using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.GUIParts;
using Yanesdk.Draw;
using Yanesdk.Input;
using Yamalib.Input;

namespace Yamalib.GUI
{
    /// <summary>
    /// tHgŕ`悵{^ƂĈNX
    /// </summary>
    public class FontButton : FocusableTextureGUI, IDisposable
    {
        #region 萔l

        #endregion

        #region otB[h

        private Font font;
        private Color4ub? activeColor;
        private Color4ub? nonActiveColor;
        private string buttonText;
        private ITexture buttonTexture;
        private int width, height;
        private IMouseInput mouse = null;
        private bool forceActive;


        #endregion

        public FontButton(FontLoader fontloader, int fontNo)
        {
            this.font = fontloader.GetFont(fontNo);
        }

        public FontButton(Font font)
        {
            this.font = font;
        }

        /// <summary>
        /// IɏɃANeBuɂ
        /// </summary>
        public bool IsForceActive
        {
            get { return forceActive; }
            set { forceActive = value; }
        }

        /// <summary>
        /// {^ƂĎgp镶ݒ肷
        /// </summary>
        /// <param name="txt"></param>
        public void SetText(string txt)
        {
            buttonText = txt;
            if (buttonTexture != null)
            {
                buttonTexture.Release();
            }
            buttonTexture = YamalibConst.CreateTexture();
            buttonTexture.SetSurface(font.DrawBlendedUnicode(txt));
        }

        /// <summary>
        /// tHgJ[ݒ肷t
        /// </summary>
        /// <param name="active"></param>
        /// <param name="nonActive"></param>
        public void SetColor(Color4ub active, Color4ub nonActive)
        {
            activeColor = active;
            nonActiveColor = nonActive;
        }


        #region ITextureGUI o

        public void OnInit(ControlContext cc)
        {
            FocusableGUIParam param = cc.Param as FocusableGUIParam;
            if (null != param)
            {
                mouse = param.Mouse;
            }
        }

        public void OnPaint(IScreen scr, ControlContext cc, int x, int y)
        {
            if (!visible || buttonTexture == null) return;

            if (width == 0 || height == 0)
            {
                ITexture t0 = buttonTexture;
                // {^TCY擾ĂA}EX̔`Ƃėp
                if (t0 != null)
                {
                    width = (int)t0.Width;
                    height = (int)t0.Height;
                }
            }

            int mx, my;
            if (mouse != null)
            {
                mouse.GetPos(out mx, out my);
            }
            else
            {
                cc.MouseInput.GetPos(out mx, out my);
            }
            bool isHover =
                (x <= mx) && (mx < x + width) &&
                (y <= my) && (my < y + height);

            bool isDown = false;
            if (mouse != null)
            {
                isDown = mouse.IsPress(MouseInput.Button.Left);
            }
            else
            {
                isDown = cc.MouseInput.IsPress(MouseInput.Button.Left);
            }

            // Ot[ŁA
            // isHoverԂłisDown
            // ̃t[
            // isHoverԂA!isDown
            // Ȃ΁A{^ꂽƂă{^CxgB

            isOnDown = false;
            if (enable)
            {
                if (lastIsHover && lastIsDown && isHover && !isDown)
                {
                    if (OnClick != null)
                    {
                        OnClick(scr, cc);
                    }
                    isOnDown = true;
                }
                if (lastIsHover && !lastIsDown && isHover && isDown)
                {
                    if (OnDown != null)
                    {
                        OnDown(scr, cc);
                    }
                }
            }
            lastIsDown = isDown;
            lastIsHover = isHover;

            Color4ub? color;
            if (forceActive)
            {
                color = activeColor;
            }
            else if (!enable)
                color = nonActiveColor;
            else if (!isHover)
                color = nonActiveColor;
            else if (isDown)
                color = activeColor;
            else
                color = activeColor;

            ITexture tex = buttonTexture;
            if (tex != null)
            {
                if (color != null)
                {
                    scr.SetColor(color.Value);
                    scr.Blt(tex, x, y);
                    scr.ResetColor();
                }
                else
                {
                    scr.Blt(tex, x, y);
                }
            }
        }

        public delegate void MouseEvent(IScreen scr, ControlContext cc);

        //@Ot[̌
        private bool lastIsDown;
        private bool lastIsHover;

        /// <summary>
        /// hoverĂ̂
        /// </summary>
        /// <remarks>
        /// Enable == falsełhover͍̔sȂ
        /// </remarks>
        public bool IsHover
        {
            get { return lastIsHover; }
        }

        /// <summary>
        /// ̃{^݃NbNꂽƂ납
        /// (OnClicknĥʓ|ȂƂɎgĂ)
        /// </summary>
        /// <remarks>
        /// Enable == falseȂΏfalseԂ
        /// </remarks>
        public bool IsDown
        {
            get { return isOnDown && enable; }
        }
        private bool isOnDown;

        /// <summary>
        /// NbNꂽƂ̃Cxg
        /// </summary>
        public MouseEvent OnClick;

        /// <summary>
        /// ꂽuԂɔCxg
        /// </summary>
        public MouseEvent OnDown;

        /// <summary>
        /// ̃{^͎gp\s\B
        /// Enable = falseɂƁA{^C[Wԍ3Ԃ
        /// gps\ȃ{^\Ȁꍇɂ́A
        /// {^̃Cxgnh͌ĂяoȂB
        /// 
        /// defaultłEnableB
        /// </summary>
        public bool Enable
        {
            get { return enable; }
            set { enable = value; }
        }
        private bool enable = true;

        /// <summary>
        /// loaderɁA\ƂoffsetwłB
        /// defaultł0BƂ΁A̐lƂ5w肷΁A
        /// Disableɕ`悳eNX`ԍ́A{3A3+5 = 8ɂȂB
        /// </summary>
        public int LoaderOffset
        {
            get { return loaderOffset; }
            set { loaderOffset = value; }
        }
        private int loaderOffset;


        /// <summary>
        /// ̃{^͕\Ă邩H
        /// Visible = falseɂƁA\ȂB
        /// 
        /// defaultł́Atrue
        /// </summary>
        public bool Visible
        {
            get { return visible; }
            set { visible = value; }
        }
        private bool visible = true;

        #endregion

        #region IDisposable o

        public void Dispose()
        {
            //	loader.Dispose();
            // cacheĂ̂łĉȂ
        }

        #endregion

        #region FocusableTextureGUI o

        public void Focus(ControlContext controlContext, int x, int y)
        {
            ITexture t0 = buttonTexture;
            // {^TCY擾ĂA}EX̔`Ƃėp
            if (t0 != null)
            {
                width = (int)t0.Width;
                height = (int)t0.Height;
            }
            if (null != mouse)
            {
                mouse.SetPos(x + width / 2, y + height / 2);
            }
            else
            {
                controlContext.MouseInput.SetPos(x + width / 2, y + height / 2);
            }
        }

        #endregion
    }
}
