using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.GUIParts;
using Yamalib.Input;

namespace Yamalib.GUI
{
    /// <summary>
    /// Ȃ{^
    /// </summary>
    public class NullButton : FocusableTextureGUI, IDisposable
    {
        private bool visible = true;
        private IMouseInput mouse;

        #region ITextureGUI o

        public void OnInit(ControlContext cc)
        {
            FocusableGUIParam param = cc.Param as FocusableGUIParam;
            if (null != param)
            {
                mouse = param.Mouse;
            }
        }

        public void OnPaint(Yanesdk.Draw.IScreen scr, ControlContext cc, int x, int y)
        {
        }

        public bool Visible
        {
            get
            {
                return visible;
            }
            set
            {
                visible = value;
            }
        }

        #endregion

        #region FocusableTextureGUI o

        public void Focus(ControlContext controlContext, int x, int y)
        {
            if (mouse != null)
            {
                mouse.SetPos(x, y);
            }
            if (controlContext.MouseInput != null)
            {
                controlContext.MouseInput.SetPos(x, y);
            }
        }

        #endregion

        #region IDisposable o

        public void Dispose()
        {
        }

        #endregion
    }
}
