using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Timer;
using Yanesdk.Ytl;
using Yamalib.Yanesdkext.Draw;
using Yamalib.Model;
using Yamalib.Util;
using Yanesdk.System;

namespace Yamalib.Scenario.YaneScript
{
    #region R}hnhNX

    /// <summary>
    /// YaneScrpt`̃^O`
    /// </summary>
    public static class TagDefinition
    {
        public static readonly String TAG_JUMP_SCENE = "jump_scene";
        public static readonly String TAG_READ_STOP = "readstop";
        public static readonly String TAG_BGM_PLAY = "bgm_play";
        public static readonly String TAG_BGM_STOP = "bgm_stop";
        public static readonly String TAG_BG = "bg";
        public static readonly String TAG_CHARA_IN = "charain";
        public static readonly String TAG_CHARA_OUT = "charaout";
        public static readonly String TAG_SE_PLAY = "se";
        public static readonly String TAG_SE_STOP = "se_stop";
        public static readonly String TAG_VOICE = "voice";
        public static readonly String TAG_VOICE_WAIT = "voicewait";

        /// <summary>
        /// Yane`̃XNvgŎgftHg̃R}hnh
        /// </summary>
        /// <returns></returns>
        public static Dictionary<string, CommandHandlerCreator> GetFactories()
        {
            Dictionary<string, CommandHandlerCreator> factories = new Dictionary<string, CommandHandlerCreator>();

            // ǂݎ~܂̃R}h
            factories[TAG_READ_STOP] = delegate()
            {
                return new ReadStopCommandHandler();
            };

            //BGM_PlaỹR}h
            factories[TAG_BGM_PLAY] = delegate()
            {
                return new BgmPlayCommandHandler();
            };

            //BGM_SOP̃R}h
            factories[TAG_BGM_STOP] = delegate()
            {
                return new BgmStopCommandHandler();
            };

            // wiR}h
            factories[TAG_BG] = delegate()
            {
                return new BgCommandHandler();
            };

            //TAG_CHARA_IÑR}h
            factories[TAG_CHARA_IN] = delegate()
            {
                return new CharaInCommandHandler();
            };

            //TAG_CHARA_OUT̃R}h
            factories[TAG_CHARA_OUT] = delegate()
            {
                return new CharaOutCommandHandler();
            };

            // SE ĐR}h
            factories[TAG_SE_PLAY] = delegate()
            {
                return new SePlayCommandHandler();
            };

            // SE ~R}h
            factories[TAG_SE_STOP] = delegate()
            {
                return new SeStopCommandHandler();
            };

            // {CXEFCgR}h
            factories[TAG_VOICE_WAIT] = delegate()
            {
                return new VoiceWaitCommandHandler();
            };

            //TODO: KvȂ̂ǉĂ

            return factories;
        }
    }

    /// <summary>
    /// ^OɎgƕ֗ȃ[eBeBNX
    /// </summary>
    public static class TagUtil
    {
        /// <summary>
        /// ^Õp[^𕪊镶
        /// </summary>
        public static readonly char TAG_SEPARATER = ',';

        /// <summary>
        /// ^Ow肳ꂽZp[^ŕ
        /// </summary>
        /// <param name="commandStr"></param>
        /// <returns></returns>
        public static String[] TagSplit(String commandStr)
        {
            //Console.WriteLine("split command : {0}", commandStr );
            if (null == commandStr)
            {
                return new String[0];
            }
            String[] resultStr = commandStr.Split(TAG_SEPARATER);
            for (int i = 0; i < resultStr.Length; i++)
            {
                resultStr[i] = resultStr[i].ToLower().Trim('"', ' ');
            }
            return resultStr;
        }

        /// <summary>
        /// Ώۂ̕z̑z肷 arrayIndexNo loB
        /// Az񂪂Z΁Aiferr Ŏw肵lԋp
        /// </summary>
        /// <param name="splitCommand"></param>
        /// <param name="arrayIndexNo"></param>
        /// <param name="iferr"></param>
        /// <returns></returns>
        public static String GetPram(String[] splitCommand, int arrayIndexNo, String iferr)
        {

            if (null == splitCommand || arrayIndexNo >= splitCommand.Length)
            {
                return iferr;
            }
            try
            {
                return splitCommand[arrayIndexNo];
            }
            catch (FormatException e)
            {
                Console.WriteLine("TAG PRAM:{0}", e);
                Console.WriteLine("TAG PRAM:{0}", e.StackTrace);
                return iferr;
            }
        }

        /// <summary>
        /// Ώۂ̕z̑z肷 arrayIndexNo loB
        /// Az񂪂Z΁Aiferr Ŏw肵lԋp
        /// </summary>
        /// <param name="splitCommand"></param>
        /// <param name="arrayIndexNo"></param>
        /// <param name="iferr"></param>
        /// <returns></returns>
        public static int GetPramInt(String[] splitCommand, int arrayIndexNo, int iferr)
        {
            if (null == splitCommand || arrayIndexNo >= splitCommand.Length)
            {
                return iferr;
            }
            try
            {
                return Convert.ToInt32(splitCommand[arrayIndexNo]);
            }
            catch (FormatException e)
            {
                Console.WriteLine("TAG PRAM:{0}", e);
                Console.WriteLine("TAG PRAM:{0}", e.StackTrace);
                return iferr;
            }
        }

        public static bool GetPramBool(String[] splitCommand, int arrayIndexNo, bool iferr)
        {
            if (null == splitCommand || arrayIndexNo >= splitCommand.Length)
            {
                return iferr;
            }
            try
            {
                return Convert.ToBoolean(splitCommand[arrayIndexNo]);
            }
            catch (FormatException e)
            {
                // ֋XI0,1
                Console.WriteLine("TAG PRAM:{0}", e);
                Console.WriteLine("TAG PRAM:{0}", e.StackTrace);
                int value = GetPramInt(splitCommand, arrayIndexNo, iferr ? 1 : 0);
                return 1 == value;
            }
        }
    }

    /// <summary>
    /// ^Onht@Ng
    /// </summary>
    public class YaneCommandHandlerFactory : ICommandHandlerFactory
    {

        #region otB[h
        private Dictionary<String, CommandHandlerCreator> factories;
        #endregion
        public void SetFactories(Dictionary<String, CommandHandlerCreator> factories)
        {
            this.factories = factories;
        }
        public Dictionary<String, CommandHandlerCreator> GetFactories()
        {
            return factories;
        }

        public ICommandHandler Create(String commandId)
        {
            if (factories == null)
            {
                return NullCommandHandler.Instance;
            }
            String tagId = GetTagId(commandId);
            if (factories.ContainsKey(tagId))
            {
                return factories[tagId]();
            }
            return NullCommandHandler.Instance;
        }

        /// <summary>
        /// R}h񂩂A擪̃^OIDƂȂ郂mo
        /// </summary>
        /// <param name="commadStr"></param>
        /// <returns></returns>
        private String GetTagId(String commadStr)
        {
            String[] tagParam = TagUtil.TagSplit(commadStr);
            if (null == tagParam || 0 == tagParam.Length)
            {
                return null;
            }
            return tagParam[0].ToLower();
        }

    }

    /// <summary>
    /// ǂݎ~܂R}h
    /// </summary>
    public class ReadStopCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_WAIT_TIME = -1;

        #endregion


        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private readonly FixTimer timer = new FixTimer();
        private int readWaitTime = INVALID_WAIT_TIME;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public ReadStopCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);

            if (1 < tagParam.Length)
            {
                //  <readstop,millsec> w莞Ԓ~
                readWaitTime = Convert.ToInt32(tagParam[1]);
            }

            return YanesdkResult.NoError;
        }

        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return ExcecutingTag(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            // s
            if (model.ShowTextCount >= ExecPosition)
            {
                //XLbvȂ牽Ȃ
                if (model.ScenarioState.ReadSkipFlg)
                {
                    execState = CommandState.DONE;
                    return YanesdkResult.NoError;
                }

                // eLXg~
                model.ScenarioState.ReadStopFlg = true;
                if (INVALID_WAIT_TIME != readWaitTime)
                {
                    timer.Reset();
                    execState = CommandState.EXECUTING;
                }
                else
                {
                    execState = CommandState.DONE;
                }

                if (null != processor)
                {
                    processor(this, model);
                }
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// readstop,waittime ̃`FbN
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutingTag(IScenarioModel model)
        {
            timer.Update();
            if (readWaitTime <= timer.Time)
            {
                model.ScenarioState.ReadStopFlg = false;
                execState = CommandState.DONE;
            }
            return YanesdkResult.NoError;
        }

        #endregion

    }


    /// <summary>
    /// BGMĐR}h
    /// </summary>
    public class BgmPlayCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_BGM_VALUE = -1;
        private static readonly float INVALID_VOLUME_VALUE = float.NaN;
        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int BGM_NO_INDEX = 1;
        private static readonly int BGM_VOLUME = 2;
        private static readonly int BGM_FADE_TIME = 3;

        #endregion


        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private int bgmNo = INVALID_BGM_VALUE;
        private float bgmVolume = INVALID_VOLUME_VALUE;
        private int fadeTime = INVALID_BGM_VALUE;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public BgmPlayCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            bgmNo = TagUtil.GetPramInt(tagParam, BGM_NO_INDEX, INVALID_BGM_VALUE);
            bgmVolume = TagUtil.GetPramInt(tagParam, BGM_VOLUME, Sdl.SDL.MIX_MAX_VOLUME) / (float)Sdl.SDL.MIX_MAX_VOLUME;
            fadeTime = TagUtil.GetPramInt(tagParam, BGM_FADE_TIME, INVALID_BGM_VALUE);

            return CheckPramValue();
        }

        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (bgmNo == INVALID_BGM_VALUE)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// BGMĐ
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            // s
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result;
            if (INVALID_BGM_VALUE == fadeTime)
            {
                result = model.BgmMgr.PlayBgm(bgmNo, bgmVolume);
            }
            else
            {
                result = model.BgmMgr.PlayBgmFade(bgmNo, bgmVolume, fadeTime);
            }

            execState = CommandState.DONE;

            return result;
        }

        #endregion
    }

    /// <summary>
    /// BGMĐR}h
    /// </summary>
    public class BgmStopCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_BGM_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 1;
        private static readonly int BGM_FADE_TIME = 1;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private int fadeTime = INVALID_BGM_VALUE;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public BgmStopCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            fadeTime = TagUtil.GetPramInt(tagParam, BGM_FADE_TIME, INVALID_BGM_VALUE);

            return CheckPramValue();
        }

        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// BGM~
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result;
            if (INVALID_BGM_VALUE == fadeTime)
            {
                result = model.BgmMgr.StopBgm();
            }
            else
            {
                result = model.BgmMgr.StopBgmFade(fadeTime);
            }

            execState = CommandState.DONE;

            return result;
        }

        #endregion
    }

    /// <summary>
    /// wi\R}h
    /// </summary>
    public class BgCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_BG_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 2;

        private static readonly int BG_NO = 1;
        private static readonly int EFFECT_NO = 2;
        private static readonly int EFFECT_SPEED = 3;
        private static readonly int WAIT_FLG = 4;

        private static readonly int INVALID_EFFECT_NO = -1;
        private static readonly int DEFAULT_EFFECT_SPEED = 1;
        private static readonly bool DEFAULT_WAIT_FLG = false;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private int oldImgNo = INVALID_BG_VALUE;
        private int imgNo = INVALID_BG_VALUE;
        private int effectNo = INVALID_EFFECT_NO;
        private int effectSpeed;
        private bool waitFlg;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public BgCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            oldImgNo = imgNo;
            imgNo = TagUtil.GetPramInt(tagParam, BG_NO, INVALID_BG_VALUE);
            effectNo = TagUtil.GetPramInt(tagParam, EFFECT_NO, INVALID_EFFECT_NO);
            effectSpeed = TagUtil.GetPramInt(tagParam, EFFECT_SPEED, DEFAULT_EFFECT_SPEED);
            waitFlg = TagUtil.GetPramBool(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Excecuting(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (INVALID_BG_VALUE == imgNo)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// wi\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;

            model.BgImgMgr.BgImgNo = imgNo;
            model.BgImgMgr.SetEffect(effectNo, 0, TransBltter.PAHSE_MAX, effectSpeed);

            if (waitFlg)
            {
                model.ScenarioState.BgEffectWaitFlg = true;
                execState = CommandState.EXECUTING;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return result;
        }

        /// <summary>
        /// s
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Excecuting(IScenarioModel model)
        {
            if (model.BgImgMgr.IsEffecting)
            {
                return YanesdkResult.NoError;
            }

            model.ScenarioState.BgEffectWaitFlg = false;

            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        #endregion
    }

    /// <summary>
    /// LN^[\R}h
    /// </summary>
    public class CharaInCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 3;

        private static readonly int CHARACTER_ID = 1;
        private static readonly int PRESET_POS = 2;
        private static readonly int SLIDE_VALUE = 3;
        private static readonly int EFFECT_NO = 4;
        private static readonly int EFFECT_SPEED = 5;
        private static readonly int COLOR = 6;
        private static readonly int WAIT_FLG = 7;
        private static readonly int REPLACE_CHARACTER_ID = 8;

        private static readonly int INVALID_SLIDE_VALUE = 0;
        private static readonly int INVALID_EFFECT_NO = -1;
        private static readonly int DEFAULT_EFFECT_SPEED = 1;
        private static readonly String DEFAULT_COLOR = "FFFFFFFF";
        private static readonly bool DEFAULT_WAIT_FLG = false;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private String characterId;
        private String presetPosition;
        private int slideOffsetValue;
        private int effectNo;
        private int effectSpeed;
        private String color;
        private bool waitFlg;
        private String replaceCharacterId;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public CharaInCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            characterId = TagUtil.GetPram(tagParam, CHARACTER_ID, null);
            presetPosition = TagUtil.GetPram(tagParam, PRESET_POS, null);
            slideOffsetValue = TagUtil.GetPramInt(tagParam, SLIDE_VALUE, INVALID_SLIDE_VALUE);
            effectNo = TagUtil.GetPramInt(tagParam, EFFECT_NO, INVALID_EFFECT_NO);
            effectSpeed = TagUtil.GetPramInt(tagParam, EFFECT_SPEED, DEFAULT_EFFECT_SPEED);
            color = TagUtil.GetPram(tagParam, COLOR, DEFAULT_COLOR);
            waitFlg = TagUtil.GetPramBool(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG);
            replaceCharacterId = TagUtil.GetPram(tagParam, REPLACE_CHARACTER_ID, null);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Executing(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }


        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (null == characterId || null == presetPosition)
            {
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// LN^[\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;

            Character character = model.CharacterImgMgr.GetCharacterImage(characterId) as Character;

            // ʒu
            character.PresetPos = Character.ToPresetPos(this.presetPosition);

            // GtFNg
            if (INVALID_EFFECT_NO != effectNo)
            {
                if (null != replaceCharacterId)
                {
                    character.SetEffectReplace(characterId, effectNo, 0, TransBltter.PAHSE_MAX, effectSpeed);
                }
                else
                {
                    character.SetEffect(effectNo, 0, TransBltter.PAHSE_MAX, effectSpeed);
                }
            }
            // LN^[J[
            character.Color = YanesdkUtil.ToColor4ub(color);
            // XCh
            if (INVALID_SLIDE_VALUE != slideOffsetValue)
            {
                character.SetSlide(slideOffsetValue, 1);
            }

            if (waitFlg)
            {
                model.ScenarioState.CharacterEffectWaitFlg = true;
                execState = CommandState.EXECUTING;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return result;
        }

        /// <summary>
        /// LN^\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Executing(IScenarioModel model)
        {
            Character[] characters = ((YaneCharacterManager)model.CharacterImgMgr).CharacterContainer;
            foreach (Character chara in characters)
            {
                if (chara.IsEffecting)
                {
                    return YanesdkResult.NoError;
                }
            }
            model.ScenarioState.CharacterEffectWaitFlg = false;
            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        #endregion
    }


    /// <summary>
    /// LN^[\R}h
    /// </summary>
    public class CharaOutCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 3;

        private static readonly int CHARACTER_ID = 1;
        private static readonly int SLIDE_VALUE = 2;
        private static readonly int EFFECT_NO = 3;
        private static readonly int EFFECT_SPEED = 4;
        private static readonly int COLOR = 5;
        private static readonly int WAIT_FLG = 6;

        private static readonly int INVALID_SLIDE_VALUE = 0;
        private static readonly int INVALID_EFFECT_NO = -1;
        private static readonly int DEFAULT_EFFECT_SPEED = 1;
        private static readonly String DEFAULT_COLOR = "FFFFFFFF";
        private static readonly bool DEFAULT_WAIT_FLG = false;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        private String characterId;
        private int slideOffsetValue;
        private int effectNo;
        private int effectSpeed;
        private String color;
        private bool waitFlg;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public CharaOutCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            characterId = TagUtil.GetPram(tagParam, CHARACTER_ID, null);
            slideOffsetValue = TagUtil.GetPramInt(tagParam, SLIDE_VALUE, INVALID_SLIDE_VALUE);
            effectNo = TagUtil.GetPramInt(tagParam, EFFECT_NO, INVALID_EFFECT_NO);
            effectSpeed = TagUtil.GetPramInt(tagParam, EFFECT_SPEED, DEFAULT_EFFECT_SPEED);
            color = TagUtil.GetPram(tagParam, COLOR, DEFAULT_COLOR);
            waitFlg = TagUtil.GetPramBool(tagParam, WAIT_FLG, DEFAULT_WAIT_FLG);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h̏
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return Executing(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }


        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (null == characterId)
            {
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// LN^[\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result = YanesdkResult.NoError;

            Character character = model.CharacterImgMgr.GetCharacterImage(characterId) as Character;
            // GtFNg
            if (INVALID_EFFECT_NO != effectNo)
            {
                character.SetEffect(effectNo, TransBltter.PAHSE_MAX, 0, effectSpeed);
            }
            else
            {
                // 
                character.Reset();
            }
            // LN^[J[
            character.Color = YanesdkUtil.ToColor4ub(color);
            // XCh
            if (INVALID_SLIDE_VALUE != slideOffsetValue)
            {
                character.SetSlide(slideOffsetValue, 1);
            }

            if (waitFlg)
            {
                model.ScenarioState.CharacterEffectWaitFlg = true;
                execState = CommandState.EXECUTING;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return result;
        }

        /// <summary>
        /// LN^\
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult Executing(IScenarioModel model)
        {
            Character[] characters = ((YaneCharacterManager)model.CharacterImgMgr).CharacterContainer;
            foreach (Character chara in characters)
            {
                if (chara.IsEffecting)
                {
                    return YanesdkResult.NoError;
                }
            }
            model.ScenarioState.CharacterEffectWaitFlg = false;
            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        #endregion
    }

    /// <summary>
    /// SEĐR}h
    /// </summary>
    public class SePlayCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_SE_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int SE_NO_INDEX = 1;
        private static readonly int SE_VOLUME = 2;
        private static readonly int SE_LOOP_TIME = 3;
        private static readonly int SE_FADE_TIME = 4;

        #endregion


        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private int seNo = INVALID_SE_VALUE;
        private float seVolume = 1.0f;
        private int fadeTime = INVALID_SE_VALUE;
        private int loopTime = YanesdkUtil.SOUND_INFINITY_LOOP;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public SePlayCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            seNo = TagUtil.GetPramInt(tagParam, SE_NO_INDEX, INVALID_SE_VALUE);
            seVolume = TagUtil.GetPramInt(tagParam, SE_VOLUME, Sdl.SDL.MIX_MAX_VOLUME) / (float)Sdl.SDL.MIX_MAX_VOLUME; ;
            loopTime = TagUtil.GetPramInt(tagParam, SE_LOOP_TIME, YanesdkUtil.SOUND_INFINITY_LOOP);
            if (YanesdkUtil.SOUND_INFINITY_LOOP != loopTime)
            {
                // [v񐔂 0PA1Q
                loopTime -= 1;
            }
            fadeTime = TagUtil.GetPramInt(tagParam, SE_FADE_TIME, INVALID_SE_VALUE);
            if (INVALID_SE_VALUE != fadeTime && fadeTime == 0)
            {
                // tF[h͎gȂ
                fadeTime = INVALID_SE_VALUE;
            }

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu̐ݒ擾
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}hǉ
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (seNo == INVALID_SE_VALUE)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// SEĐ
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            // s
            // s̐擪SEݒ肳Ăꍇl+1
            if (model.ShowTextCount < ExecPosition + 1)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result;
            if (INVALID_SE_VALUE == fadeTime)
            {
                result = model.SeMgr.PlaySe(seNo, seVolume, loopTime);
            }
            else
            {
                result = model.SeMgr.PlaySeFade(seNo, seVolume, fadeTime, loopTime);
            }

            execState = CommandState.DONE;

            return result;
        }

        #endregion
    }

    /// <summary>
    /// BGM~R}h
    /// </summary>
    public class SeStopCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_SE_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int SE_NO_INDEX = 1;
        private static readonly int SE_FADE_TIME = 2;

        #endregion

        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private int seNo = INVALID_SE_VALUE;
        private int fadeTime = INVALID_SE_VALUE;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public SeStopCommandHandler()
        {

        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            seNo = TagUtil.GetPramInt(tagParam, SE_NO_INDEX, INVALID_SE_VALUE);
            fadeTime = TagUtil.GetPramInt(tagParam, SE_FADE_TIME, INVALID_SE_VALUE);

            return CheckPramValue();
        }

        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (seNo == INVALID_SE_VALUE)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// SE~
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result;
            if (INVALID_SE_VALUE == fadeTime)
            {
                result = model.SeMgr.StopSe(seNo);
            }
            else
            {
                result = model.SeMgr.StopSeFade(seNo, fadeTime);
            }

            execState = CommandState.DONE;

            return result;
        }

        #endregion
    }

    /// <summary>
    /// {CXĐR}h
    /// </summary>
    public class VoicePlayCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int INVALID_VOICE_VALUE = -1;
        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int VOICE_NO_INDEX = 1;
        private static readonly int VOICE_VOLUME = 2;
        private static readonly int VOICE_FADE_TIME = 3;

        #endregion


        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private int voiceNo = INVALID_VOICE_VALUE;
        private float voiceVolume = INVALID_VOICE_VALUE;
        private int fadeTime = INVALID_VOICE_VALUE;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public VoicePlayCommandHandler()
        {
        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            voiceNo = TagUtil.GetPramInt(tagParam, VOICE_NO_INDEX, INVALID_VOICE_VALUE);
            voiceVolume = TagUtil.GetPramInt(tagParam, VOICE_VOLUME, Sdl.SDL.MIX_MAX_VOLUME) / (float)Sdl.SDL.MIX_MAX_VOLUME;
            fadeTime = TagUtil.GetPramInt(tagParam, VOICE_FADE_TIME, 0);

            return CheckPramValue();
        }

        /// <summary>
        /// sʒu̐ݒ擾
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}hǉ
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (voiceNo == INVALID_VOICE_VALUE)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// SEĐ
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            // s
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            YanesdkResult result;
            if (INVALID_VOICE_VALUE == fadeTime)
            {
                result = model.VoiceMgr.PlayVoice(voiceNo, voiceVolume);
            }
            else
            {
                result = model.VoiceMgr.PlayVoiceFade(voiceNo, voiceVolume, fadeTime);
            }

            execState = CommandState.DONE;

            return result;
        }

        #endregion
    }



    /// <summary>
    /// {CXҋ@R}h
    /// ̃R}h̓{CXĐł΁Aœǂݎ~܂肷閽߂ł
    /// </summary>
    public class VoiceWaitCommandHandler : ICommandHandler
    {
        #region otB[h

        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public VoiceWaitCommandHandler()
        {
        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            return CheckPramValue();
        }

        /// <summary>
        /// sʒu̐ݒ擾
        /// </summary>
        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}hǉ
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    return ExcecutingTag(model);

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// VoiceWaitJn
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            // s
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }
            if (model.VoiceMgr.IsPalying)
            {
                execState = CommandState.EXECUTING;
                model.ScenarioState.ReadStopFlg = true;
            }
            else
            {
                execState = CommandState.DONE;
            }

            return YanesdkResult.NoError;
        }

        /// <summary>
        /// VoiceWait ̃`FbN
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        private YanesdkResult ExcecutingTag(IScenarioModel model)
        {
            if (!model.VoiceMgr.IsPalying)
            {
                execState = CommandState.DONE;
                model.ScenarioState.ReadStopFlg = false;
            }
            return YanesdkResult.NoError;
        }



        #endregion
    }

    
    /// <summary>
    /// V[JڃR}h
    /// </summary>
    public class JumpSceneCommandHandler : ICommandHandler
    {
        #region 萔l

        private static readonly int MIN_PARAM_NUM = 2;
        private static readonly int SCENE_ID_INDEX = 1;
        private static readonly int ADDITION_PARAM_INDEX = 2;

        #endregion

        #region otB[h

        protected readonly SceneController<String> sceneController;
        private int execPosition;
        private CommandProcessor processor;
        private CommandState execState = CommandState.UN_EXECUTION;
        private String sceneId;
        private readonly List<String> paramList = new List<string>();

        #endregion

        /// <summary>
        /// RXgN^
        /// </summary>
        public JumpSceneCommandHandler(SceneController<String> scneController)
        {
            this.sceneController = scneController;
        }

        /// <summary>
        /// JڐV[ID
        /// </summary>
        public String SceneId
        {
            get { return sceneId; }
        }

        /// <summary>
        /// XNvgɎw肳ꂽp[^̃Xg
        /// </summary>
        public List<String> ParamList
        {
            get { return paramList; }
        }

        /// <summary>
        /// ̃R}h̏
        /// </summary>
        public CommandState State
        {
            get { return execState; }
        }

        /// <summary>
        /// R}hl̐ݒ擾
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        public YanesdkResult SetCommand(String command)
        {
            String[] tagParam = TagUtil.TagSplit(command);
            if (tagParam.Length < MIN_PARAM_NUM)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }

            sceneId = TagUtil.GetPram(tagParam, SCENE_ID_INDEX, null);
            for (int i = ADDITION_PARAM_INDEX; i < tagParam.Length; i++)
            {
                paramList.Add(tagParam[i]);
            }

            return CheckPramValue();
        }

        public int ExecPosition
        {
            set { execPosition = value; }
            get { return execPosition; }
        }

        /// <summary>
        /// R}h
        /// </summary>
        public CommandProcessor CommandProsser
        {
            get { return processor; }
            set { processor = value; }
        }

        /// <summary>
        /// R}hs
        /// </summary>
        /// <param name="model">f</param>
        /// <returns>sʂԋp</returns>
        public virtual YanesdkResult DoCommand(IScenarioModel model)
        {
            switch (execState)
            {
                case CommandState.UN_EXECUTION:
                    return ExcecutionTag(model);
                case CommandState.EXECUTING:
                    break;

                case CommandState.DONE:
                    break;
            }

            return YanesdkResult.NoError;
        }

        #region J\bh

        private YanesdkResult CheckPramValue()
        {
            if (sceneId == null)
            {
                execState = CommandState.DONE;
                return YanesdkResult.InvalidParameter;
            }
            return YanesdkResult.NoError;
        }

        /// <summary>
        /// SE~
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        protected virtual YanesdkResult ExcecutionTag(IScenarioModel model)
        {
            if (model.ShowTextCount < ExecPosition)
            {
                return YanesdkResult.NoError;
            }


            this.sceneController.JumpScene(sceneId);

            //fQ[gݒ肵Ă΂NďI
            if (null != processor)
            {
                processor(this, model);
            }

            execState = CommandState.DONE;
            return YanesdkResult.NoError;
        }

        #endregion
    }

    #endregion
}
