using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Math;
using Yanesdk.Timer;
using Yamalib.Math;

namespace Yamalib.Util
{
    abstract public class ICounter
    {
        /// <summary>
        /// JE^[l̐ݒ
        /// </summary>
        /// <param name="start_">Jnl</param>
        /// <param name="end_">Il</param>
        /// <param name="step_">Zl</param>
        public virtual void Set(int start_, int end_, int step_)
        {
            step = step_;
            start = start_;
            end = end_;
            Reset();
        }

        /// <summary>
        /// Ԃ̏
        /// </summary>
        abstract public void Reset();

        public virtual int Value() { return rootCount; }

        abstract public bool IsEnd
        {
            get;
        }

        /// <summary>
        /// ݂̒lsinZl̎擾
        /// </summary>
        /// <returns></returns>
        public virtual int ValueSined()
        {
            int w = end - start;
            int offset = rootCount - w;
            return start + sin.Sin((int)(((float)w) / offset * 128.0f), offset);
        }

        /// <summary>
        /// Zs
        /// </summary>
        abstract public void Inc();

        #region vpeB
        /// <summary>
        ///@Zl̐ݒ擾
        /// </summary>
        virtual public int StepValue
        {
            get { return step; }
            set { step = value; }
        }

        /// <summary>
        /// Jnl̐ݒ擾
        /// </summary>
        virtual public int StartValue
        {
            get { return start; }
            set { start = value; }
        }

        /// <summary>
        /// Il̐ݒ擾
        /// </summary>
        virtual public int EndValue
        {
            get { return end; }
            set { end = value; }
        }
        #endregion

        protected static SinTable sin = SinTable.Instance;

        protected int rootCount;
        protected int start;
        protected int end;
        protected int step;
    }

    /// Q[ŎgJE^
    public class RootCounter : ICounter
    {

        public static RootCounter operator ++(RootCounter counter) { counter.Inc(); return counter; }
        //	intƂ̑ݕϊ
        public static explicit operator int(RootCounter counter) { return counter.Value(); }

        #region vpeB
        /// <summary>
        /// o[X邩
        /// </summary>
        public bool ReverseFlg
        {
            set { reverse = value; }
            get { return reverse; }
        }

        /// <summary>
        /// IncʁA񂵂H^IncSʁAIlɂȂH
        /// </summary>
        public bool IsLapAround
        {
            get { return lapAround; }
        }

        /// <summary>
        /// IncʁAlɖ߂H
        /// </summary>
        public bool IsLapAroundI
        {
            get { return lapAroundI; }
        }

        #endregion


        #region public\bh

        /// <summary>
        /// RXgN^
        /// </summary>
        public RootCounter()
        {
            Set(0, int.MaxValue, 1);
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="end_">Il</param>
        public RootCounter(int end_)
        {
            Set(0, end_, 1);
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="start_">Jnl</param>
        /// <param name="end_">Il</param>
        /// <param name="step_">Zn</param>
        public RootCounter(int start_, int end_, int step_)
        {
            Set(start_, end_, step_);
            Reset();
        }

        ////	l
        public void SetInit(int n) { init = true; initNum = n; }

        //	JE^̃Zbg
        public override void Reset()
        {
            rate = 0;
            lapAround = false;
            lapAroundI = false;
            reversing = false;
            if (!init)
            {
                rootCount = start;
            }
            else
            {
                rootCount = initNum;
            }
        }

        //	JE^̃CNg(I[܂ŒBƁAēxAlɖ߂)
        public override void Inc()
        {
            if (reverse)
            {
                if (!reversing)
                {
                    if (step > 0)
                    {
                        rootCount += step;
                        if (rootCount >= end)
                        {
                            rootCount = end;
                            lapAround = true;
                            lapAroundI = false;
                            reversing = true;	//	_EJEg̊Jn
                        }
                        else
                        {
                            lapAround = false;
                            lapAroundI = false;
                        }
                    }
                    else
                    {
                        rate++;
                        if (rate == -step)
                        {
                            rate = 0;
                            rootCount++;
                            if (rootCount >= end)
                            {
                                rootCount = start;
                                lapAround = true;
                                lapAroundI = false;
                                reversing = true;	//	_EJEg̊Jn
                            }
                            else
                            {
                                lapAround = false;
                                lapAroundI = false;
                            }
                        }
                    }
                }
                else
                {
                    if (step > 0)
                    {
                        rootCount -= step;
                        if (rootCount <= start)
                        {
                            rootCount = start;
                            lapAround = true;
                            lapAroundI = true;
                            reversing = false;	//	AbvJEg̊Jn
                        }
                        else
                        {
                            lapAround = false;
                            lapAroundI = false;
                        }
                    }
                    else
                    {
                        rate++;
                        if (rate == -step)
                        {
                            rate = 0;
                            rootCount--;	//	_EJEg
                            if (rootCount <= start)
                            {
                                rootCount = start;
                                lapAround = true;
                                lapAroundI = true;	//	̎Ɍtrue
                                reversing = false;	//	AbvJEg̊Jn
                            }
                            else
                            {
                                lapAround = false;
                                lapAround = false;
                            }
                        }
                    }
                }
            }
            else
            {
                //	o[XJE^łȂȂ΁Ao[XԂł邩Ɋւ炸OZ
                if (step > 0)
                {
                    rootCount += step;
                    if (rootCount >= end)
                    {
                        rootCount = start;
                        lapAround = true;
                    }
                    else
                    {
                        lapAround = false;
                    }
                }
                else
                {
                    rate++;
                    if (rate == -step)
                    {
                        rate = 0;
                        rootCount++;
                        if (rootCount >= end)
                        {
                            rootCount = start;
                            lapAround = true;
                        }
                        else
                        {
                            lapAround = false;
                        }
                    }
                }
            }
        }//	Z


        //	JE^̃T`[VCNgiI[܂ŒBƁAŒ~j
        public void incS()
        {
            //	if (m_bReverse){
            //	o[XJE^ǂɂ炸A
            //	@@@Ĕfׂ
            if (!reversing)
            {
                if (step > 0)
                {
                    rootCount += step;
                    if (rootCount >= end)
                    {
                        rootCount = end;
                        lapAround = true;
                        //	m_bReversing = true;	//	_EJEg̊Jn
                    }
                    else
                    {
                        lapAround = false;
                    }
                }
                else
                {
                    rate++;
                    if (rate == -step)
                    {
                        rate = 0;
                        rootCount++;
                        if (rootCount >= end)
                        {
                            rootCount = end;
                            lapAround = true;
                            //	m_bReversing = true;	//	_EJEg̊Jn
                        }
                        else
                        {
                            lapAround = false;
                        }
                    }
                }
            }
            else
            {
                if (step > 0)
                {
                    rootCount -= step;
                    if (rootCount <= start)
                    {
                        rootCount = start;
                        lapAround = true;
                        //	m_bReversing = false;	//	AbvJEg̊Jn
                    }
                    else
                    {
                        lapAround = false;
                    }
                }
                else
                {
                    rate++;
                    if (rate == -step)
                    {
                        rate = 0;
                        rootCount--;	//	_EJEg
                        if (rootCount <= start)
                        {
                            rootCount = start;
                            lapAround = true;
                            //		m_bReversing = false;	//	AbvJEg̊Jn
                        }
                        else
                        {
                            lapAround = false;
                        }
                    }
                }
            }
            //	}
        }

        public int opAssign(int n) { rootCount = n; return n; }

        /// <summary>
        /// ݂̒l̎擾
        /// </summary>
        /// <returns></returns>
        # endregion

        #region  otB[h
        protected int rate;	    //	nStep<0̂Ƃ́AInc()+1
        protected bool lapAround;
        protected bool lapAroundI;

        protected bool reverse;		//	o[XJE^
        protected bool reversing;		//	o[XH
        protected bool init;			//	lݒ肳Ă邩H
        protected int initNum;		//	ݒ肳Ă鏉l
        #endregion

        public override bool IsEnd
        {
            get { return IsLapAround; }
        }
    }



    //	́AnStartnEndłȂėǂ
    public class RootCounterS : ICounter
    {

        public static RootCounterS operator ++(RootCounterS counter) { counter.Inc(); return counter; }
        //	intƂ̑ݕϊ
        public static explicit operator int(RootCounterS counter) { return counter.Value(); }

        //	JE^̃Zbg
        public override void Reset() { rootCount = start; rate = 0; }

        //	property..
        public override bool IsEnd
        {
            get
            {
                return (rootCount == end);
            }
        }

        public RootCounterS()
        {
            Set(0, int.MaxValue, 1);
            Reset();
        }

        public RootCounterS(int end_)
        {
            Set(0, end_, 1);
            Reset();
        }

        public RootCounterS(int start_, int end_, int step_)
        {
            Set(start_, end_, step_);
            Reset();
        }

        public int opAssign(int n) { rootCount = n; return n; }

        public override int ValueSined()
        {
            int w = end - start;
            int offset = rootCount - start;
            float f = (float)offset / (float)w;
            offset = sin.Sin((int)(f * 128.0f), offset);
            return start + sin.Sin((int)(f * 128.0f), offset);
        }

        //	JE^̃CNg(I[܂ŒBƁAŒ~)
        //	ZiEndփCNgj^ZiStartւ̃CNgj
        public void Inc(bool add)
        {
            bool bInc = (bool)((start > end) ^ add); // tJE^H
            if (bInc)
            {
                //	CNg
                if (step > 0)
                {
                    //	CNg
                    rootCount += step;
                }
                else
                {
                    //	CNg
                    rate++; if (rate >= (-step)) { rate = 0; rootCount++; }
                }
                //	T`[ĝH
                int max = start < end ? end : start;
                if (rootCount > max) rootCount = max;
            }
            else
            {
                //	fNg
                if (step > 0)
                {
                    //	fNg
                    rootCount -= step;
                }
                else
                {
                    //	fNg
                    rate--; if (rate <= (step)) { rate = 0; rootCount--; }
                    //	ˁ@Rate++łȂƂɒӁB
                    //	++̂--āA̐ƂȂĂ͂ȂȂ
                    //	AnStep<0̂Ƃŏ̂Pڂ--RootCounter
                    //	1Ă͂ȂBĂɂȂ
                }
                //	T`[ĝH
                int min = start < end ? start : end;
                if (rootCount < min) rootCount = min;
            }
        }

        // intarface ݊
        public override void Inc()
        {
            Inc(true);
        }

        protected int rate;	//	nStep<0̂Ƃ́AInc()+1
    };


    /// JE^
    public class InteriorCounter : ICounter
    {

        public static InteriorCounter operator ++(InteriorCounter counter) { counter.Inc(); return counter; }
        public static InteriorCounter operator --(InteriorCounter counter) { counter.Dec(); return counter; }
        //	intƂ̑ݕϊ
        public static explicit operator int(InteriorCounter counter) { return counter.Value(); }

        public InteriorCounter()
        {
        }

        public InteriorCounter(int start_, int end_, int frames_)
        {
            Set(start_, end_, frames_);
        }

        /// Z
        public override void Inc()
        {

            // error...
            if (frames == 0) return;

            if (framesNow >= frames)
            {
                rootCount = end;
                return;
            }
            framesNow++;
            //	
            rootCount = start + framesNow * (end - start) / frames;
        }

        /// Z
        public void Dec()
        {

            // error...
            if (frames == 0) return;

            //	JE^͏lH
            if (framesNow == 0) return;
            framesNow--;
            //	
            rootCount = start + framesNow * (end - start) / frames;
        }

        /// ݒ
        public override void Set(int start_, int end_, int frames_)
        {
            start = start_;
            end = end_;
            frames = frames_;
            framesNow = 0;
            StepValue = frames_;
        }

        /// ݂̒l̐ݒ
        public void Set(int now_) { rootCount = now_; }

        /// ݂̃t[̐ݒ
        public void SetFlame(int now_)
        {
            if (frames >= rootCount)
            {
                framesNow = now_;
            }
        }

        public override int ValueSined()
        {
            float temp1 = ((float)(rootCount - start));
            if (temp1 == 0)
            {
                return 0;
            }

            float nowRad = temp1 / ((float)(end - start));
            return sin.Sin((int)(nowRad * 128.0f), rootCount);

            //    float a = ((float)frames) / rootCount * 128.0f;
            //float b = rootCount * 128.0f;
            //return sin.Sin((int)(((float)frames) / rootCount * 128.0f), rootCount);
        }

        /// IH
        public override bool IsEnd
        {
            get
            {
                return (bool)(rootCount == end);
            }
        }

        // interface݊
        int getStep() { return frames; }
        public override void Reset()
        {
            Set(start, end, frames);
        }

        private int frames;		//	t[iIlɂȂ܂ŉInc΂̂j
        private int framesNow;	//	݁At[ڂH
    };

    /// <summary>
    /// FSPɈˑȂ^C}[JE^[
    /// </summary>
    public class TimerCounter : ICounter
    {
        private int time;
        private FixTimer timer;
        private bool reverse;
        private bool initFlg = false;
        private bool lapAroundI;
        private bool reversing;

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="time"></param>
        public TimerCounter(int start, int end, int time)
        {
            StartValue = start;
            EndValue = end;
            this.timer = new FixTimer();
            this.time = time;
        }

        /// <summary>
        /// o[XJEgǂ
        /// </summary>
        public bool Reverse
        {
            get { return reverse; }
            set { reverse = value; }
        }

        /// <summary>
        /// IncʁAlɖ߂H
        /// </summary>
        public bool IsLapAroundI
        {
            get { return lapAroundI; }
        }

        /// <summary>
        /// IlɒB
        /// </summary>
        /// <returns></returns>
        public override bool IsEnd
        {
            get
            {
                return time <= timer.Time;
            }
        }

        /// <summary>
        /// 擾
        /// </summary>
        /// <returns></returns>
        public override int Value()
        {
            if (IsEnd)
            {
                return EndValue;
            }

            if (StartValue < EndValue)
            {
                return (int)(StartValue + (EndValue - StartValue) * (timer.Time / (float)time));
            }
            return (int)(StartValue - (StartValue - EndValue) * (timer.Time / (float)time)); ;

        }

        /// <summary>
        /// JEgJn
        /// </summary>
        public override void Reset()
        {
            timer.Reset();
        }

        /// <summary>
        /// ݂̎ԂɁAl𑝕
        /// </summary>
        public override void Inc()
        {
            if (!initFlg)
            {
                timer.Reset();
                initFlg = true;
            }
            timer.Update();
            if (IsEnd)
            {
                if (reverse)
                {
                    int tmp = StartValue;
                    StartValue = EndValue;
                    EndValue = tmp;
                    timer.Reset();
                    lapAroundI = reversing;
                }
                reversing = !reversing;
            }
        }
    }

    /// <summary>
    /// [U`̎RȐJE^
    /// </summary>
    public class FreeLineCounter : ICounter
    {

        public override void Set(int start_, int end_, int step_)
        {
            counter.Set(start_, end_, step_);
            createPoints();
        }

        public override int StartValue
        {
            get
            {
                return counter.StartValue;
            }
            set
            {
                counter.StartValue = value;
            }
        }

        public override int StepValue
        {
            get
            {
                return counter.StepValue;
            }
            set
            {
                counter.StepValue = value;
            }
        }

        public override int EndValue
        {
            get
            {
                return counter.EndValue;
            }
            set
            {
                counter.EndValue = value;
            }
        }

        public override bool IsEnd
        {
            get
            {
                return counter.IsEnd;
            }
        }

        public override void Reset()
        {
            counter.Reset();
        }

        public override int Value()
        {
            int index = counter.Value();
            int st = counter.StartValue;
            int ed = counter.EndValue;
            int offset = st > ed ? ed : st;

            index -= offset;
            if (index >= ptSpline.Count)
            {
                index = ptSpline.Count - 1;
            }
            return offset + getRound(ptSpline[index].Y);
        }

        public override int ValueSined()
        {
            return 0;
        }

        public override void Inc()
        {
            counter.Inc();
        }

        ///
        public void setSamplePt(float[] x_, float[] y_)
        {
            sx.Clear();
            sy.Clear();

            for (int i = 0; i < LC_S_PRE_POINT.Length; ++i)
            {
                sx.Add(LC_S_PRE_POINT[i][0]);
                sy.Add(LC_S_PRE_POINT[i][1]);
            }

            foreach (int x in x_)
            {
                sx.Add(x);
            }
            foreach (int y in y_)
            {
                sx.Add(y);
            }

            for (int i = 0; i < LC_S_POST_POINT.Length; ++i)
            {
                sx.Add(LC_S_POST_POINT[i][0]);
                sy.Add(LC_S_POST_POINT[i][1]);
            }
        }

        /// ʒu𐶐
        public void createPoints()
        {
            int st = counter.StartValue;
            int ed = counter.EndValue;
            int dataNum = ed - st;

            if (dataNum < 0)
            {
                dataNum = -dataNum;
                int tmp = st;
                st = ed;
                ed = tmp;
            }

            List<Position> pts = new List<Position>();
            for (int i = 0; i < sx.Count; ++i)
            {
                Position pt = new Position();
                pt.X = (int)(dataNum * sx[i]);
                pt.Y = (int)(dataNum * sy[i]);

                pts.Add(pt);
            }

            // Tṽ|Cg dataNum/5 ̓_ŕ⊮
            ptSpline = BSpline.CalcBSpline(pts, dataNum / 5);

            /*		
                    printf("PosNum %d\n", ptSpline.length);
                    foreach (inout Position p ; ptSpline) {
                        printf("X %f, Y %f\n", p.X, p.Y);
                    }
            */
        }

        public FreeLineCounter()
        {
            for (int i = 0; i < LC_S_POINT.Length; ++i)
            {
                sx.Add(LC_S_POINT[i][0]);
                sy.Add(LC_S_POINT[i][1]);
            }
        }

        /// 
        public FreeLineCounter(ICounter counter_)
            : this()
        {
            this.counter = counter_;
        }


        /// ۂߍ݂s
        private static int getRound(float f)
        {
            return (int)f;
        }

        private ICounter counter;

        private static readonly float[][] LC_S_PRE_POINT = {
		        new float[] {0.0f ,  0.0f},	
	        };

        private static readonly float[][] LC_S_POST_POINT = {
		         new float[] {1.0f, 1.0f},	
		         new float[] {1.0f, 1.0f},	
		         new float[] {1.0f, 1.0f},
	        };

        private static readonly float[][] LC_S_POINT = {
		         new float[] {0.0f ,  0.0f},	
		         new float[] {0.0f ,  0.0f},	//1 START
		         new float[] {0.1f , 0.1f},	//2
		         new float[] {0.2f , 0.2f},	//3
		         new float[] {0.6f , 0.6f},	//4
		         new float[] {0.8f, 0.8f},	//5
		         new float[] {0.9f, 0.9f},	//6
		         new float[] {1.0f, 1.0f},	//7 END
		         new float[] {1.0f, 1.0f},	
		         new float[] {1.0f, 1.0f},
            };

        private List<float> sx = new List<float>();	//@[U`Ȑ̃Tv_
        private List<float> sy = new List<float>();

        private List<Position> ptSpline = new List<Position>();

    }

    /// <summary>
    /// _J^[̂߂̃C^[tF[X 
    /// </summary>
    public abstract class IDecimalCounter : ICounter
    {
        public abstract double GetDecimal();
    }


    /// <summary>
    /// Xebv[gݒłCounterpbP[WB
    /// ̃pbP[WɋLqĂNXׂ͂āA[gɂăXebv䗦삳B
    /// </summary>
    public class PowIncCounter : IDecimalCounter
    {

        public const float STEP_SCALE = 1024.0f;

        #region otB[h

        // ftHg̒
        protected const double DEFAULT_BASE = 0.915;

        protected double baseValue = DEFAULT_BASE;
        protected new double rootCount = 0.0f;
        protected int incCount;
        //protected int start;
        //protected int end;
        //protected int step;
        protected int rate;	//	nStep<0̂Ƃ́AInc()+1

        protected bool init;			//	lݒ肳Ă邩H
        protected int initNum;		//	ݒ肳Ă鏉l

        #endregion

        public override int StartValue
        {
            get
            {
                return start;
            }
            set
            {
                start = value;
            }
        }

        public override int StepValue
        {
            get
            {
                return step;
            }
            set
            {
                step = value;
            }
        }

        public override int EndValue
        {
            get
            {
                return end;
            }
            set
            {
                end = value;
            }
        }

        public override int Value()
        {
            return (int)GetDecimal();
        }

        public override int ValueSined()
        {
            return Value();
        }

        //	ݒ
        public override void Set(int start_, int end_, int step_)
        {
            step = step_;
            start = start_;
            end = end_;
            incCount = 0;
        }

        public void SetIncCount(int value)
        {
            incCount = value;
        }

        ////	l
        public void SetInit(int n)
        {
            init = true;
            initNum = n;
        }

        //	JE^̃Zbg
        public override void Reset()
        {
            rate = 0;
            incCount = 0;
            if (!init)
            {
                rootCount = 0.0f;
            }
        }

        /// <summary>
        /// I.
        ///  false ԋp
        /// </summary>
        public override bool IsEnd
        {
            get { return false; }
        }

        //	JE^̃CNg(I[܂ŒBƁAēxAlɖ߂)
        public override void Inc()
        {
            ++incCount;
            rootCount = GetIncValue() * incCount;
        }
        public void Dec()
        {
            --incCount;
            rootCount = GetIncValue() * incCount;
        }

        public int opAssign(int n)
        {
            rootCount = n;
            return n;
        }

        public override double GetDecimal()
        {
            return start + ((end - start) * (1.0f - (global::System.Math.Pow(baseValue, (double)rootCount))));
        }

        /// gpĂԋp
        public double GetBase()
        {
            return baseValue;
        }
        /// gpݒ肷(0 < baseValue_ < 1)
        public void SetBase(double base_)
        {
            baseValue = base_;
        }

        public PowIncCounter()
        {
            Set(0, int.MaxValue, 1);
            Reset();
        }

        public PowIncCounter(int end_)
        {
            Set(0, end_, 1);
            Reset();
        }

        public PowIncCounter(int start_, int end_, int step_)
        {
            Set(start_, end_, step_);
            Reset();
        }


        protected double GetIncValue()
        {
            return step / STEP_SCALE;
        }
    }


}
