using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;

namespace Yamalib.Util
{
    /// <summary>
    /// JAVAProperties݂ȃNX
    /// </summary>
    public class Properties
    {
        public static Properties GetInstance(string filename)
        {
            string lowFilename = filename.ToLower();

            if (INSTANCE_MAP.ContainsKey(lowFilename))
            {
                return INSTANCE_MAP[lowFilename];
            }

            Properties prop = new Properties();
            if (prop.Load(filename))
            {
                INSTANCE_MAP[lowFilename] = prop;
            }
            return prop;
        }

        /// vpeB̎擾
        public string GetProperty(string key)
        {
            if (mp.ContainsKey(key))
            {
                return mp[key];
            }
            return null;
        }

        /// vpeB̎擾
        public string GetProperty(string key, string def)
        {
            if (mp.ContainsKey(key))
            {
                return mp[key];
            }
            return def;
        }

        /// vpeB̎擾
        public long GetPropertyNum(string key, long def)
        {
            if (mp.ContainsKey(key))
            {
                try
                {
                    return Convert.ToInt64(mp[key]);

                }
                catch (Exception)
                {
                    return def;
                }
            }
            return def;
        }

        /// fW}̎擾
        public double GetPropertyDecimal(string key, double def)
        {
            if (mp.ContainsKey(key))
            {
                try
                {
                    return Convert.ToDouble(mp[key]);

                }
                catch (Exception)
                {
                    return def;
                }
            }
            return def;
        }

        /// vpeBׂ̂ẴL[擾
        public string[] GetPropertyNames()
        {
            string[] result = new string[mp.Count];
            int i = 0;
            foreach(string str in mp.Keys) {
                result[i++] = str;
            }
            return result;
        }

        private Properties() { }

        /// t@C̍ŏIύXԂ擾
        private static long GetModTime(string filename)
        {
            long modTime = -1L;
            try
            {
                System.IO.DirectoryInfo fileInfo = new System.IO.DirectoryInfo(filename);
                modTime = fileInfo.LastAccessTime.Ticks;
            }
            catch
            {
                // t@CɃANZXs...
            }
            return modTime;
        }

        /// t@C̍ŏIύXԂ`FbNύXĂ΍ēǍs
        private void CheckLastMod()
        {
            if (GetModTime(propname) > lastWriteTime)
            {
                Load(propname);
            }
        }

        /// ǂݍ݂܂
        public bool Load(string filename)
        {
            propname = filename;
            lastWriteTime = GetModTime(filename);

            string data = Yamalib.Util.YamalibUtility.ReadTextFile(filename);
            string[] lineData = data.Split(new char[] { '\r','\n' });

            foreach (string str in lineData)
            {
                string[] buf = str.Split(new char[] { '#' });
                if (buf.Length < 1)
                {
                    continue;
                }
                string linebuf = buf[0];
                int pos  = linebuf.IndexOf('=');
	
                if ( -1 == pos ) {
                    continue;
                }
	
                string key = linebuf.Substring(0,pos);
                string value = string.Empty;
                if ( linebuf.Length >= pos + 1 ) {
                    value = linebuf.Substring((pos+1), linebuf.Length-pos-1);
                }
                mp[key] = value;
            }
            return true;
        }

        private static Dictionary<string, Properties> INSTANCE_MAP = new Dictionary<string, Properties>();
        private Dictionary<string, string> mp = new Dictionary<string, string>();
        private string propname;
        private long lastWriteTime = -1L;

    }
}
