using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.System;
using Yanesdk.Draw;

namespace Yamalib.Util
{

    /// <summary>
    /// Yanesdk.Draw.Point ͍\̂Ȃ̂ŎQƓnłȂB
    /// classƂĈÖقɎQƓn҂ȂAclass
    /// </summary>
    public class Position
    {
        private Point point;

        public Position()
        {
        }

        public Position(float x, float y)
        {
            point = new Point(x, y);
        }

        public void SetPosition(float x, float y)
        {
            point.SetPoint(x, y);
        }

        public float X
        {
            set { point.X = value; }
            get { return point.X; }
        }

        public float Y
        {
            set { point.Y = value; }
            get { return point.Y; }
        }
    }

    public static class YamalibUtility
    {
        static private global::System.Text.Encoding codePage = Encoding.GetEncoding("Shift_JIS");

        public static String ReadTextFile(String filename)
        {
            byte[] data = FileSys.Read(filename);
            if (data == null)
                return String.Empty;

            bool BOMFound = (data.Length >= 2 &&
                data[0] == 0xff &&
                data[1] == 0xfe);

            // data͂ĂB
            StringBuilderEncoding byteData = new StringBuilderEncoding();

            if (BOMFound)
            {
                for (int i = 2; i < data.Length; )
                {
                    byte b1 = data[i++];
                    if (!(i < data.Length)) break;
                    byte b2 = data[i++];
                    byteData.Add(b1);
                    byteData.Add(b2);
                }
            }
            else
            {
                foreach (byte c in data)
                {
                    byteData.Add(c);
                }
            }
            // ŌɉsȂline\A
            if (byteData.Count == 0)
            {
                return String.Empty;
            }
            if (BOMFound)
            {
                return byteData.Convert(Encoding.GetEncoding("utf-16"));
            }
            return byteData.Convert(codePage);
        }

        /// <summary>
        /// m̃IuWFNg IDisposable Ȃ Dispose s
        /// </summary>
        /// <param name="obj"></param>
        public static void Dispose(Object obj)
        {
            if (null == obj)
            {
                return;
            }
            IDisposable targetObj = obj as IDisposable;
            if (null != targetObj)
            {
                targetObj.Dispose();
            }
        }

        /// <summary>
        /// m̃IuWFNg IDisposable Ȃ Dispose s
        /// </summary>
        /// <param name="obj"></param>
        public static void Dispose(Object[] objs)
        {
            if (null == objs || 0 == objs.Length)
            {
                return;
            }
            for (int i = 0; i < objs.Length; ++i)
            {
                Dispose(objs[i]);
            }
        }
    }
}
