using System;
using System.Collections.Generic;
using System.Text;
using Yanesdk.Draw;

namespace Yamalib.Yanesdkext.Draw
{
    /// <summary>
    /// eNX`[̃LbVpNXB
    /// </summary>
    /// <remarks>
    /// </remarks>
    /// <example>
    /// <code>
    /// FontLoader loader = new FontLoader();
    /// loader.loadDefRW("msmincho.ttc , 0 , 50 , 0\n");
    ///
    ///	FontRepository fr = new FontRepository;
    ///	fr.SetLoader(loader,0);
    ///	fr.Max = 100;
    ///
    ///	//	C[vɂ
    ///
    ///	Textures fonttv = fr.GetTexture("̕`ǂI");
    ///	//	font repositoryôŁAn[i߄D߁j
    ///
    ///	//		fonttv.SetSurface(
    ///	//			loader.Get(0).drawBlendedUnicode("̕`ǂI"));
    ///	//	t[tHg𐶐Ƃׂ
    ///
    ///	screen.SetColor(255,0,0);
    ///
    ///	screen.Blt(fonttv,30,100);
    ///	screen.resetColor();
    /// 
    /// </code>
    /// </example>
    public class SurfaceFontRepository : IDisposable
    {

        #region FontñeXgp̃R[h1
        /*
				FontRepository fr;
				FontLoader fontLoader;
				Textures txts;

				public void Init()
				{
					window = new Win32Window(this.pictureBox1.Handle);
					window.Screen.Select();

					fontLoader =new FontLoader();
					fontLoader.LoadDefFile("mem:msmincho.ttc , 16 , 0 , 0\n");
					fr = new FontRepository(delegate { return new GlTexture(); });
					fr.SetLoader(fontLoader, 0);

					txts = fr.GetTexture("`ł񂩁H",0);

					window.Screen.Unselect();
				}

				Win32Window window;

				private void timer1_Tick(object sender , EventArgs e)
				{
					Yanesdk.Draw.screen scr = window.Screen;
					scr.Select();
					scr.SetClearColor(255, 0, 0);
					scr.Clear();

					scr.Blend = true;
					scr.BlendSrcAlpha();
					scr.Blt(txts , 0 , 0);

					scr.Update();
				}
		*/
        #endregion

        #region FontñeXgp̃R[h2
        /*
		Win32Window window;

		private void OnInit(){
			window = new Win32Window(this.pictureBox1.Handle);
			window.Screen.Select();

			FontRepository fr;
			FontRepository fr2;
			FontLoader fontLoader;
			Textures[] txts = new Textures[12];
			fontLoader =new FontLoader();
			fontLoader.LoadDefFile("mem:msmincho.ttc , 32 , 0 \nmsmincho.ttc , 16 , 0 \n");
			fr = new FontRepository(delegate { return new GlTexture(); });
			fr.SetLoader(fontLoader, 0);
			fr2 = new FontRepository(delegate { return new GlTexture(); });
			fr2.SetLoader(fontLoader, 1);

			for (int i = 0; i < 3; ++i)
			{
				int j = i * 4;
				txts[0+j] = fr.GetTexture("`ł񂩁H", i);
				txts[1+j] = fr.GetTextureSolid("`ł񂩁H", i);
				txts[2+j] = fr2.GetTexture("`ł񂩁H", i);
				txts[3+j] = fr2.GetTextureSolid("`ł񂩁H", i);
			}
		}

		private void timer1_Tick(object sender , EventArgs e)
		{
			Yanesdk.Draw.screen scr = window.Screen;
			scr.Select();
			scr.SetClearColor(255, 0, 0);
			scr.Clear();

			scr.Blend = true;
			scr.BlendSrcAlpha();
			
			for(int i=0;i<12;++i)
				scr.Blt(txts[i] , 0 , i*20);

			scr.Update();
		}	
	*/
        #endregion

        /// <summary>
        /// LbV镶̐B
        /// </summary>
        /// <param name="max"></param>
        /// <remarks>
        /// ʂɕ`悵ő啶傫ȒlɂĂȂ
        /// `悵ĂŒɉāAςȂƂɂȂ܂B
        /// 
        /// 300炢KƎv܂A`悷ꍇ
        /// ̐ɍ킹Ē邱Ƃ߂܂B
        /// 
        /// defaultl : 300
        /// </remarks>
        public int Max
        {
            set
            {
                if (max != value)
                {
                    ResizeFontCache(value);
                    max = value;
                }
            }
        }
        private int max = 300;

        /// <summary>
        /// tHgcacheTCY̕ύXsȂB
        /// </summary>
        /// <param name="size"></param>
        private void ResizeFontCache(int size)
        {
            Release();

            fonts.Clear();
            fonts.Capacity = size;
        }

        public delegate Surface SurfaceFactory();

        /// <summary>
        /// RXgN^ŁASurfacehNX𐶐factorynĂB
        /// 
        /// )
        ///		TextureLoader loader = new TextureLoader(delegate {
        ///           return new GlTexture(); });
        /// </summary>
        /// <remarks>
        /// fBtHgłcache size = 64MB
        /// OpenGL`ɎgĂꍇAeNX`TCY2ׂ̂alignB
        /// Ƃ΁A640~480̉摜Ȃ1024~512(32bpp)ɂȂB
        /// āA1024~512~4byte = 2097152  2MBB
        /// 50MB640~480̉摜悻25ǂݍ߂ƍlėǂ낤B
        /// </remarks>
        /// <param name="factory"></param>
        public SurfaceFontRepository(SurfaceFactory factory)
        {
            this.factory = factory;

            ResizeFontCache(max);
        }

        private SurfaceFactory factory;

        /// <summary>
        /// ЂƂ̕ɑ΂B
        /// </summary>
        internal class Info
        {
            /// <summary>
            /// LbVĂ镶B
            /// </summary>
            public char Letter;
            /// <summary>
            /// LbVĂ镶̃X^C
            /// </summary>
            public int Style;
            /// <summary>
            /// gpĂtHg[_[B
            /// </summary>
            public FontLoader FontLoader;
            /// <summary>
            /// tHgio[(FontLoaderɂio[)B
            /// </summary>
            public int FontNo;
            /// <summary>
            /// ̃eNX`(null = )B
            /// </summary>
            public Surface Surface;
            /// <summary>
            /// TextureQƂꂽŌ̎ԁB
            /// </summary>
            public long LastAccessTime;
        }

        /// <summary>
        /// FontLoaderƂ̎gpio[wݒ肷B
        /// 
        /// io[́AFontLoaderŒ`t@Cǂݍ񂾂ƂɁA
        /// `t@CɏĂ擪0,1,2,cƃioOĂB
        /// </summary>
        /// <param name="loader_"></param>
        /// <param name="no_"></param>
        /// <remarks>
        /// ȍ~AGetTextureł́ÃtHgǂݍ܂B
        /// </remarks>
        public void SetLoader(FontLoader loader, int fontNo)
        {
            this.loader = loader;
            this.fontNo = fontNo;
        }

        /// <summary>
        /// tHg[_[͕ύXɁAgptHgio[ݒ/擾
        /// </summary>
        /// <param name="no_"></param>
        public int FontNo
        {
            set
            {
                fontNo = value;
            }
            get
            {
                return fontNo;
            }
        }


        /// <summary>
        /// ɑΉtHg擾B
        /// </summary>
        /// <param name="letter"></param>
        /// <returns></returns>
        /// <remarks>
        /// LbV當W߂̂ŁAłW߂
        /// (eNX`)͂̂ŁAgp̂
        /// ̕`t[Ōɂ邱ƁB
        /// 
        /// styleŎw肷l̈ӖFont.SytleƓB
        /// 
        ///  DrawBlendedUnicodeŕ`悵ĂB
        /// 
        /// </remarks>
        public Surface GetSurface(char letter, int style)
        {
            return GetSurfaceHelper(letter, style, true);
        }

        /// <summary>
        /// ɑΉtHg擾B
        /// </summary>
        /// <param name="letter"></param>
        /// <returns></returns>
        /// <remarks>
        /// LbV當W߂̂ŁAłW߂
        /// (eNX`)͂̂ŁAgp̂
        /// ̕`t[Ōɂ邱ƁB
        /// 
        /// styleŎw肷l̈ӖFont.SytleƓB
        /// 
        ///  DrawSolidUnicodeŕ`悵ĂB
        /// GetTextureDrawSolidUnicodeŕ`悷o[W
        /// 
        /// </remarks>
        public Surface GetSurfaceSolid(char letter, int style)
        {
            return GetSurfaceHelper(letter, style, false);
        }

        /// <summary>
        /// GetTexture/GetTextureSolidphelpere
        /// </summary>
        /// <remarks>
        /// isBlended̒lɉāADrawBlendedUnicodeDrawTextureSolidƂ؂ւĕ`悷B
        /// </remarks>
        /// <param name="letter"></param>
        /// <param name="style"></param>
        /// <param name="isBlended"></param>
        /// <returns></returns>
        private Surface GetSurfaceHelper(char letter, int style, bool isBlended)
        {
            if (loader == null) return null; // 񂱁[R(`DL)m

            int index = int.MaxValue; // fail safe

            //	TĂ݂
            for (int i = 0; i < fonts.Count; ++i)
            {
                if ((fonts[i].Letter == letter) &&
                    (fonts[i].Style == style) &&
                    (fonts[i].FontLoader == loader) &&
                    (fonts[i].FontNo == fontNo))
                {
                    //	݂I
                    index = i;
                    goto Exit;
                }
            }

            //@Ȃ̂ŐĂ݂

            //Surface surface = factory();
            //if (surface == null)
            //    return null; // factoryݒ肳Ƃ(L`)

            Surface surface = null;

            Font font = loader.GetFont(fontNo);
            if (font != null)
            {
                surface =
                    isBlended
                    ? font.DrawBlendedUnicode(letter.ToString())
                    : font.DrawSolidUnicode(letter.ToString());
                //surface.SetSurface(surface);
                //surface.Dispose(); // ƂȂ
            }
            else
            {
                // Ȃ[Bǂݍ܂ւ񂩂
                return null;// s
            }

            // łBɋ󂫏ꏊm肳

            if (fonts.Count == max)
            {
                //	ꏊ󂢂ĂȂ̂ŁAԍŌɎQƂꂽ
                //	IuWFNg
                long t = long.MaxValue;
                for (int i = 0; i < fonts.Count; ++i)
                {
                    if (fonts[i].LastAccessTime < t)
                    {
                        t = fonts[i].LastAccessTime;
                        index = i;
                    }
                }
                Surface tt = fonts[index].Surface;
                if (tt != null)
                    tt.Dispose(); // ꉞĂ
            }
            else
            {
                index = fonts.Count;
                fonts.Add(new Info()); // ЂƂm
            }

            // local copyAœKŏ납H
            Info info = new Info();
            info.Letter = letter;
            info.FontLoader = loader;
            info.FontNo = fontNo;
            info.Style = style;
            info.Surface = surface;

            fonts[index] = info;

        Exit:
            //	QƂ̂ŁA炵ĂB
            fonts[index].LastAccessTime = ++time;
            return fonts[index].Surface;
        }

        ///// <summary>
        ///// ɑ΂镶xN^擾B
        ///// styleŎw肷l̈ӖFont.SytleƓB
        ///// </summary>
        ///// <remarks>
        /////  DrawBlendedUnicodeŕ`悵ĂB
        ///// </remarks>
        ///// <param name="str"></param>
        ///// <returns></returns>
        //public Textures GetSurface(string str, int style)
        //{
        //    return GetSurfaceHelper(str, style, true);
        //}

        ///// <summary>
        ///// ɑ΂镶xN^擾B
        ///// styleŎw肷l̈ӖFont.SytleƓB
        ///// </summary>
        ///// <remarks>
        /////  DrawSolidUnicodeŕ`悵ĂB
        ///// </remarks>
        ///// <param name="str"></param>
        ///// <returns></returns>
        //public Textures GetSurfaceSolid(string str, int style)
        //{
        //    return GetSurfaceHelper(str, style, false);
        //}

        ///// <summary>
        ///// GetTexture/GetTextureSolidphelper
        ///// </summary>
        ///// <remarks>
        ///// isBlended̒lɉāADrawBlendedUnicodeDrawTextureSolidƂ؂ւĕ`悷B
        ///// </remarks>
        ///// <param name="str"></param>
        ///// <returns></returns>
        //private Textures GetSurfaceHelper(string str, int style, bool isBlended)
        //{
        //    if (loader == null) return null; // 񂱁[R(`DL)m

        //    Textures tv = new Textures();
        //    for (int i = 0; i < str.Length; ++i)
        //    {
        //        Surface Texture = isBlended ? GetSurface(str[i], style) : GetSurfaceSolid(str[i], style);

        //        if (Texture == null)
        //            continue; // renderingɎsfont͔΂

        //        tv.Add(Texture, (int)tv.Width, 0);
        //        //	EɘAĂ
        //    }
        //    tv.Update();	// ĂяoĂȂ
        //    //	񂪍XVȂ񂾂(LD`)
        //    return tv;
        //}

        /// <summary>
        /// ێĂtHgB
        /// </summary>
        public void Release()
        {
            if (fonts != null)
            {
                //	IɉĂ..
                for (int i = 0; i < fonts.Count; ++i)
                {
                    Surface t = fonts[i].Surface;
                    if (t != null) t.Dispose();
                }
                fonts.Clear();
            }
        }

        /// <summary>
        /// ݑIĂtHg擾
        /// </summary>
        /// <returns></returns>
        public Font CurrentFont
        {
            get { return loader.GetFont(fontNo); }
        }

        /// <summary>
        /// Dispose̍ėp͂łȂB
        /// Pɉ邾ȂReleaseĂяoāB
        /// </summary>
        public void Dispose()
        {
            Release();
        }

        private List<Info> fonts = new List<Info>();	//	gpĂtHgLbV
        private FontLoader loader;		//	ǂݍ
        private int fontNo;			//	IĂtHgio[
        private int time;			//	

    }
}
