﻿module yamalib.date.date;

private import y4d_aux.lineparser;
private import std.ctype; // tolower
private import std.string;	// toString
private import std.date;

/** 日付を表現するデータ型 */
class DateTime {
	int year;
	int month;
	int day;
	int hours;
	int mimutes;
	int second;
	
	char[] toString() {
		return std.string.toString(year) ~ " " ~ std.string.toString(month) ~ " " ~std.string.toString(day)
		~ " " ~ std.string.toString(hours) ~ " " ~std.string.toString(mimutes) ~ " " ~std.string.toString(second) ;
	}
}

/**
	日付関連のユーティリティクラス
*/
class DateUtil {
	// 日付を生成する
	static DateTime getDateTime() {
		DateTime dateTime = new DateTime();
		long date = getUTCtime();
		long localDate = UTCtoLocalTime(date);
		
		// 日本時間にあわせて９時間足す
		localDate += (60 * 60 * 9) * std.date.TicksPerSecond;
		
		char[] str,strHhMmSs,strHh;
		str = cast(char[]) std.date.toString(localDate);
		str = cast(char[]) replace(str," ",",");
		// 空白をカンマに変えてパーシングする
		LineParser lineparser = new LineParser();
		lineparser.setLine(str);
		lineparser.getStr();	// 曜日は捨てる
		lineparser.getStr();	// 月
		lineparser.getStr();	// 日
		strHhMmSs = lineparser.getStr();
		strHh = strHhMmSs[0..2];

		dateTime.year = .YearFromTime(localDate);;
		// 0..11
		dateTime.month = .MonthFromTime(localDate) + 1;
		dateTime.day = .DateFromTime(localDate);
		dateTime.hours = cast(int) atoi(strHh);
		dateTime.mimutes = cast(int) atoi(strHhMmSs[3..5]);
		dateTime.second = cast(int) atoi(strHhMmSs[6..8]);
		
		return dateTime;
	}
	
	/// 指定のdtより、フォーマットした日付を返却する
	static char[] format(DateTime dt, char[] fmt) 
	/**
		yyyy 年
		yy   年（下二桁）
		MM	 月
		dd	 日
		hh	 時
		mm   分
		ss	 秒
	*/
	{
		auto year = getFullLen( cast(char[]) std.string.toString(dt.year) );
		auto month = getFullLen( cast(char[]) std.string.toString(dt.month) );
		auto day = getFullLen( cast(char[]) std.string.toString(dt.day) );
		auto hours = getFullLen( cast(char[]) std.string.toString(dt.hours) );
		auto mimutes = getFullLen( cast(char[]) std.string.toString(dt.mimutes) );
		auto second = getFullLen( cast(char[]) std.string.toString(dt.second) );
		
		fmt = cast(char[]) std.string.replace( fmt, "yyyy", year );
		fmt = cast(char[]) std.string.replace( fmt, "yy", year[2..length] );
		fmt = cast(char[]) std.string.replace( fmt, "MM", month );
		fmt = cast(char[]) std.string.replace( fmt, "dd", day );
		fmt = cast(char[]) std.string.replace( fmt, "hh", hours );
		fmt = cast(char[]) std.string.replace( fmt, "mm", mimutes );
		fmt = cast(char[]) std.string.replace( fmt, "ss", second );
		
		return fmt;
	}

private:

	this() {
	}
	
	/// 二桁の文字に編集する
	static char[] getFullLen(char[] str) {
		if ( str.length >= 2 ) {
			return str;
		} else {
			return "0" ~ str;
		}
	}

}