module yamalib.input.adapter;

private import y4d_input.mouse;
private import y4d_input.keyinputbase;
private import y4d_input.keyboardinput;


/**
	キーボード入力をマウスボタン操作に適合させる
	アダプタクラス
*/
public class MouseInputAdapter : MouseInputImpl {
	
	/** マウスボタンとキーのマッピングを表すクラス  */
	static public class MouseKeyInputMap {
		/// マウス－キーマップをセットする（上書きする）
		void set(button e, int keyCode) {
			keyMap[e] = keyCode;
		}
		/// 設定されたキーマッピングを取得する
		int getKeyCode(button e) {
			return keyMap[e];
		}
		/// コンストラクタ
		this() {
			keyMap[button.left] = KeyCode.RETURN;
			keyMap[button.middle] = KeyCode.UNKNOWN;
			keyMap[button.right] = KeyCode.UNKNOWN;
			keyMap[button.wheel_up] = KeyCode.UP;
			keyMap[button.wheel_down] = KeyCode.DOWN;
		}
	private:
		int[button] keyMap;	
	}

	///	マウスカーソルを表示する
	override void show() {
		// 何もしない
	}

	///	マウスカーソルを非表示にする
	override void hide() {
		// 何もしない
	}

	///	マウスの位置取得
	/**
		マウスが画面外にあるときは最後に取得した値が返ります。
		すなわち、画面サイズが640×480ならば、xは0～639,yは0～479までの
		値しか返らないことが保証されます。
	*/
	override void getPos(out int x,out int y){
//		x = y = int.min;
		super.getPos(x,y);
	}

	///	マウスの位置を設定
	/**
		SDLのマウスの位置設定イベントが発生する。
	*/
	override void setPos(uint x,uint y) {
		super.setPos(x,y);
	}

	///	ボタンが押し下げられているかを判定する関数
	override bool isPress(button e) {
		return m_key.isPress( m_mkMapping.getKeyCode(e) );
	}

	/// コンストラクタ
	this(KeyInputBase key, MouseKeyInputMap mapping) 
	in
	{
		assert( !(key is null) );
		assert( !(mapping is null) );
	}
	body
	{
		m_key = key;
		m_mkMapping = mapping;
	}

protected:
	KeyInputBase m_key;
	MouseKeyInputMap m_mkMapping;

}