﻿module kyojintati4d.taskmusicroom;

private import y4d;
private import y4d_aux.filesys;

private import kyojintati4d.myapp;
private import kyojintati4d.gameinfo;
private import kyojintati4d.component.music;

private import yamalib.gui.guilistbox;
private import yamalib.log.log;
private import yamalib.log.performancelog;
private import yamalib.counterfsp;

/**
	音楽室のメインクラス
*/
class TaskMusicRoom : GameTaskBase {
	
	/// 毎回呼び出す
	override int onMove(Object o) {
		try {
			info = cast(GameInfo) o;
	
			if (!init) {
				onInit(info);
				m_mainCtl.onMove( info.screen );
				m_mainCtl.setVolume( 80 );
				init = true;
			}
			
			m_mouse.update();

			// 移動処理
			m_mainCtl.onMove( info.screen );
			m_title.onMove( info.screen );
			m_desc.onMove( info.screen );
			m_playList.onMove( info.screen );
			
			// プレイリストでリクエストがかかった！
			if ( m_playList.isNewSelected() ) {
				m_mainCtl.setPlayNum( m_playList.getSelectedNum() );
			} else {
				m_playList.setSelect( m_mainCtl.getPlayNum() );
			}
			
			int no = m_mainCtl.getLastPlayNo();
			
			if ( no != m_playNo ) {
				m_title.setTexture( m_tlTitle.get(no) );
				m_desc.setDescNo( no );
				m_playNo = no;
			}
			
			// 終了要請がきたか？
			if ( m_mainCtl.isExitReq() ) {
				returnTask();
				return -1;
			}
	
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onMove : [%s] [%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}
	
	/// 毎回呼び出すなり
	override int onDraw(Object o) {
		try {
			if ( !init ) {
				// コントローラは必ずしもonMoveを先に呼び出すことを保証しない
				return 0;
			}
			
			info = cast(GameInfo) o;
			
			info.screen.clear();
			
			m_playList.onDraw( info.screen );
			m_title.onDraw( info.screen );
			m_desc.onDraw( info.screen );
			m_mainCtl.onDraw( info.screen );
			
			return 0;
		} catch (Exception e) {
			Log.printFatal("RuntimeException %s#onDraw : [%s] [%s]", 
				super.toString(), e.toString(), e.msg);
			throw e;
		}
	}
	
	/// レガシーなやつ
	override int task(Object o) {
		return 0;
	}

	/// 破棄処理
	override void destroy() {
		m_mainCtl = null;
		m_playList = null;
		m_title = null;
		m_desc = null;

		Log.print("%s#destroy : destroyed.", super.toString());
	}
	
	/// コンストラクタ
	this() {
	}
	
private:
	
	/// 初期化処理を記述する
	void onInit(GameInfo info) {
		// メモリー状況をプリント
		GameInfo.printMemoryState();

		// ブレンドＯＫ
		info.screen.blendSrcAlpha();

		m_mouse = info.keyDecolateMouse;
		
		// リソース読み込み
		m_tlTitle = new TextureLoader();
		m_tlBg = new TextureLoader();
		
		// ほとんどキャッシュしたくない
		m_tlTitle.setCacheSize(1024*1024*1);
		m_tlBg.setCacheSize(1024*1024*2);
		
		m_tlTitle.loadDefRW( FileSys.read("img/music/title/img.lst") );
		m_tlBg.loadDefRW( FileSys.read("img/music/bg/img.lst") );
		
		
		auto bgmloader = new SoundLoader();
		bgmloader.loadDefFile("img/music/sound.lst");
		m_mainCtl = new MainParts(m_mouse);
		m_mainCtl.setSoundLoader( bgmloader );
		m_mainCtl.setInputDevice( info.key, m_mouse );
		
		SimpleListBoxItem.getFontRepository().setLoader(info.fontloader, 1);
		SimpleListBoxItem.getFontRepository().setMax(1000);
		m_playList = new PlayList(m_mouse);
		
		m_title = new Title(info.mouse);
		m_title.setTexture( m_tlTitle.get(0) );

		// 説明
		m_desc = new Description(m_mouse);
		m_desc.setFontLoader(info.fontloader);
		m_desc.drawShadow(false);
	}
	
	/// 終了して戻る
	void returnTask() {
		info.gameSceneTransiter.returnScene();

		// このタスクのせいではないんだが、ならしておかないと怒るだろうなぁ
		if (!info.bgmloader.get(0).isPlay()) {
			info.bgmloader.get(0).setLoop(-1);
			info.bgmloader.get(0).setVolume(20);
			info.bgmloader.get(0).play();
		}
	}
	
	GameInfo info;
	bool init;
	MouseInput m_mouse;
	
	MainParts m_mainCtl;	//!< プレイヤー
	PlayList m_playList;	//!< プレイリスト
	Title m_title;			//!< タイトル
	Description m_desc;		//!< 解説
	
	int m_playNo;
	
	TextureLoader m_tlTitle;	//!< 音楽タイトル画像
	TextureLoader m_tlBg;		//!< 背景画像

	
}