﻿module yamalib.draw.noisebltter;

private import y4d;
private import yamalib.counterfsp;

class NoiseBltter {
	
	/** ノイズテクスチャーをセットします */
	static void setNoiseTexture(Texture tex) {
		noiseTex = tex;
	}
	

	/** 垂直非同期ノイズ */
	static void bltUnVerticalSync(Screen screen,Texture src,int x, int y) {
		if (screen is null || src is null) return;
		
		// 描画矩形
		Rect rc1,rc2;
		int sx,sy;
		int tx,ty;
		sx = screen.getWidth();
		sy = screen.getHeight();
		tx = cast(int)src.getWidth();
		ty = cast(int)src.getHeight();
		
		// 通常描画
		if (!effecting) {
			screen.blt(src,0,0);
		} else {
			
			rc1.setRect(0 ,move_d.get(), 640, move_d.getEnd());
			rc2.setRect(0, 0, 640, move_d.get()); 
			
			screen.blt(src,0,0,&rc1);
			screen.blt(src,0, cast(int)rc1.getHeight(),&rc2);
		}

		if (!effecting) {
			intervalCounter++;
			// 一周した？
			if (intervalCounter.get()==0) {
				effectingCounter.setEnd(60+rand.get(60));
				effecting = true;
			}
		} else {
			move_d++;
			effectingCounter++;
			
			if (effectingCounter.get()==0) {
				intervalCounter.setEnd(100+rand.get(60));
				effecting = false;
			}
		}
	}

	
	/** ノイズテクスチャよりノイズを描画します */
	static void bltNoise(Screen screen) {
		if (screen is null || noiseTex is null) return;
		
		screen.blt(noiseTex,-rand.get(370), -rand.get(250));
	}
	
	static this() {
		rand = new Rand();
		rand.randomize();
		move_d = new RootCounter(0,480,60);
		intervalCounter = new RootCounter(0,180,1);
		effectingCounter = new RootCounter(0,120,1);
	}

private:
	static Texture noiseTex;
	static Rand rand;
	static RootCounter move_d;
	static RootCounter intervalCounter;
	static RootCounter effectingCounter;
	static bool effecting;
}

