﻿module kyojintati4d.taskyesno;

private import std.string;
private import std.utf;

private import y4d;
private import y4d_aux.filesys;
private import y4d_aux.widestring;

private import kyojintati4d.myapp;
private import kyojintati4d.gameinfo;

private import yamalib.auxil.properties;
private import yamalib.draw.tiletexture;
private import yamalib.gui.dialog;
private import yamalib.gui.guibutton;
private import yamalib.log.log;


/**
	YesNoダイアログタスク
*/
class TaskYesNo : GameTaskBase {
	
	/// ダイアログで押されたボタンのタイプ
	enum CLICK : int {NO_CLICK= -1, YES = 0, NO, CANCEL };
	/// ダイアログのタイプ
	enum TYPE : int { FINISH=0, OVERWRITE, UWAGAKI, SELECT1, LOAD, SAVE, LOAD_AUTO, SAVE_ONLY  };

	/// タスク名を返却する
	/**
		このタスク名称を使って、コントローラ部でタスク判別を行う可能性があるので
		ユニークな名前で、実装しておくべきである
	*/	
	override char[] getTaskName() {
		with (kyojintati4d.val.kyojinconst) {
			return KyojinConst.TASK_NAME[KyojinConst.Task.Task_YesNo];
		}
	}
	
	/// 移動の処理を行います
	int onMove(Object o) {
		return 0;
	}

	/// 描画の処理を行います
	int onDraw(Object o) {
		return 0;
	}

	/// onDraw+onMove
	int task(Object o) {
		info = cast(GameInfo) o;
		
		if (!init) {
			onInit();
			init = true;
		}

		// キーを有効に
//		NullableMouseInput aMouse = cast(NullableMouseInput) m_mouse;
//		NullableKeyInput aKey = cast(NullableKeyInput) m_key;
//		NullableMouseInput aKeyMouse = cast(NullableMouseInput) info.keyDecolateMouse;

		NullableMouseInput aMouse = cast(NullableMouseInput) info.mouse;
		NullableKeyInput aKey = cast(NullableKeyInput) info.key;
		NullableMouseInput aKeyMouse = cast(NullableMouseInput) info.keyDecolateMouse;
		JoyStick aJoystick = info.joystick;
		
		aMouse.enable();
		aKey.enable();
		aKeyMouse.enable();
		aJoystick.enable();

		aMouse.updateMark();
		aKey.updateMark();
		aKeyMouse.updateMark();

		aMouse.update();
		aKey.update();
		aKeyMouse.update();

		Color4ub colorOrg = info.screen.getColor4ub();
		int rtnVal = 0;
		try {

			info.screen.resetColor();
			m_dialog.onDraw(info.screen);
			m_dialog.onMove(info.screen);
			
			GUIButton[] bts = m_dialog.getButton();
			m_click = CLICK.NO_CLICK;
			for (int i = 0; i < bts.length; ++i) {
				if ( bts[i].isLClick() ) {
					m_click = cast(CLICK) i;
					info.yesnoClick = m_click;
					m_carsorHide = false;
					Log.print("CLICK %s", i);
					return 1;
				}
			}
			
			// このダイアログ以外すべてのマウス操作をキャンセル
			aMouse.disable();
			aKey.disable();
			aKeyMouse.disable();
			aJoystick.disable();
			return rtnVal;

		} catch (Exception e) {
			Log.printFatal("Exception %s#task() : [%s][%s]", super.toString(), e.toString, e.msg);
			throw e;
		} finally {
			info.screen.setColor(colorOrg);
		}

		return 0;
	}

	/// 占有しているメモリを解放する
	override void destroy() {
		m_dialog = null;

		Log.print("%s#destroy : destroyed.", super.toString());
	}
	
	/// クリックしたボタンのIDを取得する
	CLICK getClick() {
		return this.m_click;
	}
	
	/// タイプの設定
	void setType(TYPE type) {
		if (m_type != type) {
			m_type = type;
			init = false;
		}
	}
	/// タスクタイプの取得
	TYPE getType() {
		return m_type;
	}

	/// コンストラクタ
	this(MouseInput mouse) 
	in
	{
		assert( !(mouse is null ) );
	}
	body
	{
		this.m_mouse = mouse;
		m_type = TYPE.FINISH;
	}
private:
	/// ダイアログ定義ファイルのパス
	static final char[][] PROP_FILENAME = [
		"img/dialog/dialog_finish.txt",
		"img/dialog/dialog_overwrite.txt",
		"img/dialog/dialog_overwrite.txt",
		"",
		"img/dialog/dialog_load.txt",	// LOAD
		"img/dialog/dialog_seve.txt",	// SEVE
		"img/dialog/dialog_load_auto.txt",	// LOAD_AUTO
		"img/dialog/dialog_save_only.txt",	// SAVE_ONLY
		"",
	];
	
	static void updateMouse() {
	}
	
	static final char[] C_PROP_KEY_BUTTON_NM = "BUTTON_NM";
	static final char[] C_PROP_KEY_BUTTON_ACTIVE = "BUTTON_ACTIVE";
	static final char[] C_PROP_KEY_BUTTON_NON_ACTIVE = "BUTTON_NON_ACTIVE";
	static final char[] C_PROP_KEY_BUTTON_OX = "BUTTON_OX";
	static final char[] C_PROP_KEY_BUTTON_OY = "BUTTON_OY";

	/// 初期化処理
	void onInit() {
		// メモリー状況をプリント
		GameInfo.printMemoryState();

		m_mouse = info.keyDecolateMouse;
		m_key = info.key;
		m_dialog = DialogBox.createDialogBox(
						info.createDialogResources(),
						PROP_FILENAME[m_type],
						m_mouse,
						m_key,
						4);
						
		// もし、マウスカーソルがなければ、表示したほうがよいだろう
		m_carsorHide = m_mouse.isHide();
//		if (m_carsorHide) 
		{
			m_mouse.show();
		}
	}

	DialogBox m_dialog;
	MouseInput m_mouse;
	KeyInputBase m_key;
	GameInfo info;
	bool init;
	bool m_carsorHide;

	CLICK m_click;
	TYPE m_type;
}