//
//  FJNPersistentWindowController.h
//  FJNCoreData
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006-2008 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface FJNPersistentWindowController : NSWindowController
{
@private
    NSPersistentStoreCoordinator *_persistentStoreCoordinator;
    NSManagedObjectModel         *_managedObjectModel;
    NSManagedObjectContext       *_managedObjectContext;
	NSURL                        *_pStoreURL;
	NSString                     *_pStoreType;
}

#pragma mark Class methods
+ (void)reviewChangesAndQuitEnumeration:(BOOL)cont;

#pragma mark Initializing methods
- (id)initWithWindow:(NSWindow *)window storeDirectory:(NSString *)directory filename:(NSString *)filename type:(NSString *)type;
- (id)initWithWindowNibName:(NSString *)windowNibName storeDirectory:(NSString *)directory filename:(NSString *)filename type:(NSString *)type;
- (id)initWithWindowNibName:(NSString *)windowNibName owner:(id)owner storeDirectory:(NSString *)directory filename:(NSString *)filename type:(NSString *)type;
- (id)initWithWindowNibPath:(NSString *)windowNibPath owner:(id)owner storeDirectory:(NSString *)directory filename:(NSString *)filename type:(NSString *)type;

#pragma mark Accessor mthods
- (NSPersistentStoreCoordinator *)persistentStoreCoordinator;
- (NSManagedObjectModel *)managedObjectModel;
- (NSManagedObjectContext *)managedObjectContext;
- (NSURL *)URLForPersistentStore;

#pragma mark Action methods
- (IBAction)saveAction:sender;
- (IBAction)revertAction:(id)sender;

#pragma mark Methods implementing NSToolbarItemValidation protocol
- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)theItem;

@end
