//
//  NSCalendarDate+ICSSupport.h
//  iCal to KS2
//
//  Created by FUJIDANA on 05/05/23.
//  Copyright 2005 FUJIDANA. All rights reserved.
//
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import <Foundation/Foundation.h>

@interface NSCalendarDate (ICalendarSupport)

+ (id)dateWithICalendarDateString:(NSString *)string;
+ (id)dateWithICalendarDateTimeString:(NSString *)string timeZone:(NSTimeZone *)timeZone;
+ (id)dateWithICalendarDateTimeString:(NSString *)string timeZoneString:(NSString *)timeZoneString;
// + (id)dateWithYear:(int)year month:(unsigned)month weekOfMonth:(int)nth dayOfWeek:(unsigned)dayOfWeek hour:(unsigned)hour minute:(unsigned)minute second:(unsigned)second timeZone:(NSTimeZone *)timeZone;

- (NSCalendarDate *)dateByAddingDays:(int)day;
- (NSCalendarDate *)dateByAddingMonths:(int)months;
// - (NSCalendarDate *)dateByAddingYears:(int)years;

- (NSCalendarDate *)dateAtBeginningOfDay;
- (NSCalendarDate *)dateAtEndOfDay;
- (NSCalendarDate *)dateAtBeginningOfMonth;
- (NSCalendarDate *)dateAtEndOfMonth;

- (int)weekOfMonth;
- (int)reverseWeekOfMonth;

@end
