#!/bin/sh

#
# Variables
#
MODULE_NAME=kz_h8write
VERSION_NUMBER=$1
TAG_NAME="v$VERSION_NUMBER"
FILE_NAME="$MODULE_NAME-$TAG_NAME.tar.gz"
RELEASE_FILES="doc/ example/ src/"

GIT_STATUS=`git status`
GIT_TAG=`git tag`
STATUS_CHECK=`echo $GIT_STATUS | grep 'working directory clean' | wc -l`
TAG_CHECK=`echo $GIT_TAG | grep "$1" | wc -l`

#
# Status check
#
if [ "$VERSION_NUMBER" = "" ]
then
  echo "create-release.sh [version number]"
  exit
fi

if [ "$STATUS_CHECK" = "0" ]
then
  echo "Please check this working directory."
  echo "This working directory changes something."
  exit
fi

if [ ! "$TAG_CHECK" = "0" ]
then
  echo "The specified version already exists."
  exit
fi

#
# Create the release
#
echo '=========================================='
echo "MODULE :$MODULE_NAME"
echo "VERSION:$VERSION_NUMBER"
echo "FILE   :$FILE_NAME"
echo '=========================================='

git tag $TAG_NAME
tar cvfz $FILE_NAME $RELEASE_FILES

#
# Messages
#
echo "Please execute following command to fix the tag for the new release."
echo "  git push --tags  "

