/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers;

import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;

/**
 * @author UnAfraid
 * 
 * NPC          106     o[XfCP[L
 * |ACe    20314   o[XfC P[L pbN - oC^eB (capsuled_items)
 * |ACe    20320   o[XfC P[L - oC^eBF24Ԍ
 * |XL  22034-1 o[XfC P[L(20)
 * |BUFXL   22035-1 o[XfC P[L - o[XfC P[L̃oC^eBʁB ollāAoC^eB񕜂ĂԁB(20)
 * NPC          139     o[XfCP[L
 * |ACe    21169   т̃o[XfC Mtg {bNX (capsuled_items)
 * |ACe    21595   o[XfC P[L
 * |XL  22249-1 o[XfC P[L(20)
 * |BUFXL   22250-1 o[XfC P[L - o[XfC P[L̃oC^eBʁB5ԁAoC^eBۂĂԁB(5Ap[eB)
 */
public class BirthdayCake extends AbstractNpcAI
{
	private static final int BIRTHDAY_CAKE_24 = 106;
	private static final int BIRTHDAY_CAKE = 139;
	
	protected BirthdayCake(String name, String descr)
	{
		super(name, descr);
		addFirstTalkId(BIRTHDAY_CAKE_24, BIRTHDAY_CAKE);
		addSpawnId(BIRTHDAY_CAKE_24, BIRTHDAY_CAKE);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		addTask(npc);
		return super.onSpawn(npc);
	}
	
	private void addTask(L2Npc npc)
	{
		if (npc.isInsideZone(ZoneId.PEACE)) return;	//+[JOJO]
		
		final L2Skill skill;
		switch (npc.getNpcId())
		{
			case BIRTHDAY_CAKE_24:
			{
				skill = SkillTable.getInstance().getInfo(22035, 1);
				break;
			}
			case BIRTHDAY_CAKE:
			{
				if (npc.getSummoner() == null || !npc.getSummoner().isPlayer())
					return;
				skill = SkillTable.getInstance().getInfo(22250, 1);
				break;
			}
			default:
			{
				return;
			}
		}
		
		if (skill == null /*|| skill.getSkillType() == L2SkillType.NOTDONE*/) return;
		new BirthdayCakeAI(npc, skill);
	}
	
	protected class BirthdayCakeAI implements Runnable
	{
		private final L2Npc _npc;
		private final L2Skill _skill;				//+[JOJO]
		private final ScheduledFuture<?> _aiTask;	//+[JOJO]
		
		protected BirthdayCakeAI(L2Npc npc, L2Skill skill)
		{
			_npc = npc;
			_skill = skill;
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 3000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			
 //-[JOJO]	if (!_npc.isInsideZone(ZoneId.PEACE))
			{
				L2Skill skill = _skill;
				final int skillRadius = skill.getSkillRadius();
				switch (_npc.getNpcId())
				{
					case BIRTHDAY_CAKE_24:
					{
						for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
						{
							if (!player.isInsideRadius(_npc, skillRadius, true, true))
								continue;
							_skill.getEffects(_npc, player);
						}
						break;
					}
					case BIRTHDAY_CAKE:
					{
						final L2PcInstance player = _npc.getSummoner().getActingPlayer();
						if (!player.isInParty())
						{
							if (player.isInsideRadius(_npc, skillRadius, true, true))
							{
								skill.getEffects(_npc, player);
							}
						}
						else
						{
							for (L2PcInstance member : player.getParty().getMembers())
							{
								if ((member != null) && member.isInsideRadius(_npc, skillRadius, true, true))
								{
									skill.getEffects(_npc, member);
								}
							}
						}
						break;
					}
				}
			}
		}
	}
	
	public static void main(String[] args)
	{
		new BirthdayCake(BirthdayCake.class.getSimpleName(), "ai/npc");
	}
}
