/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.bypasshandlers;

import java.text.DateFormat;
import java.text.DecimalFormat;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.games.Lottery;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class Loto implements IBypassHandler
{
	private static final String[] COMMANDS =
	{
		"Loto"
	};
	
	@Override
	public boolean useBypass(String command, L2PcInstance activeChar, L2Character target)
	{
		if (!(target instanceof L2Npc))
		{
			return false;
		}
		
		int val = 0;
		try
		{
			val = Integer.parseInt(command.substring(5));
		}
		catch (IndexOutOfBoundsException ioobe)
		{
		}
		catch (NumberFormatException nfe)
		{
		}
		if (val == 0)
		{
			// new loto ticket
			for (int i = 0; i < 5; i++)
			{
				activeChar.setLoto(i, 0);
			}
		}
		showLotoWindow(activeChar, (L2Npc) target, val);
		
		return false;
	}
	
	/**
	 * Open a Loto window on client with the text of the L2NpcInstance.<BR>
	 * <BR>
	 * <B><U> Actions</U> :</B><BR>
	 * <BR>
	 * <li>Get the text of the selected HTML file in function of the npcId and of the page number</li> <li>Send a Server->Client NpcHtmlMessage containing the text of the L2NpcInstance to the L2PcInstance</li> <li>Send a Server->Client ActionFailed to the L2PcInstance in order to avoid that the
	 * client wait another packet</li><BR>
	 * @param player The L2PcInstance that talk with the L2NpcInstance
	 * @param npc L2Npc loto instance
	 * @param val The number of the page of the L2NpcInstance to display
	 */
	// 0 - first buy lottery ticket window
	// 1-20 - buttons
	// 21 - second buy lottery ticket window
	// 22 - selected ticket with 5 numbers
	// 23 - current lottery jackpot
	// 24 - Previous winning numbers/Prize claim
	// >24 - check lottery ticket by item object id
	public static final void showLotoWindow(L2PcInstance player, L2Npc npc, int val)
	{
		int npcId = npc.getTemplate().getNpcId();
		String filename;
		SystemMessage sm;
		NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
		
		if (val == 0) // 0 - first buy lottery ticket window
		{
			filename = npc.getHtmlPath(npcId, 1);
			html.setFile(player.getHtmlPrefix(), filename);
		}
		else if ((val >= 1) && (val <= 21)) // 1-20 - buttons, 21 - second buy lottery ticket window
		{
			if (!Lottery.getInstance().isStarted())
			{
				// tickets can't be sold
				player.sendPacket(SystemMessageId.NO_LOTTERY_TICKETS_CURRENT_SOLD);
				return;
			}
			if (!Lottery.getInstance().isSellableTickets())
			{
				// tickets can't be sold
				player.sendPacket(SystemMessageId.NO_LOTTERY_TICKETS_AVAILABLE);
				return;
			}
			
			filename = (npc.getHtmlPath(npcId, 5));
			html.setFile(player.getHtmlPrefix(), filename);
			
			int count = 0;
			int found = 0;
			// counting buttons and unsetting button if found
			for (int i = 0; i < 5; i++)
			{
				if (player.getLoto(i) == val)
				{
					// unsetting button
					player.setLoto(i, 0);
					found = 1;
				}
				else if (player.getLoto(i) > 0)
				{
					count++;
				}
			}
			
			// if not rearched limit 5 and not unseted value
			if ((count < 5) && (found == 0) && (val <= 20))
			{
				for (int i = 0; i < 5; i++)
				{
					if (player.getLoto(i) == 0)
					{
						player.setLoto(i, val);
						break;
					}
				}
			}
			
			// setting pusshed buttons
			count = 0;
			for (int i = 0; i < 5; i++)
			{
				if (player.getLoto(i) > 0)
				{
					count++;
					String button = String.valueOf(player.getLoto(i));
					if (player.getLoto(i) < 10)
					{
						button = "0" + button;
					}
					String search = "fore=\"L2UI.lottoNum" + button + "\" back=\"L2UI.lottoNum" + button + "a_check\"";
					String replace = "fore=\"L2UI.lottoNum" + button + "a_check\" back=\"L2UI.lottoNum" + button + "\"";
					html.replace(search, replace);
				}
			}
			
			//[JOJO]-------------------------------------------------
			// 30990-5.htm, 30991-5.htm, 30992-5.htm, 30993-5.htm, 30994-5.htm
			final String replace;
			if (count == 5)
				replace = "22\"><fstring>1000179</fstring>";	/*̔ԍőI|Your lucky numbers have been selected above.*/
			else
				replace = "0\"><fstring>1000170</fstring>";	/*߂|Return*/
			if (html.replace("0\">Return", replace) == 0
			 && html.replace("0\">߂", replace) == 0)
			{
				_log.warning(filename + "/" + replace + "/ can't replace.");
				Thread.dumpStack();
			}
			//-------------------------------------------------------
		}
		else if (val == 22) // 22 - selected ticket with 5 numbers
		{
			if (!Lottery.getInstance().isStarted())
			{
				// tickets can't be sold
				player.sendPacket(SystemMessageId.NO_LOTTERY_TICKETS_CURRENT_SOLD);
				return;
			}
			if (!Lottery.getInstance().isSellableTickets())
			{
				// tickets can't be sold
				player.sendPacket(SystemMessageId.NO_LOTTERY_TICKETS_AVAILABLE);
				return;
			}
			
			long price = Config.ALT_LOTTERY_TICKET_PRICE;
			int lotonumber = Lottery.getInstance().getId();
			int enchant = 0;
			int type2 = 0;
			
			for (int i = 0; i < 5; i++)
			{
				int num = player.getLoto(i);
				if (num == 0)
				{
					return;
				}
				
				if (num <= 16)
				{
					enchant |= 1 << (num - 1);
				}
				else
				{
					type2 |= 1 << (num - 16 - 1);
				}
			}
			if (player.getAdena() < price)
			{
				sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
				player.sendPacket(sm);
				return;
			}
			if (!player.reduceAdena("Loto", price, npc, true))
			{
				return;
			}
			Lottery.getInstance().increasePrize(price);
			
			sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
			sm.addItemName(4442);
			player.sendPacket(sm);
			
			L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), 4442);
			item.setCount(1);
			item.setCustomType1(lotonumber);
			item.setEnchantLevel(enchant);
			item.setCustomType2(type2);
			player.getInventory().addItem("Loto", item, player, npc);
			
			InventoryUpdate iu = new InventoryUpdate();
			iu.addItem(item);
			L2ItemInstance adenaupdate = player.getInventory().getItemByItemId(57);
			iu.addModifiedItem(adenaupdate);
			player.sendPacket(iu);
			
			filename = (npc.getHtmlPath(npcId, 6));
			html.setFile(player.getHtmlPrefix(), filename);
		}
		else if (val == 23) // 23 - current lottery jackpot
		{
			filename = (npc.getHtmlPath(npcId, 3));
			html.setFile(player.getHtmlPrefix(), filename);
		}
		else if (val == 24) // 24 - Previous winning numbers/Prize claim
		{
			filename = (npc.getHtmlPath(npcId, 4));
			html.setFile(player.getHtmlPrefix(), filename);
			
			int lotonumber = Lottery.getInstance().getId();
			StringBuilder message = new StringBuilder(2000);
			for (L2ItemInstance item : player.getInventory().getItems())
			{
				if (item == null)
				{
					continue;
				}
				if ((item.getItemId() == 4442) && (item.getCustomType1() < lotonumber))
				{
					message.append("<a action=\"bypass -h npc_%objectId%_Loto ").append(item.getObjectId()).append("\">").append(item.getCustomType1()).append("<fstring>1000172</fstring>");	/*F|Event Number*/
					int[] numbers = Lottery.getInstance().decodeNumbers(item.getEnchantLevel(), item.getCustomType2());
					for (int i = 0; i < 5; i++)
					{
						message.append(numbers[i]).append(' ');
					}
					long[] check = Lottery.getInstance().checkTicket(item);
					if (check[0] > 0)
					{
						switch ((int) check[0])
						{
							case 1:
								message.append("- <fstring>1000173</fstring> ");	/*1|1st Prize*/
								break;
							case 2:
								message.append("- <fstring>1000174</fstring> ");	/*2|2nd Prize*/
								break;
							case 3:
								message.append("- <fstring>1000175</fstring> ");	/*3|3th Prize*/
								break;
							case 4:
								message.append("- <fstring>1000176</fstring> ");	/*4|4th Prize*/
								break;
						}
						message.append(check[1]).append("&$469;");	/*Afi*/
					}
					message.append("</a><br>");
				}
			}
			if (message.length() == 0)
			{
				message.append("<fstring>1000177</fstring><br>");	/*I󂭂܂B|There has been no winning lottery ticket.*/
			}
			html.replace("%result%", message);
		}
		else if (val == 25) // 25 - lottery instructions
		{
			filename = (npc.getHtmlPath(npcId, 2));
			html.setFile(player.getHtmlPrefix(), filename);
		}
		else if (val > 25) // >25 - check lottery ticket by item object id
		{
			int lotonumber = Lottery.getInstance().getId();
			L2ItemInstance item = player.getInventory().getItemByObjectId(val);
			if ((item == null) || (item.getItemId() != 4442) || (item.getCustomType1() >= lotonumber))
			{
				return;
			}
			long[] check = Lottery.getInstance().checkTicket(item);
			
			sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
			sm.addItemName(4442);
			player.sendPacket(sm);
			
			long adena = check[1];
			if (adena > 0)
			{
				player.addAdena("Loto", adena, npc, true);
			}
			player.destroyItem("Loto", item, npc, false);
			return;
		}
		html.replace("%objectId%", npc.getObjectId());
		html.replace("%race%", Lottery.getInstance().getId());
		html.replace("%adena%", Lottery.getInstance().getPrize());
		html.replace("%ticket_price%", Config.ALT_LOTTERY_TICKET_PRICE);
		DecimalFormat dfRate = new DecimalFormat("0.#");
		html.replace("%prize5%", dfRate.format(Config.ALT_LOTTERY_5_NUMBER_RATE * 100));
		html.replace("%prize4%", dfRate.format(Config.ALT_LOTTERY_4_NUMBER_RATE * 100));
		html.replace("%prize3%", dfRate.format(Config.ALT_LOTTERY_3_NUMBER_RATE * 100));
		html.replace("%prize2%", Config.ALT_LOTTERY_2_AND_1_NUMBER_PRIZE);
		html.replace("%enddate%", DateFormat.getDateInstance().format(Lottery.getInstance().getEndDate()));
		player.sendPacket(html);
		
		// Send a Server->Client ActionFailed to the L2PcInstance in order to avoid that the client wait another packet
		player.sendPacket(ActionFailed.STATIC_PACKET);
	}
	
	@Override
	public String[] getBypassList()
	{
		return COMMANDS;
	}
}
