﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
s/\bAncient Adena\b/古代のアデナ/gi;

s/\b(The )*Sacrifice's Necropolis\b/生贄のネクロポリス/gi;		#(0)
s/\b(The )*Pilgrim's Necropolis\b/巡礼者のネクロポリス/gi;		#(6)
s/\b(The )*Worship's Necropolis\b/参拝者のネクロポリス/gi;		#(0)
s/\b(The )*Patriot's Necropolis\b/烈士のネクロポリス/gi;		#(6)
s/\b(The )*Devotion's Necropolis\b/苦行者のネクロポリス/gi;		#(0)
s/\b(The )*Martyrdom's Necropolis\b/殉教者のネクロポリス/gi;	#(0)
s/\b(The )*Saint's Necropolis\b/聖者のネクロポリス/gi;			#(6)
s/\b(The )*Disciple's Necropolis\b/使徒のネクロポリス/gi;		#(6)

s/\b(The )*Necropolis of (the )*Sacrifice\b/生贄のネクロポリス/gi;	#(6)
s/\b(The )*Necropolis of (the )*Pilgrim\b/巡礼者のネクロポリス/gi;	#(0)
s/\b(The )*Necropolis of (the )*Worship\b/参拝者のネクロポリス/gi;	#(6)
s/\b(The )*Necropolis of (the )*Patriot\b/烈士のネクロポリス/gi;	#(0)
s/\b(The )*Necropolis of (the )*Devotion\b/苦行者のネクロポリス/gi;	#(4)
s/\b(The )*Necropolis of (the )*Martyrdom\b/殉教者のネクロポリス/gi;	#(4)
s/\b(The )*Necropolis of (the )*Saint\b/聖者のネクロポリス/gi;		#(0)
s/\b(The )*Necropolis of (the )*Disciple\b/使徒のネクロポリス/gi;	#(0)

s/\b(The )*Catacomb of (the )*Heretic\b/異端者のカタコム/gi;		#(6)
s/\b(The )*Catacomb of (the )*Apostate\b/異教徒のカタコム/gi;		#(4)
s/\b(The )*Catacomb of (the )*Branded\b/烙印のカタコム/gi;			#(6)
s/\b(The )*Catacomb of (the )*Witch\b/魔導のカタコム/gi;			#(6)
s/\b(The )*Catacomb of (the )*Dark Omens\b/凶星のカタコム/gi;		#(6)
s/\b(The )*Catacomb of (the )*Forbidden Path\b/密界のカタコム/gi;	#(8)
#----------------------------------------------------------------------------
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
