## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/npcstring-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open TXT, '>:utf8', 'npcstring.txt'  or die $!;

<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//; s/\\\\n/\\n/g}
	my ($id,$string) = ($field[0],$field[1]);
	print "$id\r";

	print TXT "$id\t$string\n";
}
close TXT;
utime $mtime,$mtime,'npcstring.txt';

close CSV;
print "\n";
