﻿<?php
/**
 * Account manager file
 * @author Lauri Lüüs <mad@webpoint.ee> 
 * @version $Id: manager.php 12 2005-05-27 13:47:30Z madest $
 * @package AccountManager
 * @filesource
 */

/**
 * Main class file where all will sub to
 */
require('AccountManager.php');


/**
 * Account manager Class
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: manager.php 12 2005-05-27 13:47:30Z madest $
 * @package AccountManager
 */
class Manager extends Module
{
	/**
	 * Array of page contents
	 * @var array
	 */
	var $page; 

	/**
	 * Configuration array
	 * [sql] - Sql configuration
	 * [admin] - Array of manager admins
	 * [manager] - Manager specific settings
	 * @var array
	 */
	var $config;
	
	/**
	 * Loads template and starts content creation
	 */
	function Manager()
	{	
		
		$this->init();
		session_start();
		if($this->template = temp_load($this->config->manager['template_path'].'body.htm'))
		{
			$this->page['title'] = "アカウントマネージャー for L2j";
			$this->managePage();
				
			$this->output = $this->template;
		} else {
			$this->output = "Class:Bodyテンプレートがありません！";
		}
		echo $this->output;
	}
	
	/**
	 * Gets act from url and creates specific module object wich generates output
	 * wich will be put into html
	 */
	function managePage()
	{		
		if(isset($_GET['act']))
		{
			/**
			 * Page content Switch
			 */
			switch ($_GET['act']) {					
					case "search":	// Search
						$module = new Search();
						break;
					
					case "create":		// Account creation
						if($this->config->manager['account_creation'] == true)
						{
							$module = new Registration();
						} else {						
							$module = new Module();
							$module->output = "<font color=red>ゲームアカウントを作ることができません</font>";
						}
						break;
//-					case "activate":	// Account activation
//-						$module = new RegistActivate();
//-						break;
					
					case "account":		// Account profile
						$module = new AccountProfile();
						break;
										
					case "character":	// Character profile
						$module = new CharacterProfile();
						break;
					
					case "server":
						$module = new OnlinePlayers();
						break;
					default:			// No such act
						if($this->config->account_creation == true)
						{
							$module = new Registration();
						} else {							
							$module = new AccountProfile();
						}
						break;
				}	
		
		// First page(url with no params)
		} else {
			if($this->config->manager['account_creation']==true)
			{
				$module = new Registration();
			} else {							
				$module = new AccountProfile();
			}
		}
		
		// DEBUG - This will add development messages
		//$module->DEV_MESSAGES();
		
		$this->manageSearchPane();
		$this->page['accounts'] = account_count()."/".$this->config->manager['account_limit'];
		$this->page['content'] = $module->output;		
		$this->template = temp_subs($this->template, "page", $this->page);
	}
	
	/**
	 * Creates switch wich remembers radiobutton selection value
	 */
	function manageSearchPane()
	{
		$src_switch['account'] = "checked";
		$src_switch['character'] = "";
		// Search pane swich
		if(isset($_GET['act']))
		{
			if($_GET['act']=="search")
			{
				if(isset($_POST['s_type']))
				{
					if($_POST['s_type']=="account")
					{
						$src_switch['account'] = "checked";						
					} else {
						$src_switch['character'] = "checked";						
					}
				} elseif (isset($_POST['p_type'])) {
					if($_POST['p_type']=="account")
					{
						$src_switch['account'] = "checked";						
					} else {
						$src_switch['character'] = "checked";						
					}
				}				
			} 
		}
		$this->template = temp_subs($this->template, "search", $src_switch);	
	}
	
	/**
	 * Read config and try to connect to MySql
	 * abort all if no connection with database
	 */
	function init()
	{
		$this->config = new InitConfig();
		if(connection($this->config->sql['user'], $this->config->sql['password'], $this->config->sql['database'], $this->config->sql['host'])==false)
		{
			echo "<font color=red>MySQL: 現在未接続, 設定エラーです！</font>";
			die;			
		}		
	}
}
?>