/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Vector;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.Visitor;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Name;
import org.python.parser.ast.Suite;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.argumentsType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class ArgListCompiler
extends Visitor
implements PythonGrammarTreeConstants {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public exprType[] defaults = null;
    public Vector names = new Vector();
    public Vector fpnames = new Vector();
    public Vector init_code = new Vector();

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults = null;
        this.names.removeAllElements();
        this.init_code.removeAllElements();
    }

    public void appendInitCode(Suite suite) {
        int n = suite.body.length;
        Object[] objectArray = new stmtType[this.init_code.size() + n];
        this.init_code.copyInto(objectArray);
        System.arraycopy(suite.body, 0, objectArray, this.init_code.size(), n);
        suite.body = objectArray;
    }

    public exprType[] getDefaults() {
        return this.defaults;
    }

    public void visitArgs(argumentsType argumentsType2) throws Exception {
        int n;
        for (n = 0; n < argumentsType2.args.length; ++n) {
            String string = (String)this.visit(argumentsType2.args[n]);
            this.names.addElement(string);
            if (!(argumentsType2.args[n] instanceof Tuple)) continue;
            Assign assign = new Assign(new exprType[]{argumentsType2.args[n]}, new Name(string, 1, argumentsType2.args[n]), argumentsType2.args[n]);
            this.init_code.addElement(assign);
        }
        if (argumentsType2.vararg != null) {
            this.arglist = true;
            this.names.addElement(argumentsType2.vararg);
        }
        if (argumentsType2.kwarg != null) {
            this.keywordlist = true;
            this.names.addElement(argumentsType2.kwarg);
        }
        this.defaults = argumentsType2.defaults;
        for (n = 0; n < this.defaults.length; ++n) {
            if (this.defaults[n] != null) continue;
            throw new ParseException("non-default argument follows default argument", argumentsType2.args[argumentsType2.args.length - this.defaults.length + n]);
        }
    }

    public Object visitName(Name name) throws Exception {
        if (name.ctx != 2) {
            return null;
        }
        if (this.fpnames.contains(name.id)) {
            throw new ParseException("duplicate argument name found: " + name.id, name);
        }
        this.fpnames.addElement(name.id);
        return name.id;
    }

    public Object visitTuple(Tuple tuple) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n = tuple.elts.length;
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(this.visit(tuple.elts[i]));
            stringBuffer.append(", ");
        }
        stringBuffer.append(this.visit(tuple.elts[n - 1]));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

