/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class AbstractArray
implements Serializable {
    protected int capacity;
    protected int size;
    protected int modCountIncr;

    public AbstractArray(AbstractArray abstractArray) {
        this.capacity = abstractArray.capacity;
        this.size = abstractArray.size;
    }

    public AbstractArray(int n) {
        this.size = n;
        this.capacity = n;
    }

    public AbstractArray(Class clazz) {
        this(clazz, 10);
    }

    public AbstractArray(Class clazz, int[] nArray) {
        Object object = Array.newInstance(clazz, nArray);
        this.capacity = nArray[0];
        this.setArray(object);
    }

    public AbstractArray(Class clazz, int n) {
        Object object = Array.newInstance(clazz, n);
        this.capacity = Math.max(n, 10);
        this.setArray(object);
    }

    public void appendArray(Object object) {
        this.replaceSubArray(object, this.size);
    }

    public void clear() {
        this.modCountIncr = 0;
        if (this.size != 0) {
            this.modCountIncr = 1;
            this.clearRange(0, this.size);
            this.setSize(0);
        }
    }

    protected void clearRange(int n, int n2) {
        if (n >= n2 || n < 0 || n2 > this.size) {
            if (n == n2 && n >= 0 && n2 <= this.size) {
                return;
            }
            throw new ArrayIndexOutOfBoundsException("start and stop must follow: 0 <= start <= stop <= " + this.size + ", but found start= " + n + " and stop=" + n2);
        }
        this.clearRangeInternal(n, n2);
    }

    private void clearRangeInternal(int n, int n2) {
        Object object = this.getArray();
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                Arrays.fill((boolean[])object, n, n2, false);
            } else if (clazz == Character.TYPE) {
                Arrays.fill((char[])object, n, n2, '\u0000');
            } else if (clazz == Byte.TYPE) {
                Arrays.fill((byte[])object, n, n2, (byte)0);
            } else if (clazz == Short.TYPE) {
                Arrays.fill((short[])object, n, n2, (short)0);
            } else if (clazz == Integer.TYPE) {
                Arrays.fill((int[])object, n, n2, 0);
            } else if (clazz == Long.TYPE) {
                Arrays.fill((long[])object, n, n2, 0L);
            } else if (clazz == Float.TYPE) {
                Arrays.fill((float[])object, n, n2, 0.0f);
            } else if (clazz == Double.TYPE) {
                Arrays.fill((double[])object, n, n2, 0.0);
            }
        } else {
            Arrays.fill((Object[])object, n, n2, null);
        }
    }

    public Object copyArray() {
        Object object = Array.newInstance(this.getArray().getClass().getComponentType(), this.size);
        System.arraycopy(this.getArray(), 0, object, 0, this.size);
        return object;
    }

    protected void ensureCapacity(int n) {
        this.modCountIncr = 0;
        if (n > this.capacity) {
            this.modCountIncr = 1;
            int n2 = this.capacity * 2 + 1;
            n2 = n2 < n ? n : n2;
            this.setNewBase(n2);
            this.capacity = n2;
        }
    }

    protected int getAddIndex() {
        int n = this.size++;
        if (this.size > this.capacity) {
            this.ensureCapacity(this.size);
        }
        return n;
    }

    protected abstract Object getArray();

    protected boolean isEmpty() {
        return this.size == 0;
    }

    protected void makeInsertSpace(int n) {
        this.makeInsertSpace(n, 1);
    }

    protected void makeInsertSpace(int n, int n2) {
        this.modCountIncr = 0;
        if (n >= 0 && n <= this.size) {
            int n3 = this.size - n;
            this.size += n2;
            if (this.size > this.capacity) {
                this.ensureCapacity(this.size);
            }
            if (n < this.size - 1) {
                this.modCountIncr = 1;
                Object object = this.getArray();
                System.arraycopy(object, n, object, n + n2, n3);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException("Index must be between 0 and " + this.size + ", but was " + n);
        }
    }

    public void remove(int n) {
        if (n >= 0 && n < this.size) {
            --this.size;
            if (n < this.size) {
                Object object = this.getArray();
                System.arraycopy(object, n + 1, object, n, this.size - n);
                this.clearRangeInternal(this.size, this.size);
            }
        } else {
            if (this.size == 0) {
                throw new IllegalStateException("Cannot remove data from an empty array");
            }
            throw new IndexOutOfBoundsException("Index must be between 0 and " + (this.size - 1) + ", but was " + n);
        }
    }

    public void remove(int n, int n2) {
        if (n >= 0 && n2 <= this.size && n <= n2) {
            Object object = this.getArray();
            int n3 = n2 - n;
            if (n3 == 0) {
                return;
            }
            System.arraycopy(object, n2, object, n, this.size - n2);
            this.size -= n3;
            this.clearRangeInternal(this.size, this.size + n3 - 1);
            this.setArray(object);
            return;
        }
        throw new IndexOutOfBoundsException("start and stop must follow: 0 <= start <= stop <= " + (this.size - 1) + ", but found start= " + n + " and stop=" + n2);
    }

    public void replaceSubArray(Object object, int n) {
        int n2 = Array.getLength(object);
        this.replaceSubArray(n, Math.min(this.size, n + n2), object, 0, n2);
    }

    public void replaceSubArray(int n, int n2, Object object, int n3, int n4) {
        this.modCountIncr = 0;
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("'array' must be an array type");
        }
        int n5 = n2 - n;
        if (n < 0 || n5 < 0 || n2 > this.size) {
            String string = null;
            if (n < 0) {
                string = "thisStart < 0 (thisStart = " + n + ")";
            } else if (n5 < 0) {
                string = "thisStart > thistStop (thisStart = " + n + ", thisStop = " + n2 + ")";
            } else if (n2 > this.size) {
                string = "thisStop > size (thisStop = " + n2 + ", size = " + this.size + ")";
            } else {
                throw new InternalError("Incorrect validation logic");
            }
            throw new ArrayIndexOutOfBoundsException(string);
        }
        int n6 = Array.getLength(object);
        int n7 = n4 - n3;
        if (n3 < 0 || n7 < 0 || n4 > n6) {
            String string = null;
            if (n3 < 0) {
                string = "srcStart < 0 (srcStart = " + n3 + ")";
            } else if (n7 < 0) {
                string = "srcStart > srcStop (srcStart = " + n3 + ", srcStop = " + n4 + ")";
            } else if (n4 > n6) {
                string = "srcStop > srcArray length (srcStop = " + n4 + ", srcArray length = " + n6 + ")";
            } else {
                throw new InternalError("Incorrect validation logic");
            }
            throw new IllegalArgumentException("start, stop and array must follow:\n\t0 <= start <= stop <= array length\nBut found\n\t" + string);
        }
        int n8 = n7 - n5;
        if (n8 < 0) {
            this.remove(n2 + n8, n2);
        } else if (n8 > 0) {
            this.makeInsertSpace(n2, n8);
        }
        try {
            this.modCountIncr = 1;
            System.arraycopy(object, n3, this.getArray(), n, n7);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException("'ofArrayType' must be compatible with existing array type of " + this.getArray().getClass().getName() + "\tsee java.lang.Class.getName().");
        }
    }

    protected abstract void setArray(Object var1);

    private void setNewBase(int n) {
        this.modCountIncr = 1;
        Object object = this.getArray();
        Class<?> clazz = object.getClass().getComponentType();
        Object object2 = Array.newInstance(clazz, n);
        System.arraycopy(object, 0, object2, 0, this.capacity);
        this.setArray(object2);
    }

    public void setSize(int n) {
        if (n > this.capacity) {
            this.ensureCapacity(n);
        } else if (n < this.size) {
            this.clearRange(n, this.size);
        }
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Object object = this.getArray();
        Class<?> clazz = object.getClass().getComponentType();
        int n = this.size - 1;
        if (clazz.isPrimitive()) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(Array.get(object, i)).append(", ");
            }
            if (n >= 0) {
                stringBuffer.append(Array.get(object, n));
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(objectArray[i]).append(", ");
            }
            if (n >= 0) {
                stringBuffer.append(objectArray[n]);
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void trimToSize() {
        if (this.size < this.capacity) {
            this.setNewBase(this.size);
        }
    }

    public int getModCountIncr() {
        return this.modCountIncr;
    }
}

