package test;

import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;

public class TestFastIntObjectMapAndConcurrentHashMap
{
	private static ConcurrentHashMap<Integer, String> map1 = new ConcurrentHashMap<Integer, String>();
	private static IntObjectMap<String> map2 = new FastIntObjectMap<String>().shared();
	
	private static class Test implements Runnable
	{
		@Override
		public void run()
		{
			final int MAX = 100000;
			int[] keys = new int[MAX];
			int count = 0;
			
			for (int i = 0; i < MAX; i++)
			{
				if (Rnd.get(100) < 3)
				{
					int key = keys[Rnd.get(count)];
					map1.remove(key);
					map2.remove(key);
				}
				else
				{
					int key = Rnd.get(2000000000);
					String value = String.valueOf(key);
					map1.put(key, value);
					map2.put(key, value);
					keys[count++] = key;
				}
			}
		}
	}
	
	private static void check()
	{
		for (Entry<Integer, String> e : map1.entrySet())
		{
			int key = e.getKey();
			String value1 = e.getValue();
			String value2 = map2.get(key);
			if (value1 != value2)
				System.out.println(key + ": [" + value1 + "] != [" + value2 + "]");
		}
		System.out.println("map1.size() = " + map1.size());
		System.out.println("map2.size() = " + map2.size());
	}
	
	public static void main(String[] args) throws InterruptedException
	{
		Test a = new Test();
		Thread a1 = new Thread(a);
		Thread a2 = new Thread(a);
		Thread a3 = new Thread(a);
		Thread a4 = new Thread(a);
		Thread a5 = new Thread(a);
		Thread a6 = new Thread(a);
		Thread a7 = new Thread(a);
		Thread a8 = new Thread(a);
		
		a1.start();
		a2.start();
		a3.start();
		a4.start();
		a5.start();
		a6.start();
		a7.start();
		a8.start();
		
		a1.join();
		a2.join();
		a3.join();
		a4.join();
		a5.join();
		a6.join();
		a7.join();
		a8.join();
		
		check();
	}
}
