﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT, ':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0;
my @CC; my @DD;	#@IF DEBUG@#

&start('./');

if (@CC) {
	my $LogFile = UTF8(__FILE__);	#@IF DEBUG@#
	   $LogFile =~ s!\.[^.\/\\]*$!.log!;	#@IF DEBUG@#
	open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";	#@IF DEBUG@#
	my $i = 0; ++$i until $CC[$i];
	for (; $i <= $#CC; ++$i) {	#@IF DEBUG@#
		if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}	#@IF DEBUG@#
	}	#@IF DEBUG@#
	close LOG;	#@IF DEBUG@#
}

exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#
#2011/07/04 JOJO
#「～を買う」は「～を取引する」に改める。
#例外あり:
#・名品館 ～を買う○ ～を取引する×
#・ブレスレットやタリスマンを買う○ ～を取引する×
#・幻影兵器を買う○ ～を取引する×

s!(?<=<a action="bypass -h npc_%objectId%_multisell 300900001">).+?(?=</a>)!ブレスレットやタリスマンを買う!;
s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 003">).+?(?=</a>)!装備を交換する!;
s!(?<=<a action="bypass -h npc_%objectId%_BuyShadowItem">).+?(?=</a>)!幻影兵器を買う!;
s!(?<=<a action="bypass -h npc_%objectId%_TerritoryStatus">).+?(?=</a>)!領主、税率情報を見る!;

# Try - 試着 ファイター＆メイジ
s!>Try on Fighters? Equipment\.?<!>ファイター用の装備を試着する<!si;
s!>Try on Warriors? equipment\.?<!>ファイター用の装備を試着する<!si;
s!>Try on Wizards? Equipment\.?<!>メイジ用の装備を試着する<!si;
s!>Try on armor for Wizards\.?<!>メイジ用の装備を試着する<!si;
s!>Try on a Warrior weapon\.?<!>ファイター用の装備を試着する<!si;

# Buy/Sell/Refund
s!>Buy/Sell/Refund Common Items?\.?<!>量産型装備を取引する<!si;
s!>Buy/Sell/Refund Generals?\.?<!>消耗品と鉱物を取引する<!si;
s!>Buy/Sell/Refund Dyes?\.?<!>染料を取引する<!si;
s!>Buy/Sell/Refunds?\.?<!>装備を取引する<!si;#[62]TODO:

# Buy - 取引する ファイター＆メイジ
s!>Buy equipment for Fighters?\.?<!>ファイター用の装備を取引する<!si;
s!>Buy equipment for Wizards?\.?<!>メイジ用の装備を取引する<!si;
s!>Buy Fighters? Equipments?\.?<!>ファイター用の装備を取引する<!si;
s!>Buy Wizards? Equipments?\.?<!>メイジ用の装備を取引する<!si;
s!>Buy weapons for Wizards?\.?<!>メイジ用の装備を取引する<!si;
# Buy basic...
s!>Buy basic equipment for Warriors?\.?<!>ファイター用の量産型装備を取引する<!si;
s!>Buy basic-type accessory\.?<!>量産型アクセサリーを取引する<!si;
# Buy Common...
s!>Buy Fighters? Common Items?\.?<!>ファイター用の量産型装備を取引する<!si;
s!>Buy Wizards? Common Items?\.?<!>メイジ用の量産型装備を取引する<!si;
s!>Buy Common Items?\.?<!>量産型装備を取引する<!si;

# Buy - そのた雑貨
s!>Buy supplies? and minerals?\.?<!>消耗品と鉱物を取引する<!si;
s!>Buy items and minerals\.?<!>消耗品と鉱物を取引する<!si;
s!>Buy supplies\.?<!>消耗品を取引する<!si;
s!>Buy a ticket\.?<!>定期船の乗船券を取引する<!si;
s!>Buy dyes\.?<!>染料を取引する<!si;

# Trade - 取引する
s!>Trade consumables and minerals\.?<!>消耗品と鉱物を取引する<!si;
s!>Trade supplies and minerals\.?<!>消耗品と鉱物を取引する<!si;
s!>Trade Fighter equipment\.?<!>ファイター用の装備を取引する<!si;
s!>Trade Warrior equipment\.?<!>ファイター用の装備を取引する<!si;

s!>Trade Wizard equipment\.?<!>メイジ用の装備を取引する<!si;
s!>Trade accessories\.?<!>アクセサリーを取引する<!si;
s!>Trade supplies\.?<!>消耗品を取引する<!si;
s!>Trade\.?<!>取引する<!si;

# Trade basic...
s!>Trade basic equipment for Fighters\.?<!>ファイター用の量産型装備を取引する<!si;
s!>Trade basic equipment for Warriors\.?<!>ファイター用の量産型装備を取引する<!si;
s!>Trade basic equipment for Wizards\.?<!>メイジ用の量産型装備を取引する<!si;
s!>Trade a basic-type accessory\.?<!>量産型アクセサリーを取引する<!si;
s!>Trade a basic type accessory\.?<!>量産型アクセサリーを取引する<!si;
s!>Trade basic equipment\.?<!>量産型装備を取引する<!si;#[1]

s!>Buy\.?<!>取引する<!si;
s!>Quest\.?<!>クエスト<!;

# 補正
s!(_Buy \d+")>量産型装備を取引する<!$1>ファイター用の量産型装備を取引する<! if m/<body>ファイター用..商人/;
s!(_Buy \d+")>量産型装備を取引する<!$1>メイジ用の量産型装備を取引する<! if m/<body>メイジ用..商人/;
s!(_Buy \d+")>量産型装備を取引する<!$1>量産型アクセサリーを取引する<! if m/<body>アクセサリー商人/;
s!(_Buy \d+")>装備を取引する<!$1>アクセサリーを取引する<! if m/<body>アクセサリー商人/;
s!(_Buy \d+")>装備を取引する<!$1>消耗品と鉱物を取引する<! if m/<body>雑貨商人/;

# ****-1.htm
s!What would you like to purchase\?<br>!何をお求めですか？<br>!;
#
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
