/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers;

import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2Effect;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.model.skills.L2SkillType;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;

//@formatter:off
/**
 * @author JOJO
 * 
 * NPC          148     
 * |ACe    21875   Ηp̉ΑŐ - 30ԂŎgƕ΂܂B苗ȏ㗣ꂽꏊŕ΂Ɖ񕜃{[iXʂ܂B퓬nł͉񕜗͂オ܂Bg[hAhbvAj͂ł܂Blqɂւ̕ۊǂ͂ł܂B
 * |            1864    (30)
 * |XL  22305-1 Ώ
 * |BUFXL   22304-1 ΂̉ - ΂̉肪܂BHP񕜗͂80%ACP񕜗͂60%AMP񕜗͂40܂B
 */
public class Campfire extends AbstractNpcAI
{
	private static final int CAMPFIRE = 148;
	
	static final L2Skill CAMPFIRE_WARMTH = SkillTable.getInstance().getInfo(22304, 1);
	
	private Campfire(int id, String name, String descr)
	{
		super(id, name, descr);
		addFirstTalkId(CAMPFIRE);
		addSpawnId(CAMPFIRE);
		if (CAMPFIRE_WARMTH.getSkillType() == L2SkillType.NOTDONE) throw new RuntimeException();
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		npc.setShowSummonAnimation(false);
		
		if (ZoneManager.getInstance().getZone(npc, L2TownZone.class) == null
	  /* && ZoneManager.getInstance().getZone(npc, L2****Zone.class) != null*/) //TODO: "퓬nł͉񕜗͂オ܂B"
		{
			new CampfireAI(npc);
		}
		return null;
	}
	
	protected class CampfireAI implements Runnable
	{
		private final L2Npc _npc;
		private final ScheduledFuture<?> _aiTask;
		
		protected CampfireAI(L2Npc npc)
		{
			_npc = npc;
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 3000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			
			if (_npc.getKnownList().getKnownPlayers().size() == 0)
				return;
			
			final int skillRadius = CAMPFIRE_WARMTH.getAffectRange();
			for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
			{
				if (player.isInvul())
					continue;
				if (player.isMovementDisabled())
					continue;
				if (player.getPkKills() > 5)
					continue;
				if (!player.isInsideRadius(_npc, skillRadius, true, true))
					continue;
				if (player.getCurrentHp() < player.getMaxHp()
				 || player.getCurrentCp() < player.getMaxCp()
				 || player.getCurrentMp() < player.getMaxMp())
				{
					handleEffect(player, CAMPFIRE_WARMTH);
				}
			}
		}
		
		private void handleEffect(L2PcInstance player, L2Skill _skill)
		{
			if (! doesStack(player, _skill))
				_skill.getEffects(player, player);
		}
		
		private boolean doesStack(L2PcInstance player, L2Skill checkSkill)
		{
			AbnormalType type = checkSkill.getAbnormalType();
			for (L2Effect e : player.getAllEffects())
				if (e.getSkill().getAbnormalType() == type)
					return true;
			return false;
		}
	}
	
	public static void main(String[] args)
	{
		new Campfire(-1, "ai/npc/Campfire", "");
	}
}
