/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.lang.ByteUtils;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.PoolConfig;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.encounter.EncounterCounter;
import com.mchange.v2.encounter.EqualityEncounterCounter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.sql.SqlUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;

public final class C3P0ImplUtils {
    private static final boolean CONDITIONAL_LONG_TOKENS = false;
    static final MLogger logger = MLog.getLogger(C3P0ImplUtils.class);
    public static final DbAuth NULL_AUTH = new DbAuth(null, null);
    public static final Object[] NOARGS = new Object[0];
    private static final EncounterCounter ID_TOKEN_COUNTER = new EqualityEncounterCounter();
    public static final String VMID_PROPKEY = "com.mchange.v2.c3p0.VMID";
    private static final String VMID_PFX;
    static String connectionTesterClassName;
    static ConnectionTester cachedTester;
    private static final String HASM_HEADER = "HexAsciiSerializedMap";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateVmId() {
        FilterOutputStream dos = null;
        FilterInputStream dis = null;
        try {
            SecureRandom srand = new SecureRandom();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            try {
                dos.write(InetAddress.getLocalHost().getAddress());
            }
            catch (Exception e) {
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "Failed to get local InetAddress for VMID. This is unlikely to matter. At all. We'll add some extra randomness", e);
                }
                ((DataOutputStream)dos).write(srand.nextInt());
            }
            ((DataOutputStream)dos).writeLong(System.currentTimeMillis());
            ((DataOutputStream)dos).write(srand.nextInt());
            int remainder = baos.size() % 4;
            if (remainder > 0) {
                int pad = 4 - remainder;
                byte[] pad_bytes = new byte[pad];
                srand.nextBytes(pad_bytes);
                dos.write(pad_bytes);
            }
            StringBuffer sb = new StringBuffer(32);
            byte[] vmid_bytes = baos.toByteArray();
            dis = new DataInputStream(new ByteArrayInputStream(vmid_bytes));
            int num_ints = vmid_bytes.length / 4;
            for (int i = 0; i < num_ints; ++i) {
                int signed = ((DataInputStream)dis).readInt();
                long unsigned = (long)signed & 0xFFFFFFFFL;
                sb.append(Long.toString(unsigned, 36));
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Bizarro! IOException while reading/writing from ByteArray-based streams? We're skipping the VMID thing. It almost certainly doesn't matter, but please report the error.", e);
            }
            String string = "";
            return string;
        }
        finally {
            try {
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException e) {
                logger.log(MLevel.WARNING, "Huh? Exception close()ing a byte-array bound OutputStream.", e);
            }
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException e) {
                logger.log(MLevel.WARNING, "Huh? Exception close()ing a byte-array bound IntputStream.", e);
            }
        }
    }

    public static String allocateIdentityToken(Object o) {
        long count;
        if (o == null) {
            return null;
        }
        String shortIdToken = Integer.toString(System.identityHashCode(o), 16);
        StringBuffer sb = new StringBuffer(128);
        sb.append(VMID_PFX);
        if (ID_TOKEN_COUNTER != null && (count = ID_TOKEN_COUNTER.encounter(shortIdToken)) > 0L) {
            sb.append(shortIdToken);
            sb.append('#');
            sb.append(count);
        } else {
            sb.append(shortIdToken);
        }
        String out = sb.toString().intern();
        return out;
    }

    public static DbAuth findAuth(Object o) throws SQLException {
        if (o == null) {
            return NULL_AUTH;
        }
        String user = null;
        String password = null;
        String overrideDefaultUser = null;
        String overrideDefaultPassword = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                Method readMethod;
                Class<?> propCl = pd.getPropertyType();
                String propName = pd.getName();
                if (propCl != String.class || (readMethod = pd.getReadMethod()) == null) continue;
                Object propVal = readMethod.invoke(o, NOARGS);
                String value = (String)propVal;
                if ("user".equals(propName)) {
                    user = value;
                    continue;
                }
                if ("password".equals(propName)) {
                    password = value;
                    continue;
                }
                if ("overrideDefaultUser".equals(propName)) {
                    overrideDefaultUser = value;
                    continue;
                }
                if (!"overrideDefaultPassword".equals(propName)) continue;
                overrideDefaultPassword = value;
            }
            if (overrideDefaultUser != null) {
                return new DbAuth(overrideDefaultUser, overrideDefaultPassword);
            }
            if (user != null) {
                return new DbAuth(user, password);
            }
            return NULL_AUTH;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "An exception occurred while trying to extract the default authentification info from a bean.", e);
            }
            throw SqlUtils.toSQLException(e);
        }
    }

    static void resetTxnState(Connection pCon, boolean forceIgnoreUnresolvedTransactions, boolean autoCommitOnClose, boolean txnKnownResolved) throws SQLException {
        if (!forceIgnoreUnresolvedTransactions && !pCon.getAutoCommit()) {
            if (!autoCommitOnClose && !txnKnownResolved) {
                pCon.rollback();
            }
            pCon.setAutoCommit(true);
        }
    }

    public static synchronized ConnectionTester defaultConnectionTester() {
        String dfltCxnTesterClassName = PoolConfig.defaultConnectionTesterClassName();
        if (connectionTesterClassName != null && connectionTesterClassName.equals(dfltCxnTesterClassName)) {
            return cachedTester;
        }
        try {
            cachedTester = (ConnectionTester)Class.forName(dfltCxnTesterClassName).newInstance();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Could not load ConnectionTester " + dfltCxnTesterClassName + ", using built in default.", e);
            }
            cachedTester = C3P0Defaults.connectionTester();
            connectionTesterClassName = cachedTester.getClass().getName();
        }
        return cachedTester;
    }

    public static boolean supportsMethod(Object target, String mname, Class[] argTypes) {
        try {
            return target.getClass().getMethod(mname, argTypes) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "We were denied access in a check of whether " + target + " supports method " + mname + ". Prob means external clients have no access, returning false.", e);
            }
            return false;
        }
    }

    public static String createUserOverridesAsString(Map userOverrides) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(HASM_HEADER);
        sb.append('[');
        sb.append(ByteUtils.toHexAscii(SerializableUtils.toByteArray(userOverrides)));
        sb.append(']');
        return sb.toString();
    }

    public static Map parseUserOverridesAsString(String userOverridesAsString) throws IOException, ClassNotFoundException {
        if (userOverridesAsString != null) {
            String hexAscii = userOverridesAsString.substring(HASM_HEADER.length() + 1, userOverridesAsString.length() - 1);
            byte[] serBytes = ByteUtils.fromHexAscii(hexAscii);
            return Collections.unmodifiableMap((Map)SerializableUtils.fromByteArray(serBytes));
        }
        return Collections.EMPTY_MAP;
    }

    private C3P0ImplUtils() {
    }

    static {
        String vmid = MultiPropertiesConfig.readVmConfig().getProperty(VMID_PROPKEY);
        VMID_PFX = vmid == null || (vmid = vmid.trim()).equals("") || vmid.equals("AUTO") ? C3P0ImplUtils.generateVmId() + '|' : (vmid.equals("NONE") ? "" : vmid + "|");
        connectionTesterClassName = null;
        cachedTester = null;
    }
}

