/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import static com.l2jserver.gameserver.ai.CtrlIntention.AI_INTENTION_ATTACK;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.util.Util;

/*public*/ final class L2AttackableAISuper extends L2AttackableAIScript
{
	/**
	 * L2AttackableAIScript̕sꎞIɉ}u邽߂̃NX.<BR>
	 * <BR>
	 * L2AttackableAIScript̔hNX(:Anthras.javaACore.java ȂǁAextends L2AttackableAIScript ĂAIXNvgׂ)
	 * Cxg̖ return super.onKill() (onSkillSeeAonFactionCallAonAggroRangeEnterAonSpawnAonAttackl) ƂĂӏׂ͂Č.
	 * ȂȂ΁AL2AttackableAIScriptMonKillCxgɓo^ĂACxg쓮ƔhNX̃R[ƂŏdĂ܂.
	 * hNX return null ɂׂł.<BR>
	 * AIXNvĝ͊ȒPAcœ`FbNȂ̂ŁAɌɖ߂悤Ả}uNXpӂ.
	 * <BR>
	 * <DEL>Overarching</DEL> Superclass for all mob AI
	 * @author JOJO -- L2AttackableAIScript I[o[Ch Cxĝ݈z
	 */
	public L2AttackableAISuper (int questId, String name, String descr)
	{
		super(questId, name, descr);
	}
	
	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		if (caster == null)
		{
			return null;
		}
		
		L2Attackable attackable = (L2Attackable)npc;
		
		int skillAggroPoints = skill.getAggroPoints();
		
		if (caster.getPet() != null)
		{
			if (targets.length == 1 && Util.contains(targets, caster.getPet()))
				skillAggroPoints = 0;
		}
		
		if (skillAggroPoints > 0)
		{
			if ( attackable.hasAI() && (attackable.getAI().getIntention() == AI_INTENTION_ATTACK))
			{
				L2Object npcTarget = attackable.getTarget();
				for (L2Object skillTarget : targets)
				{
					if (npcTarget == skillTarget || npc == skillTarget)
					{
						L2Character originalCaster = isPet? caster.getPet(): caster;
						attackable.addDamageHate(originalCaster, 0, (skillAggroPoints*150)/(attackable.getLevel()+7));
					}
				}
			}
		}
		
		return null;
	}
	
	@Override
	public String onFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isPet)
	{
		if(attacker == null)
			return null;
		
		L2Character originalAttackTarget = (isPet? attacker.getPet(): attacker);
		if ( attacker.isInParty()
				&& attacker.getParty().isInDimensionalRift())
		{
			byte riftType = attacker.getParty().getDimensionalRift().getType();
			byte riftRoom = attacker.getParty().getDimensionalRift().getCurrentRoom();
			
			if (caller instanceof L2RiftInvaderInstance
					&& !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(npc.getX(), npc.getY(), npc.getZ()))
			{
				return null;
			}
		}
		
		// By default, when a faction member calls for help, attack the caller's attacker.
		// Notify the AI with EVT_AGGRESSION
		npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, originalAttackTarget, 1);
		
		return null;
	}
	
	@Override
	public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isPet)
	{
		if (player == null)
			return null;
		
		L2Character target = isPet ? player.getPet() : player;
		
		((L2Attackable) npc).addDamageHate(target, 0, 1);
		
		// Set the intention to the L2Attackable to AI_INTENTION_ACTIVE
		if (npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE)
			npc.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
		return null;
	}
	
	@Override
	public String onSpawn (L2Npc npc)
	{
		return null;
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		if (attacker != null)
		{
			L2Attackable attackable = (L2Attackable)npc;
			
			L2Character originalAttacker = isPet? attacker.getPet(): attacker;
			attackable.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, originalAttacker);
			attackable.addDamageHate(originalAttacker, damage, (damage*100)/(attackable.getLevel()+7));
		}
		return null;
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		if (npc instanceof L2MonsterInstance)
		{
			final L2MonsterInstance mob = (L2MonsterInstance)npc;
			
			L2MonsterInstance master = mob.getLeader();
			if (master != null)
			{
				final int MINIONS_RESPAWN_TIME = Config.MINIONS_RESPAWN_TIME.get(mob.getNpcId());
				final int respawnTime = MINIONS_RESPAWN_TIME > 0 ? MINIONS_RESPAWN_TIME * 1000 : -1;
				master.getMinionList().onMinionDie(mob, respawnTime);
			}

			if (mob.hasMinions())
				mob.getMinionList().onMasterDie(false);
		}
		return null;
	}
}