/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.voicedcommandhandlers;

import com.l2jserver.gameserver.handler.IVoicedCommandHandler;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

/**
 * @author JOJO
 */
public class GmSwitch implements IVoicedCommandHandler
{
	private static final String[] _voicedCommands = { "gm" };
	
	/**
	 * 
	 * @see com.l2jserver.gameserver.handler.IVoicedCommandHandler#useVoicedCommand(java.lang.String, com.l2jserver.gameserver.model.actor.instance.L2PcInstance, java.lang.String)
	 */
	@Override
	public boolean useVoicedCommand(String command, L2PcInstance activeChar, String target)
	{
		if (activeChar.getL2AccessLevel().isGm())
		{
			if (target == null)
				activeChar.setGmEnable(!activeChar.getGmEnable());
			else if (target.equals("on"))
				activeChar.setGmEnable(true);
			else if (target.equals("off"))
				activeChar.setGmEnable(false);
			else {
				activeChar.sendMessage("Usage: .gm [on|off]");
				return false;
			}
			L2AccessLevel aa = activeChar.getAccessLevel();
			activeChar.sendMessage(aa.isGm() ? "You are GM now." : "You no longer have GM status.");
			activeChar.getAppearance().setNameColor(aa.getNameColor());
		//	activeChar.getAppearance().setTitleColor(aa.getTitleColor());
			activeChar.broadcastUserInfo();
		}
		return true;
	}
	
	/**
	 * 
	 * @see com.l2jserver.gameserver.handler.IVoicedCommandHandler#getVoicedCommandList()
	 */
	@Override
	public String[] getVoicedCommandList()
	{
		return _voicedCommands;
	}
}