﻿<?php
/**
 * Login panel file
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: LoginPanel.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 * @filesource
 */

/**
 * Login panel module
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: LoginPanel.php 8 2005-05-25 22:19:23Z madest $
 * @package AccountManager
 */
class LoginPanel extends Module
{
	/**
	 * Account object
	 */
	var $account;
	
	/**
	 * Logs user in if correct login and password
	 */
	function LoginPanel()
	{
		$this->Module();
		if(!isset($_POST['login']) || !isset($_POST['password']))
		{
			$loginScreen = $this->login_screen("?act=account", "アカウント管理");	
		} else {
			$this->account = new account($_POST['login'], $_POST['password']);
			$this->account->get();
			if($this->account->auth() == true)
			{
				if($this->account->is_banned() != true)
				{
					# * Dont know what im doing here (-.-) but tring to make it unreadable to others too
					# so it could be secure :P
					
					unset($_SESSION);
					session_destroy();
					session_start();
					
					$_SESSION['sess_id'] = session_id();
					$_SESSION['login'] = $this->account->login;
					$_SESSION['acObj'] = $this->account;
					$_SESSION['logged'] = true;										
					$_SESSION['client_ip'] = get_ip();
				
					if( $_SESSION['acObj']->is_admin() == true )
					{
						$user_level = "manager admin";
					} else {
						$user_level = "default user";
					}
					$this->write_log("SESSION START: '{$this->account->login}' - {$user_level} ");					
					
				} else {
					$this->write_log("LOGIN FAILED: '{$this->account->login}'");
					$this->output = "<font color=red>アカウントは削除されています</font>";
				}
			} else {
				$this->write_log("LOGIN FAILED: '{$this->account->login}'");
				$this->output = "<font color=red>アカウントまたはパスワードが違います。</font>";			
			}
		}
	}
	
	/** Constructor loads template and starts content creation
	 * @param string url to post variables
	 * @param string loginscreen title
	 */
	function login_screen($action, $title)
	{			
		$this->template = temp_load($this->config->manager['template_path'].'login_panel.htm');				
		$this->fill['login'] = "";
		$this->fill['action'] = $action;
		$this->fill['title'] = $title;		
		
		$this->output = temp_subs($this->template, "fill", $this->fill);	
	}
	
	/**
	 * Failed login - changes output
	 * @param string url to post variables
	 * @param string loginscreen title
	 */
	function failed($login)
	{
		$this->fill['login'] = $login;
		$this->output = temp_subs($this->template, "fill", $this->fill);
	}
	
	/**
	 * Log out current lgged user
	 */
	function logOut()
	{
		if (isset($_SESSION)) {
			$login = $_SESSION['login'];	
		} else {
			$login = "";
		}
		unset($_SESSION);		
		session_destroy();
		session_start();
		$this->write_log("SESSION END: '{$login}' - Logged out");
	}
}
?>