## Active Perl 5.8.8
# 注意>DBD-mysql を 4.005 以上にアップデートしてください。
# 注意>Jcode も必要です。
# 注意>やりかた: ppm install DBD-mysql
# 注意>やりかた: ppm install Jcode

# *.htm 中のスキル名を一括して日本語化する
# fortress/support*.htm 編

use utf8;
use strict;
use warnings;
use Encode;
use DBI;
use Jcode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('build/dist/game/data/html/fortress/', 'support1.htm');
&start('build/dist/game/data/html/fortress/', 'support2.htm');

close LOG;
exit 0;

sub start {
	my ($subDir, $fileName) = @_;

	my $filePath = $subDir.$fileName;

	my $outPath = $filePath;
	   $outPath .= '.text' if $DEBUG;

	print "  $filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $original = $text;

	my $UPDATE = 0;
	while ($text =~ m!<a action="bypass -h npc_%objectId%_support (\d+) (\d+)">(.+?)</a>!g) {
		# <a action="bypass -h npc_%objectId%_support 4342 2">Wind Walk Lv.2</a><br1>
		my $id = $1;
		my $level = $2;
		my $name_en = $3;

		my $name_jp = &getName($id, $level);
		next unless $name_jp;
		$name_jp .= " Lv." . $level;
		next if $name_jp eq $name_en;

		$text =~ s!(?<=<a action="bypass -h npc_%objectId%_support $id $level">).+?(?=</a>)!$name_jp!;

		my $i = &minidiff($text, $original) unless $UPDATE;
		print  '+',$outPath,"(",$i,")\n" unless $UPDATE;
		print     "\t[",$name_en,"]\n";
		print     "\t[",$name_jp,"]\n";
		print LOG  $outPath,"(",$i,")\n" unless $UPDATE;
		print LOG "\t[",$name_en,"]\n";
		print LOG "\t[",$name_jp,"]\n";

		$UPDATE = 1;
	}

	if ($UPDATE) {
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub getName {
	my ($id,$level) = @_;

	my $sth;
	if ($level) {
		my $sql = "SELECT name FROM skillname_ja WHERE id=? AND level=?";
		$sth = $db->prepare($sql);
		$sth->execute($id,$level) or die DBI::errstr;
	} else {
		my $sql = "SELECT name FROM skillname_ja WHERE id=? LIMIT 0,1";
		$sth = $db->prepare($sql);
		$sth->execute($id) or die DBI::errstr;
	}

	$sth->bind_columns(undef, \(my($N_name))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_name;
	return Encode::decode_utf8(Jcode->new($N_name, 'utf8')->z2h->utf8)
#	return $N_name;
}

sub minidiff {
	my ($textA, $textB) = @_;

	$textA =~ s/^\x{FEFF}//;
	$textB =~ s/^\x{FEFF}//;
	my @A = split /\n/,$textA;
	my @B = split /\n/,$textB;
	my $min = $#A <= $#B ? $#A : $#B;
	for (my $i=0; $i <=$min; ++$i) {
		return $i+1 if $A[$i] ne $B[$i];
	}
	return 0;
}
