﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.html?$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;
#----------------------------------------------------------------------------
# ～ Town Square
s!\bAden Town Square\b!アデン城の村 広場!gi;
s!\bDion Town Square\b!ディオン城の村 広場!gi;
s!\bGiran Town Square\b!ギラン城の村 広場!gi;
s!\bGludio Town Square\b!グルーディオ城の村 広場!gi;
s!\bGoddard Town Square\b!ゴダード城の村 広場!gi;
s!\bHeine Town Square\b!水上都市ハイネス 広場!gi;
s!\bOren Town Square\b!オーレン城の村 広場!gi;
s!\bRune Town Square\b!ルウン城の村 広場!gi;
s!\bSchuttgart Town Square\b!シュチュッツガルト城の村 広場!gi;

# Front of the ～ Castle Gate
s!\bFront Of Aden Castle\b!アデン城門前!gi;
s!\bFront Of Dion Castle\b!ディオン城門前!gi;
s!\bFront Of Giran Castle\b!ギラン城門前!gi;
s!\bFront of the Gludio Castle\b!グルーディオ城門前!gi;
s!\bFront Of Goddard Castle\b!ゴダード城門前!gi;
s!\bFront Of Innadril Castle\b!インナドリル城門前!gi;
s!\bFront Of Oren Castle\b!オーレン城門前!gi;
s!\bFront Of Rune Castle\b!ルウン城門前!gi;
s!\bFront Of Schuttgart Castle\b!シュチュッツガルト城門前!gi;

# Front of the ～ Fortress
s!\bFront of the Aaru Fortress\b!草原の境界要塞前!gi;	#静寂の草原
s!\bFront of the Antharas' Fortress\b!地竜の境界要塞前!gi;	#リザードプレイン
s!\bFront of the Archaic Fortress\b!遺跡要塞前!gi;	#空中列車の遺跡
s!\bFront of the Bayou Fortress\b!盆地要塞前!gi;	#巨人たちの洞窟
s!\bFront of the Borderland Fortress\b!アウトポスト要塞前!gi;	#ケトラー オーク アウトポスト
s!\bFront of the Cloud Mountain Fortress\b!霧の山脈境界要塞前!gi;	#ダーク エルフの森
s!\bFront of the Demon Fortress\b!死霊の境界要塞前!gi;	#死霊の関門
s!\bFront of the Dragonspine Fortress\b!ドラゴンスパイン境界要塞前!gi;	#クルマの塔
s!\bFront of the Floran Fortress\b!フローラン境界要塞前!gi;	#フローラン開拓地
s!\bFront of the Hive Fortress\b!ハイヴ要塞前!gi;	#ビーハイヴ
s!\bFront of the Hunter's Fortress\b!猟師の境界要塞前!gi;	#猟師の村
s!\bFront of the Ivory Fortress\b!象牙の塔要塞前!gi;	#象牙の塔
s!\bFront of the Marshland Fortress\b!沼地帯要塞前!gi;	#悲鳴の沼
s!\bFront of the Monastic Fortress\b!聖者の境界要塞前!gi;	#聖者の渓谷
s!\bFront of the Narsell Fortress\b!湖の要塞前!gi;	#ナルセル湖
s!\bFront of the Shanty Fortress\b!露営地要塞前!gi;	#捨てられた露営地
s!\bFront of the Southern Fortress\b!グルーディオ南部要塞前!gi;	#ランク リザードマン生息地
s!\bFront of the Swamp Fortress\b!沼地帯要塞前!gi;	#悲鳴の沼
s!\bFront of the Tanor Fortress\b!タノール境界要塞前!gi;	#タノール渓谷
s!\bFront of the Valley Fortress\b!渓谷要塞前!gi;	#ドラゴンバレー
s!\bFront of the Western Fortress\b!西部国境要塞前!gi;	#国境守備隊
s!\bFront of the White Sands Fortress\b!白浜要塞前!gi;	#クロコダイルの白浜

# 上記以外は L2J_DataPack/build_ja/build_teleports_ja.pl にて処理。

#----------------------------------------------------------------------------
s/>Open the Outer Gates</>外郭門を開く</;
s/>Close the Outer Gates</>外郭門を閉じる</;
s/>Open the Inner Gates</>内郭門を開く</;
s/>Close the Inner Gates</>内郭門を閉じる</;
s/>Open the North Inner Gate</>北の内郭門を開く</;
s/>Close the North Inner Gate</>北の内郭門を閉じる</;
s/>Open the West Inner Gate</>西の内郭門を開く</;
s/>Close the West Inner Gate</>西の内郭門を閉じる</;
s/>Open the East Inner Gate</>東の内郭門を開く</;
s/>Close the East Inner Gate</>東の内郭門を閉じる</;

s/>Open the Throne Room Gates</>ホール入口を開く</;		#〓仮〓
s/>Close the Throne Room Gates</>ホール入口を閉じる</;	#〓仮〓
s/>Open the Throne Room Gate</>ホール入口を開く</;		#〓仮〓
s/>Close the Throne Room Gate</>ホール入口を閉じる</;	#〓仮〓

s/>Open the East Inner Hall Gates</>東のホール入口を開く</;
s/>Close the East Inner Hall Gates</>東のホール入口を閉じる</;
s/>Open the West Inner Hall Gates</>西のホール入口を開く</;
s/>Close the West Inner Hall Gates</>西のホール入口を閉じる</;

s/>Open the Terrace Gates</>テラス入口を開く</;
s/>Close the Terrace Gates</>テラス入口を閉じる</;
s/>Open the East Terrace Gate</>東のテラス入口を開く</;
s/>Close the East Terrace Gate</>東のテラス入口を閉じる</;
s/>Open the West Terrace Gate</>西のテラス入口を開く</;
s/>Close the West Terrace Gate</>西のテラス入口を閉じる</;

s/>Open All Castle Gates</>城門をすべて開く</;
s/>Close All Castle Gates</>城門をすべて閉じる</;
s/>Open all Other Walls or Gates</>城門と城壁をすべて開く</;	#〓仮〓
s/>Close all Other Walls or Gates</>城門と城壁をすべて閉じる</;	#〓仮〓

#----------------------------------------------------------------------------
	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
