﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT, ':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0;
my @CC;	#@IF DEBUG@#

&start('./');

if (@CC) {
	my $LogFile = UTF8(__FILE__);	#@IF DEBUG@#
	   $LogFile =~ s!\.[^.\/\\]*$!.log!;	#@IF DEBUG@#
	open LOG, '>:utf8', FS($LogFile) or die "'$LogFile' $!";	#@IF DEBUG@#
	my $i = 0; ++$i until $CC[$i];
	for (; $i <= $#CC; ++$i) {	#@IF DEBUG@#
		if ($CC[$i]) {print LOG __FILE__,"($i)\t",$CC[$i],"\n"}	#@IF DEBUG@#
		else         {print LOG __FILE__,"($i)\t",0,"\n"}	#@IF DEBUG@#
	}	#@IF DEBUG@#
	close LOG;	#@IF DEBUG@#
}

exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
## 傭兵隊長 36481,36482,36483,36484,36485,36486,36487,36488,36489 ##
s!\Q>Territory Registration and Information<!>領地戦申請/取消<!;
s!\Q>Buy regular mercenary items.<!>品物を買いたい<!;
s!\Q>Buy Elite Mercenary items.<!>（精鋭用兵証明書を見せて）物品を買いたい<!;
s!\Q>Buy Exalted Mercenary items.<!>（最精鋭用兵証明書を見せて）物品を買いたい<!;
s!\Q>Mount Information.<!>乗り物のことを聞く<!;
s!\Q>Mercenary Information.<!>傭兵のことを聞く<!;
s!\Q>Quest<!>クエスト<!;
#----------------------------------------------------------------------------

		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
