/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.PriestOfBlessing;

import static com.l2jserver.gameserver.util.EventNpcAligner.align;
import static com.l2jserver.gameserver.util.EventNpcAligner.getSpawns;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

/**
 * Priest Of Blessing AI.
 * @author Gnacik
 */
public class PriestOfBlessing extends AbstractNpcAI
{
	// NPC
	private static final int PRIEST = 32783;
	// Items
	private static final int NEVIT_VOICE = 17094;
	// @formatter:off
	private static final int[][] HOURGLASSES =
	{
		{ 17095, 17096, 17097, 17098, 17099 },
		{ 17100, 17101, 17102, 17103, 17104 },
		{ 17105, 17106, 17107, 17108, 17109 },
		{ 17110, 17111, 17112, 17113, 17114 },
		{ 17115, 17116, 17117, 17118, 17119 },
		{ 17120, 17121, 17122, 17123, 17124 },
		{ 17125, 17126, 17127, 17128, 17129 }
	};
	// @formatter:on
	// Prices
	private static final int PRICE_VOICE = 100000;
	private static final int[] PRICE_HOURGLASS =
	{
		4000,
		30000,
		110000,
		310000,
		970000,
		2160000,
		5000000
	};
	
	public PriestOfBlessing()
	{
		super(PriestOfBlessing.class.getSimpleName(), "ai/npc/");
		addStartNpc(PRIEST);
		addFirstTalkId(PRIEST);
		addTalkId(PRIEST);
		//[JOJO]-------------------------------------------------
		for (Location spawn : getSpawns())
			align(addSpawn(PRIEST, spawn, false, 0));
		//-------------------------------------------------------
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = event;
		if (event.equalsIgnoreCase("buy_voice"))
		{
			if (player.getAdena() >= PRICE_VOICE)
			{
				final long now = System.currentTimeMillis();
				final String value = loadGlobalQuestVar(player.getAccountName() + "_voice");
				final long reuseTime = value == "" ? 0 : Long.parseLong(value);
				
				if (now > reuseTime)
				{
					takeItems(player, PcInventory.ADENA_ID, PRICE_VOICE);
					giveItems(player, NEVIT_VOICE, 1);
					saveGlobalQuestVar(player.getAccountName() + "_voice", Long.toString(now + (20 * 3600000)));
				}
				else
				{
					final long remainingTime = reuseTime - now + 59999;	// ceil
					final int hours = (int) (remainingTime / 3600000L);
					final int minutes = (int) (remainingTime / 60000L % 60);
					SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AVAILABLE_AFTER_S1_S2_HOURS_S3_MINUTES);
					sm.addItemName(NEVIT_VOICE);
					sm.addNumber(hours);
					sm.addNumber(minutes);
					player.sendPacket(sm);
				}
				return null;
			}
			htmltext = "32783-adena.htm";
		}
		else if (event.equalsIgnoreCase("buy_hourglass"))
		{
			int index = getHGIndex(player.getLevel());
			int priceHourglass = PRICE_HOURGLASS[index];
			long now = System.currentTimeMillis();
			
			if (player.getAdena() >= priceHourglass)
			{
				String value = loadGlobalQuestVar(player.getAccountName() + "_hg_" + index);
				long reuseTime = value == "" ? 0 : Long.parseLong(value);
				
				if (now > reuseTime)
				{
					int[] hg = HOURGLASSES[index];
					int nevitHourglass = hg[getRandom(0, hg.length - 1)];
					takeItems(player, PcInventory.ADENA_ID, priceHourglass);
					giveItems(player, nevitHourglass, 1);
					saveGlobalQuestVar(player.getAccountName() + "_hg_" + index, Long.toString(now + (20 * 3600000)));
				}
				else
				{
					long remainingTime = reuseTime - now + 59999;	// ceil
					int hours = (int) (remainingTime / 3600000L);
					int minutes = (int) (remainingTime / 60000L % 60);
					SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AVAILABLE_AFTER_S1_S2_HOURS_S3_MINUTES);
					sm.addString("Nevit's Hourglass");
					sm.addNumber(hours);
					sm.addNumber(minutes);
					player.sendPacket(sm);
				}
				return null;
			}
			htmltext = "32783-adena.htm";
		}
		return htmltext;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		String content = getHtm(player.getHtmlPrefix(), "32783.htm");
		content = content.replace("%donate%", Util.formatAdena(PRICE_HOURGLASS[getHGIndex(player.getLevel())]));
		return content;
	}
	
	private int getHGIndex(int lvl)
	{
		int index = 0;
		if (lvl < 20)
		{
			index = 0;
		}
		else if (lvl < 40)
		{
			index = 1;
		}
		else if (lvl < 52)
		{
			index = 2;
		}
		else if (lvl < 61)
		{
			index = 3;
		}
		else if (lvl < 76)
		{
			index = 4;
		}
		else if (lvl < 80)
		{
			index = 5;
		}
		else if (lvl < 86)
		{
			index = 6;
		}
		return index;
	}
	
	public static void main(String[] args)
	{
		new PriestOfBlessing();
	}
}
