/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.bypasshandlers;

import java.util.StringTokenizer;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IBypassHandler;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;

public class RentPet implements IBypassHandler
{
	private static final String[] COMMANDS =
	{
		"RentPet"
	};
	
	@Override
	public boolean useBypass(String command, L2PcInstance activeChar, L2Character target)
	{
		if (!(target instanceof L2MerchantInstance))
		{
			return false;
		}
		
		if (!Config.ALLOW_RENTPET)
		{
			return false;
		}
		
		if (!Config.LIST_PET_RENT_NPC.contains(((L2Npc) target).getTemplate().getNpcId()))
		{
			return false;
		}
		
		try
		{
			StringTokenizer st = new StringTokenizer(command, " ");
			st.nextToken();
			
			if (st.countTokens() < 1)
			{
				NpcHtmlMessage msg = new NpcHtmlMessage(((L2Npc) target).getObjectId());
				msg.setHtml("<html><body>ybgǗl:<br>" +
						"Co[XgC_[yȉiŃ^Ă܂B<br>i:<br1>" +
						"<table border=0><tr><td>R</td></tr>" +
						"<tr><td>Co[</td><td>XgC_[</td></tr>" +
						"<tr><td><a action=\"bypass -h npc_%objectId%_RentPet 1\">30 b/1,800A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 11\">30 b/900A</a></td></tr>" +
						"<tr><td><a action=\"bypass -h npc_%objectId%_RentPet 2\">1 /7,200A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 12\">1 /3,600A</a></td></tr>" +
						"<tr><td><a action=\"bypass -h npc_%objectId%_RentPet 3\">10 /720,000A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 13\">10 /360,000A</a></td></tr>" +
						"<tr><td><a action=\"bypass -h npc_%objectId%_RentPet 4\">30 /6,480,000A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 14\">30 /3,240,000A</a></td></tr>" +
						"</table>" +
				"</body></html>");
				msg.replace("%objectId%", ((L2Npc) target).getObjectId());
				activeChar.sendPacket(msg);
			}
			else
			{
				tryRentPet(activeChar, Integer.parseInt(st.nextToken()));
			}
			
			return true;
		}
		catch (Exception e)
		{
			_log.info("Exception in " + getClass().getSimpleName());
		}
		return false;
	}
	
	public static final void tryRentPet(L2PcInstance player, int val)
	{
		if ((player == null) || player.hasSummon() || player.isMounted() || player.isRentedPet() || player.isTransformed() || player.isCursedWeaponEquipped())
		{
			return;
		}
		if (!player.disarmWeapons())
		{
			return;
		}
		
		int petId;
		double price = 1;
		int cost[] =
		{
			1800,
			7200,
			720000,
			6480000
		};
		int ridetime[] =
		{
			30,
			60,
			600,
			1800
		};
		
		if (val > 10)
		{
			petId = 12526;
			val -= 10;
			price /= 2;
		}
		else
		{
			petId = 12621;
		}
		
		if ((val < 1) || (val > 4))
		{
			return;
		}
		
		price *= cost[val - 1];
		int time = ridetime[val - 1];
		
		if (!player.reduceAdena("Rent", (long) price, player.getLastFolkNPC(), true))
		{
			return;
		}
		
		player.mount(petId, 0, false);
		SetupGauge sg = new SetupGauge(3, time * 1000);
		player.sendPacket(sg);
		player.startRentPet(time);
	}
	
	@Override
	public String[] getBypassList()
	{
		return COMMANDS;
	}
}
