## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/systemmsg-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open TXT, '>:utf8', 'systemmsg.txt'  or die $!;
print TXT '// please leave all $s1,$s2,$s3,$s4 and $c1 intact (these will be replaced by corresponding strings)
';

<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//; s/\\\\n/\\n/g}
	my ($id,$message) = ($field[0],$field[2]);
	print "$id\r";

	print TXT "$id\t$message\n";
}
close TXT;
utime $mtime,$mtime,'systemmsg.txt';

close CSV;
print "\n";
