/*
 * Copyright (C) 2004-2013 L2J Server
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.RecipeData;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

public class RecipeItemMakeInfo extends L2GameServerPacket
{
	private final int _id;
	private final L2PcInstance _activeChar;
	private final int _success;
	
	public RecipeItemMakeInfo(int id, L2PcInstance player, boolean success)	// <<== RecipeController.RecipeItemMaker#updateMakeInfo
	{
		_id = id;
		_activeChar = player;
		_success = success ? 1 : 0; // item creation success/failed
	}
	
	public RecipeItemMakeInfo(int id, L2PcInstance player)	// <<== RequestRecipeItemMakeInfo
	{
		_id = id;
		_activeChar = player;
		_success = -1;
	}
	
	@Override
	protected final void writeImpl()
	{
		final L2RecipeList recipe = RecipeData.getInstance().getRecipeList(_id);
		if (recipe != null)
		{
			writeC(0xDD);
			writeD(_id);
			writeD(recipe.isDwarvenRecipe() ? 0 : 1); // 0 = Dwarven - 1 = Common
			writeD((int) _activeChar.getCurrentMp());
			writeD(_activeChar.getMaxMp());
			writeD(_success);
		}
		else
		{
			_log.info("Character: " + getClient().getActiveChar() + ": Requested unexisting recipe with id = " + _id);
		}
	}
}
