﻿<?php
/**
 * Account manager Registration form module
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Registration.php 15 2005-05-29 17:32:41Z madest $
 * @package AccountManager
 * @filesource
 */

/**
 * Registration form
 * @author Lauri Lüüs <mad@webpoint.ee>
 * @version $Id: Registration.php 15 2005-05-29 17:32:41Z madest $
 * @package AccountManager
 */
class Registration extends Module
{

	/**
	 * Constructor, specification template file and starts to create contents.
	 */
	function registration()
	{
		$this->Module();
		if($this->template = temp_load($this->config->manager['template_path']."registration.htm"))
		{
			$this->check_form();		
			$this->output = $this->template;
		} else {
			$this->output = "Class:登録テンプレートがありません。";
		}
	}
	
	/**
	* Check form input and that 
	*/	
	function check_form()
	{
		include('classes/configuration.php');	//[JOJO]
		$fill['login'] = "";
		
		if(isset($_POST['login'])&& isset($_POST['password']) && isset($_POST['password2']))
		{
			if($_POST['password']!="")
			{
				if($_POST['password']==$_POST['password2'])
				{					
					if($this->get_count() < $this->config->manager['account_limit'])
					{
						// Account object creation with specified login and password
						$accountObj = new account($_POST['login'], $_POST['password']);						
						$accountObj->access_level = $this->config->manager['default_level'];
						if($accountObj->create() == true)
						{
							$this->write_log("REGISTRATION: Account created: '{$accountObj->login}'");
							$this->template = "<font color=red>\"<b>{$_POST['login']}</b>\"のアカウントが登録されました。</font>";		//[JOJO]
						//	$this->template = "<font color=red>\"<b>{$_POST['login']}</b>\"のアカウントが登録されました。</font>".$this->template;
						}else{
							$this->template = "<font color=red>アカウント \"<b>{$_POST['login']}</b>\" はすでに登録されています。</font>".$this->template;
						}
					} else {
						$this->template = "<font color=red>アカウント登録上限です : {$manager['account_limit']}</font>".$this->template;
					}
				}else{
					$fill['login'] = $_POST['login'];
					$this->template = "<font color=red>パスワードが一致しません！再度入力してください。</font>".$this->template;
				}
			}else{
				$this->template = "<font color=red>項目を入力してください！</font>".$this->template;
			}			
		}
		$this->template = temp_subs($this->template, "register", $fill);
		
		$ac_inf['registred'] = account_count();
		$ac_inf['limit'] = $this->config->manager['account_limit'];
		
		$this->template = temp_subs($this->template, "reg", $ac_inf);
	}
	
	/**
	 * Get account count in database
	 * @return int
	 */
	function get_count()
	{
		if($q = mysql_query("SELECT COUNT(login) as acs FROM accounts"))
		{
			$r = mysql_fetch_array($q);
			return $r['acs'];
		} else {
			return false;
		}
	}
}
?>