/*
 * Copyright (C) 2004-2013 L2J Server
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.l2jserver.gameserver.network;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.clientstrings.Builder;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

import gnu.trove.map.hash.TIntObjectHashMap;

/**
 * @author Noctarius, Nille02, crion, Forsaiken
 */
public final class SystemMessageId
{
	private static final Logger _log = Logger.getLogger(SystemMessageId.class.getName());
	private static final SMLocalisation[] EMPTY_SML_ARRAY = new SMLocalisation[0];
	public static final SystemMessageId[] EMPTY_ARRAY = new SystemMessageId[0];
	
	/**
	 * ID: 0<br>
	 * Message: T[o[Ƃ̐ڑؒf܂B<br>
	 * Message: &#33287;&#20282;&#26381;&#22120;&#36899;&#32218;&#20013;&#26039;&#12290;<br>
	 * Message: You have been disconnected from the server.
	 */
	public static final SystemMessageId YOU_HAVE_BEEN_DISCONNECTED;
	
	/**
	 * ID: 1<br>
	 * Message: T[o[$s1bɒf܂BQ[IĂB<br>
	 * Message: &#20282;&#26381;&#22120;&#23559;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#24460;&#38364;&#38281;&#65292;&#35531;&#20808;&#34892;&#32080;&#26463;&#36938;&#25138;&#12290;<br>
	 * Message: The server will be coming down in $1 seconds. Please find a safe place to log out.
	 */
	public static final SystemMessageId THE_SERVER_WILL_BE_COMING_DOWN_IN_S1_SECONDS;
	
	/**
	 * ID: 2<br>
	 * Message: $s1݂͑Ȃ[U[łB<br>
	 * Message: &#29609;&#23478;&#12300;&#36;&#115;&#49;&#12301;&#20006;&#19981;&#23384;&#22312;&#12290;<br>
	 * Message: $s1 does not exist.
	 */
	public static final SystemMessageId S1_DOES_NOT_EXIST;
	
	/**
	 * ID: 3<br>
	 * Message: $s1̓Q[ɐڑĂ܂B<br>
	 * Message: &#29609;&#23478;&#12300;&#36;&#115;&#49;&#12301;&#23578;&#26410;&#30331;&#20837;&#12290;<br>
	 * Message: $s1 is not currently logged in.
	 */
	public static final SystemMessageId S1_IS_NOT_ONLINE;
	
	/**
	 * ID: 4<br>
	 * Message: gɌ\邱Ƃ͂ł܂B<br>
	 * Message: &#19981;&#21487;&#36992;&#35531;&#33258;&#24049;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: You cannot ask yourself to apply to a clan.
	 */
	public static final SystemMessageId CANNOT_INVITE_YOURSELF;
	
	/**
	 * ID: 5<br>
	 * Message: $s1͂łɑ݂Ă錌łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#28858;&#24050;&#32147;&#23384;&#22312;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: $s1 already exists.
	 */
	public static final SystemMessageId S1_ALREADY_EXISTS;
	
	/**
	 * ID: 6<br>
	 * Message: $s1݂͑錌ł͂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#20006;&#19981;&#23384;&#22312;&#12290;<br>
	 * Message: $s1 does not exist
	 */
	public static final SystemMessageId S1_DOES_NOT_EXIST2;
	
	/**
	 * ID: 7<br>
	 * Message: ł$s1ɏĂ܂B<br>
	 * Message: &#24050;&#23660;&#26044;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#12290;<br>
	 * Message: You are already a member of $s1.
	 */
	public static final SystemMessageId ALREADY_MEMBER_OF_S1;
	
	/**
	 * ID: 8<br>
	 * Message: Ɋւ鑼̍ƒłB<br>
	 * Message: &#27491;&#22312;&#36914;&#34892;&#33287;&#34880;&#30431;&#30456;&#38364;&#30340;&#24037;&#20316;&#12290;<br>
	 * Message: You are working with another clan.
	 */
	public static final SystemMessageId YOU_ARE_WORKING_WITH_ANOTHER_CLAN;
	
	/**
	 * ID: 9<br>
	 * Message: $s1͌ł͂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#26159;&#34880;&#30431;&#30431;&#20027;&#12290;<br>
	 * Message: $s1 is not a clan leader.
	 */
	public static final SystemMessageId S1_IS_NOT_A_CLAN_LEADER;
	
	/**
	 * ID: 10<br>
	 * Message: $s1͌Ɋւ鑼̍ƒłB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#27491;&#22312;&#36914;&#34892;&#33287;&#34880;&#30431;&#30456;&#38364;&#30340;&#24037;&#20316;&#12290;<br>
	 * Message: $s1 is working with another clan.
	 */
	public static final SystemMessageId S1_WORKING_WITH_ANOTHER_CLAN;
	
	/**
	 * ID: 11<br>
	 * Message: ̉\҂܂B<br>
	 * Message: &#27794;&#26377;&#20154;&#30003;&#35531;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: There are no applicants for this clan.
	 */
	public static final SystemMessageId NO_APPLICANTS_FOR_THIS_CLAN;
	
	/**
	 * ID: 12<br>
	 * Message: ̉\҂̏񂪕smłB<br>
	 * Message: &#30003;&#35531;&#21152;&#20837;&#34880;&#30431;&#32773;&#30340;&#36039;&#26009;&#19981;&#27491;&#30906;&#12290;<br>
	 * Message: The applicant information is incorrect.
	 */
	public static final SystemMessageId APPLICANT_INFORMATION_INCORRECT;
	
	/**
	 * ID: 13<br>
	 * Message: Uւ̎Q\Ă邽߁AUł܂B<br>
	 * Message: &#24050;&#30003;&#35531;&#21443;&#21152;&#25915;&#22478;&#25136;&#65292;&#25925;&#28961;&#27861;&#35299;&#25955;&#12290;<br>
	 * Message: Unable to disperse: your clan has requested to participate in a castle siege.
	 */
	public static final SystemMessageId CANNOT_DISSOLVE_CAUSE_CLAN_WILL_PARTICIPATE_IN_CASTLE_SIEGE;
	
	/**
	 * ID: 14<br>
	 * Message: ܂̓AWgLĂ邽߁AUł܂B<br>
	 * Message: &#24050;&#25793;&#26377;&#22478;&#22561;&#25110;&#26681;&#25818;&#22320;&#65292;&#25925;&#28961;&#27861;&#35299;&#25955;&#12290;<br>
	 * Message: Unable to disperse: your clan owns one or more castles or hideouts.
	 */
	public static final SystemMessageId CANNOT_DISSOLVE_CAUSE_CLAN_OWNS_CASTLES_HIDEOUTS;
	
	/**
	 * ID: 15<br>
	 * Message: U풆łB<br>
	 * Message: &#25915;&#22478;&#20013;&#12290;<br>
	 * Message: You are in siege.
	 */
	public static final SystemMessageId YOU_ARE_IN_SIEGE;
	
	/**
	 * ID: 16<br>
	 * Message: U풆ł͂܂B<br>
	 * Message: &#38750;&#25915;&#22478;&#20013;&#12290;<br>
	 * Message: You are not in siege.
	 */
	public static final SystemMessageId YOU_ARE_NOT_IN_SIEGE;
	
	/**
	 * ID: 17<br>
	 * Message: U킪n܂܂B<br>
	 * Message: &#25915;&#22478;&#25136;&#24050;&#38283;&#22987;&#12290;<br>
	 * Message: The castle siege has begun.
	 */
	public static final SystemMessageId CASTLE_SIEGE_HAS_BEGUN;
	
	/**
	 * ID: 18<br>
	 * Message: U킪I܂B<br>
	 * Message: &#25915;&#22478;&#25136;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The castle siege has ended.
	 */
	public static final SystemMessageId CASTLE_SIEGE_HAS_ENDED;
	
	/**
	 * ID: 19<br>
	 * Message: 傪ւ܂I<br>
	 * Message: &#22478;&#20027;&#24050;&#26356;&#25563;&#65281;<br>
	 * Message: There is a new Lord of the castle!
	 */
	public static final SystemMessageId NEW_CASTLE_LORD;
	
	/**
	 * ID: 20<br>
	 * Message: 傪J܂B<br>
	 * Message: &#22478;&#38272;&#24050;&#25171;&#38283;&#12290;<br>
	 * Message: The gate is being opened.
	 */
	public static final SystemMessageId GATE_IS_OPENING;
	
	/**
	 * ID: 21<br>
	 * Message: 傪j󂳂܂B<br>
	 * Message: &#22478;&#38272;&#24050;&#30772;&#22750;&#12290;<br>
	 * Message: The gate is being destroyed.
	 */
	public static final SystemMessageId GATE_IS_DESTROYED;
	
	/**
	 * ID: 22<br>
	 * Message: 肪߂Ă܂B<br>
	 * Message: &#30446;&#27161;&#36317;&#38626;&#22826;&#36960;&#12290;<br>
	 * Message: Your target is out of range.
	 */
	public static final SystemMessageId TARGET_TOO_FAR;
	
	/**
	 * ID: 23<br>
	 * Message: HP܂B<br>
	 * Message: &#72;&#80;&#19981;&#36275;&#12290;<br>
	 * Message: Not enough HP.
	 */
	public static final SystemMessageId NOT_ENOUGH_HP;
	
	/**
	 * ID: 24<br>
	 * Message: MP܂B<br>
	 * Message: &#77;&#80;&#19981;&#36275;&#12290;<br>
	 * Message: Not enough MP.
	 */
	public static final SystemMessageId NOT_ENOUGH_MP;
	
	/**
	 * ID: 25<br>
	 * Message: HP񕜂܂B<br>
	 * Message: &#24674;&#24489;&#72;&#80;&#12290;<br>
	 * Message: Rejuvenating HP.
	 */
	public static final SystemMessageId REJUVENATING_HP;
	
	/**
	 * ID: 26<br>
	 * Message: MP񕜂܂B<br>
	 * Message: &#24674;&#24489;&#77;&#80;&#12290;<br>
	 * Message: Rejuvenating MP.
	 */
	public static final SystemMessageId REJUVENATING_MP;
	
	/**
	 * ID: 27<br>
	 * Message: WQ󂯁Arf܂B<br>
	 * Message: &#21463;&#21040;&#24178;&#25854;&#65292;&#22240;&#27492;&#26045;&#27861;&#20013;&#26039;&#12290;<br>
	 * Message: Your casting has been interrupted.
	 */
	public static final SystemMessageId CASTING_INTERRUPTED;
	
	/**
	 * ID: 28<br>
	 * Message: $s1Afiɓ܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: You have obtained $s1 adena.
	 */
	public static final SystemMessageId YOU_PICKED_UP_S1_ADENA;
	
	/**
	 * ID: 29<br>
	 * Message: $s1 $s2ɓ܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have obtained $s2 $s1.
	 */
	public static final SystemMessageId YOU_PICKED_UP_S1_S2;
	
	/**
	 * ID: 30<br>
	 * Message: $s1ɓ܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have obtained $s1.
	 */
	public static final SystemMessageId YOU_PICKED_UP_S1;
	
	/**
	 * ID: 31<br>
	 * Message: Ԃł͍sł܂B<br>
	 * Message: &#22352;&#19979;&#26178;&#35282;&#33394;&#28961;&#27861;&#34892;&#21205;&#12290;<br>
	 * Message: You cannot move while sitting.
	 */
	public static final SystemMessageId CANT_MOVE_SITTING;
	
	/**
	 * ID: 32<br>
	 * Message: 퓬s\Ɋׂ܂BŊ̃X^[g |CgɈړ܂B<br>
	 * Message: &#24744;&#24050;&#28961;&#27861;&#32380;&#32396;&#36914;&#34892;&#25136;&#39717;&#65292;&#35531;&#22238;&#21040;&#35282;&#33394;&#37325;&#29983;&#22320;&#40670;&#12290;<br>
	 * Message: You are unable to engage in combat. Please go to the nearest restart point.
	 */
	public static final SystemMessageId UNABLE_COMBAT_PLEASE_GO_RESTART;
	
	/**
	 * ID: 33<br>
	 * Message: @̎gpɂ͈ړł܂B<br>
	 * Message: &#26045;&#23637;&#39764;&#27861;&#26178;&#35282;&#33394;&#28961;&#27861;&#31227;&#21205;&#12290;<br>
	 * Message: You cannot move while casting.
	 */
	public static final SystemMessageId CANT_MOVE_CASTING;
	
	/**
	 * ID: 34<br>
	 * Message: l[WII̐Eւ悤I<br>
	 * Message: &#27489;&#36814;&#20358;&#21040;&#12304;&#22825;&#22530;&#73;&#73;&#12305;&#30340;&#19990;&#30028;&#12290;<br>
	 * Message: Welcome to the World of Lineage II.
	 */
	public static final SystemMessageId WELCOME_TO_LINEAGE;
	
	/**
	 * ID: 35<br>
	 * Message: $s1̃_[W^܂B<br>
	 * Message: &#36896;&#25104;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You hit for $s1 damage
	 */
	public static final SystemMessageId YOU_DID_S1_DMG;
	
	/**
	 * ID: 36<br>
	 * Message: $c1$s2̃_[W󂯂܂B<br>
	 * Message: &#34987;&#12300;&#36;&#99;&#49;&#12301;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 hit you for $s2 damage.
	 */
	public static final SystemMessageId C1_GAVE_YOU_S2_DMG;
	
	/**
	 * ID: 37<br>
	 * Message: $c1ɂ$s2̃_[W󂯂܂B<br>
	 * Message: &#22240;&#28858;&#12300;&#36;&#99;&#49;&#12301;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 hit you for $s2 damage.
	 */
	public static final SystemMessageId C1_GAVE_YOU_S2_DMG2;
	
	/**
	 * ID: 41<br>
	 * Message: ̔ˏłB<br>
	 * Message: &#28310;&#20633;&#23556;&#31661;&#20013;&#12290;<br>
	 * Message: You carefully nock an arrow.
	 */
	public static final SystemMessageId GETTING_READY_TO_SHOOT_AN_ARROW;
	
	/**
	 * ID: 42<br>
	 * Message: $c1̍U܂B<br>
	 * Message: &#38275;&#38283;&#20102;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#25915;&#25802;&#12290;<br>
	 * Message: You have avoided $c1's attack.
	 */
	public static final SystemMessageId AVOIDED_C1_ATTACK;
	
	/**
	 * ID: 43<br>
	 * Message: UO܂B<br>
	 * Message: &#27794;&#26377;&#25802;&#20013;&#23565;&#25163;&#12290;<br>
	 * Message: You have missed.
	 */
	public static final SystemMessageId MISSED_TARGET;
	
	/**
	 * ID: 44<br>
	 * Message: NeBJ qbgI<br>
	 * Message: &#33268;&#21629;&#25915;&#25802;&#65281;<br>
	 * Message: Critical hit!
	 */
	public static final SystemMessageId CRITICAL_HIT;
	
	/**
	 * ID: 45<br>
	 * Message: $s1̌ol𓾂܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#32147;&#39511;&#20540;&#12290;<br>
	 * Message: You have earned $s1 experience.
	 */
	public static final SystemMessageId EARNED_S1_EXPERIENCE;
	
	/**
	 * ID: 46<br>
	 * Message: $s1gp܂B<br>
	 * Message: &#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You use $s1.
	 */
	public static final SystemMessageId USE_S1;
	
	/**
	 * ID: 47<br>
	 * Message: $s1̎gpłB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#27491;&#22312;&#20351;&#29992;&#20013;&#12290;<br>
	 * Message: You begin to use a(n) $s1.
	 */
	public static final SystemMessageId BEGIN_TO_USE_S1;
	
	/**
	 * ID: 48<br>
	 * Message: $s1͍Ďgpł邽߁Agpł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#27491;&#22312;&#20919;&#21371;&#20013;&#65292;&#25925;&#28961;&#27861;&#20877;&#27425;&#20351;&#29992;&#12290;<br>
	 * Message: $s1 is not available at this time: being prepared for reuse.
	 */
	public static final SystemMessageId S1_PREPARED_FOR_REUSE;
	
	/**
	 * ID: 49<br>
	 * Message: $s1𑕔܂B<br>
	 * Message: &#35037;&#20633;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have equipped your $s1.
	 */
	public static final SystemMessageId S1_EQUIPPED;
	
	/**
	 * ID: 50<br>
	 * Message: ^[Qbgw肳Ă܂B<br>
	 * Message: &#28961;&#30446;&#27161;&#23565;&#35937;&#12290;<br>
	 * Message: Your target cannot be found.
	 */
	public static final SystemMessageId TARGET_CANT_FOUND;
	
	/**
	 * ID: 51<br>
	 * Message: gɂ͎gpł܂B<br>
	 * Message: &#19981;&#21487;&#20351;&#29992;&#22312;&#33258;&#24049;&#36523;&#19978;&#12290;<br>
	 * Message: You cannot use this on yourself.
	 */
	public static final SystemMessageId CANNOT_USE_ON_YOURSELF;
	
	/**
	 * ID: 52<br>
	 * Message: $s1Afi𓾂܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: You have earned $s1 adena.
	 */
	public static final SystemMessageId EARNED_S1_ADENA;
	
	/**
	 * ID: 53<br>
	 * Message: $s1 $s2𓾂܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have earned $s2 $s1(s).
	 */
	public static final SystemMessageId EARNED_S2_S1_S;
	
	/**
	 * ID: 54<br>
	 * Message: $s1𓾂܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have earned $s1.
	 */
	public static final SystemMessageId EARNED_ITEM_S1;
	
	/**
	 * ID: 55<br>
	 * Message: $s1Afi̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#25791;&#36215;&#12300;&#36;&#115;&#49;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: You have failed to pick up $s1 adena.
	 */
	public static final SystemMessageId FAILED_TO_PICKUP_S1_ADENA;
	
	/**
	 * ID: 56<br>
	 * Message: $s1̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#25791;&#36215;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have failed to pick up $s1.
	 */
	public static final SystemMessageId FAILED_TO_PICKUP_S1;
	
	/**
	 * ID: 57<br>
	 * Message: $s1 $s2̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#25791;&#36215;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have failed to pick up $s2 $s1(s).
	 */
	public static final SystemMessageId FAILED_TO_PICKUP_S2_S1_S;
	
	/**
	 * ID: 58<br>
	 * Message: $s1Afi̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: You have failed to earn $s1 adena.
	 */
	public static final SystemMessageId FAILED_TO_EARN_S1_ADENA;
	
	/**
	 * ID: 59<br>
	 * Message: $s1̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have failed to earn $s1.
	 */
	public static final SystemMessageId FAILED_TO_EARN_S1;
	
	/**
	 * ID: 60<br>
	 * Message: $s1 $s2̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have failed to earn $s2 $s1(s).
	 */
	public static final SystemMessageId FAILED_TO_EARN_S2_S1_S;
	
	/**
	 * ID: 61<br>
	 * Message: N܂łB<br>
	 * Message: &#20160;&#40636;&#20107;&#24773;&#37117;&#27794;&#30332;&#29983;&#12290;<br>
	 * Message: Nothing happened.
	 */
	public static final SystemMessageId NOTHING_HAPPENED;
	
	/**
	 * ID: 62<br>
	 * Message: $s1ɐ܂B<br>
	 * Message: &#24050;&#25104;&#21151;&#24375;&#21270;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your $s1 has been successfully enchanted.
	 */
	public static final SystemMessageId S1_SUCCESSFULLY_ENCHANTED;
	
	/**
	 * ID: 63<br>
	 * Message: +$s1$s2܂B<br>
	 * Message: &#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#30332;&#20986;&#38275;&#32768;&#30340;&#20809;&#33426;&#12290;<br>
	 * Message: Your +$S1 $S2 has been successfully enchanted.
	 */
	public static final SystemMessageId S1_S2_SUCCESSFULLY_ENCHANTED;
	
	/**
	 * ID: 64<br>
	 * Message: Ɏs܂B$s1܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30332;&#20986;&#28608;&#28872;&#30340;&#24375;&#20809;&#32780;&#28040;&#22833;&#20102;&#12290;<br>
	 * Message: The enchantment has failed! Your $s1 has been crystallized.
	 */
	public static final SystemMessageId ENCHANTMENT_FAILED_S1_EVAPORATED;
	
	/**
	 * ID: 65<br>
	 * Message: Ɏs܂B+$s1$s2܂B<br>
	 * Message: &#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#30332;&#20986;&#28608;&#28872;&#30340;&#24375;&#20809;&#32780;&#28040;&#22833;&#20102;&#12290;<br>
	 * Message: The enchantment has failed! Your +$s1 $s2 has been crystallized.
	 */
	public static final SystemMessageId ENCHANTMENT_FAILED_S1_S2_EVAPORATED;
	
	/**
	 * ID: 66<br>
	 * Message: $c1 p[eBɏ҂Ă܂BQ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#38538;&#20237;&#65292;&#35201;&#21152;&#20837;&#21966;&#65311;<br>
	 * Message: $c1 is inviting you to join a party. Do you accept?
	 */
	public static final SystemMessageId C1_INVITED_YOU_TO_PARTY;
	
	/**
	 * ID: 67<br>
	 * Message: $s1 $s2̊U󂯂Ă܂B܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#34880;&#30431;&#65292;&#35201;&#21443;&#21152;&#21966;&#65311;<br>
	 * Message: $s1 has invited you to the join the clan, $s2. Do you wish to join?
	 */
	public static final SystemMessageId S1_HAS_INVITED_YOU_TO_JOIN_THE_CLAN_S2;
	
	/**
	 * ID: 68<br>
	 * Message: $s1Eނ܂BEތA1Ԃ͑̌ɉł܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#33067;&#38626;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#21966;&#65311;&#33067;&#38626;&#24460;&#22312;&#49;&#26085;&#20839;&#28961;&#27861;&#37325;&#26032;&#21152;&#20837;&#20854;&#20182;&#34880;&#30431;&#12290;<br>
	 * Message: Would you like to withdraw from the $s1 clan? If you leave, you will have to wait at least a day before joining another clan.
	 */
	public static final SystemMessageId WOULD_YOU_LIKE_TO_WITHDRAW_FROM_THE_S1_CLAN;
	
	/**
	 * ID: 69<br>
	 * Message: $s1Ǖ܂B1ԁAV̉͂ł܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#38283;&#38500;&#30431;&#21451;&#12300;&#36;&#115;&#49;&#12301;&#21966;&#65311;&#22914;&#26524;&#38283;&#38500;&#30431;&#21729;&#65292;&#22312;&#49;&#26085;&#20043;&#20839;&#28961;&#27861;&#20877;&#25307;&#25910;&#34880;&#30431;&#25104;&#21729;&#12290;<br>
	 * Message: Would you like to dismiss $s1 from the clan? If you do so, you will have to wait at least a day before accepting a new member.
	 */
	public static final SystemMessageId WOULD_YOU_LIKE_TO_DISMISS_S1_FROM_THE_CLAN;
	
	/**
	 * ID: 70<br>
	 * Message: $s1U܂B낵łB<br>
	 * Message: &#35299;&#25955;&#34880;&#30431;&#23559;&#26371;&#21463;&#21040;&#32147;&#39511;&#20540;&#19979;&#38477;&#30340;&#25074;&#32624;&#65292;&#30906;&#23450;&#35201;&#35299;&#25955;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#21966;&#65311;<br>
	 * Message: Do you wish to disperse the clan, $s1?
	 */
	public static final SystemMessageId DO_YOU_WISH_TO_DISPERSE_THE_CLAN_S1;
	
	/**
	 * ID: 71<br>
	 * Message: $s1̂Ă܂B<br>
	 * Message: &#35531;&#21839;&#35201;&#19999;&#26820;&#24190;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#65311;<br>
	 * Message: How many of your $s1(s) do you wish to discard?
	 */
	public static final SystemMessageId HOW_MANY_S1_DISCARD;
	
	/**
	 * ID: 72<br>
	 * Message: $s1ڂ܂B<br>
	 * Message: &#35531;&#21839;&#35201;&#31227;&#21205;&#24190;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#65311;<br>
	 * Message: How many of your $s1(s) do you wish to move?
	 */
	public static final SystemMessageId HOW_MANY_S1_MOVE;
	
	/**
	 * ID: 73<br>
	 * Message: $s1j󂵂܂B<br>
	 * Message: &#35531;&#21839;&#35201;&#21034;&#38500;&#24190;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#65311;<br>
	 * Message: How many of your $s1(s) do you wish to destroy?
	 */
	public static final SystemMessageId HOW_MANY_S1_DESTROY;
	
	/**
	 * ID: 74<br>
	 * Message: $s1j󂵂܂B낵łB<br>
	 * Message: &#21034;&#38500;&#24460;&#23559;&#28961;&#27861;&#25937;&#22238;&#65292;&#30906;&#23450;&#35201;&#21034;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#21966;&#65311;<br>
	 * Message: Do you wish to destroy your $s1?
	 */
	public static final SystemMessageId WISH_DESTROY_S1;
	
	/**
	 * ID: 75<br>
	 * Message: ݂ȂAJEgłB<br>
	 * Message: &#36889;&#26159;&#19981;&#23384;&#22312;&#30340;&#24115;&#34399;&#12290;<br>
	 * Message: ID does not exist.
	 */
	public static final SystemMessageId ID_NOT_EXIST;
	
	/**
	 * ID: 76<br>
	 * Message: pX[h܂B<br>
	 * Message: &#23494;&#30908;&#37679;&#35492;&#12290;<br>
	 * Message: Incorrect password.
	 */
	public static final SystemMessageId INCORRECT_PASSWORD;
	
	/**
	 * ID: 77<br>
	 * Message: ȏ͐ł܂B̃LN^[폜Ă蒼ĂB<br>
	 * Message: &#28961;&#27861;&#20877;&#21109;&#36896;&#26032;&#35282;&#33394;&#65292;&#35531;&#21034;&#38500;&#29694;&#26377;&#30340;&#35282;&#33394;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: You cannot create another character. Please delete the existing character and try again.
	 */
	public static final SystemMessageId CANNOT_CREATE_CHARACTER;
	
	/**
	 * ID: 78<br>
	 * Message: LN^[폜΁AĂgbsO ACe폜܂BLN^[gbsO ACeĂ邩ǂmFĂB$s1{ɍ폜܂B<br>
	 * Message: &#21034;&#38500;&#35282;&#33394;&#26178;&#65292;&#20063;&#23559;&#19968;&#21516;&#21034;&#38500;&#25152;&#25793;&#26377;&#30340;&#32173;&#20182;&#21629;&#36947;&#20855;&#12290;&#35531;&#30906;&#35469;&#35282;&#33394;&#26159;&#21542;&#25793;&#26377;&#32173;&#20182;&#21629;&#36947;&#20855;&#12290;&#30906;&#23450;&#35201;&#21034;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#21966;&#65311;<br>
	 * Message: When you delete a character, any items in his/her possession will also be deleted. Do you really wish to delete $s1%?
	 */
	public static final SystemMessageId WISH_DELETE_S1;
	
	/**
	 * ID: 79<br>
	 * Message: łɑ݂閼OłB<br>
	 * Message: &#36889;&#20491;&#21517;&#23383;&#24050;&#26377;&#20154;&#20351;&#29992;&#12290;<br>
	 * Message: This name already exists.
	 */
	public static final SystemMessageId NAMING_NAME_ALREADY_EXISTS;
	
	/**
	 * ID: 80<br>
	 * Message: {1`8A܂͉p1`16ȓɂĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#20013;&#25991;&#49;&#65374;&#56;&#23383;&#25110;&#33521;&#25991;&#49;&#126;&#49;&#54;&#23383;&#12290;<br>
	 * Message: Names must be between 1-16 characters, excluding spaces or special characters.
	 */
	public static final SystemMessageId NAMING_CHARNAME_UP_TO_16CHARS;
	
	/**
	 * ID: 81<br>
	 * Message: 푰IĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#31278;&#26063;&#12290;<br>
	 * Message: Please select your race.
	 */
	public static final SystemMessageId PLEASE_SELECT_RACE;
	
	/**
	 * ID: 82<br>
	 * Message: NXIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#32887;&#26989;&#12290;<br>
	 * Message: Please select your occupation.
	 */
	public static final SystemMessageId PLEASE_SELECT_OCCUPATION;
	
	/**
	 * ID: 83<br>
	 * Message: ʂIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#24615;&#21029;&#12290;<br>
	 * Message: Please select your gender.
	 */
	public static final SystemMessageId PLEASE_SELECT_GENDER;
	
	/**
	 * ID: 84<br>
	 * Message: s[X][ł͍Uł܂B<br>
	 * Message: &#23433;&#20840;&#21312;&#22495;&#20839;&#28961;&#27861;&#36914;&#34892;&#25915;&#25802;&#12290;<br>
	 * Message: You may not attack in a peaceful zone.
	 */
	public static final SystemMessageId CANT_ATK_PEACEZONE;
	
	/**
	 * ID: 85<br>
	 * Message: 肪s[X][ɂ邽߁AUł܂B<br>
	 * Message: &#23565;&#26041;&#22312;&#23433;&#20840;&#21312;&#22495;&#20839;&#65292;&#28961;&#27861;&#36914;&#34892;&#25915;&#25802;&#12290;<br>
	 * Message: You may not attack this target in a peaceful zone.
	 */
	public static final SystemMessageId TARGET_IN_PEACEZONE;
	
	/**
	 * ID: 86<br>
	 * Message: AJEg͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#24115;&#34399;&#12290;<br>
	 * Message: Please enter your ID.
	 */
	public static final SystemMessageId PLEASE_ENTER_ID;
	
	/**
	 * ID: 87<br>
	 * Message: pX[h͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#23494;&#30908;&#12290;<br>
	 * Message: Please enter your password.
	 */
	public static final SystemMessageId PLEASE_ENTER_PASSWORD;
	
	/**
	 * ID: 88<br>
	 * Message: vgR̃o[WقȂ܂BvOIĂB<br>
	 * Message: &#21332;&#23450;&#29256;&#26412;&#37679;&#35492;&#65292;&#35531;&#32066;&#27490;&#31243;&#24335;&#12290;<br>
	 * Message: Your protocol version is different, please restart your client and run a full check.
	 */
	public static final SystemMessageId WRONG_PROTOCOL_CHECK;
	
	/**
	 * ID: 89<br>
	 * Message: vgR̃o[WقȂ܂BĂB<br>
	 * Message: &#21332;&#23450;&#29256;&#26412;&#37679;&#35492;&#65292;&#35531;&#32380;&#32396;&#36914;&#34892;&#12290;<br>
	 * Message: Your protocol version is different, please continue.
	 */
	public static final SystemMessageId WRONG_PROTOCOL_CONTINUE;
	
	/**
	 * ID: 90<br>
	 * Message: T[o[ɐڑł܂B<br>
	 * Message: &#28961;&#27861;&#33287;&#20282;&#26381;&#22120;&#36899;&#32218;&#12290;<br>
	 * Message: You are unable to connect to the server.
	 */
	public static final SystemMessageId UNABLE_TO_CONNECT;
	
	/**
	 * ID: 91<br>
	 * Message: ^IĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#39662;&#22411;&#12290;<br>
	 * Message: Please select your hairstyle.
	 */
	public static final SystemMessageId PLEASE_SELECT_HAIRSTYLE;
	
	/**
	 * ID: 92<br>
	 * Message: $s1̌ʂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#28040;&#22833;&#20102;&#12290;<br>
	 * Message: $s1 has worn off.
	 */
	public static final SystemMessageId S1_HAS_WORN_OFF;
	
	/**
	 * ID: 93<br>
	 * Message: SP܂B<br>
	 * Message: &#83;&#80;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough SP for this.
	 */
	public static final SystemMessageId NOT_ENOUGH_SP;
	
	/**
	 * ID: 94<br>
	 * Message: Copyright c NCsoft Corporation. All Rights Reserved.<br>
	 * Message: &#67;&#111;&#112;&#121;&#114;&#105;&#103;&#104;&#116;&#32;&#169;&#32;&#78;&#67;&#115;&#111;&#102;&#116;&#32;&#67;&#111;&#114;&#112;&#111;&#114;&#97;&#116;&#105;&#111;&#110;&#46;&#32;&#65;&#108;&#108;&#32;&#82;&#105;&#103;&#104;&#116;&#115;&#32;&#82;&#101;&#115;&#101;&#114;&#118;&#101;&#100;&#46;<br>
	 * Message: 2004-2011 (c) NC Interactive, Inc. All Rights Reserved.
	 */
	public static final SystemMessageId COPYRIGHT;
	
	/**
	 * ID: 95<br>
	 * Message: $s1̌ol$s2SP𓾂܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#32147;&#39511;&#20540;&#33287;&#12300;&#36;&#115;&#50;&#12301;&#40670;&#83;&#80;&#12290;<br>
	 * Message: You have earned $s1 experience and $s2 SP.
	 */
	public static final SystemMessageId YOU_EARNED_S1_EXP_AND_S2_SP;
	
	/**
	 * ID: 96<br>
	 * Message: x Abv܂I<br>
	 * Message: &#24744;&#21319;&#32026;&#20102;&#65281;<br>
	 * Message: Your level has increased!
	 */
	public static final SystemMessageId YOU_INCREASED_YOUR_LEVEL;
	
	/**
	 * ID: 97<br>
	 * Message: NGXg ACe͈ړł܂B<br>
	 * Message: &#28961;&#27861;&#31227;&#21205;&#20219;&#21209;&#36947;&#20855;&#12290;<br>
	 * Message: This item cannot be moved.
	 */
	public static final SystemMessageId CANNOT_MOVE_THIS_ITEM;
	
	/**
	 * ID: 98<br>
	 * Message: NGXg ACéÂĂ܂B<br>
	 * Message: &#20219;&#21209;&#36947;&#20855;&#28961;&#27861;&#19999;&#26820;&#25110;&#21034;&#38500;&#12290;<br>
	 * Message: This item cannot be discarded.
	 */
	public static final SystemMessageId CANNOT_DISCARD_THIS_ITEM;
	
	/**
	 * ID: 99<br>
	 * Message: NGXg ACe̓g[h蔄ł܂B<br>
	 * Message: &#20219;&#21209;&#36947;&#20855;&#28961;&#27861;&#20132;&#26131;&#12290;<br>
	 * Message: This item cannot be traded or sold.
	 */
	public static final SystemMessageId CANNOT_TRADE_THIS_ITEM;
	
	/**
	 * ID: 100<br>
	 * Message: $c1g[h\Ă܂Bɉ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#35531;&#27714;&#33287;&#24744;&#20132;&#26131;&#65292;&#35201;&#36914;&#34892;&#20132;&#26131;&#21966;&#65311;<br>
	 * Message: $c1 is requesting to trade. Do you wish to continue?
	 */
	public static final SystemMessageId C1_REQUESTS_TRADE;
	
	/**
	 * ID: 101<br>
	 * Message: 퓬̓OAEgł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#30331;&#20986;&#12290;<br>
	 * Message: You cannot exit while in combat.
	 */
	public static final SystemMessageId CANT_LOGOUT_WHILE_FIGHTING;
	
	/**
	 * ID: 102<br>
	 * Message: 퓬̓X^[gł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: You cannot restart while in combat.
	 */
	public static final SystemMessageId CANT_RESTART_WHILE_FIGHTING;
	
	/**
	 * ID: 103<br>
	 * Message: ݐڑĂAJEgłB<br>
	 * Message: &#24115;&#34399;&#24050;&#22312;&#20351;&#29992;&#20013;&#12290;<br>
	 * Message: This ID is currently logged in.
	 */
	public static final SystemMessageId ID_LOGGED_IN;
	
	/**
	 * ID: 104<br>
	 * Message: ϐgɂ͕ύXł܂B<br>
	 * Message: &#36914;&#34892;&#25915;&#25802;&#26178;&#65292;&#28961;&#27861;&#35722;&#26356;&#27494;&#22120;&#12290;<br>
	 * Message: You cannot change weapons during an attack.
	 */
	public static final SystemMessageId CANNOT_CHANGE_WEAPON_DURING_AN_ATTACK;
	
	/**
	 * ID: 105<br>
	 * Message: $c1 p[eBɏ҂܂B<br>
	 * Message: &#36992;&#35531;&#20102;&#12300;&#36;&#99;&#49;&#12301;&#21152;&#20837;&#38538;&#20237;&#12290;<br>
	 * Message: $c1 has been invited to the party.
	 */
	public static final SystemMessageId C1_INVITED_TO_PARTY;
	
	/**
	 * ID: 106<br>
	 * Message: p[eBɎQ܂B<br>
	 * Message: &#21152;&#20837;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#38538;&#20237;&#12290;<br>
	 * Message: You have joined $s1's party.
	 */
	public static final SystemMessageId YOU_JOINED_S1_PARTY;
	
	/**
	 * ID: 107<br>
	 * Message: $c1p[eBɎQ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#21152;&#20837;&#38538;&#20237;&#12290;<br>
	 * Message: $c1 has joined the party.
	 */
	public static final SystemMessageId C1_JOINED_PARTY;
	
	/**
	 * ID: 108<br>
	 * Message: $c1p[eBEނ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#38626;&#38283;&#38538;&#20237;&#12290;<br>
	 * Message: $c1 has left the party.
	 */
	public static final SystemMessageId C1_LEFT_PARTY;
	
	/**
	 * ID: 109<br>
	 * Message: ^[Qbg܂B<br>
	 * Message: &#37679;&#35492;&#30340;&#30446;&#27161;&#12290;<br>
	 * Message: Invalid target.
	 */
	public static final SystemMessageId INCORRECT_TARGET;
	
	/**
	 * ID: 110<br>
	 * Message: $s1̌ʂ܂B<br>
	 * Message: &#24863;&#21463;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#12290;<br>
	 * Message: $s1 $s2's effect can be felt.
	 */
	public static final SystemMessageId YOU_FEEL_S1_EFFECT;
	
	/**
	 * ID: 111<br>
	 * Message: V[hɂhɐ܂B<br>
	 * Message: &#24744;&#25104;&#21151;&#30340;&#20351;&#29992;&#30462;&#29260;&#36914;&#34892;&#38450;&#31142;&#12290;<br>
	 * Message: Your shield defense has succeeded.
	 */
	public static final SystemMessageId SHIELD_DEFENCE_SUCCESSFULL;
	
	/**
	 * ID: 112<br>
	 * Message: ܂B<br>
	 * Message: &#31661;&#25976;&#19981;&#36275;&#12290;<br>
	 * Message: You have run out of arrows.
	 */
	public static final SystemMessageId NOT_ENOUGH_ARROWS;
	
	/**
	 * ID: 113<br>
	 * Message: Ȃ߁A$s1͎gpł܂B<br>
	 * Message: &#26781;&#20214;&#19981;&#31526;&#65292;&#28961;&#27861;&#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 cannot be used due to unsuitable terms.
	 */
	public static final SystemMessageId S1_CANNOT_BE_USED;
	
	/**
	 * ID: 114<br>
	 * Message: Ẻeɓ܂B<br>
	 * Message: &#24744;&#36914;&#20837;&#19990;&#30028;&#27193;&#30340;&#31840;&#32617;&#31684;&#22285;&#12290;<br>
	 * Message: You have entered the shadow of the Mother Tree.
	 */
	public static final SystemMessageId ENTER_SHADOW_MOTHER_TREE;
	
	/**
	 * ID: 115<br>
	 * Message: Ẻe痣܂B<br>
	 * Message: &#24744;&#38626;&#38283;&#19990;&#30028;&#27193;&#30340;&#31840;&#32617;&#31684;&#22285;&#12290;<br>
	 * Message: You have left the shadow of the Mother Tree.
	 */
	public static final SystemMessageId EXIT_SHADOW_MOTHER_TREE;
	
	/**
	 * ID: 116<br>
	 * Message: s[X][ɓ܂B<br>
	 * Message: &#36914;&#20837;&#23433;&#20840;&#21312;&#22495;&#12290;<br>
	 * Message: You have entered a peaceful zone.
	 */
	public static final SystemMessageId ENTER_PEACEFUL_ZONE;
	
	/**
	 * ID: 117<br>
	 * Message: s[X][痣܂B<br>
	 * Message: &#38626;&#38283;&#23433;&#20840;&#21312;&#22495;&#12290;<br>
	 * Message: You have left the peaceful zone.
	 */
	public static final SystemMessageId EXIT_PEACEFUL_ZONE;
	
	/**
	 * ID: 118<br>
	 * Message: $c1 Ƀg[h\݂܂B<br>
	 * Message: &#35531;&#27714;&#33287;&#12300;&#36;&#99;&#49;&#12301;&#36914;&#34892;&#20132;&#26131;&#12290;<br>
	 * Message: You have requested a trade with $c1.
	 */
	public static final SystemMessageId REQUEST_C1_FOR_TRADE;
	
	/**
	 * ID: 119<br>
	 * Message: $c1 g[hۂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25298;&#32085;&#20132;&#26131;&#12290;<br>
	 * Message: $c1 has denied your request to trade.
	 */
	public static final SystemMessageId C1_DENIED_TRADE_REQUEST;
	
	/**
	 * ID: 120<br>
	 * Message: $c1Ƃ̃g[hJn܂B<br>
	 * Message: &#38283;&#22987;&#33287;&#12300;&#36;&#99;&#49;&#12301;&#36914;&#34892;&#20132;&#26131;&#12290;<br>
	 * Message: You begin trading with $c1.
	 */
	public static final SystemMessageId BEGIN_TRADE_WITH_C1;
	
	/**
	 * ID: 121<br>
	 * Message: $c1 g[hACem肵܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30906;&#35469;&#20132;&#26131;&#20839;&#23481;&#12290;<br>
	 * Message: $c1 has confirmed the trade.
	 */
	public static final SystemMessageId C1_CONFIRMED_TRADE;
	
	/**
	 * ID: 122<br>
	 * Message: 肪g[hACem肵߁AACe̒ǉ͂ł܂B<br>
	 * Message: &#23565;&#26041;&#24050;&#30906;&#35469;&#20132;&#26131;&#20839;&#23481;&#65292;&#19981;&#21487;&#20877;&#22686;&#21152;&#20132;&#26131;&#38917;&#30446;&#12290;<br>
	 * Message: You may no longer adjust items in the trade because the trade has been confirmed.
	 */
	public static final SystemMessageId CANNOT_ADJUST_ITEMS_AFTER_TRADE_CONFIRMED;
	
	/**
	 * ID: 123<br>
	 * Message: g[hɍs܂B<br>
	 * Message: &#20132;&#26131;&#23436;&#25104;&#12290;<br>
	 * Message: Your trade is successful.
	 */
	public static final SystemMessageId TRADE_SUCCESSFUL;
	
	/**
	 * ID: 124<br>
	 * Message: $c1 g[hLZ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#21462;&#28040;&#20132;&#26131;&#12290;<br>
	 * Message: $c1 has cancelled the trade.
	 */
	public static final SystemMessageId C1_CANCELED_TRADE;
	
	/**
	 * ID: 125<br>
	 * Message: Q[I܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#32080;&#26463;&#36938;&#25138;&#21966;&#65311;<br>
	 * Message: Do you wish to exit the game?
	 */
	public static final SystemMessageId WISH_EXIT_GAME;
	
	/**
	 * ID: 126<br>
	 * Message: Q[X^[g܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#37325;&#26032;&#38283;&#22987;&#36938;&#25138;&#21966;&#65311;<br>
	 * Message: Do you wish to return to the character select screen?
	 */
	public static final SystemMessageId WISH_RESTART_GAME;
	
	/**
	 * ID: 127<br>
	 * Message: T[o[Ƃ̐ڑؒf܂B΂炭ĂēxڑB<br>
	 * Message: &#33287;&#20282;&#26381;&#22120;&#30340;&#36899;&#32218;&#32080;&#26463;&#65292;&#35531;&#31245;&#24460;&#20877;&#22039;&#35430;&#36899;&#32218;&#12290;<br>
	 * Message: You have been disconnected from the server. Please login again.
	 */
	public static final SystemMessageId DISCONNECTED_FROM_SERVER;
	
	/**
	 * ID: 128<br>
	 * Message: LN^[̐Ɏs܂B<br>
	 * Message: &#35282;&#33394;&#21109;&#36896;&#22833;&#25943;&#12290;<br>
	 * Message: Your character creation has failed.
	 */
	public static final SystemMessageId CHARACTER_CREATION_FAILED;
	
	/**
	 * ID: 129<br>
	 * Message: Cxg̃XbgςłB<br>
	 * Message: &#25884;&#24118;&#36947;&#20855;&#25976;&#37327;&#24050;&#28415;&#12290;<br>
	 * Message: Your inventory is full.
	 */
	public static final SystemMessageId SLOTS_FULL;
	
	/**
	 * ID: 130<br>
	 * Message: qɂ̃XbgςłB<br>
	 * Message: &#20489;&#24235;&#23384;&#25918;&#25976;&#37327;&#24050;&#28415;&#12290;<br>
	 * Message: Your warehouse is full.
	 */
	public static final SystemMessageId WAREHOUSE_FULL;
	
	/**
	 * ID: 131<br>
	 * Message: $s1OC܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#30331;&#20837;&#12290;<br>
	 * Message: $s1 has logged in.
	 */
	public static final SystemMessageId S1_LOGGED_IN;
	
	/**
	 * ID: 132<br>
	 * Message: $s1FlXgɒǉ܂B<br>
	 * Message: &#24050;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#26032;&#22686;&#33267;&#22909;&#21451;&#21517;&#21934;&#12290;<br>
	 * Message: $s1 has been added to your friends list.
	 */
	public static final SystemMessageId S1_ADDED_TO_FRIENDS;
	
	/**
	 * ID: 133<br>
	 * Message: $s1FlXg폜܂B<br>
	 * Message: &#24050;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#24478;&#22909;&#21451;&#21517;&#21934;&#20013;&#21034;&#38500;&#12290;<br>
	 * Message: $s1 has been removed from your friends list.
	 */
	public static final SystemMessageId S1_REMOVED_FROM_YOUR_FRIENDS_LIST;
	
	/**
	 * ID: 134<br>
	 * Message: FlXgmFĂB<br>
	 * Message: &#35531;&#37325;&#26032;&#30906;&#35469;&#22909;&#21451;&#21517;&#21934;&#12290;<br>
	 * Message: Please check your friends list again.
	 */
	public static final SystemMessageId PLEACE_CHECK_YOUR_FRIEND_LIST_AGAIN;
	
	/**
	 * ID: 135<br>
	 * Message: $c1Ȃ߁Ap[eB҂LZ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#20006;&#26410;&#22238;&#35206;&#65292;&#32068;&#38538;&#36992;&#35531;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: $c1 did not reply to your invitation. Your invitation has been cancelled.
	 */
	public static final SystemMessageId C1_DID_NOT_REPLY_TO_YOUR_INVITE;
	
	/**
	 * ID: 136<br>
	 * Message: $c1̏҂ɉȂ߁ALZ܂B<br>
	 * Message: &#24744;&#26410;&#22238;&#35206;&#12300;&#36;&#99;&#49;&#12301;&#65292;&#32068;&#38538;&#30340;&#36992;&#35531;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: You have not replied to $c1's invitation. The offer has been cancelled.
	 */
	public static final SystemMessageId YOU_DID_NOT_REPLY_TO_C1_INVITE;
	
	/**
	 * ID: 137<br>
	 * Message: V[gJbgɎw肳ꂽACe܂B<br>
	 * Message: &#29105;&#37749;&#20839;&#24050;&#27794;&#26377;&#36947;&#20855;&#12290;<br>
	 * Message: There are no more items in the shortcut.
	 */
	public static final SystemMessageId NO_MORE_ITEMS_SHORTCUT;
	
	/**
	 * ID: 138<br>
	 * Message: V[gJbgw肳Ă܂B<br>
	 * Message: &#26410;&#35373;&#23450;&#24555;&#36895;&#37749;&#12290;<br>
	 * Message: Designate shortcut.
	 */
	public static final SystemMessageId DESIGNATE_SHORTCUT;
	
	/**
	 * ID: 139<br>
	 * Message: $c1$s2ɂ܂łB<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#23565;&#12300;&#36;&#99;&#49;&#12301;&#27794;&#26377;&#25928;&#26524;&#12290;<br>
	 * Message: $c1 has resisted your $s2.
	 */
	public static final SystemMessageId C1_RESISTED_YOUR_S2;
	
	/**
	 * ID: 140<br>
	 * Message: MPȂ߁AXLf܂B<br>
	 * Message: &#77;&#80;&#19981;&#36275;&#65292;&#25216;&#33021;&#35299;&#38500;&#12290;<br>
	 * Message: Your skill was removed due to a lack of MP.
	 */
	public static final SystemMessageId SKILL_REMOVED_DUE_LACK_MP;
	
	/**
	 * ID: 141<br>
	 * Message: g[hACem肵߁AACe̒ǉ͂ł܂B<br>
	 * Message: &#24050;&#30906;&#35469;&#20132;&#26131;&#20839;&#23481;&#65292;&#19981;&#21487;&#20877;&#22686;&#21152;&#20132;&#26131;&#38917;&#30446;&#12290;<br>
	 * Message: Once the trade is confirmed, the item cannot be moved again.
	 */
	public static final SystemMessageId ONCE_THE_TRADE_IS_CONFIRMED_THE_ITEM_CANNOT_BE_MOVED_AGAIN;
	
	/**
	 * ID: 142<br>
	 * Message: łɃg[hłB<br>
	 * Message: &#20132;&#26131;&#36914;&#34892;&#20013;&#12290;<br>
	 * Message: You are already trading with someone.
	 */
	public static final SystemMessageId ALREADY_TRADING;
	
	/**
	 * ID: 143<br>
	 * Message: $c1 ͑̐lƃg[hĂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#33287;&#20182;&#20154;&#36914;&#34892;&#20132;&#26131;&#12290;<br>
	 * Message: $c1 is already trading with another person. Please try again later.
	 */
	public static final SystemMessageId C1_ALREADY_TRADING;
	
	/**
	 * ID: 144<br>
	 * Message: ^[Qbg܂B<br>
	 * Message: &#30446;&#27161;&#37679;&#35492;&#12290;<br>
	 * Message: That is the incorrect target.
	 */
	public static final SystemMessageId TARGET_IS_INCORRECT;
	
	/**
	 * ID: 145<br>
	 * Message: ^[QbgQ[ɂ܂B<br>
	 * Message: &#23565;&#26041;&#19981;&#22312;&#36938;&#25138;&#20013;&#12290;<br>
	 * Message: That player is not online.
	 */
	public static final SystemMessageId TARGET_IS_NOT_FOUND_IN_THE_GAME;
	
	/**
	 * ID: 146<br>
	 * Message: `bg܂B<br>
	 * Message: &#24744;&#21487;&#20197;&#35527;&#35441;&#20102;&#12290;<br>
	 * Message: Chatting is now permitted.
	 */
	public static final SystemMessageId CHATTING_PERMITTED;
	
	/**
	 * ID: 147<br>
	 * Message: `bg֎~܂B<br>
	 * Message: &#24744;&#28961;&#27861;&#35527;&#35441;&#12290;<br>
	 * Message: Chatting is currently prohibited.
	 */
	public static final SystemMessageId CHATTING_PROHIBITED;
	
	/**
	 * ID: 148<br>
	 * Message: NGXg ACe͎gpł܂B<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#20219;&#21209;&#36947;&#20855;&#12290;<br>
	 * Message: You cannot use quest items.
	 */
	public static final SystemMessageId CANNOT_USE_QUEST_ITEMS;
	
	/**
	 * ID: 149<br>
	 * Message: g[h̓ACeEgpł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#28961;&#27861;&#25791;&#21462;&#25110;&#20351;&#29992;&#36947;&#20855;&#12290;<br>
	 * Message: You cannot pick up or use items while trading.
	 */
	public static final SystemMessageId CANNOT_USE_ITEM_WHILE_TRADING;
	
	/**
	 * ID: 150<br>
	 * Message: lXg[hɁAACêĂ邱Ƃj󂷂邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#19999;&#26820;&#25110;&#21034;&#38500;&#20491;&#20154;&#21830;&#24215;&#12289;&#20132;&#26131;&#20013;&#30340;&#29289;&#21697;&#12290;<br>
	 * Message: You cannot discard or destroy an item while trading at a private store.
	 */
	public static final SystemMessageId CANNOT_DISCARD_OR_DESTROY_ITEM_WHILE_TRADING;
	
	/**
	 * ID: 151<br>
	 * Message: ߂Ď̂Ă܂B<br>
	 * Message: &#36317;&#38626;&#22826;&#36960;&#28961;&#27861;&#19999;&#26820;&#12290;<br>
	 * Message: That is too far from you to discard.
	 */
	public static final SystemMessageId CANNOT_DISCARD_DISTANCE_TOO_FAR;
	
	/**
	 * ID: 152<br>
	 * Message: ҂Ώۂ܂B<br>
	 * Message: &#36992;&#35531;&#23565;&#35937;&#37679;&#35492;&#12290;<br>
	 * Message: You have invited the wrong target.
	 */
	public static final SystemMessageId YOU_HAVE_INVITED_THE_WRONG_TARGET;
	
	/**
	 * ID: 153<br>
	 * Message: $c1 ͍ƒłB΂炭Ă\ȂĂB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#36914;&#34892;&#20854;&#20182;&#21205;&#20316;&#65292;&#35531;&#31245;&#24460;&#20877;&#36992;&#35531;&#12290;<br>
	 * Message: $c1 is on another task. Please try again later.
	 */
	public static final SystemMessageId C1_IS_BUSY_TRY_LATER;
	
	/**
	 * ID: 154<br>
	 * Message: p[eB [_[҂gpł܂B<br>
	 * Message: &#21482;&#26377;&#38538;&#38263;&#21487;&#20197;&#25552;&#20986;&#36992;&#35531;&#12290;<br>
	 * Message: Only the leader can give out invitations.
	 */
	public static final SystemMessageId ONLY_LEADER_CAN_INVITE;
	
	/**
	 * ID: 155<br>
	 * Message: p[eBɂȂ܂B<br>
	 * Message: &#38538;&#20237;&#21517;&#38989;&#24050;&#28415;&#12290;<br>
	 * Message: The party is full.
	 */
	public static final SystemMessageId PARTY_FULL;
	
	/**
	 * ID: 156<br>
	 * Message: hC܂B<br>
	 * Message: &#33021;&#37327;&#21560;&#21462;&#20013;&#26039;&#12290;<br>
	 * Message: Drain was only 50 percent successful.
	 */
	public static final SystemMessageId DRAIN_HALF_SUCCESFUL;
	
	/**
	 * ID: 157<br>
	 * Message: $c1̃hCɒR܂B<br>
	 * Message: &#25104;&#21151;&#25269;&#25239;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#33021;&#37327;&#21560;&#21462;&#12290;<br>
	 * Message: You resisted $c1's drain.
	 */
	public static final SystemMessageId RESISTED_C1_DRAIN;
	
	/**
	 * ID: 158<br>
	 * Message: Us܂B<br>
	 * Message: &#25915;&#25802;&#22833;&#25943;&#12290;<br>
	 * Message: Your attack has failed.
	 */
	public static final SystemMessageId ATTACK_FAILED;
	
	/**
	 * ID: 159<br>
	 * Message: $c1̖@ɒR܂B<br>
	 * Message: &#25104;&#21151;&#25269;&#25239;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#39764;&#27861;&#12290;<br>
	 * Message: You resisted $c1's magic.
	 */
	public static final SystemMessageId RESISTED_C1_MAGIC;
	
	/**
	 * ID: 160<br>
	 * Message: $c1 ͂łɃp[eBɏĂ邽߁A҂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#38584;&#23660;&#26044;&#20854;&#20182;&#38538;&#20237;&#65292;&#25925;&#28961;&#27861;&#36914;&#34892;&#36992;&#35531;&#12290;<br>
	 * Message: $c1 is a member of another party and cannot be invited.
	 */
	public static final SystemMessageId C1_IS_ALREADY_IN_PARTY;
	
	/**
	 * ID: 161<br>
	 * Message: p[eBɏ҂[U[܂B<br>
	 * Message: &#24744;&#24819;&#36992;&#35531;&#21152;&#20837;&#38538;&#20237;&#30340;&#29609;&#23478;&#19981;&#23384;&#22312;&#12290;<br>
	 * Message: That player is not currently online.
	 */
	public static final SystemMessageId INVITED_USER_NOT_ONLINE;
	
	/**
	 * ID: 162<br>
	 * Message: qɂ߂Ă܂B<br>
	 * Message: &#36317;&#38626;&#20489;&#24235;&#22826;&#36960;&#12290;<br>
	 * Message: Warehouse is too far.
	 */
	public static final SystemMessageId WAREHOUSE_TOO_FAR;
	
	/**
	 * ID: 163<br>
	 * Message: Ȃ߁Ajł܂B<br>
	 * Message: &#25976;&#37327;&#37679;&#35492;&#65292;&#25925;&#28961;&#27861;&#21034;&#38500;&#12290;<br>
	 * Message: You cannot destroy it because the number is incorrect.
	 */
	public static final SystemMessageId CANNOT_DESTROY_NUMBER_INCORRECT;
	
	/**
	 * ID: 164<br>
	 * Message: ̃vZX̉҂Ă܂B<br>
	 * Message: &#27491;&#31561;&#24453;&#20854;&#20182;&#24037;&#20316;&#30340;&#22238;&#25033;&#12290;<br>
	 * Message: Waiting for another reply.
	 */
	public static final SystemMessageId WAITING_FOR_ANOTHER_REPLY;
	
	/**
	 * ID: 165<br>
	 * Message: gFlƂēo^邱Ƃ͂ł܂B<br>
	 * Message: &#19981;&#21487;&#23559;&#33258;&#24049;&#30331;&#35352;&#28858;&#22909;&#21451;&#12290;<br>
	 * Message: You cannot add yourself to your own friend list.
	 */
	public static final SystemMessageId YOU_CANNOT_ADD_YOURSELF_TO_OWN_FRIEND_LIST;
	
	/**
	 * ID: 166<br>
	 * Message: FlXg܂쐬Ă܂B΂炭Ăo^ȂĂB<br>
	 * Message: &#23578;&#28961;&#27861;&#35069;&#20316;&#22909;&#21451;&#21517;&#21934;&#65292;&#35531;&#26085;&#24460;&#20877;&#30331;&#35352;&#12290;<br>
	 * Message: Friend list is not ready yet. Please register again later.
	 */
	public static final SystemMessageId FRIEND_LIST_NOT_READY_YET_REGISTER_LATER;
	
	/**
	 * ID: 167<br>
	 * Message: $c1 ͂łɗFlXgɓo^Ă܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30331;&#35352;&#22312;&#22909;&#21451;&#21517;&#21934;&#19978;&#12290;<br>
	 * Message: $c1 is already on your friend list.
	 */
	public static final SystemMessageId C1_ALREADY_ON_FRIEND_LIST;
	
	/**
	 * ID: 168<br>
	 * Message: $c1 FlXg̓o^v܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#22909;&#21451;&#21517;&#21934;&#12290;<br>
	 * Message: $c1 has sent a friend request.
	 */
	public static final SystemMessageId C1_REQUESTED_TO_BECOME_FRIENDS;
	
	/**
	 * ID: 169<br>
	 * Message: o^܂B 0/1 (1Aۂ0)<br>
	 * Message: &#31572;&#25033;&#21152;&#20837;&#22909;&#21451;&#32;&#48;&#47;&#49;&#65288;&#48;&#32;&#25298;&#32085;&#65292;&#49;&#32;&#31572;&#25033;&#65289;<br>
	 * Message: Accept friendship 0/1 (1 to accept, 0 to deny)
	 */
	public static final SystemMessageId ACCEPT_THE_FRIENDSHIP;
	
	/**
	 * ID: 170<br>
	 * Message: Flo^v[U[Q[ɂ܂B<br>
	 * Message: &#36992;&#35531;&#21152;&#20837;&#22909;&#21451;&#30340;&#29609;&#23478;&#19981;&#22312;&#32218;&#19978;&#12290;<br>
	 * Message: The user who requested to become friends is not found in the game.
	 */
	public static final SystemMessageId THE_USER_YOU_REQUESTED_IS_NOT_IN_GAME;
	
	/**
	 * ID: 171<br>
	 * Message: $c1 ͗FlXgɓo^Ă郆[U[ł͂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#20006;&#26410;&#30331;&#35352;&#22312;&#22909;&#21451;&#21517;&#21934;&#19978;&#12290;<br>
	 * Message: $c1 is not on your friend list.
	 */
	public static final SystemMessageId C1_NOT_ON_YOUR_FRIENDS_LIST;
	
	/**
	 * ID: 172<br>
	 * Message: ۊǗ܂B<br>
	 * Message: &#28961;&#20445;&#31649;&#36027;&#12290;<br>
	 * Message: You lack the funds needed to pay for this transaction.
	 */
	public static final SystemMessageId LACK_FUNDS_FOR_TRANSACTION1;
	
	/**
	 * ID: 173<br>
	 * Message: ۊǗ܂B<br>
	 * Message: &#20445;&#31649;&#36027;&#19981;&#36275;&#12290;<br>
	 * Message: You lack the funds needed to pay for this transaction.
	 */
	public static final SystemMessageId LACK_FUNDS_FOR_TRANSACTION2;
	
	/**
	 * ID: 174<br>
	 * Message: ̃Cxg̃XbgςłB<br>
	 * Message: &#23565;&#26041;&#25884;&#24118;&#36947;&#20855;&#25976;&#37327;&#24050;&#28415;&#12290;<br>
	 * Message: That person's inventory is full.
	 */
	public static final SystemMessageId OTHER_INVENTORY_FULL;
	
	/**
	 * ID: 175<br>
	 * Message: HPSɉ񕜂ꂽ߁AXLf܂B<br>
	 * Message: &#72;&#80;&#23436;&#20840;&#24674;&#24489;&#65292;&#25216;&#33021;&#25928;&#26524;&#35299;&#38500;&#12290;<br>
	 * Message: That skill has been de-activated as HP was fully recovered.
	 */
	public static final SystemMessageId SKILL_DEACTIVATED_HP_FULL;
	
	/**
	 * ID: 176<br>
	 * Message: ̓bZ[WMs\ȏԂłB<br>
	 * Message: &#23565;&#26041;&#30446;&#21069;&#38364;&#38281;&#23494;&#35527;&#12290;<br>
	 * Message: That person is in message refusal mode.
	 */
	public static final SystemMessageId THE_PERSON_IS_IN_MESSAGE_REFUSAL_MODE;
	
	/**
	 * ID: 177<br>
	 * Message: bZ[WMs\ȏԂłB<br>
	 * Message: &#25298;&#32085;&#25509;&#25910;&#23494;&#35527;&#12290;<br>
	 * Message: Message refusal mode.
	 */
	public static final SystemMessageId MESSAGE_REFUSAL_MODE;
	
	/**
	 * ID: 178<br>
	 * Message: bZ[WM̏ԂłB<br>
	 * Message: &#20801;&#35377;&#25509;&#25910;&#23494;&#35527;&#12290;<br>
	 * Message: Message acceptance mode.
	 */
	public static final SystemMessageId MESSAGE_ACCEPTANCE_MODE;
	
	/**
	 * ID: 179<br>
	 * Message: ł̓ACêĂ܂B<br>
	 * Message: &#27492;&#34389;&#19981;&#21487;&#19999;&#26820;&#29289;&#21697;&#12290;<br>
	 * Message: You cannot discard those items here.
	 */
	public static final SystemMessageId CANT_DISCARD_HERE;
	
	/**
	 * ID: 180<br>
	 * Message: 폜܂$s1cĂ܂B폜LZ܂B<br>
	 * Message: &#36317;&#38626;&#21034;&#38500;&#26085;&#26399;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#22825;&#65292;&#35201;&#21462;&#28040;&#21034;&#38500;&#21966;&#65311;<br>
	 * Message: You have $s1 day(s) left until deletion. Do you wish to cancel this action?
	 */
	public static final SystemMessageId S1_DAYS_LEFT_CANCEL_ACTION;
	
	/**
	 * ID: 181<br>
	 * Message: ^[Qbg܂B<br>
	 * Message: &#30446;&#27161;&#30475;&#19981;&#28165;&#26970;&#12290;<br>
	 * Message: Cannot see target.
	 */
	public static final SystemMessageId CANT_SEE_TARGET;
	
	/**
	 * ID: 182<br>
	 * Message: NGXgF$s1𒆒f܂B<br>
	 * Message: &#35201;&#20013;&#27490;&#30446;&#21069;&#25152;&#36984;&#25799;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#20219;&#21209;&#21966;&#65311;<br>
	 * Message: Do you want to quit the current quest?
	 */
	public static final SystemMessageId WANT_QUIT_CURRENT_QUEST;
	
	/**
	 * ID: 183<br>
	 * Message: T[o[̐lɒB܂B΂炭ĂڑȂĂ݂ĂB<br>
	 * Message: &#20282;&#26381;&#22120;&#20154;&#25976;&#24050;&#28415;&#65292;&#35531;&#36984;&#25799;&#20854;&#20182;&#20282;&#26381;&#22120;&#25110;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: There are too many users on the server. Please try again later
	 */
	public static final SystemMessageId TOO_MANY_USERS;
	
	/**
	 * ID: 184<br>
	 * Message: ΂炭Ă蒼ĂB<br>
	 * Message: &#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: Please try again later.
	 */
	public static final SystemMessageId TRY_AGAIN_LATER;
	
	/**
	 * ID: 185<br>
	 * Message: p[eBɏ҂郆[U[IĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#27442;&#36992;&#35531;&#21152;&#20837;&#38538;&#20237;&#30340;&#29609;&#23478;&#12290;<br>
	 * Message: You must first select a user to invite to your party.
	 */
	public static final SystemMessageId FIRST_SELECT_USER_TO_INVITE_TO_PARTY;
	
	/**
	 * ID: 186<br>
	 * Message: U郆[U[IĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#27442;&#36992;&#35531;&#21152;&#20837;&#34880;&#30431;&#30340;&#29609;&#23478;&#12290;<br>
	 * Message: You must first select a user to invite to your clan.
	 */
	public static final SystemMessageId FIRST_SELECT_USER_TO_INVITE_TO_CLAN;
	
	/**
	 * ID: 187<br>
	 * Message: Ǖ郆[U[IĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#38283;&#38500;&#30340;&#29609;&#23478;&#12290;<br>
	 * Message: Select user to expel.
	 */
	public static final SystemMessageId SELECT_USER_TO_EXPEL;
	
	/**
	 * ID: 188<br>
	 * Message: ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#34880;&#30431;&#30340;&#21517;&#31281;&#12290;<br>
	 * Message: Please create your clan name.
	 */
	public static final SystemMessageId PLEASE_CREATE_CLAN_NAME;
	
	/**
	 * ID: 189<br>
	 * Message: n݂܂B<br>
	 * Message: &#34880;&#30431;&#21109;&#31435;&#12290;<br>
	 * Message: Your clan has been created.
	 */
	public static final SystemMessageId CLAN_CREATED;
	
	/**
	 * ID: 190<br>
	 * Message: ̑n݂Ɏs܂B<br>
	 * Message: &#34880;&#30431;&#21109;&#31435;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to create a clan.
	 */
	public static final SystemMessageId FAILED_TO_CREATE_CLAN;
	
	/**
	 * ID: 191<br>
	 * Message:  $s1珜܂B<br>
	 * Message: &#30431;&#21451;&#12300;&#36;&#115;&#49;&#12301;&#34987;&#34880;&#30431;&#38283;&#38500;&#12290;<br>
	 * Message: Clan member $s1 has been expelled.
	 */
	public static final SystemMessageId CLAN_MEMBER_S1_EXPELLED;
	
	/**
	 * ID: 192<br>
	 * Message:  $s1̏Ɏs܂B<br>
	 * Message: &#26410;&#33021;&#38283;&#38500;&#34880;&#30431;&#20839;&#30340;&#30431;&#21729;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have failed to expel $s1 from the clan.
	 */
	public static final SystemMessageId FAILED_EXPEL_S1;
	
	/**
	 * ID: 193<br>
	 * Message: U܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#24050;&#35299;&#25955;&#12290;<br>
	 * Message: Clan has dispersed.
	 */
	public static final SystemMessageId CLAN_HAS_DISPERSED;
	
	/**
	 * ID: 194<br>
	 * Message: ̉UɎs܂B<br>
	 * Message: &#34880;&#30431;&#35299;&#25955;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to disperse the clan.
	 */
	public static final SystemMessageId FAILED_TO_DISPERSE_CLAN;
	
	/**
	 * ID: 195<br>
	 * Message: ɉ܂B<br>
	 * Message: &#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: Entered the clan.
	 */
	public static final SystemMessageId ENTERED_THE_CLAN;
	
	/**
	 * ID: 196<br>
	 * Message: $s1ۂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#25298;&#32085;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: $s1 declined your clan invitation.
	 */
	public static final SystemMessageId S1_REFUSED_TO_JOIN_CLAN;
	
	/**
	 * ID: 197<br>
	 * Message: Eނ܂B<br>
	 * Message: &#24744;&#24050;&#33067;&#38626;&#34880;&#30431;&#12290;<br>
	 * Message: You have withdrawn from the clan.
	 */
	public static final SystemMessageId YOU_HAVE_WITHDRAWN_FROM_CLAN;
	
	/**
	 * ID: 198<br>
	 * Message: $s1̒EނɎs܂B<br>
	 * Message: &#26410;&#33021;&#33067;&#38626;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#12290;<br>
	 * Message: You have failed to withdraw from the $s1 clan.
	 */
	public static final SystemMessageId FAILED_TO_WITHDRAW_FROM_S1_CLAN;
	
	/**
	 * ID: 199<br>
	 * Message: 珜܂B1Ԃ͑̌ɉł܂B<br>
	 * Message: &#24744;&#34987;&#34880;&#30431;&#38283;&#38500;&#20102;&#12290;&#49;&#26085;&#20839;&#28961;&#27861;&#21152;&#20837;&#20854;&#20182;&#34880;&#30431;&#12290;<br>
	 * Message: You have recently been dismissed from a clan. You are not allowed to join another clan for 24-hours.
	 */
	public static final SystemMessageId CLAN_MEMBERSHIP_TERMINATED;
	
	/**
	 * ID: 200<br>
	 * Message: p[eBEނ܂B<br>
	 * Message: &#24744;&#24050;&#33067;&#38626;&#38538;&#20237;&#12290;<br>
	 * Message: You have withdrawn from the party.
	 */
	public static final SystemMessageId YOU_LEFT_PARTY;
	
	/**
	 * ID: 201<br>
	 * Message: $c1p[eBǕ܂B<br>
	 * Message: &#23559;&#38538;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#33258;&#38538;&#20237;&#20013;&#38500;&#21517;&#12290;<br>
	 * Message: $c1 was expelled from the party.
	 */
	public static final SystemMessageId C1_WAS_EXPELLED_FROM_PARTY;
	
	/**
	 * ID: 202<br>
	 * Message: p[eBǕ܂B<br>
	 * Message: &#24744;&#34987;&#38538;&#20237;&#38500;&#21517;&#12290;<br>
	 * Message: You have been expelled from the party.
	 */
	public static final SystemMessageId HAVE_BEEN_EXPELLED_FROM_PARTY;
	
	/**
	 * ID: 203<br>
	 * Message: p[eBU܂B<br>
	 * Message: &#38538;&#20237;&#35299;&#25955;&#12290;<br>
	 * Message: The party has dispersed.
	 */
	public static final SystemMessageId PARTY_DISPERSED;
	
	/**
	 * ID: 204<br>
	 * Message: ̐zĂ邩AsK؂ȕgpĂ܂B蒼ĂB<br>
	 * Message: &#37679;&#35492;&#30340;&#21517;&#31281;&#65292;&#35531;&#20877;&#27425;&#36664;&#20837;&#12290;<br>
	 * Message: Incorrect name. Please try again.
	 */
	public static final SystemMessageId INCORRECT_NAME_TRY_AGAIN;
	
	/**
	 * ID: 205<br>
	 * Message: LN^[܂BT|[gɂ₢킹B<br>
	 * Message: &#35282;&#33394;&#21517;&#31281;&#37679;&#35492;&#65292;&#35531;&#27965;&#35426;&#31649;&#29702;&#20154;&#21729;&#12290;<br>
	 * Message: Incorrect character name. Please try again.
	 */
	public static final SystemMessageId INCORRECT_CHARACTER_NAME_TRY_AGAIN;
	
	/**
	 * ID: 206<br>
	 * Message: z錌͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#23459;&#25136;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: Please enter the name of the clan you wish to declare war on.
	 */
	public static final SystemMessageId ENTER_CLAN_NAME_TO_DECLARE_WAR;
	
	/**
	 * ID: 207<br>
	 * Message: $s1$s2Ɍ\܂܂B󂯓܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#25552;&#20986;&#30431;&#25136;&#35201;&#27714;&#65292;&#35201;&#25509;&#21463;&#25361;&#25136;&#21966;&#65311;<br>
	 * Message: $s2 of the clan $s1 requests declaration of war. Do you accept?
	 */
	public static final SystemMessageId S2_OF_THE_CLAN_S1_REQUESTS_WAR;
	
	/**
	 * ID: 208<br>
	 * Message: o^摜t@C̊gq܂ރtpX͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#27491;&#30906;&#30340;&#27284;&#26696;&#36335;&#24465;&#65288;&#21253;&#21547;&#21103;&#27284;&#21517;&#65289;&#12290;<br>
	 * Message: Please include file type when entering file path.
	 */
	
	/**
	 * ID: 209<br>
	 * Message: 摜t@C̃TCY܂B16x12sNZɎw肵ĂB<br>
	 * Message: &#22294;&#20687;&#27284;&#26696;&#19981;&#31526;&#65292;&#35531;&#20351;&#29992;&#49;&#54;&#42;&#49;&#50;&#20687;&#32032;&#65292;&#50;&#53;&#54;&#33394;&#30340;&#98;&#109;&#112;&#27284;&#26696;&#12290;<br>
	 * Message: The size of the image file is inappropriate. Please adjust to 16x12 pixels.
	 */
	
	/**
	 * ID: 210<br>
	 * Message: t@C܂BpX͂ĂB<br>
	 * Message: &#28961;&#27861;&#25214;&#21040;&#27284;&#26696;&#65292;&#35531;&#37325;&#26032;&#36664;&#20837;&#27491;&#30906;&#36335;&#24465;&#12290;<br>
	 * Message: Cannot find file. Please enter precise path.
	 */
	
	/**
	 * ID: 211<br>
	 * Message: 16x12sNZ256FBMPt@Ĉݓo^ł܂B<br>
	 * Message: &#21482;&#33021;&#19978;&#20659;&#49;&#54;&#42;&#49;&#50;&#20687;&#32032;&#65292;&#50;&#53;&#54;&#33394;&#30340;&#98;&#109;&#112;&#27284;&#26696;&#12290;<br>
	 * Message: You can only register 16x12 pixel 256 color bmp files.
	 */
	
	/**
	 * ID: 212<br>
	 * Message: 錌ł͂܂B<br>
	 * Message: &#23565;&#26041;&#20006;&#38750;&#25152;&#23660;&#34880;&#30431;&#30340;&#25104;&#21729;&#12290;<br>
	 * Message: You are not a clan member and cannot perform this action.
	 */
	public static final SystemMessageId YOU_ARE_NOT_A_CLAN_MEMBER;
	
	/**
	 * ID: 213<br>
	 * Message: ܂łB΂炭Ă蒼ĂB<br>
	 * Message: &#23578;&#26410;&#34389;&#29702;&#65292;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: Not working. Please try again later.
	 */
	public static final SystemMessageId NOT_WORKING_PLEASE_TRY_AGAIN_LATER;
	
	/**
	 * ID: 214<br>
	 * Message: ^CgύX܂B<br>
	 * Message: &#31281;&#34399;&#24050;&#25913;&#35722;&#12290;<br>
	 * Message: Your title has been changed.
	 */
	public static final SystemMessageId TITLE_CHANGED;
	
	/**
	 * ID: 215<br>
	 * Message: $s1 Ƃ̐푈n܂܂B<br>
	 * Message: &#33287;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#30431;&#25136;&#38283;&#22987;&#12290;<br>
	 * Message: War with the $s1 clan has begun.
	 */
	public static final SystemMessageId WAR_WITH_THE_S1_CLAN_HAS_BEGUN;
	
	/**
	 * ID: 216<br>
	 * Message: $s1 Ƃ̐푈I܂B<br>
	 * Message: &#33287;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#30431;&#25136;&#32080;&#26463;&#12290;<br>
	 * Message: War with the $s1 clan has ended.
	 */
	public static final SystemMessageId WAR_WITH_THE_S1_CLAN_HAS_ENDED;
	
	/**
	 * ID: 217<br>
	 * Message: $s1 Ƃ̐푈ŏ܂I<br>
	 * Message: &#33287;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#38291;&#30340;&#25136;&#29229;&#21213;&#21033;&#12290;<br>
	 * Message: You have won the war over the $s1 clan!
	 */
	public static final SystemMessageId YOU_HAVE_WON_THE_WAR_OVER_THE_S1_CLAN;
	
	/**
	 * ID: 218<br>
	 * Message: $s1 ɍ~܂B<br>
	 * Message: &#21521;&#36;&#115;&#49;&#34880;&#30431;&#25237;&#38477;&#12290;<br>
	 * Message: You have surrendered to the $s1 clan.
	 */
	public static final SystemMessageId YOU_HAVE_SURRENDERED_TO_THE_S1_CLAN;
	
	/**
	 * ID: 219<br>
	 * Message: 傪SA$s1 ɕ܂B<br>
	 * Message: &#30431;&#20027;&#27515;&#20129;&#65292;&#33287;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#38291;&#30340;&#25136;&#29229;&#22833;&#25943;&#12290;<br>
	 * Message: Your clan leader has died. You have been defeated by the $s1 clan.
	 */
	public static final SystemMessageId YOU_WERE_DEFEATED_BY_S1_CLAN;
	
	/**
	 * ID: 220<br>
	 * Message: ̏I܂ł $s1łB<br>
	 * Message: &#38626;&#30431;&#25136;&#32080;&#26463;&#30340;&#26178;&#38291;&#23578;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: You have $s1 minutes left until the clan war ends.
	 */
	public static final SystemMessageId S1_MINUTES_LEFT_UNTIL_CLAN_WAR_ENDS;
	
	/**
	 * ID: 221<br>
	 * Message: ̐Ԃ߂A$s1 Ƃ̐푈I܂B<br>
	 * Message: &#30431;&#25136;&#38480;&#21046;&#26178;&#38291;&#24050;&#21040;&#65292;&#33287;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#38291;&#30340;&#25136;&#29229;&#32080;&#26463;&#12290;<br>
	 * Message: The time limit for the clan war is up. War with the $s1 clan is over.
	 */
	public static final SystemMessageId CLAN_WAR_WITH_S1_CLAN_HAS_ENDED;
	
	/**
	 * ID: 222<br>
	 * Message: $s1ɉ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: $s1 has joined the clan.
	 */
	public static final SystemMessageId S1_HAS_JOINED_CLAN;
	
	/**
	 * ID: 223<br>
	 * Message:  $s1Eނ܂B<br>
	 * Message: &#30431;&#21451;&#12300;&#36;&#115;&#49;&#12301;&#33067;&#38626;&#34880;&#30431;&#12290;<br>
	 * Message: $s1 has withdrawn from the clan.
	 */
	public static final SystemMessageId S1_HAS_WITHDRAWN_FROM_THE_CLAN;
	
	/**
	 * ID: 224<br>
	 * Message: $s1Ȃ߁ÅULZ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20006;&#26410;&#22238;&#35206;&#65292;&#21152;&#20837;&#34880;&#30431;&#30340;&#36992;&#35531;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: $s1 did not respond: Invitation to the clan has been cancelled.
	 */
	public static final SystemMessageId S1_DID_NOT_RESPOND_TO_CLAN_INVITATION;
	
	/**
	 * ID: 225<br>
	 * Message: $s1̊UɉȂ߁ALZ܂B<br>
	 * Message: &#24744;&#26410;&#22238;&#35206;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#21152;&#20837;&#34880;&#30431;&#30340;&#36992;&#35531;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: You didn't respond to $s1's invitation: joining has been cancelled.
	 */
	public static final SystemMessageId YOU_DID_NOT_RESPOND_TO_S1_CLAN_INVITATION;
	
	/**
	 * ID: 226<br>
	 * Message: $s1Ȃ߁Azۂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#20006;&#26410;&#22238;&#35206;&#65292;&#30431;&#25136;&#35201;&#27714;&#24050;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: The $s1 clan did not respond: war proclamation has been refused.
	 */
	public static final SystemMessageId S1_CLAN_DID_NOT_RESPOND;
	
	/**
	 * ID: 227<br>
	 * Message: $s1̐zɉȂ߁A킪ۂ܂B<br>
	 * Message: &#24744;&#26410;&#22238;&#35206;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#65292;&#24050;&#33258;&#21205;&#25298;&#32085;&#20102;&#30431;&#25136;&#35201;&#27714;&#12290;<br>
	 * Message: Clan war has been refused because you did not respond to $s1 clan's war proclamation.
	 */
	public static final SystemMessageId CLAN_WAR_REFUSED_YOU_DID_NOT_RESPOND_TO_S1;
	
	/**
	 * ID: 228<br>
	 * Message: Ivۂ܂B<br>
	 * Message: &#20572;&#25136;&#35531;&#27714;&#36973;&#25298;&#32085;&#12290;<br>
	 * Message: Request to end war has been denied.
	 */
	public static final SystemMessageId REQUEST_TO_END_WAR_HAS_BEEN_DENIED;
	
	/**
	 * ID: 229<br>
	 * Message: n݂̎i܂B<br>
	 * Message: &#21109;&#31435;&#34880;&#30431;&#30340;&#36039;&#26684;&#19981;&#31526;&#12290;<br>
	 * Message: You do not meet the criteria in order to create a clan.
	 */
	public static final SystemMessageId YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN;
	
	/**
	 * ID: 230<br>
	 * Message: U10ȓɂ͐Vn݂ł܂B<br>
	 * Message: &#34880;&#30431;&#35299;&#25955;&#24460;&#49;&#48;&#26085;&#20839;&#19981;&#21487;&#21109;&#31435;&#26032;&#34880;&#30431;&#12290;<br>
	 * Message: You must wait 10 days before creating a new clan.
	 */
	public static final SystemMessageId YOU_MUST_WAIT_XX_DAYS_BEFORE_CREATING_A_NEW_CLAN;
	
	/**
	 * ID: 231<br>
	 * Message: ̏1ȓɂ͐V̉͂ł܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#36973;&#38500;&#21517;&#25110;&#33067;&#38626;&#34880;&#30431;&#24460;&#49;&#26085;&#20839;&#28961;&#27861;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: After a clan member is dismissed from a clan, the clan must wait at least a day before accepting a new member.
	 */
	public static final SystemMessageId YOU_MUST_WAIT_BEFORE_ACCEPTING_A_NEW_MEMBER;
	
	/**
	 * ID: 232<br>
	 * Message: ܂͒Eތ1ȓɂ͌ɉł܂B<br>
	 * Message: &#34987;&#34880;&#30431;&#38500;&#21517;&#25110;&#33067;&#38626;&#34880;&#30431;&#24460;&#49;&#26085;&#20839;&#28961;&#27861;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: After leaving or having been dismissed from a clan, you must wait at least a day before joining another clan.
	 */
	public static final SystemMessageId YOU_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN;
	
	/**
	 * ID: 233<br>
	 * Message: AJf~[/߉q/Rmc̋󂫂܂̂ŁAVȌ̉͂ł܂B<br>
	 * Message: &#23416;&#38498;&#47;&#35242;&#34907;&#38538;&#47;&#39438;&#22763;&#22296;&#20154;&#25976;&#24050;&#28415;&#65292;&#28961;&#27861;&#21152;&#20837;&#26032;&#25104;&#21729;&#12290;<br>
	 * Message: The Academy/Royal Guard/Order of Knights is full and cannot accept new members at this time.
	 */
	public static final SystemMessageId SUBCLAN_IS_FULL;
	
	/**
	 * ID: 234<br>
	 * Message: ^[QbgɂĂB<br>
	 * Message: &#23565;&#35937;&#24517;&#38920;&#26159;&#34880;&#30431;&#25104;&#21729;&#12290;<br>
	 * Message: The target must be a clan member.
	 */
	public static final SystemMessageId TARGET_MUST_BE_IN_CLAN;
	
	/**
	 * ID: 235<br>
	 * Message: Ϗł܂B<br>
	 * Message: &#35442;&#27402;&#38480;&#28961;&#27861;&#25480;&#33287;&#20182;&#20154;&#12290;<br>
	 * Message: You are not authorized to bestow these rights.
	 */
	public static final SystemMessageId NOT_AUTHORIZED_TO_BESTOW_RIGHTS;
	
	/**
	 * ID: 236<br>
	 * Message: ݂̂s܂B<br>
	 * Message: &#21482;&#26377;&#30431;&#20027;&#25165;&#21487;&#22519;&#34892;&#12290;<br>
	 * Message: Only the clan leader is enabled.
	 */
	public static final SystemMessageId ONLY_THE_CLAN_LEADER_IS_ENABLED;
	
	/**
	 * ID: 237<br>
	 * Message: 傪܂B<br>
	 * Message: &#28961;&#27861;&#25214;&#21040;&#30431;&#20027;&#12290;<br>
	 * Message: The clan leader could not be found.
	 */
	public static final SystemMessageId CLAN_LEADER_NOT_FOUND;
	
	/**
	 * ID: 238<br>
	 * Message: ɉĂ܂B<br>
	 * Message: &#20006;&#26410;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: Not joined in any clan.
	 */
	public static final SystemMessageId NOT_JOINED_IN_ANY_CLAN;
	
	/**
	 * ID: 239<br>
	 * Message: ͒Eނł܂B<br>
	 * Message: &#34880;&#30431;&#30431;&#20027;&#28961;&#27861;&#33067;&#38626;&#12290;<br>
	 * Message: The clan leader cannot withdraw.
	 */
	public static final SystemMessageId CLAN_LEADER_CANNOT_WITHDRAW;
	
	/**
	 * ID: 240<br>
	 * Message: ݌풆łB<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#36914;&#34892;&#30431;&#25136;&#12290;<br>
	 * Message: Currently involved in clan war.
	 */
	public static final SystemMessageId CURRENTLY_INVOLVED_IN_CLAN_WAR;
	
	/**
	 * ID: 241<br>
	 * Message: $s1̌͐ڑĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#30431;&#20027;&#19981;&#22312;&#32218;&#19978;&#12290;<br>
	 * Message: Leader of the $s1 Clan is not logged in.
	 */
	public static final SystemMessageId LEADER_OF_S1_CLAN_NOT_FOUND;
	
	/**
	 * ID: 242<br>
	 * Message: ^[QbgIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#23565;&#35937;&#12290;<br>
	 * Message: Select target.
	 */
	public static final SystemMessageId SELECT_TARGET;
	
	/**
	 * ID: 243<br>
	 * Message: ̌ɑ΂Č̐z͂ł܂B<br>
	 * Message: &#28961;&#27861;&#21521;&#21516;&#30431;&#30340;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: You cannot declare war on an allied clan.
	 */
	public static final SystemMessageId CANNOT_DECLARE_WAR_ON_ALLIED_CLAN;
	
	/**
	 * ID: 244<br>
	 * Message: \ގi܂B<br>
	 * Message: &#28961;&#23459;&#25136;&#36039;&#26684;&#12290;<br>
	 * Message: You are not allowed to issue this challenge.
	 */
	public static final SystemMessageId NOT_ALLOWED_TO_CHALLENGE;
	
	/**
	 * ID: 245<br>
	 * Message: Ǒ̋ۂ5oĂ܂B낵łB<br>
	 * Message: &#38626;&#19978;&#27425;&#25298;&#32085;&#30431;&#25136;&#26178;&#38291;&#26410;&#21040;&#53;&#26085;&#65292;&#30906;&#23450;&#35201;&#23459;&#25136;&#21966;&#65311;<br>
	 * Message: 5 days has not passed since you were refused war. Do you wish to continue?
	 */
	public static final SystemMessageId FIVE_DAYS_NOT_PASSED_SINCE_REFUSED_WAR;
	
	/**
	 * ID: 246<br>
	 * Message: ̌͌ݐ푈łB<br>
	 * Message: &#23565;&#26041;&#34880;&#30431;&#27491;&#22312;&#36914;&#34892;&#25136;&#39717;&#12290;<br>
	 * Message: That clan is currently at war.
	 */
	public static final SystemMessageId CLAN_CURRENTLY_AT_WAR;
	
	/**
	 * ID: 247<br>
	 * Message: $s1 Ƃ͂łɐ푈s߁AO̐푈5o߂ȂƐzł܂B<br>
	 * Message: &#24050;&#33287;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#36914;&#34892;&#36942;&#30431;&#25136;&#65292;&#38920;&#38626;&#19978;&#27425;&#30431;&#25136;&#26178;&#38291;&#53;&#26085;&#20197;&#19978;&#65292;&#26041;&#21487;&#20877;&#24230;&#23459;&#25136;&#12290;<br>
	 * Message: You have already been at war with the $s1 clan: 5 days must pass before you can challenge this clan again
	 */
	public static final SystemMessageId FIVE_DAYS_MUST_PASS_BEFORE_CHALLENGE_AGAIN;
	
	/**
	 * ID: 248<br>
	 * Message: $s1 ̌ȂĐzł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#34880;&#30431;&#25104;&#21729;&#22826;&#23569;&#65292;&#28961;&#27861;&#23459;&#25136;&#12290;<br>
	 * Message: You cannot proclaim war: the $s1 clan does not have enough members.
	 */
	public static final SystemMessageId S1_CLAN_NOT_ENOUGH_MEMBERS_FOR_WAR;
	
	/**
	 * ID: 249<br>
	 * Message: $s1 ɍ~܂B<br>
	 * Message: &#35201;&#21521;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#25237;&#38477;&#21966;&#65311;<br>
	 * Message: Do you wish to surrender to the $s1 clan?
	 */
	public static final SystemMessageId WISH_SURRENDER_TO_S1_CLAN;
	
	/**
	 * ID: 250<br>
	 * Message: $s1 Ɍl~܂B̏ԂƂ܂B<br>
	 * Message: &#21521;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#36914;&#34892;&#20491;&#20154;&#25237;&#38477;&#65292;&#25104;&#28858;&#24050;&#33067;&#38626;&#30431;&#25136;&#29376;&#24907;&#12290;<br>
	 * Message: You have personally surrendered to the $s1 clan. You are no longer participating in this clan war.
	 */
	public static final SystemMessageId YOU_HAVE_PERSONALLY_SURRENDERED_TO_THE_S1_CLAN;
	
	/**
	 * ID: 251<br>
	 * Message: 풆ɂ͑̌ɑ΂Đzł܂B<br>
	 * Message: &#30431;&#25136;&#20013;&#28961;&#27861;&#23565;&#20854;&#20182;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: You cannot proclaim war: you are at war with another clan.
	 */
	public static final SystemMessageId ALREADY_AT_WAR_WITH_ANOTHER_CLAN;
	
	/**
	 * ID: 252<br>
	 * Message: ~錌͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#25237;&#38477;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the clan name to surrender to.
	 */
	public static final SystemMessageId ENTER_CLAN_NAME_TO_SURRENDER_TO;
	
	/**
	 * ID: 253<br>
	 * Message: I\ތ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35531;&#27714;&#20572;&#25136;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the name of the clan you wish to end the war with.
	 */
	public static final SystemMessageId ENTER_CLAN_NAME_TO_END_WAR;
	
	/**
	 * ID: 254<br>
	 * Message: ͌l~ł܂B<br>
	 * Message: &#30431;&#20027;&#28961;&#27861;&#20491;&#20154;&#25237;&#38477;&#12290;<br>
	 * Message: A clan leader cannot personally surrender.
	 */
	public static final SystemMessageId LEADER_CANT_PERSONALLY_SURRENDER;
	
	/**
	 * ID: 255<br>
	 * Message: $s1 ɏI\܂܂Bӂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#35201;&#27714;&#20572;&#25136;&#65292;&#35201;&#25509;&#21463;&#20572;&#25136;&#35201;&#27714;&#21966;&#65311;<br>
	 * Message: The $s1 clan has requested to end war. Do you agree?
	 */
	public static final SystemMessageId S1_CLAN_REQUESTED_END_WAR;
	
	/**
	 * ID: 256<br>
	 * Message: t^^Cg͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#30331;&#35352;&#30340;&#31281;&#34399;&#12290;<br>
	 * Message: Enter title
	 */
	public static final SystemMessageId ENTER_TITLE;
	
	/**
	 * ID: 257<br>
	 * Message: $s1ɏI\݂܂B<br>
	 * Message: &#35201;&#21521;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#35531;&#27714;&#20572;&#25136;&#21966;&#65311;<br>
	 * Message: Do you offer the $s1 clan a proposal to end the war?
	 */
	public static final SystemMessageId DO_YOU_OFFER_S1_CLAN_END_WAR;
	
	/**
	 * ID: 258<br>
	 * Message: 풆ł͂܂B<br>
	 * Message: &#30446;&#21069;&#20006;&#26410;&#36914;&#34892;&#30431;&#25136;&#12290;<br>
	 * Message: You are not involved in a clan war.
	 */
	public static final SystemMessageId NOT_INVOLVED_CLAN_WAR;
	
	/**
	 * ID: 259<br>
	 * Message: XgIĂB<br>
	 * Message: &#35531;&#24478;&#34880;&#30431;&#25104;&#21729;&#21517;&#21934;&#20013;&#36984;&#25799;&#12290;<br>
	 * Message: Select clan members from list.
	 */
	public static final SystemMessageId SELECT_MEMBERS_FROM_LIST;
	
	/**
	 * ID: 260<br>
	 * Message: ̋ۂ5oĂȂ߁Al܂B<br>
	 * Message: &#38626;&#19978;&#27425;&#25298;&#32085;&#30431;&#25136;&#26178;&#38291;&#26410;&#21040;&#53;&#26085;&#65292;&#22240;&#27492;&#36896;&#25104;&#34880;&#30431;&#32882;&#26395;&#19979;&#38477;&#12290;<br>
	 * Message: Fame level has decreased: 5 days have not passed since you were refused war
	 */
	public static final SystemMessageId FIVE_DAYS_NOT_PASSED_SINCE_YOU_WERE_REFUSED_WAR;
	
	/**
	 * ID: 261<br>
	 * Message: ܂B<br>
	 * Message: &#34880;&#30431;&#21517;&#31281;&#19981;&#27491;&#30906;&#12290;<br>
	 * Message: Clan name is invalid.
	 */
	public static final SystemMessageId CLAN_NAME_INCORRECT;
	
	/**
	 * ID: 262<br>
	 * Message: ߂܂B<br>
	 * Message: &#34880;&#30431;&#21517;&#31281;&#36942;&#38263;&#12290;<br>
	 * Message: Clan name's length is incorrect.
	 */
	public static final SystemMessageId CLAN_NAME_TOO_LONG;
	
	/**
	 * ID: 263<br>
	 * Message: $s1͉U̐\ݒłB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#24050;&#30003;&#35531;&#35299;&#25955;&#12290;<br>
	 * Message: You have already requested the dissolution of your clan.
	 */
	public static final SystemMessageId DISSOLUTION_IN_PROGRESS;
	
	/**
	 * ID: 264<br>
	 * Message: 푈ɂ͌Uł܂B<br>
	 * Message: &#25136;&#29229;&#20013;&#28961;&#27861;&#35299;&#25955;&#34880;&#30431;&#12290;<br>
	 * Message: You cannot dissolve a clan while engaged in a war.
	 */
	public static final SystemMessageId CANNOT_DISSOLVE_WHILE_IN_WAR;
	
	/**
	 * ID: 265<br>
	 * Message: Uȟ͉Uł܂B<br>
	 * Message: &#25915;&#22478;&#25110;&#23432;&#22478;&#20013;&#30340;&#34880;&#30431;&#28961;&#27861;&#35299;&#25955;&#12290;<br>
	 * Message: You cannot dissolve a clan during a siege or while protecting a castle.
	 */
	public static final SystemMessageId CANNOT_DISSOLVE_WHILE_IN_SIEGE;
	
	/**
	 * ID: 266<br>
	 * Message: AWgLĂ錌͉Uł܂B<br>
	 * Message: &#25793;&#26377;&#26681;&#25818;&#22320;&#25110;&#22478;&#22561;&#30340;&#34880;&#30431;&#28961;&#27861;&#35299;&#25955;&#12290;<br>
	 * Message: You cannot dissolve a clan while owning a clan hall or castle.
	 */
	public static final SystemMessageId CANNOT_DISSOLVE_WHILE_OWNING_CLAN_HALL_OR_CASTLE;
	
	/**
	 * ID: 267<br>
	 * Message: U̐\݂Ă܂B<br>
	 * Message: &#20006;&#26410;&#30003;&#35531;&#35299;&#25955;&#12290;<br>
	 * Message: There are no requests to disperse.
	 */
	public static final SystemMessageId NO_REQUESTS_TO_DISPERSE;
	
	/**
	 * ID: 268<br>
	 * Message: łɌɏĂ܂B<br>
	 * Message: &#24050;&#23660;&#26044;&#20854;&#20182;&#34880;&#30431;&#12290;<br>
	 * Message: That player already belongs to another clan.
	 */
	public static final SystemMessageId PLAYER_ALREADY_ANOTHER_CLAN;
	
	/**
	 * ID: 269<br>
	 * Message: g邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#23559;&#33258;&#24049;&#38283;&#38500;&#12290;<br>
	 * Message: You cannot dismiss yourself.
	 */
	public static final SystemMessageId YOU_CANNOT_DISMISS_YOURSELF;
	
	/**
	 * ID: 270<br>
	 * Message: łɍ~܂B<br>
	 * Message: &#24050;&#32147;&#25237;&#38477;&#12290;<br>
	 * Message: You have already surrendered.
	 */
	public static final SystemMessageId YOU_HAVE_ALREADY_SURRENDERED;
	
	/**
	 * ID: 271<br>
	 * Message: ^Cgt^͌XL x3ȏォł܂B<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#24517;&#38920;&#35201;&#36948;&#21040;&#51;&#32026;&#20197;&#19978;&#65292;&#25165;&#33021;&#36070;&#20104;&#30431;&#21451;&#31281;&#34399;&#12290;<br>
	 * Message: A player can only be granted a title if the clan is level 3 or above
	 */
	public static final SystemMessageId CLAN_LVL_3_NEEDED_TO_ENDOWE_TITLE;
	
	/**
	 * ID: 272<br>
	 * Message: Guo^͌XL x3ȏォł܂B<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#24517;&#38920;&#35201;&#36948;&#21040;&#51;&#32026;&#20197;&#19978;&#65292;&#25165;&#33021;&#30331;&#35352;&#34880;&#30431;&#32011;&#31456;&#12290;<br>
	 * Message: A clan crest can only be registered when the clan's skill level is 3 or above.
	 */
	public static final SystemMessageId CLAN_LVL_3_NEEDED_TO_SET_CREST;
	
	/**
	 * ID: 273<br>
	 * Message: ̕z͌XL x3ȏォł܂B<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#24517;&#38920;&#35201;&#36948;&#21040;&#51;&#32026;&#20197;&#19978;&#65292;&#25165;&#33021;&#36914;&#34892;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: A clan war can only be declared when a clan's skill level is 3 or above.
	 */
	public static final SystemMessageId CLAN_LVL_3_NEEDED_TO_DECLARE_WAR;
	
	/**
	 * ID: 274<br>
	 * Message: XL̃xオ܂B<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#25552;&#21319;&#12290;<br>
	 * Message: Your clan's skill level has increased.
	 */
	public static final SystemMessageId CLAN_LEVEL_INCREASED;
	
	/**
	 * ID: 275<br>
	 * Message: XL̃x AbvɎs܂B<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#25552;&#21319;&#22833;&#25943;&#12290;<br>
	 * Message: Clan has failed to increase skill level.
	 */
	public static final SystemMessageId CLAN_LEVEL_INCREASE_FAILED;
	
	/**
	 * ID: 276<br>
	 * Message: XLKɕKvȃACe܂B<br>
	 * Message: &#23416;&#32722;&#25216;&#33021;&#24517;&#35201;&#30340;&#36947;&#20855;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have the necessary materials or prerequisites to learn this skill.
	 */
	public static final SystemMessageId ITEM_MISSING_TO_LEARN_SKILL;
	
	/**
	 * ID: 277<br>
	 * Message: $s1K܂B<br>
	 * Message: &#23416;&#32722;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have earned $s1.
	 */
	public static final SystemMessageId LEARNED_SKILL_S1;
	
	/**
	 * ID: 278<br>
	 * Message: XLKɕKvSP܂B<br>
	 * Message: &#23416;&#32722;&#25216;&#33021;&#24517;&#35201;&#30340;&#83;&#80;&#19981;&#22816;&#12290;<br>
	 * Message: You do not have enough SP to learn this skill.
	 */
	public static final SystemMessageId NOT_ENOUGH_SP_TO_LEARN_SKILL;
	
	/**
	 * ID: 279<br>
	 * Message: Afi܂B<br>
	 * Message: &#37329;&#37666;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough adena.
	 */
	public static final SystemMessageId YOU_NOT_ENOUGH_ADENA;
	
	/**
	 * ID: 280<br>
	 * Message: ̂܂B<br>
	 * Message: &#27492;&#29289;&#21697;&#28961;&#27861;&#36023;&#36067;&#12290;<br>
	 * Message: You do not have any items to sell.
	 */
	public static final SystemMessageId NO_ITEMS_TO_SELL;
	
	/**
	 * ID: 281<br>
	 * Message: ۊǗ܂B<br>
	 * Message: &#20445;&#31649;&#36027;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough adena to pay the fee.
	 */
	public static final SystemMessageId YOU_NOT_ENOUGH_ADENA_PAY_FEE;
	
	/**
	 * ID: 282<br>
	 * Message: â܂B<br>
	 * Message: &#27794;&#26377;&#23384;&#25918;&#30340;&#29289;&#21697;&#12290;<br>
	 * Message: You have not deposited any items in your warehouse.
	 */
	public static final SystemMessageId NO_ITEM_DEPOSITED_IN_WH;
	
	/**
	 * ID: 283<br>
	 * Message: ɓ܂B<br>
	 * Message: &#36914;&#20837;&#25136;&#22580;&#12290;<br>
	 * Message: You have entered a combat zone.
	 */
	public static final SystemMessageId ENTERED_COMBAT_ZONE;
	
	/**
	 * ID: 284<br>
	 * Message: ꂩo܂B<br>
	 * Message: &#38626;&#38283;&#25136;&#22580;&#12290;<br>
	 * Message: You have left a combat zone.
	 */
	public static final SystemMessageId LEFT_COMBAT_ZONE;
	
	/**
	 * ID: 285<br>
	 * Message: $s1 xz҂̍ɐ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#25104;&#21151;&#21051;&#21123;&#32113;&#27835;&#32773;&#23553;&#21360;&#65281;<br>
	 * Message: Clan $s1 has succeeded in engraving the ruler!
	 */
	public static final SystemMessageId CLAN_S1_ENGRAVED_RULER;
	
	/**
	 * ID: 286<br>
	 * Message: wnUĂ܂B<br>
	 * Message: &#25915;&#22478;&#38499;&#22320;&#36973;&#21463;&#25915;&#25802;&#12290;<br>
	 * Message: Your base is being attacked.
	 */
	public static final SystemMessageId BASE_UNDER_ATTACK;
	
	/**
	 * ID: 287<br>
	 * Message: Ǧxz҂̍n߂܂B<br>
	 * Message: &#25973;&#20154;&#34880;&#30431;&#38283;&#22987;&#21051;&#21123;&#32113;&#27835;&#32773;&#23553;&#21360;&#12290;<br>
	 * Message: The opposing clan has stared to engrave to monument!
	 */
	public static final SystemMessageId OPPONENT_STARTED_ENGRAVING;
	
	/**
	 * ID: 288<br>
	 * Message: 傪܂B<br>
	 * Message: &#22478;&#38272;&#24050;&#30772;&#22750;&#12290;<br>
	 * Message: The castle gate has been broken down.
	 */
	public static final SystemMessageId CASTLE_GATE_BROKEN_DOWN;
	
	/**
	 * ID: 289<br>
	 * Message: ݐwnOn邽ߍ\zł܂B<br>
	 * Message: &#30446;&#21069;&#24050;&#26377;&#38499;&#22320;&#25110;&#21069;&#21736;&#22522;&#22320;&#65292;&#22240;&#27492;&#28961;&#27861;&#37325;&#24314;&#12290;<br>
	 * Message: An outpost or headquarters cannot be built because at least one already exists.
	 */
	public static final SystemMessageId NOT_ANOTHER_HEADQUARTERS;
	
	/**
	 * ID: 290<br>
	 * Message: ɂ͐wnĂ܂B<br>
	 * Message: &#27492;&#34389;&#19981;&#21487;&#35373;&#31435;&#25915;&#22478;&#38499;&#22320;&#12290;<br>
	 * Message: You cannot set up a base here.
	 */
	public static final SystemMessageId NOT_SET_UP_BASE_HERE;
	
	/**
	 * ID: 291<br>
	 * Message: $s1  $s2 Ƃ̍Uŏ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#22312;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#25915;&#22478;&#25136;&#20013;&#21213;&#21033;&#65281;<br>
	 * Message: Clan $s1 is victorious over $s2's castle siege!
	 */
	public static final SystemMessageId CLAN_S1_VICTORIOUS_OVER_S2_S_SIEGE;
	
	/**
	 * ID: 292<br>
	 * Message: $s1U鎞z܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#23459;&#24067;&#20102;&#25915;&#22478;&#26178;&#21051;&#12290;<br>
	 * Message: $s1 has announced the castle siege time.
	 */
	public static final SystemMessageId S1_ANNOUNCED_SIEGE_TIME;
	
	/**
	 * ID: 293<br>
	 * Message: $s1̍Uo^ԂI܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25915;&#22478;&#30331;&#35352;&#26178;&#38291;&#32080;&#26463;&#12290;<br>
	 * Message: The registration term for $s1 has ended.
	 */
	public static final SystemMessageId REGISTRATION_TERM_FOR_S1_ENDED;
	
	/**
	 * ID: 294<br>
	 * Message: UAvǐAWgɎQĂǓł͂Ȃ̂Őwn邱Ƃ͂ł܂B<br>
	 * Message: &#19981;&#26159;&#23660;&#26044;&#21443;&#21152;&#25915;&#22478;&#25136;&#47;&#35201;&#22622;&#25136;&#12289;&#26681;&#25818;&#22320;&#20308;&#38936;&#25136;&#30340;&#25915;&#22478;&#26041;&#34880;&#30431;&#65292;&#22240;&#27492;&#28961;&#27861;&#35373;&#32622;&#25915;&#22478;&#38499;&#22320;&#12290;<br>
	 * Message: Because your clan is not currently on the offensive in a Clan Hall siege war, it cannot summon its base camp.
	 */
	public static final SystemMessageId BECAUSE_YOUR_CLAN_IS_NOT_CURRENTLY_ON_THE_OFFENSIVE_IN_A_CLAN_HALL_SIEGE_WAR_IT_CANNOT_SUMMON_ITS_BASE_CAMP;
	
	/**
	 * ID: 295<br>
	 * Message: UɎQ錌Ȃ߁A$s1̍U킪LZ܂B<br>
	 * Message: &#27794;&#26377;&#34880;&#30431;&#21443;&#21152;&#25915;&#22478;&#25136;&#65292;&#22240;&#27492;&#36;&#115;&#49;&#30340;&#25915;&#22478;&#25136;&#24050;&#34987;&#21462;&#28040;<br>
	 * Message: $s1's siege was canceled because there were no clans that participated.
	 */
	public static final SystemMessageId S1_SIEGE_WAS_CANCELED_BECAUSE_NO_CLANS_PARTICIPATED;
	
	/**
	 * ID: 296<br>
	 * Message: 痎$s1̃_[W󂯂܂B<br>
	 * Message: &#24478;&#39640;&#34389;&#22684;&#33853;&#65292;&#22240;&#32780;&#21463;&#21040;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You received $s1 damage from taking a high fall.
	 */
	public static final SystemMessageId FALL_DAMAGE_S1;
	
	/**
	 * ID: 297<br>
	 * Message: ċzł$s1̃_[W󂯂܂B<br>
	 * Message: &#28961;&#27861;&#21628;&#21560;&#65292;&#22240;&#32780;&#21463;&#21040;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You have taken $s1 damage because you were unable to breathe.
	 */
	public static final SystemMessageId DROWN_DAMAGE_S1;
	
	/**
	 * ID: 298<br>
	 * Message: $s1𗎂Ƃ܂B<br>
	 * Message: &#36986;&#33853;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have dropped $s1.
	 */
	public static final SystemMessageId YOU_DROPPED_S1;
	
	/**
	 * ID: 299<br>
	 * Message: $c1$s2$s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has obtained $s3 $s2.
	 */
	public static final SystemMessageId C1_OBTAINED_S3_S2;
	
	/**
	 * ID: 300<br>
	 * Message: $c1$s2ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has obtained $s2.
	 */
	public static final SystemMessageId C1_OBTAINED_S2;
	
	/**
	 * ID: 301<br>
	 * Message: $s1 $s2܂B<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: $s2 $s1 has disappeared.
	 */
	public static final SystemMessageId S2_S1_DISAPPEARED;
	
	/**
	 * ID: 302<br>
	 * Message: $s1܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: $s1 has disappeared.
	 */
	public static final SystemMessageId S1_DISAPPEARED;
	
	/**
	 * ID: 303<br>
	 * Message: ACeIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#24375;&#21270;&#30340;&#29289;&#21697;&#12290;<br>
	 * Message: Select item to enchant.
	 */
	public static final SystemMessageId SELECT_ITEM_TO_ENCHANT;
	
	/**
	 * ID: 304<br>
	 * Message:  $s1Q[ɐڑ܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#30331;&#20837;&#36938;&#25138;&#12290;<br>
	 * Message: Clan member $s1 has logged into game.
	 */
	public static final SystemMessageId CLAN_MEMBER_S1_LOGGED_IN;
	
	/**
	 * ID: 305<br>
	 * Message: p[eBւ̎Qۂ܂B<br>
	 * Message: &#25298;&#32085;&#21152;&#20837;&#38538;&#20237;&#12290;<br>
	 * Message: The player declined to join your party.
	 */
	public static final SystemMessageId PLAYER_DECLINED;
	
	/**
	 * ID: 306<br>
	 * Message: LN^[̍폜Ɏs܂B<br>
	 * Message: &#21034;&#38500;&#35282;&#33394;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to delete the character.
	 */
	public static final SystemMessageId FAILED_TO_DELETE_CHAR;
	
	/**
	 * ID: 307<br>
	 * Message: qɂƂ̃g[hɎs܂B<br>
	 * Message: &#23384;&#38936;&#20489;&#24235;&#22833;&#25943;&#12290;<br>
	 * Message: You cannot trade with a warehouse keeper.
	 */
	public static final SystemMessageId CANNOT_TRADE_WAREHOUSE_KEEPER;
	
	/**
	 * ID: 308<br>
	 * Message: ̊UɎs܂B<br>
	 * Message: &#21152;&#20837;&#34880;&#30431;&#22833;&#25943;&#12290;<br>
	 * Message: The player declined your clan invitation.
	 */
	public static final SystemMessageId PLAYER_DECLINED_CLAN_INVITATION;
	
	/**
	 * ID: 309<br>
	 * Message: ̏ɐ܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#38283;&#38500;&#25104;&#21151;&#12290;<br>
	 * Message: You have succeeded in expelling the clan member.
	 */
	public static final SystemMessageId YOU_HAVE_SUCCEEDED_IN_EXPELLING_CLAN_MEMBER;
	
	/**
	 * ID: 310<br>
	 * Message: ̏Ɏs܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#38283;&#38500;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to expel the clan member.
	 */
	public static final SystemMessageId FAILED_TO_EXPEL_CLAN_MEMBER;
	
	/**
	 * ID: 311<br>
	 * Message: ̐\݂󂯓܂B<br>
	 * Message: &#25509;&#21463;&#30431;&#25136;&#35201;&#27714;&#12290;<br>
	 * Message: The clan war declaration has been accepted.
	 */
	public static final SystemMessageId CLAN_WAR_DECLARATION_ACCEPTED;
	
	/**
	 * ID: 312<br>
	 * Message: ̐\݂ۂ܂B<br>
	 * Message: &#25298;&#32085;&#30431;&#25136;&#35201;&#27714;&#12290;<br>
	 * Message: The clan war declaration has been refused.
	 */
	public static final SystemMessageId CLAN_WAR_DECLARATION_REFUSED;
	
	/**
	 * ID: 313<br>
	 * Message: I̐\݂󂯓܂B<br>
	 * Message: &#25509;&#21463;&#20572;&#25136;&#35531;&#27714;&#12290;<br>
	 * Message: The cease war request has been accepted.
	 */
	public static final SystemMessageId CEASE_WAR_REQUEST_ACCEPTED;
	
	/**
	 * ID: 314<br>
	 * Message: ~Ɏs܂B<br>
	 * Message: &#25237;&#38477;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to surrender.
	 */
	public static final SystemMessageId FAILED_TO_SURRENDER;
	
	/**
	 * ID: 315<br>
	 * Message: l~Ɏs܂B<br>
	 * Message: &#20491;&#20154;&#25237;&#38477;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to personally surrender.
	 */
	public static final SystemMessageId FAILED_TO_PERSONALLY_SURRENDER;
	
	/**
	 * ID: 316<br>
	 * Message: p[eB̒EނɎs܂B<br>
	 * Message: &#26410;&#33021;&#33067;&#38626;&#38538;&#20237;&#12290;<br>
	 * Message: You have failed to withdraw from the party.
	 */
	public static final SystemMessageId FAILED_TO_WITHDRAW_FROM_THE_PARTY;
	
	/**
	 * ID: 317<br>
	 * Message: p[eB o[̒ǕɎs܂B<br>
	 * Message: &#38538;&#21729;&#38500;&#21517;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to expel the party member.
	 */
	public static final SystemMessageId FAILED_TO_EXPEL_THE_PARTY_MEMBER;
	
	/**
	 * ID: 318<br>
	 * Message: p[eB̉UɎs܂B<br>
	 * Message: &#35299;&#25955;&#38538;&#20237;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to disperse the party.
	 */
	public static final SystemMessageId FAILED_TO_DISPERSE_THE_PARTY;
	
	/**
	 * ID: 319<br>
	 * Message: AbNłȂhAłB<br>
	 * Message: &#19981;&#33021;&#25171;&#38283;&#30340;&#38272;&#12290;<br>
	 * Message: This door cannot be unlocked.
	 */
	public static final SystemMessageId UNABLE_TO_UNLOCK_DOOR;
	
	/**
	 * ID: 320<br>
	 * Message: AbNɎs܂B<br>
	 * Message: &#25171;&#38283;&#38272;&#37782;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to unlock the door.
	 */
	public static final SystemMessageId FAILED_TO_UNLOCK_DOOR;
	
	/**
	 * ID: 321<br>
	 * Message: bNĂ܂B<br>
	 * Message: &#20006;&#26410;&#19978;&#37782;&#12290;<br>
	 * Message: It is not locked.
	 */
	public static final SystemMessageId ITS_NOT_LOCKED;
	
	/**
	 * ID: 322<br>
	 * Message: ̔z߂ĂB<br>
	 * Message: &#35531;&#27770;&#23450;&#36009;&#21806;&#20729;&#26684;&#12290;<br>
	 * Message: Please decide on the sales price.
	 */
	public static final SystemMessageId DECIDE_SALES_PRICE;
	
	/**
	 * ID: 323<br>
	 * Message: C$s1iKɏ㏸܂B<br>
	 * Message: &#21147;&#37327;&#24050;&#32147;&#25552;&#21319;&#21040;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#38542;&#27573;&#12290;<br>
	 * Message: Your force has increased to $s1 level.
	 */
	public static final SystemMessageId FORCE_INCREASED_TO_S1;
	
	/**
	 * ID: 324<br>
	 * Message: ȏ͋Cグ܂B<br>
	 * Message: &#28961;&#27861;&#32380;&#32396;&#25552;&#21319;&#21147;&#37327;&#12290;<br>
	 * Message: Your force has reached maximum capacity.
	 */
	public static final SystemMessageId FORCE_MAXLEVEL_REACHED;
	
	/**
	 * ID: 325<br>
	 * Message: ̂łɂȂȂ܂B<br>
	 * Message: &#23629;&#39636;&#24050;&#32147;&#28040;&#22833;&#12290;<br>
	 * Message: The corpse has already disappeared.
	 */
	public static final SystemMessageId CORPSE_ALREADY_DISAPPEARED;
	
	/**
	 * ID: 326<br>
	 * Message: ΏۂXgIĂB<br>
	 * Message: &#35531;&#30001;&#28165;&#21934;&#20013;&#36984;&#25799;&#23565;&#35937;&#12290;<br>
	 * Message: Select target from list.
	 */
	public static final SystemMessageId SELECT_TARGET_FROM_LIST;
	
	/**
	 * ID: 327<br>
	 * Message: 80ȉɂĂB<br>
	 * Message: &#19981;&#33021;&#36229;&#36942;&#56;&#48;&#20491;&#23383;&#12290;<br>
	 * Message: You cannot exceed 80 characters.
	 */
	public static final SystemMessageId CANNOT_EXCEED_80_CHARACTERS;
	
	/**
	 * ID: 328<br>
	 * Message: ڂ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#27161;&#38988;&#12290;<br>
	 * Message: Please input title using less than 128 characters.
	 */
	public static final SystemMessageId PLEASE_INPUT_TITLE_LESS_128_CHARACTERS;
	
	/**
	 * ID: 329<br>
	 * Message: e͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#20839;&#23481;&#12290;<br>
	 * Message: Please input content using less than 3000 characters.
	 */
	public static final SystemMessageId PLEASE_INPUT_CONTENT_LESS_3000_CHARACTERS;
	
	/**
	 * ID: 330<br>
	 * Message: Rg128ȓœ͂ĂB<br>
	 * Message: &#21934;&#34892;&#22238;&#31572;&#19981;&#21487;&#36229;&#36942;&#49;&#50;&#56;&#20491;&#33521;&#25991;&#25110;&#25976;&#23383;&#12290;<br>
	 * Message: A one-line response may not exceed 128 characters.
	 */
	public static final SystemMessageId ONE_LINE_RESPONSE_NOT_EXCEED_128_CHARACTERS;
	
	/**
	 * ID: 331<br>
	 * Message: $s1SP𓾂܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#32;&#83;&#80;&#12290;<br>
	 * Message: You have acquired $s1 SP.
	 */
	public static final SystemMessageId ACQUIRED_S1_SP;
	
	/**
	 * ID: 332<br>
	 * Message: ܂B<br>
	 * Message: &#35201;&#24489;&#27963;&#21966;&#63;<br>
	 * Message: Do you want to be restored?
	 */
	public static final SystemMessageId DO_YOU_WANT_TO_BE_RESTORED;
	
	/**
	 * ID: 333<br>
	 * Message: RÃoAɂ$s1̃_[W󂯂܂B<br>
	 * Message: &#22240;&#26680;&#24515;&#32080;&#30028;&#21463;&#21040;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You have received $s1 damage by Core's barrier.
	 */
	public static final SystemMessageId S1_DAMAGE_BY_CORE_BARRIER;
	
	/**
	 * ID: 334<br>
	 * Message: bZ[W͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#21830;&#24215;&#36039;&#35338;&#12290;<br>
	 * Message: Please enter your private store display message.
	 */
	public static final SystemMessageId ENTER_PRIVATE_STORE_MESSAGE;
	
	/**
	 * ID: 335<br>
	 * Message: $s1𒆒f܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20013;&#27490;&#12290;<br>
	 * Message: $s1 has been aborted.
	 */
	public static final SystemMessageId S1_HAS_BEEN_ABORTED;
	
	/**
	 * ID: 336<br>
	 * Message: $s1NX^CY܂B낵łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#32080;&#26230;&#21270;&#20043;&#24460;&#23559;&#26371;&#28040;&#22833;&#65292;&#35531;&#21839;&#30906;&#23450;&#35201;&#23559;&#27492;&#29289;&#21697;&#32080;&#26230;&#21270;&#21966;&#63;<br>
	 * Message: You are attempting to crystallize $s1. Do you wish to continue?
	 */
	public static final SystemMessageId WISH_TO_CRYSTALLIZE_S1;
	
	/**
	 * ID: 337<br>
	 * Message: \E Vbgƕ̃O[hv܂B<br>
	 * Message: &#38728;&#39746;&#24392;&#31561;&#32026;&#33287;&#27494;&#22120;&#19981;&#31526;&#12290;<br>
	 * Message: The soulshot you are attempting to use does not match the grade of your equipped weapon.
	 */
	public static final SystemMessageId SOULSHOTS_GRADE_MISMATCH;
	
	/**
	 * ID: 338<br>
	 * Message: \E Vbg܂B<br>
	 * Message: &#38728;&#39746;&#24392;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough soulshots for that.
	 */
	public static final SystemMessageId NOT_ENOUGH_SOULSHOTS;
	
	/**
	 * ID: 339<br>
	 * Message: \E Vbggpł܂B<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#38728;&#39746;&#24392;&#12290;<br>
	 * Message: Cannot use soulshots.
	 */
	public static final SystemMessageId CANNOT_USE_SOULSHOTS;
	
	/**
	 * ID: 340<br>
	 * Message: lX̏łB<br>
	 * Message: &#20491;&#20154;&#21830;&#24215;&#28310;&#20633;&#20013;&#12290;<br>
	 * Message: Your private store is now open for business.
	 */
	public static final SystemMessageId PRIVATE_STORE_UNDER_WAY;
	
	/**
	 * ID: 341<br>
	 * Message: ޗ܂B<br>
	 * Message: &#26448;&#26009;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough materials to perform that action.
	 */
	public static final SystemMessageId NOT_ENOUGH_MATERIALS;
	
	/**
	 * ID: 342<br>
	 * Message: ̗͂g܂B<br>
	 * Message: &#28748;&#27880;&#38728;&#39746;&#20043;&#21147;&#12290;<br>
	 * Message: Power of the spirits enabled.
	 */
	public static final SystemMessageId ENABLED_SOULSHOT;
	
	/**
	 * ID: 343<br>
	 * Message: X|CĂȂ߁AXEB[p[̎gpɎs܂B<br>
	 * Message: &#30446;&#27161;&#20006;&#38750;&#21576;&#29694;&#33258;&#39636;&#35722;&#21270;&#29376;&#24907;&#65292;&#22238;&#25910;&#32773;&#25216;&#33021;&#20351;&#29992;&#22833;&#25943;&#12290;<br>
	 * Message: Sweeper failed, target not spoiled.
	 */
	public static final SystemMessageId SWEEPER_FAILED_TARGET_NOT_SPOILED;
	
	/**
	 * ID: 344<br>
	 * Message: ̗͂Ȃ܂B<br>
	 * Message: &#35299;&#38500;&#38728;&#39746;&#20043;&#21147;&#12290;<br>
	 * Message: Power of the spirits disabled.
	 */
	public static final SystemMessageId SOULSHOTS_DISABLED;
	
	/**
	 * ID: 345<br>
	 * Message: `bg\ȏԂłB<br>
	 * Message: &#21487;&#20132;&#35527;&#29376;&#24907;&#12290;<br>
	 * Message: Chat enabled.
	 */
	public static final SystemMessageId CHAT_ENABLED;
	
	/**
	 * ID: 346<br>
	 * Message: `bg֎~܂B<br>
	 * Message: &#20132;&#35527;&#20013;&#27490;&#12290;<br>
	 * Message: Chat disabled.
	 */
	public static final SystemMessageId CHAT_DISABLED;
	
	/**
	 * ID: 347<br>
	 * Message: ACě܂B<br>
	 * Message: &#36947;&#20855;&#25976;&#37327;&#36664;&#20837;&#37679;&#35492;&#12290;<br>
	 * Message: Incorrect item count.
	 */
	public static final SystemMessageId INCORRECT_ITEM_COUNT;
	
	/**
	 * ID: 348<br>
	 * Message: ACẻi܂B<br>
	 * Message: &#20729;&#26684;&#36664;&#20837;&#37679;&#35492;&#12290;<br>
	 * Message: Incorrect item price.
	 */
	public static final SystemMessageId INCORRECT_ITEM_PRICE;
	
	/**
	 * ID: 349<br>
	 * Message: lXI܂B<br>
	 * Message: &#20491;&#20154;&#21830;&#24215;&#24050;&#32147;&#38364;&#38281;&#12290;<br>
	 * Message: Private store already closed.
	 */
	public static final SystemMessageId PRIVATE_STORE_ALREADY_CLOSED;
	
	/**
	 * ID: 350<br>
	 * Message: ACei؂łB<br>
	 * Message: &#29289;&#21697;&#24050;&#21806;&#23436;&#12290;<br>
	 * Message: Item out of stock.
	 */
	public static final SystemMessageId ITEM_OUT_OF_STOCK;
	
	/**
	 * ID: 351<br>
	 * Message: wACě܂B<br>
	 * Message: &#27442;&#36092;&#36023;&#30340;&#36947;&#20855;&#25976;&#37327;&#37679;&#35492;&#12290;<br>
	 * Message: Incorrect item count.
	 */
	public static final SystemMessageId NOT_ENOUGH_ITEMS;
	
	/**
	 * ID: 352<br>
	 * Message: ACe܂B<br>
	 * Message: &#29289;&#21697;&#37679;&#35492;&#12290;<br>
	 * Message: Incorrect item.
	 */
	public static final SystemMessageId INCORRECT_ITEM;
	
	/**
	 * ID: 353<br>
	 * Message: wɎs܂B<br>
	 * Message: &#36092;&#36023;&#22833;&#25943;&#12290;<br>
	 * Message: Cannot purchase.
	 */
	public static final SystemMessageId CANNOT_PURCHASE;
	
	/**
	 * ID: 354<br>
	 * Message: G`gLZ܂B<br>
	 * Message: &#29289;&#21697;&#24375;&#21270;&#21205;&#20316;&#21462;&#28040;&#12290;<br>
	 * Message: Cancel enchant.
	 */
	public static final SystemMessageId CANCEL_ENCHANT;
	
	/**
	 * ID: 355<br>
	 * Message: G`g̏v܂B<br>
	 * Message: &#29289;&#21697;&#24375;&#21270;&#26781;&#20214;&#19981;&#31526;&#65292;&#35531;&#37325;&#26032;&#27298;&#26597;&#12290;<br>
	 * Message: Inappropriate enchant conditions.
	 */
	public static final SystemMessageId INAPPROPRIATE_ENCHANT_CONDITION;
	
	/**
	 * ID: 356<br>
	 * Message: ۂ܂B<br>
	 * Message: &#25298;&#32085;&#24489;&#27963;&#12290;<br>
	 * Message: Reject resurrection.
	 */
	public static final SystemMessageId REJECT_RESURRECTION;
	
	/**
	 * ID: 357<br>
	 * Message: łɃX|CɂĂ܂B<br>
	 * Message: &#30446;&#27161;&#24050;&#25104;&#28858;&#33258;&#39636;&#35722;&#21270;&#29376;&#24907;&#12290;<br>
	 * Message: It has already been spoiled.
	 */
	public static final SystemMessageId ALREADY_SPOILED;
	
	/**
	 * ID: 358<br>
	 * Message: ȔI܂ł$s1ԂłB<br>
	 * Message: &#38626;&#25915;&#22478;&#25136;&#32080;&#26463;&#26178;&#38291;&#36996;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#23567;&#26178;&#12290;<br>
	 * Message: $s1 hour(s) until castle siege conclusion.
	 */
	public static final SystemMessageId S1_HOURS_UNTIL_SIEGE_CONCLUSION;
	
	/**
	 * ID: 359<br>
	 * Message: ȔI܂ł$s1łB<br>
	 * Message: &#38626;&#25915;&#22478;&#25136;&#32080;&#26463;&#26178;&#38291;&#36996;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: $s1 minute(s) until castle siege conclusion.
	 */
	public static final SystemMessageId S1_MINUTES_UNTIL_SIEGE_CONCLUSION;
	
	/**
	 * ID: 360<br>
	 * Message: ȔI܂ł$s1bI<br>
	 * Message: &#38626;&#25915;&#22478;&#25136;&#32080;&#26463;&#26178;&#38291;&#36996;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#65281;<br>
	 * Message: Castle siege $s1 second(s) left!
	 */
	public static final SystemMessageId CASTLE_SIEGE_S1_SECONDS_LEFT;
	
	/**
	 * ID: 361<br>
	 * Message: I[o[qbgI<br>
	 * Message: &#79;&#118;&#101;&#114;&#72;&#105;&#116;&#65281;<br>
	 * Message: Over-hit!
	 */
	public static final SystemMessageId OVER_HIT;
	
	/**
	 * ID: 362<br>
	 * Message: I[o[qbg$s1̃{[iXol𓾂܂B<br>
	 * Message: &#38989;&#22806;&#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#29518;&#21237;&#32147;&#39511;&#20540;&#12290;<br>
	 * Message: You have acquired $s1 bonus experience from a successful over-hit.
	 */
	public static final SystemMessageId ACQUIRED_BONUS_EXPERIENCE_THROUGH_OVER_HIT;
	
	/**
	 * ID: 363<br>
	 * Message: `bg\܂ł$s1łB<br>
	 * Message: &#31105;&#35328;&#26178;&#38291;&#36996;&#21097;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: Chat available time: $s1 minute.
	 */
	public static final SystemMessageId CHAT_AVAILABLE_S1_MINUTE;
	
	/**
	 * ID: 364<br>
	 * Message: 郆[U[͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#26597;&#35426;&#30340;&#29609;&#23478;&#22995;&#21517;&#12290;<br>
	 * Message: Enter user's name to search
	 */
	public static final SystemMessageId ENTER_USER_NAME_TO_SEARCH;
	
	/**
	 * ID: 365<br>
	 * Message: {ɃNX^CY܂B<br>
	 * Message: &#30495;&#30340;&#35201;&#32080;&#26230;&#21270;&#21966;&#65311;<br>
	 * Message: Are you sure?
	 */
	public static final SystemMessageId ARE_YOU_SURE;
	
	/**
	 * ID: 366<br>
	 * Message: FIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#38957;&#39662;&#38991;&#33394;&#12290;<br>
	 * Message: Please select your hair color.
	 */
	public static final SystemMessageId PLEASE_SELECT_HAIR_COLOR;
	
	/**
	 * ID: 367<br>
	 * Message: ɏĂLN^[͍폜ł܂B<br>
	 * Message: &#21152;&#20837;&#34880;&#30431;&#30340;&#35282;&#33394;&#28961;&#27861;&#21034;&#38500;&#12290;<br>
	 * Message: You cannot remove that clan character at this time.
	 */
	public static final SystemMessageId CANNOT_REMOVE_CLAN_CHARACTER;
	
	/**
	 * ID: 368<br>
	 * Message: +$s1$s2𑕔܂B<br>
	 * Message: &#35037;&#20633;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Equipped +$s1 $s2.
	 */
	public static final SystemMessageId S1_S2_EQUIPPED;
	
	/**
	 * ID: 369<br>
	 * Message: +$s1$s2ɓ܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have obtained a +$s1 $s2.
	 */
	public static final SystemMessageId YOU_PICKED_UP_A_S1_S2;
	
	/**
	 * ID: 370<br>
	 * Message: +$s1$s2̎擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#25791;&#21462;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Failed to pickup $s1.
	 */
	public static final SystemMessageId FAILED_PICKUP_S1;
	
	/**
	 * ID: 371<br>
	 * Message: +$s1$s2𓾂܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Acquired +$s1 $s2.
	 */
	public static final SystemMessageId ACQUIRED_S1_S2;
	
	/**
	 * ID: 372<br>
	 * Message: +$s1$s2擾Ɏs܂B<br>
	 * Message: &#28961;&#27861;&#29554;&#24471;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Failed to earn $s1.
	 */
	public static final SystemMessageId FAILED_EARN_S1;
	
	/**
	 * ID: 373<br>
	 * Message: +$s1$s2j󂵂܂B낵łB<br>
	 * Message: &#21034;&#38500;&#24460;&#23559;&#28961;&#27861;&#25937;&#22238;&#65292;&#30906;&#23450;&#35201;&#21034;&#38500;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#21966;&#65311;<br>
	 * Message: You are trying to destroy +$s1 $s2. Do you wish to continue?
	 */
	public static final SystemMessageId WISH_DESTROY_S1_S2;
	
	/**
	 * ID: 374<br>
	 * Message: +$s1$s2NX^CY܂B낵łB<br>
	 * Message: &#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#32080;&#26230;&#21270;&#20043;&#24460;&#23559;&#26371;&#28040;&#22833;&#65292;&#35531;&#21839;&#30906;&#23450;&#35201;&#23559;&#27492;&#29289;&#21697;&#32080;&#26230;&#21270;&#21966;&#63;<br>
	 * Message: You are attempting to crystallize +$s1 $s2. Do you wish to continue?
	 */
	public static final SystemMessageId WISH_CRYSTALLIZE_S1_S2;
	
	/**
	 * ID: 375<br>
	 * Message: +$s1$s2𗎂Ƃ܂B<br>
	 * Message: &#19999;&#26820;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have dropped +$s1 $s2 .
	 */
	public static final SystemMessageId DROPPED_S1_S2;
	
	/**
	 * ID: 376<br>
	 * Message: $c1 +$s2$s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: $c1 has obtained +$s2$s3.
	 */
	public static final SystemMessageId C1_OBTAINED_S2_S3;
	
	/**
	 * ID: 377<br>
	 * Message: +$s1$s2܂B<br>
	 * Message: &#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: $S1 $S2 disappeared.
	 */
	public static final SystemMessageId S1_S2_DISAPPEARED;
	
	/**
	 * ID: 378<br>
	 * Message: $c1 $s2𔃂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 purchased $s2.
	 */
	public static final SystemMessageId C1_PURCHASED_S2;
	
	/**
	 * ID: 379<br>
	 * Message: $c1 +$s2$s3𔃂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: $c1 purchased +$s2$s3.
	 */
	public static final SystemMessageId C1_PURCHASED_S2_S3;
	
	/**
	 * ID: 380<br>
	 * Message: $c1 $s2 $s3𔃂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 purchased $s3 $s2(s).
	 */
	public static final SystemMessageId C1_PURCHASED_S3_S2_S;
	
	/**
	 * ID: 381<br>
	 * Message: T|[gT[o[Ɍq܂B<br>
	 * Message: &#20006;&#26410;&#36899;&#32218;&#21040;&#35380;&#27714;&#31995;&#32113;&#12290;<br>
	 * Message: The game client encountered an error and was unable to connect to the petition server.
	 */
	public static final SystemMessageId GAME_CLIENT_UNABLE_TO_CONNECT_TO_PETITION_SERVER;
	
	/**
	 * ID: 382<br>
	 * Message: FSESPTET[rX`[ IDŃ`FbNAEgĂ邨ql͂܂B<br>
	 * Message: &#30446;&#21069;&#20006;&#27794;&#26377;&#29992;&#71;&#77;&#32;&#73;&#68;&#21246;&#36984;&#30340;&#29992;&#25142;&#12290;<br>
	 * Message: Currently there are no users that have checked out a GM ID.
	 */
	public static final SystemMessageId NO_USERS_CHECKED_OUT_GM_ID;
	
	/**
	 * ID: 383<br>
	 * Message: T|[g̏INGXg܂B<br>
	 * Message: &#35201;&#27714;&#32066;&#27490;&#35380;&#27714;&#31995;&#32113;&#30340;&#20132;&#35527;&#12290;<br>
	 * Message: Request confirmed to end consultation at petition server.
	 */
	public static final SystemMessageId REQUEST_CONFIRMED_TO_END_CONSULTATION;
	
	/**
	 * ID: 384<br>
	 * Message: [U[Q[ T[o[ɐڑĂ܂B<br>
	 * Message: &#29609;&#23478;&#19981;&#22312;&#32218;&#19978;<br>
	 * Message: The client is not logged onto the game server.
	 */
	public static final SystemMessageId CLIENT_NOT_LOGGED_ONTO_GAME_SERVER;
	
	/**
	 * ID: 385<br>
	 * Message: T|[g̊JnNGXg܂B<br>
	 * Message: &#35201;&#27714;&#36914;&#34892;&#35380;&#27714;&#31995;&#32113;&#30340;&#20132;&#35527;&#12290;<br>
	 * Message: Request confirmed to begin consultation at petition server.
	 */
	public static final SystemMessageId REQUEST_CONFIRMED_TO_BEGIN_CONSULTATION;
	
	/**
	 * ID: 386<br>
	 * Message: T|[gvɂ́Ae6ȏ͂ĂB<br>
	 * Message: &#35380;&#27714;&#30340;&#21839;&#38988;&#24517;&#38920;&#36664;&#20837;&#54;&#20491;&#23383;&#20197;&#19978;&#12290;<br>
	 * Message: The body of your petition must be more than five characters in length.
	 */
	public static final SystemMessageId PETITION_MORE_THAN_FIVE_CHARACTERS;
	
	/**
	 * ID: 387<br>
	 * Message: T|[gI܂B\nT|[gɑ΂]Ē΍KłB<br>
	 * Message: &#71;&#77;&#24050;&#31572;&#35206;&#23436;&#30050;&#12290;&#92;&#110;&#31245;&#24460;&#35531;&#23529;&#26680;&#35380;&#27714;&#65292;&#38750;&#24120;&#24863;&#35613;&#24744;&#30340;&#25903;&#25345;&#12290;<br>
	 * Message: This ends the GM petition consultation. Please take a moment to provide feedback about this service.
	 */
	public static final SystemMessageId THIS_END_THE_PETITION_PLEASE_PROVIDE_FEEDBACK;
	
	/**
	 * ID: 388<br>
	 * Message: ݁AΘb\Ԃł͂܂B<br>
	 * Message: &#30446;&#21069;&#20006;&#26410;&#36914;&#34892;&#35380;&#27714;&#31995;&#32113;&#30340;&#20132;&#35527;&#12290;<br>
	 * Message: Not under petition consultation.
	 */
	public static final SystemMessageId NOT_UNDER_PETITION_CONSULTATION;
	
	/**
	 * ID: 389<br>
	 * Message: - T|[g󂯕t܂B\n - tԍ$s1ԂłB<br>
	 * Message: &#45;&#32;&#35380;&#27714;&#21839;&#38988;&#21463;&#29702;&#20013;&#12290;&#92;&#110;&#32;&#45;&#32;&#30446;&#21069;&#24744;&#30340;&#32232;&#34399;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: our petition application has been accepted. - Receipt No. is $s1.
	 */
	public static final SystemMessageId PETITION_ACCEPTED_RECENT_NO_S1;
	
	/**
	 * ID: 390<br>
	 * Message: łɃT|[gv󂯕tĂ܂B<br>
	 * Message: &#35380;&#27714;&#21839;&#38988;&#23578;&#26410;&#34389;&#29702;&#65292;&#28961;&#27861;&#37325;&#35206;&#30003;&#35531;&#12290;<br>
	 * Message: You may only submit one petition (active) at a time.
	 */
	public static final SystemMessageId ONLY_ONE_ACTIVE_PETITION_AT_TIME;
	
	/**
	 * ID: 391<br>
	 * Message: tԍ$s1ԂLZ܂B<br>
	 * Message: &#32232;&#34399;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#35380;&#27714;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: Receipt No. $s1, petition cancelled.
	 */
	public static final SystemMessageId RECENT_NO_S1_CANCELED;
	
	/**
	 * ID: 392<br>
	 * Message: ݃T|[gΉłB<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#36914;&#34892;&#35380;&#27714;&#20132;&#35527;&#12290;<br>
	 * Message: Under petition advice.
	 */
	public static final SystemMessageId UNDER_PETITION_ADVICE;
	
	/**
	 * ID: 393<br>
	 * Message: T|[gṽLZɎs܂B΂炭Ă蒼ĂB<br>
	 * Message: &#35380;&#27714;&#21462;&#28040;&#22833;&#25943;&#65292;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: Failed to cancel petition. Please try again later.
	 */
	public static final SystemMessageId FAILED_CANCEL_PETITION_TRY_LATER;
	
	/**
	 * ID: 394<br>
	 * Message: $c1Ƃ̃T|[gJn܂B<br>
	 * Message: &#33287;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#35380;&#27714;&#20132;&#35527;&#38283;&#22987;&#12290;<br>
	 * Message: Starting petition consultation with $c1.
	 */
	public static final SystemMessageId STARTING_PETITION_WITH_C1;
	
	/**
	 * ID: 395<br>
	 * Message: $c1Ƃ̃T|[gI܂B<br>
	 * Message: &#33287;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#35380;&#27714;&#20132;&#35527;&#32080;&#26463;&#12290;<br>
	 * Message: Ending petition consultation with $c1.
	 */
	public static final SystemMessageId PETITION_ENDED_WITH_C1;
	
	/**
	 * ID: 396<br>
	 * Message: TCgihttp://lineage2.plaync.jp/jŃpX[h̕ύX܂̓ZLeBJ[h̍ĔsĂڑĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#22240;&#21152;&#23494;&#21345;&#23494;&#30908;&#36664;&#20837;&#37679;&#35492;&#32780;&#36973;&#37782;&#23450;&#65292;&#35531;&#33267;&#22825;&#22530;&#73;&#73;&#23448;&#26041;&#32178;&#31449;&#30340;&#21152;&#23494;&#21345;&#23560;&#21312;&#35299;&#38500;&#24115;&#34399;&#37782;&#23450;&#12290;<br>
	 * Message: Please login after changing your temporary password.
	 */
	public static final SystemMessageId TRY_AGAIN_AFTER_CHANGING_PASSWORD;
	
	/**
	 * ID: 397<br>
	 * Message: LAJEgł͂܂B<br>
	 * Message: &#36889;&#20006;&#19981;&#26159;&#25910;&#36027;&#24115;&#34399;&#12290;<br>
	 * Message: Not a paid account.
	 */
	public static final SystemMessageId NO_PAID_ACCOUNT;
	
	/**
	 * ID: 398<br>
	 * Message: ʐ̎c莞Ԃ܂B<br>
	 * Message: &#35336;&#26178;&#21046;&#30340;&#26178;&#38291;&#19981;&#22816;&#12290;<br>
	 * Message: There is no time left on this account.
	 */
	public static final SystemMessageId NO_TIME_LEFT_ON_ACCOUNT;
	
	/**
	 * ID: 399<br>
	 * Message: VXeG[łB<br>
	 * Message: &#24115;&#34399;&#25110;&#23494;&#30908;&#36664;&#20837;&#37679;&#35492;&#65281;&#35531;&#20877;&#27425;&#30906;&#35469;&#24744;&#36664;&#20837;&#30340;&#24115;&#34399;&#23494;&#30908;&#12290;&#25552;&#37266;&#24744;&#65292;&#33258;&#50;&#48;&#48;&#55;&#47;&#49;&#49;&#47;&#50;&#48;&#36215;&#22825;&#22530;&#73;&#73;&#36938;&#25138;&#23494;&#30908;&#24050;&#20462;&#25913;&#28858;&#112;&#108;&#97;&#121;&#110;&#99;&#24115;&#25142;&#23494;&#30908;&#65292;&#35531;&#20351;&#29992;&#112;&#108;&#97;&#121;&#110;&#99;&#23494;&#30908;&#30331;&#20837;&#36938;&#25138;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#23448;&#32178;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#26597;&#35426;&#12290;<br>
	 * Message: System error.
	 */
	public static final SystemMessageId SYSTEM_ERROR;
	
	/**
	 * ID: 400<br>
	 * Message: $s1̂Ă܂B낵łB<br>
	 * Message: &#24744;&#30906;&#23450;&#35201;&#19999;&#26820;&#12300;&#36;&#115;&#49;&#12301;&#21966;&#63;<br>
	 * Message: You are attempting to drop $s1. Dou you wish to continue?
	 */
	public static final SystemMessageId WISH_TO_DROP_S1;
	
	/**
	 * ID: 401<br>
	 * Message: is̃NGXg߂܂B<br>
	 * Message: &#36914;&#34892;&#20013;&#30340;&#20219;&#21209;&#36942;&#22810;&#12290;<br>
	 * Message: You have to many ongoing quests.
	 */
	public static final SystemMessageId TOO_MANY_QUESTS;
	
	/**
	 * ID: 402<br>
	 * Message: DȂƏDł܂B<br>
	 * Message: &#27794;&#26377;&#33337;&#31080;&#65292;&#28961;&#27861;&#25645;&#20056;&#12290;<br>
	 * Message: You do not possess the correct ticket to board the boat.
	 */
	public static final SystemMessageId NOT_CORRECT_BOAT_TICKET;
	
	/**
	 * ID: 403<br>
	 * Message: łAfǐE𒴂܂B<br>
	 * Message: &#37329;&#24163;&#25976;&#37327;&#24050;&#21040;&#36948;&#19978;&#38480;&#12290;<br>
	 * Message: You have exceeded your out-of-pocket adena limit.
	 */
	public static final SystemMessageId EXCEECED_POCKET_ADENA_LIMIT;
	
	/**
	 * ID: 404<br>
	 * Message: ACeXL̃x߂܂B<br>
	 * Message: &#35069;&#20316;&#29289;&#21697;&#30340;&#25216;&#33021;&#31561;&#32026;&#22826;&#20302;&#12290;<br>
	 * Message: Your Create Item level is too low to register this recipe.
	 */
	public static final SystemMessageId CREATE_LVL_TOO_LOW_TO_REGISTER;
	
	/**
	 * ID: 405<br>
	 * Message: iȋz傫߂܂B<br>
	 * Message: &#29986;&#21697;&#20729;&#26684;&#35373;&#23450;&#36229;&#36942;&#19978;&#38480;&#12290;<br>
	 * Message: The total price of the product is too high.
	 */
	public static final SystemMessageId TOTAL_PRICE_TOO_HIGH;
	
	/**
	 * ID: 406<br>
	 * Message: T|[g̐\󂯕t܂B<br>
	 * Message: &#35380;&#27714;&#30340;&#30003;&#35531;&#24050;&#32147;&#34987;&#25509;&#21463;&#12290;<br>
	 * Message: Petition application accepted.
	 */
	public static final SystemMessageId PETITION_APP_ACCEPTED;
	
	/**
	 * ID: 407<br>
	 * Message: ݑΉ̃T|[gvłB<br>
	 * Message: &#35380;&#27714;&#27491;&#22312;&#34389;&#29702;&#20013;&#12290;<br>
	 * Message: Petition under process.
	 */
	public static final SystemMessageId PETITION_UNDER_PROCESS;
	
	/**
	 * ID: 408<br>
	 * Message: U̐ݒ<br>
	 * Message: &#35373;&#23450;&#25915;&#22478;&#26399;&#38291;&#12290;<br>
	 * Message: Set Period
	 */
	public static final SystemMessageId SET_PERIOD;
	
	/**
	 * ID: 409<br>
	 * Message: U̐ݒ܂$s1$s2$s3błB<br>
	 * Message: &#36317;&#38626;&#35373;&#23450;&#40;&#25915;&#22478;&#41;&#26178;&#38291;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#32;&#36;&#115;&#51;&#31186;&#12301;&#12290;<br>
	 * Message: Set Time-$s1:$s2:$s3
	 */
	public static final SystemMessageId SET_TIME_S1_S2_S3;
	
	/**
	 * ID: 410<br>
	 * Message: U̓o^<br>
	 * Message: &#30331;&#37636;&#25915;&#22478;&#26399;&#38291;&#12290;<br>
	 * Message: Registration Period
	 */
	public static final SystemMessageId REGISTRATION_PERIOD;
	
	/**
	 * ID: 411<br>
	 * Message: U̓o^܂$s1$s2$s3błB<br>
	 * Message: &#36317;&#38626;&#25915;&#22478;&#30331;&#37636;&#26178;&#38291;&#32;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#32;&#36;&#115;&#51;&#31186;&#12301;&#12290;<br>
	 * Message: Registration Time-$s1:$s2:$s3
	 */
	public static final SystemMessageId REGISTRATION_TIME_S1_S2_S3;
	
	/**
	 * ID: 412<br>
	 * Message: ŮJn܂$s1$s2$s4błB<br>
	 * Message: &#36317;&#38626;&#25915;&#22478;&#38283;&#22987;&#26178;&#38291;&#32;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#32;&#36;&#115;&#51;&#31186;&#12301;&#12290;<br>
	 * Message: Battle begins in $s1:$s2:$s3
	 */
	public static final SystemMessageId BATTLE_BEGINS_S1_S2_S3;
	
	/**
	 * ID: 413<br>
	 * Message: ȔI܂$s1$s2$s5błB<br>
	 * Message: &#36317;&#38626;&#25915;&#22478;&#32080;&#26463;&#26178;&#38291;&#32;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#32;&#36;&#115;&#51;&#31186;&#12301;&#12290;<br>
	 * Message: Battle ends in $s1:$s2:$s3
	 */
	public static final SystemMessageId BATTLE_ENDS_S1_S2_S3;
	
	/**
	 * ID: 414<br>
	 * Message: Ȗҋ@<br>
	 * Message: &#25915;&#22478;&#31561;&#24453;&#26399;&#38291;&#12290;<br>
	 * Message: Standby
	 */
	public static final SystemMessageId STANDBY;
	
	/**
	 * ID: 415<br>
	 * Message: U풆<br>
	 * Message: &#25915;&#22478;&#20013;&#12290;<br>
	 * Message: Under Siege
	 */
	public static final SystemMessageId UNDER_SIEGE;
	
	/**
	 * ID: 416<br>
	 * Message: g[hłȂԂłB<br>
	 * Message: &#30446;&#21069;&#28961;&#27861;&#20132;&#25563;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: This item cannot be exchanged.
	 */
	public static final SystemMessageId ITEM_CANNOT_EXCHANGE;
	
	/**
	 * ID: 417<br>
	 * Message: $s1𑕔܂B<br>
	 * Message: &#21368;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 has been disarmed.
	 */
	public static final SystemMessageId S1_DISARMED;
	
	/**
	 * ID: 419<br>
	 * Message: gpԂ͎c$s1łB<br>
	 * Message: &#20351;&#29992;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: $s1 minute(s) of usage time left.
	 */
	public static final SystemMessageId S1_MINUTES_USAGE_LEFT;
	
	/**
	 * ID: 420<br>
	 * Message: ʎgpԂI܂B<br>
	 * Message: &#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#24050;&#21040;&#12290;<br>
	 * Message: Time expired.
	 */
	public static final SystemMessageId TIME_EXPIRED;
	
	/**
	 * ID: 421<br>
	 * Message: ̃[U[AJEgŃOC܂B<br>
	 * Message: &#26377;&#20182;&#20154;&#20351;&#29992;&#24744;&#30340;&#24115;&#34399;&#30331;&#20837;&#12290;<br>
	 * Message: Another person has logged in with the same account.
	 */
	public static final SystemMessageId ANOTHER_LOGIN_WITH_ACCOUNT;
	
	/**
	 * ID: 422<br>
	 * Message: edʂ𒴂܂B<br>
	 * Message: &#24050;&#36229;&#36942;&#36000;&#37325;&#38480;&#21046;&#12290;<br>
	 * Message: You have exceeded the weight limit.
	 */
	public static final SystemMessageId WEIGHT_LIMIT_EXCEEDED;
	
	/**
	 * ID: 423<br>
	 * Message: XN[̎gpLZ܂B<br>
	 * Message: &#21462;&#28040;&#24375;&#21270;&#21367;&#36600;&#30340;&#20351;&#29992;&#12290;<br>
	 * Message: You have cancelled the enchanting process.
	 */
	public static final SystemMessageId ENCHANT_SCROLL_CANCELLED;
	
	/**
	 * ID: 424<br>
	 * Message: XN[̋ɍ܂B<br>
	 * Message: &#33287;&#24375;&#21270;&#21367;&#36600;&#30340;&#31561;&#32026;&#19981;&#31526;&#12290;<br>
	 * Message: Does not fit strengthening conditions of the scroll.
	 */
	public static final SystemMessageId DOES_NOT_FIT_SCROLL_CONDITIONS;
	
	/**
	 * ID: 425<br>
	 * Message: ACeXL̃x߂邩AACeXL܂B<br>
	 * Message: &#32068;&#21512;&#36947;&#20855;&#20043;&#32;&#25216;&#33021;&#31561;&#32026;&#22826;&#20302;&#25110;&#28961;&#31561;&#32026;&#12290;<br>
	 * Message: Your Create Item level is too low to register this recipe.
	 */
	public static final SystemMessageId CREATE_LVL_TOO_LOW_TO_REGISTER2;
	
	/**
	 * ID: 445<br>
	 * Message: iމtԍF $s1j<br>
	 * Message: &#65117;&#30003;&#35531;&#21034;&#38500;&#26371;&#21729;&#36039;&#26684;&#20043;&#30003;&#35531;&#34399;&#30908;&#65306;&#12300;&#36;&#115;&#49;&#12301;&#65118;<br>
	 * Message: (Reference Number Regarding Membership Withdrawal Request: $s1)
	 */
	public static final SystemMessageId REFERENCE_MEMBERSHIP_WITHDRAWAL_S1;
	
	/**
	 * ID: 447<br>
	 * Message: B<br>
	 * Message: &#12290;<br>
	 * Message: .
	 */
	public static final SystemMessageId DOT;
	
	/**
	 * ID: 448<br>
	 * Message: VXe G[łB΂炭Ă烍OCĂB<br>
	 * Message: &#31995;&#32113;&#37679;&#35492;&#12290;&#35531;&#31245;&#24460;&#20877;&#37325;&#26032;&#30331;&#20837;&#12290;<br>
	 * Message: There is a system error. Please log in again later.
	 */
	public static final SystemMessageId SYSTEM_ERROR_LOGIN_LATER;
	
	/**
	 * ID: 449<br>
	 * Message: AJEgƃpX[hv܂B<br>
	 * Message: &#24115;&#34399;&#25110;&#23494;&#30908;&#36664;&#20837;&#37679;&#35492;&#65281;&#35531;&#20877;&#27425;&#30906;&#35469;&#24744;&#36664;&#20837;&#30340;&#24115;&#34399;&#23494;&#30908;&#12290;<br>
	 * Message: The password you have entered is incorrect.
	 */
	public static final SystemMessageId PASSWORD_ENTERED_INCORRECT1;
	
	/**
	 * ID: 450<br>
	 * Message: AJEgĊmFăOCĂB<br>
	 * Message: &#25552;&#37266;&#24744;&#65292;&#33258;&#50;&#48;&#48;&#55;&#47;&#49;&#49;&#47;&#50;&#48;&#36215;&#22825;&#22530;&#73;&#73;&#36938;&#25138;&#23494;&#30908;&#24050;&#20462;&#25913;&#28858;&#112;&#108;&#97;&#121;&#110;&#99;&#24115;&#25142;&#23494;&#30908;&#65292;&#35531;&#20351;&#29992;&#112;&#108;&#97;&#121;&#110;&#99;&#23494;&#30908;&#30331;&#20837;&#36938;&#25138;&#65292;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#23448;&#32178;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#26597;&#35426;&#12290;<br>
	 * Message: Confirm your account information and log in later.
	 */
	public static final SystemMessageId CONFIRM_ACCOUNT_LOGIN_LATER;
	
	/**
	 * ID: 451<br>
	 * Message: AJEgƃpX[hv܂B<br>
	 * Message: &#24115;&#34399;&#25110;&#23494;&#30908;&#36664;&#20837;&#37679;&#35492;&#65281;&#35531;&#20877;&#27425;&#30906;&#35469;&#24744;&#36664;&#20837;&#30340;&#24115;&#34399;&#23494;&#30908;&#12290;<br>
	 * Message: The password you have entered is incorrect.
	 */
	public static final SystemMessageId PASSWORD_ENTERED_INCORRECT2;
	
	/**
	 * ID: 452<br>
	 * Message: AJEgĊmFăOCĂB<br>
	 * Message: &#35531;&#37325;&#26032;&#30906;&#35469;&#24115;&#34399;&#24460;&#65292;&#20877;&#22039;&#35430;&#30331;&#20837;&#12290;<br>
	 * Message: Please confirm your account information and try logging in later.
	 */
	public static final SystemMessageId PLEASE_CONFIRM_ACCOUNT_LOGIN_LATER;
	
	/**
	 * ID: 453<br>
	 * Message: AJEg񂪐܂B<br>
	 * Message: &#24115;&#34399;&#23494;&#30908;&#37679;&#35492;&#12290;<br>
	 * Message: Your account information is incorrect.
	 */
	public static final SystemMessageId ACCOUNT_INFORMATION_INCORRECT;
	
	/**
	 * ID: 455<br>
	 * Message: łɎgp̃AJEgłBOCł܂B<br>
	 * Message: &#27492;&#24115;&#34399;&#24050;&#26377;&#20154;&#20351;&#29992;&#65292;&#22240;&#27492;&#28961;&#27861;&#30331;&#20837;&#12290;<br>
	 * Message: Account is already in use. Unable to log in.
	 */
	public static final SystemMessageId ACCOUNT_IN_USE;
	
	/**
	 * ID: 456<br>
	 * Message: l[WII ́A15ˈȏ݂̂̕p܂BPvPT[o[18ˈȏ݂̂̕p܂B<br>
	 * Message: &#49;&#53;&#27506;&#20197;&#19978;&#21487;&#36914;&#34892;&#22825;&#22530;&#73;&#73;&#36938;&#25138;&#65292;&#32780;&#49;&#56;&#27506;&#20197;&#19978;&#21487;&#20351;&#29992;&#80;&#118;&#80;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: Lineage II game services may be used by individuals 15 years of age or older except for PvP servers,which may only be used by adults 18 years of age and older (Korea Only)
	 */
	public static final SystemMessageId LINAGE_MINIMUM_AGE;
	
	/**
	 * ID: 457<br>
	 * Message: ݁AQ[ T[o[̃eiXłB΂炭Ă烍OCĂB<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#32173;&#20462;&#36938;&#25138;&#20282;&#26381;&#22120;&#65292;&#35531;&#31245;&#24460;&#20877;&#37325;&#26032;&#30331;&#20837;&#12290;<br>
	 * Message: Currently undergoing game server maintenance. Please log in again later.
	 */
	public static final SystemMessageId SERVER_MAINTENANCE;
	
	/**
	 * ID: 458<br>
	 * Message: vC\ԂI߁AOCł܂B<br>
	 * Message: &#20351;&#29992;&#26399;&#38480;&#24050;&#21040;&#26399;&#65292;&#22240;&#27492;&#28961;&#27861;&#30331;&#20837;&#12290;<br>
	 * Message: Your usage term has expired.
	 */
	public static final SystemMessageId USAGE_TERM_EXPIRED;
	
	/**
	 * ID: 460<br>
	 * Message: FlbgJtF炲p̂ql͓X܃X^btɂmFB<br>
	 * Message: &#35531;&#21521;&#31649;&#29702;&#32773;&#25110;&#23458;&#26381;&#20013;&#24515;<br>
	 * Message: to reactivate your account.
	 */
	public static final SystemMessageId TO_REACTIVATE_YOUR_ACCOUNT;
	
	/**
	 * ID: 461<br>
	 * Message: Q[ T[o[̐ڑɎs܂B<br>
	 * Message: &#33287;&#36938;&#25138;&#20282;&#26381;&#22120;&#36899;&#32218;&#22833;&#25943;&#12290;<br>
	 * Message: Access failed.
	 */
	public static final SystemMessageId ACCESS_FAILED;
	
	/**
	 * ID: 462<br>
	 * Message: ΂炭Ă蒼ĂB<br>
	 * Message: &#35531;&#31245;&#24460;&#20877;&#22039;&#35430;&#12290;<br>
	 * Message: Please try again later.
	 */
	public static final SystemMessageId PLEASE_TRY_AGAIN_LATER;
	
	/**
	 * ID: 464<br>
	 * Message: ݂̂s܂B<br>
	 * Message: &#21516;&#30431;&#20027;&#25165;&#21487;&#20351;&#29992;<br>
	 * Message: This feature is only available alliance leaders.
	 */
	public static final SystemMessageId FEATURE_ONLY_FOR_ALLIANCE_LEADER;
	
	/**
	 * ID: 465<br>
	 * Message: ɉĂ܂B<br>
	 * Message: &#23578;&#26410;&#21152;&#20837;&#21516;&#30431;&#12290;<br>
	 * Message: You are not currently allied with any clans.
	 */
	public static final SystemMessageId NO_CURRENT_ALLIANCES;
	
	/**
	 * ID: 466<br>
	 * Message: Ȃ̂ŐV͎󂯓܂B<br>
	 * Message: &#32068;&#21729;&#24050;&#28415;&#65292;&#32;&#28961;&#27861;&#21152;&#20837;&#26032;&#34880;&#30431;&#12290;<br>
	 * Message: You have exceeded the limit.
	 */
	public static final SystemMessageId YOU_HAVE_EXCEEDED_THE_LIMIT;
	
	/**
	 * ID: 467<br>
	 * Message: Ǖ1oĂȂꍇAV͎󂯓܂B<br>
	 * Message: &#39493;&#36880;&#34880;&#30431;&#24460;&#65292;&#49;&#22825;&#20839;&#28961;&#27861;&#20877;&#37325;&#26032;&#21109;&#36896;&#34880;&#30431;&#12290;<br>
	 * Message: You may not accept any clan within a day after expelling another clan.
	 */
	public static final SystemMessageId CANT_INVITE_CLAN_WITHIN_1_DAY;
	
	/**
	 * ID: 468<br>
	 * Message: ǕꂽEނ́A1ȓɂ͓ɉł܂B<br>
	 * Message: &#34987;&#21435;&#38500;&#65292;&#32;&#25110;&#33258;&#24049;&#36864;&#38500;&#30340;&#34880;&#30431;&#65292;&#32;&#49;&#22825;&#20839;&#28961;&#27861;&#21152;&#20837;&#21516;&#30431;&#12290;<br>
	 * Message: A clan that has withdrawn or been expelled cannot enter into an alliance within one day of withdrawal or expulsion.
	 */
	public static final SystemMessageId CANT_ENTER_ALLIANCE_WITHIN_1_DAY;
	
	/**
	 * ID: 469<br>
	 * Message: ֌Wɂ錌Ƃ͓ł܂B<br>
	 * Message: &#26377;&#34880;&#25136;&#38364;&#20418;&#30340;&#34880;&#30431;&#65292;&#32;&#28961;&#27861;&#36914;&#34892;&#21516;&#30431;&#12290;<br>
	 * Message: You may not ally with a clan you are currently at war with. That would be diabolical and treacherous.
	 */
	public static final SystemMessageId MAY_NOT_ALLY_CLAN_BATTLE;
	
	/**
	 * ID: 470<br>
	 * Message: ݂̂̒Eސ\ł܂B<br>
	 * Message: &#21482;&#26377;&#34880;&#30431;&#30431;&#20027;&#21487;&#20197;&#30003;&#35531;&#36864;&#20986;&#21516;&#30431;&#12290;<br>
	 * Message: Only the clan leader may apply for withdrawal from the alliance.
	 */
	public static final SystemMessageId ONLY_CLAN_LEADER_WITHDRAW_ALLY;
	
	/**
	 * ID: 471<br>
	 * Message: ͒Eނł܂B<br>
	 * Message: &#21516;&#30431;&#20027;&#28961;&#27861;&#36864;&#20986;&#12290;<br>
	 * Message: Alliance leaders cannot withdraw.
	 */
	public static final SystemMessageId ALLIANCE_LEADER_CANT_WITHDRAW;
	
	/**
	 * ID: 472<br>
	 * Message: ̌͒Ǖł܂B<br>
	 * Message: &#28961;&#27861;&#21435;&#38500;&#33258;&#24049;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: You cannot expel yourself from the clan.
	 */
	public static final SystemMessageId CANNOT_EXPEL_YOURSELF;
	
	/**
	 * ID: 473<br>
	 * Message: ɑ錌ł͂܂B<br>
	 * Message: &#19981;&#26159;&#23660;&#26044;&#21516;&#30431;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: Different alliance.
	 */
	public static final SystemMessageId DIFFERENT_ALLIANCE;
	
	/**
	 * ID: 474<br>
	 * Message: Y݂܂B<br>
	 * Message: &#27492;&#34880;&#30431;&#19981;&#23384;&#22312;&#12290;<br>
	 * Message: That clan does not exist.
	 */
	public static final SystemMessageId CLAN_DOESNT_EXISTS;
	
	/**
	 * ID: 475<br>
	 * Message: ɑ錌ł͂܂B<br>
	 * Message: &#19981;&#26159;&#23660;&#26044;&#21516;&#30431;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: Different alliance.
	 */
	public static final SystemMessageId DIFFERENT_ALLIANCE2;
	
	/**
	 * ID: 476<br>
	 * Message: 摜t@C̃TCY܂B8x12sNZɎw肵ĂB<br>
	 * Message: &#27492;&#22294;&#29255;&#22823;&#23567;&#19981;&#31526;&#21512;&#12290;&#32;&#35531;&#25913;&#25104;&#56;&#42;&#49;&#50;&#12290;<br>
	 * Message: Please adjust the image size to 8x12.
	 */
	public static final SystemMessageId ADJUST_IMAGE_8_12;
	
	/**
	 * ID: 477<br>
	 * Message: Ȃ߁ÅULZ܂B<br>
	 * Message: &#22240;&#27794;&#26377;&#22238;&#35206;&#65292;&#32;&#22240;&#27492;&#21462;&#28040;&#21152;&#20837;&#25152;&#36992;&#35531;&#20043;&#21516;&#30431;&#12290;<br>
	 * Message: No response. Invitation to join an alliance has been cancelled.
	 */
	public static final SystemMessageId NO_RESPONSE_TO_ALLY_INVITATION;
	
	/**
	 * ID: 478<br>
	 * Message: UɉȂ߁ẢLZ܂B<br>
	 * Message: &#22240;&#27794;&#26377;&#22238;&#35206;&#36992;&#35531;&#65292;&#32;&#22240;&#27492;&#21462;&#28040;&#21152;&#20837;&#25152;&#36992;&#35531;&#20043;&#21516;&#30431;&#12290;<br>
	 * Message: No response. Your entrance to the alliance has been cancelled.
	 */
	public static final SystemMessageId YOU_DID_NOT_RESPOND_TO_ALLY_INVITATION;
	
	/**
	 * ID: 479<br>
	 * Message: $s1VFlɓo^܂B<br>
	 * Message: &#36;&#115;&#49;&#30331;&#20837;&#28858;&#26032;&#30340;&#22909;&#21451;&#12290;<br>
	 * Message: $s1 has joined as a friend.
	 */
	public static final SystemMessageId S1_JOINED_AS_FRIEND;
	
	/**
	 * ID: 480<br>
	 * Message: FlXgmFĂB<br>
	 * Message: &#35531;&#37325;&#26032;&#26597;&#30475;&#22909;&#21451;&#21517;&#21934;&#12290;<br>
	 * Message: Please check your friend list.
	 */
	public static final SystemMessageId PLEASE_CHECK_YOUR_FRIENDS_LIST;
	
	/**
	 * ID: 481<br>
	 * Message: $s1FlXg폜܂B<br>
	 * Message: &#36;&#115;&#49;&#24050;&#22312;&#22909;&#21451;&#21517;&#21934;&#20013;&#21034;&#38500;&#12290;<br>
	 * Message: $s1 has been deleted from your friends list.
	 */
	public static final SystemMessageId S1_HAS_BEEN_DELETED_FROM_YOUR_FRIENDS_LIST;
	
	/**
	 * ID: 482<br>
	 * Message: gFlƂēo^邱Ƃ͂ł܂B<br>
	 * Message: &#33258;&#24049;&#24115;&#34399;&#28961;&#27861;&#21152;&#20837;&#20320;&#30340;&#22909;&#21451;&#21517;&#21934;&#35041;&#12290;<br>
	 * Message: You cannot add yourself to your own friend list.
	 */
	public static final SystemMessageId YOU_CANNOT_ADD_YOURSELF_TO_YOUR_OWN_FRIENDS_LIST;
	
	/**
	 * ID: 483<br>
	 * Message: FlXg܂쐬Ă܂B΂炭Ă炲pB<br>
	 * Message: &#23578;&#26410;&#23436;&#25104;&#32232;&#21046;&#22909;&#21451;&#21517;&#21934;&#12290;&#32;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: This function is inaccessible right now. Please try again later.
	 */
	public static final SystemMessageId FUNCTION_INACCESSIBLE_NOW;
	
	/**
	 * ID: 484<br>
	 * Message: łɗFlXgɓo^Ă܂B<br>
	 * Message: &#24050;&#21152;&#20837;&#22909;&#21451;&#21517;&#21934;&#12290;<br>
	 * Message: This player is already registered in your friends list.
	 */
	public static final SystemMessageId S1_ALREADY_IN_FRIENDS_LIST;
	
	/**
	 * ID: 485<br>
	 * Message: FlɂȂ邱Ƃ߂[U[܂B<br>
	 * Message: &#27794;&#26377;&#36992;&#35531;&#22909;&#21451;&#21152;&#20837;&#30340;&#29609;&#23478;&#12290;<br>
	 * Message: No new friend invitations may be accepted.
	 */
	public static final SystemMessageId NO_NEW_INVITATIONS_ACCEPTED;
	
	/**
	 * ID: 486<br>
	 * Message: FlXgɓo^Ă郆[U[ł͂܂B<br>
	 * Message: &#27794;&#26377;&#22312;&#22909;&#21451;&#21517;&#21934;&#20839;&#12290;<br>
	 * Message: The following user is not in your friends list.
	 */
	public static final SystemMessageId THE_USER_NOT_IN_FRIENDS_LIST;
	
	/**
	 * ID: 487<br>
	 * Message: ======<FlXg>======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#60;&#22909;&#21451;&#21517;&#21934;&#62;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ======<Friends List>======
	 */
	public static final SystemMessageId FRIEND_LIST_HEADER;
	
	/**
	 * ID: 488<br>
	 * Message: $s1iXe[^XFICj<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#32;&#40;&#30446;&#21069;&#29376;&#24907;&#32;&#58;&#32;&#79;&#78;&#108;&#105;&#110;&#101;&#41;<br>
	 * Message: $s1 (Currently: Online)
	 */
	public static final SystemMessageId S1_ONLINE;
	
	/**
	 * ID: 489<br>
	 * Message: $s1iXe[^XFItCj<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#32;&#40;&#30446;&#21069;&#29376;&#24907;&#32;&#58;&#32;&#79;&#102;&#102;&#108;&#105;&#110;&#101;&#41;<br>
	 * Message: $s1 (Currently: Offline)
	 */
	public static final SystemMessageId S1_OFFLINE;
	
	/**
	 * ID: 490<br>
	 * Message: ========================<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ========================
	 */
	public static final SystemMessageId FRIEND_LIST_FOOTER;
	
	/**
	 * ID: 491<br>
	 * Message: =======<>=======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#21516;&#30431;&#36039;&#35338;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: =======<Alliance Information>=======
	 */
	public static final SystemMessageId ALLIANCE_INFO_HEAD;
	
	/**
	 * ID: 492<br>
	 * Message: F$s1<br>
	 * Message: &#21516;&#30431;&#21517;&#32;&#32;&#32;&#32;&#58;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Alliance Name: $s1
	 */
	public static final SystemMessageId ALLIANCE_NAME_S1;
	
	/**
	 * ID: 493<br>
	 * Message: ڑF$s1l/v$s2l<br>
	 * Message: &#22312;&#32218;&#20154;&#25976;&#32;&#32;&#32;&#32;&#32;&#32;&#32;&#58;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#32;&#47;&#32;&#20849;&#12300;&#36;&#115;&#50;&#12301;&#21517;<br>
	 * Message: Connection: $s1 / Total $s2
	 */
	public static final SystemMessageId CONNECTION_S1_TOTAL_S2;
	
	/**
	 * ID: 494<br>
	 * Message: F$s1$s2<br>
	 * Message: &#21516;&#30431;&#20027;&#32;&#32;&#32;&#32;&#58;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#12300;&#36;&#115;&#50;&#12301;<br>
	 * Message: Alliance Leader: $s2 of $s1
	 */
	public static final SystemMessageId ALLIANCE_LEADER_S2_OF_S1;
	
	/**
	 * ID: 495<br>
	 * Message: Fv$s1<br>
	 * Message: &#25152;&#23660;&#34880;&#30431;&#32;&#58;&#32;&#20849;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;<br>
	 * Message: Affiliated clans: Total $s1 clan(s)
	 */
	public static final SystemMessageId ALLIANCE_CLAN_TOTAL_S1;
	
	/**
	 * ID: 496<br>
	 * Message: =====<̏>=====<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#60;&#25152;&#23660;&#34880;&#30431;&#36039;&#35338;&#62;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: =====<Clan Information>=====
	 */
	public static final SystemMessageId CLAN_INFO_HEAD;
	
	/**
	 * ID: 497<br>
	 * Message: F$s1<br>
	 * Message: &#34880;&#30431;&#21517;&#32;&#32;&#32;&#32;&#58;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Clan Name: $s1
	 */
	public static final SystemMessageId CLAN_INFO_NAME_S1;
	
	/**
	 * ID: 498<br>
	 * Message: F$s1<br>
	 * Message: &#34880;&#30431;&#30431;&#20027;&#32;&#32;&#32;&#32;&#58;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Clan Leader: $s1
	 */
	public static final SystemMessageId CLAN_INFO_LEADER_S1;
	
	/**
	 * ID: 499<br>
	 * Message: xF$s1<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#32;&#58;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Clan Level: $s1
	 */
	public static final SystemMessageId CLAN_INFO_LEVEL_S1;
	
	/**
	 * ID: 500<br>
	 * Message: ------------------------<br>
	 * Message: &#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;&#45;<br>
	 * Message: ------------------------
	 */
	public static final SystemMessageId CLAN_INFO_SEPARATOR;
	
	/**
	 * ID: 501<br>
	 * Message: ========================<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ========================
	 */
	public static final SystemMessageId CLAN_INFO_FOOT;
	
	/**
	 * ID: 502<br>
	 * Message: łɓɉĂ܂B<br>
	 * Message: &#24050;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: You already belong to another alliance.
	 */
	public static final SystemMessageId ALREADY_JOINED_ALLIANCE;
	
	/**
	 * ID: 503<br>
	 * Message: Fl$s1 OC܂B<br>
	 * Message: &#20320;&#30340;&#22909;&#21451;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#30331;&#20837;&#12290;<br>
	 * Message: $s1 (Friend) has logged in.
	 */
	public static final SystemMessageId FRIEND_S1_HAS_LOGGED_IN;
	
	/**
	 * ID: 504<br>
	 * Message: ݂̂n݂ł܂B<br>
	 * Message: &#21482;&#26377;&#34880;&#30431;&#30431;&#20027;&#32;&#21487;&#20197;&#21109;&#31435;&#21516;&#30431;&#12290;<br>
	 * Message: Only clan leaders may create alliances.
	 */
	public static final SystemMessageId ONLY_CLAN_LEADER_CREATE_ALLIANCE;
	
	/**
	 * ID: 505<br>
	 * Message: U̓͐Vȓ̑n݂͂ł܂B<br>
	 * Message: &#35299;&#25955;&#21516;&#30431;&#24460;&#65292;&#49;&#26085;&#20043;&#20839;&#28961;&#27861;&#20877;&#37325;&#26032;&#21109;&#31435;&#26032;&#21516;&#30431;&#12290;<br>
	 * Message: You cannot create a new alliance within 10 days after dissolution.
	 */
	public static final SystemMessageId CANT_CREATE_ALLIANCE_10_DAYS_DISOLUTION;
	
	/**
	 * ID: 506<br>
	 * Message: ܂B<br>
	 * Message: &#21516;&#30431;&#21517;&#31281;&#19981;&#31526;&#21512;&#35215;&#23450;&#12290;<br>
	 * Message: Incorrect alliance name. Please try again.
	 */
	public static final SystemMessageId INCORRECT_ALLIANCE_NAME;
	
	/**
	 * ID: 507<br>
	 * Message: ߂܂B<br>
	 * Message: &#21516;&#30431;&#21517;&#31281;&#30340;&#38263;&#24230;&#19981;&#31526;&#21512;&#35215;&#23450;&#12290;<br>
	 * Message: Incorrect length for an alliance name.
	 */
	public static final SystemMessageId INCORRECT_ALLIANCE_NAME_LENGTH;
	
	/**
	 * ID: 508<br>
	 * Message: łɑ݂铯łB<br>
	 * Message: &#27492;&#21516;&#30431;&#24050;&#26377;&#20154;&#20351;&#29992;&#12290;<br>
	 * Message: This alliance name already exists.
	 */
	public static final SystemMessageId ALLIANCE_ALREADY_EXISTS;
	
	/**
	 * ID: 509<br>
	 * Message: ̌ƍUœG֌WƂĐ\Ă̂ŁAtł܂B<br>
	 * Message: &#22312;&#25915;&#22478;&#25136;&#26178;&#65292;&#33287;&#21516;&#30431;&#20013;&#30340;&#34880;&#30431;&#34389;&#26044;&#25973;&#23565;&#38364;&#20418;&#65292;&#25925;&#28961;&#27861;&#25509;&#21463;&#12290;<br>
	 * Message: Cannot accept. clan ally is registered as an enemy during siege battle.
	 */
	public static final SystemMessageId CANT_ACCEPT_ALLY_ENEMY_FOR_SIEGE;
	
	/**
	 * ID: 510<br>
	 * Message: ɏ҂܂B<br>
	 * Message: &#36992;&#35531;&#21516;&#30431;&#12290;<br>
	 * Message: You have invited someone to your alliance.
	 */
	public static final SystemMessageId YOU_INVITED_FOR_ALLIANCE;
	
	/**
	 * ID: 511<br>
	 * Message: ɏ҂lIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#36992;&#35531;&#21152;&#20837;&#21516;&#30431;&#30340;&#20154;&#12290;<br>
	 * Message: You must first select a user to invite.
	 */
	public static final SystemMessageId SELECT_USER_TO_INVITE;
	
	/**
	 * ID: 512<br>
	 * Message: {ɓEނ܂BEތ1ԁA̓ɍĉł܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#33067;&#38626;&#21516;&#30431;&#21966;&#65311;&#33067;&#38626;&#24460;&#22312;&#49;&#26085;&#20839;&#28961;&#27861;&#37325;&#26032;&#21152;&#20837;&#20854;&#20182;&#21516;&#30431;&#12290;<br>
	 * Message: Do you really wish to withdraw from the alliance?
	 */
	public static final SystemMessageId DO_YOU_WISH_TO_WITHDRW;
	
	/**
	 * ID: 513<br>
	 * Message: Ǖ鑊̌͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#39493;&#36880;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the name of the clan you wish to expel.
	 */
	public static final SystemMessageId ENTER_NAME_CLAN_TO_EXPEL;
	
	/**
	 * ID: 514<br>
	 * Message: {ɉU܂BU͓đn݂ł܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#35299;&#25955;&#21966;&#65311;&#49;&#26085;&#20839;&#28961;&#27861;&#37325;&#26032;&#21109;&#31435;&#21516;&#30431;&#12290;<br>
	 * Message: Do you really wish to dissolve the alliance?
	 */
	public static final SystemMessageId DO_YOU_WISH_TO_DISOLVE;
	
	/**
	 * ID: 516<br>
	 * Message: $s1 ȂFlƂď҂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36992;&#35531;&#20320;&#21152;&#20837;&#22909;&#21451;&#21517;&#21934;&#12290;<br>
	 * Message: $s1 has invited you to be their friend.
	 */
	public static final SystemMessageId SI_INVITED_YOU_AS_FRIEND;
	
	/**
	 * ID: 517<br>
	 * Message: ܂B<br>
	 * Message: &#31572;&#25033;&#21516;&#30431;&#12290;<br>
	 * Message: You have accepted the alliance.
	 */
	public static final SystemMessageId YOU_ACCEPTED_ALLIANCE;
	
	/**
	 * ID: 518<br>
	 * Message: ̏҂Ɏs܂B<br>
	 * Message: &#21516;&#30431;&#36992;&#35531;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to invite a clan into the alliance.
	 */
	public static final SystemMessageId FAILED_TO_INVITE_CLAN_IN_ALLIANCE;
	
	/**
	 * ID: 519<br>
	 * Message: Eނ܂B<br>
	 * Message: &#33067;&#38626;&#21516;&#30431;&#12290;<br>
	 * Message: You have withdrawn from the alliance.
	 */
	public static final SystemMessageId YOU_HAVE_WITHDRAWN_FROM_ALLIANCE;
	
	/**
	 * ID: 520<br>
	 * Message: ̒EނɎs܂B<br>
	 * Message: &#21516;&#30431;&#33067;&#38626;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to withdraw from the alliance.
	 */
	public static final SystemMessageId YOU_HAVE_FAILED_TO_WITHDRAWN_FROM_ALLIANCE;
	
	/**
	 * ID: 521<br>
	 * Message: ̒Ǖɐ܂B<br>
	 * Message: &#34880;&#30431;&#25512;&#32763;&#25104;&#21151;&#12290;<br>
	 * Message: You have succeeded in expelling a clan.
	 */
	public static final SystemMessageId YOU_HAVE_EXPELED_A_CLAN;
	
	/**
	 * ID: 522<br>
	 * Message: ̒ǕɎs܂B<br>
	 * Message: &#34880;&#30431;&#25512;&#32763;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to expel a clan.
	 */
	public static final SystemMessageId FAILED_TO_EXPELED_A_CLAN;
	
	/**
	 * ID: 523<br>
	 * Message: U܂B<br>
	 * Message: &#21516;&#30431;&#35299;&#25955;&#12290;<br>
	 * Message: The alliance has been dissolved.
	 */
	public static final SystemMessageId ALLIANCE_DISOLVED;
	
	/**
	 * ID: 524<br>
	 * Message: ̉UɎs܂B<br>
	 * Message: &#21516;&#30431;&#35299;&#25955;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to dissolve the alliance.
	 */
	public static final SystemMessageId FAILED_TO_DISOLVE_ALLIANCE;
	
	/**
	 * ID: 525<br>
	 * Message: Fl̏҂ɐ܂B<br>
	 * Message: &#34987;&#22909;&#21451;&#36992;&#35531;&#25104;&#21151;&#12290;<br>
	 * Message: You have succeeded in inviting a friend to your friends list.
	 */
	public static final SystemMessageId YOU_HAVE_SUCCEEDED_INVITING_FRIEND;
	
	/**
	 * ID: 526<br>
	 * Message: Fl̏҂Ɏs܂B<br>
	 * Message: &#34987;&#22909;&#21451;&#36992;&#35531;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to add a friend to your friends list.
	 */
	public static final SystemMessageId FAILED_TO_INVITE_A_FRIEND;
	
	/**
	 * ID: 527<br>
	 * Message: $s1̓$s2 ɓ\܂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#21516;&#30431;&#20027;&#12300;&#36;&#115;&#50;&#12301;&#36992;&#35531;&#21516;&#30431;&#12290;<br>
	 * Message: $s1 leader, $s2, has requested an alliance.
	 */
	public static final SystemMessageId S2_ALLIANCE_LEADER_OF_S1_REQUESTED_ALLIANCE;
	
	/**
	 * ID: 530<br>
	 * Message: Xsbg Vbg̃O[hƈv܂B<br>
	 * Message: &#19981;&#36969;&#21512;&#29992;&#22312;&#35442;&#31561;&#32026;&#27494;&#22120;&#30340;&#39764;&#38728;&#24392;&#12290;<br>
	 * Message: The Spiritshot does not match the weapon's grade.
	 */
	public static final SystemMessageId SPIRITSHOTS_GRADE_MISMATCH;
	
	/**
	 * ID: 531<br>
	 * Message: Xsbg Vbg܂B<br>
	 * Message: &#39764;&#38728;&#24392;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough Spiritshots for that.
	 */
	public static final SystemMessageId NOT_ENOUGH_SPIRITSHOTS;
	
	/**
	 * ID: 532<br>
	 * Message: Xsbg Vbgg܂B<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#39764;&#38728;&#24392;&#12290;<br>
	 * Message: You may not use Spiritshots.
	 */
	public static final SystemMessageId CANNOT_USE_SPIRITSHOTS;
	
	/**
	 * ID: 533<br>
	 * Message: }i̗͂g܂B<br>
	 * Message: &#28748;&#27880;&#39764;&#27861;&#20043;&#21147;&#12290;<br>
	 * Message: Power of Mana enabled.
	 */
	public static final SystemMessageId ENABLED_SPIRITSHOT;
	
	/**
	 * ID: 534<br>
	 * Message: }i̗͂ȂȂ܂B<br>
	 * Message: &#35299;&#38500;&#39764;&#27861;&#20043;&#21147;&#12290;<br>
	 * Message: Power of Mana disabled.
	 */
	public static final SystemMessageId DISABLED_SPIRITSHOT;
	
	/**
	 * ID: 535<br>
	 * Message: ybgɖO܂B<br>
	 * Message: &#35531;&#21462;&#23541;&#29289;&#21517;&#12290;<br>
	 * Message: Enter a name for your pet.
	 */
	
	/**
	 * ID: 536<br>
	 * Message: Afiǂꂭ炢CxgɈڂ܂B<br>
	 * Message: &#35201;&#23559;&#31227;&#21205;&#22810;&#23569;&#25976;&#37327;&#33267;&#35282;&#33394;&#36947;&#20855;&#28165;&#21934;&#20839;&#65311;<br>
	 * Message: How much adena do you wish to transfer to your Inventory?
	 */
	public static final SystemMessageId HOW_MUCH_ADENA_TRANSFER;
	
	/**
	 * ID: 537<br>
	 * Message: ڂ܂B<br>
	 * Message: &#35201;&#31227;&#21205;&#24190;&#20491;&#65311;<br>
	 * Message: How much will you transfer?
	 */
	public static final SystemMessageId HOW_MUCH_TRANSFER;
	
	/**
	 * ID: 538<br>
	 * Message: SP$s1܂B<br>
	 * Message: &#28040;&#32791;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#83;&#80;&#12290;<br>
	 * Message: Your SP has decreased by $s1.
	 */
	public static final SystemMessageId SP_DECREASED_S1;
	
	/**
	 * ID: 539<br>
	 * Message: ol$s1܂B<br>
	 * Message: &#28040;&#32791;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#32147;&#39511;&#20540;&#12290;<br>
	 * Message: Your Experience has decreased by $s1.
	 */
	public static final SystemMessageId EXP_DECREASED_BY_S1;
	
	/**
	 * ID: 540<br>
	 * Message: ͍폜ł܂BUĂ蒼Ă݂ĂB<br>
	 * Message: &#34880;&#30431;&#30431;&#20027;&#28961;&#27861;&#21034;&#38500;&#65292;&#35531;&#35299;&#25955;&#34880;&#30431;&#24460;&#37325;&#26032;&#20877;&#35430;&#12290;<br>
	 * Message: Clan leaders may not be deleted. Dissolve the clan first and try again.
	 */
	public static final SystemMessageId CLAN_LEADERS_MAY_NOT_BE_DELETED;
	
	/**
	 * ID: 541<br>
	 * Message: ͍폜ł܂BEނĂ蒼Ă݂ĂB<br>
	 * Message: &#34880;&#30431;&#21729;&#28961;&#27861;&#21034;&#38500;&#12290;&#32;&#34880;&#30431;&#22312;&#33067;&#38626;&#24460;&#32;&#20877;&#35430;&#12290;<br>
	 * Message: You may not delete a clan member. Withdraw from the clan first and try again.
	 */
	public static final SystemMessageId CLAN_MEMBER_MAY_NOT_BE_DELETED;
	
	/**
	 * ID: 542<br>
	 * Message: NPCT[o[쓮ĂȂ߁Aybgł܂B<br>
	 * Message: &#78;&#80;&#67;&#20282;&#26381;&#22120;&#27491;&#22312;&#28310;&#20633;&#20013;&#65292;&#25925;&#28961;&#27861;&#21484;&#21914;&#23541;&#29289;&#12290;<br>
	 * Message: The NPC server is currently down. Pets and servitors cannot be summoned at this time.
	 */
	public static final SystemMessageId THE_NPC_SERVER_IS_CURRENTLY_DOWN;
	
	/**
	 * ID: 543<br>
	 * Message: łɃybg܂B<br>
	 * Message: &#24050;&#26377;&#23541;&#29289;&#12290;<br>
	 * Message: You already have a pet.
	 */
	public static final SystemMessageId YOU_ALREADY_HAVE_A_PET;
	
	/**
	 * ID: 544<br>
	 * Message: ybgɓnȂACełB<br>
	 * Message: &#27492;&#36947;&#20855;&#28961;&#27861;&#32102;&#23541;&#29289;&#12290;<br>
	 * Message: Your pet cannot carry this item.
	 */
	public static final SystemMessageId ITEM_NOT_FOR_PETS;
	
	/**
	 * ID: 545<br>
	 * Message: ybg̃Cxg̃XbgɂACen܂B<br>
	 * Message: &#23541;&#29289;&#30340;&#36947;&#20855;&#28165;&#21934;&#25976;&#37327;&#26377;&#38480;&#65292;&#22240;&#27492;&#28961;&#27861;&#20877;&#25552;&#20379;&#36947;&#20855;&#12290;<br>
	 * Message: Your pet cannot carry any more items. Remove some, then try again.
	 */
	public static final SystemMessageId YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS;
	
	/**
	 * ID: 546<br>
	 * Message: ybgpCxg̏dʐɂACen܂B<br>
	 * Message: &#22240;&#23541;&#29289;&#30340;&#36947;&#20855;&#36000;&#37325;&#25976;&#37327;&#38480;&#21046;&#65292;&#28961;&#27861;&#20877;&#32102;&#36947;&#20855;&#12290;<br>
	 * Message: Unable to place item, your pet is too encumbered.
	 */
	public static final SystemMessageId UNABLE_TO_PLACE_ITEM_YOUR_PET_IS_TOO_ENCUMBERED;
	
	/**
	 * ID: 547<br>
	 * Message: ybg܂B<br>
	 * Message: &#21484;&#21914;&#23541;&#29289;&#12290;<br>
	 * Message: Summoning your pet.
	 */
	public static final SystemMessageId SUMMON_A_PET;
	
	/**
	 * ID: 548<br>
	 * Message: ybg̖O8܂ŉ\łB<br>
	 * Message: &#23541;&#29289;&#30340;&#21517;&#31281;&#21487;&#20197;&#23531;&#21040;&#56;&#20491;&#23383;&#12290;<br>
	 * Message: Your pet's name can be up to 8 characters in length.
	 */
	public static final SystemMessageId NAMING_PETNAME_UP_TO_8CHARS;
	
	/**
	 * ID: 549<br>
	 * Message: ɂ́Ãx5ȏłȂ΂Ȃ܂B<br>
	 * Message: &#35201;&#21109;&#31435;&#21516;&#30431;&#32;&#34880;&#30431;&#31561;&#32026;&#24517;&#38920;&#35201;&#22312;&#53;&#32026;&#20197;&#19978;&#12290;<br>
	 * Message: To create an alliance, your clan must be Level 5 or higher.
	 */
	public static final SystemMessageId TO_CREATE_AN_ALLY_YOU_CLAN_MUST_BE_LEVEL_5_OR_HIGHER;
	
	/**
	 * ID: 550<br>
	 * Message: UP\Ԓ͓̑n݂͂ł܂B<br>
	 * Message: &#22312;&#35299;&#25955;&#23532;&#38480;&#26399;&#20839;&#65292;&#28961;&#27861;&#21109;&#31435;&#21516;&#30431;&#12290;<br>
	 * Message: You may not create an alliance during the term of dissolution postponement.
	 */
	public static final SystemMessageId YOU_MAY_NOT_CREATE_ALLY_WHILE_DISSOLVING;
	
	/**
	 * ID: 551<br>
	 * Message: UP\Ԓ͌xグ܂B<br>
	 * Message: &#22312;&#35299;&#25955;&#23532;&#38480;&#26399;&#20839;&#65292;&#28961;&#27861;&#25552;&#21319;&#34880;&#30431;&#31561;&#32026;&#12290;<br>
	 * Message: You cannot raise your clan level during the term of dispersion postponement.
	 */
	public static final SystemMessageId CANNOT_RISE_LEVEL_WHILE_DISSOLUTION_IN_PROGRESS;
	
	/**
	 * ID: 552<br>
	 * Message: UP\Ԓ̓Gu̓o^э폜͂ł܂B<br>
	 * Message: &#22312;&#35299;&#25955;&#23532;&#38480;&#26399;&#20839;&#65292;&#28961;&#27861;&#30331;&#37636;&#25110;&#21034;&#38500;&#34880;&#30431;&#32011;&#31456;&#12290;<br>
	 * Message: During the grace period for dissolving a clan, the registration or deletion of a clan's crest is not allowed.
	 */
	public static final SystemMessageId CANNOT_SET_CREST_WHILE_DISSOLUTION_IN_PROGRESS;
	
	/**
	 * ID: 553<br>
	 * Message: ͉̌U\܂Ă܂B<br>
	 * Message: &#23565;&#26041;&#34880;&#30431;&#24050;&#23436;&#25104;&#35299;&#25955;&#12290;<br>
	 * Message: The opposing clan has applied for dispersion.
	 */
	public static final SystemMessageId OPPOSING_CLAN_APPLIED_DISPERSION;
	
	/**
	 * ID: 554<br>
	 * Message: ɑ錌͉Uł܂B<br>
	 * Message: &#28961;&#27861;&#35299;&#25955;&#23660;&#26044;&#21516;&#30431;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: You cannot disperse the clans in your alliance.
	 */
	public static final SystemMessageId CANNOT_DISPERSE_THE_CLANS_IN_ALLY;
	
	/**
	 * ID: 555<br>
	 * Message: ĂACed߂ē܂B<br>
	 * Message: &#25793;&#26377;&#30340;&#36947;&#20855;&#36942;&#37325;&#65292;&#22240;&#27492;&#28961;&#27861;&#31227;&#21205;&#12290;<br>
	 * Message: You cannot move - you are too encumbered
	 */
	public static final SystemMessageId CANT_MOVE_TOO_ENCUMBERED;
	
	/**
	 * ID: 556<br>
	 * Message: ݂̏Ԃł͓܂B<br>
	 * Message: &#30446;&#21069;&#29376;&#24907;&#28961;&#27861;&#31227;&#21205;&#12290;<br>
	 * Message: You cannot move in this state
	 */
	public static final SystemMessageId CANT_MOVE_IN_THIS_STATE;
	
	/**
	 * ID: 557<br>
	 * Message: ybgĂ邽߁Ajł܂B<br>
	 * Message: &#23541;&#29289;&#34389;&#26044;&#21484;&#21914;&#29376;&#24907;&#65292;&#28961;&#27861;&#21034;&#38500;&#12290;<br>
	 * Message: Your pet has been summoned and may not be destroyed
	 */
	public static final SystemMessageId PET_SUMMONED_MAY_NOT_DESTROYED;
	
	/**
	 * ID: 558<br>
	 * Message: ybgĂ邽߁AnʂɎ̂Ă܂B<br>
	 * Message: &#23541;&#29289;&#34389;&#26044;&#21484;&#21914;&#29376;&#24907;&#65292;&#28961;&#27861;&#19999;&#26820;&#12290;<br>
	 * Message: Your pet has been summoned and may not be let go.
	 */
	public static final SystemMessageId PET_SUMMONED_MAY_NOT_LET_GO;
	
	/**
	 * ID: 559<br>
	 * Message: $c1$s2𔃂܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have purchased $s2 from $c1.
	 */
	public static final SystemMessageId PURCHASED_S2_FROM_C1;
	
	/**
	 * ID: 560<br>
	 * Message: $c1+$s2$s3𔃂܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: You have purchased +$s2 $s3 from $c1.
	 */
	public static final SystemMessageId PURCHASED_S2_S3_FROM_C1;
	
	/**
	 * ID: 561<br>
	 * Message: $c1$s2 $s3𔃂܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have purchased $s3 $s2(s) from $c1.
	 */
	public static final SystemMessageId PURCHASED_S3_S2_S_FROM_C1;
	
	/**
	 * ID: 562<br>
	 * Message: NX^CỸXL xႢ̂ŃNX^CYł܂B<br>
	 * Message: &#22240;&#32080;&#26230;&#35069;&#20316;&#25216;&#33021;&#31561;&#32026;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#32080;&#26230;&#21270;&#12290;<br>
	 * Message: You may not crystallize this item. Your crystallization skill level is too low.
	 */
	public static final SystemMessageId CRYSTALLIZE_LEVEL_TOO_LOW;
	
	/**
	 * ID: 563<br>
	 * Message: U~̉Ɏs܂B<br>
	 * Message: &#25915;&#25802;&#27442;&#26395;&#21462;&#28040;&#22833;&#25943;&#12290;<br>
	 * Message: Failed to disable attack target.
	 */
	public static final SystemMessageId FAILED_DISABLE_TARGET;
	
	/**
	 * ID: 564<br>
	 * Message: U~̕ύXɎs܂B<br>
	 * Message: &#25915;&#25802;&#27442;&#26395;&#35722;&#26356;&#22833;&#25943;&#12290;<br>
	 * Message: Failed to change attack target.
	 */
	public static final SystemMessageId FAILED_CHANGE_TARGET;
	
	/**
	 * ID: 565<br>
	 * Message: ^܂B<br>
	 * Message: &#36939;&#27683;&#19981;&#36275;&#12290;<br>
	 * Message: Not enough luck.
	 */
	public static final SystemMessageId NOT_ENOUGH_LUCK;
	
	/**
	 * ID: 566<br>
	 * Message: Ɏs܂B<br>
	 * Message: &#28151;&#20098;&#22833;&#25943;&#12290;<br>
	 * Message: Your confusion spell failed.
	 */
	public static final SystemMessageId CONFUSION_FAILED;
	
	/**
	 * ID: 567<br>
	 * Message: tBA[Ɏs܂B<br>
	 * Message: &#24515;&#20043;&#24656;&#25084;&#22833;&#25943;&#12290;<br>
	 * Message: Your fear spell failed.
	 */
	public static final SystemMessageId FEAR_FAILED;
	
	/**
	 * ID: 568<br>
	 * Message: L[rbN̏Ɏs܂B<br>
	 * Message: &#26230;&#39636;&#21484;&#21914;&#22833;&#25943;&#12290;<br>
	 * Message: Cubic Summoning failed.
	 */
	public static final SystemMessageId CUBIC_SUMMONING_FAILED;
	
	/**
	 * ID: 569<br>
	 * Message: ACẻiƂȂ̍܂B낵łB<br>
	 * Message: &#35531;&#27880;&#24847;&#65292;&#36947;&#20855;&#30340;&#20729;&#26684;&#33287;&#21830;&#24215;&#30340;&#33853;&#24046;&#24456;&#22823;&#12290;&#26159;&#21542;&#35201;&#32380;&#32396;&#65311;<br>
	 * Message: Caution -- this item's price greatly differs from non-player run shops. Do you wish to continue?
	 */
	
	/**
	 * ID: 570<br>
	 * Message: $s1܂B<br>
	 * Message: &#35201;&#36092;&#36023;&#24190;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#65311;<br>
	 * Message: How many $s1(s) do you want to purchase?
	 */
	
	/**
	 * ID: 572<br>
	 * Message: $c1 ̃p[eBUɉ܂BiACezFElLj<br>
	 * Message: &#35201;&#31572;&#25033;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#32068;&#38538;&#36992;&#35531;&#21966;&#65311;&#65288;&#25136;&#21033;&#21697;&#20998;&#37197;&#65306;&#25342;&#36215;&#20154;&#25152;&#26377;&#65289;<br>
	 * Message: Do you accept $c1's party invitation? (Item Distribution: Finders Keepers.)
	 */
	public static final SystemMessageId C1_INVITED_YOU_TO_PARTY_FINDERS_KEEPERS;
	
	/**
	 * ID: 573<br>
	 * Message: $c1 ̃p[eBUɉ܂BiACezFp[eB o[Ƀ_Łj<br>
	 * Message: &#35201;&#31572;&#25033;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#32068;&#38538;&#36992;&#35531;&#21966;&#65311;&#32;&#65288;&#25136;&#21033;&#21697;&#20998;&#37197;&#65306;&#38538;&#21729;&#38568;&#27231;&#20998;&#37197;&#65289;<br>
	 * Message: Do you accept $c1's party invitation? (Item Distribution: Random.)
	 */
	public static final SystemMessageId C1_INVITED_YOU_TO_PARTY_RANDOM;
	
	/**
	 * ID: 574<br>
	 * Message: bybg܂B<br>
	 * Message: &#27794;&#26377;&#21484;&#21914;&#34899;&#25110;&#23541;&#29289;&#12290;<br>
	 * Message: Pets and Servitors are not available at this time.
	 */
	public static final SystemMessageId PETS_ARE_NOT_AVAILABLE_AT_THIS_TIME;
	
	/**
	 * ID: 575<br>
	 * Message: ̃AfiybgɈڂ܂B<br>
	 * Message: &#35201;&#23559;&#22810;&#23569;&#37329;&#24163;&#32102;&#23541;&#29289;&#65311;<br>
	 * Message: How much adena do you wish to transfer to your pet?
	 */
	public static final SystemMessageId HOW_MUCH_ADENA_TRANSFER_TO_PET;
	
	/**
	 * ID: 576<br>
	 * Message: ڂ܂B<br>
	 * Message: &#35531;&#21839;&#35201;&#25644;&#24190;&#20491;&#21602;&#65311;<br>
	 * Message: How much do you wish to transfer?
	 */
	public static final SystemMessageId HOW_MUCH_TRANSFER2;
	
	/**
	 * ID: 577<br>
	 * Message: g[hlXɂ͏ł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#32;&#25110;&#32;&#20491;&#20154;&#21830;&#24215;&#35041;&#32;&#28961;&#27861;&#36914;&#34892;&#21484;&#21914;&#12290;<br>
	 * Message: You cannot summon during a trade or while using the private shops.
	 */
	public static final SystemMessageId CANNOT_SUMMON_DURING_TRADE_SHOP;
	
	/**
	 * ID: 578<br>
	 * Message: 퓬͏ł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#36914;&#34892;&#21484;&#21914;&#12290;<br>
	 * Message: You cannot summon during combat.
	 */
	public static final SystemMessageId YOU_CANNOT_SUMMON_IN_COMBAT;
	
	/**
	 * ID: 579<br>
	 * Message: 퓬̃ybg͖߂܂B<br>
	 * Message: &#28961;&#27861;&#25910;&#22238;&#25136;&#39717;&#20013;&#30340;&#23541;&#29289;&#12290;<br>
	 * Message: A pet cannot be sent back during battle.
	 */
	public static final SystemMessageId PET_CANNOT_SENT_BACK_DURING_BATTLE;
	
	/**
	 * ID: 580<br>
	 * Message: ̃ybg⏢bxɎgƂ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#19968;&#27425;&#20351;&#29992;&#22810;&#25976;&#30340;&#23541;&#29289;&#21450;&#20351;&#39764;&#12290;<br>
	 * Message: You may not use multiple pets or servitors at the same time.
	 */
	public static final SystemMessageId SUMMON_ONLY_ONE;
	
	/**
	 * ID: 581<br>
	 * Message: OɃXy[XĂ܂B<br>
	 * Message: &#21517;&#31281;&#26377;&#31354;&#30333;&#34389;&#12290;<br>
	 * Message: There is a space in the name.
	 */
	public static final SystemMessageId NAMING_THERE_IS_A_SPACE;
	
	/**
	 * ID: 582<br>
	 * Message: ֎~ꂽLN^[łB<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#20043;&#35282;&#33394;&#21517;&#31281;&#12290;<br>
	 * Message: Inappropriate character name.
	 */
	public static final SystemMessageId NAMING_INAPPROPRIATE_CHARACTER_NAME;
	
	/**
	 * ID: 583<br>
	 * Message: Oɋ֎~ꂽPꂪĂ܂B<br>
	 * Message: &#27492;&#21517;&#31281;&#21934;&#23383;&#28858;&#31105;&#27490;&#20351;&#29992;&#21934;&#23383;&#12290;<br>
	 * Message: Name includes forbidden words.
	 */
	public static final SystemMessageId NAMING_INCLUDES_FORBIDDEN_WORDS;
	
	/**
	 * ID: 584<br>
	 * Message: łɓÕybg܂B<br>
	 * Message: &#27492;&#23541;&#29289;&#21517;&#31281;&#24050;&#26377;&#20154;&#20351;&#29992;&#12290;<br>
	 * Message: This is already in use by another pet.
	 */
	public static final SystemMessageId NAMING_ALREADY_IN_USE_BY_ANOTHER_PET;
	
	/**
	 * ID: 585<br>
	 * Message: wi߂ĂB<br>
	 * Message: &#35531;&#23450;&#19979;&#36092;&#36023;&#20729;&#26684;&#12290;<br>
	 * Message: Please decide on the price.
	 */
	public static final SystemMessageId DECIDE_ON_PRICE;
	
	/**
	 * ID: 586<br>
	 * Message: ybg̃ACe̓V[gJbgɓo^ł܂B<br>
	 * Message: &#23541;&#29289;&#30340;&#36947;&#20855;&#32;&#28961;&#27861;&#30331;&#20837;&#22312;&#32;&#24555;&#36895;&#37749;&#12290;<br>
	 * Message: Pet items cannot be registered as shortcuts.
	 */
	public static final SystemMessageId PET_NO_SHORTCUT;
	
	/**
	 * ID: 588<br>
	 * Message: ybg̃CxgςłB<br>
	 * Message: &#23541;&#29289;&#30340;&#24235;&#23384;&#26126;&#32048;&#24050;&#28415;&#12290;<br>
	 * Message: Your pet's inventory is full.
	 */
	public static final SystemMessageId PET_INVENTORY_FULL;
	
	/**
	 * ID: 589<br>
	 * Message: 񂾃ybg߂Ƃ͂ł܂B<br>
	 * Message: &#27515;&#20129;&#30340;&#23541;&#29289;&#65292;&#28961;&#27861;&#21484;&#22238;&#12290;<br>
	 * Message: A dead pet cannot be sent back.
	 */
	public static final SystemMessageId DEAD_PET_CANNOT_BE_RETURNED;
	
	/**
	 * ID: 590<br>
	 * Message: 񂾃ybgɃACe͈ړł܂B<br>
	 * Message: &#28961;&#27861;&#23559;&#36947;&#20855;&#32102;&#24050;&#27515;&#25481;&#30340;&#23541;&#29289;<br>
	 * Message: Your pet is motionless and any attempt you make to give it something goes unrecognized.
	 */
	public static final SystemMessageId CANNOT_GIVE_ITEMS_TO_DEAD_PET;
	
	/**
	 * ID: 591<br>
	 * Message: ybg̖Oɖ̕Ă܂B<br>
	 * Message: &#23541;&#29289;&#21517;&#31281;&#26377;&#19981;&#31526;&#21512;&#35215;&#23450;&#30340;&#25991;&#23383;&#12290;<br>
	 * Message: An invalid character is included in the pet's name.
	 */
	public static final SystemMessageId NAMING_PETNAME_CONTAINS_INVALID_CHARS;
	
	/**
	 * ID: 592<br>
	 * Message: {ɉU܂BUƏACe͏܂B<br>
	 * Message: &#20877;&#27425;&#30906;&#35469;&#32;&#26159;&#21542;&#35201;&#35299;&#25955;&#65311;&#22914;&#35299;&#25955;&#23541;&#29289;&#38917;&#37706;&#23601;&#26371;&#19981;&#35211;&#12290;<br>
	 * Message: Do you wish to dismiss your pet? Dismissing your pet will cause the pet necklace to disappear
	 */
	public static final SystemMessageId WISH_TO_DISMISS_PET;
	
	/**
	 * ID: 593<br>
	 * Message: Q炦ꂸAybgȂ̌܂B<br>
	 * Message: &#28961;&#27861;&#24525;&#21463;&#39138;&#39187;&#30340;&#23541;&#29289;&#65292;&#23559;&#38626;&#24744;&#32780;&#21435;&#12290;<br>
	 * Message: Starving, grumpy and fed up, your pet has left.
	 */
	public static final SystemMessageId STARVING_GRUMPY_AND_FED_UP_YOUR_PET_HAS_LEFT;
	
	/**
	 * ID: 594<br>
	 * Message: Qybg͖߂Ƃł܂B<br>
	 * Message: &#27491;&#22312;&#39138;&#39187;&#29376;&#24907;&#30340;&#23541;&#29289;&#65292;&#28961;&#27861;&#25910;&#22238;&#12290;<br>
	 * Message: You may not restore a hungry pet.
	 */
	public static final SystemMessageId YOU_CANNOT_RESTORE_HUNGRY_PETS;
	
	/**
	 * ID: 595<br>
	 * Message: ybg܂ɂĂ܂B<br>
	 * Message: &#23541;&#29289;&#38750;&#24120;&#30340;&#39138;&#39187;&#12290;<br>
	 * Message: Your pet is very hungry.
	 */
	public static final SystemMessageId YOUR_PET_IS_VERY_HUNGRY;
	
	/**
	 * ID: 596<br>
	 * Message: ybg͂ǂɂQ̂܂AˑRƂĂĂ܂B<br>
	 * Message: &#23541;&#29289;&#26377;&#21507;&#40670;&#26481;&#35199;&#12290;&#32;&#20294;&#36996;&#26159;&#32922;&#23376;&#39187;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: Your pet ate a little, but is still hungry.
	 */
	public static final SystemMessageId YOUR_PET_ATE_A_LITTLE_BUT_IS_STILL_HUNGRY;
	
	/**
	 * ID: 597<br>
	 * Message: ybgQɂ܂łȂł܂BCĂB<br>
	 * Message: &#23541;&#29289;&#24050;&#28961;&#27861;&#24525;&#21463;&#39138;&#39187;&#65292;&#35531;&#27880;&#24847;&#65281;<br>
	 * Message: Your pet is very hungry. Please be careful.
	 */
	public static final SystemMessageId YOUR_PET_IS_VERY_HUNGRY_PLEASE_BE_CAREFULL;
	
	/**
	 * ID: 598<br>
	 * Message: Ԃ̂߁Aʃ`bg͂ł܂B<br>
	 * Message: &#34389;&#26044;&#36879;&#26126;&#29376;&#24907;&#26178;&#65292;&#28961;&#27861;&#36914;&#34892;&#19968;&#33324;&#32842;&#22825;&#12290;<br>
	 * Message: You may not chat while you are invisible.
	 */
	public static final SystemMessageId NOT_CHAT_WHILE_INVISIBLE;
	
	/**
	 * ID: 599<br>
	 * Message: T|[gdvȂm点܂B`bg͂΂炭~܂B<br>
	 * Message: &#71;&#77;&#27491;&#22312;&#30332;&#24067;&#37325;&#35201;&#30340;&#35338;&#24687;&#65292;&#22240;&#27492;&#24050;&#26283;&#20572;&#32842;&#22825;&#21151;&#33021;&#12290;<br>
	 * Message: The GM has an important notice. Chat has been temporarily disabled.
	 */
	public static final SystemMessageId GM_NOTICE_CHAT_DISABLED;
	
	/**
	 * ID: 600<br>
	 * Message: ybg ACe͑ł܂B<br>
	 * Message: &#28961;&#27861;&#35037;&#32622;&#23541;&#29289;&#36947;&#20855;&#12290;<br>
	 * Message: You may not equip a pet item.
	 */
	public static final SystemMessageId CANNOT_EQUIP_PET_ITEM;
	
	/**
	 * ID: 601<br>
	 * Message: - t̑ҋ@Ґ$s1łB<br>
	 * Message: &#45;&#32;&#30003;&#35531;&#35380;&#27714;&#31561;&#24453;&#32773;&#20849;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#20301;&#12290;<br>
	 * Message: There are $S1 petitions currently on the waiting list.
	 */
	public static final SystemMessageId S1_PETITION_ON_WAITING_LIST;
	
	/**
	 * ID: 602<br>
	 * Message: ݁AT|[gVXe쓮Ă܂B΂炭Ă蒼ĂB<br>
	 * Message: &#30446;&#21069;&#35380;&#27714;&#31995;&#32113;&#23578;&#26410;&#38283;&#22987;&#20316;&#26989;&#12290;&#32;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: The petition system is currently unavailable. Please try again later.
	 */
	public static final SystemMessageId PETITION_SYSTEM_CURRENT_UNAVAILABLE;
	
	/**
	 * ID: 603<br>
	 * Message: ̃ACê͎Ăg[hł܂B<br>
	 * Message: &#35442;&#36947;&#20855;&#28961;&#27861;&#19999;&#26820;&#25110;&#20132;&#25563;&#12290;<br>
	 * Message: That item cannot be discarded or exchanged.
	 */
	public static final SystemMessageId CANNOT_DISCARD_EXCHANGE_ITEM;
	
	/**
	 * ID: 604<br>
	 * Message: ł̓ybg⏢bł܂B<br>
	 * Message: &#22312;&#36889;&#35041;&#19981;&#21487;&#20197;&#21484;&#21914;&#23541;&#29289;&#25110;&#20351;&#39764;&#12290;<br>
	 * Message: You may not call forth a pet or summoned creature from this location
	 */
	public static final SystemMessageId NOT_CALL_PET_FROM_THIS_LOCATION;
	
	/**
	 * ID: 605<br>
	 * Message: FlXgɂ͍ő128l܂œo^ł܂B<br>
	 * Message: &#22909;&#21451;&#21517;&#21934;&#19978;&#21482;&#33021;&#30331;&#35352;&#49;&#50;&#56;&#21517;&#12290;<br>
	 * Message: You may register up to 64 people on your list.
	 */
	public static final SystemMessageId MAY_REGISTER_UP_TO_64_PEOPLE;
	
	/**
	 * ID: 606<br>
	 * Message: ̗FlXgɓo^ꂽl128l𒴂̂ŁAo^ł܂B<br>
	 * Message: &#23565;&#26041;&#30340;&#22909;&#21451;&#21517;&#21934;&#19978;&#24050;&#26377;&#30331;&#35352;&#49;&#50;&#56;&#21517;&#65292;&#22240;&#27492;&#28961;&#27861;&#20877;&#30331;&#35352;&#12290;<br>
	 * Message: You cannot be registered because the other person has already registered 64 people on his/her list.
	 */
	public static final SystemMessageId OTHER_PERSON_ALREADY_64_PEOPLE;
	
	/**
	 * ID: 607<br>
	 * Message: ȏKXL܂B$s1xɂȂĂ痈ĂB<br>
	 * Message: &#24050;&#32147;&#27794;&#26377;&#21487;&#23416;&#32722;&#30340;&#25216;&#33021;&#65292;&#35531;&#22312;&#36948;&#21040;&#31561;&#32026;&#12300;&#36;&#115;&#49;&#12301;&#24460;&#20877;&#20809;&#39015;&#27492;&#34389;&#12290;<br>
	 * Message: You do not have any further skills to learn. Come back when you have reached Level $s1.
	 */
	public static final SystemMessageId DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1;
	
	/**
	 * ID: 608<br>
	 * Message: $c1XEB[p[$s2 $s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#21033;&#29992;&#22238;&#25910;&#32773;&#25216;&#33021;&#29554;&#24471;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has obtained $s3 $s2 by using Sweeper.
	 */
	public static final SystemMessageId C1_SWEEPED_UP_S3_S2;
	
	/**
	 * ID: 609<br>
	 * Message: $c1XEB[p[$s2ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#21033;&#29992;&#22238;&#25910;&#32773;&#25216;&#33021;&#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has obtained $s2 by using Sweeper.
	 */
	public static final SystemMessageId C1_SWEEPED_UP_S2;
	
	/**
	 * ID: 610<br>
	 * Message: HPȂ߃XL܂B<br>
	 * Message: &#22240;&#72;&#80;&#19981;&#36275;&#65292;&#25216;&#33021;&#34987;&#20013;&#26039;&#12290;<br>
	 * Message: Your skill has been canceled due to lack of HP.
	 */
	public static final SystemMessageId SKILL_REMOVED_DUE_LACK_HP;
	
	/**
	 * ID: 611<br>
	 * Message: Gf킷Ƃɐ܂B<br>
	 * Message: &#25104;&#21151;&#22320;&#25854;&#20098;&#20102;&#25973;&#20154;&#12290;<br>
	 * Message: You have succeeded in Confusing the enemy.
	 */
	public static final SystemMessageId CONFUSING_SUCCEEDED;
	
	/**
	 * ID: 612<br>
	 * Message: X|CԂɂȂ܂B<br>
	 * Message: &#30446;&#27161;&#25104;&#28858;&#33258;&#39636;&#35722;&#21270;&#29376;&#24907;&#12290;<br>
	 * Message: The Spoil condition has been activated.
	 */
	public static final SystemMessageId SPOIL_SUCCESS;
	
	/**
	 * ID: 613<br>
	 * Message: ========<ՒfXg>========<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#60;&#38548;&#32085;&#21517;&#21934;&#62;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ======<Ignore List>======
	 */
	public static final SystemMessageId BLOCK_LIST_HEADER;
	
	/**
	 * ID: 614<br>
	 * Message: $c1F$c2<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#65306;&#12300;&#36;&#99;&#50;&#12301;<br>
	 * Message: $c1 : $c2
	 */
	public static final SystemMessageId C1_D_C2;
	
	/**
	 * ID: 615<br>
	 * Message: ՒfXgւ̓o^Ɏs܂B<br>
	 * Message: &#30331;&#35352;&#38548;&#32085;&#21517;&#21934;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to register the user to your Ignore List.
	 */
	public static final SystemMessageId FAILED_TO_REGISTER_TO_IGNORE_LIST;
	
	/**
	 * ID: 616<br>
	 * Message: ՒfXg̍폜Ɏs܂B<br>
	 * Message: &#21034;&#38500;&#38548;&#32085;&#21517;&#21934;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to delete the character.
	 */
	public static final SystemMessageId FAILED_TO_DELETE_CHARACTER;
	
	/**
	 * ID: 617<br>
	 * Message: $s1ՒfXgɓo^܂B<br>
	 * Message: &#22312;&#38548;&#32085;&#21517;&#21934;&#20013;&#30331;&#35352;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 has been added to your Ignore List.
	 */
	public static final SystemMessageId S1_WAS_ADDED_TO_YOUR_IGNORE_LIST;
	
	/**
	 * ID: 618<br>
	 * Message: $s1ՒfXg폜܂B<br>
	 * Message: &#24478;&#38548;&#32085;&#21517;&#21934;&#20013;&#21034;&#38500;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 has been removed from your Ignore List.
	 */
	public static final SystemMessageId S1_WAS_REMOVED_FROM_YOUR_IGNORE_LIST;
	
	/**
	 * ID: 619<br>
	 * Message: $s1ȂՒf܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#38548;&#32085;&#20102;&#20320;&#12290;<br>
	 * Message: $s1 has placed you on his/her Ignore List.
	 */
	public static final SystemMessageId S1_HAS_ADDED_YOU_TO_IGNORE_LIST;
	
	/**
	 * ID: 620<br>
	 * Message: $s1͂ȂՒf܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#38548;&#32085;&#20102;&#20320;&#12290;<br>
	 * Message: $s1 has placed you on his/her Ignore List.
	 */
	public static final SystemMessageId S1_HAS_ADDED_YOU_TO_IGNORE_LIST2;
	
	/**
	 * ID: 621<br>
	 * Message: ڑꂽIPʂăQ[ɐڑ݂܂B<br>
	 * Message: &#21033;&#29992;&#34987;&#38480;&#21046;&#36938;&#25138;&#30340;&#24115;&#34399;&#35430;&#22294;&#36899;&#32218;&#12290;<br>
	 * Message: Game connection attempted through a restricted IP.
	 */
	public static final SystemMessageId CONNECTION_RESTRICTED_IP;
	
	/**
	 * ID: 622<br>
	 * Message: 풆ɐz͂ł܂B<br>
	 * Message: &#22312;&#21516;&#30431;&#25136;&#36942;&#31243;&#20013;&#28961;&#27861;&#36914;&#34892;&#23459;&#25136;&#12290;<br>
	 * Message: You may not make a declaration of war during an alliance battle.
	 */
	public static final SystemMessageId NO_WAR_DURING_ALLY_BATTLE;
	
	/**
	 * ID: 623<br>
	 * Message: ̓isł铯̐𒴂Ă܂B<br>
	 * Message: &#30446;&#27161;&#34880;&#30431;&#30340;&#34880;&#30431;&#25136;&#25973;&#23565;&#34880;&#30431;&#25976;&#24050;&#36948;&#19978;&#38480;&#12290;<br>
	 * Message: Your opponent has exceeded the number of simultaneous alliance battles alllowed.
	 */
	public static final SystemMessageId OPPONENT_TOO_MUCH_ALLY_BATTLES1;
	
	/**
	 * ID: 624<br>
	 * Message: $s1̓傪ڑĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#21516;&#30431;&#20027;&#19981;&#22312;&#36899;&#32218;&#19978;&#12290;<br>
	 * Message: $s1 Clan leader is not currently connected to the game server.
	 */
	public static final SystemMessageId S1_LEADER_NOT_CONNECTED;
	
	/**
	 * ID: 625<br>
	 * Message: ̏Ivۂ܂B<br>
	 * Message: &#21516;&#30431;&#25136;&#20572;&#25136;&#35531;&#27714;&#34987;&#25298;&#32085;&#20102;&#12290;<br>
	 * Message: Your request for Alliance Battle truce has been denied.
	 */
	public static final SystemMessageId ALLY_BATTLE_TRUCE_DENIED;
	
	/**
	 * ID: 626<br>
	 * Message: $s1Ȃ߁Azۂ܂B<br>
	 * Message: &#22240;&#27794;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#31572;&#35206;&#65292;&#25152;&#20197;&#23459;&#25136;&#35531;&#27714;&#34987;&#25298;&#32085;&#20102;&#12290;<br>
	 * Message: The $s1 clan did not respond: war proclamation has been refused.
	 */
	public static final SystemMessageId WAR_PROCLAMATION_HAS_BEEN_REFUSED;
	
	/**
	 * ID: 627<br>
	 * Message: $s1̐zɉȂ߁A킪ۂ܂B<br>
	 * Message: &#22240;&#27794;&#26377;&#23565;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#23459;&#25136;&#35531;&#27714;&#32102;&#33287;&#31572;&#35206;&#65292;&#21516;&#30431;&#25136;&#34987;&#25298;&#32085;&#20102;&#12290;<br>
	 * Message: Clan battle has been refused because you did not respond to $s1 clan's war proclamation.
	 */
	public static final SystemMessageId YOU_REFUSED_CLAN_WAR_PROCLAMATION;
	
	/**
	 * ID: 628<br>
	 * Message: $s1 Ƃ͂łɓs߁AO̓킩5o߂ȂƐzł܂B<br>
	 * Message: &#24050;&#32147;&#21644;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#36914;&#34892;&#36942;&#25136;&#29229;&#65292;&#21482;&#33021;&#22312;&#19978;&#27425;&#21516;&#30431;&#25136;&#38283;&#22987;&#53;&#22825;&#20197;&#24460;&#25165;&#21487;&#20197;&#20877;&#27425;&#23459;&#25136;&#12290;<br>
	 * Message: You have already been at war with the $s1 clan: 5 days must pass before you can declare war again.
	 */
	public static final SystemMessageId ALREADY_AT_WAR_WITH_S1_WAIT_5_DAYS;
	
	/**
	 * ID: 629<br>
	 * Message: ̌isł錌̐𒴂Ă܂B<br>
	 * Message: &#30456;&#23565;&#34880;&#30431;&#21487;&#20197;&#36914;&#34892;&#30340;&#34880;&#30431;&#25136;&#30340;&#25976;&#37327;&#24050;&#32147;&#28415;&#20102;&#12290;<br>
	 * Message: Your opponent has exceeded the number of simultaneous alliance battles alllowed.
	 */
	public static final SystemMessageId OPPONENT_TOO_MUCH_ALLY_BATTLES2;
	
	/**
	 * ID: 630<br>
	 * Message: $s1Ƃ̓킪n܂܂B<br>
	 * Message: &#21644;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#25136;&#29229;&#24050;&#32147;&#38283;&#22987;&#20102;&#12290;<br>
	 * Message: War with the clan has begun.
	 */
	public static final SystemMessageId WAR_WITH_CLAN_BEGUN;
	
	/**
	 * ID: 631<br>
	 * Message: $s1Ƃ̓킪I܂B<br>
	 * Message: &#21644;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#25136;&#29229;&#24050;&#32147;&#32080;&#26463;&#20102;&#12290;<br>
	 * Message: War with the clan is over.
	 */
	public static final SystemMessageId WAR_WITH_CLAN_ENDED;
	
	/**
	 * ID: 632<br>
	 * Message: $s1Ƃ̓ŏ܂I<br>
	 * Message: &#21644;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#25136;&#29229;&#20013;&#21213;&#21033;&#20102;&#12290;<br>
	 * Message: You have won the war over the clan!
	 */
	public static final SystemMessageId WON_WAR_OVER_CLAN;
	
	/**
	 * ID: 633<br>
	 * Message: $s1ɍ~܂B<br>
	 * Message: &#21521;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#25237;&#38477;&#20102;&#12290;<br>
	 * Message: You have surrendered to the clan.
	 */
	public static final SystemMessageId SURRENDERED_TO_CLAN;
	
	/**
	 * ID: 634<br>
	 * Message: 傪SāA$s1ɔsk܂B<br>
	 * Message: &#21516;&#30431;&#20027;&#27515;&#20102;&#12290;&#34987;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#25802;&#25943;&#20102;&#12290;<br>
	 * Message: Your alliance leader has been slain. You have been defeated by the clan.
	 */
	public static final SystemMessageId DEFEATED_BY_CLAN;
	
	/**
	 * ID: 635<br>
	 * Message: ̐Ԃ߂߁A$s1Ƃ̓킪I܂B<br>
	 * Message: &#36229;&#36942;&#20102;&#21516;&#30431;&#25136;&#38480;&#21046;&#30340;&#26178;&#38291;&#12290;&#21644;&#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#25136;&#29229;&#24050;&#32147;&#32080;&#26463;&#20102;&#12290;<br>
	 * Message: The time limit for the clan war has been exceeded. War with the clan is over.
	 */
	public static final SystemMessageId TIME_UP_WAR_OVER;
	
	/**
	 * ID: 636<br>
	 * Message: 풆ł͂܂B<br>
	 * Message: &#38750;&#21516;&#30431;&#25136;&#20013;&#12290;<br>
	 * Message: You are not involved in a clan war.
	 */
	public static final SystemMessageId NOT_INVOLVED_IN_WAR;
	
	/**
	 * ID: 637<br>
	 * Message: ̌Gɓo^܂B<br>
	 * Message: &#25152;&#23660;&#21516;&#30431;&#30340;&#34880;&#30431;&#21152;&#20837;&#20102;&#25973;&#26041;&#12290;<br>
	 * Message: A clan ally has registered itself to the opponent.
	 */
	public static final SystemMessageId ALLY_REGISTERED_SELF_TO_OPPONENT;
	
	/**
	 * ID: 638<br>
	 * Message: łɍU\ԂłB<br>
	 * Message: &#30003;&#35531;&#20102;&#25915;&#22478;&#25136;&#30340;&#29376;&#24907;&#20013;&#12290;<br>
	 * Message: You have already requested a Siege Battle.
	 */
	public static final SystemMessageId ALREADY_REQUESTED_SIEGE_BATTLE;
	
	/**
	 * ID: 639<br>
	 * Message: ̍Uɐ\ԂȂ̂Ő\ł܂B<br>
	 * Message: &#24050;&#32147;&#30003;&#35531;&#20102;&#21478;&#22806;&#30340;&#25915;&#22478;&#25136;&#65292;&#25152;&#20197;&#19981;&#33021;&#20877;&#30003;&#35531;&#12290;<br>
	 * Message: Your application has been denied because you have already submitted a request for another Siege Battle.
	 */
	public static final SystemMessageId APPLICATION_DENIED_BECAUSE_ALREADY_SUBMITTED_A_REQUEST_FOR_ANOTHER_SIEGE_BATTLE;
	
	/**
	 * ID: 640<br>
	 * Message: ̋ۂɎs܂B<br>
	 * Message: &#23432;&#22478;&#25298;&#32085;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to refuse castle defense aid.
	 */
	public static final SystemMessageId FAILED_TO_REFUSE_CASTLE_DEFENSE_AID;
	
	/**
	 * ID: 641<br>
	 * Message: ̏FɎs܂B<br>
	 * Message: &#23432;&#22478;&#30906;&#35469;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to approve castle defense aid.
	 */
	public static final SystemMessageId FAILED_TO_APPROVE_CASTLE_DEFENSE_AID;
	
	/**
	 * ID: 642<br>
	 * Message: łɍUɓo^Ă邽ߐ\ł܂BU̓o^LZĂx蒼ĂB<br>
	 * Message: &#24050;&#32147;&#30331;&#35352;&#22312;&#25915;&#22478;&#26041;&#65292;&#38920;&#21462;&#28040;&#30331;&#35352;&#24460;&#25165;&#21487;&#20197;&#20877;&#27425;&#30003;&#35531;&#12290;<br>
	 * Message: You are already registered to the attacker side and must cancel your registration before submitting your request.
	 */
	public static final SystemMessageId ALREADY_ATTACKER_NOT_CANCEL;
	
	/**
	 * ID: 643<br>
	 * Message: łɎɓo^Ă邽ߐ\ł܂B̓o^LZĂx蒼ĂB<br>
	 * Message: &#24050;&#32147;&#30331;&#35352;&#22312;&#23432;&#22478;&#26041;&#65292;&#38920;&#21462;&#28040;&#24050;&#26377;&#30340;&#30003;&#35531;&#24460;&#25165;&#21487;&#20197;&#20877;&#27425;&#30331;&#35352;&#12290;<br>
	 * Message: You have already registered to the defender side and must cancel your registration before submitting your request.
	 */
	public static final SystemMessageId ALREADY_DEFENDER_NOT_CANCEL;
	
	/**
	 * ID: 644<br>
	 * Message: ܂Uɓo^Ă܂B<br>
	 * Message: &#36996;&#27794;&#26377;&#30331;&#35352;&#21040;&#25915;&#22478;&#25136;&#12290;<br>
	 * Message: You are not yet registered for the castle siege.
	 */
	public static final SystemMessageId NOT_REGISTERED_FOR_SIEGE;
	
	/**
	 * ID: 645<br>
	 * Message: x5ȏ݂̌̂Uɓo^ł܂B<br>
	 * Message: &#31561;&#32026;&#53;&#20197;&#19978;&#30340;&#34880;&#30431;&#25165;&#21487;&#20197;&#30331;&#35352;&#25915;&#22478;&#25136;&#12290;<br>
	 * Message: Only clans of level 5 or higher may register for a castle siege.
	 */
	public static final SystemMessageId ONLY_CLAN_LEVEL_5_ABOVE_MAY_SIEGE;
	
	/**
	 * ID: 646<br>
	 * Message: ̃XgύX錠܂B<br>
	 * Message: &#27794;&#26377;&#25913;&#35722;&#23432;&#22478;&#26041;&#30446;&#37636;&#30340;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have the authority to modify the castle defender list.
	 */
	public static final SystemMessageId DO_NOT_HAVE_AUTHORITY_TO_MODIFY_CASTLE_DEFENDER_LIST;
	
	/**
	 * ID: 647<br>
	 * Message: U鎞ݒ肷錠܂B<br>
	 * Message: &#27794;&#26377;&#35373;&#23450;&#25915;&#22478;&#26178;&#38291;&#30340;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have the authority to modify the siege time.
	 */
	public static final SystemMessageId DO_NOT_HAVE_AUTHORITY_TO_MODIFY_SIEGE_TIME;
	
	/**
	 * ID: 648<br>
	 * Message: ȏUɓo^ł܂B<br>
	 * Message: &#24050;&#28961;&#27861;&#20877;&#30331;&#35352;&#25915;&#22478;&#26041;&#12290;<br>
	 * Message: No more registrations may be accepted for the attacker side.
	 */
	public static final SystemMessageId ATTACKER_SIDE_FULL;
	
	/**
	 * ID: 649<br>
	 * Message: ȏɐ\ł܂B<br>
	 * Message: &#24050;&#28961;&#27861;&#20877;&#30331;&#35352;&#23432;&#22478;&#26041;&#12290;<br>
	 * Message: No more registrations may be accepted for the defender side.
	 */
	public static final SystemMessageId DEFENDER_SIDE_FULL;
	
	/**
	 * ID: 650<br>
	 * Message: ݒnł͏ł܂B<br>
	 * Message: &#28961;&#27861;&#22312;&#29694;&#22312;&#30340;&#20301;&#32622;&#21484;&#21914;&#12290;<br>
	 * Message: You may not summon from your current location.
	 */
	public static final SystemMessageId YOU_MAY_NOT_SUMMON_FROM_YOUR_CURRENT_LOCATION;
	
	/**
	 * ID: 651<br>
	 * Message: $s1ݗĂʒuƕɔzu܂B낵łB<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#49;&#12301;&#37197;&#32622;&#22312;&#30446;&#21069;&#30340;&#20301;&#32622;&#21644;&#26041;&#21521;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: Place in the current location and direction. Do you wish to continue?
	 */
	public static final SystemMessageId PLACE_CURRENT_LOCATION_DIRECTION;
	
	/**
	 * ID: 652<br>
	 * Message: b̃^[Qbg܂B<br>
	 * Message: &#20351;&#39764;&#30340;&#30446;&#27161;&#37679;&#35492;&#12290;<br>
	 * Message: The target of the summoned monster is wrong.
	 */
	public static final SystemMessageId TARGET_OF_SUMMON_WRONG;
	
	/**
	 * ID: 653<br>
	 * Message: bzu錠܂B<br>
	 * Message: &#28961;&#27402;&#37197;&#32622;&#20653;&#20853;&#12290;<br>
	 * Message: You do not have the authority to position mercenaries.
	 */
	public static final SystemMessageId YOU_DO_NOT_HAVE_AUTHORITY_TO_POSITION_MERCENARIES;
	
	/**
	 * ID: 654<br>
	 * Message: bzuLZ錠܂B<br>
	 * Message: &#28961;&#27402;&#21462;&#28040;&#37197;&#32622;&#20653;&#20853;&#12290;<br>
	 * Message: You do not have the authority to cancel mercenary positioning.
	 */
	public static final SystemMessageId YOU_DO_NOT_HAVE_AUTHORITY_TO_CANCEL_MERCENARY_POSITIONING;
	
	/**
	 * ID: 655<br>
	 * Message: bĂł͂Ȃ߁Azuł܂B<br>
	 * Message: &#19981;&#26159;&#20653;&#20853;&#25152;&#23660;&#30340;&#22478;&#22561;&#38936;&#22495;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#37197;&#32622;&#12290;<br>
	 * Message: Mercenaries cannot be positioned here.
	 */
	public static final SystemMessageId MERCENARIES_CANNOT_BE_POSITIONED_HERE;
	
	/**
	 * ID: 656<br>
	 * Message: ̗b͔zuł܂B<br>
	 * Message: &#35442;&#20653;&#20853;&#28961;&#27861;&#20877;&#36914;&#34892;&#37197;&#32622;&#12290;<br>
	 * Message: This mercenary cannot be positioned anymore.
	 */
	public static final SystemMessageId THIS_MERCENARY_CANNOT_BE_POSITIONED_ANYMORE;
	
	/**
	 * ID: 657<br>
	 * Message: bm̊Ԋu߂邽߁Azuł܂B<br>
	 * Message: &#20653;&#20853;&#38291;&#30340;&#31354;&#38291;&#22826;&#31364;&#65292;&#25925;&#28961;&#27861;&#37197;&#32622;&#12290;<br>
	 * Message: Positioning cannot be done here because the distance between mercenaries is too short.
	 */
	public static final SystemMessageId POSITIONING_CANNOT_BE_DONE_BECAUSE_DISTANCE_BETWEEN_MERCENARIES_TOO_SHORT;
	
	/**
	 * ID: 658<br>
	 * Message: LĂ̗bł͂Ȃ߁AzuLZł܂B<br>
	 * Message: &#19981;&#26159;&#24744;&#25152;&#25793;&#26377;&#30340;&#22478;&#22561;&#20043;&#20653;&#20853;&#65292;&#25925;&#28961;&#27861;&#21462;&#28040;&#37197;&#32622;&#12290;<br>
	 * Message: This is not a mercenary of a castle that you own and so you cannot cancel its positioning.
	 */
	public static final SystemMessageId THIS_IS_NOT_A_MERCENARY_OF_A_CASTLE_THAT_YOU_OWN_AND_SO_CANNOT_CANCEL_POSITIONING;
	
	/**
	 * ID: 659<br>
	 * Message: U̓o^Ԃł͂Ȃ߁AFۂł܂B<br>
	 * Message: &#38750;&#25915;&#22478;&#30331;&#35352;&#26399;&#38291;&#65292;&#22240;&#27492;&#28961;&#27861;&#20801;&#35377;&#25110;&#25298;&#32085;&#12290;<br>
	 * Message: This is not the time for siege registration and so registrations cannot be accepted or rejected.
	 */
	public static final SystemMessageId NOT_SIEGE_REGISTRATION_TIME1;
	
	/**
	 * ID: 660<br>
	 * Message: U̓o^Ԃł͂Ȃ߁Ao^LZł܂B<br>
	 * Message: &#38750;&#25915;&#22478;&#30331;&#35352;&#26399;&#38291;&#65292;&#22240;&#27492;&#28961;&#27861;&#30331;&#35352;&#25110;&#21462;&#28040;&#12290;<br>
	 * Message: This is not the time for siege registration and so registration and cancellation cannot be done.
	 */
	public static final SystemMessageId NOT_SIEGE_REGISTRATION_TIME2;
	
	/**
	 * ID: 661<br>
	 * Message: X|CłȂLN^[łB<br>
	 * Message: &#35442;&#35282;&#33394;&#19981;&#21487;&#34987;&#25613;&#22750;&#12290;<br>
	 * Message: This character cannot be spoiled.
	 */
	public static final SystemMessageId SPOIL_CANNOT_USE;
	
	/**
	 * ID: 662<br>
	 * Message: 肪FB̏҂ۂĂԂłB<br>
	 * Message: &#23565;&#26041;&#35373;&#23450;&#28858;&#25298;&#32085;&#36992;&#35531;&#26379;&#21451;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: The other player is rejecting friend invitations.
	 */
	public static final SystemMessageId THE_PLAYER_IS_REJECTING_FRIEND_INVITATIONS;
	
	/**
	 * ID: 663<br>
	 * Message: U鎞$s1łBz̕ύX͂ł܂B낵łB<br>
	 * Message: &#23459;&#20296;&#25915;&#22478;&#26178;&#38291;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#12290;&#23459;&#20296;&#24460;&#28961;&#27861;&#20877;&#27425;&#35722;&#26356;&#65292;&#35531;&#30906;&#35469;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: The siege time has been declared for $s. It is not possible to change the time after a siege time has been declared. Do you want to continue?
	 */
	public static final SystemMessageId SIEGE_TIME_DECLARED_FOR_S1;
	
	/**
	 * ID: 664<br>
	 * Message: lIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#25910;&#20214;&#20154;&#12290;<br>
	 * Message: Please choose a person to receive.
	 */
	public static final SystemMessageId CHOOSE_PERSON_TO_RECEIVE;
	
	/**
	 * ID: 665<br>
	 * Message: $s1$s2ɓ\܂܂B󂯓܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#30003;&#35531;&#21516;&#30431;&#25136;&#12290;&#26159;&#21542;&#25509;&#21463;&#25361;&#25136;&#65311;<br>
	 * Message: of alliance is applying for alliance war. Do you want to accept the challenge?
	 */
	public static final SystemMessageId APPLYING_ALLIANCE_WAR;
	
	/**
	 * ID: 666<br>
	 * Message: $s1 ɏI\܂܂Bӂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21516;&#30431;&#25552;&#20986;&#20572;&#25136;&#35201;&#27714;&#12290;&#26159;&#21542;&#21516;&#24847;&#65311;<br>
	 * Message: A request for ceasefire has been received from alliance. Do you agree?
	 */
	public static final SystemMessageId REQUEST_FOR_CEASEFIRE;
	
	/**
	 * ID: 667<br>
	 * Message: $s1UɍUƂēo^܂B낵łB<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#25915;&#22478;&#25136;&#65292;&#23559;&#26371;&#30331;&#35352;&#28858;&#25915;&#22478;&#26041;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You are registering on the attacking side of the siege. Do you want to continue?
	 */
	public static final SystemMessageId REGISTERING_ON_ATTACKING_SIDE;
	
	/**
	 * ID: 668<br>
	 * Message: $s1UɎƂēo^܂B낵łB<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#25915;&#22478;&#25136;&#65292;&#23559;&#26371;&#30331;&#35352;&#28858;&#23432;&#22478;&#26041;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You are registering on the defending side of the siege. Do you want to continue?
	 */
	public static final SystemMessageId REGISTERING_ON_DEFENDING_SIDE;
	
	/**
	 * ID: 669<br>
	 * Message: $s1Uւ̎Q\LZ܂B낵łB<br>
	 * Message: &#21462;&#28040;&#21443;&#21152;&#12300;&#36;&#115;&#49;&#12301;&#25915;&#22478;&#25136;&#30340;&#30003;&#35531;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You are canceling your application to participate in the siege battle. Do you want to continue?
	 */
	public static final SystemMessageId CANCELING_REGISTRATION;
	
	/**
	 * ID: 670<br>
	 * Message: $s1̎o^ۂ܂B낵łB<br>
	 * Message: &#25298;&#32085;&#30331;&#35352;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#23432;&#22478;&#26041;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You are refusing the registration of clan on the defending side. Do you want to continue?
	 */
	public static final SystemMessageId REFUSING_REGISTRATION;
	
	/**
	 * ID: 671<br>
	 * Message: $s1̎o^F܂B낵łB<br>
	 * Message: &#20801;&#35377;&#30331;&#35352;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#23432;&#22478;&#26041;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You are agreeing to the registration of clan on the defending side. Do you want to continue?
	 */
	public static final SystemMessageId AGREEING_REGISTRATION;
	
	/**
	 * ID: 672<br>
	 * Message: $s1Afi܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#26522;&#37329;&#24163;&#28040;&#22833;&#20102;&#12290;<br>
	 * Message: $s1 adena disappeared.
	 */
	public static final SystemMessageId S1_DISAPPEARED_ADENA;
	
	/**
	 * ID: 673<br>
	 * Message: AWg̋ɂ͌x2ȏ̌̂ݎQł܂B<br>
	 * Message: &#20677;&#38480;&#34880;&#30431;&#31561;&#32026;&#50;&#20197;&#19978;&#30340;&#34880;&#30431;&#30431;&#20027;&#21443;&#21152;&#26681;&#25818;&#22320;&#25293;&#36067;&#12290;<br>
	 * Message: Only a clan leader whose clan is of level 2 or higher is allowed to participate in a clan hall auction.
	 */
	public static final SystemMessageId AUCTION_ONLY_CLAN_LEVEL_2_HIGHER;
	
	/**
	 * ID: 674<br>
	 * Message: LZĂ7߂Ă܂B<br>
	 * Message: &#21462;&#28040;&#25293;&#36067;&#26410;&#36942;&#55;&#22825;&#12290;<br>
	 * Message: I has not yet been seven days since canceling an auction.
	 */
	public static final SystemMessageId NOT_SEVEN_DAYS_SINCE_CANCELING_AUCTION;
	
	/**
	 * ID: 675<br>
	 * Message: ̃AWgł͂܂B<br>
	 * Message: &#38750;&#25293;&#36067;&#20013;&#30340;&#26681;&#25818;&#22320;&#12290;<br>
	 * Message: There are no clan halls up for auction.
	 */
	public static final SystemMessageId NO_CLAN_HALLS_UP_FOR_AUCTION;
	
	/**
	 * ID: 676<br>
	 * Message: ݋ɓD̂߁A̋ɂ͎Qł܂B<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#25237;&#27161;&#20013;&#65292;&#22240;&#27492;&#28961;&#27861;&#21443;&#21152;&#20854;&#20182;&#25293;&#36067;&#12290;<br>
	 * Message: Since you have already submitted a bid, you are not allowed to participate in another auction at this time.
	 */
	public static final SystemMessageId ALREADY_SUBMITTED_BID;
	
	/**
	 * ID: 677<br>
	 * Message: Di͍ŒD\i荂Ȃ΂Ȃ܂B<br>
	 * Message: &#25237;&#27161;&#20729;&#26684;&#38920;&#39640;&#26044;&#26368;&#20302;&#25237;&#27161;&#20729;&#26684;&#12290;<br>
	 * Message: Your bid price must be higher than the minimum price that can be bid.
	 */
	public static final SystemMessageId BID_PRICE_MUST_BE_HIGHER;
	
	/**
	 * ID: 678<br>
	 * Message: $s1̋ɓD܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25293;&#36067;&#25307;&#27161;&#20102;&#12290;<br>
	 * Message: You have submitted a bid for the auction of $s1.
	 */
	public static final SystemMessageId SUBMITTED_A_BID_OF_S1;
	
	/**
	 * ID: 679<br>
	 * Message: DLZ܂B<br>
	 * Message: &#21462;&#28040;&#25237;&#27161;&#12290;<br>
	 * Message: You have canceled your bid.
	 */
	public static final SystemMessageId CANCELED_BID;
	
	/**
	 * ID: 680<br>
	 * Message: ɎQł܂B<br>
	 * Message: &#19981;&#33021;&#21443;&#21152;&#25293;&#36067;&#12290;<br>
	 * Message: You cannot participate in an auction.
	 */
	public static final SystemMessageId CANNOT_PARTICIPATE_IN_AN_AUCTION;
	
	/**
	 * ID: 681<br>
	 * Message: AWgLĂ܂B<br>
	 * Message: &#34880;&#30431;&#23578;&#26410;&#25793;&#26377;&#26681;&#25818;&#22320;&#12290;<br>
	 * Message: The clan does not own a clan hall.
	 */
	public static final SystemMessageId CLAN_HAS_NO_CLAN_HALL;
	
	/**
	 * ID: 682<br>
	 * Message: w肵ꏊɈړ܂B<br>
	 * Message: &#31227;&#21205;&#21040;&#21029;&#30340;&#22478;&#37806;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You are moving to another village. Do you want to continue?
	 */
	public static final SystemMessageId MOVING_TO_ANOTHER_VILLAGE;
	
	/**
	 * ID: 683<br>
	 * Message: XEB[p[ɑ΂D挠܂B<br>
	 * Message: &#27794;&#26377;&#36914;&#34892;&#22238;&#25910;&#32773;&#30340;&#20778;&#20808;&#27402;&#12290;<br>
	 * Message: There are no priority rights on a sweeper.
	 */
	public static final SystemMessageId SWEEP_NOT_ALLOWED;
	
	/**
	 * ID: 684<br>
	 * Message: U钆ɂ͗bzuł܂B<br>
	 * Message: &#22312;&#25915;&#22478;&#20013;&#65292;&#28961;&#27861;&#37197;&#32622;&#20653;&#20853;&#12290;<br>
	 * Message: You cannot position mercenaries during a siege.
	 */
	public static final SystemMessageId CANNOT_POSITION_MERCS_DURING_SIEGE;
	
	/**
	 * ID: 685<br>
	 * Message: ɑ錌Ɍ\ނƂ͂ł܂B<br>
	 * Message: &#23565;&#23660;&#26044;&#21516;&#30431;&#30340;&#34880;&#30431;&#65292;&#28961;&#27861;&#30003;&#35531;&#34880;&#30431;&#25136;&#12290;<br>
	 * Message: You cannot apply for clan war with a clan that belongs to the same alliance
	 */
	public static final SystemMessageId CANNOT_DECLARE_WAR_ON_ALLY;
	
	/**
	 * ID: 686<br>
	 * Message: @̉΂ɂ$s1̃_[W󂯂܂B<br>
	 * Message: &#22240;&#39764;&#27861;&#20043;&#28779;&#65292;&#36973;&#21463;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You have received $s1 damage from the fire of magic.
	 */
	public static final SystemMessageId S1_DAMAGE_FROM_FIRE_MAGIC;
	
	/**
	 * ID: 687<br>
	 * Message: t[YԂł͍sł܂B΂炭҂B<br>
	 * Message: &#22312;&#26283;&#20572;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#34892;&#21205;&#12290;&#35531;&#31245;&#31561;&#12290;<br>
	 * Message: You cannot move while frozen. Please wait.
	 */
	public static final SystemMessageId CANNOT_MOVE_FROZEN;
	
	/**
	 * ID: 688<br>
	 * Message: LĂ錌́AIɎɓo^܂B<br>
	 * Message: &#25793;&#26377;&#22478;&#22561;&#30340;&#34880;&#30431;&#23559;&#33258;&#21205;&#30331;&#35352;&#28858;&#23432;&#22478;&#26041;&#12290;<br>
	 * Message: The clan that owns the castle is automatically registered on the defending side.
	 */
	public static final SystemMessageId CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING;
	
	/**
	 * ID: 689<br>
	 * Message: LĂ錌́A̍Uɂ͎Qł܂B<br>
	 * Message: &#25793;&#26377;&#22478;&#22561;&#30340;&#34880;&#30431;&#19981;&#33021;&#21443;&#21152;&#21029;&#30340;&#25915;&#22478;&#25136;&#12290;<br>
	 * Message: A clan that owns a castle cannot participate in another siege.
	 */
	public static final SystemMessageId CLAN_THAT_OWNS_CASTLE_CANNOT_PARTICIPATE_OTHER_SIEGE;
	
	/**
	 * ID: 690<br>
	 * Message: LĂ錌ƓɑĂ邽߁AUɓo^ł܂B<br>
	 * Message: &#24744;&#23660;&#26044;&#25793;&#26377;&#22478;&#22561;&#30340;&#34880;&#30431;&#20043;&#21516;&#30431;&#65292;&#22240;&#27492;&#28961;&#27861;&#30331;&#35352;&#28858;&#25915;&#22478;&#26041;&#12290;<br>
	 * Message: You cannot register on the attacking side because you are part of an alliance with the clan that owns the castle.
	 */
	public static final SystemMessageId CANNOT_ATTACK_ALLIANCE_CASTLE;
	
	/**
	 * ID: 691<br>
	 * Message: $s1́Ał$s2ɉĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#24050;&#32147;&#21152;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#21516;&#30431;&#12290;<br>
	 * Message: $s1 clan is already a member of $s2 alliance.
	 */
	public static final SystemMessageId S1_CLAN_ALREADY_MEMBER_OF_S2_ALLIANCE;
	
	/**
	 * ID: 692<br>
	 * Message: 肪t[YԂłB΂炭҂B<br>
	 * Message: &#23565;&#26041;&#38519;&#20837;&#26283;&#20572;&#29376;&#24907;&#12290;&#35531;&#31245;&#31561;&#12290;<br>
	 * Message: The other party is frozen. Please wait a moment.
	 */
	public static final SystemMessageId OTHER_PARTY_IS_FROZEN;
	
	/**
	 * ID: 693<br>
	 * Message: ̑qɂɂ܂B<br>
	 * Message: &#21040;&#36948;&#30340;&#21253;&#35065;&#22312;&#21029;&#30340;&#20489;&#24235;&#35023;&#12290;<br>
	 * Message: The package that arrived is in another warehouse.
	 */
	public static final SystemMessageId PACKAGE_IN_ANOTHER_WAREHOUSE;
	
	/**
	 * ID: 694<br>
	 * Message: ͂܂B<br>
	 * Message: &#27794;&#26377;&#21040;&#36948;&#30340;&#21253;&#35065;&#12290;<br>
	 * Message: No packages have arrived.
	 */
	public static final SystemMessageId NO_PACKAGES_ARRIVED;
	
	/**
	 * ID: 695<br>
	 * Message: ybg̖Oݒł܂B<br>
	 * Message: &#28961;&#27861;&#35373;&#23450;&#23541;&#29289;&#30340;&#21517;&#23383;&#12290;<br>
	 * Message: You cannot set the name of the pet.
	 */
	public static final SystemMessageId NAMING_YOU_CANNOT_SET_NAME_OF_THE_PET;
	
	/**
	 * ID: 697<br>
	 * Message: ACeG`glُłB<br>
	 * Message: &#36947;&#20855;&#24375;&#21270;&#25976;&#20540;&#30064;&#24120;&#12290;<br>
	 * Message: The item enchant value is strange
	 */
	public static final SystemMessageId ITEM_ENCHANT_VALUE_STRANGE;
	
	/**
	 * ID: 698<br>
	 * Message: ̔Xgɂ铯ACeƉiقȂ܂B<br>
	 * Message: &#33287;&#36009;&#36067;&#28165;&#21934;&#19978;&#30456;&#21516;&#36947;&#20855;&#30340;&#20729;&#26684;&#19981;&#21516;&#12290;<br>
	 * Message: The price is different than the same item on the sales list.
	 */
	public static final SystemMessageId PRICE_DIFFERENT_FROM_SALES_LIST;
	
	/**
	 * ID: 699<br>
	 * Message: ݍw܂B<br>
	 * Message: &#29694;&#22312;&#19981;&#36092;&#36023;&#12290;<br>
	 * Message: Currently not purchasing.
	 */
	public static final SystemMessageId CURRENTLY_NOT_PURCHASING;
	
	/**
	 * ID: 700<br>
	 * Message: w܂B<br>
	 * Message: &#36092;&#36023;&#23436;&#25104;&#12290;<br>
	 * Message: The purchase is complete.
	 */
	public static final SystemMessageId THE_PURCHASE_IS_COMPLETE;
	
	/**
	 * ID: 701<br>
	 * Message: KvACe܂B<br>
	 * Message: &#25152;&#38656;&#36947;&#20855;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough required items.
	 */
	public static final SystemMessageId NOT_ENOUGH_REQUIRED_ITEMS;
	
	/**
	 * ID: 702<br>
	 * Message: ݑΉFSESPTET[rX`[܂B<br>
	 * Message: &#30446;&#21069;&#27794;&#26377;&#27965;&#35527;&#20013;&#30340;&#71;&#77;&#12290;<br>
	 * Message: There are no GMs currently visible in the public list as they may be performing other functions at the moment.
	 */
	public static final SystemMessageId NO_GM_PROVIDING_SERVICE_NOW;
	
	/**
	 * ID: 703<br>
	 * Message: ======<FSXg>======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#60;&#71;&#77;&#21517;&#21934;&#62;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ======<GM List>======
	 */
	public static final SystemMessageId GM_LIST;
	
	/**
	 * ID: 704<br>
	 * Message: supportF$c1<br>
	 * Message: &#71;&#77;&#65306;&#12300;&#36;&#99;&#49;&#12301;<br>
	 * Message: GM : $c1
	 */
	public static final SystemMessageId GM_C1;
	
	/**
	 * ID: 705<br>
	 * Message: gՒf邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#38548;&#32085;&#33258;&#24049;&#12290;<br>
	 * Message: You cannot exclude yourself.
	 */
	public static final SystemMessageId CANNOT_EXCLUDE_SELF;
	
	/**
	 * ID: 706<br>
	 * Message: ՒfXgɂ͍ő128l܂œo^ł܂B<br>
	 * Message: &#38548;&#32085;&#21517;&#21934;&#19978;&#21482;&#33021;&#30331;&#35352;&#49;&#50;&#56;&#21517;&#12290;<br>
	 * Message: You can only register up to 64 names on your exclude list.
	 */
	public static final SystemMessageId ONLY_64_NAMES_ON_EXCLUDE_LIST;
	
	/**
	 * ID: 707<br>
	 * Message: U풆̑ւ̓e|[gł܂B<br>
	 * Message: &#28961;&#27861;&#20659;&#36865;&#21040;&#25915;&#22478;&#20013;&#30340;&#26449;&#33674;&#12290;<br>
	 * Message: You cannot teleport to a village that is in a siege.
	 */
	public static final SystemMessageId NO_PORT_THAT_IS_IN_SIGE;
	
	/**
	 * ID: 708<br>
	 * Message: ̑qɂ𗘗p錠܂B<br>
	 * Message: &#28961;&#27402;&#21033;&#29992;&#22478;&#22561;&#20489;&#24235;&#12290;<br>
	 * Message: You do not have the right to use the castle warehouse.
	 */
	public static final SystemMessageId YOU_DO_NOT_HAVE_THE_RIGHT_TO_USE_CASTLE_WAREHOUSE;
	
	/**
	 * ID: 709<br>
	 * Message: qɂ𗘗p錠܂B<br>
	 * Message: &#28961;&#27402;&#21033;&#29992;&#34880;&#30431;&#20489;&#24235;&#12290;<br>
	 * Message: You do not have the right to use the clan warehouse.
	 */
	public static final SystemMessageId YOU_DO_NOT_HAVE_THE_RIGHT_TO_USE_CLAN_WAREHOUSE;
	
	/**
	 * ID: 710<br>
	 * Message: qɂ𗘗pł̂́Ax1ȏ݂̌̂łB<br>
	 * Message: &#21482;&#26377;&#34880;&#30431;&#49;&#31561;&#32026;&#20197;&#19978;&#30340;&#34880;&#30431;&#65292;&#25165;&#33021;&#21033;&#29992;&#34880;&#30431;&#20489;&#24235;&#12290;<br>
	 * Message: Only clans of clan level 1 or higher can use a clan warehouse.
	 */
	public static final SystemMessageId ONLY_LEVEL_1_CLAN_OR_HIGHER_CAN_USE_WAREHOUSE;
	
	/**
	 * ID: 711<br>
	 * Message: $s1̍U킪n܂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25915;&#22478;&#25136;&#38283;&#22987;&#20102;&#12290;<br>
	 * Message: The siege of $s1 has started.
	 */
	public static final SystemMessageId SIEGE_OF_S1_HAS_STARTED;
	
	/**
	 * ID: 712<br>
	 * Message: $s1̍U킪I܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25915;&#22478;&#25136;&#32080;&#26463;&#20102;&#12290;<br>
	 * Message: The siege of $s1 has finished.
	 */
	public static final SystemMessageId SIEGE_OF_S1_HAS_ENDED;
	
	/**
	 * ID: 713<br>
	 * Message: $s1/$s2/$s3 $s4:$s5<br>
	 * Message: &#36;&#115;&#49;&#47;&#36;&#115;&#50;&#47;&#36;&#115;&#51;&#32;&#36;&#115;&#52;&#58;&#36;&#115;&#53;<br>
	 * Message: $s1/$s2/$s3 :
	 */
	public static final SystemMessageId S1_S2_S3_D;
	
	/**
	 * ID: 714<br>
	 * Message: gbvu쓮܂B<br>
	 * Message: &#38519;&#38449;&#35037;&#32622;&#21855;&#21205;&#12290;<br>
	 * Message: A trap device has been tripped.
	 */
	public static final SystemMessageId A_TRAP_DEVICE_HAS_BEEN_TRIPPED;
	
	/**
	 * ID: 715<br>
	 * Message: gbvu̍쓮f܂B<br>
	 * Message: &#20013;&#27490;&#21855;&#21205;&#38519;&#38449;&#35037;&#32622;&#12290;<br>
	 * Message: A trap device has been stopped.
	 */
	public static final SystemMessageId A_TRAP_DEVICE_HAS_BEEN_STOPPED;
	
	/**
	 * ID: 716<br>
	 * Message: wnȂƕł܂B<br>
	 * Message: &#27794;&#26377;&#38499;&#22320;&#26178;&#65292;&#28961;&#27861;&#24489;&#27963;&#12290;<br>
	 * Message: If a base camp does not exist, resurrection is not possible.
	 */
	public static final SystemMessageId NO_RESURRECTION_WITHOUT_BASE_CAMP;
	
	/**
	 * ID: 717<br>
	 * Message: K[fBA^[j󂳂As\łB<br>
	 * Message: &#23432;&#35703;&#22612;&#34987;&#30772;&#22750;&#65292;&#28961;&#27861;&#24489;&#21407;&#12290;<br>
	 * Message: The guardian tower has been destroyed and resurrection is not possible
	 */
	public static final SystemMessageId TOWER_DESTROYED_NO_RESURRECTION;
	
	/**
	 * ID: 718<br>
	 * Message: U풆͏Jł܂B<br>
	 * Message: &#22312;&#25915;&#22478;&#20013;&#65292;&#28961;&#27861;&#38283;&#38364;&#22478;&#38272;&#12290;<br>
	 * Message: The castle gates cannot be opened and closed during a siege.
	 */
	public static final SystemMessageId GATES_NOT_OPENED_CLOSED_DURING_SIEGE;
	
	/**
	 * ID: 719<br>
	 * Message: ACe̒Ɏs܂B<br>
	 * Message: &#36947;&#20855;&#32068;&#21512;&#22833;&#25943;&#12290;<br>
	 * Message: You failed at mixing the item.
	 */
	public static final SystemMessageId ITEM_MIXING_FAILED;
	
	/**
	 * ID: 720<br>
	 * Message: wz傫߁AlXJƂł܂B<br>
	 * Message: &#36092;&#36023;&#38989;&#22823;&#26044;&#25152;&#24118;&#30340;&#37329;&#38989;&#65292;&#28961;&#27861;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#12290;<br>
	 * Message: The purchase price is higher than the amount of money that you have and so you cannot open a personal store.
	 */
	public static final SystemMessageId THE_PURCHASE_PRICE_IS_HIGHER_THAN_MONEY;
	
	/**
	 * ID: 721<br>
	 * Message: UɎQ킵ĂԂł́A邱Ƃł܂B<br>
	 * Message: &#22312;&#21443;&#21152;&#25915;&#22478;&#25136;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#32080;&#25104;&#21516;&#30431;&#12290;<br>
	 * Message: You cannot create an alliance while participating in a siege.
	 */
	public static final SystemMessageId NO_ALLY_CREATION_WHILE_SIEGE;
	
	/**
	 * ID: 722<br>
	 * Message: ̌UɎQ킵ĂԂ̂߁AUł܂B<br>
	 * Message: &#25152;&#23660;&#34880;&#30431;&#24050;&#22312;&#21443;&#21152;&#25915;&#22478;&#25136;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#35299;&#25955;&#21516;&#30431;&#12290;<br>
	 * Message: You cannot dissolve an alliance while an affiliated clan is participating in a siege battle.
	 */
	public static final SystemMessageId CANNOT_DISSOLVE_ALLY_WHILE_IN_SIEGE;
	
	/**
	 * ID: 723<br>
	 * Message: ̌́AUɎQ풆łB<br>
	 * Message: &#23565;&#26041;&#34880;&#30431;&#27491;&#22312;&#21443;&#21152;&#25915;&#22478;&#25136;&#12290;<br>
	 * Message: The opposing clan is participating in a siege battle.
	 */
	public static final SystemMessageId OPPOSING_CLAN_IS_PARTICIPATING_IN_SIEGE;
	
	/**
	 * ID: 724<br>
	 * Message: UɎQ킵ĂԂł́AEނł܂B<br>
	 * Message: &#22312;&#21443;&#21152;&#25915;&#22478;&#25136;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#33067;&#38626;&#12290;<br>
	 * Message: You cannot leave while participating in a siege battle.
	 */
	public static final SystemMessageId CANNOT_LEAVE_WHILE_SIEGE;
	
	/**
	 * ID: 725<br>
	 * Message: UɎQ풆̌𓯖Ǖł܂B<br>
	 * Message: &#28961;&#27861;&#23559;&#21443;&#21152;&#25915;&#22478;&#25136;&#20013;&#30340;&#34880;&#30431;&#24478;&#21516;&#30431;&#39493;&#36880;&#12290;<br>
	 * Message: You cannot banish a clan from an alliance while the clan is participating in a siege
	 */
	public static final SystemMessageId CANNOT_DISMISS_WHILE_SIEGE;
	
	/**
	 * ID: 726<br>
	 * Message: t[YԂn܂܂B΂炭҂B<br>
	 * Message: &#26283;&#20572;&#29376;&#24907;&#38283;&#22987;&#12290;&#35531;&#31245;&#31561;&#12290;<br>
	 * Message: Frozen condition has started. Please wait a moment.
	 */
	public static final SystemMessageId FROZEN_CONDITION_STARTED;
	
	/**
	 * ID: 727<br>
	 * Message: t[YԂ܂B<br>
	 * Message: &#26283;&#20572;&#29376;&#24907;&#35299;&#38500;&#12290;<br>
	 * Message: The frozen condition was removed.
	 */
	public static final SystemMessageId FROZEN_CONDITION_REMOVED;
	
	/**
	 * ID: 728<br>
	 * Message: U̐\7ȓ́AĂщU\ނƂł܂B<br>
	 * Message: &#30003;&#35531;&#35299;&#25955;&#24460;&#55;&#26085;&#20043;&#20839;&#28961;&#27861;&#20877;&#30003;&#35531;&#35299;&#25955;&#12290;<br>
	 * Message: You cannot apply for dissolution again within seven days after a previous application for dissolution.
	 */
	public static final SystemMessageId CANNOT_APPLY_DISSOLUTION_AGAIN;
	
	/**
	 * ID: 729<br>
	 * Message: YACêĂ邱Ƃ͂ł܂B<br>
	 * Message: &#35442;&#36947;&#20855;&#28961;&#27861;&#19999;&#26820;&#12290;<br>
	 * Message: That item cannot be discarded.
	 */
	public static final SystemMessageId ITEM_NOT_DISCARDED;
	
	/**
	 * ID: 730<br>
	 * Message: - $c1Ԗڂ̃T|[g󂯕t܂B\n - ̃T|[g񐔂͂$s2łB\n - [h̏󋵂ɂĂ͕ԐMɂԂĂ܂ꍇ܂B\߂܂B<br>
	 * Message: &#45;&#32;&#24050;&#25552;&#20986;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#27425;&#35380;&#27714;&#12290;&#92;&#110;&#32;&#45;&#32;&#20170;&#22825;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#27425;&#35380;&#27714;&#30340;&#27231;&#26371;&#12290;<br>
	 * Message: You have submitted $s1 petition(s). - You may submit $s2 more petition(s) today.
	 */
	public static final SystemMessageId SUBMITTED_YOU_S1_TH_PETITION_S2_LEFT;
	
	/**
	 * ID: 731<br>
	 * Message: $c1 ɃT|[g̑Ήv܂Btԍ$s2łB<br>
	 * Message: &#24050;&#21521;&#12300;&#36;&#99;&#49;&#12301;&#25552;&#20986;&#71;&#77;&#30340;&#20195;&#29702;&#35380;&#27714;&#12290;&#35380;&#27714;&#34399;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: A petition has been received by the GM on behalf of $s1. The petition code is $s2.
	 */
	public static final SystemMessageId PETITION_S1_RECEIVED_CODE_IS_S2;
	
	/**
	 * ID: 732<br>
	 * Message: $c1 ɃT|[ĝA܂B<br>
	 * Message: &#24050;&#21521;&#12300;&#36;&#99;&#49;&#12301;&#25552;&#20986;&#71;&#77;&#30340;&#20132;&#35527;&#35201;&#27714;&#12290;<br>
	 * Message: $c1 has received a request for a consultation with the GM.
	 */
	public static final SystemMessageId C1_RECEIVED_CONSULTATION_REQUEST;
	
	/**
	 * ID: 733<br>
	 * Message: ɐ\\$s1̃T|[gׂĎ󂯕t܂BȏT|[g\ނƂ͂ł܂B<br>
	 * Message: &#19968;&#22825;&#25152;&#33021;&#25509;&#21463;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#27425;&#35380;&#27714;&#24050;&#21463;&#29702;&#23436;&#30050;&#65292;&#25925;&#28961;&#27861;&#20877;&#27425;&#30003;&#35531;&#35380;&#27714;&#12290;<br>
	 * Message: We have received $s1 petitions from you today and that is the maximum that you can submit in one day. You cannot submit any more petitions.
	 */
	public static final SystemMessageId WE_HAVE_RECEIVED_S1_PETITIONS_TODAY;
	
	/**
	 * ID: 734<br>
	 * Message: T|[g̑㗝tɎs܂B$c1 łɃT|[g󂯕tԂłB<br>
	 * Message: &#20195;&#29702;&#35380;&#27714;&#22833;&#25943;&#12290;&#12300;&#36;&#99;&#49;&#12301;&#24050;&#25552;&#20986;&#35380;&#27714;&#12290;<br>
	 * Message: You have failed at submitting a petition on behalf of someone else. $c1 already submitted a petition.
	 */
	public static final SystemMessageId PETITION_FAILED_C1_ALREADY_SUBMITTED;
	
	/**
	 * ID: 735<br>
	 * Message: $c1 ɑ΂T|[g̑㗝tɎs܂BG[ԍ$s2łB<br>
	 * Message: &#26377;&#38364;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#20195;&#29702;&#35380;&#27714;&#25552;&#20132;&#22833;&#25943;&#12290;&#37679;&#35492;&#20195;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have failed at submitting a petition on behalf of $c1. The error number is $s2.
	 */
	public static final SystemMessageId PETITION_FAILED_FOR_C1_ERROR_NUMBER_S2;
	
	/**
	 * ID: 736<br>
	 * Message: T|[gvLZ܂B󂯕t\ȃT|[g͂$s1łB<br>
	 * Message: &#23565;&#26044;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20195;&#29702;&#35380;&#27714;&#25509;&#21463;&#22833;&#25943;&#12290;&#37679;&#35492;&#20195;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: The petition was canceled. You may submit $s1 more petition(s) today.
	 */
	public static final SystemMessageId PETITION_CANCELED_SUBMIT_S1_MORE_TODAY;
	
	/**
	 * ID: 737<br>
	 * Message: $c1 ɑ΂T|[g̑㗝tLZ܂B<br>
	 * Message: &#24050;&#21462;&#28040;&#26377;&#38364;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#20195;&#29702;&#35380;&#27714;&#12290;<br>
	 * Message: You have cancelled submitting a petition on behalf of $s1.
	 */
	public static final SystemMessageId CANCELED_PETITION_ON_S1;
	
	/**
	 * ID: 738<br>
	 * Message: ݂̓T|[gv󂯕tĂ܂B<br>
	 * Message: &#30446;&#21069;&#19981;&#25509;&#21463;&#35380;&#27714;&#12290;<br>
	 * Message: You have not submitted a petition.
	 */
	public static final SystemMessageId PETITION_NOT_SUBMITTED;
	
	/**
	 * ID: 739<br>
	 * Message: $c1 ɑ΂T|[g̑㗝t̃LZɎs܂BG[R[h$s2łB<br>
	 * Message: &#26377;&#38364;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#20195;&#29702;&#35380;&#27714;&#21462;&#28040;&#22833;&#25943;&#12290;&#37679;&#35492;&#20195;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have failed at cancelling a petition on behalf of $c1. The error number is $s2.
	 */
	public static final SystemMessageId PETITION_CANCEL_FAILED_FOR_C1_ERROR_NUMBER_S2;
	
	/**
	 * ID: 740<br>
	 * Message: $c1 T|[g̗vőΘbɎQ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22240;&#71;&#77;&#30340;&#35201;&#27714;&#24050;&#21152;&#20837;&#35380;&#27714;&#23565;&#35441;&#12290;<br>
	 * Message: $c1 participated in a petition chat at the request of the GM.
	 */
	public static final SystemMessageId C1_PARTICIPATE_PETITION;
	
	/**
	 * ID: 741<br>
	 * Message: $c1 Θbɒǉ̂Ɏs܂BłɃT|[g󂯕tԂłB<br>
	 * Message: &#35430;&#22294;&#23559;&#12300;&#36;&#99;&#49;&#12301;&#21152;&#20837;&#35380;&#27714;&#23565;&#35441;&#21371;&#36973;&#22833;&#25943;&#12290;&#24050;&#25552;&#20986;&#35380;&#27714;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: You have failed at adding $c1 to the petition chat. Petition has already been submitted.
	 */
	public static final SystemMessageId FAILED_ADDING_C1_TO_PETITION;
	
	/**
	 * ID: 742<br>
	 * Message: $c1 Θbɒǉ̂Ɏs܂BG[R[h$s2łB<br>
	 * Message: &#35430;&#22294;&#23559;&#12300;&#36;&#99;&#49;&#12301;&#21152;&#20837;&#35380;&#27714;&#23565;&#35441;&#21371;&#36973;&#22833;&#25943;&#12290;&#37679;&#35492;&#20195;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have failed at adding $c1 to the petition chat. The error code is $s2.
	 */
	public static final SystemMessageId PETITION_ADDING_C1_FAILED_ERROR_NUMBER_S2;
	
	/**
	 * ID: 743<br>
	 * Message: $c1 Θbޏꂵ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#38626;&#38283;&#20102;&#35380;&#27714;&#23565;&#35441;&#12290;<br>
	 * Message: $c1 left the petition chat.
	 */
	public static final SystemMessageId C1_LEFT_PETITION_CHAT;
	
	/**
	 * ID: 744<br>
	 * Message: $s1 Θb폜̂Ɏs܂BG[R[h$s2łB<br>
	 * Message: &#35430;&#22294;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#24478;&#35380;&#27714;&#23565;&#35441;&#20013;&#21034;&#38500;&#21371;&#36973;&#22833;&#25943;&#12290;&#37679;&#35492;&#20195;&#30908;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have failed at removing $s1 from the petition chat. The error code is $s2.
	 */
	public static final SystemMessageId PETITION_REMOVING_S1_FAILED_ERROR_NUMBER_S2;
	
	/**
	 * ID: 745<br>
	 * Message: ݃T|[g̑ΘbԂł͂܂B<br>
	 * Message: &#30446;&#21069;&#19981;&#26159;&#35380;&#27714;&#23565;&#35441;&#29376;&#24907;&#12290;<br>
	 * Message: You are currently not in a petition chat.
	 */
	public static final SystemMessageId YOU_ARE_NOT_IN_PETITION_CHAT;
	
	/**
	 * ID: 746<br>
	 * Message: ݂̓T|[gv̏Ԃł͂܂B<br>
	 * Message: &#30446;&#21069;&#19981;&#26159;&#35380;&#27714;&#29376;&#24907;&#12290;<br>
	 * Message: It is not currently a petition.
	 */
	public static final SystemMessageId CURRENTLY_NO_PETITION;
	
	/**
	 * ID: 748<br>
	 * Message: Ă邽߁Arf܂B<br>
	 * Message: &#22240;&#36317;&#38626;&#22826;&#36960;&#65292;&#25216;&#33021;&#26045;&#23637;&#34987;&#20013;&#26039;&#12290;<br>
	 * Message: The distance is too far and so the casting has been stopped.
	 */
	public static final SystemMessageId DIST_TOO_FAR_CASTING_STOPPED;
	
	/**
	 * ID: 749<br>
	 * Message: $s1̌ʂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#34987;&#35299;&#38500;&#20102;&#12290;<br>
	 * Message: The effect of $s1 has been removed.
	 */
	public static final SystemMessageId EFFECT_S1_DISAPPEARED;
	
	/**
	 * ID: 750<br>
	 * Message: ȏKXL܂B<br>
	 * Message: &#24050;&#32147;&#27794;&#26377;&#21487;&#20197;&#23416;&#32722;&#30340;&#25216;&#33021;&#12290;<br>
	 * Message: There are no other skills to learn.
	 */
	public static final SystemMessageId NO_MORE_SKILLS_TO_LEARN;
	
	/**
	 * ID: 751<br>
	 * Message: ɑ錌ƍŮ֌WՓ˂邽߁Aɏ҂ł܂B<br>
	 * Message: &#33287;&#25152;&#23660;&#21516;&#30431;&#20043;&#38291;&#22312;&#25915;&#22478;&#25136;&#20013;&#26159;&#25973;&#23565;&#38364;&#20418;&#65292;&#25152;&#20197;&#28961;&#27861;&#32380;&#32396;&#30041;&#22312;&#21516;&#30431;&#20043;&#20013;&#12290;<br>
	 * Message: As there is a conflict in the siege relationship with a clan in the alliance, you cannot invite that clan to the alliance.
	 */
	public static final SystemMessageId CANNOT_INVITE_CONFLICT_CLAN;
	
	/**
	 * ID: 752<br>
	 * Message: gpłȂOłB<br>
	 * Message: &#26159;&#28961;&#25928;&#30340;&#22995;&#21517;&#12290;<br>
	 * Message: That name cannot be used.
	 */
	public static final SystemMessageId CANNOT_USE_NAME;
	
	/**
	 * ID: 753<br>
	 * Message: ɂ͗bzuł܂B<br>
	 * Message: &#27492;&#22320;&#40670;&#28961;&#27861;&#37197;&#32622;&#20653;&#20853;&#12290;<br>
	 * Message: You cannot position mercenaries here.
	 */
	public static final SystemMessageId NO_MERCS_HERE;
	
	/**
	 * ID: 754<br>
	 * Message: T̎gpԂ́A$s1$s2łB<br>
	 * Message: &#26412;&#36913;&#30340;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: There are $s1 hours and $s2 minutes left in this week's usage time.
	 */
	public static final SystemMessageId S1_HOURS_S2_MINUTES_LEFT_THIS_WEEK;
	
	/**
	 * ID: 755<br>
	 * Message: T̎gpԂ́A$s1łB<br>
	 * Message: &#26412;&#36913;&#30340;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: There are $s1 minutes left in this week's usage time.
	 */
	public static final SystemMessageId S1_MINUTES_LEFT_THIS_WEEK;
	
	/**
	 * ID: 756<br>
	 * Message: T̎gpԂI܂B<br>
	 * Message: &#26412;&#36913;&#30340;&#20351;&#29992;&#26178;&#38291;&#24050;&#32147;&#32080;&#26463;&#20102;&#12290;<br>
	 * Message: This week's usage time has finished.
	 */
	public static final SystemMessageId WEEKS_USAGE_TIME_FINISHED;
	
	/**
	 * ID: 757<br>
	 * Message: ʎgpԂ́A$s1$s2łB<br>
	 * Message: &#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: There are $s1 hours and $s2 minutes left in the fixed use time.
	 */
	public static final SystemMessageId S1_HOURS_S2_MINUTES_LEFT_IN_TIME;
	
	/**
	 * ID: 758<br>
	 * Message: T̃vCԂ́A$s1$s2łB<br>
	 * Message: &#26412;&#36913;&#30340;&#36938;&#25138;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: There are $s1 hours and $s2 minutes left in this week's play time.
	 */
	public static final SystemMessageId S1_HOURS_S2_MINUTES_LEFT_THIS_WEEKS_PLAY_TIME;
	
	/**
	 * ID: 759<br>
	 * Message: T̃vCԂ́A$s1łB<br>
	 * Message: &#26412;&#36913;&#30340;&#36938;&#25138;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: There are $s1 minutes left in this week's play time.
	 */
	public static final SystemMessageId S1_MINUTES_LEFT_THIS_WEEKS_PLAY_TIME;
	
	/**
	 * ID: 760<br>
	 * Message: $c1 ͌Eތ1Ԍo߂Ă炸AɉłȂԂłB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36864;&#20986;&#34880;&#30431;&#24460;&#23578;&#26410;&#36229;&#36942;&#49;&#22825;&#65292;&#25152;&#20197;&#28961;&#27861;&#21152;&#20837;&#34880;&#30431;&#12290;<br>
	 * Message: $c1 cannot join the clan because one day has not yet passed since he/she left another clan.
	 */
	public static final SystemMessageId C1_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN;
	
	/**
	 * ID: 761<br>
	 * Message: $s1͓Eތ1o߂Ă炸AɉłȂԂłB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#36864;&#20986;&#21516;&#30431;&#20043;&#24460;&#36996;&#27794;&#26377;&#36229;&#36942;&#49;&#22825;&#25152;&#20197;&#28961;&#27861;&#21152;&#20837;&#21516;&#30431;&#12290;<br>
	 * Message: $s1 clan cannot join the alliance because one day has not yet passed since it left another alliance.
	 */
	public static final SystemMessageId S1_CANT_ENTER_ALLIANCE_WITHIN_1_DAY;
	
	/**
	 * ID: 762<br>
	 * Message: $c1$s2]$s3o܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36681;&#21205;&#12300;&#36;&#115;&#50;&#12301;&#24460;&#20986;&#29694;&#12300;&#36;&#115;&#51;&#12301;&#40670;&#40670;&#25976;&#12290;<br>
	 * Message: $c1 rolled $s2 and $s3's eye came out.
	 */
	public static final SystemMessageId C1_ROLLED_S2_S3_EYE_CAME_OUT;
	
	/**
	 * ID: 763<br>
	 * Message: qɂƂ̋ߏ͂܂łB<br>
	 * Message: &#22240;&#28858;&#38626;&#20489;&#24235;&#30340;&#36317;&#38626;&#36942;&#36960;&#25152;&#20197;&#36939;&#36865;&#21253;&#35065;&#22833;&#25943;&#12290;<br>
	 * Message: You failed at sending the package because you are too far from the warehouse.
	 */
	public static final SystemMessageId FAILED_SENDING_PACKAGE_TOO_FAR;
	
	/**
	 * ID: 764<br>
	 * Message: $s1ԃvC܂BN̂߂ɂ΂炭xeĂB<br>
	 * Message: &#36938;&#25138;&#24050;&#32147;&#36914;&#34892;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#23567;&#26178;&#12290;&#28858;&#20102;&#20581;&#24247;&#65292;&#35531;&#24744;&#20241;&#24687;&#29255;&#21051;&#24460;&#20877;&#32380;&#32396;&#36938;&#25138;&#21543;&#12290;<br>
	 * Message: You have been playing for an extended period of time. Please consider taking a break.
	 */
	public static final SystemMessageId PLAYING_FOR_LONG_TIME;
	
	/**
	 * ID: 769<br>
	 * Message: s[eBeB̗p܂Bs[eBeB̗pIāAēxsĂB<br>
	 * Message: &#30332;&#29694;&#20102;&#39405;&#23458;&#24037;&#20855;&#12290;&#35531;&#38364;&#38281;&#19981;&#24517;&#35201;&#30340;&#31243;&#24335;&#24460;&#37325;&#26032;&#22519;&#34892;&#12290;<br>
	 * Message: A hacking tool has been discovered. Please try again after closing unnecessary programs.
	 */
	public static final SystemMessageId HACKING_TOOL;
	
	/**
	 * ID: 774<br>
	 * Message: vCԂ͂ȏ㌸܂B<br>
	 * Message: &#36938;&#25138;&#26178;&#38291;&#23559;&#19981;&#26371;&#32380;&#32396;&#28040;&#32791;&#12290;<br>
	 * Message: Play time is no longer accumulating.
	 */
	public static final SystemMessageId PLAY_TIME_NO_LONGER_ACCUMULATING;
	
	/**
	 * ID: 775<br>
	 * Message: ꂩvCԂ܂B<br>
	 * Message: &#29694;&#22312;&#38283;&#22987;&#28040;&#32791;&#36938;&#25138;&#26178;&#38291;&#12290;<br>
	 * Message: From here on, play time will be expended.
	 */
	public static final SystemMessageId PLAY_TIME_EXPENDED;
	
	/**
	 * ID: 776<br>
	 * Message: ɓDAWg$s1ɗD܂B<br>
	 * Message: &#22312;&#25293;&#36067;&#20013;&#25307;&#27161;&#30340;&#26681;&#25818;&#22320;&#65292;&#30001;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#24471;&#27161;&#12290;<br>
	 * Message: The clan hall which was put up for auction has been awarded to clan.
	 */
	public static final SystemMessageId CLANHALL_AWARDED_TO_CLAN;
	
	/**
	 * ID: 777<br>
	 * Message: ɓDAWgDƂȂ܂B<br>
	 * Message: &#22312;&#25293;&#36067;&#20013;&#25307;&#27161;&#30340;&#26681;&#25818;&#22320;&#27969;&#27161;&#20102;&#12290;<br>
	 * Message: The clan hall which was put up for auction was not sold and therefore has been re-listed.
	 */
	public static final SystemMessageId CLANHALL_NOT_SOLD;
	
	/**
	 * ID: 778<br>
	 * Message: ł̓OAEgł܂B<br>
	 * Message: &#28961;&#27861;&#22312;&#27492;&#34389;&#30331;&#20986;&#12290;<br>
	 * Message: You may not log out from this location.
	 */
	public static final SystemMessageId NO_LOGOUT_HERE;
	
	/**
	 * ID: 779<br>
	 * Message: ł̓X^[gł܂B<br>
	 * Message: &#28961;&#27861;&#22312;&#27492;&#34389;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: You may not restart in this location.
	 */
	public static final SystemMessageId NO_RESTART_HERE;
	
	/**
	 * ID: 780<br>
	 * Message: ŮԂϐł܂B<br>
	 * Message: &#21482;&#33021;&#22312;&#36914;&#34892;&#25915;&#22478;&#25136;&#26178;&#35264;&#25136;&#12290;<br>
	 * Message: Observation is only possible during a siege.
	 */
	public static final SystemMessageId ONLY_VIEW_SIEGE;
	
	/**
	 * ID: 781<br>
	 * Message: ϐ풆ɂ͂łȂsłB<br>
	 * Message: &#22312;&#35264;&#25136;&#26178;&#65292;&#28961;&#27861;&#36914;&#34892;&#27492;&#21205;&#20316;&#12290;<br>
	 * Message: Observers cannot participate.
	 */
	public static final SystemMessageId OBSERVERS_CANNOT_PARTICIPATE;
	
	/**
	 * ID: 782<br>
	 * Message: ybgA܂͏bĂԂł͊ϐł܂B<br>
	 * Message: &#33509;&#24050;&#21484;&#21914;&#23541;&#29289;&#25110;&#20351;&#39764;&#30340;&#35441;&#65292;&#23601;&#28961;&#27861;&#35264;&#25136;&#12290;<br>
	 * Message: You may not observe a siege with a pet or servitor summoned.
	 */
	public static final SystemMessageId NO_OBSERVE_WITH_PET;
	
	/**
	 * ID: 783<br>
	 * Message: ݁A󂭂̔̔ꎞfĂ܂B<br>
	 * Message: &#29694;&#22312;&#26283;&#20572;&#36009;&#36067;&#24425;&#21048;&#12290;<br>
	 * Message: Lottery ticket sales have been temporarily suspended.
	 */
	public static final SystemMessageId LOTTERY_TICKET_SALES_TEMP_SUSPENDED;
	
	/**
	 * ID: 784<br>
	 * Message: 󂭂̔̔ߐ؂܂B<br>
	 * Message: &#24425;&#21048;&#24050;&#36009;&#36067;&#32080;&#26463;&#12290;<br>
	 * Message: Tickets for the current lottery are no longer available.
	 */
	public static final SystemMessageId NO_LOTTERY_TICKETS_AVAILABLE;
	
	/**
	 * ID: 785<br>
	 * Message: ܂$s1ڂ̓IʂoĂ܂B<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#20013;&#29518;&#32080;&#26524;&#23578;&#26410;&#20986;&#29200;&#12290;<br>
	 * Message: The results of lottery number $s1 have not yet been published.
	 */
	public static final SystemMessageId LOTTERY_S1_RESULT_NOT_PUBLISHED;
	
	/**
	 * ID: 786<br>
	 * Message: gȂPꂪ܂܂Ă܂B<br>
	 * Message: &#21477;&#20013;&#21253;&#21547;&#33879;&#28961;&#27861;&#20351;&#29992;&#30340;&#21934;&#23383;&#12290;<br>
	 * Message: Incorrect syntax.
	 */
	public static final SystemMessageId INCORRECT_SYNTAX;
	
	/**
	 * ID: 787<br>
	 * Message: \II܂B<br>
	 * Message: &#38928;&#36093;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The tryouts are finished.
	 */
	public static final SystemMessageId CLANHALL_SIEGE_TRYOUTS_FINISHED;
	
	/**
	 * ID: 788<br>
	 * Message: 킪I܂B<br>
	 * Message: &#27770;&#36093;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The finals are finished.
	 */
	public static final SystemMessageId CLANHALL_SIEGE_FINALS_FINISHED;
	
	/**
	 * ID: 789<br>
	 * Message: \In܂܂B<br>
	 * Message: &#38928;&#36093;&#24050;&#38283;&#22987;&#12290;<br>
	 * Message: The tryouts have begun.
	 */
	public static final SystemMessageId CLANHALL_SIEGE_TRYOUTS_BEGUN;
	
	/**
	 * ID: 790<br>
	 * Message: 킪n܂܂B<br>
	 * Message: &#27770;&#36093;&#24050;&#38283;&#22987;&#12290;<br>
	 * Message: The finals are finished.
	 */
	public static final SystemMessageId CLANHALL_SIEGE_FINALS_BEGUN;
	
	/**
	 * ID: 791<br>
	 * Message: ̑ҋ@ԂłBĂB<br>
	 * Message: &#31561;&#24453;&#21443;&#33287;&#27770;&#36093;&#12290;&#35531;&#38928;&#20633;&#12290;<br>
	 * Message: The final match is about to begin. Line up!
	 */
	public static final SystemMessageId FINAL_MATCH_BEGIN;
	
	/**
	 * ID: 792<br>
	 * Message: AWg킪I܂B<br>
	 * Message: &#26681;&#25818;&#22320;&#20308;&#38936;&#25136;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The siege of the clan hall is finished.
	 */
	public static final SystemMessageId CLANHALL_SIEGE_ENDED;
	
	/**
	 * ID: 793<br>
	 * Message: AWg킪n܂܂B<br>
	 * Message: &#26681;&#25818;&#22320;&#20308;&#38936;&#25136;&#24050;&#38283;&#22987;&#12290;<br>
	 * Message: The siege of the clan hall has begun.
	 */
	public static final SystemMessageId CLANHALL_SIEGE_BEGUN;
	
	/**
	 * ID: 794<br>
	 * Message: Y錠܂B<br>
	 * Message: &#27794;&#26377;&#30456;&#38364;&#27402;&#38480;&#12290;<br>
	 * Message: You are not authorized to do that.
	 */
	public static final SystemMessageId YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT;
	
	/**
	 * ID: 795<br>
	 * Message: ݂̂ݒł܂B<br>
	 * Message: &#21482;&#26377;&#34880;&#30431;&#30431;&#20027;&#25165;&#33021;&#35373;&#23450;&#27402;&#38480;&#12290;<br>
	 * Message: Only clan leaders are authorized to set rights.
	 */
	public static final SystemMessageId ONLY_LEADERS_CAN_SET_RIGHTS;
	
	/**
	 * ID: 796<br>
	 * Message: ϐ\Ԃ͎c$s1łB<br>
	 * Message: &#21487;&#20197;&#35264;&#25136;&#30340;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: Your remaining observation time is minutes.
	 */
	public static final SystemMessageId REMAINING_OBSERVATION_TIME;
	
	/**
	 * ID: 797<br>
	 * Message: }N48܂œo^\łB<br>
	 * Message: &#24040;&#38598;&#21487;&#20197;&#22686;&#21152;&#21040;&#52;&#56;&#20491;&#12290;<br>
	 * Message: You may create up to 48 macros.
	 */
	public static final SystemMessageId YOU_MAY_CREATE_UP_TO_48_MACROS;
	
	/**
	 * ID: 798<br>
	 * Message: xo^ƁAĂѐ}ACeɖ߂Ƃ͂ł܂Bo^Ă낵łB<br>
	 * Message: &#19968;&#26086;&#30331;&#35352;&#20043;&#24460;&#65292;&#23601;&#28961;&#27861;&#20877;&#24674;&#24489;&#28858;&#35069;&#20316;&#21367;&#36600;&#36947;&#20855;&#12290;&#26159;&#21542;&#35201;&#30331;&#35352;&#65311;<br>
	 * Message: Item registration is irreversible. Do you wish to continue?
	 */
	public static final SystemMessageId ITEM_REGISTRATION_IRREVERSIBLE;
	
	/**
	 * ID: 799<br>
	 * Message: ϐ\ԂI܂B<br>
	 * Message: &#21487;&#35264;&#25136;&#30340;&#26178;&#38291;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The observation time has expired.
	 */
	public static final SystemMessageId OBSERVATION_TIME_EXPIRED;
	
	/**
	 * ID: 800<br>
	 * Message: AWg̓o^Ԃ߂̂ŁAo^ł܂B<br>
	 * Message: &#26681;&#25818;&#22320;&#20308;&#38936;&#25136;&#30331;&#35352;&#26178;&#38291;&#24050;&#32080;&#26463;&#65292;&#22240;&#27492;&#28961;&#27861;&#30331;&#35352;&#12290;<br>
	 * Message: You are too late. The registration period is over.
	 */
	public static final SystemMessageId REGISTRATION_PERIOD_OVER;
	
	/**
	 * ID: 801<br>
	 * Message: ȏ̃AWg̓o^͂ł܂B<br>
	 * Message: &#28961;&#27861;&#20877;&#30331;&#35352;&#26681;&#25818;&#22320;&#20308;&#38936;&#25136;&#12290;<br>
	 * Message: Registration for the clan hall siege is closed.
	 */
	public static final SystemMessageId REGISTRATION_CLOSED;
	
	/**
	 * ID: 802<br>
	 * Message: ȏĎEBhEJƂł܂BEBhEāAēxsĂB<br>
	 * Message: &#28961;&#27861;&#20877;&#38283;&#21855;&#30435;&#35222;&#35222;&#31383;&#12290;&#35531;&#38364;&#38281;&#30446;&#21069;&#30340;&#35222;&#31383;&#24460;&#65292;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Petitions are not being accepted at this time. You may submit your petition after a.m./p.m.
	 */
	public static final SystemMessageId PETITION_NOT_ACCEPTED_NOW;
	
	/**
	 * ID: 803<br>
	 * Message: T|[gv̓eĂB<br>
	 * Message: &#35531;&#23531;&#19979;&#35380;&#27714;&#20839;&#23481;&#12290;<br>
	 * Message: Enter the specifics of your petition.
	 */
	public static final SystemMessageId PETITION_NOT_SPECIFIED;
	
	/**
	 * ID: 804<br>
	 * Message: ނIāAFAQmFB<br>
	 * Message: &#35531;&#36984;&#25799;&#20998;&#39006;&#25110;&#30456;&#38364;&#70;&#65;&#81;&#12290;<br>
	 * Message: Select a type.
	 */
	public static final SystemMessageId SELECT_TYPE;
	
	/**
	 * ID: 805<br>
	 * Message: ݂̓T|[g̎󂯕tsĂ܂B$s1ȌɍēxvĂB<br>
	 * Message: &#30446;&#21069;&#19981;&#25509;&#21463;&#35380;&#27714;&#12290;&#35531;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#20197;&#24460;&#37325;&#35430;&#12290;<br>
	 * Message: Petitions are not being accepted at this time. You may submit your petition after $s1 a.m./p.m.
	 */
	public static final SystemMessageId PETITION_NOT_ACCEPTED_SUBMIT_AT_S1;
	
	/**
	 * ID: 806<br>
	 * Message: n`ɂ͂܂ďoȂ́u/escapevR}hĂ݂ĂB<br>
	 * Message: &#33509;&#22846;&#22312;&#22320;&#24418;&#32780;&#21205;&#24392;&#19981;&#24471;&#26178;&#65292;&#35531;&#22039;&#35430;&#12300;&#47;&#33067;&#36867;&#12301;&#25351;&#20196;&#12290;<br>
	 * Message: If you are trapped, try typing "/unstuck".
	 */
	public static final SystemMessageId TRY_UNSTUCK_WHEN_TRAPPED;
	
	/**
	 * ID: 807<br>
	 * Message: ړs\Ȓn`ł̂ŁAɃe|[g܂B<br>
	 * Message: &#22240;&#34389;&#26044;&#28961;&#27861;&#31227;&#21205;&#30340;&#22320;&#24418;&#32780;&#33067;&#36867;&#21040;&#26449;&#33674;&#12290;<br>
	 * Message: This terrain is navigable. Prepare for transport to the nearest village.
	 */
	public static final SystemMessageId STUCK_PREPARE_FOR_TRANSPORT;
	
	/**
	 * ID: 808<br>
	 * Message: ړs\Ȓn`ł邱ƂmFł܂łBu/supportvR}hŁAT|[gvsȂĂB<br>
	 * Message: &#19981;&#33021;&#30906;&#35469;&#26159;&#21542;&#34389;&#26044;&#28961;&#27861;&#31227;&#21205;&#30340;&#22320;&#24418;&#12290;&#35531;&#29992;&#12300;&#47;&#35380;&#27714;&#12301;&#25351;&#20196;&#30003;&#35531;&#35380;&#27714;&#12290;<br>
	 * Message: You are stuck. You may submit a petition by typing "/gm".
	 */
	public static final SystemMessageId STUCK_SUBMIT_PETITION;
	
	/**
	 * ID: 809<br>
	 * Message: ړs\Ȓn`ł邱ƂmFł܂łB5ɑɃe|[g܂B<br>
	 * Message: &#19981;&#33021;&#30906;&#35469;&#26159;&#21542;&#34389;&#26044;&#28961;&#27861;&#31227;&#21205;&#30340;&#22320;&#24418;&#12290;&#53;&#20998;&#37912;&#20043;&#24460;&#23559;&#33067;&#36867;&#21040;&#26449;&#33674;&#12290;<br>
	 * Message: You are stuck. You will be transported to the nearest village in five minutes.
	 */
	public static final SystemMessageId STUCK_TRANSPORT_IN_FIVE_MINUTES;
	
	/**
	 * ID: 810<br>
	 * Message: Lȃ}Nł͂܂B}NɊ֘AwvmFB<br>
	 * Message: &#36889;&#19981;&#26159;&#26377;&#25928;&#30340;&#24040;&#38598;&#12290;&#21443;&#29031;&#26377;&#38364;&#24040;&#38598;&#30340;&#27714;&#21161;&#12290;<br>
	 * Message: Invalid macro. Refer to the Help file for instructions.
	 */
	public static final SystemMessageId INVALID_MACRO;
	
	/**
	 * ID: 811<br>
	 * Message: ړIni$s1jɈړ܂B<br>
	 * Message: &#21521;&#30446;&#30340;&#22320;&#12300;&#36;&#115;&#49;&#12301;&#31227;&#21205;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: You will be moved to (). Do you wish to continue?
	 */
	public static final SystemMessageId WILL_BE_MOVED;
	
	/**
	 * ID: 812<br>
	 * Message: 㩂ɂ$s1̃_[W󂯂܂B<br>
	 * Message: &#22240;&#28858;&#31192;&#23494;&#38519;&#38449;&#65292;&#21463;&#21040;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: The secret trap has inflicted $s1 damage on you.
	 */
	public static final SystemMessageId TRAP_DID_S1_DAMAGE;
	
	/**
	 * ID: 813<br>
	 * Message: 㩂ɂēłɊ|܂B<br>
	 * Message: &#22240;&#28858;&#31061;&#23494;&#38519;&#38449;&#32780;&#20013;&#27602;&#12290;<br>
	 * Message: You have been poisoned by a Secret Trap.
	 */
	public static final SystemMessageId POISONED_BY_TRAP;
	
	/**
	 * ID: 814<br>
	 * Message: 㩂ɂĈړxቺ܂B<br>
	 * Message: &#22240;&#28858;&#31192;&#23494;&#38519;&#38449;&#65292;&#20351;&#24471;&#31227;&#21205;&#36895;&#24230;&#19979;&#38477;&#12290;<br>
	 * Message: Your speed has been decreased by a Secret Trap.
	 */
	public static final SystemMessageId SLOWED_BY_TRAP;
	
	/**
	 * ID: 815<br>
	 * Message: \Iҋ@ԂłBĂB<br>
	 * Message: &#31561;&#24453;&#21443;&#33287;&#38928;&#36093;&#12290;&#35531;&#38928;&#20633;&#12290;<br>
	 * Message: The tryouts are about to begin. Line up!
	 */
	public static final SystemMessageId TRYOUTS_ABOUT_TO_BEGIN;
	
	/**
	 * ID: 816<br>
	 * Message: $s1񃂃X^[ [X `Pbg̔̔Jn܂I<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#24618;&#29289;&#36093;&#28310;&#20633;&#22909;&#20102;&#12290;&#35531;&#36092;&#36023;&#31080;&#12290;<br>
	 * Message: Tickets are now available for Monster Race $s1!
	 */
	public static final SystemMessageId MONSRACE_TICKETS_AVAILABLE_FOR_S1_RACE;
	
	/**
	 * ID: 817<br>
	 * Message: $s1񃂃X^[ [X `Pbgݔ̔Ă܂B<br>
	 * Message: &#27491;&#22312;&#36009;&#36067;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: Now selling tickets for Monster Race $s1!
	 */
	public static final SystemMessageId MONSRACE_TICKETS_NOW_AVAILABLE_FOR_S1_RACE;
	
	/**
	 * ID: 818<br>
	 * Message: $s1ɃX^[ [X `Pbg̔̔I܂B߂ɂwB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#20043;&#24460;&#23559;&#32080;&#26463;&#36009;&#36067;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: Ticket sales for the Monster Race will end in $s1 minute(s).
	 */
	public static final SystemMessageId MONSRACE_TICKETS_STOP_IN_S1_MINUTES;
	
	/**
	 * ID: 819<br>
	 * Message: $s1񃂃X^[ [X `Pbg̔̔I܂BzmFB<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#24618;&#29289;&#36093;&#31080;&#24050;&#32080;&#26463;&#36009;&#36067;&#12290;&#35531;&#30906;&#35469;&#36064;&#29575;&#12290;<br>
	 * Message: Tickets sales are closed for Monster Race $s1. Odds are posted.
	 */
	public static final SystemMessageId MONSRACE_S1_TICKET_SALES_CLOSED;
	
	/**
	 * ID: 820<br>
	 * Message: $s1ɑ$s2񃂃X^[ [XJn܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#20043;&#24460;&#23559;&#38283;&#22987;&#31532;&#12300;&#36;&#115;&#50;&#12301;&#22238;&#21512;&#24618;&#29289;&#36093;&#12290;<br>
	 * Message: Monster Race $s2 will begin in $s1 minute(s)!
	 */
	public static final SystemMessageId MONSRACE_S2_BEGINS_IN_S1_MINUTES;
	
	/**
	 * ID: 821<br>
	 * Message: 30bɑ$s1񃂃X^[ [XJn܂B<br>
	 * Message: &#51;&#48;&#31186;&#20043;&#24460;&#23559;&#38283;&#22987;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#24618;&#29289;&#36093;&#12290;<br>
	 * Message: Monster Race $s1 will begin in 30 seconds!
	 */
	public static final SystemMessageId MONSRACE_S1_BEGINS_IN_30_SECONDS;
	
	/**
	 * ID: 822<br>
	 * Message: $s1񃂃X^[ [XJn܂B<br>
	 * Message: &#21363;&#23559;&#38283;&#22987;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#24618;&#29289;&#36093;&#12290;&#53;&#31186;&#20043;&#24460;&#38283;&#22987;&#20498;&#25976;&#35336;&#26178;&#12290;<br>
	 * Message: Monster Race $s1 is about to begin! Countdown in five seconds!
	 */
	public static final SystemMessageId MONSRACE_S1_COUNTDOWN_IN_FIVE_SECONDS;
	
	/**
	 * ID: 823<br>
	 * Message: $s1bOI<br>
	 * Message: &#38283;&#22987;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#21069;&#65281;<br>
	 * Message: The race will begin in $s1 second(s)!
	 */
	public static final SystemMessageId MONSRACE_BEGINS_IN_S1_SECONDS;
	
	/**
	 * ID: 824<br>
	 * Message: [X X^[gI<br>
	 * Message: &#20986;&#30332;&#65281;&#27604;&#36093;&#24050;&#38283;&#22987;&#65281;<br>
	 * Message: They're off!
	 */
	public static final SystemMessageId MONSRACE_RACE_START;
	
	/**
	 * ID: 825<br>
	 * Message: $s1񃂃X^[ [XI܂B<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#21512;&#27604;&#36093;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: Monster Race $s1 is finished!
	 */
	public static final SystemMessageId MONSRACE_S1_RACE_END;
	
	/**
	 * ID: 826<br>
	 * Message: 1$s1ԁA2$s2ԂłI<br>
	 * Message: &#31532;&#19968;&#21517;&#26159;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#36305;&#36947;&#65292;&#31532;&#50;&#21517;&#26159;&#31532;&#12300;&#36;&#115;&#50;&#12301;&#36305;&#36947;&#12290;<br>
	 * Message: First prize goes to the player in lane $s1. Second prize goes to the player in lane $s2.
	 */
	public static final SystemMessageId MONSRACE_FIRST_PLACE_S1_SECOND_S2;
	
	/**
	 * ID: 827<br>
	 * Message: FSESPTET[rX`[Ւf邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#38548;&#32085;&#71;&#77;&#12290;<br>
	 * Message: You may not impose a block on a GM.
	 */
	public static final SystemMessageId YOU_MAY_NOT_IMPOSE_A_BLOCK_ON_GM;
	
	/**
	 * ID: 828<br>
	 * Message: $s1}N폜܂B<br>
	 * Message: &#21034;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#24040;&#38598;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: Are you sure you wish to delete the $s1 macro?
	 */
	public static final SystemMessageId WISH_TO_DELETE_S1_MACRO;
	
	/**
	 * ID: 829<br>
	 * Message: g𐄑E邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#25512;&#34214;&#33258;&#24049;&#12290;<br>
	 * Message: You cannot recommend yourself.
	 */
	public static final SystemMessageId YOU_CANNOT_RECOMMEND_YOURSELF;
	
	/**
	 * ID: 830<br>
	 * Message: $c1𐄑E܂BE̎c$s2łB<br>
	 * Message: &#25512;&#34214;&#20102;&#12300;&#36;&#99;&#49;&#12301;&#12290;&#25512;&#34214;&#27402;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12290;<br>
	 * Message: You have recommended $c1. You have $s2 recommendations left.
	 */
	public static final SystemMessageId YOU_HAVE_RECOMMENDED_C1_YOU_HAVE_S2_RECOMMENDATIONS_LEFT;
	
	/**
	 * ID: 831<br>
	 * Message: $c1琄E܂B<br>
	 * Message: &#24050;&#24478;&#12300;&#36;&#99;&#49;&#12301;&#24471;&#21040;&#25512;&#34214;&#12290;<br>
	 * Message: You have been recommended by $c1.
	 */
	public static final SystemMessageId YOU_HAVE_BEEN_RECOMMENDED_BY_C1;
	
	/**
	 * ID: 832<br>
	 * Message: łɐEĂ܂B<br>
	 * Message: &#34389;&#26044;&#24050;&#32147;&#25512;&#34214;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: That character has already been recommended.
	 */
	public static final SystemMessageId THAT_CHARACTER_IS_RECOMMENDED;
	
	/**
	 * ID: 833<br>
	 * Message: EׂĎgp܂BE͖ߌ1ɏ܂B<br>
	 * Message: &#25512;&#34214;&#27402;&#24050;&#20351;&#29992;&#23436;&#30050;&#12290;&#25512;&#34214;&#25976;&#23559;&#26371;&#22312;&#27599;&#22825;&#19979;&#21320;&#65297;&#40670;&#24674;&#24489;&#28858;&#21407;&#22987;&#35373;&#23450;&#12290;<br>
	 * Message: You are not authorized to make further recommendations at this time. You will receive more recommendation credits each day at 1 p.m.
	 */
	public static final SystemMessageId NO_MORE_RECOMMENDATIONS_TO_HAVE;
	
	/**
	 * ID: 834<br>
	 * Message: $c1]TCR̖ڂ$s2łB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25842;&#30340;&#39600;&#23376;&#40670;&#25976;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has rolled $s2.
	 */
	public static final SystemMessageId C1_ROLLED_S2;
	
	/**
	 * ID: 835<br>
	 * Message: AăTCRU邱Ƃ͂ł܂BԂuĂgpĂB<br>
	 * Message: &#29694;&#22312;&#28961;&#27861;&#25842;&#39600;&#23376;&#12290;&#35531;&#31245;&#24460;&#20877;&#20351;&#29992;&#12290;<br>
	 * Message: You may not throw the dice at this time. Try again later.
	 */
	public static final SystemMessageId YOU_MAY_NOT_THROW_THE_DICE_AT_THIS_TIME_TRY_AGAIN_LATER;
	
	/**
	 * ID: 836<br>
	 * Message: Cxg̃Xbg̒߂ɂAACe󂯎܂B<br>
	 * Message: &#36947;&#20855;&#28165;&#21934;&#30340;&#25976;&#37327;&#36229;&#36942;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#25509;&#25910;&#36947;&#20855;&#12290;<br>
	 * Message: You have exceeded your inventory volume limit and cannot take this item.
	 */
	public static final SystemMessageId YOU_HAVE_EXCEEDED_YOUR_INVENTORY_VOLUME_LIMIT_AND_CANNOT_TAKE_THIS_ITEM;
	
	/**
	 * ID: 837<br>
	 * Message: }N̐32܂łłB<br>
	 * Message: &#24040;&#38598;&#20043;&#35498;&#26126;&#26368;&#22810;&#21482;&#33021;&#36664;&#20837;&#51;&#50;&#23383;&#12290;<br>
	 * Message: Macro descriptions may contain up to 32 characters.
	 */
	public static final SystemMessageId MACRO_DESCRIPTION_MAX_32_CHARS;
	
	/**
	 * ID: 838<br>
	 * Message: }N͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#24040;&#38598;&#30340;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the name of the macro.
	 */
	public static final SystemMessageId ENTER_THE_MACRO_NAME;
	
	/**
	 * ID: 839<br>
	 * Message: Õ}N̂œo^ł܂B<br>
	 * Message: &#30456;&#21516;&#21517;&#31281;&#30340;&#24040;&#38598;&#24050;&#23384;&#22312;&#12290;<br>
	 * Message: That name is already assigned to another macro.
	 */
	public static final SystemMessageId MACRO_NAME_ALREADY_USED;
	
	/**
	 * ID: 840<br>
	 * Message: łɓo^Ă鐻}łB<br>
	 * Message: &#24050;&#30331;&#35352;&#30340;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: That recipe is already registered.
	 */
	public static final SystemMessageId RECIPE_ALREADY_REGISTERED;
	
	/**
	 * ID: 841<br>
	 * Message: ȏ㐻}̓o^͂ł܂B<br>
	 * Message: &#24050;&#28961;&#27861;&#20877;&#30331;&#35352;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: No further recipes may be registered.
	 */
	public static final SystemMessageId NO_FUTHER_RECIPES_CAN_BE_ADDED;
	
	/**
	 * ID: 842<br>
	 * Message: NGCg ACẽXL xႢ߁A}o^ł܂B<br>
	 * Message: &#36947;&#20855;&#35069;&#20316;&#25216;&#33021;&#31561;&#32026;&#22826;&#20302;&#65292;&#28961;&#27861;&#30331;&#35352;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: You are not authorized to register a recipe.
	 */
	public static final SystemMessageId NOT_AUTHORIZED_REGISTER_RECIPE;
	
	/**
	 * ID: 843<br>
	 * Message: $s1̐̐킪I܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20308;&#38936;&#25136;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The siege of $s1 is finished.
	 */
	public static final SystemMessageId SIEGE_OF_S1_FINISHED;
	
	/**
	 * ID: 844<br>
	 * Message: $s1̐̐킪Jn܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20308;&#38936;&#25136;&#24050;&#38283;&#22987;&#12290;<br>
	 * Message: The siege to conquer $s1 has begun.
	 */
	public static final SystemMessageId SIEGE_OF_S1_BEGUN;
	
	/**
	 * ID: 845<br>
	 * Message: $s1̐̐̓o^ԂI܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20308;&#38936;&#25136;&#30331;&#35352;&#26178;&#38291;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The deadlineto register for the siege of $s1 has passed.
	 */
	public static final SystemMessageId DEADLINE_FOR_SIEGE_S1_PASSED;
	
	/**
	 * ID: 846<br>
	 * Message: Q錌Ȃ߁A$s1̐̐킪LZ܂B<br>
	 * Message: &#27794;&#26377;&#21443;&#21152;&#30340;&#34880;&#30431;&#65292;&#22240;&#27492;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20308;&#38936;&#25136;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: The siege of $s1 has been canceled due to lack of interest.
	 */
	public static final SystemMessageId SIEGE_OF_S1_HAS_BEEN_CANCELED_DUE_TO_LACK_OF_INTEREST;
	
	/**
	 * ID: 847<br>
	 * Message: łɃAWgLĂ錌͐̐ɎQł܂B<br>
	 * Message: &#24050;&#25793;&#26377;&#26681;&#25818;&#22320;&#30340;&#34880;&#30431;&#65292;&#28961;&#27861;&#21443;&#21152;&#20308;&#38936;&#25136;&#12290;<br>
	 * Message: A clan that owns a clan hall may not participate in a clan hall siege.
	 */
	public static final SystemMessageId CLAN_OWNING_CLANHALL_MAY_NOT_SIEGE_CLANHALL;
	
	/**
	 * ID: 848<br>
	 * Message: $s1폜܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#34987;&#21034;&#38500;&#12290;<br>
	 * Message: $s1 has been deleted.
	 */
	public static final SystemMessageId S1_HAS_BEEN_DELETED;
	
	/**
	 * ID: 849<br>
	 * Message: $s1TƂł܂B<br>
	 * Message: &#28961;&#27861;&#25214;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 cannot be found.
	 */
	public static final SystemMessageId S1_NOT_FOUND;
	
	/**
	 * ID: 850<br>
	 * Message: $s1łɑ݂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#23384;&#22312;&#12290;<br>
	 * Message: $s1 already exists.
	 */
	public static final SystemMessageId S1_ALREADY_EXISTS2;
	
	/**
	 * ID: 851<br>
	 * Message: $s1ǉ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#22686;&#21152;&#12290;<br>
	 * Message: $s1 has been added.
	 */
	public static final SystemMessageId S1_ADDED;
	
	/**
	 * ID: 852<br>
	 * Message: }̏񂪐܂B<br>
	 * Message: &#35069;&#20316;&#21367;&#36600;&#36039;&#26009;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The recipe is incorrect.
	 */
	public static final SystemMessageId RECIPE_INCORRECT;
	
	/**
	 * ID: 853<br>
	 * Message: lԂł́A}WǗ͂ł܂B<br>
	 * Message: &#20491;&#20154;&#24037;&#25151;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#31649;&#29702;&#35069;&#20316;&#21367;&#36600;&#26360;&#31821;&#12290;<br>
	 * Message: You may not alter your recipe book while engaged in manufacturing.
	 */
	public static final SystemMessageId CANT_ALTER_RECIPEBOOK_WHILE_CRAFTING;
	
	/**
	 * ID: 854<br>
	 * Message: $s1$s2܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#22816;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12290;<br>
	 * Message: You are missing $s2 $s1 required to create that.
	 */
	public static final SystemMessageId MISSING_S2_S1_TO_CREATE;
	
	/**
	 * ID: 855<br>
	 * Message: $s1$s2Ƃ̐̐ŏ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#22312;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20308;&#38936;&#25136;&#20013;&#24471;&#21040;&#20102;&#21213;&#21033;&#12290;<br>
	 * Message: $s1 clan has defeated $s2.
	 */
	public static final SystemMessageId S1_CLAN_DEFEATED_S2;
	
	/**
	 * ID: 856<br>
	 * Message: $s1̐̐킪ŏI܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20308;&#38936;&#25136;&#32080;&#26524;&#28858;&#24179;&#25163;&#12290;<br>
	 * Message: The siege of $s1 has ended in a draw.
	 */
	public static final SystemMessageId SIEGE_S1_DRAW;
	
	/**
	 * ID: 857<br>
	 * Message: $s1$s2Ƃ̗\Iŏ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#22312;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#38928;&#36093;&#20013;&#24471;&#21040;&#20102;&#21213;&#21033;&#12290;<br>
	 * Message: $s1 clan has won in the preliminary match of $s2.
	 */
	public static final SystemMessageId S1_CLAN_WON_MATCH_S2;
	
	/**
	 * ID: 858<br>
	 * Message: $s1̗\I͈ŏI܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#38928;&#36093;&#32080;&#23616;&#25104;&#28858;&#24179;&#25163;&#12290;<br>
	 * Message: The preliminary match of $s1 has ended in a draw.
	 */
	public static final SystemMessageId MATCH_OF_S1_DRAW;
	
	/**
	 * ID: 859<br>
	 * Message: }o^ĂB<br>
	 * Message: &#35531;&#30331;&#35352;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: Please register a recipe.
	 */
	public static final SystemMessageId PLEASE_REGISTER_RECIPE;
	
	/**
	 * ID: 860<br>
	 * Message: ̐wnƂ̊Ԋu߁Aɐwn𗧂Ă邱Ƃł܂B<br>
	 * Message: &#33287;&#20854;&#20182;&#38499;&#22320;&#20043;&#38291;&#38548;&#22826;&#29433;&#31364;&#65292;&#22240;&#27492;&#28961;&#27861;&#22312;&#27492;&#22320;&#24314;&#31435;&#38499;&#22320;&#12290;<br>
	 * Message: You may not buld your headquarters in close proximity to another headquarters.
	 */
	public static final SystemMessageId HEADQUARTERS_TOO_CLOSE;
	
	/**
	 * ID: 861<br>
	 * Message: ̐߂܂B<br>
	 * Message: &#24050;&#36229;&#36942;&#35352;&#37636;&#25976;&#37327;&#12290;<br>
	 * Message: You have exceeded the maximum number of memos.
	 */
	public static final SystemMessageId TOO_MANY_MEMOS;
	
	/**
	 * ID: 862<br>
	 * Message: `Pbg̔̔ĂȂ̂ŁAz邱Ƃł܂B<br>
	 * Message: &#31080;&#23578;&#26410;&#20986;&#21806;&#23436;&#30050;&#65292;&#22240;&#27492;&#28961;&#27861;&#26597;&#30475;&#36064;&#29575;&#30340;&#24773;&#27841;&#12290;<br>
	 * Message: Odds are not posted until ticket sales have closed.
	 */
	public static final SystemMessageId ODDS_NOT_POSTED;
	
	/**
	 * ID: 863<br>
	 * Message: ΂̋C܂B<br>
	 * Message: &#33021;&#24863;&#35258;&#21040;&#28779;&#20043;&#27683;&#12290;<br>
	 * Message: You feel the energy of fire.
	 */
	public static final SystemMessageId FEEL_ENERGY_FIRE;
	
	/**
	 * ID: 864<br>
	 * Message: ̋C܂B<br>
	 * Message: &#33021;&#24863;&#35258;&#21040;&#27700;&#20043;&#27683;&#12290;<br>
	 * Message: You feel the energy of water.
	 */
	public static final SystemMessageId FEEL_ENERGY_WATER;
	
	/**
	 * ID: 865<br>
	 * Message: ̋C܂B<br>
	 * Message: &#33021;&#24863;&#35258;&#21040;&#39080;&#20043;&#27683;&#12290;<br>
	 * Message: You feel the energy of wind.
	 */
	public static final SystemMessageId FEEL_ENERGY_WIND;
	
	/**
	 * ID: 866<br>
	 * Message: ȏACW߂邱Ƃł܂B<br>
	 * Message: &#28961;&#27861;&#20877;&#21295;&#38598;&#21147;&#37327;&#12290;<br>
	 * Message: You may no longer gather energy.
	 */
	public static final SystemMessageId NO_LONGER_ENERGY;
	
	/**
	 * ID: 867<br>
	 * Message: CȂȂ܂B<br>
	 * Message: &#21147;&#27683;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: The energy is depleted.
	 */
	public static final SystemMessageId ENERGY_DEPLETED;
	
	/**
	 * ID: 868<br>
	 * Message: ΂̋C`܂B<br>
	 * Message: &#20659;&#36948;&#20102;&#28779;&#20043;&#27683;&#12290;<br>
	 * Message: The energy of fire has been delivered.
	 */
	public static final SystemMessageId ENERGY_FIRE_DELIVERED;
	
	/**
	 * ID: 869<br>
	 * Message: ̋C`܂B<br>
	 * Message: &#20659;&#36948;&#20102;&#27700;&#20043;&#27683;&#12290;<br>
	 * Message: The energy of water has been delivered.
	 */
	public static final SystemMessageId ENERGY_WATER_DELIVERED;
	
	/**
	 * ID: 870<br>
	 * Message: ̋C`܂B<br>
	 * Message: &#20659;&#36948;&#20102;&#39080;&#20043;&#27683;&#12290;<br>
	 * Message: The energy of wind has been delivered.
	 */
	public static final SystemMessageId ENERGY_WIND_DELIVERED;
	
	/**
	 * ID: 871<br>
	 * Message: łɎAtꂽԂłB<br>
	 * Message: &#30446;&#27161;&#24050;&#34389;&#26044;&#25773;&#31278;&#29376;&#24907;&#12290;<br>
	 * Message: The seed has been sown.
	 */
	public static final SystemMessageId THE_SEED_HAS_BEEN_SOWN;
	
	/**
	 * ID: 872<br>
	 * Message: ̑ł͎gȂłB<br>
	 * Message: &#27492;&#31278;&#23376;&#28961;&#27861;&#22312;&#36889;&#20491;&#33674;&#22290;&#20351;&#29992;&#12290;<br>
	 * Message: This seed may not be sown here.
	 */
	public static final SystemMessageId THIS_SEED_MAY_NOT_BE_SOWN_HERE;
	
	/**
	 * ID: 873<br>
	 * Message: ݕ󂯎LN^[܂B<br>
	 * Message: &#27794;&#26377;&#21487;&#25910;&#21462;&#36008;&#29289;&#30340;&#35282;&#33394;&#12290;<br>
	 * Message: That character does not exist.
	 */
	public static final SystemMessageId CHARACTER_DOES_NOT_EXIST;
	
	/**
	 * ID: 874<br>
	 * Message: ΏۂƂȂqɂςłB<br>
	 * Message: &#30446;&#27161;&#30340;&#20489;&#24235;&#24050;&#36229;&#36942;&#38480;&#24230;&#12290;<br>
	 * Message: The capacity of the warehouse has been exceeded.
	 */
	public static final SystemMessageId WAREHOUSE_CAPACITY_EXCEEDED;
	
	/**
	 * ID: 875<br>
	 * Message: zLZ܂B<br>
	 * Message: &#36008;&#29289;&#20659;&#36865;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: The transport of the cargo has been canceled.
	 */
	public static final SystemMessageId CARGO_CANCELED;
	
	/**
	 * ID: 876<br>
	 * Message: zɎs܂B<br>
	 * Message: &#36008;&#29289;&#20659;&#36865;&#22833;&#25943;&#12290;<br>
	 * Message: The cargo was not delivered.
	 */
	public static final SystemMessageId CARGO_NOT_DELIVERED;
	
	/**
	 * ID: 877<br>
	 * Message: lǉ܂B<br>
	 * Message: &#32011;&#31456;&#24050;&#22686;&#21152;&#12290;<br>
	 * Message: The symbol has been added.
	 */
	public static final SystemMessageId SYMBOL_ADDED;
	
	/**
	 * ID: 878<br>
	 * Message: l폜܂B<br>
	 * Message: &#32011;&#31456;&#24050;&#21034;&#38500;&#12290;<br>
	 * Message: The symbol has been deleted.
	 */
	public static final SystemMessageId SYMBOL_DELETED;
	
	/**
	 * ID: 879<br>
	 * Message: VXe͌ݓ_łB<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#32173;&#20462;&#33674;&#22290;&#31995;&#32113;&#12290;<br>
	 * Message: The manor system is currently under maintenance.
	 */
	public static final SystemMessageId THE_MANOR_SYSTEM_IS_CURRENTLY_UNDER_MAINTENANCE;
	
	/**
	 * ID: 880<br>
	 * Message: wI܂B<br>
	 * Message: &#25910;&#36092;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The transaction is complete.
	 */
	public static final SystemMessageId THE_TRANSACTION_IS_COMPLETE;
	
	/**
	 * ID: 881<br>
	 * Message: wACȅ񂪐܂B<br>
	 * Message: &#25910;&#36092;&#36947;&#20855;&#24773;&#22577;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: There is a discrepancy on the invoice.
	 */
	public static final SystemMessageId THERE_IS_A_DISCREPANCY_ON_THE_INVOICE;
	
	/**
	 * ID: 882<br>
	 * Message: ̐܂B<br>
	 * Message: &#31278;&#23376;&#25976;&#37327;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The seed quantity is incorrect.
	 */
	public static final SystemMessageId THE_SEED_QUANTITY_IS_INCORRECT;
	
	/**
	 * ID: 883<br>
	 * Message: ̏񂪐܂B<br>
	 * Message: &#31278;&#23376;&#24773;&#22577;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The seed information is incorrect.
	 */
	public static final SystemMessageId THE_SEED_INFORMATION_IS_INCORRECT;
	
	/**
	 * ID: 884<br>
	 * Message: ̏񂪐Vɐݒ肳܂B<br>
	 * Message: &#33674;&#22290;&#24773;&#22577;&#24050;&#37325;&#26032;&#35373;&#23450;&#12290;<br>
	 * Message: The manor information has been updated.
	 */
	public static final SystemMessageId THE_MANOR_INFORMATION_HAS_BEEN_UPDATED;
	
	/**
	 * ID: 885<br>
	 * Message: 앨̐܂B<br>
	 * Message: &#36786;&#20316;&#29289;&#25976;&#37327;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The number of crops is incorrect.
	 */
	public static final SystemMessageId THE_NUMBER_OF_CROPS_IS_INCORRECT;
	
	/**
	 * ID: 886<br>
	 * Message: 앨̉i񂪐܂B<br>
	 * Message: &#36786;&#20316;&#29289;&#20729;&#26684;&#24773;&#22577;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The crops are priced incorrectly.
	 */
	public static final SystemMessageId THE_CROPS_ARE_PRICED_INCORRECTLY;
	
	/**
	 * ID: 887<br>
	 * Message: ^Cv܂B<br>
	 * Message: &#39006;&#22411;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The type is incorrect.
	 */
	public static final SystemMessageId THE_TYPE_IS_INCORRECT;
	
	/**
	 * ID: 888<br>
	 * Message: w앨܂B<br>
	 * Message: &#27794;&#26377;&#21487;&#25910;&#36092;&#30340;&#36786;&#20316;&#29289;&#12290;<br>
	 * Message: No crops can be purchased at this time.
	 */
	public static final SystemMessageId NO_CROPS_CAN_BE_PURCHASED_AT_THIS_TIME;
	
	/**
	 * ID: 889<br>
	 * Message: ̐Atɐ܂B<br>
	 * Message: &#25773;&#31278;&#25104;&#21151;&#12290;<br>
	 * Message: The seed was successfully sown.
	 */
	public static final SystemMessageId THE_SEED_WAS_SUCCESSFULLY_SOWN;
	
	/**
	 * ID: 890<br>
	 * Message: ̐AtɎs܂B<br>
	 * Message: &#25773;&#31278;&#22833;&#25943;&#12290;<br>
	 * Message: The seed was not sown.
	 */
	public static final SystemMessageId THE_SEED_WAS_NOT_SOWN;
	
	/**
	 * ID: 891<br>
	 * Message: nɑ΂D挠܂B<br>
	 * Message: &#23565;&#25910;&#21106;&#27794;&#26377;&#20778;&#20808;&#27402;&#12290;<br>
	 * Message: You are not authorized to harvest.
	 */
	public static final SystemMessageId YOU_ARE_NOT_AUTHORIZED_TO_HARVEST;
	
	/**
	 * ID: 892<br>
	 * Message: nɎs܂B<br>
	 * Message: &#25910;&#21106;&#22833;&#25943;&#12290;<br>
	 * Message: The harvest has failed.
	 */
	public static final SystemMessageId THE_HARVEST_HAS_FAILED;
	
	/**
	 * ID: 893<br>
	 * Message: ̐AtԂAnɎs܂B<br>
	 * Message: &#27794;&#26377;&#25773;&#31278;&#65292;&#22240;&#27492;&#25910;&#21106;&#22833;&#25943;&#12290;<br>
	 * Message: The harvest failed because the seed was not sown.
	 */
	public static final SystemMessageId THE_HARVEST_FAILED_BECAUSE_THE_SEED_WAS_NOT_SOWN;
	
	/**
	 * ID: 894<br>
	 * Message: }$s1o^ł܂B<br>
	 * Message: &#35069;&#20316;&#21367;&#36600;&#21482;&#33021;&#30331;&#35352;&#21040;&#36;&#115;&#49;&#20491;&#12290;<br>
	 * Message: Up to $s1 recipes can be registered.
	 */
	public static final SystemMessageId UP_TO_S1_RECIPES_CAN_REGISTER;
	
	/**
	 * ID: 895<br>
	 * Message: o^ꂽ}܂B<br>
	 * Message: &#27794;&#26377;&#34987;&#30331;&#35352;&#30340;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: No recipes have been registered.
	 */
	public static final SystemMessageId NO_RECIPES_REGISTERED;
	
	/**
	 * ID: 896<br>
	 * Message: NGXg}͓o^ł܂B<br>
	 * Message: &#28961;&#27861;&#30331;&#35352;&#20219;&#21209;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: The ferry has arrived at Gludin Harbor.
	 */
	public static final SystemMessageId FERRY_AT_GLUDIN;
	
	/**
	 * ID: 897<br>
	 * Message: 萔܂B<br>
	 * Message: &#35069;&#20316;&#25163;&#32396;&#36027;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The ferry will leave for Talking Island Harbor after anchoring for ten minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_TALKING;
	
	/**
	 * ID: 898<br>
	 * Message: x10ȏɂȂȂƁA̐l𐄑E邱Ƃ͂ł܂B<br>
	 * Message: &#21482;&#26377;&#21040;&#31561;&#32026;&#49;&#48;&#20197;&#19978;&#65292;&#25165;&#33021;&#25512;&#34214;&#20182;&#20154;&#12290;<br>
	 * Message: Only characters of level 10 or above are authorized to make recommendations.
	 */
	public static final SystemMessageId ONLY_LEVEL_SUP_10_CAN_RECOMMEND;
	
	/**
	 * ID: 899<br>
	 * Message: lނƂł܂B<br>
	 * Message: &#28961;&#27861;&#21051;&#32011;&#31456;&#12290;<br>
	 * Message: The symbol cannot be drawn.
	 */
	public static final SystemMessageId CANT_DRAW_SYMBOL;
	
	/**
	 * ID: 900<br>
	 * Message: lޏꏊ܂B<br>
	 * Message: &#27794;&#26377;&#33021;&#21051;&#32011;&#31456;&#30340;&#27396;&#20301;&#12290;<br>
	 * Message: No slot exists to draw the symbol
	 */
	public static final SystemMessageId SYMBOLS_FULL;
	
	/**
	 * ID: 901<br>
	 * Message: l邱Ƃł܂B<br>
	 * Message: &#28961;&#27861;&#25214;&#21040;&#32011;&#31456;&#24773;&#22577;&#12290;<br>
	 * Message: The symbol information cannot be found.
	 */
	public static final SystemMessageId SYMBOL_NOT_FOUND;
	
	/**
	 * ID: 902<br>
	 * Message: ACe܂B<br>
	 * Message: &#36947;&#20855;&#25976;&#37327;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The number of items is incorrect.
	 */
	public static final SystemMessageId NUMBER_INCORRECT;
	
	/**
	 * ID: 903<br>
	 * Message: t[YԂł̓T|[gvs܂B΂炭҂B<br>
	 * Message: &#22312;&#20941;&#32080;&#29376;&#24907;&#19979;&#28961;&#27861;&#35380;&#27714;&#12290;&#35531;&#31245;&#20505;&#12290;<br>
	 * Message: You may not submit a petition while frozen. Be patient.
	 */
	public static final SystemMessageId NO_PETITION_WHILE_FROZEN;
	
	/**
	 * ID: 904<br>
	 * Message: lXJԂł̓ACêĂ܂B<br>
	 * Message: &#22312;&#20491;&#20154;&#21830;&#24215;&#29376;&#24907;&#19979;&#28961;&#27861;&#19999;&#26820;&#36947;&#20855;&#12290;<br>
	 * Message: Items cannot be discarded while in private store status.
	 */
	public static final SystemMessageId NO_DISCARD_WHILE_PRIVATE_STORE;
	
	/**
	 * ID: 905<br>
	 * Message: q[}̃XRA $s1_łB<br>
	 * Message: &#30446;&#21069;&#20154;&#39006;&#31278;&#26063;&#30340;&#24471;&#20998;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The current score for the Humans is $s1.
	 */
	public static final SystemMessageId HUMAN_SCORE_S1;
	
	/**
	 * ID: 906<br>
	 * Message: Gt̃XRA $s1_łB<br>
	 * Message: &#30446;&#21069;&#31934;&#38728;&#31278;&#26063;&#30340;&#24471;&#20998;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The current score for the Elves is $s1.
	 */
	public static final SystemMessageId ELVES_SCORE_S1;
	
	/**
	 * ID: 907<br>
	 * Message: _[NGt̃XRA $s1_łB<br>
	 * Message: &#30446;&#21069;&#40657;&#26263;&#31934;&#38728;&#31278;&#26063;&#30340;&#24471;&#20998;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The current score for the Dark Elves is $s1.
	 */
	public static final SystemMessageId DARK_ELVES_SCORE_S1;
	
	/**
	 * ID: 908<br>
	 * Message: I[ÑXRA $s1_łB<br>
	 * Message: &#30446;&#21069;&#21322;&#29560;&#20154;&#31278;&#26063;&#30340;&#24471;&#20998;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The current score for the Orcs is $s1.
	 */
	public static final SystemMessageId ORCS_SCORE_S1;
	
	/**
	 * ID: 909<br>
	 * Message: h[t̃XRA $s1_łB<br>
	 * Message: &#30446;&#21069;&#30702;&#20154;&#31278;&#26063;&#30340;&#24471;&#20998;&#26159;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The current score for the Dwarves is $s1.
	 */
	public static final SystemMessageId DWARVEN_SCORE_S1;
	
	/**
	 * ID: 910<br>
	 * Message: ݒnF $s1A$s2A$s3 (b铇̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#35498;&#35441;&#20043;&#23798;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near Talking Island Village)
	 */
	public static final SystemMessageId LOC_TI_S1_S2_S3;
	
	/**
	 * ID: 911<br>
	 * Message: ݒnF $s1A$s2A$s3 (O[fBt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#21476;&#39791;&#19969;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near Gludin Village)
	 */
	public static final SystemMessageId LOC_GLUDIN_S1_S2_S3;
	
	/**
	 * ID: 912<br>
	 * Message: ݒnF $s1A$s2A$s3 (O[fBȊt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#21476;&#39791;&#19969;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Town of Gludio)
	 */
	public static final SystemMessageId LOC_GLUDIO_S1_S2_S3;
	
	/**
	 * ID: 913<br>
	 * Message: ݒnF $s1A$s2A$s3 (nѕt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#20013;&#31435;&#22320;&#24118;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Neutral Zone)
	 */
	public static final SystemMessageId LOC_NEUTRAL_ZONE_S1_S2_S3;
	
	/**
	 * ID: 914<br>
	 * Message: ݒnF $s1A$s2A$s3 (Gtt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#31934;&#38728;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Elven Village)
	 */
	public static final SystemMessageId LOC_ELVEN_S1_S2_S3;
	
	/**
	 * ID: 915<br>
	 * Message: ݒnF $s1A$s2A$s3 (_[NGtt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#40657;&#26263;&#31934;&#38728;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Dark Elf Village)
	 */
	public static final SystemMessageId LOC_DARK_ELVEN_S1_S2_S3;
	
	/**
	 * ID: 916<br>
	 * Message: ݒnF $s1A$s2A$s3 (fBȊt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#29380;&#24681;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Town of Dion)
	 */
	public static final SystemMessageId LOC_DION_S1_S2_S3;
	
	/**
	 * ID: 917<br>
	 * Message: ݒnF $s1A$s2A$s3 (t[t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#33433;&#32645;&#34349;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Floran Village)
	 */
	public static final SystemMessageId LOC_FLORAN_S1_S2_S3;
	
	/**
	 * ID: 918<br>
	 * Message: ݒnF $s1A$s2A$s3 (M̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#22855;&#23721;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Town of Giran)
	 */
	public static final SystemMessageId LOC_GIRAN_S1_S2_S3;
	
	/**
	 * ID: 919<br>
	 * Message: ݒnF $s1A$s2A$s3 (M`t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#22855;&#23721;&#28207;&#21475;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near Giran Harbor)
	 */
	public static final SystemMessageId LOC_GIRAN_HARBOR_S1_S2_S3;
	
	/**
	 * ID: 920<br>
	 * Message: ݒnF $s1A$s2A$s3 (I[Nt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#21322;&#29560;&#20154;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Orc Village)
	 */
	public static final SystemMessageId LOC_ORC_S1_S2_S3;
	
	/**
	 * ID: 921<br>
	 * Message: ݒnF $s1A$s2A$s3 (h[tt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#30702;&#20154;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Dwarven Village)
	 */
	public static final SystemMessageId LOC_DWARVEN_S1_S2_S3;
	
	/**
	 * ID: 922<br>
	 * Message: ݒnF $s1A$s2A$s3 (I[̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#27472;&#29790;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Town of Oren)
	 */
	public static final SystemMessageId LOC_OREN_S1_S2_S3;
	
	/**
	 * ID: 923<br>
	 * Message: ݒnF $s1A$s2A$s3 (t̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#29557;&#20154;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near Hunters Village)
	 */
	public static final SystemMessageId LOC_HUNTER_S1_S2_S3;
	
	/**
	 * ID: 924<br>
	 * Message: ݒnF $s1A$s2A$s3 (Af̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#20126;&#19969;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near Aden Castle Town)
	 */
	public static final SystemMessageId LOC_ADEN_S1_S2_S3;
	
	/**
	 * ID: 925<br>
	 * Message: ݒnF $s1A$s2A$s3 (RVA)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#22823;&#22291;&#24418;&#31478;&#25216;&#22580;&#65118;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near the Coliseum)
	 */
	public static final SystemMessageId LOC_COLISEUM_S1_S2_S3;
	
	/**
	 * ID: 926<br>
	 * Message: ݒnF $s1A$s2A$s3 (nClXt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#28023;&#38899;&#26031;&#38468;&#36817;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (Near Heine)
	 */
	public static final SystemMessageId LOC_HEINE_S1_S2_S3;
	
	/**
	 * ID: 927<br>
	 * Message: ݂̎$s1$s2łB<br>
	 * Message: &#29694;&#22312;&#26159;&#30333;&#22825;&#12300;&#36;&#115;&#49;&#40670;&#36;&#115;&#50;&#20998;&#12301;&#12290;<br>
	 * Message: The current time is $s1:$s2.
	 */
	public static final SystemMessageId TIME_S1_S2_IN_THE_DAY;
	
	/**
	 * ID: 928<br>
	 * Message: ݂̎$s1$s2łB<br>
	 * Message: &#29694;&#22312;&#26159;&#22812;&#26202;&#12300;&#36;&#115;&#49;&#40670;&#36;&#115;&#50;&#20998;&#12301;&#12290;<br>
	 * Message: The current time is $s1:$s2.
	 */
	public static final SystemMessageId TIME_S1_S2_IN_THE_NIGHT;
	
	/**
	 * ID: 929<br>
	 * Message: 앨ɑ΂܂͏o܂łB<br>
	 * Message: &#23578;&#26410;&#20998;&#30332;&#23565;&#36786;&#20316;&#29289;&#30340;&#22577;&#37228;&#12290;<br>
	 * Message: No compensation was given for the farm products.
	 */
	public static final SystemMessageId NO_COMPENSATION_FOR_FARM_PRODUCTS;
	
	/**
	 * ID: 930<br>
	 * Message: ݁A󂭂̔̔sȂĂ܂B<br>
	 * Message: &#29694;&#22312;&#19981;&#26159;&#36009;&#36067;&#24425;&#21048;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: Lottery tickets are not currently being sold.
	 */
	public static final SystemMessageId NO_LOTTERY_TICKETS_CURRENT_SOLD;
	
	/**
	 * ID: 931<br>
	 * Message: 󂭂Iԍ͂܂\Ă܂B<br>
	 * Message: &#20013;&#29518;&#34399;&#30908;&#23578;&#26410;&#20844;&#21578;&#12290;<br>
	 * Message: The winning lottery ticket numbers has not yet been anonunced.
	 */
	public static final SystemMessageId LOTTERY_WINNERS_NOT_ANNOUNCED_YET;
	
	/**
	 * ID: 932<br>
	 * Message: ϐ풆̂߁Aʃ`bg͂ł܂B<br>
	 * Message: &#35264;&#25136;&#20013;&#28961;&#27861;&#36914;&#34892;&#19968;&#33324;&#32842;&#22825;&#12290;<br>
	 * Message: You cannot chat locally while observing.
	 */
	public static final SystemMessageId NO_ALLCHAT_WHILE_OBSERVING;
	
	/**
	 * ID: 933<br>
	 * Message: ̉i񂪐܂B<br>
	 * Message: &#31278;&#23376;&#20729;&#26684;&#24773;&#22577;&#20986;&#29694;&#30064;&#24120;&#12290;<br>
	 * Message: The seed pricing greatly differs from standard seed prices.
	 */
	public static final SystemMessageId THE_SEED_PRICING_GREATLY_DIFFERS_FROM_STANDARD_SEED_PRICES;
	
	/**
	 * ID: 934<br>
	 * Message: 폜ꂽ}łB<br>
	 * Message: &#24050;&#34987;&#21034;&#38500;&#30340;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: It is a deleted recipe.
	 */
	public static final SystemMessageId A_DELETED_RECIPE;
	
	/**
	 * ID: 935<br>
	 * Message: zŝ߁A삵܂B<br>
	 * Message: &#37329;&#38989;&#19981;&#36275;&#65292;&#28961;&#27861;&#21855;&#21205;&#33674;&#22290;&#12290;<br>
	 * Message: The amount is not sufficient and so the manor is not in operation.
	 */
	public static final SystemMessageId THE_AMOUNT_IS_NOT_SUFFICIENT_AND_SO_THE_MANOR_IS_NOT_IN_OPERATION;
	
	/**
	 * ID: 936<br>
	 * Message: $s1gp܂B<br>
	 * Message: &#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Use $s1.
	 */
	public static final SystemMessageId USE_S1_;
	
	/**
	 * ID: 937<br>
	 * Message: lH[̏łB<br>
	 * Message: &#20491;&#20154;&#24037;&#25151;&#27491;&#22312;&#28310;&#20633;&#20013;&#12290;<br>
	 * Message: Currently preparing for private workshop.
	 */
	public static final SystemMessageId PREPARING_PRIVATE_WORKSHOP;
	
	/**
	 * ID: 938<br>
	 * Message: ݁AR~jeB[ T[o[̓_łB<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#32173;&#20462;&#31038;&#32676;&#31995;&#32113;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: The community server is currently offline.
	 */
	public static final SystemMessageId CB_OFFLINE;
	
	/**
	 * ID: 939<br>
	 * Message: S̎ՒfԂȂ̂Ńg[hł܂B<br>
	 * Message: &#22312;&#20840;&#37096;&#38548;&#32085;&#29376;&#24907;&#19979;&#28961;&#27861;&#20132;&#26131;&#12290;<br>
	 * Message: You cannot exchange while blocking everything.
	 */
	public static final SystemMessageId NO_EXCHANGE_WHILE_BLOCKING;
	
	/**
	 * ID: 940<br>
	 * Message: $s1͑S̎ՒfԂłB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34389;&#26044;&#20840;&#37096;&#38548;&#32085;&#29376;&#24907;&#12290;<br>
	 * Message: $s1 is blocked everything.
	 */
	public static final SystemMessageId S1_BLOCKED_EVERYTHING;
	
	/**
	 * ID: 941<br>
	 * Message: b铇̑ŃX^[g܂B<br>
	 * Message: &#22312;&#35498;&#35441;&#20043;&#23798;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at Talking Island Village.
	 */
	public static final SystemMessageId RESTART_AT_TI;
	
	/**
	 * ID: 942<br>
	 * Message: O[fBŃX^[g܂B<br>
	 * Message: &#22312;&#21476;&#39791;&#19969;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at Gludin Village.
	 */
	public static final SystemMessageId RESTART_AT_GLUDIN;
	
	/**
	 * ID: 943<br>
	 * Message: O[fBȊŃX^[g܂B<br>
	 * Message: &#22312;&#21476;&#39791;&#19969;&#22478;&#37806;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Town of Gludin. || guess should be Gludio ;)
	 */
	public static final SystemMessageId RESTART_AT_GLUDIO;
	
	/**
	 * ID: 944<br>
	 * Message: nтŃX^[g܂B<br>
	 * Message: &#22312;&#20013;&#31435;&#22320;&#24118;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Neutral Zone.
	 */
	public static final SystemMessageId RESTART_AT_NEUTRAL_ZONE;
	
	/**
	 * ID: 945<br>
	 * Message: GtŃX^[g܂B<br>
	 * Message: &#22312;&#31934;&#38728;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Elven Village.
	 */
	public static final SystemMessageId RESTART_AT_ELFEN_VILLAGE;
	
	/**
	 * ID: 946<br>
	 * Message: _[NGtŃX^[g܂B<br>
	 * Message: &#22312;&#40657;&#26263;&#31934;&#38728;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Dark Elf Village.
	 */
	public static final SystemMessageId RESTART_AT_DARKELF_VILLAGE;
	
	/**
	 * ID: 947<br>
	 * Message: fBȊŃX^[g܂B<br>
	 * Message: &#22312;&#29380;&#24681;&#22478;&#37806;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Town of Dion.
	 */
	public static final SystemMessageId RESTART_AT_DION;
	
	/**
	 * ID: 948<br>
	 * Message: t[ŃX^[g܂B<br>
	 * Message: &#22312;&#33433;&#32645;&#34349;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at Floran Village.
	 */
	public static final SystemMessageId RESTART_AT_FLORAN;
	
	/**
	 * ID: 949<br>
	 * Message: M̑ŃX^[g܂B<br>
	 * Message: &#22312;&#22855;&#23721;&#22478;&#37806;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Town of Giran.
	 */
	public static final SystemMessageId RESTART_AT_GIRAN;
	
	/**
	 * ID: 950<br>
	 * Message: M`ŃX^[g܂B<br>
	 * Message: &#22312;&#22855;&#23721;&#28207;&#21475;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at Giran Harbor.
	 */
	public static final SystemMessageId RESTART_AT_GIRAN_HARBOR;
	
	/**
	 * ID: 951<br>
	 * Message: I[NŃX^[g܂B<br>
	 * Message: &#22312;&#21322;&#29560;&#20154;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Orc Village.
	 */
	public static final SystemMessageId RESTART_AT_ORC_VILLAGE;
	
	/**
	 * ID: 952<br>
	 * Message: h[tŃX^[g܂B<br>
	 * Message: &#22312;&#30702;&#20154;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Dwarven Village.
	 */
	public static final SystemMessageId RESTART_AT_DWARFEN_VILLAGE;
	
	/**
	 * ID: 953<br>
	 * Message: I[̑ŃX^[g܂B<br>
	 * Message: &#22312;&#27472;&#29790;&#22478;&#37806;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Town of Oren.
	 */
	public static final SystemMessageId RESTART_AT_OREN;
	
	/**
	 * ID: 954<br>
	 * Message: t̑ŃX^[g܂B<br>
	 * Message: &#22312;&#29557;&#20154;&#26449;&#33674;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at Hunters Village.
	 */
	public static final SystemMessageId RESTART_AT_HUNTERS_VILLAGE;
	
	/**
	 * ID: 955<br>
	 * Message: Af̑ŃX^[g܂B<br>
	 * Message: &#22312;&#20126;&#19969;&#22478;&#37806;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Town of Aden.
	 */
	public static final SystemMessageId RESTART_AT_ADEN;
	
	/**
	 * ID: 956<br>
	 * Message: RVAŃX^[g܂B<br>
	 * Message: &#22312;&#22823;&#22291;&#24418;&#31478;&#25216;&#22580;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at the Coliseum.
	 */
	public static final SystemMessageId RESTART_AT_COLISEUM;
	
	/**
	 * ID: 957<br>
	 * Message: nClXŃX^[g܂B<br>
	 * Message: &#22312;&#28023;&#38899;&#26031;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Restart at Heine.
	 */
	public static final SystemMessageId RESTART_AT_HEINE;
	
	/**
	 * ID: 958<br>
	 * Message: lXlH[̏ɁAACêĂ邱Ƃj󂷂邱Ƃ͂ł܂B<br>
	 * Message: &#22312;&#20491;&#20154;&#21830;&#24215;&#25110;&#20491;&#20154;&#24037;&#25151;&#20013;&#65292;&#28961;&#27861;&#19999;&#26820;&#25110;&#21034;&#38500;&#36947;&#20855;&#12290;<br>
	 * Message: Items cannot be discarded or destroyed while operating a private store or workshop.
	 */
	public static final SystemMessageId ITEMS_CANNOT_BE_DISCARDED_OR_DESTROYED_WHILE_OPERATING_PRIVATE_STORE_OR_WORKSHOP;
	
	/**
	 * ID: 959<br>
	 * Message: $s1i$s2j̐ɐ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#40;&#42;&#36;&#115;&#50;&#41;&#32;&#35069;&#20316;&#25104;&#21151;&#12290;<br>
	 * Message: $s1 (*$s2) manufactured successfully.
	 */
	public static final SystemMessageId S1_S2_MANUFACTURED_SUCCESSFULLY;
	
	/**
	 * ID: 960<br>
	 * Message: $s1̐Ɏs܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#35069;&#20316;&#22833;&#25943;&#12290;<br>
	 * Message: $s1 manufacturing failure.
	 */
	public static final SystemMessageId S1_MANUFACTURE_FAILURE;
	
	/**
	 * ID: 961<br>
	 * Message: ݑS̎ՒfԂłB<br>
	 * Message: &#30446;&#21069;&#34389;&#26044;&#20840;&#37096;&#38548;&#32085;&#29376;&#24907;&#12290;<br>
	 * Message: You are now blocking everything.
	 */
	public static final SystemMessageId BLOCKING_ALL;
	
	/**
	 * ID: 962<br>
	 * Message: S̎ՒfԂ܂B<br>
	 * Message: &#35299;&#38500;&#20102;&#20840;&#37096;&#38548;&#32085;&#29376;&#24907;&#12290;<br>
	 * Message: You are no longer blocking everything.
	 */
	public static final SystemMessageId NOT_BLOCKING_ALL;
	
	/**
	 * ID: 963<br>
	 * Message: 쉿i肵ĂB<br>
	 * Message: &#35531;&#27770;&#23450;&#35069;&#20316;&#20729;&#26684;&#12290;<br>
	 * Message: Please determine the manufacturing price.
	 */
	public static final SystemMessageId DETERMINE_MANUFACTURE_PRICE;
	
	/**
	 * ID: 964<br>
	 * Message: A`bgɂA1ԃ`bg֎~܂B<br>
	 * Message: &#23559;&#31105;&#27490;&#32842;&#22825;&#49;&#20998;&#37912;&#12290;<br>
	 * Message: Chatting is prohibited for one minute.
	 */
	public static final SystemMessageId CHATBAN_FOR_1_MINUTE;
	
	/**
	 * ID: 965<br>
	 * Message: `bg֎~܂B<br>
	 * Message: &#24050;&#35299;&#38500;&#31105;&#27490;&#32842;&#22825;&#12290;<br>
	 * Message: The chatting prohibition has been removed.
	 */
	public static final SystemMessageId CHATBAN_REMOVED;
	
	/**
	 * ID: 966<br>
	 * Message: `bg֎~łBOɃ`bg݂ꍇA܂ł̎Ԃ蒷Ȃ܂̂łӂB<br>
	 * Message: &#31105;&#27490;&#32842;&#22825;&#20013;&#12290;&#33509;&#22312;&#35299;&#38500;&#31105;&#27490;&#32842;&#22825;&#20043;&#21069;&#22039;&#35430;&#32842;&#22825;&#30340;&#35441;&#65292;&#23559;&#26371;&#24310;&#38263;&#32842;&#22825;&#31105;&#27490;&#26178;&#38291;&#12290;<br>
	 * Message: Chatting is currently prohibited. If you try to chat before the prohibition is removed, the prohibition time will become even longer.
	 */
	public static final SystemMessageId CHATTING_IS_CURRENTLY_PROHIBITED;
	
	/**
	 * ID: 967<br>
	 * Message: $c1 ̃p[eBUɉ܂BiACezFX|C܂߃_Ɂj<br>
	 * Message: &#35201;&#31572;&#25033;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#32068;&#38538;&#36992;&#35531;&#21966;&#65311;&#65288;&#25136;&#21033;&#21697;&#20998;&#37197;&#65306;&#21253;&#21547;&#33258;&#39636;&#35722;&#21270;&#38568;&#27231;&#20998;&#37197;&#65289;<br>
	 * Message: Do you accept $c1's party invitation? (Item Distribution: Random including spoil.)
	 */
	public static final SystemMessageId C1_PARTY_INVITE_RANDOM_INCLUDING_SPOIL;
	
	/**
	 * ID: 968<br>
	 * Message: $c1 ̃p[eBUɉ܂BiACezFԂɎ擾j<br>
	 * Message: &#35201;&#31572;&#25033;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#32068;&#38538;&#36992;&#35531;&#21966;&#65311;&#65288;&#25136;&#21033;&#21697;&#20998;&#37197;&#65306;&#25353;&#29031;&#38538;&#21729;&#38918;&#24207;&#20998;&#37197;&#65289;<br>
	 * Message: Do you accept $c1's party invitation? (Item Distribution: By Turn.)
	 */
	public static final SystemMessageId C1_PARTY_INVITE_BY_TURN;
	
	/**
	 * ID: 969<br>
	 * Message: $c1 ̃p[eBUɉ܂BiACezFX|C܂ߏԂɁj<br>
	 * Message: &#35201;&#31572;&#25033;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#32068;&#38538;&#36992;&#35531;&#21966;&#65311;&#65288;&#25136;&#21033;&#21697;&#20998;&#37197;&#65306;&#21253;&#21547;&#33258;&#39636;&#35722;&#21270;&#25353;&#38918;&#24207;&#20998;&#37197;&#65289;<br>
	 * Message: Do you accept $c1's party invitation? (Item Distribution: By Turn including spoil.)
	 */
	public static final SystemMessageId C1_PARTY_INVITE_BY_TURN_INCLUDING_SPOIL;
	
	/**
	 * ID: 970<br>
	 * Message: $c1$s2MPhC󂯂܂B<br>
	 * Message: &#34987;&#12300;&#36;&#99;&#49;&#12301;&#21560;&#21462;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#77;&#80;&#12290;<br>
	 * Message: $s2's MP has been drained by $c1.
	 */
	public static final SystemMessageId S2_MP_HAS_BEEN_DRAINED_BY_C1;
	
	/**
	 * ID: 971<br>
	 * Message: 255𒴂T|[gv͂ł܂B萔ł͂ZčēxvsȂĂB<br>
	 * Message: &#35380;&#27714;&#19981;&#21487;&#36229;&#36942;&#50;&#53;&#53;&#20491;&#23383;&#12290;<br>
	 * Message: Petitions cannot exceed 255 characters.
	 */
	public static final SystemMessageId PETITION_MAX_CHARS_255;
	
	/**
	 * ID: 972<br>
	 * Message: ybggpłȂACełB<br>
	 * Message: &#23541;&#29289;&#19981;&#21487;&#20351;&#29992;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: This pet cannot use this item.
	 */
	public static final SystemMessageId PET_CANNOT_USE_ITEM;
	
	/**
	 * ID: 973<br>
	 * Message: Ăʂ͈͓̔œ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#26082;&#26377;&#25976;&#37327;&#20197;&#20839;&#30340;&#25976;&#23383;&#12290;<br>
	 * Message: Please input no more than the number you have.
	 */
	public static final SystemMessageId INPUT_NO_MORE_YOU_HAVE;
	
	/**
	 * ID: 974<br>
	 * Message: \E Xg[̋zɐ܂B<br>
	 * Message: &#25628;&#39746;&#30707;&#25104;&#21151;&#22320;&#21560;&#25910;&#20102;&#38728;&#39746;&#12290;<br>
	 * Message: The soul crystal succeeded in absorbing a soul.
	 */
	public static final SystemMessageId SOUL_CRYSTAL_ABSORBING_SUCCEEDED;
	
	/**
	 * ID: 975<br>
	 * Message: \E Xg[̋zɎs܂B<br>
	 * Message: &#25628;&#39746;&#30707;&#21560;&#25910;&#38728;&#39746;&#22833;&#25943;&#12290;<br>
	 * Message: The soul crystal was not able to absorb a soul.
	 */
	public static final SystemMessageId SOUL_CRYSTAL_ABSORBING_FAILED;
	
	/**
	 * ID: 976<br>
	 * Message: \E Xg[̋Cɑςꂸӂ܂B<br>
	 * Message: &#25628;&#39746;&#30707;&#22240;&#23481;&#32013;&#19981;&#20102;&#38728;&#39746;&#20043;&#27683;&#65292;&#32780;&#30772;&#30862;&#20102;&#12290;<br>
	 * Message: The soul crystal broke because it was not able to endure the soul energy.
	 */
	public static final SystemMessageId SOUL_CRYSTAL_BROKE;
	
	/**
	 * ID: 977<br>
	 * Message: \E Xg[N̋zɎs܂B<br>
	 * Message: &#25628;&#39746;&#30707;&#30456;&#20114;&#29986;&#29983;&#20849;&#40180;&#24460;&#65292;&#23566;&#33268;&#21560;&#25910;&#38728;&#39746;&#22833;&#25943;&#12290;<br>
	 * Message: The soul crystals caused resonation and failed at absorbing a soul.
	 */
	public static final SystemMessageId SOUL_CRYSTAL_ABSORBING_FAILED_RESONATION;
	
	/**
	 * ID: 978<br>
	 * Message: \E Xg[̋zۂĂ܂B<br>
	 * Message: &#25628;&#39746;&#30707;&#25298;&#32085;&#21560;&#25910;&#38728;&#39746;&#12290;<br>
	 * Message: The soul crystal is refusing to absorb a soul.
	 */
	public static final SystemMessageId SOUL_CRYSTAL_ABSORBING_REFUSED;
	
	/**
	 * ID: 979<br>
	 * Message: b铇̍`ɓ܂B<br>
	 * Message: &#24050;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry arrived at Talking Island Harbor.
	 */
	public static final SystemMessageId FERRY_ARRIVED_AT_TALKING;
	
	/**
	 * ID: 980<br>
	 * Message: 10Ԃ̒┑AO[fBɏo܂B<br>
	 * Message: &#20572;&#27850;&#49;&#48;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Gludin Harbor after anchoring for ten minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_GLUDIN_AFTER_10_MINUTES;
	
	/**
	 * ID: 981<br>
	 * Message: 5ɘb铇̍`O[fB֏o܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Gludin Harbor in five minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_GLUDIN_IN_5_MINUTES;
	
	/**
	 * ID: 982<br>
	 * Message: 1ɘb铇̍`O[fB֏o܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Gludin Harbor in one minute.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_GLUDIN_IN_1_MINUTE;
	
	/**
	 * ID: 983<br>
	 * Message: D͋}łB<br>
	 * Message: &#35201;&#25645;&#20056;&#30340;&#26053;&#23458;&#35531;&#21450;&#26178;&#25645;&#20056;&#12290;<br>
	 * Message: Those wishing to ride should make haste to get on.
	 */
	public static final SystemMessageId MAKE_HASTE_GET_ON_BOAT;
	
	/**
	 * ID: 984<br>
	 * Message: ԂȂb铇̍`O[fB֏o܂B<br>
	 * Message: &#21363;&#23559;&#24478;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will be leaving soon for Gludin Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVE_SOON_FOR_GLUDIN;
	
	/**
	 * ID: 985<br>
	 * Message: b铇̍`O[fB֏o܂B<br>
	 * Message: &#24478;&#35498;&#35441;&#20043;&#23798;&#30340;&#28207;&#21475;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry is leaving for Gludin Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVING_FOR_GLUDIN;
	
	/**
	 * ID: 986<br>
	 * Message: O[fB`ɓ܂B<br>
	 * Message: &#24050;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry has arrived at Gludin Harbor.
	 */
	public static final SystemMessageId FERRY_ARRIVED_AT_GLUDIN;
	
	/**
	 * ID: 987<br>
	 * Message: 10Ԃ̒┑Ab铇ɏo܂B<br>
	 * Message: &#20572;&#27850;&#49;&#48;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Talking Island Harbor after anchoring for ten minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_TALKING_AFTER_10_MINUTES;
	
	/**
	 * ID: 988<br>
	 * Message: 5ɃO[fB`b铇֏o܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Talking Island Harbor in five minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_TALKING_IN_5_MINUTES;
	
	/**
	 * ID: 989<br>
	 * Message: 1ɃO[fB`b铇֏o܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Talking Island Harbor in one minute.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_TALKING_IN_1_MINUTE;
	
	/**
	 * ID: 990<br>
	 * Message: ԂȂO[fB`b铇֏o܂B<br>
	 * Message: &#21363;&#23559;&#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will be leaving soon for Talking Island Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVE_SOON_FOR_TALKING;
	
	/**
	 * ID: 991<br>
	 * Message: O[fB`b铇֏o܂B<br>
	 * Message: &#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry is leaving for Talking Island Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVING_FOR_TALKING;
	
	/**
	 * ID: 992<br>
	 * Message: M`ɓ܂B<br>
	 * Message: &#24050;&#25269;&#36948;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry has arrived at Giran Harbor.
	 */
	public static final SystemMessageId FERRY_ARRIVED_AT_GIRAN;
	
	/**
	 * ID: 993<br>
	 * Message: 10Ԓ┑AMɏo܂B<br>
	 * Message: &#20572;&#27850;&#49;&#48;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#21069;&#24448;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Giran Harbor after anchoring for ten minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_GIRAN_AFTER_10_MINUTES;
	
	/**
	 * ID: 994<br>
	 * Message: 5ɃM`ɏo܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#21069;&#24448;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Giran Harbor in five minutes.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_GIRAN_IN_5_MINUTES;
	
	/**
	 * ID: 995<br>
	 * Message: 1ɃM`ɏo܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#21069;&#24448;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Giran Harbor in one minute.
	 */
	public static final SystemMessageId FERRY_LEAVE_FOR_GIRAN_IN_1_MINUTE;
	
	/**
	 * ID: 996<br>
	 * Message: ܂ȂM`ɏo܂B<br>
	 * Message: &#21363;&#23559;&#24478;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#21069;&#24448;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will be leaving soon for Giran Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVE_SOON_FOR_GIRAN;
	
	/**
	 * ID: 997<br>
	 * Message: M`ɏo܂B<br>
	 * Message: &#23559;&#21069;&#24448;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry is leaving for Giran Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVING_FOR_GIRAN;
	
	/**
	 * ID: 998<br>
	 * Message: CihVD܂B10Ԓ┑܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#24050;&#25269;&#36948;&#12290;&#23559;&#20572;&#27850;&#49;&#48;&#20998;&#37912;&#12290;<br>
	 * Message: The Innadril pleasure boat has arrived. It will anchor for ten minutes.
	 */
	public static final SystemMessageId INNADRIL_BOAT_ANCHOR_10_MINUTES;
	
	/**
	 * ID: 999<br>
	 * Message: 5ɃCihVDo܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#23559;&#35201;&#20986;&#30332;&#12290;<br>
	 * Message: The Innadril pleasure boat will leave in five minutes.
	 */
	public static final SystemMessageId INNADRIL_BOAT_LEAVE_IN_5_MINUTES;
	
	/**
	 * ID: 1000<br>
	 * Message: 1ɃCihVDo܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#23559;&#35201;&#20986;&#30332;&#12290;<br>
	 * Message: The Innadril pleasure boat will leave in one minute.
	 */
	public static final SystemMessageId INNADRIL_BOAT_LEAVE_IN_1_MINUTE;
	
	/**
	 * ID: 1001<br>
	 * Message: ܂ȂCihVDo܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#39340;&#19978;&#23601;&#35201;&#20986;&#30332;&#12290;<br>
	 * Message: The Innadril pleasure boat will be leaving soon.
	 */
	public static final SystemMessageId INNADRIL_BOAT_LEAVE_SOON;
	
	/**
	 * ID: 1002<br>
	 * Message: CihVDo܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#23559;&#35201;&#20986;&#30332;&#12290;<br>
	 * Message: The Innadril pleasure boat is leaving.
	 */
	public static final SystemMessageId INNADRIL_BOAT_LEAVING;
	
	/**
	 * ID: 1003<br>
	 * Message: X^[ [X `Pbg̐Zł܂B<br>
	 * Message: &#28961;&#27861;&#32080;&#31639;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: Cannot possess a monster race ticket.
	 */
	public static final SystemMessageId CANNOT_POSSES_MONS_TICKET;
	
	/**
	 * ID: 1004<br>
	 * Message: AWg̋ɓo^܂B<br>
	 * Message: &#24050;&#30331;&#35352;&#26681;&#25818;&#22320;&#25293;&#36023;&#12290;<br>
	 * Message: You have registered for a clan hall auction.
	 */
	public static final SystemMessageId REGISTERED_FOR_CLANHALL;
	
	/**
	 * ID: 1005<br>
	 * Message: qɂɃAfi܂B<br>
	 * Message: &#22312;&#34880;&#30431;&#20489;&#24235;&#30340;&#37329;&#24163;&#19981;&#36275;&#12290;<br>
	 * Message: There is not enough adena in the clan hall warehouse.
	 */
	public static final SystemMessageId NOT_ENOUGH_ADENA_IN_CWH;
	
	/**
	 * ID: 1006<br>
	 * Message: AWg̋ɓD܂B<br>
	 * Message: &#24050;&#32147;&#25307;&#27161;&#20102;&#26681;&#25818;&#22320;&#25293;&#36023;&#12290;<br>
	 * Message: You have bid in a clan hall auction.
	 */
	public static final SystemMessageId BID_IN_CLANHALL_AUCTION;
	
	/**
	 * ID: 1007<br>
	 * Message: $s1̗\Io^ߐ؂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#38928;&#36093;&#30340;&#30331;&#35352;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The preliminary match registration of $s1 has finished.
	 */
	public static final SystemMessageId PRELIMINARY_REGISTRATION_OF_S1_FINISHED;
	
	/**
	 * ID: 1008<br>
	 * Message: 󕠏Ԃ̃XgC_[ɂ͏~ł܂B<br>
	 * Message: &#34389;&#26044;&#39138;&#39187;&#29376;&#24907;&#30340;&#24231;&#40845;&#65292;&#28961;&#27861;&#36914;&#34892;&#39438;&#20056;&#47;&#38477;&#19979;&#30340;&#21205;&#20316;&#12290;<br>
	 * Message: A hungry strider cannot be mounted or dismounted.
	 */
	public static final SystemMessageId HUNGRY_STRIDER_NOT_MOUNT;
	
	/**
	 * ID: 1009<br>
	 * Message: SԂł̓XgC_[ɏ邱Ƃł܂B<br>
	 * Message: &#22312;&#27515;&#20129;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#24231;&#40845;&#12290;<br>
	 * Message: A strider cannot be ridden when dead.
	 */
	public static final SystemMessageId STRIDER_CANT_BE_RIDDEN_WHILE_DEAD;
	
	/**
	 * ID: 1010<br>
	 * Message: SXgC_[ɏ邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#39438;&#20056;&#27515;&#20129;&#30340;&#24231;&#40845;&#12290;<br>
	 * Message: A dead strider cannot be ridden.
	 */
	public static final SystemMessageId DEAD_STRIDER_CANT_BE_RIDDEN;
	
	/**
	 * ID: 1011<br>
	 * Message: 퓬̃XgC_[ɏ邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#39438;&#20056;&#25136;&#39717;&#20013;&#30340;&#24231;&#40845;&#12290;<br>
	 * Message: A strider in battle cannot be ridden.
	 */
	public static final SystemMessageId STRIDER_IN_BATLLE_CANT_BE_RIDDEN;
	
	/**
	 * ID: 1012<br>
	 * Message: 퓬̓XgC_[ɏ邱Ƃł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#39438;&#20056;&#24231;&#40845;&#12290;<br>
	 * Message: A strider cannot be ridden while in battle.
	 */
	public static final SystemMessageId STRIDER_CANT_BE_RIDDEN_WHILE_IN_BATTLE;
	
	/**
	 * ID: 1013<br>
	 * Message: ĂԂ̃XgC_[ɏ邱Ƃł܂B<br>
	 * Message: &#21482;&#33021;&#22312;&#31449;&#31435;&#30340;&#29376;&#24907;&#19979;&#65292;&#25165;&#21487;&#39438;&#20056;&#24231;&#40845;&#12290;<br>
	 * Message: A strider can be ridden only when standing.
	 */
	public static final SystemMessageId STRIDER_CAN_BE_RIDDEN_ONLY_WHILE_STANDING;
	
	/**
	 * ID: 1014<br>
	 * Message: ybg$s1̌ol𓾂܂B<br>
	 * Message: &#23541;&#29289;&#29554;&#24471;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#32147;&#39511;&#20540;&#12290;<br>
	 * Message: Your pet gained $s1 experience points.
	 */
	public static final SystemMessageId PET_EARNED_S1_EXP;
	
	/**
	 * ID: 1015<br>
	 * Message: ybg$s1̃_[W^܂B<br>
	 * Message: &#23541;&#29289;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: Your pet hit for $s1 damage.
	 */
	public static final SystemMessageId PET_HIT_FOR_S1_DAMAGE;
	
	/**
	 * ID: 1016<br>
	 * Message: ybg$c1ɂ$s2̃_[W󂯂܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#65292;&#23541;&#29289;&#36973;&#21040;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: Pet received $s2 damage by $c1.
	 */
	public static final SystemMessageId PET_RECEIVED_S2_DAMAGE_BY_C1;
	
	/**
	 * ID: 1017<br>
	 * Message: ybg̃NeBJ qbgI<br>
	 * Message: &#23541;&#29289;&#30340;&#33268;&#21629;&#25915;&#25802;&#65281;<br>
	 * Message: Pet's critical hit!
	 */
	public static final SystemMessageId CRITICAL_HIT_BY_PET;
	
	/**
	 * ID: 1018<br>
	 * Message: ybg$s1gp܂B<br>
	 * Message: &#23541;&#29289;&#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your pet uses $s1.
	 */
	public static final SystemMessageId PET_USES_S1;
	
	/**
	 * ID: 1019<br>
	 * Message: ybg$s1gp܂B<br>
	 * Message: &#23541;&#29289;&#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your pet uses $s1.
	 */
	public static final SystemMessageId PET_USES_S1_;
	
	/**
	 * ID: 1020<br>
	 * Message: ybg$s1𓾂܂B<br>
	 * Message: &#23541;&#29289;&#25791;&#36215;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your pet picked up $s1.
	 */
	public static final SystemMessageId PET_PICKED_S1;
	
	/**
	 * ID: 1021<br>
	 * Message: ybg$s1 $s2𓾂܂B<br>
	 * Message: &#23541;&#29289;&#25791;&#36215;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your pet picked up $s2 $s1(s).
	 */
	public static final SystemMessageId PET_PICKED_S2_S1_S;
	
	/**
	 * ID: 1022<br>
	 * Message: ybg+$s1$s2𓾂܂B<br>
	 * Message: &#23541;&#29289;&#25791;&#36215;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Your pet picked up +$s1 $s2.
	 */
	public static final SystemMessageId PET_PICKED_S1_S2;
	
	/**
	 * ID: 1023<br>
	 * Message: ybg$s1Afi𓾂܂B<br>
	 * Message: &#23541;&#29289;&#25791;&#36215;&#12300;&#36;&#115;&#49;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: Your pet picked up $s1 adena.
	 */
	public static final SystemMessageId PET_PICKED_S1_ADENA;
	
	/**
	 * ID: 1024<br>
	 * Message: ybg$s1𑕔܂B<br>
	 * Message: &#23541;&#29289;&#35037;&#20633;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your pet put on $s1.
	 */
	public static final SystemMessageId PET_PUT_ON_S1;
	
	/**
	 * ID: 1025<br>
	 * Message: ybg$s1̑܂B<br>
	 * Message: &#23541;&#29289;&#35299;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#35037;&#20633;&#12290;<br>
	 * Message: Your pet took off $s1.
	 */
	public static final SystemMessageId PET_TOOK_OFF_S1;
	
	/**
	 * ID: 1026<br>
	 * Message: b$s1̃_[W^܂B<br>
	 * Message: &#20351;&#39764;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: The summoned monster gave damage of $s1
	 */
	public static final SystemMessageId SUMMON_GAVE_DAMAGE_S1;
	
	/**
	 * ID: 1027<br>
	 * Message: b$c1ɂ$s2̃_[W󂯂܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#65292;&#20351;&#39764;&#36973;&#21040;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: Servitor received $s2 damage caused by $s1.
	 */
	public static final SystemMessageId SUMMON_RECEIVED_DAMAGE_S2_BY_S1;
	
	/**
	 * ID: 1028<br>
	 * Message: b̃NeBJ qbgI<br>
	 * Message: &#20351;&#39764;&#30340;&#33268;&#21629;&#25915;&#25802;&#65281;<br>
	 * Message: Summoned monster's critical hit!
	 */
	public static final SystemMessageId CRITICAL_HIT_BY_SUMMONED_MOB;
	
	/**
	 * ID: 1029<br>
	 * Message: b$s1gp܂B<br>
	 * Message: &#20351;&#39764;&#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Summoned monster uses $s1.
	 */
	public static final SystemMessageId SUMMONED_MOB_USES_S1;
	
	/**
	 * ID: 1030<br>
	 * Message: =======<p[eB>=======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#38538;&#20237;&#36039;&#35338;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: <Party Information>
	 */
	public static final SystemMessageId PARTY_INFORMATION;
	
	/**
	 * ID: 1031<br>
	 * Message: ^CvF ElL<br>
	 * Message: &#20998;&#37197;&#39006;&#22411;&#65306;&#25342;&#36215;&#20154;&#25152;&#26377;<br>
	 * Message: Looting method: Finders keepers
	 */
	public static final SystemMessageId LOOTING_FINDERS_KEEPERS;
	
	/**
	 * ID: 1032<br>
	 * Message: ^CvF _ɕz<br>
	 * Message: &#20998;&#37197;&#39006;&#22411;&#65306;&#38538;&#21729;&#38568;&#27231;&#20998;&#37197;<br>
	 * Message: Looting method: Random
	 */
	public static final SystemMessageId LOOTING_RANDOM;
	
	/**
	 * ID: 1033<br>
	 * Message: ^CvF X|C܂߃_<br>
	 * Message: &#20998;&#37197;&#39006;&#22411;&#65306;&#21253;&#21547;&#33258;&#39636;&#35722;&#21270;&#38568;&#27231;&#20998;&#37197;<br>
	 * Message: Looting method: Random including spoil
	 */
	public static final SystemMessageId LOOTING_RANDOM_INCLUDE_SPOIL;
	
	/**
	 * ID: 1034<br>
	 * Message: ^CvF ԂɎ擾<br>
	 * Message: &#20998;&#37197;&#39006;&#22411;&#65306;&#25353;&#29031;&#38538;&#21729;&#38918;&#24207;<br>
	 * Message: Looting method: By turn
	 */
	public static final SystemMessageId LOOTING_BY_TURN;
	
	/**
	 * ID: 1035<br>
	 * Message: ^CvF X|C܂ߏԂ<br>
	 * Message: &#20998;&#37197;&#39006;&#22411;&#65306;&#21253;&#21547;&#33258;&#39636;&#35722;&#21270;&#38918;&#24207;&#20998;&#37197;<br>
	 * Message: Looting method: By turn including spoil
	 */
	public static final SystemMessageId LOOTING_BY_TURN_INCLUDE_SPOIL;
	
	/**
	 * ID: 1036<br>
	 * Message: ͉\Ȑʂ𒴉߂܂B<br>
	 * Message: &#24050;&#36229;&#36942;&#21487;&#20197;&#36664;&#20837;&#30340;&#25976;&#37327;&#12290;<br>
	 * Message: You have exceeded the quantity that can be inputted.
	 */
	public static final SystemMessageId YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED;
	
	/**
	 * ID: 1037<br>
	 * Message: $c1$s2𐻍삵܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#35069;&#20316;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 manufactured $s2.
	 */
	public static final SystemMessageId C1_MANUFACTURED_S2;
	
	/**
	 * ID: 1038<br>
	 * Message: $c1$s2 $s3𐻍삵܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#35069;&#20316;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 manufactured $s3 $s2(s).
	 */
	public static final SystemMessageId C1_MANUFACTURED_S3_S2_S;
	
	/**
	 * ID: 1039<br>
	 * Message: qɂɗaACe͌̂ݎo\łBł낵łB<br>
	 * Message: &#23492;&#23384;&#22312;&#34880;&#30431;&#20489;&#24235;&#30340;&#36947;&#20855;&#65292;&#21482;&#33021;&#30001;&#34880;&#30431;&#30431;&#20027;&#21462;&#22238;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: Items left at the clan hall warehouse can only be retrieved by the clan leader. Do you want to continue?
	 */
	public static final SystemMessageId ONLY_CLAN_LEADER_CAN_RETRIEVE_ITEMS_FROM_CLAN_WAREHOUSE;
	
	/**
	 * ID: 1040<br>
	 * Message: gbsO ACe͑Sn̋Ȅlo܂B낵łB<br>
	 * Message: &#30332;&#36865;&#30340;&#32173;&#20182;&#21629;&#36947;&#20855;&#21487;&#36879;&#36942;&#25152;&#26377;&#22320;&#21312;&#30340;&#32173;&#20182;&#21629;&#31649;&#29702;&#32773;&#21462;&#22238;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: Items sent by freight can be picked up from any Warehouse location. Do you want to continue?
	 */
	public static final SystemMessageId ITEMS_SENT_BY_FREIGHT_PICKED_UP_FROM_ANYWHERE;
	
	/**
	 * ID: 1041<br>
	 * Message: ̎̍w$s1AfiłB<br>
	 * Message: &#19979;&#27425;&#31278;&#23376;&#30340;&#36092;&#36023;&#37329;&#38989;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#12290;<br>
	 * Message: The next seed purchase price is $s1 adena.
	 */
	public static final SystemMessageId THE_NEXT_SEED_PURCHASE_PRICE_IS_S1_ADENA;
	
	/**
	 * ID: 1042<br>
	 * Message: ̍앨̔̔$s1AfiłB<br>
	 * Message: &#19979;&#27425;&#36786;&#20316;&#29289;&#30340;&#25910;&#36092;&#37329;&#38989;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#12290;<br>
	 * Message: The next farm goods purchase price is $s1 adena.
	 */
	public static final SystemMessageId THE_NEXT_FARM_GOODS_PURCHASE_PRICE_IS_S1_ADENA;
	
	/**
	 * ID: 1043<br>
	 * Message: ݁Au/escapevR}h͎gpł܂BT|[gvsȂĂB<br>
	 * Message: &#29694;&#22312;&#26178;&#21051;&#28961;&#27861;&#22039;&#35430;&#12300;&#47;&#33067;&#36867;&#12301;&#25351;&#20196;&#12290;&#35531;&#30003;&#35531;&#35380;&#27714;&#12290;<br>
	 * Message: At the current time, the "/unstuck" command cannot be used. Please send in a petition.
	 */
	public static final SystemMessageId NO_UNSTUCK_PLEASE_SEND_PETITION;
	
	/**
	 * ID: 1044<br>
	 * Message: `Pbg̔̓X^[ [X̔z\邱Ƃł܂B<br>
	 * Message: &#36009;&#36067;&#31080;&#21048;&#26178;&#65292;&#28961;&#27861;&#26597;&#30475;&#24618;&#29289;&#31478;&#36093;&#36064;&#29575;&#12290;<br>
	 * Message: Monster race payout information is not available while tickets are being sold.
	 */
	public static final SystemMessageId MONSRACE_NO_PAYOUT_INFO;
	
	/**
	 * ID: 1046<br>
	 * Message: ̔IAX^[ [X̃`Pbgwł܂B<br>
	 * Message: &#31080;&#21048;&#36009;&#36067;&#32080;&#26463;&#65292;&#22240;&#27492;&#28961;&#27861;&#36092;&#36023;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: Monster race tickets are no longer available.
	 */
	public static final SystemMessageId MONSRACE_TICKETS_NOT_AVAILABLE;
	
	/**
	 * ID: 1047<br>
	 * Message: $s1̃ACeɎs܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36947;&#20855;&#35069;&#20316;&#22833;&#25943;&#12290;<br>
	 * Message: We did not succeed in producing $s1 item.
	 */
	public static final SystemMessageId NOT_SUCCEED_PRODUCING_S1;
	
	/**
	 * ID: 1048<br>
	 * Message: S̎ՒfԂȂ̂ŃEBXp[gpł܂B<br>
	 * Message: &#22312;&#20840;&#37096;&#38548;&#32085;&#29376;&#24907;&#19979;&#28961;&#27861;&#20351;&#29992;&#23494;&#35486;&#12290;<br>
	 * Message: When "blocking" everything, whispering is not possible.
	 */
	public static final SystemMessageId NO_WHISPER_WHEN_BLOCKING;
	
	/**
	 * ID: 1049<br>
	 * Message: S̎ՒfԂȂ̂Ńp[eB[̏҂ł܂B<br>
	 * Message: &#22312;&#20840;&#37096;&#38548;&#32085;&#29376;&#24907;&#19979;&#28961;&#27861;&#36992;&#35531;&#21152;&#20837;&#38538;&#20237;&#12290;<br>
	 * Message: When "blocking" everything, it is not possible to send invitations for organizing parties.
	 */
	public static final SystemMessageId NO_PARTY_WHEN_BLOCKING;
	
	/**
	 * ID: 1050<br>
	 * Message: ̌R~jeB[܂B̑_͑咷VK˂Č̃x2ȏɏグ΃R~jeB[܂B<br>
	 * Message: &#27794;&#26377;&#25105;&#26041;&#34880;&#30431;&#30340;&#31038;&#32676;&#31995;&#32113;&#12290;&#22914;&#26524;&#21435;&#25214;&#26449;&#33674;&#30340;&#23447;&#24107;&#12289;&#22823;&#31070;&#23448;&#25110;&#22823;&#38263;&#32769;&#23559;&#34880;&#30431;&#31561;&#32026;&#25552;&#21319;&#33267;&#50;&#20197;&#19978;&#65292;&#23601;&#21487;&#21109;&#20986;&#31038;&#32676;&#31995;&#32113;&#12290;<br>
	 * Message: There are no communities in my clan. Clan communities are allowed for clans with skill levels of 2 and higher.
	 */
	public static final SystemMessageId NO_CB_IN_MY_CLAN;
	
	/**
	 * ID: 1051<br>
	 * Message: AWg̎gpx܂łB$s1܂łɎgpqɂɂ[߂B<br>
	 * Message: &#23578;&#26410;&#32371;&#32013;&#26681;&#25818;&#22320;&#20351;&#29992;&#36027;&#12290;&#35531;&#22312;&#26126;&#22825;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#20197;&#21069;&#23559;&#20351;&#29992;&#36027;&#23384;&#20837;&#34880;&#30431;&#20489;&#24235;&#12290;<br>
	 * Message: Payment for your clan hall has not been made please make payment tomorrow.
	 */
	public static final SystemMessageId PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW;
	
	/**
	 * ID: 1052<br>
	 * Message: AWggpTԑؔ[߃AWgԊ҂܂B<br>
	 * Message: &#26681;&#25818;&#22320;&#20351;&#29992;&#36027;&#32371;&#32013;&#26399;&#38480;&#36229;&#36942;&#19968;&#20491;&#26143;&#26399;&#65292;&#22240;&#32780;&#26681;&#25818;&#22320;&#34987;&#22238;&#25910;&#12290;<br>
	 * Message: Payment of Clan Hall is overdue the owner loose Clan Hall.
	 */
	public static final SystemMessageId THE_CLAN_HALL_FEE_IS_ONE_WEEK_OVERDUE_THEREFORE_THE_CLAN_HALL_OWNERSHIP_HAS_BEEN_REVOKED;
	
	/**
	 * ID: 1053<br>
	 * Message: U풆̐ł͕ł܂B<br>
	 * Message: &#22312;&#36914;&#34892;&#25915;&#22478;&#25136;&#30340;&#25136;&#22580;&#19978;&#65292;&#28961;&#27861;&#24489;&#27963;&#12290;<br>
	 * Message: It is not possible to resurrect in battlefields where a siege war is taking place.
	 */
	public static final SystemMessageId CANNOT_BE_RESURRECTED_DURING_SIEGE;
	
	/**
	 * ID: 1054<br>
	 * Message: _̋CɖGAɓ܂B<br>
	 * Message: &#36914;&#20837;&#20102;&#21547;&#26377;&#31070;&#22855;&#21147;&#37327;&#30340;&#21312;&#22495;&#12290;<br>
	 * Message: You have entered a mystical land.
	 */
	public static final SystemMessageId ENTERED_MYSTICAL_LAND;
	
	/**
	 * ID: 1055<br>
	 * Message: _̋CɖGA痣܂B<br>
	 * Message: &#33067;&#38626;&#20102;&#21547;&#26377;&#31070;&#22855;&#21147;&#37327;&#30340;&#21312;&#22495;&#12290;<br>
	 * Message: You have left a mystical land.
	 */
	public static final SystemMessageId EXITED_MYSTICAL_LAND;
	
	/**
	 * ID: 1056<br>
	 * Message: ̋ɂɕۊǂłAfǐxz𒴂܂B<br>
	 * Message: &#33021;&#23384;&#22312;&#22478;&#20839;&#37329;&#24235;&#30340;&#37329;&#24163;&#24050;&#36229;&#36942;&#38480;&#21046;&#12290;<br>
	 * Message: You have exceeded the storage capacity of the castle's vault.
	 */
	public static final SystemMessageId VAULT_CAPACITY_EXCEEDED;
	
	/**
	 * ID: 1057<br>
	 * Message: bNX T[o[ł̂ݎgp\ȃR}hłB<br>
	 * Message: &#21482;&#33021;&#22312;&#32233;&#34909;&#20282;&#26381;&#22120;&#25165;&#33021;&#20351;&#29992;&#30340;&#25351;&#20196;&#12290;<br>
	 * Message: This command can only be used in the relax server.
	 */
	public static final SystemMessageId RELAX_SERVER_ONLY;
	
	/**
	 * ID: 1058<br>
	 * Message: ̔̔$s1AfiłB<br>
	 * Message: &#31278;&#23376;&#30340;&#36009;&#36067;&#37329;&#38989;&#28858;&#36;&#115;&#49;&#37329;&#24163;&#12290;<br>
	 * Message: The sales price for seeds is $s1 adena.
	 */
	public static final SystemMessageId THE_SALES_PRICE_FOR_SEEDS_IS_S1_ADENA;
	
	/**
	 * ID: 1059<br>
	 * Message: c̔$s1AfiłB<br>
	 * Message: &#21097;&#19979;&#30340;&#25910;&#36092;&#37329;&#38989;&#28858;&#36;&#115;&#49;&#37329;&#24163;&#12290;<br>
	 * Message: The remaining purchasing amount is $s1 adena.
	 */
	public static final SystemMessageId THE_REMAINING_PURCHASING_IS_S1_ADENA;
	
	/**
	 * ID: 1060<br>
	 * Message: ̔Ďcz$s1AfiłB<br>
	 * Message: &#36009;&#36067;&#31278;&#23376;&#24460;&#21097;&#19979;&#30340;&#37329;&#38989;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#12290;<br>
	 * Message: The remainder after selling the seeds is $s1.
	 */
	public static final SystemMessageId THE_REMAINDER_AFTER_SELLING_THE_SEEDS_IS_S1;
	
	/**
	 * ID: 1061<br>
	 * Message: ACeXLȂ߁A}o^ł܂B<br>
	 * Message: &#27794;&#26377;&#35069;&#20316;&#36947;&#20855;&#25216;&#33021;&#65292;&#25152;&#20197;&#28961;&#27861;&#30331;&#35352;&#35069;&#20316;&#21367;&#36600;&#12290;<br>
	 * Message: The recipe cannot be registered. You do not have the ability to create items.
	 */
	public static final SystemMessageId CANT_REGISTER_NO_ABILITY_TO_CRAFT;
	
	/**
	 * ID: 1062<br>
	 * Message: VK쐬̓x10\łB<br>
	 * Message: &#24478;&#31561;&#32026;&#49;&#48;&#38283;&#22987;&#25165;&#21487;&#20197;&#23531;&#26032;&#25991;&#31456;&#12290;<br>
	 * Message: Writing something new is possible after level 10.
	 */
	public static final SystemMessageId WRITING_SOMETHING_NEW_POSSIBLE_AFTER_LEVEL_10;
	
	/**
	 * ID: 1063<br>
	 * if you become trapped or unable to move, please use the '/unstuck' command.
	 */
	public static final SystemMessageId PETITION_UNAVAILABLE;
	
	/**
	 * ID: 1064<br>
	 * Message: +$s1$s2̑܂B<br>
	 * Message: &#35299;&#38500;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#35037;&#20633;&#12290;<br>
	 * Message: The equipment, +$s1 $s2, has been removed.
	 */
	public static final SystemMessageId EQUIPMENT_S1_S2_REMOVED;
	
	/**
	 * ID: 1065<br>
	 * Message: lXlH[̏ꍇAACêĂ邱Ƃg[h邱Ƃ͂ł܂B<br>
	 * Message: &#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#25110;&#65292;&#20491;&#20154;&#24037;&#25151;&#26178;&#65292;&#28961;&#27861;&#19999;&#26820;&#65292;&#21034;&#38500;&#65292;&#20132;&#26131;&#29289;&#21697;&#12290;<br>
	 * Message: While operating a private store or workshop, you cannot discard, destroy, or trade an item.
	 */
	public static final SystemMessageId CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE;
	
	/**
	 * ID: 1066<br>
	 * Message: $s1HP񕜂܂B<br>
	 * Message: &#24674;&#24489;&#72;&#80;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 HP has been restored.
	 */
	public static final SystemMessageId S1_HP_RESTORED;
	
	/**
	 * ID: 1067<br>
	 * Message: $c1ɂHP$s2񕜂܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#24674;&#24489;&#72;&#80;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s2 HP has been restored by $c1
	 */
	public static final SystemMessageId S2_HP_RESTORED_BY_C1;
	
	/**
	 * ID: 1068<br>
	 * Message: MP$s1񕜂܂B<br>
	 * Message: &#24674;&#24489;&#77;&#80;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 MP has been restored.
	 */
	public static final SystemMessageId S1_MP_RESTORED;
	
	/**
	 * ID: 1069<br>
	 * Message: $c1ɂMP$s2񕜂܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#24674;&#24489;&#77;&#80;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s2 MP has been restored by $c1.
	 */
	public static final SystemMessageId S2_MP_RESTORED_BY_C1;
	
	/**
	 * ID: 1070<br>
	 * Message: ǂݍ݌܂B<br>
	 * Message: &#27794;&#26377;&#35712;&#21462;&#30340;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have 'read' permission.
	 */
	public static final SystemMessageId NO_READ_PERMISSION;
	
	/**
	 * ID: 1071<br>
	 * Message: ݌܂B<br>
	 * Message: &#27794;&#26377;&#23531;&#30340;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have 'write' permission.
	 */
	public static final SystemMessageId NO_WRITE_PERMISSION;
	
	/**
	 * ID: 1072<br>
	 * Message: $s1ڃX^[[X̒P`Pbg󂯎܂B<br>
	 * Message: &#29554;&#24471;&#21934;&#21213;&#45;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#32;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: You have obtained a ticket for the Monster Race #$s1 - Single
	 */
	public static final SystemMessageId OBTAINED_TICKET_FOR_MONS_RACE_S1_SINGLE;
	
	/**
	 * ID: 1073<br>
	 * Message: $s1ڃX^[[X̘A`Pbg󂯎܂B<br>
	 * Message: &#29554;&#24471;&#35079;&#21213;&#45;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#32;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: You have obtained a ticket for the Monster Race #$s1 - Single
	 */
	public static final SystemMessageId OBTAINED_TICKET_FOR_MONS_RACE_S1_SINGLE_;
	
	/**
	 * ID: 1074<br>
	 * Message: NŃX^[ [X̃`Pbgwł܂B<br>
	 * Message: &#22240;&#24180;&#40801;&#38480;&#21046;&#65292;&#28961;&#27861;&#36092;&#36023;&#24618;&#29289;&#36093;&#31080;&#12290;<br>
	 * Message: You do not meet the age requirement to purchase a Monster Race Ticket.
	 */
	public static final SystemMessageId NOT_MEET_AGE_REQUIREMENT_FOR_MONS_RACE;
	
	/**
	 * ID: 1075<br>
	 * Message: ēDi͊̓Di荂ݒ肵ĂB<br>
	 * Message: &#20877;&#25307;&#27161;&#20729;&#35201;&#27604;&#20043;&#21069;&#25307;&#27161;&#20729;&#39640;&#12290;<br>
	 * Message: The bid amount must be higher than the previous bid.
	 */
	public static final SystemMessageId BID_AMOUNT_HIGHER_THAN_PREVIOUS_BID;
	
	/**
	 * ID: 1076<br>
	 * Message: Q[Ił܂B<br>
	 * Message: &#28961;&#27861;&#32080;&#26463;&#36938;&#25138;&#12290;<br>
	 * Message: The game cannot be terminated at this time.
	 */
	public static final SystemMessageId GAME_CANNOT_TERMINATE_NOW;
	
	/**
	 * ID: 1077<br>
	 * Message: GameGuard̃G[łB<br>
	 * Message: &#71;&#97;&#109;&#101;&#71;&#117;&#97;&#114;&#100;&#22519;&#34892;&#30064;&#24120;&#12290;&#35531;&#23559;&#71;&#97;&#109;&#101;&#71;&#117;&#97;&#114;&#100;&#27284;&#26696;&#35041;&#30340;&#32;&#42;&#46;&#101;&#114;&#108;&#32;&#27284;&#26696;&#32;&#23492;&#21040;&#103;&#97;&#109;&#101;&#64;&#105;&#110;&#99;&#97;&#46;&#99;&#111;&#46;&#107;&#114;&#12290;<br>
	 * Message: A GameGuard Execution error has occurred. Please send the *.erl file(s) located in the GameGuard folder to game@inca.co.kr
	 */
	public static final SystemMessageId GG_EXECUTION_ERROR;
	
	/**
	 * ID: 1078<br>
	 * Message: ZԂŏde̔𑽗ʂɓ͂ƎIɃ`bg֎~ɂȂ܂̂ŁAӂB<br>
	 * Message: &#22240;&#20351;&#29992;&#37749;&#30436;&#36664;&#20837;&#27425;&#25976;&#36942;&#22810;&#65292;&#21028;&#23450;&#28858;&#27927;&#30059;&#38754;&#12290;&#35531;&#21247;&#22312;&#30701;&#26178;&#38291;&#20839;&#36664;&#20837;&#22810;&#27425;&#25991;&#23383;&#65292;&#35613;&#35613;&#65281;<br>
	 * Message: When a user's keyboard input exceeds a certain cumulative score a chat ban will be applied. This is done to discourage spamming. Please avoid posting the same message multiple times during a short period.
	 */
	public static final SystemMessageId DONT_SPAM;
	
	/**
	 * ID: 1079<br>
	 * Message: 肪`bg֎~łB<br>
	 * Message: &#23565;&#26041;&#31105;&#35328;&#29376;&#24907;&#12290;<br>
	 * Message: The target is currently banend from chatting.
	 */
	public static final SystemMessageId TARGET_IS_CHAT_BANNED;
	
	/**
	 * ID: 1080<br>
	 * Message: tFCX^Cṽ|[VFAgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#25972;&#24418;&#34277;&#27700;&#45;&#65;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the facelift potion - Type A?
	 */
	public static final SystemMessageId FACELIFT_POTION_TYPE_A;
	
	/**
	 * ID: 1081<br>
	 * Message: wAJ[̃|[VFAgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#65;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the hair dye potion - Type A?
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_A;
	
	/**
	 * ID: 1082<br>
	 * Message: wAX^C̃|[VFAgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#65;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type A? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_A;
	
	/**
	 * ID: 1083<br>
	 * Message: tFCX^Cṽ|[VFAgp܂B<br>
	 * Message: &#20351;&#29992;&#25972;&#22411;&#34277;&#27700;&#45;&#65;&#12290;<br>
	 * Message: Facelift potion - Type A is being applied.
	 */
	public static final SystemMessageId FACELIFT_POTION_TYPE_A_APPLIED;
	
	/**
	 * ID: 1084<br>
	 * Message: wAJ[̃|[VFAgp܂B<br>
	 * Message: &#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#65;&#12290;<br>
	 * Message: Hair dye potion - Type A is being applied.
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_A_APPLIED;
	
	/**
	 * ID: 1085<br>
	 * Message: wAX^C̃|[VFAgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#65;&#12290;<br>
	 * Message: The hair style chance potion - Type A is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_A_USED;
	
	/**
	 * ID: 1086<br>
	 * Message: tFCX^CvύX܂B<br>
	 * Message: &#33225;&#30340;&#24418;&#29376;&#25913;&#35722;&#20102;&#12290;<br>
	 * Message: Your facial appearance has been changed.
	 */
	public static final SystemMessageId FACE_APPEARANCE_CHANGED;
	
	/**
	 * ID: 1087<br>
	 * Message: wAJ[ύX܂B<br>
	 * Message: &#38957;&#39662;&#38991;&#33394;&#25913;&#35722;&#20102;&#12290;<br>
	 * Message: Your hair color has changed.
	 */
	public static final SystemMessageId HAIR_COLOR_CHANGED;
	
	/**
	 * ID: 1088<br>
	 * Message: wAX^CύX܂B<br>
	 * Message: &#38957;&#30340;&#24418;&#29376;&#25913;&#35722;&#20102;&#12290;<br>
	 * Message: Your hair style has been changed.
	 */
	public static final SystemMessageId HAIR_STYLE_CHANGED;
	
	/**
	 * ID: 1089<br>
	 * Message: $c1 1NLOACe𓾂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#49;&#36913;&#24180;&#30340;&#32000;&#24565;&#21697;&#12290;<br>
	 * Message: $c1 has obtained a first anniversary commemorative item.
	 */
	public static final SystemMessageId C1_OBTAINED_ANNIVERSARY_ITEM;
	
	/**
	 * ID: 1090<br>
	 * Message: tFCX^Cṽ|[VFBgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#25972;&#24418;&#34277;&#27700;&#45;&#66;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the facelift potion - Type B?
	 */
	public static final SystemMessageId FACELIFT_POTION_TYPE_B;
	
	/**
	 * ID: 1091<br>
	 * Message: tFCX^Cṽ|[VFCgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#25972;&#24418;&#34277;&#27700;&#45;&#67;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the facelift potion - Type C?
	 */
	public static final SystemMessageId FACELIFT_POTION_TYPE_C;
	
	/**
	 * ID: 1092<br>
	 * Message: wAJ[̃|[VFBgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#66;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the hair dye potion - Type B?
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_B;
	
	/**
	 * ID: 1093<br>
	 * Message: wAJ[̃|[VFCgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#67;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the hair dye potion - Type C?
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_C;
	
	/**
	 * ID: 1094<br>
	 * Message: wAJ[̃|[VFDgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#68;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Being permanent, are you sure you wish to use the hair dye potion - Type D?
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_D;
	
	/**
	 * ID: 1095<br>
	 * Message: wAX^C̃|[VFBgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#66;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type B? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_B;
	
	/**
	 * ID: 1096<br>
	 * Message: wAX^C̃|[VFCgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#67;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type C? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_C;
	
	/**
	 * ID: 1097<br>
	 * Message: wAX^C̃|[VFDgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#68;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type D? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_D;
	
	/**
	 * ID: 1098<br>
	 * Message: wAX^C̃|[VFEgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#69;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type E? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_E;
	
	/**
	 * ID: 1099<br>
	 * Message: wAX^C̃|[VFFgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#70;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type F? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_F;
	
	/**
	 * ID: 1100<br>
	 * Message: wAX^C̃|[VFGgp܂Bgp̌ʂ͉ivɎ܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#71;&#21966;&#65311;&#20351;&#29992;&#24460;&#25928;&#26524;&#26371;&#27704;&#20037;&#20445;&#25345;&#12290;<br>
	 * Message: Do you wish to use the hair style change potion - Type G? It is permanent.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_G;
	
	/**
	 * ID: 1101<br>
	 * Message: tFCX^Cṽ|[VFBgp܂B<br>
	 * Message: &#20351;&#29992;&#25972;&#24418;&#34277;&#27700;&#45;&#66;&#12290;<br>
	 * Message: Facelift potion - Type B is being applied.
	 */
	public static final SystemMessageId FACELIFT_POTION_TYPE_B_APPLIED;
	
	/**
	 * ID: 1102<br>
	 * Message: tFCX^Cṽ|[VFCgp܂B<br>
	 * Message: &#20351;&#29992;&#25972;&#24418;&#34277;&#27700;&#45;&#67;&#12290;<br>
	 * Message: Facelift potion - Type C is being applied.
	 */
	public static final SystemMessageId FACELIFT_POTION_TYPE_C_APPLIED;
	
	/**
	 * ID: 1103<br>
	 * Message: wAJ[̃|[VFBgp܂B<br>
	 * Message: &#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#66;&#12290;<br>
	 * Message: Hair dye potion - Type B is being applied.
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_B_APPLIED;
	
	/**
	 * ID: 1104<br>
	 * Message: wAJ[̃|[VFCgp܂B<br>
	 * Message: &#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#67;&#12290;<br>
	 * Message: Hair dye potion - Type C is being applied.
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_C_APPLIED;
	
	/**
	 * ID: 1105<br>
	 * Message: wAJ[̃|[VFDgp܂B<br>
	 * Message: &#20351;&#29992;&#26579;&#39662;&#34277;&#27700;&#45;&#68;&#12290;<br>
	 * Message: Hair dye potion - Type D is being applied.
	 */
	public static final SystemMessageId HAIRDYE_POTION_TYPE_D_APPLIED;
	
	/**
	 * ID: 1106<br>
	 * Message: wAX^C̃|[VFBgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#66;&#12290;<br>
	 * Message: The hair style chance potion - Type B is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_B_USED;
	
	/**
	 * ID: 1107<br>
	 * Message: wAX^C̃|[VFCgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#67;&#12290;<br>
	 * Message: The hair style chance potion - Type C is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_C_USED;
	
	/**
	 * ID: 1108<br>
	 * Message: wAX^C̃|[VFDgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#68;&#12290;<br>
	 * Message: The hair style chance potion - Type D is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_D_USED;
	
	/**
	 * ID: 1109<br>
	 * Message: wAX^C̃|[VFEgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#69;&#12290;<br>
	 * Message: The hair style chance potion - Type E is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_E_USED;
	
	/**
	 * ID: 1110<br>
	 * Message: wAX^C̃|[VFFgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#70;&#12290;<br>
	 * Message: The hair style chance potion - Type F is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_F_USED;
	
	/**
	 * ID: 1111<br>
	 * Message: wAX^C̃|[VFGgp܂B<br>
	 * Message: &#20351;&#29992;&#36896;&#22411;&#34277;&#27700;&#45;&#71;&#12290;<br>
	 * Message: The hair style chance potion - Type G is being used.
	 */
	public static final SystemMessageId HAIRSTYLE_POTION_TYPE_G_USED;
	
	/**
	 * ID: 1112<br>
	 * Message: $s1ڕ󂭂̓Iz$s2AfiŁA$s3l1ɓI܂B<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#27138;&#36879;&#30340;&#29518;&#37329;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#37329;&#24163;&#20849;&#12300;&#36;&#115;&#51;&#12301;&#21517;&#29554;&#24471;&#38957;&#29518;&#12290;<br>
	 * Message: The prize amount for the winner of Lottery #$s1 is $s2 adena. We have $s3 first prize winners.
	 */
	public static final SystemMessageId AMOUNT_FOR_WINNER_S1_IS_S2_ADENA_WE_HAVE_S3_PRIZE_WINNER;
	
	/**
	 * ID: 1113<br>
	 * Message: $s1ڕ󂭂̓Iz$s2AfiłAzI҂Ȃ߁AǏJz܂B<br>
	 * Message: &#31532;&#12300;&#36;&#115;&#49;&#12301;&#22238;&#27138;&#36879;&#29518;&#37329;&#26159;&#12300;&#36;&#115;&#50;&#12301;&#37329;&#24163;&#65292;&#22240;&#28858;&#27794;&#26377;&#38283;&#20986;&#38957;&#29518;&#65292;&#22240;&#27492;&#23559;&#26371;&#32047;&#31309;&#21040;&#19979;&#19968;&#22238;&#12290;<br>
	 * Message: The prize amount for Lucky Lottery #$s1 is $s2 adena. There was no first prize winner in this drawing, therefore the jackpot will be added to the next drawing.
	 */
	public static final SystemMessageId AMOUNT_FOR_LOTTERY_S1_IS_S2_ADENA_NO_WINNER;
	
	/**
	 * ID: 1114<br>
	 * Message: UP\Ԓ͍Uɓo^ł܂B<br>
	 * Message: &#35299;&#25955;&#23532;&#38480;&#26399;&#20839;&#65292;&#28961;&#27861;&#30331;&#35352;&#25915;&#22478;&#25136;&#12290;<br>
	 * Message: Your clan may not register to participate in a siege while under a grace period of the clan's dissolution.
	 */
	public static final SystemMessageId CANT_PARTICIPATE_IN_SIEGE_WHILE_DISSOLUTION_IN_PROGRESS;
	
	/**
	 * ID: 1115<br>
	 * Message: 퓬͌l~邱Ƃ͂ł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#20491;&#20154;&#25237;&#38477;&#12290;<br>
	 * Message: Individuals may not surrender during combat.
	 */
	public static final SystemMessageId INDIVIDUALS_NOT_SURRENDER_DURING_COMBAT;
	
	/**
	 * ID: 1116<br>
	 * Message: 퓬͌Eނł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#33067;&#38626;&#34880;&#30431;&#12290;<br>
	 * Message: One cannot leave one's clan during combat.
	 */
	public static final SystemMessageId YOU_CANNOT_LEAVE_DURING_COMBAT;
	
	/**
	 * ID: 1117<br>
	 * Message: 퓬̌Ǖ邱Ƃ͂ł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#38283;&#38500;&#30431;&#21729;&#12290;<br>
	 * Message: A clan member may not be dismissed during combat.
	 */
	public static final SystemMessageId CLAN_MEMBER_CANNOT_BE_DISMISSED_DURING_COMBAT;
	
	/**
	 * ID: 1118<br>
	 * Message: Cxg̏dʂ܂͌80̎̂ݐisł܂B<br>
	 * Message: &#36947;&#20855;&#30340;&#37325;&#37327;&#47;&#25976;&#37327;&#20302;&#26044;&#56;&#48;&#37;&#26178;&#25165;&#21487;&#36914;&#34892;&#12290;<br>
	 * Message: Progress in a quest is possible only when your inventory's weight and volume are less than 80 percent of capacity.
	 */
	public static final SystemMessageId INVENTORY_LESS_THAN_80_PERCENT;
	
	/**
	 * ID: 1119<br>
	 * Message: NGXg̐isɍsȂȂ󋵂ŃNGXĝ݂ŁANGXgIɎ܂B<br>
	 * Message: &#35430;&#22294;&#36914;&#34892;&#30064;&#24120;&#21205;&#20316;&#65292;&#22240;&#27492;&#20219;&#21209;&#23559;&#33258;&#21205;&#21462;&#28040;&#12290;<br>
	 * Message: Quest was automatically canceled when you attempted to settle the accounts of your quest while your inventory exceeded 80 percent of capacity.
	 */
	public static final SystemMessageId QUEST_CANCELED_INVENTORY_EXCEEDS_80_PERCENT;
	
	/**
	 * ID: 1120<br>
	 * Message: Eނł܂łB<br>
	 * Message: &#26410;&#33021;&#33067;&#38626;&#34880;&#30431;&#12290;<br>
	 * Message: You are still a member of the clan.
	 */
	public static final SystemMessageId STILL_CLAN_MEMBER;
	
	/**
	 * ID: 1121<br>
	 * Message: E܂B<br>
	 * Message: &#27794;&#26377;&#25512;&#34214;&#27402;&#12290;<br>
	 * Message: You do not have the right to vote.
	 */
	public static final SystemMessageId NO_RIGHT_TO_VOTE;
	
	/**
	 * ID: 1122<br>
	 * Message: E鑊肪݂܂B<br>
	 * Message: &#25512;&#34214;&#30340;&#23565;&#35937;&#19981;&#23384;&#22312;&#12290;<br>
	 * Message: There is no candidate.
	 */
	public static final SystemMessageId NO_CANDIDATE;
	
	/**
	 * ID: 1123<br>
	 * Message: Cxg̏dʂ܂͌zĂ邽߁ÃXL͎gpł܂B<br>
	 * Message: &#36947;&#20855;&#28165;&#21934;&#30340;&#37325;&#37327;&#47;&#25976;&#30446;&#36229;&#36942;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#35442;&#25216;&#33021;&#12290;<br>
	 * Message: Weight and volume limit has been exceeded. That skill is currently unavailable.
	 */
	public static final SystemMessageId WEIGHT_EXCEEDED_SKILL_UNAVAILABLE;
	
	/**
	 * ID: 1124<br>
	 * Message: XLgp̂߁AACeEBhEJƂł܂B<br>
	 * Message: &#20351;&#29992;&#25216;&#33021;&#20013;&#28961;&#27861;&#20351;&#29992;&#35069;&#20316;&#21367;&#36600;&#26360;&#31821;&#12290;<br>
	 * Message: Your recipe book may not be accessed while using a skill.
	 */
	public static final SystemMessageId NO_RECIPE_BOOK_WHILE_CASTING;
	
	/**
	 * ID: 1125<br>
	 * Message: g[h͐ł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#28961;&#27861;&#35069;&#20316;&#12290;<br>
	 * Message: An item may not be created while engaged in trading.
	 */
	public static final SystemMessageId CANNOT_CREATED_WHILE_ENGAGED_IN_TRADING;
	
	/**
	 * ID: 1126<br>
	 * Message: }CiX̒l͓͂ł܂B<br>
	 * Message: &#28961;&#27861;&#36664;&#20837;&#30340;&#36000;&#25976;&#20729;&#26684;&#12290;<br>
	 * Message: You cannot enter a negative number.
	 */
	public static final SystemMessageId NO_NEGATIVE_NUMBER;
	
	/**
	 * ID: 1127<br>
	 * Message: {i10{ȏ̉i͐ݒł܂B<br>
	 * Message: &#28961;&#27861;&#35373;&#23450;&#36229;&#36942;&#22522;&#28310;&#20729;&#49;&#48;&#20493;&#20197;&#19978;&#30340;&#22577;&#37228;&#12290;<br>
	 * Message: The reward must be less than 10 times the standard price.
	 */
	public static final SystemMessageId REWARD_LESS_THAN_10_TIMES_STANDARD_PRICE;
	
	/**
	 * ID: 1128<br>
	 * Message: XLgp̂߁AlXlH[JƂł܂B<br>
	 * Message: &#20351;&#29992;&#25216;&#33021;&#20013;&#28961;&#27861;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#20197;&#21450;&#20491;&#20154;&#24037;&#25151;&#12290;<br>
	 * Message: A private store may not be opened while using a skill.
	 */
	public static final SystemMessageId PRIVATE_STORE_NOT_WHILE_CASTING;
	
	/**
	 * ID: 1129<br>
	 * Message: D̂߁A̍s͂ł܂łB<br>
	 * Message: &#25645;&#23450;&#26399;&#33337;&#26178;&#19981;&#33021;&#20570;&#30340;&#21205;&#20316;&#12290;<br>
	 * Message: This is not allowed while riding a ferry or boat.
	 */
	public static final SystemMessageId NOT_ALLOWED_ON_BOAT;
	
	/**
	 * ID: 1130<br>
	 * Message: $s1̃_[W^A_[W̓]ڑΏۂ$s2̃_[W^܂B<br>
	 * Message: &#21521;&#23565;&#26041;&#21152;&#20197;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#20663;&#23475;&#65292;&#21521;&#36681;&#31227;&#20663;&#23475;&#30340;&#30446;&#27161;&#21152;&#20197;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: You have given $s1 damage to your target and $s2 damage to the servitor.
	 */
	public static final SystemMessageId GIVEN_S1_DAMAGE_TO_YOUR_TARGET_AND_S2_DAMAGE_TO_SERVITOR;
	
	/**
	 * ID: 1131<br>
	 * Message: [ɂȂ߁A$s1̌ʂ܂B<br>
	 * Message: &#21040;&#20102;&#21320;&#22812;&#65292;&#24863;&#35258;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#12290;<br>
	 * Message: It is now midnight and the effect of $s1 can be felt.
	 */
	public static final SystemMessageId NIGHT_EFFECT_APPLIES;
	
	/**
	 * ID: 1132<br>
	 * Message: 邪߁A$s1̌ʂ܂B<br>
	 * Message: &#21040;&#20102;&#22825;&#20142;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#28040;&#22833;&#12290;<br>
	 * Message: It is now dawn and the effect of $s1 will now disappear.
	 */
	public static final SystemMessageId DAY_EFFECT_DISAPPEARS;
	
	/**
	 * ID: 1133<br>
	 * Message: HP߁A$s1̌ʂ܂B<br>
	 * Message: &#22240;&#28858;&#72;&#80;&#36942;&#20302;&#65292;&#24863;&#21463;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#12290;<br>
	 * Message: Since HP has decreased, the effect of $s1 can be felt.
	 */
	public static final SystemMessageId HP_DECREASED_EFFECT_APPLIES;
	
	/**
	 * ID: 1134<br>
	 * Message: HP߁A$s1̌ʂ܂B<br>
	 * Message: &#22240;&#28858;&#72;&#80;&#24674;&#24489;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25928;&#26524;&#28040;&#22833;&#12290;<br>
	 * Message: Since HP has increased, the effect of $s1 will disappear.
	 */
	public static final SystemMessageId HP_INCREASED_EFFECT_DISAPPEARS;
	
	/**
	 * ID: 1135<br>
	 * Message: 퓬ɌlXJƂ͂ł܂B<br>
	 * Message: &#25136;&#39717;&#20013;&#28961;&#27861;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#20197;&#21450;&#20491;&#20154;&#24037;&#25151;<br>
	 * Message: While you are engaged in combat, you cannot operate a private store or private workshop.
	 */
	public static final SystemMessageId CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT;
	
	/**
	 * ID: 1136<br>
	 * Message: sȃANZX݂IPAhX̂߁A$s1Ԃ̃T[o[ɐڑł܂Bʂ̃T[o[pB<br>
	 * Message: &#27492;&#73;&#80;&#20301;&#22336;&#20351;&#29992;&#38750;&#27861;&#36899;&#32080;&#26041;&#24335;&#30331;&#20837;&#36938;&#25138;&#24115;&#34399;&#65292;&#25152;&#20197;&#23559;&#26377;&#19968;&#20998;&#37912;&#28961;&#27861;&#36914;&#20837;&#27492;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: Since there was an account that used this IP and attempted to log in illegally, this account is not allowed to connect to the game server for $s1 minutes. Please use another game server.
	 */
	public static final SystemMessageId ACCOUNT_NOT_ALLOWED_TO_CONNECT;
	
	/**
	 * ID: 1137<br>
	 * Message: $c1 $s2 $s3n܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25910;&#21106;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 harvested $s3 $s2(s).
	 */
	public static final SystemMessageId C1_HARVESTED_S3_S2S;
	
	/**
	 * ID: 1138<br>
	 * Message: $c1$s2n܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25910;&#21106;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 harvested $s2(s).
	 */
	public static final SystemMessageId C1_HARVESTED_S2S;
	
	/**
	 * ID: 1139<br>
	 * Message: Cxg̑dʂXbg̐𒴂邱Ƃ͂ł܂B<br>
	 * Message: &#19981;&#33021;&#36229;&#36942;&#36947;&#20855;&#28165;&#21934;&#30340;&#37325;&#37327;&#47;&#25976;&#30446;&#38480;&#21046;&#12290;<br>
	 * Message: The weight and volume limit of your inventory must not be exceeded.
	 */
	public static final SystemMessageId INVENTORY_LIMIT_MUST_NOT_BE_EXCEEDED;
	
	/**
	 * ID: 1140<br>
	 * Message: J܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#38283;&#38272;&#21966;&#65311;<br>
	 * Message: Would you like to open the gate?
	 */
	public static final SystemMessageId WOULD_YOU_LIKE_TO_OPEN_THE_GATE;
	
	/**
	 * ID: 1141<br>
	 * Message: ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#38364;&#38272;&#21966;&#65311;<br>
	 * Message: Would you like to close the gate?
	 */
	public static final SystemMessageId WOULD_YOU_LIKE_TO_CLOSE_THE_GATE;
	
	/**
	 * ID: 1142<br>
	 * Message: ߂ɂł$s1邽߁Adďł܂B<br>
	 * Message: &#38468;&#36817;&#24050;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#25152;&#20197;&#28961;&#27861;&#36914;&#34892;&#21484;&#21914;&#12290;<br>
	 * Message: Since $s1 already exists nearby, you cannot summon it again.
	 */
	public static final SystemMessageId CANNOT_SUMMON_S1_AGAIN;
	
	/**
	 * ID: 1143<br>
	 * Message: b̈ێɕKvȃACeȂ߁AbĂ܂܂B<br>
	 * Message: &#22240;&#32173;&#25345;&#21484;&#21914;&#20351;&#39764;&#30340;&#36947;&#20855;&#19981;&#36275;&#65292;&#21484;&#21914;&#20351;&#39764;&#23559;&#26371;&#28040;&#22833;&#12290;<br>
	 * Message: Since you do not have enough items to maintain the servitor's stay, the servitor will disappear.
	 */
	public static final SystemMessageId SERVITOR_DISAPPEARED_NOT_ENOUGH_ITEMS;
	
	/**
	 * ID: 1144<br>
	 * Message: Q[ɑΘb肪܂B<br>
	 * Message: &#36938;&#25138;&#20839;&#27794;&#26377;&#32842;&#22825;&#23565;&#35937;&#12290;<br>
	 * Message: Currently, you don't have anybody to chat with in the game.
	 */
	public static final SystemMessageId NOBODY_IN_GAME_TO_CHAT;
	
	/**
	 * ID: 1145<br>
	 * Message: $c1 $s2 $s3 AfiŐ삵܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#51;&#12301;&#37329;&#24163;&#30340;&#37228;&#21214;&#65292;&#28858;&#12300;&#36;&#99;&#49;&#12301;&#35069;&#20316;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s2 has been created for $c1 after the payment of $s3 adena is received.
	 */
	public static final SystemMessageId S2_CREATED_FOR_C1_FOR_S3_ADENA;
	
	/**
	 * ID: 1146<br>
	 * Message: $c1 $s2 $s3 AfiŐ삵܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#20197;&#12300;&#36;&#115;&#51;&#12301;&#37329;&#24163;&#20316;&#28858;&#20195;&#24037;&#36027;&#65292;&#28858;&#24744;&#35069;&#20316;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 created $s2 after receiving $s3 adena.
	 */
	public static final SystemMessageId C1_CREATED_S2_FOR_S3_ADENA;
	
	/**
	 * ID: 1147<br>
	 * Message: $c1 $s2 $s3 $s4AfiŐ삵܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#52;&#12301;&#37329;&#24163;&#30340;&#37228;&#21214;&#65292;&#28858;&#12300;&#36;&#99;&#49;&#12301;&#35069;&#20316;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s2 $s3 have been created for $c1 at the price of $s4 adena.
	 */
	public static final SystemMessageId S2_S3_S_CREATED_FOR_C1_FOR_S4_ADENA;
	
	/**
	 * ID: 1148<br>
	 * Message: $c1 $s2 $s3 $s4AfiŐ삵܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#20197;&#12300;&#36;&#115;&#52;&#12301;&#37329;&#24163;&#28858;&#20195;&#24037;&#36027;&#65292;&#28858;&#24744;&#35069;&#20316;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 created $s2 $s3 at the price of $s4 adena.
	 */
	public static final SystemMessageId C1_CREATED_S2_S3_S_FOR_S4_ADENA;
	
	/**
	 * ID: 1149<br>
	 * Message: $c1 $s2 $s3 AfiŐł܂łB<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#51;&#12301;&#37329;&#24163;&#30340;&#20195;&#24037;&#36027;&#24460;&#65292;&#28858;&#12300;&#36;&#99;&#49;&#12301;&#35069;&#20316;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#65292;&#32080;&#26524;&#21371;&#36973;&#22833;&#25943;&#12290;<br>
	 * Message: Your attempt to create $s2 for $c1 at the price of $s3 adena has failed.
	 */
	public static final SystemMessageId CREATION_OF_S2_FOR_C1_AT_S3_ADENA_FAILED;
	
	/**
	 * ID: 1150<br>
	 * Message: $c1 $s2 $s3 AfiŐł܂łB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#20197;&#12300;&#36;&#115;&#51;&#12301;&#37329;&#24163;&#20316;&#28858;&#20195;&#24037;&#36027;&#35069;&#20316;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#65292;&#32080;&#26524;&#21371;&#36973;&#22833;&#25943;&#12290;<br>
	 * Message: $c1 has failed to create $s2 at the price of $s3 adena.
	 */
	public static final SystemMessageId C1_FAILED_TO_CREATE_S2_FOR_S3_ADENA;
	
	/**
	 * ID: 1151<br>
	 * Message: $c1 $s2 $s3 AfiŔ̔܂B<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#50;&#12301;&#20197;&#12300;&#36;&#115;&#51;&#12301;&#37329;&#24163;&#36067;&#32102;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: $s2 is sold to $c1 at the price of $s3 adena.
	 */
	public static final SystemMessageId S2_SOLD_TO_C1_FOR_S3_ADENA;
	
	/**
	 * ID: 1152<br>
	 * Message: $c1 $s2 $s3 $s4 AfiŔ̔܂B<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#20197;&#12300;&#36;&#115;&#52;&#12301;&#37329;&#24163;&#36067;&#32102;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: $s2 $s3 have been sold to $c1 for $s4 adena.
	 */
	public static final SystemMessageId S3_S2_S_SOLD_TO_C1_FOR_S4_ADENA;
	
	/**
	 * ID: 1153<br>
	 * Message: $c1 $s2 $s3 Afiōw܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#20197;&#12300;&#36;&#115;&#51;&#12301;&#37329;&#24163;&#36092;&#36023;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s2 has been purchased from $c1 at the price of $s3 adena.
	 */
	public static final SystemMessageId S2_PURCHASED_FROM_C1_FOR_S3_ADENA;
	
	/**
	 * ID: 1154<br>
	 * Message: $c1 $s2 $s3 $s4 Afiōw܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#20197;&#12300;&#36;&#115;&#52;&#12301;&#37329;&#24163;&#36092;&#36023;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s3 $s2 has been purchased from $c1 for $s4 adena.
	 */
	public static final SystemMessageId S3_S2_S_PURCHASED_FROM_C1_FOR_S4_ADENA;
	
	/**
	 * ID: 1155<br>
	 * Message: $c1 +$s2$s3 $s4 AfiŔ̔܂B<br>
	 * Message: &#23559;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#20197;&#12300;&#36;&#115;&#52;&#12301;&#37329;&#24163;&#36067;&#32102;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: +$s2 $s3 have been sold to $c1 for $s4 adena.
	 */
	public static final SystemMessageId S3_S2_SOLD_TO_C1_FOR_S4_ADENA;
	
	/**
	 * ID: 1156<br>
	 * Message: $c1 +$s2$s3 $s4 Afiōw܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#20197;&#12300;&#36;&#115;&#52;&#12301;&#37329;&#24163;&#36092;&#36023;&#20102;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: +$s2 $s3 has been purchased from $c1 for $s4 adena.
	 */
	public static final SystemMessageId S2_S3_PURCHASED_FROM_C1_FOR_S4_ADENA;
	
	/**
	 * ID: 1157<br>
	 * Message: ͖10bԂŁAԂ̕ωƎꍇ܂B<br>
	 * Message: &#35430;&#31359;&#23559;&#26371;&#25345;&#32396;&#49;&#48;&#31186;&#65292;&#29376;&#24907;&#33509;&#26377;&#35722;&#21270;&#26178;&#65292;&#23559;&#26371;&#31435;&#21051;&#21462;&#28040;&#12290;<br>
	 * Message: Trying on state lasts for only 5 seconds. When a character's state changes, it can be cancelled.
	 */
	public static final SystemMessageId TRYING_ON_STATE;
	
	/**
	 * ID: 1158<br>
	 * Message: ߂鏊͔э~邱Ƃł܂B<br>
	 * Message: &#28961;&#27861;&#22312;&#22826;&#39640;&#30340;&#22320;&#26041;&#19979;&#21435;&#12290;<br>
	 * Message: You cannot dismount from this elevation.
	 */
	public static final SystemMessageId CANNOT_DISMOUNT_FROM_ELEVATION;
	
	/**
	 * ID: 1159<br>
	 * Message: b铇̒D10ɃO[fB`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will arrive at Gludin Harbor in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GLUDIN_10_MINUTES;
	
	/**
	 * ID: 1160<br>
	 * Message: b铇̒D5ɃO[fB`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Gludin Harbor in approximately 5 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GLUDIN_5_MINUTES;
	
	/**
	 * ID: 1161<br>
	 * Message: b铇̒D1ɃO[fB`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#20998;&#37912;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Gludin Harbor in approximately 1 minute.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GLUDIN_1_MINUTE;
	
	/**
	 * ID: 1162<br>
	 * Message: M`̒D15ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#22855;&#23721;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Giran Harbor will be arriving at Talking Island in approximately 15 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_15_MINUTES;
	
	/**
	 * ID: 1163<br>
	 * Message: M`̒D10ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#22855;&#23721;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Giran Harbor will be arriving at Talking Island in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_10_MINUTES;
	
	/**
	 * ID: 1164<br>
	 * Message: M`̒D5ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#22855;&#23721;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Giran Harbor will be arriving at Talking Island in approximately 5 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_5_MINUTES;
	
	/**
	 * ID: 1165<br>
	 * Message: M`̒D1ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#22855;&#23721;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Giran Harbor will be arriving at Talking Island in approximately 1 minute.
	 */
	public static final SystemMessageId FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_1_MINUTE;
	
	/**
	 * ID: 1166<br>
	 * Message: b铇̒D20ɃM`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#50;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Giran Harbor in approximately 20 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_20_MINUTES;
	
	/**
	 * ID: 1167<br>
	 * Message: b铇̒D15ɃM`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Giran Harbor in approximately 20 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_15_MINUTES;
	
	/**
	 * ID: 1168<br>
	 * Message: b铇̒D10ɃM`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Giran Harbor in approximately 20 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_10_MINUTES;
	
	/**
	 * ID: 1169<br>
	 * Message: b铇̒D5ɃM`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Giran Harbor in approximately 20 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_5_MINUTES;
	
	/**
	 * ID: 1170<br>
	 * Message: b铇̒D1ɃM`ɓ܂B<br>
	 * Message: &#38626;&#38283;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#20998;&#37912;&#24460;&#25269;&#36948;&#22855;&#23721;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Talking Island will be arriving at Giran Harbor in approximately 1 minute.
	 */
	public static final SystemMessageId FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_1_MINUTE;
	
	/**
	 * ID: 1171<br>
	 * Message: 20CihVDDɓ܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#32004;&#22312;&#50;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#30908;&#38957;&#12290;<br>
	 * Message: The Innadril pleasure boat will arrive in approximately 20 minutes.
	 */
	public static final SystemMessageId INNADRIL_BOAT_ARRIVE_20_MINUTES;
	
	/**
	 * ID: 1172<br>
	 * Message: 15CihVDDɓ܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#32004;&#22312;&#49;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#30908;&#38957;&#12290;<br>
	 * Message: The Innadril pleasure boat will arrive in approximately 15 minutes.
	 */
	public static final SystemMessageId INNADRIL_BOAT_ARRIVE_15_MINUTES;
	
	/**
	 * ID: 1173<br>
	 * Message: 10CihVDDɓ܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#32004;&#22312;&#49;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#30908;&#38957;&#12290;<br>
	 * Message: The Innadril pleasure boat will arrive in approximately 10 minutes.
	 */
	public static final SystemMessageId INNADRIL_BOAT_ARRIVE_10_MINUTES;
	
	/**
	 * ID: 1174<br>
	 * Message: 5CihVDDɓ܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#32004;&#22312;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#30908;&#38957;&#12290;<br>
	 * Message: The Innadril pleasure boat will arrive in approximately 5 minutes.
	 */
	public static final SystemMessageId INNADRIL_BOAT_ARRIVE_5_MINUTES;
	
	/**
	 * ID: 1175<br>
	 * Message: 1CihVDDɓ܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#32004;&#22312;&#49;&#20998;&#37912;&#24460;&#25269;&#36948;&#30908;&#38957;&#12290;<br>
	 * Message: The Innadril pleasure boat will arrive in approximately 1 minute.
	 */
	public static final SystemMessageId INNADRIL_BOAT_ARRIVE_1_MINUTE;
	
	/**
	 * ID: 1176<br>
	 * Message: ԂłB<br>
	 * Message: &#29694;&#22312;&#26159;&#31478;&#29229;&#26399;&#38291;&#12290;<br>
	 * Message: The SSQ Competition period is underway.
	 */
	public static final SystemMessageId SSQ_COMPETITION_UNDERWAY;
	
	/**
	 * ID: 1177<br>
	 * Message: LԂłB<br>
	 * Message: &#29694;&#22312;&#26159;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#12290;<br>
	 * Message: This is the seal validation period.
	 */
	public static final SystemMessageId VALIDATION_PERIOD;
	
	/**
	 * ID: 1178<br>
	 * Message: ̕L錈́ALԒA×~̕ɂĊJʂȃ_Wɓꂷ邱ƂłAʂȃ_Wɏo}̏lƎ邱ƂłAgk̃lN|XŃAiLA܂̓XɉƂł܂B<br>
	 * Message: &#25793;&#26377;&#27492;&#23553;&#21360;&#30340;&#38499;&#29151;&#22312;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#20839;&#65292;&#37341;&#23565;&#30001;&#36010;&#24958;&#30340;&#23553;&#21360;&#25152;&#38283;&#21855;&#30340;&#21476;&#20195;&#20844;&#22675;&#21487;&#29544;&#20139;&#36914;&#20837;&#30340;&#27402;&#21033;&#65292;&#20063;&#21487;&#33287;&#22312;&#21476;&#20195;&#20844;&#22675;&#20986;&#27794;&#30340;&#36001;&#23500;&#30340;&#21830;&#20154;&#36914;&#34892;&#20132;&#26131;&#65292;&#19988;&#21487;&#22312;&#20351;&#24466;&#30340;&#21476;&#20195;&#20844;&#22675;&#20013;&#33287;&#20126;&#32013;&#25110;&#33673;&#33673;&#32114;&#23565;&#25136;&#12290;<br>
	 * Message: <Seal of Avarice description>
	 */
	public static final SystemMessageId AVARICE_DESCRIPTION;
	
	/**
	 * ID: 1179<br>
	 * Message: ̕L錈́ALԒA[̕ɂĊJʂȃ_Wɓꂷ邱ƂłAɂiՂA_Wւ̃e|[g T[rX󂯂邱ƂłA_Wɏo}̒b艮ɉƂł܂B[`(ŖSԎ)ɌAґ(sґ)ɗLv(LQ)@r܂B<br>
	 * Message: &#25793;&#26377;&#27492;&#23553;&#21360;&#30340;&#38499;&#29151;&#22312;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#20839;&#65292;&#37341;&#23565;&#30001;&#21855;&#31034;&#30340;&#23553;&#21360;&#25152;&#38283;&#21855;&#30340;&#29305;&#27530;&#27934;&#31391;&#21487;&#29544;&#20139;&#36914;&#20837;&#20043;&#27402;&#21033;&#65292;&#20063;&#21487;&#24478;&#26449;&#33674;&#30340;&#31085;&#21496;&#24471;&#21040;&#20659;&#36865;&#26381;&#21209;&#65292;&#19988;&#21487;&#35211;&#21040;&#22312;&#27934;&#31391;&#20013;&#20986;&#29694;&#30340;&#36001;&#23500;&#30340;&#37941;&#21280;&#12290;&#36947;&#30772;&#21855;&#31034;&#30340;&#20154;&#65288;&#21558;&#21898;&#28357;&#20129;&#30340;&#20154;&#65289;&#23559;&#26371;&#20986;&#29694;&#22312;&#26449;&#33674;&#65292;&#28858;&#21213;&#26041;&#65288;&#25943;&#26041;&#65289;&#26045;&#23637;&#33391;&#24615;&#65288;&#24801;&#24615;&#65289;&#39764;&#27861;&#12290;<br>
	 * Message: <Seal of Gnosis description>
	 */
	public static final SystemMessageId GNOSIS_DESCRIPTION;
	
	/**
	 * ID: 1180<br>
	 * Message: LԒA̍őCPʂюb/AǃAbv O[hp/AǊ{h/̐ŗ̌El̕LɗLȂ悤ɕύX܂B܂AU핺̎gp܂B̊vR̕LƁAU̍ۂɏ鏊L鑤ɎQł悤ɂȂ܂B<br>
	 * Message: &#22312;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#20839;&#65292;&#38499;&#29151;&#30340;&#67;&#80;&#26368;&#22823;&#20540;&#20197;&#21450;&#23432;&#22478;&#20653;&#20853;&#47;&#22478;&#38272;&#12289;&#22478;&#29254;&#24375;&#21270;&#36027;&#29992;&#47;&#22478;&#38272;&#12289;&#22478;&#29254;&#22522;&#26412;&#38450;&#31142;&#21147;&#47;&#31237;&#29575;&#19978;&#38480;&#20540;&#65292;&#23559;&#35722;&#28858;&#26377;&#21033;&#26044;&#25793;&#26377;&#27492;&#23553;&#21360;&#30340;&#38499;&#29151;&#65292;&#21516;&#26178;&#20063;&#26371;&#38480;&#21046;&#25915;&#22478;&#20853;&#22120;&#30340;&#20351;&#29992;&#12290;&#33509;&#30001;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#25484;&#25511;&#27492;&#23553;&#21360;&#30340;&#35441;&#65292;&#25915;&#22478;&#25136;&#26178;&#21482;&#26377;&#32113;&#27835;&#22478;&#22561;&#30340;&#34880;&#30431;&#25165;&#33021;&#21443;&#33287;&#23432;&#22478;&#26041;&#12290;<br>
	 * Message: <Seal of Strife description>
	 */
	public static final SystemMessageId STRIFE_DESCRIPTION;
	
	/**
	 * ID: 1181<br>
	 * Message: {Ƀ^Cg폜܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#21034;&#38500;&#31281;&#34399;&#21966;&#65311;<br>
	 * Message: Do you really wish to change the title?
	 */
	public static final SystemMessageId CHANGE_TITLE_CONFIRM;
	
	/**
	 * ID: 1182<br>
	 * Message: {ɍ폜܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#21034;&#38500;&#34880;&#30431;&#32011;&#31456;&#21966;&#65311;<br>
	 * Message: Are you sure you wish to delete the clan crest?
	 */
	public static final SystemMessageId CREST_DELETE_CONFIRM;
	
	/**
	 * ID: 1183<br>
	 * Message: ԂłB<br>
	 * Message: &#29694;&#22312;&#26159;&#21407;&#22987;&#29376;&#24907;&#12290;<br>
	 * Message: This is the initial period.
	 */
	public static final SystemMessageId INITIAL_PERIOD;
	
	/**
	 * ID: 1184<br>
	 * Message: T[o[WvԂłB<br>
	 * Message: &#29694;&#22312;&#26159;&#20282;&#26381;&#22120;&#20839;&#37096;&#32113;&#35336;&#26399;&#12290;<br>
	 * Message: This is a period of calculating statistics in the server.
	 */
	public static final SystemMessageId RESULTS_PERIOD;
	
	/**
	 * ID: 1185<br>
	 * Message: ɍ폜܂B<br>
	 * Message: &#26085;&#24460;&#23601;&#26371;&#21034;&#38500;&#12290;<br>
	 * Message: days left until deletion.
	 */
	public static final SystemMessageId DAYS_LEFT_UNTIL_DELETION;
	
	/**
	 * ID: 1186<br>
	 * Message: VKAJEg쐬邽߂ɂ́Al[WII TCgihttp://lineage2.plaync.jp/jŉo^Kv܂B<br>
	 * Message: &#22914;&#35201;&#30003;&#35531;&#26032;&#24115;&#34399;&#65292;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#21152;&#20837;&#112;&#108;&#97;&#121;&#110;&#99;&#26371;&#21729;&#65292;&#21516;&#26178;&#21855;&#29992;&#22825;&#22530;&#73;&#73;&#36938;&#25138;&#26381;&#21209;&#12290;<br>
	 * Message: To create a new account, please visit the PlayNC website (http://www.plaync.com/us/support/)
	 */
	public static final SystemMessageId TO_CREATE_ACCOUNT_VISIT_WEBSITE;
	
	/**
	 * ID: 1187<br>
	 * Message: AJEg𕴎ꍇAl[WII TCgihttp://lineage2.plaync.jp/j̃T|[g炨₢킹B<br>
	 * Message: &#22914;&#36986;&#22833;&#24115;&#34399;&#65292;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#23448;&#32178;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#32879;&#32363;&#23458;&#26381;&#65117;&#22825;&#22530;&#73;&#73;&#65118;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#25110;&#35531;&#38651;&#27965;&#65117;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#54;&#54;&#54;&#65118;&#26597;&#35426;&#12290;<br>
	 * Message: If you forgotten your account information or password, please visit the Support Center on the PlayNC website(http://www.plaync.com/us/support/)
	 */
	public static final SystemMessageId ACCOUNT_INFORMATION_FORGOTTON_VISIT_WEBSITE;
	
	/**
	 * ID: 1188<br>
	 * Message: ȏ㐄E󂯂ȂԂłB<br>
	 * Message: &#28961;&#27861;&#20877;&#34987;&#25512;&#34214;&#30340;&#30446;&#27161;&#12290;<br>
	 * Message: Your selected target can no longer receive a recommendation.
	 */
	public static final SystemMessageId YOUR_TARGET_NO_LONGER_RECEIVE_A_RECOMMENDATION;
	
	/**
	 * ID: 1189<br>
	 * Message: U鑤Վт܂Bŏ̏֎ɉ܂B<br>
	 * Message: &#25915;&#22478;&#26041;&#33256;&#26178;&#21516;&#30431;&#27491;&#24335;&#38283;&#22987;&#12290;&#26356;&#25563;&#31532;&#19968;&#22478;&#20027;&#26178;&#65292;&#23559;&#26371;&#33258;&#21205;&#35299;&#38500;&#12290;<br>
	 * Message: This temporary alliance of the Castle Attacker team is in effect. It will be dissolved when the Castle Lord is replaced.
	 */
	public static final SystemMessageId TEMPORARY_ALLIANCE;
	
	/**
	 * ID: 1189<br>
	 * Message: U鑤Վт܂Bŏ̏֎ɉ܂B<br>
	 * Message: &#25915;&#22478;&#26041;&#33256;&#26178;&#21516;&#30431;&#27491;&#24335;&#38283;&#22987;&#12290;&#26356;&#25563;&#31532;&#19968;&#22478;&#20027;&#26178;&#65292;&#23559;&#26371;&#33258;&#21205;&#35299;&#38500;&#12290;<br>
	 * Message: This temporary alliance of the Castle Attacker team has been dissolved.
	 */
	public static final SystemMessageId TEMPORARY_ALLIANCE_DISSOLVED;
	
	/**
	 * ID: 1191<br>
	 * Message: O[fB`̒D10ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#21476;&#39791;&#19969;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#48;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Talking Island in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_ARRIVE_AT_TALKING_10_MINUTES;
	
	/**
	 * ID: 1192<br>
	 * Message: O[fB`̒D5ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#21476;&#39791;&#19969;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#53;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Talking Island in approximately 5 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_ARRIVE_AT_TALKING_5_MINUTES;
	
	/**
	 * ID: 1193<br>
	 * Message: O[fB`̒D1ɘb铇ɓ܂B<br>
	 * Message: &#38626;&#38283;&#21476;&#39791;&#19969;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#20998;&#37912;&#24460;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Talking Island in approximately 1 minute.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_ARRIVE_AT_TALKING_1_MINUTE;
	
	/**
	 * ID: 1194<br>
	 * Message: b͕LԓɁAUJnO܂Ŕzu邱Ƃł܂B<br>
	 * Message: &#33258;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#33267;&#25915;&#22478;&#38283;&#22987;&#20043;&#21069;&#21487;&#20197;&#37197;&#32622;&#20653;&#20853;&#12290;<br>
	 * Message: A mercenary can be assigned to a position from the beginning of the Seal Validatio period until the time when a siege starts.
	 */
	public static final SystemMessageId MERC_CAN_BE_ASSIGNED;
	
	/**
	 * ID: 1195<br>
	 * Message: ̗b͐헐̕ɂzuł܂B<br>
	 * Message: &#22240;&#25136;&#20098;&#30340;&#23553;&#21360;&#65292;&#28961;&#27861;&#37197;&#32622;&#35442;&#20653;&#20853;&#12290;<br>
	 * Message: This mercenary cannot be assigned to a position by using the Seal of Strife.
	 */
	public static final SystemMessageId MERC_CANT_BE_ASSIGNED_USING_STRIFE;
	
	/**
	 * ID: 1196<br>
	 * Message: CōiKɒB߁AȏCW߂邱Ƃ͂ł܂B<br>
	 * Message: &#21147;&#37327;&#24050;&#32147;&#36948;&#21040;&#26368;&#39640;&#38542;&#27573;&#65292;&#28961;&#27861;&#32380;&#32396;&#25552;&#21319;&#12290;<br>
	 * Message: Your force has reached maximum capacity.
	 */
	public static final SystemMessageId FORCE_MAXIMUM;
	
	/**
	 * ID: 1197<br>
	 * Message: b̔p$s1$s2Ղ܂B<br>
	 * Message: &#28858;&#21484;&#21914;&#20351;&#39764;&#30340;&#36027;&#29992;&#23559;&#28040;&#32791;&#36;&#115;&#50;&#20491;&#36;&#115;&#49;&#12290;<br>
	 * Message: Summoning a servitor costs $s2 $s1.
	 */
	public static final SystemMessageId SUMMONING_SERVITOR_COSTS_S2_S1;
	
	/**
	 * ID: 1198<br>
	 * Message: NX^CY܂B<br>
	 * Message: &#24050;&#32080;&#26230;&#21270;&#12290;<br>
	 * Message: The item has been successfully crystallized.
	 */
	public static final SystemMessageId CRYSTALLIZATION_SUCCESSFUL;
	
	/**
	 * ID: 1199<br>
	 * Message: =======<̑>=======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#34880;&#30431;&#25136;&#23565;&#35937;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: =======<Clan War Target>=======
	 */
	public static final SystemMessageId CLAN_WAR_HEADER;
	
	/**
	 * ID: 1200<br>
	 * Message:($s1 ($s2 Alliance)
	 */
	public static final SystemMessageId S1_S2_ALLIANCE;
	
	/**
	 * ID: 1201<br>
	 * Message: fNGXgIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#20013;&#27490;&#30340;&#20219;&#21209;&#12290;<br>
	 * Message: Please select the quest you wish to abort.
	 */
	public static final SystemMessageId SELECT_QUEST_TO_ABOR;
	
	/**
	 * ID: 1202<br>
	 * Message:($s1 (No alliance exists)
	 */
	public static final SystemMessageId S1_NO_ALLI_EXISTS;
	
	/**
	 * ID: 1203<br>
	 * Message: 푈ł͂܂B<br>
	 * Message: &#38750;&#34389;&#26044;&#25136;&#29229;&#20013;&#12290;<br>
	 * Message: There is no clan war in progress.
	 */
	public static final SystemMessageId NO_WAR_IN_PROGRESS;
	
	/**
	 * ID: 1204<br>
	 * Message: XN[Vbgۑ܂B($s1$s2x$s3)<br>
	 * Message: &#24050;&#20786;&#23384;&#30059;&#38754;&#34722;&#24149;&#12290;&#65288;&#36;&#115;&#49;&#32;&#36;&#115;&#50;&#120;&#36;&#115;&#51;&#65289;<br>
	 * Message: The screenshot has been saved. ($s1 $s2x$s3)
	 */
	public static final SystemMessageId SCREENSHOT;
	
	/**
	 * ID: 1205<br>
	 * Message: MgCςɂȂ܂BMgC100܂ŕۑł܂B<br>
	 * Message: &#37109;&#20214;&#31665;&#24050;&#28415;&#65292;&#22240;&#27492;&#28961;&#27861;&#20786;&#23384;&#12290;&#26368;&#22810;&#21482;&#33021;&#20786;&#23384;&#49;&#48;&#48;&#20214;&#12290;<br>
	 * Message: Your mailbox is full. There is a 100 message limit.
	 */
	public static final SystemMessageId MAILBOX_FULL;
	
	/**
	 * ID: 1206<br>
	 * Message: ςɂȂ܂B100܂œo^ł܂B<br>
	 * Message: &#35338;&#24687;&#31665;&#24050;&#28415;&#65292;&#22240;&#27492;&#28961;&#27861;&#20786;&#23384;&#12290;&#26368;&#22810;&#21482;&#33021;&#20786;&#23384;&#49;&#48;&#48;&#20214;&#12290;<br>
	 * Message: The memo box is full. There is a 100 memo limit.
	 */
	public static final SystemMessageId MEMOBOX_FULL;
	
	/**
	 * ID: 1207<br>
	 * Message: e͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#20839;&#23481;&#12290;<br>
	 * Message: Please make an entry in the field.
	 */
	public static final SystemMessageId MAKE_AN_ENTRY;
	
	/**
	 * ID: 1208<br>
	 * Message: $c1SA$s2$s3𗎂Ƃ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27515;&#20129;&#24460;&#25481;&#33853;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 died and dropped $s3 $s2.
	 */
	public static final SystemMessageId C1_DIED_DROPPED_S3_S2;
	
	/**
	 * ID: 1209<br>
	 * Message: A߂łƂ܂B<br>
	 * Message: &#24685;&#21916;&#33;&#29417;&#29557;&#25104;&#21151;&#12290;<br>
	 * Message: Congratulations. Your raid was successful.
	 */
	public static final SystemMessageId RAID_WAS_SUCCESSFUL;
	
	/**
	 * ID: 1210<br>
	 * Message: Zu TCFԂn܂܂Bt̎iՂ̎iՂK˂邱ƂŎQł܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#31478;&#29229;&#26399;&#38291;&#38283;&#22987;&#20102;&#12290;&#21435;&#25214;&#40654;&#26126;&#30340;&#31085;&#21496;&#25110;&#40643;&#26127;&#30340;&#31085;&#21496;&#23601;&#21487;&#20197;&#21443;&#21152;&#12290;<br>
	 * Message: Seven Signs: The quest event period has begun. Visit a Priest of Dawn or Priestess of Dusk to participate in the event.
	 */
	public static final SystemMessageId QUEST_EVENT_PERIOD_BEGUN;
	
	/**
	 * ID: 1211<br>
	 * Message: Zu TCFԂI܂B̋Ԃ1TԌɎn܂܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#31478;&#29229;&#26399;&#38291;&#32080;&#26463;&#20102;&#12290;&#19979;&#19968;&#27425;&#31478;&#29229;&#23559;&#26044;&#19968;&#36913;&#24460;&#38283;&#22987;&#12290;<br>
	 * Message: Seven Signs: The quest event period has ended. The next quest event will start in one week.
	 */
	public static final SystemMessageId QUEST_EVENT_PERIOD_ENDED;
	
	/**
	 * ID: 1212<br>
	 * Message: Zu TCFťN傽×~̕l܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#29554;&#24471;&#20102;&#36010;&#24958;&#30340;&#23553;&#21360;&#12290;<br>
	 * Message: Seven Signs: The Lords of Dawn have obtained the Seal of Avarice.
	 */
	public static final SystemMessageId DAWN_OBTAINED_AVARICE;
	
	/**
	 * ID: 1213<br>
	 * Message: Zu TCFťN傽[̕l܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#29554;&#24471;&#20102;&#21855;&#31034;&#30340;&#23553;&#21360;&#12290;<br>
	 * Message: Seven Signs: The Lords of Dawn have obtained the Seal of Gnosis.
	 */
	public static final SystemMessageId DAWN_OBTAINED_GNOSIS;
	
	/**
	 * ID: 1214<br>
	 * Message: Zu TCFťN傽헐̕l܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#29554;&#24471;&#20102;&#25136;&#20098;&#30340;&#23553;&#21360;&#12290;<br>
	 * Message: Seven Signs: The Lords of Dawn have obtained the Seal of Strife.
	 */
	public static final SystemMessageId DAWN_OBTAINED_STRIFE;
	
	/**
	 * ID: 1215<br>
	 * Message: Zu TCF̊vR×~̕l܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#29554;&#24471;&#20102;&#36010;&#24958;&#30340;&#23553;&#21360;&#12290;<br>
	 * Message: Seven Signs: The Revolutionaries of Dusk have obtained the Seal of Avarice.
	 */
	public static final SystemMessageId DUSK_OBTAINED_AVARICE;
	
	/**
	 * ID: 1216<br>
	 * Message: Zu TCF̊vR[̕l܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#29554;&#24471;&#20102;&#21855;&#31034;&#30340;&#23553;&#21360;&#12290;<br>
	 * Message: Seven Signs: The Revolutionaries of Dusk have obtained the Seal of Gnosis.
	 */
	public static final SystemMessageId DUSK_OBTAINED_GNOSIS;
	
	/**
	 * ID: 1217<br>
	 * Message: Zu TCF̊vR헐̕l܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#29554;&#24471;&#20102;&#25136;&#20098;&#30340;&#23553;&#21360;&#12290;<br>
	 * Message: Seven Signs: The Revolutionaries of Dusk have obtained the Seal of Strife.
	 */
	public static final SystemMessageId DUSK_OBTAINED_STRIFE;
	
	/**
	 * ID: 1218<br>
	 * Message: Zu TCFLԂn܂܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#23553;&#21360;&#26377;&#25928;&#26399;&#38480;&#38283;&#22987;&#12290;<br>
	 * Message: Seven Signs: The Seal Validation period has begun.
	 */
	public static final SystemMessageId SEAL_VALIDATION_PERIOD_BEGUN;
	
	/**
	 * ID: 1219<br>
	 * Message: Zu TCFLԂI܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#23553;&#21360;&#26377;&#25928;&#26399;&#38480;&#32080;&#26463;&#12290;<br>
	 * Message: Seven Signs: The Seal Validation period has ended.
	 */
	public static final SystemMessageId SEAL_VALIDATION_PERIOD_ENDED;
	
	/**
	 * ID: 1220<br>
	 * Message: {ɏ܂B<br>
	 * Message: &#30906;&#23526;&#35201;&#21484;&#21914;&#21966;&#65311;<br>
	 * Message: Are you sure you wish to summon it?
	 */
	public static final SystemMessageId SUMMON_CONFIRM;
	
	/**
	 * ID: 1221<br>
	 * Message: {ɋA҂܂B<br>
	 * Message: &#30906;&#23526;&#35201;&#36820;&#22238;&#21966;&#65311;<br>
	 * Message: Are you sure you wish to return it?
	 */
	public static final SystemMessageId RETURN_CONFIRM;
	
	/**
	 * ID: 1222<br>
	 * Message: ݒnF $s1A$s2A$s3 (T|[gk)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#71;&#77;&#35566;&#35426;&#34389;&#65289;<br>
	 * Message: Current location : $s1, $s2, $s3 (GM Consultation Service)
	 */
	public static final SystemMessageId LOC_GM_CONSULATION_SERVICE_S1_S2_S3;
	
	/**
	 * ID: 1223<br>
	 * Message: 5ɃM`b铇֏o܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#22855;&#23721;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: We depart for Talking Island in five minutes.
	 */
	public static final SystemMessageId DEPART_FOR_TALKING_5_MINUTES;
	
	/**
	 * ID: 1224<br>
	 * Message: 1ɃM`b铇֏o܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#22855;&#23721;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: We depart for Talking Island in one minute.
	 */
	public static final SystemMessageId DEPART_FOR_TALKING_1_MINUTE;
	
	/**
	 * ID: 1225<br>
	 * Message: ԂȂM`b铇֏o܂B<br>
	 * Message: &#21363;&#23559;&#24478;&#22855;&#23721;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: All aboard for Talking Island
	 */
	public static final SystemMessageId DEPART_FOR_TALKING;
	
	/**
	 * ID: 1226<br>
	 * Message: M`b铇֏o܂B<br>
	 * Message: &#24478;&#22855;&#23721;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#28207;&#21475;&#12290;<br>
	 * Message: We are now leaving for Talking Island.
	 */
	public static final SystemMessageId LEAVING_FOR_TALKING;
	
	/**
	 * ID: 1227<br>
	 * Message: $s1̖ǂ̃[܂B<br>
	 * Message: &#24744;&#26377;&#12300;&#36;&#115;&#49;&#12301;&#23553;&#26410;&#35712;&#37109;&#20214;&#12290;<br>
	 * Message: You have $s1 unread messages.
	 */
	public static final SystemMessageId S1_UNREAD_MESSAGES;
	
	/**
	 * ID: 1228<br>
	 * Message: $c1ɎՒfꂽ߁A[܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#23559;&#24744;&#38548;&#32085;&#65292;&#28961;&#27861;&#20659;&#36865;&#37109;&#20214;&#12290;<br>
	 * Message: $c1 has blocked you. You cannot send mail to $c1.
	 */
	public static final SystemMessageId C1_BLOCKED_YOU_CANNOT_MAIL;
	
	/**
	 * ID: 1229<br>
	 * Message: [ȏ㑗Mł܂BAJEgA10ʂ܂őMł܂B<br>
	 * Message: &#28961;&#27861;&#20877;&#30332;&#36865;&#37109;&#20214;&#12290;&#27599;&#20491;&#24115;&#34399;&#19968;&#22825;&#21482;&#33021;&#30332;&#36865;&#49;&#48;&#23553;&#37109;&#20214;&#12290;<br>
	 * Message: No more messages may be sent at this time. Each account is allowed 10 messages per day.
	 */
	public static final SystemMessageId NO_MORE_MESSAGES_TODAY;
	
	/**
	 * ID: 1230<br>
	 * Message: [̑M͍ő5l܂ŉ\łB<br>
	 * Message: &#26368;&#22810;&#21482;&#33021;&#30332;&#36865;&#32102;&#53;&#20301;&#12290;<br>
	 * Message: You are limited to five recipients at a time.
	 */
	public static final SystemMessageId ONLY_FIVE_RECIPIENTS;
	
	/**
	 * ID: 1231<br>
	 * Message: [𑗐M܂B<br>
	 * Message: &#37109;&#20214;&#30332;&#36865;&#25104;&#21151;&#12290;<br>
	 * Message: You've sent mail.
	 */
	public static final SystemMessageId SENT_MAIL;
	
	/**
	 * ID: 1232<br>
	 * Message: [̑MɎs܂B<br>
	 * Message: &#37109;&#20214;&#30332;&#36865;&#22833;&#25943;&#12290;<br>
	 * Message: The message was not sent.
	 */
	public static final SystemMessageId MESSAGE_NOT_SENT;
	
	/**
	 * ID: 1233<br>
	 * Message: [͂܂B<br>
	 * Message: &#26032;&#37109;&#20214;&#12290;<br>
	 * Message: You've got mail.
	 */
	public static final SystemMessageId NEW_MAIL;
	
	/**
	 * ID: 1234<br>
	 * Message: [gCɕۑ܂B<br>
	 * Message: &#37109;&#20214;&#20786;&#23384;&#26044;&#33256;&#26178;&#20445;&#31649;&#31665;&#12290;<br>
	 * Message: The mail has been stored in your temporary mailbox.
	 */
	public static final SystemMessageId MAIL_STORED_IN_MAILBOX;
	
	/**
	 * ID: 1235<br>
	 * Message: Flׂč폜܂B<br>
	 * Message: &#30906;&#23450;&#21034;&#38500;&#25152;&#26377;&#22909;&#21451;&#21966;&#65311;<br>
	 * Message: Do you wish to delete all your friends?
	 */
	public static final SystemMessageId ALL_FRIENDS_DELETE_CONFIRM;
	
	/**
	 * ID: 1236<br>
	 * Message: ZLeB J[hԍ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#21152;&#23494;&#21345;&#34399;&#30908;&#12290;<br>
	 * Message: Please enter security card number.
	 */
	public static final SystemMessageId ENTER_SECURITY_CARD_NUMBER;
	
	/**
	 * ID: 1237<br>
	 * Message: $s1Ԃ̃J[hԍ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#32232;&#34399;&#31532;&#12300;&#36;&#115;&#49;&#12301;&#20043;&#21152;&#23494;&#21345;&#23433;&#20840;&#30908;&#12290;<br>
	 * Message: Please enter the card number for number $s1.
	 */
	public static final SystemMessageId ENTER_CARD_NUMBER_FOR_S1;
	
	/**
	 * ID: 1238<br>
	 * Message: gCςɂȂ߁Aȏۑł܂B10܂ŕۑł܂B<br>
	 * Message: &#33609;&#31295;&#21283;&#24050;&#28415;&#65292;&#22240;&#27492;&#28961;&#27861;&#20786;&#23384;&#12290;&#26368;&#22810;&#21482;&#33021;&#20786;&#23384;&#49;&#48;&#20214;&#12290;<br>
	 * Message: Your temporary mailbox is full. No more mail can be stored; you have reached the 10 message limit.
	 */
	public static final SystemMessageId TEMP_MAILBOX_FULL;
	
	/**
	 * ID: 1239<br>
	 * Message: L[Z[t W[̃[fBOɎs܂Bēxsꍇ́AQ[IĎsĂB<br>
	 * Message: &#37749;&#30436;&#20445;&#23433;&#27169;&#24335;&#23566;&#20837;&#22833;&#25943;&#12290;&#22914;&#26524;&#35201;&#37325;&#35430;&#65292;&#35531;&#20808;&#32080;&#26463;&#36938;&#25138;&#24460;&#20877;&#37325;&#26032;&#22519;&#34892;&#12290;<br>
	 * Message: The keyboard security module has failed to load. Please exit the game and try again.
	 */
	public static final SystemMessageId KEYBOARD_MODULE_FAILED_LOAD;
	
	/**
	 * ID: 1240<br>
	 * Message: Zu TCF̊vR܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Seven Signs: The Revolutionaries of Dusk have won.
	 */
	public static final SystemMessageId DUSK_WON;
	
	/**
	 * ID: 1241<br>
	 * Message: Zu TCFťN傽܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Seven Signs: The Lords of Dawn have won.
	 */
	public static final SystemMessageId DAWN_WON;
	
	/**
	 * ID: 1242<br>
	 * Message: 18˔F؂󂯂ĂȂ[U[ĺA22痂6܂ŃOCł܂B<br>
	 * Message: &#26410;&#32147;&#30906;&#35469;&#30340;&#49;&#56;&#27506;&#29609;&#23478;&#65292;&#24478;&#50;&#50;&#40670;&#21040;&#32716;&#26085;&#30340;&#48;&#54;&#40670;&#28961;&#27861;&#30331;&#20837;&#12290;<br>
	 * Message: Users who have not verified their age may not log in between the hours if 10:00 p.m. and 6:00 a.m.
	 */
	public static final SystemMessageId NOT_VERIFIED_AGE_NO_LOGIN;
	
	/**
	 * ID: 1243<br>
	 * Message: ̃ZLeB J[hԍ͗Lł͂܂B<br>
	 * Message: &#27492;&#28858;&#28961;&#25928;&#30340;&#21152;&#23494;&#23433;&#20840;&#30908;&#12290;<br>
	 * Message: The security card number is invalid.
	 */
	public static final SystemMessageId SECURITY_CARD_NUMBER_INVALID;
	
	/**
	 * ID: 1244<br>
	 * Message: 18˔F؂󂯂ĂȂ[U[ĺA22痂6܂ł̊ԁAڑłȂ߃Q[I܂B<br>
	 * Message: &#26410;&#32147;&#30906;&#35469;&#30340;&#49;&#56;&#27506;&#29609;&#23478;&#65292;&#24478;&#50;&#50;&#40670;&#21040;&#32716;&#26085;&#30340;&#48;&#54;&#40670;&#28961;&#27861;&#36899;&#32218;&#65292;&#22240;&#27492;&#32066;&#27490;&#36938;&#25138;&#12290;<br>
	 * Message: Users who have not verified their age may not log in between the hours if 10:00 p.m. and 6:00 a.m. Logging off now
	 */
	public static final SystemMessageId NOT_VERIFIED_AGE_LOG_OFF;
	
	/**
	 * ID: 1245<br>
	 * Message: ڑI$s1OłB<br>
	 * Message: &#32080;&#26463;&#36899;&#32218;&#21069;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: You will be loged out in $s1 minutes.
	 */
	public static final SystemMessageId LOGOUT_IN_S1_MINUTES;
	
	/**
	 * ID: 1246<br>
	 * Message: $c1SA$s2Afi𗎂Ƃ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27515;&#20129;&#24460;&#25481;&#33853;&#12300;&#36;&#115;&#50;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: $c1 died and has dropped $s2 adena.
	 */
	public static final SystemMessageId C1_DIED_DROPPED_S2_ADENA;
	
	/**
	 * ID: 1247<br>
	 * Message: Ԃ߂߁ÂɊỸXLgpł܂B<br>
	 * Message: &#23629;&#39636;&#25918;&#32622;&#22826;&#20037;&#65292;&#28961;&#27861;&#20351;&#29992;&#35442;&#25216;&#33021;&#12290;<br>
	 * Message: The corpse is too old. The skill cannot be used.
	 */
	public static final SystemMessageId CORPSE_TOO_OLD_SKILL_NOT_USED;
	
	/**
	 * ID: 1248<br>
	 * Message: 󕠂ɂȂAԂ܂B<br>
	 * Message: &#39164;&#26009;&#29992;&#30433;&#65292;&#35299;&#38500;&#39438;&#20056;&#29376;&#24907;&#12290;<br>
	 * Message: You are out of feed. Mount status canceled.
	 */
	public static final SystemMessageId OUT_OF_FEED_MOUNT_CANCELED;
	
	/**
	 * ID: 1249<br>
	 * Message: Co[ɏ邽߂ɂ́AXgC_[ɏԂłȂ΂Ȃ܂B<br>
	 * Message: &#22312;&#39438;&#20056;&#24231;&#40845;&#30340;&#29376;&#24907;&#19979;&#65292;&#25165;&#21487;&#39438;&#20056;&#39131;&#40845;&#12290;<br>
	 * Message: You may only ride a wyvern while you're riding a strider.
	 */
	public static final SystemMessageId YOU_MAY_ONLY_RIDE_WYVERN_WHILE_RIDING_STRIDER;
	
	/**
	 * ID: 1250<br>
	 * Message: {ɍ~܂B̍~ALN^[1̎SɒlolyieB܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#25237;&#38477;&#21966;&#65311;&#22312;&#21516;&#30431;&#25136;&#25237;&#38477;&#26178;&#65292;<br>
	 * Message: Do you really want to surrender? If you surrender during an alliance war, your Exp will drop the same as if you were to die once.
	 */
	public static final SystemMessageId SURRENDER_ALLY_WAR_CONFIRM;
	
	/**
	 * ID: 1251<br>
	 * Message: {ɒǕ܂BǕsȂꍇA1̊ԁǍ𓯖ɉ邱Ƃł܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#39493;&#36880;&#21966;&#65311;&#22914;&#26524;&#39493;&#36880;&#21516;&#30431;&#30340;&#35441;&#65292;&#22312;&#19968;&#22825;&#20839;&#23601;&#28961;&#27861;&#35731;&#20854;&#20182;&#34880;&#30431;&#21152;&#20837;&#28858;&#21516;&#30431;&#12290;<br>
	 * Message: Are you sure you want to dismiss the alliance? If you use the /allydismiss command, you will not be able to accept another clan to your alliance for one day.
	 */
	public static final SystemMessageId DISMISS_ALLY_CONFIRM;
	
	/**
	 * ID: 1252<br>
	 * Message: {ɍ~܂B1̎SɒlolyieB܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#25237;&#38477;&#21966;&#65311;&#26371;&#28187;&#20302;&#30456;&#30070;&#26044;&#27515;&#20129;&#19968;&#27425;&#26178;&#30340;&#32147;&#39511;&#20540;&#12290;<br>
	 * Message: Are you sure you want to surrender? Exp penalty will be the same as death.
	 */
	public static final SystemMessageId SURRENDER_CONFIRM1;
	
	/**
	 * ID: 1253<br>
	 * Message: {Ɍl~܂B1̎SɒlolyieBAɎQłȂȂ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#20491;&#20154;&#25237;&#38477;&#21966;&#65311;&#23559;&#26371;&#38477;&#20302;&#30456;&#30070;&#26044;&#27515;&#20129;&#19968;&#27425;&#26178;&#30340;&#32147;&#39511;&#20540;&#65292;&#32780;&#19988;&#28961;&#27861;&#21443;&#21152;&#34880;&#30431;&#25136;&#12290;<br>
	 * Message: Are you sure you want to surrender? Exp penalty will be the same as death and you will not be allowed to participate in clan war.
	 */
	public static final SystemMessageId SURRENDER_CONFIRM2;
	
	/**
	 * ID: 1254<br>
	 * Message: ]ɉĒA肪Ƃ܂B<br>
	 * Message: &#24863;&#35613;&#23529;&#26680;&#35380;&#27714;&#12290;<br>
	 * Message: Thank you for submitting feedback.
	 */
	public static final SystemMessageId THANKS_FOR_FEEDBACK;
	
	/**
	 * ID: 1255<br>
	 * Message: T|[gJn܂B<br>
	 * Message: &#33287;&#71;&#77;&#20132;&#35527;&#38283;&#22987;&#20102;&#12290;<br>
	 * Message: GM consultation has begun.
	 */
	public static final SystemMessageId GM_CONSULTATION_BEGUN;
	
	/**
	 * ID: 1256<br>
	 * Message: R}ȟɖOĂB<br>
	 * Message: &#35531;&#22312;&#25351;&#20196;&#24460;&#38754;&#35352;&#36617;&#21517;&#31281;&#12290;<br>
	 * Message: Please write the name after the command.
	 */
	public static final SystemMessageId PLEASE_WRITE_NAME_AFTER_COMMAND;
	
	/**
	 * ID: 1257<br>
	 * Message: ybgƏb̓XL̓}Nɓo^ł܂B<br>
	 * Message: &#23541;&#29289;&#21644;&#21484;&#21914;&#20351;&#39764;&#30340;&#29305;&#27530;&#25216;&#33021;&#65292;&#28961;&#27861;&#30331;&#37636;&#25104;&#24040;&#38598;&#12290;<br>
	 * Message: The special skill of a servitor or pet cannot be registerd as a macro.
	 */
	public static final SystemMessageId PET_SKILL_NOT_AS_MACRO;
	
	/**
	 * ID: 1258<br>
	 * Message: $s1NX^CY܂B<br>
	 * Message: &#24050;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#32080;&#26230;&#21270;&#12290;<br>
	 * Message: $s1 has been crystallized
	 */
	public static final SystemMessageId S1_CRYSTALLIZED;
	
	/**
	 * ID: 1259<br>
	 * Message: =======<̑>=======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#21516;&#30431;&#25136;&#23565;&#35937;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: =======<Alliance Target>=======
	 */
	public static final SystemMessageId ALLIANCE_TARGET_HEADER;
	
	/**
	 * ID: 1260<br>
	 * Message: Zu TCF̋̏łB<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#27491;&#22312;&#28310;&#20633;&#19979;&#19968;&#27425;&#30340;&#31478;&#29229;&#12290;<br>
	 * Message: Seven Signs: Preparations have begun for the next quest event.
	 */
	public static final SystemMessageId PREPARATIONS_PERIOD_BEGUN;
	
	/**
	 * ID: 1261<br>
	 * Message: Zu TCFԒłBt̎iՂ̎iՂK˂邱ƂŎQł܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#29694;&#22312;&#26159;&#31478;&#29229;&#26399;&#38291;&#12290;&#21435;&#25214;&#40654;&#26126;&#30340;&#31085;&#21496;&#25110;&#40643;&#26127;&#30340;&#31085;&#21496;&#23601;&#21487;&#20197;&#21443;&#21152;&#12290;<br>
	 * Message: Seven Signs: The quest event period has begun. Speak with a Priest of Dawn or Dusk Priestess if you wish to participate in the event.
	 */
	public static final SystemMessageId COMPETITION_PERIOD_BEGUN;
	
	/**
	 * ID: 1262<br>
	 * Message: Zu TCFԂIAʂWvĂ܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#31478;&#29229;&#26399;&#38291;&#32080;&#26463;&#65292;&#27491;&#22312;&#21512;&#35336;&#32080;&#26524;&#12290;<br>
	 * Message: Seven Signs: Quest event has ended. Results are being tallied.
	 */
	public static final SystemMessageId RESULTS_PERIOD_BEGUN;
	
	/**
	 * ID: 1263<br>
	 * Message: Zu TCFLԒłBԂ͎̌jɊJn܂B<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#65306;&#29694;&#22312;&#26159;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#12290;&#31478;&#29229;&#26399;&#38291;&#23559;&#26371;&#22312;&#19979;&#36913;&#19968;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Seven Signs: This is the seal validation period. A new quest event period begins next Monday.
	 */
	public static final SystemMessageId VALIDATION_PERIOD_BEGUN;
	
	/**
	 * ID: 1264<br>
	 * Message: ̋zɎs܂B݂̃\E Xg[ł͂̍͋zł܂B<br>
	 * Message: &#29992;&#29694;&#26377;&#30340;&#25628;&#39746;&#30707;&#28961;&#27861;&#21560;&#25910;&#27492;&#38728;&#39746;&#12290;&#38728;&#39746;&#21560;&#25910;&#22833;&#25943;&#12290;<br>
	 * Message: This soul stone cannot currently absorb souls. Absorption has failed.
	 */
	public static final SystemMessageId STONE_CANNOT_ABSORB;
	
	/**
	 * ID: 1265<br>
	 * Message: \E Xg[ĂȂ̂ōzł܂B<br>
	 * Message: &#22240;&#27794;&#26377;&#25628;&#39746;&#30707;&#65292;&#28961;&#27861;&#21560;&#25910;&#27492;&#38728;&#39746;&#12290;<br>
	 * Message: You can't absorb souls without a soul stone.
	 */
	public static final SystemMessageId CANT_ABSORB_WITHOUT_STONE;
	
	/**
	 * ID: 1266<br>
	 * Message: g[hI܂B<br>
	 * Message: &#20132;&#25563;&#32080;&#26463;&#12290;<br>
	 * Message: The exchange has ended.
	 */
	public static final SystemMessageId EXCHANGE_HAS_ENDED;
	
	/**
	 * ID: 1267<br>
	 * Message: vx$s1オ܂B<br>
	 * Message: &#36002;&#29563;&#24230;&#22686;&#21152;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your contribution score is increased by $s1.
	 */
	public static final SystemMessageId CONTRIB_SCORE_INCREASED_S1;
	
	/**
	 * ID: 1268<br>
	 * Message: $s1NXTu NXɒǉ܂B<br>
	 * Message: &#30906;&#23450;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#27492;&#32887;&#26989;&#36861;&#21152;&#28858;&#21103;&#32887;&#26989;&#21966;&#65311;<br>
	 * Message: Do you wish to add class as your sub class?
	 */
	public static final SystemMessageId ADD_SUBCLASS_CONFIRM;
	
	/**
	 * ID: 1269<br>
	 * Message: VTu NXǉ܂B<br>
	 * Message: &#36861;&#21152;&#20102;&#26032;&#30340;&#21103;&#32887;&#26989;&#12290;<br>
	 * Message: The new sub class has been added.
	 */
	public static final SystemMessageId ADD_NEW_SUBCLASS;
	
	/**
	 * ID: 1270<br>
	 * Message: Tu NXԂ̕ύX܂B<br>
	 * Message: &#21103;&#32887;&#26989;&#38291;&#30340;&#36681;&#25563;&#24050;&#32147;&#23436;&#25104;&#12290;<br>
	 * Message: The transfer of sub class has been completed.
	 */
	public static final SystemMessageId SUBCLASS_TRANSFER_COMPLETED;
	
	/**
	 * ID: 1271<br>
	 * Message: {ɎQ܂B̕LԂ܂ťN及ɂȂ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#21443;&#21152;&#21966;&#65311;&#33267;&#19979;&#22238;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#28858;&#27490;&#65292;&#23559;&#38584;&#23660;&#26044;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#12290;<br>
	 * Message: Do you wish to participate? Until the next seal validation period, you are a member of the Lords of Dawn.
	 */
	public static final SystemMessageId DAWN_CONFIRM;
	
	/**
	 * ID: 1271<br>
	 * Message: {ɎQ܂B̕LԂ܂ťN及ɂȂ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#21443;&#21152;&#21966;&#65311;&#33267;&#19979;&#22238;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#28858;&#27490;&#65292;&#23559;&#38584;&#23660;&#26044;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#12290;<br>
	 * Message: Do you wish to participate? Until the next seal validation period, you are a member of the Revolutionaries of Dusk.
	 */
	public static final SystemMessageId DUSK_CONFIRM;
	
	/**
	 * ID: 1273<br>
	 * Message: ťN及ŃZu TCɎQ܂B<br>
	 * Message: &#20197;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#20043;&#36523;&#20221;&#21443;&#21152;&#19971;&#20491;&#23553;&#21360;&#12290;<br>
	 * Message: You will participate in the Seven Signs as a member of the Lords of Dawn.
	 */
	public static final SystemMessageId SEVENSIGNS_PARTECIPATION_DAWN;
	
	/**
	 * ID: 1274<br>
	 * Message: ̊vRŃZu TCɎQ܂B<br>
	 * Message: &#20197;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#20043;&#36523;&#20221;&#21443;&#21152;&#19971;&#20491;&#23553;&#21360;&#12290;<br>
	 * Message: You will participate in the Seven Signs as a member of the Revolutionaries of Dusk.
	 */
	public static final SystemMessageId SEVENSIGNS_PARTECIPATION_DUSK;
	
	/**
	 * ID: 1275<br>
	 * Message: ̋Ԃ́A×~̂̕߂ɐ키I܂B<br>
	 * Message: &#22312;&#36889;&#27425;&#30340;&#31478;&#29229;&#26399;&#38291;&#20839;&#65292;&#36984;&#25799;&#28858;&#36010;&#24958;&#30340;&#23553;&#21360;&#32780;&#25136;&#12290;<br>
	 * Message: You've chosen to fight for the Seal of Avarice during this quest event period.
	 */
	public static final SystemMessageId FIGHT_FOR_AVARICE;
	
	/**
	 * ID: 1276<br>
	 * Message: ̋Ԃ́A[̂̕߂ɐ키I܂B<br>
	 * Message: &#22312;&#36889;&#27425;&#30340;&#31478;&#29229;&#26399;&#38291;&#20839;&#65292;&#36984;&#25799;&#28858;&#21855;&#31034;&#30340;&#23553;&#21360;&#32780;&#25136;&#12290;<br>
	 * Message: You've chosen to fight for the Seal of Gnosis during this quest event period.
	 */
	public static final SystemMessageId FIGHT_FOR_GNOSIS;
	
	/**
	 * ID: 1277<br>
	 * Message: ̋Ԃ́A헐̂̕߂ɐ키I܂B<br>
	 * Message: &#22312;&#36889;&#27425;&#30340;&#31478;&#29229;&#26399;&#38291;&#20839;&#65292;&#36984;&#25799;&#28858;&#25136;&#20098;&#30340;&#23553;&#21360;&#32780;&#25136;&#12290;<br>
	 * Message: You've chosen to fight for the Seal of Strife during this quest event period.
	 */
	public static final SystemMessageId FIGHT_FOR_STRIFE;
	
	/**
	 * ID: 1278<br>
	 * Message: NPCT[o[쓮~ԂłB<br>
	 * Message: &#78;&#80;&#67;&#20282;&#26381;&#22120;&#29694;&#34389;&#26044;&#20572;&#27490;&#25805;&#20316;&#29376;&#24907;&#12290;<br>
	 * Message: The NPC server is not operating at this time.
	 */
	public static final SystemMessageId NPC_SERVER_NOT_OPERATING;
	
	/**
	 * ID: 1279<br>
	 * Message: vx̌x𒴉߂Asł܂B<br>
	 * Message: &#22240;&#36229;&#20986;&#36002;&#29563;&#24230;&#38480;&#21046;&#32780;&#28961;&#27861;&#36914;&#34892;&#12290;<br>
	 * Message: Contribution level has exceeded the limit. You may not continue.
	 */
	public static final SystemMessageId CONTRIB_SCORE_EXCEEDED;
	
	/**
	 * ID: 1280<br>
	 * Message: @̃NeBJ qbgI<br>
	 * Message: &#39764;&#27861;&#33268;&#21629;&#25915;&#25802;&#65281;<br>
	 * Message: Magic Critical Hit!
	 */
	public static final SystemMessageId CRITICAL_HIT_MAGIC;
	
	/**
	 * ID: 1281<br>
	 * Message: V[hɂzhɐ܂B<br>
	 * Message: &#23436;&#32654;&#30340;&#30462;&#29260;&#38450;&#31142;&#25104;&#21151;&#65281;<br>
	 * Message: Your excellent shield defense was a success!
	 */
	public static final SystemMessageId YOUR_EXCELLENT_SHIELD_DEFENSE_WAS_A_SUCCESS;
	
	/**
	 * ID: 1282<br>
	 * Message: l$s1ɕύX܂B<br>
	 * Message: &#24615;&#21521;&#20540;&#35722;&#26356;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your Karma has been changed to $s1
	 */
	public static final SystemMessageId YOUR_KARMA_HAS_BEEN_CHANGED_TO_S1;
	
	/**
	 * ID: 1283<br>
	 * Message: ŏt[@\ō쓮܂B<br>
	 * Message: &#21855;&#21205;&#20102;&#25928;&#26524;&#26368;&#23567;&#21270;&#21151;&#33021;&#12290;<br>
	 * Message: The minimum frame option has been activated.
	 */
	public static final SystemMessageId MINIMUM_FRAME_ACTIVATED;
	
	/**
	 * ID: 1284<br>
	 * Message: ŏt[@\܂B<br>
	 * Message: &#35299;&#38500;&#20102;&#25928;&#26524;&#26368;&#23567;&#21270;&#21151;&#33021;&#12290;<br>
	 * Message: The minimum frame option has been deactivated.
	 */
	public static final SystemMessageId MINIMUM_FRAME_DEACTIVATED;
	
	/**
	 * ID: 1285<br>
	 * Message: ݌ɂȂ߁Awł܂B<br>
	 * Message: &#32570;&#36008;&#65292;&#22240;&#32780;&#28961;&#27861;&#36092;&#36023;&#12290;<br>
	 * Message: No inventory exists: You cannot purchase an item.
	 */
	public static final SystemMessageId NO_INVENTORY_CANNOT_PURCHASE;
	
	/**
	 * ID: 1286<br>
	 * Message: (̌jߌ6܂)<br>
	 * Message: &#65288;&#21040;&#19979;&#36913;&#19968;&#19979;&#21320;&#54;&#40670;&#28858;&#27490;&#65289;<br>
	 * Message: (Until next Monday at 6:00 p.m.)
	 */
	public static final SystemMessageId UNTIL_MONDAY_6PM;
	
	/**
	 * ID: 1287<br>
	 * Message: ({ߌ6܂)<br>
	 * Message: &#65288;&#21040;&#20170;&#22825;&#19979;&#21320;&#54;&#40670;&#28858;&#27490;&#65289;<br>
	 * Message: (Until today at 6:00 p.m.)
	 */
	public static final SystemMessageId UNTIL_TODAY_6PM;
	
	/**
	 * ID: 1288<br>
	 * Message: ݂̏ԂŋԂIƉ肵A$s1ȀL͈ȉ̂悤ɂȂ܂B<br>
	 * Message: &#20551;&#35373;&#20197;&#30446;&#21069;&#30340;&#29376;&#24907;&#32080;&#26463;&#31478;&#29229;&#26399;&#38291;&#26178;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#23601;&#26371;&#36111;&#24471;&#21213;&#21033;&#65292;&#19988;&#23553;&#21360;&#25152;&#26377;&#27402;&#26371;&#22914;&#21516;&#19979;&#36848;&#24773;&#24418;&#12290;<br>
	 * Message: If trends continue, $s1 will win and the seal will belong to:
	 */
	public static final SystemMessageId S1_WILL_WIN_COMPETITION;
	
	/**
	 * ID: 1289<br>
	 * Message: ȑO̎ŕLĂāA10ȏ̐l[̂<br>
	 * Message: &#21069;&#36913;&#26399;&#25793;&#26377;&#36942;&#23553;&#21360;&#65292;&#19988;&#49;&#48;&#37;&#20197;&#19978;&#30340;&#20154;&#26377;&#36914;&#34892;&#25237;&#31080;<br>
	 * Message: (Until next Monday at 6:00 p.m.)
	 */
	public static final SystemMessageId SEAL_OWNED_10_MORE_VOTED;
	
	/**
	 * ID: 1290<br>
	 * Message: ȑO̎ŕLłȂA35ȏ̐l[̂<br>
	 * Message: &#21069;&#36913;&#26399;&#38614;&#26410;&#25793;&#26377;&#36942;&#23553;&#21360;&#65292;&#20294;&#51;&#53;&#37;&#20197;&#19978;&#30340;&#20154;&#26377;&#36914;&#34892;&#25237;&#31080;<br>
	 * Message: Although the seal was not owned, since 35 percent or more people have voted.
	 */
	public static final SystemMessageId SEAL_NOT_OWNED_35_MORE_VOTED;
	
	/**
	 * ID: 1291<br>
	 * Message: ȑO̎ŕLĂA10̐l[̂<br>
	 * Message: &#21069;&#36913;&#26399;&#38614;&#25793;&#26377;&#36942;&#23553;&#21360;&#65292;&#20294;&#36914;&#34892;&#25237;&#31080;&#30340;&#20154;&#26410;&#28415;&#49;&#48;&#37;<br>
	 * Message: Although the seal was owned during the previous period, less than 10% of people have voted.
	 */
	public static final SystemMessageId SEAL_OWNED_10_LESS_VOTED;
	
	/**
	 * ID: 1292<br>
	 * Message: ȑO̎ŕLłA35̐l[̂<br>
	 * Message: &#21069;&#36913;&#26399;&#26410;&#25793;&#26377;&#36942;&#23553;&#21360;&#65292;&#19988;&#26410;&#28415;&#30334;&#20998;&#20043;&#19977;&#21313;&#20116;&#30340;&#20154;&#36984;&#25799;&#27492;&#23553;&#21360;&#12290;<br>
	 * Message: Since the seal was not owned during the previous period, and since less than 35 percent of people have voted.
	 */
	public static final SystemMessageId SEAL_NOT_OWNED_35_LESS_VOTED;
	
	/**
	 * ID: 1293<br>
	 * Message: ݂̏ԂŋԂIꍇAɂȂ܂B<br>
	 * Message: &#20197;&#30446;&#21069;&#30340;&#29376;&#24907;&#32080;&#26463;&#31478;&#29229;&#26399;&#38291;&#30340;&#35441;&#65292;&#23601;&#26371;&#25171;&#25104;&#24179;&#25163;&#12290;<br>
	 * Message: If current trends continue, it will end in a tie.
	 */
	public static final SystemMessageId COMPETITION_WILL_TIE;
	
	/**
	 * ID: 1294<br>
	 * Message: ̏ꍇALɂȂ܂B<br>
	 * Message: &#22240;&#31478;&#29229;&#32080;&#26524;&#19981;&#20998;&#21213;&#36000;&#65292;&#25152;&#20197;&#23553;&#21360;&#20063;&#26410;&#34987;&#20219;&#20309;&#19968;&#26041;&#25152;&#26377;&#12290;<br>
	 * Message: The competition has ended in a tie. Therefore, nobody has been awarded the seal.
	 */
	public static final SystemMessageId COMPETITION_TIE_SEAL_NOT_AWARDED;
	
	/**
	 * ID: 1295<br>
	 * Message: XLgp̓Tu NX邱ƂAύX邱Ƃ͂ł܂B<br>
	 * Message: &#20351;&#29992;&#25216;&#33021;&#36884;&#20013;&#65292;&#28961;&#27861;&#21109;&#36896;&#25110;&#35722;&#26356;&#21103;&#32887;&#26989;&#12290;<br>
	 * Message: Sub classes may not be created or changed while a skill is in use.
	 */
	public static final SystemMessageId SUBCLASS_NO_CHANGE_OR_CREATE_WHILE_SKILL_IN_USE;
	
	/**
	 * ID: 1296<br>
	 * Message: lXJƂłȂGAłB<br>
	 * Message: &#27492;&#22320;&#21312;&#28961;&#27861;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#12290;<br>
	 * Message: You cannot open a Private Store here.
	 */
	public static final SystemMessageId NO_PRIVATE_STORE_HERE;
	
	/**
	 * ID: 1297<br>
	 * Message: lH[JƂłȂGAłB<br>
	 * Message: &#27492;&#22320;&#21312;&#28961;&#27861;&#38283;&#21855;&#20491;&#20154;&#24037;&#25151;&#12290;<br>
	 * Message: You cannot open a Private Workshop here.
	 */
	public static final SystemMessageId NO_PRIVATE_WORKSHOP_HERE;
	
	/**
	 * ID: 1298<br>
	 * Message: X^[ [Xꂩo܂B<br>
	 * Message: &#38626;&#38283;&#24618;&#29289;&#31478;&#36093;&#22580;&#12290;<br>
	 * Message: Please confirm that you would like to exit the Monster Race Track.
	 */
	public static final SystemMessageId MONS_EXIT_CONFIRM;
	
	/**
	 * ID: 1299<br>
	 * Message: $c1WQ󂯁Arf܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#21463;&#21040;&#24178;&#25854;&#65292;&#22240;&#27492;&#26045;&#27861;&#20013;&#26039;&#12290;<br>
	 * Message: $c1's casting has been interrupted.
	 */
	public static final SystemMessageId C1_CASTING_INTERRUPTED;
	
	/**
	 * ID: 1300<br>
	 * Message: LZ܂B<br>
	 * Message: &#35430;&#31359;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: You are no longer trying on equipment.
	 */
	public static final SystemMessageId WEAR_ITEMS_STOPPED;
	
	/**
	 * ID: 1301<br>
	 * Message: ťN傽ɉȂƗpł܂B<br>
	 * Message: &#21482;&#26377;&#21152;&#20837;&#40654;&#26126;&#30340;&#21531;&#20027;&#20497;&#25165;&#33021;&#20351;&#29992;&#12290;<br>
	 * Message: Only a Lord of Dawn may use this.
	 */
	public static final SystemMessageId CAN_BE_USED_BY_DAWN;
	
	/**
	 * ID: 1302<br>
	 * Message: ̊vRɉȂƗpł܂B<br>
	 * Message: &#21482;&#26377;&#21152;&#20837;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#25165;&#33021;&#20351;&#29992;&#12290;<br>
	 * Message: Only a Revolutionary of Dusk may use this.
	 */
	public static final SystemMessageId CAN_BE_USED_BY_DUSK;
	
	/**
	 * ID: 1303<br>
	 * Message: Ԃp邱Ƃł܂B<br>
	 * Message: &#21482;&#26377;&#22312;&#31478;&#29229;&#26399;&#38291;&#20839;&#25165;&#33021;&#20351;&#29992;&#12290;<br>
	 * Message: This may only be used during the quest event period.
	 */
	public static final SystemMessageId CAN_BE_USED_DURING_QUEST_EVENT_PERIOD;
	
	/**
	 * ID: 1304<br>
	 * Message: 헐̉̕eŁA̎o^ׂăLZ܂B<br>
	 * Message: &#22240;&#21463;&#25136;&#20098;&#30340;&#23553;&#21360;&#20043;&#24433;&#38911;&#65292;&#25152;&#26377;&#34880;&#30431;&#30340;&#23432;&#22478;&#30331;&#37636;&#20840;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: The influence of the Seal of Strife has caused all defensive registrations to be canceled.
	 */
	public static final SystemMessageId STRIFE_CANCELED_DEFENSIVE_REGISTRATION;
	
	/**
	 * ID: 1305<br>
	 * Message: Ԃ̂݁A΂a邱Ƃł܂B<br>
	 * Message: &#21482;&#26377;&#22312;&#31478;&#29229;&#26399;&#38291;&#20839;&#25165;&#33021;&#23492;&#23384;&#23553;&#21360;&#30707;&#12290;<br>
	 * Message: Seal Stones may only be transferred during the quest event period.
	 */
	public static final SystemMessageId SEAL_STONES_ONLY_WHILE_QUEST;
	
	/**
	 * ID: 1306<br>
	 * Message: I܂B<br>
	 * Message: &#35430;&#31359;&#32080;&#26463;&#12290;<br>
	 * Message: You are no longer trying on equipment.
	 */
	public static final SystemMessageId NO_LONGER_TRYING_ON;
	
	/**
	 * ID: 1307<br>
	 * Message: LԂɂZł܂B<br>
	 * Message: &#21482;&#26377;&#22312;&#23553;&#21360;&#26377;&#25928;&#26399;&#38291;&#20839;&#25165;&#33021;&#36914;&#34892;&#32080;&#31639;&#12290;<br>
	 * Message: Only during the seal validation period may you settle your account.
	 */
	public static final SystemMessageId SETTLE_ACCOUNT_ONLY_IN_SEAL_VALIDATION;
	
	/**
	 * ID: 1308<br>
	 * Message: ߂łƂ܂IIVNXɓ]E܂B<br>
	 * Message: &#24685;&#21916;&#20320;&#65281;&#65281;&#24050;&#36681;&#32887;&#28858;&#26032;&#30340;&#32887;&#26989;&#12290;<br>
	 * Message: Congratulations - You've completed a class transfer!
	 */
	public static final SystemMessageId CLASS_TRANSFER;
	
	/**
	 * ID: 1309<br>
	 * Message: ̋@\́AŐVo[W MSN Messenger Ŏgpł܂B<br>
	 * Message: &#28858;&#20351;&#29992;&#35442;&#21151;&#33021;&#65292;&#20351;&#29992;&#32773;&#38651;&#33126;&#20839;&#38920;&#23433;&#35037;&#26368;&#26032;&#77;&#83;&#78;&#32;&#67;&#108;&#105;&#101;&#110;&#116;&#12290;<br>
	 * Message: To use this option, you must have the lastest version of MSN Messenger installed on your computer.
	 */
	public static final SystemMessageId LATEST_MSN_REQUIRED;
	
	/**
	 * ID: 1310<br>
	 * Message: l[WII  MSN Messenger̋@\gpɂ́AŐVo[W MSN Messenger CXg[Kv܂B<br>
	 * Message: &#28858;&#20351;&#29992;&#36938;&#25138;&#20839;&#25152;&#25552;&#20379;&#30340;&#77;&#83;&#78;&#32;&#77;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#25152;&#26377;&#21151;&#33021;&#65292;&#20351;&#29992;&#32773;&#38651;&#33126;&#20839;&#38920;&#23433;&#35037;&#26368;&#26032;&#77;&#83;&#78;&#32;&#67;&#108;&#105;&#101;&#110;&#116;&#12290;<br>
	 * Message: For full functionality, the latest version of MSN Messenger must be installed on your computer.
	 */
	public static final SystemMessageId LATEST_MSN_RECOMMENDED;
	
	/**
	 * ID: 1311<br>
	 * Message: Âo[W MSN Messenger ł̓CX^g bZ[W@\gpłAo̒ǉE폜уIvV@\͎gpł܂B<br>
	 * Message: &#33509;&#20351;&#29992;&#38750;&#26368;&#26032;&#29256;&#26412;&#30340;&#77;&#83;&#78;&#32;&#109;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#26178;&#65292;&#36938;&#25138;&#20013;&#30340;&#77;&#83;&#78;&#32;&#109;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#21482;&#33021;&#36914;&#34892;&#22522;&#26412;&#30340;&#23565;&#35441;&#65292;&#19988;&#19981;&#33021;&#20351;&#29992;&#26032;&#22686;&#47;&#21034;&#38500;&#22909;&#21451;&#21644;&#20854;&#20182;&#21151;&#33021;&#36984;&#38917;&#12290;<br>
	 * Message: Previous versions of MSN Messenger only provide the basic features for in-game MSN Messenger Chat. Add/Delete Contacts and other MSN Messenger options are not available
	 */
	public static final SystemMessageId MSN_ONLY_BASIC;
	
	/**
	 * ID: 1312<br>
	 * Message: ŐVo[W MSN Messenger 肷ɂ́AMSN Messenger ̃TCg(http://messenger.live.jp/download)ɈړĂB<br>
	 * Message: &#28858;&#23433;&#35037;&#26368;&#26032;&#29256;&#26412;&#30340;&#77;&#83;&#78;&#32;&#109;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#65292;&#35531;&#33950;&#33256;&#77;&#83;&#78;&#23448;&#26041;&#32178;&#22336;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#109;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#46;&#109;&#115;&#110;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#65292;&#35613;&#35613;&#65281;<br>
	 * Message: The latest version of MSN Messenger may be obtained from the MSN web site (http://messenger.msn.com).
	 */
	public static final SystemMessageId MSN_OBTAINED_FROM;
	
	/**
	 * ID: 1313<br>
	 * Message: $s2 ́AGkEV[EWp()񋟂T[rXɐڑĂ邽߁A$s1 Ƃ̃bZ[ẂAT[rX̉^ĉ߂ɕۑ܂BӒȂꍇ́ẢbEBhEĂBڂ͕Ѓz[y[W܂ł₢킹B<br>
	 * Message: &#36;&#115;&#49;&#24744;&#22909;&#65292;&#24744;&#25110;&#24744;&#30340;&#26379;&#21451;&#27491;&#22312;&#36914;&#34892;&#78;&#67;&#84;&#97;&#105;&#119;&#97;&#110;&#25152;&#25552;&#20379;&#30340;&#32218;&#19978;&#36938;&#25138;&#26381;&#21209;&#65292;&#26377;&#38364;&#36938;&#25138;&#35443;&#24773;&#35531;&#27965;&#22825;&#22530;&#73;&#73;&#23448;&#26041;&#32178;&#31449;&#65117;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#108;&#105;&#110;&#101;&#97;&#103;&#101;&#50;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65118;&#65292;&#35613;&#35613;&#65281;<br>
	 * Message: $s1, to better serve our customers, all chat histories [...]
	 */
	public static final SystemMessageId S1_CHAT_HISTORIES_STORED;
	
	/**
	 * ID: 1314<br>
	 * Message: ǉ郁o̓dq[ AhX͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#36992;&#35531;&#28858;&#22909;&#21451;&#32773;&#30340;&#80;&#97;&#115;&#115;&#112;&#111;&#114;&#116;&#24115;&#34399;&#12290;<br>
	 * Message: Please enter the passport ID of the person you wish to add to your contact list.
	 */
	public static final SystemMessageId ENTER_PASSPORT_FOR_ADDING;
	
	/**
	 * ID: 1315<br>
	 * Message: ̐l폜ƁAo Xgւ̓o^܂BA̐l֎~ȂA̐l͂Ȃ̃ICԂmFAbZ[W𑗐M邱Ƃł܂B<br>
	 * Message: &#33509;&#21034;&#38500;&#27492;&#32842;&#22825;&#23565;&#35937;&#65292;&#22312;&#32842;&#22825;&#23565;&#35937;&#30446;&#37636;&#20013;&#20063;&#26371;&#34987;&#21034;&#38500;&#12290;&#20294;&#26159;&#28961;&#27861;&#23553;&#37782;&#27492;&#32842;&#22825;&#23565;&#35937;&#35264;&#30475;&#26371;&#21729;&#24744;&#30340;&#36899;&#32218;&#29376;&#24907;&#25110;&#20659;&#36865;&#35338;&#24687;&#12290;<br>
	 * Message: Deleting a contact will remove that contact from MSN Messenger as well. The contact can still check your online status and well not be blocked from sending you a message.
	 */
	public static final SystemMessageId DELETING_A_CONTACT;
	
	/**
	 * ID: 1316<br>
	 * Message: ̐l֎~<br>
	 * Message: &#21034;&#38500;&#30340;&#21516;&#26178;&#23559;&#36914;&#34892;&#23553;&#37782;&#12290;<br>
	 * Message: The contact will be deleted and blocked from your contact list.
	 */
	public static final SystemMessageId CONTACT_WILL_DELETED;
	
	/**
	 * ID: 1317<br>
	 * Message: ̃o̓o^܂?<br>
	 * Message: &#35201;&#23559;&#27492;&#32879;&#32097;&#20154;&#21034;&#38500;&#21966;&#65311;<br>
	 * Message: Would you like to delete this contact?
	 */
	public static final SystemMessageId CONTACT_DELETE_CONFIRM;
	
	/**
	 * ID: 1318<br>
	 * Message: ֎~܂͋֎~郁oIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#23553;&#37782;&#47;&#35299;&#38500;&#20043;&#22909;&#21451;&#12290;<br>
	 * Message: Please select the contact you want to block or unblock.
	 */
	public static final SystemMessageId SELECT_CONTACT_FOR_BLOCK_UNBLOCK;
	
	/**
	 * ID: 1319<br>
	 * Message: O[vύX郁oIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#35722;&#26356;&#32676;&#32068;&#20043;&#22909;&#21451;&#12290;<br>
	 * Message: Please select the name of the contact you wish to change to another group.
	 */
	public static final SystemMessageId SELECT_CONTACT_FOR_CHANGE_GROUP;
	
	/**
	 * ID: 1320<br>
	 * Message: ړ̃O[vIāAOK NbNĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#35722;&#26356;&#30340;&#32676;&#32068;&#24460;&#65292;&#40670;&#25802;&#30906;&#23450;&#25353;&#37397;&#12290;<br>
	 * Message: After selecting the group you wish to move your contact to, press the OK button.
	 */
	public static final SystemMessageId SELECT_GROUP_PRESS_OK;
	
	/**
	 * ID: 1321<br>
	 * Message: ǉO[v͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#36861;&#21152;&#30340;&#32676;&#32068;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the name of the group you wish to add.
	 */
	public static final SystemMessageId ENTER_GROUP_NAME;
	
	/**
	 * ID: 1322<br>
	 * Message: ύXO[vIāAVO[v͂ĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#35722;&#26356;&#30340;&#32676;&#32068;&#24460;&#65292;&#36664;&#20837;&#35201;&#35722;&#26356;&#30340;&#21517;&#31281;&#12290;<br>
	 * Message: Select the group and enter the new name.
	 */
	public static final SystemMessageId SELECT_GROUP_ENTER_NAME;
	
	/**
	 * ID: 1323<br>
	 * Message: 폜O[vIāAOK NbNĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#21034;&#38500;&#30340;&#32676;&#32068;&#24460;&#65292;&#40670;&#25802;&#30906;&#35469;&#25353;&#37397;&#12290;<br>
	 * Message: Select the group you wish to delete and click the OK button.
	 */
	public static final SystemMessageId SELECT_GROUP_TO_DELETE;
	
	/**
	 * ID: 1324<br>
	 * Message: TCC...<br>
	 * Message: &#27491;&#22312;&#30331;&#20837;&#8230;<br>
	 * Message: Signing in...
	 */
	public static final SystemMessageId SIGNING_IN;
	
	/**
	 * ID: 1325<br>
	 * Message: ̏ꏊ Messenger ɃTCC߁A.NET Messenger Service TCAEg܂B<br>
	 * Message: &#24050;&#22312;&#21029;&#30340;&#38651;&#33126;&#39023;&#31034;&#28858;&#30331;&#20837;&#29376;&#24907;&#65292;&#22240;&#27492;&#22312;&#27492;&#38651;&#33126;&#30340;&#78;&#69;&#84;&#32;&#77;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#26381;&#21209;&#34987;&#30331;&#20986;&#12290;<br>
	 * Message: You've logged into another computer and have been logged out of the .NET Messenger Service on this computer.
	 */
	public static final SystemMessageId ANOTHER_COMPUTER_LOGOUT;
	
	/**
	 * ID: 1326<br>
	 * Message: $s1 ̔:<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#35498;&#65306;<br>
	 * Message: $s1 :
	 */
	public static final SystemMessageId S1_D;
	
	/**
	 * ID: 1327<br>
	 * Message: ̃bZ[W𑗂邱Ƃł܂B<br>
	 * Message: &#20197;&#19979;&#35338;&#24687;&#28961;&#27861;&#20659;&#36865;&#12290;<br>
	 * Message: The following message could not be delivered:
	 */
	public static final SystemMessageId MESSAGE_NOT_DELIVERED;
	
	/**
	 * ID: 1328<br>
	 * Message: ̊vRȂ̂ŁAł܂B<br>
	 * Message: &#30446;&#21069;&#38584;&#23660;&#26044;&#40643;&#26127;&#30340;&#38761;&#21629;&#36557;&#65292;&#25152;&#20197;&#28961;&#27861;&#24489;&#27963;&#12290;<br>
	 * Message: Members of the Revolutionaries of Dusk will not be resurrected.
	 */
	public static final SystemMessageId DUSK_NOT_RESURRECTED;
	
	/**
	 * ID: 1329<br>
	 * Message: lXьlH[͋֎~Ԃ̂߁AJ݂ł܂B<br>
	 * Message: &#29694;&#26159;&#34987;&#31105;&#27490;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#33287;&#20491;&#20154;&#24037;&#25151;&#20043;&#29376;&#24907;&#12290;<br>
	 * Message: You are currently blocked from using the Private Store and Private Workshop.
	 */
	public static final SystemMessageId BLOCKED_FROM_USING_STORE;
	
	/**
	 * ID: 1330<br>
	 * Message: $s1ԌlXьlH[̊J݂֎~܂B<br>
	 * Message: &#23559;&#34987;&#31105;&#27490;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#33287;&#20491;&#20154;&#24037;&#25151;&#36;&#115;&#49;&#20998;&#37912;&#12290;<br>
	 * Message: You may not open a Private Store or Private Workshop for another $s1 minute(s)
	 */
	public static final SystemMessageId NO_STORE_FOR_S1_MINUTES;
	
	/**
	 * ID: 1331<br>
	 * Message: lXьlH[̊J݋֎~܂B<br>
	 * Message: &#29694;&#35299;&#38500;&#31105;&#27490;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#33287;&#20491;&#20154;&#24037;&#25151;&#12290;<br>
	 * Message: You are no longer blocked from using the Private Store and Private Workshop
	 */
	public static final SystemMessageId NO_LONGER_BLOCKED_USING_STORE;
	
	/**
	 * ID: 1332<br>
	 * Message: łԂŃACe͎g܂B<br>
	 * Message: &#22312;&#27515;&#20129;&#29376;&#24907;&#19979;&#28961;&#27861;&#20351;&#29992;&#36947;&#20855;&#12290;<br>
	 * Message: Items may not be used after your character or pet dies.
	 */
	public static final SystemMessageId NO_ITEMS_AFTER_DEATH;
	
	/**
	 * ID: 1333<br>
	 * Message: vC t@Cǂݎ܂BReplay.init@CmFĂB<br>
	 * Message: &#28961;&#27861;&#35712;&#21462;&#37325;&#25773;&#27284;&#26696;&#65292;&#35531;&#30906;&#35469;&#82;&#101;&#112;&#108;&#97;&#121;&#46;&#105;&#110;&#105;&#27284;&#26696;&#12290;<br>
	 * Message: The replay file is not accessible. Please verify that the replay.ini exists in your Linage 2 directory.
	 */
	public static final SystemMessageId REPLAY_INACCESSIBLE;
	
	/**
	 * ID: 1334<br>
	 * Message: VJۑ܂B<br>
	 * Message: &#24050;&#20786;&#23384;&#26032;&#30340;&#37857;&#38957;&#36039;&#35338;&#12290;<br>
	 * Message: The new camera data has been stored.
	 */
	public static final SystemMessageId NEW_CAMERA_STORED;
	
	/**
	 * ID: 1335<br>
	 * Message: VJ̕ۑɎs܂B<br>
	 * Message: &#26032;&#30340;&#37857;&#38957;&#36039;&#35338;&#20786;&#23384;&#22833;&#25943;&#12290;<br>
	 * Message: The attempt to store the new camera data has failed.
	 */
	public static final SystemMessageId CAMERA_STORING_FAILED;
	
	/**
	 * ID: 1336<br>
	 * Message: vC t@C܂B$s1.$s2 t@CmFĂB<br>
	 * Message: &#37325;&#25773;&#27284;&#26696;&#34987;&#25613;&#22750;&#65292;&#35531;&#30906;&#35469;&#36;&#115;&#49;&#12290;&#36;&#115;&#50;&#32;&#27284;&#26696;&#12290;<br>
	 * Message: The replay file, $s1.$$s2 has been corrupted, please check the fle.
	 */
	public static final SystemMessageId REPLAY_S1_S2_CORRUPTED;
	
	/**
	 * ID: 1337<br>
	 * Message: vCI܂B낵łB<br>
	 * Message: &#32080;&#26463;&#37325;&#25773;&#12290;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: This will terminate the replay. Do you wish to continue?
	 */
	public static final SystemMessageId REPLAY_TERMINATE_CONFIRM;
	
	/**
	 * ID: 1338<br>
	 * Message: xɈڂƂ̂łʂ𒴉߂܂B<br>
	 * Message: &#36229;&#36942;&#19968;&#27425;&#25152;&#33021;&#25644;&#31227;&#30340;&#25976;&#37327;&#12290;<br>
	 * Message: You have exceeded the maximum amount that may be transferred at one time.
	 */
	public static final SystemMessageId EXCEEDED_MAXIMUM_AMOUNT;
	
	/**
	 * ID: 1339<br>
	 * Message: }NɊ蓖ĂꂽV[gJbg L[ʂ̃}NŎgp邱Ƃ͂ł܂B<br>
	 * Message: &#24050;&#26377;&#25351;&#23450;&#24040;&#38598;&#30340;&#24555;&#36895;&#37749;&#65292;&#19981;&#24471;&#20877;&#34987;&#25351;&#23450;&#28858;&#24040;&#38598;&#22519;&#34892;&#12290;<br>
	 * Message: Once a macro is assigned to a shortcut, it cannot be run as a macro again.
	 */
	public static final SystemMessageId MACRO_SHORTCUT_NOT_RUN;
	
	/**
	 * ID: 1340<br>
	 * Message: ݎgpĂN[|ł͐ڑłȂT[o[łB<br>
	 * Message: &#24744;&#25152;&#20351;&#29992;&#30340;&#24115;&#34399;&#28961;&#27861;&#36914;&#20837;&#27492;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: This server cannot be accessed by the coupon you are using.
	 */
	public static final SystemMessageId SERVER_NOT_ACCESSED_BY_COUPON;
	
	/**
	 * ID: 1341<br>
	 * Message: ͂ꂽdq[ AhX͖łB<br>
	 * Message: &#24744;&#36664;&#20837;&#30340;&#22995;&#21517;&#25110;&#37109;&#20214;&#20449;&#31665;&#26377;&#35492;&#12290;<br>
	 * Message: Incorrect name and/or email address.
	 */
	public static final SystemMessageId INCORRECT_NAME_OR_ADDRESS;
	
	/**
	 * ID: 1342<br>
	 * Message: łɃTCCĂ܂B<br>
	 * Message: &#24050;&#26377;&#30331;&#20837;&#12290;<br>
	 * Message: You are already logged in.
	 */
	public static final SystemMessageId ALREADY_LOGGED_IN;
	
	/**
	 * ID: 1343<br>
	 * Message: ͂ꂽTCC݂ȂApX[hȂ߁ATCCł܂łB<br>
	 * Message: &#24744;&#36664;&#20837;&#30340;&#23494;&#30908;&#25110;&#37109;&#20214;&#20449;&#31665;&#26377;&#35492;&#65292;&#25925;&#28961;&#27861;&#30331;&#20837;&#12290;&#78;&#69;&#84;&#32;&#77;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#32;&#83;&#101;&#114;&#118;&#105;&#99;&#101;&#12290;<br>
	 * Message: Incorrect email address and/or password. Your attempt to log into .NET Messenger Service has failed.
	 */
	public static final SystemMessageId INCORRECT_ADDRESS_OR_PASSWORD;
	
	/**
	 * ID: 1344<br>
	 * Message: T[rXȂ߁ANET Messenger Service ɃTCCł܂łBC^[lbgɐڑĂ邱ƂmFĂB<br>
	 * Message: &#28961;&#27861;&#25214;&#21040;&#26381;&#21209;&#65292;&#25925;&#28961;&#27861;&#30331;&#20837;&#12290;&#78;&#69;&#84;&#32;&#77;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#32;&#83;&#101;&#114;&#118;&#105;&#99;&#101;&#12290;&#35531;&#30906;&#35469;&#30446;&#21069;&#26159;&#21542;&#26377;&#36899;&#32218;&#12290;<br>
	 * Message: Your request to log into the .NET Messenger service has failed. Please verify that you are currently connected to the internet.
	 */
	public static final SystemMessageId NET_LOGIN_FAILED;
	
	/**
	 * ID: 1345<br>
	 * Message: ̉bɏ҂lIāAOK NbN܂B<br>
	 * Message: &#36984;&#21462;&#32879;&#32097;&#20154;&#24460;&#35531;&#40670;&#25802;&#12300;&#30906;&#23450;&#12301;&#37749;&#12290;<br>
	 * Message: Click the OK button after you have selected a contact name.
	 */
	public static final SystemMessageId SELECT_CONTACT_CLICK_OK;
	
	/**
	 * ID: 1346<br>
	 * Message: bZ[W͂Ă܂B<br>
	 * Message: &#20351;&#29992;&#32773;&#27491;&#22312;&#36664;&#20837;&#35338;&#24687;&#12290;<br>
	 * Message: You are currently entering a chat message.
	 */
	public static final SystemMessageId CURRENTLY_ENTERING_CHAT;
	
	/**
	 * ID: 1347<br>
	 * Message: Lineage II Messenger  vł܂łB<br>
	 * Message: &#22825;&#22530;&#73;&#73;&#32;&#77;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#28961;&#27861;&#22519;&#34892;&#24744;&#35201;&#27714;&#30340;&#20316;&#26989;&#12290;<br>
	 * Message: The Linage II messenger could not carry out the task you requested.
	 */
	public static final SystemMessageId MESSENGER_FAILED_CARRYING_OUT_TASK;
	
	/**
	 * ID: 1348<br>
	 * Message: $s1 bɎQ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#32;&#21443;&#33287;&#20102;&#32842;&#22825;&#12290;<br>
	 * Message: $s1 has entered the chat room.
	 */
	public static final SystemMessageId S1_ENTERED_CHAT_ROOM;
	
	/**
	 * ID: 1349<br>
	 * Message: $s1 bސȂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#32;&#38626;&#38283;&#20102;&#32842;&#22825;&#23460;&#12290;<br>
	 * Message: $s1 has left the chat room.
	 */
	public static final SystemMessageId S1_LEFT_CHAT_ROOM;
	
	/**
	 * ID: 1350<br>
	 * Message: ԂItCɕύX܂BׂẲbEBhEI܂B<br>
	 * Message: &#23559;&#29694;&#29376;&#24907;&#35722;&#26356;&#28858;&#12300;&#27161;&#31034;&#28858;&#38626;&#32218;&#12301;&#12290;&#29694;&#38283;&#21855;&#30340;&#25152;&#26377;&#32842;&#22825;&#35222;&#31383;&#23559;&#34987;&#38364;&#38281;&#12290;<br>
	 * Message: The state will be changed to indicate "off-line." All the chat windows currently opened will be closed.
	 */
	public static final SystemMessageId GOING_OFFLINE;
	
	/**
	 * ID: 1351<br>
	 * Message: 폜郁oIāA폜 NbNĂB<br>
	 * Message: &#23559;&#35201;&#21034;&#38500;&#30340;&#22909;&#21451;&#36984;&#25799;&#24460;&#35531;&#40670;&#25802;&#21034;&#38500;&#37749;&#12290;<br>
	 * Message: Click the Delete button after selecting the contact you wish to remove.
	 */
	public static final SystemMessageId SELECT_CONTACT_CLICK_REMOVE;
	
	/**
	 * ID: 1352<br>
	 * Message: $s1 ($s2) ̃o Xgɒǉ܂B<br>
	 * Message: &#24744;&#34987;&#30331;&#37636;&#22312;&#32;&#36;&#115;&#49;&#32;&#65288;&#36;&#115;&#50;&#65289;&#30340;&#32879;&#32097;&#20154;&#30446;&#37636;&#12290;<br>
	 * Message: You have been added to $s1 ($s2)'s contact list.
	 */
	public static final SystemMessageId ADDED_TO_S1_S2_CONTACT_LIST;
	
	/**
	 * ID: 1353<br>
	 * Message: łItCԂɂ邱Ƃł܂B<br>
	 * Message: &#38568;&#26178;&#37117;&#21487;&#20197;&#23559;&#25152;&#26377;&#32879;&#32097;&#20154;&#25152;&#30475;&#21040;&#30340;&#25105;&#30340;&#29376;&#24907;&#35373;&#23450;&#28858;&#38626;&#32218;&#12290;<br>
	 * Message: You can set the option to show your status as always being off-line to all of your contacts.
	 */
	public static final SystemMessageId CAN_SET_OPTION_TO_ALWAYS_SHOW_OFFLINE;
	
	/**
	 * ID: 1354<br>
	 * Message: `bg֎~̂߁Abł܂B<br>
	 * Message: &#22312;&#31105;&#27490;&#32842;&#22825;&#30340;&#29376;&#24907;&#19979;&#65292;&#19981;&#33021;&#36914;&#34892;&#22909;&#21451;&#23565;&#35441;&#12290;<br>
	 * Message: You are not allowed to chat with a contact while chatting block is imposed.
	 */
	public static final SystemMessageId NO_CHAT_WHILE_BLOCKED;
	
	/**
	 * ID: 1355<br>
	 * Message: b̑͌݃`bg֎~̏ԂłB<br>
	 * Message: &#24819;&#35201;&#32842;&#22825;&#30340;&#23565;&#35937;&#65292;&#30446;&#21069;&#26159;&#31105;&#27490;&#32842;&#22825;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: The contact is currently blocked from chatting.
	 */
	public static final SystemMessageId CONTACT_CURRENTLY_BLOCKED;
	
	/**
	 * ID: 1356<br>
	 * Message: b̑͌ݐڑĂ܂B<br>
	 * Message: &#24819;&#35201;&#32842;&#22825;&#30340;&#23565;&#35937;&#65292;&#30446;&#21069;&#23578;&#26410;&#36899;&#32218;&#12290;<br>
	 * Message: The contact is not currently logged in.
	 */
	public static final SystemMessageId CONTACT_CURRENTLY_OFFLINE;
	
	/**
	 * ID: 1357<br>
	 * Message: b̑ɂċ֎~ĂԂłB<br>
	 * Message: &#30446;&#21069;&#26159;&#34987;&#23565;&#26041;&#23553;&#37782;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: You have been blocked from chatting with that contact.
	 */
	public static final SystemMessageId YOU_ARE_BLOCKED;
	
	/**
	 * ID: 1358<br>
	 * Message: TCAEg...<br>
	 * Message: &#27491;&#22312;&#38626;&#32218;&#20013;&#8230;<br>
	 * Message: You are being logged out...
	 */
	public static final SystemMessageId YOU_ARE_LOGGING_OUT;
	
	/**
	 * ID: 1359<br>
	 * Message: $s1 TCC܂B<br>
	 * Message: &#20320;&#30340;&#22909;&#21451;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#30331;&#20837;&#12290;<br>
	 * Message: $s1 has logged in.
	 */
	public static final SystemMessageId S1_LOGGED_IN2;
	
	/**
	 * ID: 1360<br>
	 * Message: $s1 ̐VbZ[W͂܂B<br>
	 * Message: &#24478;&#12300;&#36;&#115;&#49;&#12301;&#32;&#37027;&#20818;&#25910;&#21040;&#20102;&#26032;&#37109;&#20214;&#12290;<br>
	 * Message: You have received a message from $s1.
	 */
	public static final SystemMessageId GOT_MESSAGE_FROM_S1;
	
	/**
	 * ID: 1361<br>
	 * Message: VXe guɂ .NET Messenger Service TCAEg܂B<br>
	 * Message: &#22240;&#31995;&#32113;&#21839;&#38988;&#65292;&#34987;&#36843;&#30331;&#20986;&#46;&#78;&#69;&#84;&#32;&#77;&#101;&#115;&#115;&#101;&#110;&#103;&#101;&#114;&#32;&#83;&#101;&#114;&#118;&#105;&#99;&#101;&#12290;<br>
	 * Message: Due to a system error, you have been logged out of the .NET Messenger Service.
	 */
	public static final SystemMessageId LOGGED_OUT_DUE_TO_ERROR;
	
	/**
	 * ID: 1362<br>
	 * click the button next to My Status and then use the Options menu.
	 */
	public static final SystemMessageId SELECT_CONTACT_TO_DELETE;
	
	/**
	 * ID: 1363<br>
	 * Message: ̐\݂ۂ܂B<br>
	 * Message: &#21516;&#30431;&#25136;&#30003;&#35531;&#34987;&#25298;&#32085;&#12290;<br>
	 * Message: Your request to participate in the alliance war has been denied.
	 */
	public static final SystemMessageId YOUR_REQUEST_ALLIANCE_WAR_DENIED;
	
	/**
	 * ID: 1364<br>
	 * Message: ̐\݂ۂ܂B<br>
	 * Message: &#25298;&#32085;&#20102;&#21516;&#30431;&#25136;&#36992;&#35531;&#12290;<br>
	 * Message: The request for an alliance war has been rejected.
	 */
	public static final SystemMessageId REQUEST_ALLIANCE_WAR_REJECTED;
	
	/**
	 * ID: 1365<br>
	 * Message: $s1$s2l~܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#29544;&#33258;&#25237;&#38477;&#20102;&#12290;<br>
	 * Message: $s2 of $s1 clan has surrendered as an individual.
	 */
	public static final SystemMessageId S2_OF_S1_SURRENDERED_AS_INDIVIDUAL;
	
	/**
	 * ID: 1366<br>
	 * Message: 폜ł̂́ÃO[v݂̂łB̃O[vׂ̂Ẵo𑼂̃O[vɈړĂB<br>
	 * Message: &#21482;&#33021;&#22312;&#32676;&#32068;&#20839;&#27794;&#26377;&#32879;&#32097;&#20154;&#30340;&#24773;&#27841;&#19979;&#21034;&#38500;&#32676;&#32068;&#12290;&#35201;&#21034;&#38500;&#32676;&#32068;&#30340;&#35441;&#65292;&#35531;&#20808;&#23559;&#32879;&#32097;&#20154;&#31227;&#33267;&#20854;&#20182;&#32676;&#32068;&#20839;&#12290;<br>
	 * Message: In order to delete a group, you must not [...]
	 */
	public static final SystemMessageId DELTE_GROUP_INSTRUCTION;
	
	/**
	 * ID: 1367<br>
	 * Message: ֘AłȂ̂ŁAL^ǉł܂B<br>
	 * Message: &#22240;&#19981;&#26159;&#30456;&#21516;&#38499;&#29151;&#65292;&#25152;&#20197;&#28961;&#27861;&#36861;&#21152;&#32000;&#37636;&#12290;<br>
	 * Message: Only members of the group are allowed to add records.
	 */
	public static final SystemMessageId ONLY_GROUP_CAN_ADD_RECORDS;
	
	/**
	 * ID: 1368<br>
	 * Message: ꏏɒpłACeł͂܂B<br>
	 * Message: &#27492;&#28858;&#19981;&#33021;&#21516;&#26178;&#35430;&#31359;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: You can not try those items on at the same time.
	 */
	public static final SystemMessageId YOU_CAN_NOT_TRY_THOSE_ITEMS_ON_AT_THE_SAME_TIME;
	
	/**
	 * ID: 1369<br>
	 * Message: ݒłōz𒴉߂܂B<br>
	 * Message: &#36229;&#20986;&#25152;&#33021;&#35373;&#23450;&#30340;&#26368;&#39640;&#37329;&#38989;&#38480;&#24230;&#12290;<br>
	 * Message: You've exceeded the maximum.
	 */
	public static final SystemMessageId EXCEEDED_THE_MAXIMUM;
	
	/**
	 * ID: 1370<br>
	 * Message: $c1 ͉^c҂Ȃ̂Ń[𑗂邱Ƃł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#26159;&#71;&#77;&#65292;&#25152;&#20197;&#28961;&#27861;&#20659;&#36865;&#37109;&#20214;&#12290;<br>
	 * Message: Your message to $c1 did not reach its recipient. You cannot send mail to the GM staff.
	 */
	public static final SystemMessageId CANNOT_MAIL_GM_C1;
	
	/**
	 * ID: 1371<br>
	 * Message: M͐ɃvCĂȂƔfA$s1ԓȂȂ[uƂ܂B<br>
	 * Message: &#32147;&#26597;&#35657;&#24744;&#27794;&#26377;&#36981;&#23432;&#27491;&#24120;&#30340;&#36938;&#25138;&#35215;&#21063;&#65292;&#25925;&#34987;&#34389;&#32622;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#20839;&#28961;&#27861;&#31227;&#21205;&#12290;<br>
	 * Message: It has been determined that you're not engaged in normal gameplay and a restriction has been imposed upon you. You may not move for $s1 minutes.
	 */
	public static final SystemMessageId GAMEPLAY_RESTRICTION_PENALTY_S1;
	
	/**
	 * ID: 1372<br>
	 * Message: ݓȂԂłB悤ɂȂ܂ł̎c莞Ԃ͂$s1łB<br>
	 * Message: &#29694;&#22312;&#34389;&#26044;&#28961;&#27861;&#31227;&#21205;&#30340;&#29376;&#24907;&#12290;&#36317;&#38626;&#21487;&#31227;&#21205;&#30340;&#26178;&#38291;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: Your punishment will continue for $s1 minutes.
	 */
	public static final SystemMessageId PUNISHMENT_CONTINUE_S1_MINUTES;
	
	/**
	 * ID: 1373<br>
	 * Message: $c1Ch {XƂ$s2ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#36215;&#29417;&#29557;&#39318;&#38936;&#25481;&#33853;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has picked up $s2 that was dropped by a Raid Boss.
	 */
	public static final SystemMessageId C1_PICKED_UP_S2_FROM_RAIDBOSS;
	
	/**
	 * ID: 1374<br>
	 * Message: $c1Ch {XƂ$s2 $s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#36215;&#29417;&#29557;&#39318;&#38936;&#25481;&#33853;&#30340;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has picked up $s3 $s2(s) that was dropped by a Raid Boss.
	 */
	public static final SystemMessageId C1_PICKED_UP_S3_S2_S_FROM_RAIDBOSS;
	
	/**
	 * ID: 1375<br>
	 * Message: $c1Ch {XƂ$s2Afiɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#36215;&#29417;&#29557;&#39318;&#38936;&#25481;&#33853;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: $c1 has picked up $s2 adena that was dropped by a Raid Boss.
	 */
	public static final SystemMessageId C1_PICKED_UP_S2_ADENA_FROM_RAIDBOSS;
	
	/**
	 * ID: 1376<br>
	 * Message: $c1̐lƂ$s2ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#36215;&#20854;&#20182;&#29609;&#23478;&#25481;&#33853;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has picked up $s2 that was dropped by another character.
	 */
	public static final SystemMessageId C1_PICKED_UP_S2_FROM_ANOTHER_CHARACTER;
	
	/**
	 * ID: 1377<br>
	 * Message: $c1̐lƂ$s2 $s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#36215;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#20854;&#20182;&#29609;&#23478;&#25481;&#33853;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has picked up $s3 $s2(s) that was dropped by a another character.
	 */
	public static final SystemMessageId C1_PICKED_UP_S3_S2_S_FROM_ANOTHER_CHARACTER;
	
	/**
	 * ID: 1378<br>
	 * Message: $c1̐lƂ+$s3$s2ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#36215;&#20854;&#20182;&#29609;&#23478;&#25481;&#33853;&#30340;&#12300;&#43;&#36;&#115;&#51;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has picked up +$s3 $s2 that was dropped by a another character.
	 */
	public static final SystemMessageId C1_PICKED_UP_S3_S2_FROM_ANOTHER_CHARACTER;
	
	/**
	 * ID: 1379<br>
	 * Message: $c1$s2Afiɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: $c1 has obtained $s2 adena.
	 */
	public static final SystemMessageId C1_OBTAINED_S2_ADENA;
	
	/**
	 * ID: 1380<br>
	 * Message: ł$s1ł܂B<br>
	 * Message: &#22312;&#25136;&#22580;&#28961;&#27861;&#21484;&#21914;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You can't summon a $s1 while on the battleground.
	 */
	public static final SystemMessageId CANT_SUMMON_S1_ON_BATTLEGROUND;
	
	/**
	 * ID: 1381<br>
	 * Message: p[eB [_[$s1$s2l܂B<br>
	 * Message: &#38538;&#20237;&#38538;&#38263;&#29554;&#24471;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The party leader has obtained $s2 of $s1.
	 */
	public static final SystemMessageId LEADER_OBTAINED_S2_OF_S1;
	
	/**
	 * ID: 1382<br>
	 * Message: {ɂ̕I܂B NGXg邽߂ɂ́AIKėȂ΂Ȃ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#36984;&#25799;&#36889;&#20491;&#27494;&#22120;&#21966;&#65311;&#28858;&#23436;&#25104;&#20219;&#21209;&#38920;&#23559;&#25152;&#36984;&#30340;&#27494;&#22120;&#24118;&#22238;&#20358;&#25165;&#34892;&#12290;<br>
	 * Message: To fulfill the quest, you must bring the chosen weapon. Are you sure you want to choose this weapon?
	 */
	public static final SystemMessageId CHOOSE_WEAPON_CONFIRM;
	
	/**
	 * ID: 1383<br>
	 * Message: {ɕς܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#20132;&#25563;&#21966;&#65311;<br>
	 * Message: Are you sure you want to exchange?
	 */
	public static final SystemMessageId EXCHANGE_CONFIRM;
	
	/**
	 * ID: 1384<br>
	 * Message: $c1p[eB [_[ɂȂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25104;&#28858;&#38538;&#20237;&#38538;&#38263;&#12290;<br>
	 * Message: $c1 has become the party leader.
	 */
	public static final SystemMessageId C1_HAS_BECOME_A_PARTY_LEADER;
	
	/**
	 * ID: 1385<br>
	 * Message: ~ȂGAłB<br>
	 * Message: &#27492;&#22320;&#21312;&#28961;&#27861;&#19979;&#21435;&#12290;<br>
	 * Message: You are not allowed to dismount at this location.
	 */
	public static final SystemMessageId NO_DISMOUNT_HERE;
	
	/**
	 * ID: 1386<br>
	 * Message: ~Ԃ܂B<br>
	 * Message: &#35299;&#38500;&#20102;&#20572;&#27490;&#29376;&#24907;&#12290;<br>
	 * Message: You are no longer held in place.
	 */
	public static final SystemMessageId NO_LONGER_HELD_IN_PLACE;
	
	/**
	 * ID: 1387<br>
	 * Message: pACeIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#35430;&#31359;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: Please select the item you would like to try on.
	 */
	public static final SystemMessageId SELECT_ITEM_TO_TRY_ON;
	
	/**
	 * ID: 1388<br>
	 * Message: p[eB [܂B<br>
	 * Message: &#38538;&#20237;&#25151;&#38291;&#24050;&#23436;&#25104;&#12290;<br>
	 * Message: A party room has been created.
	 */
	public static final SystemMessageId PARTY_ROOM_CREATED;
	
	/**
	 * ID: 1389<br>
	 * Message: p[eB [̏񂪏C܂B<br>
	 * Message: &#24050;&#20462;&#25913;&#38538;&#20237;&#25151;&#38291;&#36039;&#35338;&#12290;<br>
	 * Message: The party room's information has been revised.
	 */
	public static final SystemMessageId PARTY_ROOM_REVISED;
	
	/**
	 * ID: 1390<br>
	 * Message: p[eB [ɓł܂B<br>
	 * Message: &#28961;&#27861;&#36914;&#20837;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: You are not allowed to enter the party room.
	 */
	public static final SystemMessageId PARTY_ROOM_FORBIDDEN;
	
	/**
	 * ID: 1391<br>
	 * Message: p[eB [ޏꂵ܂B<br>
	 * Message: &#24050;&#36864;&#20986;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: You have exited from the party room.
	 */
	public static final SystemMessageId PARTY_ROOM_EXITED;
	
	/**
	 * ID: 1392<br>
	 * Message: $c1p[eB [ޏꂵ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#38626;&#38283;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: $c1 has left the party room.
	 */
	public static final SystemMessageId C1_LEFT_PARTY_ROOM;
	
	/**
	 * ID: 1393<br>
	 * Message: p[eB [Ǖ܂B<br>
	 * Message: &#24744;&#34987;&#36880;&#20986;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: You have been ousted from the party room.
	 */
	public static final SystemMessageId OUSTED_FROM_PARTY_ROOM;
	
	/**
	 * ID: 1394<br>
	 * Message: $c1p[eB [Ǖ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34987;&#36880;&#20986;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: $c1 has been kicked from the party room.
	 */
	public static final SystemMessageId C1_KICKED_FROM_PARTY_ROOM;
	
	/**
	 * ID: 1395<br>
	 * Message: p[eB [I܂B<br>
	 * Message: &#38538;&#20237;&#25151;&#38291;&#24050;&#34987;&#35299;&#25955;&#12290;<br>
	 * Message: The party room has been disbanded.
	 */
	public static final SystemMessageId PARTY_ROOM_DISBANDED;
	
	/**
	 * ID: 1396<br>
	 * Message: p[eBɉĂȂAp[eB [_[łȂƁAp[eB [̃Xg邱Ƃ͂ł܂B<br>
	 * Message: &#26410;&#21152;&#20837;&#38538;&#20237;&#32773;&#25110;&#26159;&#21482;&#26377;&#38538;&#20237;&#38538;&#38263;&#25165;&#33021;&#26597;&#30475;&#38538;&#20237;&#25151;&#38291;&#30446;&#37636;&#12290;<br>
	 * Message: The list of party rooms can only be viewed by a person who has not joined a party or who is currently the leader of a party.
	 */
	public static final SystemMessageId CANT_VIEW_PARTY_ROOMS;
	
	/**
	 * ID: 1397<br>
	 * Message: p[eB [̃[ [_[ύX܂B<br>
	 * Message: &#38538;&#20237;&#25151;&#38291;&#20027;&#20154;&#24050;&#35722;&#26356;&#12290;<br>
	 * Message: The leader of the party room has changed.
	 */
	public static final SystemMessageId PARTY_ROOM_LEADER_CHANGED;
	
	/**
	 * ID: 1398<br>
	 * Message: p[eB o[W܂B<br>
	 * Message: &#24501;&#27714;&#38538;&#20237;&#25104;&#21729;&#12290;<br>
	 * Message: We are recruiting party members.
	 */
	public static final SystemMessageId RECRUITING_PARTY_MEMBERS;
	
	/**
	 * ID: 1399<br>
	 * Message: p[eB [_[̂݌Ϗ邱Ƃł܂B<br>
	 * Message: &#21482;&#26377;&#38538;&#20237;&#38538;&#38263;&#25165;&#33021;&#36681;&#35731;&#27402;&#38480;&#12290;<br>
	 * Message: Only the leader of the party can transfer party leadership to another player.
	 */
	public static final SystemMessageId ONLY_A_PARTY_LEADER_CAN_TRANSFER_ONES_RIGHTS_TO_ANOTHER_PLAYER;
	
	/**
	 * ID: 1400<br>
	 * Message: p[eB [_[̌ϏΏۂIĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#36681;&#35731;&#38538;&#20237;&#38538;&#38263;&#27402;&#38480;&#20043;&#23565;&#35937;&#12290;<br>
	 * Message: Please select the person you wish to make the party leader.
	 */
	public static final SystemMessageId PLEASE_SELECT_THE_PERSON_TO_WHOM_YOU_WOULD_LIKE_TO_TRANSFER_THE_RIGHTS_OF_A_PARTY_LEADER;
	
	/**
	 * ID: 1401<br>
	 * Message: gɌϏ邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#37341;&#23565;&#33258;&#24049;&#36681;&#35731;&#27402;&#38480;&#12290;<br>
	 * Message: Slow down.you are already the party leader.
	 */
	public static final SystemMessageId YOU_CANNOT_TRANSFER_RIGHTS_TO_YOURSELF;
	
	/**
	 * ID: 1402<br>
	 * Message: p[eB o[ɂ̂݌̈Ϗ\łB<br>
	 * Message: &#21482;&#33021;&#23559;&#27402;&#38480;&#36681;&#35731;&#32102;&#38538;&#20237;&#25104;&#21729;&#12290;<br>
	 * Message: You may only transfer party leadership to another member of the party.
	 */
	public static final SystemMessageId YOU_CAN_TRANSFER_RIGHTS_ONLY_TO_ANOTHER_PARTY_MEMBER;
	
	/**
	 * ID: 1403<br>
	 * Message: p[eB [_[̌ϏɎs܂B<br>
	 * Message: &#38538;&#20237;&#38538;&#38263;&#20043;&#27402;&#38480;&#36681;&#35731;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to transfer the party leadership.
	 */
	public static final SystemMessageId YOU_HAVE_FAILED_TO_TRANSFER_THE_PARTY_LEADER_RIGHTS;
	
	/**
	 * ID: 1404<br>
	 * Message: lH[̎l쉿iύX܂BύXꂽixmFČ䗘pB<br>
	 * Message: &#20491;&#20154;&#24037;&#25151;&#20027;&#20154;&#35722;&#26356;&#20102;&#35069;&#36896;&#20729;&#26684;&#12290;&#35531;&#37325;&#26032;&#30906;&#35469;&#35722;&#26356;&#20729;&#26684;&#24460;&#20877;&#21033;&#29992;&#12290;<br>
	 * Message: The owner of the private manufacturing store has changed the price for creating this item. Please check the new price before trying again.
	 */
	public static final SystemMessageId MANUFACTURE_PRICE_HAS_CHANGED;
	
	/**
	 * ID: 1405<br>
	 * Message: $s1CP񕜂܂B<br>
	 * Message: &#24674;&#24489;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#67;&#80;&#12290;<br>
	 * Message: $s1 CPs have been restored.
	 */
	public static final SystemMessageId S1_CP_WILL_BE_RESTORED;
	
	/**
	 * ID: 1406<br>
	 * Message: $c1ɂ$s2CP񕜂܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#24674;&#24489;&#67;&#80;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $s2 CPs has been restored by $c1.
	 */
	public static final SystemMessageId S2_CP_WILL_BE_RESTORED_BY_C1;
	
	/**
	 * ID: 1407<br>
	 * Message: 2̃AJEgœɃANZXłȂPCgpĂ܂B<br>
	 * Message: &#24744;&#20351;&#29992;&#30340;&#38651;&#33126;&#19981;&#33021;&#21516;&#26178;&#30331;&#20837;&#20841;&#20491;&#24115;&#34399;&#12290;<br>
	 * Message: You are using a computer that does not allow you to log in with two accounts at the same time.
	 */
	public static final SystemMessageId NO_LOGIN_WITH_TWO_ACCOUNTS;
	
	/**
	 * ID: 1408<br>
	 * Message: ۋԂ̎c$s1 $s2łB\ς݂̌ς$s3łB<br>
	 * Message: &#24744;&#30340;&#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;&#24050;&#38928;&#32004;&#30340;&#20184;&#36027;&#21830;&#21697;&#25110;&#24207;&#34399;&#23578;&#26377;&#12300;&#36;&#115;&#51;&#12301;&#20214;&#12290;<br>
	 * Message: Your prepaid remaining usage time is $s1 hours and $s2 minutes. You have $s3 paid reservations left.
	 */
	public static final SystemMessageId PREPAID_LEFT_S1_S2_S3;
	
	/**
	 * ID: 1409<br>
	 * Message: ۋԂ̂ŗ\ς݂̌ςLɂȂ܂Bc莞Ԃ$s1 $s2łB<br>
	 * Message: &#24744;&#30340;&#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#24050;&#21040;&#26399;&#65292;&#23559;&#20351;&#29992;&#19979;&#19968;&#20491;&#20184;&#36027;&#21830;&#21697;&#25110;&#24207;&#34399;&#12290;&#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: Your prepaid usage time has expired. Your new prepaid reservation will be used. The remaining usage time is $s1 hours and $s2 minutes.
	 */
	public static final SystemMessageId PREPAID_EXPIRED_S1_S2;
	
	/**
	 * ID: 1410<br>
	 * Message: ۋԂ܂B\ς݂̌ς͂܂B<br>
	 * Message: &#24744;&#30340;&#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#24050;&#21040;&#26399;&#12290;&#30446;&#21069;&#27794;&#26377;&#38928;&#32004;&#30340;&#20184;&#36027;&#21830;&#21697;&#25110;&#24207;&#34399;&#12290;<br>
	 * Message: Your prepaid usage time has expired. You do not have any more prepaid reservations left.
	 */
	public static final SystemMessageId PREPAID_EXPIRED;
	
	/**
	 * ID: 1411<br>
	 * Message: ۋϗ\񌏐ύX܂B<br>
	 * Message: &#38928;&#32004;&#30340;&#20184;&#36027;&#21830;&#21697;&#25110;&#24207;&#34399;&#20214;&#25976;&#24050;&#35722;&#26356;&#12290;<br>
	 * Message: The number of your prepaid reservations has changed.
	 */
	public static final SystemMessageId PREPAID_CHANGED;
	
	/**
	 * ID: 1412<br>
	 * Message: ۋԂ͎c$s1łB<br>
	 * Message: &#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: Your prepaid usage time has $s1 minutes left.
	 */
	public static final SystemMessageId PREPAID_LEFT_S1;
	
	/**
	 * ID: 1413<br>
	 * Message: Ȃ߁Ap[eB [ɓł܂B<br>
	 * Message: &#22240;&#26781;&#20214;&#19981;&#21512;&#32780;&#28961;&#27861;&#36914;&#20837;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: You do not meet the requirements to enter that party room.
	 */
	public static final SystemMessageId CANT_ENTER_PARTY_ROOM;
	
	/**
	 * ID: 1414<br>
	 * Message: ́A100ȏAc5000ɂĂB<br>
	 * Message: &#38263;&#23532;&#30340;&#38480;&#21046;&#21508;&#38920;&#22312;&#49;&#48;&#48;&#20197;&#19978;&#21040;&#26410;&#28415;&#53;&#48;&#48;&#48;&#25165;&#34892;&#12290;<br>
	 * Message: The width and length should be 100 or more grids and less than 5000 grids respectively.
	 */
	public static final SystemMessageId WRONG_GRID_COUNT;
	
	/**
	 * ID: 1415<br>
	 * Message: R}h t@Cw肳Ă܂B<br>
	 * Message: &#21629;&#20196;&#35486;&#27284;&#26696;&#26410;&#34987;&#25351;&#23450;&#12290;<br>
	 * Message: The command file is not sent.
	 */
	public static final SystemMessageId COMMAND_FILE_NOT_SENT;
	
	/**
	 * ID: 1416<br>
	 * Message: 1`[̃[_[IĂ܂B<br>
	 * Message: &#49;&#32068;&#38538;&#20237;&#30340;&#20195;&#34920;&#26410;&#34987;&#36984;&#25799;&#12290;<br>
	 * Message: The representative of Team 1 has not been selected.
	 */
	public static final SystemMessageId TEAM_1_NO_REPRESENTATIVE;
	
	/**
	 * ID: 1417<br>
	 * Message: 2`[̃[_[IĂ܂B<br>
	 * Message: &#50;&#32068;&#38538;&#20237;&#30340;&#20195;&#34920;&#26410;&#34987;&#36984;&#25799;&#12290;<br>
	 * Message: The representative of Team 2 has not been selected.
	 */
	public static final SystemMessageId TEAM_2_NO_REPRESENTATIVE;
	
	/**
	 * ID: 1418<br>
	 * Message: 1`[̖̂w肳Ă܂B<br>
	 * Message: &#49;&#32068;&#21517;&#31281;&#26410;&#34987;&#25351;&#23450;&#12290;<br>
	 * Message: The name of Team 1 has not yet been chosen.
	 */
	public static final SystemMessageId TEAM_1_NO_NAME;
	
	/**
	 * ID: 1419<br>
	 * Message: 2`[̖̂w肳Ă܂B<br>
	 * Message: &#50;&#32068;&#21517;&#31281;&#26410;&#34987;&#25351;&#23450;&#12290;<br>
	 * Message: The name of Team 2 has not yet been chosen.
	 */
	public static final SystemMessageId TEAM_2_NO_NAME;
	
	/**
	 * ID: 1420<br>
	 * Message: 1`[Ƒ2`[̖̂łB<br>
	 * Message: &#49;&#32068;&#21644;&#50;&#32068;&#21517;&#31281;&#30456;&#21516;&#12290;<br>
	 * Message: The name of Team 1 and the name of Team 2 are identical.
	 */
	public static final SystemMessageId TEAM_NAME_IDENTICAL;
	
	/**
	 * ID: 1421<br>
	 * Message: Zݒt@Cw肳Ă܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#26410;&#34987;&#25351;&#23450;&#12290;<br>
	 * Message: The race setup file has not been designated.
	 */
	public static final SystemMessageId RACE_SETUP_FILE1;
	
	/**
	 * ID: 1422<br>
	 * Message: Zݒt@C G[FBuffCntĂ܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#66;&#117;&#102;&#102;&#67;&#110;&#116;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - BuffCnt is not specified
	 */
	public static final SystemMessageId RACE_SETUP_FILE2;
	
	/**
	 * ID: 1423<br>
	 * Message: Zݒt@C G[FBuffID$s1Ă܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#66;&#117;&#102;&#102;&#68;&#36;&#115;&#49;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - BuffID$s1 is not specified.
	 */
	public static final SystemMessageId RACE_SETUP_FILE3;
	
	/**
	 * ID: 1424<br>
	 * Message: Zݒt@C G[FBuffLv$s1Ă܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#66;&#117;&#102;&#102;&#76;&#118;&#36;&#115;&#49;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - BuffLv$s1 is not specified.
	 */
	public static final SystemMessageId RACE_SETUP_FILE4;
	
	/**
	 * ID: 1425<br>
	 * Message: Zݒt@C G[FDefaultAllowĂ܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#68;&#101;&#102;&#97;&#117;&#108;&#116;&#65;&#108;&#108;&#111;&#119;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - DefaultAllow is not specified
	 */
	public static final SystemMessageId RACE_SETUP_FILE5;
	
	/**
	 * ID: 1426<br>
	 * Message: Zݒt@C G[FExpSkillCntĂ܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#69;&#120;&#112;&#83;&#107;&#105;&#108;&#108;&#67;&#110;&#116;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - ExpSkillCnt is not specified.
	 */
	public static final SystemMessageId RACE_SETUP_FILE6;
	
	/**
	 * ID: 1427<br>
	 * Message: Zݒt@C G[FExpSkillID$s1Ă܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#69;&#120;&#112;&#83;&#107;&#105;&#108;&#108;&#68;&#36;&#115;&#49;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - ExpSkillID$s1 is not specified.
	 */
	public static final SystemMessageId RACE_SETUP_FILE7;
	
	/**
	 * ID: 1428<br>
	 * Message: Zݒt@C G[FExpItemCntĂ܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#69;&#120;&#112;&#73;&#116;&#101;&#109;&#67;&#110;&#116;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - ExpItemCnt is not specified.
	 */
	public static final SystemMessageId RACE_SETUP_FILE8;
	
	/**
	 * ID: 1429<br>
	 * Message: Zݒt@C G[FExpItemID$s1Ă܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#69;&#120;&#112;&#73;&#116;&#101;&#109;&#68;&#36;&#115;&#49;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - ExpItemID$s1 is not specified.
	 */
	public static final SystemMessageId RACE_SETUP_FILE9;
	
	/**
	 * ID: 1430<br>
	 * Message: Zݒt@C G[FTeleportDelayĂ܂B<br>
	 * Message: &#27604;&#36093;&#35373;&#23450;&#27284;&#26696;&#37679;&#35492;&#45;&#84;&#101;&#108;&#101;&#112;&#111;&#114;&#116;&#68;&#101;&#108;&#97;&#121;&#26410;&#34987;&#26126;&#31034;&#12290;<br>
	 * Message: Race setup file error - TeleportDelay is not specified
	 */
	public static final SystemMessageId RACE_SETUP_FILE10;
	
	/**
	 * ID: 1431<br>
	 * Message: Zꎞf܂B<br>
	 * Message: &#26283;&#26178;&#20013;&#26039;&#27604;&#36093;&#12290;<br>
	 * Message: The race will be stopped temporarily.
	 */
	public static final SystemMessageId RACE_STOPPED_TEMPORARILY;
	
	/**
	 * ID: 1432<br>
	 * Message: 肪ΉԂłB<br>
	 * Message: &#23565;&#26041;&#29694;&#22312;&#34389;&#26044;&#30707;&#21270;&#29376;&#24907;&#12290;<br>
	 * Message: Your opponent is currently in a petrified state.
	 */
	public static final SystemMessageId OPPONENT_PETRIFIED;
	
	/**
	 * ID: 1433<br>
	 * Message: $s1 ̎gpɂ܂B<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#49;&#12301;&#20351;&#29992;&#35373;&#28858;&#33258;&#21205;&#21270;&#12290;<br>
	 * Message: You will now automatically apply $s1 to your target.
	 */
	public static final SystemMessageId USE_OF_S1_WILL_BE_AUTO;
	
	/**
	 * ID: 1434<br>
	 * Message: $s1 ̎gp܂B<br>
	 * Message: &#35299;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#33258;&#21205;&#20351;&#29992;&#29376;&#24907;&#12290;<br>
	 * Message: You will no longer automatically apply $s1 to your weapon.
	 */
	public static final SystemMessageId AUTO_USE_OF_S1_CANCELLED;
	
	/**
	 * ID: 1435<br>
	 * Message: $s1sĂ̂Ŏgp܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#36275;&#65292;&#22240;&#27492;&#24050;&#35299;&#38500;&#33258;&#21205;&#20351;&#29992;&#29376;&#24907;&#12290;<br>
	 * Message: Due to insufficient $s1, the automatic use function has been deactivated.
	 */
	public static final SystemMessageId AUTO_USE_CANCELLED_LACK_OF_S1;
	
	/**
	 * ID: 1436<br>
	 * Message: $s1sĂ̂Ŏgpł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#35373;&#28858;&#33258;&#21205;&#21270;&#12290;<br>
	 * Message: Due to insufficient $s1, the automatic use function cannot be activated.
	 */
	public static final SystemMessageId CANNOT_AUTO_USE_LACK_OF_S1;
	
	/**
	 * ID: 1437<br>
	 * Message: TCRgȂȂ܂Bɂʂ̏Xł̍wł܂BAɂʂ̏Xł̔̔͂ł܂B<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#39600;&#23376;&#65292;&#20063;&#19981;&#33021;&#22312;&#26449;&#33674;&#21830;&#24215;&#36914;&#34892;&#36092;&#36023;&#12290;&#20294;&#26159;&#21487;&#26044;&#26449;&#33674;&#21830;&#24215;&#36914;&#34892;&#36009;&#36067;&#12290;<br>
	 * Message: Players are no longer allowed to play dice. Dice can no longer be purchased from a village store. However, you can still sell them to any village store.
	 */
	public static final SystemMessageId DICE_NO_LONGER_ALLOWED;
	
	/**
	 * ID: 1438<br>
	 * Message: G`g\ȃXL܂B<br>
	 * Message: &#27794;&#26377;&#33021;&#22816;&#26119;&#33775;&#30340;&#25216;&#33021;&#12290;<br>
	 * Message: There is no skill that enables enchant.
	 */
	public static final SystemMessageId THERE_IS_NO_SKILL_THAT_ENABLES_ENCHANT;
	
	/**
	 * ID: 1439<br>
	 * Message: XL̃G`gɕKvȃACesĂ܂B<br>
	 * Message: &#25216;&#33021;&#26119;&#33775;&#26178;&#25152;&#38656;&#30340;&#36947;&#20855;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have all of the items needed to enchant that skill.
	 */
	public static final SystemMessageId YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL;
	
	/**
	 * ID: 1440<br>
	 * Message: XL̃G`gɐ܂BXL̃G`g$s1܂B<br>
	 * Message: &#25216;&#33021;&#26119;&#33775;&#25104;&#21151;&#12290;&#26119;&#33775;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#36948;&#21040;&#26356;&#24375;&#30340;&#22659;&#30028;&#12290;<br>
	 * Message: You have succeeded in enchanting the skill $s1.
	 */
	public static final SystemMessageId YOU_HAVE_SUCCEEDED_IN_ENCHANTING_THE_SKILL_S1;
	
	/**
	 * ID: 1441<br>
	 * Message: XL̃G`gɎs܂BXL̃G`g܂B<br>
	 * Message: &#25216;&#33021;&#26119;&#33775;&#22833;&#25943;&#12290;&#26119;&#33775;&#25216;&#33021;&#23559;&#34987;&#21021;&#22987;&#21270;&#65292;&#20006;&#35722;&#26356;&#28858;&#22522;&#26412;&#25216;&#33021;&#12290;<br>
	 * Message: Skill enchant failed. The skill will be initialized.
	 */
	public static final SystemMessageId YOU_HAVE_FAILED_TO_ENCHANT_THE_SKILL_S1;
	
	/**
	 * ID: 1443<br>
	 * Message: XL̃G`gɕKvSPsĂ܂B<br>
	 * Message: &#26119;&#33775;&#25216;&#33021;&#26178;&#25152;&#38656;&#30340;&#83;&#80;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough SP to enchant that skill.
	 */
	public static final SystemMessageId YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL;
	
	/**
	 * ID: 1444<br>
	 * Message: XL̃G`gɕKvȌolsĂ܂B<br>
	 * Message: &#26119;&#33775;&#25216;&#33021;&#26178;&#25152;&#38656;&#30340;&#37329;&#24163;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough experience (Exp) to enchant that skill.
	 */
	public static final SystemMessageId YOU_DONT_HAVE_ENOUGH_EXP_TO_ENCHANT_THAT_SKILL;
	
	/**
	 * ID: 1445<br>
	 * Message: ȑÕTuNX͏łAVȃTuNX̃x40X^[g܂B낵łB<br>
	 * Message: &#21034;&#38500;&#20043;&#21069;&#30340;&#21103;&#32887;&#26989;&#24460;&#65292;&#26032;&#30340;&#21103;&#32887;&#26989;&#23559;&#26371;&#24478;&#31561;&#32026;&#52;&#48;&#30340;&#29376;&#24907;&#37325;&#26032;&#38283;&#22987;&#12290;&#30906;&#23450;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: Your previous subclass will be removed and replaced with the new subclass at level 40. Do you wish to continue?
	 */
	public static final SystemMessageId REPLACE_SUBCLASS_CONFIRM;
	
	/**
	 * ID: 1446<br>
	 * Message: $s1  $s2 s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#40670;&#21069;&#24448;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from $s1 to $s2 has been delayed.
	 */
	public static final SystemMessageId FERRY_FROM_S1_TO_S2_DELAYED;
	
	/**
	 * ID: 1447<br>
	 * Message: H̑ҋ@ɂ͑̃XLgpł܂B<br>
	 * Message: &#22312;&#22402;&#37347;&#36884;&#20013;&#65292;&#28961;&#27861;&#20351;&#29992;&#20854;&#20182;&#25216;&#33021;&#12290;<br>
	 * Message: You cannot do that while fishing.
	 */
	public static final SystemMessageId CANNOT_DO_WHILE_FISHING_1;
	
	/**
	 * ID: 1448<br>
	 * Message: tBbVOpXL̂ݎgpł܂B<br>
	 * Message: &#20677;&#38480;&#20351;&#29992;&#37347;&#39770;&#25216;&#33021;&#12290;<br>
	 * Message: Only fishing skills may be used at this time.
	 */
	public static final SystemMessageId ONLY_FISHING_SKILLS_NOW;
	
	/**
	 * ID: 1449<br>
	 * Message: H܂B<br>
	 * Message: &#39770;&#24050;&#25104;&#21151;&#19978;&#37476;&#12290;<br>
	 * Message: You've got a bite!
	 */
	public static final SystemMessageId GOT_A_BITE;
	
	/**
	 * ID: 1450<br>
	 * Message: Ԑ؂Ŋl𓦂܂B<br>
	 * Message: &#36229;&#20986;&#26178;&#38291;&#38480;&#21046;&#65292;&#39770;&#24050;&#25497;&#33067;&#39770;&#37390;&#12290;<br>
	 * Message: That fish is more determined than you are - it spit the hook!
	 */
	public static final SystemMessageId FISH_SPIT_THE_HOOK;
	
	/**
	 * ID: 1451<br>
	 * Message: l𓦂܂B<br>
	 * Message: &#39770;&#24050;&#25497;&#33067;&#39770;&#37476;&#12290;<br>
	 * Message: Your bait was stolen by that fish!
	 */
	public static final SystemMessageId BAIT_STOLEN_BY_FISH;
	
	/**
	 * ID: 1452<br>
	 * Message: lGTē܂B<br>
	 * Message: &#39770;&#26410;&#19978;&#37476;&#65292;&#39770;&#39180;&#28040;&#22833;&#20102;&#12290;<br>
	 * Message: Baits have been lost because the fish got away.
	 */
	public static final SystemMessageId BAIT_LOST_FISH_GOT_AWAY;
	
	/**
	 * ID: 1453<br>
	 * Message: ނƂ𑕔Ă܂B<br>
	 * Message: &#26410;&#35037;&#20633;&#37347;&#31487;&#12290;<br>
	 * Message: You do not have a fishing pole equipped.
	 */
	public static final SystemMessageId FISHING_POLE_NOT_EQUIPPED;
	
	/**
	 * ID: 1454<br>
	 * Message: GTĂ܂B<br>
	 * Message: &#26410;&#35037;&#20633;&#39770;&#39180;&#12290;<br>
	 * Message: You must put bait on your hook before you can fish.
	 */
	public static final SystemMessageId BAIT_ON_HOOK_BEFORE_FISHING;
	
	/**
	 * ID: 1455<br>
	 * Message: ł̓tBbVOł܂B<br>
	 * Message: &#22312;&#27700;&#24213;&#28961;&#27861;&#36914;&#34892;&#22402;&#37347;&#12290;<br>
	 * Message: You cannot fish while under water.
	 */
	public static final SystemMessageId CANNOT_FISH_UNDER_WATER;
	
	/**
	 * ID: 1456<br>
	 * Message: 悵Ԃł̓tBbVOł܂B<br>
	 * Message: &#22312;&#25645;&#20056;&#29376;&#24907;&#19979;&#28961;&#27861;&#36914;&#34892;&#22402;&#37347;&#12290;<br>
	 * Message: You cannot fish while riding as a passenger of a boat - it's against the rules.
	 */
	public static final SystemMessageId CANNOT_FISH_ON_BOAT;
	
	/**
	 * ID: 1457<br>
	 * Message: ނł͂܂B<br>
	 * Message: &#27492;&#22320;&#19981;&#23660;&#26044;&#37347;&#39770;&#21312;&#22495;&#12290;<br>
	 * Message: You can't fish here.
	 */
	public static final SystemMessageId CANNOT_FISH_HERE;
	
	/**
	 * ID: 1458<br>
	 * Message: tBbVO܂B<br>
	 * Message: &#21462;&#28040;&#22402;&#37347;&#12290;<br>
	 * Message: Your attempt at fishing has been cancelled.
	 */
	public static final SystemMessageId FISHING_ATTEMPT_CANCELLED;
	
	/**
	 * ID: 1459<br>
	 * Message: GTsĂ܂B<br>
	 * Message: &#39770;&#39180;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough bait.
	 */
	public static final SystemMessageId NOT_ENOUGH_BAIT;
	
	/**
	 * ID: 1460<br>
	 * Message: tBbVOI܂B<br>
	 * Message: &#32080;&#26463;&#22402;&#37347;&#12290;<br>
	 * Message: You reel your line in and stop fishing.
	 */
	public static final SystemMessageId REEL_LINE_AND_STOP_FISHING;
	
	/**
	 * ID: 1461<br>
	 * Message: tBbVOJn܂B<br>
	 * Message: &#38283;&#22987;&#22402;&#37347;&#12290;<br>
	 * Message: You cast your line and start to fish.
	 */
	public static final SystemMessageId CAST_LINE_AND_START_FISHING;
	
	/**
	 * ID: 1462<br>
	 * Message: |sOXL͊lHԂł̂ݎgpł܂B<br>
	 * Message: &#25289;&#32218;&#25216;&#33021;&#20677;&#38480;&#26044;&#19978;&#37476;&#29376;&#24907;&#20013;&#20351;&#29992;&#12290;<br>
	 * Message: You may only use the Pumping skill while you are fishing.
	 */
	public static final SystemMessageId CAN_USE_PUMPING_ONLY_WHILE_FISHING;
	
	/**
	 * ID: 1463<br>
	 * Message: [OXL͊lHԂł̂ݎgpł܂B<br>
	 * Message: &#25918;&#32218;&#25216;&#33021;&#20677;&#38480;&#26044;&#19978;&#37476;&#29376;&#24907;&#20013;&#20351;&#29992;&#12290;<br>
	 * Message: You may only use the Reeling skill while you are fishing.
	 */
	public static final SystemMessageId CAN_USE_REELING_ONLY_WHILE_FISHING;
	
	/**
	 * ID: 1464<br>
	 * Message: lR܂B<br>
	 * Message: &#39770;&#22312;&#25497;&#25166;&#12290;<br>
	 * Message: The fish has resisted your attempt to bring it in.
	 */
	public static final SystemMessageId FISH_RESISTED_ATTEMPT_TO_BRING_IT_IN;
	
	/**
	 * ID: 1465<br>
	 * Message: |sOA_[WF $s1<br>
	 * Message: &#25289;&#32218;&#25104;&#21151;&#65292;&#20663;&#23475;&#65306;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Your pumping is successful, causing $s1 damage.
	 */
	public static final SystemMessageId PUMPING_SUCCESFUL_S1_DAMAGE;
	
	/**
	 * ID: 1466<br>
	 * Message: |sOsA_[WF $s1<br>
	 * Message: &#25289;&#32218;&#22833;&#25943;&#65292;&#20663;&#23475;&#65306;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: You failed to do anything with the fish and it regains $s1 HP.
	 */
	public static final SystemMessageId FISH_RESISTED_PUMPING_S1_HP_REGAINED;
	
	/**
	 * ID: 1467<br>
	 * Message: [OA_[WF$s1<br>
	 * Message: &#25918;&#32218;&#25104;&#21151;&#65292;&#20663;&#23475;&#65306;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: You reel that fish in closer and cause $s1 damage.
	 */
	public static final SystemMessageId REELING_SUCCESFUL_S1_DAMAGE;
	
	/**
	 * ID: 1468<br>
	 * Message: [OsA_[WF$s1<br>
	 * Message: &#25918;&#32218;&#22833;&#25943;&#65292;&#20663;&#23475;&#65306;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: You failed to reel that fish in further and it regains $s1 HP.
	 */
	public static final SystemMessageId FISH_RESISTED_REELING_S1_HP_REGAINED;
	
	/**
	 * ID: 1469<br>
	 * Message: lނグ܂B<br>
	 * Message: &#37347;&#39770;&#25104;&#21151;&#12290;<br>
	 * Message: You caught something!
	 */
	public static final SystemMessageId YOU_CAUGHT_SOMETHING;
	
	/**
	 * ID: 1470<br>
	 * Message: tBbVOɂ̓ACȇAAjӁAhbv͂ł܂B<br>
	 * Message: &#22312;&#31561;&#24453;&#39770;&#20818;&#19978;&#37476;&#36884;&#20013;&#65292;&#28961;&#27861;&#36914;&#34892;&#36947;&#20855;&#30340;&#35037;&#20633;&#12289;&#25286;&#21368;&#12289;&#21034;&#38500;&#25110;&#19999;&#26820;&#12290;<br>
	 * Message: You cannot do that while fishing.
	 */
	public static final SystemMessageId CANNOT_DO_WHILE_FISHING_2;
	
	/**
	 * ID: 1471<br>
	 * Message: tBbVOɂ͑̍s邱Ƃł܂B<br>
	 * Message: &#22312;&#22402;&#37347;&#30070;&#20013;&#28961;&#27861;&#36914;&#34892;&#20854;&#20182;&#21205;&#20316;&#12290;<br>
	 * Message: You cannot do that while fishing.
	 */
	public static final SystemMessageId CANNOT_DO_WHILE_FISHING_3;
	
	/**
	 * ID: 1472<br>
	 * Message: ނƂł͍Uł܂B<br>
	 * Message: &#28961;&#27861;&#21033;&#29992;&#37347;&#31487;&#36914;&#34892;&#25915;&#25802;&#12290;<br>
	 * Message: You look oddly at the fishing pole in disbelief and realize that you can't attack anything with this.
	 */
	public static final SystemMessageId CANNOT_ATTACK_WITH_FISHING_POLE;
	
	/**
	 * ID: 1473<br>
	 * Message: $s1sĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#36275;&#12290;<br>
	 * Message: $s1 is not sufficient.
	 */
	public static final SystemMessageId S1_NOT_SUFFICIENT;
	
	/**
	 * ID: 1474<br>
	 * Message: $s1gpł܂B<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 is not available.
	 */
	public static final SystemMessageId S1_NOT_AVAILABLE;
	
	/**
	 * ID: 1475<br>
	 * Message: ybg$s1𗎂Ƃ܂B<br>
	 * Message: &#23541;&#29289;&#19999;&#26820;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Pet has dropped $s1.
	 */
	public static final SystemMessageId PET_DROPPED_S1;
	
	/**
	 * ID: 1476<br>
	 * Message: ybg+$s1$s2𗎂Ƃ܂B<br>
	 * Message: &#23541;&#29289;&#19999;&#26820;&#20102;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Pet has dropped +$s1 $s2.
	 */
	public static final SystemMessageId PET_DROPPED_S1_S2;
	
	/**
	 * ID: 1477<br>
	 * Message: ybg$s1 $s2𗎂Ƃ܂B<br>
	 * Message: &#23541;&#29289;&#19999;&#26820;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Pet has dropped $s2 of $s1.
	 */
	public static final SystemMessageId PET_DROPPED_S2_S1_S;
	
	/**
	 * ID: 1478<br>
	 * Message: 64x64sNZ256FBMPt@Ĉݓo^ł܂B<br>
	 * Message: &#21482;&#33021;&#19978;&#20659;&#54;&#52;&#42;&#54;&#52;&#20687;&#32032;&#65292;&#50;&#53;&#54;&#33394;&#30340;&#98;&#109;&#112;&#27284;&#26696;&#12290;<br>
	 * Message: You may only register a 64 x 64 pixel, 256-color BMP.
	 */
	public static final SystemMessageId ONLY_64_PIXEL_256_COLOR_BMP;
	
	/**
	 * ID: 1479<br>
	 * Message: ނƂ̃O[hɍtBbVO Vbgł͂܂B<br>
	 * Message: &#28417;&#38728;&#24392;&#19981;&#31526;&#21512;&#37347;&#31487;&#31561;&#32026;&#12290;<br>
	 * Message: That is the wrong grade of soulshot for that fishing pole.
	 */
	public static final SystemMessageId WRONG_FISHINGSHOT_GRADE;
	
	/**
	 * ID: 1480<br>
	 * Message: IsA[h̎Q\݂܂B<br>
	 * Message: &#30906;&#23450;&#21462;&#28040;&#22887;&#26519;&#21305;&#20126;&#30340;&#21443;&#36093;&#30003;&#35531;&#21966;&#65311;<br>
	 * Message: Are you sure you want to remove yourself from the Grand Olympiad Games waiting list?
	 */
	public static final SystemMessageId OLYMPIAD_REMOVE_CONFIRM;
	
	/**
	 * ID: 1481<br>
	 * Message: NXlZI܂BQ܂B<br>
	 * Message: &#24744;&#24050;&#36984;&#25799;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#30340;&#20491;&#20154;&#27604;&#36093;&#12290;&#24744;&#35201;&#21443;&#21152;&#21966;&#65311;<br>
	 * Message: You have selected a class irrelevant individual match. Do you wish to participate?
	 */
	public static final SystemMessageId OLYMPIAD_NON_CLASS_CONFIRM;
	
	/**
	 * ID: 1482<br>
	 * Message: NXʎI܂BQ܂B<br>
	 * Message: &#24744;&#36984;&#25799;&#30340;&#26159;&#32887;&#26989;&#39006;&#21029;&#27604;&#36093;&#12290;&#30906;&#23450;&#35201;&#21443;&#21152;&#21966;&#65311;<br>
	 * Message: You've selected to join a class specific game. Continue?
	 */
	public static final SystemMessageId OLYMPIAD_CLASS_CONFIRM;
	
	/**
	 * ID: 1483<br>
	 * Message: pYɂȂ܂B<br>
	 * Message: &#20320;&#24819;&#29694;&#22312;&#25104;&#28858;&#33521;&#38596;&#21966;&#65311;<br>
	 * Message: Are you ready to be a Hero?
	 */
	public static final SystemMessageId HERO_CONFIRM;
	
	/**
	 * ID: 1484<br>
	 * Message: IpY̕gp܂BJ}G͎gpł܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#25152;&#36984;&#30340;&#33521;&#38596;&#27494;&#22120;&#21966;&#65311;&#19981;&#36942;&#65292;&#38343;&#22825;&#20351;&#19968;&#26063;&#28961;&#27861;&#20351;&#29992;&#27492;&#27494;&#22120;&#12290;<br>
	 * Message: Are you sure this is the Hero weapon you wish to use? Kamael race cannot use this.
	 */
	public static final SystemMessageId HERO_WEAPON_CONFIRM;
	
	/**
	 * ID: 1485<br>
	 * Message: b铇 O[fB`s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#35498;&#35441;&#20043;&#23798;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Talking Island to Gludin Harbor has been delayed.
	 */
	public static final SystemMessageId FERRY_TALKING_GLUDIN_DELAYED;
	
	/**
	 * ID: 1486<br>
	 * Message: O[fB` b铇s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#21476;&#39791;&#19969;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Gludin Harbor to Talking Island has been delayed.
	 */
	public static final SystemMessageId FERRY_GLUDIN_TALKING_DELAYED;
	
	/**
	 * ID: 1487<br>
	 * Message: M` b铇s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#22855;&#23721;&#28207;&#21475;&#21069;&#24448;&#35498;&#35441;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Giran Harbor to Talking Island has been delayed.
	 */
	public static final SystemMessageId FERRY_GIRAN_TALKING_DELAYED;
	
	/**
	 * ID: 1488<br>
	 * Message: b铇 M`s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#35498;&#35441;&#20043;&#23798;&#21069;&#24448;&#22855;&#23721;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Talking Island to Giran Harbor has been delayed.
	 */
	public static final SystemMessageId FERRY_TALKING_GIRAN_DELAYED;
	
	/**
	 * ID: 1489<br>
	 * Message: CihVD̉^qɒxꂪoĂ܂B<br>
	 * Message: &#22240;&#32013;&#24471;&#31435;&#36938;&#35261;&#33337;&#30340;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: Innadril cruise service has been delayed.
	 */
	public static final SystemMessageId INNADRIL_BOAT_DELAYED;
	
	/**
	 * ID: 1490<br>
	 * Message: 앨$s1$s2Z܂B<br>
	 * Message: &#24050;&#32080;&#31639;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#36786;&#20316;&#29289;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Traded $s2 of crop $s1.
	 */
	public static final SystemMessageId TRADED_S2_OF_CROP_S1;
	
	/**
	 * ID: 1491<br>
	 * Message: 앨$s1$s2ẐɎs܂B<br>
	 * Message: &#26410;&#33021;&#32080;&#31639;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#36786;&#20316;&#29289;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Failed in trading $s2 of crop $s1.
	 */
	public static final SystemMessageId FAILED_IN_TRADING_S2_OF_CROP_S1;
	
	/**
	 * ID: 1492<br>
	 * Message: $s1bɃIsA[h X^WAɈړ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#31186;&#20043;&#24460;&#65292;&#23559;&#34987;&#31227;&#24448;&#22887;&#26519;&#21305;&#20126;&#36093;&#22580;&#12290;<br>
	 * Message: You will be moved to the Olympiad Stadium in $s1 second(s).
	 */
	public static final SystemMessageId YOU_WILL_ENTER_THE_OLYMPIAD_STADIUM_IN_S1_SECOND_S;
	
	/**
	 * ID: 1493<br>
	 * Message: 肪Q[ÎŎ܂B<br>
	 * Message: &#21443;&#36093;&#23565;&#25163;&#32080;&#26463;&#20102;&#36938;&#25138;&#65292;&#36093;&#31243;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: Your opponent made haste with their tail between their legs), the match has been cancelled.
	 */
	public static final SystemMessageId THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_ENDS_THE_GAME;
	
	/**
	 * ID: 1494<br>
	 * Message: 肪Q[̎Q𖞂Ȃ߁A܂B<br>
	 * Message: &#21443;&#36093;&#23565;&#25163;&#26410;&#33021;&#31526;&#21512;&#21443;&#36093;&#26781;&#20214;&#30340;&#35201;&#27714;&#65292;&#35442;&#36093;&#31243;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: Your opponent does not meet the requirements to do battle), the match has been cancelled.
	 */
	public static final SystemMessageId THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME;
	
	/**
	 * ID: 1495<br>
	 * Message: $s1bɎJn܂B<br>
	 * Message: &#27604;&#36093;&#23559;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#24460;&#38283;&#22987;&#12290;<br>
	 * Message: The match will start in $s1 second(s).
	 */
	public static final SystemMessageId THE_GAME_WILL_START_IN_S1_SECOND_S;
	
	/**
	 * ID: 1496<br>
	 * Message: Jn܂B<br>
	 * Message: &#27604;&#36093;&#38283;&#22987;&#12290;<br>
	 * Message: The match has started, fight!
	 */
	public static final SystemMessageId STARTS_THE_GAME;
	
	/**
	 * ID: 1497<br>
	 * Message: $c1܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22312;&#27604;&#36093;&#20013;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Congratulations, $c1! You win the match!
	 */
	public static final SystemMessageId C1_HAS_WON_THE_GAME;
	
	/**
	 * ID: 1498<br>
	 * Message: łB<br>
	 * Message: &#19981;&#20998;&#21213;&#36000;&#12290;<br>
	 * Message: There is no victor, the match ends in a tie.
	 */
	public static final SystemMessageId THE_GAME_ENDED_IN_A_TIE;
	
	/**
	 * ID: 1499<br>
	 * Message: $s1bɑɋA҂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#31186;&#20043;&#24460;&#65292;&#23559;&#26371;&#37325;&#36820;&#26449;&#33674;&#12290;<br>
	 * Message: You will be moved back to town in $s1 second(s).
	 */
	public static final SystemMessageId YOU_WILL_BE_MOVED_TO_TOWN_IN_S1_SECONDS;
	
	/**
	 * ID: 1500<br>
	 * Message: $c1 ͎Qɍ܂BTuNX LN^[ł̓IsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#19981;&#31526;&#21512;&#21443;&#21152;&#26781;&#20214;&#12290;&#21103;&#32887;&#26989;&#29376;&#24907;&#19979;&#30340;&#35282;&#33394;&#65292;&#19981;&#24471;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1% does not meet the participation requirements. A sub-class character cannot participate in the Olympiad.
	 */
	public static final SystemMessageId C1_CANT_JOIN_THE_OLYMPIAD_WITH_A_SUB_CLASS_CHARACTER;
	
	/**
	 * ID: 1501<br>
	 * Message: $c1 ͎Qɍ܂Bm[uXȊO̓IsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#19981;&#31526;&#21512;&#21443;&#21152;&#26781;&#20214;&#12290;&#21482;&#26377;&#36020;&#26063;&#36523;&#20998;&#25165;&#33021;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1% does not meet the participation requirements. Only Noblesse can participate in the Olympiad.
	 */
	public static final SystemMessageId C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD;
	
	/**
	 * ID: 1502<br>
	 * Message: $c1 ͋Zҋ@҃Xgɂłɓo^Ă܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30331;&#35352;&#22312;&#27604;&#36093;&#21443;&#36093;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: $c1 is already registered on the match waiting list.
	 */
	public static final SystemMessageId C1_IS_ALREADY_REGISTERED_ON_THE_MATCH_WAITING_LIST;
	
	/**
	 * ID: 1503<br>
	 * Message: NXʋZڂ̑ҋ@҃Xgɓo^܂B<br>
	 * Message: &#24050;&#30331;&#35352;&#22312;&#32887;&#26989;&#39006;&#21029;&#27604;&#36093;&#38917;&#30446;&#21443;&#36093;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: You have been registered in the Grand Olympiad Games waiting list for a class specific match.
	 */
	public static final SystemMessageId YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_CLASSIFIED_GAMES;
	
	/**
	 * ID: 1504<br>
	 * Message: NXlZڂ̑ҋ@҃Xgɓo^܂B<br>
	 * Message: &#24050;&#30331;&#35352;&#22312;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#20491;&#20154;&#27604;&#36093;&#38917;&#30446;&#30340;&#31561;&#24453;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: You are currently registered for a 1v1 class irrelevant match.
	 */
	public static final SystemMessageId YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_NO_CLASS_GAMES;
	
	/**
	 * ID: 1505<br>
	 * Message: Zҋ@҃Xg폜܂B<br>
	 * Message: &#24050;&#34987;&#21034;&#38500;&#22312;&#27604;&#36093;&#31561;&#24453;&#32773;&#21517;&#21934;&#20043;&#22806;&#12290;<br>
	 * Message: You have been removed from the Grand Olympiad Games waiting list.
	 */
	public static final SystemMessageId YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME;
	
	/**
	 * ID: 1506<br>
	 * Message: Zҋ@҃Xgɓo^Ă܂B<br>
	 * Message: &#26410;&#34987;&#30331;&#35352;&#22312;&#27604;&#36093;&#31561;&#24453;&#32773;&#21517;&#21934;&#20043;&#20839;&#12290;<br>
	 * Message: You are not currently registered on any Grand Olympiad Games waiting list.
	 */
	public static final SystemMessageId YOU_HAVE_NOT_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_A_GAME;
	
	/**
	 * ID: 1507<br>
	 * Message: IsA[hZł͑łȂACełB<br>
	 * Message: &#35442;&#38917;&#36947;&#20855;&#28961;&#27861;&#22312;&#22887;&#26519;&#21305;&#20126;&#27604;&#36093;&#20043;&#20013;&#25152;&#20329;&#25140;&#12290;<br>
	 * Message: You cannot equip that item in a Grand Olympiad Games match.
	 */
	public static final SystemMessageId THIS_ITEM_CANT_BE_EQUIPPED_FOR_THE_OLYMPIAD_EVENT;
	
	/**
	 * ID: 1508<br>
	 * Message: IsA[hZł͎gpłȂACełB<br>
	 * Message: &#35442;&#38917;&#36947;&#20855;&#28961;&#27861;&#22312;&#22887;&#26519;&#21305;&#20126;&#27604;&#36093;&#20043;&#20013;&#25152;&#20351;&#29992;&#12290;<br>
	 * Message: You cannot use that item in a Grand Olympiad Games match.
	 */
	public static final SystemMessageId THIS_ITEM_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT;
	
	/**
	 * ID: 1509<br>
	 * Message: IsA[hZł͎gpłȂXLłB<br>
	 * Message: &#35442;&#38917;&#25216;&#33021;&#28961;&#27861;&#22312;&#22887;&#26519;&#21305;&#20126;&#27604;&#36093;&#20043;&#20013;&#25152;&#20351;&#29992;&#12290;<br>
	 * Message: You cannot use that skill in a Grand Olympiad Games match.
	 */
	public static final SystemMessageId THIS_SKILL_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT;
	
	/**
	 * ID: 1510<br>
	 * Message: $c1$s2̌ol𕜋镜݂Ă܂B܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#35430;&#22294;&#36914;&#34892;&#24674;&#24489;&#12300;&#36;&#115;&#50;&#12301;&#40670;&#32147;&#39511;&#20540;&#30340;&#24489;&#27963;&#12290;&#35201;&#36914;&#34892;&#24489;&#27963;&#21966;&#65311;<br>
	 * Message: $c1 is making an attempt at resurrection with $s2 experience points. Do you want to be resurrected?
	 */
	public static final SystemMessageId RESSURECTION_REQUEST_BY_C1_FOR_S2_XP;
	
	/**
	 * ID: 1511<br>
	 * Message: ybg݂̕Ă鎞́A𕜊ł܂B<br>
	 * Message: &#30070;&#23541;&#29289;&#22312;&#36914;&#34892;&#24489;&#27963;&#26178;&#65292;&#28961;&#27861;&#24489;&#27963;&#20854;&#20027;&#20154;&#12290;<br>
	 * Message: While a pet is attempting to resurrect, it cannot help in resurrecting its master.
	 */
	public static final SystemMessageId MASTER_CANNOT_RES;
	
	/**
	 * ID: 1512<br>
	 * Message: ݂̕Ă鎞́Aybg𕜊ł܂B<br>
	 * Message: &#30070;&#20027;&#20154;&#22312;&#36914;&#34892;&#24489;&#27963;&#26178;&#65292;&#28961;&#27861;&#24489;&#27963;&#20854;&#23541;&#29289;&#12290;<br>
	 * Message: You cannot resurrect a pet while their owner is being resurrected.
	 */
	public static final SystemMessageId CANNOT_RES_PET;
	
	/**
	 * ID: 1513<br>
	 * Message: łɂD̕񎦂ĂԂłB<br>
	 * Message: &#24050;&#29554;&#24471;&#26356;&#22909;&#30340;&#24489;&#27963;&#25552;&#26696;&#12290;<br>
	 * Message: Resurrection has already been proposed.
	 */
	public static final SystemMessageId RES_HAS_ALREADY_BEEN_PROPOSED;
	
	/**
	 * ID: 1514<br>
	 * Message: ybgȂ̂ŁA̕ɂȂ܂B<br>
	 * Message: &#23541;&#29289;&#27491;&#34389;&#26044;&#24489;&#27963;&#36942;&#31243;&#20043;&#20013;&#65292;&#22240;&#27492;&#20854;&#20027;&#20154;&#30340;&#24489;&#27963;&#35201;&#27714;&#24050;&#22833;&#25928;&#12290;<br>
	 * Message: You cannot the owner of a pet while their pet is being resurrected
	 */
	public static final SystemMessageId CANNOT_RES_MASTER;
	
	/**
	 * ID: 1515<br>
	 * Message: 傪Ȃ̂ŁAybg̕ɂȂ܂B<br>
	 * Message: &#20027;&#20154;&#27491;&#34389;&#26044;&#24489;&#27963;&#36942;&#31243;&#20043;&#20013;&#65292;&#22240;&#27492;&#20854;&#23541;&#29289;&#30340;&#24489;&#27963;&#35201;&#27714;&#24050;&#22833;&#25928;&#12290;<br>
	 * Message: A pet cannot be resurrected while it's owner is in the process of resurrecting.
	 */
	public static final SystemMessageId CANNOT_RES_PET2;
	
	/**
	 * ID: 1516<br>
	 * Message: ̐AtłȂΏۂłB<br>
	 * Message: &#30446;&#27161;&#19981;&#23660;&#26044;&#25773;&#31278;&#23565;&#35937;&#12290;<br>
	 * Message: The target is unavailable for seeding.
	 */
	public static final SystemMessageId THE_TARGET_IS_UNAVAILABLE_FOR_SEEDING;
	
	/**
	 * ID: 1517<br>
	 * Message: jꂽɎs܂BYACẽG`gl0ɂȂ܂B<br>
	 * Message: &#26410;&#33021;&#25104;&#21151;&#36914;&#34892;&#31069;&#31119;&#24375;&#21270;&#65292;&#35442;&#35037;&#20633;&#30340;&#24375;&#21270;&#20540;&#35722;&#28858;&#48;&#12290;<br>
	 * Message: Failed in Blessed Enchant. The enchant value of the item became 0.
	 */
	public static final SystemMessageId BLESSED_ENCHANT_FAILED;
	
	/**
	 * ID: 1518<br>
	 * Message: ACȇɍȂ߁AYACe𑕔ł܂B<br>
	 * Message: &#35442;&#36947;&#20855;&#19981;&#31526;&#21512;&#35037;&#20633;&#26781;&#20214;&#32780;&#28961;&#27861;&#36914;&#34892;&#35037;&#20633;&#12290;<br>
	 * Message: You do not meet the required condition to equip that item.
	 */
	public static final SystemMessageId CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION;
	
	/**
	 * ID: 1519<br>
	 * Message: ybgS܂B24ԈȓɕȂ΃ybg͏łāAybg̎ĂACeł܂B<br>
	 * Message: &#23541;&#29289;&#24050;&#27515;&#21435;&#12290;&#38656;&#22312;&#50;&#52;&#23567;&#26178;&#20197;&#20839;&#36914;&#34892;&#24489;&#27963;&#65292;&#21542;&#21063;&#23541;&#29289;&#30340;&#23629;&#39636;&#21644;&#23541;&#29289;&#21484;&#21914;&#36947;&#20855;&#23559;&#26371;&#28040;&#22833;&#12290;<br>
	 * Message: The pet has been killed. If you don't resurrect it within 24 hours, the pet's body will disappear along with all the pet's items.
	 */
	public static final SystemMessageId MAKE_SURE_YOU_RESSURECT_YOUR_PET_WITHIN_24_HOURS;
	
	/**
	 * ID: 1520<br>
	 * Message: bS܂B<br>
	 * Message: &#21484;&#21914;&#20351;&#39764;&#24050;&#27515;&#21435;&#12290;<br>
	 * Message: Servitor passed away.
	 */
	public static final SystemMessageId SERVITOR_PASSED_AWAY;
	
	/**
	 * ID: 1521<br>
	 * Message: Ԃẑŏb܂B<br>
	 * Message: &#24050;&#36229;&#20986;&#21484;&#21914;&#26178;&#38480;&#65292;&#20351;&#39764;&#23559;&#26371;&#28040;&#22833;&#12290;<br>
	 * Message: Your servitor has vanished! You'll need to summon a new one.
	 */
	public static final SystemMessageId YOUR_SERVITOR_HAS_VANISHED;
	
	/**
	 * ID: 1522<br>
	 * Message: ybg̎SAԂẑŎ̂ł܂B<br>
	 * Message: &#23541;&#29289;&#27515;&#20129;&#26178;&#38291;&#36942;&#20037;&#65292;&#23629;&#39636;&#23559;&#28040;&#22833;&#12290;<br>
	 * Message: Your pet's corpse has decayed!
	 */
	public static final SystemMessageId YOUR_PETS_CORPSE_HAS_DECAYED;
	
	/**
	 * ID: 1523<br>
	 * Message: ybg⏢b͑D̉^qɐɗĎS鋰ꂪ̂ŁAoOɏĂB<br>
	 * Message: &#23541;&#29289;&#25110;&#21484;&#21914;&#20351;&#39764;&#19978;&#33337;&#20043;&#24460;&#65292;&#26377;&#29986;&#29983;&#33853;&#27700;&#27515;&#20129;&#30340;&#21487;&#33021;&#24615;&#12290;&#22240;&#27492;&#65292;&#24314;&#35696;&#22312;&#20986;&#30332;&#21069;&#20808;&#35299;&#38500;&#21484;&#21914;&#12290;<br>
	 * Message: You should release your pet or servitor so that it does not fall off of the boat and drown!
	 */
	public static final SystemMessageId RELEASE_PET_ON_BOAT;
	
	/**
	 * ID: 1524<br>
	 * Message: $c1̃ybg$s2ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;&#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1's pet gained $s2.
	 */
	public static final SystemMessageId C1_PET_GAINED_S2;
	
	/**
	 * ID: 1525<br>
	 * Message: $c1̃ybg$s2 $s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;&#29554;&#24471;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1's pet gained $s3 of $s2.
	 */
	public static final SystemMessageId C1_PET_GAINED_S3_S2_S;
	
	/**
	 * ID: 1526<br>
	 * Message: $c1̃ybg+$s2$s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;&#29554;&#24471;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: $c1's pet gained +$s2$s3.
	 */
	public static final SystemMessageId C1_PET_GAINED_S2_S3;
	
	/**
	 * ID: 1527<br>
	 * Message: ybg󕠂̂$s1Hׂ܂B<br>
	 * Message: &#23541;&#29289;&#32922;&#23376;&#39187;&#20102;&#65292;&#39135;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your pet was hungry so it ate $s1.
	 */
	public static final SystemMessageId PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY;
	
	/**
	 * ID: 1528<br>
	 * Message: T|[ĝA܂B<br>
	 * Message: &#71;&#77;&#30340;&#35380;&#27714;&#24050;&#34987;&#25509;&#21463;&#12290;<br>
	 * Message: You've sent a petition to the GM staff.
	 */
	public static final SystemMessageId SENT_PETITION_TO_GM;
	
	/**
	 * ID: 1529<br>
	 * Message: $c1Aɏ҂܂BQ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#32879;&#21512;&#36557;&#12290;&#35201;&#21152;&#20837;&#21966;&#65311;<br>
	 * Message: $c1 is inviting you to the command channel. Do you want accept?
	 */
	public static final SystemMessageId COMMAND_CHANNEL_CONFIRM_FROM_C1;
	
	/**
	 * ID: 1530<br>
	 * Message: Ώۂ߂邩O͂ĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#30446;&#27161;&#25110;&#36664;&#20837;&#21517;&#31281;&#12290;<br>
	 * Message: Select a target or enter the name.
	 */
	public static final SystemMessageId SELECT_TARGET_OR_ENTER_NAME;
	
	/**
	 * ID: 1531<br>
	 * Message: z鑊̌͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#23459;&#25136;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the name of the clan that you wish to declare war on.
	 */
	public static final SystemMessageId ENTER_CLAN_NAME_TO_DECLARE_WAR2;
	
	/**
	 * ID: 1532<br>
	 * Message: 푈̌͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#25764;&#22238;&#23459;&#25136;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: Enter the name of the clan that you wish to have a cease-fire with.
	 */
	public static final SystemMessageId ENTER_CLAN_NAME_TO_CEASE_FIRE;
	
	/**
	 * ID: 1533<br>
	 * Message: m点F $c1$s2ɓ܂B<br>
	 * Message: &#20844;&#21578;&#65306;&#12300;&#36;&#99;&#49;&#12301;&#25791;&#21462;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Announcement: $c1 has picked up $s2.
	 */
	public static final SystemMessageId ANNOUNCEMENT_C1_PICKED_UP_S2;
	
	/**
	 * ID: 1534<br>
	 * Message: m点F $c1+$s2$s3ɓ܂B<br>
	 * Message: &#20844;&#21578;&#65306;&#12300;&#36;&#99;&#49;&#12301;&#25791;&#21462;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: Announcement: $c1 has picked up +$s2$s3.
	 */
	public static final SystemMessageId ANNOUNCEMENT_C1_PICKED_UP_S2_S3;
	
	/**
	 * ID: 1535<br>
	 * Message: m点F $c1̃ybg$s2ɓ܂B<br>
	 * Message: &#20844;&#21578;&#65306;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;&#25791;&#21462;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Announcement: $c1's pet has picked up $s2.
	 */
	public static final SystemMessageId ANNOUNCEMENT_C1_PET_PICKED_UP_S2;
	
	/**
	 * ID: 1536<br>
	 * Message: m点F $c1̃ybg+$s2$s3ɓ܂B<br>
	 * Message: &#20844;&#21578;&#65306;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;&#25791;&#21462;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: Announcement: $c1's pet has picked up +$s2$s3.
	 */
	public static final SystemMessageId ANNOUNCEMENT_C1_PET_PICKED_UP_S2_S3;
	
	/**
	 * ID: 1537<br>
	 * Message: ݒnF $s1A$s2A$s3 (Ȇt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#39791;&#22240;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (near Rune Village)
	 */
	public static final SystemMessageId LOC_RUNE_S1_S2_S3;
	
	/**
	 * ID: 1538<br>
	 * Message: ݒnF $s1A$s2A$s3 (S_[h̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#39640;&#36948;&#29305;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (near the Town of Goddard)
	 */
	public static final SystemMessageId LOC_GODDARD_S1_S2_S3;
	
	/**
	 * ID: 1539<br>
	 * Message: ݕb铇̑ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#24050;&#25269;&#36948;&#35498;&#35441;&#20043;&#23798;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Talking Island Village.
	 */
	public static final SystemMessageId CARGO_AT_TALKING_VILLAGE;
	
	/**
	 * ID: 1540<br>
	 * Message: ݕ_[NGtɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#40657;&#26263;&#31934;&#38728;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at the Dark Elf Village.
	 */
	public static final SystemMessageId CARGO_AT_DARKELF_VILLAGE;
	
	/**
	 * ID: 1541<br>
	 * Message: ݕGtɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#31934;&#38728;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Elven Village.
	 */
	public static final SystemMessageId CARGO_AT_ELVEN_VILLAGE;
	
	/**
	 * ID: 1542<br>
	 * Message: ݕI[Nɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#21322;&#29560;&#20154;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Orc Village.
	 */
	public static final SystemMessageId CARGO_AT_ORC_VILLAGE;
	
	/**
	 * ID: 1543<br>
	 * Message: ݕh[tɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#30702;&#20154;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Dwarfen Village.
	 */
	public static final SystemMessageId CARGO_AT_DWARVEN_VILLAGE;
	
	/**
	 * ID: 1544<br>
	 * Message: ݕAf̑ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#20126;&#19969;&#22478;&#37806;&#12290;<br>
	 * Message: Cargo has arrived at Aden Castle Town.
	 */
	public static final SystemMessageId CARGO_AT_ADEN;
	
	/**
	 * ID: 1545<br>
	 * Message: ݕI[̑ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#27472;&#29790;&#22478;&#37806;&#12290;<br>
	 * Message: Cargo has arrived at Town of Oren.
	 */
	public static final SystemMessageId CARGO_AT_OREN;
	
	/**
	 * ID: 1546<br>
	 * Message: ݕt̑ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#29557;&#20154;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Hunters Village.
	 */
	public static final SystemMessageId CARGO_AT_HUNTERS;
	
	/**
	 * ID: 1547<br>
	 * Message: ݕfBȊɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#29380;&#24681;&#22478;&#37806;&#12290;<br>
	 * Message: Cargo has arrived at the Town of Dion.
	 */
	public static final SystemMessageId CARGO_AT_DION;
	
	/**
	 * ID: 1548<br>
	 * Message: ݕt[ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#33433;&#32645;&#34349;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Floran Village.
	 */
	public static final SystemMessageId CARGO_AT_FLORAN;
	
	/**
	 * ID: 1549<br>
	 * Message: ݕO[fBɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#21476;&#39791;&#19969;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Gludin Village.
	 */
	public static final SystemMessageId CARGO_AT_GLUDIN;
	
	/**
	 * ID: 1550<br>
	 * Message: ݕO[fBȊɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#21476;&#39791;&#19969;&#22478;&#37806;&#12290;<br>
	 * Message: Cargo has arrived at the Town of Gludio.
	 */
	public static final SystemMessageId CARGO_AT_GLUDIO;
	
	/**
	 * ID: 1551<br>
	 * Message: ݕM̑ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#22855;&#23721;&#22478;&#37806;&#12290;<br>
	 * Message: Cargo has arrived at Giran Castle Town.
	 */
	public static final SystemMessageId CARGO_AT_GIRAN;
	
	/**
	 * ID: 1552<br>
	 * Message: ݕnClXɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#28023;&#38899;&#26031;&#12290;<br>
	 * Message: Cargo has arrived at Heine.
	 */
	public static final SystemMessageId CARGO_AT_HEINE;
	
	/**
	 * ID: 1553<br>
	 * Message: ݕȆɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#39791;&#22240;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at Rune Village.
	 */
	public static final SystemMessageId CARGO_AT_RUNE;
	
	/**
	 * ID: 1554<br>
	 * Message: ݕS_[h̑ɓ͂Ă܂B<br>
	 * Message: &#36008;&#29289;&#25269;&#36948;&#39640;&#36948;&#29305;&#26449;&#33674;&#12290;<br>
	 * Message: Cargo has arrived at the Town of Goddard.
	 */
	public static final SystemMessageId CARGO_AT_GODDARD;
	
	/**
	 * ID: 1555<br>
	 * Message: LN^[̍폜܂B<br>
	 * Message: &#30906;&#23450;&#21462;&#28040;&#35282;&#33394;&#21034;&#38500;&#21966;&#65311;<br>
	 * Message: Do you want to cancel character deletion?
	 */
	public static final SystemMessageId CANCEL_CHARACTER_DELETION_CONFIRM;
	
	/**
	 * ID: 1556<br>
	 * Message: m点̓eۑ܂B<br>
	 * Message: &#36890;&#30693;&#20839;&#23481;&#24050;&#34987;&#20786;&#23384;&#12290;<br>
	 * Message: Your clan notice has been saved.
	 */
	public static final SystemMessageId CLAN_NOTICE_SAVED;
	
	/**
	 * ID: 1557<br>
	 * Message: ̉i$s1ȏ$s2ȉɂĂB<br>
	 * Message: &#31278;&#23376;&#30340;&#20729;&#26684;&#35201;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#20197;&#19978;&#12300;&#36;&#115;&#50;&#12301;&#20197;&#19979;&#12290;<br>
	 * Message: Seed price should be more than $s1 and less than $s2.
	 */
	public static final SystemMessageId SEED_PRICE_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2;
	
	/**
	 * ID: 1558<br>
	 * Message: ̐ʂ$s1ȏ$s2ȉɂĂB<br>
	 * Message: &#31278;&#23376;&#30340;&#25976;&#37327;&#35201;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#20197;&#19978;&#12300;&#36;&#115;&#50;&#12301;&#20197;&#19979;&#12290;<br>
	 * Message: The quantity of seed should be more than $s1 and less than $s2.
	 */
	public static final SystemMessageId THE_QUANTITY_OF_SEED_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2;
	
	/**
	 * ID: 1559<br>
	 * Message: 앨̉i$s1ȏ$s2ȉɂĂB<br>
	 * Message: &#36786;&#20316;&#29289;&#30340;&#20729;&#26684;&#35201;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#20197;&#19978;&#12300;&#36;&#115;&#50;&#12301;&#20197;&#19979;&#12290;<br>
	 * Message: Crop price should be more than $s1 and less than $s2.
	 */
	public static final SystemMessageId CROP_PRICE_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2;
	
	/**
	 * ID: 1560<br>
	 * Message: 앨̐ʂ$s1ȏ$s2ȉɂĂB<br>
	 * Message: &#36786;&#20316;&#29289;&#30340;&#25976;&#37327;&#35201;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#20197;&#19978;&#12300;&#36;&#115;&#50;&#12301;&#20197;&#19979;&#12290;<br>
	 * Message: The quantity of crop should be more than $s1 and less than $s2
	 */
	public static final SystemMessageId THE_QUANTITY_OF_CROP_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2;
	
	/**
	 * ID: 1561<br>
	 * Message: $s1z܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: The clan, $s1, has declared a Clan War.
	 */
	public static final SystemMessageId CLAN_S1_DECLARED_WAR;
	
	/**
	 * ID: 1562<br>
	 * Message: $s1ɑ΂z܂B葊̌ɂĎSꍇAolXgʏ41ɂȂ܂B<br>
	 * Message: &#24050;&#21521;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#23459;&#25136;&#12290;&#24478;&#29694;&#22312;&#38283;&#22987;&#65292;&#25105;&#26041;&#34880;&#30431;&#25104;&#21729;&#33509;&#34987;&#25973;&#26041;&#34880;&#30431;&#25104;&#21729;&#27578;&#27515;&#65292;&#32147;&#39511;&#20540;&#25074;&#32624;&#23559;&#26371;&#38477;&#28858;&#21407;&#26412;&#30340;&#49;&#47;&#52;&#12290;<br>
	 * Message: A Clan War has been declared against the clan, $s1. you will only lose a quarter of the normal experience from death.
	 */
	public static final SystemMessageId CLAN_WAR_DECLARED_AGAINST_S1_IF_KILLED_LOSE_LOW_EXP;
	
	/**
	 * ID: 1563<br>
	 * or they do not have enough members.
	 */
	public static final SystemMessageId CANNOT_DECLARE_WAR_TOO_LOW_LEVEL_OR_NOT_ENOUGH_MEMBERS;
	
	/**
	 * ID: 1564<br>
	 * Message: x3ȏA15lȏ݂̌̂zł܂B<br>
	 * Message: &#34880;&#30431;&#25136;&#30340;&#23459;&#21578;&#65292;&#21482;&#26377;&#22312;&#34880;&#30431;&#31561;&#32026;&#51;&#31561;&#32026;&#20197;&#19978;&#65292;&#19988;&#34880;&#30431;&#25104;&#21729;&#20154;&#25976;&#22312;&#49;&#53;&#21517;&#20197;&#19978;&#26178;&#25165;&#33021;&#36914;&#34892;&#12290;<br>
	 * Message: A Clan War can be declared only if the clan is level three or above, and the number of clan members is fifteen or greater.
	 */
	public static final SystemMessageId CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER;
	
	/**
	 * ID: 1565<br>
	 * Message: ݂Ȃ܂͒ԊĂȂȂ̂Őzł܂B<br>
	 * Message: &#35442;&#34880;&#30431;&#19981;&#23384;&#22312;&#65292;&#25110;&#22240;&#38263;&#26399;&#34389;&#26044;&#38750;&#27963;&#21205;&#29376;&#24907;&#32780;&#28961;&#27861;&#36914;&#34892;&#23459;&#25136;&#12290;<br>
	 * Message: A Clan War cannot be declared against a clan that does not exist!
	 */
	public static final SystemMessageId CLAN_WAR_CANNOT_DECLARED_CLAN_NOT_EXIST;
	
	/**
	 * ID: 1566<br>
	 * Message: $s1z艺܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#25764;&#22238;&#23459;&#25136;&#12290;<br>
	 * Message: The clan, $s1, has decided to stop the war.
	 */
	public static final SystemMessageId CLAN_S1_HAS_DECIDED_TO_STOP;
	
	/**
	 * ID: 1567<br>
	 * Message: $s1ւ̕z艺܂B<br>
	 * Message: &#24050;&#25764;&#22238;&#23565;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#23459;&#25136;&#12290;<br>
	 * Message: The war against $s1 Clan has been stopped.
	 */
	public static final SystemMessageId WAR_AGAINST_S1_HAS_STOPPED;
	
	/**
	 * ID: 1568<br>
	 * Message: z̑Ώۂ܂B<br>
	 * Message: &#23459;&#25136;&#23565;&#35937;&#26377;&#35492;&#12290;<br>
	 * Message: The target for declaration is wrong.
	 */
	public static final SystemMessageId WRONG_DECLARATION_TARGET;
	
	/**
	 * ID: 1569<br>
	 * Message: 񂾌ɂ͌zł܂B<br>
	 * Message: &#21516;&#30431;&#30340;&#34880;&#30431;&#28961;&#27861;&#25104;&#28858;&#23459;&#25136;&#23565;&#35937;&#12290;<br>
	 * Message: A declaration of Clan War against an allied clan can't be made.
	 */
	public static final SystemMessageId CLAN_WAR_AGAINST_A_ALLIED_CLAN_NOT_WORK;
	
	/**
	 * ID: 1570<br>
	 * Message: 30ȏ̌ɓɐz邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#23565;&#51;&#48;&#20491;&#20197;&#19978;&#30340;&#34880;&#30431;&#21516;&#26178;&#23459;&#25136;&#12290;<br>
	 * Message: A declaration of war against more than 30 Clans can't be made at the same time
	 */
	public static final SystemMessageId TOO_MANY_CLAN_WARS;
	
	/**
	 * ID: 1571<br>
	 * Message: =======<zXg>=======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#23459;&#25136;&#21517;&#21934;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ======<Clans You've Declared War On>======
	 */
	public static final SystemMessageId CLANS_YOU_DECLARED_WAR_ON;
	
	/**
	 * ID: 1572<br>
	 * Message: ======<zXg>======<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#34987;&#23459;&#25136;&#21517;&#21934;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: ======<Clans That Have Declared War On You>======
	 */
	public static final SystemMessageId CLANS_THAT_HAVE_DECLARED_WAR_ON_YOU;
	
	/**
	 * ID: 1573<br>
	 * Message: z錌݂܂B<br>
	 * Message: &#25105;&#26041;&#20006;&#28961;&#23565;&#20219;&#20309;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: All is well. There are no clans that have declared war against your clan.
	 */
	public static final SystemMessageId NO_WARS_AGAINST_YOU;
	
	/**
	 * ID: 1574<br>
	 * Message: z󂯂錌݂܂B<br>
	 * Message: &#25105;&#26041;&#20006;&#28961;&#34987;&#20219;&#20309;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: Command Channels can only be formed by a party leader who is also the leader of a level 5 clan.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_ONLY_BY_LEVEL_5_CLAN_LEADER_PARTY_LEADER;
	
	/**
	 * ID: 1575<br>
	 * Message: Ǎ͌x5ȏ̌łp[eB [_[݂̂\łB<br>
	 * Message: &#20677;&#38480;&#34880;&#30431;&#31561;&#32026;&#53;&#20197;&#19978;&#30340;&#34880;&#30431;&#30431;&#20027;&#20358;&#32068;&#32340;&#32879;&#21512;&#36557;&#12290;<br>
	 * Message: Your pet uses spiritshot.
	 */
	public static final SystemMessageId PET_USE_SPIRITSHOT;
	
	/**
	 * ID: 1576<br>
	 * Message: ybg̗͂gp܂B<br>
	 * Message: &#23541;&#29289;&#28748;&#27880;&#38728;&#39746;&#20043;&#21147;&#12290;<br>
	 * Message: Your servitor uses spiritshot.
	 */
	public static final SystemMessageId SERVITOR_USE_SPIRITSHOT;
	
	/**
	 * ID: 1577<br>
	 * Message: b̗͂gp܂B<br>
	 * Message: &#21484;&#21914;&#20351;&#39764;&#28748;&#27880;&#38728;&#39746;&#20043;&#21147;&#12290;<br>
	 * Message: Servitor uses the power of spirit.
	 */
	public static final SystemMessageId SERVITOR_USE_THE_POWER_OF_SPIRIT;
	
	/**
	 * ID: 1578<br>
	 * Message: lXlH[JĂ鎞̓ACe𑕔ł܂B<br>
	 * Message: &#22312;&#20491;&#20154;&#21830;&#24215;&#25110;&#20491;&#20154;&#24037;&#25151;&#20013;&#65292;&#28961;&#27861;&#35037;&#20633;&#36947;&#20855;&#12290;<br>
	 * Message: Items are not available for a private store or a private manufacture.
	 */
	public static final SystemMessageId ITEMS_UNAVAILABLE_FOR_STORE_MANUFACTURE;
	
	/**
	 * ID: 1579<br>
	 * Message: $c1̃ybg$s2Afiɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;&#29554;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#26522;&#37329;&#24163;&#12290;<br>
	 * Message: $c1's pet gained $s2 adena.
	 */
	public static final SystemMessageId C1_PET_GAINED_S2_ADENA;
	
	/**
	 * ID: 1580<br>
	 * Message: A܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#24050;&#32068;&#25104;&#12290;<br>
	 * Message: The Command Channel has been formed.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_FORMED;
	
	/**
	 * ID: 1581<br>
	 * Message: A܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#24050;&#35299;&#25955;&#12290;<br>
	 * Message: The Command Channel has been disbanded.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_DISBANDED;
	
	/**
	 * ID: 1582<br>
	 * Message: AɎQ܂B<br>
	 * Message: &#21152;&#20837;&#32879;&#21512;&#36557;&#12290;<br>
	 * Message: You have joined the Command Channel.
	 */
	public static final SystemMessageId JOINED_COMMAND_CHANNEL;
	
	/**
	 * ID: 1583<br>
	 * Message: AǕ܂B<br>
	 * Message: &#24744;&#34987;&#32879;&#21512;&#36557;&#38500;&#21517;&#12290;<br>
	 * Message: You were dismissed from the Command Channel.
	 */
	public static final SystemMessageId DISMISSED_FROM_COMMAND_CHANNEL;
	
	/**
	 * ID: 1584<br>
	 * Message: $c1̃p[eBAǕ܂B<br>
	 * Message: &#23559;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#36880;&#20986;&#32879;&#21512;&#36557;&#12290;<br>
	 * Message: $c1's party has been dismissed from the Command Channel.
	 */
	public static final SystemMessageId C1_PARTY_DISMISSED_FROM_COMMAND_CHANNEL;
	
	/**
	 * ID: 1585<br>
	 * Message: AANeBuɂȂ܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#26283;&#26178;&#20572;&#27490;&#36939;&#20316;&#12290;<br>
	 * Message: The Command Channel has been disbanded.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_DISBANDED2;
	
	/**
	 * ID: 1586<br>
	 * Message: AEނ܂B<br>
	 * Message: &#24050;&#36864;&#20986;&#32879;&#21512;&#36557;&#12290;<br>
	 * Message: You have quit the Command Channel.
	 */
	public static final SystemMessageId LEFT_COMMAND_CHANNEL;
	
	/**
	 * ID: 1587<br>
	 * Message: $c1̃p[eBA`lEނ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#24050;&#36864;&#20986;&#25351;&#25582;&#38971;&#36947;&#12290;<br>
	 * Message: $c1's party has left the Command Channel.
	 */
	public static final SystemMessageId C1_PARTY_LEFT_COMMAND_CHANNEL;
	
	/**
	 * ID: 1588<br>
	 * Message: A5ȏ̃p[eBQ̂݃ANeBuɂȂ܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#30340;&#27402;&#38480;&#24050;&#36681;&#35731;&#32102;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The Command Channel is activated only when there are at least 5 parties participating.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_ONLY_AT_LEAST_5_PARTIES;
	
	/**
	 * ID: 1589<br>
	 * Message: $c1ɘǍ^܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#30340;&#27402;&#38480;&#24050;&#36681;&#35731;&#32102;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: Command Channel authority has been transferred to $c1.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_LEADER_NOW_C1;
	
	/**
	 * ID: 1590<br>
	 * Message: ===<AiSp[eBF$s1)>===<br>
	 * Message: &#61;&#61;&#61;&#60;&#32879;&#21512;&#36557;&#35338;&#24687;&#65288;&#32317;&#38538;&#20237;&#25976;&#65306;&#36;&#115;&#49;&#65289;&#62;&#61;&#61;&#61;<br>
	 * Message: ===<Guild Info (Total Parties: $s1)>===
	 */
	public static final SystemMessageId GUILD_INFO_HEADER;
	
	/**
	 * ID: 1591<br>
	 * Message: Aɏ҂vC[܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#20839;&#27794;&#26377;&#25033;&#36992;&#30340;&#29609;&#23478;&#12290;<br>
	 * Message: No user has been invited to the Command Channel.
	 */
	public static final SystemMessageId NO_USER_INVITED_TO_COMMAND_CHANNEL;
	
	/**
	 * ID: 1592<br>
	 * Message: ȏAJ݂ł܂B<br>
	 * Message: &#28961;&#27861;&#20877;&#38283;&#35373;&#26032;&#30340;&#32879;&#21512;&#36557;&#12290;<br>
	 * Message: You can no longer set up a Command Channel.
	 */
	public static final SystemMessageId CANNOT_LONGER_SETUP_COMMAND_CHANNEL;
	
	/**
	 * ID: 1593<br>
	 * Message: Aɏ҂ł錠܂B<br>
	 * Message: &#19981;&#20855;&#20633;&#32879;&#21512;&#36557;&#30340;&#36992;&#35531;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have authority to invite someone to the Command Channel.
	 */
	public static final SystemMessageId CANNOT_INVITE_TO_COMMAND_CHANNEL;
	
	/**
	 * ID: 1594<br>
	 * Message: $c1̃p[eB͂łɘAɎQĂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#24050;&#32147;&#21152;&#20837;&#32879;&#21512;&#36557;&#12290;<br>
	 * Message: $c1's party is already a member of the Command Channel.
	 */
	public static final SystemMessageId C1_ALREADY_MEMBER_OF_COMMAND_CHANNEL;
	
	/**
	 * ID: 1595<br>
	 * Message: $s1ɐ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#25104;&#21151;&#20102;&#12290;<br>
	 * Message: $s1 has succeeded.
	 */
	public static final SystemMessageId S1_SUCCEEDED;
	
	/**
	 * ID: 1596<br>
	 * Message: $s1ɓ܂B<br>
	 * Message: &#34987;&#12300;&#36;&#115;&#49;&#12301;&#25802;&#20013;&#12290;<br>
	 * Message: You were hit by $s1!
	 */
	public static final SystemMessageId HIT_BY_S1;
	
	/**
	 * ID: 1597<br>
	 * Message: $s1s܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#22833;&#25943;&#20102;&#12290;<br>
	 * Message: $s1 has failed.
	 */
	public static final SystemMessageId S1_FAILED;
	
	/**
	 * ID: 1598<br>
	 * Message: ybgяbSԂł́Aybgяbp\E Vbg܂̓Xsbg Vbg͎gpł܂B<br>
	 * Message: &#30070;&#23541;&#29289;&#47;&#21484;&#21914;&#20351;&#39764;&#34389;&#26044;&#27515;&#20129;&#29376;&#24907;&#65292;&#21063;&#28961;&#27861;&#20351;&#29992;&#23541;&#29289;&#47;&#21484;&#21914;&#20351;&#39764;&#23560;&#29992;&#30340;&#38728;&#39746;&#24392;&#25110;&#39764;&#38728;&#24392;&#12290;<br>
	 * Message: Soulshots and spiritshots are not available for a dead pet or servitor. Sad, isn't it?
	 */
	public static final SystemMessageId SOULSHOTS_AND_SPIRITSHOTS_ARE_NOT_AVAILABLE_FOR_A_DEAD_PET;
	
	/**
	 * ID: 1599<br>
	 * Message: 퓬͊ϐł܂B<br>
	 * Message: &#25136;&#39717;&#30070;&#20013;&#19981;&#21487;&#35264;&#25136;&#12290;<br>
	 * Message: You cannot observe while you are in combat!
	 */
	public static final SystemMessageId CANNOT_OBSERVE_IN_COMBAT;
	
	/**
	 * ID: 1600<br>
	 * Message: ̍ڂ̐lׂ0ɏ܂B낵łB<br>
	 * Message: &#26126;&#22825;&#38917;&#30446;&#30340;&#25976;&#20540;&#23559;&#34987;&#21021;&#22987;&#21270;&#25104;&#28858;&#48;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: Tomorrow's items will ALL be set to 0. Do you wish to continue?
	 */
	public static final SystemMessageId TOMORROW_ITEM_ZERO_CONFIRM;
	
	/**
	 * ID: 1601<br>
	 * Message: ̍ڂ̐lׂčƓlɐݒ肳܂B낵łB<br>
	 * Message: &#26126;&#26085;&#38917;&#30446;&#30340;&#25976;&#20540;&#65292;&#24050;&#35373;&#23450;&#21516;&#26044;&#20170;&#22825;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: Tomorrow's items will all be set to the same value as today's items. Do you wish to continue?
	 */
	public static final SystemMessageId TOMORROW_ITEM_SAME_CONFIRM;
	
	/**
	 * ID: 1602<br>
	 * Message: A`bg̓p[eB [_[̂ݎQł܂B<br>
	 * Message: &#21482;&#26377;&#38538;&#38263;&#25165;&#26377;&#27402;&#38480;&#36914;&#34892;&#32879;&#21512;&#36557;&#20839;&#20132;&#35527;&#12290;<br>
	 * Message: Only a party leader can access the Command Channel.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_ONLY_FOR_PARTY_LEADER;
	
	/**
	 * ID: 1603<br>
	 * Message: S̖߂̓`lJݎ҂̂ݍsƂł܂B<br>
	 * Message: &#21482;&#26377;&#38971;&#36947;&#38283;&#35373;&#32773;&#25165;&#26377;&#27402;&#36914;&#34892;&#25972;&#39636;&#21629;&#20196;&#12290;<br>
	 * Message: Only channel operator can give All Command.
	 */
	public static final SystemMessageId ONLY_COMMANDER_GIVE_COMMAND;
	
	/**
	 * ID: 1604<br>
	 * Message: 畞pׂ͂ẴXLƁA[VKvȃACegpł܂B<br>
	 * Message: &#36523;&#33879;&#31150;&#26381;&#26178;&#65292;&#23601;&#28961;&#27861;&#20351;&#29992;&#26377;&#38364;&#25216;&#33021;&#33287;&#26045;&#23637;&#21205;&#20316;&#19978;&#25152;&#38656;&#30340;&#20219;&#20309;&#36947;&#20855;&#12290;<br>
	 * Message: While dressed in formal wear, you can't use items that require all skills and casting operations.
	 */
	public static final SystemMessageId CANNOT_USE_ITEMS_SKILLS_WITH_FORMALWEAR;
	
	/**
	 * ID: 1605<br>
	 * Message: *ł$s1̎̂ݍwł܂B<br>
	 * Message: &#42;&#32;&#22312;&#27492;&#34389;&#21482;&#33021;&#36092;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#33674;&#22290;&#30340;&#31278;&#23376;&#12290;<br>
	 * Message: * Here, you can buy only seeds of $s1 Manor.
	 */
	public static final SystemMessageId HERE_YOU_CAN_BUY_ONLY_SEEDS_OF_S1_MANOR;
	
	/**
	 * ID: 1606<br>
	 * Message: 3]ENGXgNAAVȃNXɓ]E܂B߂łƂ܂I<br>
	 * Message: &#24050;&#23436;&#25104;&#31532;&#51;&#27425;&#36681;&#32887;&#20219;&#21209;&#65292;&#25104;&#21151;&#25509;&#20219;&#26032;&#30340;&#20219;&#21209;&#12290;&#24685;&#21916;&#65281;<br>
	 * Message: Congratulations - You've completed the third-class transfer quest!
	 */
	public static final SystemMessageId THIRD_CLASS_TRANSFER;
	
	/**
	 * ID: 1607<br>
	 * Message: $s1Afi𔃎萔ƂĎx܂B<br>
	 * Message: &#21033;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#20358;&#25903;&#20184;&#25910;&#36092;&#25163;&#32396;&#36027;&#29992;&#12290;<br>
	 * Message: $s1 adena has been withdrawn to pay for purchasing fees.
	 */
	public static final SystemMessageId S1_ADENA_HAS_BEEN_WITHDRAWN_TO_PAY_FOR_PURCHASING_FEES;
	
	/**
	 * ID: 1608<br>
	 * Message: Afisđ̔肪ł܂B<br>
	 * Message: &#37329;&#24163;&#19981;&#36275;&#65292;&#28961;&#27861;&#25910;&#36092;&#20182;&#22478;&#12290;<br>
	 * Message: Due to insufficient adena you cannot buy another castle.
	 */
	public static final SystemMessageId INSUFFICIENT_ADENA_TO_BUY_CASTLE;
	
	/**
	 * ID: 1609<br>
	 * Message: łɐzłB<br>
	 * Message: &#24050;&#23459;&#21578;&#25136;&#29229;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: War has already been declared against that clan... but I'll make note that you really don't like them.
	 */
	public static final SystemMessageId WAR_ALREADY_DECLARED;
	
	/**
	 * ID: 1610<br>
	 * Message: ̌ɂ͐zł܂B<br>
	 * Message: &#28961;&#27861;&#21521;&#33258;&#24049;&#30340;&#34880;&#30431;&#23459;&#25136;&#12290;<br>
	 * Message: Fool! You cannot declare war against your own clan!
	 */
	public static final SystemMessageId CANNOT_DECLARE_AGAINST_OWN_CLAN;
	
	/**
	 * ID: 1611<br>
	 * Message: p[eB [_[F $c1<br>
	 * Message: &#38538;&#38263;&#65306;&#12300;&#36;&#99;&#49;&#12301;<br>
	 * Message: Leader: $c1
	 */
	public static final SystemMessageId PARTY_LEADER_C1;
	
	/**
	 * ID: 1612<br>
	 * Message: =====<ozXg>=====<br>
	 * Message: &#61;&#61;&#61;&#61;&#61;&#61;&#61;&#60;&#25136;&#29229;&#21517;&#21934;&#62;&#61;&#61;&#61;&#61;&#61;&#61;&#61;<br>
	 * Message: =====<War List>=====
	 */
	public static final SystemMessageId WAR_LIST;
	
	/**
	 * ID: 1613<br>
	 * Message: oz܂B<br>
	 * Message: &#30446;&#21069;&#25105;&#26041;&#20006;&#27794;&#26377;&#38617;&#26041;&#21516;&#26178;&#23459;&#25136;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: There is no clan listed on War List.
	 */
	public static final SystemMessageId NO_CLAN_ON_WAR_LIST;
	
	/**
	 * ID: 1614<br>
	 * Message: łɊJ݂ꂽ`lɎQĂ܂B<br>
	 * Message: &#24050;&#32147;&#21443;&#21152;&#20102;&#20854;&#20182;&#30340;&#38971;&#36947;&#12290;<br>
	 * Message: You have joined a channel that was already open.
	 */
	public static final SystemMessageId JOINED_CHANNEL_ALREADY_OPEN;
	
	/**
	 * ID: 1615<br>
	 * Message: `lANeBu܂$s1̃p[eBQł܂B<br>
	 * Message: &#38971;&#36947;&#30340;&#38283;&#22987;&#36939;&#20316;&#65292;&#23578;&#32570;&#12300;&#36;&#115;&#49;&#12301;&#20491;&#38538;&#20237;&#30340;&#21152;&#20837;&#12290;<br>
	 * Message: The number of remaining parties is $s1 until a channel is activated
	 */
	public static final SystemMessageId S1_PARTIES_REMAINING_UNTIL_CHANNEL;
	
	/**
	 * ID: 1616<br>
	 * Message: AANeBuɂȂ܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#24050;&#38283;&#22987;&#36939;&#20316;&#12290;<br>
	 * Message: The Command Channel has been activated.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_ACTIVATED;
	
	/**
	 * ID: 1617<br>
	 * Message: A𗘗pł錠܂B<br>
	 * Message: &#19981;&#20855;&#20633;&#32879;&#21512;&#36557;&#30340;&#21033;&#29992;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have the authority to use the Command Channel.
	 */
	public static final SystemMessageId CANT_USE_COMMAND_CHANNEL;
	
	/**
	 * ID: 1618<br>
	 * Message: E` O[fB`s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#39791;&#22240;&#28207;&#21475;&#21069;&#24448;&#21476;&#39791;&#19969;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Rune Harbor to Gludin Harbor has been delayed.
	 */
	public static final SystemMessageId FERRY_RUNE_GLUDIN_DELAYED;
	
	/**
	 * ID: 1619<br>
	 * Message: O[fB` E`s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#21476;&#39791;&#19969;&#28207;&#21475;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Gludin Harbor to Rune Harbor has been delayed.
	 */
	public static final SystemMessageId FERRY_GLUDIN_RUNE_DELAYED;
	
	/**
	 * ID: 1620<br>
	 * Message: E`ɓ܂B<br>
	 * Message: &#24050;&#25269;&#36948;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: Arrived at Rune Harbor.
	 */
	public static final SystemMessageId ARRIVED_AT_RUNE;
	
	/**
	 * ID: 1621<br>
	 * Message: 5AE`O[fB`s̑Doq܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#21476;&#39791;&#19969;&#12290;<br>
	 * Message: Departure for Gludin Harbor will take place in five minutes!
	 */
	public static final SystemMessageId DEPARTURE_FOR_GLUDIN_5_MINUTES;
	
	/**
	 * ID: 1622<br>
	 * Message: 1AE`O[fB`s̑Doq܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#21476;&#39791;&#19969;&#12290;<br>
	 * Message: Departure for Gludin Harbor will take place in one minute!
	 */
	public static final SystemMessageId DEPARTURE_FOR_GLUDIN_1_MINUTE;
	
	/**
	 * ID: 1623<br>
	 * Message: ܂ȂAE`O[fB`s̑Doq܂B<br>
	 * Message: &#21363;&#23559;&#24478;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#21476;&#39791;&#19969;&#12290;<br>
	 * Message: Make haste! We will be departing for Gludin Harbor shortly...
	 */
	public static final SystemMessageId DEPARTURE_FOR_GLUDIN_SHORTLY;
	
	/**
	 * ID: 1624<br>
	 * Message: E`O[fB`s̑Doq܂B<br>
	 * Message: &#24478;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#21476;&#39791;&#19969;&#12290;<br>
	 * Message: We are now departing for Gludin Harbor Hold on and enjoy the ride!
	 */
	public static final SystemMessageId DEPARTURE_FOR_GLUDIN_NOW;
	
	/**
	 * ID: 1625<br>
	 * Message: 10Ԓ┑AE`ɏo܂B<br>
	 * Message: &#20572;&#27850;&#49;&#48;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: Departure for Rune Harbor will take place after anchoring for ten minutes.
	 */
	public static final SystemMessageId DEPARTURE_FOR_RUNE_10_MINUTES;
	
	/**
	 * ID: 1626<br>
	 * Message: 5AO[fB`烋E`s̑Doq܂B<br>
	 * Message: &#53;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: Departure for Rune Harbor will take place in five minutes!
	 */
	public static final SystemMessageId DEPARTURE_FOR_RUNE_5_MINUTES;
	
	/**
	 * ID: 1627<br>
	 * Message: 1AO[fB`烋E`s̑Doq܂B<br>
	 * Message: &#49;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: Departure for Rune Harbor will take place in one minute!
	 */
	public static final SystemMessageId DEPARTURE_FOR_RUNE_1_MINUTE;
	
	/**
	 * ID: 1628<br>
	 * Message: ܂ȂAO[fB`烋E`s̑Doq܂B<br>
	 * Message: &#21363;&#23559;&#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: Make haste! We will be departing for Gludin Harbor shortly...
	 */
	public static final SystemMessageId DEPARTURE_FOR_GLUDIN_SHORTLY2;
	
	/**
	 * ID: 1629<br>
	 * Message: O[fB`烋E`s̑Doq܂B<br>
	 * Message: &#24478;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: We are now departing for Rune Harbor Hold on and enjoy the ride!
	 */
	public static final SystemMessageId DEPARTURE_FOR_RUNE_NOW;
	
	/**
	 * ID: 1630<br>
	 * Message: E`̒DA15O[fB`ɓ܂B<br>
	 * Message: &#33258;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#53;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Rune Harbor will be arriving at Gludin Harbor in approximately 15 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_RUNE_AT_GLUDIN_15_MINUTES;
	
	/**
	 * ID: 1631<br>
	 * Message: E`̒DA10O[fB`ɓ܂B<br>
	 * Message: &#33258;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#48;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Rune Harbor will be arriving at Gludin Harbor in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_RUNE_AT_GLUDIN_10_MINUTES;
	
	/**
	 * ID: 1632<br>
	 * Message: E`̒DA5O[fB`ɓ܂B<br>
	 * Message: &#33258;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#53;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Rune Harbor will be arriving at Gludin Harbor in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_RUNE_AT_GLUDIN_5_MINUTES;
	
	/**
	 * ID: 1633<br>
	 * Message: E`̒DA1O[fB`ɓ܂B<br>
	 * Message: &#33258;&#39791;&#22240;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#21476;&#39791;&#19969;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Rune Harbor will be arriving at Gludin Harbor in approximately 1 minute.
	 */
	public static final SystemMessageId FERRY_FROM_RUNE_AT_GLUDIN_1_MINUTE;
	
	/**
	 * ID: 1634<br>
	 * Message: O[fB`̒DA15ニE`ɓ܂B<br>
	 * Message: &#33258;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#53;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Rune Harbor in approximately 15 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_AT_RUNE_15_MINUTES;
	
	/**
	 * ID: 1635<br>
	 * Message: O[fB`̒DA10ニE`ɓ܂B<br>
	 * Message: &#33258;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#48;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Rune harbor in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_AT_RUNE_10_MINUTES;
	
	/**
	 * ID: 1636<br>
	 * Message: O[fB`̒DA5ニE`ɓ܂B<br>
	 * Message: &#33258;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#53;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Rune Harbor in approximately 10 minutes.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_AT_RUNE_5_MINUTES;
	
	/**
	 * ID: 1637<br>
	 * Message: O[fB`̒DA1ニE`ɓ܂B<br>
	 * Message: &#33258;&#21476;&#39791;&#19969;&#28207;&#21475;&#20986;&#30332;&#30340;&#23450;&#26399;&#33337;&#65292;&#23559;&#22312;&#49;&#20998;&#37912;&#20043;&#24460;&#25269;&#36948;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry from Gludin Harbor will be arriving at Rune Harbor in approximately 1 minute.
	 */
	public static final SystemMessageId FERRY_FROM_GLUDIN_AT_RUNE_1_MINUTE;
	
	/**
	 * ID: 1638<br>
	 * Message: }WAlH[AlX̎gpɂ̓tBbVOł܂B<br>
	 * Message: &#22312;&#20351;&#29992;&#35069;&#20316;&#21367;&#36600;&#26360;&#31821;&#12289;&#20491;&#20154;&#24037;&#25151;&#20197;&#21450;&#20491;&#20154;&#21830;&#24215;&#30070;&#20013;&#65292;&#28961;&#27861;&#36914;&#34892;&#22402;&#37347;&#12290;<br>
	 * Message: You cannot fish while using a recipe book, private manufacture or private store.
	 */
	public static final SystemMessageId CANNOT_FISH_WHILE_USING_RECIPE_BOOK;
	
	/**
	 * ID: 1639<br>
	 * Message: $s1IsA[hԂn܂܂B<br>
	 * Message: &#31532;&#36;&#115;&#49;&#26399;&#22887;&#26519;&#21305;&#20126;&#36913;&#26399;&#38283;&#22987;&#12290;<br>
	 * Message: Period $s1 of the Grand Olympiad Games has started!
	 */
	public static final SystemMessageId OLYMPIAD_PERIOD_S1_HAS_STARTED;
	
	/**
	 * ID: 1640<br>
	 * Message: $s1IsA[hԂI܂B<br>
	 * Message: &#31532;&#36;&#115;&#49;&#26399;&#22887;&#26519;&#21305;&#20126;&#36913;&#26399;&#32080;&#26463;&#12290;<br>
	 * Message: Period $s1 of the Grand Olympiad Games has now ended.
	 */
	public static final SystemMessageId OLYMPIAD_PERIOD_S1_HAS_ENDED;
	
	/**
	 * ID: 1641<br>
	 * Message: IsA[hZn܂܂B<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#36093;&#31243;&#38283;&#22987;&#12290;<br>
	 * Message: Sharpen your swords, tighten the stitching in your armor, and make haste to a Grand Olympiad Manager! Battles in the Grand Olympiad Games are now taking place!
	 */
	public static final SystemMessageId THE_OLYMPIAD_GAME_HAS_STARTED;
	
	/**
	 * ID: 1642<br>
	 * Message: IsA[hZI܂B<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#36093;&#31243;&#32080;&#26463;&#12290;<br>
	 * Message: Much carnage has been left for the cleanup crew of the Olympiad Stadium. Battles in the Grand Olympiad Games are now over!
	 */
	public static final SystemMessageId THE_OLYMPIAD_GAME_HAS_ENDED;
	
	/**
	 * ID: 1643<br>
	 * Message: ݒnF $s1A$s2A$s3 (̋)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#27425;&#20803;&#30340;&#35010;&#30165;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (Dimensional Gap)
	 */
	public static final SystemMessageId LOC_DIMENSIONAL_GAP_S1_S2_S3;
	
	// 1644 - 1648: none
	
	/**
	 * ID: 1649<br>
	 * Message: ڑԂ̗ݐςĊJ܂B<br>
	 * Message: &#32047;&#31309;&#36899;&#32218;&#26178;&#38291;&#23559;&#37325;&#26032;&#38283;&#22987;&#12290;<br>
	 * Message: Play time is now accumulating.
	 */
	public static final SystemMessageId PLAY_TIME_NOW_ACCUMULATING;
	
	/**
	 * ID: 1650<br>
	 * Message: ύ݂Ă܂̂Őڑł܂B΂炭ĂēxANZXĂB<br>
	 * Message: &#22240;&#29609;&#23478;&#36942;&#22810;&#65292;&#22240;&#27492;&#36899;&#32218;&#28961;&#27861;&#38918;&#21033;&#23436;&#25104;&#12290;&#32;&#35531;&#31245;&#20505;&#20877;&#35430;&#36899;&#32218;&#12290;<br>
	 * Message: Due to high server traffic, your login attempt has failed. Please try again soon.
	 */
	public static final SystemMessageId TRY_LOGIN_LATER;
	
	/**
	 * ID: 1651<br>
	 * Message: IsA[hZs鎞Ԃł͂܂B<br>
	 * Message: &#19981;&#26159;&#22887;&#26519;&#21305;&#20126;&#31478;&#36093;&#30340;&#36914;&#34892;&#26178;&#38291;&#12290;<br>
	 * Message: The Grand Olympiad Games are not currently in progress.
	 */
	public static final SystemMessageId THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS;
	
	/**
	 * ID: 1652<br>
	 * Message: vC^n߂܂B<br>
	 * Message: &#24433;&#20687;&#37636;&#35069;&#38283;&#22987;&#12290;<br>
	 * Message: You are now recording gameplay.
	 */
	public static final SystemMessageId RECORDING_GAMEPLAY_START;
	
	/**
	 * ID: 1653<br>
	 * Message: vC t@Cۑ܂B($s1)<br>
	 * Message: &#24433;&#20687;&#27284;&#26696;&#37636;&#35069;&#25104;&#21151;&#12290;&#65288;&#36;&#115;&#49;&#65289;<br>
	 * Message: Your recording has been successfully stored. ($s1)
	 */
	public static final SystemMessageId RECORDING_GAMEPLAY_STOP_S1;
	
	/**
	 * ID: 1654<br>
	 * Message: vC^Ɏs܂B<br>
	 * Message: &#24433;&#20687;&#37636;&#24433;&#22833;&#25943;&#12290;<br>
	 * Message: Your attempt to record the replay file has failed.
	 */
	public static final SystemMessageId RECORDING_GAMEPLAY_FAILED;
	
	/**
	 * ID: 1655<br>
	 * Message: X^[ނ܂I<br>
	 * Message: &#37347;&#21040;&#24618;&#29289;&#20102;&#65281;<br>
	 * Message: You caught something smelly and scary, maybe you should throw it back!?
	 */
	public static final SystemMessageId YOU_CAUGHT_SOMETHING_SMELLY_THROW_IT_BACK;
	
	/**
	 * ID: 1656<br>
	 * Message: NPCƂ̃g[hɐ܂B<br>
	 * Message: &#33287;&#78;&#80;&#67;&#20132;&#25563;&#25104;&#21151;&#12290;<br>
	 * Message: You have successfully traded the item with the NPC.
	 */
	public static final SystemMessageId SUCCESSFULLY_TRADED_WITH_NPC;
	
	/**
	 * ID: 1657<br>
	 * Message: $c1IsA[h |Cg$s2|Cg𓾂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#22887;&#26519;&#21305;&#20126;&#40670;&#25976;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12290;<br>
	 * Message: $c1 has earned $s2 points in the Grand Olympiad Games.
	 */
	public static final SystemMessageId C1_HAS_GAINED_S2_OLYMPIAD_POINTS;
	
	/**
	 * ID: 1658<br>
	 * Message: $c1IsA[h |Cg$s2|Cg܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22833;&#21435;&#22887;&#26519;&#21305;&#20126;&#40670;&#25976;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12290;<br>
	 * Message: $c1 has lost $s2 points in the Grand Olympiad Games.
	 */
	public static final SystemMessageId C1_HAS_LOST_S2_OLYMPIAD_POINTS;
	
	/**
	 * ID: 1659<br>
	 * Message: ݒnF $s1A$s2A$s3 (鍑̕n)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#24093;&#22283;&#20043;&#22675;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (Cemetery of the Empire)
	 */
	public static final SystemMessageId LOC_CEMETARY_OF_THE_EMPIRE_S1_S2_S3;
	
	/**
	 * ID: 1660<br>
	 * Message: `lJݎҁF $c1<br>
	 * Message: &#38971;&#36947;&#20027;&#20154;&#65306;&#12300;&#36;&#99;&#49;&#12301;<br>
	 * Message: Channel Creator: $c1.
	 */
	public static final SystemMessageId CHANNEL_CREATOR_C1;
	
	/**
	 * ID: 1661<br>
	 * Message: $c1$s2 $s3ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#29554;&#24471;&#12300;&#36;&#115;&#51;&#12301;&#20491;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has obtained $s3 $s2s.
	 */
	public static final SystemMessageId C1_OBTAINED_S3_S2_S;
	
	/**
	 * ID: 1662<br>
	 * Message: ӏŒԒނĂƐHmႭȂ܂B̏ꏊɈړđĂB<br>
	 * Message: &#33509;&#22312;&#21516;&#19968;&#20491;&#22320;&#26041;&#38263;&#26178;&#38291;&#37347;&#39770;&#65292;&#23601;&#26371;&#38477;&#20302;&#39770;&#20818;&#19978;&#37390;&#30340;&#27231;&#29575;&#12290;&#24314;&#35696;&#24744;&#31227;&#33267;&#21029;&#34389;&#32380;&#32396;&#37347;&#39770;&#12290;<br>
	 * Message: The fish are no longer biting here because you've caught too many! Try fishing in another location.
	 */
	public static final SystemMessageId FISH_NO_MORE_BITING_TRY_OTHER_LOCATION;
	
	/**
	 * ID: 1663<br>
	 * Message: GTCo^܂͍폜܂BAWg܂͏L錌ɂ̂݁A֘AACeɃGTC\܂B<br>
	 * Message: &#24509;&#31456;&#30331;&#35352;&#25104;&#21151;&#12290;&#20677;&#38480;&#25793;&#26377;&#26681;&#25818;&#22320;&#25110;&#25793;&#26377;&#22478;&#22561;&#30340;&#34880;&#30431;&#65292;&#25165;&#33021;&#22312;&#33287;&#34880;&#30431;&#30456;&#38364;&#30340;&#36947;&#20855;&#19978;&#27161;&#31034;&#24509;&#31456;&#12290;<br>
	 * Message: The clan crest was successfully registered. Remember, only a clan that owns a clan hall or castle can have their crest displayed.
	 */
	public static final SystemMessageId CLAN_EMBLEM_WAS_SUCCESSFULLY_REGISTERED;
	
	/**
	 * ID: 1664<br>
	 * Message: RĂ̂ŃELĂ܂B<br>
	 * Message: &#39770;&#27491;&#22312;&#25269;&#25239;&#65292;&#39770;&#28418;&#25622;&#21205;&#30340;&#24456;&#21426;&#23475;&#12290;<br>
	 * Message: The fish is resisting your efforts to haul it in! Look at that bobber go!
	 */
	public static final SystemMessageId FISH_RESISTING_LOOK_BOBBLER;
	
	/**
	 * ID: 1665<br>
	 * Message: Ă̂ŃEL̓アłB<br>
	 * Message: &#39770;&#30130;&#20518;&#20102;&#65292;&#39770;&#28418;&#25622;&#21205;&#30340;&#24456;&#24494;&#24369;&#12290;<br>
	 * Message: You've worn that fish out! It can't even pull the bobber under the water!
	 */
	public static final SystemMessageId YOU_WORN_FISH_OUT;
	
	/**
	 * ID: 1666<br>
	 * Message: +$s1$s2ɓ܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: You have obtained +$s1 $s2.
	 */
	public static final SystemMessageId OBTAINED_S1_S2;
	
	/**
	 * ID: 1667<br>
	 * Message: CX^g LI<br>
	 * Message: &#30636;&#27578;&#65281;<br>
	 * Message: Lethal Strike!
	 */
	public static final SystemMessageId LETHAL_STRIKE;
	
	/**
	 * ID: 1668<br>
	 * Message: XLqbg܂I<br>
	 * Message: &#36973;&#21463;&#21363;&#27515;&#25216;&#33021;&#25915;&#25802;&#65281;<br>
	 * Message: Your lethal strike was successful!
	 */
	public static final SystemMessageId LETHAL_STRIKE_SUCCESSFUL;
	
	/**
	 * ID: 1669<br>
	 * Message: ACeϊɎs܂B<br>
	 * Message: &#36681;&#25563;&#36947;&#20855;&#22833;&#25943;&#12290;<br>
	 * Message: There was nothing found inside of that.
	 */
	public static final SystemMessageId NOTHING_INSIDE_THAT;
	
	/**
	 * ID: 1670<br>
	 * Message: [O(|sO)XL̃xtBbVO }X^[̃x̂$s1̃yieBKp܂B<br>
	 * Message: &#25918;&#32218;&#40;&#25289;&#32218;&#41;&#25216;&#33021;&#30340;&#31561;&#32026;&#27604;&#31934;&#36890;&#37347;&#39770;&#31561;&#32026;&#39640;&#65292;&#22240;&#27492;&#34389;&#20197;&#36;&#115;&#49;&#37;&#30340;&#25074;&#32624;&#12290;<br>
	 * Message: Due to your Reeling and/or Pumping skill being three or more levels higher than your Fishing skill, a 50 damage penalty will be applied.
	 */
	public static final SystemMessageId REELING_PUMPING_3_LEVELS_HIGHER_THAN_FISHING_PENALTY;
	
	/**
	 * ID: 1671<br>
	 * Message: [OI(}X^[ yieBF$s1)<br>
	 * Message: &#25918;&#32218;&#25104;&#21151;&#65281;&#40;&#31934;&#36890;&#25074;&#32624;&#65306;&#36;&#115;&#49;&#37;&#41;<br>
	 * Message: Your reeling was successful! (Mastery Penalty:$s1 )
	 */
	public static final SystemMessageId REELING_SUCCESSFUL_PENALTY_S1;
	
	/**
	 * ID: 1672<br>
	 * Message: |sOI(}X^[ yieBF$s1)<br>
	 * Message: &#25289;&#32218;&#25104;&#21151;&#65281;&#40;&#31934;&#36890;&#25074;&#32624;&#65306;&#36;&#115;&#49;&#37;&#41;<br>
	 * Message: Your pumping was successful! (Mastery Penalty:$s1 )
	 */
	public static final SystemMessageId PUMPING_SUCCESSFUL_PENALTY_S1;
	
	/**
	 * ID: 1673<br>
	 * Message: ̃IsA[ȟ݂̐т$s1$s2$s3słBlIsA[h |Cg$s4|CgłB<br>
	 * Message: &#36889;&#27425;&#22887;&#26519;&#21305;&#20126;&#26399;&#38291;&#30340;&#30446;&#21069;&#25136;&#32318;&#26159;&#36;&#115;&#49;&#25136;&#32;&#36;&#115;&#50;&#21213;&#32;&#36;&#115;&#51;&#25943;&#12290;&#25152;&#29554;&#24471;&#30340;&#22887;&#26519;&#21305;&#20126;&#40670;&#25976;&#28858;&#36;&#115;&#52;&#20998;&#12290;<br>
	 * Message: Your current record for this Grand Olympiad is $s1 match(es), $s2 win(s) and $s3 defeat(s). You have earned $s4 Olympiad Point(s).
	 */
	public static final SystemMessageId THE_CURRENT_RECORD_FOR_THIS_OLYMPIAD_SESSION_IS_S1_MATCHES_S2_WINS_S3_DEFEATS_YOU_HAVE_EARNED_S4_OLYMPIAD_POINTS;
	
	/**
	 * ID: 1674<br>
	 * Message: Ώۂm[uX̏ꍇÃR}h͎g܂B<br>
	 * Message: &#30446;&#27161;&#28858;&#36020;&#26063;&#26178;&#25165;&#33021;&#20351;&#29992;&#30340;&#25351;&#20196;&#12290;<br>
	 * Message: This command can only be used by a Noblesse.
	 */
	public static final SystemMessageId NOBLESSE_ONLY;
	
	/**
	 * ID: 1675<br>
	 * Message: 043020̊Ԃ͑̐ݒύXł܂B<br>
	 * Message: &#48;&#52;&#40670;&#51;&#48;&#20998;&#21040;&#50;&#48;&#40670;&#20043;&#38291;&#65292;&#28961;&#27861;&#35373;&#23450;&#33674;&#22290;&#12290;<br>
	 * Message: A manor cannot be set up between 6 a.m. and 8 p.m.
	 */
	public static final SystemMessageId A_MANOR_CANNOT_BE_SET_UP_BETWEEN_6_AM_AND_8_PM;
	
	/**
	 * ID: 1676<br>
	 * Message: b܂̓ybgȂ̂Ŏgpł܂B<br>
	 * Message: &#27794;&#26377;&#20351;&#39764;&#25110;&#23541;&#29289;&#65292;&#25152;&#20197;&#28961;&#27861;&#23559;&#20854;&#33258;&#21205;&#21270;&#12290;<br>
	 * Message: You do not have a servitor or pet and therefore cannot use the automatic-use function.
	 */
	public static final SystemMessageId NO_SERVITOR_CANNOT_AUTOMATE_USE;
	
	/**
	 * ID: 1677<br>
	 * Message: 퓬݂̌̂ŕz܂B<br>
	 * Message: &#24050;&#26377;&#34880;&#30431;&#25104;&#21729;&#22312;&#36914;&#34892;&#25136;&#39717;&#65292;&#25152;&#20197;&#28961;&#27861;&#21462;&#28040;&#23459;&#25136;&#12290;<br>
	 * Message: A cease-fire during a Clan War can not be called while members of your clan are engaged in battle.
	 */
	public static final SystemMessageId CANT_STOP_CLAN_WAR_WHILE_IN_COMBAT;
	
	/**
	 * ID: 1678<br>
	 * Message: $s1Ɍz܂łB<br>
	 * Message: &#26410;&#21521;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#25552;&#20986;&#34880;&#30431;&#25136;&#23459;&#25136;&#12290;<br>
	 * Message: You have not declared a Clan War against the clan $s1.
	 */
	public static final SystemMessageId NO_CLAN_WAR_AGAINST_CLAN_S1;
	
	/**
	 * ID: 1679<br>
	 * Message: S̖߂̓`lJݎ҂̂ݎsł܂B<br>
	 * Message: &#21482;&#26377;&#38971;&#36947;&#20027;&#20154;&#25165;&#33021;&#30332;&#20986;&#20840;&#39636;&#25351;&#20196;&#12290;<br>
	 * Message: Only the creator of a channel can issue a global command.
	 */
	public static final SystemMessageId ONLY_CHANNEL_CREATOR_CAN_GLOBAL_COMMAND;
	
	/**
	 * ID: 1680<br>
	 * Message: $c1`l҂ۂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25298;&#32085;&#21152;&#20837;&#38971;&#36947;&#30340;&#36992;&#35531;&#12290;<br>
	 * Message: $c1 has declined the channel invitation.
	 */
	public static final SystemMessageId C1_DECLINED_CHANNEL_INVITATION;
	
	/**
	 * ID: 1681<br>
	 * Message: $c1̉Ȃ̂Ń`l҂Ɏs܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#27794;&#26377;&#22238;&#35206;&#65292;&#25152;&#20197;&#36992;&#35531;&#21152;&#20837;&#38971;&#36947;&#22833;&#25943;&#12290;<br>
	 * Message: Since $c1 did not respond, your channel invitation has failed.
	 */
	public static final SystemMessageId C1_DID_NOT_RESPOND_CHANNEL_INVITATION_FAILED;
	
	/**
	 * ID: 1682<br>
	 * Message: `lǕ͊Jݎ҂̂ݎsł܂B<br>
	 * Message: &#21482;&#26377;&#38971;&#36947;&#20027;&#20154;&#25165;&#33021;&#39493;&#36880;&#38971;&#36947;&#12290;<br>
	 * Message: Only the creator of a channel can use the channel dismiss command.
	 */
	public static final SystemMessageId ONLY_CHANNEL_CREATOR_CAN_DISMISS;
	
	/**
	 * ID: 1683<br>
	 * Message: `lEނ̓p[eB [_[̂ݎsł܂B<br>
	 * Message: &#21482;&#26377;&#38538;&#20237;&#38538;&#38263;&#25165;&#33021;&#33067;&#38626;&#38971;&#36947;&#12290;<br>
	 * Message: Only a party leader can leave a command channel.
	 */
	public static final SystemMessageId ONLY_PARTY_LEADER_CAN_LEAVE_CHANNEL;
	
	/**
	 * ID: 1684<br>
	 * Message: Uɂ͌zł܂B<br>
	 * Message: &#22312;&#34880;&#30431;&#35299;&#25955;&#20013;&#26178;&#65292;&#28961;&#27861;&#25552;&#20986;&#34880;&#30431;&#25136;&#23459;&#25136;&#12290;<br>
	 * Message: A Clan War can not be declared against a clan that is being dissolved.
	 */
	public static final SystemMessageId NO_CLAN_WAR_AGAINST_DISSOLVING_CLAN;
	
	/**
	 * ID: 1685<br>
	 * Message: PKJEg1ȏゾƑłȂACełB<br>
	 * Message: &#27492;&#28858;&#80;&#75;&#32;&#20540;&#49;&#20197;&#19978;&#26178;&#28961;&#27861;&#20329;&#25140;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: You are unable to equip this item when your PK count is greater or equal to one.
	 */
	public static final SystemMessageId YOU_ARE_UNABLE_TO_EQUIP_THIS_ITEM_WHEN_YOUR_PK_COUNT_IS_GREATER_THAN_OR_EQUAL_TO_ONE;
	
	/**
	 * ID: 1686<br>
	 * Message: ǂ܂B<br>
	 * Message: &#22478;&#29254;&#36973;&#21040;&#27584;&#22750;&#12290;<br>
	 * Message: Stones and mortar tumble to the earth - the castle wall has taken damage!
	 */
	public static final SystemMessageId CASTLE_WALL_DAMAGED;
	
	/**
	 * ID: 1687<br>
	 * Message: Co[ɏ܂܂ł͍sȂGAłB܂Ɠ悪܂B<br>
	 * Message: &#39438;&#20056;&#39131;&#40845;&#26178;&#28961;&#27861;&#36914;&#20837;&#30340;&#21312;&#22495;&#12290;&#33509;&#19968;&#30452;&#20572;&#30041;&#22312;&#27492;&#22320;&#21312;&#65292;&#23559;&#26371;&#24375;&#21046;&#35299;&#38500;&#39438;&#20056;&#29376;&#24907;&#12290;<br>
	 * Message: This area cannot be entered while mounted atop of a Wyvern. You will be dismounted from your Wyvern if you do not leave!
	 */
	public static final SystemMessageId AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN;
	
	/**
	 * ID: 1688<br>
	 * Message: lXlH[̏Ԃł̓G`gł܂B<br>
	 * Message: &#22312;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#25110;&#26159;&#20491;&#20154;&#24037;&#25151;&#26178;&#65292;&#28961;&#27861;&#36914;&#34892;&#24375;&#21270;&#12290;<br>
	 * Message: You cannot enchant while operating a Private Store or Private Workshop.
	 */
	public static final SystemMessageId CANNOT_ENCHANT_WHILE_STORE;
	
	/**
	 * ID: 1689<br>
	 * Message: $c1 ̓NXʋZ̑ҋ@҃Xgɂłɓo^Ă܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30331;&#35352;&#22312;&#32887;&#26989;&#39006;&#21029;&#27604;&#36093;&#21443;&#36093;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: $c1 is already registered on the class match waiting list.
	 */
	public static final SystemMessageId C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST;
	
	/**
	 * ID: 1690<br>
	 * Message: $c1 ̓NXlZ̑ҋ@҃Xgɂłɓo^Ă܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30331;&#35352;&#22312;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#20491;&#20154;&#27604;&#36093;&#21443;&#36093;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: $c1 is already registered on the waiting list for the non-class-limited individual match event.
	 */
	public static final SystemMessageId C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST;
	
	/**
	 * ID: 1691<br>
	 * Message: $c1 ͎Qɍ܂BCxg Xbg80𒴂Ă邽߁AIsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#19981;&#31526;&#21512;&#21443;&#21152;&#26781;&#20214;&#12290;&#36947;&#20855;&#25884;&#24118;&#25976;&#37327;&#24050;&#36229;&#36942;&#56;&#48;&#37;&#65292;&#22240;&#27492;&#28961;&#27861;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1% does not meet the participation requirements. You cannot participate in the Olympiad because your inventory slot exceeds 80%.
	 */
	public static final SystemMessageId C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT;
	
	/**
	 * ID: 1692<br>
	 * Message: $c1 ͎Qɍ܂BNXTuNXɕύX߁AQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#19981;&#31526;&#21512;&#21443;&#21152;&#26781;&#20214;&#12290;&#24050;&#23559;&#32887;&#26989;&#35722;&#26356;&#28858;&#21103;&#32887;&#26989;&#65292;&#22240;&#27492;&#28961;&#27861;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1% does not meet the participation requirements. You cannot participate in the Olympiad because you have changed to your sub-class.
	 */
	public static final SystemMessageId C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_WHILE_CHANGED_TO_SUB_CLASS;
	
	/**
	 * ID: 1693<br>
	 * Message: ҋ@҃Xgɓo^Ԃł͋Zϗł܂B<br>
	 * Message: &#22312;&#24050;&#30331;&#35352;&#26044;&#21443;&#36093;&#32773;&#21517;&#21934;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#35264;&#30475;&#27604;&#36093;&#12290;<br>
	 * Message: You may not observe a Grand Olympiad Games match while you are on the waiting list.
	 */
	public static final SystemMessageId WHILE_YOU_ARE_ON_THE_WAITING_LIST_YOU_ARE_NOT_ALLOWED_TO_WATCH_THE_GAME;
	
	/**
	 * ID: 1694<br>
	 * Message: U펞Am[uX̌̂ݎgpł܂B<br>
	 * Message: &#22312;&#25915;&#22478;&#25136;&#26178;&#65292;&#20677;&#38480;&#36020;&#26063;&#34880;&#30431;&#30431;&#20027;&#20351;&#29992;&#12290;<br>
	 * Message: Only a clan leader that is a Noblesse can view the Siege War Status window during a siege war.
	 */
	public static final SystemMessageId ONLY_NOBLESSE_LEADER_CAN_VIEW_SIEGE_STATUS_WINDOW;
	
	/**
	 * ID: 1695<br>
	 * Message: U펞̂ݎgpł܂B<br>
	 * Message: &#21482;&#26377;&#22312;&#25915;&#22478;&#25136;&#26178;&#25165;&#33021;&#20351;&#29992;&#12290;<br>
	 * Message: You can only use that during a Siege War!
	 */
	public static final SystemMessageId ONLY_DURING_SIEGE;
	
	/**
	 * ID: 1696<br>
	 * Message: vCԂ $s1ԂłB<br>
	 * Message: &#24744;&#30340;&#36938;&#25138;&#36914;&#34892;&#26178;&#38291;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your accumulated play time is $s1.
	 */
	public static final SystemMessageId ACCUMULATED_PLAY_TIME_IS_S1;
	
	/**
	 * ID: 1697<br>
	 * Message: Q[ vCԂuJxv𒴂߁AQ[l50ɒቺ܂BN̂߂ɍOAEgAxeƂƂɁAK؂ȃXgb`sA׊wƂ̃oXƂĂB<br>
	 * Message: &#24744;&#24050;&#36914;&#20837;&#30130;&#21214;&#24230;&#36938;&#25138;&#26178;&#27573;&#65292;&#22240;&#27492;&#36938;&#25138;&#22577;&#37228;&#23559;&#28187;&#23569;&#33267;&#27491;&#24120;&#20540;&#30340;&#53;&#48;&#37;&#12290;&#28858;&#20102;&#24744;&#30340;&#20581;&#24247;&#33879;&#24819;&#35531;&#30433;&#36895;&#30331;&#20986;&#65292;&#25645;&#37197;&#36969;&#30070;&#30340;&#36939;&#21205;&#27463;&#24687;&#19968;&#19979;&#65292;&#20006;&#21512;&#29702;&#22320;&#23433;&#25490;&#26085;&#24120;&#29983;&#27963;&#21450;&#23416;&#32722;&#26178;&#38291;&#12290;<br>
	 * Message: Your accumulated play time has reached Fatigue level, so you will receive experience or item drops at only 50 percent [...]
	 */
	public static final SystemMessageId ACCUMULATED_PLAY_TIME_WARNING1;
	
	/**
	 * ID: 1698<br>
	 * Message: NQ鋰̂Q[Ԃɓ܂BN̂߂ɍOAEgAxeƂ肭BOAEgȂꍇANQăQ[0ɒቺAOAEg̗ݐώԂ5ԂɒBȂƌɂ͖߂܂B<br>
	 * Message: &#24744;&#24050;&#36914;&#20837;&#19981;&#20581;&#24247;&#30340;&#36938;&#25138;&#26178;&#27573;&#65292;&#28858;&#20102;&#24744;&#30340;&#20581;&#24247;&#33879;&#24819;&#35531;&#30433;&#36895;&#30331;&#20986;&#20006;&#27463;&#24687;&#19968;&#19979;&#12290;&#33509;&#19981;&#30331;&#20986;&#23559;&#21487;&#33021;&#24433;&#38911;&#24744;&#30340;&#20581;&#24247;&#65292;&#22240;&#27492;&#24744;&#30340;&#32147;&#39511;&#20540;&#23559;&#28187;&#23569;&#33267;&#48;&#37;&#12290;&#30070;&#24744;&#30340;&#30331;&#20986;&#26178;&#38291;&#36229;&#36942;&#53;&#23567;&#26178;&#30340;&#35441;&#65292;&#23559;&#26371;&#24674;&#24489;&#27491;&#24120;&#12290;<br>
	 * Message: Your accumulated play time has reached Ill-health level, so you will no longer gain experience or item drops. [...}
	 */
	public static final SystemMessageId ACCUMULATED_PLAY_TIME_WARNING2;
	
	/**
	 * ID: 1699<br>
	 * Message: p[eB o[Ǖł܂B<br>
	 * Message: &#19981;&#33021;&#24375;&#21046;&#39493;&#38626;&#38538;&#20237;&#25104;&#21729;&#12290;<br>
	 * Message: You cannot dismiss a party member by force.
	 */
	public static final SystemMessageId CANNOT_DISMISS_PARTY_MEMBER;
	
	/**
	 * ID: 1700<br>
	 * Message: ybgяbpXsbg Vbg܂B<br>
	 * Message: &#23541;&#29289;&#12289;&#21484;&#21914;&#20351;&#39764;&#23560;&#29992;&#30340;&#39764;&#38728;&#24392;&#19981;&#36275;&#12290;<br>
	 * Message: You don't have enough spiritshots needed for a pet/servitor.
	 */
	public static final SystemMessageId NOT_ENOUGH_SPIRITHOTS_FOR_PET;
	
	/**
	 * ID: 1701<br>
	 * Message: ybgяbp\E Vbg܂B<br>
	 * Message: &#23541;&#29289;&#12289;&#21484;&#21914;&#20351;&#39764;&#23560;&#29992;&#30340;&#38728;&#39746;&#24392;&#19981;&#36275;&#12290;<br>
	 * Message: You don't have enough soulshots needed for a pet/servitor.
	 */
	public static final SystemMessageId NOT_ENOUGH_SOULSHOTS_FOR_PET;
	
	/**
	 * ID: 1702<br>
	 * Message: قǃ`FbN[U[$s1BOTgp҂Ɣ܂B<br>
	 * Message: &#21083;&#25165;&#21463;&#27298;&#26597;&#30340;&#35282;&#33394;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#21028;&#26126;&#28858;&#66;&#79;&#84;&#29992;&#25142;&#12290;<br>
	 * Message: $s1 is using a third party program.
	 */
	public static final SystemMessageId S1_USING_THIRD_PARTY_PROGRAM;
	
	/**
	 * ID: 1703<br>
	 * Message: قǃ`FbN[U[BOTgp҂ł͂Ȃ悤łB<br>
	 * Message: &#21083;&#25165;&#21463;&#27298;&#26597;&#30340;&#35282;&#33394;&#22909;&#20687;&#19981;&#26159;&#66;&#79;&#84;&#29992;&#25142;&#12290;<br>
	 * Message: The previous investigated user is not using a third party program
	 */
	public static final SystemMessageId NOT_USING_THIRD_PARTY_PROGRAM;
	
	/**
	 * ID: 1704<br>
	 * Message: lH[AXݒEBhEĂsĂB<br>
	 * Message: &#35531;&#38364;&#38281;&#20491;&#20154;&#24037;&#25151;&#20197;&#21450;&#21830;&#24215;&#30340;&#35373;&#23450;&#35222;&#31383;&#24460;&#20877;&#22039;&#35430;&#36914;&#34892;&#12290;<br>
	 * Message: Please close the setup window for your private manufacturing store or private store, and try again.
	 */
	public static final SystemMessageId CLOSE_STORE_WINDOW_AND_TRY_AGAIN;
	
	/**
	 * ID: 1705<br>
	 * Message: lbgJtF |CglԂłB<br>
	 * Message: &#29694;&#22312;&#26159;&#27963;&#21205;&#40670;&#25976;&#29554;&#24471;&#26399;&#38291;&#12290;&#40670;&#25976;&#29554;&#24471;&#26399;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#23567;&#26178;&#12290;<br>
	 * Message: PC Bang Points acquisition period. Points acquisition period left $s1 hour.
	 */
	public static final SystemMessageId PCPOINT_ACQUISITION_PERIOD;
	
	/**
	 * ID: 1706<br>
	 * Message: lbgJtF |CgLԂłB<br>
	 * Message: &#29694;&#22312;&#26159;&#27963;&#21205;&#40670;&#25976;&#20351;&#29992;&#26399;&#38291;&#12290;&#40670;&#25976;&#20351;&#29992;&#26399;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#23567;&#26178;&#12290;<br>
	 * Message: PC Bang Points use period. Points acquisition period left $s1 hour.
	 */
	public static final SystemMessageId PCPOINT_USE_PERIOD;
	
	/**
	 * ID: 1707<br>
	 * Message: lbgJtF |Cg $s1|Cgl܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#30340;&#27963;&#21205;&#40670;&#25976;&#12290;<br>
	 * Message: You acquired $s1 PC Bang Point.
	 */
	public static final SystemMessageId ACQUIRED_S1_PCPOINT;
	
	/**
	 * ID: 1708<br>
	 * Message: _u |CgIlbgJtF |Cg $s1|Cgl܂B<br>
	 * Message: &#38617;&#20493;&#40670;&#25976;&#65281;&#29554;&#24471;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#30340;&#27963;&#21205;&#40670;&#25976;&#12290;<br>
	 * Message: Double points! You acquired $s1 PC Bang Point.
	 */
	public static final SystemMessageId ACQUIRED_S1_PCPOINT_DOUBLE;
	
	/**
	 * ID: 1709<br>
	 * Message: $s1|Cggp܂B<br>
	 * Message: &#20351;&#29992;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#30340;&#40670;&#25976;&#12290;<br>
	 * Message: You are using $s1 point.
	 */
	public static final SystemMessageId USING_S1_PCPOINT;
	
	/**
	 * ID: 1710<br>
	 * Message: |Cg܂B<br>
	 * Message: &#32047;&#31309;&#30340;&#40670;&#25976;&#19981;&#36275;&#12290;<br>
	 * Message: You are short of accumulated points.
	 */
	public static final SystemMessageId SHORT_OF_ACCUMULATED_POINTS;
	
	/**
	 * ID: 1711<br>
	 * Message: lbgJtF |CgL؂Ă܂B<br>
	 * Message: &#27963;&#21205;&#40670;&#25976;&#20351;&#29992;&#26399;&#38291;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: PC Bang Points use period has expired.
	 */
	public static final SystemMessageId PCPOINT_USE_PERIOD_EXPIRED;
	
	/**
	 * ID: 1712<br>
	 * Message: lbgJtF |CglԂI܂B<br>
	 * Message: &#27963;&#21205;&#40670;&#25976;&#20351;&#29992;&#26399;&#38291;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The PC Bang Points accumulation period has expired.
	 */
	public static final SystemMessageId PCPOINT_ACCUMULATION_PERIOD_EXPIRED;
	
	/**
	 * ID: 1713<br>
	 * Message: ҋ@ҐȂ̂ŁAZJnɒxꂪoꍇ܂B<br>
	 * Message: &#30001;&#26044;&#21443;&#36093;&#32773;&#20154;&#25976;&#19981;&#36275;&#65292;&#27604;&#36093;&#26178;&#38291;&#21487;&#33021;&#26371;&#24310;&#36978;&#12290;<br>
	 * Message: The games may be delayed due to an insufficient number of players waiting.
	 */
	public static final SystemMessageId GAMES_DELAYED;
	
	/**
	 * ID: 1714<br>
	 * Message: ݒnF $s1A$s2A$s3 (V`bcKg̑t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#20462;&#21152;&#29305;&#22478;&#37806;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (Near the Town of Schuttgart)
	 */
	public static final SystemMessageId LOC_SCHUTTGART_S1_S2_S3;
	
	/**
	 * ID: 1715<br>
	 * Message: s[X][\n- PvPłȂGAłB<br>
	 * Message: &#23433;&#20840;&#21312;&#22495;&#92;&#110;&#45;&#32;&#22312;&#27492;&#22320;&#21312;&#28961;&#27861;&#36914;&#34892;&#80;&#118;&#80;&#12290;<br>
	 * Message: This is a Peaceful Zone - PvP is not allowed in this area.
	 */
	public static final SystemMessageId PEACEFUL_ZONE;
	
	/**
	 * ID: 1716<br>
	 * Message: ُԃGA<br>
	 * Message: &#30064;&#24120;&#29376;&#24907;&#21312;&#22495;<br>
	 * Message: Altered Zone
	 */
	public static final SystemMessageId ALTERED_ZONE;
	
	/**
	 * ID: 1717<br>
	 * Message: U][\n-U킪sĂGAłB\nS̕ɐGAłB<br>
	 * Message: &#25915;&#22478;&#25136;&#22580;&#92;&#110;&#45;&#32;&#27492;&#22320;&#21312;&#27491;&#22312;&#36914;&#34892;&#25915;&#22478;&#25136;&#12290;&#92;&#110;&#32;&#22312;&#27492;&#22320;&#21312;&#27515;&#20129;&#26178;&#65292;&#24489;&#27963;&#26371;&#36973;&#21463;&#38480;&#21046;&#12290;<br>
	 * Message: Siege War Zone - A siege is currently in progress in this area. If a character dies in this zone, their resurrection ability may be restricted.
	 */
	public static final SystemMessageId SIEGE_ZONE;
	
	/**
	 * ID: 1718<br>
	 * Message: ʃtB[h<br>
	 * Message: &#19968;&#33324;&#21312;&#22495;<br>
	 * Message: General Field
	 */
	public static final SystemMessageId GENERAL_ZONE;
	
	/**
	 * ID: 1719<br>
	 * Message: Zu TC ][\n- x AbvĂHPAMP\n񕜂ȂGAłB<br>
	 * Message: &#19971;&#20491;&#23553;&#21360;&#21312;&#22495;&#92;&#110;&#45;&#32;&#22312;&#27492;&#22320;&#21312;&#25552;&#21319;&#31561;&#32026;&#26178;&#65292;&#72;&#80;&#33287;&#77;&#80;&#92;&#110;&#23559;&#19981;&#26371;&#21463;&#21040;&#24674;&#24489;&#12290;<br>
	 * Message: Seven Signs Zone - Although a character's level may increase while in this area, HP and MP will not be regenerated.
	 */
	public static final SystemMessageId SEVENSIGNS_ZONE;
	
	/**
	 * ID: 1720<br>
	 * Message: ---<br>
	 * Message: &#45;&#45;&#45;<br>
	 * Message: ---
	 */
	public static final SystemMessageId UNKNOWN1;
	
	/**
	 * ID: 1721<br>
	 * Message: GA<br>
	 * Message: &#32027;&#29229;&#22320;&#21312;<br>
	 * Message: Combat Zone
	 */
	public static final SystemMessageId COMBAT_ZONE;
	
	/**
	 * ID: 1722<br>
	 * Message: lXAlH[ŌACe͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#24819;&#35201;&#22312;&#20491;&#20154;&#21830;&#24215;&#12289;&#20491;&#20154;&#24037;&#25151;&#25628;&#23563;&#30340;&#36947;&#20855;&#21517;&#31281;&#12290;<br>
	 * Message: Please enter the name of the item you wish to search for.
	 */
	public static final SystemMessageId ENTER_ITEM_NAME_SEARCH;
	
	/**
	 * ID: 1723<br>
	 * Message: T|[gɑ΂]Ē΍KłB<br>
	 * Message: &#24863;&#35613;&#23529;&#26680;&#35380;&#27714;&#12290;<br>
	 * Message: Please take a moment to provide feedback about the petition service.
	 */
	public static final SystemMessageId PLEASE_PROVIDE_PETITION_FEEDBACK;
	
	/**
	 * ID: 1724<br>
	 * Message: 퓬͏b߂܂B<br>
	 * Message: &#28961;&#27861;&#25910;&#22238;&#25136;&#39717;&#20013;&#30340;&#20351;&#39764;&#12290;<br>
	 * Message: A servitor whom is engaged in battle cannot be de-activated.
	 */
	public static final SystemMessageId SERVITOR_NOT_RETURN_IN_BATTLE;
	
	/**
	 * ID: 1725<br>
	 * Message: $s1̃Ch |Cgl܂B<br>
	 * Message: &#24050;&#29554;&#24471;&#29417;&#29557;&#40670;&#25976;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have earned $s1 raid point(s).
	 */
	public static final SystemMessageId EARNED_S1_RAID_POINTS;
	
	/**
	 * ID: 1726<br>
	 * Message: LԂ̂$s1܂B<br>
	 * Message: &#22240;&#26377;&#25928;&#26399;&#38291;&#32080;&#26463;&#65292;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: $s1 has disappeared because its time period has expired.
	 */
	public static final SystemMessageId S1_PERIOD_EXPIRED_DISAPPEARED;
	
	/**
	 * ID: 1727<br>
	 * Message: $s1 $s2p[eB[ [ɏ҂܂B܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36992;&#35531;&#36914;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#25151;&#38291;&#65292;&#35201;&#36914;&#20837;&#21966;&#65311;<br>
	 * Message: $c1 has invited you to a party room. Do you accept?
	 */
	public static final SystemMessageId C1_INVITED_YOU_TO_PARTY_ROOM_CONFIRM;
	
	/**
	 * ID: 1728<br>
	 * Message: 肪p[eB }b`̏҂ɉ܂łB<br>
	 * Message: &#23565;&#26041;&#26410;&#31572;&#25033;&#21152;&#20837;&#38538;&#20237;&#25151;&#38291;&#30340;&#36992;&#35531;&#12290;<br>
	 * Message: The recipient of your invitation did not accept the party matching invitation.
	 */
	public static final SystemMessageId PARTY_MATCHING_REQUEST_NO_RESPONSE;
	
	/**
	 * ID: 1729<br>
	 * Message: Ae|[gł邽߁AÃp[eBɉł܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#22312;&#20659;&#36865;&#30070;&#20013;&#65292;&#22240;&#27492;&#28961;&#27861;&#21152;&#20837;&#32879;&#21512;&#36557;&#38538;&#20237;&#12290;<br>
	 * Message: You cannot join a Command Channel while teleporting.
	 */
	public static final SystemMessageId NOT_JOIN_CHANNEL_WHILE_TELEPORTING;
	
	/**
	 * ID: 1730<br>
	 * Message: AJf~[n݂ɂ́Ãx5ȏłȂ΂Ȃ܂B<br>
	 * Message: &#33509;&#35201;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#65292;&#34880;&#30431;&#31561;&#32026;&#24517;&#38920;&#36948;&#21040;&#31561;&#32026;&#53;&#20197;&#19978;&#12290;<br>
	 * Message: To establish a Clan Academy, your clan must be Level 5 or higher.
	 */
	public static final SystemMessageId YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN_ACADEMY;
	
	/**
	 * ID: 1731<br>
	 * Message: ̂݌AJf~[n݂邱Ƃł܂B<br>
	 * Message: &#21482;&#26377;&#34880;&#30431;&#30431;&#20027;&#25165;&#33021;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: Only the leader can create a Clan Academy.
	 */
	public static final SystemMessageId ONLY_LEADER_CAN_CREATE_ACADEMY;
	
	/**
	 * ID: 1732<br>
	 * Message: AJf~[n݂ɂ̓ACeȕ؁vKvłB<br>
	 * Message: &#33509;&#35201;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#65292;&#24517;&#38920;&#20855;&#26377;&#36947;&#20855;&#12300;&#34880;&#20043;&#35657;&#12301;&#12290;<br>
	 * Message: To create a Clan Academy, a Blood Mark is needed.
	 */
	public static final SystemMessageId NEED_BLOODMARK_FOR_ACADEMY;
	
	/**
	 * ID: 1733<br>
	 * Message: AJf~[n݂ɂ̓Afi܂B<br>
	 * Message: &#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#25152;&#38656;&#30340;&#37329;&#24163;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough adena to create a Clan Academy.
	 */
	public static final SystemMessageId NEED_ADENA_FOR_ACADEMY;
	
	/**
	 * ID: 1734<br>
	 * Message: AJf~[ɉɂ́ǍɏĂ炸A2]EIĂȂx40ȉ̃LN^[łȂ΂Ȃ܂B<br>
	 * Message: &#31561;&#32026;&#52;&#48;&#20197;&#19979;&#20006;&#19988;&#23578;&#26410;&#23436;&#25104;&#20108;&#27425;&#36681;&#32887;&#30340;&#28961;&#34880;&#30431;&#35282;&#33394;&#25165;&#33021;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: To join a Clan Academy, characters must be Level 40 or below, not belong another clan and not yet completed their 2nd class transfer.
	 */
	public static final SystemMessageId ACADEMY_REQUIREMENTS;
	
	/**
	 * ID: 1735<br>
	 * Message: $s1 ͌AJf~[̉ɍ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#31526;&#21512;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#30340;&#26781;&#20214;&#12290;<br>
	 * Message: $s1 does not meet the requirements to join a Clan Academy.
	 */
	public static final SystemMessageId S1_DOESNOT_MEET_REQUIREMENTS_TO_JOIN_ACADEMY;
	
	/**
	 * ID: 1736<br>
	 * Message: AJf~[̐lɒB߁AAJf~[̉󂯕tł܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#38498;&#30340;&#25307;&#29983;&#20154;&#25976;&#24050;&#28415;&#65292;&#22240;&#27492;&#28961;&#27861;&#20877;&#25509;&#21463;&#26032;&#23416;&#21729;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: The Clan Academy has reached its maximum enrollment.
	 */
	public static final SystemMessageId ACADEMY_MAXIMUM;
	
	/**
	 * ID: 1737<br>
	 * Message: ݏĂ錌̌AJf~[͊J݂Ă܂BAJf~[J݂ł܂B<br>
	 * Message: &#30446;&#21069;&#38584;&#23660;&#30340;&#34880;&#30431;&#23578;&#26410;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#65292;&#22240;&#27492;&#21487;&#20197;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: Your clan has not established a Clan Academy but is eligible to do so.
	 */
	public static final SystemMessageId CLAN_CAN_CREATE_ACADEMY;
	
	/**
	 * ID: 1738<br>
	 * Message: ݏĂ錌̌AJf~[͂łɊJ݂Ă܂B<br>
	 * Message: &#30446;&#21069;&#38584;&#23660;&#30340;&#34880;&#30431;&#24050;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: Your clan has already established a Clan Academy.
	 */
	public static final SystemMessageId CLAN_HAS_ALREADY_ESTABLISHED_A_CLAN_ACADEMY;
	
	/**
	 * ID: 1739<br>
	 * Message: AJf~[n݂܂B<br>
	 * Message: &#35201;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#21966;&#65311;<br>
	 * Message: Would you like to create a Clan Academy?
	 */
	public static final SystemMessageId CLAN_ACADEMY_CREATE_CONFIRM;
	
	/**
	 * ID: 1740<br>
	 * Message: AJf~[͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#34880;&#30431;&#23416;&#38498;&#21517;&#31281;&#12290;<br>
	 * Message: Please enter the name of the Clan Academy.
	 */
	public static final SystemMessageId ACADEMY_CREATE_ENTER_NAME;
	
	/**
	 * ID: 1741<br>
	 * Message: ߂łƂ܂I$s1̌AJf~[n݂܂B<br>
	 * Message: &#24685;&#21916;&#24744;&#65281;&#24050;&#21109;&#31435;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#30340;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: Congratulations! The $s1's Clan Academy has been created.
	 */
	public static final SystemMessageId THE_S1S_CLAN_ACADEMY_HAS_BEEN_CREATED;
	
	/**
	 * ID: 1742<br>
	 * Message: AJf~[U郁bZ[W$s1ɑ܂B<br>
	 * Message: &#23565;&#12300;&#36;&#115;&#49;&#12301;&#36865;&#20986;&#36992;&#35531;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#30340;&#35338;&#24687;&#12290;<br>
	 * Message: A message inviting $s1 to join the Clan Academy is being sent.
	 */
	public static final SystemMessageId ACADEMY_INVITATION_SENT_TO_S1;
	
	/**
	 * ID: 1743<br>
	 * Message: AJf~[n݂ɂ́Ax5ȏŌ傪ACeȕ؁vXX܂͈ʂ̃AfixȂ΂Ȃ܂B<br>
	 * Message: &#33509;&#35201;&#21109;&#31435;&#34880;&#30431;&#23416;&#38498;&#65292;&#24517;&#38920;&#28858;&#34880;&#30431;&#31561;&#32026;&#53;&#20197;&#19978;&#30340;&#30431;&#20027;&#65292;&#25345;&#26377;&#88;&#88;&#20491;&#34880;&#20043;&#35657;&#25110;&#25903;&#20184;&#19968;&#23450;&#25976;&#37327;&#30340;&#37329;&#24163;&#12290;<br>
	 * Message: To open a Clan Academy, the leader of a Level 5 clan or above must pay XX Proofs of Blood or a certain amount of adena.
	 */
	public static final SystemMessageId OPEN_ACADEMY_CONDITIONS;
	
	/**
	 * ID: 1744<br>
	 * Message: 肪Ȃ߁AAJf~[̊ULZ܂B<br>
	 * Message: &#22240;&#23565;&#26041;&#27794;&#26377;&#22238;&#25033;&#65292;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#30340;&#36992;&#35531;&#24050;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: There was no response to your invitation to join the Clan Academy, so the invitation has been rescinded.
	 */
	public static final SystemMessageId ACADEMY_JOIN_NO_RESPONSE;
	
	/**
	 * ID: 1745<br>
	 * Message: 肪AJf~[̊Uۂ܂B<br>
	 * Message: &#23565;&#26041;&#25298;&#32085;&#20102;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#30340;&#36992;&#35531;&#12290;<br>
	 * Message: The recipient of your invitation to join the Clan Academy has declined.
	 */
	public static final SystemMessageId ACADEMY_JOIN_DECLINE;
	
	/**
	 * ID: 1746<br>
	 * Message: łɌAJf~[ɉĂ܂B<br>
	 * Message: &#24050;&#32147;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#12290;<br>
	 * Message: You have already joined a Clan Academy.
	 */
	public static final SystemMessageId ALREADY_JOINED_ACADEMY;
	
	/**
	 * ID: 1747<br>
	 * Message: $s1$s2̌AJf~[̊UĂ܂B҂ɉ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#34880;&#30431;&#30340;&#34880;&#30431;&#23416;&#38498;&#65292;&#24744;&#39000;&#24847;&#21152;&#20837;&#21966;&#65311;<br>
	 * Message: $s1 has sent you an invitation to join the Clan Academy belonging to the $s2 clan. Do you accept?
	 */
	public static final SystemMessageId JOIN_ACADEMY_REQUEST_BY_S1_FOR_CLAN_S2;
	
	/**
	 * ID: 1748<br>
	 * Message: AJf~[$s12]Eɐl$s2|Cgl܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#21729;&#12300;&#36;&#115;&#49;&#12301;&#23436;&#25104;&#20108;&#27425;&#36681;&#32887;&#65292;&#22240;&#27492;&#29554;&#24471;&#20102;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#50;&#12301;&#40670;&#12290;<br>
	 * Message: Clan Academy member $s1 has successfully completed the 2nd class transfer and obtained $s2 Clan Reputation points.
	 */
	public static final SystemMessageId CLAN_MEMBER_GRADUATED_FROM_ACADEMY;
	
	/**
	 * ID: 1749<br>
	 * Message: ߂łƂ܂IAJf~[𑲋ƂAEނ܂BƎ҂̓yieB[ȂŐɌƂđł܂B<br>
	 * Message: &#24685;&#21916;&#24744;&#65281;&#23559;&#24478;&#34880;&#30431;&#23416;&#38498;&#30050;&#26989;&#20006;&#33067;&#38626;&#34880;&#30431;&#12290;&#30050;&#26989;&#29983;&#21487;&#19981;&#21463;&#38626;&#38283;&#34880;&#30431;&#49;&#26085;&#20839;&#28961;&#27861;&#21152;&#20837;&#30340;&#35215;&#21063;&#38480;&#21046;&#65292;&#21487;&#39340;&#19978;&#27491;&#24335;&#21152;&#20837;&#28858;&#34880;&#30431;&#25104;&#21729;&#12290;<br>
	 * Message: Congratulations! You will now graduate from the Clan Academy and leave your current clan. As a graduate of the academy, you can immediately join a clan as a regular member without being subject to any penalties.
	 */
	public static final SystemMessageId ACADEMY_MEMBERSHIP_TERMINATED;
	
	/**
	 * ID: 1750<br>
	 * Message: $c1 ͎Qɍ܂B$s2̏L҂̓IsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#19981;&#31526;&#21512;&#21443;&#21152;&#26781;&#20214;&#12290;&#25345;&#26377;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20154;&#28961;&#27861;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1% does not meet the participation requirements. The owner of $s2 cannot participate in the Olympiad.
	 */
	public static final SystemMessageId C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2;
	
	/**
	 * ID: 1751<br>
	 * Message: Oh }X^[LOACe^܂B<br>
	 * Message: &#24478;&#23447;&#24107;&#37027;&#35041;&#29554;&#24471;&#20102;&#32000;&#24565;&#21697;&#12290;<br>
	 * Message: The Grand Master has given you a commemorative item.
	 */
	public static final SystemMessageId GRAND_MASTER_COMMEMORATIVE_ITEM;
	
	/**
	 * ID: 1752<br>
	 * Message: AJf~[Ǝ҂ƂĉAl$s1|Cg𓾂܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#38498;&#30050;&#26989;&#29983;&#27491;&#24335;&#21152;&#20837;&#28858;&#34880;&#30431;&#25104;&#21729;&#65292;&#22240;&#27492;&#29554;&#24471;&#20102;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: Since the clan has received a graduate of the Clan Academy, it has earned $s1 points towards its reputation score.
	 */
	public static final SystemMessageId MEMBER_GRADUATED_EARNED_S1_REPU;
	
	/**
	 * ID: 1753<br>
	 * Message: AJf~[ɂ͌傪ݒ肵ɂY͗^܂B<br>
	 * Message: &#22240;&#34880;&#30431;&#30431;&#20027;&#25152;&#35330;&#19979;&#30340;&#27402;&#38480;&#65292;&#19981;&#33021;&#36070;&#20104;&#35442;&#27402;&#38480;&#32102;&#34880;&#30431;&#23416;&#21729;&#12290;<br>
	 * Message: The clan leader has decreed that that particular privilege cannot be granted to a Clan Academy member.
	 */
	public static final SystemMessageId CANT_TRANSFER_PRIVILEGE_TO_ACADEMY_MEMBER;
	
	/**
	 * ID: 1754<br>
	 * Message: AJf~[ɂ͊Y^܂B<br>
	 * Message: &#19981;&#36070;&#20104;&#23416;&#21729;&#27492;&#38917;&#27402;&#38480;&#12290;<br>
	 * Message: That privilege cannot be granted to a Clan Academy member.
	 */
	public static final SystemMessageId RIGHT_CANT_TRANSFERRED_TO_ACADEMY_MEMBER;
	
	/**
	 * ID: 1755<br>
	 * Message: $s1̌PƂ$s2w肵܂B<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#34987;&#25351;&#23450;&#28858;&#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#23416;&#21729;&#12290;<br>
	 * Message: $s2 has been designated as the apprentice of clan member $s1.
	 */
	public static final SystemMessageId S2_HAS_BEEN_DESIGNATED_AS_APPRENTICE_OF_CLAN_MEMBER_S1;
	
	/**
	 * ID: 1756<br>
	 * Message: AJf~[P$s1ڑ܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#38498;&#30340;&#23416;&#21729;&#12300;&#36;&#115;&#49;&#12301;&#24050;&#36899;&#32218;&#12290;<br>
	 * Message: Your apprentice, $s1, has logged in.
	 */
	public static final SystemMessageId YOUR_APPRENTICE_S1_HAS_LOGGED_IN;
	
	/**
	 * ID: 1757<br>
	 * Message: AJf~[P$c1ڑ𒆒f܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#38498;&#30340;&#23416;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#24050;&#38626;&#32218;&#12290;<br>
	 * Message: Your apprentice, $c1, has logged out.
	 */
	public static final SystemMessageId YOUR_APPRENTICE_C1_HAS_LOGGED_OUT;
	
	/**
	 * ID: 1758<br>
	 * Message: AJf~[㌩l$c1ڑ܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#38498;&#30340;&#30435;&#35703;&#20154;&#12300;&#36;&#99;&#49;&#12301;&#24050;&#36899;&#32218;&#12290;<br>
	 * Message: Your sponsor, $c1, has logged in.
	 */
	public static final SystemMessageId YOUR_SPONSOR_C1_HAS_LOGGED_IN;
	
	/**
	 * ID: 1759<br>
	 * Message: AJf~[㌩l$c1ڑ𒆒f܂B<br>
	 * Message: &#34880;&#30431;&#23416;&#38498;&#30340;&#30435;&#35703;&#20154;&#12300;&#36;&#99;&#49;&#12301;&#24050;&#38626;&#32218;&#12290;<br>
	 * Message: Your sponsor, $c1, has logged out.
	 */
	public static final SystemMessageId YOUR_SPONSOR_C1_HAS_LOGGED_OUT;
	
	/**
	 * ID: 1760<br>
	 * Message: $c1̃^Cg$s2Ɏw肳܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#31281;&#34399;&#34987;&#25351;&#23450;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Clan member $c1's name title has been changed to $2.
	 */
	public static final SystemMessageId CLAN_MEMBER_C1_TITLE_CHANGED_TO_S2;
	
	/**
	 * ID: 1761<br>
	 * Message: $c1̌NX$s2Ɏw肳܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#27402;&#38480;&#31561;&#32026;&#34987;&#25351;&#23450;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Clan member $c1's privilege level has been changed to $s2.
	 */
	public static final SystemMessageId CLAN_MEMBER_C1_PRIVILEGE_CHANGED_TO_S2;
	
	/**
	 * ID: 1762<br>
	 * Message: PC錠͂܂B<br>
	 * Message: &#27794;&#26377;&#38283;&#38500;&#23416;&#21729;&#30340;&#27402;&#38480;&#12290;<br>
	 * Message: You do not have the right to dismiss an apprentice.
	 */
	public static final SystemMessageId YOU_DO_NOT_HAVE_THE_RIGHT_TO_DISMISS_AN_APPRENTICE;
	
	/**
	 * ID: 1763<br>
	 * Message: $c1̌P$s2폜܂B<br>
	 * Message: &#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#23416;&#21729;&#12300;&#36;&#115;&#50;&#12301;&#24050;&#34987;&#38500;&#21517;&#12290;<br>
	 * Message: $s2, clan member $c1's apprentice, has been removed.
	 */
	public static final SystemMessageId S2_CLAN_MEMBER_C1_APPRENTICE_HAS_BEEN_REMOVED;
	
	/**
	 * ID: 1764<br>
	 * Message: AJf~[̂ݑłACełB<br>
	 * Message: &#21482;&#26377;&#34880;&#30431;&#23416;&#21729;&#25165;&#33021;&#20329;&#25140;&#27492;&#36947;&#20855;&#12290;<br>
	 * Message: This item can only be worn by a member of the Clan Academy.
	 */
	public static final SystemMessageId EQUIP_ONLY_FOR_ACADEMY;
	
	/**
	 * ID: 1765<br>
	 * Message: AJf~[𑲋ƂƑł܂B<br>
	 * Message: &#33509;&#24478;&#34880;&#30431;&#23416;&#38498;&#30050;&#26989;&#23601;&#28961;&#27861;&#20329;&#25140;&#12290;<br>
	 * Message: As a graduate of the Clan Academy, you can no longer wear this item.
	 */
	public static final SystemMessageId EQUIP_NOT_FOR_GRADUATES;
	
	/**
	 * ID: 1766<br>
	 * Message: $c1$s2ƂČ\𑗂܂B<br>
	 * Message: &#23565;&#12300;&#36;&#99;&#49;&#12301;&#25552;&#20986;&#21152;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#34880;&#30431;&#30340;&#36992;&#35531;&#12290;<br>
	 * Message: An application to join the clan has been sent to $c1 in $s2.
	 */
	public static final SystemMessageId CLAN_JOIN_APPLICATION_SENT_TO_C1_IN_S2;
	
	/**
	 * ID: 1767<br>
	 * Message: $c1ɌAJf~[։\𑗂܂B<br>
	 * Message: &#23565;&#12300;&#36;&#99;&#49;&#12301;&#25552;&#20986;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#30340;&#36992;&#35531;&#12290;<br>
	 * Message: An application to join the clan Academy has been sent to $c1.
	 */
	public static final SystemMessageId ACADEMY_JOIN_APPLICATION_SENT_TO_C1;
	
	/**
	 * ID: 1768<br>
	 * Message: $c1 $s2 ̌AJf~[Ƃĉ\܂B܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#34880;&#30431;&#30340;&#34880;&#30431;&#23416;&#38498;&#12290;&#35201;&#21152;&#20837;&#21966;&#65311;<br>
	 * Message: $c1 has invited you to join the Clan Academy of $s2 clan. Would you like to join?
	 */
	public static final SystemMessageId JOIN_REQUEST_BY_C1_TO_CLAN_S2_ACADEMY;
	
	/**
	 * ID: 1769<br>
	 * Message: $c1 $s2 $s3 RmcƂĉ҂𑗂܂B܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#38584;&#23660;&#26044;&#12300;&#36;&#115;&#50;&#12301;&#34880;&#30431;&#30340;&#12300;&#36;&#115;&#51;&#12301;&#39438;&#22763;&#22296;&#12290;&#35201;&#21152;&#20837;&#21966;&#65311;<br>
	 * Message: $c1 has sent you an invitation to join the $s3 Order of Knights under the $s2 clan. Would you like to join?
	 */
	public static final SystemMessageId JOIN_REQUEST_BY_C1_TO_ORDER_OF_KNIGHTS_S3_UNDER_CLAN_S2;
	
	/**
	 * ID: 1770<br>
	 * Message: l0|CgȉƂȂ萧󂯂܂B<br>
	 * Message: &#22240;&#34880;&#30431;&#32882;&#26395;&#38477;&#33267;&#48;&#40670;&#20197;&#19979;&#65292;&#21487;&#33021;&#26371;&#21463;&#21040;&#38480;&#21046;&#12290;<br>
	 * Message: The clan's reputation score has dropped below 0. The clan may face certain penalties as a result.
	 */
	public static final SystemMessageId CLAN_REPU_0_MAY_FACE_PENALTIES;
	
	/**
	 * ID: 1771<br>
	 * Message: x5ȏɂȂ茌l~邱Ƃł܂B<br>
	 * Message: &#34880;&#30431;&#31561;&#32026;&#36948;&#21040;&#53;&#20197;&#19978;&#65292;&#22240;&#27492;&#21487;&#20197;&#32047;&#31309;&#34880;&#30431;&#32882;&#26395;&#12290;<br>
	 * Message: Now that your clan level is above Level 5, it can accumulate clan reputation points.
	 */
	public static final SystemMessageId CLAN_CAN_ACCUMULATE_CLAN_REPUTATION_POINTS;
	
	/**
	 * ID: 1772<br>
	 * Message: UŔsǩɌl$s1|CgD܂B<br>
	 * Message: &#25105;&#26041;&#34880;&#30431;&#22312;&#25915;&#22478;&#25136;&#25136;&#25943;&#65292;&#22240;&#27492;&#34987;&#23565;&#26041;&#34880;&#30431;&#22890;&#21462;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: Since your clan was defeated in a siege, $s1 points have been deducted from your clan's reputation score and given to the opposing clan.
	 */
	public static final SystemMessageId CLAN_WAS_DEFEATED_IN_SIEGE_AND_LOST_S1_REPUTATION_POINTS;
	
	/**
	 * ID: 1773<br>
	 * Message: Uŏ̌l$s1|CgD܂B<br>
	 * Message: &#25152;&#23660;&#30340;&#34880;&#30431;&#22312;&#25915;&#22478;&#25136;&#29554;&#21213;&#65292;&#22240;&#27492;&#24478;&#23565;&#26041;&#34880;&#30431;&#34389;&#22890;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#30340;&#34880;&#30431;&#32882;&#26395;&#12290;<br>
	 * Message: Since your clan emerged victorious from the siege, $s1 points have been added to your clan's reputation score.
	 */
	public static final SystemMessageId CLAN_VICTORIOUS_IN_SIEGE_AND_GAINED_S1_REPUTATION_POINTS;
	
	/**
	 * ID: 1774<br>
	 * Message: 퓬^AWgVKɊlāAl$s1|Cgɓ܂B<br>
	 * Message: &#25105;&#26041;&#34880;&#30431;&#39318;&#29554;&#25136;&#39717;&#22411;&#26681;&#25818;&#22320;&#65292;&#22240;&#27492;&#29554;&#24471;&#20102;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: Your clan's newly acquired contested clan hall has added $s1 points to your clan's reputation score.
	 */
	public static final SystemMessageId CLAN_ACQUIRED_CONTESTED_CLAN_HALL_AND_S1_REPUTATION_POINTS;
	
	/**
	 * ID: 1775<br>
	 * Message: ̌$c1ł̍ՓT1ʃp[eB̈ƂĊ􂵁Al$s2|Cgɓ܂B<br>
	 * Message: &#25105;&#26041;&#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#36523;&#26044;&#40657;&#26263;&#31085;&#20856;&#31532;&#19968;&#21517;&#38538;&#20237;&#30340;&#19968;&#21729;&#34920;&#29694;&#21331;&#36234;&#65292;&#29554;&#24471;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#50;&#12301;&#40670;&#12290;<br>
	 * Message: Clan member $c1 was an active member of the highest-ranked party in the Festival of Darkness. $s2 points have been added to your clan's reputation score.
	 */
	public static final SystemMessageId CLAN_MEMBER_C1_WAS_IN_HIGHEST_RANKED_PARTY_IN_FESTIVAL_OF_DARKNESS_AND_GAINED_S2_REPUTATION;
	
	/**
	 * ID: 1776<br>
	 * Message: ̌$c1 pYƂȂ茌l$s2|Cgɓ܂B<br>
	 * Message: &#25105;&#26041;&#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#27054;&#30331;&#33521;&#38596;&#20043;&#20301;&#65292;&#22240;&#27492;&#29554;&#24471;&#20102;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#50;&#12301;&#40670;&#12290;<br>
	 * Message: Clan member $c1 was named a hero. $2s points have been added to your clan's reputation score.
	 */
	public static final SystemMessageId CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS;
	
	/**
	 * ID: 1777<br>
	 * Message: NGXg𖳎NAA$s1̌ll܂B<br>
	 * Message: &#25104;&#21151;&#30340;&#23436;&#25104;&#34880;&#30431;&#20219;&#21209;&#65292;&#22240;&#27492;&#29554;&#24471;&#20102;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: You have successfully completed a clan quest. $s1 points have been added to your clan's reputation score.
	 */
	public static final SystemMessageId CLAN_QUEST_COMPLETED_AND_S1_POINTS_GAINED;
	
	/**
	 * ID: 1778<br>
	 * Message: ̌֐퓬^AWgDǍl$s1|CgD܂B<br>
	 * Message: &#34987;&#23565;&#26041;&#34880;&#30431;&#22890;&#36208;&#20102;&#25136;&#39717;&#22411;&#26681;&#25818;&#22320;&#65292;&#22240;&#27492;&#25105;&#26041;&#34880;&#30431;&#30340;&#34880;&#30431;&#32882;&#26395;&#34987;&#22890;&#21462;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: An opposing clan has captured your clan's contested clan hall. $s1 points have been deducted from your clan's reputation score.
	 */
	public static final SystemMessageId OPPOSING_CLAN_CAPTURED_CLAN_HALL_AND_YOUR_CLAN_LOSES_S1_POINTS;
	
	/**
	 * ID: 1779<br>
	 * Message: 퓬^AWgDꌌl300|Cg܂B<br>
	 * Message: &#22240;&#34987;&#22890;&#36208;&#25136;&#39717;&#22411;&#26681;&#25818;&#22320;&#65292;&#34880;&#30431;&#32882;&#26395;&#38477;&#20302;&#20102;&#12300;&#51;&#48;&#48;&#12301;&#40670;&#12290;<br>
	 * Message: After losing the contested clan hall, 300 points have been deducted from your clan's reputation score.
	 */
	public static final SystemMessageId CLAN_LOST_CONTESTED_CLAN_HALL_AND_300_POINTS;
	
	/**
	 * ID: 1780<br>
	 * Message: 퓬^AWg𑈒Dđ̌猌l$s1|CgD܂B<br>
	 * Message: &#25152;&#23660;&#30340;&#34880;&#30431;&#25104;&#21151;&#20308;&#38936;&#25136;&#39717;&#22411;&#26681;&#25818;&#22320;&#65292;&#22240;&#27492;&#24478;&#23565;&#26041;&#34880;&#30431;&#34389;&#22890;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#30340;&#34880;&#30431;&#32882;&#26395;&#12290;<br>
	 * Message: Your clan has captured your opponent's contested clan hall. $s1 points have been deducted from your opponent's clan reputation score.
	 */
	public static final SystemMessageId CLAN_CAPTURED_CONTESTED_CLAN_HALL_AND_S1_POINTS_DEDUCTED_FROM_OPPONENT;
	
	/**
	 * ID: 1781<br>
	 * Message: ̌l$s1|Cg𓾂܂B<br>
	 * Message: &#29554;&#24471;&#25152;&#23660;&#34880;&#30431;&#30340;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: Your clan has added $1s points to its clan reputation score.
	 */
	public static final SystemMessageId CLAN_ADDED_S1S_POINTS_TO_REPUTATION_SCORE;
	
	/**
	 * ID: 1782<br>
	 * Message: ̌$c1Eꂽ̂ŁǍɖl$s2|CgD܂B<br>
	 * Message: &#25105;&#26041;&#34880;&#30431;&#25104;&#21729;&#12300;&#36;&#99;&#49;&#12301;&#34987;&#27578;&#23475;&#65292;&#22240;&#27492;&#34880;&#30431;&#32882;&#26395;&#34987;&#22890;&#21462;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#40670;&#12290;<br>
	 * Message: Your clan member $c1 was killed. $s2 points have been deducted from your clan's reputation score and added to your opponent's clan reputation score.
	 */
	public static final SystemMessageId CLAN_MEMBER_C1_WAS_KILLED_AND_S2_POINTS_DEDUCTED_FROM_REPUTATION;
	
	/**
	 * ID: 1783<br>
	 * Message: ̌̃vC[|̌l$s1|CgD܂B<br>
	 * Message: &#27578;&#27515;&#20102;&#23565;&#26041;&#34880;&#30431;&#25104;&#21729;&#65292;&#22240;&#27492;&#22890;&#24471;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: For killing an opposing clan member, $s1 points have been deducted from your opponents' clan reputation score.
	 */
	public static final SystemMessageId FOR_KILLING_OPPOSING_MEMBER_S1_POINTS_WERE_DEDUCTED_FROM_OPPONENTS;
	
	/**
	 * ID: 1784<br>
	 * Message: ɎšɌl$s1|CgD܂B<br>
	 * Message: &#34880;&#30431;&#23432;&#22478;&#22833;&#25943;&#65292;&#22240;&#27492;&#34987;&#23565;&#26041;&#34880;&#30431;&#22890;&#36208;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#34880;&#30431;&#32882;&#26395;&#12290;<br>
	 * Message: Your clan has failed to defend the castle. $s1 points have been deducted from your clan's reputation score and added to your opponents'.
	 */
	public static final SystemMessageId YOUR_CLAN_FAILED_TO_DEFEND_CASTLE_AND_S1_POINTS_LOST_AND_ADDED_TO_OPPONENT;
	
	/**
	 * ID: 1785<br>
	 * Message: ۗLĂ邪$s1|Cg܂B<br>
	 * Message: &#25105;&#26041;&#34880;&#30431;&#25152;&#25793;&#26377;&#30340;&#22478;&#22561;&#35722;&#28858;&#21021;&#22987;&#21270;&#65292;&#22240;&#27492;&#38477;&#20302;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: The clan you belong to has been initialized. $s1 points have been deducted from your clan reputation score.
	 */
	public static final SystemMessageId YOUR_CLAN_HAS_BEEN_INITIALIZED_AND_S1_POINTS_LOST;
	
	/**
	 * ID: 1786<br>
	 * Message: Ă錌Ɏsl$s1|Cg܂B<br>
	 * Message: &#34880;&#30431;&#23432;&#22478;&#22833;&#25943;&#65292;&#34880;&#30431;&#32882;&#26395;&#38477;&#20302;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: Your clan has failed to defend the castle. $s1 points have been deducted from your clan's reputation score.
	 */
	public static final SystemMessageId YOUR_CLAN_FAILED_TO_DEFEND_CASTLE_AND_S1_POINTS_LOST;
	
	/**
	 * ID: 1787<br>
	 * Message: l$s1|CgՂ܂B<br>
	 * Message: &#20351;&#29992;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#40670;&#12290;<br>
	 * Message: $s1 points have been deducted from the clan's reputation score.
	 */
	public static final SystemMessageId S1_DEDUCTED_FROM_CLAN_REP;
	
	/**
	 * ID: 1788<br>
	 * Message: XL$s1ɓ܂B<br>
	 * Message: &#32722;&#24471;&#34880;&#30431;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: The clan skill $s1 has been added.
	 */
	public static final SystemMessageId CLAN_SKILL_S1_ADDED;
	
	/**
	 * ID: 1789<br>
	 * Message: l0ȉɂȂ̂ŁAXLANeBu܂B<br>
	 * Message: &#34880;&#30431;&#32882;&#26395;&#38477;&#33267;&#48;&#20197;&#19979;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#34880;&#30431;&#25216;&#33021;&#12290;<br>
	 * Message: Since the Clan Reputation Score has dropped to 0 or lower, your clan skill(s) will be de-activated.
	 */
	public static final SystemMessageId REPUTATION_POINTS_0_OR_LOWER_CLAN_SKILLS_DEACTIVATED;
	
	/**
	 * ID: 1790<br>
	 * Message: ɖȂ߁Ãx Abv͂ł܂B<br>
	 * Message: &#26781;&#20214;&#19981;&#36275;&#65292;&#28961;&#27861;&#25552;&#21319;&#34880;&#30431;&#31561;&#32026;&#12290;<br>
	 * Message: The conditions necessary to increase the clan's level have not been met.
	 */
	public static final SystemMessageId FAILED_TO_INCREASE_CLAN_LEVEL;
	
	/**
	 * ID: 1791<br>
	 * Message: ɖȂ߁APʕ̑n݂ł܂B<br>
	 * Message: &#22240;&#26781;&#20214;&#19981;&#31526;&#65292;&#28961;&#27861;&#21109;&#31435;&#29544;&#31435;&#37096;&#38538;&#12290;<br>
	 * Message: The conditions necessary to create a military unit have not been met.
	 */
	public static final SystemMessageId YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_MILITARY_UNIT;
	
	/**
	 * ID: 1792<br>
	 * Message: n݂Rmc̊Ǘ҂w肵ĂB<br>
	 * Message: &#35531;&#25351;&#23450;&#29575;&#38936;&#21363;&#23559;&#21109;&#31435;&#30340;&#39438;&#22763;&#22296;&#22296;&#38263;&#12290;<br>
	 * Message: Please assign a manager for your new Order of Knights.
	 */
	public static final SystemMessageId ASSIGN_MANAGER_FOR_ORDER_OF_KNIGHTS;
	
	/**
	 * ID: 1793<br>
	 * Message: $c1 $s2̒cɔC܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34987;&#20219;&#21629;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#22296;&#38263;&#12290;<br>
	 * Message: $c1 has been selected as the captain of $s2.
	 */
	public static final SystemMessageId C1_HAS_BEEN_SELECTED_AS_CAPTAIN_OF_S2;
	
	/**
	 * ID: 1794<br>
	 * Message: $s1Rmcn݂܂B<br>
	 * Message: &#21109;&#31435;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#39438;&#22763;&#22296;&#12290;<br>
	 * Message: The Knights of $s1 have been created.
	 */
	public static final SystemMessageId THE_KNIGHTS_OF_S1_HAVE_BEEN_CREATED;
	
	/**
	 * ID: 1795<br>
	 * Message: $s1߉qn݂܂B<br>
	 * Message: &#21109;&#31435;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#35242;&#34907;&#38538;&#12290;<br>
	 * Message: The Royal Guard of $s1 have been created.
	 */
	public static final SystemMessageId THE_ROYAL_GUARD_OF_S1_HAVE_BEEN_CREATED;
	
	/**
	 * ID: 1796<br>
	 * Message: ql̃AJEǵAsAJEgp⑼lɔQ^Q[ vCȂǂF߂ꂽ߁AꎞIɂpĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[gɒڂ₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#28041;&#23244;&#30428;&#29992;&#20182;&#20154;&#36039;&#26009;&#20358;&#21152;&#20837;&#26371;&#21729;&#65292;&#20006;&#30332;&#29694;&#20197;&#19981;&#27861;&#25163;&#27573;&#36914;&#34892;&#36938;&#25138;&#65292;&#22240;&#32780;&#36896;&#25104;&#23565;&#20182;&#20154;&#30340;&#25613;&#22833;&#65292;&#22240;&#27492;&#34389;&#26044;&#38656;&#36879;&#36942;&#26412;&#20154;&#35469;&#35657;&#20358;&#35299;&#38500;&#27492;&#29376;&#24907;&#30340;&#38542;&#27573;&#12290;&#35442;&#24773;&#27841;&#33509;&#19981;&#23660;&#23526;&#65292;&#35531;&#33267;&#26412;&#20844;&#21496;&#32178;&#31449;&#36879;&#36942;&#26412;&#20154;&#35469;&#35657;&#20358;&#20316;&#30906;&#35469;&#65292;&#23601;&#21487;&#27491;&#24120;&#20351;&#29992;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE17;
	
	/**
	 * ID: 1797<br>
	 * Message: $c1̃x$s2Ɏw肳܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#31561;&#32026;&#34987;&#25351;&#23450;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 has been promoted to $s2.
	 */
	public static final SystemMessageId C1_PROMOTED_TO_S2;
	
	/**
	 * ID: 1798<br>
	 * Message: ̌$c1 ɈϏ܂B<br>
	 * Message: &#34880;&#30431;&#30431;&#20027;&#30340;&#27402;&#38480;&#24050;&#36681;&#35731;&#32102;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: Clan lord privileges have been transferred to $c1.
	 */
	public static final SystemMessageId CLAN_LEADER_PRIVILEGES_HAVE_BEEN_TRANSFERRED_TO_C1;
	
	/**
	 * ID: 1799<br>
	 * Message: ȑOBOTgp҂`FbNłB΂炭Ă炨gB<br>
	 * Message: &#27491;&#22312;&#27298;&#26597;&#20043;&#21069;&#30340;&#66;&#79;&#84;&#29992;&#25142;&#65292;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: We are searching for BOT users. Please try again later.
	 */
	public static final SystemMessageId SEARCHING_FOR_BOT_USERS_TRY_AGAIN_LATER;
	
	/**
	 * ID: 1800<br>
	 * Message: [U[$c1 BOTgp܂B<br>
	 * Message: &#29992;&#25142;&#12300;&#36;&#99;&#49;&#12301;&#26377;&#20351;&#29992;&#66;&#79;&#84;&#30340;&#32000;&#37636;&#12290;<br>
	 * Message: User $c1 has a history of using BOT.
	 */
	public static final SystemMessageId C1_HISTORY_USING_BOT;
	
	/**
	 * ID: 1801<br>
	 * Message: ̔ł܂łB<br>
	 * Message: &#36009;&#36067;&#22833;&#25943;&#12290;<br>
	 * Message: The attempt to sell has failed.
	 */
	public static final SystemMessageId SELL_ATTEMPT_FAILED;
	
	/**
	 * ID: 1802<br>
	 * Message: Ɏs܂B<br>
	 * Message: &#20132;&#26131;&#22833;&#25943;&#12290;<br>
	 * Message: The attempt to trade has failed.
	 */
	public static final SystemMessageId TRADE_ATTEMPT_FAILED;
	
	/**
	 * ID: 1803<br>
	 * Message: ߐ؂10O͎Q\݂ł܂B<br>
	 * Message: &#24478;&#27604;&#36093;&#32080;&#26463;&#30340;&#49;&#48;&#20998;&#37912;&#21069;&#38283;&#22987;&#65292;&#28961;&#27861;&#30003;&#35531;&#27604;&#36093;&#12290;<br>
	 * Message: The request to participate in the game cannot be made starting from 10 minutes before the end of the game.
	 */
	public static final SystemMessageId GAME_REQUEST_CANNOT_BE_MADE;
	
	/**
	 * ID: 1804<br>
	 * Message: ql̃AJEǵAAAJEgȂǂ̍sׂF߂ꂽ߁A7ԁApĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#39318;&#27425;&#30332;&#29694;&#23458;&#25142;&#35430;&#22294;&#36914;&#34892;&#29694;&#37329;&#47;&#20282;&#26381;&#22120;&#47;&#33287;&#20854;&#20182;&#36938;&#25138;&#31561;&#30340;&#20132;&#26131;&#65292;&#22240;&#27492;&#24744;&#30340;&#24115;&#34399;&#34987;&#38480;&#21046;&#20351;&#29992;&#55;&#22825;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE18;
	
	/**
	 * ID: 1805<br>
	 * Message: ql̃AJEǵAAAJEgȂǂ̍sׂ2xF߂ꂽ߁A30ԁApĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#31532;&#20108;&#27425;&#30332;&#29694;&#23458;&#25142;&#35430;&#22294;&#36914;&#34892;&#29694;&#37329;&#47;&#20282;&#26381;&#22120;&#47;&#33287;&#20854;&#20182;&#36938;&#25138;&#31561;&#30340;&#20132;&#26131;&#65292;&#22240;&#27492;&#24744;&#30340;&#24115;&#34399;&#34987;&#38480;&#21046;&#20351;&#29992;&#51;&#48;&#22825;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE19;
	
	/**
	 * ID: 1806<br>
	 * Message: ql̃AJEǵAAAJEgȂǂ̍sׂ3xȏF߂ꂽ߁AłpĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#30332;&#29694;&#23458;&#25142;&#35430;&#22294;&#36914;&#34892;&#29694;&#37329;&#47;&#24115;&#34399;&#30340;&#20132;&#26131;&#19977;&#27425;&#20197;&#19978;&#65292;&#22240;&#27492;&#24744;&#30340;&#24115;&#34399;&#24050;&#38480;&#21046;&#20351;&#29992;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE20;
	
	/**
	 * ID: 1807<br>
	 * Message: ql̃AJEǵA̎F߂ꂽ߁A30ԁApĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#30332;&#29694;&#23458;&#25142;&#30906;&#23526;&#26377;&#22312;&#36914;&#34892;&#29694;&#37329;&#47;&#20282;&#26381;&#22120;&#47;&#33287;&#20854;&#20182;&#36938;&#25138;&#31561;&#30340;&#20132;&#26131;&#65292;&#22240;&#27492;&#24744;&#30340;&#24115;&#34399;&#34987;&#38480;&#21046;&#20351;&#29992;&#51;&#48;&#22825;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE21;
	
	/**
	 * ID: 1808<br>
	 * Message: ql̃AJEǵAAAJEgȂǂ̍sׂ2xF߂ꂽ߁AłpĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#30332;&#29694;&#23458;&#25142;&#30906;&#23526;&#26377;&#22312;&#36914;&#34892;&#29694;&#37329;&#47;&#20282;&#26381;&#22120;&#47;&#33287;&#20854;&#20182;&#36938;&#25138;&#31561;&#30340;&#20132;&#26131;&#20841;&#27425;&#20197;&#19978;&#65292;&#22240;&#27492;&#24744;&#30340;&#24115;&#34399;&#24050;&#38480;&#21046;&#20351;&#29992;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE22;
	
	/**
	 * ID: 1809<br>
	 * Message: ql̃AJEǵA{llmF̎葱KvłBl[WII TCgihttp://lineage2.plaync.jp/j葱sĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#26410;&#33021;&#30906;&#35469;&#23526;&#21517;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#36938;&#25138;&#26381;&#21209;&#12290;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#36879;&#36942;&#26412;&#20154;&#35469;&#35657;&#20358;&#20316;&#30906;&#35469;&#65292;&#23601;&#33021;&#27491;&#24120;&#20351;&#29992;&#36938;&#25138;&#26381;&#21209;&#12290;&#22312;&#36914;&#34892;&#26412;&#20154;&#35469;&#35657;&#30340;&#36942;&#31243;&#30070;&#20013;&#65292;&#33509;&#26377;&#38656;&#35201;&#26597;&#35426;&#30340;&#20107;&#38917;&#65292;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#26597;&#35426;&#12290;<br>
	 * Message: Your account must be verified. For information on verification procedures, please visit the PlayNC website (http://us.ncsoft.com/support/).
	 */
	public static final SystemMessageId ACCOUNT_MUST_VERIFIED;
	
	/**
	 * ID: 1810<br>
	 * Message: ҋۏԂɂȂ܂B<br>
	 * Message: &#23559;&#35373;&#23450;&#28858;&#25298;&#32085;&#36992;&#35531;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: The refuse invitation state has been activated.
	 */
	public static final SystemMessageId REFUSE_INVITATION_ACTIVATED;
	
	/**
	 * ID: 1812<br>
	 * Message: ݁AҋۏԂȂ̂ŏ҂ł܂B<br>
	 * Message: &#30446;&#21069;&#34389;&#26044;&#25298;&#32085;&#36992;&#35531;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#36992;&#35531;&#12290;<br>
	 * Message: Since the refuse invitation state is currently activated, no invitation can be made
	 */
	public static final SystemMessageId REFUSE_INVITATION_CURRENTLY_ACTIVE;
	
	/**
	 * ID: 1813<br>
	 * Message: $s1̎gp\Ԃ͎c$s2ԂłB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#37034;&#24801;&#20043;&#21147;&#23578;&#23384;&#12300;&#36;&#115;&#50;&#12301;&#23567;&#26178;&#12290;<br>
	 * Message: $s1 has $s2 hour(s) of usage time remaining.
	 */
	public static final SystemMessageId THERE_IS_S1_HOUR_AND_S2_MINUTE_LEFT_OF_THE_FIXED_USAGE_TIME;
	
	/**
	 * ID: 1814<br>
	 * Message: $s1̎gp\Ԃ͎c$s2łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#37034;&#24801;&#20043;&#21147;&#20677;&#23384;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12290;<br>
	 * Message: $s1 has $s2 minute(s) of usage time remaining.
	 */
	public static final SystemMessageId S2_MINUTE_OF_USAGE_TIME_ARE_LEFT_FOR_S1;
	
	/**
	 * ID: 1815<br>
	 * Message: $s1GA$s2܂B<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#26044;&#12300;&#36;&#115;&#49;&#12301;&#22320;&#21312;&#38477;&#33256;&#20102;&#12290;<br>
	 * Message: $s2 was dropped in the $s1 region.
	 */
	public static final SystemMessageId S2_WAS_DROPPED_IN_THE_S1_REGION;
	
	/**
	 * ID: 1816<br>
	 * Message: $s1GA$s2̏L҂܂B<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#20043;&#20027;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#22320;&#21312;&#29694;&#36523;&#20102;&#12290;<br>
	 * Message: The owner of $s2 has appeared in the $s1 region.
	 */
	public static final SystemMessageId THE_OWNER_OF_S2_HAS_APPEARED_IN_THE_S1_REGION;
	
	/**
	 * ID: 1817<br>
	 * Message: $s1GA$s2̏L҂OC܂B<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#20043;&#20027;&#24050;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#22320;&#21312;&#30331;&#20837;&#12290;<br>
	 * Message: $s2's owner has logged into the $s1 region.
	 */
	public static final SystemMessageId S2_OWNER_HAS_LOGGED_INTO_THE_S1_REGION;
	
	/**
	 * ID: 1818<br>
	 * Message: $s1ł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#28040;&#28357;&#12290;<br>
	 * Message: $s1 has disappeared.
	 */
	public static final SystemMessageId S1_HAS_DISAPPEARED;
	
	/**
	 * ID: 1819<br>
	 * Message: $s1GAɂ鉽҂$s2̎׈ȋCz܂B<br>
	 * Message: &#24478;&#12300;&#36;&#115;&#49;&#12301;&#22320;&#21312;&#30340;&#26576;&#20154;&#36523;&#19978;&#33021;&#24863;&#35258;&#21040;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#37034;&#24801;&#27683;&#24687;&#12290;<br>
	 * Message: An evil is pulsating from $s2 in $s1.
	 */
	public static final SystemMessageId EVIL_FROM_S2_IN_S1;
	
	/**
	 * ID: 1820<br>
	 * Message: $s1͌ݖĂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30446;&#21069;&#27785;&#30496;&#20013;&#12290;<br>
	 * Message: $s1 is currently asleep.
	 */
	public static final SystemMessageId S1_CURRENTLY_SLEEP;
	
	/**
	 * ID: 1821<br>
	 * Message: $s1GA$s2̎׈ȋCz܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#22320;&#21312;&#33021;&#24863;&#35258;&#21040;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#37034;&#24801;&#27683;&#24687;&#12290;<br>
	 * Message: $s2's evil presence is felt in $s1.
	 */
	public static final SystemMessageId S2_EVIL_PRESENCE_FELT_IN_S1;
	
	/**
	 * ID: 1822<br>
	 * Message: $s1͕󂳂Ă܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24050;&#34987;&#23553;&#21360;&#12290;<br>
	 * Message: $s1 has been sealed.
	 */
	public static final SystemMessageId S1_SEALED;
	
	/**
	 * ID: 1823<br>
	 * Message: AWgo^͒ߐ؂܂B<br>
	 * Message: &#26681;&#25818;&#22320;&#25136;&#30340;&#30331;&#35352;&#26399;&#38291;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The registration period for a clan hall war has ended.
	 */
	public static final SystemMessageId CLANHALL_WAR_REGISTRATION_PERIOD_ENDED;
	
	/**
	 * ID: 1824<br>
	 * Message: AWgɓo^܂BAWg̓ɂ鋣ZֈړAĂB<br>
	 * Message: &#26681;&#25818;&#22320;&#25136;&#30340;&#30331;&#35352;&#24050;&#23436;&#25104;&#65292;&#35531;&#31227;&#33267;&#26681;&#25818;&#22320;&#26481;&#37002;&#23559;&#36914;&#34892;&#27604;&#36093;&#30340;&#26371;&#22580;&#20839;&#65292;&#20006;&#20570;&#22909;&#36093;&#21069;&#28310;&#20633;&#12290;<br>
	 * Message: You have been registered for a clan hall war. Please move to the left side of the clan hall's arena and get ready.
	 */
	public static final SystemMessageId REGISTERED_FOR_CLANHALL_WAR;
	
	/**
	 * ID: 1825<br>
	 * Message: AWgɓo^ł܂łB̋@ɂzB<br>
	 * Message: &#26681;&#25818;&#22320;&#25136;&#30331;&#35352;&#22833;&#25943;&#65292;&#19979;&#22238;&#35531;&#22909;&#22909;&#25226;&#25569;&#27231;&#26371;&#12290;<br>
	 * Message: You have failed in your attempt to register for the clan hall war. Please try again.
	 */
	public static final SystemMessageId CLANHALL_WAR_REGISTRATION_FAILED;
	
	/**
	 * ID: 1826<br>
	 * Message: Jn܂ł$s1łBQ҂͋}ŃAWg̓ɂ鋣ZɈړĂB<br>
	 * Message: &#36938;&#25138;&#38283;&#22987;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#65292;&#35531;&#21443;&#36093;&#32773;&#30433;&#36895;&#31227;&#33267;&#26681;&#25818;&#22320;&#26481;&#37002;&#30340;&#31478;&#25216;&#22580;&#12290;<br>
	 * Message: In $s1 minute(s), the game will begin. All players must hurry and move to the left side of the clan hall's arena.
	 */
	public static final SystemMessageId CLANHALL_WAR_BEGINS_IN_S1_MINUTES;
	
	/**
	 * ID: 1827<br>
	 * Message: Jn܂ł$s1łBQ҂͋Z̒ɓĂB<br>
	 * Message: &#36938;&#25138;&#38283;&#22987;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#65292;&#35531;&#21443;&#36093;&#32773;&#36914;&#20837;&#31478;&#25216;&#22580;&#20839;&#37096;&#12290;<br>
	 * Message: In $s1 minute(s), the game will begin. All players must, please enter the arena now
	 */
	public static final SystemMessageId CLANHALL_WAR_BEGINS_IN_S1_MINUTES_ENTER_NOW;
	
	/**
	 * ID: 1828<br>
	 * Message: Jn܂ł$s1błB<br>
	 * Message: &#36938;&#25138;&#38283;&#22987;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: In $s1 seconds(s), the game will begin.
	 */
	public static final SystemMessageId CLANHALL_WAR_BEGINS_IN_S1_SECONDS;
	
	/**
	 * ID: 1829<br>
	 * Message: A̍őp[eBẑŁAVp[eB܂B<br>
	 * Message: &#32879;&#21512;&#36557;&#30340;&#25104;&#21729;&#25976;&#24050;&#36948;&#26997;&#38480;&#65292;&#22240;&#27492;&#28961;&#27861;&#21152;&#20837;&#26032;&#30340;&#38538;&#20237;&#12290;<br>
	 * Message: The Command Channel is full.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_FULL;
	
	/**
	 * ID: 1830<br>
	 * Message: $c1 p[eB [֏҂ł܂Bҋ@҃XgXVĂB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#28858;&#28961;&#27861;&#36992;&#35531;&#33267;&#38538;&#20237;&#25151;&#38291;&#30340;&#35282;&#33394;&#65292;&#35531;&#26356;&#26032;&#31561;&#24453;&#32773;&#21517;&#21934;&#12290;<br>
	 * Message: $c1 is not allowed to use the party room invite command. Please update the waiting list.
	 */
	public static final SystemMessageId C1_NOT_ALLOWED_INVITE_TO_PARTY_ROOM;
	
	/**
	 * ID: 1831<br>
	 * Message: $c1 ̓p[eB [̏ɍ܂Bҋ@҃XgXVĂB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#28858;&#19981;&#31526;&#21512;&#38538;&#20237;&#25151;&#38291;&#35373;&#23450;&#30340;&#35282;&#33394;&#65292;&#35531;&#26356;&#26032;&#31561;&#24453;&#32773;&#21517;&#21934;&#12290;<br>
	 * Message: $c1 does not meet the conditions of the party room. Please update the waiting list.
	 */
	public static final SystemMessageId C1_NOT_MEET_CONDITIONS_FOR_PARTY_ROOM;
	
	/**
	 * ID: 1832<br>
	 * Message: p[eB [ւ̓[[_[̂ݏ҂ł܂B<br>
	 * Message: &#38538;&#20237;&#25151;&#38291;&#30340;&#36992;&#35531;&#27402;&#21147;&#65292;&#20677;&#38480;&#26044;&#25151;&#38291;&#20027;&#20154;&#25165;&#33021;&#20351;&#29992;&#12290;<br>
	 * Message: Only a room leader may invite others to a party room.
	 */
	public static final SystemMessageId ONLY_ROOM_LEADER_CAN_INVITE;
	
	/**
	 * ID: 1833<br>
	 * Message: $s1ŜĂ܂B낵łB<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#49;&#12301;&#20840;&#25976;&#19999;&#26820;&#65292;&#35531;&#30906;&#35469;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: All of $s1 will be dropped. Would you like to continue?
	 */
	public static final SystemMessageId CONFIRM_DROP_ALL_OF_S1;
	
	/**
	 * ID: 1834<br>
	 * Message: p[eB [̒̂߁Aȏ㏵҂ł܂B<br>
	 * Message: &#38538;&#20237;&#25151;&#38291;&#20154;&#25976;&#24050;&#28415;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#26032;&#35282;&#33394;&#36914;&#20837;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: The party room is full. No more characters can be invitet in
	 */
	public static final SystemMessageId PARTY_ROOM_FULL;
	
	/**
	 * ID: 1835<br>
	 * Message: $s1̒̂߁AVȌ邱Ƃ͂ł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20154;&#25976;&#24050;&#28415;&#65292;&#22240;&#27492;&#28961;&#27861;&#21152;&#20837;&#26032;&#25104;&#21729;&#12290;<br>
	 * Message: $s1 is full and cannot accept additional clan members at this time.
	 */
	public static final SystemMessageId S1_CLAN_IS_FULL;
	
	/**
	 * ID: 1836<br>
	 * Message: 2]EIĂ̂ŌAJf~[̉ɍ܂B<br>
	 * Message: &#24050;&#23436;&#25104;&#20108;&#27425;&#36681;&#32887;&#65292;&#22240;&#27492;&#19981;&#31526;&#21512;&#21152;&#20837;&#34880;&#30431;&#23416;&#38498;&#30340;&#26781;&#20214;&#12290;<br>
	 * Message: You cannot join a Clan Academy because you have successfully completed your 2nd class transfer.
	 */
	public static final SystemMessageId CANNOT_JOIN_ACADEMY_AFTER_2ND_OCCUPATION;
	
	/**
	 * ID: 1837<br>
	 * Message: $c1 $s2$s3߉qւ̉߂Ă܂B܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36992;&#35531;&#24744;&#21152;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#34880;&#30431;&#30340;&#12300;&#36;&#115;&#51;&#12301;&#35242;&#34907;&#38538;&#12290;&#35201;&#21152;&#20837;&#21966;&#65311;<br>
	 * Message: $c1 has sent you an invitation to join the $s3 Royal Guard under the $s2 clan. Would you like to join?
	 */
	public static final SystemMessageId C1_SENT_INVITATION_TO_ROYAL_GUARD_S3_OF_CLAN_S2;
	
	/**
	 * ID: 1838<br>
	 * Message: 1. N[|̓LN^[1̂ݎgpł܂B<br>
	 * Message: &#49;&#46;&#27599;&#19968;&#20491;&#35282;&#33394;&#20677;&#38480;&#20351;&#29992;&#19968;&#27425;&#31150;&#21048;&#12290;<br>
	 * Message: 1. The coupon an be used once per character.
	 */
	public static final SystemMessageId COUPON_ONCE_PER_CHARACTER;
	
	/**
	 * ID: 1839<br>
	 * Message: 2. gpς݂̃VAԍ͍Ăюgpł܂B<br>
	 * Message: &#50;&#46;&#20351;&#29992;&#36942;&#30340;&#32232;&#34399;&#28961;&#27861;&#20877;&#27425;&#20351;&#29992;&#12290;<br>
	 * Message: 2. A used serial number may not be used again.
	 */
	public static final SystemMessageId SERIAL_MAY_USED_ONCE;
	
	/**
	 * ID: 1840<br>
	 * Message: 3. VAԍ̓͂5ȏԈႦꍇA莞\n oߌɍēx݂͂ĂB<br>
	 * Message: &#51;&#46;&#32232;&#34399;&#36664;&#20837;&#37679;&#35492;&#36948;&#21040;&#53;&#27425;&#20197;&#19978;&#26178;&#65292;&#35201;&#36942;&#19968;&#27573;&#26178;&#38291;&#92;&#110;&#24460;&#25165;&#33021;&#20351;&#29992;&#12290;<br>
	 * Message: 3. If you enter the incorrect serial number more than 5 times, you may use it again after a certain amount of time passes.
	 */
	public static final SystemMessageId SERIAL_INPUT_INCORRECT;
	
	/**
	 * ID: 1841<br>
	 * Message: Q\݂̌Ȃ߁AAWg̓LZ܂B<br>
	 * Message: &#30003;&#35531;&#21443;&#21152;&#30340;&#34880;&#30431;&#25976;&#19981;&#36275;&#65292;&#22240;&#32780;&#36896;&#25104;&#26681;&#25818;&#22320;&#25136;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: The clan hall war has been cancelled. Not enough clans have registered.
	 */
	public static final SystemMessageId CLANHALL_WAR_CANCELLED;
	
	/**
	 * ID: 1842<br>
	 * Message: $c1 $s2珢\݂܂Bɉ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22312;&#12300;&#36;&#115;&#50;&#12301;&#36914;&#34892;&#21484;&#21914;&#12290;&#35201;&#25509;&#21463;&#23565;&#26041;&#30340;&#21484;&#21914;&#21966;&#65311;<br>
	 * Message: $c1 wishes to summon you from $s2. Do you accept?
	 */
	public static final SystemMessageId C1_WISHES_TO_SUMMON_YOU_FROM_S2_DO_YOU_ACCEPT;
	
	/**
	 * ID: 1843<br>
	 * Message: $c1 ͐퓬̂ߏł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22312;&#25136;&#39717;&#20013;&#65292;&#22240;&#27492;&#28961;&#27861;&#21484;&#21914;&#12290;<br>
	 * Message: $c1 is engaged in combat and cannot be summoned.
	 */
	public static final SystemMessageId C1_IS_ENGAGED_IN_COMBAT_AND_CANNOT_BE_SUMMONED;
	
	/**
	 * ID: 1844<br>
	 * Message: $c1 ͌ݎSԂ̂ߏł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30446;&#21069;&#34389;&#26044;&#27515;&#20129;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#21484;&#21914;&#12290;<br>
	 * Message: $c1 is dead at the moment and cannot be summoned.
	 */
	public static final SystemMessageId C1_IS_DEAD_AT_THE_MOMENT_AND_CANNOT_BE_SUMMONED;
	
	/**
	 * ID: 1845<br>
	 * Message: pYp͔jł܂B<br>
	 * Message: &#28961;&#27861;&#21034;&#38500;&#33521;&#38596;&#27494;&#22120;&#12290;<br>
	 * Message: Hero weapons cannot be destroyed.
	 */
	public static final SystemMessageId HERO_WEAPONS_CANT_DESTROYED;
	
	/**
	 * ID: 1846<br>
	 * Message: 蕨Ƃ̋߂Ă̂ŁAł܂B<br>
	 * Message: &#33287;&#20056;&#22352;&#29289;&#30340;&#36317;&#38626;&#22826;&#36960;&#65292;&#22240;&#27492;&#28961;&#27861;&#39438;&#20056;&#12290;<br>
	 * Message: You are too far away from the Fenrir to mount it.
	 */
	public static final SystemMessageId TOO_FAR_AWAY_FROM_FENRIR_TO_MOUNT;
	
	/**
	 * ID: 1847<br>
	 * Message: $s1̋ނ܂B<br>
	 * Message: &#37347;&#21040;&#20102;&#38263;&#24230;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#39770;&#12290;<br>
	 * Message: You caught a fish $s1 in length.
	 */
	public static final SystemMessageId CAUGHT_FISH_S1_LENGTH;
	
	/**
	 * ID: 1848<br>
	 * Message: 啨ނ̂ŃLOɓo^܂B<br>
	 * Message: &#37347;&#21040;&#20102;&#22823;&#39770;&#65292;&#22240;&#27492;&#21015;&#20837;&#25490;&#21517;&#12290;<br>
	 * Message: Because of the size of fish caught, you will be registered in the ranking
	 */
	public static final SystemMessageId REGISTERED_IN_FISH_SIZE_RANKING;
	
	/**
	 * ID: 1849<br>
	 * Message: $s1ŜĂ܂B낵łB<br>
	 * Message: &#23559;&#21034;&#38500;&#25152;&#26377;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#65292;&#35531;&#30906;&#35469;&#26159;&#21542;&#32380;&#32396;&#65311;<br>
	 * Message: All of $s1 will be discarded. Would you like to continue?
	 */
	public static final SystemMessageId CONFIRM_DISCARD_ALL_OF_S1;
	
	/**
	 * ID: 1850<br>
	 * Message: RmcɔCł܂B<br>
	 * Message: &#28961;&#27861;&#20219;&#21629;&#28858;&#39438;&#22763;&#22296;&#38263;&#12290;<br>
	 * Message: The Captain of the Order of Knights cannot be appointed.
	 */
	public static final SystemMessageId CAPTAIN_OF_ORDER_OF_KNIGHTS_CANNOT_BE_APPOINTED;
	
	/**
	 * ID: 1851<br>
	 * Message: ߉qɔCł܂B<br>
	 * Message: &#28961;&#27861;&#20219;&#21629;&#28858;&#35242;&#34907;&#38538;&#38263;&#12290;<br>
	 * Message: The Captain of the Royal Guard cannot be appointed.
	 */
	public static final SystemMessageId CAPTAIN_OF_ROYAL_GUARD_CANNOT_BE_APPOINTED;
	
	/**
	 * ID: 1852<br>
	 * Message: lȂ̂ŃXLKł܂łB<br>
	 * Message: &#34880;&#30431;&#32882;&#26395;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#23416;&#32722;&#35442;&#25216;&#33021;&#12290;<br>
	 * Message: The attempt to acquire the skill has failed because of an insufficient Clan Reputation Score.
	 */
	public static final SystemMessageId ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE;
	
	/**
	 * ID: 1853<br>
	 * Message: ނ̐ʐACe𓯎Ƀg[hł܂B<br>
	 * Message: &#21516;&#19968;&#31278;&#39006;&#30340;&#22534;&#30090;&#22411;&#36947;&#20855;&#65292;&#28961;&#27861;&#21516;&#26178;&#36914;&#34892;&#20132;&#26131;&#12290;<br>
	 * Message: Quantity items of the same type cannot be exchanged at the same time
	 */
	public static final SystemMessageId CANT_EXCHANGE_QUANTITY_ITEMS_OF_SAME_TYPE;
	
	/**
	 * ID: 1854<br>
	 * Message: ACeϊɐ܂B<br>
	 * Message: &#36947;&#20855;&#36681;&#25563;&#25104;&#21151;&#12290;<br>
	 * Message: The item was converted successfully.
	 */
	public static final SystemMessageId ITEM_CONVERTED_SUCCESSFULLY;
	
	/**
	 * ID: 1855<br>
	 * Message: ̕Ɩ̂d܂Bʂ̖O͂ĂB<br>
	 * Message: &#33287;&#20854;&#20182;&#37096;&#38538;&#30340;&#21517;&#31281;&#37325;&#35206;&#12290;&#35531;&#36664;&#20837;&#20854;&#20182;&#21517;&#31281;&#12290;<br>
	 * Message: Another military unit is already using that name. Please enter a different name.
	 */
	public static final SystemMessageId ANOTHER_MILITARY_UNIT_IS_ALREADY_USING_THAT_NAME;
	
	/**
	 * ID: 1856<br>
	 * Message: 肪$s1̏L҂ɂȂ̂ŁAIsA[hLZ܂B<br>
	 * Message: &#22240;&#23565;&#25163;&#25104;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#20043;&#20027;&#65292;&#22240;&#27492;&#21462;&#28040;&#20102;&#22887;&#26519;&#21305;&#20126;&#27604;&#36093;&#12290;<br>
	 * Message: Since your opponent is now the owner of $s1, the Olympiad has been cancelled.
	 */
	public static final SystemMessageId OPPONENT_POSSESSES_S1_OLYMPIAD_CANCELLED;
	
	/**
	 * ID: 1857<br>
	 * Message: $c1 $s2̏L҂ɂȂĂ邽߁AIsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25104;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#20043;&#20027;&#65292;&#22240;&#27492;&#28961;&#27861;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1 is the owner of $s2 and cannot participate in the Olympiad.
	 */
	public static final SystemMessageId C1_OWNS_S2_AND_CANNOT_PARTICIPATE_IN_OLYMPIAD;
	
	/**
	 * ID: 1858<br>
	 * Message: $c1 ͎SԂł邽߁AIsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#27515;&#20129;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1 is currently dead and cannot participate in the Olympiad.
	 */
	public static final SystemMessageId C1_CANNOT_PARTICIPATE_OLYMPIAD_WHILE_DEAD;
	
	/**
	 * ID: 1859<br>
	 * Message: xɈړ\Ȑʂ𒴂܂B<br>
	 * Message: &#36229;&#20986;&#20102;&#19968;&#27425;&#21487;&#25644;&#31227;&#30340;&#25976;&#37327;&#12290;<br>
	 * Message: You exceeded the quantity that can be moved at one time.
	 */
	public static final SystemMessageId EXCEEDED_QUANTITY_FOR_MOVED;
	
	/**
	 * ID: 1860<br>
	 * Message: l܂B<br>
	 * Message: &#34880;&#30431;&#32882;&#26395;&#19981;&#36275;&#12290;<br>
	 * Message: The Clan Reputation Score is too low.
	 */
	public static final SystemMessageId THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW;
	
	/**
	 * ID: 1861<br>
	 * Message: GTC폜܂B<br>
	 * Message: &#24050;&#21034;&#38500;&#34880;&#30431;&#24509;&#31456;&#12290;<br>
	 * Message: The clan's crest has been deleted.
	 */
	public static final SystemMessageId CLAN_CREST_HAS_BEEN_DELETED;
	
	/**
	 * ID: 1862<br>
	 * Message: l0ȏɂȂ̂ŌXLANeBu܂B<br>
	 * Message: &#34880;&#30431;&#32882;&#26395;&#25552;&#21319;&#33267;&#48;&#20197;&#19978;&#65292;&#22240;&#27492;&#21487;&#20197;&#20351;&#29992;&#34880;&#30431;&#25216;&#33021;&#12290;<br>
	 * Message: Clan skills will now be activated since the clan's reputation score is 0 or higher.
	 */
	public static final SystemMessageId CLAN_SKILLS_WILL_BE_ACTIVATED_SINCE_REPUTATION_IS_0_OR_HIGHER;
	
	/**
	 * ID: 1863<br>
	 * Message: $c1 ACeŵŁAl$s2܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#36092;&#36023;&#20102;&#36947;&#20855;&#65292;&#22240;&#27492;&#38477;&#20302;&#34880;&#30431;&#32882;&#26395;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: $c1 purchased a clan item, reducing the Clan Reputation by $s2 points.
	 */
	public static final SystemMessageId C1_PURCHASED_CLAN_ITEM_REDUCING_S2_REPU_POINTS;
	
	/**
	 * ID: 1864<br>
	 * Message: ybg܂͏bُԂɂȂA߂𕷂܂B<br>
	 * Message: &#23541;&#29289;&#47;&#21484;&#21914;&#20351;&#39764;&#34389;&#26044;&#30064;&#24120;&#29376;&#24907;&#65292;&#22240;&#32780;&#19981;&#32893;&#20351;&#21914;&#12290;<br>
	 * Message: Your pet/servitor is unresponsive and will not obey any orders.
	 */
	public static final SystemMessageId PET_REFUSING_ORDER;
	
	/**
	 * ID: 1865<br>
	 * Message: ybg܂͏bُԂłB<br>
	 * Message: &#23541;&#29289;&#47;&#21484;&#21914;&#20351;&#39764;&#34389;&#26044;&#30064;&#24120;&#29376;&#24907;&#12290;<br>
	 * Message: Your pet/servitor is currently in a state of distress.
	 */
	public static final SystemMessageId PET_IN_STATE_OF_DISTRESS;
	
	/**
	 * ID: 1866<br>
	 * Message: $s1MP܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#77;&#80;&#28040;&#22833;&#20102;&#12290;<br>
	 * Message: MP was reduced by $s1.
	 */
	public static final SystemMessageId MP_REDUCED_BY_S1;
	
	/**
	 * ID: 1867<br>
	 * Message: MP $s1قǂ܂B<br>
	 * Message: &#20351;&#23565;&#26041;&#30340;&#77;&#80;&#28040;&#22833;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Your opponent's MP was reduced by $s1.
	 */
	public static final SystemMessageId YOUR_OPPONENTS_MP_WAS_REDUCED_BY_S1;
	
	/**
	 * ID: 1868<br>
	 * Message: ACegp̓g[hł܂B<br>
	 * Message: &#22312;&#20351;&#29992;&#36947;&#20855;&#26178;&#65292;&#28961;&#27861;&#36914;&#34892;&#20132;&#26131;&#12290;<br>
	 * Message: You cannot exchange an item while it is being used.
	 */
	public static final SystemMessageId CANNOT_EXCHANCE_USED_ITEM;
	
	/**
	 * ID: 1869<br>
	 * Message: $c1wÃ}X^[ p[eBɁAACež^܂B<br>
	 * Message: &#23559;&#36947;&#20855;&#20998;&#37197;&#27402;&#38480;&#24050;&#36070;&#20104;&#32102;&#12300;&#36;&#99;&#49;&#12301;&#25152;&#25351;&#25582;&#30340;&#32879;&#21512;&#36557;&#20027;&#35201;&#38538;&#20237;&#12290;<br>
	 * Message: $c1 has granted the Command Channel's master party the privilege of item looting.
	 */
	public static final SystemMessageId C1_GRANTED_MASTER_PARTY_LOOTING_RIGHTS;
	
	/**
	 * ID: 1870<br>
	 * Message: łɃACež^ꂽA`l݂܂B<br>
	 * Message: &#34987;&#36070;&#20104;&#36947;&#20855;&#20998;&#37197;&#27402;&#38480;&#30340;&#25351;&#25582;&#38971;&#36947;&#24050;&#23384;&#22312;&#12290;<br>
	 * Message: A Command Channel with looting rights already exists.
	 */
	public static final SystemMessageId COMMAND_CHANNEL_WITH_LOOTING_RIGHTS_EXISTS;
	
	/**
	 * ID: 1871<br>
	 * Message: $c1珜܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#23559;&#12300;&#36;&#99;&#49;&#12301;&#24478;&#34880;&#30431;&#20013;&#38500;&#21517;&#21966;&#65311;<br>
	 * Message: Do you want to dismiss $c1 from the clan?
	 */
	public static final SystemMessageId CONFIRM_DISMISS_C1_FROM_CLAN;
	
	/**
	 * ID: 1872<br>
	 * Message: l[U[̎c莞Ԃ͂$s1 $s2łB<br>
	 * Message: &#29609;&#23478;&#20491;&#20154;&#20351;&#29992;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: You have $s1 hour(s) and $s2 minute(s) left.
	 */
	public static final SystemMessageId S1_HOURS_S2_MINUTES_LEFT;
	
	/**
	 * ID: 1873<br>
	 * Message: lbgJtFʂ̎c莞Ԃ͂$s1 $s2łB<br>
	 * Message: &#32178;&#21654;&#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#32;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: There are $s1 hour(s) and $s2 minute(s) left in the fixed use time for this PC Cafe.
	 */
	public static final SystemMessageId S1_HOURS_S2_MINUTES_LEFT_FOR_THIS_PCCAFE;
	
	/**
	 * ID: 1874<br>
	 * Message: l[U[̎c莞Ԃ͂$s1łB<br>
	 * Message: &#29609;&#23478;&#20491;&#20154;&#20351;&#29992;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: There are $s1 minute(s) left for this individual user.
	 */
	public static final SystemMessageId S1_MINUTES_LEFT_FOR_THIS_USER;
	
	/**
	 * ID: 1875<br>
	 * Message: lbgJtFʂ̎c莞Ԃ͂$s1łB<br>
	 * Message: &#32178;&#21654;&#36938;&#25138;&#20351;&#29992;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: There are $s1 minute(s) left in the fixed use time for this PC Cafe.
	 */
	public static final SystemMessageId S1_MINUTES_LEFT_FOR_THIS_PCCAFE;
	
	/**
	 * ID: 1876<br>
	 * Message: $s1Eނ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#33067;&#38626;&#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#21966;&#65311;<br>
	 * Message: Do you want to leave $s1 clan?
	 */
	public static final SystemMessageId CONFIRM_LEAVE_S1_CLAN;
	
	/**
	 * ID: 1877<br>
	 * Message: I܂ł$s1łB<br>
	 * Message: &#36938;&#25138;&#32080;&#26463;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: The game will end in $s1 minutes.
	 */
	public static final SystemMessageId GAME_WILL_END_IN_S1_MINUTES;
	
	/**
	 * ID: 1878<br>
	 * Message: I܂ł$s1błB<br>
	 * Message: &#36938;&#25138;&#32080;&#26463;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: The game will end in $s1 seconds.
	 */
	public static final SystemMessageId GAME_WILL_END_IN_S1_SECONDS;
	
	/**
	 * ID: 1879<br>
	 * Message: $s1AZ̊OɃe|[g܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#24460;&#23559;&#20659;&#36865;&#21040;&#31478;&#25216;&#22580;&#22806;&#12290;<br>
	 * Message: In $s1 minute(s), you will be teleported outside of the game arena.
	 */
	public static final SystemMessageId IN_S1_MINUTES_TELEPORTED_OUTSIDE_OF_GAME_ARENA;
	
	/**
	 * ID: 1880<br>
	 * Message: $s1bAZ̊OɃe|[g܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#31186;&#24460;&#23559;&#20659;&#36865;&#21040;&#31478;&#25216;&#22580;&#22806;&#12290;<br>
	 * Message: In $s1 seconds(s), you will be teleported outside of the game arena.
	 */
	public static final SystemMessageId IN_S1_SECONDS_TELEPORTED_OUTSIDE_OF_GAME_ARENA;
	
	/**
	 * ID: 1881<br>
	 * Message: $s1bɗ\IX^[g܂BĂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#31186;&#24460;&#23559;&#26371;&#33289;&#34892;&#38928;&#36093;&#65292;&#35531;&#20570;&#22909;&#28310;&#20633;&#12290;<br>
	 * Message: The preliminary match will begin in $s1 second(s). Prepare yourself.
	 */
	public static final SystemMessageId PRELIMINARY_MATCH_BEGIN_IN_S1_SECONDS;
	
	/**
	 * ID: 1882<br>
	 * Message: ݂̃T[o[ɂ̓LN^[𐶐ł܂B<br>
	 * Message: &#30446;&#21069;&#22312;&#27492;&#20282;&#26381;&#22120;&#28961;&#27861;&#21109;&#36896;&#35282;&#33394;&#12290;<br>
	 * Message: Characters cannot be created from this server.
	 */
	public static final SystemMessageId CHARACTERS_NOT_CREATED_FROM_THIS_SERVER;
	
	/**
	 * ID: 1883<br>
	 * Message: L͓D̂܂B<br>
	 * Message: &#27794;&#26377;&#25105;&#25152;&#25793;&#26377;&#25110;&#25237;&#27161;&#30340;&#21830;&#21697;&#12290;<br>
	 * Message: There are no offerings I own or I made a bid for.
	 */
	public static final SystemMessageId NO_OFFERINGS_OWN_OR_MADE_BID_FOR;
	
	/**
	 * ID: 1884<br>
	 * Message: lbgJtF N[|̃VAԍ͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#32178;&#21654;&#31150;&#21048;&#32232;&#34399;&#65306;<br>
	 * Message: Enter the PC Room coupon serial number.
	 */
	public static final SystemMessageId ENTER_PCROOM_SERIAL_NUMBER;
	
	/**
	 * ID: 1885<br>
	 * Message: VAԍ͂ł܂B$s1ɍēx݂ĂB<br>
	 * Message: &#28961;&#27861;&#36664;&#20837;&#32232;&#34399;&#65292;&#35531;&#26044;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#24460;&#37325;&#26032;&#20877;&#35430;&#12290;<br>
	 * Message: This serial number cannot be entered. Please try again in minute(s).
	 */
	public static final SystemMessageId SERIAL_NUMBER_CANT_ENTERED;
	
	/**
	 * ID: 1886<br>
	 * Message: łɎgpꂽVAԍłB<br>
	 * Message: &#27492;&#28858;&#24050;&#20351;&#29992;&#36942;&#30340;&#32232;&#34399;&#12290;<br>
	 * Message: This serial has already been used.
	 */
	public static final SystemMessageId SERIAL_NUMBER_ALREADY_USED;
	
	/**
	 * ID: 1887<br>
	 * Message: VAԍ܂B$s1͂ɎŝŁA$s2̃`X܂B<br>
	 * Message: &#32232;&#34399;&#19981;&#31526;&#65292;&#24744;&#24050;&#36664;&#20837;&#22833;&#25943;&#12300;&#36;&#115;&#49;&#12301;&#27425;&#12290;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#27425;&#27231;&#26371;&#12290;<br>
	 * Message: Invalid serial number. Your attempt to enter the number has failed time(s). You will be allowed to make more attempt(s).
	 */
	public static final SystemMessageId SERIAL_NUMBER_ENTERING_FAILED;
	
	/**
	 * ID: 1888<br>
	 * Message: VAԍ܂B5͂Ɏs܂B4Ԍɍēx݂ĂB<br>
	 * Message: &#32232;&#34399;&#19981;&#31526;&#65292;&#24744;&#24050;&#36664;&#20837;&#22833;&#25943;&#36948;&#53;&#27425;&#65292;&#35531;&#26044;&#52;&#23567;&#26178;&#24460;&#37325;&#26032;&#20877;&#35430;&#12290;<br>
	 * Message: Invalid serial number. Your attempt to enter the number has failed 5 time(s). Please try again in 4 hours.
	 */
	public static final SystemMessageId SERIAL_NUMBER_ENTERING_FAILED_5_TIMES;
	
	/**
	 * ID: 1889<br>
	 * Message: ߂łƂ܂B$s1󂯎܂B<br>
	 * Message: &#24685;&#21916;&#24744;&#65281;&#24744;&#24050;&#24471;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Congratulations! You have received $s1.
	 */
	public static final SystemMessageId CONGRATULATIONS_RECEIVED_S1;
	
	/**
	 * ID: 1890<br>
	 * Message: ̃N[|͂łɎgpς݂Ȃ̂ŃVAԍ͂ł܂B<br>
	 * Message: &#24744;&#24050;&#20351;&#29992;&#36942;&#19968;&#27425;&#31150;&#21048;&#65292;&#22240;&#27492;&#28961;&#27861;&#36664;&#20837;&#32232;&#34399;&#12290;<br>
	 * Message: Since you have already used this coupon, you may not use this serial number.
	 */
	public static final SystemMessageId ALREADY_USED_COUPON_NOT_USE_SERIAL_NUMBER;
	
	/**
	 * ID: 1891<br>
	 * Message: lX܂͌lH[̓ACegpł܂B<br>
	 * Message: &#22312;&#20491;&#20154;&#21830;&#24215;&#25110;&#20491;&#20154;&#24037;&#25151;&#30340;&#29376;&#24907;&#19979;&#28961;&#27861;&#20351;&#29992;&#36947;&#20855;&#12290;<br>
	 * Message: You may not use items in a private store or private work shop.
	 */
	public static final SystemMessageId NOT_USE_ITEMS_IN_PRIVATE_STORE;
	
	/**
	 * ID: 1892<br>
	 * Message: ȑÕo[W̃vC t@C͍Đł܂B<br>
	 * Message: &#28961;&#27861;&#25773;&#25918;&#20197;&#21069;&#29256;&#26412;&#30340;&#37636;&#20687;&#27284;&#26696;&#12290;<br>
	 * Message: The replay file for the previous version cannot be played.
	 */
	public static final SystemMessageId REPLAY_FILE_PREVIOUS_VERSION_CANT_PLAYED;
	
	/**
	 * ID: 1893<br>
	 * Message: ĐłȂt@CłB<br>
	 * Message: &#27492;&#28858;&#28961;&#27861;&#25773;&#25918;&#30340;&#27284;&#26696;&#12290;<br>
	 * Message: This file cannot be replayed.
	 */
	public static final SystemMessageId FILE_CANT_REPLAYED;
	
	/**
	 * ID: 1894<br>
	 * Message: edʂ𒴂邽߁ATu NX̒ǉύXł܂B<br>
	 * Message: &#24050;&#36229;&#20986;&#37325;&#37327;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#21109;&#36896;&#25110;&#35722;&#26356;&#21103;&#32887;&#26989;&#12290;<br>
	 * Message: A sub-class cannot be created or changed while you are over your weight limit.
	 */
	public static final SystemMessageId NOT_SUBCLASS_WHILE_OVERWEIGHT;
	
	/**
	 * ID: 1895<br>
	 * Message: $c1 ͌ݏłȂnɂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30446;&#21069;&#36523;&#22312;&#28961;&#27861;&#21484;&#21914;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: $c1 is in an area which blocks summoning.
	 */
	public static final SystemMessageId C1_IN_SUMMON_BLOCKING_AREA;
	
	/**
	 * ID: 1896<br>
	 * Message: $c1 ͂łɏłB<br>
	 * Message: &#27491;&#22312;&#21484;&#21914;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: $c1 has already been summoned.
	 */
	public static final SystemMessageId C1_ALREADY_SUMMONED;
	
	/**
	 * ID: 1897<br>
	 * Message: ɕKvȃACe$s1܂B<br>
	 * Message: &#27794;&#26377;&#21484;&#21914;&#26178;&#25152;&#38656;&#30340;&#36947;&#20855;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 is required for summoning.
	 */
	public static final SystemMessageId S1_REQUIRED_FOR_SUMMONING;
	
	/**
	 * ID: 1898<br>
	 * Message: $c1 ̓g[hlXsĂ邽ߏł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30446;&#21069;&#27491;&#22312;&#36914;&#34892;&#20132;&#26131;&#25110;&#38283;&#35373;&#20491;&#20154;&#21830;&#24215;&#65292;&#22240;&#27492;&#28961;&#27861;&#21484;&#21914;&#12290;<br>
	 * Message: $c1 is currently trading or operating a private store and cannot be summoned.
	 */
	public static final SystemMessageId C1_CURRENTLY_TRADING_OR_OPERATING_PRIVATE_STORE_AND_CANNOT_BE_SUMMONED;
	
	/**
	 * ID: 1899<br>
	 * Message: ݑlłȂꏊɂ邽߁Ał܂B<br>
	 * Message: &#30446;&#21069;&#36523;&#22312;&#28961;&#27861;&#21484;&#21914;&#20182;&#20154;&#30340;&#22320;&#21312;&#65292;&#22240;&#27492;&#28961;&#27861;&#21484;&#21914;&#23565;&#26041;&#12290;<br>
	 * Message: Your target is in an area which blocks summoning.
	 */
	public static final SystemMessageId YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING;
	
	/**
	 * ID: 1900<br>
	 * Message: $c1 p[eB [ɓ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#36914;&#20837;&#38538;&#20237;&#25151;&#38291;&#12290;<br>
	 * Message: $c1 has entered the party room.
	 */
	public static final SystemMessageId C1_ENTERED_PARTY_ROOM;
	
	/**
	 * ID: 1901<br>
	 * Message: $s1 $s2p[eB[ [ɏ҂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36992;&#35531;&#24744;&#36914;&#20837;&#12300;&#36;&#115;&#50;&#12301;&#25151;&#38291;&#12290;<br>
	 * Message: $c1 has invited you to enter the party room.
	 */
	public static final SystemMessageId C1_INVITED_YOU_TO_PARTY_ROOM;
	
	/**
	 * ID: 1902<br>
	 * Message: ACẽO[hvȂߎgpł܂B<br>
	 * Message: &#36947;&#20855;&#31561;&#32026;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#12290;<br>
	 * Message: Incompatible item grade. This item cannot be used.
	 */
	public static final SystemMessageId INCOMPATIBLE_ITEM_GRADE;
	
	/**
	 * ID: 1903<br>
	 * Message: NCOTPɂ\݂̏ꍇ͌gѓdb\nNCOTPs\ꂽ\nNCOTP pX[h1ȓɓ͂A\n\݂łȂꍇ͋󗓂̂܂\nOCsĂB<br>
	 * Message: &#24050;&#30003;&#35531;&#78;&#67;&#79;&#84;&#80;&#32773;&#65292;&#35531;&#22519;&#34892;&#25163;&#27231;&#30340;&#92;&#110;&#78;&#67;&#79;&#84;&#80;&#20006;&#23559;&#39023;&#31034;&#30340;&#78;&#67;&#79;&#84;&#80;&#92;&#110;&#23494;&#30908;&#22312;&#19968;&#20998;&#37912;&#20839;&#36664;&#20837;&#23436;&#30050;&#65292;&#92;&#110;&#26410;&#30003;&#35531;&#32773;&#35531;&#31354;&#33879;&#27492;&#27396;&#92;&#110;&#65292;&#30452;&#25509;&#40670;&#25802;&#30331;&#20837;&#37749;&#92;&#110;&#21363;&#21487;&#12290;<br>
	 * Message: Those of you who have requested NCOTP should run NCOTP by using your cell phone to get the NCOTP password and enter it within 1 minute. If you have not requested NCOTP, leave this field blank and click the Login button.
	 */
	public static final SystemMessageId NCOTP;
	
	/**
	 * ID: 1904<br>
	 * Message: bybgԂ́ATu NX̒ǉύXł܂B<br>
	 * Message: &#22312;&#21484;&#21914;&#20986;&#20351;&#39764;&#25110;&#23541;&#29289;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#21109;&#36896;&#25110;&#35722;&#26356;&#21103;&#32887;&#26989;&#12290;<br>
	 * Message: A sub-class may not be created or changed while a servitor or pet is summoned.
	 */
	public static final SystemMessageId CANT_SUBCLASS_WITH_SUMMONED_SERVITOR;
	
	/**
	 * ID: 1905<br>
	 * Message: $s1$c2$s3$c4Ɍւ܂B<br>
	 * Message: &#23559;&#38584;&#23660;&#26044;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#12300;&#36;&#99;&#50;&#12301;&#26367;&#25563;&#25104;&#38584;&#23660;&#26044;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#12300;&#36;&#99;&#52;&#12301;&#12290;<br>
	 * Message: $s2 of $s1 will be replaced with $s4 of $s3.
	 */
	public static final SystemMessageId S2_OF_S1_WILL_REPLACED_WITH_S4_OF_S3;
	
	/**
	 * ID: 1906<br>
	 * Message: ύX镔I܂B<br>
	 * Message: &#35531;&#36984;&#25799;&#23559;&#36681;&#35519;&#30340;&#37096;&#38538;&#12290;<br>
	 * Message: Select the combat unit to transfer to.
	 */
	public static final SystemMessageId SELECT_COMBAT_UNIT;
	
	/**
	 * ID: 1907<br>
	 * Message: IΏۂ𑼂̐lƌւꍇ\nւΏۂI܂B<br>
	 * Message: &#33509;&#35201;&#23559;&#25152;&#36984;&#23565;&#35937;&#33287;&#20854;&#20182;&#20154;&#26367;&#25563;&#92;&#110;&#35531;&#36984;&#25799;&#35201;&#26367;&#25563;&#30340;&#23565;&#35937;&#12290;<br>
	 * Message: Select the character who will replace the current character.
	 */
	public static final SystemMessageId SELECT_CHARACTER_WHO_WILL;
	
	/**
	 * ID: 1908<br>
	 * Message: $c1 ͏łȂԂłB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#28961;&#27861;&#21484;&#21914;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: $c1 in a state which prevents summoning.
	 */
	public static final SystemMessageId C1_STATE_FORBIDS_SUMMONING;
	
	/**
	 * ID: 1909<br>
	 * Message: ==<ŋ߈TԂ̌AJf~[Ǝ>==<br>
	 * Message: &#61;&#61;&#60;&#26368;&#36817;&#19968;&#36913;&#30340;&#34880;&#30431;&#23416;&#38498;&#30050;&#26989;&#29983;&#62;&#61;&#61;<br>
	 * Message: ==< List of Academy Graduates During the Past Week >==
	 */
	public static final SystemMessageId ACADEMY_LIST_HEADER;
	
	/**
	 * ID: 1910<br>
	 * Message: ƎҁF$c1<br>
	 * Message: &#30050;&#26989;&#29983;&#65306;&#12300;&#36;&#99;&#49;&#12301;<br>
	 * Message: Graduates: $c1.
	 */
	public static final SystemMessageId GRADUATES_C1;
	
	/**
	 * ID: 1911<br>
	 * Message: IsA[hɎQ̃[U[͏ł܂B<br>
	 * Message: &#28961;&#27861;&#21484;&#21914;&#22887;&#26519;&#21305;&#20126;&#21443;&#36093;&#20013;&#30340;&#29609;&#23478;&#12290;<br>
	 * Message: You cannot summon players who are currently participating in the Grand Olympiad.
	 */
	public static final SystemMessageId YOU_CANNOT_SUMMON_PLAYERS_WHO_ARE_IN_OLYMPIAD;
	
	/**
	 * ID: 1912<br>
	 * Message: NCOTPɂ\݂̂̕ݓ́B<br>
	 * Message: &#20677;&#38480;&#78;&#67;&#79;&#84;&#80;&#30003;&#35531;&#20154;&#36664;&#20837;&#12290;<br>
	 * Message: Only those requesting NCOTP should make an entry into this field.
	 */
	public static final SystemMessageId NCOTP2;
	
	/**
	 * ID: 1913<br>
	 * Message: $s1̍ĎgpԂ͎c$s2łB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20877;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12290;<br>
	 * Message: The remaining recycle time for $s1 is $s2 minute(s).
	 */
	public static final SystemMessageId TIME_FOR_S1_IS_S2_MINUTES_REMAINING;
	
	/**
	 * ID: 1914<br>
	 * Message: $s1̍ĎgpԂ͎c$s2błB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20877;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#31186;&#12290;<br>
	 * Message: The remaining recycle time for $s1 is $s2 seconds(s).
	 */
	public static final SystemMessageId TIME_FOR_S1_IS_S2_SECONDS_REMAINING;
	
	/**
	 * ID: 1915<br>
	 * Message: ZIԂ܂Ŏc$s1błB<br>
	 * Message: &#36317;&#38626;&#27604;&#36093;&#32080;&#26463;&#26178;&#38291;&#21482;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: The game will end in $s1 second(s).
	 */
	public static final SystemMessageId GAME_ENDS_IN_S1_SECONDS;
	
	/**
	 * ID: 1916<br>
	 * Message: 炷x$s1Kp܂B<br>
	 * Message: &#36973;&#21463;&#12300;&#31561;&#32026;&#36;&#115;&#49;&#12301;&#30340;&#27515;&#20129;&#24460;&#36986;&#30151;&#12290;<br>
	 * Message: Your Death Penalty is now level $s1.
	 */
	public static final SystemMessageId DEATH_PENALTY_LEVEL_S1_ADDED;
	
	/**
	 * ID: 1917<br>
	 * Message: 炷܂B<br>
	 * Message: &#27515;&#20129;&#24460;&#36986;&#30151;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: Your Death Penalty has been lifted.
	 */
	public static final SystemMessageId DEATH_PENALTY_LIFTED;
	
	/**
	 * ID: 1918<br>
	 * Message: ybg̃x߂邽߁ARg[ł܂B<br>
	 * Message: &#23541;&#29289;&#31561;&#32026;&#36942;&#39640;&#65292;&#22240;&#32780;&#28961;&#27861;&#25511;&#21046;&#12290;<br>
	 * Message: Your pet is too high level to control.
	 */
	public static final SystemMessageId PET_TOO_HIGH_TO_CONTROL;
	
	/**
	 * ID: 1919<br>
	 * Message: IsA[h̎Qo^ߐ؂܂B<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#21443;&#36093;&#30331;&#35352;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The Grand Olympiad registration period has ended.
	 */
	public static final SystemMessageId OLYMPIAD_REGISTRATION_PERIOD_ENDED;
	
	/**
	 * ID: 1920<br>
	 * Message: AJEg͋xAJEgԂłBԃQ[ɐڑȂꍇ͋xAJEgԂƂȂATCgihttp://lineage2.plaync.jp/jŃQ[ڑ\ȏԂɕύXł܂B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30446;&#21069;&#34389;&#26044;&#23553;&#21360;&#29376;&#24907;&#12290;&#22312;&#19968;&#27573;&#26399;&#38291;&#20839;&#33509;&#19981;&#36899;&#32080;&#36938;&#25138;&#26178;&#65292;&#23559;&#33258;&#21205;&#36681;&#25563;&#28858;&#23553;&#21360;&#29376;&#24907;&#12290;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#21487;&#23559;&#35442;&#24115;&#34399;&#36681;&#25563;&#28858;&#21487;&#20197;&#30331;&#20837;&#36938;&#25138;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: Your account is currently inactive because you have not logged into the game for some time. You may reactivate your account by visiting the PlayNC website (http://www.plaync.com/us/support/).
	 */
	public static final SystemMessageId ACCOUNT_INACTIVITY;
	
	/**
	 * ID: 1921<br>
	 * Message: $s1ECsĂ$s2$s3o߂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36914;&#34892;&#27578;&#25134;&#30340;&#26178;&#38291;&#24050;&#32147;&#36942;&#12300;&#36;&#115;&#50;&#23567;&#26178;&#36;&#115;&#51;&#20998;&#12301;&#12290;<br>
	 * Message: $s2 hour(s) and $s3 minute(s) have passed since $s1 has killed.
	 */
	public static final SystemMessageId S2_HOURS_S3_MINUTES_SINCE_S1_KILLED;
	
	/**
	 * ID: 1922<br>
	 * Message: $s1ۈECs킸Ał܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#25972;&#26085;&#23578;&#26410;&#36914;&#34892;&#27578;&#25134;&#65292;&#22240;&#27492;&#24050;&#33258;&#21205;&#28040;&#22833;&#12290;<br>
	 * Message: Because $s1 has failed to kill for one full day, it has expired.
	 */
	public static final SystemMessageId S1_FAILED_KILLING_EXPIRED;
	
	/**
	 * ID: 1923<br>
	 * Message: {얂ptFN Q[g܂I<br>
	 * Message: &#23470;&#24311;&#39764;&#27861;&#24107;&#65306;&#20659;&#36865;&#24050;&#23436;&#25104;&#12290;<br>
	 * Message: Court Magician: The portal has been created!
	 */
	public static final SystemMessageId COURT_MAGICIAN_CREATED_PORTAL;
	
	/**
	 * ID: 1924<br>
	 * Message: ݒnF $s1A$s2A$s3 (Â̓t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#21407;&#22987;&#20043;&#23798;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (Near the Primeval Isle)
	 */
	public static final SystemMessageId LOC_PRIMEVAL_ISLE_S1_S2_S3;
	
	/**
	 * ID: 1925<br>
	 * Message: 헐̉̕eɂ菢ł܂B<br>
	 * Message: &#21463;&#25136;&#20098;&#30340;&#23553;&#21360;&#30340;&#24433;&#38911;&#65292;&#30446;&#21069;&#34389;&#26044;&#28961;&#27861;&#21484;&#21914;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: Due to the affects of the Seal of Strife, it is not possible to summon at this time.
	 */
	public static final SystemMessageId SEAL_OF_STRIFE_FORBIDS_SUMMONING;
	
	/**
	 * ID: 1926<br>
	 * Message: \ޑ肪܂B<br>
	 * Message: &#27794;&#26377;&#33021;&#30003;&#35531;&#27770;&#39717;&#30340;&#23565;&#35937;&#12290;<br>
	 * Message: There is no opponent to receive your challenge for a duel.
	 */
	public static final SystemMessageId THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL;
	
	/**
	 * ID: 1927<br>
	 * Message: $c1 11ł̌\݂܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#25552;&#20986;&#49;&#23565;&#49;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 has been challenged to a duel.
	 */
	public static final SystemMessageId C1_HAS_BEEN_CHALLENGED_TO_A_DUEL;
	
	/**
	 * ID: 1928<br>
	 * Message: $c1 ̃p[eBɃp[eBmł̌\݂܂B<br>
	 * Message: &#21521;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#30003;&#35531;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;<br>
	 * Message: $c1's party has been challenged to a duel.
	 */
	public static final SystemMessageId C1_PARTY_HAS_BEEN_CHALLENGED_TO_A_DUEL;
	
	/**
	 * ID: 1929<br>
	 * Message: $c1 11ł̌󂯓܂B΂炭ƌn܂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25509;&#21463;&#49;&#23565;&#49;&#27770;&#39717;&#12290;&#29255;&#21051;&#24460;&#23559;&#23637;&#38283;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 has accepted your challenge to a duel. The duel will begin in a few moments.
	 */
	public static final SystemMessageId C1_HAS_ACCEPTED_YOUR_CHALLENGE_TO_A_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS;
	
	/**
	 * ID: 1930<br>
	 * Message: $c1 11ł̌̐\݂󂯓܂B΂炭ƌn܂܂B<br>
	 * Message: &#24050;&#25509;&#21463;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#49;&#23565;&#49;&#27770;&#39717;&#12290;&#29255;&#21051;&#24460;&#23559;&#23637;&#38283;&#27770;&#39717;&#12290;<br>
	 * Message: You have accepted $c1's challenge to a duel. The duel will begin in a few moments.
	 */
	public static final SystemMessageId YOU_HAVE_ACCEPTED_C1_CHALLENGE_TO_A_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS;
	
	/**
	 * ID: 1931<br>
	 * Message: $c1 11ł̌ۂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25298;&#32085;&#49;&#23565;&#49;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 has declined your challenge to a duel.
	 */
	public static final SystemMessageId C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL;
	
	/**
	 * ID: 1932<br>
	 * Message: $c1 ̐\݂ۂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25298;&#32085;&#27770;&#39717;&#30003;&#35531;&#12290;<br>
	 * Message: $c1 has declined your challenge to a duel.
	 */
	public static final SystemMessageId C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL2;
	
	/**
	 * ID: 1933<br>
	 * Message: $c1 ̃p[eB̃p[eBmł̌̐\݂󂯓܂B΂炭ƌn܂܂B<br>
	 * Message: &#24050;&#25509;&#21463;&#12300;&#36;&#99;&#49;&#12301;&#38538;&#20237;&#30340;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;&#29255;&#21051;&#24460;&#23559;&#23637;&#38283;&#27770;&#39717;&#12290;<br>
	 * Message: You have accepted $c1's challenge to a party duel. The duel will begin in a few moments.
	 */
	public static final SystemMessageId YOU_HAVE_ACCEPTED_C1_CHALLENGE_TO_A_PARTY_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS;
	
	/**
	 * ID: 1934<br>
	 * Message: $c1 p[eBmł̌󂯓܂B΂炭ƌn܂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25509;&#21463;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;&#29255;&#21051;&#24460;&#23559;&#23637;&#38283;&#27770;&#39717;&#12290;<br>
	 * Message: $s1 has accepted your challenge to duel against their party. The duel will begin in a few moments.
	 */
	public static final SystemMessageId S1_HAS_ACCEPTED_YOUR_CHALLENGE_TO_DUEL_AGAINST_THEIR_PARTY_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS;
	
	/**
	 * ID: 1935<br>
	 * Message: $c1 p[eBmł̌ۂ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25298;&#32085;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 has declined your challenge to a party duel.
	 */
	public static final SystemMessageId C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_PARTY_DUEL;
	
	/**
	 * ID: 1936<br>
	 * Message: ̃p[eB̐\݂ۂ܂B<br>
	 * Message: &#23565;&#26041;&#38538;&#20237;&#24050;&#25298;&#32085;&#38538;&#20237;&#38291;&#27770;&#39717;&#30003;&#35531;&#12290;<br>
	 * Message: The opposing party has declined your challenge to a duel.
	 */
	public static final SystemMessageId THE_OPPOSING_PARTY_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL;
	
	/**
	 * ID: 1937<br>
	 * Message: 肪p[eBԂł͂Ȃ߁Ap[eBmł̌̐\݂ł܂B<br>
	 * Message: &#23565;&#26041;&#30446;&#21069;&#20006;&#38750;&#34389;&#26044;&#38538;&#20237;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#30003;&#35531;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;<br>
	 * Message: Since the person you challenged is not currently in a party, they cannot duel against your party.
	 */
	public static final SystemMessageId SINCE_THE_PERSON_YOU_CHALLENGED_IS_NOT_CURRENTLY_IN_A_PARTY_THEY_CANNOT_DUEL_AGAINST_YOUR_PARTY;
	
	/**
	 * ID: 1938<br>
	 * Message: $c1 11ł̌\݂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30003;&#35531;&#49;&#23565;&#49;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 has challenged you to a duel.
	 */
	public static final SystemMessageId C1_HAS_CHALLENGED_YOU_TO_A_DUEL;
	
	/**
	 * ID: 1939<br>
	 * Message: $c1 ̃p[eBp[eBmł̌\݂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#24050;&#30003;&#35531;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;<br>
	 * Message: $c1's party has challenged your party to a duel.
	 */
	public static final SystemMessageId C1_PARTY_HAS_CHALLENGED_YOUR_PARTY_TO_A_DUEL;
	
	/**
	 * ID: 1940<br>
	 * Message: Ȃ߁A\߂܂B<br>
	 * Message: &#22240;&#26781;&#20214;&#19981;&#21512;&#65292;&#28961;&#27861;&#30003;&#35531;&#27770;&#39717;&#12290;<br>
	 * Message: You are unable to request a duel at this time.
	 */
	public static final SystemMessageId YOU_ARE_UNABLE_TO_REQUEST_A_DUEL_AT_THIS_TIME;
	
	/**
	 * ID: 1941<br>
	 * Message: sꏊł͂܂B<br>
	 * Message: &#27492;&#34389;&#20006;&#38750;&#28858;&#21487;&#27770;&#39717;&#30340;&#22580;&#25152;&#12290;<br>
	 * Message: This is no suitable place to challenge anyone or party to a duel.
	 */
	public static final SystemMessageId NO_PLACE_FOR_DUEL;
	
	/**
	 * ID: 1942<br>
	 * Message: ̃p[eBsԂł͂܂B<br>
	 * Message: &#23565;&#26041;&#38538;&#20237;&#34389;&#26044;&#28961;&#27861;&#27770;&#39717;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: The opposing party is currently unable to accept a challenge to a duel.
	 */
	public static final SystemMessageId THE_OPPOSING_PARTY_IS_CURRENTLY_UNABLE_TO_ACCEPT_A_CHALLENGE_TO_A_DUEL;
	
	/**
	 * ID: 1943<br>
	 * Message: ̃p[eBsꏊɂ܂B<br>
	 * Message: &#23565;&#26041;&#38538;&#20237;&#20301;&#26044;&#28961;&#27861;&#27770;&#39717;&#30340;&#22580;&#25152;&#12290;<br>
	 * Message: The opposing party is currently not in a suitable location for a duel.
	 */
	public static final SystemMessageId THE_OPPOSING_PARTY_IS_AT_BAD_LOCATION_FOR_A_DUEL;
	
	/**
	 * ID: 1944<br>
	 * Message: ΂炭ƌɈړ܂B<br>
	 * Message: &#31245;&#24460;&#23559;&#31227;&#21205;&#33267;&#27770;&#39717;&#30340;&#22580;&#25152;&#12290;<br>
	 * Message: In a moment, you will be transported to the site where the duel will take place.
	 */
	public static final SystemMessageId IN_A_MOMENT_YOU_WILL_BE_TRANSPORTED_TO_THE_SITE_WHERE_THE_DUEL_WILL_TAKE_PLACE;
	
	/**
	 * ID: 1945<br>
	 * Message: $s1bɌn܂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#31186;&#24460;&#23559;&#23637;&#38283;&#27770;&#39717;&#12290;<br>
	 * Message: The duel will begin in $s1 second(s).
	 */
	public static final SystemMessageId THE_DUEL_WILL_BEGIN_IN_S1_SECONDS;
	
	/**
	 * ID: 1946<br>
	 * Message: $c1 11ł̌\݂܂B󂯓܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22312;&#30003;&#35531;&#49;&#23565;&#49;&#27770;&#39717;&#12290;&#35201;&#25509;&#21463;&#21966;&#65311;<br>
	 * Message: $c1 has challenged you to a duel. Will you accept?
	 */
	public static final SystemMessageId C1_CHALLENGED_YOU_TO_A_DUEL;
	
	/**
	 * ID: 1947<br>
	 * Message: $c1 ̃p[eBp[eBmł̌\݂܂B󂯓܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#22312;&#30003;&#35531;&#38538;&#20237;&#38291;&#27770;&#39717;&#12290;&#35201;&#25509;&#21463;&#21966;&#65311;<br>
	 * Message: $c1's party has challenged your party to a duel. Will you accept?
	 */
	public static final SystemMessageId C1_CHALLENGED_YOU_TO_A_PARTY_DUEL;
	
	/**
	 * ID: 1948<br>
	 * Message:  $s1bɎn܂܂B<br>
	 * Message: &#27770;&#39717;&#22312;&#12300;&#36;&#115;&#49;&#31186;&#12301;&#24460;&#23637;&#38283;&#12290;<br>
	 * Message: The duel will begin in $s1 second(s).
	 */
	public static final SystemMessageId THE_DUEL_WILL_BEGIN_IN_S1_SECONDS2;
	
	/**
	 * ID: 1949<br>
	 * Message: JnI<br>
	 * Message: &#27770;&#39717;&#38283;&#22987;&#65281;<br>
	 * Message: Let the duel begin!
	 */
	public static final SystemMessageId LET_THE_DUEL_BEGIN;
	
	/**
	 * ID: 1950<br>
	 * Message: $c1 ɏ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22312;&#27770;&#39717;&#20013;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: $c1 has won the duel.
	 */
	public static final SystemMessageId C1_HAS_WON_THE_DUEL;
	
	/**
	 * ID: 1951<br>
	 * Message: $c1 ̃p[eBɏ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#22312;&#27770;&#39717;&#20013;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: $c1's party has won the duel.
	 */
	public static final SystemMessageId C1_PARTY_HAS_WON_THE_DUEL;
	
	/**
	 * ID: 1952<br>
	 * Message: łB<br>
	 * Message: &#19981;&#20998;&#21213;&#36000;&#12290;<br>
	 * Message: The duel has ended in a tie.
	 */
	public static final SystemMessageId THE_DUEL_HAS_ENDED_IN_A_TIE;
	
	/**
	 * ID: 1953<br>
	 * Message: $c1iƂȂ$s2܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#22833;&#21435;&#36039;&#26684;&#65292;&#12300;&#36;&#115;&#50;&#12301;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Since $c1 was disqualified, $s2 has won.
	 */
	public static final SystemMessageId SINCE_C1_WAS_DISQUALIFIED_S2_HAS_WON;
	
	/**
	 * ID: 1954<br>
	 * Message: $c1̃p[eBiƂȂ$s2 ̃p[eB܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#22833;&#21435;&#36039;&#26684;&#65292;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#38538;&#20237;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Since $c1's party was disqualified, $s2's party has won.
	 */
	public static final SystemMessageId SINCE_C1_PARTY_WAS_DISQUALIFIED_S2_PARTY_HAS_WON;
	
	/**
	 * ID: 1955<br>
	 * Message: $c1$s2܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#25918;&#26820;&#27770;&#39717;&#65292;&#12300;&#36;&#115;&#50;&#12301;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Since $c1 withdrew from the duel, $s2 has won.
	 */
	public static final SystemMessageId SINCE_C1_WITHDREW_FROM_THE_DUEL_S2_HAS_WON;
	
	/**
	 * ID: 1956<br>
	 * Message: $c1̃p[eB$s2̃p[eB܂B<br>
	 * Message: &#22240;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#38538;&#20237;&#25918;&#26820;&#27770;&#39717;&#65292;&#12300;&#36;&#115;&#50;&#12301;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: Since $c1's party withdrew from the duel, $s2's party has won.
	 */
	public static final SystemMessageId SINCE_C1_PARTY_WITHDREW_FROM_THE_DUEL_S2_PARTY_HAS_WON;
	
	/**
	 * ID: 1957<br>
	 * Message: BACeuĂB<br>
	 * Message: &#23559;&#35201;&#31934;&#29001;&#30340;&#36947;&#20855;&#25918;&#19978;&#21435;&#12290;<br>
	 * Message: Select the item to be augmented.
	 */
	public static final SystemMessageId SELECT_THE_ITEM_TO_BE_AUGMENTED;
	
	/**
	 * ID: 1958<br>
	 * Message: BނuĂB<br>
	 * Message: &#23559;&#31934;&#29001;&#21137;&#25918;&#19978;&#21435;&#12290;<br>
	 * Message: Select the catalyst for augmentation.
	 */
	public static final SystemMessageId SELECT_THE_CATALYST_FOR_AUGMENTATION;
	
	/**
	 * ID: 1959<br>
	 * Message: $s1 $s2uĂB<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#25918;&#19978;&#21435;&#12290;<br>
	 * Message: Requires $s1 $s2.
	 */
	public static final SystemMessageId REQUIRES_S1_S2;
	
	/**
	 * ID: 1960<br>
	 * Message: ACeKĂ܂B<br>
	 * Message: &#19981;&#26159;&#36969;&#21512;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: This is not a suitable item.
	 */
	public static final SystemMessageId THIS_IS_NOT_A_SUITABLE_ITEM;
	
	/**
	 * ID: 1961<br>
	 * Message: WFXg[̐Ă܂B<br>
	 * Message: &#23542;&#30707;&#25976;&#37327;&#19981;&#21512;&#12290;<br>
	 * Message: Gemstone quantity is incorrect.
	 */
	public static final SystemMessageId GEMSTONE_QUANTITY_IS_INCORRECT;
	
	/**
	 * ID: 1962<br>
	 * Message: ACeBI<br>
	 * Message: &#36947;&#20855;&#31934;&#29001;&#25104;&#21151;&#65281;<br>
	 * Message: The item was successfully augmented!
	 */
	public static final SystemMessageId THE_ITEM_WAS_SUCCESSFULLY_AUGMENTED;
	
	/**
	 * ID: 1963<br>
	 * Message: BACeuĂB<br>
	 * Message: &#23559;&#24819;&#35201;&#35299;&#38500;&#31934;&#29001;&#30340;&#36947;&#20855;&#25918;&#19978;&#21435;&#12290;<br>
	 * Message: Select the item from which you wish to remove augmentation.
	 */
	public static final SystemMessageId SELECT_THE_ITEM_FROM_WHICH_YOU_WISH_TO_REMOVE_AUGMENTATION;
	
	/**
	 * ID: 1964<br>
	 * Message: BĂȂACe͐BsƂł܂B<br>
	 * Message: &#26410;&#31934;&#29001;&#36942;&#30340;&#36947;&#20855;&#65292;&#28961;&#27861;&#35299;&#38500;&#31934;&#29001;&#12290;<br>
	 * Message: Augmentation removal can only be done on an augmented item.
	 */
	public static final SystemMessageId AUGMENTATION_REMOVAL_CAN_ONLY_BE_DONE_ON_AN_AUGMENTED_ITEM;
	
	/**
	 * ID: 1965<br>
	 * Message: $s1̐Bɐ܂B<br>
	 * Message: &#25104;&#21151;&#35299;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#31934;&#29001;&#29376;&#24907;&#12290;<br>
	 * Message: Augmentation has been successfully removed from your $s1.
	 */
	public static final SystemMessageId AUGMENTATION_HAS_BEEN_SUCCESSFULLY_REMOVED_FROM_YOUR_S1;
	
	/**
	 * ID: 1966<br>
	 * Message: wR}h͘A̎w҂gpł܂B<br>
	 * Message: &#20677;&#38480;&#32879;&#36557;&#25351;&#25582;&#32773;&#20351;&#29992;&#25351;&#25582;&#21629;&#20196;&#12290;<br>
	 * Message: Only the clan leader may issue commands.
	 */
	public static final SystemMessageId ONLY_CLAN_LEADER_CAN_ISSUE_COMMANDS;
	
	/**
	 * ID: 1967<br>
	 * Message: 傪łĂ܂B΂炭ĂxsĂB<br>
	 * Message: &#38272;&#32202;&#32202;&#30340;&#37782;&#33879;&#12290;&#35531;&#31245;&#24460;&#20877;&#35430;&#35430;&#12290;<br>
	 * Message: The gate is firmly locked. Please try again later.
	 */
	public static final SystemMessageId GATE_LOCKED_TRY_AGAIN_LATER;
	
	/**
	 * ID: 1968<br>
	 * Message: $s1̏L<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20027;&#20154;<br>
	 * Message: $s1's owner.
	 */
	public static final SystemMessageId S1_OWNER;
	
	/**
	 * ID: 1969<br>
	 * Message: $s1̓on<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20986;&#29694;&#22320;&#21312;<br>
	 * Message: Area where $s1 appears.
	 */
	public static final SystemMessageId AREA_S1_APPEARS;
	
	/**
	 * ID: 1970<br>
	 * Message: BꂽACe܂B邱Ƃ͂ł܂B<br>
	 * Message: &#31934;&#29001;&#36942;&#30340;&#36947;&#20855;&#65292;&#28961;&#27861;&#20877;&#27425;&#31934;&#29001;&#12290;<br>
	 * Message: Once an item is augmented, it cannot be augmented again.
	 */
	public static final SystemMessageId ONCE_AN_ITEM_IS_AUGMENTED_IT_CANNOT_BE_AUGMENTED_AGAIN;
	
	/**
	 * ID: 1971<br>
	 * Message: ނ̃x߂邽߁Agpł܂B<br>
	 * Message: &#24375;&#21270;&#21137;&#30340;&#31561;&#32026;&#22826;&#39640;&#65292;&#28961;&#27861;&#20351;&#29992;&#12290;<br>
	 * Message: The level of the hardener is too high to be used.
	 */
	public static final SystemMessageId HARDENER_LEVEL_TOO_HIGH;
	
	/**
	 * ID: 1972<br>
	 * Message: lXlH[̓rł͐Bł܂B<br>
	 * Message: &#22312;&#20491;&#20154;&#21830;&#24215;&#25110;&#20491;&#20154;&#24037;&#25151;&#26178;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while a private store or private workshop is in operation.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_A_PRIVATE_STORE_OR_PRIVATE_WORKSHOP_IS_IN_OPERATION;
	
	/**
	 * ID: 1973<br>
	 * Message: t[YԂł͐Bł܂B<br>
	 * Message: &#22312;&#26283;&#20572;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while frozen.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_FROZEN;
	
	/**
	 * ID: 1974<br>
	 * Message: SԂł͐Bł܂B<br>
	 * Message: &#22312;&#27515;&#20129;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while dead.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_DEAD;
	
	/**
	 * ID: 1975<br>
	 * Message: g[h͐Bł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while engaged in trade activities.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_TRADING;
	
	/**
	 * ID: 1976<br>
	 * Message: ΉԂł͐Bł܂B<br>
	 * Message: &#22312;&#30707;&#21270;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while paralyzed.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_PARALYZED;
	
	/**
	 * ID: 1977<br>
	 * Message: tBbVO͐Bł܂B<br>
	 * Message: &#37347;&#39770;&#20013;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while fishing.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_FISHING;
	
	/**
	 * ID: 1978<br>
	 * Message: ĂԂł͐Bł܂B<br>
	 * Message: &#22352;&#19979;&#26178;&#65292;&#28961;&#27861;&#36914;&#34892;&#31934;&#29001;&#12290;<br>
	 * Message: You cannot augment items while sitting down.
	 */
	public static final SystemMessageId YOU_CANNOT_AUGMENT_ITEMS_WHILE_SITTING_DOWN;
	
	/**
	 * ID: 1979<br>
	 * Message: $s1̎c͂10ɂȂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#21097;&#39192;&#39764;&#21147;&#28858;&#49;&#48;&#12290;<br>
	 * Message: $s1's remaining Mana is now 10.
	 */
	public static final SystemMessageId S1S_REMAINING_MANA_IS_NOW_10;
	
	/**
	 * ID: 1980<br>
	 * Message: $s1̎c͂5ɂȂ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#21097;&#39192;&#39764;&#21147;&#28858;&#53;&#12290;<br>
	 * Message: $s1's remaining Mana is now 5.
	 */
	public static final SystemMessageId S1S_REMAINING_MANA_IS_NOW_5;
	
	/**
	 * ID: 1981<br>
	 * Message: $s1̎c͂1ɂȂ܂B΂炭Əł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#21097;&#39192;&#39764;&#21147;&#28858;&#49;&#12290;&#29255;&#21051;&#24460;&#21363;&#23559;&#28040;&#22833;&#12290;<br>
	 * Message: $s1's remaining Mana is now 1. It will disappear soon.
	 */
	public static final SystemMessageId S1S_REMAINING_MANA_IS_NOW_1;
	
	/**
	 * ID: 1982<br>
	 * Message: $s1̎c͂0ƂȂAACeł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#21097;&#39192;&#39764;&#21147;&#28858;&#48;&#65292;&#22240;&#27492;&#36947;&#20855;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: $s1's remaining Mana is now 0, and the item has disappeared.
	 */
	public static final SystemMessageId S1S_REMAINING_MANA_IS_NOW_0;
	
	/**
	 * ID: 1984<br>
	 * Message: B{^ƐBn܂܂B<br>
	 * Message: &#25353;&#19979;&#31934;&#29001;&#25353;&#37397;&#24460;&#23559;&#38283;&#22987;&#31934;&#29001;&#12290;<br>
	 * Message: Press the Augment button to begin.
	 */
	public static final SystemMessageId PRESS_THE_AUGMENT_BUTTON_TO_BEGIN;
	
	/**
	 * ID: 1985<br>
	 * Message: $s1̃hbvn($s2)<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#25481;&#33853;&#22320;&#21312;&#65288;&#36;&#115;&#50;&#65289;<br>
	 * Message: $s1's drop area ($s2)
	 */
	public static final SystemMessageId S1_DROP_AREA_S2;
	
	/**
	 * ID: 1986<br>
	 * Message: $s1̏L($s2)<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20027;&#20154;&#65288;&#36;&#115;&#50;&#65289;<br>
	 * Message: $s1's owner ($s2)
	 */
	public static final SystemMessageId S1_OWNER_S2;
	
	/**
	 * ID: 1987<br>
	 * Message: $s1<br>
	 * Message: &#36;&#115;&#49;<br>
	 * Message: $s1
	 */
	public static final SystemMessageId S1;
	
	/**
	 * ID: 1988<br>
	 * Message: Â̓ɓ܂B<br>
	 * Message: &#24050;&#25269;&#36948;&#21407;&#22987;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry has arrived at Primeval Isle.
	 */
	public static final SystemMessageId FERRY_ARRIVED_AT_PRIMEVAL;
	
	/**
	 * ID: 1989<br>
	 * Message: 3Ԓ┑AE`ɏo܂B<br>
	 * Message: &#20572;&#27850;&#51;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry will leave for Rune Harbor after anchoring for three minutes.
	 */
	public static final SystemMessageId FERRY_LEAVING_FOR_RUNE_3_MINUTES;
	
	/**
	 * ID: 1990<br>
	 * Message: Â̓烋E`֏o܂B<br>
	 * Message: &#24478;&#21407;&#22987;&#20043;&#23798;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#12290;<br>
	 * Message: The ferry is now departing Primeval Isle for Rune Harbor.
	 */
	public static final SystemMessageId FERRY_LEAVING_PRIMEVAL_FOR_RUNE_NOW;
	
	/**
	 * ID: 1991<br>
	 * Message: 3Ԓ┑AÂ̓ɏo܂B<br>
	 * Message: &#20572;&#27850;&#51;&#20998;&#37912;&#20043;&#24460;&#65292;&#23559;&#21069;&#24448;&#21407;&#22987;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry will leave for Primeval Isle after anchoring for three minutes.
	 */
	public static final SystemMessageId FERRY_LEAVING_FOR_PRIMEVAL_3_MINUTES;
	
	/**
	 * ID: 1992<br>
	 * Message: E`瑾Â̓֏o܂B<br>
	 * Message: &#24478;&#39791;&#22240;&#28207;&#21475;&#21069;&#24448;&#21407;&#22987;&#20043;&#23798;&#12290;<br>
	 * Message: The ferry is now departing Rune Harbor for Primeval Isle.
	 */
	public static final SystemMessageId FERRY_LEAVING_RUNE_FOR_PRIMEVAL_NOW;
	
	/**
	 * ID: 1993<br>
	 * Message: Â̓ E`s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#21407;&#22987;&#20043;&#23798;&#21069;&#24448;&#39791;&#22240;&#28207;&#21475;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Primeval Isle to Rune Harbor has been delayed.
	 */
	public static final SystemMessageId FERRY_FROM_PRIMEVAL_TO_RUNE_DELAYED;
	
	/**
	 * ID: 1994<br>
	 * Message: E` Â̓s̒D̉^qɒxꂪoĂ܂B<br>
	 * Message: &#33258;&#39791;&#22240;&#28207;&#21475;&#21069;&#24448;&#21407;&#22987;&#20043;&#23798;&#30340;&#23450;&#26399;&#33337;&#65292;&#20986;&#30332;&#26178;&#38291;&#24310;&#35492;&#12290;<br>
	 * Message: The ferry from Rune Harbor to Primeval Isle has been delayed.
	 */
	public static final SystemMessageId FERRY_FROM_RUNE_TO_PRIMEVAL_DELAYED;
	
	/**
	 * ID: 1995<br>
	 * Message: $s1 ̨ݸ ߼<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#38971;&#36947;&#31721;&#36984;&#36984;&#38917;<br>
	 * Message: $s1 channel filtering option
	 */
	public static final SystemMessageId S1_CHANNEL_FILTER_OPTION;
	
	/**
	 * ID: 1996<br>
	 * Message: 肪GԂłB<br>
	 * Message: &#23565;&#26041;&#34389;&#26044;&#28961;&#25973;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: The attack has been blocked.
	 */
	public static final SystemMessageId ATTACK_WAS_BLOCKED;
	
	/**
	 * ID: 1997<br>
	 * Message: $c1XLUɔ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#23565;&#25216;&#33021;&#25915;&#25802;&#36914;&#34892;&#21453;&#25802;&#12290;<br>
	 * Message: $c1 is performing a counterattack.
	 */
	public static final SystemMessageId C1_PERFORMING_COUNTERATTACK;
	
	/**
	 * ID: 1998<br>
	 * Message: $c1̃XLUɔ܂B<br>
	 * Message: &#23565;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#25216;&#33021;&#25915;&#25802;&#36914;&#34892;&#21453;&#25802;&#12290;<br>
	 * Message: You countered $c1's attack.
	 */
	public static final SystemMessageId COUNTERED_C1_ATTACK;
	
	/**
	 * ID: 1999<br>
	 * Message: $c1XLU܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#26377;&#38275;&#38283;&#25216;&#33021;&#25915;&#25802;&#12290;<br>
	 * Message: $c1 dodges the attack.
	 */
	public static final SystemMessageId C1_DODGES_ATTACK;
	
	/**
	 * ID: 2000<br>
	 * Message: $c1̃XLU܂B<br>
	 * Message: &#24050;&#38275;&#38283;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#25216;&#33021;&#25915;&#25802;&#12290;<br>
	 * Message: You have avoided $c1's attack.
	 */
	public static final SystemMessageId AVOIDED_C1_ATTACK2;
	
	/**
	 * ID: 2001<br>
	 * Message: BɍsꂸABs܂B<br>
	 * Message: &#26410;&#32147;&#36942;&#27491;&#24120;&#30340;&#31934;&#29001;&#36942;&#31243;&#65292;&#22240;&#27492;&#23566;&#33268;&#31934;&#29001;&#22833;&#25943;&#12290;<br>
	 * Message: Augmentation failed due to inappropriate conditions.
	 */
	public static final SystemMessageId AUGMENTATION_FAILED_DUE_TO_INAPPROPRIATE_CONDITIONS;
	
	/**
	 * ID: 2002<br>
	 * Message: ߊlɎs܂B<br>
	 * Message: &#29557;&#25429;&#22833;&#25943;&#12290;<br>
	 * Message: Trap failed.
	 */
	public static final SystemMessageId TRAP_FAILED;
	
	/**
	 * ID: 2003<br>
	 * Message: ʑ𓾂܂B<br>
	 * Message: &#29554;&#24471;&#19968;&#33324;&#23660;&#24615;&#12290;<br>
	 * Message: You obtained an ordinary material.
	 */
	public static final SystemMessageId OBTAINED_ORDINARY_MATERIAL;
	
	/**
	 * ID: 2004<br>
	 * Message: A𓾂܂B<br>
	 * Message: &#29554;&#24471;&#31232;&#26377;&#23660;&#24615;&#12290;<br>
	 * Message: You obtained a rare material.
	 */
	public static final SystemMessageId OBTAINED_RATE_MATERIAL;
	
	/**
	 * ID: 2005<br>
	 * Message: j[N𓾂܂B<br>
	 * Message: &#29554;&#24471;&#29544;&#29305;&#23660;&#24615;&#12290;<br>
	 * Message: You obtained a unique material.
	 */
	public static final SystemMessageId OBTAINED_UNIQUE_MATERIAL;
	
	/**
	 * ID: 2006<br>
	 * Message: Bꑮ𓾂܂B<br>
	 * Message: &#29554;&#24471;&#26997;&#33268;&#23660;&#24615;&#12290;<br>
	 * Message: You obtained the only material of this kind.
	 */
	public static final SystemMessageId OBTAINED_ONLY_MATERIAL;
	
	/**
	 * ID: 2007<br>
	 * Message: M͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#25910;&#20214;&#20154;&#12290;<br>
	 * Message: Please enter the recipient's name.
	 */
	public static final SystemMessageId ENTER_RECIPIENTS_NAME;
	
	/**
	 * ID: 2008<br>
	 * Message: {͂ĂB<br>
	 * Message: &#35531;&#36664;&#20837;&#26412;&#25991;&#12290;<br>
	 * Message: Please enter the text.
	 */
	public static final SystemMessageId ENTER_TEXT;
	
	/**
	 * ID: 2009<br>
	 * Message: 1500߂Ă܂B<br>
	 * Message: &#19981;&#24471;&#36229;&#36942;&#49;&#44;&#53;&#48;&#48;&#23383;&#12290;<br>
	 * Message: You cannot exceed 1500 characters.
	 */
	public static final SystemMessageId CANT_EXCEED_1500_CHARACTERS;
	
	/**
	 * ID: 2010<br>
	 * Message: $s2 $s1<br>
	 * Message: &#12300;&#36;&#115;&#50;&#32;&#36;&#115;&#49;&#12301;<br>
	 * Message: $s2 $s1
	 */
	public static final SystemMessageId S2_S1;
	
	/**
	 * ID: 2011<br>
	 * Message: Bς݃ACê͎Ă邱Ƃł܂B<br>
	 * Message: &#28961;&#27861;&#19999;&#26820;&#31934;&#29001;&#36942;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: The augmented item cannot be discarded.
	 */
	public static final SystemMessageId AUGMENTED_ITEM_CANNOT_BE_DISCARDED;
	
	/**
	 * ID: 2012<br>
	 * Message: $s1܂B<br>
	 * Message: &#24050;&#30332;&#21205;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s1 has been activated.
	 */
	public static final SystemMessageId S1_HAS_BEEN_ACTIVATED;
	
	/**
	 * ID: 2013<br>
	 * Message: ܂͍w̎c肪sĂ܂B<br>
	 * Message: &#31278;&#23376;&#25110;&#21097;&#39192;&#25910;&#36092;&#37327;&#19981;&#36275;&#12290;<br>
	 * Message: Your seed or remaining purchase amount is inadequate.
	 */
	public static final SystemMessageId YOUR_SEED_OR_REMAINING_PURCHASE_AMOUNT_IS_INADEQUATE;
	
	/**
	 * ID: 2014<br>
	 * Message: ُ펖ԂĐisł܂B<br>
	 * Message: &#30332;&#29983;&#30064;&#24120;&#29694;&#35937;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#12290;<br>
	 * Message: You cannot proceed because the manor cannot accept any more crops. All crops have been returned and no adena withdrawn.
	 */
	public static final SystemMessageId MANOR_CANT_ACCEPT_MORE_CROPS;
	
	/**
	 * ID: 2015<br>
	 * Message: zXĽʂAXL̍Ďgp\łB<br>
	 * Message: &#23436;&#32654;&#23637;&#29694;&#30331;&#23792;&#36896;&#26997;&#30340;&#25216;&#34269;&#65292;&#25216;&#33021;&#21363;&#21051;&#25104;&#28858;&#33021;&#22816;&#20877;&#20351;&#29992;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: A skill is ready to be used again.
	 */
	public static final SystemMessageId SKILL_READY_TO_USE_AGAIN;
	
	/**
	 * ID: 2016<br>
	 * Message: zXĽʂAXLُ̈Ԃ̌ʎԂ܂B<br>
	 * Message: &#23436;&#32654;&#23637;&#29694;&#30331;&#23792;&#36896;&#26997;&#30340;&#25216;&#34269;&#65292;&#25216;&#33021;&#30340;&#29305;&#27530;&#29376;&#24907;&#25928;&#26524;&#25345;&#32396;&#26178;&#38291;&#25552;&#21319;&#12290;<br>
	 * Message: A skill is ready to be used again but its re-use counter time has increased.
	 */
	public static final SystemMessageId SKILL_READY_TO_USE_AGAIN_BUT_TIME_INCREASED;
	
	/**
	 * ID: 2017<br>
	 * Message: $c1 ͌lXlH[JĂ邽ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#38283;&#35373;&#20491;&#20154;&#21830;&#24215;&#25110;&#24037;&#25151;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is currently engaged in a private store or manufacture.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_A_PRIVATE_STORE_OR_MANUFACTURE;
	
	/**
	 * ID: 2018<br>
	 * Message: $c1 ̓tBbVÔߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#37347;&#39770;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is currently fishing.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_FISHING;
	
	/**
	 * ID: 2019<br>
	 * Message: $c1 HP܂MP50ȉ̂ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#72;&#80;&#25110;&#77;&#80;&#30446;&#21069;&#34389;&#26044;&#53;&#48;&#37;&#20197;&#19979;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1's HP or MP is below 50%.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_HP_OR_MP_IS_BELOW_50_PERCENT;
	
	/**
	 * ID: 2020<br>
	 * Message: $c1 ͌s\Ȓnis[X][AZu TCAAX^[gs\Ȓnjɂ邽ߌ\߂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30446;&#21069;&#34389;&#26044;&#28961;&#27861;&#27770;&#39717;&#30340;&#22320;&#21312;&#65288;&#23433;&#20840;&#21312;&#22495;&#47;&#19971;&#23553;&#21360;&#22320;&#21312;&#47;&#27700;&#20013;&#47;&#28961;&#27861;&#37325;&#29983;&#30340;&#22320;&#40670;&#65289;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot make a challenge to a duel because $c1 is currently in a duel-prohibited area (Peaceful Zone / Seven Signs Zone / Near Water / Restart Prohibited Area).
	 */
	public static final SystemMessageId C1_CANNOT_MAKE_A_CHALLANGE_TO_A_DUEL_BECAUSE_C1_IS_CURRENTLY_IN_A_DUEL_PROHIBITED_AREA;
	
	/**
	 * ID: 2021<br>
	 * Message: $c1 ͐퓬̂߁Ał܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#36914;&#34892;&#25136;&#39717;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is currently engaged in battle.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_BATTLE;
	
	/**
	 * ID: 2022<br>
	 * Message: $c1 ͂łɌ̂ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#22312;&#27770;&#39717;&#20013;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is already engaged in a duel.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_ALREADY_ENGAGED_IN_A_DUEL;
	
	/**
	 * ID: 2023<br>
	 * Message: $c1 ̓JIeBbN̂ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#24615;&#21521;&#20540;&#22823;&#26044;&#48;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is in a chaotic state.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_IN_A_CHAOTIC_STATE;
	
	/**
	 * ID: 2024<br>
	 * Message: $c1 ̓IsA[hsĂ邽߁Ał܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#21443;&#33287;&#22887;&#26519;&#21305;&#20126;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is participating in the Olympiad.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_THE_OLYMPIAD;
	
	/**
	 * ID: 2025<br>
	 * Message: $c1 ̓AWg퐋ŝߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#21443;&#33287;&#25915;&#22478;&#25136;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is participating in a clan hall war.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_A_CLAN_HALL_WAR;
	
	/**
	 * ID: 2026<br>
	 * Message: $c1 ͍UɎQ̂ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#21443;&#33287;&#25915;&#22478;&#25136;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is participating in a siege war.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_A_SIEGE_WAR;
	
	/**
	 * ID: 2027<br>
	 * Message: $c1 ͑DACo[AXgC_[Ȃǂɓ撆̂ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#25645;&#20056;&#33337;&#12289;&#39438;&#20056;&#39131;&#40845;&#25110;&#24231;&#40845;&#65292;&#22240;&#27492;&#28961;&#27861;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is currently riding a boat, steed, or strider.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_RIDING_A_BOAT_STEED_OR_STRIDER;
	
	/**
	 * ID: 2028<br>
	 * Message: $c1 ͉ɂ邽ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#20301;&#32622;&#22826;&#36942;&#36953;&#36960;&#65292;&#22240;&#27492;&#28961;&#27861;&#25509;&#21463;&#27770;&#39717;&#36992;&#35531;&#12290;<br>
	 * Message: $c1 cannot receive a duel challenge because $c1 is too far away.
	 */
	public static final SystemMessageId C1_CANNOT_RECEIVE_A_DUEL_CHALLENGE_BECAUSE_C1_IS_TOO_FAR_AWAY;
	
	/**
	 * ID: 2029<br>
	 * Message: $c1 ̓e|[gł邽߁AIsA[hɎQł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#20659;&#36865;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#21443;&#21152;&#22887;&#26519;&#21305;&#20126;&#12290;<br>
	 * Message: $c1 is currently teleporting and cannot participate in the Olympiad.
	 */
	public static final SystemMessageId C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_DURING_TELEPORT;
	
	/**
	 * ID: 2030<br>
	 * Message: OCłB<br>
	 * Message: &#30331;&#20837;&#20013;&#12290;<br>
	 * Message: You are currently logging in.
	 */
	public static final SystemMessageId CURRENTLY_LOGGING_IN;
	
	/**
	 * ID: 2031<br>
	 * Message: ΂炭҂B<br>
	 * Message: &#35531;&#31245;&#20505;&#12290;<br>
	 * Message: Please wait a moment.
	 */
	public static final SystemMessageId PLEASE_WAIT_A_MOMENT;
	
	/**
	 * ID: 2032<br>
	 * Message: ACe̍w\ԓł͂܂B<br>
	 * Message: &#23578;&#26410;&#21040;&#21487;&#20197;&#36092;&#36023;&#36947;&#20855;&#30340;&#26178;&#38291;&#12290;<br>
	 * Message: It is not the right time for purchasing the item.
	 */
	public static final SystemMessageId NOT_TIME_TO_PURCHASE_ITEM;
	
	/**
	 * ID: 2033<br>
	 * Message: Cxg̐ʐ𒴂߁ATu NX邱ƂύXł܂B<br>
	 * Message: &#36229;&#36942;&#36947;&#20855;&#28165;&#21934;&#25976;&#37327;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#21109;&#36896;&#25110;&#35722;&#26356;&#21103;&#32887;&#26989;&#12290;<br>
	 * Message: A sub-class cannot be created or changed because you have exceeded your inventory limit.
	 */
	public static final SystemMessageId NOT_SUBCLASS_WHILE_INVENTORY_FULL;
	
	/**
	 * ID: 2034<br>
	 * Message: ACe̍w\Ԃ܂Ŏc$s1 $s2łB<br>
	 * Message: &#38626;&#21487;&#20197;&#36092;&#36023;&#36947;&#20855;&#30340;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#23567;&#26178;&#36;&#115;&#50;&#20998;&#37912;&#12301;&#12290;<br>
	 * Message: There are $s1 hour(s) and $s2 minute(s) remaining until the time when the item can be purchased.
	 */
	public static final SystemMessageId ITEM_PURCHASABLE_IN_S1_HOURS_S2_MINUTES;
	
	/**
	 * ID: 2035<br>
	 * Message: ACe̍w\Ԃ܂Ŏc $s1łB<br>
	 * Message: &#38626;&#21487;&#20197;&#36092;&#36023;&#36947;&#20855;&#30340;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: There are $s1 minute(s) remaining until the time when the item can be purchased.
	 */
	public static final SystemMessageId ITEM_PURCHASABLE_IN_S1_MINUTES;
	
	/**
	 * ID: 2036<br>
	 * Message: p[eBbNĂ邽ߏ҂ł܂B<br>
	 * Message: &#38538;&#20237;&#24050;&#37782;&#23450;&#65292;&#25925;&#28961;&#27861;&#36914;&#34892;&#36992;&#35531;&#12290;<br>
	 * Message: Unable to invite because the party is locked.
	 */
	public static final SystemMessageId NO_INVITE_PARTY_LOCKED;
	
	/**
	 * ID: 2037<br>
	 * Message: LN^[𐶐ł܂BYT[o[͈ȑOLN^[Ȃꍇ́AVKLN^[𐶐łȂ悤ɐĂ܂B̃T[o[pB<br>
	 * Message: &#28961;&#27861;&#21109;&#36896;&#35282;&#33394;&#12290;&#27794;&#26377;&#21109;&#36896;&#36942;&#20219;&#20309;&#35282;&#33394;&#30340;&#24115;&#34399;&#65292;&#28961;&#27861;&#26044;&#27492;&#20282;&#26381;&#22120;&#20839;&#21109;&#36896;&#26032;&#35282;&#33394;&#65292;&#35531;&#36984;&#25799;&#20854;&#20182;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: Unable to create character. You are unable to create a new character on the selected server. A restriction is in place which restricts users from creating characters on different servers where no previous characters exists. Please choose another server.
	 */
	public static final SystemMessageId CANT_CREATE_CHARACTER_DURING_RESTRICTION;
	
	/**
	 * ID: 2038<br>
	 * Message: ACẽhbvłȂAJEgłB<br>
	 * Message: &#28961;&#27861;&#25481;&#33853;&#36947;&#20855;&#30340;&#24115;&#34399;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed to drop items and/or Adena. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId ACCOUNT_CANT_DROP_ITEMS;
	
	/**
	 * ID: 2039<br>
	 * Message: ACẽg[hłȂAJEgłB<br>
	 * Message: &#28961;&#27861;&#20132;&#26131;&#36947;&#20855;&#30340;&#24115;&#34399;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed to trade items and/or Adena. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId ACCOUNT_CANT_TRADE_ITEMS;
	
	/**
	 * ID: 2040<br>
	 * Message: Ώۂ̃[U[ƃACẽg[hł܂B<br>
	 * Message: &#28961;&#27861;&#33287;&#30446;&#27161;&#23565;&#35937;&#20132;&#26131;&#36947;&#20855;&#12290;<br>
	 * Message: Cannot trade items with the targeted user.
	 */
	public static final SystemMessageId CANT_TRADE_WITH_TARGET;
	
	/**
	 * ID: 2041<br>
	 * Message: lXJƂ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#38283;&#35373;&#20491;&#20154;&#21830;&#24215;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed to setup private stores. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId CANT_OPEN_PRIVATE_STORE;
	
	/**
	 * ID: 2042<br>
	 * Message: ql̃AJEǵA[ɂꎞIɂpĂԂłB\nڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#27492;&#24115;&#34399;&#22240;&#25163;&#27231;&#65288;&#33258;&#21205;&#35486;&#38899;&#31995;&#32113;&#65289;&#20786;&#20540;&#20043;&#24460;&#26410;&#20184;&#36027;&#65292;&#22240;&#32780;&#26283;&#26178;&#34987;&#38480;&#21046;&#20351;&#29992;&#12290;&#35531;&#22312;&#20184;&#36027;&#24460;&#65292;&#23559;&#35657;&#26126;&#20184;&#36027;&#30340;&#25910;&#25818;&#20659;&#30495;&#33267;&#65288;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#50;&#50;&#50;&#65289;&#24460;&#65292;&#35531;&#32879;&#32097;&#23458;&#26381;&#20013;&#24515;&#65288;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#54;&#54;&#54;&#65289;&#12290;<br>
	 * Message: This account has been suspended for non-payment based on the cell phone payment agreement. Please submit proof of payment by fax (02-2186-3499) and contact customer service at 1600-0020.
	 */
	public static final SystemMessageId ILLEGAL_USE23;
	
	/**
	 * ID: 2043<br>
	 * Message: Cxg̏dʂ܂͌zĂ邽߁ANGXg̐Zł܂BCxgɃXy[XmۂĂ蒼ĂB<br>
	 * Message: &#36947;&#20855;&#28165;&#21934;&#30340;&#37325;&#37327;&#47;&#25976;&#37327;&#36229;&#36942;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#20219;&#21209;&#32080;&#31639;&#32113;&#35336;&#12290;&#35531;&#30906;&#20445;&#36947;&#20855;&#28165;&#21934;&#30340;&#31354;&#38291;&#24460;&#37325;&#26032;&#20877;&#35430;&#12290;<br>
	 * Message: You have exceeded your inventory volume limit and may not take this quest item. Please make room in your inventory and try again
	 */
	public static final SystemMessageId YOU_HAVE_EXCEEDED_YOUR_INVENTORY_VOLUME_LIMIT_AND_CANNOT_TAKE_THIS_QUESTITEM;
	
	/**
	 * ID: 2044<br>
	 * Message: lH[JȂAJEgłB<br>
	 * Message: &#20197;&#27492;&#24115;&#34399;&#28961;&#27861;&#38283;&#21855;&#20491;&#20154;&#24037;&#25151;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed to set up private manufacturing stores. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId CANT_SETUP_PRIVATE_WORKSHOP;
	
	/**
	 * ID: 2045<br>
	 * Message: lH[płȂAJEgłB<br>
	 * Message: &#20197;&#27492;&#24115;&#34399;&#28961;&#27861;&#20351;&#29992;&#20491;&#20154;&#24037;&#25151;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed to use private manufacturing stores. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId CANT_USE_PRIVATE_WORKSHOP;
	
	/**
	 * ID: 2046<br>
	 * Message: lXpłȂAJEgłB<br>
	 * Message: &#20197;&#27492;&#24115;&#34399;&#28961;&#27861;&#20351;&#29992;&#20491;&#20154;&#21830;&#24215;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed buy items from private stores. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId CANT_USE_PRIVATE_STORES;
	
	/**
	 * ID: 2047<br>
	 * Message: qɂpłȂAJEgłB<br>
	 * Message: &#20197;&#27492;&#24115;&#34399;&#28961;&#27861;&#20351;&#29992;&#34880;&#30431;&#20489;&#24235;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts aren't allowed to access clan warehouses. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId CANT_USE_CLAN_WH;
	
	/**
	 * ID: 2048<br>
	 * Message: $s1łłɎgpĂV[gJbg L[ƏdĂ܂BdĂV[gJbg L[ZbgA͂V[gJbg L[g܂B<br>
	 * Message: &#33287;&#12300;&#36;&#115;&#49;&#12301;&#20839;&#20351;&#29992;&#30340;&#24555;&#25463;&#37749;&#37325;&#35079;&#12290;&#37325;&#35373;&#37325;&#35079;&#30340;&#24555;&#25463;&#37749;&#24460;&#65292;&#35201;&#20351;&#29992;&#29694;&#22312;&#25152;&#36664;&#20837;&#30340;&#24555;&#25463;&#37749;&#21966;&#65311;<br>
	 * Message: The shortcut in use conflicts with $s1. Do you wish to reset the conflicting shortcuts and use the saved shortcut?
	 */
	public static final SystemMessageId CONFLICTING_SHORTCUT;
	
	/**
	 * ID: 2049<br>
	 * Message: V[gJbgL[KpăT[o[ɕۑ܂B낵łB<br>
	 * Message: &#23559;&#25033;&#29992;&#24555;&#25463;&#37749;&#20006;&#23559;&#20854;&#20786;&#23384;&#22312;&#20282;&#26381;&#22120;&#20839;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: The shortcut will be applied and saved in the server. Will you continue?
	 */
	public static final SystemMessageId CONFIRM_SHORTCUT_WILL_SAVED_ON_SERVER;
	
	/**
	 * ID: 2050<br>
	 * Message: $s1̌fgs܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#35430;&#22294;&#21319;&#26071;&#12290;<br>
	 * Message: $s1 Blood Pledge is trying to display a flag.
	 */
	public static final SystemMessageId S1_TRYING_RAISE_FLAG;
	
	/**
	 * ID: 2051<br>
	 * Message: qĺA܂l[WIĨvCɓӂĂȂ߁Al[WIĨvC͂ł܂BTCgihttp://lineage2.plaync.jp/jŃQ[ɓӂĂAxOCĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#23578;&#26410;&#20801;&#35377;&#21516;&#24847;&#20351;&#29992;&#22825;&#22530;&#73;&#73;&#36938;&#25138;&#26381;&#21209;&#12290;&#92;&#110;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30331;&#20837;&#24115;&#25142;&#23494;&#30908;&#20006;&#21855;&#29992;&#36938;&#25138;&#24460;&#20877;&#27425;&#36899;&#32218;&#12290;<br>
	 * Message: You must accept the User Agreement before this account can access Lineage II.
	 */
	public static final SystemMessageId MUST_ACCEPT_AGREEMENT;
	
	/**
	 * ID: 2052<br>
	 * Message: ql̃AJEg͕ی҂̓ӂ𓾂Ă܂B\nی҂̓ӂς܂ŁAxOCĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30446;&#21069;&#23578;&#26410;&#24471;&#21040;&#27861;&#23450;&#20195;&#29702;&#20154;&#30340;&#21516;&#24847;&#12290;&#92;&#110;&#35531;&#22312;&#24471;&#21040;&#27861;&#23450;&#20195;&#29702;&#20154;&#30340;&#21516;&#24847;&#24460;&#20877;&#27425;&#36899;&#32218;&#12290;<br>
	 * Message: A guardian's consent is required before this account can be used to play Lineage II.
	 */
	public static final SystemMessageId NEED_CONSENT_TO_PLAY_THIS_ACCOUNT;
	
	/**
	 * ID: 2053<br>
	 * Message: ql̃AJEǵAQ[ɓӂĂȂA\ƂȂĂ܂B\nQ[ɓӂ邩A\LZŁAxOCĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30446;&#21069;&#27491;&#22312;&#34389;&#26044;&#25764;&#22238;&#36938;&#25138;&#21516;&#24847;&#25110;&#21034;&#38500;&#26371;&#21729;&#36039;&#26684;&#20043;&#29376;&#24907;&#20013;&#12290;&#92;&#110;&#35531;&#22312;&#21462;&#28040;&#25764;&#22238;&#36938;&#25138;&#21516;&#24847;&#25110;&#21034;&#38500;&#26371;&#21729;&#36039;&#26684;&#24460;&#20877;&#27425;&#36899;&#32218;&#12290;<br>
	 * Message: This account has declined the User Agreement or is pending a withdrawl request.
	 */
	public static final SystemMessageId ACCOUNT_DECLINED_AGREEMENT_OR_PENDING;
	
	/**
	 * ID: 2054<br>
	 * Message: ql̃AJEǵAׂẴT[rX̂pĂԂłB\nڂ͌TCgihttp://lineage2.plaync.jp/j܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30446;&#21069;&#34389;&#26044;&#38480;&#21046;&#25152;&#26377;&#30340;&#27402;&#38480;&#12290;&#92;&#110;&#35443;&#24773;&#35531;&#27965;&#23458;&#26381;&#20013;&#24515;&#65288;&#84;&#101;&#108;&#46;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#54;&#54;&#54;&#65289;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: This account has been suspended.
	 */
	public static final SystemMessageId ACCOUNT_SUSPENDED;
	
	/**
	 * ID: 2055<br>
	 * Message: ql̃AJEǵAׂẴQ[ T[rX̂płȂ悤ɐĂ܂B\nڂ͌TCgihttp://lineage2.plaync.jp/j܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30446;&#21069;&#34389;&#26044;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#92;&#110;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended from all game services.
	 */
	public static final SystemMessageId ACCOUNT_SUSPENDED_FROM_ALL_SERVICES;
	
	/**
	 * ID: 2056<br>
	 * Message: ql̃AJEg͓AJEgɕύXꂽ߁Aڑł܂B\nύX̓AJEgłxOCĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#24050;&#34987;&#36681;&#25563;&#28858;&#112;&#108;&#97;&#121;&#110;&#99;&#24115;&#34399;&#65292;&#22240;&#27492;&#28961;&#27861;&#36899;&#32218;&#12290;&#92;&#110;&#35531;&#21033;&#29992;&#24050;&#36681;&#25563;&#30340;&#112;&#108;&#97;&#121;&#110;&#99;&#24115;&#34399;&#20877;&#27425;&#36899;&#32218;&#12290;<br>
	 * Message: Your account has been converted to an integrated account, and is unable to be accessed.
	 */
	public static final SystemMessageId ACCOUNT_CONVERTED;
	
	/**
	 * ID: 2057<br>
	 * Message: Ȃ$c1Ւf܂B<br>
	 * Message: &#24744;&#24050;&#38548;&#32085;&#12300;&#36;&#99;&#49;&#12301;&#12290;<br>
	 * Message: You have blocked $c1.
	 */
	public static final SystemMessageId BLOCKED_C1;
	
	/**
	 * ID: 2058<br>
	 * Message: łɕϐgԂł邽߁Aϐgł܂B<br>
	 * Message: &#24050;&#34389;&#26044;&#35722;&#36523;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#35722;&#36523;&#28858;&#20854;&#20182;&#22411;&#24907;&#12290;<br>
	 * Message: You are already polymorphed and cannot polymorph again.
	 */
	public static final SystemMessageId YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN;
	
	/**
	 * ID: 2059<br>
	 * Message: 肪߁Aϐgł܂Bʂ̏ꏊɈړĂxsĂB<br>
	 * Message: &#21608;&#22285;&#30340;&#31354;&#38291;&#22826;&#36942;&#29433;&#23567;&#65292;&#22240;&#27492;&#28961;&#27861;&#35722;&#36523;&#12290;&#35531;&#31227;&#33267;&#20854;&#20182;&#22320;&#26041;&#24460;&#65292;&#20877;&#22039;&#35430;&#35722;&#36523;&#12290;<br>
	 * Message: The nearby area is too narrow for you to polymorph. Please move to another area and try to polymorph again.
	 */
	public static final SystemMessageId AREA_UNSUITABLE_FOR_POLYMORPH;
	
	/**
	 * ID: 2060<br>
	 * Message: ̒ł͂]݂̎pɕϐgł܂B<br>
	 * Message: &#22312;&#27700;&#20013;&#28961;&#27861;&#35722;&#36523;&#28858;&#24819;&#35201;&#35722;&#25104;&#30340;&#35722;&#36523;&#39636;&#12290;<br>
	 * Message: You cannot polymorph into the desired form in water.
	 */
	public static final SystemMessageId YOU_CANNOT_POLYMORPH_INTO_THE_DESIRED_FORM_IN_WATER;
	
	/**
	 * ID: 2061<br>
	 * Message: ϐgǂĂ邽ߕϐgł܂B<br>
	 * Message: &#35722;&#36523;&#24460;&#36986;&#30151;&#23578;&#22312;&#25345;&#32396;&#65292;&#22240;&#27492;&#28961;&#27861;&#35722;&#36523;&#12290;<br>
	 * Message: You are still under transform penalty and cannot be polymorphed.
	 */
	public static final SystemMessageId CANT_MORPH_DUE_TO_MORPH_PENALTY;
	
	/**
	 * ID: 2062<br>
	 * Message: bAybgԂł͕ϐgł܂B<br>
	 * Message: &#22312;&#21484;&#21914;&#20351;&#39764;&#47;&#23541;&#29289;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#35722;&#36523;&#12290;<br>
	 * Message: You cannot polymorph when you have summoned a servitor/pet.
	 */
	public static final SystemMessageId YOU_CANNOT_POLYMORPH_WHEN_YOU_HAVE_SUMMONED_A_SERVITOR;
	
	/**
	 * ID: 2063<br>
	 * Message: ybgɏĂԂł͕ϐgł܂B<br>
	 * Message: &#22312;&#39438;&#20056;&#23541;&#29289;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#35722;&#36523;&#12290;<br>
	 * Message: You cannot polymorph while riding a pet.
	 */
	public static final SystemMessageId YOU_CANNOT_POLYMORPH_WHILE_RIDING_A_PET;
	
	/**
	 * ID: 2064<br>
	 * Message: ȃXL̉e󂯂ĂԂ͕ϐgł܂B<br>
	 * Message: &#22312;&#25509;&#21463;&#29305;&#27530;&#25216;&#33021;&#30340;&#24433;&#38911;&#26178;&#65292;&#28961;&#27861;&#35722;&#36523;&#12290;<br>
	 * Message: You cannot polymorph while under the effect of a special skill
	 */
	public static final SystemMessageId CANT_MORPH_WHILE_UNDER_SPECIAL_SKILL_EFFECT;
	
	/**
	 * ID: 2065<br>
	 * Message: YACe͉ł܂B<br>
	 * Message: &#35442;&#36947;&#20855;&#28961;&#27861;&#21368;&#38500;&#12290;<br>
	 * Message: That item cannot be taken off
	 */
	public static final SystemMessageId ITEM_CANNOT_BE_TAKEN_OFF;
	
	/**
	 * ID: 2066<br>
	 * Message: Y͍̕Uł܂B<br>
	 * Message: &#35442;&#27494;&#22120;&#28961;&#27861;&#36914;&#34892;&#25915;&#25802;&#12290;<br>
	 * Message: That weapon cannot perform any attacks.
	 */
	public static final SystemMessageId THAT_WEAPON_CANT_ATTACK;
	
	/**
	 * ID: 2067<br>
	 * Message: Y͕̕XLȊÔ̑̃XL͎gpł܂B<br>
	 * Message: &#35442;&#27494;&#22120;&#19981;&#33021;&#20351;&#29992;&#38500;&#27494;&#22120;&#25216;&#33021;&#20197;&#22806;&#30340;&#20854;&#20182;&#25216;&#33021;&#12290;<br>
	 * Message: That weapon cannot use any other skill except the weapon's skill.
	 */
	public static final SystemMessageId WEAPON_CAN_USE_ONLY_WEAPON_SKILL;
	
	/**
	 * ID: 2068<br>
	 * Message: G`g XL̃AgCɕKvȃACesĂ܂B<br>
	 * Message: &#21453;&#26119;&#33775;&#25216;&#33021;&#26178;&#25152;&#38656;&#30340;&#36947;&#20855;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have all of the items needed to untrain the enchant skill.
	 */
	public static final SystemMessageId YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_UNTRAIN_SKILL_ENCHANT;
	
	/**
	 * ID: 2069<br>
	 * Message: G`g XL̃AgCɐ܂BG`g XL$s1̃G`gLv1ቺ܂B<br>
	 * Message: &#21453;&#26119;&#33775;&#25216;&#33021;&#25104;&#21151;&#12290;&#26119;&#33775;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#26119;&#33775;&#76;&#118;&#19979;&#38477;&#49;&#12290;<br>
	 * Message: Untrain of enchant skill was successful. Current level of enchant skill $s1 has been decreased by 1.
	 */
	public static final SystemMessageId UNTRAIN_SUCCESSFUL_SKILL_S1_ENCHANT_LEVEL_DECREASED_BY_ONE;
	
	/**
	 * ID: 2070<br>
	 * Message: G`g XL̃AgCɐ܂BG`g XL$s1̃G`gLv0ɂȂG`g XL܂B<br>
	 * Message: &#26119;&#33775;&#25216;&#33021;&#30340;&#21453;&#26119;&#33775;&#25104;&#21151;&#12290;&#26119;&#33775;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#26119;&#33775;&#76;&#118;&#35722;&#28858;&#48;&#65292;&#22240;&#27492;&#26119;&#33775;&#25216;&#33021;&#23559;&#34987;&#21021;&#22987;&#21270;&#65292;&#20006;&#35722;&#26356;&#28858;&#22522;&#26412;&#25216;&#33021;&#12290;<br>
	 * Message: Untrain of enchant skill was successful. Current level of enchant skill $s1 became 0 and enchant skill will be initialized.
	 */
	public static final SystemMessageId UNTRAIN_SUCCESSFUL_SKILL_S1_ENCHANT_LEVEL_RESETED;
	
	/**
	 * ID: 2071<br>
	 * Message: G`g XL [g `FWɕKvȃACe܂B<br>
	 * Message: &#35722;&#26356;&#26119;&#33775;&#36335;&#24465;&#26178;&#25152;&#38656;&#30340;&#36947;&#20855;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have all of the items needed to enchant skill route change.
	 */
	public static final SystemMessageId YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_CHANGE_SKILL_ENCHANT_ROUTE;
	
	/**
	 * ID: 2072<br>
	 * Message: G`g XL [g `FWɐ܂BG`g XL$s1Lv$s2ቺ܂B<br>
	 * Message: &#35722;&#26356;&#26119;&#33775;&#36335;&#24465;&#25104;&#21151;&#12290;&#26119;&#33775;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#76;&#118;&#38477;&#33267;&#12300;&#36;&#115;&#50;&#12301;&#12290;<br>
	 * Message: Enchant skill route change was successful. Lv of enchant skill $s1 has been decreased by $s2.
	 */
	public static final SystemMessageId SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WAS_DECREASED_BY_S2;
	
	/**
	 * ID: 2073<br>
	 * Message: G`g XL [g `FWɐ܂BG`gXL$s1Lvێ܂B<br>
	 * Message: &#35722;&#26356;&#26119;&#33775;&#36335;&#24465;&#25104;&#21151;&#12290;&#23559;&#32173;&#25345;&#26119;&#33775;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#76;&#118;&#12290;<br>
	 * Message: Enchant skill route change was successful. Lv of enchant skill $s1 will remain.
	 */
	public static final SystemMessageId SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WILL_REMAIN;
	
	/**
	 * ID: 2074<br>
	 * Message: XL G`gɎs܂BG`g XL$s1̃G`gLvێ܂B<br>
	 * Message: &#26119;&#33775;&#25216;&#33021;&#22833;&#25943;&#12290;&#23559;&#32173;&#25345;&#26119;&#33775;&#25216;&#33021;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#26119;&#33775;&#76;&#118;&#12290;<br>
	 * Message: Skill enchant failed. Current level of enchant skill $s1 will remain unchanged.
	 */
	public static final SystemMessageId SKILL_ENCHANT_FAILED_S1_LEVEL_WILL_REMAIN;
	
	/**
	 * ID: 2075<br>
	 * Message: Ԃł͂܂B<br>
	 * Message: &#29694;&#22312;&#19981;&#26159;&#31478;&#36067;&#26399;&#38291;&#12290;<br>
	 * Message: It is not auction period.
	 */
	public static final SystemMessageId NO_AUCTION_PERIOD;
	
	/**
	 * ID: 2076<br>
	 * Message: ōDi1000𒴂邽߁ADł܂B<br>
	 * Message: &#26368;&#39640;&#25307;&#27161;&#20729;&#36229;&#36942;&#49;&#44;&#48;&#48;&#48;&#20740;&#65292;&#22240;&#27492;&#28961;&#27861;&#25307;&#27161;&#12290;<br>
	 * Message: Bidding is not allowed because the maximum bidding price exceeds 100 billion.
	 */
	public static final SystemMessageId BID_CANT_EXCEED_100_BILLION;
	
	/**
	 * ID: 2077<br>
	 * Message: ōDi荂zœDĂB<br>
	 * Message: &#35201;&#25307;&#27161;&#36229;&#20986;&#26368;&#39640;&#25307;&#27161;&#20729;&#30340;&#37329;&#38989;&#25165;&#34892;&#12290;<br>
	 * Message: Your bid must be higher than the current highest bid.
	 */
	public static final SystemMessageId BID_MUST_BE_HIGHER_THAN_CURRENT_BID;
	
	/**
	 * ID: 2078<br>
	 * Message: DɕKvȃAfi܂B<br>
	 * Message: &#36914;&#34892;&#25307;&#27161;&#30340;&#37329;&#24163;&#19981;&#36275;&#12290;<br>
	 * Message: You do not have enough adena for this bid.
	 */
	public static final SystemMessageId NOT_ENOUGH_ADENA_FOR_THIS_BID;
	
	/**
	 * ID: 2079<br>
	 * Message: łɍōzDƂȂADƂȂz܂B<br>
	 * Message: &#24050;&#26377;&#25307;&#27161;&#26368;&#39640;&#20729;&#25110;&#26377;&#27969;&#27161;&#30340;&#37329;&#38989;&#12290;<br>
	 * Message: You currently have the highest bid, but the reserve has not been met.
	 */
	public static final SystemMessageId HIGHEST_BID_BUT_RESERVE_NOT_MET;
	
	/**
	 * ID: 2080<br>
	 * Message: ʓD҂ɂDLZ܂B<br>
	 * Message: &#22240;&#20986;&#29694;&#21898;&#20729;&#26356;&#39640;&#30340;&#20154;&#65292;&#22240;&#27492;&#25307;&#27161;&#34987;&#21462;&#28040;&#12290;<br>
	 * Message: You have been outbid.
	 */
	public static final SystemMessageId YOU_HAVE_BEEN_OUTBID;
	
	/**
	 * ID: 2081<br>
	 * Message: DƂȂz܂B<br>
	 * Message: &#27794;&#26377;&#27969;&#27161;&#30340;&#37329;&#38989;&#12290;<br>
	 * Message: There are no funds presently due to you.
	 */
	public static final SystemMessageId NO_FUNDS_DUE;
	
	/**
	 * ID: 2082<br>
	 * Message: Cxg̃Afiel𒴂܂B<br>
	 * Message: &#36947;&#20855;&#28165;&#21934;&#30340;&#37329;&#24163;&#24050;&#36229;&#36942;&#38480;&#21046;&#12290;<br>
	 * Message: You have exceeded the total amount of adena allowed in inventory.
	 */
	public static final SystemMessageId EXCEEDED_MAX_ADENA_AMOUNT_IN_INVENTORY;
	
	/**
	 * ID: 2083<br>
	 * Message: n܂܂B<br>
	 * Message: &#31478;&#36067;&#21363;&#23559;&#38283;&#22987;&#12290;<br>
	 * Message: The auction has begun.
	 */
	public static final SystemMessageId AUCTION_BEGUN;
	
	/**
	 * ID: 2084<br>
	 * Message: vǂɓǦN܂B<br>
	 * Message: &#25973;&#23565;&#34880;&#30431;&#20837;&#20405;&#35201;&#22622;&#65281;<br>
	 * Message: Enemy Blood Pledges have intruded into the fortress.
	 */
	public static final SystemMessageId ENEMIES_INTRUDED_FORTRESS;
	
	/**
	 * ID: 2085<br>
	 * Message: ꂽLԂł͋тƃg[h `bg͗pł܂B<br>
	 * Message: &#25345;&#26377;&#21463;&#35419;&#21650;&#30340;&#27494;&#22120;&#26178;&#65292;&#28961;&#27861;&#21033;&#29992;&#12300;&#21898;&#21483;&#12301;&#21644;&#12300;&#20132;&#26131;&#38971;&#36947;&#12301;&#12290;<br>
	 * Message: Shout and trade chatting cannot be used while possessing a cursed weapon.
	 */
	public static final SystemMessageId SHOUT_AND_TRADE_CHAT_CANNOT_BE_USED_WHILE_POSSESSING_CURSED_WEAPON;
	
	/**
	 * ID: 2086<br>
	 * Message: $s1Ƀ[U[$c2ɂĂBOTI܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#24460;&#23559;&#32080;&#26463;&#29992;&#25142;&#12300;&#36;&#99;&#50;&#12301;&#30340;&#66;&#79;&#84;&#27298;&#26597;&#12290;<br>
	 * Message: Search on user $s2 for third-party program use will be completed in $s1 minute(s).
	 */
	public static final SystemMessageId SEARCH_ON_S2_FOR_BOT_USE_COMPLETED_IN_S1_MINUTES;
	
	/**
	 * ID: 2087<br>
	 * Message: vǂUĂ܂I<br>
	 * Message: &#35201;&#22622;&#36973;&#21463;&#25915;&#25802;&#65281;<br>
	 * Message: A fortress is under attack!
	 */
	public static final SystemMessageId A_FORTRESS_IS_UNDER_ATTACK;
	
	/**
	 * ID: 2088<br>
	 * Message: vǐJn܂Ŏc$s1łB<br>
	 * Message: &#36317;&#38626;&#35201;&#22622;&#25136;&#38283;&#22987;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: $s1 minute(s) until the fortress battle starts.
	 */
	public static final SystemMessageId S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS;
	
	/**
	 * ID: 2089<br>
	 * Message: vǐJn܂Ŏc$s1błB<br>
	 * Message: &#36317;&#38626;&#35201;&#22622;&#25136;&#38283;&#22987;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: $s1 minute(s) until the fortress battle starts.
	 */
	public static final SystemMessageId S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS;
	
	/**
	 * ID: 2090<br>
	 * Message: $s1̗vǐ킪n܂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#35201;&#22622;&#25136;&#24050;&#38283;&#22987;&#12290;<br>
	 * Message: The fortress battle $s1 has begun.
	 */
	public static final SystemMessageId THE_FORTRESS_BATTLE_S1_HAS_BEGUN;
	
	/**
	 * ID: 2091<br>
	 * Message: ql̃AJEg̓pX[h̕ύXȂΐڑł܂B\nTCgihttp://lineage2.plaync.jp/jŃpX[hύXŁAx蒼ĂB<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#38920;&#35722;&#26356;&#23494;&#30908;&#20197;&#21450;&#23494;&#30908;&#25552;&#31034;&#24460;&#25165;&#33021;&#36899;&#32218;&#12290;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#35722;&#26356;&#23494;&#30908;&#20197;&#21450;&#23494;&#30908;&#25552;&#31034;&#24460;&#25165;&#33021;&#20351;&#29992;&#26381;&#21209;&#12290;<br>
	 * Message: Your account can only be used after changing your password and quiz.
	 */
	public static final SystemMessageId CHANGE_PASSWORT_FIRST;
	
	/**
	 * ID: 2092<br>
	 * Message: DƂȂz邽ߓDł܂B<br>
	 * Message: &#26377;&#27969;&#27161;&#30340;&#37329;&#38989;&#65292;&#22240;&#27492;&#28961;&#27861;&#25307;&#27161;&#12290;<br>
	 * Message: You cannot bid due to a passed-in price.
	 */
	public static final SystemMessageId CANNOT_BID_DUE_TO_PASSED_IN_PRICE;
	
	/**
	 * ID: 2093<br>
	 * Message: ̗DƂȂz$s1AfiłBDƂȂzԋ܂B<br>
	 * Message: &#25293;&#36067;&#27969;&#27161;&#37329;&#38989;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#12290;&#35201;&#25910;&#22238;&#25293;&#36067;&#27969;&#27161;&#37329;&#38989;&#21966;&#65311;<br>
	 * Message: The passed-in price is $s1 adena. Would you like to return the passed-in price?
	 */
	public static final SystemMessageId PASSED_IN_PRICE_IS_S1_ADENA_WOULD_YOU_LIKE_TO_RETURN_IT;
	
	/**
	 * ID: 2094<br>
	 * Message: ̃[U[włB΂炭oĂxB<br>
	 * Message: &#20854;&#20182;&#29992;&#25142;&#27491;&#22312;&#36092;&#36023;&#65292;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: Another user is purchasing. Please try again later.
	 */
	public static final SystemMessageId ANOTHER_USER_PURCHASING_TRY_AGAIN_LATER;
	
	/**
	 * ID: 2095<br>
	 * Message: тłȂAJEgłB<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#21898;&#21483;&#38971;&#36947;&#30340;&#24115;&#34399;&#12290;<br>
	 * Message: Some Lineage II features have been limited for free trials. Trial accounts have limited chatting capabilities. To unlock all of the features of Lineage II, purchase the full version today.
	 */
	public static final SystemMessageId ACCOUNT_CANNOT_SHOUT;
	
	/**
	 * ID: 2096<br>
	 * Message: $c1 łȂʒuɂ邽ߐisł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#20301;&#26044;&#28961;&#27861;&#36914;&#20837;&#30340;&#20301;&#32622;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#12290;<br>
	 * Message: $c1 is in a location which cannot be entered, therefore it cannot be processed.
	 */
	public static final SystemMessageId C1_IS_IN_LOCATION_THAT_CANNOT_BE_ENTERED;
	
	/**
	 * ID: 2097<br>
	 * Message: $c1 ̃xȂߓł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#31561;&#32026;&#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: $c1's level requirement is not sufficient and cannot be entered.
	 */
	public static final SystemMessageId C1_LEVEL_REQUIREMENT_NOT_SUFFICIENT;
	
	/**
	 * ID: 2098<br>
	 * Message: $c1 ̃NGXgȂߓł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#20219;&#21209;&#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: $c1's quest requirement is not sufficient and cannot be entered.
	 */
	public static final SystemMessageId C1_QUEST_REQUIREMENT_NOT_SUFFICIENT;
	
	/**
	 * ID: 2099<br>
	 * Message: $c1 ̃ACeȂߓł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#36947;&#20855;&#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: $c1's item requirement is not sufficient and cannot be entered.
	 */
	public static final SystemMessageId C1_ITEM_REQUIREMENT_NOT_SUFFICIENT;
	
	/**
	 * ID: 2100<br>
	 * Message: $c1 ē\ԂɂȂȂ߁Ał܂B<br>
	 * Message: &#23578;&#26410;&#36948;&#21040;&#12300;&#36;&#99;&#49;&#12301;&#30340;&#20877;&#20837;&#22580;&#26178;&#38291;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: $c1 may not re-enter yet.
	 */
	public static final SystemMessageId C1_MAY_NOT_REENTER_YET;
	
	/**
	 * ID: 2101<br>
	 * Message: ݃p[eBԂł͂Ȃߓł܂B<br>
	 * Message: &#30446;&#21069;&#19981;&#26159;&#38538;&#20237;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: You are not currently in a party, so you cannot enter.
	 */
	public static final SystemMessageId NOT_IN_PARTY_CANT_ENTER;
	
	/**
	 * ID: 2102<br>
	 * Message: Yp[eB𒴂߁Ał܂B<br>
	 * Message: &#35442;&#38538;&#20237;&#30340;&#20837;&#22580;&#25104;&#21729;&#25976;&#24050;&#36229;&#36942;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: You cannot enter due to the party having exceeded the limit.
	 */
	public static final SystemMessageId PARTY_EXCEEDED_THE_LIMIT_CANT_ENTER;
	
	/**
	 * ID: 2103<br>
	 * Message: ݁AA`lɏĂȂߓł܂B<br>
	 * Message: &#30446;&#21069;&#27794;&#26377;&#38584;&#23660;&#26044;&#32879;&#21512;&#38971;&#36947;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: You cannot enter because you are not associated with the current command channel.
	 */
	public static final SystemMessageId NOT_IN_COMMAND_CHANNEL_CANT_ENTER;
	
	/**
	 * ID: 2104<br>
	 * Message: YCX^g ][̍ő吶𒴂߁Ał܂B<br>
	 * Message: &#24050;&#36229;&#36942;&#21109;&#31435;&#21363;&#26178;&#22320;&#21312;&#30340;&#19978;&#38480;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: The maximum number of instance zones has been exceeded. You cannot enter.
	 */
	public static final SystemMessageId MAXIMUM_INSTANCE_ZONE_NUMBER_EXCEEDED_CANT_ENTER;
	
	/**
	 * ID: 2105<br>
	 * Message: ̃CX^g ][ɓꂵԂł邽߁AY_Wɓł܂B<br>
	 * Message: &#30446;&#21069;&#24050;&#26377;&#36914;&#20837;&#21363;&#26178;&#22320;&#21312;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#35442;&#27934;&#31391;&#12290;<br>
	 * Message: You have entered another instance zone, therefore you cannot enter corresponding dungeon.
	 */
	public static final SystemMessageId ALREADY_ENTERED_ANOTHER_INSTANCE_CANT_ENTER;
	
	/**
	 * ID: 2106<br>
	 * Message: Y_W̗pԏI܂Ŏc$s1łBԂIƃ_W̊O֋ړ܂B<br>
	 * Message: &#35442;&#27934;&#31391;&#30340;&#20351;&#29992;&#26399;&#38480;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#65292;&#26178;&#38291;&#21040;&#26178;&#65292;&#23559;&#34987;&#24375;&#21046;&#31227;&#21205;&#21040;&#27934;&#31391;&#22806;&#37096;&#12290;<br>
	 * Message: This dungeon will expire in $s1 minute(s). You will be forced out of the dungeon when the time expires.
	 */
	public static final SystemMessageId DUNGEON_EXPIRES_IN_S1_MINUTES;
	
	/**
	 * ID: 2107<br>
	 * Message: CX^g ][$s1ɍ폜AYԏIɃ_W̊O֋ړ܂B<br>
	 * Message: &#21363;&#26178;&#22320;&#21312;&#23559;&#26371;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#24460;&#34987;&#21034;&#38500;&#65292;&#26178;&#38291;&#21040;&#26178;&#65292;&#23559;&#34987;&#24375;&#21046;&#31227;&#21205;&#21040;&#27934;&#31391;&#22806;&#37096;&#12290;<br>
	 * Message: This instance zone will be terminated in $s1 minute(s). You will be forced out of the dungeon when the time expires.
	 */
	public static final SystemMessageId INSTANCE_ZONE_TERMINATES_IN_S1_MINUTES;
	
	/**
	 * ID: 2108<br>
	 * Message: ql̃AJEǵAs[eBeB̗pF߂ꂽ10ԁAQ[T[rXׂĂ̂pĂ܂B㓯l̈ᔽsׂmFꂽꍇAivɐ܂̂łӂBڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#20351;&#29992;&#38750;&#26412;&#20844;&#21496;&#25480;&#27402;&#20043;&#38750;&#27861;&#31243;&#24335;&#65292;&#22240;&#27492;&#24050;&#38480;&#21046;&#20351;&#29992;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#65289;&#21033;&#29992;&#23458;&#26381;&#20013;&#24515;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE24;
	
	/**
	 * ID: 2109<br>
	 * Message: T[o[ꂽׁAłgp̃LN^[$s1́A̖OƏdĂ܂BύXLN^[͂ĂB<br>
	 * Message: &#20282;&#26381;&#22120;&#32147;&#21512;&#20341;&#24460;&#65292;&#36942;&#21435;&#25152;&#20351;&#29992;&#30340;&#35282;&#33394;&#12300;&#36;&#115;&#49;&#12301;&#33287;&#20854;&#20182;&#21517;&#23383;&#37325;&#35079;&#12290;&#35531;&#36664;&#20837;&#35201;&#35722;&#26356;&#30340;&#35282;&#33394;&#21517;&#31281;&#12290;<br>
	 * Message: The server has been integrated, and your character, $s1, has overlapped with another name. Please enter a new name for your character
	 */
	public static final SystemMessageId CHARACTER_NAME_OVERLAPPING_RENAME_CHARACTER;
	
	/**
	 * ID: 2110<br>
	 * Message: ̖͂O͊ɑ݂Ă邩ApłȂOłBύXLN^[x͂B<br>
	 * Message: &#24744;&#36664;&#20837;&#30340;&#21517;&#23383;&#24050;&#26377;&#37325;&#35079;&#25110;&#28961;&#27861;&#20351;&#29992;&#12290;&#35531;&#20877;&#27425;&#36664;&#20837;&#35201;&#35722;&#26356;&#30340;&#35282;&#33394;&#21517;&#31281;&#12290;<br>
	 * Message: This character name already exists or is an invalid name. Please enter a new name
	 */
	public static final SystemMessageId CHARACTER_NAME_INVALID_RENAME_CHARACTER;
	
	/**
	 * ID: 2111<br>
	 * Message: w̃V[gJbgL[͂܂B<br>
	 * Message: &#35531;&#36664;&#20837;&#35201;&#25351;&#23450;&#30340;&#24555;&#25463;&#37749;&#12290;<br>
	 * Message: Enter a shortcut to assign.
	 */
	public static final SystemMessageId ENTER_SHORTCUT_TO_ASSIGN;
	
	/**
	 * ID: 2112<br>
	 * Message: ⏕L[CTRLAALTASHIFTL[gpłAxɓ̕⏕L[͂ł܂B\n) uCTRL + ALT + Av<br>
	 * Message: &#36628;&#21161;&#37749;&#21487;&#20351;&#29992;&#67;&#116;&#114;&#108;&#12289;&#65;&#108;&#116;&#12289;&#83;&#104;&#105;&#102;&#116;&#37749;&#65292;&#19968;&#27425;&#21487;&#36664;&#20837;&#20841;&#20491;&#36628;&#21161;&#37749;&#12290;&#92;&#110;&#32;&#20363;&#65289;&#12300;&#67;&#116;&#114;&#108;&#43;&#65;&#108;&#116;&#43;&#65;&#12301;<br>
	 * Message: Sub-key can be CTRL, ALT, SHIFT and you may enter two sub-keys at a time.
	 */
	public static final SystemMessageId SUBKEY_EXPLANATION1;
	
	/**
	 * ID: 2113<br>
	 * Message: g ⏕L[ [hłCTRLAALTASHIFTL[⏕L[ƂĊpłAʃV[gJbgL[ [hł͕⏕L[ALT̂ݎgpł܂B<br>
	 * Message: &#22312;&#25844;&#20805;&#36628;&#21161;&#37749;&#27169;&#24335;&#21487;&#23559;&#67;&#116;&#114;&#108;&#12289;&#65;&#108;&#116;&#12289;&#83;&#104;&#105;&#102;&#116;&#37749;&#27963;&#29992;&#28858;&#36628;&#21161;&#37749;&#65292;&#32780;&#22312;&#19968;&#33324;&#24555;&#25463;&#37749;&#27169;&#24335;&#21482;&#33021;&#23559;&#65;&#108;&#116;&#20351;&#29992;&#28858;&#36628;&#21161;&#37749;&#12290;<br>
	 * Message: (Sub key explanation)
	 */
	public static final SystemMessageId SUBKEY_EXPLANATION2;
	
	/**
	 * ID: 2114<br>
	 * Message: g ⏕L[ [hɐݒ肷ƁACtrlShiftɎw肳ĂUƂ̏ł̍UAlt + QAlt + EɕύXACTRLL[SHIFTL[ʂ̃V[gJbgL[̎wL[Ŏgp\ƂȂ悤ɕύX܂B낵łB<br>
	 * Message: &#33509;&#35373;&#23450;&#28858;&#25844;&#20805;&#36628;&#21161;&#37749;&#27169;&#24335;&#26178;&#65292;&#30446;&#21069;&#34987;&#25351;&#23450;&#28858;&#67;&#116;&#114;&#108;&#21644;&#83;&#104;&#105;&#102;&#116;&#30340;&#24375;&#21046;&#25915;&#25802;&#21644;&#22266;&#23450;&#20301;&#32622;&#25915;&#25802;&#65292;&#23559;&#35722;&#26356;&#28858;&#65;&#108;&#116;&#43;&#81;&#21644;&#65;&#108;&#116;&#43;&#69;&#65292;&#32780;&#19988;&#67;&#116;&#114;&#108;&#37749;&#21644;&#83;&#104;&#105;&#102;&#116;&#37749;&#23559;&#35722;&#26356;&#28858;&#20854;&#23427;&#21487;&#20351;&#29992;&#30340;&#24555;&#25463;&#37749;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: Forced attack and stand-in-place attacks assigned previously to Ctrl and Shift will be changed to Alt + Q and Alt + E when set as expanded sub-key mode, and CTRL and SHIFT will be available to assign to another shortcut. Will you continue?
	 */
	public static final SystemMessageId SUBKEY_EXPLANATION3;
	
	/**
	 * ID: 2115<br>
	 * Message: ql̃AJEgNCRCɊւoOpƂF߂ꂽ߁ApĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#24801;&#29992;&#78;&#67;&#111;&#105;&#110;&#30456;&#38364;&#33261;&#34802;&#65288;&#66;&#85;&#71;&#65289;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#12290;&#35443;&#24773;&#35531;&#27965;&#23458;&#26381;&#20013;&#24515;&#65288;&#84;&#101;&#108;&#46;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#54;&#54;&#54;&#65289;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE25;
	
	/**
	 * ID: 2116<br>
	 * Message: ql̃AJEg͖ŎxꂽRCpƂF߂ꂽ߂pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#24801;&#29992;&#20813;&#36027;&#30332;&#36865;&#30340;&#78;&#67;&#111;&#105;&#110;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#12290;&#35443;&#24773;&#35531;&#27965;&#23458;&#26381;&#20013;&#24515;&#65288;&#84;&#101;&#108;&#46;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#54;&#54;&#54;&#65289;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE26;
	
	/**
	 * ID: 2117<br>
	 * Message: ql̃AJEg͑l̖`𗘗pȂǂF߂ꂽ߁AꎞIɃQ[T[rX̂pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#28041;&#23244;&#30428;&#29992;&#20182;&#20154;&#36039;&#26009;&#20358;&#21152;&#20837;&#26371;&#21729;&#65292;&#22240;&#27492;&#26283;&#26178;&#38480;&#21046;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35442;&#24773;&#27841;&#33509;&#19981;&#23660;&#23526;&#65292;&#35531;&#36879;&#36942;&#26412;&#20154;&#35469;&#35657;&#20358;&#20316;&#30906;&#35469;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE27;
	
	/**
	 * ID: 2118<br>
	 * Message: ql̃AJEg͌ς̓pF߂ꂽ߁AQ[T[rXׂĂ̂pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30428;&#29992;&#20182;&#20154;&#21517;&#32681;&#20351;&#29992;&#20786;&#20540;&#30456;&#38364;&#26381;&#21209;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE28;
	
	/**
	 * ID: 2119<br>
	 * Message: ql̃AJEg͌ς̓pF߂ꂽ߁AQ[T[rXׂĂ̂pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#26377;&#22312;&#36914;&#34892;&#24115;&#34399;&#20132;&#26131;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE29;
	
	/**
	 * ID: 2120<br>
	 * Message: ql̃AJEg͕s[eBeB̗pF߂ꂽ߁A10ԃQ[T[rX̗pׂĐĂ܂B㓯l̈ᔽsׂmFꂽꍇ͉ivɐ܂̂łӂBڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#20351;&#29992;&#38750;&#27861;&#31243;&#24335;&#65292;&#22240;&#27492;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#34987;&#38480;&#21046;&#20351;&#29992;&#49;&#48;&#22825;&#12290;&#26085;&#24460;&#33509;&#30332;&#29694;&#30456;&#21516;&#24773;&#24418;&#65292;&#23559;&#26371;&#27704;&#20037;&#38480;&#21046;&#36938;&#25138;&#26381;&#21209;&#65292;&#35531;&#30041;&#24847;&#27492;&#40670;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#65288;&#22825;&#22530;&#73;&#73;&#65289;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE30;
	
	/**
	 * ID: 2121<br>
	 * Message: ql̃AJEg͕s[eBeB̗pF߂ꂽ߁AQ[T[rXׂĂ̗pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#20351;&#29992;&#38750;&#27861;&#31243;&#24335;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#65288;&#22825;&#22530;&#73;&#73;&#65289;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE31;
	
	/**
	 * ID: 2122<br>
	 * Message: ql̃AJEg͕s[eBeB̗pF߂ꂽ߁AQ[T[rXׂĂ̗pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#20351;&#29992;&#38750;&#27861;&#31243;&#24335;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#65288;&#22825;&#22530;&#73;&#73;&#65289;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE32;
	
	/**
	 * ID: 2123<br>
	 * Message: ql̃AJEg͂ql̗vɂQ[T[rXׂĂ̗płȂ悤ɂȂĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#32147;&#29992;&#25142;&#30340;&#35201;&#27714;&#34987;&#35373;&#23450;&#28858;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#27965;&#23458;&#26381;&#20013;&#24515;&#65288;&#84;&#101;&#108;&#46;&#48;&#50;&#45;&#54;&#54;&#50;&#48;&#45;&#48;&#54;&#54;&#54;&#65289;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE33;
	
	/**
	 * ID: 2124<br>
	 * Message: T[o[ɂgpĂł$s1́A̖OƏdĂ܂BύX錌͂ĂB<br>
	 * Message: &#20282;&#26381;&#22120;&#32147;&#32113;&#21512;&#24460;&#65292;&#36942;&#21435;&#25152;&#20351;&#29992;&#30340;&#34880;&#30431;&#21517;&#31281;&#12300;&#36;&#115;&#49;&#12301;&#33287;&#20854;&#20182;&#21517;&#23383;&#37325;&#35079;&#12290;&#35531;&#36664;&#20837;&#35201;&#35722;&#26356;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: The server has been integrated, and your Clan name, $s1, has been overlapped with another name. Please enter the Clan name to be changed.
	 */
	public static final SystemMessageId CLAN_NAME_OVERLAPPING_RENAME_CLAN;
	
	/**
	 * ID: 2125<br>
	 * Message: ̖͂O͊ɑ݂Ă邩gpłȂOłBύX錌x͂ĂB<br>
	 * Message: &#24744;&#36664;&#20837;&#30340;&#21517;&#23383;&#24050;&#26377;&#37325;&#35079;&#25110;&#28961;&#27861;&#20351;&#29992;&#12290;&#35531;&#20877;&#27425;&#36664;&#20837;&#35201;&#35722;&#26356;&#30340;&#34880;&#30431;&#21517;&#31281;&#12290;<br>
	 * Message: This name already exists or is an invalid name. Please enter the Clan name to be changed.
	 */
	public static final SystemMessageId CLAN_NAME_INVALID_RENAME_CLAN;
	
	/**
	 * ID: 2126<br>
	 * Message: ql̃AJEg͌Ǒɔe̓xdȂAbv[hF߂ꂽ߁AT[rX̂pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#23650;&#27425;&#21002;&#30331;&#19981;&#30070;&#30340;&#25991;&#31456;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#65288;&#22825;&#22530;&#73;&#73;&#65289;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE34;
	
	/**
	 * ID: 2127<br>
	 * Message: ql̃AJEg͈ᔽƂȂ鏑݂F߂ꂽ߁ApĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#21002;&#30331;&#36949;&#29359;&#29694;&#34892;&#27861;&#30340;&#25991;&#31456;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#65288;&#22825;&#22530;&#73;&#73;&#65289;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE35;
	
	/**
	 * ID: 2128<br>
	 * Message: ql̃AJEg͏ƖړĨQ[pF߂ꂽ߁AQ[T[rXׂĂ̂pĂ܂Bڂ͌TCgihttp://lineage2.plaync.jp/j̃T|[g܂ł₢킹B<br>
	 * Message: &#24744;&#30340;&#24115;&#34399;&#30332;&#29694;&#26377;&#22312;&#36914;&#34892;&#21830;&#26989;&#34892;&#28858;&#65292;&#22240;&#27492;&#34987;&#38480;&#21046;&#20351;&#29992;&#25152;&#26377;&#30340;&#36938;&#25138;&#26381;&#21209;&#12290;&#35443;&#24773;&#35531;&#33267;&#112;&#108;&#97;&#121;&#110;&#99;&#32178;&#31449;&#65288;&#104;&#116;&#116;&#112;&#58;&#47;&#47;&#119;&#119;&#119;&#46;&#112;&#108;&#97;&#121;&#110;&#99;&#46;&#99;&#111;&#109;&#46;&#116;&#119;&#47;&#65289;&#30340;&#23458;&#26381;&#20013;&#24515;&#21033;&#29992;&#65288;&#22825;&#22530;&#73;&#73;&#65289;&#69;&#45;&#66;&#111;&#120;&#22238;&#35206;&#31995;&#32113;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Your account has been suspended ...
	 */
	public static final SystemMessageId ILLEGAL_USE36;
	
	/**
	 * ID: 2129<br>
	 * Message: BꂽACe͕ϊł܂BBɕϊĂB<br>
	 * Message: &#31934;&#29001;&#36942;&#30340;&#36947;&#20855;&#65292;&#28961;&#27861;&#36914;&#34892;&#36681;&#25563;&#12290;&#35531;&#22312;&#35299;&#38500;&#31934;&#29001;&#24460;&#20877;&#36914;&#34892;&#36681;&#25563;&#12290;<br>
	 * Message: The augmented item cannot be converted. Please convert after the augmentation has been removed.
	 */
	public static final SystemMessageId AUGMENTED_ITEM_CANT_CONVERTED;
	
	/**
	 * ID: 2130<br>
	 * Message: ϊłȂACełB<br>
	 * Message: &#28961;&#27861;&#36681;&#25563;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: You cannot convert this item.
	 */
	public static final SystemMessageId CANT_CONVERT_THIS_ITEM;
	
	/**
	 * ID: 2131<br>
	 * Message: ōzăACeD܂BDꂽACe͌lqɂ󂯎邱Ƃł܂B<br>
	 * Message: &#25552;&#20986;&#26368;&#39640;&#20729;&#26684;&#24460;&#24050;&#24471;&#21040;&#35442;&#36947;&#20855;&#65292;&#24471;&#27161;&#30340;&#36947;&#20855;&#21487;&#21069;&#24448;&#20489;&#24235;&#38936;&#21462;&#12290;<br>
	 * Message: You have bid the highest price and have won the item. The item can be found in your personal warehouse.
	 */
	public static final SystemMessageId WON_BID_ITEM_CAN_BE_FOUND_IN_WAREHOUSE;
	
	/**
	 * ID: 2132<br>
	 * Message: ʃT[o[ɐڑ܂B<br>
	 * Message: &#24744;&#36914;&#20837;&#30340;&#26159;&#19968;&#33324;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: You have entered a common server.
	 */
	public static final SystemMessageId ENTERED_COMMON_SERVER;
	
	/**
	 * ID: 2133<br>
	 * Message: lT[o[ɐڑ܂B<br>
	 * Message: &#24744;&#36914;&#20837;&#30340;&#26159;&#25104;&#20154;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: You have entered an adults-only server.
	 */
	public static final SystemMessageId ENTERED_ADULTS_ONLY_SERVER;
	
	/**
	 * ID: 2134<br>
	 * Message: NT[o[ɐڑ܂B<br>
	 * Message: &#24744;&#36914;&#20837;&#30340;&#26159;&#38738;&#23569;&#24180;&#20282;&#26381;&#22120;&#12290;<br>
	 * Message: You have entered a server for juveniles.
	 */
	public static final SystemMessageId ENTERED_JUVENILES_SERVER;
	
	/**
	 * ID: 2135<br>
	 * Message: Jx̂ߍs܂B<br>
	 * Message: &#22240;&#28858;&#30130;&#21214;&#24230;&#32780;&#28961;&#27861;&#36914;&#34892;&#27492;&#21205;&#20316;&#12290;<br>
	 * Message: Because of your Fatigue level, this is not allowed.
	 */
	public static final SystemMessageId NOT_ALLOWED_DUE_TO_FATIGUE_LEVEL;
	
	/**
	 * ID: 2136<br>
	 * Message: ύX̐\󂯕t܂B<br>
	 * Message: &#35722;&#26356;&#34880;&#30431;&#21517;&#31281;&#30340;&#30003;&#35531;&#24050;&#34987;&#21463;&#29702;&#12290;<br>
	 * Message: A clan name change application has been submitted.
	 */
	public static final SystemMessageId CLAN_NAME_CHANCE_PETITION_SUBMITTED;
	
	/**
	 * ID: 2137<br>
	 * Message: $s1ACe$s2AfiœD悤ƂĂ܂B낵łB<br>
	 * Message: &#23559;&#12300;&#36;&#115;&#49;&#12301;&#36947;&#20855;&#20197;&#12300;&#36;&#115;&#50;&#12301;&#37329;&#24163;&#25307;&#27161;&#65292;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: You are about to bid $s1 item with $s2 adena. Will you continue?
	 */
	public static final SystemMessageId CONFIRM_BID_S2_ADENA_FOR_S1_ITEM;
	
	/**
	 * ID: 2138<br>
	 * Message: Di͂ĉB<br>
	 * Message: &#35531;&#36664;&#20837;&#25307;&#27161;&#20729;&#12290;<br>
	 * Message: Please enter a bid price.
	 */
	public static final SystemMessageId ENTER_BID_PRICE;
	
	/**
	 * ID: 2139<br>
	 * Message: $c1̃ybg<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#23541;&#29289;<br>
	 * Message: $c1's Pet.
	 */
	public static final SystemMessageId C1_PET;
	
	/**
	 * ID: 2140<br>
	 * Message: $c1̏b<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#20351;&#39764;<br>
	 * Message: $c1's Servitor.
	 */
	public static final SystemMessageId C1_SERVITOR;
	
	/**
	 * ID: 2141<br>
	 * Message: $c1̖@ɎキR܂B<br>
	 * Message: &#23565;&#12300;&#36;&#99;&#49;&#12301;&#26045;&#23637;&#30340;&#39764;&#27861;&#26377;&#31245;&#20316;&#25269;&#25239;&#12290;<br>
	 * Message: You slightly resisted $c1's magic.
	 */
	public static final SystemMessageId SLIGHTLY_RESISTED_C1_MAGICC;
	
	/**
	 * ID: 2142<br>
	 * Message: $c1 ̓p[eB o[ł͂ȂߒǕł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#19981;&#26159;&#38538;&#20237;&#25104;&#21729;&#65292;&#22240;&#27492;&#28961;&#27861;&#39493;&#36880;&#12290;<br>
	 * Message: You cannot expel $c1 because $c1 is not a party member.
	 */
	public static final SystemMessageId CANT_EXPEL_C1_NOT_A_PARTY_MEMBER;
	
	/**
	 * ID: 2143<br>
	 * Message: lXlH[̓rł͑t^ł܂B<br>
	 * Message: &#22312;&#36914;&#34892;&#20491;&#20154;&#21830;&#24215;&#25110;&#24037;&#25151;&#26178;&#28961;&#27861;&#36070;&#20104;&#23660;&#24615;&#12290;<br>
	 * Message: You cannot add elemental power while operating a Private Store or Private Workshop.
	 */
	public static final SystemMessageId CANNOT_ADD_ELEMENTAL_POWER_WHILE_OPERATING_PRIVATE_STORE_OR_WORKSHOP;
	
	/**
	 * ID: 2144<br>
	 * Message: t^ACeIтB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#36070;&#20104;&#23660;&#24615;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: Please select item to add elemental power.
	 */
	public static final SystemMessageId SELECT_ITEM_TO_ADD_ELEMENTAL_POWER;
	
	/**
	 * ID: 2145<br>
	 * Message: ނ̎gp܂B<br>
	 * Message: &#24050;&#21462;&#28040;&#23660;&#24615;&#24375;&#21270;&#21137;&#30340;&#20351;&#29992;&#12290;<br>
	 * Message: Attribute item usage has been cancelled.
	 */
	public static final SystemMessageId ELEMENTAL_ENHANCE_CANCELED;
	
	/**
	 * ID: 2146<br>
	 * Message: ނ̎gpɍ܂B<br>
	 * Message: &#23660;&#24615;&#24375;&#21270;&#21137;&#30340;&#20351;&#29992;&#26781;&#20214;&#19981;&#31526;&#12290;<br>
	 * Message: Elemental power enhancer usage requirement is not sufficient.
	 */
	public static final SystemMessageId ELEMENTAL_ENHANCE_REQUIREMENT_NOT_SUFFICIENT;
	
	/**
	 * ID: 2147<br>
	 * Message: $s1$s2̑̕t^ɐ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#19978;&#24050;&#25104;&#21151;&#36070;&#20104;&#12300;&#36;&#115;&#50;&#12301;&#23660;&#24615;&#12290;<br>
	 * Message: $s2 elemental power has been added successfully to $s1.
	 */
	public static final SystemMessageId ELEMENTAL_POWER_S2_SUCCESSFULLY_ADDED_TO_S1;
	
	/**
	 * ID: 2148<br>
	 * Message: +$s1$s2$s3̑𐬌Iɕt^܂B<br>
	 * Message: &#22312;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#19978;&#24050;&#25104;&#21151;&#36070;&#20104;&#12300;&#36;&#115;&#51;&#12301;&#23660;&#24615;&#12290;<br>
	 * Message: $s3 elemental power has been added successfully to +$s1 $s2.
	 */
	public static final SystemMessageId ELEMENTAL_POWER_S3_SUCCESSFULLY_ADDED_TO_S1_S2;
	
	/**
	 * ID: 2149<br>
	 * Message: ̕t^Ɏs܂B<br>
	 * Message: &#36070;&#20104;&#23660;&#24615;&#22833;&#25943;&#12290;<br>
	 * Message: You have failed to add elemental power.
	 */
	public static final SystemMessageId FAILED_ADDING_ELEMENTAL_POWER;
	
	/**
	 * ID: 2150<br>
	 * Message: łɕʂ̑t^Ă邽߁At^ł܂B<br>
	 * Message: &#24050;&#26377;&#36070;&#20104;&#20854;&#23427;&#23660;&#24615;&#65292;&#22240;&#27492;&#28961;&#27861;&#36070;&#20104;&#23660;&#24615;&#12290;<br>
	 * Message: Another elemental power has already been added. This elemental power cannot be added.
	 */
	public static final SystemMessageId ANOTHER_ELEMENTAL_POWER_ALREADY_ADDED;
	
	/**
	 * ID: 2151<br>
	 * Message: 肪@ɒR߃_[Wቺ܂B<br>
	 * Message: &#23565;&#26041;&#25269;&#25239;&#20102;&#39764;&#27861;&#65292;&#22240;&#27492;&#38477;&#20302;&#20102;&#20663;&#23475;&#12290;<br>
	 * Message: Your opponent has resistance to magic, the damage was decreased.
	 */
	public static final SystemMessageId OPPONENT_HAS_RESISTANCE_MAGIC_DAMAGE_DECREASED;
	
	/**
	 * ID: 2152<br>
	 * Message: w̃V[gJbgL[ׂďāAV[gJbgL[ݒɖ߂܂B낵łB<br>
	 * Message: &#21034;&#38500;&#25152;&#26377;&#25351;&#23450;&#30340;&#24555;&#25463;&#37749;&#24460;&#65292;&#23559;&#24489;&#21407;&#28858;&#24555;&#25463;&#37749;&#21021;&#22987;&#35373;&#23450;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: The assigned shortcut will be deleted and the initial shortcut setting restored. Will you continue?
	 */
	public static final SystemMessageId CONFIRM_SHORCUT_DELETE;
	
	/**
	 * ID: 2153<br>
	 * Message: ݂̃AJEg̒10ɐڑĂ邽߁Aȏʂ̃AJEgł̐ڑ͂ł܂B<br>
	 * Message: &#22312;&#24744;&#25152;&#25345;&#26377;&#30340;&#24115;&#34399;&#20013;&#24050;&#26377;&#49;&#48;&#20491;&#21516;&#26178;&#36899;&#32218;&#65292;&#22240;&#27492;&#28961;&#27861;&#20877;&#20197;&#20854;&#20182;&#24115;&#34399;&#30331;&#20837;&#12290;<br>
	 * Message: You are currently logged into 10 of your accounts and can no longer access your other accounts.
	 */
	public static final SystemMessageId MAXIMUM_ACCOUNT_LOGINS_REACHED;
	
	/**
	 * ID: 2154<br>
	 * Message: ^[QbgtbO |[ł͂Ȃ߁Ǎfg͂ł܂B<br>
	 * Message: &#30446;&#27161;&#20006;&#38750;&#28858;&#26071;&#26751;&#65292;&#22240;&#27492;&#28961;&#27861;&#21319;&#26071;&#12290;<br>
	 * Message: The target is not a flagpole so a flag cannot be displayed.
	 */
	public static final SystemMessageId THE_TARGET_IS_NOT_A_FLAGPOLE_SO_A_FLAG_CANNOT_BE_DISPLAYED;
	
	/**
	 * ID: 2155<br>
	 * Message: łɊfgĂ邽ߌfgł܂B<br>
	 * Message: &#24050;&#26377;&#39640;&#25499;&#26071;&#24159;&#65292;&#22240;&#27492;&#28961;&#27861;&#21319;&#26071;&#12290;<br>
	 * Message: A flag is already being displayed, another flag cannot be displayed.
	 */
	public static final SystemMessageId A_FLAG_IS_ALREADY_BEING_DISPLAYED_ANOTHER_FLAG_CANNOT_BE_DISPLAYED;
	
	/**
	 * ID: 2156<br>
	 * Message: KvȃACeȂ߃XLgpł܂B<br>
	 * Message: &#25152;&#38656;&#36947;&#20855;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#25216;&#33021;&#12290;<br>
	 * Message: There are not enough necessary items to use the skill.
	 */
	public static final SystemMessageId THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL;
	
	/**
	 * ID: 2157<br>
	 * Message: $s1AfiœD܂B<br>
	 * Message: &#35430;&#22294;&#20197;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#20358;&#25307;&#27161;&#12290;<br>
	 * Message: Bid will be attempted with $s1 adena.
	 */
	public static final SystemMessageId BID_WILL_BE_ATTEMPTED_WITH_S1_ADENA;
	
	/**
	 * ID: 2158<br>
	 * Message: U鑤̗ՎA^[Qbgɂ͋Uł܂B<br>
	 * Message: &#23565;&#25915;&#22478;&#26041;&#33256;&#26178;&#32879;&#21512;&#36557;&#28961;&#27861;&#36914;&#34892;&#24375;&#21046;&#25915;&#25802;&#12290;<br>
	 * Message: Force attack is impossible against a temporary allied member during a siege.
	 */
	public static final SystemMessageId FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS;
	
	/**
	 * ID: 2159<br>
	 * Message: D҂邽ߋԂ5ԉ܂B<br>
	 * Message: &#23578;&#26377;&#25307;&#27161;&#32773;&#65292;&#22240;&#27492;&#31478;&#36067;&#36914;&#34892;&#26178;&#38291;&#23559;&#24310;&#38263;&#53;&#20998;&#37912;&#12290;<br>
	 * Message: Bidder exists, the auction time has been extended by 5 minutes.
	 */
	public static final SystemMessageId BIDDER_EXISTS_AUCTION_TIME_EXTENDED_BY_5_MINUTES;
	
	/**
	 * ID: 2160<br>
	 * Message: D҂邽ߋԂ3ԉ܂B<br>
	 * Message: &#23578;&#26377;&#25307;&#27161;&#32773;&#65292;&#22240;&#27492;&#31478;&#36067;&#36914;&#34892;&#26178;&#38291;&#23559;&#24310;&#38263;&#51;&#20998;&#37912;&#12290;<br>
	 * Message: Bidder exists, the auction time has been extended by 3 minutes.
	 */
	public static final SystemMessageId BIDDER_EXISTS_AUCTION_TIME_EXTENDED_BY_3_MINUTES;
	
	/**
	 * ID: 2161<br>
	 * Message: ړXy[XȂ߁AXLgpł܂B<br>
	 * Message: &#27794;&#26377;&#31227;&#21205;&#31354;&#38291;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#25216;&#33021;&#12290;<br>
	 * Message: There is not enough space to move, the skill cannot be used.
	 */
	public static final SystemMessageId NOT_ENOUGH_SPACE_FOR_SKILL;
	
	/**
	 * ID: 2162<br>
	 * Message: $s1߁Av$s2ɂȂ܂B<br>
	 * Message: &#38728;&#39746;&#22686;&#21152;&#12300;&#36;&#115;&#49;&#12301;&#20491;&#65292;&#30446;&#21069;&#20849;&#26377;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12290;<br>
	 * Message: Your soul has increased by $s1, so it is now at $s2.
	 */
	public static final SystemMessageId YOUR_SOUL_HAS_INCREASED_BY_S1_SO_IT_IS_NOW_AT_S2;
	
	/**
	 * ID: 2163<br>
	 * Message: ȏ㍰𑝂₷Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#32380;&#32396;&#22686;&#21152;&#38728;&#39746;&#12290;<br>
	 * Message: Soul cannot be increased anymore.
	 */
	public static final SystemMessageId SOUL_CANNOT_BE_INCREASED_ANYMORE;
	
	/**
	 * ID: 2164<br>
	 * Message: ɂ̂܂B<br>
	 * Message: &#24050;&#20308;&#38936;&#24149;&#33293;&#12290;<br>
	 * Message: The barracks have been seized.
	 */
	public static final SystemMessageId SEIZED_BARRACKS;
	
	/**
	 * ID: 2165<br>
	 * Message: ɋ@\܂B<br>
	 * Message: &#24149;&#33293;&#21151;&#33021;&#24050;&#24489;&#21407;&#12290;<br>
	 * Message: The barracks function has been restored.
	 */
	public static final SystemMessageId BARRACKS_FUNCTION_RESTORED;
	
	/**
	 * ID: 2166<br>
	 * Message: ׂĂ̖ɂ̂܂B<br>
	 * Message: &#25351;&#25582;&#24149;&#33293;&#30340;&#38272;&#24050;&#38283;&#21855;&#12290;<br>
	 * Message: All barracks are occupied.
	 */
	public static final SystemMessageId ALL_BARRACKS_OCCUPIED;
	
	/**
	 * ID: 2167<br>
	 * Message: ӂ̂XL̓s[X][Ŏgpł܂B<br>
	 * Message: &#22312;&#23433;&#20840;&#21312;&#22495;&#28961;&#27861;&#20351;&#29992;&#38468;&#26377;&#24801;&#24847;&#30340;&#25216;&#33021;&#12290;<br>
	 * Message: A malicious skill cannot be used in a peace zone.
	 */
	public static final SystemMessageId A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE;
	
	/**
	 * ID: 2168<br>
	 * Message: $c1E܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25342;&#21462;&#20102;&#26071;&#24159;&#12290;<br>
	 * Message: $c1 has acquired the flag.
	 */
	public static final SystemMessageId C1_ACQUIRED_THE_FLAG;
	
	/**
	 * ID: 2169<br>
	 * Message: $s1̗vǐɓo^܂B<br>
	 * Message: &#24050;&#26377;&#30331;&#35352;&#22312;&#12300;&#36;&#115;&#49;&#12301;&#35201;&#22622;&#25136;&#12290;<br>
	 * Message: Your clan has been registered to $s1's fortress battle.
	 */
	public static final SystemMessageId REGISTERED_TO_S1_FORTRESS_BATTLE;
	
	/**
	 * ID: 2170<br>
	 * Message: ӂ̂XL͑肪s[X][ɂ鎞͎gpł܂B<br>
	 * Message: &#23565;&#26041;&#22312;&#23433;&#20840;&#21312;&#22495;&#26178;&#28961;&#27861;&#20351;&#29992;&#38468;&#26377;&#24801;&#24847;&#30340;&#25216;&#33021;&#12290;<br>
	 * Message: A malicious skill cannot be used when an opponent is in the peace zone
	 */
	public static final SystemMessageId CANT_USE_BAD_MAGIC_WHEN_OPPONENT_IN_PEACE_ZONE;
	
	/**
	 * ID: 2171<br>
	 * Message: NX^CYłȂACełB<br>
	 * Message: &#28961;&#27861;&#32080;&#26230;&#21270;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: This item cannot be crystallized.
	 */
	public static final SystemMessageId ITEM_CANNOT_CRYSTALLIZED;
	
	/**
	 * ID: 2172<br>
	 * Message: +$s1$s2̋I܂B<br>
	 * Message: &#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#30340;&#31478;&#36067;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: +$s1 $s2's auction has ended.
	 */
	public static final SystemMessageId S1_S2_AUCTION_ENDED;
	
	/**
	 * ID: 2173<br>
	 * Message: $s1̋I܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#31478;&#36067;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: $s1's auction has ended.
	 */
	public static final SystemMessageId S1_AUCTION_ENDED;
	
	/**
	 * ID: 2174<br>
	 * Message: $c1 ϐgԂ̂ߌł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#35722;&#36523;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#27770;&#39717;&#12290;<br>
	 * Message: $c1 cannot duel because $c1 is currently polymorphed.
	 */
	public static final SystemMessageId C1_CANNOT_DUEL_WHILE_POLYMORPHED;
	
	/**
	 * ID: 2175<br>
	 * Message: ϐgԂ̃p[eB o[邽߃p[eBmł̌ł܂B<br>
	 * Message: &#26377;&#35722;&#36523;&#30340;&#38538;&#20237;&#25104;&#21729;&#23384;&#22312;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#38538;&#20237;&#38291;&#30340;&#27770;&#39717;&#12290;<br>
	 * Message: Party duel cannot be initiated due to a polymorphed partymember
	 */
	public static final SystemMessageId CANNOT_PARTY_DUEL_WHILE_A_MEMBER_IS_POLYMORPHED;
	
	/**
	 * ID: 2176<br>
	 * Message: $s1$s2܂B<br>
	 * Message: &#24050;&#35299;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#23660;&#24615;&#12290;<br>
	 * Message: $s1's elemental power has been removed.
	 */
	public static final SystemMessageId S1_ELEMENTAL_POWER_REMOVED;
	
	/**
	 * ID: 2177<br>
	 * Message: +$s1$s2$s3̑܂B<br>
	 * Message: &#24050;&#35299;&#38500;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#30340;&#12300;&#36;&#115;&#51;&#12301;&#23660;&#24615;&#12290;<br>
	 * Message: +$s1 $s2's elemental power has been removed.
	 */
	public static final SystemMessageId S1_S2_ELEMENTAL_POWER_REMOVED;
	
	/**
	 * ID: 2178<br>
	 * Message: ̉Ɏs܂B<br>
	 * Message: &#23660;&#24615;&#35299;&#38500;&#22833;&#25943;&#12290;<br>
	 * Message: You failed to remove the elemental power.
	 */
	public static final SystemMessageId FAILED_TO_REMOVE_ELEMENTAL_POWER;
	
	/**
	 * ID: 2179<br>
	 * Message: M̋ɍōzDłB<br>
	 * Message: &#22312;&#22855;&#23721;&#22478;&#25293;&#36067;&#20013;&#65292;&#27491;&#22312;&#25307;&#27161;&#26368;&#39640;&#20729;&#12290;<br>
	 * Message: You have the highest bid submitted in Giran Castle Auction.
	 */
	public static final SystemMessageId HIGHEST_BID_FOR_GIRAN_CASTLE;
	
	/**
	 * ID: 2180<br>
	 * Message: Af̋ɍōzDłB<br>
	 * Message: &#22312;&#20126;&#19969;&#22478;&#25293;&#36067;&#20013;&#65292;&#27491;&#22312;&#25307;&#27161;&#26368;&#39640;&#20729;&#12290;<br>
	 * Message: You have the highest bid submitted in Aden Castle Auction.
	 */
	public static final SystemMessageId HIGHEST_BID_FOR_ADEN_CASTLE;
	
	/**
	 * ID: 2181<br>
	 * Message: E̋ɍōzDłB<br>
	 * Message: &#22312;&#39791;&#22240;&#22478;&#25293;&#36067;&#20013;&#65292;&#27491;&#22312;&#25307;&#27161;&#26368;&#39640;&#20729;&#12290;<br>
	 * Message: You have the highest bid submitted in Rune Castle Auction.
	 */
	public static final SystemMessageId HIGHEST_BID_FOR_RUNE_CASTLE;
	
	/**
	 * ID: 2182<br>
	 * Message: DɏԂł͕ϐgł܂B<br>
	 * Message: &#22312;&#25645;&#20056;&#33337;&#26178;&#65292;&#28961;&#27861;&#35722;&#36523;&#12290;<br>
	 * Message: You cannot polymorph while riding a boat.
	 */
	public static final SystemMessageId CANT_POLYMORPH_ON_BOAT;
	
	/**
	 * ID: 2183<br>
	 * Message: $s1̗vǐ킪I܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#35201;&#22622;&#25136;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The fortress battle of $s1 has finished.
	 */
	public static final SystemMessageId THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED;
	
	/**
	 * ID: 2184<br>
	 * Message: $s1$s2̗vǐŏ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#22312;&#12300;&#36;&#115;&#50;&#12301;&#35201;&#22622;&#25136;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: $s1 clan is victorious in the fortress battle of $s2.
	 */
	public static final SystemMessageId S1_CLAN_IS_VICTORIOUS_IN_THE_FORTRESS_BATTLE_OF_S2;
	
	/**
	 * ID: 2185<br>
	 * Message: p[eB [_[݂̂ꂷ邱Ƃł܂B<br>
	 * Message: &#21482;&#38480;&#38538;&#38263;&#20358;&#35430;&#22294;&#36914;&#20837;&#12290;<br>
	 * Message: Only a party leader can try to enter.
	 */
	public static final SystemMessageId ONLY_PARTY_LEADER_CAN_ENTER;
	
	/**
	 * ID: 2186<br>
	 * Message: ȏ̍͋zł܂B<br>
	 * Message: &#28961;&#27861;&#32380;&#32396;&#21560;&#25910;&#38728;&#39746;&#12290;<br>
	 * Message: Soul cannot be absorbed anymore.
	 */
	public static final SystemMessageId SOUL_CANNOT_BE_ABSORBED_ANYMORE;
	
	/**
	 * ID: 2187<br>
	 * Message: 肪ˌłȂʒuɂ܂B<br>
	 * Message: &#30446;&#27161;&#22312;&#28961;&#27861;&#31361;&#25802;&#30340;&#20301;&#32622;&#12290;<br>
	 * Message: The target is located where you cannot charge.
	 */
	public static final SystemMessageId CANT_REACH_TARGET_TO_CHARGE;
	
	/**
	 * ID: 2188<br>
	 * Message: ̃G`gsĂ܂BO̍ƂIꂽ܂sĂB<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#36914;&#34892;&#20854;&#20182;&#26119;&#33775;&#65292;&#35531;&#32080;&#26463;&#20043;&#21069;&#30340;&#20316;&#26989;&#24460;&#37325;&#26032;&#20877;&#35430;&#12290;<br>
	 * Message: Another enchantment is in progress. Please complete previous task and try again.
	 */
	public static final SystemMessageId ENCHANTMENT_ALREADY_IN_PROGRESS;
	
	/**
	 * ID: 2189<br>
	 * Message: ݒnF $s1A$s2A$s3 (J}Gt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#38343;&#22825;&#20351;&#26449;&#33674;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (near Near Kamael Village)
	 */
	public static final SystemMessageId LOC_KAMAEL_VILLAGE_S1_S2_S3;
	
	/**
	 * ID: 2190<br>
	 * Message: ݒnF$s1A$s2A$s3 (rn쑤̃Lvt)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#33618;&#21407;&#21335;&#26041;&#29151;&#22320;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (Near south of Wastelands Camp)
	 */
	public static final SystemMessageId LOC_WASTELANDS_CAMP_S1_S2_S3;
	
	/**
	 * ID: 2191<br>
	 * Message: IIvVKpɂ́AĂуQ[[hKv܂BKpȂꍇ́AQ[sۂɓKp܂BKp܂B<br>
	 * Message: &#33509;&#24819;&#25033;&#29992;&#25152;&#36984;&#30340;&#36984;&#38917;&#65292;&#24517;&#38920;&#35201;&#37325;&#26032;&#21855;&#21205;&#36938;&#25138;&#12290;&#33509;&#19981;&#39340;&#19978;&#25033;&#29992;&#26178;&#65292;&#23559;&#26371;&#22312;&#19979;&#27425;&#36914;&#34892;&#36938;&#25138;&#26178;&#25033;&#29992;&#36984;&#38917;&#12290;&#35201;&#29694;&#22312;&#25033;&#29992;&#21966;&#65311;<br>
	 * Message: To apply selected options, the game needs to be reloaded. If you don't apply now, it will be applied when you start the game next time. Will you apply now?
	 */
	public static final SystemMessageId CONFIRM_APPLY_SELECTIONS;
	
	/**
	 * ID: 2192<br>
	 * Message: ACeɓD܂B<br>
	 * Message: &#22312;&#36947;&#20855;&#31478;&#36067;&#24050;&#26377;&#36914;&#34892;&#25307;&#27161;&#12290;<br>
	 * Message: You have bid on an item auction.
	 */
	public static final SystemMessageId BID_ON_ITEM_AUCTION;
	
	/**
	 * ID: 2193<br>
	 * Message: NPCƂ̋ߍ쓮܂B<br>
	 * Message: &#33287;&#78;&#80;&#67;&#30340;&#36317;&#38626;&#22826;&#36960;&#65292;&#22240;&#27492;&#28961;&#27861;&#21855;&#21205;&#12290;<br>
	 * Message: It's too far from the NPC to work.
	 */
	public static final SystemMessageId TOO_FAR_FROM_NPC;
	
	/**
	 * ID: 2194<br>
	 * Message: ݕϐg̕ϐĝł͊Y̌ʂKpł܂B<br>
	 * Message: &#22312;&#30446;&#21069;&#35722;&#36523;&#20013;&#30340;&#35722;&#36523;&#39636;&#19978;&#65292;&#35442;&#25928;&#26524;&#23559;&#19981;&#26371;&#29983;&#25928;&#12290;<br>
	 * Message: Current polymorph form cannot be applied with corresponding effects.
	 */
	public static final SystemMessageId CANT_APPLY_CURRENT_POLYMORPH_WITH_CORRESPONDING_EFFECTS;
	
	/**
	 * ID: 2195<br>
	 * Message: ܂B<br>
	 * Message: &#38728;&#39746;&#19981;&#36275;&#12290;<br>
	 * Message: There is not enough soul.
	 */
	public static final SystemMessageId THERE_IS_NOT_ENOUGH_SOUL;
	
	/**
	 * ID: 2196<br>
	 * Message: LȂ<br>
	 * Message: &#27794;&#26377;&#25793;&#26377;&#30340;&#34880;&#30431;&#12290;<br>
	 * Message: No Owned Clan.
	 */
	public static final SystemMessageId NO_OWNED_CLAN;
	
	/**
	 * ID: 2197<br>
	 * Message: $s1L<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#25793;&#26377;&#20013;&#12290;<br>
	 * Message: Owned by clan $s1.
	 */
	public static final SystemMessageId OWNED_S1_CLAN;
	
	/**
	 * ID: 2198<br>
	 * Message: ACeɍōzDłB<br>
	 * Message: &#22312;&#36947;&#20855;&#25293;&#36067;&#19978;&#65292;&#27491;&#22312;&#25307;&#27161;&#26368;&#39640;&#20729;&#12290;<br>
	 * Message: You have the highest bid in an item auction.
	 */
	public static final SystemMessageId HIGHEST_BID_IN_ITEM_AUCTION;
	
	/**
	 * ID: 2199<br>
	 * Message: NPCT[o[쓮~Ԃ̂߁ACX^g ][ɓł܂B<br>
	 * Message: &#78;&#80;&#67;&#20282;&#26381;&#22120;&#34389;&#26044;&#36939;&#36681;&#20013;&#27490;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#21363;&#26178;&#22320;&#21312;&#12290;<br>
	 * Message: You cannot enter this instance zone while the NPC server is unavailable.
	 */
	public static final SystemMessageId CANT_ENTER_INSTANCE_ZONE_NPC_SERVER_OFFLINE;
	
	/**
	 * ID: 2200<br>
	 * Message: NPCT[o[쓮~ɂYCX^g ][폜邽߁A΂炭Ă狭ޏꂳ܂B<br>
	 * Message: &#78;&#80;&#67;&#20282;&#26381;&#22120;&#34389;&#26044;&#36939;&#36681;&#20013;&#27490;&#29376;&#24907;&#65292;&#22240;&#27492;&#23559;&#26371;&#21034;&#38500;&#35442;&#21363;&#26178;&#22320;&#21312;&#65292;&#19988;&#31245;&#24460;&#23559;&#34987;&#24375;&#21046;&#36864;&#22580;&#12290;<br>
	 * Message: This instance zone will be terminated because the NPC server is unavailable. You will be forcibly removed from the dungeon shortly
	 */
	public static final SystemMessageId INSTANCE_ZONE_TERMINATED_NPC_SERVER_OFFLINE;
	
	/**
	 * ID: 2201<br>
	 * Message: $s1N$s2$s3<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#24180;&#12300;&#36;&#115;&#50;&#12301;&#26376;&#12300;&#36;&#115;&#51;&#12301;&#26085;<br>
	 * Message: $s1 year(s) $s2 month(s) $s3 day(s)
	 */
	public static final SystemMessageId S1_YEARS_S2_MONTHS_S3_DAYS;
	
	/**
	 * ID: 2202<br>
	 * Message: $s1$s2$s3b<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#40670;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12300;&#36;&#115;&#51;&#12301;&#31186;<br>
	 * Message: $s1 hour(s) $s2 minute(s) $s3 second(s)
	 */
	public static final SystemMessageId S1_HOURS_S2_MINUTES_S3_SECONDS;
	
	/**
	 * ID: 2203<br>
	 * Message: $s1$s2<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#26376;&#12300;&#36;&#115;&#50;&#12301;&#26085;<br>
	 * Message: $s1 month(s) $s2 day(s)
	 */
	public static final SystemMessageId S1_MONTHS_S2_DAYS;
	
	/**
	 * ID: 2204<br>
	 * Message: $s1<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#40670;<br>
	 * Message: $s1 hour(s)
	 */
	public static final SystemMessageId S1_HOURS;
	
	/**
	 * ID: 2205<br>
	 * Message: ~j}bvgȂnɓ܂B~j}bv܂B<br>
	 * Message: &#24050;&#36914;&#20837;&#28961;&#27861;&#20351;&#29992;&#36855;&#20320;&#22320;&#22294;&#30340;&#22320;&#21312;&#12290;&#23559;&#38364;&#38281;&#36855;&#20320;&#22320;&#22294;&#12290;<br>
	 * Message: You have entered an area where the mini map cannot be used. The mini map will be closed.
	 */
	public static final SystemMessageId AREA_FORBIDS_MINIMAP;
	
	/**
	 * ID: 2206<br>
	 * Message: ~j}bvgnɓ܂B<br>
	 * Message: &#24050;&#36914;&#20837;&#21487;&#20351;&#29992;&#36855;&#20320;&#22320;&#22294;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: You have entered an area where the mini map can be used.
	 */
	public static final SystemMessageId AREA_ALLOWS_MINIMAP;
	
	/**
	 * ID: 2207<br>
	 * Message: ~j}bvgȂn̂߁A~j}bvJ܂B<br>
	 * Message: &#36914;&#20837;&#28961;&#27861;&#20351;&#29992;&#36855;&#20320;&#22320;&#22294;&#30340;&#22320;&#21312;&#65292;&#22240;&#27492;&#28961;&#27861;&#38283;&#21855;&#36855;&#20320;&#22320;&#22294;&#12290;<br>
	 * Message: This is an area where you cannot use the mini map. The mini map will not be opened.
	 */
	public static final SystemMessageId CANT_OPEN_MINIMAP;
	
	/**
	 * ID: 2208<br>
	 * Message: XLKɕKvȃXL x܂B<br>
	 * Message: &#32722;&#24471;&#25216;&#33021;&#25152;&#38656;&#30340;&#25216;&#33021;&#31561;&#32026;&#26781;&#20214;&#19981;&#31526;&#12290;<br>
	 * Message: You do not meet the skill level requirements.
	 */
	public static final SystemMessageId YOU_DONT_MEET_SKILL_LEVEL_REQUIREMENTS;
	
	/**
	 * ID: 2209<br>
	 * Message: [_[쓮Ȃn<br>
	 * Message: &#28961;&#27861;&#21855;&#21205;&#38647;&#36948;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: This is an area where radar cannot be used
	 */
	public static final SystemMessageId AREA_WHERE_RADAR_CANNOT_BE_USED;
	
	/**
	 * ID: 2210<br>
	 * Message: G`gĂȂԂɖ߂܂B<br>
	 * Message: &#22238;&#21040;&#28961;&#27861;&#26119;&#33775;&#30340;&#29376;&#24907;&#12290;<br>
	 * Message: It will return to an unenchanted condition.
	 */
	public static final SystemMessageId RETURN_TO_UNENCHANTED_CONDITION;
	
	/**
	 * ID: 2211<br>
	 * Message: sXLKĂȂߐVXLKł܂B<br>
	 * Message: &#23578;&#26410;&#32722;&#24471;&#20808;&#34892;&#25216;&#33021;&#22240;&#27492;&#28961;&#27861;&#21462;&#24471;&#26032;&#25216;&#33021;&#12290;<br>
	 * Message: You must learn the Onyx Beast skill before you can acquire further skills.
	 */
	public static final SystemMessageId YOU_MUST_LEARN_ONYX_BEAST_SKILL;
	
	/**
	 * ID: 2212<br>
	 * Message: XLKɕKvȃNGXg܂sĂ܂B<br>
	 * Message: &#23578;&#26410;&#22519;&#34892;&#32722;&#24471;&#25216;&#33021;&#25152;&#38656;&#30340;&#20219;&#21209;&#12290;<br>
	 * Message: You have not completed the necessary quest for skill acquisition.
	 */
	public static final SystemMessageId NOT_COMPLETED_QUEST_FOR_SKILL_ACQUISITION;
	
	/**
	 * ID: 2213<br>
	 * Message: ϐgԂł͑DɏDł܂B<br>
	 * Message: &#22312;&#35722;&#36523;&#30340;&#29376;&#24907;&#28961;&#27861;&#25645;&#20056;&#33337;&#12290;<br>
	 * Message: Cannot board a ship while polymorphed.
	 */
	public static final SystemMessageId CANT_BOARD_SHIP_POLYMORPHED;
	
	/**
	 * ID: 2214<br>
	 * Message: ݒ肵ZbeBOŐVLN^[𐶐܂B낵łB<br>
	 * Message: &#23559;&#20197;&#29694;&#22312;&#35373;&#23450;&#30340;&#26781;&#20214;&#21109;&#36896;&#26032;&#35282;&#33394;&#65292;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: A new character will be created with the current settings. Continue
	 */
	public static final SystemMessageId CONFIRM_CHARACTER_CREATION;
	
	/**
	 * ID: 2215<br>
	 * Message: $s1h<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#29289;&#29702;&#38450;&#31142;&#21147;&#12290;<br>
	 * Message: $s1 P.Def
	 */
	public static final SystemMessageId S1_PDEF;
	
	/**
	 * ID: 2216<br>
	 * Message: CPUhCo[ŐVo[Wł͂܂BAMDfARAȏCPUg̏ꍇAAMD̃EFuTCgAMDfARAIveB}CU[_E[hACXg[ĉB<br>
	 * Message: &#67;&#80;&#85;&#39493;&#21205;&#31243;&#24335;&#19981;&#26159;&#26368;&#26032;&#29256;&#26412;&#12290;&#22914;&#26524;&#20351;&#29992;&#30340;&#26159;&#65;&#77;&#68;&#38617;&#26680;&#24515;&#20197;&#19978;&#30340;&#67;&#80;&#85;&#26178;&#65292;&#35531;&#33267;&#65;&#77;&#68;&#23448;&#26041;&#32178;&#31449;&#19979;&#36617;&#65;&#77;&#68;&#32;&#68;&#117;&#97;&#108;&#45;&#67;&#111;&#114;&#101;&#32;&#79;&#112;&#116;&#105;&#109;&#105;&#122;&#101;&#114;&#20006;&#36914;&#34892;&#23433;&#35037;&#31243;&#24335;&#12290;<br>
	 * Message: The CPU driver is not up to date. Please install an up-to-date CPU driver.
	 */
	public static final SystemMessageId PLEASE_UPDATE_CPU_DRIVER;
	
	/**
	 * ID: 2217<br>
	 * Message: oX^̔jɐāAlオ܂B<br>
	 * Message: &#25104;&#21151;&#29190;&#30772;&#24361;&#30770;&#65292;&#34880;&#30431;&#32882;&#26395;&#23559;&#25552;&#21319;&#12290;<br>
	 * Message: The ballista has been successfully destroyed and the clan's reputation will be increased.
	 */
	public static final SystemMessageId BALLISTA_DESTROYED_CLAN_REPU_INCREASED;
	
	/**
	 * ID: 2218<br>
	 * Message: C NX̎ɂgXLłB<br>
	 * Message: &#22312;&#20027;&#32887;&#26989;&#26178;&#25165;&#33021;&#20351;&#29992;&#30340;&#25216;&#33021;&#12290;<br>
	 * Message: This is a main class skill only.
	 */
	public static final SystemMessageId MAIN_CLASS_SKILL_ONLY;
	
	/**
	 * ID: 2219<br>
	 * Message: łɏKʌ̃XLłB<br>
	 * Message: &#27492;&#28858;&#24050;&#32722;&#24471;&#30340;&#19979;&#20301;&#34880;&#30431;&#25216;&#33021;&#12290;<br>
	 * Message: This squad skill has already been acquired.
	 */
	public static final SystemMessageId SQUAD_SKILL_ALREADY_ACQUIRED;
	
	/**
	 * ID: 2220<br>
	 * Message: OiKx̃XLKĂ܂B<br>
	 * Message: &#23578;&#26410;&#32722;&#24471;&#20808;&#34892;&#31561;&#32026;&#30340;&#25216;&#33021;&#12290;<br>
	 * Message: The previous level skill has not been learned.
	 */
	public static final SystemMessageId PREVIOUS_LEVEL_SKILL_NOT_LEARNED;
	
	/**
	 * ID: 2221<br>
	 * Message: I񂾋@\ANeBuɂ܂B<br>
	 * Message: &#35201;&#21855;&#21205;&#25152;&#36984;&#30340;&#21151;&#33021;&#21966;&#65311;<br>
	 * Message: Will you activate the selected functions?
	 */
	public static final SystemMessageId ACTIVATE_SELECTED_FUNTIONS_CONFIRM;
	
	/**
	 * ID: 2222<br>
	 * Message: @̔zuɂ15Afi܂Bzu܂B<br>
	 * Message: &#37197;&#32622;&#20597;&#26597;&#20853;&#26178;&#23559;&#28040;&#32791;&#49;&#53;&#33836;&#37329;&#24163;&#12290;&#35201;&#37197;&#32622;&#21966;&#65311;<br>
	 * Message: It will cost 150,000 adena to place scouts. Will you place them.
	 */
	public static final SystemMessageId SCOUT_COSTS_150000_ADENA;
	
	/**
	 * ID: 2223<br>
	 * Message: vǖ̋ɂ20Afi܂B܂B<br>
	 * Message: &#24375;&#21270;&#35201;&#22622;&#38272;&#26178;&#23559;&#28040;&#32791;&#50;&#48;&#33836;&#37329;&#24163;&#12290;&#35201;&#24375;&#21270;&#21966;&#65311;<br>
	 * Message: It will cost 200,000 adena for a fortress gate enhancement. Will you enhance it?
	 */
	public static final SystemMessageId FORTRESS_GATE_COSTS_200000_ADENA;
	
	/**
	 * ID: 2224<br>
	 * Message: {EKˏłB<br>
	 * Message: &#27491;&#22312;&#28310;&#20633;&#30332;&#23556;&#24361;&#31661;&#12290;<br>
	 * Message: Crossbow is preparing to fire.
	 */
	public static final SystemMessageId CROSSBOW_PREPARING_TO_FIRE;
	
	/**
	 * ID: 2225<br>
	 * Message: ȏKXL͂܂B$s1]EĂ痈ĂB<br>
	 * Message: &#24050;&#27794;&#26377;&#21487;&#23416;&#32722;&#30340;&#25216;&#33021;&#12290;&#35531;&#22312;&#23436;&#25104;&#12300;&#36;&#115;&#49;&#12301;&#27425;&#36681;&#32887;&#24460;&#20877;&#20809;&#39015;&#27492;&#34389;&#12290;<br>
	 * Message: There are no other skills to learn. Please come back after $s1nd class change.
	 */
	public static final SystemMessageId NO_SKILLS_TO_LEARN_RETURN_AFTER_S1_CLASS_CHANGE;
	
	/**
	 * ID: 2226<br>
	 * Message: {g܂B<br>
	 * Message: &#24361;&#31661;&#19981;&#36275;&#12290;<br>
	 * Message: Not enough bolts.
	 */
	public static final SystemMessageId NOT_ENOUGH_BOLTS;
	
	/**
	 * ID: 2227<br>
	 * Message: _񂵂Ăʂ̏̍Uɂ͍U鑤ɓo^͂ł܂B<br>
	 * Message: &#22312;&#22865;&#32004;&#20013;&#30340;&#19978;&#20301;&#22478;&#22561;&#25152;&#36914;&#34892;&#30340;&#25915;&#22478;&#25136;&#20013;&#65292;&#28961;&#27861;&#20197;&#25915;&#22478;&#26041;&#20358;&#30331;&#35352;&#12290;<br>
	 * Message: It is not possible to register for the castle siege side or castle siege of a higher castle in the contract
	 */
	public static final SystemMessageId NOT_POSSIBLE_TO_REGISTER_TO_CASTLE_SIEGE;
	
	/**
	 * ID: 2228<br>
	 * Message: pԐԂ̃CX^g ][F<br>
	 * Message: &#26377;&#35373;&#23450;&#38480;&#21046;&#21033;&#29992;&#26178;&#38291;&#30340;&#21363;&#26178;&#22320;&#21312;&#65306;<br>
	 * Message: Instance zone time limit:
	 */
	public static final SystemMessageId INSTANCE_ZONE_TIME_LIMIT;
	
	/**
	 * ID: 2229<br>
	 * Message: pԐԂ̃CX^g ][͂܂B<br>
	 * Message: &#27794;&#26377;&#38480;&#21046;&#21033;&#29992;&#26178;&#38291;&#30340;&#21363;&#26178;&#22320;&#21312;&#12290;<br>
	 * Message: There is no instance zone under a time limit
	 */
	public static final SystemMessageId NO_INSTANCEZONE_TIME_LIMIT;
	
	/**
	 * ID: 2230<br>
	 * Message: $s1 $s2 $s3ɂpł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21487;&#22312;&#12300;&#36;&#115;&#50;&#23567;&#26178;&#36;&#115;&#51;&#20998;&#12301;&#24460;&#20351;&#29992;&#12290;<br>
	 * Message: Available to use after $s1 $s2hour(s) $s3minute(s).
	 */
	public static final SystemMessageId AVAILABLE_AFTER_S1_S2_HOURS_S3_MINUTES;
	
	/**
	 * ID: 2231<br>
	 * Message: _񂵂Ăʂ̏̌lȂ߁A⋋ix܂łB<br>
	 * Message: &#22312;&#22865;&#32004;&#20013;&#30340;&#19978;&#20301;&#22478;&#22561;&#20854;&#34880;&#30431;&#32882;&#26395;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#25552;&#20379;&#35036;&#32102;&#21697;&#12290;<br>
	 * Message: The reputation score of the upper castle in contract is not enough and supply was not granted.
	 */
	public static final SystemMessageId REPUTATION_SCORE_FOR_CONTRACT_NOT_ENOUGH;
	
	/**
	 * ID: 2232<br>
	 * Message: $s1ӂOɃNX^CY܂B܂B<br>
	 * Message: &#22312;&#30772;&#22750;&#12300;&#36;&#115;&#49;&#12301;&#20043;&#21069;&#23559;&#36914;&#34892;&#32080;&#26230;&#21270;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: $s1 will be crystallized before destruction. Will you continue?
	 */
	public static final SystemMessageId S1_CRYSTALLIZED_BEFORE_DESTRUCTION;
	
	/**
	 * ID: 2233<br>
	 * Message: ʂ̏ƌ_񂵂Ă邽߁AUo^͂ł܂B<br>
	 * Message: &#33287;&#19978;&#20301;&#22478;&#22561;&#27491;&#34389;&#26044;&#22865;&#32004;&#20013;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#25915;&#22478;&#30331;&#35352;&#12290;<br>
	 * Message: Siege registration is not possible due to a contract with a higher castle.
	 */
	public static final SystemMessageId CANT_REGISTER_TO_SIEGE_DUE_TO_CONTRACT;
	
	/**
	 * ID: 2234<br>
	 * Message: IJ}Gp̉pYg܂B<br>
	 * Message: &#35201;&#20351;&#29992;&#25152;&#36984;&#30340;&#38343;&#22825;&#20351;&#19968;&#26063;&#23560;&#29992;&#30340;&#33521;&#38596;&#27494;&#22120;&#21966;&#65311;<br>
	 * Message: Will you use the selected Kamael-race-only Hero Weapon?
	 */
	public static final SystemMessageId CONFIRM_KAMAEL_HERO_WEAPON;
	
	/**
	 * ID: 2235<br>
	 * Message: p̃CX^g ][߁Ał܂B<br>
	 * Message: &#27491;&#22312;&#21033;&#29992;&#30340;&#21363;&#26178;&#22320;&#21312;&#24050;&#28040;&#22833;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: The instance zone in use has been deleted and cannot be accessed.
	 */
	public static final SystemMessageId INSTANCE_ZONE_DELETED_CANT_ACCESSED;
	
	/**
	 * ID: 2236<br>
	 * Message: Co[掞Ԃ͎c$s1łB<br>
	 * Message: &#39438;&#20056;&#39131;&#40845;&#30340;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: $s1 minute(s) left for wyvern riding.
	 */
	public static final SystemMessageId S1_MINUTES_LEFT_ON_WYVERN;
	
	/**
	 * ID: 2237<br>
	 * Message: Co[掞Ԃ͎c$s1błB<br>
	 * Message: &#39438;&#20056;&#39131;&#40845;&#30340;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: $s1 seconds(s) left for wyvern riding.
	 */
	public static final SystemMessageId S1_SECONDS_LEFT_ON_WYVERN;
	
	/**
	 * ID: 2238<br>
	 * Message: $s1̍UɎQ킵܂B̍U2ԍs܂B<br>
	 * Message: &#24050;&#21443;&#21152;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25915;&#22478;&#25136;&#12290;&#21443;&#21152;&#20013;&#30340;&#25915;&#22478;&#25136;&#23559;&#36914;&#34892;&#50;&#23567;&#26178;&#12290;<br>
	 * Message: You have participated in the siege of $s1. This siege will continue for 2 hours.
	 */
	public static final SystemMessageId PARTICIPATING_IN_SIEGE_OF_S1;
	
	/**
	 * ID: 2239<br>
	 * Message: Q킵$s1̍U킪I܂B<br>
	 * Message: &#21443;&#21152;&#20013;&#30340;&#12300;&#36;&#115;&#49;&#12301;&#25915;&#22478;&#25136;&#24050;&#32080;&#26463;&#12290;<br>
	 * Message: The siege of $s1, in which you are participating, has finished.
	 */
	public static final SystemMessageId SIEGE_OF_S1_FINIHSED;
	
	/**
	 * ID: 2240<br>
	 * Message: Ϗ̐\ݎ葱ł錌̓`[ og AWgɓo^ł܂B<br>
	 * Message: &#25552;&#20986;&#34880;&#30431;&#30431;&#20027;&#36681;&#35731;&#30003;&#35531;&#30340;&#34880;&#30431;&#65292;&#28961;&#27861;&#30331;&#35352;&#38538;&#20237;&#25136;&#39717;&#26681;&#25818;&#22320;&#25136;&#12290;<br>
	 * Message: You cannot register for the Team Battle Clan Hall War when your Clan Lord is on the waiting list for a transaction.
	 */
	public static final SystemMessageId CANT_REGISTER_TO_TEAM_BATTLE_CLAN_HALL_WAR_WHILE_LORD_ON_TRANSACTION_WAITING_LIST;
	
	/**
	 * ID: 2241<br>
	 * Message: `[ og AWgɓo^͌Ϗ̐\݂͂ł܂B<br>
	 * Message: &#30331;&#35352;&#38538;&#20237;&#25136;&#39717;&#26681;&#25818;&#22320;&#25136;&#30340;&#34880;&#30431;&#65292;&#28961;&#27861;&#25552;&#20986;&#34880;&#30431;&#30431;&#20027;&#36681;&#35731;&#30003;&#35531;&#12290;<br>
	 * Message: You cannot apply for a Clan Lord transaction if your clan has registed for the Team Battle Clan Hall War.
	 */
	public static final SystemMessageId CANT_APPLY_ON_LORD_TRANSACTION_WHILE_REGISTERED_TO_TEAM_BATTLE_CLAN_HALL_WAR;
	
	/**
	 * ID: 2242<br>
	 * Message: `[ og AWgɓo^͒Eނ͒Ǖł܂B<br>
	 * Message: &#30331;&#35352;&#38538;&#20237;&#25136;&#39717;&#26681;&#25818;&#22320;&#25136;&#30340;&#30431;&#21729;&#65292;&#28961;&#27861;&#36914;&#34892;&#33067;&#38626;&#25110;&#39493;&#36880;&#12290;<br>
	 * Message: Clan members cannot leave or be expelled when they are regisered for the Team Battle Clan Hall War.
	 */
	public static final SystemMessageId MEMBERS_CANT_LEAVE_WHEN_REGISTERED_TO_TEAM_BATTLE_CLAN_HALL_WAR;
	
	/**
	 * ID: 2243<br>
	 * Message: ȒAAr[Xg t@[ AWgL錌傪ϔCꍇAύX̌ł͂ȂύXǑ傪AWgɎQ܂B<br>
	 * Message: &#23665;&#36042;&#22478;&#23528;&#65292;&#20197;&#21450;&#25793;&#26377;&#37326;&#29560;&#36786;&#33674;&#26681;&#25818;&#22320;&#30340;&#34880;&#30431;&#20027;&#25509;&#21463;&#22996;&#20219;&#26178;&#65292;&#21443;&#21152;&#26681;&#25818;&#22320;&#25136;&#30340;&#26159;&#20043;&#21069;&#30340;&#34880;&#30431;&#20027;&#32780;&#19981;&#26159;&#26032;&#20219;&#30340;&#34880;&#30431;&#20027;&#12290;<br>
	 * Message: During the Bandit Stronghold or Wild Beast Reserve clan hall war, the previous clan lord rather than the new clan lord participates in battle.
	 */
	public static final SystemMessageId WHEN_BANDITSTRONGHOLD_WILDBEASTRESERVRE_CLANLORD_IN_DANGER_PREVIOUS_LORD_PARTICIPATES_IN_BATTLE;
	
	/**
	 * ID: 2244<br>
	 * Message: IԂ܂Ŏc$s1łB<br>
	 * Message: &#36317;&#38626;&#32080;&#26463;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: $s1 minute(s) remaining.
	 */
	public static final SystemMessageId S1_MINUTES_REMAINING;
	
	/**
	 * ID: 2245<br>
	 * Message: IԂ܂Ŏc$s1błB<br>
	 * Message: &#36317;&#38626;&#32080;&#26463;&#26178;&#38291;&#21097;&#19979;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#12290;<br>
	 * Message: $s1 second(s) remaining.
	 */
	public static final SystemMessageId S1_SECONDS_REMAINING;
	
	/**
	 * ID: 2246<br>
	 * Message: $s1ɗ\In܂܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#24460;&#23559;&#26371;&#33289;&#34892;&#38928;&#36093;&#12290;<br>
	 * Message: The contest will begin in $s1 minute(s).
	 */
	public static final SystemMessageId CONTEST_BEGIN_IN_S1_MINUTES;
	
	/**
	 * ID: 2247<br>
	 * Message: ϐg͏蕨ɓł܂B<br>
	 * Message: &#22312;&#35722;&#36523;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while transformed.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_TRANSFORMED;
	
	/**
	 * ID: 2248<br>
	 * Message: ΉԂł͏蕨ɓł܂B<br>
	 * Message: &#22312;&#30707;&#21270;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while petrified.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_PETRIFIED;
	
	/**
	 * ID: 2249<br>
	 * Message: SԂł͏蕨ɓł܂B<br>
	 * Message: &#22312;&#27515;&#20129;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while dead.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_DEAD;
	
	/**
	 * ID: 2250<br>
	 * Message: tBbVO͏蕨ɓł܂B<br>
	 * Message: &#22312;&#37347;&#39770;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while fishing.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_FISHING;
	
	/**
	 * ID: 2251<br>
	 * Message: 퓬͏蕨ɓł܂B<br>
	 * Message: &#22312;&#25136;&#39717;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while in battle.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_IN_BATTLE;
	
	/**
	 * ID: 2252<br>
	 * Message: ͏蕨ɓł܂B<br>
	 * Message: &#22312;&#27770;&#39717;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while in a duel.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_IN_A_DUEL;
	
	/**
	 * ID: 2253<br>
	 * Message: Ԃł͏蕨ɓł܂B<br>
	 * Message: &#22312;&#22352;&#19979;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while sitting.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_SITTING;
	
	/**
	 * ID: 2254<br>
	 * Message: XLr͏蕨ɓł܂B<br>
	 * Message: &#22312;&#26045;&#23637;&#25216;&#33021;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while casting.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_CASTING;
	
	/**
	 * ID: 2255<br>
	 * Message: ꂽ𑕔Ԃł͏蕨ɓł܂B<br>
	 * Message: &#22312;&#35037;&#20633;&#21463;&#35419;&#21650;&#30340;&#27494;&#22120;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship when a cursed weapon is equipped.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_A_CURSED_WEAPON_IS_EQUIPPED;
	
	/**
	 * ID: 2256<br>
	 * Message: Ԃł͏蕨ɓł܂B<br>
	 * Message: &#22312;&#25163;&#25345;&#26071;&#24159;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while holding a flag.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_HOLDING_A_FLAG;
	
	/**
	 * ID: 2257<br>
	 * Message: ybgяbԂł͏蕨ɓł܂B<br>
	 * Message: &#22312;&#21484;&#21914;&#23541;&#29289;&#25110;&#20351;&#39764;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#39438;&#20056;&#20219;&#20309;&#26481;&#35199;&#12290;<br>
	 * Message: You cannot board an airship while a pet or a servitor is summoned.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_A_PET_OR_A_SERVITOR_IS_SUMMONED;
	
	/**
	 * ID: 2258<br>
	 * Message: łɕʂ̏蕨ɓ悵ĂԂłB<br>
	 * Message: &#30446;&#21069;&#24050;&#26159;&#39438;&#20056;&#29376;&#24907;&#12290;<br>
	 * Message: You have already boarded another airship.
	 */
	public static final SystemMessageId YOU_HAVE_ALREADY_BOARDED_ANOTHER_AIRSHIP;
	
	/**
	 * ID: 2259<br>
	 * Message: ݒnF$s1A$s2A$s3 (z̓t)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#22818;&#24187;&#23798;&#38468;&#36817;&#65289;<br>
	 * Message: Current Location: $s1, $s2, $s3 (near Fantasy Isle)
	 */
	public static final SystemMessageId LOC_FANTASY_ISLAND_S1_S2_S3;
	
	/**
	 * ID: 2260<br>
	 * Message: 󕠊Q[W10ȏɖȂ΁AybgoƂ܂B<br>
	 * Message: &#33509;&#19981;&#23559;&#39165;&#39135;&#24230;&#32173;&#25345;&#22312;&#49;&#48;&#37;&#20197;&#19978;&#30340;&#35441;&#65292;&#23541;&#29289;&#26377;&#21487;&#33021;&#26371;&#36867;&#36305;&#12290;<br>
	 * Message: A pet can run away if you do not fill its hunger gauge to 10% or above.
	 */
	public static final SystemMessageId PET_CAN_RUN_AWAY_WHEN_HUNGER_BELOW_10_PERCENT;
	
	/**
	 * ID: 2261<br>
	 * Message: $c1$c2$s3̃_[W^܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#23565;&#12300;&#36;&#99;&#50;&#12301;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 has given $c2 damage of $s3.
	 */
	public static final SystemMessageId C1_GAVE_C2_DAMAGE_OF_S3;
	
	/**
	 * ID: 2262<br>
	 * Message: $c1$c2$s3̃_[W𕉂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34987;&#12300;&#36;&#99;&#50;&#12301;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 has received $s3 damage from $c2.
	 */
	public static final SystemMessageId C1_RECEIVED_DAMAGE_OF_S3_FROM_C2;
	
	/**
	 * ID: 2263<br>
	 * Message: $c1$c2ɂ$s3̃_[W𕉂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22240;&#12300;&#36;&#99;&#50;&#12301;&#36896;&#25104;&#20102;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 has received damage of $s3 through $c2.
	 */
	public static final SystemMessageId C1_RECEIVED_DAMAGE_OF_S3_THROUGH_C2;
	
	/**
	 * ID: 2264<br>
	 * Message: $c1$c2̍U܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#38275;&#38283;&#20102;&#12300;&#36;&#99;&#50;&#12301;&#30340;&#25915;&#25802;&#12290;<br>
	 * Message: $c1 has evaded $c2's attack.
	 */
	public static final SystemMessageId C1_EVADED_C2_ATTACK;
	
	/**
	 * ID: 2265<br>
	 * Message: $c1̍UO܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#25915;&#25802;&#20559;&#38626;&#20102;&#12290;<br>
	 * Message: $c1's attack went astray.
	 */
	public static final SystemMessageId C1_ATTACK_WENT_ASTRAY;
	
	/**
	 * ID: 2266<br>
	 * Message: $c1̃NeBJ qbgI<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#33268;&#21629;&#25915;&#25802;&#65281;<br>
	 * Message: $c1 had a critical hit!
	 */
	public static final SystemMessageId C1_HAD_CRITICAL_HIT;
	
	/**
	 * ID: 2267<br>
	 * Message: $c1$c2̃hCɒR܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25104;&#21151;&#25269;&#25239;&#12300;&#36;&#99;&#50;&#12301;&#30340;&#33021;&#37327;&#21560;&#21462;&#12290;<br>
	 * Message: $c1 resisted $c2's drain.
	 */
	public static final SystemMessageId C1_RESISTED_C2_DRAIN;
	
	/**
	 * ID: 2268<br>
	 * Message: $c1UɎs܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25915;&#25802;&#22833;&#25943;&#12290;<br>
	 * Message: $c1's attack failed.
	 */
	public static final SystemMessageId C1_ATTACK_FAILED;
	
	/**
	 * ID: 2269<br>
	 * Message: $c1$c2̖@ɒR܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25104;&#21151;&#25269;&#25239;&#12300;&#36;&#99;&#50;&#12301;&#30340;&#39764;&#27861;&#12290;<br>
	 * Message: $c1 resisted $c2's magic.
	 */
	public static final SystemMessageId C1_RESISTED_C2_DRAIN2;
	
	/**
	 * ID: 2270<br>
	 * Message: @̉ɂ$c1$s2̃_[W𕉂܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#22240;&#39764;&#27861;&#20043;&#28779;&#65292;&#36973;&#21463;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 has received damage from $s2 through the fire of magic
	 */
	public static final SystemMessageId C1_RECEIVED_DAMAGE_FROM_S2_THROUGH_FIRE_OF_MAGIC;
	
	/**
	 * ID: 2271<br>
	 * Message: $c1$c2̖@Ɏ኱R܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#23565;&#12300;&#36;&#99;&#50;&#12301;&#26045;&#23637;&#30340;&#39764;&#27861;&#26377;&#31245;&#20316;&#25269;&#25239;&#12290;<br>
	 * Message: $c1 weakly resisted $c2's magic.
	 */
	public static final SystemMessageId C1_WEAKLY_RESISTED_C2_MAGIC;
	
	/**
	 * ID: 2272<br>
	 * Message: ʃ`bg [hł͎w肵L[V[gJbgL[Ɏw肷邱Ƃ͂ł܂B<br>
	 * Message: &#22312;&#19968;&#33324;&#32842;&#22825;&#27169;&#24335;&#20013;&#65292;&#28961;&#27861;&#23559;&#25351;&#23450;&#30340;&#25353;&#37749;&#35373;&#23450;&#28858;&#24555;&#25463;&#37749;&#12290;<br>
	 * Message: You have selected shortcuts without settings up sub-keys. You can only use the set shortcut in the Enter Chat mode. Do you still wish to use the set shortcuts
	 */
	public static final SystemMessageId USE_SHORTCUT_CONFIRM;
	
	/**
	 * ID: 2273<br>
	 * Message: Tu NX̏Ԃł͏KłȂXLłBC NXɕύXĂxsĂB<br>
	 * Message: &#22312;&#21103;&#32887;&#26989;&#29376;&#24907;&#19979;&#28961;&#27861;&#23416;&#32722;&#27492;&#25216;&#33021;&#65292;&#36681;&#25563;&#28858;&#20027;&#32887;&#26989;&#24460;&#35531;&#37325;&#26032;&#20877;&#35430;&#12290;<br>
	 * Message: This skill cannot be learned while in the sub-class state. Please try again after changing to the main class.
	 */
	public static final SystemMessageId SKILL_NOT_FOR_SUBCLASS;
	
	/**
	 * ID: 2274<br>
	 * Message: ACêĂ邱ƂłȂGAɓ܂B<br>
	 * Message: &#24744;&#24050;&#36914;&#20837;&#28961;&#27861;&#19999;&#26820;&#36947;&#20855;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: You entered an area where you cannot throw away items.
	 */
	
	/**
	 * ID: 2275<br>
	 * Message: ybg̏łȂGAɂ܂B<br>
	 * Message: &#24050;&#36914;&#20837;&#28961;&#27861;&#21484;&#21914;&#47;&#35299;&#38500;&#23541;&#29289;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: You are in an area where you cannot cancel pet summoning.
	 */
	
	/**
	 * ID: 2276<br>
	 * Message: WX^X̗vǂD҂܂B<br>
	 * Message: &#21467;&#20098;&#36557;&#24050;&#20308;&#38936;&#35201;&#22622;&#12290;<br>
	 * Message: The rebel army recaptured the fortress.
	 */
	public static final SystemMessageId NPCS_RECAPTURED_FORTRESS;
	
	/**
	 * ID: 2277<br>
	 * Message: $s1̃p[eB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#38538;&#20237;<br>
	 * Message: Party of $s1
	 */
	
	/**
	 * ID: 2278<br>
	 * Message: c莞$s1:$s2<br>
	 * Message: &#21097;&#39192;&#26178;&#38291;&#12300;&#36;&#115;&#49;&#65306;&#36;&#115;&#50;&#12301;<br>
	 * Message: Remaining Time $s1:$s2
	 */
	
	/**
	 * ID: 2279<br>
	 * Message: NGXg A[gɃNGXgo^ł܂B<br>
	 * Message: &#24050;&#28961;&#27861;&#22312;&#20219;&#21209;&#35338;&#24687;&#30331;&#37636;&#20219;&#21209;&#12290;<br>
	 * Message: You can no longer add a quest to the Quest Alterts.
	 */
	
	/**
	 * ID: 2280<br>
	 * Message: $c1$c2̖@ɒRă_[W܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#25269;&#25239;&#12300;&#36;&#99;&#50;&#12301;&#30340;&#39764;&#27861;&#65292;&#22240;&#27492;&#38477;&#20302;&#20102;&#20663;&#23475;&#12290;<br>
	 * Message: Damage is decreased because $c1 resisted $c2's magic.
	 */
	
	/**
	 * ID: 2281<br>
	 * Message: $c1$c2$s3̃_[WA_[WȎ$s4̃_[W^܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#21521;&#12300;&#36;&#99;&#50;&#12301;&#21152;&#20197;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#20663;&#23475;&#12289;&#21521;&#36681;&#31227;&#20663;&#23475;&#30340;&#30446;&#27161;&#21152;&#20197;&#12300;&#36;&#115;&#52;&#12301;&#30340;&#20663;&#23475;&#12290;<br>
	 * Message: $c1 hit you for $s3 damage and hit your servitor for $s4.
	 */
	
	/**
	 * ID: 2282<br>
	 * Message: z̓o܂B<br>
	 * Message: &#38626;&#38283;&#22818;&#24187;&#23798;&#12290;<br>
	 * Message: Leave Fantasy Isle.
	 */
	
	/**
	 * ID: 2283<br>
	 * Message: Ԃł͕ϐgł܂B<br>
	 * Message: &#35282;&#33394;&#22352;&#19979;&#26178;&#28961;&#27861;&#35722;&#36523;&#12290;<br>
	 * Message: You cannot transform while sitting.
	 */
	public static final SystemMessageId CANNOT_TRANSFORM_WHILE_SITTING;
	
	/**
	 * ID: 2291<br>
	 * Message: p[eBɎQԂł̂݋@B삪\łB<br>
	 * Message: &#22312;&#21443;&#33287;&#38538;&#20237;&#30340;&#29376;&#24907;&#19979;&#25165;&#33021;&#25805;&#20316;&#27231;&#26800;&#12290;<br>
	 * Message: You can operate the machine when you participate in the party.
	 */
	public static final SystemMessageId CAN_OPERATE_MACHINE_WHEN_IN_PARTY;
	
	/**
	 * ID: 2293<br>
	 * Message: ݒnF$s1A$s2A$s3 (|S̏)<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#37628;&#37941;&#20043;&#22478;&#20839;&#37096;&#65289;<br>
	 * Message: Current location: $s1, $s2, $s3 (inside the Steel Citadel)
	 */
	public static final SystemMessageId LOC_IN_STEEL_CITADEL_S1_S2_S3;
	
	/**
	 * ID: 2296<br>
	 * Message: oC^eB |Cgl܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#27963;&#21147;&#40670;&#25976;&#12290;<br>
	 * Message: You have gained Vitality points.
	 */
	public static final SystemMessageId GAINED_VITALITY_POINTS;
	
	/**
	 * ID: 2301<br>
	 * Message: ݒnF|S̏s<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#65288;&#37628;&#37941;&#20043;&#22478;&#20839;&#22478;&#65289;<br>
	 * Message: Current location: Steel Citadel
	 */
	public static final SystemMessageId LOC_STEEL_CITADEL;
	
	/**
	 * ID: 2302<br>
	 * Message: gbsO ACe܂Be̋Ȅlv[g󂯎܂B<br>
	 * Message: &#24744;&#29554;&#24471;&#20102;&#32173;&#20182;&#21629;&#36947;&#20855;&#12290;&#21069;&#24448;&#21508;&#26449;&#33674;&#23563;&#25214;&#32173;&#20182;&#21629;&#31649;&#29702;&#32773;&#65292;&#23601;&#33021;&#24471;&#21040;&#35442;&#36947;&#20855;&#12290;<br>
	 * Message: Your Vitamin Item has arrived! Visit the Vitamin Manager in any village to obtain it
	 */
	public static final SystemMessageId YOUR_VITAMIN_ITEM_HAS_ARRIVED;
	
	/**
	 * ID: 2303<br>
	 * Message: $s1̍ĎgpԂ͎c$s2błB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20877;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#31186;&#12290;<br>
	 * Message: There are $s2 second(s) remaining in $s1's re-use time.
	 */
	public static final SystemMessageId S2_SECONDS_REMAINING_FOR_REUSE_S1;
	
	/**
	 * ID: 2304<br>
	 * Message: $s1̍ĎgpԂ͎c$s2$s3błB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20877;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#12301;&#20998;&#12300;&#36;&#115;&#51;&#12301;&#31186;&#12290;<br>
	 * Message: There are $s2 minute(s), $s3 second(s) remaining in $s1's re-use time.
	 */
	public static final SystemMessageId S2_MINUTES_S3_SECONDS_REMAINING_FOR_REUSE_S1;
	
	/**
	 * ID: 2305<br>
	 * Message: $s1̍ĎgpԂ͎c$s2$s3$s4błB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#30340;&#20877;&#20351;&#29992;&#26178;&#38291;&#36996;&#21097;&#19979;&#12300;&#36;&#115;&#50;&#23567;&#26178;&#32;&#36;&#115;&#51;&#20998;&#32;&#36;&#115;&#52;&#31186;&#12301;&#12290;<br>
	 * Message: There are $s2 hour(s), $s3 minute(s), and $s4 second(s) remaining in $s1's re-use time.
	 */
	public static final SystemMessageId S2_HOURS_S3_MINUTES_S4_SECONDS_REMAINING_FOR_REUSE_S1;
	
	/**
	 * ID: 2306<br>
	 * Message: EĈ̌ʂɂ蕜ł܂Bɕ܂B\n<br>
	 * Message: &#21033;&#29992;&#21191;&#27683;&#35703;&#31526;&#21487;&#20197;&#24489;&#27963;&#12290;&#35201;&#29694;&#22312;&#24489;&#27963;&#21966;&#65311;<br>
	 * Message: Resurrection is possible because of the courage charm's effect. Would you like to resurrect now?
	 */
	public static final SystemMessageId RESURRECT_USING_CHARM_OF_COURAGE;
	
	/**
	 * ID: 2311<br>
	 * Message: b܂B<br>
	 * Message: &#27794;&#26377;&#20351;&#39764;&#12290;<br>
	 * Message: You do not have a servitor.
	 */
	public static final SystemMessageId DONT_HAVE_SERVITOR;
	
	/**
	 * ID: 2312<br>
	 * Message: ybg܂B<br>
	 * Message: &#27794;&#26377;&#23541;&#29289;&#12290;<br>
	 * Message: You do not have a pet.
	 */
	public static final SystemMessageId DONT_HAVE_PET;
	
	/**
	 * ID: 2314<br>
	 * Message: oC^eBӂ܂B<br>
	 * Message: &#27963;&#21147;&#20805;&#27803;&#12290;<br>
	 * Message: Your Vitality is at maximum.
	 */
	public static final SystemMessageId VITALITY_IS_AT_MAXIMUM;
	
	/**
	 * ID: 2315<br>
	 * Message: oC^eB܂B<br>
	 * Message: &#27963;&#21147;&#22686;&#21152;&#12290;<br>
	 * Message: You have gained Vitality points.
	 */
	public static final SystemMessageId VITALITY_HAS_INCREASED;
	
	/**
	 * ID: 2316<br>
	 * Message: oC^eB܂B<br>
	 * Message: &#27963;&#21147;&#38477;&#20302;&#12290;<br>
	 * Message: You have lost Vitality points.
	 */
	public static final SystemMessageId VITALITY_HAS_DECREASED;
	
	/**
	 * ID: 2317<br>
	 * Message: oC^eBׂĂȂȂ܂B<br>
	 * Message: &#27963;&#21147;&#32791;&#30433;&#12290;<br>
	 * Message: Your Vitality is fully exhausted.
	 */
	public static final SystemMessageId VITALITY_IS_EXHAUSTED;
	
	/**
	 * ID: 2319<br>
	 * Message: $s1̖lɓ܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#32882;&#26395;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: You have acquired $s1 reputation score.
	 */
	public static final SystemMessageId ACQUIRED_S1_REPUTATION_SCORE;
	
	/**
	 * ID: 2321<br>
	 * Message: ݒnFJ}J<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#27442;&#30028;&#20839;&#37096;<br>
	 * Message: Current location: Inside Kamaloka
	 */
	public static final SystemMessageId LOC_KAMALOKA;
	
	/**
	 * ID: 2322<br>
	 * Message: ݒnFjA J}J<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36817;&#32227;&#27442;&#30028;&#20839;&#37096;<br>
	 * Message: Current location: Inside Nia Kamaloka
	 */
	
	public static final SystemMessageId LOC_NIA_KAMALOKA;
	/**
	 * ID: 2323<br>
	 * Message: ݒnF J}J<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#37002;&#32227;&#27442;&#30028;&#20839;&#37096;<br>
	 * Message: Current location: Inside Rim Kamaloka
	 */
	public static final SystemMessageId LOC_RIM_KAMALOKA;
	
	/**
	 * ID: 2326<br>
	 * Message: l 50_l܂B<br>
	 * Message: &#24744;&#29554;&#24471;&#20102;&#34880;&#30431;&#32882;&#26395;&#12300;&#53;&#48;&#12301;&#40670;&#12290;<br>
	 * Message: You have acquired 50 Clan's Fame Points..
	 */
	public static final SystemMessageId ACQUIRED_50_CLAN_FAME_POINTS;
	
	/**
	 * ID: 2327<br>
	 * Message: l܂B<br>
	 * Message: &#32882;&#26395;&#19981;&#36275;&#12290;<br>
	 * Message: You don't have enough reputation score.
	 */
	public static final SystemMessageId NOT_ENOUGH_FAME_POINTS;
	
	/**
	 * ID: 2333<br>
	 * Message: Cxg̏d/𒴂Ă邽߁AgbsO ACe܂B<br>
	 * Message: &#36947;&#20855;&#28165;&#21934;&#30340;&#37325;&#37327;&#47;&#25976;&#37327;&#36229;&#36942;&#38480;&#21046;&#65292;&#22240;&#27492;&#28961;&#27861;&#24471;&#21040;&#29518;&#21237;&#36947;&#20855;&#12290;<br>
	 * Message: You cannot receive the vitamin item because you have exceed your inventory weight/quantity limit.
	 */
	public static final SystemMessageId YOU_CANNOT_RECEIVE_THE_VITAMIN_ITEM;
	
	/**
	 * ID: 2335<br>
	 * Message: 󂯎gbsO ACe͂܂B<br>
	 * Message: &#24050;&#28961;&#21487;&#21462;&#22238;&#30340;&#32173;&#20182;&#21629;&#36947;&#20855;&#12290;<br>
	 * Message: There are no more vitamin items to be found
	 */
	public static final SystemMessageId THERE_ARE_NO_MORE_VITAMIN_ITEMS_TO_BE_FOUND;
	
	/**
	 * ID: 2336<br>
	 * Message: n[tLI<br>
	 * Message: &#28693;&#27515;&#25915;&#25802;&#65281;<br>
	 * Message: Half-Kill!
	 */
	public static final SystemMessageId HALF_KILL;
	
	/**
	 * ID: 2337<br>
	 * Message: n[t LXLɓCP܂B<br>
	 * Message: &#36973;&#21463;&#28693;&#27515;&#25915;&#25802;&#25216;&#33021;&#65292;&#23566;&#33268;&#67;&#80;&#28040;&#22833;&#12290;<br>
	 * Message: Your CP was drained because you were hit with a CP siphon skill.
	 */
	public static final SystemMessageId CP_DISAPPEARS_WHEN_HIT_WITH_A_HALF_KILL_SKILL;
	
	/**
	 * ID: 2348<br>
	 * Message: 퓬̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#25136;&#39717;&#20043;&#20013;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports during a battle.
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_BATTLE;
	
	/**
	 * ID: 2349<br>
	 * Message: UAvǐAAWgȂǂ̑K͐퓬ւ̎Q̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#21443;&#21152;&#25915;&#22478;&#25136;&#12289;&#35201;&#22622;&#25136;&#12289;&#26681;&#25818;&#22320;&#25136;&#31561;&#22823;&#35215;&#27169;&#30340;&#25136;&#39717;&#26178;&#65292;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports while participating a large-scale battle such as a castle siege, fortress siege, or hideout siege..
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING;
	
	/**
	 * ID: 2350<br>
	 * Message: ̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#27770;&#39717;&#20043;&#20013;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports during a duel
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_DUEL;
	
	/**
	 * ID: 2351<br>
	 * Message: s̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#39131;&#34892;&#36884;&#20013;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports while flying
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_WHILE_FLYING;
	
	/**
	 * ID: 2352<br>
	 * Message: IsA[hZis̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#27604;&#36093;&#36914;&#34892;&#30070;&#20013;&#65292;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports while participating in an Olympiad match
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING_IN_AN_OLYMPIAD_MATCH;
	
	/**
	 * ID: 2353<br>
	 * Message: ΉA჏Ԃł̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#22312;&#30707;&#21270;&#29376;&#24907;&#25110;&#40635;&#30202;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#36914;&#34892;&#20659;&#36865;&#12290;<br>
	 * Message: You cannot use My Teleports while you are in a flint or paralyzed state
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_PARALYZED;
	
	/**
	 * ID: 2354<br>
	 * Message: SԂł̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#22312;&#27515;&#20129;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports while you are dead
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_DEAD;
	
	/**
	 * ID: 2355<br>
	 * Message: ̒nł̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#30446;&#21069;&#34389;&#26044;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#30340;&#22320;&#21312;&#20013;&#12290;<br>
	 * Message: You cannot use My Teleports in this area
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_IN_THIS_AREA;
	
	/**
	 * ID: 2356<br>
	 * Message: ł̓t[e|[g@\͎gpł܂B<br>
	 * Message: &#22312;&#27700;&#20013;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports underwater
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_UNDERWATER;
	
	/**
	 * ID: 2357<br>
	 * Message: CX^g][ł t[e|[g@\͎gpł܂B<br>
	 * Message: &#22312;&#21363;&#26178;&#22320;&#21312;&#28961;&#27861;&#20351;&#29992;&#33258;&#30001;&#20659;&#36865;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot use My Teleports in an instant zone
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_IN_AN_INSTANT_ZONE;
	
	/**
	 * ID: 2358<br>
	 * Message: e|[gʒuۑXy[X܂B<br>
	 * Message: &#27794;&#26377;&#21097;&#39192;&#30340;&#31354;&#38291;&#20786;&#23384;&#26360;&#31844;&#12290;<br>
	 * Message: You have no space to save the teleport location
	 */
	public static final SystemMessageId YOU_HAVE_NO_SPACE_TO_SAVE_THE_TELEPORT_LOCATION;
	
	/**
	 * ID: 2359<br>
	 * Message: e|[gACeȂ߁Ae|[gł܂B<br>
	 * Message: &#27794;&#26377;&#20659;&#36865;&#36947;&#20855;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#20659;&#36865;&#12290;<br>
	 * Message: You cannot teleport because you do not have a teleport item
	 */
	public static final SystemMessageId YOU_CANNOT_TELEPORT_BECAUSE_YOU_DO_NOT_HAVE_A_TELEPORT_ITEM;
	
	/**
	 * ID: 2361<br>
	 * Message: ݒnF$s1<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Current Location: $s1
	 */
	public static final SystemMessageId CURRENT_LOCATION_S1;
	
	/**
	 * ID: 2366<br>
	 * Message: ԌACe폜܂B<br>
	 * Message: &#24050;&#21034;&#38500;&#38480;&#26178;&#36947;&#20855;&#12290;<br>
	 * Message: The limited-time item has been deleted..
	 */
	public static final SystemMessageId TIME_LIMITED_ITEM_DELETED;
	
	/**
	 * ID: 2372<br>
	 * Message: ngT|[gybg܂ȂȂȂ܂B<br>
	 * Message: &#29417;&#29557;&#24171;&#25163;&#23541;&#29289;&#30340;&#38626;&#38283;&#30340;&#26178;&#38291;&#24050;&#21097;&#19979;&#19981;&#22810;&#12290;<br>
	 * Message: There is not much time remaining until the hunting helper pet leaves.
	 */
	public static final SystemMessageId THERE_NOT_MUCH_TIME_REMAINING_UNTIL_HELPER_LEAVES;
	
	/**
	 * ID: 2373<br>
	 * Message: ngT|[gybgȂ̂Ƃ狎鎞ԂƂȂ܂B<br>
	 * Message: &#29417;&#29557;&#24171;&#25163;&#23541;&#29289;&#30340;&#38626;&#38283;&#26178;&#38291;&#24050;&#21040;&#65292;&#22240;&#27492;&#23559;&#26371;&#38626;&#38283;&#24744;&#12290;<br>
	 * Message: The hunting helper pet is now leaving.
	 */
	public static final SystemMessageId THE_HELPER_PET_LEAVING;
	
	/**
	 * ID: 2375<br>
	 * Message: ngT|[gybg܂ȂȂȂ܂B͖߂܂B<br>
	 * Message: &#38626;&#38283;&#26178;&#38291;&#21097;&#19979;&#19981;&#22810;&#30340;&#29417;&#29557;&#24171;&#25163;&#23541;&#29289;&#23559;&#28961;&#27861;&#25910;&#22238;&#12290;<br>
	 * Message: The hunting helper pet cannot be returned ecause there is not much time remaining until it leaves.
	 */
	public static final SystemMessageId THE_HELPER_PET_CANNOT_BE_RETURNED;
	
	/**
	 * ID: 2376<br>
	 * Message: ɂ̓gbsO ACe󂯎܂B<br>
	 * Message: &#20132;&#26131;&#36884;&#20013;&#28961;&#27861;&#38936;&#21462;&#32173;&#20182;&#21629;&#36947;&#20855;&#12290;<br>
	 * Message: You cannot receive a vitamin item during an exchange.
	 */
	public static final SystemMessageId YOU_CANNOT_RECEIVE_A_VITAMIN_ITEM_DURING_AN_EXCHANGE;
	
	/**
	 * ID: 2390<br>
	 * Message: t[e|[g XbgőɊgĂ܂Bȏ̊g͂ł܂B<br>
	 * Message: &#33258;&#30001;&#20659;&#36865;&#27396;&#20301;&#24050;&#25844;&#20805;&#33267;&#26368;&#22823;&#26997;&#38480;&#65292;&#28961;&#27861;&#32380;&#32396;&#25844;&#20805;&#12290;<br>
	 * Message: Your number of My Teleports slots has reached its maximum limit.
	 */
	public static final SystemMessageId YOUR_NUMBER_OF_MY_TELEPORTS_SLOTS_HAS_REACHED_ITS_MAXIMUM_LIMIT;
	
	/**
	 * ID: 2396<br>
	 * Message: ybg/b̂̃XL͍Ďgpł邽ߎg܂B<br>
	 * Message: &#23541;&#29289;&#47;&#20351;&#39764;&#30340;&#27492;&#25216;&#33021;&#27491;&#22312;&#20919;&#21371;&#20013;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#12290;<br>
	 * Message: That pet/servitor skill cannot be used because it is recharging.
	 */
	public static final SystemMessageId PET_SKILL_CANNOT_BE_USED_RECHARCHING;
	
	/**
	 * ID: 2398<br>
	 * Message: XbgANeBuɂȂĂ܂B<br>
	 * Message: &#23578;&#26410;&#25844;&#20805;&#27396;&#20301;&#12290;<br>
	 * Message: You have no open My Teleports slots.
	 */
	public static final SystemMessageId YOU_HAVE_NO_OPEN_MY_TELEPORTS_SLOTS;
	
	/**
	 * ID: 2440<br>
	 * Message: $c1 ̓NXZڂ̑ҋ@҃Xgɂłɓo^Ă܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#30331;&#35352;&#22312;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#38538;&#20237;&#27604;&#36093;&#38917;&#30446;&#30340;&#31561;&#24453;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: $c1 is already registered on the waiting list for the non-class-limited match event.
	 */
	public static final SystemMessageId C1_IS_ALREADY_REGISTERED_NON_CLASS_LIMITED_EVENT_TEAMS;
	
	/**
	 * ID: 2441<br>
	 * Message: `[Z̐\݂̓p[eB[_[ł܂B<br>
	 * Message: &#21482;&#26377;&#38538;&#38263;&#25165;&#33021;&#30003;&#35531;&#38538;&#20237;&#27604;&#36093;&#12290;<br>
	 * Message: Only a party leader can request a team match.
	 */
	public static final SystemMessageId ONLY_PARTY_LEADER_CAN_REQUEST_TEAM_MATCH;
	
	/**
	 * ID: 2442<br>
	 * Message: Ȃ߁A\݂ł܂B`[ZɎQ邽߂ɂ3lȏ̃p[eBȂ΂Ȃ܂B<br>
	 * Message: &#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#30003;&#35531;&#12290;&#33509;&#35201;&#21443;&#21152;&#38538;&#20237;&#27604;&#36093;&#65292;&#24517;&#38920;&#35201;&#30001;&#51;&#20154;&#32068;&#25104;&#38538;&#20237;&#25165;&#34892;&#12290;<br>
	 * Message: The request cannot be made because the requirements have not been made. To participate in a team match you must first form a 3-member party.
	 */
	public static final SystemMessageId PARTY_REQUIREMENTS_NOT_MET;
	
	/**
	 * ID: 2936<br>
	 * Message: ̗̒nƃXN[vȂ߁AUł܂B<br>
	 * Message: &#25152;&#23660;&#38936;&#22320;&#21644;&#20605;&#35037;&#21367;&#36600;&#19981;&#19968;&#33268;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#20605;&#35037;&#12290;<br>
	 * Message: The disguise scroll cannot be used because it is meant for use in a different territory.
	 */
	public static final SystemMessageId THE_DISGUISE_SCROLL_MEANT_FOR_DIFFERENT_TERRITORY;
	
	/**
	 * ID: 2937<br>
	 * Message: ̒nĂ錌̌͋Uł܂B<br>
	 * Message: &#25793;&#26377;&#38936;&#22320;&#30340;&#34880;&#30431;&#25104;&#21729;&#28961;&#27861;&#36914;&#34892;&#20605;&#35037;&#12290;<br>
	 * Message: A territory owning clan member cannot use a disguise scroll.
	 */
	public static final SystemMessageId TERRITORY_OWNING_CLAN_CANNOT_USE_DISGUISE_SCROLL;
	
	/**
	 * ID: 2955<br>
	 * Message: ̒np̋UAϐg͗̒nJn20OI10܂Ŏg܂B<br>
	 * Message: &#38936;&#22320;&#25136;&#23560;&#29992;&#20605;&#35037;&#21450;&#35722;&#36523;&#65292;&#21487;&#22312;&#38936;&#22320;&#25136;&#38283;&#22987;&#21069;&#50;&#48;&#20998;&#37912;&#33267;&#32080;&#26463;&#24460;&#49;&#48;&#20998;&#37912;&#20043;&#20839;&#20351;&#29992;&#12290;<br>
	 * Message: The territory war exclusive disguise and transformation can be used 20 minutes before the start of the territory war to 10 minutes after its end.
	 */
	public static final SystemMessageId TERRITORY_WAR_SCROLL_CAN_NOT_USED_NOW;
	
	/**
	 * ID: 2400<br>
	 * Message: ݎgp̃CX^g ][F$s1<br>
	 * Message: &#30446;&#21069;&#27491;&#22312;&#21033;&#29992;&#30340;&#21363;&#26178;&#22320;&#21312;&#65306;&#12300;&#36;&#115;&#49;&#12301;<br>
	 * Message: Instant Zone currently in use: $s1
	 */
	public static final SystemMessageId INSTANT_ZONE_CURRENTLY_INUSE_S1;
	
	/**
	 * ID: 2402<br>
	 * Message: ̒n̐\݂͊ɒߐ؂Ă܂B<br>
	 * Message: &#38936;&#22320;&#25136;&#30003;&#35531;&#26399;&#38291;&#24050;&#25130;&#27490;&#12290;<br>
	 * Message: The Territory War request period has ended.
	 */
	public static final SystemMessageId THE_TERRITORY_WAR_REGISTERING_PERIOD_ENDED;
	
	/**
	 * ID: 2403<br>
	 * Message: ̒nJn܂ł10łB<br>
	 * Message: &#38936;&#22320;&#25136;&#38283;&#22987;&#30340;&#21069;&#49;&#48;&#20998;&#37758;&#65281;<br>
	 * Message: Territory War begins in 10 minutes!
	 */
	public static final SystemMessageId TERRITORY_WAR_BEGINS_IN_10_MINUTES;
	
	/**
	 * ID: 2404<br>
	 * Message: ̒nJn܂ł5łB<br>
	 * Message: &#38936;&#22320;&#25136;&#38283;&#22987;&#30340;&#21069;&#53;&#20998;&#37758;&#65281;<br>
	 * Message: Territory War begins in 5 minutes!
	 */
	public static final SystemMessageId TERRITORY_WAR_BEGINS_IN_5_MINUTES;
	
	/**
	 * ID: 2405<br>
	 * Message: ̒nJn܂ł1łB<br>
	 * Message: &#38936;&#22320;&#25136;&#38283;&#22987;&#30340;&#21069;&#49;&#20998;&#37758;&#65281;<br>
	 * Message: Territory War begins in 1 minute!
	 */
	public static final SystemMessageId TERRITORY_WAR_BEGINS_IN_1_MINUTE;
	
	/**
	 * ID: 2408<br>
	 * Message: NXZڂ̑ҋ@҃Xgɓo^܂B<br>
	 * Message: &#24050;&#30331;&#35352;&#22312;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#38538;&#20237;&#27604;&#36093;&#38917;&#30446;&#30340;&#31561;&#24453;&#32773;&#21517;&#21934;&#20043;&#20013;&#12290;<br>
	 * Message: You have registered on the waiting list for the non-class-limited team match event.
	 */
	public static final SystemMessageId YOU_HAVE_REGISTERED_IN_A_WAITING_LIST_OF_TEAM_GAMES;
	
	/**
	 * ID: 2409<br>
	 * Message: t[e|[g Xbgg܂B<br>
	 * Message: &#24050;&#25844;&#20805;&#33258;&#30001;&#20659;&#36865;&#27396;&#20301;&#12290;<br>
	 * Message: The number of My Teleports slots has been increased.
	 */
	public static final SystemMessageId THE_NUMBER_OF_MY_TELEPORTS_SLOTS_HAS_BEEN_INCREASED;
	
	/**
	 * ID: 2410<br>
	 * Message: t[e|[gł͍sȂnłB<br>
	 * Message: &#21033;&#29992;&#33258;&#30001;&#20659;&#36865;&#28961;&#27861;&#31227;&#21205;&#21040;&#24744;&#35201;&#21069;&#24448;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: You cannot use My Teleports to reach this area!
	 */
	public static final SystemMessageId YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA;
	
	/**
	 * ID: 2424<br>
	 * Message: ̏WɎs܂B<br>
	 * Message: &#25505;&#38598;&#22833;&#25943;&#12290;<br>
	 * Message: The collection has failed.
	 */
	public static final SystemMessageId THE_COLLECTION_HAS_FAILED;
	
	/**
	 * ID: 2448<br>
	 * Message: a߂łƂ܂IAOAo[XfC v[g͂܂B<br>
	 * Message: &#29983;&#26085;&#24555;&#27138;&#65281;&#29983;&#26085;&#21916;&#24709;&#31934;&#38728;&#23559;&#26371;&#30332;&#36865;&#31150;&#29289;&#32102;&#24744;&#12290;<br>
	 * Message: Your birthday gift has arrived
	 */
	public static final SystemMessageId YOUR_BIRTHDAY_GIFT_HAS_ARRIVED;
	
	/**
	 * ID: 2449<br>
	 * Message: a܂ł$s1łBaɂȂAAOAS߂ďv[gXւł͂܂B<br>
	 * Message: &#38626;&#29983;&#26085;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#22825;&#12290;&#22312;&#29983;&#26085;&#30070;&#22825;&#65292;&#29983;&#26085;&#21916;&#24709;&#31934;&#38728;&#23559;&#26371;&#37109;&#23492;&#35488;&#24515;&#35488;&#24847;&#28858;&#24744;&#28310;&#20633;&#30340;&#31150;&#29289;&#32102;&#24744;&#12290;<br>
	 * Message: There are $s1 days until your character's birthday.
	 */
	public static final SystemMessageId THERE_ARE_S1_DAYS_UNTIL_YOUR_CHARACTERS_BIRTHDAY;
	
	/**
	 * ID: 2450<br>
	 * Message: $c1 ̒a$s2N$s3$s4łB<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24744;&#30340;&#29983;&#26085;&#28858;&#12300;&#36;&#115;&#50;&#12301;&#24180;&#12300;&#36;&#115;&#51;&#12301;&#26376;&#12300;&#36;&#115;&#52;&#12301;&#26085;&#12290;<br>
	 * Message: $c1's character birthday is $s3/$s4/$s2.
	 */
	public static final SystemMessageId C1_BIRTHDAY_IS_S3_S4_S2;
	
	/**
	 * ID: 2451<br>
	 * Message: A[}[ Zbg̑߁AN[N̑܂B<br>
	 * Message: &#24050;&#35299;&#38500;&#35703;&#30002;&#22871;&#35037;&#65292;&#22240;&#27492;&#20063;&#23559;&#21368;&#38500;&#26007;&#31735;&#12290;<br>
	 * Message: The cloak equip has been removed because the armor set equip has been removed.
	 */
	public static final SystemMessageId CLOAK_REMOVED_BECAUSE_ARMOR_SET_REMOVED;
	
	/**
	 * ID: 2455<br>
	 * Message: ꂽsD݂Ȃ߁Ał܂B<br>
	 * Message: &#27794;&#26377;&#34987;&#21484;&#21914;&#30340;&#39131;&#31354;&#33351;&#65292;&#22240;&#27492;&#28961;&#27861;&#25645;&#20056;&#39131;&#31354;&#33351;&#12290;<br>
	 * Message: The airship must be summoned in order for you to board.
	 */
	public static final SystemMessageId THE_AIRSHIP_MUST_BE_SUMMONED_TO_BOARD;
	
	/**
	 * ID: 2456<br>
	 * Message: sDlɂ́Ax5ȏłȂ΂Ȃ܂B<br>
	 * Message: &#22914;&#26524;&#24819;&#35201;&#29554;&#24471;&#39131;&#31354;&#33351;&#65292;&#34880;&#30431;&#31561;&#32026;&#24517;&#38920;&#35201;&#36948;&#21040;&#31561;&#32026;&#53;&#25165;&#34892;&#12290;<br>
	 * Message: In order to acquire an airship, the clan's level must be level 5 or higher.
	 */
	public static final SystemMessageId THE_AIRSHIP_NEED_CLANLVL_5_TO_SUMMON;
	
	/**
	 * ID: 2457<br>
	 * Message: sD͂ĂȂAL̔sD݂Ȃ߁AsDł܂B<br>
	 * Message: &#23578;&#26410;&#36664;&#20837;&#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#65292;&#25110;&#32773;&#27794;&#26377;&#23660;&#26044;&#34880;&#30431;&#30340;&#39131;&#31354;&#33351;&#65292;&#22240;&#27492;&#28961;&#27861;&#21484;&#21914;&#39131;&#31354;&#33351;&#12290;<br>
	 * Message: An airship cannot be summoned because either you have not registered your airship license, or the airship has not yet been summoned
	 */
	public static final SystemMessageId THE_AIRSHIP_NEED_LICENSE_TO_SUMMON;
	
	/**
	 * ID: 2458<br>
	 * Message: L̔sD͂łɑ̌gpĂ܂B<br>
	 * Message: &#23660;&#26044;&#34880;&#30431;&#30340;&#39131;&#31354;&#33351;&#24050;&#34987;&#20854;&#20182;&#34880;&#30431;&#25104;&#21729;&#20351;&#29992;&#12290;<br>
	 * Message: The airship owned by the clan is already being used by another clan member.
	 */
	public static final SystemMessageId THE_AIRSHIP_ALREADY_USED;
	
	/**
	 * ID: 2459<br>
	 * Message: sDłɊlĂ܂B<br>
	 * Message: &#24050;&#29554;&#24471;&#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#12290;<br>
	 * Message: The Airship Summon License has already been acquired.
	 */
	public static final SystemMessageId THE_AIRSHIP_SUMMON_LICENSE_ALREADY_ACQUIRED;
	
	/**
	 * ID: 2460<br>
	 * Message: L̔sD͂łɑ݂Ă܂B<br>
	 * Message: &#24050;&#26377;&#23660;&#26044;&#34880;&#30431;&#30340;&#39131;&#31354;&#33351;&#12290;<br>
	 * Message: The clan owned airship already exists.
	 */
	public static final SystemMessageId THE_AIRSHIP_IS_ALREADY_EXISTS;
	
	/**
	 * ID: 2461<br>
	 * Message: L̔sD͌̂ݔ܂B<br>
	 * Message: &#23660;&#26044;&#34880;&#30431;&#30340;&#39131;&#31354;&#33351;&#20677;&#38480;&#30431;&#20027;&#20358;&#36092;&#36023;&#12290;<br>
	 * Message: The airship owned by the clan can only be purchased by the clan lord.
	 */
	public static final SystemMessageId THE_AIRSHIP_NO_PRIVILEGES;
	
	/**
	 * ID: 2462<br>
	 * Message: $s1sĂ邽߁AsDł܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#19981;&#36275;&#65292;&#22240;&#32780;&#28961;&#27861;&#21484;&#21914;&#39131;&#31354;&#33351;&#12290;<br>
	 * Message: The airship cannot be summoned because you don't have enough $s1%.
	 */
	public static final SystemMessageId THE_AIRSHIP_NEED_MORE_S1;
	
	/**
	 * ID: 2463<br>
	 * Message: sD̔RiEPjȂȂ肻łB<br>
	 * Message: &#39131;&#31354;&#33351;&#30340;&#29123;&#26009;&#65288;&#69;&#80;&#65289;&#21363;&#23559;&#32791;&#30433;&#12290;<br>
	 * Message: The airship's fuel (EP) will soon run out.
	 */
	public static final SystemMessageId THE_AIRSHIP_FUEL_SOON_RUN_OUT;
	
	/**
	 * ID: 2464<br>
	 * Message: sD̔R(EP)ׂĎg؂܂B̏Ԃł͔sD̃Xs[h啝Ɍ܂B<br>
	 * Message: &#39131;&#31354;&#33351;&#30340;&#29123;&#26009;&#65288;&#69;&#80;&#65289;&#24050;&#32791;&#30433;&#65292;&#22312;&#27492;&#29376;&#24907;&#19979;&#39131;&#31354;&#33351;&#30340;&#36895;&#24230;&#23559;&#26371;&#22823;&#24133;&#19979;&#38477;&#12290;<br>
	 * Message: The airship's fuel (EP) has run out. The airship's speed will be greatly decreased in this condition.
	 */
	public static final SystemMessageId THE_AIRSHIP_FUEL_RUN_OUT;
	
	/**
	 * ID: 2465<br>
	 * Message: NX`[ZI܂BQ܂B<br>
	 * Message: &#24744;&#24050;&#36984;&#25799;&#19981;&#38480;&#32887;&#26989;&#39006;&#21029;&#30340;&#38538;&#20237;&#27604;&#36093;&#12290;&#24744;&#35201;&#21443;&#21152;&#21966;&#65311;<br>
	 * Message: You have selected a 3 vs 3 class irrelevant team match. Do you wish to participate?
	 */
	public static final SystemMessageId OLYMPIAD_3VS3_CONFIRM;
	
	/**
	 * ID: 2466<br>
	 * Message: ⏕[hԂ̃ybg̓XLg܂B<br>
	 * Message: &#22312;&#36628;&#21161;&#27169;&#24335;&#29376;&#24907;&#19979;&#30340;&#23541;&#29289;&#28961;&#27861;&#20351;&#29992;&#25216;&#33021;&#12290;<br>
	 * Message: A pet on auxiliary mode cannot use skills.
	 */
	public static final SystemMessageId PET_AUXILIARY_MODE_CANNOT_USE_SKILLS;
	
	/**
	 * ID: 2491<br>
	 * Message: sD̔RȂ߁Ae|[gł܂B<br>
	 * Message: &#39131;&#31354;&#33351;&#30340;&#29123;&#26009;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#20659;&#36865;&#12290;<br>
	 * Message: Your ship cannot teleport because it does not have enough fuel for the trip.
	 */
	public static final SystemMessageId THE_AIRSHIP_CANNOT_TELEPORT;
	
	/**
	 * ID: 2492<br>
	 * Message: sD܂B%sɎIɏo܂B<br>
	 * Message: &#24050;&#21484;&#21914;&#39131;&#31354;&#33351;&#12290;&#12300;&#37;&#115;&#12301;&#20998;&#37912;&#24460;&#65292;&#23559;&#26371;&#33258;&#21205;&#20986;&#30332;&#12290;<br>
	 * Message: The airship has been summoned. It will automatically depart in %s minutes.
	 */
	public static final SystemMessageId THE_AIRSHIP_SUMMONED;
	
	/**
	 * ID: 2500<br>
	 * Message: ̏Wɐ܂B<br>
	 * Message: &#25505;&#38598;&#25104;&#21151;&#12290;<br>
	 * Message: The collection has succeeded.
	 */
	public static final SystemMessageId THE_COLLECTION_HAS_SUCCEEDED;
	
	/**
	 * ID: 2701<br>
	 * Message: ZłB΂炭ĂēxB<br>
	 * Message: &#31478;&#36093;&#28310;&#20633;&#20013;&#65292;&#35531;&#31245;&#24460;&#20877;&#35430;&#12290;<br>
	 * Message: The match is being prepared. Please try again later.
	 */
	public static final SystemMessageId MATCH_BEING_PREPARED_TRY_LATER;
	
	/**
	 * ID: 2702<br>
	 * Message: lȂ߁A`[珜O܂B<br>
	 * Message: &#20154;&#25976;&#19981;&#31526;&#65292;&#22240;&#27492;&#34987;&#36864;&#20986;&#38538;&#20237;&#12290;<br>
	 * Message: You were excluded from the match because the registration count was not correct.
	 */
	public static final SystemMessageId EXCLUDED_FROM_MATCH_DUE_INCORRECT_COUNT;
	
	/**
	 * ID: 2703<br>
	 * Message: l̔䗦Ȃ߁A`[܂B<br>
	 * Message: &#20154;&#21729;&#27604;&#29575;&#19981;&#31526;&#65292;&#22240;&#27492;&#35519;&#31680;&#20102;&#38538;&#20237;&#12290;<br>
	 * Message: The team was adjusted because the population ratio was not correct.
	 */
	public static final SystemMessageId TEAM_ADJUSTED_BECAUSE_WRONG_POPULATION_RATIO;
	
	/**
	 * ID: 2704<br>
	 * Message: 𒴉߂߁Ao^ł܂B<br>
	 * Message: &#36229;&#36942;&#23450;&#21729;&#20154;&#25976;&#65292;&#22240;&#27492;&#28961;&#27861;&#30331;&#35352;&#12290;<br>
	 * Message: You cannot register because capacity has been exceeded.
	 */
	public static final SystemMessageId CANNOT_REGISTER_CAUSE_QUEUE_FULL;
	
	/**
	 * ID: 2705<br>
	 * Message: Zҋ@Ԃ1ԉ܂B<br>
	 * Message: &#27604;&#36093;&#31561;&#24453;&#26178;&#38291;&#24050;&#24310;&#38263;&#49;&#20998;&#37912;&#12290;<br>
	 * Message: The match waiting time was extended by 1 minute.
	 */
	public static final SystemMessageId MATCH_WAITING_TIME_EXTENDED;
	
	/**
	 * ID: 2706<br>
	 * Message: Ȃ߁Ał܂B<br>
	 * Message: &#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: You cannot enter because you do not meet the requirements.
	 */
	public static final SystemMessageId CANNOT_ENTER_CAUSE_DONT_MATCH_REQUIREMENTS;
	
	/**
	 * ID: 2707<br>
	 * Message: Zo^LZ10bԂ͍ēx̐\݂͂ł܂B<br>
	 * Message: &#21462;&#28040;&#27604;&#36093;&#30331;&#35352;&#20043;&#24460;&#65292;&#22312;&#49;&#48;&#31186;&#24038;&#21491;&#28961;&#27861;&#20877;&#27425;&#30003;&#35531;&#12290;<br>
	 * Message: You cannot make another request for 10 seconds after cancelling a match registration.
	 */
	public static final SystemMessageId CANNOT_REQUEST_REGISTRATION_10_SECS_AFTER;
	
	/**
	 * ID: 2708<br>
	 * Message: ꂽĂ邽߁Ao^ł܂B<br>
	 * Message: &#22312;&#25345;&#26377;&#21463;&#35419;&#21650;&#30340;&#27494;&#22120;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#30331;&#35352;&#12290;<br>
	 * Message: You cannot register while possessing a cursed weapon.
	 */
	public static final SystemMessageId CANNOT_REGISTER_PROCESSING_CURSED_WEAPON;
	
	/**
	 * ID: 2709<br>
	 * Message: IsA[hAnRVAANg̃L[uɐ\ݒ͓o^ł܂B<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#12289;&#22320;&#19979;&#31478;&#25216;&#22580;&#12289;&#26607;&#38647;&#22612;&#30340;&#26230;&#39636;&#27604;&#36093;&#30003;&#35531;&#32773;&#65292;&#30342;&#28961;&#27861;&#30331;&#35352;&#12290;<br>
	 * Message: Applicants for the Olympiad, Underground Coliseum, or Kratei's Cube matches cannot register.
	 */
	public static final SystemMessageId COLISEUM_OLYMPIAD_KRATEIS_APPLICANTS_CANNOT_PARTICIPATE;
	
	/**
	 * ID: 2710<br>
	 * Message: ݒnF $s1, $s2, $s3iNZX̘An̂΁j<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#26607;&#22622;&#21202;&#26031;&#21516;&#30431;&#32879;&#21512;&#22522;&#22320;&#38468;&#36817;&#65289;<br>
	 * Message: Current location: $s1, $s2, $s3 (near the Keucereus clan association location)
	 */
	public static final SystemMessageId LOC_KEUCEREUS_S1_S2_S3;
	
	/**
	 * ID: 2711<br>
	 * Message: ݒnF $s1, $s2, $s3isł̎̓j<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#19981;&#28357;&#20043;&#31278;&#20839;&#37096;&#65289;<br>
	 * Message: Current location: $s1, $s2, $s3 (inside the Seed of Infinity)
	 */
	public static final SystemMessageId LOC_IN_SEED_INFINITY_S1_S2_S3;
	
	/**
	 * ID: 2712<br>
	 * Message: ݒnF $s1, $s2, $s3ijł̎̓j<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#30772;&#28357;&#20043;&#31278;&#20839;&#37096;&#65289;<br>
	 * Message: Current location: $s1, $s2, $s3 (outside the Seed of Infinity)
	 */
	public static final SystemMessageId LOC_OUT_SEED_INFINITY_S1_S2_S3;
	
	/**
	 * ID: 2716<br>
	 * Message: ݒnF $s1, $s2, $s3iNtg̓j<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#36;&#115;&#49;&#65292;&#36;&#115;&#50;&#65292;&#36;&#115;&#51;&#65288;&#35010;&#32299;&#25136;&#22580;&#20839;&#37096;&#65289;<br>
	 * Message: Current location: $s1, $s2, $s3 (inside Aerial Cleft)
	 */
	public static final SystemMessageId LOC_CLEFT_S1_S2_S3;
	
	/**
	 * ID: 2720<br>
	 * Message: CX^g ][F$s1ւ̓ꂪ܂B̓\Ԃ𒲂ׂɂ̓R}hu/instantzonevg܂B<br>
	 * Message: &#24478;&#29694;&#22312;&#36215;&#23559;&#26371;&#38480;&#21046;&#36914;&#20837;&#21363;&#26178;&#22320;&#21312;&#65306;&#12300;&#36;&#115;&#49;&#12301;&#12290;&#19979;&#19968;&#27425;&#30340;&#36914;&#22580;&#26178;&#38291;&#21487;&#36879;&#36942;&#12300;&#47;&#21363;&#26178;&#22320;&#21312;&#12301;&#25351;&#20196;&#20358;&#26597;&#35426;&#12290;<br>
	 * Message: Instant zone from here: $s1's entry has been restricted.
	 */
	public static final SystemMessageId INSTANT_ZONE_S1_RESTRICTED;
	
	/**
	 * ID: 2721<br>
	 * Message: ͔ŝɓAłȂnłB<br>
	 * Message: &#30446;&#21069;&#30340;&#25152;&#22312;&#20301;&#32622;&#26159;&#28961;&#27861;&#25645;&#20056;&#39131;&#34892;&#29289;&#25110;&#35299;&#38500;&#25645;&#20056;&#30340;&#22320;&#21312;&#12290;<br>
	 * Message: Boarding or cancellation of boarding on Airships is not allowed in the current area.
	 */
	public static final SystemMessageId BOARD_OR_CANCEL_NOT_POSSIBLE_HERE;
	
	/**
	 * ID: 2722<br>
	 * Message: ɂ͑̔sDĂ܂B܂قǂpB<br>
	 * Message: &#30908;&#38957;&#19978;&#24050;&#26377;&#21484;&#21914;&#20854;&#20182;&#30340;&#39131;&#31354;&#33351;&#65292;&#35531;&#31245;&#24460;&#20877;&#21033;&#29992;&#12290;<br>
	 * Message: Another airship has already been summoned at the wharf. Please try again later.
	 */
	public static final SystemMessageId ANOTHER_AIRSHIP_ALREADY_SUMMONED;
	
	/**
	 * ID: 2727<br>
	 * Message: Ȃߏ܂B<br>
	 * Message: &#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#25645;&#20056;&#12290;<br>
	 * Message: You cannot board because you do not meet the requirements.
	 */
	public static final SystemMessageId YOU_CANNOT_BOARD_NOT_MEET_REQUEIREMENTS;
	
	/**
	 * ID: 2728<br>
	 * Message: ĂŒɂ͂łȂANVłB<br>
	 * Message: &#22312;&#25645;&#20056;&#29376;&#24907;&#19979;&#28961;&#27861;&#36914;&#34892;&#27492;&#21205;&#20316;&#12290;<br>
	 * Message: This action is prohibited while mounted or on an airship.
	 */
	public static final SystemMessageId ACTION_PROHIBITED_WHILE_MOUNTED_OR_ON_AN_AIRSHIP;
	
	/**
	 * ID: 2729<br>
	 * Message: ϐgɂ͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#35722;&#36523;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while transformed.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_TRANSFORMED;
	
	/**
	 * ID: 2730<br>
	 * Message: ΉԂł͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#30707;&#21270;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while you are petrified.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_YOU_ARE_PETRIFIED;
	
	/**
	 * ID: 2731<br>
	 * Message: 񂾏Ԃł͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#27515;&#20129;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm when you are dead.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHEN_YOU_ARE_DEAD;
	
	/**
	 * ID: 2732<br>
	 * Message: ނ蒆ɂ͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#37347;&#39770;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while fishing.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_FISHING;
	
	/**
	 * ID: 2733<br>
	 * Message: 퓬ɂ͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#25136;&#39717;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while in a battle.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_IN_A_BATTLE;
	
	/**
	 * ID: 2734<br>
	 * Message: ɂ͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#27770;&#39717;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while in a duel.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_IN_A_DUEL;
	/**
	 * ID: 2735<br>
	 * Message: Ԃł͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#22352;&#33879;&#30340;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while in a sitting position.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_IN_A_SITTING_POSITION;
	
	/**
	 * ID: 2736<br>
	 * Message: XLrɂ͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#26045;&#23637;&#25216;&#33021;&#26178;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while using a skill.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_USING_A_SKILL;
	
	/**
	 * ID: 2737<br>
	 * Message: ꂽ𑕒Ԃł͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#35037;&#20633;&#21463;&#35419;&#21650;&#27494;&#22120;&#26178;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while a cursed weapon is equipped.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_A_CURSED_WEAPON_IS_EQUIPPED;
	
	/**
	 * ID: 2738<br>
	 * Message: Ԃł͑Ώۂ𑀏cł܂B<br>
	 * Message: &#22312;&#39640;&#33289;&#26071;&#24159;&#30340;&#29376;&#24907;&#19979;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control the helm while holding a flag.
	 */
	public static final SystemMessageId YOU_CANNOT_CONTROL_THE_HELM_WHILE_HOLDING_A_FLAG;
	
	/**
	 * ID: 2750<br>
	 * Message: $s1앨AjI앨$c2D悵܂B<br>
	 * Message: &#24050;&#30772;&#22750;&#12300;&#36;&#115;&#49;&#12301;&#23432;&#35703;&#20043;&#29289;&#65281;&#12300;&#36;&#99;&#50;&#12301;&#22890;&#21462;&#20102;&#38936;&#22320;&#23432;&#35703;&#20043;&#29289;&#12290;<br>
	 * Message: The $s1 ward has been destroyed! $c2 now has the territory ward.
	 */
	public static final SystemMessageId THE_S1_WARD_HAS_BEEN_DESTROYED_C2_HAS_THE_WARD;
	
	/**
	 * ID: 2751<br>
	 * Message: $s1앨ELN^[S܂B<br>
	 * Message: &#29554;&#24471;&#12300;&#36;&#115;&#49;&#12301;&#23432;&#35703;&#20043;&#29289;&#30340;&#35282;&#33394;&#24050;&#27515;&#20129;&#12290;<br>
	 * Message: The character that acquired $s1 ward has been killed.
	 */
	public static final SystemMessageId THE_CHAR_THAT_ACQUIRED_S1_WARD_HAS_BEEN_KILLED;
	
	/**
	 * ID: 2762<br>
	 * Message: Ă邽߁AΏۂ𑀏cł܂B<br>
	 * Message: &#36317;&#38626;&#22826;&#36960;&#65292;&#22240;&#32780;&#28961;&#27861;&#25805;&#25511;&#30446;&#27161;&#12290;<br>
	 * Message: You cannot control because you are too far.
	 */
	public static final SystemMessageId CANT_CONTROL_TOO_FAR;
	
	/**
	 * ID: 2764<br>
	 * Message: ̘A`l͐l߂̂ߓ܂B<br>
	 * Message: &#24050;&#36229;&#36942;&#21487;&#36914;&#20837;&#32879;&#21512;&#38971;&#36947;&#30340;&#20154;&#25976;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: You cannot enter because the corresponding alliance channel's maximum number of entrants has been reached.
	 */
	public static final SystemMessageId YOU_CANNOT_ENTER_BECAUSE_MAXIMUM_ENTRANTS;
	
	/**
	 * ID: 2765<br>
	 * Message: A`l[_[ȊO͓܂B<br>
	 * Message: &#21482;&#26377;&#32879;&#21512;&#38971;&#36947;&#20027;&#20154;&#25165;&#33021;&#22039;&#35430;&#36914;&#20837;&#12290;<br>
	 * Message: Only the alliance channel leader can attempt entry.
	 */
	public static final SystemMessageId ONLY_ALLIANCE_CHANNEL_LEADER_CAN_ENTER;
	
	/**
	 * ID: 2766<br>
	 * Message: sł̎탌x1U<br>
	 * Message: &#19981;&#28357;&#20043;&#31278;&#31532;&#49;&#38542;&#27573;&#25915;&#25802;&#36914;&#34892;&#20013;&#12290;<br>
	 * Message: Seed of Infinity Stage 1 Attack In Progress.
	 */
	public static final SystemMessageId SEED_OF_INFINITY_STAGE_1_ATTACK_IN_PROGRESS;
	
	/**
	 * ID: 2767<br>
	 * Message: sł̎탌x2U<br>
	 * Message: &#19981;&#28357;&#20043;&#31278;&#31532;&#50;&#38542;&#27573;&#25915;&#25802;&#36914;&#34892;&#20013;&#12290;<br>
	 * Message: Seed of Infinity Stage 2 Attack In Progress.
	 */
	public static final SystemMessageId SEED_OF_INFINITY_STAGE_2_ATTACK_IN_PROGRESS;
	
	/**
	 * ID: 2768<br>
	 * Message: sł̎̊<br>
	 * Message: &#24050;&#20308;&#38936;&#19981;&#28357;&#20043;&#31278;&#12290;<br>
	 * Message: Seed of Infinity Conquest Complete.
	 */
	public static final SystemMessageId SEED_OF_INFINITY_CONQUEST_COMPLETE;
	
	/**
	 * ID: 2769<br>
	 * Message: sł̎탌x1h䒆<br>
	 * Message: &#27491;&#22312;&#36914;&#34892;&#19981;&#28357;&#20043;&#31278;&#31532;&#49;&#38542;&#27573;&#30340;&#25915;&#25802;&#12290;<br>
	 * Message: Seed of Infinity Stage 1 Defense In Progress.
	 */
	public static final SystemMessageId SEED_OF_INFINITY_STAGE_1_DEFENSE_IN_PROGRESS;
	
	/**
	 * ID: 2770<br>
	 * Message: sł̎탌x2h䒆<br>
	 * Message: &#27491;&#22312;&#36914;&#34892;&#19981;&#28357;&#20043;&#31278;&#31532;&#50;&#38542;&#27573;&#30340;&#25915;&#25802;&#12290;<br>
	 * Message: Seed of Infinity Stage 2 Defense In Progress.
	 */
	public static final SystemMessageId SEED_OF_INFINITY_STAGE_2_DEFENSE_IN_PROGRESS;
	
	/**
	 * ID: 2771<br>
	 * Message: jł̎U<br>
	 * Message: &#27491;&#22312;&#36914;&#34892;&#30772;&#28357;&#20043;&#31278;&#30340;&#25915;&#25802;&#12290;<br>
	 * Message: Seed of Destruction Attack in Progress.
	 */
	public static final SystemMessageId SEED_OF_DESTRUCTION_ATTACK_IN_PROGRESS;
	
	/**
	 * ID: 2772<br>
	 * Message: jł̎̊<br>
	 * Message: &#24050;&#20308;&#38936;&#30772;&#28357;&#20043;&#31278;&#12290;<br>
	 * Message: Seed of Destruction Conquest Complete.
	 */
	public static final SystemMessageId SEED_OF_DESTRUCTION_CONQUEST_COMPLETE;
	
	/**
	 * ID: 2773<br>
	 * Message: jł̎h䒆<br>
	 * Message: &#27491;&#22312;&#36914;&#34892;&#30772;&#28357;&#20043;&#31278;&#30340;&#38450;&#34907;&#12290;<br>
	 * Message: Seed of Destruction Defense in Progress.
	 */
	public static final SystemMessageId SEED_OF_DESTRUCTION_DEFENSE_IN_PROGRESS;
	
	/**
	 * ID: 2777<br>
	 * Message: sD̏͂ł܂BM͍AsD̏ł悤ɂȂ܂B<br>
	 * Message: &#39131;&#31354;&#33351;&#21484;&#21914;&#35377;&#21487;&#35657;&#24050;&#36664;&#20837;&#23436;&#30050;&#65292;&#24448;&#24460;&#36020;&#34880;&#30431;&#23601;&#33021;&#21484;&#21914;&#39131;&#31354;&#33351;&#12290;<br>
	 * Message: The airship's summon license has been entered. Your clan can now summon the airship.
	 */
	public static final SystemMessageId THE_AIRSHIP_SUMMON_LICENSE_ENTERED;
	
	/**
	 * ID: 2778<br>
	 * Message: 앨ĂԂł͏uԈړʂKp܂B<br>
	 * Message: &#22312;&#25793;&#26377;&#23432;&#35703;&#20043;&#29289;&#30340;&#29376;&#24907;&#19979;&#65292;&#23559;&#19981;&#26371;&#30332;&#25582;&#30636;&#38291;&#31227;&#21205;&#25928;&#26524;&#12290;<br>
	 * Message: You cannot teleport while in possession of a ward.
	 */
	public static final SystemMessageId YOU_CANNOT_TELEPORT_WHILE_IN_POSSESSION_OF_A_WARD;
	
	/**
	 * ID: 2793<br>
	 * Message: CX^g ][̍ŏli$s1ljɒBĂȂ߁A܂B<br>
	 * Message: &#26410;&#36948;&#21040;&#21363;&#26178;&#22320;&#21312;&#30340;&#19979;&#38480;&#20154;&#25976;&#65288;&#12300;&#36;&#115;&#49;&#12301;&#21517;&#65289;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#20837;&#12290;<br>
	 * Message: You must have a minimum of ($s1) people to enter this Instant Zone. Your request for entry is denied
	 */
	public static final SystemMessageId YOU_MUST_HAVE_MINIMUM_OF_S1_PEOPLE_TO_ENTER;
	
	/**
	 * ID: 2795<br>
	 * Message: ɑ̗̒n\łԂłB<br>
	 * Message: &#24050;&#32147;&#26377;&#21521;&#20854;&#20182;&#38936;&#22320;&#30003;&#35531;&#38936;&#22320;&#25136;&#12290;<br>
	 * Message: You've already requested a territory war in another territory elsewhere.
	 */
	public static final SystemMessageId YOU_ALREADY_REQUESTED_TW_REGISTRATION;
	
	/**
	 * ID: 2796<br>
	 * Message: ̒nĂ錌͗̒nɗb̎ił͎Qł܂B<br>
	 * Message: &#25793;&#26377;&#38936;&#22320;&#30340;&#34880;&#30431;&#65292;&#28961;&#27861;&#20197;&#20653;&#20853;&#30340;&#36523;&#20998;&#21443;&#33287;&#38936;&#22320;&#25136;&#12290;<br>
	 * Message: The clan who owns the territory cannot participate in the territory war as mercenaries.
	 */
	public static final SystemMessageId THE_TERRITORY_OWNER_CLAN_CANNOT_PARTICIPATE_AS_MERCENARIES;
	
	/**
	 * ID: 2797<br>
	 * Message: ͗̒n\Ԃł͂܂B<br>
	 * Message: &#19981;&#26159;&#38936;&#22320;&#25136;&#30331;&#35352;&#26399;&#38291;&#65292;&#22240;&#27492;&#28961;&#27861;&#30003;&#35531;&#21443;&#25136;&#12290;<br>
	 * Message: It is not a territory war registration period, so a request cannot be made at this time.
	 */
	public static final SystemMessageId NOT_TERRITORY_REGISTRATION_PERIOD;
	
	/**
	 * ID: 2798<br>
	 * Message: ̒nI$s1ԑOI<br>
	 * Message: &#33267;&#38936;&#22320;&#25136;&#32080;&#26463;&#26178;&#38291;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#23567;&#26178;&#12290;<br>
	 * Message: The territory war will end in $s1-hour(s).
	 */
	public static final SystemMessageId THE_TERRITORY_WAR_WILL_END_IN_S1_HOURS;
	
	/**
	 * ID: 2799<br>
	 * Message: ̒nI$s1OI<br>
	 * Message: &#33267;&#38936;&#22320;&#25136;&#32080;&#26463;&#26178;&#38291;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#12290;<br>
	 * Message: The territory war will end in $s1-minute(s).
	 */
	public static final SystemMessageId THE_TERRITORY_WAR_WILL_END_IN_S1_MINUTES;
	
	/**
	 * ID: 2900<br>
	 * Message: ̒nI$s1bOI<br>
	 * Message: &#33267;&#38936;&#22320;&#25136;&#32080;&#26463;&#26178;&#38291;&#23578;&#39192;&#12300;&#36;&#115;&#49;&#12301;&#31186;&#37912;&#65281;<br>
	 * Message: $s1-second(s) to the end of territory war!
	 */
	public static final SystemMessageId S1_SECONDS_TO_THE_END_OF_TERRITORY_WAR;
	
	/**
	 * ID: 2901<br>
	 * Message: Ώۂ̒n̂߁AU͂ł܂B<br>
	 * Message: &#30446;&#27161;&#38584;&#23660;&#26044;&#21516;&#19968;&#20491;&#38936;&#22320;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#24375;&#21046;&#25915;&#25802;&#12290;<br>
	 * Message: You cannot force attack a member of the same territory.
	 */
	public static final SystemMessageId YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY;
	
	/**
	 * ID: 2902<br>
	 * Message: 앨𓾂܂B}ɖ̑OnɈړĂB<br>
	 * Message: &#29554;&#24471;&#20102;&#23432;&#35703;&#20043;&#29289;&#65292;&#35531;&#30433;&#36895;&#31227;&#21205;&#21040;&#25105;&#36557;&#30340;&#21069;&#21736;&#22522;&#22320;&#12290;<br>
	 * Message: You've acquired the ward. Move quickly to your forces' outpost.
	 */
	public static final SystemMessageId YOU_VE_ACQUIRED_THE_WARD;
	
	/**
	 * ID: 2903<br>
	 * Message: ̒n킪n܂܂B<br>
	 * Message: &#38936;&#22320;&#25136;&#38283;&#22987;&#12290;<br>
	 * Message: Territory war has begun.
	 */
	public static final SystemMessageId TERRITORY_WAR_HAS_BEGUN;
	
	/**
	 * ID: 2904<br>
	 * Message: ̒n킪I܂B<br>
	 * Message: &#38936;&#22320;&#25136;&#32080;&#26463;&#12290;<br>
	 * Message: Territory war has ended.
	 */
	public static final SystemMessageId TERRITORY_WAR_HAS_ENDED;
	
	/**
	 * ID: 2911<br>
	 * You've requested $c1 to be on your Friends List.
	 */
	public static final SystemMessageId YOU_REQUESTED_C1_TO_BE_FRIEND;
	
	/**
	 * ID: 2913<br>
	 * Message: $s1$s2앨̒Dɐ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#34880;&#30431;&#25104;&#21151;&#22890;&#24471;&#12300;&#36;&#115;&#50;&#12301;&#23432;&#35703;&#20043;&#29289;&#12290;<br>
	 * Message: Clan $s1 has succeeded in capturing $s2's territory ward.
	 */
	public static final SystemMessageId CLAN_S1_HAS_SUCCEDED_IN_CAPTURING_S2_TERRITORY_WARD;
	
	/**
	 * ID: 2914<br>
	 * Message: ̒nJn20OłB܂`lANeBuɂȂ܂BpUAϑł܂B<br>
	 * Message: &#38936;&#22320;&#25136;&#38283;&#22987;&#50;&#48;&#20998;&#37912;&#21069;&#65281;&#24478;&#29694;&#22312;&#36215;&#25136;&#22580;&#38971;&#36947;&#23559;&#26371;&#38283;&#21855;&#65292;&#21487;&#20197;&#36914;&#34892;&#23560;&#29992;&#20605;&#35037;&#21644;&#35722;&#36523;&#12290;<br>
	 * Message: The territory war will begin in 20 minutes! Territory related functions (ie: battlefield channel, Disguise Scrolls, Transformations, etc...) can now be used.
	 */
	public static final SystemMessageId TERRITORY_WAR_BEGINS_IN_20_MINUTES;
	
	/**
	 * ID: 2922<br>
	 * Message: ubN`FbJ[I5bOI<br>
	 * Message: &#32763;&#36681;&#26041;&#22602;&#32080;&#26463;&#53;&#31186;&#21069;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Block Checker will end in 5 seconds!
	 */
	public static final SystemMessageId BLOCK_CHECKER_ENDS_5;
	
	/**
	 * ID: 2923<br>
	 * Message: ubN`FbJ[I4bOI<br>
	 * Message: &#32763;&#36681;&#26041;&#22602;&#32080;&#26463;&#52;&#31186;&#21069;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Block Checker will end in 4 seconds!!
	 */
	public static final SystemMessageId BLOCK_CHECKER_ENDS_4;
	
	/**
	 * ID: 2924<br>
	 * Message: sϑ̏Ԃł͎̓ɂ͓܂B<br>
	 * Message: &#22312;&#35722;&#36523;&#28858;&#39131;&#34892;&#39636;&#30340;&#29376;&#24907;&#19979;&#65292;&#28961;&#27861;&#36914;&#20837;&#31278;&#23376;&#20839;&#37096;&#12290;<br>
	 * Message: You cannot enter a Seed while in a flying transformation state.
	 */
	public static final SystemMessageId YOU_CANNOT_ENTER_SEED_IN_FLYING_TRANSFORM;
	
	/**
	 * ID: 2925<br>
	 * Message: ubN`FbJ[I3bOI<br>
	 * Message: &#32763;&#36681;&#26041;&#22602;&#32080;&#26463;&#51;&#31186;&#21069;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Block Checker will end in 3 seconds!!!
	 */
	public static final SystemMessageId BLOCK_CHECKER_ENDS_3;
	
	/**
	 * ID: 2926<br>
	 * Message: ubN`FbJ[I2bOI<br>
	 * Message: &#32763;&#36681;&#26041;&#22602;&#32080;&#26463;&#50;&#31186;&#21069;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Block Checker will end in 2 seconds!!!!
	 */
	public static final SystemMessageId BLOCK_CHECKER_ENDS_2;
	
	/**
	 * ID: 2927<br>
	 * Message: ubN`FbJ[I1bOI<br>
	 * Message: &#32763;&#36681;&#26041;&#22602;&#32080;&#26463;&#49;&#31186;&#21069;&#65281;&#65281;&#65281;&#65281;<br>
	 * Message: Block Checker will end in 1 second!!!!!
	 */
	public static final SystemMessageId BLOCK_CHECKER_ENDS_1;
	
	/**
	 * ID: 2928<br>
	 * Message: $c1̃`[Zŏ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#38538;&#20237;&#22312;&#31478;&#36093;&#29554;&#24471;&#21213;&#21033;&#12290;<br>
	 * Message: The $c1 team has won.
	 */
	public static final SystemMessageId TEAM_C1_WON;
	
	/**
	 * ID: 2961<br>
	 * Message: ACe$s1$s2KvłB<br>
	 * Message: &#38656;&#35201;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#36947;&#20855;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: $s2 unit(s) of the item $s1 is/are required.
	 */
	public static final SystemMessageId S2_UNIT_OF_THE_ITEM_S1_REQUIRED;
	
	/**
	 * ID: 2964<br>
	 * Message: m[uXɔCꍇAs̊֘ANGXg폜܂B낵łB<br>
	 * Message: &#34987;&#20219;&#21629;&#28858;&#36020;&#26063;&#26178;&#65292;&#23559;&#26371;&#21034;&#38500;&#36914;&#34892;&#20013;&#30340;&#30456;&#38364;&#20219;&#21209;&#12290;&#35201;&#32380;&#32396;&#21966;&#65311;<br>
	 * Message: Being appointed as a Noblesse will cancel all related quests. Do you wish to continue?
	 */
	public static final SystemMessageId CANCEL_NOBLESSE_QUESTS;
	
	/**
	 * ID: 2966<br>
	 * Message: Xւ̓ACeYtȂ΍oł܂BACeYtĂB<br>
	 * Message: &#22312;&#35531;&#27714;&#36008;&#27454;&#37109;&#20214;&#20013;&#38656;&#35201;&#38468;&#21152;&#36947;&#20855;&#24460;&#25165;&#21487;&#30332;&#36865;&#12290;&#35531;&#38468;&#21152;&#36947;&#20855;&#12290;<br>
	 * Message: This is a Payment Request transaction. Please attach the item.
	 */
	public static final SystemMessageId PAYMENT_REQUEST_NO_ITEM;
	
	/**
	 * ID: 2968<br>
	 * Message: ̃LN^[̗Xւ̌x(240)𒴂߁Aoł܂B<br>
	 * Message: &#25105;&#26041;&#35282;&#33394;&#24050;&#36229;&#20986;&#37109;&#20214;&#38480;&#37327;&#65288;&#50;&#52;&#48;&#20214;&#65289;&#65292;&#22240;&#27492;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: The mail limit (240) has been exceeded and this cannot be forwarded.
	 */
	public static final SystemMessageId CANT_FORWARD_MAIL_LIMIT_EXCEEDED;
	
	/**
	 * ID: 2969<br>
	 * Message: OXւoĂ10boĂȂ߁Aoł܂B<br>
	 * Message: &#30332;&#36865;&#21069;&#19968;&#37109;&#20214;&#24460;&#23578;&#26410;&#32147;&#36942;&#49;&#48;&#31186;&#65292;&#22240;&#27492;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: The previous mail was forwarded less than 1 minute ago and this cannot be forwarded.
	 */
	public static final SystemMessageId CANT_FORWARD_LESS_THAN_MINUTE;
	
	/**
	 * ID: 2970<br>
	 * Message: s[X][łȂƂɂ͔ł܂B<br>
	 * Message: &#22312;&#38750;&#23433;&#20840;&#22320;&#21312;&#20839;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: You cannot forward in a non-peace zone.
	 */
	public static final SystemMessageId CANT_FORWARD_NOT_IN_PEACE_ZONE;
	
	/**
	 * ID: 2971<br>
	 * Message: g[hɂ͔ł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: You cannot forward during exchange.
	 */
	public static final SystemMessageId CANT_FORWARD_DURING_EXCHANGE;
	
	/**
	 * ID: 2972<br>
	 * Message: lXA܂͍H[gp̂ߔł܂B<br>
	 * Message: &#27491;&#22312;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#25110;&#26159;&#24037;&#25151;&#65292;&#22240;&#27492;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: You cannot forward because the private shop or workshop is in progress.
	 */
	public static final SystemMessageId CANT_FORWARD_PRIVATE_STORE;
	
	/**
	 * ID: 2973<br>
	 * Message: ACeAɂ͔ł܂B<br>
	 * Message: &#24375;&#21270;&#36947;&#20855;&#25110;&#23660;&#24615;&#26178;&#65292;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: You cannot forward during an item enhancement or attribute enhancement.
	 */
	public static final SystemMessageId CANT_FORWARD_DURING_ENCHANT;
	
	/**
	 * ID: 2974<br>
	 * Message: ACeK؂łȂߔł܂B<br>
	 * Message: &#24819;&#35201;&#30332;&#36865;&#30340;&#36947;&#20855;&#19981;&#36969;&#21512;&#65292;&#22240;&#27492;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: The item that you're trying to send cannot be forwarded because it isn't proper.
	 */
	public static final SystemMessageId CANT_FORWARD_BAD_ITEM;
	
	/**
	 * ID: 2975<br>
	 * Message: AfisĂ邽ߔł܂B<br>
	 * Message: &#37329;&#24163;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: You cannot forward because you don't have enough adena.
	 */
	public static final SystemMessageId CANT_FORWARD_NO_ADENA;
	
	/**
	 * ID: 2976<br>
	 * Message: s[X][łȂƂł͎Mł܂B<br>
	 * Message: &#22312;&#38750;&#23433;&#20840;&#22320;&#21312;&#20839;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You cannot receive in a non-peace zone location.
	 */
	public static final SystemMessageId CANT_RECEIVE_NOT_IN_PEACE_ZONE;
	
	/**
	 * ID: 2977<br>
	 * Message: g[hɂ͎Mł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You cannot receive during an exchange.
	 */
	public static final SystemMessageId CANT_RECEIVE_DURING_EXCHANGE;
	
	/**
	 * ID: 2978<br>
	 * Message: lXA܂͍H[JĂ邽ߎMł܂B<br>
	 * Message: &#27491;&#22312;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#25110;&#26159;&#24037;&#25151;&#65292;&#22240;&#27492;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You cannot receive because the private shop or workshop is in progress.
	 */
	public static final SystemMessageId CANT_RECEIVE_PRIVATE_STORE;
	
	/**
	 * ID: 2979<br>
	 * Message: ACeAɂ͎Mł܂B<br>
	 * Message: &#24375;&#21270;&#36947;&#20855;&#25110;&#23660;&#24615;&#26178;&#65292;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You cannot receive during an item enhancement or attribute enhancement.
	 */
	public static final SystemMessageId CANT_RECEIVE_DURING_ENCHANT;
	
	/**
	 * ID: 2980<br>
	 * Message: AfisĂ邽ߎMł܂B<br>
	 * Message: &#37329;&#24163;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You cannot receive because you don't have enough adena.
	 */
	public static final SystemMessageId CANT_RECEIVE_NO_ADENA;
	
	/**
	 * ID: 2981<br>
	 * Message: Ɏs܂B<br>
	 * Message: &#25910;&#21462;&#22833;&#25943;&#12290;<br>
	 * Message: You cannot receive because your inventory is full.
	 */
	public static final SystemMessageId CANT_RECEIVE_INVENTORY_FULL;
	
	/**
	 * ID: 2982<br>
	 * Message: s[X][łȂƂɂ̓LZł܂B<br>
	 * Message: &#22312;&#38750;&#23433;&#20840;&#22320;&#21312;&#20839;&#28961;&#27861;&#21462;&#28040;&#12290;<br>
	 * Message: You cannot cancel in a non-peace zone location.
	 */
	public static final SystemMessageId CANT_CANCEL_NOT_IN_PEACE_ZONE;
	
	/**
	 * ID: 2983<br>
	 * Message: g[hɂ̓LZł܂B<br>
	 * Message: &#20132;&#26131;&#20013;&#28961;&#27861;&#21462;&#28040;&#12290;<br>
	 * Message: You cannot cancel during an exchange.
	 */
	public static final SystemMessageId CANT_CANCEL_DURING_EXCHANGE;
	
	/**
	 * ID: 2984<br>
	 * Message: lXA܂͍H[JĂ邽߃LZł܂B<br>
	 * Message: &#27491;&#22312;&#38283;&#21855;&#20491;&#20154;&#21830;&#24215;&#25110;&#26159;&#24037;&#25151;&#65292;&#22240;&#27492;&#28961;&#27861;&#21462;&#28040;&#12290;<br>
	 * Message: You cannot cancel because the private shop or workshop is in progress.
	 */
	public static final SystemMessageId CANT_CANCEL_PRIVATE_STORE;
	
	/**
	 * ID: 2985<br>
	 * Message: ACeAɂ̓LZł܂B<br>
	 * Message: &#24375;&#21270;&#36947;&#20855;&#25110;&#23660;&#24615;&#26178;&#65292;&#28961;&#27861;&#21462;&#28040;&#12290;<br>
	 * Message: You cannot cancel during an item enhancement or attribute enhancement.
	 */
	public static final SystemMessageId CANT_CANCEL_DURING_ENCHANT;
	
	/**
	 * ID: 2988<br>
	 * Message: Cxg G[̂߁ALZł܂łB<br>
	 * Message: &#36947;&#20855;&#28165;&#21934;&#30332;&#29983;&#37679;&#35492;&#65292;&#22240;&#27492;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You could not cancel receipt because your inventory is full.
	 */
	public static final SystemMessageId CANT_CANCEL_INVENTORY_FULL;
	
	/**
	 * ID: 3002<br>
	 * Message: M҂݂ȂA폜ꂽLN^[ɂ͗X֔ł܂B<br>
	 * Message: &#25910;&#20214;&#20154;&#19981;&#23384;&#22312;&#25110;&#26159;&#24050;&#21034;&#38500;&#30340;&#35282;&#33394;&#65292;&#28961;&#27861;&#30332;&#36865;&#37109;&#20214;&#12290;<br>
	 * Message: When the recipient doesn't exist or the character is deleted, sending mail is not possible.
	 */
	public static final SystemMessageId RECIPIENT_NOT_EXIST;
	
	/**
	 * ID: 3008<br>
	 * Message: Xւ͂܂B<br>
	 * Message: &#25910;&#21040;&#26032;&#37109;&#20214;&#12290;<br>
	 * Message: The mail has arrived.
	 */
	public static final SystemMessageId MAIL_ARRIVED;
	
	/**
	 * ID: 3009<br>
	 * Message: Xւ̍o܂B<br>
	 * Message: &#37109;&#20214;&#30332;&#36865;&#25104;&#21151;&#12290;<br>
	 * Message: Mail successfully sent.
	 */
	public static final SystemMessageId MAIL_SUCCESSFULLY_SENT;
	
	/**
	 * ID: 3010<br>
	 * Message: Xւ̕ԑ܂B<br>
	 * Message: &#37109;&#20214;&#36864;&#36996;&#25104;&#21151;&#12290;<br>
	 * Message: Mail successfully returned.
	 */
	public static final SystemMessageId MAIL_SUCCESSFULLY_RETURNED;
	
	/**
	 * ID: 3011<br>
	 * Message: Xւ̃LZ܂B<br>
	 * Message: &#37109;&#20214;&#21462;&#28040;&#25104;&#21151;&#12290;<br>
	 * Message: Mail successfully cancelled.
	 */
	public static final SystemMessageId MAIL_SUCCESSFULLY_CANCELLED;
	
	/**
	 * ID: 3012<br>
	 * Message: Xւ̎悪܂B<br>
	 * Message: &#37109;&#20214;&#25910;&#21462;&#25104;&#21151;&#12290;<br>
	 * Message: Mail successfully received.
	 */
	public static final SystemMessageId MAIL_SUCCESSFULLY_RECEIVED;
	
	/**
	 * ID: 3013<br>
	 * Message: $c1 +$s2$s3G`gɐ܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#25104;&#21151;&#24375;&#21270;&#12300;&#43;&#36;&#115;&#50;&#36;&#115;&#51;&#12301;&#12290;<br>
	 * Message: $c1 has successfuly enchanted a +$s2 $s3.
	 */
	public static final SystemMessageId C1_SUCCESSFULY_ENCHANTED_A_S2_S3;
	
	/**
	 * ID: 3014<br>
	 * Message: I[폜܂B<br>
	 * Message: &#35201;&#21034;&#38500;&#25152;&#36984;&#30340;&#37109;&#20214;&#21966;&#65311;<br>
	 * Message: Do you wish to erase the selected mail ?
	 */
	public static final SystemMessageId DO_YOU_WISH_TO_ERASE_MAIL;
	
	/**
	 * ID: 3015<br>
	 * Message: 폜郁[IĂB<br>
	 * Message: &#35531;&#36984;&#25799;&#35201;&#21034;&#38500;&#30340;&#37109;&#20214;&#12290;<br>
	 * Message: Please select the mail to be deleted.
	 */
	public static final SystemMessageId PLEASE_SELECT_MAIL_TO_BE_DELETED;
	
	/**
	 * ID: 3016<br>
	 * Message: ACe̓Yt͍ő8܂łł܂B<br>
	 * Message: &#38468;&#21152;&#36947;&#20855;&#25976;&#37327;&#19978;&#38480;&#28858;&#56;&#20491;&#12290;<br>
	 * Message: Item selection is possible up to 8.
	 */
	public static final SystemMessageId ITEM_SELECTION_POSSIBLE_UP_TO_8;
	
	/**
	 * ID: 3019<br>
	 * Message: gɂ͗Xւoł܂B<br>
	 * Message: &#28961;&#27861;&#23565;&#33258;&#24049;&#26412;&#20154;&#30332;&#36865;&#37109;&#20214;&#12290;<br>
	 * Message: You cannot send mail to yourself.
	 */
	public static final SystemMessageId YOU_CANT_SEND_MAIL_TO_YOURSELF;
	
	/**
	 * ID: 3020<br>
	 * Message: Xւ͎󂯎z͂Ȃ΍oł܂B<br>
	 * Message: &#33509;&#19981;&#36664;&#20837;&#35531;&#27714;&#36008;&#27454;&#26178;&#21487;&#25910;&#21463;&#37329;&#38989;&#65292;&#23601;&#28961;&#27861;&#30332;&#36865;&#12290;<br>
	 * Message: When not entering the amount for the payment request, you cannot send any mail.
	 */
	public static final SystemMessageId PAYMENT_AMOUNT_NOT_ENTERED;
	
	/**
	 * ID: 3023<br>
	 * Message: J[V̖ڂ痬oC}ɋ܂̂܂B<br>
	 * Message: &#24863;&#35258;&#21040;&#21345;&#27801;&#20043;&#30524;&#30340;&#39764;&#27683;&#27491;&#22312;&#36805;&#36895;&#24375;&#21270;&#12290;<br>
	 * Message: I can feel that the energy being flown in the Kasha's eye is getting stronger rapidly.
	 */
	public static final SystemMessageId I_CAN_FEEL_ENERGY_KASHA_EYE_GETTING_STRONGER_RAPIDLY;
	
	/**
	 * ID: 3024<br>
	 * Message: J[V̖ڂɂłj􂹂΂̐łǂ肤܂B<br>
	 * Message: &#21345;&#27801;&#20043;&#30524;&#20687;&#26159;&#35201;&#29190;&#30332;&#20284;&#30340;&#38663;&#21205;&#33879;&#12290;<br>
	 * Message: Kasha's eye pitches and tosses like it's about to explode.
	 */
	public static final SystemMessageId KASHA_EYE_PITCHES_TOSSES_EXPLODE;
	
	/**
	 * ID: 3025<br>
	 * Message: $s2 x܂B$s1Afil܂B<br>
	 * Message: &#12300;&#36;&#115;&#50;&#12301;&#24050;&#20184;&#36008;&#27454;&#65292;&#22240;&#27492;&#29554;&#24471;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#12290;<br>
	 * Message: Payment of $s1 Adena was completed by $s2.
	 */
	public static final SystemMessageId PAYMENT_OF_S1_ADENA_COMPLETED_BY_S2;
	
	/**
	 * ID: 3026<br>
	 * Message: XL G`g@\g郌xł͂܂B̋@\gɂ́Ax76ȏłȂ΂Ȃ܂B<br>
	 * Message: &#26410;&#36948;&#21040;&#33021;&#22816;&#20351;&#29992;&#25216;&#33021;&#26119;&#33775;&#31995;&#32113;&#30340;&#31561;&#32026;&#12290;&#31561;&#32026;&#36948;&#21040;&#55;&#54;&#20197;&#19978;&#26178;&#65292;&#25165;&#33021;&#20351;&#29992;&#35442;&#21151;&#33021;&#12290;<br>
	 * Message: You cannot use the skill enhancing function on this level. You can use the corresponding function on levels higher than 76Lv .
	 */
	public static final SystemMessageId YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL;
	
	/**
	 * ID: 3027<br>
	 * Message: XL G`g@\gNXł͂܂B̋@\gɂ́A3]EIĂȂ΂Ȃ܂B<br>
	 * Message: &#27492;&#32887;&#26989;&#28961;&#27861;&#20351;&#29992;&#25216;&#33021;&#26119;&#33775;&#31995;&#32113;&#12290;&#23436;&#25104;&#51;&#27425;&#36681;&#32887;&#30340;&#32887;&#26989;&#25165;&#33021;&#20351;&#29992;&#35442;&#21151;&#33021;&#12290;<br>
	 * Message: You cannot use the skill enhancing function in this class. You can use corresponding function when completing the third class change.
	 */
	public static final SystemMessageId YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS;
	
	/**
	 * ID: 3028<br>
	 * Message: XL G`g@\gԂł͂܂B̋@\͔퓬ԂŎg܂BϐgA퓬ÅeԂł͎g܂B<br>
	 * Message: &#28961;&#27861;&#20351;&#29992;&#25216;&#33021;&#26119;&#33775;&#31995;&#32113;&#12290;&#25216;&#33021;&#26119;&#33775;&#31995;&#32113;&#21482;&#33021;&#22312;&#38750;&#25136;&#39717;&#24773;&#27841;&#19979;&#20351;&#29992;&#65292;&#32780;&#19988;&#20063;&#19981;&#33021;&#22312;&#35722;&#36523;&#29376;&#24907;&#12289;&#25136;&#39717;&#29376;&#24907;&#12289;&#39438;&#20056;&#29376;&#24907;&#19979;&#20351;&#29992;&#12290;<br>
	 * Message: You cannot use the skill enhancing function in this class. You can use the skill enhancing function under off-battle status, and cannot use the function while transforming, battling and on-board.
	 */
	public static final SystemMessageId YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT;
	
	/**
	 * ID: 3029<br>
	 * Message: $s1 Xւԑ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#36864;&#36996;&#20102;&#37109;&#20214;&#12290;<br>
	 * Message: $s1 returned the mail.
	 */
	public static final SystemMessageId S1_RETURNED_MAIL;
	
	/**
	 * ID: 3030<br>
	 * Message: lłɎ󂯎Ă邽߁AõLZ͂ł܂B<br>
	 * Message: &#25910;&#20214;&#20154;&#24050;&#25910;&#21462;&#65292;&#22240;&#27492;&#28961;&#27861;&#21462;&#28040;&#30332;&#36865;&#12290;<br>
	 * Message: You cannot cancel sent mail since the recipient received it.
	 */
	public static final SystemMessageId YOU_CANT_CANCEL_RECEIVED_MAIL;
	
	/**
	 * ID: 3033<br>
	 * Message: x̐gBXLpāAt̏ɂ܂ŐI<br>
	 * Message: &#20351;&#29992;&#35686;&#34907;&#38538;&#21729;&#30340;&#38577;&#36523;&#25216;&#33021;&#24460;&#65292;&#28507;&#20837;&#21040;&#40654;&#26126;&#30340;&#25991;&#20214;&#20786;&#34255;&#23460;&#20839;&#65281;<br>
	 * Message: By using the invisible skill, sneak into the Dawn's document storage!
	 */
	public static final SystemMessageId SNEAK_INTO_DAWNS_DOCUMENT_STORAGE;
	
	/**
	 * ID: 3037<br>
	 * Message: jx͐gBĂ邱ƂɋCÂ܂Ax͋CÂ܂B<br>
	 * Message: &#30007;&#24615;&#35686;&#34907;&#38538;&#21729;&#21487;&#20197;&#23519;&#35258;&#38577;&#36523;&#65292;&#32780;&#22899;&#24615;&#35686;&#34907;&#38538;&#21729;&#28961;&#27861;&#23519;&#35258;&#38577;&#36523;&#12290;<br>
	 * Message: Male guards can detect the concealment but the female guards cannot.
	 */
	public static final SystemMessageId MALE_GUARDS_CAN_DETECT_FEMALES_DONT;
	
	/**
	 * ID: 3038<br>
	 * Message: x͒jx͂邩ɉłϐgpĵŁACĂB<br>
	 * Message: &#22899;&#24615;&#35686;&#34907;&#38538;&#21729;&#27604;&#30007;&#24615;&#35686;&#34907;&#38538;&#21729;&#21487;&#20197;&#22312;&#26356;&#36960;&#30340;&#22320;&#26041;&#23601;&#33021;&#23519;&#35258;&#21040;&#35722;&#36523;&#34899;&#65292;&#25152;&#20197;&#35201;&#38750;&#24120;&#23567;&#24515;&#12290;<br>
	 * Message: Female guards notice the disguises from far away better than the male guards do, so beware.
	 */
	public static final SystemMessageId FEMALE_GUARDS_NOTICE_BETTER_THAN_MALE;
	
	/**
	 * ID: 3059<br>
	 * Message: $s1 ҋ@ԒɎ󂯎Ȃ߁AIɕԑ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#22312;&#25910;&#20214;&#31561;&#24453;&#26178;&#38291;&#20839;&#23578;&#26410;&#25910;&#21462;&#65292;&#22240;&#27492;&#24050;&#33258;&#21205;&#36864;&#36996;&#12290;<br>
	 * Message: $s1 did not receive it during the waiting time, so it was returned automatically.
	 */
	public static final SystemMessageId S1_NOT_RECEIVE_DURING_WAITING_TIME_MAIL_RETURNED;
	
	/**
	 * ID: 3062<br>
	 * Message: $s1AfiŌς܂B<br>
	 * Message: &#35201;&#25903;&#20184;&#12300;&#36;&#115;&#49;&#12301;&#37329;&#24163;&#21966;&#65311;<br>
	 * Message: Do you want to pay $s1 Adena ?
	 */
	public static final SystemMessageId DO_YOU_WANT_TO_PAY_S1_ADENA;
	
	/**
	 * ID: 3063<br>
	 * Message: {ɕԑ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#36864;&#36996;&#21966;&#65311;<br>
	 * Message: Do you really want to forward ?
	 */
	public static final SystemMessageId DO_YOU_WANT_TO_FORWARD;
	
	/**
	 * ID: 3064<br>
	 * Message: ǂ̗Xւ܂B<br>
	 * Message: &#26377;&#23578;&#26410;&#35712;&#21462;&#30340;&#37109;&#20214;&#12290;<br>
	 * Message: There is an unread mail.
	 */
	public static final SystemMessageId UNREAD_MAIL;
	
	/**
	 * ID: 3065<br>
	 * Message: ݒnF̌E<br>
	 * Message: &#30446;&#21069;&#20301;&#32622;&#65306;&#22818;&#24187;&#32080;&#30028;&#20839;&#37096;<br>
	 * Message: Current location: Inside the Chamber of Delusion
	 */
	public static final SystemMessageId LOC_DELUSION_CHAMBER;
	
	/**
	 * ID: 3066<br>
	 * Message: s[X][ȊȌꏊł́AXւɓYtꂽACe̎⍷o͂ł܂Bʂ邱Ƃ\łB<br>
	 * Message: &#22312;&#38750;&#23433;&#20840;&#21312;&#22495;&#20839;&#28961;&#27861;&#25910;&#21462;&#25110;&#30332;&#36865;&#37109;&#20214;&#38468;&#21152;&#36947;&#20855;&#65292;&#21482;&#33021;&#30332;&#36865;&#25110;&#30906;&#35469;&#37109;&#20214;&#20839;&#23481;&#12290;<br>
	 * Message: You cannot use the mail function outside the Peace Zone.
	 */
	public static final SystemMessageId CANT_USE_MAIL_OUTSIDE_PEACE_ZONE;
	
	/**
	 * ID: 3067<br>
	 * Message: $s1 Xւ̍oLZ܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#21462;&#28040;&#30332;&#36865;&#37109;&#20214;&#12290;<br>
	 * Message: $s1 cancelled the sent mail.
	 */
	public static final SystemMessageId S1_CANCELLED_MAIL;
	
	/**
	 * ID: 3068<br>
	 * Message: ҋ@Ԃ߂߁AXւԑ܂B<br>
	 * Message: &#25910;&#20214;&#31561;&#24453;&#26178;&#38291;&#24050;&#36942;&#65292;&#22240;&#27492;&#37109;&#20214;&#24050;&#36864;&#36996;&#12290;<br>
	 * Message: The mail was returned due to the exceeded waiting time.
	 */
	public static final SystemMessageId MAIL_RETURNED;
	
	/**
	 * ID: 3069<br>
	 * Message: {ɎLZ܂B<br>
	 * Message: &#30906;&#23450;&#35201;&#21462;&#28040;&#20132;&#26131;&#21966;&#65311;<br>
	 * Message: Do you really want to cancel the transaction ?
	 */
	public static final SystemMessageId DO_YOU_WANT_TO_CANCEL_TRANSACTION;
	
	/**
	 * ID: 3072<br>
	 * Message: $s1 XւɓYtꂽACel܂B<br>
	 * Message: &#12300;&#36;&#115;&#49;&#12301;&#29554;&#24471;&#20102;&#38468;&#21152;&#22312;&#37109;&#20214;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: $s1 acquired the attached item to your mail.
	 */
	public static final SystemMessageId S1_ACQUIRED_ATTACHED_ITEM;
	
	/**
	 * ID: 3073<br>
	 * Message: $s1ACe$s2l܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#12300;&#36;&#115;&#50;&#12301;&#20491;&#12300;&#36;&#115;&#49;&#12301;&#36947;&#20855;&#12290;<br>
	 * Message: You have acquired $s2 $s1.
	 */
	public static final SystemMessageId YOU_ACQUIRED_S2_S1;
	
	/**
	 * ID: 3074<br>
	 * Message: K̎l̒𒴂Ă܂B<br>
	 * Message: &#25910;&#20214;&#20154;&#21517;&#23383;&#24050;&#36229;&#36942;&#21487;&#36664;&#20837;&#30340;&#38480;&#24230;&#12290;<br>
	 * Message: The allowed length for recipient exceeded.
	 */
	public static final SystemMessageId ALLOWED_LENGTH_FOR_RECIPIENT_EXCEEDED;
	
	/**
	 * ID: 3075<br>
	 * Message: K̃^Cg̒𒴂Ă܂B<br>
	 * Message: &#27161;&#38988;&#24050;&#36229;&#36942;&#21487;&#36664;&#20837;&#30340;&#38480;&#24230;&#12290;<br>
	 * Message: The allowed length for a title exceeded.
	 */
	public static final SystemMessageId ALLOWED_LENGTH_FOR_TITLE_EXCEEDED;
	
	/**
	 * ID: 3077<br>
	 * Message: ̃LN^[Xւ̌x(240)𒴂߁Aoł܂B<br>
	 * Message: &#23565;&#26041;&#35282;&#33394;&#24050;&#36229;&#36942;&#37109;&#20214;&#38480;&#37327;&#65288;&#50;&#52;&#48;&#20214;&#65289;&#65292;&#22240;&#27492;&#28961;&#27861;&#20659;&#36865;&#12290;<br>
	 * Message: The mail limit (240) of the opponent's character has been exceeded and this cannot be forwarded.
	 */
	public static final SystemMessageId MAIL_LIMIT_EXCEEDED;
	
	/**
	 * ID: 3078<br>
	 * Message: XւłB{ɍo܂B<br>
	 * Message: &#35531;&#27714;&#36008;&#27454;&#37109;&#20214;&#65292;&#30906;&#23450;&#35201;&#20659;&#36865;&#21966;&#65311;<br>
	 * Message: You're making a request for payment. Do you want to proceed ?
	 */
	public static final SystemMessageId YOU_MAKING_PAYMENT_REQUEST;
	
	/**
	 * ID: 3079<br>
	 * Message: ybg CxgɃACe邽߁Aybg̔̔AlX̔̔o^AACẽhbv͂ł܂Bybg CxgɂĂB<br>
	 * Message: &#23541;&#29289;&#36947;&#20855;&#28165;&#21934;&#20839;&#26377;&#36947;&#20855;&#65292;&#22240;&#27492;&#28961;&#27861;&#20986;&#21806;&#23541;&#29289;&#12289;&#30331;&#35352;&#20491;&#20154;&#21830;&#24215;&#45;&#36009;&#21806;&#20197;&#21450;&#19999;&#26820;&#36947;&#20855;&#12290;&#35531;&#28165;&#38500;&#23541;&#29289;&#36947;&#20855;&#28165;&#21934;&#20839;&#30340;&#36947;&#20855;&#12290;<br>
	 * Message: There are items in the Pet Inventory so you cannot register as an individual store or drop items. Please empty the items in the Pet Inventory.
	 */
	public static final SystemMessageId ITEMS_IN_PET_INVENTORY;
	
	/**
	 * ID: 3080<br>
	 * Message: AfisĂ邽߃XL NZbgł܂B<br>
	 * Message: &#37329;&#24163;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#37325;&#35373;&#25216;&#33021;&#36899;&#32080;&#12290;<br>
	 * Message: You cannot reset the Skill Link because there is not enough Adena.
	 */
	public static final SystemMessageId CANNOT_RESET_SKILL_LINK_BECAUSE_NOT_ENOUGH_ADENA;
	
	/**
	 * ID: 3081<br>
	 * Message: 肪σAfilłȂɂȂĂ邽߁A󂯎܂B<br>
	 * Message: &#23565;&#26041;&#26781;&#20214;&#19981;&#36275;&#20197;&#29554;&#24471;&#32080;&#31639;&#37329;&#24163;&#65292;&#22240;&#27492;&#28961;&#27861;&#25910;&#21462;&#12290;<br>
	 * Message: You cannot receive it because you are under condition that the opponent cannot acquire any Adena for payment
	 */
	public static final SystemMessageId YOU_CANNOT_RECEIVE_CONDITION_OPPONENT_CANT_ACQUIRE_ADENA;
	
	/**
	 * ID: 3082<br>
	 * Message: ՒfĂLN^[ɂ͗Xւo܂B<br>
	 * Message: &#23565;&#38548;&#32085;&#24744;&#30340;&#35282;&#33394;&#28961;&#27861;&#30332;&#36865;&#37109;&#20214;&#12290;<br>
	 * Message: You cannot send mail to any character that has blocked you.
	 */
	public static final SystemMessageId YOU_CANNOT_SEND_MAIL_TO_CHAR_BLOCK_YOU;
	
	/**
	 * ID: 3094<br>
	 * Message: IsA[hQ̃[U[̓p[eBAFl̏҂͂ł܂B<br>
	 * Message: &#22887;&#26519;&#21305;&#20126;&#21443;&#36093;&#20013;&#30340;&#35282;&#33394;&#28961;&#27861;&#36992;&#35531;&#32068;&#38538;&#25110;&#21152;&#28858;&#22909;&#21451;&#12290;<br>
	 * Message: A user currently participating in the Olympiad cannot send party and friend invitations.
	 */
	public static final SystemMessageId A_USER_CURRENTLY_PARTICIPATING_IN_THE_OLYMPIAD_CANNOT_SEND_PARTY_AND_FRIEND_INVITATIONS;
	
	/**
	 * ID: 3108<br>
	 * Message: AANeBu X^[h邨ꂪ܂B<br>
	 * Message: &#24478;&#29694;&#22312;&#36215;&#21487;&#20197;&#21050;&#28608;&#26377;&#20808;&#34892;&#25915;&#25802;&#24615;&#21521;&#30340;&#24618;&#29289;&#12290;<br>
	 * Message: You are no longer protected from aggressive monsters.
	 */
	public static final SystemMessageId YOU_ARE_NO_LONGER_PROTECTED_FROM_AGGRESSIVE_MONSTERS;
	
	/**
	 * ID: 3119<br>
	 * Message: Jbv ANV̐\݂ۂ܂B<br>
	 * Message: &#38617;&#20154;&#21205;&#20316;&#36973;&#21463;&#25298;&#32085;&#12290;<br>
	 * Message: The couple action was denied.
	 */
	public static final SystemMessageId COUPLE_ACTION_DENIED;
	
	/**
	 * ID: 3120<br>
	 * Message: ΏۂƂ̈ʒuȂߐ\݂ł܂B<br>
	 * Message: &#33287;&#30446;&#27161;&#30340;&#20301;&#32622;&#26781;&#20214;&#19981;&#31526;&#65292;&#22240;&#27492;&#28961;&#27861;&#36914;&#34892;&#36992;&#35531;&#12290;<br>
	 * Message: The request cannot be completed because the target does not meet location requirements.
	 */
	public static final SystemMessageId TARGET_DO_NOT_MEET_LOC_REQUIREMENTS;
	
	/**
	 * ID: 3121<br>
	 * Message: Jbv ANVLZ܂B<br>
	 * Message: &#38617;&#20154;&#21205;&#20316;&#24050;&#21462;&#28040;&#12290;<br>
	 * Message: The couple action was cancelled.
	 */
	public static final SystemMessageId COUPLE_ACTION_CANCELED;
	
	/**
	 * ID: 3122<br>
	 * Message: Abv[hGu܂̓GTC͋Kiɍ܂B<br>
	 * Message: &#19978;&#36617;&#30340;&#32011;&#31456;&#25110;&#24509;&#31456;&#30340;&#25972;&#39636;&#35215;&#26684;&#19981;&#31526;&#12290;<br>
	 * Message: The size of the uploaded crest or insignia does not meet the standard requirements.
	 */
	public static final SystemMessageId WRONG_SIZE_UPLOADED_CREST;
	
	/**
	 * ID: 3123<br>
	 * Message: $c1 ͌lXlH[JĂ邽߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#38283;&#35373;&#20491;&#20154;&#21830;&#24215;&#25110;&#24037;&#25151;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is in Private Shop mode or in a battle and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_IN_PRIVATE_SHOP_MODE_OR_IN_A_BATTLE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3124<br>
	 * Message: $c1 ̓tBbVÔ߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#37347;&#39770;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is fishing and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_FISHING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3125<br>
	 * Message: $c1 ͐퓬̂߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#36914;&#34892;&#25136;&#39717;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is in a battle and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_IN_A_BATTLE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3126<br>
	 * Message: $c1 ͂łɃJbv ANV̂߁AVɃJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#24050;&#22312;&#36914;&#34892;&#38617;&#20154;&#21205;&#20316;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is already participating in a couple action and cannot be requested for another couple action.
	 */
	public static final SystemMessageId C1_IS_ALREADY_PARTICIPATING_IN_A_COUPLE_ACTION_AND_CANNOT_BE_REQUESTED_FOR_ANOTHER_COUPLE_ACTION;
	
	/**
	 * ID: 3127<br>
	 * Message: $c1 ̓JIeBbN̂߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30340;&#24615;&#21521;&#20540;&#22823;&#26044;&#48;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is in a chaotic state and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_IN_A_CHAOTIC_STATE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3128<br>
	 * Message: $c1 ̓IsA[hQ̂߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#21443;&#33287;&#22887;&#26519;&#21305;&#20126;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is participating in the Olympiad and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_PARTICIPATING_IN_THE_OLYMPIAD_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3129<br>
	 * Message: $c1 ̓AWg퐋ŝ߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#21443;&#33287;&#26681;&#25818;&#22320;&#25136;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is participating in a hideout siege and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_PARTICIPATING_IN_A_HIDEOUT_SIEGE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3130<br>
	 * Message: $c1 ͍UɎQ̂߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#21443;&#33287;&#25915;&#22478;&#25136;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is in a castle siege and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_IN_A_CASTLE_SIEGE_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3131<br>
	 * Message: $c1 ͑DACo[AXgC_[Ȃǂɓ撆̂߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#27491;&#22312;&#25645;&#20056;&#33337;&#12289;&#39438;&#20056;&#40845;&#39340;&#25110;&#24231;&#40845;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is riding a ship, steed, or strider and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_RIDING_A_SHIP_STEED_OR_STRIDER_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3132<br>
	 * Message: $c1 ̓e|[ĝ߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#20659;&#36865;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is currently teleporting and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_CURRENTLY_TELEPORTING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3133<br>
	 * Message: $c1 ͕ϐĝ߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#35722;&#36523;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is currently transforming and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_CURRENTLY_TRANSFORMING_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3135<br>
	 * Message: $s1ւ̕ύXɂāAӂ߂Ă܂B<br>
	 * Message: &#27491;&#22312;&#23563;&#27714;&#21516;&#24847;&#26159;&#21542;&#35722;&#26356;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Requesting approval for changing party loot to "$s1".
	 */
	public static final SystemMessageId REQUESTING_APPROVAL_CHANGE_PARTY_LOOT_S1;
	
	/**
	 * ID: 3137<br>
	 * Message: ACez^Cv̕ύXLZ܂B<br>
	 * Message: &#24050;&#21462;&#28040;&#20998;&#37197;&#39006;&#22411;&#30340;&#35722;&#26356;&#12290;<br>
	 * Message: Party loot change was cancelled.
	 */
	public static final SystemMessageId PARTY_LOOT_CHANGE_CANCELLED;
	
	/**
	 * ID: 3138<br>
	 * Message: ACez^Cv$s1ɕύX܂B<br>
	 * Message: &#24050;&#23559;&#20998;&#37197;&#39006;&#22411;&#35722;&#26356;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#12290;<br>
	 * Message: Party loot was changed to "$s1".
	 */
	public static final SystemMessageId PARTY_LOOT_CHANGED_S1;
	
	/**
	 * ID: 3139<br>
	 * Message: $c1 ͌ݎSԂ̂߁AJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#30446;&#21069;&#34389;&#26044;&#27515;&#20129;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is currently dead and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_CURRENTLY_DEAD_AND_CANNOT_BE_REQUESTED_FOR_A_COUPLE_ACTION;
	
	/**
	 * ID: 3144<br>
	 * Message: $s1$s2̑t^܂B$s3ɑ΂ϐサ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#19978;&#24050;&#25104;&#21151;&#36070;&#20104;&#12300;&#36;&#115;&#50;&#12301;&#23660;&#24615;&#65292;&#22240;&#27492;&#22686;&#21152;&#20102;&#23565;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#25239;&#24615;&#12290;<br>
	 * Message: The $s2's attribute was successfully bestowed on $s1, and resistance to $s3 was increased.
	 */
	public static final SystemMessageId THE_S2_ATTRIBUTE_WAS_SUCCESSFULLY_BESTOWED_ON_S1_RES_TO_S3_INCREASED;
	
	/**
	 * ID: 3147<br>
	 * Message: $s1ȓɕĂȂ΁ACX^g ][Ǖ܂B<br>
	 * Message: &#22312;&#12300;&#36;&#115;&#49;&#12301;&#20998;&#37912;&#20839;&#33509;&#28961;&#27861;&#24489;&#27963;&#30340;&#35441;&#65292;&#23601;&#26371;&#34987;&#39493;&#36880;&#26044;&#21363;&#26178;&#22320;&#21312;&#20043;&#22806;&#12290;<br>
	 * Message: If you are not resurrected within $s1 minutes, you will be expelled from the instant zone.
	 */
	public static final SystemMessageId YOU_WILL_BE_EXPELLED_IN_S1;
	
	/**
	 * ID: 3150<br>
	 * Message: $c1 ɃJbv ANV\݂܂B<br>
	 * Message: &#36992;&#35531;&#20102;&#12300;&#36;&#99;&#49;&#12301;&#36914;&#34892;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: You have requested a couple action with $c1.
	 */
	public static final SystemMessageId YOU_HAVE_REQUESTED_COUPLE_ACTION_C1;
	
	/**
	 * ID: 3152<br>
	 * Message: $s1$s2̑܂B$s3ɑ΂ϐቺ܂B<br>
	 * Message: &#24050;&#35299;&#38500;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#12300;&#36;&#115;&#50;&#12301;&#23660;&#24615;&#65292;&#22240;&#27492;&#38477;&#20302;&#20102;&#23565;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#25239;&#24615;&#12290;<br>
	 * Message: $s1's $s2 attribute was removed, and resistance to $s3 was decreased.
	 */
	public static final SystemMessageId S1_S2_ATTRIBUTE_REMOVED_RESISTANCE_S3_DECREASED;
	
	/**
	 * ID: 3156<br>
	 * Message: 萔sĂ邽߁Ał܂B<br>
	 * Message: &#25163;&#32396;&#36027;&#19981;&#36275;&#65292;&#22240;&#27492;&#28961;&#27861;&#35299;&#38500;&#35442;&#23660;&#24615;&#12290;<br>
	 * Message: You do not have enough funds to cancel this attribute.
	 */
	public static final SystemMessageId YOU_DO_NOT_HAVE_ENOUGH_FUNDS_TO_CANCEL_ATTRIBUTE;
	
	/**
	 * ID: 3160<br>
	 * Message: +$s1$s2$s3̑܂B$s4ɑ΂ϐቺ܂B<br>
	 * Message: &#24050;&#35299;&#38500;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#30340;&#12300;&#36;&#115;&#51;&#12301;&#23660;&#24615;&#65292;&#22240;&#27492;&#38477;&#20302;&#20102;&#23565;&#12300;&#36;&#115;&#52;&#12301;&#30340;&#25239;&#24615;&#12290;<br>
	 * Message: +$s1$s2's $s3 attribute was removed, so resistance to $s4 was decreased.
	 */
	public static final SystemMessageId S1_S2_S3_ATTRIBUTE_REMOVED_RESISTANCE_TO_S4_DECREASED;
	
	/**
	 * ID: 3163<br>
	 * Message: +$s1$s2$s3̑t^܂B$s4ɑ΂ϐサ܂B<br>
	 * Message: &#22312;&#12300;&#43;&#36;&#115;&#49;&#36;&#115;&#50;&#12301;&#19978;&#24050;&#25104;&#21151;&#36070;&#20104;&#12300;&#36;&#115;&#51;&#12301;&#23660;&#24615;&#65292;&#22240;&#27492;&#22686;&#21152;&#20102;&#23565;&#12300;&#36;&#115;&#52;&#12301;&#30340;&#25239;&#24615;&#12290;<br>
	 * Message: The $s3's attribute was successfully bestowed on +$s1$s2, and resistance to $s4 was increased.
	 */
	public static final SystemMessageId THE_S3_ATTRIBUTE_BESTOWED_ON_S1_S2_RESISTANCE_TO_S4_INCREASED;
	
	/**
	 * ID: 3164<br>
	 * Message: $c1 ͂łɃJbvۏԂ̂߁AVɃJbv ANV̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#25298;&#32085;&#38617;&#20154;&#21205;&#20316;&#30340;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#36992;&#35531;&#38617;&#20154;&#21205;&#20316;&#12290;<br>
	 * Message: $c1 is set to refuse couple actions and cannot be requested for a couple action.
	 */
	public static final SystemMessageId C1_IS_SET_TO_REFUSE_COUPLE_ACTIONS;
	
	/**
	 * ID: 3168<br>
	 * Message: $c1 ͂łɃJbvۏԂ̂߁AVɃp[eB̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#25298;&#32085;&#38538;&#20237;&#36992;&#35531;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#25509;&#21463;&#38538;&#20237;&#36992;&#35531;&#12290;<br>
	 * Message: $c1 is set to refuse party requests and cannot receive a party request.
	 */
	public static final SystemMessageId C1_IS_SET_TO_REFUSE_PARTY_REQUEST;
	
	/**
	 * ID: 3169<br>
	 * Message: $c1 ͂łɌ\ۏԂ̂߁AVɌ̐\݂͂ł܂B<br>
	 * Message: &#12300;&#36;&#99;&#49;&#12301;&#34389;&#26044;&#25298;&#32085;&#27770;&#39717;&#36992;&#35531;&#29376;&#24907;&#65292;&#22240;&#27492;&#28961;&#27861;&#25509;&#21463;&#27770;&#39717;&#36992;&#35531;&#12290;<br>
	 * Message: $c1 is set to refuse duel requests and cannot receive a duel request.
	 */
	public static final SystemMessageId C1_IS_SET_TO_REFUSE_DUEL_REQUEST;
	
	/**
	 * ID: 3206<br>
	 * Message: ݁AĂ鐄E͂܂B<br>
	 * Message: &#30446;&#21069;&#23578;&#26410;&#25793;&#26377;&#25512;&#34214;&#27402;&#12290;<br>
	 * Message: You currently do not have any Recommendations.
	 */
	public static final SystemMessageId YOU_CURRENTLY_DO_NOT_HAVE_ANY_RECOMMENDATIONS;
	
	/**
	 * ID: 3207<br>
	 * Message: E$s1ɓ܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#20491;&#25512;&#34214;&#27402;&#12290;<br>
	 * Message: You obtained $s1 Recommendations
	 */
	public static final SystemMessageId YOU_OBTAINED_S1_RECOMMENDATIONS;
	
	/**
	 * ID: 3214<br>
	 * Message: $s1 lXgɓo^܂B<br>
	 * Message: &#24050;&#25104;&#21151;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#30331;&#35352;&#22312;&#25910;&#20214;&#20154;&#26032;&#22686;&#30446;&#37636;&#19978;&#12290;<br>
	 * Message: $s1 was successfully added to your Contact List.
	 */
	public static final SystemMessageId S1_SUCCESSFULLY_ADDED_TO_CONTACT_LIST;
	
	/**
	 * ID: 3215<br>
	 * Message: $s1݂͑Ȃ[U[łBO͂ĂB<br>
	 * Message: &#12300;&#36;&#115;&#49;&#37;&#12301;&#27492;&#21517;&#31281;&#19981;&#23384;&#22312;&#12290;&#35531;&#20877;&#27425;&#30906;&#35469;&#24460;&#36664;&#20837;&#12290;<br>
	 * Message: The name $s1% doesn't exist. Please try another name.
	 */
	public static final SystemMessageId NAME_S1_NOT_EXIST_TRY_ANOTHER_NAME;
	
	/**
	 * ID: 3216<br>
	 * Message: łɎlXgɓo^Ă閼OłB<br>
	 * Message: &#27492;&#21517;&#31281;&#24050;&#26377;&#30331;&#35352;&#22312;&#25910;&#20214;&#20154;&#26032;&#22686;&#30446;&#37636;&#19978;&#12290;<br>
	 * Message: The name already exists on the added list.
	 */
	public static final SystemMessageId NAME_ALREADY_EXIST_ON_CONTACT_LIST;
	
	/**
	 * ID: 3217<br>
	 * Message: ݁AOXgɓo^ł܂B<br>
	 * Message: &#30446;&#21069;&#28961;&#27861;&#30331;&#35352;&#21517;&#31281;&#12290;<br>
	 * Message: The name is not currently registered.
	 */
	public static final SystemMessageId NAME_NOT_REGISTERED_ON_CONTACT_LIST;
	
	/**
	 * ID: 3219<br>
	 * Message: $s1 lXg폜܂B<br>
	 * Message: &#24050;&#23559;&#12300;&#36;&#115;&#49;&#12301;&#24478;&#25910;&#20214;&#20154;&#26032;&#22686;&#30446;&#37636;&#19978;&#21034;&#38500;&#12290;<br>
	 * Message: $s1 was successfully deleted from your Contact List.
	 */
	public static final SystemMessageId S1_SUCCESFULLY_DELETED_FROM_CONTACT_LIST;
	
	/**
	 * ID: 3221<br>
	 * Message: ̖Oo^邱Ƃ͂ł܂B<br>
	 * Message: &#28961;&#27861;&#26032;&#22686;&#33258;&#24049;&#30340;&#21517;&#31281;&#12290;<br>
	 * Message: You cannot add your own name.
	 */
	public static final SystemMessageId CANNOT_ADD_YOUR_NAME_ON_CONTACT_LIST;
	
	/**
	 * ID: 3222<br>
	 * Message: O̓o^(100l)ɒB߁Ao^ł܂B<br>
	 * Message: &#24050;&#36229;&#20986;&#26032;&#22686;&#21517;&#31281;&#30340;&#19978;&#38480;&#65288;&#49;&#48;&#48;&#21517;&#65289;&#65292;&#22240;&#27492;&#28961;&#27861;&#32380;&#32396;&#30331;&#35352;&#12290;<br>
	 * Message: The maximum number of names (100) has been reached. You cannot register any more.
	 */
	public static final SystemMessageId CONTACT_LIST_LIMIT_REACHED;
	
	/**
	 * ID: 3224<br>
	 * Message: 1TԂɎQłő勣Z70łB<br>
	 * Message: &#27599;&#20491;&#26143;&#26399;&#21487;&#20197;&#21443;&#21152;&#30340;&#31478;&#36093;&#19978;&#38480;&#25976;&#28858;&#55;&#48;&#22580;&#12290;<br>
	 * Message: The maximum matches you can participate in 1 week is 70.
	 */
	public static final SystemMessageId MAX_OLY_WEEKLY_MATCHES_REACHED;
	
	/**
	 * ID: 3225<br>
	 * Message: 1TԂɎQłő勣Z͖Z60ANXʋZ30A`[Z10łB<br>
	 * Message: &#27599;&#20491;&#26143;&#26399;&#21487;&#20197;&#21443;&#21152;&#30340;&#31478;&#36093;&#19978;&#38480;&#25976;&#28858;&#65306;&#19981;&#38480;&#32887;&#26989;&#31478;&#36093;&#54;&#48;&#22580;&#12289;&#32887;&#26989;&#31478;&#36093;&#51;&#48;&#22580;&#65292;&#20197;&#21450;&#38538;&#20237;&#31478;&#36093;&#49;&#48;&#22580;&#12290;<br>
	 * Message: The total number of matches that can be entered in 1 week is 60 class irrelevant individual matches, 30 specific matches, and 10 team matches.
	 */
	public static final SystemMessageId MAX_OLY_WEEKLY_MATCHES_REACHED_60_NON_CLASSED_30_CLASSED_10_TEAM;
	
	/**
	 * ID: 3226<br>
	 * Message: `bgJnシɂ͈ړł܂B΂炭҂B<br>
	 * Message: &#38283;&#22987;&#36914;&#34892;&#20132;&#35527;&#24460;&#65292;&#28961;&#27861;&#39340;&#19978;&#31227;&#21205;&#12290;&#35531;&#31245;&#20505;&#12290;<br>
	 * Message: You cannot move while speaking to an NPC. One moment please.
	 */
	public static final SystemMessageId CANNOT_MOVE_WHILE_SPEAKING_TO_AN_NPC;
	
	/**
	 * ID: 3255<br>
	 * Message: APC V[h̉eŁAHP̑MP$s1̃_[W󂯂܂B<br>
	 * Message: &#21463;&#21040;&#22887;&#31061;&#20043;&#30462;&#30340;&#24433;&#38911;&#65292;&#77;&#80;&#23559;&#20195;&#21463;&#72;&#80;&#21463;&#21040;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#25613;&#23475;&#12290;<br>
	 * Message: Arcane Shield decreased your MP by $1 instead of HP.
	 */
	public static final SystemMessageId ARCANE_SHIELD_DECREASED_YOUR_MP_BY_S1_INSTEAD_OF_HP;
	
	/**
	 * ID: 3259<br>
	 * Message: $s1̌ol({[iXF$s2)$s3SP({[iXF$s4)𓾂܂B<br>
	 * Message: &#29554;&#24471;&#20102;&#12300;&#36;&#115;&#49;&#12301;&#30340;&#32147;&#39511;&#20540;&#65288;&#32005;&#21033;&#65306;&#12300;&#36;&#115;&#50;&#12301;&#65289;&#21644;&#12300;&#36;&#115;&#51;&#12301;&#30340;&#83;&#80;&#65288;&#32005;&#21033;&#65306;&#12300;&#36;&#115;&#52;&#12301;&#65289;&#12290;<br>
	 * Message: You have acquired $s1 EXP (Bonus: $s2) and $s3 SP (Bonus: $s4).
	 */
	public static final SystemMessageId YOU_EARNED_S1_EXP_BONUS_S2_AND_S3_SP_BONUS_S4;
	
	/**
	 * ID: 3256<br>
	 * Message: MP0ɂȂāAAPC V[hł܂B<br>
	 * Message: &#77;&#80;&#24050;&#25104;&#28858;&#48;&#65292;&#22240;&#27492;&#22887;&#31061;&#20043;&#30462;&#23559;&#26371;&#28040;&#22833;&#12290;<br>
	 * Message: MP became 0 and the Arcane Shield is disappearing.
	 */
	public static final SystemMessageId MP_BECAME_0_ARCANE_SHIELD_DISAPPEARING;
	
	/**
	 * ID: 3260<br>
	 * Message: bĂȂ߁AXLgƂ͂ł܂B<br>
	 * Message: &#26410;&#33021;&#21484;&#21914;&#20351;&#39764;&#65292;&#22240;&#27492;&#28961;&#27861;&#20351;&#29992;&#25216;&#33021;&#12290;<br>
	 * Message: You cannot use the skill because the servitor has not been summoned.
	 */
	public static final SystemMessageId CANNOT_USE_SKILL_WITHOUT_SERVITOR;
	
	/**
	 * ID: 3261<br>
	 * Message: TAQł鋣Z̐$s1łB(NXʋZF$s2AZF$s3A`[ZF$s4)<br>
	 * Message: &#26412;&#21608;&#21487;&#20197;&#21443;&#21152;&#30340;&#31478;&#36093;&#25976;&#20849;&#28858;&#12300;&#36;&#115;&#49;&#12301;&#22580;&#65288;&#32887;&#26989;&#31478;&#36093;&#12300;&#36;&#115;&#50;&#12301;&#22580;&#32;&#47;&#32;&#19981;&#38480;&#32887;&#26989;&#31478;&#36093;&#12300;&#36;&#115;&#51;&#12301;&#22580;&#32;&#47;&#32;&#38538;&#20237;&#31478;&#36093;&#12300;&#36;&#115;&#52;&#12301;&#22580;&#65289;&#12290;<br>
	 * Message: You have $s1 match(es) remaining that you can participate in this week ($s2 1 vs 1 Class matches, $s3 1 vs 1 matches, & $s4 3 vs 3 Team matches).
	 */
	public static final SystemMessageId YOU_HAVE_S1_MATCHES_REMAINING_THAT_YOU_CAN_PARTECIPATE_IN_THIS_WEEK_S2_CLASSED_S3_NON_CLASSED_S4_TEAM;
	
	/**
	 * ID: 6004<br>
	 * Message: G`gɎs܂BYACẽG`gl͂̂܂܂łB<br>
	 * Message: &#24375;&#21270;&#22833;&#25943;&#12290;&#35442;&#36947;&#20855;&#30340;&#24375;&#21270;&#25216;&#33021;&#23559;&#25345;&#32396;&#32173;&#25345;&#12290;<br>
	 * Message: Enchant failed. The enchant level for the corresponding item will be exactly retained.
	 */
	public static final SystemMessageId SAFE_ENCHANT_FAILED;
	
	/**
	 * ID: 6501<br>
	 * Message: t[e|[g̊Ȃ߁AubN}[Nۑł܂B<br>
	 * Message: &#27794;&#26377;&#33258;&#30001;&#20659;&#36865;&#26071;&#65292;&#22240;&#27492;&#28961;&#27861;&#20786;&#23384;&#26360;&#31844;&#12290;<br>
	 * Message: You cannot bookmark this location because you do not have a My Teleport Flag.
	 */
	public static final SystemMessageId YOU_CANNOT_BOOKMARK_THIS_LOCATION_BECAUSE_YOU_DO_NOT_HAVE_A_MY_TELEPORT_FLAG;
	
	/**
	 * ID: 6503<br>
	 * Message: Lve ^[L[܂BNX}X T^~o܂傤B<br>
	 * Message: &#19981;&#33391;&#28779;&#38622;&#20986;&#29694;&#20102;&#65281;&#24555;&#24171;&#24537;&#25937;&#20986;&#32854;&#35477;&#32769;&#20154;&#12290;<br>
	 * Message: The evil Thomas D. Turkey has appeared. Please save Santa.
	 */
	public static final SystemMessageId THOMAS_D_TURKEY_APPEARED;
	
	/**
	 * ID: 6504<br>
	 * Message: Lve ^[L[Ƃ̐킢ɏāANX}X T^~o܂B<br>
	 * Message: &#33287;&#19981;&#33391;&#28779;&#38622;&#25136;&#39717;&#29554;&#24471;&#21213;&#21033;&#65292;&#25152;&#20197;&#32854;&#35477;&#32769;&#20154;&#33258;&#30001;&#20102;&#12290;<br>
	 * Message: You won the battle against Thomas D. Turkey. Santa has been rescued.
	 */
	public static final SystemMessageId THOMAS_D_TURKEY_DEFETED;
	
	/**
	 * ID: 6505<br>
	 * Message: NX}X T^~oȂ܂܁ALve ^[L[Ă܂܂B<br>
	 * Message: &#26410;&#33021;&#25937;&#20986;&#32854;&#35477;&#32769;&#20154;&#65292;&#28779;&#38622;&#24050;&#28040;&#22833;&#12290;<br>
	 * Message: You did not rescue Santa, and Thomas D. Turkey has disappeared.
	 */
	public static final SystemMessageId THOMAS_D_TURKEY_DISAPPEARED;
	
	/**
	 * Array containing all SystemMessageIds<br>
	 * Important: Always initialize with a length of the highest SystemMessageId + 1!!!
	 */
	private static TIntObjectHashMap<SystemMessageId> VALUES;
	
	static
	{
		YOU_HAVE_BEEN_DISCONNECTED = new SystemMessageId(0);
		THE_SERVER_WILL_BE_COMING_DOWN_IN_S1_SECONDS = new SystemMessageId(1);
		S1_DOES_NOT_EXIST = new SystemMessageId(2);
		S1_IS_NOT_ONLINE = new SystemMessageId(3);
		CANNOT_INVITE_YOURSELF = new SystemMessageId(4);
		S1_ALREADY_EXISTS = new SystemMessageId(5);
		S1_DOES_NOT_EXIST2 = new SystemMessageId(6);
		ALREADY_MEMBER_OF_S1 = new SystemMessageId(7);
		YOU_ARE_WORKING_WITH_ANOTHER_CLAN = new SystemMessageId(8);
		S1_IS_NOT_A_CLAN_LEADER = new SystemMessageId(9);
		S1_WORKING_WITH_ANOTHER_CLAN = new SystemMessageId(10);
		NO_APPLICANTS_FOR_THIS_CLAN = new SystemMessageId(11);
		APPLICANT_INFORMATION_INCORRECT = new SystemMessageId(12);
		CANNOT_DISSOLVE_CAUSE_CLAN_WILL_PARTICIPATE_IN_CASTLE_SIEGE = new SystemMessageId(13);
		CANNOT_DISSOLVE_CAUSE_CLAN_OWNS_CASTLES_HIDEOUTS = new SystemMessageId(14);
		YOU_ARE_IN_SIEGE = new SystemMessageId(15);
		YOU_ARE_NOT_IN_SIEGE = new SystemMessageId(16);
		CASTLE_SIEGE_HAS_BEGUN = new SystemMessageId(17);
		CASTLE_SIEGE_HAS_ENDED = new SystemMessageId(18);
		NEW_CASTLE_LORD = new SystemMessageId(19);
		GATE_IS_OPENING = new SystemMessageId(20);
		GATE_IS_DESTROYED = new SystemMessageId(21);
		TARGET_TOO_FAR = new SystemMessageId(22);
		NOT_ENOUGH_HP = new SystemMessageId(23);
		NOT_ENOUGH_MP = new SystemMessageId(24);
		REJUVENATING_HP = new SystemMessageId(25);
		REJUVENATING_MP = new SystemMessageId(26);
		CASTING_INTERRUPTED = new SystemMessageId(27);
		YOU_PICKED_UP_S1_ADENA = new SystemMessageId(28);
		YOU_PICKED_UP_S1_S2 = new SystemMessageId(29);
		YOU_PICKED_UP_S1 = new SystemMessageId(30);
		CANT_MOVE_SITTING = new SystemMessageId(31);
		UNABLE_COMBAT_PLEASE_GO_RESTART = new SystemMessageId(32);
		CANT_MOVE_CASTING = new SystemMessageId(33);
		WELCOME_TO_LINEAGE = new SystemMessageId(34);
		YOU_DID_S1_DMG = new SystemMessageId(35);
		C1_GAVE_YOU_S2_DMG = new SystemMessageId(36);
		C1_GAVE_YOU_S2_DMG2 = new SystemMessageId(37);
		GETTING_READY_TO_SHOOT_AN_ARROW = new SystemMessageId(41);
		AVOIDED_C1_ATTACK = new SystemMessageId(42);
		MISSED_TARGET = new SystemMessageId(43);
		CRITICAL_HIT = new SystemMessageId(44);
		EARNED_S1_EXPERIENCE = new SystemMessageId(45);
		USE_S1 = new SystemMessageId(46);
		BEGIN_TO_USE_S1 = new SystemMessageId(47);
		S1_PREPARED_FOR_REUSE = new SystemMessageId(48);
		S1_EQUIPPED = new SystemMessageId(49);
		TARGET_CANT_FOUND = new SystemMessageId(50);
		CANNOT_USE_ON_YOURSELF = new SystemMessageId(51);
		EARNED_S1_ADENA = new SystemMessageId(52);
		EARNED_S2_S1_S = new SystemMessageId(53);
		EARNED_ITEM_S1 = new SystemMessageId(54);
		FAILED_TO_PICKUP_S1_ADENA = new SystemMessageId(55);
		FAILED_TO_PICKUP_S1 = new SystemMessageId(56);
		FAILED_TO_PICKUP_S2_S1_S = new SystemMessageId(57);
		FAILED_TO_EARN_S1_ADENA = new SystemMessageId(58);
		FAILED_TO_EARN_S1 = new SystemMessageId(59);
		FAILED_TO_EARN_S2_S1_S = new SystemMessageId(60);
		NOTHING_HAPPENED = new SystemMessageId(61);
		S1_SUCCESSFULLY_ENCHANTED = new SystemMessageId(62);
		S1_S2_SUCCESSFULLY_ENCHANTED = new SystemMessageId(63);
		ENCHANTMENT_FAILED_S1_EVAPORATED = new SystemMessageId(64);
		ENCHANTMENT_FAILED_S1_S2_EVAPORATED = new SystemMessageId(65);
		C1_INVITED_YOU_TO_PARTY = new SystemMessageId(66);
		S1_HAS_INVITED_YOU_TO_JOIN_THE_CLAN_S2 = new SystemMessageId(67);
		WOULD_YOU_LIKE_TO_WITHDRAW_FROM_THE_S1_CLAN = new SystemMessageId(68);
		WOULD_YOU_LIKE_TO_DISMISS_S1_FROM_THE_CLAN = new SystemMessageId(69);
		DO_YOU_WISH_TO_DISPERSE_THE_CLAN_S1 = new SystemMessageId(70);
		HOW_MANY_S1_DISCARD = new SystemMessageId(71);
		HOW_MANY_S1_MOVE = new SystemMessageId(72);
		HOW_MANY_S1_DESTROY = new SystemMessageId(73);
		WISH_DESTROY_S1 = new SystemMessageId(74);
		ID_NOT_EXIST = new SystemMessageId(75);
		INCORRECT_PASSWORD = new SystemMessageId(76);
		CANNOT_CREATE_CHARACTER = new SystemMessageId(77);
		WISH_DELETE_S1 = new SystemMessageId(78);
		NAMING_NAME_ALREADY_EXISTS = new SystemMessageId(79);
		NAMING_CHARNAME_UP_TO_16CHARS = new SystemMessageId(80);
		PLEASE_SELECT_RACE = new SystemMessageId(81);
		PLEASE_SELECT_OCCUPATION = new SystemMessageId(82);
		PLEASE_SELECT_GENDER = new SystemMessageId(83);
		CANT_ATK_PEACEZONE = new SystemMessageId(84);
		TARGET_IN_PEACEZONE = new SystemMessageId(85);
		PLEASE_ENTER_ID = new SystemMessageId(86);
		PLEASE_ENTER_PASSWORD = new SystemMessageId(87);
		WRONG_PROTOCOL_CHECK = new SystemMessageId(88);
		WRONG_PROTOCOL_CONTINUE = new SystemMessageId(89);
		UNABLE_TO_CONNECT = new SystemMessageId(90);
		PLEASE_SELECT_HAIRSTYLE = new SystemMessageId(91);
		S1_HAS_WORN_OFF = new SystemMessageId(92);
		NOT_ENOUGH_SP = new SystemMessageId(93);
		COPYRIGHT = new SystemMessageId(94);
		YOU_EARNED_S1_EXP_AND_S2_SP = new SystemMessageId(95);
		YOU_INCREASED_YOUR_LEVEL = new SystemMessageId(96);
		CANNOT_MOVE_THIS_ITEM = new SystemMessageId(97);
		CANNOT_DISCARD_THIS_ITEM = new SystemMessageId(98);
		CANNOT_TRADE_THIS_ITEM = new SystemMessageId(99);
		C1_REQUESTS_TRADE = new SystemMessageId(100);
		CANT_LOGOUT_WHILE_FIGHTING = new SystemMessageId(101);
		CANT_RESTART_WHILE_FIGHTING = new SystemMessageId(102);
		ID_LOGGED_IN = new SystemMessageId(103);
		CANNOT_CHANGE_WEAPON_DURING_AN_ATTACK = new SystemMessageId(104);
		C1_INVITED_TO_PARTY = new SystemMessageId(105);
		YOU_JOINED_S1_PARTY = new SystemMessageId(106);
		C1_JOINED_PARTY = new SystemMessageId(107);
		C1_LEFT_PARTY = new SystemMessageId(108);
		INCORRECT_TARGET = new SystemMessageId(109);
		YOU_FEEL_S1_EFFECT = new SystemMessageId(110);
		SHIELD_DEFENCE_SUCCESSFULL = new SystemMessageId(111);
		NOT_ENOUGH_ARROWS = new SystemMessageId(112);
		S1_CANNOT_BE_USED = new SystemMessageId(113);
		ENTER_SHADOW_MOTHER_TREE = new SystemMessageId(114);
		EXIT_SHADOW_MOTHER_TREE = new SystemMessageId(115);
		ENTER_PEACEFUL_ZONE = new SystemMessageId(116);
		EXIT_PEACEFUL_ZONE = new SystemMessageId(117);
		REQUEST_C1_FOR_TRADE = new SystemMessageId(118);
		C1_DENIED_TRADE_REQUEST = new SystemMessageId(119);
		BEGIN_TRADE_WITH_C1 = new SystemMessageId(120);
		C1_CONFIRMED_TRADE = new SystemMessageId(121);
		CANNOT_ADJUST_ITEMS_AFTER_TRADE_CONFIRMED = new SystemMessageId(122);
		TRADE_SUCCESSFUL = new SystemMessageId(123);
		C1_CANCELED_TRADE = new SystemMessageId(124);
		WISH_EXIT_GAME = new SystemMessageId(125);
		WISH_RESTART_GAME = new SystemMessageId(126);
		DISCONNECTED_FROM_SERVER = new SystemMessageId(127);
		CHARACTER_CREATION_FAILED = new SystemMessageId(128);
		SLOTS_FULL = new SystemMessageId(129);
		WAREHOUSE_FULL = new SystemMessageId(130);
		S1_LOGGED_IN = new SystemMessageId(131);
		S1_ADDED_TO_FRIENDS = new SystemMessageId(132);
		S1_REMOVED_FROM_YOUR_FRIENDS_LIST = new SystemMessageId(133);
		PLEACE_CHECK_YOUR_FRIEND_LIST_AGAIN = new SystemMessageId(134);
		C1_DID_NOT_REPLY_TO_YOUR_INVITE = new SystemMessageId(135);
		YOU_DID_NOT_REPLY_TO_C1_INVITE = new SystemMessageId(136);
		NO_MORE_ITEMS_SHORTCUT = new SystemMessageId(137);
		DESIGNATE_SHORTCUT = new SystemMessageId(138);
		C1_RESISTED_YOUR_S2 = new SystemMessageId(139);
		SKILL_REMOVED_DUE_LACK_MP = new SystemMessageId(140);
		ONCE_THE_TRADE_IS_CONFIRMED_THE_ITEM_CANNOT_BE_MOVED_AGAIN = new SystemMessageId(141);
		ALREADY_TRADING = new SystemMessageId(142);
		C1_ALREADY_TRADING = new SystemMessageId(143);
		TARGET_IS_INCORRECT = new SystemMessageId(144);
		TARGET_IS_NOT_FOUND_IN_THE_GAME = new SystemMessageId(145);
		CHATTING_PERMITTED = new SystemMessageId(146);
		CHATTING_PROHIBITED = new SystemMessageId(147);
		CANNOT_USE_QUEST_ITEMS = new SystemMessageId(148);
		CANNOT_USE_ITEM_WHILE_TRADING = new SystemMessageId(149);
		CANNOT_DISCARD_OR_DESTROY_ITEM_WHILE_TRADING = new SystemMessageId(150);
		CANNOT_DISCARD_DISTANCE_TOO_FAR = new SystemMessageId(151);
		YOU_HAVE_INVITED_THE_WRONG_TARGET = new SystemMessageId(152);
		C1_IS_BUSY_TRY_LATER = new SystemMessageId(153);
		ONLY_LEADER_CAN_INVITE = new SystemMessageId(154);
		PARTY_FULL = new SystemMessageId(155);
		DRAIN_HALF_SUCCESFUL = new SystemMessageId(156);
		RESISTED_C1_DRAIN = new SystemMessageId(157);
		ATTACK_FAILED = new SystemMessageId(158);
		RESISTED_C1_MAGIC = new SystemMessageId(159);
		C1_IS_ALREADY_IN_PARTY = new SystemMessageId(160);
		INVITED_USER_NOT_ONLINE = new SystemMessageId(161);
		WAREHOUSE_TOO_FAR = new SystemMessageId(162);
		CANNOT_DESTROY_NUMBER_INCORRECT = new SystemMessageId(163);
		WAITING_FOR_ANOTHER_REPLY = new SystemMessageId(164);
		YOU_CANNOT_ADD_YOURSELF_TO_OWN_FRIEND_LIST = new SystemMessageId(165);
		FRIEND_LIST_NOT_READY_YET_REGISTER_LATER = new SystemMessageId(166);
		C1_ALREADY_ON_FRIEND_LIST = new SystemMessageId(167);
		C1_REQUESTED_TO_BECOME_FRIENDS = new SystemMessageId(168);
		ACCEPT_THE_FRIENDSHIP = new SystemMessageId(169);
		THE_USER_YOU_REQUESTED_IS_NOT_IN_GAME = new SystemMessageId(170);
		C1_NOT_ON_YOUR_FRIENDS_LIST = new SystemMessageId(171);
		LACK_FUNDS_FOR_TRANSACTION1 = new SystemMessageId(172);
		LACK_FUNDS_FOR_TRANSACTION2 = new SystemMessageId(173);
		OTHER_INVENTORY_FULL = new SystemMessageId(174);
		SKILL_DEACTIVATED_HP_FULL = new SystemMessageId(175);
		THE_PERSON_IS_IN_MESSAGE_REFUSAL_MODE = new SystemMessageId(176);
		MESSAGE_REFUSAL_MODE = new SystemMessageId(177);
		MESSAGE_ACCEPTANCE_MODE = new SystemMessageId(178);
		CANT_DISCARD_HERE = new SystemMessageId(179);
		S1_DAYS_LEFT_CANCEL_ACTION = new SystemMessageId(180);
		CANT_SEE_TARGET = new SystemMessageId(181);
		WANT_QUIT_CURRENT_QUEST = new SystemMessageId(182);
		TOO_MANY_USERS = new SystemMessageId(183);
		TRY_AGAIN_LATER = new SystemMessageId(184);
		FIRST_SELECT_USER_TO_INVITE_TO_PARTY = new SystemMessageId(185);
		FIRST_SELECT_USER_TO_INVITE_TO_CLAN = new SystemMessageId(186);
		SELECT_USER_TO_EXPEL = new SystemMessageId(187);
		PLEASE_CREATE_CLAN_NAME = new SystemMessageId(188);
		CLAN_CREATED = new SystemMessageId(189);
		FAILED_TO_CREATE_CLAN = new SystemMessageId(190);
		CLAN_MEMBER_S1_EXPELLED = new SystemMessageId(191);
		FAILED_EXPEL_S1 = new SystemMessageId(192);
		CLAN_HAS_DISPERSED = new SystemMessageId(193);
		FAILED_TO_DISPERSE_CLAN = new SystemMessageId(194);
		ENTERED_THE_CLAN = new SystemMessageId(195);
		S1_REFUSED_TO_JOIN_CLAN = new SystemMessageId(196);
		YOU_HAVE_WITHDRAWN_FROM_CLAN = new SystemMessageId(197);
		FAILED_TO_WITHDRAW_FROM_S1_CLAN = new SystemMessageId(198);
		CLAN_MEMBERSHIP_TERMINATED = new SystemMessageId(199);
		YOU_LEFT_PARTY = new SystemMessageId(200);
		C1_WAS_EXPELLED_FROM_PARTY = new SystemMessageId(201);
		HAVE_BEEN_EXPELLED_FROM_PARTY = new SystemMessageId(202);
		PARTY_DISPERSED = new SystemMessageId(203);
		INCORRECT_NAME_TRY_AGAIN = new SystemMessageId(204);
		INCORRECT_CHARACTER_NAME_TRY_AGAIN = new SystemMessageId(205);
		ENTER_CLAN_NAME_TO_DECLARE_WAR = new SystemMessageId(206);
		S2_OF_THE_CLAN_S1_REQUESTS_WAR = new SystemMessageId(207);
		YOU_ARE_NOT_A_CLAN_MEMBER = new SystemMessageId(212);
		NOT_WORKING_PLEASE_TRY_AGAIN_LATER = new SystemMessageId(213);
		TITLE_CHANGED = new SystemMessageId(214);
		WAR_WITH_THE_S1_CLAN_HAS_BEGUN = new SystemMessageId(215);
		WAR_WITH_THE_S1_CLAN_HAS_ENDED = new SystemMessageId(216);
		YOU_HAVE_WON_THE_WAR_OVER_THE_S1_CLAN = new SystemMessageId(217);
		YOU_HAVE_SURRENDERED_TO_THE_S1_CLAN = new SystemMessageId(218);
		YOU_WERE_DEFEATED_BY_S1_CLAN = new SystemMessageId(219);
		S1_MINUTES_LEFT_UNTIL_CLAN_WAR_ENDS = new SystemMessageId(220);
		CLAN_WAR_WITH_S1_CLAN_HAS_ENDED = new SystemMessageId(221);
		S1_HAS_JOINED_CLAN = new SystemMessageId(222);
		S1_HAS_WITHDRAWN_FROM_THE_CLAN = new SystemMessageId(223);
		S1_DID_NOT_RESPOND_TO_CLAN_INVITATION = new SystemMessageId(224);
		YOU_DID_NOT_RESPOND_TO_S1_CLAN_INVITATION = new SystemMessageId(225);
		S1_CLAN_DID_NOT_RESPOND = new SystemMessageId(226);
		CLAN_WAR_REFUSED_YOU_DID_NOT_RESPOND_TO_S1 = new SystemMessageId(227);
		REQUEST_TO_END_WAR_HAS_BEEN_DENIED = new SystemMessageId(228);
		YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN = new SystemMessageId(229);
		YOU_MUST_WAIT_XX_DAYS_BEFORE_CREATING_A_NEW_CLAN = new SystemMessageId(230);
		YOU_MUST_WAIT_BEFORE_ACCEPTING_A_NEW_MEMBER = new SystemMessageId(231);
		YOU_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN = new SystemMessageId(232);
		SUBCLAN_IS_FULL = new SystemMessageId(233);
		TARGET_MUST_BE_IN_CLAN = new SystemMessageId(234);
		NOT_AUTHORIZED_TO_BESTOW_RIGHTS = new SystemMessageId(235);
		ONLY_THE_CLAN_LEADER_IS_ENABLED = new SystemMessageId(236);
		CLAN_LEADER_NOT_FOUND = new SystemMessageId(237);
		NOT_JOINED_IN_ANY_CLAN = new SystemMessageId(238);
		CLAN_LEADER_CANNOT_WITHDRAW = new SystemMessageId(239);
		CURRENTLY_INVOLVED_IN_CLAN_WAR = new SystemMessageId(240);
		LEADER_OF_S1_CLAN_NOT_FOUND = new SystemMessageId(241);
		SELECT_TARGET = new SystemMessageId(242);
		CANNOT_DECLARE_WAR_ON_ALLIED_CLAN = new SystemMessageId(243);
		NOT_ALLOWED_TO_CHALLENGE = new SystemMessageId(244);
		FIVE_DAYS_NOT_PASSED_SINCE_REFUSED_WAR = new SystemMessageId(245);
		CLAN_CURRENTLY_AT_WAR = new SystemMessageId(246);
		FIVE_DAYS_MUST_PASS_BEFORE_CHALLENGE_AGAIN = new SystemMessageId(247);
		S1_CLAN_NOT_ENOUGH_MEMBERS_FOR_WAR = new SystemMessageId(248);
		WISH_SURRENDER_TO_S1_CLAN = new SystemMessageId(249);
		YOU_HAVE_PERSONALLY_SURRENDERED_TO_THE_S1_CLAN = new SystemMessageId(250);
		ALREADY_AT_WAR_WITH_ANOTHER_CLAN = new SystemMessageId(251);
		ENTER_CLAN_NAME_TO_SURRENDER_TO = new SystemMessageId(252);
		ENTER_CLAN_NAME_TO_END_WAR = new SystemMessageId(253);
		LEADER_CANT_PERSONALLY_SURRENDER = new SystemMessageId(254);
		S1_CLAN_REQUESTED_END_WAR = new SystemMessageId(255);
		ENTER_TITLE = new SystemMessageId(256);
		DO_YOU_OFFER_S1_CLAN_END_WAR = new SystemMessageId(257);
		NOT_INVOLVED_CLAN_WAR = new SystemMessageId(258);
		SELECT_MEMBERS_FROM_LIST = new SystemMessageId(259);
		FIVE_DAYS_NOT_PASSED_SINCE_YOU_WERE_REFUSED_WAR = new SystemMessageId(260);
		CLAN_NAME_INCORRECT = new SystemMessageId(261);
		CLAN_NAME_TOO_LONG = new SystemMessageId(262);
		DISSOLUTION_IN_PROGRESS = new SystemMessageId(263);
		CANNOT_DISSOLVE_WHILE_IN_WAR = new SystemMessageId(264);
		CANNOT_DISSOLVE_WHILE_IN_SIEGE = new SystemMessageId(265);
		CANNOT_DISSOLVE_WHILE_OWNING_CLAN_HALL_OR_CASTLE = new SystemMessageId(266);
		NO_REQUESTS_TO_DISPERSE = new SystemMessageId(267);
		PLAYER_ALREADY_ANOTHER_CLAN = new SystemMessageId(268);
		YOU_CANNOT_DISMISS_YOURSELF = new SystemMessageId(269);
		YOU_HAVE_ALREADY_SURRENDERED = new SystemMessageId(270);
		CLAN_LVL_3_NEEDED_TO_ENDOWE_TITLE = new SystemMessageId(271);
		CLAN_LVL_3_NEEDED_TO_SET_CREST = new SystemMessageId(272);
		CLAN_LVL_3_NEEDED_TO_DECLARE_WAR = new SystemMessageId(273);
		CLAN_LEVEL_INCREASED = new SystemMessageId(274);
		CLAN_LEVEL_INCREASE_FAILED = new SystemMessageId(275);
		ITEM_MISSING_TO_LEARN_SKILL = new SystemMessageId(276);
		LEARNED_SKILL_S1 = new SystemMessageId(277);
		NOT_ENOUGH_SP_TO_LEARN_SKILL = new SystemMessageId(278);
		YOU_NOT_ENOUGH_ADENA = new SystemMessageId(279);
		NO_ITEMS_TO_SELL = new SystemMessageId(280);
		YOU_NOT_ENOUGH_ADENA_PAY_FEE = new SystemMessageId(281);
		NO_ITEM_DEPOSITED_IN_WH = new SystemMessageId(282);
		ENTERED_COMBAT_ZONE = new SystemMessageId(283);
		LEFT_COMBAT_ZONE = new SystemMessageId(284);
		CLAN_S1_ENGRAVED_RULER = new SystemMessageId(285);
		BASE_UNDER_ATTACK = new SystemMessageId(286);
		OPPONENT_STARTED_ENGRAVING = new SystemMessageId(287);
		CASTLE_GATE_BROKEN_DOWN = new SystemMessageId(288);
		NOT_ANOTHER_HEADQUARTERS = new SystemMessageId(289);
		NOT_SET_UP_BASE_HERE = new SystemMessageId(290);
		CLAN_S1_VICTORIOUS_OVER_S2_S_SIEGE = new SystemMessageId(291);
		S1_ANNOUNCED_SIEGE_TIME = new SystemMessageId(292);
		REGISTRATION_TERM_FOR_S1_ENDED = new SystemMessageId(293);
		BECAUSE_YOUR_CLAN_IS_NOT_CURRENTLY_ON_THE_OFFENSIVE_IN_A_CLAN_HALL_SIEGE_WAR_IT_CANNOT_SUMMON_ITS_BASE_CAMP = new SystemMessageId(294);
		S1_SIEGE_WAS_CANCELED_BECAUSE_NO_CLANS_PARTICIPATED = new SystemMessageId(295);
		FALL_DAMAGE_S1 = new SystemMessageId(296);
		DROWN_DAMAGE_S1 = new SystemMessageId(297);
		YOU_DROPPED_S1 = new SystemMessageId(298);
		C1_OBTAINED_S3_S2 = new SystemMessageId(299);
		C1_OBTAINED_S2 = new SystemMessageId(300);
		S2_S1_DISAPPEARED = new SystemMessageId(301);
		S1_DISAPPEARED = new SystemMessageId(302);
		SELECT_ITEM_TO_ENCHANT = new SystemMessageId(303);
		CLAN_MEMBER_S1_LOGGED_IN = new SystemMessageId(304);
		PLAYER_DECLINED = new SystemMessageId(305);
		FAILED_TO_DELETE_CHAR = new SystemMessageId(306);
		CANNOT_TRADE_WAREHOUSE_KEEPER = new SystemMessageId(307);
		PLAYER_DECLINED_CLAN_INVITATION = new SystemMessageId(308);
		YOU_HAVE_SUCCEEDED_IN_EXPELLING_CLAN_MEMBER = new SystemMessageId(309);
		FAILED_TO_EXPEL_CLAN_MEMBER = new SystemMessageId(310);
		CLAN_WAR_DECLARATION_ACCEPTED = new SystemMessageId(311);
		CLAN_WAR_DECLARATION_REFUSED = new SystemMessageId(312);
		CEASE_WAR_REQUEST_ACCEPTED = new SystemMessageId(313);
		FAILED_TO_SURRENDER = new SystemMessageId(314);
		FAILED_TO_PERSONALLY_SURRENDER = new SystemMessageId(315);
		FAILED_TO_WITHDRAW_FROM_THE_PARTY = new SystemMessageId(316);
		FAILED_TO_EXPEL_THE_PARTY_MEMBER = new SystemMessageId(317);
		FAILED_TO_DISPERSE_THE_PARTY = new SystemMessageId(318);
		UNABLE_TO_UNLOCK_DOOR = new SystemMessageId(319);
		FAILED_TO_UNLOCK_DOOR = new SystemMessageId(320);
		ITS_NOT_LOCKED = new SystemMessageId(321);
		DECIDE_SALES_PRICE = new SystemMessageId(322);
		FORCE_INCREASED_TO_S1 = new SystemMessageId(323);
		FORCE_MAXLEVEL_REACHED = new SystemMessageId(324);
		CORPSE_ALREADY_DISAPPEARED = new SystemMessageId(325);
		SELECT_TARGET_FROM_LIST = new SystemMessageId(326);
		CANNOT_EXCEED_80_CHARACTERS = new SystemMessageId(327);
		PLEASE_INPUT_TITLE_LESS_128_CHARACTERS = new SystemMessageId(328);
		PLEASE_INPUT_CONTENT_LESS_3000_CHARACTERS = new SystemMessageId(329);
		ONE_LINE_RESPONSE_NOT_EXCEED_128_CHARACTERS = new SystemMessageId(330);
		ACQUIRED_S1_SP = new SystemMessageId(331);
		DO_YOU_WANT_TO_BE_RESTORED = new SystemMessageId(332);
		S1_DAMAGE_BY_CORE_BARRIER = new SystemMessageId(333);
		ENTER_PRIVATE_STORE_MESSAGE = new SystemMessageId(334);
		S1_HAS_BEEN_ABORTED = new SystemMessageId(335);
		WISH_TO_CRYSTALLIZE_S1 = new SystemMessageId(336);
		SOULSHOTS_GRADE_MISMATCH = new SystemMessageId(337);
		NOT_ENOUGH_SOULSHOTS = new SystemMessageId(338);
		CANNOT_USE_SOULSHOTS = new SystemMessageId(339);
		PRIVATE_STORE_UNDER_WAY = new SystemMessageId(340);
		NOT_ENOUGH_MATERIALS = new SystemMessageId(341);
		ENABLED_SOULSHOT = new SystemMessageId(342);
		SWEEPER_FAILED_TARGET_NOT_SPOILED = new SystemMessageId(343);
		SOULSHOTS_DISABLED = new SystemMessageId(344);
		CHAT_ENABLED = new SystemMessageId(345);
		CHAT_DISABLED = new SystemMessageId(346);
		INCORRECT_ITEM_COUNT = new SystemMessageId(347);
		INCORRECT_ITEM_PRICE = new SystemMessageId(348);
		PRIVATE_STORE_ALREADY_CLOSED = new SystemMessageId(349);
		ITEM_OUT_OF_STOCK = new SystemMessageId(350);
		NOT_ENOUGH_ITEMS = new SystemMessageId(351);
		INCORRECT_ITEM = new SystemMessageId(352);
		CANNOT_PURCHASE = new SystemMessageId(353);
		CANCEL_ENCHANT = new SystemMessageId(354);
		INAPPROPRIATE_ENCHANT_CONDITION = new SystemMessageId(355);
		REJECT_RESURRECTION = new SystemMessageId(356);
		ALREADY_SPOILED = new SystemMessageId(357);
		S1_HOURS_UNTIL_SIEGE_CONCLUSION = new SystemMessageId(358);
		S1_MINUTES_UNTIL_SIEGE_CONCLUSION = new SystemMessageId(359);
		CASTLE_SIEGE_S1_SECONDS_LEFT = new SystemMessageId(360);
		OVER_HIT = new SystemMessageId(361);
		ACQUIRED_BONUS_EXPERIENCE_THROUGH_OVER_HIT = new SystemMessageId(362);
		CHAT_AVAILABLE_S1_MINUTE = new SystemMessageId(363);
		ENTER_USER_NAME_TO_SEARCH = new SystemMessageId(364);
		ARE_YOU_SURE = new SystemMessageId(365);
		PLEASE_SELECT_HAIR_COLOR = new SystemMessageId(366);
		CANNOT_REMOVE_CLAN_CHARACTER = new SystemMessageId(367);
		S1_S2_EQUIPPED = new SystemMessageId(368);
		YOU_PICKED_UP_A_S1_S2 = new SystemMessageId(369);
		FAILED_PICKUP_S1 = new SystemMessageId(370);
		ACQUIRED_S1_S2 = new SystemMessageId(371);
		FAILED_EARN_S1 = new SystemMessageId(372);
		WISH_DESTROY_S1_S2 = new SystemMessageId(373);
		WISH_CRYSTALLIZE_S1_S2 = new SystemMessageId(374);
		DROPPED_S1_S2 = new SystemMessageId(375);
		C1_OBTAINED_S2_S3 = new SystemMessageId(376);
		S1_S2_DISAPPEARED = new SystemMessageId(377);
		C1_PURCHASED_S2 = new SystemMessageId(378);
		C1_PURCHASED_S2_S3 = new SystemMessageId(379);
		C1_PURCHASED_S3_S2_S = new SystemMessageId(380);
		GAME_CLIENT_UNABLE_TO_CONNECT_TO_PETITION_SERVER = new SystemMessageId(381);
		NO_USERS_CHECKED_OUT_GM_ID = new SystemMessageId(382);
		REQUEST_CONFIRMED_TO_END_CONSULTATION = new SystemMessageId(383);
		CLIENT_NOT_LOGGED_ONTO_GAME_SERVER = new SystemMessageId(384);
		REQUEST_CONFIRMED_TO_BEGIN_CONSULTATION = new SystemMessageId(385);
		PETITION_MORE_THAN_FIVE_CHARACTERS = new SystemMessageId(386);
		THIS_END_THE_PETITION_PLEASE_PROVIDE_FEEDBACK = new SystemMessageId(387);
		NOT_UNDER_PETITION_CONSULTATION = new SystemMessageId(388);
		PETITION_ACCEPTED_RECENT_NO_S1 = new SystemMessageId(389);
		ONLY_ONE_ACTIVE_PETITION_AT_TIME = new SystemMessageId(390);
		RECENT_NO_S1_CANCELED = new SystemMessageId(391);
		UNDER_PETITION_ADVICE = new SystemMessageId(392);
		FAILED_CANCEL_PETITION_TRY_LATER = new SystemMessageId(393);
		STARTING_PETITION_WITH_C1 = new SystemMessageId(394);
		PETITION_ENDED_WITH_C1 = new SystemMessageId(395);
		TRY_AGAIN_AFTER_CHANGING_PASSWORD = new SystemMessageId(396);
		NO_PAID_ACCOUNT = new SystemMessageId(397);
		NO_TIME_LEFT_ON_ACCOUNT = new SystemMessageId(398);
		SYSTEM_ERROR = new SystemMessageId(399);
		WISH_TO_DROP_S1 = new SystemMessageId(400);
		TOO_MANY_QUESTS = new SystemMessageId(401);
		NOT_CORRECT_BOAT_TICKET = new SystemMessageId(402);
		EXCEECED_POCKET_ADENA_LIMIT = new SystemMessageId(403);
		CREATE_LVL_TOO_LOW_TO_REGISTER = new SystemMessageId(404);
		TOTAL_PRICE_TOO_HIGH = new SystemMessageId(405);
		PETITION_APP_ACCEPTED = new SystemMessageId(406);
		PETITION_UNDER_PROCESS = new SystemMessageId(407);
		SET_PERIOD = new SystemMessageId(408);
		SET_TIME_S1_S2_S3 = new SystemMessageId(409);
		REGISTRATION_PERIOD = new SystemMessageId(410);
		REGISTRATION_TIME_S1_S2_S3 = new SystemMessageId(411);
		BATTLE_BEGINS_S1_S2_S3 = new SystemMessageId(412);
		BATTLE_ENDS_S1_S2_S3 = new SystemMessageId(413);
		STANDBY = new SystemMessageId(414);
		UNDER_SIEGE = new SystemMessageId(415);
		ITEM_CANNOT_EXCHANGE = new SystemMessageId(416);
		S1_DISARMED = new SystemMessageId(417);
		S1_MINUTES_USAGE_LEFT = new SystemMessageId(419);
		TIME_EXPIRED = new SystemMessageId(420);
		ANOTHER_LOGIN_WITH_ACCOUNT = new SystemMessageId(421);
		WEIGHT_LIMIT_EXCEEDED = new SystemMessageId(422);
		ENCHANT_SCROLL_CANCELLED = new SystemMessageId(423);
		DOES_NOT_FIT_SCROLL_CONDITIONS = new SystemMessageId(424);
		CREATE_LVL_TOO_LOW_TO_REGISTER2 = new SystemMessageId(425);
		REFERENCE_MEMBERSHIP_WITHDRAWAL_S1 = new SystemMessageId(445);
		DOT = new SystemMessageId(447);
		SYSTEM_ERROR_LOGIN_LATER = new SystemMessageId(448);
		PASSWORD_ENTERED_INCORRECT1 = new SystemMessageId(449);
		CONFIRM_ACCOUNT_LOGIN_LATER = new SystemMessageId(450);
		PASSWORD_ENTERED_INCORRECT2 = new SystemMessageId(451);
		PLEASE_CONFIRM_ACCOUNT_LOGIN_LATER = new SystemMessageId(452);
		ACCOUNT_INFORMATION_INCORRECT = new SystemMessageId(453);
		ACCOUNT_IN_USE = new SystemMessageId(455);
		LINAGE_MINIMUM_AGE = new SystemMessageId(456);
		SERVER_MAINTENANCE = new SystemMessageId(457);
		USAGE_TERM_EXPIRED = new SystemMessageId(458);
		TO_REACTIVATE_YOUR_ACCOUNT = new SystemMessageId(460);
		ACCESS_FAILED = new SystemMessageId(461);
		PLEASE_TRY_AGAIN_LATER = new SystemMessageId(462);
		FEATURE_ONLY_FOR_ALLIANCE_LEADER = new SystemMessageId(464);
		NO_CURRENT_ALLIANCES = new SystemMessageId(465);
		YOU_HAVE_EXCEEDED_THE_LIMIT = new SystemMessageId(466);
		CANT_INVITE_CLAN_WITHIN_1_DAY = new SystemMessageId(467);
		CANT_ENTER_ALLIANCE_WITHIN_1_DAY = new SystemMessageId(468);
		MAY_NOT_ALLY_CLAN_BATTLE = new SystemMessageId(469);
		ONLY_CLAN_LEADER_WITHDRAW_ALLY = new SystemMessageId(470);
		ALLIANCE_LEADER_CANT_WITHDRAW = new SystemMessageId(471);
		CANNOT_EXPEL_YOURSELF = new SystemMessageId(472);
		DIFFERENT_ALLIANCE = new SystemMessageId(473);
		CLAN_DOESNT_EXISTS = new SystemMessageId(474);
		DIFFERENT_ALLIANCE2 = new SystemMessageId(475);
		ADJUST_IMAGE_8_12 = new SystemMessageId(476);
		NO_RESPONSE_TO_ALLY_INVITATION = new SystemMessageId(477);
		YOU_DID_NOT_RESPOND_TO_ALLY_INVITATION = new SystemMessageId(478);
		S1_JOINED_AS_FRIEND = new SystemMessageId(479);
		PLEASE_CHECK_YOUR_FRIENDS_LIST = new SystemMessageId(480);
		S1_HAS_BEEN_DELETED_FROM_YOUR_FRIENDS_LIST = new SystemMessageId(481);
		YOU_CANNOT_ADD_YOURSELF_TO_YOUR_OWN_FRIENDS_LIST = new SystemMessageId(482);
		FUNCTION_INACCESSIBLE_NOW = new SystemMessageId(483);
		S1_ALREADY_IN_FRIENDS_LIST = new SystemMessageId(484);
		NO_NEW_INVITATIONS_ACCEPTED = new SystemMessageId(485);
		THE_USER_NOT_IN_FRIENDS_LIST = new SystemMessageId(486);
		FRIEND_LIST_HEADER = new SystemMessageId(487);
		S1_ONLINE = new SystemMessageId(488);
		S1_OFFLINE = new SystemMessageId(489);
		FRIEND_LIST_FOOTER = new SystemMessageId(490);
		ALLIANCE_INFO_HEAD = new SystemMessageId(491);
		ALLIANCE_NAME_S1 = new SystemMessageId(492);
		CONNECTION_S1_TOTAL_S2 = new SystemMessageId(493);
		ALLIANCE_LEADER_S2_OF_S1 = new SystemMessageId(494);
		ALLIANCE_CLAN_TOTAL_S1 = new SystemMessageId(495);
		CLAN_INFO_HEAD = new SystemMessageId(496);
		CLAN_INFO_NAME_S1 = new SystemMessageId(497);
		CLAN_INFO_LEADER_S1 = new SystemMessageId(498);
		CLAN_INFO_LEVEL_S1 = new SystemMessageId(499);
		CLAN_INFO_SEPARATOR = new SystemMessageId(500);
		CLAN_INFO_FOOT = new SystemMessageId(501);
		ALREADY_JOINED_ALLIANCE = new SystemMessageId(502);
		FRIEND_S1_HAS_LOGGED_IN = new SystemMessageId(503);
		ONLY_CLAN_LEADER_CREATE_ALLIANCE = new SystemMessageId(504);
		CANT_CREATE_ALLIANCE_10_DAYS_DISOLUTION = new SystemMessageId(505);
		INCORRECT_ALLIANCE_NAME = new SystemMessageId(506);
		INCORRECT_ALLIANCE_NAME_LENGTH = new SystemMessageId(507);
		ALLIANCE_ALREADY_EXISTS = new SystemMessageId(508);
		CANT_ACCEPT_ALLY_ENEMY_FOR_SIEGE = new SystemMessageId(509);
		YOU_INVITED_FOR_ALLIANCE = new SystemMessageId(510);
		SELECT_USER_TO_INVITE = new SystemMessageId(511);
		DO_YOU_WISH_TO_WITHDRW = new SystemMessageId(512);
		ENTER_NAME_CLAN_TO_EXPEL = new SystemMessageId(513);
		DO_YOU_WISH_TO_DISOLVE = new SystemMessageId(514);
		SI_INVITED_YOU_AS_FRIEND = new SystemMessageId(516);
		YOU_ACCEPTED_ALLIANCE = new SystemMessageId(517);
		FAILED_TO_INVITE_CLAN_IN_ALLIANCE = new SystemMessageId(518);
		YOU_HAVE_WITHDRAWN_FROM_ALLIANCE = new SystemMessageId(519);
		YOU_HAVE_FAILED_TO_WITHDRAWN_FROM_ALLIANCE = new SystemMessageId(520);
		YOU_HAVE_EXPELED_A_CLAN = new SystemMessageId(521);
		FAILED_TO_EXPELED_A_CLAN = new SystemMessageId(522);
		ALLIANCE_DISOLVED = new SystemMessageId(523);
		FAILED_TO_DISOLVE_ALLIANCE = new SystemMessageId(524);
		YOU_HAVE_SUCCEEDED_INVITING_FRIEND = new SystemMessageId(525);
		FAILED_TO_INVITE_A_FRIEND = new SystemMessageId(526);
		S2_ALLIANCE_LEADER_OF_S1_REQUESTED_ALLIANCE = new SystemMessageId(527);
		SPIRITSHOTS_GRADE_MISMATCH = new SystemMessageId(530);
		NOT_ENOUGH_SPIRITSHOTS = new SystemMessageId(531);
		CANNOT_USE_SPIRITSHOTS = new SystemMessageId(532);
		ENABLED_SPIRITSHOT = new SystemMessageId(533);
		DISABLED_SPIRITSHOT = new SystemMessageId(534);
		HOW_MUCH_ADENA_TRANSFER = new SystemMessageId(536);
		HOW_MUCH_TRANSFER = new SystemMessageId(537);
		SP_DECREASED_S1 = new SystemMessageId(538);
		EXP_DECREASED_BY_S1 = new SystemMessageId(539);
		CLAN_LEADERS_MAY_NOT_BE_DELETED = new SystemMessageId(540);
		CLAN_MEMBER_MAY_NOT_BE_DELETED = new SystemMessageId(541);
		THE_NPC_SERVER_IS_CURRENTLY_DOWN = new SystemMessageId(542);
		YOU_ALREADY_HAVE_A_PET = new SystemMessageId(543);
		ITEM_NOT_FOR_PETS = new SystemMessageId(544);
		YOUR_PET_CANNOT_CARRY_ANY_MORE_ITEMS = new SystemMessageId(545);
		UNABLE_TO_PLACE_ITEM_YOUR_PET_IS_TOO_ENCUMBERED = new SystemMessageId(546);
		SUMMON_A_PET = new SystemMessageId(547);
		NAMING_PETNAME_UP_TO_8CHARS = new SystemMessageId(548);
		TO_CREATE_AN_ALLY_YOU_CLAN_MUST_BE_LEVEL_5_OR_HIGHER = new SystemMessageId(549);
		YOU_MAY_NOT_CREATE_ALLY_WHILE_DISSOLVING = new SystemMessageId(550);
		CANNOT_RISE_LEVEL_WHILE_DISSOLUTION_IN_PROGRESS = new SystemMessageId(551);
		CANNOT_SET_CREST_WHILE_DISSOLUTION_IN_PROGRESS = new SystemMessageId(552);
		OPPOSING_CLAN_APPLIED_DISPERSION = new SystemMessageId(553);
		CANNOT_DISPERSE_THE_CLANS_IN_ALLY = new SystemMessageId(554);
		CANT_MOVE_TOO_ENCUMBERED = new SystemMessageId(555);
		CANT_MOVE_IN_THIS_STATE = new SystemMessageId(556);
		PET_SUMMONED_MAY_NOT_DESTROYED = new SystemMessageId(557);
		PET_SUMMONED_MAY_NOT_LET_GO = new SystemMessageId(558);
		PURCHASED_S2_FROM_C1 = new SystemMessageId(559);
		PURCHASED_S2_S3_FROM_C1 = new SystemMessageId(560);
		PURCHASED_S3_S2_S_FROM_C1 = new SystemMessageId(561);
		CRYSTALLIZE_LEVEL_TOO_LOW = new SystemMessageId(562);
		FAILED_DISABLE_TARGET = new SystemMessageId(563);
		FAILED_CHANGE_TARGET = new SystemMessageId(564);
		NOT_ENOUGH_LUCK = new SystemMessageId(565);
		CONFUSION_FAILED = new SystemMessageId(566);
		FEAR_FAILED = new SystemMessageId(567);
		CUBIC_SUMMONING_FAILED = new SystemMessageId(568);
		C1_INVITED_YOU_TO_PARTY_FINDERS_KEEPERS = new SystemMessageId(572);
		C1_INVITED_YOU_TO_PARTY_RANDOM = new SystemMessageId(573);
		PETS_ARE_NOT_AVAILABLE_AT_THIS_TIME = new SystemMessageId(574);
		HOW_MUCH_ADENA_TRANSFER_TO_PET = new SystemMessageId(575);
		HOW_MUCH_TRANSFER2 = new SystemMessageId(576);
		CANNOT_SUMMON_DURING_TRADE_SHOP = new SystemMessageId(577);
		YOU_CANNOT_SUMMON_IN_COMBAT = new SystemMessageId(578);
		PET_CANNOT_SENT_BACK_DURING_BATTLE = new SystemMessageId(579);
		SUMMON_ONLY_ONE = new SystemMessageId(580);
		NAMING_THERE_IS_A_SPACE = new SystemMessageId(581);
		NAMING_INAPPROPRIATE_CHARACTER_NAME = new SystemMessageId(582);
		NAMING_INCLUDES_FORBIDDEN_WORDS = new SystemMessageId(583);
		NAMING_ALREADY_IN_USE_BY_ANOTHER_PET = new SystemMessageId(584);
		DECIDE_ON_PRICE = new SystemMessageId(585);
		PET_NO_SHORTCUT = new SystemMessageId(586);
		PET_INVENTORY_FULL = new SystemMessageId(588);
		DEAD_PET_CANNOT_BE_RETURNED = new SystemMessageId(589);
		CANNOT_GIVE_ITEMS_TO_DEAD_PET = new SystemMessageId(590);
		NAMING_PETNAME_CONTAINS_INVALID_CHARS = new SystemMessageId(591);
		WISH_TO_DISMISS_PET = new SystemMessageId(592);
		STARVING_GRUMPY_AND_FED_UP_YOUR_PET_HAS_LEFT = new SystemMessageId(593);
		YOU_CANNOT_RESTORE_HUNGRY_PETS = new SystemMessageId(594);
		YOUR_PET_IS_VERY_HUNGRY = new SystemMessageId(595);
		YOUR_PET_ATE_A_LITTLE_BUT_IS_STILL_HUNGRY = new SystemMessageId(596);
		YOUR_PET_IS_VERY_HUNGRY_PLEASE_BE_CAREFULL = new SystemMessageId(597);
		NOT_CHAT_WHILE_INVISIBLE = new SystemMessageId(598);
		GM_NOTICE_CHAT_DISABLED = new SystemMessageId(599);
		CANNOT_EQUIP_PET_ITEM = new SystemMessageId(600);
		S1_PETITION_ON_WAITING_LIST = new SystemMessageId(601);
		PETITION_SYSTEM_CURRENT_UNAVAILABLE = new SystemMessageId(602);
		CANNOT_DISCARD_EXCHANGE_ITEM = new SystemMessageId(603);
		NOT_CALL_PET_FROM_THIS_LOCATION = new SystemMessageId(604);
		MAY_REGISTER_UP_TO_64_PEOPLE = new SystemMessageId(605);
		OTHER_PERSON_ALREADY_64_PEOPLE = new SystemMessageId(606);
		DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1 = new SystemMessageId(607);
		C1_SWEEPED_UP_S3_S2 = new SystemMessageId(608);
		C1_SWEEPED_UP_S2 = new SystemMessageId(609);
		SKILL_REMOVED_DUE_LACK_HP = new SystemMessageId(610);
		CONFUSING_SUCCEEDED = new SystemMessageId(611);
		SPOIL_SUCCESS = new SystemMessageId(612);
		BLOCK_LIST_HEADER = new SystemMessageId(613);
		C1_D_C2 = new SystemMessageId(614);
		FAILED_TO_REGISTER_TO_IGNORE_LIST = new SystemMessageId(615);
		FAILED_TO_DELETE_CHARACTER = new SystemMessageId(616);
		S1_WAS_ADDED_TO_YOUR_IGNORE_LIST = new SystemMessageId(617);
		S1_WAS_REMOVED_FROM_YOUR_IGNORE_LIST = new SystemMessageId(618);
		S1_HAS_ADDED_YOU_TO_IGNORE_LIST = new SystemMessageId(619);
		S1_HAS_ADDED_YOU_TO_IGNORE_LIST2 = new SystemMessageId(620);
		CONNECTION_RESTRICTED_IP = new SystemMessageId(621);
		NO_WAR_DURING_ALLY_BATTLE = new SystemMessageId(622);
		OPPONENT_TOO_MUCH_ALLY_BATTLES1 = new SystemMessageId(623);
		S1_LEADER_NOT_CONNECTED = new SystemMessageId(624);
		ALLY_BATTLE_TRUCE_DENIED = new SystemMessageId(625);
		WAR_PROCLAMATION_HAS_BEEN_REFUSED = new SystemMessageId(626);
		YOU_REFUSED_CLAN_WAR_PROCLAMATION = new SystemMessageId(627);
		ALREADY_AT_WAR_WITH_S1_WAIT_5_DAYS = new SystemMessageId(628);
		OPPONENT_TOO_MUCH_ALLY_BATTLES2 = new SystemMessageId(629);
		WAR_WITH_CLAN_BEGUN = new SystemMessageId(630);
		WAR_WITH_CLAN_ENDED = new SystemMessageId(631);
		WON_WAR_OVER_CLAN = new SystemMessageId(632);
		SURRENDERED_TO_CLAN = new SystemMessageId(633);
		DEFEATED_BY_CLAN = new SystemMessageId(634);
		TIME_UP_WAR_OVER = new SystemMessageId(635);
		NOT_INVOLVED_IN_WAR = new SystemMessageId(636);
		ALLY_REGISTERED_SELF_TO_OPPONENT = new SystemMessageId(637);
		ALREADY_REQUESTED_SIEGE_BATTLE = new SystemMessageId(638);
		APPLICATION_DENIED_BECAUSE_ALREADY_SUBMITTED_A_REQUEST_FOR_ANOTHER_SIEGE_BATTLE = new SystemMessageId(639);
		FAILED_TO_REFUSE_CASTLE_DEFENSE_AID = new SystemMessageId(640);
		FAILED_TO_APPROVE_CASTLE_DEFENSE_AID = new SystemMessageId(641);
		ALREADY_ATTACKER_NOT_CANCEL = new SystemMessageId(642);
		ALREADY_DEFENDER_NOT_CANCEL = new SystemMessageId(643);
		NOT_REGISTERED_FOR_SIEGE = new SystemMessageId(644);
		ONLY_CLAN_LEVEL_5_ABOVE_MAY_SIEGE = new SystemMessageId(645);
		DO_NOT_HAVE_AUTHORITY_TO_MODIFY_CASTLE_DEFENDER_LIST = new SystemMessageId(646);
		DO_NOT_HAVE_AUTHORITY_TO_MODIFY_SIEGE_TIME = new SystemMessageId(647);
		ATTACKER_SIDE_FULL = new SystemMessageId(648);
		DEFENDER_SIDE_FULL = new SystemMessageId(649);
		YOU_MAY_NOT_SUMMON_FROM_YOUR_CURRENT_LOCATION = new SystemMessageId(650);
		PLACE_CURRENT_LOCATION_DIRECTION = new SystemMessageId(651);
		TARGET_OF_SUMMON_WRONG = new SystemMessageId(652);
		YOU_DO_NOT_HAVE_AUTHORITY_TO_POSITION_MERCENARIES = new SystemMessageId(653);
		YOU_DO_NOT_HAVE_AUTHORITY_TO_CANCEL_MERCENARY_POSITIONING = new SystemMessageId(654);
		MERCENARIES_CANNOT_BE_POSITIONED_HERE = new SystemMessageId(655);
		THIS_MERCENARY_CANNOT_BE_POSITIONED_ANYMORE = new SystemMessageId(656);
		POSITIONING_CANNOT_BE_DONE_BECAUSE_DISTANCE_BETWEEN_MERCENARIES_TOO_SHORT = new SystemMessageId(657);
		THIS_IS_NOT_A_MERCENARY_OF_A_CASTLE_THAT_YOU_OWN_AND_SO_CANNOT_CANCEL_POSITIONING = new SystemMessageId(658);
		NOT_SIEGE_REGISTRATION_TIME1 = new SystemMessageId(659);
		NOT_SIEGE_REGISTRATION_TIME2 = new SystemMessageId(660);
		SPOIL_CANNOT_USE = new SystemMessageId(661);
		THE_PLAYER_IS_REJECTING_FRIEND_INVITATIONS = new SystemMessageId(662);
		SIEGE_TIME_DECLARED_FOR_S1 = new SystemMessageId(663);
		CHOOSE_PERSON_TO_RECEIVE = new SystemMessageId(664);
		APPLYING_ALLIANCE_WAR = new SystemMessageId(665);
		REQUEST_FOR_CEASEFIRE = new SystemMessageId(666);
		REGISTERING_ON_ATTACKING_SIDE = new SystemMessageId(667);
		REGISTERING_ON_DEFENDING_SIDE = new SystemMessageId(668);
		CANCELING_REGISTRATION = new SystemMessageId(669);
		REFUSING_REGISTRATION = new SystemMessageId(670);
		AGREEING_REGISTRATION = new SystemMessageId(671);
		S1_DISAPPEARED_ADENA = new SystemMessageId(672);
		AUCTION_ONLY_CLAN_LEVEL_2_HIGHER = new SystemMessageId(673);
		NOT_SEVEN_DAYS_SINCE_CANCELING_AUCTION = new SystemMessageId(674);
		NO_CLAN_HALLS_UP_FOR_AUCTION = new SystemMessageId(675);
		ALREADY_SUBMITTED_BID = new SystemMessageId(676);
		BID_PRICE_MUST_BE_HIGHER = new SystemMessageId(677);
		SUBMITTED_A_BID_OF_S1 = new SystemMessageId(678);
		CANCELED_BID = new SystemMessageId(679);
		CANNOT_PARTICIPATE_IN_AN_AUCTION = new SystemMessageId(680);
		CLAN_HAS_NO_CLAN_HALL = new SystemMessageId(681);
		MOVING_TO_ANOTHER_VILLAGE = new SystemMessageId(681);
		SWEEP_NOT_ALLOWED = new SystemMessageId(683);
		CANNOT_POSITION_MERCS_DURING_SIEGE = new SystemMessageId(684);
		CANNOT_DECLARE_WAR_ON_ALLY = new SystemMessageId(685);
		S1_DAMAGE_FROM_FIRE_MAGIC = new SystemMessageId(686);
		CANNOT_MOVE_FROZEN = new SystemMessageId(687);
		CLAN_THAT_OWNS_CASTLE_IS_AUTOMATICALLY_REGISTERED_DEFENDING = new SystemMessageId(688);
		CLAN_THAT_OWNS_CASTLE_CANNOT_PARTICIPATE_OTHER_SIEGE = new SystemMessageId(689);
		CANNOT_ATTACK_ALLIANCE_CASTLE = new SystemMessageId(690);
		S1_CLAN_ALREADY_MEMBER_OF_S2_ALLIANCE = new SystemMessageId(691);
		OTHER_PARTY_IS_FROZEN = new SystemMessageId(692);
		PACKAGE_IN_ANOTHER_WAREHOUSE = new SystemMessageId(693);
		NO_PACKAGES_ARRIVED = new SystemMessageId(694);
		NAMING_YOU_CANNOT_SET_NAME_OF_THE_PET = new SystemMessageId(695);
		ITEM_ENCHANT_VALUE_STRANGE = new SystemMessageId(697);
		PRICE_DIFFERENT_FROM_SALES_LIST = new SystemMessageId(698);
		CURRENTLY_NOT_PURCHASING = new SystemMessageId(699);
		THE_PURCHASE_IS_COMPLETE = new SystemMessageId(700);
		NOT_ENOUGH_REQUIRED_ITEMS = new SystemMessageId(701);
		NO_GM_PROVIDING_SERVICE_NOW = new SystemMessageId(702);
		GM_LIST = new SystemMessageId(703);
		GM_C1 = new SystemMessageId(704);
		CANNOT_EXCLUDE_SELF = new SystemMessageId(705);
		ONLY_64_NAMES_ON_EXCLUDE_LIST = new SystemMessageId(706);
		NO_PORT_THAT_IS_IN_SIGE = new SystemMessageId(707);
		YOU_DO_NOT_HAVE_THE_RIGHT_TO_USE_CASTLE_WAREHOUSE = new SystemMessageId(708);
		YOU_DO_NOT_HAVE_THE_RIGHT_TO_USE_CLAN_WAREHOUSE = new SystemMessageId(709);
		ONLY_LEVEL_1_CLAN_OR_HIGHER_CAN_USE_WAREHOUSE = new SystemMessageId(710);
		SIEGE_OF_S1_HAS_STARTED = new SystemMessageId(711);
		SIEGE_OF_S1_HAS_ENDED = new SystemMessageId(712);
		S1_S2_S3_D = new SystemMessageId(713);
		A_TRAP_DEVICE_HAS_BEEN_TRIPPED = new SystemMessageId(714);
		A_TRAP_DEVICE_HAS_BEEN_STOPPED = new SystemMessageId(715);
		NO_RESURRECTION_WITHOUT_BASE_CAMP = new SystemMessageId(716);
		TOWER_DESTROYED_NO_RESURRECTION = new SystemMessageId(717);
		GATES_NOT_OPENED_CLOSED_DURING_SIEGE = new SystemMessageId(718);
		ITEM_MIXING_FAILED = new SystemMessageId(719);
		THE_PURCHASE_PRICE_IS_HIGHER_THAN_MONEY = new SystemMessageId(720);
		NO_ALLY_CREATION_WHILE_SIEGE = new SystemMessageId(721);
		CANNOT_DISSOLVE_ALLY_WHILE_IN_SIEGE = new SystemMessageId(722);
		OPPOSING_CLAN_IS_PARTICIPATING_IN_SIEGE = new SystemMessageId(723);
		CANNOT_LEAVE_WHILE_SIEGE = new SystemMessageId(724);
		CANNOT_DISMISS_WHILE_SIEGE = new SystemMessageId(725);
		FROZEN_CONDITION_STARTED = new SystemMessageId(726);
		FROZEN_CONDITION_REMOVED = new SystemMessageId(727);
		CANNOT_APPLY_DISSOLUTION_AGAIN = new SystemMessageId(728);
		ITEM_NOT_DISCARDED = new SystemMessageId(729);
		SUBMITTED_YOU_S1_TH_PETITION_S2_LEFT = new SystemMessageId(730);
		PETITION_S1_RECEIVED_CODE_IS_S2 = new SystemMessageId(731);
		C1_RECEIVED_CONSULTATION_REQUEST = new SystemMessageId(732);
		WE_HAVE_RECEIVED_S1_PETITIONS_TODAY = new SystemMessageId(733);
		PETITION_FAILED_C1_ALREADY_SUBMITTED = new SystemMessageId(734);
		PETITION_FAILED_FOR_C1_ERROR_NUMBER_S2 = new SystemMessageId(735);
		PETITION_CANCELED_SUBMIT_S1_MORE_TODAY = new SystemMessageId(736);
		CANCELED_PETITION_ON_S1 = new SystemMessageId(737);
		PETITION_NOT_SUBMITTED = new SystemMessageId(738);
		PETITION_CANCEL_FAILED_FOR_C1_ERROR_NUMBER_S2 = new SystemMessageId(739);
		C1_PARTICIPATE_PETITION = new SystemMessageId(740);
		FAILED_ADDING_C1_TO_PETITION = new SystemMessageId(741);
		PETITION_ADDING_C1_FAILED_ERROR_NUMBER_S2 = new SystemMessageId(742);
		C1_LEFT_PETITION_CHAT = new SystemMessageId(743);
		PETITION_REMOVING_S1_FAILED_ERROR_NUMBER_S2 = new SystemMessageId(744);
		YOU_ARE_NOT_IN_PETITION_CHAT = new SystemMessageId(745);
		CURRENTLY_NO_PETITION = new SystemMessageId(746);
		DIST_TOO_FAR_CASTING_STOPPED = new SystemMessageId(748);
		EFFECT_S1_DISAPPEARED = new SystemMessageId(749);
		NO_MORE_SKILLS_TO_LEARN = new SystemMessageId(750);
		CANNOT_INVITE_CONFLICT_CLAN = new SystemMessageId(751);
		CANNOT_USE_NAME = new SystemMessageId(752);
		NO_MERCS_HERE = new SystemMessageId(753);
		S1_HOURS_S2_MINUTES_LEFT_THIS_WEEK = new SystemMessageId(754);
		S1_MINUTES_LEFT_THIS_WEEK = new SystemMessageId(755);
		WEEKS_USAGE_TIME_FINISHED = new SystemMessageId(756);
		S1_HOURS_S2_MINUTES_LEFT_IN_TIME = new SystemMessageId(757);
		S1_HOURS_S2_MINUTES_LEFT_THIS_WEEKS_PLAY_TIME = new SystemMessageId(758);
		S1_MINUTES_LEFT_THIS_WEEKS_PLAY_TIME = new SystemMessageId(759);
		C1_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN = new SystemMessageId(760);
		S1_CANT_ENTER_ALLIANCE_WITHIN_1_DAY = new SystemMessageId(761);
		C1_ROLLED_S2_S3_EYE_CAME_OUT = new SystemMessageId(762);
		FAILED_SENDING_PACKAGE_TOO_FAR = new SystemMessageId(763);
		PLAYING_FOR_LONG_TIME = new SystemMessageId(764);
		HACKING_TOOL = new SystemMessageId(769);
		PLAY_TIME_NO_LONGER_ACCUMULATING = new SystemMessageId(774);
		PLAY_TIME_EXPENDED = new SystemMessageId(775);
		CLANHALL_AWARDED_TO_CLAN = new SystemMessageId(776);
		CLANHALL_NOT_SOLD = new SystemMessageId(777);
		NO_LOGOUT_HERE = new SystemMessageId(778);
		NO_RESTART_HERE = new SystemMessageId(779);
		ONLY_VIEW_SIEGE = new SystemMessageId(780);
		OBSERVERS_CANNOT_PARTICIPATE = new SystemMessageId(781);
		NO_OBSERVE_WITH_PET = new SystemMessageId(782);
		LOTTERY_TICKET_SALES_TEMP_SUSPENDED = new SystemMessageId(783);
		NO_LOTTERY_TICKETS_AVAILABLE = new SystemMessageId(784);
		LOTTERY_S1_RESULT_NOT_PUBLISHED = new SystemMessageId(785);
		INCORRECT_SYNTAX = new SystemMessageId(786);
		CLANHALL_SIEGE_TRYOUTS_FINISHED = new SystemMessageId(787);
		CLANHALL_SIEGE_FINALS_FINISHED = new SystemMessageId(788);
		CLANHALL_SIEGE_TRYOUTS_BEGUN = new SystemMessageId(789);
		CLANHALL_SIEGE_FINALS_BEGUN = new SystemMessageId(790);
		FINAL_MATCH_BEGIN = new SystemMessageId(791);
		CLANHALL_SIEGE_ENDED = new SystemMessageId(792);
		CLANHALL_SIEGE_BEGUN = new SystemMessageId(793);
		YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT = new SystemMessageId(794);
		ONLY_LEADERS_CAN_SET_RIGHTS = new SystemMessageId(795);
		REMAINING_OBSERVATION_TIME = new SystemMessageId(796);
		YOU_MAY_CREATE_UP_TO_48_MACROS = new SystemMessageId(797);
		ITEM_REGISTRATION_IRREVERSIBLE = new SystemMessageId(798);
		OBSERVATION_TIME_EXPIRED = new SystemMessageId(799);
		REGISTRATION_PERIOD_OVER = new SystemMessageId(800);
		REGISTRATION_CLOSED = new SystemMessageId(801);
		PETITION_NOT_ACCEPTED_NOW = new SystemMessageId(802);
		PETITION_NOT_SPECIFIED = new SystemMessageId(803);
		SELECT_TYPE = new SystemMessageId(804);
		PETITION_NOT_ACCEPTED_SUBMIT_AT_S1 = new SystemMessageId(805);
		TRY_UNSTUCK_WHEN_TRAPPED = new SystemMessageId(806);
		STUCK_PREPARE_FOR_TRANSPORT = new SystemMessageId(807);
		STUCK_SUBMIT_PETITION = new SystemMessageId(808);
		STUCK_TRANSPORT_IN_FIVE_MINUTES = new SystemMessageId(809);
		INVALID_MACRO = new SystemMessageId(810);
		WILL_BE_MOVED = new SystemMessageId(811);
		TRAP_DID_S1_DAMAGE = new SystemMessageId(812);
		POISONED_BY_TRAP = new SystemMessageId(813);
		SLOWED_BY_TRAP = new SystemMessageId(814);
		TRYOUTS_ABOUT_TO_BEGIN = new SystemMessageId(815);
		MONSRACE_TICKETS_AVAILABLE_FOR_S1_RACE = new SystemMessageId(816);
		MONSRACE_TICKETS_NOW_AVAILABLE_FOR_S1_RACE = new SystemMessageId(817);
		MONSRACE_TICKETS_STOP_IN_S1_MINUTES = new SystemMessageId(818);
		MONSRACE_S1_TICKET_SALES_CLOSED = new SystemMessageId(819);
		MONSRACE_S2_BEGINS_IN_S1_MINUTES = new SystemMessageId(820);
		MONSRACE_S1_BEGINS_IN_30_SECONDS = new SystemMessageId(821);
		MONSRACE_S1_COUNTDOWN_IN_FIVE_SECONDS = new SystemMessageId(822);
		MONSRACE_BEGINS_IN_S1_SECONDS = new SystemMessageId(823);
		MONSRACE_RACE_START = new SystemMessageId(824);
		MONSRACE_S1_RACE_END = new SystemMessageId(825);
		MONSRACE_FIRST_PLACE_S1_SECOND_S2 = new SystemMessageId(826);
		YOU_MAY_NOT_IMPOSE_A_BLOCK_ON_GM = new SystemMessageId(827);
		WISH_TO_DELETE_S1_MACRO = new SystemMessageId(828);
		YOU_CANNOT_RECOMMEND_YOURSELF = new SystemMessageId(829);
		YOU_HAVE_RECOMMENDED_C1_YOU_HAVE_S2_RECOMMENDATIONS_LEFT = new SystemMessageId(830);
		YOU_HAVE_BEEN_RECOMMENDED_BY_C1 = new SystemMessageId(831);
		THAT_CHARACTER_IS_RECOMMENDED = new SystemMessageId(832);
		NO_MORE_RECOMMENDATIONS_TO_HAVE = new SystemMessageId(833);
		C1_ROLLED_S2 = new SystemMessageId(834);
		YOU_MAY_NOT_THROW_THE_DICE_AT_THIS_TIME_TRY_AGAIN_LATER = new SystemMessageId(835);
		YOU_HAVE_EXCEEDED_YOUR_INVENTORY_VOLUME_LIMIT_AND_CANNOT_TAKE_THIS_ITEM = new SystemMessageId(836);
		MACRO_DESCRIPTION_MAX_32_CHARS = new SystemMessageId(837);
		ENTER_THE_MACRO_NAME = new SystemMessageId(838);
		MACRO_NAME_ALREADY_USED = new SystemMessageId(839);
		RECIPE_ALREADY_REGISTERED = new SystemMessageId(840);
		NO_FUTHER_RECIPES_CAN_BE_ADDED = new SystemMessageId(841);
		NOT_AUTHORIZED_REGISTER_RECIPE = new SystemMessageId(842);
		SIEGE_OF_S1_FINISHED = new SystemMessageId(843);
		SIEGE_OF_S1_BEGUN = new SystemMessageId(844);
		DEADLINE_FOR_SIEGE_S1_PASSED = new SystemMessageId(845);
		SIEGE_OF_S1_HAS_BEEN_CANCELED_DUE_TO_LACK_OF_INTEREST = new SystemMessageId(846);
		CLAN_OWNING_CLANHALL_MAY_NOT_SIEGE_CLANHALL = new SystemMessageId(847);
		S1_HAS_BEEN_DELETED = new SystemMessageId(848);
		S1_NOT_FOUND = new SystemMessageId(849);
		S1_ALREADY_EXISTS2 = new SystemMessageId(850);
		S1_ADDED = new SystemMessageId(851);
		RECIPE_INCORRECT = new SystemMessageId(852);
		CANT_ALTER_RECIPEBOOK_WHILE_CRAFTING = new SystemMessageId(853);
		MISSING_S2_S1_TO_CREATE = new SystemMessageId(854);
		S1_CLAN_DEFEATED_S2 = new SystemMessageId(855);
		SIEGE_S1_DRAW = new SystemMessageId(856);
		S1_CLAN_WON_MATCH_S2 = new SystemMessageId(857);
		MATCH_OF_S1_DRAW = new SystemMessageId(858);
		PLEASE_REGISTER_RECIPE = new SystemMessageId(859);
		HEADQUARTERS_TOO_CLOSE = new SystemMessageId(860);
		TOO_MANY_MEMOS = new SystemMessageId(861);
		ODDS_NOT_POSTED = new SystemMessageId(862);
		FEEL_ENERGY_FIRE = new SystemMessageId(863);
		FEEL_ENERGY_WATER = new SystemMessageId(864);
		FEEL_ENERGY_WIND = new SystemMessageId(865);
		NO_LONGER_ENERGY = new SystemMessageId(866);
		ENERGY_DEPLETED = new SystemMessageId(867);
		ENERGY_FIRE_DELIVERED = new SystemMessageId(868);
		ENERGY_WATER_DELIVERED = new SystemMessageId(869);
		ENERGY_WIND_DELIVERED = new SystemMessageId(870);
		THE_SEED_HAS_BEEN_SOWN = new SystemMessageId(871);
		THIS_SEED_MAY_NOT_BE_SOWN_HERE = new SystemMessageId(872);
		CHARACTER_DOES_NOT_EXIST = new SystemMessageId(873);
		WAREHOUSE_CAPACITY_EXCEEDED = new SystemMessageId(874);
		CARGO_CANCELED = new SystemMessageId(875);
		CARGO_NOT_DELIVERED = new SystemMessageId(876);
		SYMBOL_ADDED = new SystemMessageId(877);
		SYMBOL_DELETED = new SystemMessageId(878);
		THE_MANOR_SYSTEM_IS_CURRENTLY_UNDER_MAINTENANCE = new SystemMessageId(879);
		THE_TRANSACTION_IS_COMPLETE = new SystemMessageId(880);
		THERE_IS_A_DISCREPANCY_ON_THE_INVOICE = new SystemMessageId(881);
		THE_SEED_QUANTITY_IS_INCORRECT = new SystemMessageId(882);
		THE_SEED_INFORMATION_IS_INCORRECT = new SystemMessageId(883);
		THE_MANOR_INFORMATION_HAS_BEEN_UPDATED = new SystemMessageId(884);
		THE_NUMBER_OF_CROPS_IS_INCORRECT = new SystemMessageId(885);
		THE_CROPS_ARE_PRICED_INCORRECTLY = new SystemMessageId(886);
		THE_TYPE_IS_INCORRECT = new SystemMessageId(887);
		NO_CROPS_CAN_BE_PURCHASED_AT_THIS_TIME = new SystemMessageId(888);
		THE_SEED_WAS_SUCCESSFULLY_SOWN = new SystemMessageId(889);
		THE_SEED_WAS_NOT_SOWN = new SystemMessageId(890);
		YOU_ARE_NOT_AUTHORIZED_TO_HARVEST = new SystemMessageId(891);
		THE_HARVEST_HAS_FAILED = new SystemMessageId(892);
		THE_HARVEST_FAILED_BECAUSE_THE_SEED_WAS_NOT_SOWN = new SystemMessageId(893);
		UP_TO_S1_RECIPES_CAN_REGISTER = new SystemMessageId(894);
		NO_RECIPES_REGISTERED = new SystemMessageId(895);
		FERRY_AT_GLUDIN = new SystemMessageId(896);
		FERRY_LEAVE_TALKING = new SystemMessageId(897);
		ONLY_LEVEL_SUP_10_CAN_RECOMMEND = new SystemMessageId(898);
		CANT_DRAW_SYMBOL = new SystemMessageId(899);
		SYMBOLS_FULL = new SystemMessageId(900);
		SYMBOL_NOT_FOUND = new SystemMessageId(901);
		NUMBER_INCORRECT = new SystemMessageId(902);
		NO_PETITION_WHILE_FROZEN = new SystemMessageId(903);
		NO_DISCARD_WHILE_PRIVATE_STORE = new SystemMessageId(904);
		HUMAN_SCORE_S1 = new SystemMessageId(905);
		ELVES_SCORE_S1 = new SystemMessageId(906);
		DARK_ELVES_SCORE_S1 = new SystemMessageId(907);
		ORCS_SCORE_S1 = new SystemMessageId(908);
		DWARVEN_SCORE_S1 = new SystemMessageId(909);
		LOC_TI_S1_S2_S3 = new SystemMessageId(910);
		LOC_GLUDIN_S1_S2_S3 = new SystemMessageId(911);
		LOC_GLUDIO_S1_S2_S3 = new SystemMessageId(912);
		LOC_NEUTRAL_ZONE_S1_S2_S3 = new SystemMessageId(913);
		LOC_ELVEN_S1_S2_S3 = new SystemMessageId(914);
		LOC_DARK_ELVEN_S1_S2_S3 = new SystemMessageId(915);
		LOC_DION_S1_S2_S3 = new SystemMessageId(916);
		LOC_FLORAN_S1_S2_S3 = new SystemMessageId(917);
		LOC_GIRAN_S1_S2_S3 = new SystemMessageId(918);
		LOC_GIRAN_HARBOR_S1_S2_S3 = new SystemMessageId(919);
		LOC_ORC_S1_S2_S3 = new SystemMessageId(920);
		LOC_DWARVEN_S1_S2_S3 = new SystemMessageId(921);
		LOC_OREN_S1_S2_S3 = new SystemMessageId(922);
		LOC_HUNTER_S1_S2_S3 = new SystemMessageId(923);
		LOC_ADEN_S1_S2_S3 = new SystemMessageId(924);
		LOC_COLISEUM_S1_S2_S3 = new SystemMessageId(925);
		LOC_HEINE_S1_S2_S3 = new SystemMessageId(926);
		TIME_S1_S2_IN_THE_DAY = new SystemMessageId(927);
		TIME_S1_S2_IN_THE_NIGHT = new SystemMessageId(928);
		NO_COMPENSATION_FOR_FARM_PRODUCTS = new SystemMessageId(929);
		NO_LOTTERY_TICKETS_CURRENT_SOLD = new SystemMessageId(930);
		LOTTERY_WINNERS_NOT_ANNOUNCED_YET = new SystemMessageId(931);
		NO_ALLCHAT_WHILE_OBSERVING = new SystemMessageId(932);
		THE_SEED_PRICING_GREATLY_DIFFERS_FROM_STANDARD_SEED_PRICES = new SystemMessageId(933);
		A_DELETED_RECIPE = new SystemMessageId(934);
		THE_AMOUNT_IS_NOT_SUFFICIENT_AND_SO_THE_MANOR_IS_NOT_IN_OPERATION = new SystemMessageId(935);
		USE_S1_ = new SystemMessageId(936);
		PREPARING_PRIVATE_WORKSHOP = new SystemMessageId(937);
		CB_OFFLINE = new SystemMessageId(938);
		NO_EXCHANGE_WHILE_BLOCKING = new SystemMessageId(939);
		S1_BLOCKED_EVERYTHING = new SystemMessageId(940);
		RESTART_AT_TI = new SystemMessageId(941);
		RESTART_AT_GLUDIN = new SystemMessageId(942);
		RESTART_AT_GLUDIO = new SystemMessageId(943);
		RESTART_AT_NEUTRAL_ZONE = new SystemMessageId(944);
		RESTART_AT_ELFEN_VILLAGE = new SystemMessageId(945);
		RESTART_AT_DARKELF_VILLAGE = new SystemMessageId(946);
		RESTART_AT_DION = new SystemMessageId(947);
		RESTART_AT_FLORAN = new SystemMessageId(948);
		RESTART_AT_GIRAN = new SystemMessageId(949);
		RESTART_AT_GIRAN_HARBOR = new SystemMessageId(950);
		RESTART_AT_ORC_VILLAGE = new SystemMessageId(951);
		RESTART_AT_DWARFEN_VILLAGE = new SystemMessageId(952);
		RESTART_AT_OREN = new SystemMessageId(953);
		RESTART_AT_HUNTERS_VILLAGE = new SystemMessageId(954);
		RESTART_AT_ADEN = new SystemMessageId(955);
		RESTART_AT_COLISEUM = new SystemMessageId(956);
		RESTART_AT_HEINE = new SystemMessageId(957);
		ITEMS_CANNOT_BE_DISCARDED_OR_DESTROYED_WHILE_OPERATING_PRIVATE_STORE_OR_WORKSHOP = new SystemMessageId(958);
		S1_S2_MANUFACTURED_SUCCESSFULLY = new SystemMessageId(959);
		S1_MANUFACTURE_FAILURE = new SystemMessageId(960);
		BLOCKING_ALL = new SystemMessageId(961);
		NOT_BLOCKING_ALL = new SystemMessageId(962);
		DETERMINE_MANUFACTURE_PRICE = new SystemMessageId(963);
		CHATBAN_FOR_1_MINUTE = new SystemMessageId(964);
		CHATBAN_REMOVED = new SystemMessageId(965);
		CHATTING_IS_CURRENTLY_PROHIBITED = new SystemMessageId(966);
		C1_PARTY_INVITE_RANDOM_INCLUDING_SPOIL = new SystemMessageId(967);
		C1_PARTY_INVITE_BY_TURN = new SystemMessageId(968);
		C1_PARTY_INVITE_BY_TURN_INCLUDING_SPOIL = new SystemMessageId(969);
		S2_MP_HAS_BEEN_DRAINED_BY_C1 = new SystemMessageId(970);
		PETITION_MAX_CHARS_255 = new SystemMessageId(971);
		PET_CANNOT_USE_ITEM = new SystemMessageId(972);
		INPUT_NO_MORE_YOU_HAVE = new SystemMessageId(973);
		SOUL_CRYSTAL_ABSORBING_SUCCEEDED = new SystemMessageId(974);
		SOUL_CRYSTAL_ABSORBING_FAILED = new SystemMessageId(975);
		SOUL_CRYSTAL_BROKE = new SystemMessageId(976);
		SOUL_CRYSTAL_ABSORBING_FAILED_RESONATION = new SystemMessageId(977);
		SOUL_CRYSTAL_ABSORBING_REFUSED = new SystemMessageId(978);
		FERRY_ARRIVED_AT_TALKING = new SystemMessageId(979);
		FERRY_LEAVE_FOR_GLUDIN_AFTER_10_MINUTES = new SystemMessageId(980);
		FERRY_LEAVE_FOR_GLUDIN_IN_5_MINUTES = new SystemMessageId(981);
		FERRY_LEAVE_FOR_GLUDIN_IN_1_MINUTE = new SystemMessageId(982);
		MAKE_HASTE_GET_ON_BOAT = new SystemMessageId(983);
		FERRY_LEAVE_SOON_FOR_GLUDIN = new SystemMessageId(984);
		FERRY_LEAVING_FOR_GLUDIN = new SystemMessageId(985);
		FERRY_ARRIVED_AT_GLUDIN = new SystemMessageId(986);
		FERRY_LEAVE_FOR_TALKING_AFTER_10_MINUTES = new SystemMessageId(987);
		FERRY_LEAVE_FOR_TALKING_IN_5_MINUTES = new SystemMessageId(988);
		FERRY_LEAVE_FOR_TALKING_IN_1_MINUTE = new SystemMessageId(989);
		FERRY_LEAVE_SOON_FOR_TALKING = new SystemMessageId(990);
		FERRY_LEAVING_FOR_TALKING = new SystemMessageId(991);
		FERRY_ARRIVED_AT_GIRAN = new SystemMessageId(992);
		FERRY_LEAVE_FOR_GIRAN_AFTER_10_MINUTES = new SystemMessageId(993);
		FERRY_LEAVE_FOR_GIRAN_IN_5_MINUTES = new SystemMessageId(994);
		FERRY_LEAVE_FOR_GIRAN_IN_1_MINUTE = new SystemMessageId(995);
		FERRY_LEAVE_SOON_FOR_GIRAN = new SystemMessageId(996);
		FERRY_LEAVING_FOR_GIRAN = new SystemMessageId(997);
		INNADRIL_BOAT_ANCHOR_10_MINUTES = new SystemMessageId(998);
		INNADRIL_BOAT_LEAVE_IN_5_MINUTES = new SystemMessageId(999);
		INNADRIL_BOAT_LEAVE_IN_1_MINUTE = new SystemMessageId(1000);
		INNADRIL_BOAT_LEAVE_SOON = new SystemMessageId(1001);
		INNADRIL_BOAT_LEAVING = new SystemMessageId(1002);
		CANNOT_POSSES_MONS_TICKET = new SystemMessageId(1003);
		REGISTERED_FOR_CLANHALL = new SystemMessageId(1004);
		NOT_ENOUGH_ADENA_IN_CWH = new SystemMessageId(1005);
		BID_IN_CLANHALL_AUCTION = new SystemMessageId(1006);
		PRELIMINARY_REGISTRATION_OF_S1_FINISHED = new SystemMessageId(1007);
		HUNGRY_STRIDER_NOT_MOUNT = new SystemMessageId(1008);
		STRIDER_CANT_BE_RIDDEN_WHILE_DEAD = new SystemMessageId(1009);
		DEAD_STRIDER_CANT_BE_RIDDEN = new SystemMessageId(1010);
		STRIDER_IN_BATLLE_CANT_BE_RIDDEN = new SystemMessageId(1011);
		STRIDER_CANT_BE_RIDDEN_WHILE_IN_BATTLE = new SystemMessageId(1012);
		STRIDER_CAN_BE_RIDDEN_ONLY_WHILE_STANDING = new SystemMessageId(1013);
		PET_EARNED_S1_EXP = new SystemMessageId(1014);
		PET_HIT_FOR_S1_DAMAGE = new SystemMessageId(1015);
		PET_RECEIVED_S2_DAMAGE_BY_C1 = new SystemMessageId(1016);
		CRITICAL_HIT_BY_PET = new SystemMessageId(1017);
		PET_USES_S1 = new SystemMessageId(1018);
		PET_USES_S1_ = new SystemMessageId(1019);
		PET_PICKED_S1 = new SystemMessageId(1020);
		PET_PICKED_S2_S1_S = new SystemMessageId(1021);
		PET_PICKED_S1_S2 = new SystemMessageId(1022);
		PET_PICKED_S1_ADENA = new SystemMessageId(1023);
		PET_PUT_ON_S1 = new SystemMessageId(1024);
		PET_TOOK_OFF_S1 = new SystemMessageId(1025);
		SUMMON_GAVE_DAMAGE_S1 = new SystemMessageId(1026);
		SUMMON_RECEIVED_DAMAGE_S2_BY_S1 = new SystemMessageId(1027);
		CRITICAL_HIT_BY_SUMMONED_MOB = new SystemMessageId(1028);
		SUMMONED_MOB_USES_S1 = new SystemMessageId(1029);
		PARTY_INFORMATION = new SystemMessageId(1030);
		LOOTING_FINDERS_KEEPERS = new SystemMessageId(1031);
		LOOTING_RANDOM = new SystemMessageId(1032);
		LOOTING_RANDOM_INCLUDE_SPOIL = new SystemMessageId(1033);
		LOOTING_BY_TURN = new SystemMessageId(1034);
		LOOTING_BY_TURN_INCLUDE_SPOIL = new SystemMessageId(1035);
		YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED = new SystemMessageId(1036);
		C1_MANUFACTURED_S2 = new SystemMessageId(1037);
		C1_MANUFACTURED_S3_S2_S = new SystemMessageId(1038);
		ONLY_CLAN_LEADER_CAN_RETRIEVE_ITEMS_FROM_CLAN_WAREHOUSE = new SystemMessageId(1039);
		ITEMS_SENT_BY_FREIGHT_PICKED_UP_FROM_ANYWHERE = new SystemMessageId(1040);
		THE_NEXT_SEED_PURCHASE_PRICE_IS_S1_ADENA = new SystemMessageId(1041);
		THE_NEXT_FARM_GOODS_PURCHASE_PRICE_IS_S1_ADENA = new SystemMessageId(1042);
		NO_UNSTUCK_PLEASE_SEND_PETITION = new SystemMessageId(1043);
		MONSRACE_NO_PAYOUT_INFO = new SystemMessageId(1044);
		MONSRACE_TICKETS_NOT_AVAILABLE = new SystemMessageId(1046);
		NOT_SUCCEED_PRODUCING_S1 = new SystemMessageId(1047);
		NO_WHISPER_WHEN_BLOCKING = new SystemMessageId(1048);
		NO_PARTY_WHEN_BLOCKING = new SystemMessageId(1049);
		NO_CB_IN_MY_CLAN = new SystemMessageId(1050);
		PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW = new SystemMessageId(1051);
		THE_CLAN_HALL_FEE_IS_ONE_WEEK_OVERDUE_THEREFORE_THE_CLAN_HALL_OWNERSHIP_HAS_BEEN_REVOKED = new SystemMessageId(1052);
		CANNOT_BE_RESURRECTED_DURING_SIEGE = new SystemMessageId(1053);
		ENTERED_MYSTICAL_LAND = new SystemMessageId(1054);
		EXITED_MYSTICAL_LAND = new SystemMessageId(1055);
		VAULT_CAPACITY_EXCEEDED = new SystemMessageId(1056);
		RELAX_SERVER_ONLY = new SystemMessageId(1057);
		THE_SALES_PRICE_FOR_SEEDS_IS_S1_ADENA = new SystemMessageId(1058);
		THE_REMAINING_PURCHASING_IS_S1_ADENA = new SystemMessageId(1059);
		THE_REMAINDER_AFTER_SELLING_THE_SEEDS_IS_S1 = new SystemMessageId(1060);
		CANT_REGISTER_NO_ABILITY_TO_CRAFT = new SystemMessageId(1061);
		WRITING_SOMETHING_NEW_POSSIBLE_AFTER_LEVEL_10 = new SystemMessageId(1062);
		PETITION_UNAVAILABLE = new SystemMessageId(1063);
		EQUIPMENT_S1_S2_REMOVED = new SystemMessageId(1064);
		CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE = new SystemMessageId(1065);
		S1_HP_RESTORED = new SystemMessageId(1066);
		S2_HP_RESTORED_BY_C1 = new SystemMessageId(1067);
		S1_MP_RESTORED = new SystemMessageId(1068);
		S2_MP_RESTORED_BY_C1 = new SystemMessageId(1069);
		NO_READ_PERMISSION = new SystemMessageId(1070);
		NO_WRITE_PERMISSION = new SystemMessageId(1071);
		OBTAINED_TICKET_FOR_MONS_RACE_S1_SINGLE = new SystemMessageId(1072);
		OBTAINED_TICKET_FOR_MONS_RACE_S1_SINGLE_ = new SystemMessageId(1073);
		NOT_MEET_AGE_REQUIREMENT_FOR_MONS_RACE = new SystemMessageId(1074);
		BID_AMOUNT_HIGHER_THAN_PREVIOUS_BID = new SystemMessageId(1075);
		GAME_CANNOT_TERMINATE_NOW = new SystemMessageId(1076);
		GG_EXECUTION_ERROR = new SystemMessageId(1077);
		DONT_SPAM = new SystemMessageId(1078);
		TARGET_IS_CHAT_BANNED = new SystemMessageId(1079);
		FACELIFT_POTION_TYPE_A = new SystemMessageId(1080);
		HAIRDYE_POTION_TYPE_A = new SystemMessageId(1081);
		HAIRSTYLE_POTION_TYPE_A = new SystemMessageId(1082);
		FACELIFT_POTION_TYPE_A_APPLIED = new SystemMessageId(1083);
		HAIRDYE_POTION_TYPE_A_APPLIED = new SystemMessageId(1084);
		HAIRSTYLE_POTION_TYPE_A_USED = new SystemMessageId(1085);
		FACE_APPEARANCE_CHANGED = new SystemMessageId(1086);
		HAIR_COLOR_CHANGED = new SystemMessageId(1087);
		HAIR_STYLE_CHANGED = new SystemMessageId(1088);
		C1_OBTAINED_ANNIVERSARY_ITEM = new SystemMessageId(1089);
		FACELIFT_POTION_TYPE_B = new SystemMessageId(1090);
		FACELIFT_POTION_TYPE_C = new SystemMessageId(1091);
		HAIRDYE_POTION_TYPE_B = new SystemMessageId(1092);
		HAIRDYE_POTION_TYPE_C = new SystemMessageId(1093);
		HAIRDYE_POTION_TYPE_D = new SystemMessageId(1094);
		HAIRSTYLE_POTION_TYPE_B = new SystemMessageId(1095);
		HAIRSTYLE_POTION_TYPE_C = new SystemMessageId(1096);
		HAIRSTYLE_POTION_TYPE_D = new SystemMessageId(1097);
		HAIRSTYLE_POTION_TYPE_E = new SystemMessageId(1098);
		HAIRSTYLE_POTION_TYPE_F = new SystemMessageId(1099);
		HAIRSTYLE_POTION_TYPE_G = new SystemMessageId(1100);
		FACELIFT_POTION_TYPE_B_APPLIED = new SystemMessageId(1101);
		FACELIFT_POTION_TYPE_C_APPLIED = new SystemMessageId(1102);
		HAIRDYE_POTION_TYPE_B_APPLIED = new SystemMessageId(1103);
		HAIRDYE_POTION_TYPE_C_APPLIED = new SystemMessageId(1104);
		HAIRDYE_POTION_TYPE_D_APPLIED = new SystemMessageId(1105);
		HAIRSTYLE_POTION_TYPE_B_USED = new SystemMessageId(1106);
		HAIRSTYLE_POTION_TYPE_C_USED = new SystemMessageId(1107);
		HAIRSTYLE_POTION_TYPE_D_USED = new SystemMessageId(1108);
		HAIRSTYLE_POTION_TYPE_E_USED = new SystemMessageId(1109);
		HAIRSTYLE_POTION_TYPE_F_USED = new SystemMessageId(1110);
		HAIRSTYLE_POTION_TYPE_G_USED = new SystemMessageId(1111);
		AMOUNT_FOR_WINNER_S1_IS_S2_ADENA_WE_HAVE_S3_PRIZE_WINNER = new SystemMessageId(1112);
		AMOUNT_FOR_LOTTERY_S1_IS_S2_ADENA_NO_WINNER = new SystemMessageId(1113);
		CANT_PARTICIPATE_IN_SIEGE_WHILE_DISSOLUTION_IN_PROGRESS = new SystemMessageId(1114);
		INDIVIDUALS_NOT_SURRENDER_DURING_COMBAT = new SystemMessageId(1115);
		YOU_CANNOT_LEAVE_DURING_COMBAT = new SystemMessageId(1116);
		CLAN_MEMBER_CANNOT_BE_DISMISSED_DURING_COMBAT = new SystemMessageId(1117);
		INVENTORY_LESS_THAN_80_PERCENT = new SystemMessageId(1118);
		QUEST_CANCELED_INVENTORY_EXCEEDS_80_PERCENT = new SystemMessageId(1119);
		STILL_CLAN_MEMBER = new SystemMessageId(1120);
		NO_RIGHT_TO_VOTE = new SystemMessageId(1121);
		NO_CANDIDATE = new SystemMessageId(1122);
		WEIGHT_EXCEEDED_SKILL_UNAVAILABLE = new SystemMessageId(1123);
		NO_RECIPE_BOOK_WHILE_CASTING = new SystemMessageId(1124);
		CANNOT_CREATED_WHILE_ENGAGED_IN_TRADING = new SystemMessageId(1125);
		NO_NEGATIVE_NUMBER = new SystemMessageId(1126);
		REWARD_LESS_THAN_10_TIMES_STANDARD_PRICE = new SystemMessageId(1127);
		PRIVATE_STORE_NOT_WHILE_CASTING = new SystemMessageId(1128);
		NOT_ALLOWED_ON_BOAT = new SystemMessageId(1129);
		GIVEN_S1_DAMAGE_TO_YOUR_TARGET_AND_S2_DAMAGE_TO_SERVITOR = new SystemMessageId(1130);
		NIGHT_EFFECT_APPLIES = new SystemMessageId(1131);
		DAY_EFFECT_DISAPPEARS = new SystemMessageId(1132);
		HP_DECREASED_EFFECT_APPLIES = new SystemMessageId(1133);
		HP_INCREASED_EFFECT_DISAPPEARS = new SystemMessageId(1134);
		CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT = new SystemMessageId(1135);
		ACCOUNT_NOT_ALLOWED_TO_CONNECT = new SystemMessageId(1136);
		C1_HARVESTED_S3_S2S = new SystemMessageId(1137);
		C1_HARVESTED_S2S = new SystemMessageId(1138);
		INVENTORY_LIMIT_MUST_NOT_BE_EXCEEDED = new SystemMessageId(1139);
		WOULD_YOU_LIKE_TO_OPEN_THE_GATE = new SystemMessageId(1140);
		WOULD_YOU_LIKE_TO_CLOSE_THE_GATE = new SystemMessageId(1141);
		CANNOT_SUMMON_S1_AGAIN = new SystemMessageId(1142);
		SERVITOR_DISAPPEARED_NOT_ENOUGH_ITEMS = new SystemMessageId(1143);
		NOBODY_IN_GAME_TO_CHAT = new SystemMessageId(1144);
		S2_CREATED_FOR_C1_FOR_S3_ADENA = new SystemMessageId(1145);
		C1_CREATED_S2_FOR_S3_ADENA = new SystemMessageId(1146);
		S2_S3_S_CREATED_FOR_C1_FOR_S4_ADENA = new SystemMessageId(1147);
		C1_CREATED_S2_S3_S_FOR_S4_ADENA = new SystemMessageId(1148);
		CREATION_OF_S2_FOR_C1_AT_S3_ADENA_FAILED = new SystemMessageId(1149);
		C1_FAILED_TO_CREATE_S2_FOR_S3_ADENA = new SystemMessageId(1150);
		S2_SOLD_TO_C1_FOR_S3_ADENA = new SystemMessageId(1151);
		S3_S2_S_SOLD_TO_C1_FOR_S4_ADENA = new SystemMessageId(1152);
		S2_PURCHASED_FROM_C1_FOR_S3_ADENA = new SystemMessageId(1153);
		S3_S2_S_PURCHASED_FROM_C1_FOR_S4_ADENA = new SystemMessageId(1154);
		S3_S2_SOLD_TO_C1_FOR_S4_ADENA = new SystemMessageId(1155);
		S2_S3_PURCHASED_FROM_C1_FOR_S4_ADENA = new SystemMessageId(1156);
		TRYING_ON_STATE = new SystemMessageId(1157);
		CANNOT_DISMOUNT_FROM_ELEVATION = new SystemMessageId(1158);
		FERRY_FROM_TALKING_ARRIVE_AT_GLUDIN_10_MINUTES = new SystemMessageId(1159);
		FERRY_FROM_TALKING_ARRIVE_AT_GLUDIN_5_MINUTES = new SystemMessageId(1160);
		FERRY_FROM_TALKING_ARRIVE_AT_GLUDIN_1_MINUTE = new SystemMessageId(1161);
		FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_15_MINUTES = new SystemMessageId(1162);
		FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_10_MINUTES = new SystemMessageId(1163);
		FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_5_MINUTES = new SystemMessageId(1164);
		FERRY_FROM_GIRAN_ARRIVE_AT_TALKING_1_MINUTE = new SystemMessageId(1165);
		FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_20_MINUTES = new SystemMessageId(1166);
		FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_15_MINUTES = new SystemMessageId(1167);
		FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_10_MINUTES = new SystemMessageId(1168);
		FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_5_MINUTES = new SystemMessageId(1169);
		FERRY_FROM_TALKING_ARRIVE_AT_GIRAN_1_MINUTE = new SystemMessageId(1170);
		INNADRIL_BOAT_ARRIVE_20_MINUTES = new SystemMessageId(1171);
		INNADRIL_BOAT_ARRIVE_15_MINUTES = new SystemMessageId(1172);
		INNADRIL_BOAT_ARRIVE_10_MINUTES = new SystemMessageId(1173);
		INNADRIL_BOAT_ARRIVE_5_MINUTES = new SystemMessageId(1174);
		INNADRIL_BOAT_ARRIVE_1_MINUTE = new SystemMessageId(1175);
		SSQ_COMPETITION_UNDERWAY = new SystemMessageId(1176);
		VALIDATION_PERIOD = new SystemMessageId(1177);
		AVARICE_DESCRIPTION = new SystemMessageId(1178);
		GNOSIS_DESCRIPTION = new SystemMessageId(1179);
		STRIFE_DESCRIPTION = new SystemMessageId(1180);
		CHANGE_TITLE_CONFIRM = new SystemMessageId(1181);
		CREST_DELETE_CONFIRM = new SystemMessageId(1182);
		INITIAL_PERIOD = new SystemMessageId(1183);
		RESULTS_PERIOD = new SystemMessageId(1184);
		DAYS_LEFT_UNTIL_DELETION = new SystemMessageId(1185);
		TO_CREATE_ACCOUNT_VISIT_WEBSITE = new SystemMessageId(1186);
		ACCOUNT_INFORMATION_FORGOTTON_VISIT_WEBSITE = new SystemMessageId(1187);
		YOUR_TARGET_NO_LONGER_RECEIVE_A_RECOMMENDATION = new SystemMessageId(1188);
		TEMPORARY_ALLIANCE = new SystemMessageId(1189);
		TEMPORARY_ALLIANCE_DISSOLVED = new SystemMessageId(1190);
		FERRY_FROM_GLUDIN_ARRIVE_AT_TALKING_10_MINUTES = new SystemMessageId(1191);
		FERRY_FROM_GLUDIN_ARRIVE_AT_TALKING_5_MINUTES = new SystemMessageId(1192);
		FERRY_FROM_GLUDIN_ARRIVE_AT_TALKING_1_MINUTE = new SystemMessageId(1193);
		MERC_CAN_BE_ASSIGNED = new SystemMessageId(1194);
		MERC_CANT_BE_ASSIGNED_USING_STRIFE = new SystemMessageId(1195);
		FORCE_MAXIMUM = new SystemMessageId(1196);
		SUMMONING_SERVITOR_COSTS_S2_S1 = new SystemMessageId(1197);
		CRYSTALLIZATION_SUCCESSFUL = new SystemMessageId(1198);
		CLAN_WAR_HEADER = new SystemMessageId(1199);
		S1_S2_ALLIANCE = new SystemMessageId(1200);
		SELECT_QUEST_TO_ABOR = new SystemMessageId(1201);
		S1_NO_ALLI_EXISTS = new SystemMessageId(1202);
		NO_WAR_IN_PROGRESS = new SystemMessageId(1203);
		SCREENSHOT = new SystemMessageId(1204);
		MAILBOX_FULL = new SystemMessageId(1205);
		MEMOBOX_FULL = new SystemMessageId(1206);
		MAKE_AN_ENTRY = new SystemMessageId(1207);
		C1_DIED_DROPPED_S3_S2 = new SystemMessageId(1208);
		RAID_WAS_SUCCESSFUL = new SystemMessageId(1209);
		QUEST_EVENT_PERIOD_BEGUN = new SystemMessageId(1210);
		QUEST_EVENT_PERIOD_ENDED = new SystemMessageId(1211);
		DAWN_OBTAINED_AVARICE = new SystemMessageId(1212);
		DAWN_OBTAINED_GNOSIS = new SystemMessageId(1213);
		DAWN_OBTAINED_STRIFE = new SystemMessageId(1214);
		DUSK_OBTAINED_AVARICE = new SystemMessageId(1215);
		DUSK_OBTAINED_GNOSIS = new SystemMessageId(1216);
		DUSK_OBTAINED_STRIFE = new SystemMessageId(1217);
		SEAL_VALIDATION_PERIOD_BEGUN = new SystemMessageId(1218);
		SEAL_VALIDATION_PERIOD_ENDED = new SystemMessageId(1219);
		SUMMON_CONFIRM = new SystemMessageId(1220);
		RETURN_CONFIRM = new SystemMessageId(1221);
		LOC_GM_CONSULATION_SERVICE_S1_S2_S3 = new SystemMessageId(1222);
		DEPART_FOR_TALKING_5_MINUTES = new SystemMessageId(1223);
		DEPART_FOR_TALKING_1_MINUTE = new SystemMessageId(1224);
		DEPART_FOR_TALKING = new SystemMessageId(1225);
		LEAVING_FOR_TALKING = new SystemMessageId(1226);
		S1_UNREAD_MESSAGES = new SystemMessageId(1227);
		C1_BLOCKED_YOU_CANNOT_MAIL = new SystemMessageId(1228);
		NO_MORE_MESSAGES_TODAY = new SystemMessageId(1229);
		ONLY_FIVE_RECIPIENTS = new SystemMessageId(1230);
		SENT_MAIL = new SystemMessageId(1231);
		MESSAGE_NOT_SENT = new SystemMessageId(1232);
		NEW_MAIL = new SystemMessageId(1233);
		MAIL_STORED_IN_MAILBOX = new SystemMessageId(1234);
		ALL_FRIENDS_DELETE_CONFIRM = new SystemMessageId(1235);
		ENTER_SECURITY_CARD_NUMBER = new SystemMessageId(1236);
		ENTER_CARD_NUMBER_FOR_S1 = new SystemMessageId(1237);
		TEMP_MAILBOX_FULL = new SystemMessageId(1238);
		KEYBOARD_MODULE_FAILED_LOAD = new SystemMessageId(1239);
		DUSK_WON = new SystemMessageId(1240);
		DAWN_WON = new SystemMessageId(1241);
		NOT_VERIFIED_AGE_NO_LOGIN = new SystemMessageId(1242);
		SECURITY_CARD_NUMBER_INVALID = new SystemMessageId(1243);
		NOT_VERIFIED_AGE_LOG_OFF = new SystemMessageId(1244);
		LOGOUT_IN_S1_MINUTES = new SystemMessageId(1245);
		C1_DIED_DROPPED_S2_ADENA = new SystemMessageId(1246);
		CORPSE_TOO_OLD_SKILL_NOT_USED = new SystemMessageId(1247);
		OUT_OF_FEED_MOUNT_CANCELED = new SystemMessageId(1248);
		YOU_MAY_ONLY_RIDE_WYVERN_WHILE_RIDING_STRIDER = new SystemMessageId(1249);
		SURRENDER_ALLY_WAR_CONFIRM = new SystemMessageId(1250);
		DISMISS_ALLY_CONFIRM = new SystemMessageId(1251);
		SURRENDER_CONFIRM1 = new SystemMessageId(1252);
		SURRENDER_CONFIRM2 = new SystemMessageId(1253);
		THANKS_FOR_FEEDBACK = new SystemMessageId(1254);
		GM_CONSULTATION_BEGUN = new SystemMessageId(1255);
		PLEASE_WRITE_NAME_AFTER_COMMAND = new SystemMessageId(1256);
		PET_SKILL_NOT_AS_MACRO = new SystemMessageId(1257);
		S1_CRYSTALLIZED = new SystemMessageId(1258);
		ALLIANCE_TARGET_HEADER = new SystemMessageId(1259);
		PREPARATIONS_PERIOD_BEGUN = new SystemMessageId(1260);
		COMPETITION_PERIOD_BEGUN = new SystemMessageId(1261);
		RESULTS_PERIOD_BEGUN = new SystemMessageId(1262);
		VALIDATION_PERIOD_BEGUN = new SystemMessageId(1263);
		STONE_CANNOT_ABSORB = new SystemMessageId(1264);
		CANT_ABSORB_WITHOUT_STONE = new SystemMessageId(1265);
		EXCHANGE_HAS_ENDED = new SystemMessageId(1266);
		CONTRIB_SCORE_INCREASED_S1 = new SystemMessageId(1267);
		ADD_SUBCLASS_CONFIRM = new SystemMessageId(1268);
		ADD_NEW_SUBCLASS = new SystemMessageId(1269);
		SUBCLASS_TRANSFER_COMPLETED = new SystemMessageId(1270);
		DAWN_CONFIRM = new SystemMessageId(1271);
		DUSK_CONFIRM = new SystemMessageId(1272);
		SEVENSIGNS_PARTECIPATION_DAWN = new SystemMessageId(1273);
		SEVENSIGNS_PARTECIPATION_DUSK = new SystemMessageId(1274);
		FIGHT_FOR_AVARICE = new SystemMessageId(1275);
		FIGHT_FOR_GNOSIS = new SystemMessageId(1276);
		FIGHT_FOR_STRIFE = new SystemMessageId(1277);
		NPC_SERVER_NOT_OPERATING = new SystemMessageId(1278);
		CONTRIB_SCORE_EXCEEDED = new SystemMessageId(1279);
		CRITICAL_HIT_MAGIC = new SystemMessageId(1280);
		YOUR_EXCELLENT_SHIELD_DEFENSE_WAS_A_SUCCESS = new SystemMessageId(1281);
		YOUR_KARMA_HAS_BEEN_CHANGED_TO_S1 = new SystemMessageId(1282);
		MINIMUM_FRAME_ACTIVATED = new SystemMessageId(1283);
		MINIMUM_FRAME_DEACTIVATED = new SystemMessageId(1284);
		NO_INVENTORY_CANNOT_PURCHASE = new SystemMessageId(1285);
		UNTIL_MONDAY_6PM = new SystemMessageId(1286);
		UNTIL_TODAY_6PM = new SystemMessageId(1287);
		S1_WILL_WIN_COMPETITION = new SystemMessageId(1288);
		SEAL_OWNED_10_MORE_VOTED = new SystemMessageId(1289);
		SEAL_NOT_OWNED_35_MORE_VOTED = new SystemMessageId(1290);
		SEAL_OWNED_10_LESS_VOTED = new SystemMessageId(1291);
		SEAL_NOT_OWNED_35_LESS_VOTED = new SystemMessageId(1292);
		COMPETITION_WILL_TIE = new SystemMessageId(1293);
		COMPETITION_TIE_SEAL_NOT_AWARDED = new SystemMessageId(1294);
		SUBCLASS_NO_CHANGE_OR_CREATE_WHILE_SKILL_IN_USE = new SystemMessageId(1295);
		NO_PRIVATE_STORE_HERE = new SystemMessageId(1296);
		NO_PRIVATE_WORKSHOP_HERE = new SystemMessageId(1297);
		MONS_EXIT_CONFIRM = new SystemMessageId(1298);
		C1_CASTING_INTERRUPTED = new SystemMessageId(1299);
		WEAR_ITEMS_STOPPED = new SystemMessageId(1300);
		CAN_BE_USED_BY_DAWN = new SystemMessageId(1301);
		CAN_BE_USED_BY_DUSK = new SystemMessageId(1302);
		CAN_BE_USED_DURING_QUEST_EVENT_PERIOD = new SystemMessageId(1303);
		STRIFE_CANCELED_DEFENSIVE_REGISTRATION = new SystemMessageId(1304);
		SEAL_STONES_ONLY_WHILE_QUEST = new SystemMessageId(1305);
		NO_LONGER_TRYING_ON = new SystemMessageId(1306);
		SETTLE_ACCOUNT_ONLY_IN_SEAL_VALIDATION = new SystemMessageId(1307);
		CLASS_TRANSFER = new SystemMessageId(1308);
		LATEST_MSN_REQUIRED = new SystemMessageId(1309);
		LATEST_MSN_RECOMMENDED = new SystemMessageId(1310);
		MSN_ONLY_BASIC = new SystemMessageId(1311);
		MSN_OBTAINED_FROM = new SystemMessageId(1312);
		S1_CHAT_HISTORIES_STORED = new SystemMessageId(1313);
		ENTER_PASSPORT_FOR_ADDING = new SystemMessageId(1314);
		DELETING_A_CONTACT = new SystemMessageId(1315);
		CONTACT_WILL_DELETED = new SystemMessageId(1316);
		CONTACT_DELETE_CONFIRM = new SystemMessageId(1317);
		SELECT_CONTACT_FOR_BLOCK_UNBLOCK = new SystemMessageId(1318);
		SELECT_CONTACT_FOR_CHANGE_GROUP = new SystemMessageId(1319);
		SELECT_GROUP_PRESS_OK = new SystemMessageId(1320);
		ENTER_GROUP_NAME = new SystemMessageId(1321);
		SELECT_GROUP_ENTER_NAME = new SystemMessageId(1322);
		SELECT_GROUP_TO_DELETE = new SystemMessageId(1323);
		SIGNING_IN = new SystemMessageId(1324);
		ANOTHER_COMPUTER_LOGOUT = new SystemMessageId(1325);
		S1_D = new SystemMessageId(1326);
		MESSAGE_NOT_DELIVERED = new SystemMessageId(1327);
		DUSK_NOT_RESURRECTED = new SystemMessageId(1328);
		BLOCKED_FROM_USING_STORE = new SystemMessageId(1329);
		NO_STORE_FOR_S1_MINUTES = new SystemMessageId(1330);
		NO_LONGER_BLOCKED_USING_STORE = new SystemMessageId(1331);
		NO_ITEMS_AFTER_DEATH = new SystemMessageId(1332);
		REPLAY_INACCESSIBLE = new SystemMessageId(1333);
		NEW_CAMERA_STORED = new SystemMessageId(1334);
		CAMERA_STORING_FAILED = new SystemMessageId(1335);
		REPLAY_S1_S2_CORRUPTED = new SystemMessageId(1336);
		REPLAY_TERMINATE_CONFIRM = new SystemMessageId(1337);
		EXCEEDED_MAXIMUM_AMOUNT = new SystemMessageId(1338);
		MACRO_SHORTCUT_NOT_RUN = new SystemMessageId(1339);
		SERVER_NOT_ACCESSED_BY_COUPON = new SystemMessageId(1340);
		INCORRECT_NAME_OR_ADDRESS = new SystemMessageId(1341);
		ALREADY_LOGGED_IN = new SystemMessageId(1342);
		INCORRECT_ADDRESS_OR_PASSWORD = new SystemMessageId(1343);
		NET_LOGIN_FAILED = new SystemMessageId(1344);
		SELECT_CONTACT_CLICK_OK = new SystemMessageId(1345);
		CURRENTLY_ENTERING_CHAT = new SystemMessageId(1346);
		MESSENGER_FAILED_CARRYING_OUT_TASK = new SystemMessageId(1347);
		S1_ENTERED_CHAT_ROOM = new SystemMessageId(1348);
		S1_LEFT_CHAT_ROOM = new SystemMessageId(1349);
		GOING_OFFLINE = new SystemMessageId(1350);
		SELECT_CONTACT_CLICK_REMOVE = new SystemMessageId(1351);
		ADDED_TO_S1_S2_CONTACT_LIST = new SystemMessageId(1352);
		CAN_SET_OPTION_TO_ALWAYS_SHOW_OFFLINE = new SystemMessageId(1353);
		NO_CHAT_WHILE_BLOCKED = new SystemMessageId(1354);
		CONTACT_CURRENTLY_BLOCKED = new SystemMessageId(1355);
		CONTACT_CURRENTLY_OFFLINE = new SystemMessageId(1356);
		YOU_ARE_BLOCKED = new SystemMessageId(1357);
		YOU_ARE_LOGGING_OUT = new SystemMessageId(1358);
		S1_LOGGED_IN2 = new SystemMessageId(1359);
		GOT_MESSAGE_FROM_S1 = new SystemMessageId(1360);
		LOGGED_OUT_DUE_TO_ERROR = new SystemMessageId(1361);
		SELECT_CONTACT_TO_DELETE = new SystemMessageId(1362);
		YOUR_REQUEST_ALLIANCE_WAR_DENIED = new SystemMessageId(1363);
		REQUEST_ALLIANCE_WAR_REJECTED = new SystemMessageId(1364);
		S2_OF_S1_SURRENDERED_AS_INDIVIDUAL = new SystemMessageId(1365);
		DELTE_GROUP_INSTRUCTION = new SystemMessageId(1366);
		ONLY_GROUP_CAN_ADD_RECORDS = new SystemMessageId(1367);
		YOU_CAN_NOT_TRY_THOSE_ITEMS_ON_AT_THE_SAME_TIME = new SystemMessageId(1368);
		EXCEEDED_THE_MAXIMUM = new SystemMessageId(1369);
		CANNOT_MAIL_GM_C1 = new SystemMessageId(1370);
		GAMEPLAY_RESTRICTION_PENALTY_S1 = new SystemMessageId(1371);
		PUNISHMENT_CONTINUE_S1_MINUTES = new SystemMessageId(1372);
		C1_PICKED_UP_S2_FROM_RAIDBOSS = new SystemMessageId(1373);
		C1_PICKED_UP_S3_S2_S_FROM_RAIDBOSS = new SystemMessageId(1374);
		C1_PICKED_UP_S2_ADENA_FROM_RAIDBOSS = new SystemMessageId(1375);
		C1_PICKED_UP_S2_FROM_ANOTHER_CHARACTER = new SystemMessageId(1376);
		C1_PICKED_UP_S3_S2_S_FROM_ANOTHER_CHARACTER = new SystemMessageId(1377);
		C1_PICKED_UP_S3_S2_FROM_ANOTHER_CHARACTER = new SystemMessageId(1378);
		C1_OBTAINED_S2_ADENA = new SystemMessageId(1379);
		CANT_SUMMON_S1_ON_BATTLEGROUND = new SystemMessageId(1380);
		LEADER_OBTAINED_S2_OF_S1 = new SystemMessageId(1381);
		CHOOSE_WEAPON_CONFIRM = new SystemMessageId(1382);
		EXCHANGE_CONFIRM = new SystemMessageId(1383);
		C1_HAS_BECOME_A_PARTY_LEADER = new SystemMessageId(1384);
		NO_DISMOUNT_HERE = new SystemMessageId(1385);
		NO_LONGER_HELD_IN_PLACE = new SystemMessageId(1386);
		SELECT_ITEM_TO_TRY_ON = new SystemMessageId(1387);
		PARTY_ROOM_CREATED = new SystemMessageId(1388);
		PARTY_ROOM_REVISED = new SystemMessageId(1389);
		PARTY_ROOM_FORBIDDEN = new SystemMessageId(1390);
		PARTY_ROOM_EXITED = new SystemMessageId(1391);
		C1_LEFT_PARTY_ROOM = new SystemMessageId(1392);
		OUSTED_FROM_PARTY_ROOM = new SystemMessageId(1393);
		C1_KICKED_FROM_PARTY_ROOM = new SystemMessageId(1394);
		PARTY_ROOM_DISBANDED = new SystemMessageId(1395);
		CANT_VIEW_PARTY_ROOMS = new SystemMessageId(1396);
		PARTY_ROOM_LEADER_CHANGED = new SystemMessageId(1397);
		RECRUITING_PARTY_MEMBERS = new SystemMessageId(1398);
		ONLY_A_PARTY_LEADER_CAN_TRANSFER_ONES_RIGHTS_TO_ANOTHER_PLAYER = new SystemMessageId(1399);
		PLEASE_SELECT_THE_PERSON_TO_WHOM_YOU_WOULD_LIKE_TO_TRANSFER_THE_RIGHTS_OF_A_PARTY_LEADER = new SystemMessageId(1400);
		YOU_CANNOT_TRANSFER_RIGHTS_TO_YOURSELF = new SystemMessageId(1401);
		YOU_CAN_TRANSFER_RIGHTS_ONLY_TO_ANOTHER_PARTY_MEMBER = new SystemMessageId(1402);
		YOU_HAVE_FAILED_TO_TRANSFER_THE_PARTY_LEADER_RIGHTS = new SystemMessageId(1403);
		MANUFACTURE_PRICE_HAS_CHANGED = new SystemMessageId(1404);
		S1_CP_WILL_BE_RESTORED = new SystemMessageId(1405);
		S2_CP_WILL_BE_RESTORED_BY_C1 = new SystemMessageId(1406);
		NO_LOGIN_WITH_TWO_ACCOUNTS = new SystemMessageId(1407);
		PREPAID_LEFT_S1_S2_S3 = new SystemMessageId(1408);
		PREPAID_EXPIRED_S1_S2 = new SystemMessageId(1409);
		PREPAID_EXPIRED = new SystemMessageId(1410);
		PREPAID_CHANGED = new SystemMessageId(1411);
		PREPAID_LEFT_S1 = new SystemMessageId(1412);
		CANT_ENTER_PARTY_ROOM = new SystemMessageId(1413);
		WRONG_GRID_COUNT = new SystemMessageId(1414);
		COMMAND_FILE_NOT_SENT = new SystemMessageId(1415);
		TEAM_1_NO_REPRESENTATIVE = new SystemMessageId(1416);
		TEAM_2_NO_REPRESENTATIVE = new SystemMessageId(1417);
		TEAM_1_NO_NAME = new SystemMessageId(1418);
		TEAM_2_NO_NAME = new SystemMessageId(1419);
		TEAM_NAME_IDENTICAL = new SystemMessageId(1420);
		RACE_SETUP_FILE1 = new SystemMessageId(1421);
		RACE_SETUP_FILE2 = new SystemMessageId(1422);
		RACE_SETUP_FILE3 = new SystemMessageId(1423);
		RACE_SETUP_FILE4 = new SystemMessageId(1424);
		RACE_SETUP_FILE5 = new SystemMessageId(1425);
		RACE_SETUP_FILE6 = new SystemMessageId(1426);
		RACE_SETUP_FILE7 = new SystemMessageId(1427);
		RACE_SETUP_FILE8 = new SystemMessageId(1428);
		RACE_SETUP_FILE9 = new SystemMessageId(1429);
		RACE_SETUP_FILE10 = new SystemMessageId(1430);
		RACE_STOPPED_TEMPORARILY = new SystemMessageId(1431);
		OPPONENT_PETRIFIED = new SystemMessageId(1432);
		USE_OF_S1_WILL_BE_AUTO = new SystemMessageId(1433);
		AUTO_USE_OF_S1_CANCELLED = new SystemMessageId(1434);
		AUTO_USE_CANCELLED_LACK_OF_S1 = new SystemMessageId(1435);
		CANNOT_AUTO_USE_LACK_OF_S1 = new SystemMessageId(1436);
		DICE_NO_LONGER_ALLOWED = new SystemMessageId(1437);
		THERE_IS_NO_SKILL_THAT_ENABLES_ENCHANT = new SystemMessageId(1438);
		YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL = new SystemMessageId(1439);
		YOU_HAVE_SUCCEEDED_IN_ENCHANTING_THE_SKILL_S1 = new SystemMessageId(1440);
		YOU_HAVE_FAILED_TO_ENCHANT_THE_SKILL_S1 = new SystemMessageId(1441);
		YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL = new SystemMessageId(1443);
		YOU_DONT_HAVE_ENOUGH_EXP_TO_ENCHANT_THAT_SKILL = new SystemMessageId(1444);
		REPLACE_SUBCLASS_CONFIRM = new SystemMessageId(1445);
		FERRY_FROM_S1_TO_S2_DELAYED = new SystemMessageId(1446);
		CANNOT_DO_WHILE_FISHING_1 = new SystemMessageId(1447);
		ONLY_FISHING_SKILLS_NOW = new SystemMessageId(1448);
		GOT_A_BITE = new SystemMessageId(1449);
		FISH_SPIT_THE_HOOK = new SystemMessageId(1450);
		BAIT_STOLEN_BY_FISH = new SystemMessageId(1451);
		BAIT_LOST_FISH_GOT_AWAY = new SystemMessageId(1452);
		FISHING_POLE_NOT_EQUIPPED = new SystemMessageId(1453);
		BAIT_ON_HOOK_BEFORE_FISHING = new SystemMessageId(1454);
		CANNOT_FISH_UNDER_WATER = new SystemMessageId(1455);
		CANNOT_FISH_ON_BOAT = new SystemMessageId(1456);
		CANNOT_FISH_HERE = new SystemMessageId(1457);
		FISHING_ATTEMPT_CANCELLED = new SystemMessageId(1458);
		NOT_ENOUGH_BAIT = new SystemMessageId(1459);
		REEL_LINE_AND_STOP_FISHING = new SystemMessageId(1460);
		CAST_LINE_AND_START_FISHING = new SystemMessageId(1461);
		CAN_USE_PUMPING_ONLY_WHILE_FISHING = new SystemMessageId(1462);
		CAN_USE_REELING_ONLY_WHILE_FISHING = new SystemMessageId(1463);
		FISH_RESISTED_ATTEMPT_TO_BRING_IT_IN = new SystemMessageId(1464);
		PUMPING_SUCCESFUL_S1_DAMAGE = new SystemMessageId(1465);
		FISH_RESISTED_PUMPING_S1_HP_REGAINED = new SystemMessageId(1466);
		REELING_SUCCESFUL_S1_DAMAGE = new SystemMessageId(1467);
		FISH_RESISTED_REELING_S1_HP_REGAINED = new SystemMessageId(1468);
		YOU_CAUGHT_SOMETHING = new SystemMessageId(1469);
		CANNOT_DO_WHILE_FISHING_2 = new SystemMessageId(1470);
		CANNOT_DO_WHILE_FISHING_3 = new SystemMessageId(1471);
		CANNOT_ATTACK_WITH_FISHING_POLE = new SystemMessageId(1472);
		S1_NOT_SUFFICIENT = new SystemMessageId(1473);
		S1_NOT_AVAILABLE = new SystemMessageId(1474);
		PET_DROPPED_S1 = new SystemMessageId(1475);
		PET_DROPPED_S1_S2 = new SystemMessageId(1476);
		PET_DROPPED_S2_S1_S = new SystemMessageId(1477);
		ONLY_64_PIXEL_256_COLOR_BMP = new SystemMessageId(1478);
		WRONG_FISHINGSHOT_GRADE = new SystemMessageId(1479);
		OLYMPIAD_REMOVE_CONFIRM = new SystemMessageId(1480);
		OLYMPIAD_NON_CLASS_CONFIRM = new SystemMessageId(1481);
		OLYMPIAD_CLASS_CONFIRM = new SystemMessageId(1482);
		HERO_CONFIRM = new SystemMessageId(1483);
		HERO_WEAPON_CONFIRM = new SystemMessageId(1484);
		FERRY_TALKING_GLUDIN_DELAYED = new SystemMessageId(1485);
		FERRY_GLUDIN_TALKING_DELAYED = new SystemMessageId(1486);
		FERRY_GIRAN_TALKING_DELAYED = new SystemMessageId(1487);
		FERRY_TALKING_GIRAN_DELAYED = new SystemMessageId(1488);
		INNADRIL_BOAT_DELAYED = new SystemMessageId(1489);
		TRADED_S2_OF_CROP_S1 = new SystemMessageId(1490);
		FAILED_IN_TRADING_S2_OF_CROP_S1 = new SystemMessageId(1491);
		YOU_WILL_ENTER_THE_OLYMPIAD_STADIUM_IN_S1_SECOND_S = new SystemMessageId(1492);
		THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_ENDS_THE_GAME = new SystemMessageId(1493);
		THE_GAME_HAS_BEEN_CANCELLED_BECAUSE_THE_OTHER_PARTY_DOES_NOT_MEET_THE_REQUIREMENTS_FOR_JOINING_THE_GAME = new SystemMessageId(1494);
		THE_GAME_WILL_START_IN_S1_SECOND_S = new SystemMessageId(1495);
		STARTS_THE_GAME = new SystemMessageId(1496);
		C1_HAS_WON_THE_GAME = new SystemMessageId(1497);
		THE_GAME_ENDED_IN_A_TIE = new SystemMessageId(1498);
		YOU_WILL_BE_MOVED_TO_TOWN_IN_S1_SECONDS = new SystemMessageId(1499);
		C1_CANT_JOIN_THE_OLYMPIAD_WITH_A_SUB_CLASS_CHARACTER = new SystemMessageId(1500);
		C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD = new SystemMessageId(1501);
		C1_IS_ALREADY_REGISTERED_ON_THE_MATCH_WAITING_LIST = new SystemMessageId(1502);
		YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_CLASSIFIED_GAMES = new SystemMessageId(1503);
		YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_NO_CLASS_GAMES = new SystemMessageId(1504);
		YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME = new SystemMessageId(1505);
		YOU_HAVE_NOT_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_A_GAME = new SystemMessageId(1506);
		THIS_ITEM_CANT_BE_EQUIPPED_FOR_THE_OLYMPIAD_EVENT = new SystemMessageId(1507);
		THIS_ITEM_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT = new SystemMessageId(1508);
		THIS_SKILL_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT = new SystemMessageId(1509);
		RESSURECTION_REQUEST_BY_C1_FOR_S2_XP = new SystemMessageId(1510);
		MASTER_CANNOT_RES = new SystemMessageId(1511);
		CANNOT_RES_PET = new SystemMessageId(1512);
		RES_HAS_ALREADY_BEEN_PROPOSED = new SystemMessageId(1513);
		CANNOT_RES_MASTER = new SystemMessageId(1514);
		CANNOT_RES_PET2 = new SystemMessageId(1515);
		THE_TARGET_IS_UNAVAILABLE_FOR_SEEDING = new SystemMessageId(1516);
		BLESSED_ENCHANT_FAILED = new SystemMessageId(1517);
		CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION = new SystemMessageId(1518);
		MAKE_SURE_YOU_RESSURECT_YOUR_PET_WITHIN_24_HOURS = new SystemMessageId(1519);
		SERVITOR_PASSED_AWAY = new SystemMessageId(1520);
		YOUR_SERVITOR_HAS_VANISHED = new SystemMessageId(1521);
		YOUR_PETS_CORPSE_HAS_DECAYED = new SystemMessageId(1522);
		RELEASE_PET_ON_BOAT = new SystemMessageId(1523);
		C1_PET_GAINED_S2 = new SystemMessageId(1524);
		C1_PET_GAINED_S3_S2_S = new SystemMessageId(1525);
		C1_PET_GAINED_S2_S3 = new SystemMessageId(1526);
		PET_TOOK_S1_BECAUSE_HE_WAS_HUNGRY = new SystemMessageId(1527);
		SENT_PETITION_TO_GM = new SystemMessageId(1528);
		COMMAND_CHANNEL_CONFIRM_FROM_C1 = new SystemMessageId(1529);
		SELECT_TARGET_OR_ENTER_NAME = new SystemMessageId(1530);
		ENTER_CLAN_NAME_TO_DECLARE_WAR2 = new SystemMessageId(1531);
		ENTER_CLAN_NAME_TO_CEASE_FIRE = new SystemMessageId(1532);
		ANNOUNCEMENT_C1_PICKED_UP_S2 = new SystemMessageId(1533);
		ANNOUNCEMENT_C1_PICKED_UP_S2_S3 = new SystemMessageId(1534);
		ANNOUNCEMENT_C1_PET_PICKED_UP_S2 = new SystemMessageId(1535);
		ANNOUNCEMENT_C1_PET_PICKED_UP_S2_S3 = new SystemMessageId(1536);
		LOC_RUNE_S1_S2_S3 = new SystemMessageId(1537);
		LOC_GODDARD_S1_S2_S3 = new SystemMessageId(1538);
		CARGO_AT_TALKING_VILLAGE = new SystemMessageId(1539);
		CARGO_AT_DARKELF_VILLAGE = new SystemMessageId(1540);
		CARGO_AT_ELVEN_VILLAGE = new SystemMessageId(1541);
		CARGO_AT_ORC_VILLAGE = new SystemMessageId(1542);
		CARGO_AT_DWARVEN_VILLAGE = new SystemMessageId(1543);
		CARGO_AT_ADEN = new SystemMessageId(1544);
		CARGO_AT_OREN = new SystemMessageId(1545);
		CARGO_AT_HUNTERS = new SystemMessageId(1546);
		CARGO_AT_DION = new SystemMessageId(1547);
		CARGO_AT_FLORAN = new SystemMessageId(1548);
		CARGO_AT_GLUDIN = new SystemMessageId(1549);
		CARGO_AT_GLUDIO = new SystemMessageId(1550);
		CARGO_AT_GIRAN = new SystemMessageId(1551);
		CARGO_AT_HEINE = new SystemMessageId(1552);
		CARGO_AT_RUNE = new SystemMessageId(1553);
		CARGO_AT_GODDARD = new SystemMessageId(1554);
		CANCEL_CHARACTER_DELETION_CONFIRM = new SystemMessageId(1555);
		CLAN_NOTICE_SAVED = new SystemMessageId(1556);
		SEED_PRICE_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2 = new SystemMessageId(1557);
		THE_QUANTITY_OF_SEED_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2 = new SystemMessageId(1558);
		CROP_PRICE_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2 = new SystemMessageId(1559);
		THE_QUANTITY_OF_CROP_SHOULD_BE_MORE_THAN_S1_AND_LESS_THAN_S2 = new SystemMessageId(1560);
		CLAN_S1_DECLARED_WAR = new SystemMessageId(1561);
		CLAN_WAR_DECLARED_AGAINST_S1_IF_KILLED_LOSE_LOW_EXP = new SystemMessageId(1562);
		CANNOT_DECLARE_WAR_TOO_LOW_LEVEL_OR_NOT_ENOUGH_MEMBERS = new SystemMessageId(1563);
		CLAN_WAR_DECLARED_IF_CLAN_LVL3_OR_15_MEMBER = new SystemMessageId(1564);
		CLAN_WAR_CANNOT_DECLARED_CLAN_NOT_EXIST = new SystemMessageId(1565);
		CLAN_S1_HAS_DECIDED_TO_STOP = new SystemMessageId(1566);
		WAR_AGAINST_S1_HAS_STOPPED = new SystemMessageId(1567);
		WRONG_DECLARATION_TARGET = new SystemMessageId(1568);
		CLAN_WAR_AGAINST_A_ALLIED_CLAN_NOT_WORK = new SystemMessageId(1569);
		TOO_MANY_CLAN_WARS = new SystemMessageId(1570);
		CLANS_YOU_DECLARED_WAR_ON = new SystemMessageId(1571);
		CLANS_THAT_HAVE_DECLARED_WAR_ON_YOU = new SystemMessageId(1572);
		NO_WARS_AGAINST_YOU = new SystemMessageId(1573);
		COMMAND_CHANNEL_ONLY_BY_LEVEL_5_CLAN_LEADER_PARTY_LEADER = new SystemMessageId(1574);
		PET_USE_SPIRITSHOT = new SystemMessageId(1575);
		SERVITOR_USE_SPIRITSHOT = new SystemMessageId(1576);
		SERVITOR_USE_THE_POWER_OF_SPIRIT = new SystemMessageId(1577);
		ITEMS_UNAVAILABLE_FOR_STORE_MANUFACTURE = new SystemMessageId(1578);
		C1_PET_GAINED_S2_ADENA = new SystemMessageId(1579);
		COMMAND_CHANNEL_FORMED = new SystemMessageId(1580);
		COMMAND_CHANNEL_DISBANDED = new SystemMessageId(1581);
		JOINED_COMMAND_CHANNEL = new SystemMessageId(1582);
		DISMISSED_FROM_COMMAND_CHANNEL = new SystemMessageId(1583);
		C1_PARTY_DISMISSED_FROM_COMMAND_CHANNEL = new SystemMessageId(1584);
		COMMAND_CHANNEL_DISBANDED2 = new SystemMessageId(1585);
		LEFT_COMMAND_CHANNEL = new SystemMessageId(1586);
		C1_PARTY_LEFT_COMMAND_CHANNEL = new SystemMessageId(1587);
		COMMAND_CHANNEL_ONLY_AT_LEAST_5_PARTIES = new SystemMessageId(1588);
		COMMAND_CHANNEL_LEADER_NOW_C1 = new SystemMessageId(1589);
		GUILD_INFO_HEADER = new SystemMessageId(1590);
		NO_USER_INVITED_TO_COMMAND_CHANNEL = new SystemMessageId(1591);
		CANNOT_LONGER_SETUP_COMMAND_CHANNEL = new SystemMessageId(1592);
		CANNOT_INVITE_TO_COMMAND_CHANNEL = new SystemMessageId(1593);
		C1_ALREADY_MEMBER_OF_COMMAND_CHANNEL = new SystemMessageId(1594);
		S1_SUCCEEDED = new SystemMessageId(1595);
		HIT_BY_S1 = new SystemMessageId(1596);
		S1_FAILED = new SystemMessageId(1597);
		SOULSHOTS_AND_SPIRITSHOTS_ARE_NOT_AVAILABLE_FOR_A_DEAD_PET = new SystemMessageId(1598);
		CANNOT_OBSERVE_IN_COMBAT = new SystemMessageId(1599);
		TOMORROW_ITEM_ZERO_CONFIRM = new SystemMessageId(1600);
		TOMORROW_ITEM_SAME_CONFIRM = new SystemMessageId(1601);
		COMMAND_CHANNEL_ONLY_FOR_PARTY_LEADER = new SystemMessageId(1602);
		ONLY_COMMANDER_GIVE_COMMAND = new SystemMessageId(1603);
		CANNOT_USE_ITEMS_SKILLS_WITH_FORMALWEAR = new SystemMessageId(1604);
		HERE_YOU_CAN_BUY_ONLY_SEEDS_OF_S1_MANOR = new SystemMessageId(1605);
		THIRD_CLASS_TRANSFER = new SystemMessageId(1606);
		S1_ADENA_HAS_BEEN_WITHDRAWN_TO_PAY_FOR_PURCHASING_FEES = new SystemMessageId(1607);
		INSUFFICIENT_ADENA_TO_BUY_CASTLE = new SystemMessageId(1608);
		WAR_ALREADY_DECLARED = new SystemMessageId(1609);
		CANNOT_DECLARE_AGAINST_OWN_CLAN = new SystemMessageId(1610);
		PARTY_LEADER_C1 = new SystemMessageId(1611);
		WAR_LIST = new SystemMessageId(1612);
		NO_CLAN_ON_WAR_LIST = new SystemMessageId(1613);
		JOINED_CHANNEL_ALREADY_OPEN = new SystemMessageId(1614);
		S1_PARTIES_REMAINING_UNTIL_CHANNEL = new SystemMessageId(1615);
		COMMAND_CHANNEL_ACTIVATED = new SystemMessageId(1616);
		CANT_USE_COMMAND_CHANNEL = new SystemMessageId(1617);
		FERRY_RUNE_GLUDIN_DELAYED = new SystemMessageId(1618);
		FERRY_GLUDIN_RUNE_DELAYED = new SystemMessageId(1619);
		ARRIVED_AT_RUNE = new SystemMessageId(1620);
		DEPARTURE_FOR_GLUDIN_5_MINUTES = new SystemMessageId(1621);
		DEPARTURE_FOR_GLUDIN_1_MINUTE = new SystemMessageId(1622);
		DEPARTURE_FOR_GLUDIN_SHORTLY = new SystemMessageId(1623);
		DEPARTURE_FOR_GLUDIN_NOW = new SystemMessageId(1624);
		DEPARTURE_FOR_RUNE_10_MINUTES = new SystemMessageId(1625);
		DEPARTURE_FOR_RUNE_5_MINUTES = new SystemMessageId(1626);
		DEPARTURE_FOR_RUNE_1_MINUTE = new SystemMessageId(1627);
		DEPARTURE_FOR_GLUDIN_SHORTLY2 = new SystemMessageId(1628);
		DEPARTURE_FOR_RUNE_NOW = new SystemMessageId(1629);
		FERRY_FROM_RUNE_AT_GLUDIN_15_MINUTES = new SystemMessageId(1630);
		FERRY_FROM_RUNE_AT_GLUDIN_10_MINUTES = new SystemMessageId(1631);
		FERRY_FROM_RUNE_AT_GLUDIN_5_MINUTES = new SystemMessageId(1632);
		FERRY_FROM_RUNE_AT_GLUDIN_1_MINUTE = new SystemMessageId(1633);
		FERRY_FROM_GLUDIN_AT_RUNE_15_MINUTES = new SystemMessageId(1634);
		FERRY_FROM_GLUDIN_AT_RUNE_10_MINUTES = new SystemMessageId(1635);
		FERRY_FROM_GLUDIN_AT_RUNE_5_MINUTES = new SystemMessageId(1636);
		FERRY_FROM_GLUDIN_AT_RUNE_1_MINUTE = new SystemMessageId(1637);
		CANNOT_FISH_WHILE_USING_RECIPE_BOOK = new SystemMessageId(1638);
		OLYMPIAD_PERIOD_S1_HAS_STARTED = new SystemMessageId(1639);
		OLYMPIAD_PERIOD_S1_HAS_ENDED = new SystemMessageId(1640);
		THE_OLYMPIAD_GAME_HAS_STARTED = new SystemMessageId(1641);
		THE_OLYMPIAD_GAME_HAS_ENDED = new SystemMessageId(1642);
		LOC_DIMENSIONAL_GAP_S1_S2_S3 = new SystemMessageId(1643);
		PLAY_TIME_NOW_ACCUMULATING = new SystemMessageId(1649);
		TRY_LOGIN_LATER = new SystemMessageId(1650);
		THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS = new SystemMessageId(1651);
		RECORDING_GAMEPLAY_START = new SystemMessageId(1652);
		RECORDING_GAMEPLAY_STOP_S1 = new SystemMessageId(1653);
		RECORDING_GAMEPLAY_FAILED = new SystemMessageId(1654);
		YOU_CAUGHT_SOMETHING_SMELLY_THROW_IT_BACK = new SystemMessageId(1655);
		SUCCESSFULLY_TRADED_WITH_NPC = new SystemMessageId(1656);
		C1_HAS_GAINED_S2_OLYMPIAD_POINTS = new SystemMessageId(1657);
		C1_HAS_LOST_S2_OLYMPIAD_POINTS = new SystemMessageId(1658);
		LOC_CEMETARY_OF_THE_EMPIRE_S1_S2_S3 = new SystemMessageId(1659);
		CHANNEL_CREATOR_C1 = new SystemMessageId(1660);
		C1_OBTAINED_S3_S2_S = new SystemMessageId(1661);
		FISH_NO_MORE_BITING_TRY_OTHER_LOCATION = new SystemMessageId(1662);
		CLAN_EMBLEM_WAS_SUCCESSFULLY_REGISTERED = new SystemMessageId(1663);
		FISH_RESISTING_LOOK_BOBBLER = new SystemMessageId(1664);
		YOU_WORN_FISH_OUT = new SystemMessageId(1665);
		OBTAINED_S1_S2 = new SystemMessageId(1666);
		LETHAL_STRIKE = new SystemMessageId(1667);
		LETHAL_STRIKE_SUCCESSFUL = new SystemMessageId(1668);
		NOTHING_INSIDE_THAT = new SystemMessageId(1669);
		REELING_PUMPING_3_LEVELS_HIGHER_THAN_FISHING_PENALTY = new SystemMessageId(1670);
		REELING_SUCCESSFUL_PENALTY_S1 = new SystemMessageId(1671);
		PUMPING_SUCCESSFUL_PENALTY_S1 = new SystemMessageId(1672);
		THE_CURRENT_RECORD_FOR_THIS_OLYMPIAD_SESSION_IS_S1_MATCHES_S2_WINS_S3_DEFEATS_YOU_HAVE_EARNED_S4_OLYMPIAD_POINTS = new SystemMessageId(1673);
		NOBLESSE_ONLY = new SystemMessageId(1674);
		A_MANOR_CANNOT_BE_SET_UP_BETWEEN_6_AM_AND_8_PM = new SystemMessageId(1675);
		NO_SERVITOR_CANNOT_AUTOMATE_USE = new SystemMessageId(1676);
		CANT_STOP_CLAN_WAR_WHILE_IN_COMBAT = new SystemMessageId(1677);
		NO_CLAN_WAR_AGAINST_CLAN_S1 = new SystemMessageId(1678);
		ONLY_CHANNEL_CREATOR_CAN_GLOBAL_COMMAND = new SystemMessageId(1679);
		C1_DECLINED_CHANNEL_INVITATION = new SystemMessageId(1680);
		C1_DID_NOT_RESPOND_CHANNEL_INVITATION_FAILED = new SystemMessageId(1681);
		ONLY_CHANNEL_CREATOR_CAN_DISMISS = new SystemMessageId(1682);
		ONLY_PARTY_LEADER_CAN_LEAVE_CHANNEL = new SystemMessageId(1683);
		NO_CLAN_WAR_AGAINST_DISSOLVING_CLAN = new SystemMessageId(1684);
		YOU_ARE_UNABLE_TO_EQUIP_THIS_ITEM_WHEN_YOUR_PK_COUNT_IS_GREATER_THAN_OR_EQUAL_TO_ONE = new SystemMessageId(1685);
		CASTLE_WALL_DAMAGED = new SystemMessageId(1686);
		AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN = new SystemMessageId(1687);
		CANNOT_ENCHANT_WHILE_STORE = new SystemMessageId(1688);
		C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST = new SystemMessageId(1689);
		C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST = new SystemMessageId(1690);
		C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT = new SystemMessageId(1691);
		C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_WHILE_CHANGED_TO_SUB_CLASS = new SystemMessageId(1692);
		WHILE_YOU_ARE_ON_THE_WAITING_LIST_YOU_ARE_NOT_ALLOWED_TO_WATCH_THE_GAME = new SystemMessageId(1693);
		ONLY_NOBLESSE_LEADER_CAN_VIEW_SIEGE_STATUS_WINDOW = new SystemMessageId(1694);
		ONLY_DURING_SIEGE = new SystemMessageId(1695);
		ACCUMULATED_PLAY_TIME_IS_S1 = new SystemMessageId(1696);
		ACCUMULATED_PLAY_TIME_WARNING1 = new SystemMessageId(1697);
		ACCUMULATED_PLAY_TIME_WARNING2 = new SystemMessageId(1698);
		CANNOT_DISMISS_PARTY_MEMBER = new SystemMessageId(1699);
		NOT_ENOUGH_SPIRITHOTS_FOR_PET = new SystemMessageId(1700);
		NOT_ENOUGH_SOULSHOTS_FOR_PET = new SystemMessageId(1701);
		S1_USING_THIRD_PARTY_PROGRAM = new SystemMessageId(1702);
		NOT_USING_THIRD_PARTY_PROGRAM = new SystemMessageId(1703);
		CLOSE_STORE_WINDOW_AND_TRY_AGAIN = new SystemMessageId(1704);
		PCPOINT_ACQUISITION_PERIOD = new SystemMessageId(1705);
		PCPOINT_USE_PERIOD = new SystemMessageId(1706);
		ACQUIRED_S1_PCPOINT = new SystemMessageId(1707);
		ACQUIRED_S1_PCPOINT_DOUBLE = new SystemMessageId(1708);
		USING_S1_PCPOINT = new SystemMessageId(1709);
		SHORT_OF_ACCUMULATED_POINTS = new SystemMessageId(1710);
		PCPOINT_USE_PERIOD_EXPIRED = new SystemMessageId(1711);
		PCPOINT_ACCUMULATION_PERIOD_EXPIRED = new SystemMessageId(1712);
		GAMES_DELAYED = new SystemMessageId(1713);
		LOC_SCHUTTGART_S1_S2_S3 = new SystemMessageId(1714);
		PEACEFUL_ZONE = new SystemMessageId(1715);
		ALTERED_ZONE = new SystemMessageId(1716);
		SIEGE_ZONE = new SystemMessageId(1717);
		GENERAL_ZONE = new SystemMessageId(1718);
		SEVENSIGNS_ZONE = new SystemMessageId(1719);
		UNKNOWN1 = new SystemMessageId(1720);
		COMBAT_ZONE = new SystemMessageId(1721);
		ENTER_ITEM_NAME_SEARCH = new SystemMessageId(1722);
		PLEASE_PROVIDE_PETITION_FEEDBACK = new SystemMessageId(1723);
		SERVITOR_NOT_RETURN_IN_BATTLE = new SystemMessageId(1724);
		EARNED_S1_RAID_POINTS = new SystemMessageId(1725);
		S1_PERIOD_EXPIRED_DISAPPEARED = new SystemMessageId(1726);
		C1_INVITED_YOU_TO_PARTY_ROOM_CONFIRM = new SystemMessageId(1727);
		PARTY_MATCHING_REQUEST_NO_RESPONSE = new SystemMessageId(1728);
		NOT_JOIN_CHANNEL_WHILE_TELEPORTING = new SystemMessageId(1729);
		YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN_ACADEMY = new SystemMessageId(1730);
		ONLY_LEADER_CAN_CREATE_ACADEMY = new SystemMessageId(1731);
		NEED_BLOODMARK_FOR_ACADEMY = new SystemMessageId(1732);
		NEED_ADENA_FOR_ACADEMY = new SystemMessageId(1733);
		ACADEMY_REQUIREMENTS = new SystemMessageId(1734);
		S1_DOESNOT_MEET_REQUIREMENTS_TO_JOIN_ACADEMY = new SystemMessageId(1735);
		ACADEMY_MAXIMUM = new SystemMessageId(1736);
		CLAN_CAN_CREATE_ACADEMY = new SystemMessageId(1737);
		CLAN_HAS_ALREADY_ESTABLISHED_A_CLAN_ACADEMY = new SystemMessageId(1738);
		CLAN_ACADEMY_CREATE_CONFIRM = new SystemMessageId(1739);
		ACADEMY_CREATE_ENTER_NAME = new SystemMessageId(1740);
		THE_S1S_CLAN_ACADEMY_HAS_BEEN_CREATED = new SystemMessageId(1741);
		ACADEMY_INVITATION_SENT_TO_S1 = new SystemMessageId(1742);
		OPEN_ACADEMY_CONDITIONS = new SystemMessageId(1743);
		ACADEMY_JOIN_NO_RESPONSE = new SystemMessageId(1744);
		ACADEMY_JOIN_DECLINE = new SystemMessageId(1745);
		ALREADY_JOINED_ACADEMY = new SystemMessageId(1746);
		JOIN_ACADEMY_REQUEST_BY_S1_FOR_CLAN_S2 = new SystemMessageId(1747);
		CLAN_MEMBER_GRADUATED_FROM_ACADEMY = new SystemMessageId(1748);
		ACADEMY_MEMBERSHIP_TERMINATED = new SystemMessageId(1749);
		C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2 = new SystemMessageId(1750);
		GRAND_MASTER_COMMEMORATIVE_ITEM = new SystemMessageId(1751);
		MEMBER_GRADUATED_EARNED_S1_REPU = new SystemMessageId(1752);
		CANT_TRANSFER_PRIVILEGE_TO_ACADEMY_MEMBER = new SystemMessageId(1753);
		RIGHT_CANT_TRANSFERRED_TO_ACADEMY_MEMBER = new SystemMessageId(1754);
		S2_HAS_BEEN_DESIGNATED_AS_APPRENTICE_OF_CLAN_MEMBER_S1 = new SystemMessageId(1755);
		YOUR_APPRENTICE_S1_HAS_LOGGED_IN = new SystemMessageId(1756);
		YOUR_APPRENTICE_C1_HAS_LOGGED_OUT = new SystemMessageId(1757);
		YOUR_SPONSOR_C1_HAS_LOGGED_IN = new SystemMessageId(1758);
		YOUR_SPONSOR_C1_HAS_LOGGED_OUT = new SystemMessageId(1759);
		CLAN_MEMBER_C1_TITLE_CHANGED_TO_S2 = new SystemMessageId(1760);
		CLAN_MEMBER_C1_PRIVILEGE_CHANGED_TO_S2 = new SystemMessageId(1761);
		YOU_DO_NOT_HAVE_THE_RIGHT_TO_DISMISS_AN_APPRENTICE = new SystemMessageId(1762);
		S2_CLAN_MEMBER_C1_APPRENTICE_HAS_BEEN_REMOVED = new SystemMessageId(1763);
		EQUIP_ONLY_FOR_ACADEMY = new SystemMessageId(1764);
		EQUIP_NOT_FOR_GRADUATES = new SystemMessageId(1765);
		CLAN_JOIN_APPLICATION_SENT_TO_C1_IN_S2 = new SystemMessageId(1766);
		ACADEMY_JOIN_APPLICATION_SENT_TO_C1 = new SystemMessageId(1767);
		JOIN_REQUEST_BY_C1_TO_CLAN_S2_ACADEMY = new SystemMessageId(1768);
		JOIN_REQUEST_BY_C1_TO_ORDER_OF_KNIGHTS_S3_UNDER_CLAN_S2 = new SystemMessageId(1769);
		CLAN_REPU_0_MAY_FACE_PENALTIES = new SystemMessageId(1770);
		CLAN_CAN_ACCUMULATE_CLAN_REPUTATION_POINTS = new SystemMessageId(1771);
		CLAN_WAS_DEFEATED_IN_SIEGE_AND_LOST_S1_REPUTATION_POINTS = new SystemMessageId(1772);
		CLAN_VICTORIOUS_IN_SIEGE_AND_GAINED_S1_REPUTATION_POINTS = new SystemMessageId(1773);
		CLAN_ACQUIRED_CONTESTED_CLAN_HALL_AND_S1_REPUTATION_POINTS = new SystemMessageId(1774);
		CLAN_MEMBER_C1_WAS_IN_HIGHEST_RANKED_PARTY_IN_FESTIVAL_OF_DARKNESS_AND_GAINED_S2_REPUTATION = new SystemMessageId(1775);
		CLAN_MEMBER_C1_BECAME_HERO_AND_GAINED_S2_REPUTATION_POINTS = new SystemMessageId(1776);
		CLAN_QUEST_COMPLETED_AND_S1_POINTS_GAINED = new SystemMessageId(1777);
		OPPOSING_CLAN_CAPTURED_CLAN_HALL_AND_YOUR_CLAN_LOSES_S1_POINTS = new SystemMessageId(1778);
		CLAN_LOST_CONTESTED_CLAN_HALL_AND_300_POINTS = new SystemMessageId(1779);
		CLAN_CAPTURED_CONTESTED_CLAN_HALL_AND_S1_POINTS_DEDUCTED_FROM_OPPONENT = new SystemMessageId(1780);
		CLAN_ADDED_S1S_POINTS_TO_REPUTATION_SCORE = new SystemMessageId(1781);
		CLAN_MEMBER_C1_WAS_KILLED_AND_S2_POINTS_DEDUCTED_FROM_REPUTATION = new SystemMessageId(1782);
		FOR_KILLING_OPPOSING_MEMBER_S1_POINTS_WERE_DEDUCTED_FROM_OPPONENTS = new SystemMessageId(1783);
		YOUR_CLAN_FAILED_TO_DEFEND_CASTLE_AND_S1_POINTS_LOST_AND_ADDED_TO_OPPONENT = new SystemMessageId(1784);
		YOUR_CLAN_HAS_BEEN_INITIALIZED_AND_S1_POINTS_LOST = new SystemMessageId(1785);
		YOUR_CLAN_FAILED_TO_DEFEND_CASTLE_AND_S1_POINTS_LOST = new SystemMessageId(1786);
		S1_DEDUCTED_FROM_CLAN_REP = new SystemMessageId(1787);
		CLAN_SKILL_S1_ADDED = new SystemMessageId(1788);
		REPUTATION_POINTS_0_OR_LOWER_CLAN_SKILLS_DEACTIVATED = new SystemMessageId(1789);
		FAILED_TO_INCREASE_CLAN_LEVEL = new SystemMessageId(1790);
		YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_MILITARY_UNIT = new SystemMessageId(1791);
		ASSIGN_MANAGER_FOR_ORDER_OF_KNIGHTS = new SystemMessageId(1792);
		C1_HAS_BEEN_SELECTED_AS_CAPTAIN_OF_S2 = new SystemMessageId(1793);
		THE_KNIGHTS_OF_S1_HAVE_BEEN_CREATED = new SystemMessageId(1794);
		THE_ROYAL_GUARD_OF_S1_HAVE_BEEN_CREATED = new SystemMessageId(1795);
		ILLEGAL_USE17 = new SystemMessageId(1796);
		C1_PROMOTED_TO_S2 = new SystemMessageId(1797);
		CLAN_LEADER_PRIVILEGES_HAVE_BEEN_TRANSFERRED_TO_C1 = new SystemMessageId(1798);
		SEARCHING_FOR_BOT_USERS_TRY_AGAIN_LATER = new SystemMessageId(1799);
		C1_HISTORY_USING_BOT = new SystemMessageId(1800);
		SELL_ATTEMPT_FAILED = new SystemMessageId(1801);
		TRADE_ATTEMPT_FAILED = new SystemMessageId(1802);
		GAME_REQUEST_CANNOT_BE_MADE = new SystemMessageId(1803);
		ILLEGAL_USE18 = new SystemMessageId(1804);
		ILLEGAL_USE19 = new SystemMessageId(1805);
		ILLEGAL_USE20 = new SystemMessageId(1806);
		ILLEGAL_USE21 = new SystemMessageId(1807);
		ILLEGAL_USE22 = new SystemMessageId(1808);
		ACCOUNT_MUST_VERIFIED = new SystemMessageId(1809);
		REFUSE_INVITATION_ACTIVATED = new SystemMessageId(1810);
		REFUSE_INVITATION_CURRENTLY_ACTIVE = new SystemMessageId(1812);
		THERE_IS_S1_HOUR_AND_S2_MINUTE_LEFT_OF_THE_FIXED_USAGE_TIME = new SystemMessageId(1813);
		S2_MINUTE_OF_USAGE_TIME_ARE_LEFT_FOR_S1 = new SystemMessageId(1814);
		S2_WAS_DROPPED_IN_THE_S1_REGION = new SystemMessageId(1815);
		THE_OWNER_OF_S2_HAS_APPEARED_IN_THE_S1_REGION = new SystemMessageId(1816);
		S2_OWNER_HAS_LOGGED_INTO_THE_S1_REGION = new SystemMessageId(1817);
		S1_HAS_DISAPPEARED = new SystemMessageId(1818);
		EVIL_FROM_S2_IN_S1 = new SystemMessageId(1819);
		S1_CURRENTLY_SLEEP = new SystemMessageId(1820);
		S2_EVIL_PRESENCE_FELT_IN_S1 = new SystemMessageId(1821);
		S1_SEALED = new SystemMessageId(1822);
		CLANHALL_WAR_REGISTRATION_PERIOD_ENDED = new SystemMessageId(1823);
		REGISTERED_FOR_CLANHALL_WAR = new SystemMessageId(1824);
		CLANHALL_WAR_REGISTRATION_FAILED = new SystemMessageId(1825);
		CLANHALL_WAR_BEGINS_IN_S1_MINUTES = new SystemMessageId(1826);
		CLANHALL_WAR_BEGINS_IN_S1_MINUTES_ENTER_NOW = new SystemMessageId(1827);
		CLANHALL_WAR_BEGINS_IN_S1_SECONDS = new SystemMessageId(1828);
		COMMAND_CHANNEL_FULL = new SystemMessageId(1829);
		C1_NOT_ALLOWED_INVITE_TO_PARTY_ROOM = new SystemMessageId(1830);
		C1_NOT_MEET_CONDITIONS_FOR_PARTY_ROOM = new SystemMessageId(1831);
		ONLY_ROOM_LEADER_CAN_INVITE = new SystemMessageId(1832);
		CONFIRM_DROP_ALL_OF_S1 = new SystemMessageId(1833);
		PARTY_ROOM_FULL = new SystemMessageId(1834);
		S1_CLAN_IS_FULL = new SystemMessageId(1835);
		CANNOT_JOIN_ACADEMY_AFTER_2ND_OCCUPATION = new SystemMessageId(1836);
		C1_SENT_INVITATION_TO_ROYAL_GUARD_S3_OF_CLAN_S2 = new SystemMessageId(1837);
		COUPON_ONCE_PER_CHARACTER = new SystemMessageId(1838);
		SERIAL_MAY_USED_ONCE = new SystemMessageId(1839);
		SERIAL_INPUT_INCORRECT = new SystemMessageId(1840);
		CLANHALL_WAR_CANCELLED = new SystemMessageId(1841);
		C1_WISHES_TO_SUMMON_YOU_FROM_S2_DO_YOU_ACCEPT = new SystemMessageId(1842);
		C1_IS_ENGAGED_IN_COMBAT_AND_CANNOT_BE_SUMMONED = new SystemMessageId(1843);
		C1_IS_DEAD_AT_THE_MOMENT_AND_CANNOT_BE_SUMMONED = new SystemMessageId(1844);
		HERO_WEAPONS_CANT_DESTROYED = new SystemMessageId(1845);
		TOO_FAR_AWAY_FROM_FENRIR_TO_MOUNT = new SystemMessageId(1846);
		CAUGHT_FISH_S1_LENGTH = new SystemMessageId(1847);
		REGISTERED_IN_FISH_SIZE_RANKING = new SystemMessageId(1848);
		CONFIRM_DISCARD_ALL_OF_S1 = new SystemMessageId(1849);
		CAPTAIN_OF_ORDER_OF_KNIGHTS_CANNOT_BE_APPOINTED = new SystemMessageId(1850);
		CAPTAIN_OF_ROYAL_GUARD_CANNOT_BE_APPOINTED = new SystemMessageId(1851);
		ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE = new SystemMessageId(1852);
		CANT_EXCHANGE_QUANTITY_ITEMS_OF_SAME_TYPE = new SystemMessageId(1853);
		ITEM_CONVERTED_SUCCESSFULLY = new SystemMessageId(1854);
		ANOTHER_MILITARY_UNIT_IS_ALREADY_USING_THAT_NAME = new SystemMessageId(1855);
		OPPONENT_POSSESSES_S1_OLYMPIAD_CANCELLED = new SystemMessageId(1856);
		C1_OWNS_S2_AND_CANNOT_PARTICIPATE_IN_OLYMPIAD = new SystemMessageId(1857);
		C1_CANNOT_PARTICIPATE_OLYMPIAD_WHILE_DEAD = new SystemMessageId(1858);
		EXCEEDED_QUANTITY_FOR_MOVED = new SystemMessageId(1859);
		THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW = new SystemMessageId(1860);
		CLAN_CREST_HAS_BEEN_DELETED = new SystemMessageId(1861);
		CLAN_SKILLS_WILL_BE_ACTIVATED_SINCE_REPUTATION_IS_0_OR_HIGHER = new SystemMessageId(1862);
		C1_PURCHASED_CLAN_ITEM_REDUCING_S2_REPU_POINTS = new SystemMessageId(1863);
		PET_REFUSING_ORDER = new SystemMessageId(1864);
		PET_IN_STATE_OF_DISTRESS = new SystemMessageId(1865);
		MP_REDUCED_BY_S1 = new SystemMessageId(1866);
		YOUR_OPPONENTS_MP_WAS_REDUCED_BY_S1 = new SystemMessageId(1867);
		CANNOT_EXCHANCE_USED_ITEM = new SystemMessageId(1868);
		C1_GRANTED_MASTER_PARTY_LOOTING_RIGHTS = new SystemMessageId(1869);
		COMMAND_CHANNEL_WITH_LOOTING_RIGHTS_EXISTS = new SystemMessageId(1870);
		CONFIRM_DISMISS_C1_FROM_CLAN = new SystemMessageId(1871);
		S1_HOURS_S2_MINUTES_LEFT = new SystemMessageId(1872);
		S1_HOURS_S2_MINUTES_LEFT_FOR_THIS_PCCAFE = new SystemMessageId(1873);
		S1_MINUTES_LEFT_FOR_THIS_USER = new SystemMessageId(1874);
		S1_MINUTES_LEFT_FOR_THIS_PCCAFE = new SystemMessageId(1875);
		CONFIRM_LEAVE_S1_CLAN = new SystemMessageId(1876);
		GAME_WILL_END_IN_S1_MINUTES = new SystemMessageId(1877);
		GAME_WILL_END_IN_S1_SECONDS = new SystemMessageId(1878);
		IN_S1_MINUTES_TELEPORTED_OUTSIDE_OF_GAME_ARENA = new SystemMessageId(1879);
		IN_S1_SECONDS_TELEPORTED_OUTSIDE_OF_GAME_ARENA = new SystemMessageId(1880);
		PRELIMINARY_MATCH_BEGIN_IN_S1_SECONDS = new SystemMessageId(1881);
		CHARACTERS_NOT_CREATED_FROM_THIS_SERVER = new SystemMessageId(1882);
		NO_OFFERINGS_OWN_OR_MADE_BID_FOR = new SystemMessageId(1883);
		ENTER_PCROOM_SERIAL_NUMBER = new SystemMessageId(1884);
		SERIAL_NUMBER_CANT_ENTERED = new SystemMessageId(1885);
		SERIAL_NUMBER_ALREADY_USED = new SystemMessageId(1886);
		SERIAL_NUMBER_ENTERING_FAILED = new SystemMessageId(1887);
		SERIAL_NUMBER_ENTERING_FAILED_5_TIMES = new SystemMessageId(1888);
		CONGRATULATIONS_RECEIVED_S1 = new SystemMessageId(1889);
		ALREADY_USED_COUPON_NOT_USE_SERIAL_NUMBER = new SystemMessageId(1890);
		NOT_USE_ITEMS_IN_PRIVATE_STORE = new SystemMessageId(1891);
		REPLAY_FILE_PREVIOUS_VERSION_CANT_PLAYED = new SystemMessageId(1892);
		FILE_CANT_REPLAYED = new SystemMessageId(1893);
		NOT_SUBCLASS_WHILE_OVERWEIGHT = new SystemMessageId(1894);
		C1_IN_SUMMON_BLOCKING_AREA = new SystemMessageId(1895);
		C1_ALREADY_SUMMONED = new SystemMessageId(1896);
		S1_REQUIRED_FOR_SUMMONING = new SystemMessageId(1897);
		C1_CURRENTLY_TRADING_OR_OPERATING_PRIVATE_STORE_AND_CANNOT_BE_SUMMONED = new SystemMessageId(1898);
		YOUR_TARGET_IS_IN_AN_AREA_WHICH_BLOCKS_SUMMONING = new SystemMessageId(1899);
		C1_ENTERED_PARTY_ROOM = new SystemMessageId(1900);
		C1_INVITED_YOU_TO_PARTY_ROOM = new SystemMessageId(1901);
		INCOMPATIBLE_ITEM_GRADE = new SystemMessageId(1902);
		NCOTP = new SystemMessageId(1903);
		CANT_SUBCLASS_WITH_SUMMONED_SERVITOR = new SystemMessageId(1904);
		S2_OF_S1_WILL_REPLACED_WITH_S4_OF_S3 = new SystemMessageId(1905);
		SELECT_COMBAT_UNIT = new SystemMessageId(1906);
		SELECT_CHARACTER_WHO_WILL = new SystemMessageId(1907);
		C1_STATE_FORBIDS_SUMMONING = new SystemMessageId(1908);
		ACADEMY_LIST_HEADER = new SystemMessageId(1909);
		GRADUATES_C1 = new SystemMessageId(1910);
		YOU_CANNOT_SUMMON_PLAYERS_WHO_ARE_IN_OLYMPIAD = new SystemMessageId(1911);
		NCOTP2 = new SystemMessageId(1912);
		TIME_FOR_S1_IS_S2_MINUTES_REMAINING = new SystemMessageId(1913);
		TIME_FOR_S1_IS_S2_SECONDS_REMAINING = new SystemMessageId(1914);
		GAME_ENDS_IN_S1_SECONDS = new SystemMessageId(1915);
		DEATH_PENALTY_LEVEL_S1_ADDED = new SystemMessageId(1916);
		DEATH_PENALTY_LIFTED = new SystemMessageId(1917);
		PET_TOO_HIGH_TO_CONTROL = new SystemMessageId(1918);
		OLYMPIAD_REGISTRATION_PERIOD_ENDED = new SystemMessageId(1919);
		ACCOUNT_INACTIVITY = new SystemMessageId(1920);
		S2_HOURS_S3_MINUTES_SINCE_S1_KILLED = new SystemMessageId(1921);
		S1_FAILED_KILLING_EXPIRED = new SystemMessageId(1922);
		COURT_MAGICIAN_CREATED_PORTAL = new SystemMessageId(1923);
		LOC_PRIMEVAL_ISLE_S1_S2_S3 = new SystemMessageId(1924);
		SEAL_OF_STRIFE_FORBIDS_SUMMONING = new SystemMessageId(1925);
		THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL = new SystemMessageId(1926);
		C1_HAS_BEEN_CHALLENGED_TO_A_DUEL = new SystemMessageId(1927);
		C1_PARTY_HAS_BEEN_CHALLENGED_TO_A_DUEL = new SystemMessageId(1928);
		C1_HAS_ACCEPTED_YOUR_CHALLENGE_TO_A_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS = new SystemMessageId(1929);
		YOU_HAVE_ACCEPTED_C1_CHALLENGE_TO_A_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS = new SystemMessageId(1930);
		C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL = new SystemMessageId(1931);
		C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL2 = new SystemMessageId(1932);
		YOU_HAVE_ACCEPTED_C1_CHALLENGE_TO_A_PARTY_DUEL_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS = new SystemMessageId(1933);
		S1_HAS_ACCEPTED_YOUR_CHALLENGE_TO_DUEL_AGAINST_THEIR_PARTY_THE_DUEL_WILL_BEGIN_IN_A_FEW_MOMENTS = new SystemMessageId(1934);
		C1_HAS_DECLINED_YOUR_CHALLENGE_TO_A_PARTY_DUEL = new SystemMessageId(1935);
		THE_OPPOSING_PARTY_HAS_DECLINED_YOUR_CHALLENGE_TO_A_DUEL = new SystemMessageId(1936);
		SINCE_THE_PERSON_YOU_CHALLENGED_IS_NOT_CURRENTLY_IN_A_PARTY_THEY_CANNOT_DUEL_AGAINST_YOUR_PARTY = new SystemMessageId(1937);
		C1_HAS_CHALLENGED_YOU_TO_A_DUEL = new SystemMessageId(1938);
		C1_PARTY_HAS_CHALLENGED_YOUR_PARTY_TO_A_DUEL = new SystemMessageId(1939);
		YOU_ARE_UNABLE_TO_REQUEST_A_DUEL_AT_THIS_TIME = new SystemMessageId(1940);
		NO_PLACE_FOR_DUEL = new SystemMessageId(1941);
		THE_OPPOSING_PARTY_IS_CURRENTLY_UNABLE_TO_ACCEPT_A_CHALLENGE_TO_A_DUEL = new SystemMessageId(1942);
		THE_OPPOSING_PARTY_IS_AT_BAD_LOCATION_FOR_A_DUEL = new SystemMessageId(1943);
		IN_A_MOMENT_YOU_WILL_BE_TRANSPORTED_TO_THE_SITE_WHERE_THE_DUEL_WILL_TAKE_PLACE = new SystemMessageId(1944);
		THE_DUEL_WILL_BEGIN_IN_S1_SECONDS = new SystemMessageId(1945);
		C1_CHALLENGED_YOU_TO_A_DUEL = new SystemMessageId(1946);
		C1_CHALLENGED_YOU_TO_A_PARTY_DUEL = new SystemMessageId(1947);
		THE_DUEL_WILL_BEGIN_IN_S1_SECONDS2 = new SystemMessageId(1948);
		LET_THE_DUEL_BEGIN = new SystemMessageId(1949);
		C1_HAS_WON_THE_DUEL = new SystemMessageId(1950);
		C1_PARTY_HAS_WON_THE_DUEL = new SystemMessageId(1951);
		THE_DUEL_HAS_ENDED_IN_A_TIE = new SystemMessageId(1952);
		SINCE_C1_WAS_DISQUALIFIED_S2_HAS_WON = new SystemMessageId(1953);
		SINCE_C1_PARTY_WAS_DISQUALIFIED_S2_PARTY_HAS_WON = new SystemMessageId(1954);
		SINCE_C1_WITHDREW_FROM_THE_DUEL_S2_HAS_WON = new SystemMessageId(1955);
		SINCE_C1_PARTY_WITHDREW_FROM_THE_DUEL_S2_PARTY_HAS_WON = new SystemMessageId(1956);
		SELECT_THE_ITEM_TO_BE_AUGMENTED = new SystemMessageId(1957);
		SELECT_THE_CATALYST_FOR_AUGMENTATION = new SystemMessageId(1958);
		REQUIRES_S1_S2 = new SystemMessageId(1959);
		THIS_IS_NOT_A_SUITABLE_ITEM = new SystemMessageId(1960);
		GEMSTONE_QUANTITY_IS_INCORRECT = new SystemMessageId(1961);
		THE_ITEM_WAS_SUCCESSFULLY_AUGMENTED = new SystemMessageId(1962);
		SELECT_THE_ITEM_FROM_WHICH_YOU_WISH_TO_REMOVE_AUGMENTATION = new SystemMessageId(1963);
		AUGMENTATION_REMOVAL_CAN_ONLY_BE_DONE_ON_AN_AUGMENTED_ITEM = new SystemMessageId(1964);
		AUGMENTATION_HAS_BEEN_SUCCESSFULLY_REMOVED_FROM_YOUR_S1 = new SystemMessageId(1965);
		ONLY_CLAN_LEADER_CAN_ISSUE_COMMANDS = new SystemMessageId(1966);
		GATE_LOCKED_TRY_AGAIN_LATER = new SystemMessageId(1967);
		S1_OWNER = new SystemMessageId(1968);
		AREA_S1_APPEARS = new SystemMessageId(1969);
		ONCE_AN_ITEM_IS_AUGMENTED_IT_CANNOT_BE_AUGMENTED_AGAIN = new SystemMessageId(1970);
		HARDENER_LEVEL_TOO_HIGH = new SystemMessageId(1971);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_A_PRIVATE_STORE_OR_PRIVATE_WORKSHOP_IS_IN_OPERATION = new SystemMessageId(1972);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_FROZEN = new SystemMessageId(1973);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_DEAD = new SystemMessageId(1974);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_TRADING = new SystemMessageId(1975);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_PARALYZED = new SystemMessageId(1976);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_FISHING = new SystemMessageId(1977);
		YOU_CANNOT_AUGMENT_ITEMS_WHILE_SITTING_DOWN = new SystemMessageId(1978);
		S1S_REMAINING_MANA_IS_NOW_10 = new SystemMessageId(1979);
		S1S_REMAINING_MANA_IS_NOW_5 = new SystemMessageId(1980);
		S1S_REMAINING_MANA_IS_NOW_1 = new SystemMessageId(1981);
		S1S_REMAINING_MANA_IS_NOW_0 = new SystemMessageId(1982);
		PRESS_THE_AUGMENT_BUTTON_TO_BEGIN = new SystemMessageId(1984);
		S1_DROP_AREA_S2 = new SystemMessageId(1985);
		S1_OWNER_S2 = new SystemMessageId(1986);
		S1 = new SystemMessageId(1987);
		FERRY_ARRIVED_AT_PRIMEVAL = new SystemMessageId(1988);
		FERRY_LEAVING_FOR_RUNE_3_MINUTES = new SystemMessageId(1989);
		FERRY_LEAVING_PRIMEVAL_FOR_RUNE_NOW = new SystemMessageId(1990);
		FERRY_LEAVING_FOR_PRIMEVAL_3_MINUTES = new SystemMessageId(1991);
		FERRY_LEAVING_RUNE_FOR_PRIMEVAL_NOW = new SystemMessageId(1992);
		FERRY_FROM_PRIMEVAL_TO_RUNE_DELAYED = new SystemMessageId(1993);
		FERRY_FROM_RUNE_TO_PRIMEVAL_DELAYED = new SystemMessageId(1994);
		S1_CHANNEL_FILTER_OPTION = new SystemMessageId(1995);
		ATTACK_WAS_BLOCKED = new SystemMessageId(1996);
		C1_PERFORMING_COUNTERATTACK = new SystemMessageId(1997);
		COUNTERED_C1_ATTACK = new SystemMessageId(1998);
		C1_DODGES_ATTACK = new SystemMessageId(1999);
		AVOIDED_C1_ATTACK2 = new SystemMessageId(2000);
		AUGMENTATION_FAILED_DUE_TO_INAPPROPRIATE_CONDITIONS = new SystemMessageId(2001);
		TRAP_FAILED = new SystemMessageId(2002);
		OBTAINED_ORDINARY_MATERIAL = new SystemMessageId(2003);
		OBTAINED_RATE_MATERIAL = new SystemMessageId(2004);
		OBTAINED_UNIQUE_MATERIAL = new SystemMessageId(2005);
		OBTAINED_ONLY_MATERIAL = new SystemMessageId(2006);
		ENTER_RECIPIENTS_NAME = new SystemMessageId(2007);
		ENTER_TEXT = new SystemMessageId(2008);
		CANT_EXCEED_1500_CHARACTERS = new SystemMessageId(2009);
		S2_S1 = new SystemMessageId(2010);
		AUGMENTED_ITEM_CANNOT_BE_DISCARDED = new SystemMessageId(2011);
		S1_HAS_BEEN_ACTIVATED = new SystemMessageId(2012);
		YOUR_SEED_OR_REMAINING_PURCHASE_AMOUNT_IS_INADEQUATE = new SystemMessageId(2013);
		MANOR_CANT_ACCEPT_MORE_CROPS = new SystemMessageId(2014);
		SKILL_READY_TO_USE_AGAIN = new SystemMessageId(2015);
		SKILL_READY_TO_USE_AGAIN_BUT_TIME_INCREASED = new SystemMessageId(2016);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_A_PRIVATE_STORE_OR_MANUFACTURE = new SystemMessageId(2017);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_FISHING = new SystemMessageId(2018);
		C1_CANNOT_DUEL_BECAUSE_C1_HP_OR_MP_IS_BELOW_50_PERCENT = new SystemMessageId(2019);
		C1_CANNOT_MAKE_A_CHALLANGE_TO_A_DUEL_BECAUSE_C1_IS_CURRENTLY_IN_A_DUEL_PROHIBITED_AREA = new SystemMessageId(2020);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_BATTLE = new SystemMessageId(2021);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_ALREADY_ENGAGED_IN_A_DUEL = new SystemMessageId(2022);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_IN_A_CHAOTIC_STATE = new SystemMessageId(2023);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_THE_OLYMPIAD = new SystemMessageId(2024);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_A_CLAN_HALL_WAR = new SystemMessageId(2025);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_A_SIEGE_WAR = new SystemMessageId(2026);
		C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_RIDING_A_BOAT_STEED_OR_STRIDER = new SystemMessageId(2027);
		C1_CANNOT_RECEIVE_A_DUEL_CHALLENGE_BECAUSE_C1_IS_TOO_FAR_AWAY = new SystemMessageId(2028);
		C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_DURING_TELEPORT = new SystemMessageId(2029);
		CURRENTLY_LOGGING_IN = new SystemMessageId(2030);
		PLEASE_WAIT_A_MOMENT = new SystemMessageId(2031);
		NOT_TIME_TO_PURCHASE_ITEM = new SystemMessageId(2032);
		NOT_SUBCLASS_WHILE_INVENTORY_FULL = new SystemMessageId(2033);
		ITEM_PURCHASABLE_IN_S1_HOURS_S2_MINUTES = new SystemMessageId(2034);
		ITEM_PURCHASABLE_IN_S1_MINUTES = new SystemMessageId(2035);
		NO_INVITE_PARTY_LOCKED = new SystemMessageId(2036);
		CANT_CREATE_CHARACTER_DURING_RESTRICTION = new SystemMessageId(2037);
		ACCOUNT_CANT_DROP_ITEMS = new SystemMessageId(2038);
		ACCOUNT_CANT_TRADE_ITEMS = new SystemMessageId(2039);
		CANT_TRADE_WITH_TARGET = new SystemMessageId(2040);
		CANT_OPEN_PRIVATE_STORE = new SystemMessageId(2041);
		ILLEGAL_USE23 = new SystemMessageId(2042);
		YOU_HAVE_EXCEEDED_YOUR_INVENTORY_VOLUME_LIMIT_AND_CANNOT_TAKE_THIS_QUESTITEM = new SystemMessageId(2043);
		CANT_SETUP_PRIVATE_WORKSHOP = new SystemMessageId(2044);
		CANT_USE_PRIVATE_WORKSHOP = new SystemMessageId(2045);
		CANT_USE_PRIVATE_STORES = new SystemMessageId(2046);
		CANT_USE_CLAN_WH = new SystemMessageId(2047);
		CONFLICTING_SHORTCUT = new SystemMessageId(2048);
		CONFIRM_SHORTCUT_WILL_SAVED_ON_SERVER = new SystemMessageId(2049);
		S1_TRYING_RAISE_FLAG = new SystemMessageId(2050);
		MUST_ACCEPT_AGREEMENT = new SystemMessageId(2051);
		NEED_CONSENT_TO_PLAY_THIS_ACCOUNT = new SystemMessageId(2052);
		ACCOUNT_DECLINED_AGREEMENT_OR_PENDING = new SystemMessageId(2053);
		ACCOUNT_SUSPENDED = new SystemMessageId(2054);
		ACCOUNT_SUSPENDED_FROM_ALL_SERVICES = new SystemMessageId(2055);
		ACCOUNT_CONVERTED = new SystemMessageId(2056);
		BLOCKED_C1 = new SystemMessageId(2057);
		YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN = new SystemMessageId(2058);
		AREA_UNSUITABLE_FOR_POLYMORPH = new SystemMessageId(2059);
		YOU_CANNOT_POLYMORPH_INTO_THE_DESIRED_FORM_IN_WATER = new SystemMessageId(2060);
		CANT_MORPH_DUE_TO_MORPH_PENALTY = new SystemMessageId(2061);
		YOU_CANNOT_POLYMORPH_WHEN_YOU_HAVE_SUMMONED_A_SERVITOR = new SystemMessageId(2062);
		YOU_CANNOT_POLYMORPH_WHILE_RIDING_A_PET = new SystemMessageId(2063);
		CANT_MORPH_WHILE_UNDER_SPECIAL_SKILL_EFFECT = new SystemMessageId(2064);
		ITEM_CANNOT_BE_TAKEN_OFF = new SystemMessageId(2065);
		THAT_WEAPON_CANT_ATTACK = new SystemMessageId(2066);
		WEAPON_CAN_USE_ONLY_WEAPON_SKILL = new SystemMessageId(2067);
		YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_UNTRAIN_SKILL_ENCHANT = new SystemMessageId(2068);
		UNTRAIN_SUCCESSFUL_SKILL_S1_ENCHANT_LEVEL_DECREASED_BY_ONE = new SystemMessageId(2069);
		UNTRAIN_SUCCESSFUL_SKILL_S1_ENCHANT_LEVEL_RESETED = new SystemMessageId(2070);
		YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_CHANGE_SKILL_ENCHANT_ROUTE = new SystemMessageId(2071);
		SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WAS_DECREASED_BY_S2 = new SystemMessageId(2072);
		SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WILL_REMAIN = new SystemMessageId(2073);
		SKILL_ENCHANT_FAILED_S1_LEVEL_WILL_REMAIN = new SystemMessageId(2074);
		NO_AUCTION_PERIOD = new SystemMessageId(2075);
		BID_CANT_EXCEED_100_BILLION = new SystemMessageId(2076);
		BID_MUST_BE_HIGHER_THAN_CURRENT_BID = new SystemMessageId(2077);
		NOT_ENOUGH_ADENA_FOR_THIS_BID = new SystemMessageId(2078);
		HIGHEST_BID_BUT_RESERVE_NOT_MET = new SystemMessageId(2079);
		YOU_HAVE_BEEN_OUTBID = new SystemMessageId(2080);
		NO_FUNDS_DUE = new SystemMessageId(2081);
		EXCEEDED_MAX_ADENA_AMOUNT_IN_INVENTORY = new SystemMessageId(2082);
		AUCTION_BEGUN = new SystemMessageId(2083);
		ENEMIES_INTRUDED_FORTRESS = new SystemMessageId(2084);
		SHOUT_AND_TRADE_CHAT_CANNOT_BE_USED_WHILE_POSSESSING_CURSED_WEAPON = new SystemMessageId(2085);
		SEARCH_ON_S2_FOR_BOT_USE_COMPLETED_IN_S1_MINUTES = new SystemMessageId(2086);
		A_FORTRESS_IS_UNDER_ATTACK = new SystemMessageId(2087);
		S1_MINUTES_UNTIL_THE_FORTRESS_BATTLE_STARTS = new SystemMessageId(2088);
		S1_SECONDS_UNTIL_THE_FORTRESS_BATTLE_STARTS = new SystemMessageId(2089);
		THE_FORTRESS_BATTLE_S1_HAS_BEGUN = new SystemMessageId(2090);
		CHANGE_PASSWORT_FIRST = new SystemMessageId(2091);
		CANNOT_BID_DUE_TO_PASSED_IN_PRICE = new SystemMessageId(2092);
		PASSED_IN_PRICE_IS_S1_ADENA_WOULD_YOU_LIKE_TO_RETURN_IT = new SystemMessageId(2093);
		ANOTHER_USER_PURCHASING_TRY_AGAIN_LATER = new SystemMessageId(2094);
		ACCOUNT_CANNOT_SHOUT = new SystemMessageId(2095);
		C1_IS_IN_LOCATION_THAT_CANNOT_BE_ENTERED = new SystemMessageId(2096);
		C1_LEVEL_REQUIREMENT_NOT_SUFFICIENT = new SystemMessageId(2097);
		C1_QUEST_REQUIREMENT_NOT_SUFFICIENT = new SystemMessageId(2098);
		C1_ITEM_REQUIREMENT_NOT_SUFFICIENT = new SystemMessageId(2099);
		C1_MAY_NOT_REENTER_YET = new SystemMessageId(2100);
		NOT_IN_PARTY_CANT_ENTER = new SystemMessageId(2101);
		PARTY_EXCEEDED_THE_LIMIT_CANT_ENTER = new SystemMessageId(2102);
		NOT_IN_COMMAND_CHANNEL_CANT_ENTER = new SystemMessageId(2103);
		MAXIMUM_INSTANCE_ZONE_NUMBER_EXCEEDED_CANT_ENTER = new SystemMessageId(2104);
		ALREADY_ENTERED_ANOTHER_INSTANCE_CANT_ENTER = new SystemMessageId(2105);
		DUNGEON_EXPIRES_IN_S1_MINUTES = new SystemMessageId(2106);
		INSTANCE_ZONE_TERMINATES_IN_S1_MINUTES = new SystemMessageId(2107);
		ILLEGAL_USE24 = new SystemMessageId(2108);
		CHARACTER_NAME_OVERLAPPING_RENAME_CHARACTER = new SystemMessageId(2109);
		CHARACTER_NAME_INVALID_RENAME_CHARACTER = new SystemMessageId(2110);
		ENTER_SHORTCUT_TO_ASSIGN = new SystemMessageId(2111);
		SUBKEY_EXPLANATION1 = new SystemMessageId(2112);
		SUBKEY_EXPLANATION2 = new SystemMessageId(2113);
		SUBKEY_EXPLANATION3 = new SystemMessageId(2114);
		ILLEGAL_USE25 = new SystemMessageId(2115);
		ILLEGAL_USE26 = new SystemMessageId(2116);
		ILLEGAL_USE27 = new SystemMessageId(2117);
		ILLEGAL_USE28 = new SystemMessageId(2118);
		ILLEGAL_USE29 = new SystemMessageId(2119);
		ILLEGAL_USE30 = new SystemMessageId(2120);
		ILLEGAL_USE31 = new SystemMessageId(2121);
		ILLEGAL_USE32 = new SystemMessageId(2122);
		ILLEGAL_USE33 = new SystemMessageId(2123);
		CLAN_NAME_OVERLAPPING_RENAME_CLAN = new SystemMessageId(2124);
		CLAN_NAME_INVALID_RENAME_CLAN = new SystemMessageId(2125);
		ILLEGAL_USE34 = new SystemMessageId(2126);
		ILLEGAL_USE35 = new SystemMessageId(2127);
		ILLEGAL_USE36 = new SystemMessageId(2128);
		AUGMENTED_ITEM_CANT_CONVERTED = new SystemMessageId(2129);
		CANT_CONVERT_THIS_ITEM = new SystemMessageId(2130);
		WON_BID_ITEM_CAN_BE_FOUND_IN_WAREHOUSE = new SystemMessageId(2131);
		ENTERED_COMMON_SERVER = new SystemMessageId(2132);
		ENTERED_ADULTS_ONLY_SERVER = new SystemMessageId(2133);
		ENTERED_JUVENILES_SERVER = new SystemMessageId(2134);
		NOT_ALLOWED_DUE_TO_FATIGUE_LEVEL = new SystemMessageId(2135);
		CLAN_NAME_CHANCE_PETITION_SUBMITTED = new SystemMessageId(2136);
		CONFIRM_BID_S2_ADENA_FOR_S1_ITEM = new SystemMessageId(2137);
		ENTER_BID_PRICE = new SystemMessageId(2138);
		C1_PET = new SystemMessageId(2139);
		C1_SERVITOR = new SystemMessageId(2140);
		SLIGHTLY_RESISTED_C1_MAGICC = new SystemMessageId(2141);
		CANT_EXPEL_C1_NOT_A_PARTY_MEMBER = new SystemMessageId(2142);
		CANNOT_ADD_ELEMENTAL_POWER_WHILE_OPERATING_PRIVATE_STORE_OR_WORKSHOP = new SystemMessageId(2143);
		SELECT_ITEM_TO_ADD_ELEMENTAL_POWER = new SystemMessageId(2144);
		ELEMENTAL_ENHANCE_CANCELED = new SystemMessageId(2145);
		ELEMENTAL_ENHANCE_REQUIREMENT_NOT_SUFFICIENT = new SystemMessageId(2146);
		ELEMENTAL_POWER_S2_SUCCESSFULLY_ADDED_TO_S1 = new SystemMessageId(2147);
		ELEMENTAL_POWER_S3_SUCCESSFULLY_ADDED_TO_S1_S2 = new SystemMessageId(2148);
		FAILED_ADDING_ELEMENTAL_POWER = new SystemMessageId(2149);
		ANOTHER_ELEMENTAL_POWER_ALREADY_ADDED = new SystemMessageId(2150);
		OPPONENT_HAS_RESISTANCE_MAGIC_DAMAGE_DECREASED = new SystemMessageId(2151);
		CONFIRM_SHORCUT_DELETE = new SystemMessageId(2152);
		MAXIMUM_ACCOUNT_LOGINS_REACHED = new SystemMessageId(2153);
		THE_TARGET_IS_NOT_A_FLAGPOLE_SO_A_FLAG_CANNOT_BE_DISPLAYED = new SystemMessageId(2154);
		A_FLAG_IS_ALREADY_BEING_DISPLAYED_ANOTHER_FLAG_CANNOT_BE_DISPLAYED = new SystemMessageId(2155);
		THERE_ARE_NOT_ENOUGH_NECESSARY_ITEMS_TO_USE_THE_SKILL = new SystemMessageId(2156);
		BID_WILL_BE_ATTEMPTED_WITH_S1_ADENA = new SystemMessageId(2157);
		FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS = new SystemMessageId(2158);
		BIDDER_EXISTS_AUCTION_TIME_EXTENDED_BY_5_MINUTES = new SystemMessageId(2159);
		BIDDER_EXISTS_AUCTION_TIME_EXTENDED_BY_3_MINUTES = new SystemMessageId(2160);
		NOT_ENOUGH_SPACE_FOR_SKILL = new SystemMessageId(2161);
		YOUR_SOUL_HAS_INCREASED_BY_S1_SO_IT_IS_NOW_AT_S2 = new SystemMessageId(2162);
		SOUL_CANNOT_BE_INCREASED_ANYMORE = new SystemMessageId(2163);
		SEIZED_BARRACKS = new SystemMessageId(2164);
		BARRACKS_FUNCTION_RESTORED = new SystemMessageId(2165);
		ALL_BARRACKS_OCCUPIED = new SystemMessageId(2166);
		A_MALICIOUS_SKILL_CANNOT_BE_USED_IN_PEACE_ZONE = new SystemMessageId(2167);
		C1_ACQUIRED_THE_FLAG = new SystemMessageId(2168);
		REGISTERED_TO_S1_FORTRESS_BATTLE = new SystemMessageId(2169);
		CANT_USE_BAD_MAGIC_WHEN_OPPONENT_IN_PEACE_ZONE = new SystemMessageId(2170);
		ITEM_CANNOT_CRYSTALLIZED = new SystemMessageId(2171);
		S1_S2_AUCTION_ENDED = new SystemMessageId(2172);
		S1_AUCTION_ENDED = new SystemMessageId(2173);
		C1_CANNOT_DUEL_WHILE_POLYMORPHED = new SystemMessageId(2174);
		CANNOT_PARTY_DUEL_WHILE_A_MEMBER_IS_POLYMORPHED = new SystemMessageId(2175);
		S1_ELEMENTAL_POWER_REMOVED = new SystemMessageId(2176);
		S1_S2_ELEMENTAL_POWER_REMOVED = new SystemMessageId(2177);
		FAILED_TO_REMOVE_ELEMENTAL_POWER = new SystemMessageId(2178);
		HIGHEST_BID_FOR_GIRAN_CASTLE = new SystemMessageId(2179);
		HIGHEST_BID_FOR_ADEN_CASTLE = new SystemMessageId(2180);
		HIGHEST_BID_FOR_RUNE_CASTLE = new SystemMessageId(2181);
		CANT_POLYMORPH_ON_BOAT = new SystemMessageId(2182);
		THE_FORTRESS_BATTLE_OF_S1_HAS_FINISHED = new SystemMessageId(2183);
		S1_CLAN_IS_VICTORIOUS_IN_THE_FORTRESS_BATTLE_OF_S2 = new SystemMessageId(2184);
		ONLY_PARTY_LEADER_CAN_ENTER = new SystemMessageId(2185);
		SOUL_CANNOT_BE_ABSORBED_ANYMORE = new SystemMessageId(2186);
		CANT_REACH_TARGET_TO_CHARGE = new SystemMessageId(2187);
		ENCHANTMENT_ALREADY_IN_PROGRESS = new SystemMessageId(2188);
		LOC_KAMAEL_VILLAGE_S1_S2_S3 = new SystemMessageId(2189);
		LOC_WASTELANDS_CAMP_S1_S2_S3 = new SystemMessageId(2190);
		CONFIRM_APPLY_SELECTIONS = new SystemMessageId(2191);
		BID_ON_ITEM_AUCTION = new SystemMessageId(2192);
		TOO_FAR_FROM_NPC = new SystemMessageId(2193);
		CANT_APPLY_CURRENT_POLYMORPH_WITH_CORRESPONDING_EFFECTS = new SystemMessageId(2194);
		THERE_IS_NOT_ENOUGH_SOUL = new SystemMessageId(2195);
		NO_OWNED_CLAN = new SystemMessageId(2196);
		OWNED_S1_CLAN = new SystemMessageId(2197);
		HIGHEST_BID_IN_ITEM_AUCTION = new SystemMessageId(2198);
		CANT_ENTER_INSTANCE_ZONE_NPC_SERVER_OFFLINE = new SystemMessageId(2199);
		INSTANCE_ZONE_TERMINATED_NPC_SERVER_OFFLINE = new SystemMessageId(2200);
		S1_YEARS_S2_MONTHS_S3_DAYS = new SystemMessageId(2201);
		S1_HOURS_S2_MINUTES_S3_SECONDS = new SystemMessageId(2202);
		S1_MONTHS_S2_DAYS = new SystemMessageId(2203);
		S1_HOURS = new SystemMessageId(2204);
		AREA_FORBIDS_MINIMAP = new SystemMessageId(2205);
		AREA_ALLOWS_MINIMAP = new SystemMessageId(2206);
		CANT_OPEN_MINIMAP = new SystemMessageId(2207);
		YOU_DONT_MEET_SKILL_LEVEL_REQUIREMENTS = new SystemMessageId(2208);
		AREA_WHERE_RADAR_CANNOT_BE_USED = new SystemMessageId(2209);
		RETURN_TO_UNENCHANTED_CONDITION = new SystemMessageId(2210);
		YOU_MUST_LEARN_ONYX_BEAST_SKILL = new SystemMessageId(2211);
		NOT_COMPLETED_QUEST_FOR_SKILL_ACQUISITION = new SystemMessageId(2212);
		CANT_BOARD_SHIP_POLYMORPHED = new SystemMessageId(2213);
		CONFIRM_CHARACTER_CREATION = new SystemMessageId(2214);
		S1_PDEF = new SystemMessageId(2215);
		PLEASE_UPDATE_CPU_DRIVER = new SystemMessageId(2216);
		BALLISTA_DESTROYED_CLAN_REPU_INCREASED = new SystemMessageId(2217);
		MAIN_CLASS_SKILL_ONLY = new SystemMessageId(2218);
		SQUAD_SKILL_ALREADY_ACQUIRED = new SystemMessageId(2219);
		PREVIOUS_LEVEL_SKILL_NOT_LEARNED = new SystemMessageId(2220);
		ACTIVATE_SELECTED_FUNTIONS_CONFIRM = new SystemMessageId(2221);
		SCOUT_COSTS_150000_ADENA = new SystemMessageId(2222);
		FORTRESS_GATE_COSTS_200000_ADENA = new SystemMessageId(2223);
		CROSSBOW_PREPARING_TO_FIRE = new SystemMessageId(2224);
		NO_SKILLS_TO_LEARN_RETURN_AFTER_S1_CLASS_CHANGE = new SystemMessageId(2225);
		NOT_ENOUGH_BOLTS = new SystemMessageId(2226);
		NOT_POSSIBLE_TO_REGISTER_TO_CASTLE_SIEGE = new SystemMessageId(2227);
		INSTANCE_ZONE_TIME_LIMIT = new SystemMessageId(2228);
		NO_INSTANCEZONE_TIME_LIMIT = new SystemMessageId(2229);
		AVAILABLE_AFTER_S1_S2_HOURS_S3_MINUTES = new SystemMessageId(2230);
		REPUTATION_SCORE_FOR_CONTRACT_NOT_ENOUGH = new SystemMessageId(2231);
		S1_CRYSTALLIZED_BEFORE_DESTRUCTION = new SystemMessageId(2232);
		CANT_REGISTER_TO_SIEGE_DUE_TO_CONTRACT = new SystemMessageId(2233);
		CONFIRM_KAMAEL_HERO_WEAPON = new SystemMessageId(2234);
		INSTANCE_ZONE_DELETED_CANT_ACCESSED = new SystemMessageId(2235);
		S1_MINUTES_LEFT_ON_WYVERN = new SystemMessageId(2236);
		S1_SECONDS_LEFT_ON_WYVERN = new SystemMessageId(2237);
		PARTICIPATING_IN_SIEGE_OF_S1 = new SystemMessageId(2238);
		SIEGE_OF_S1_FINIHSED = new SystemMessageId(2239);
		CANT_REGISTER_TO_TEAM_BATTLE_CLAN_HALL_WAR_WHILE_LORD_ON_TRANSACTION_WAITING_LIST = new SystemMessageId(2240);
		CANT_APPLY_ON_LORD_TRANSACTION_WHILE_REGISTERED_TO_TEAM_BATTLE_CLAN_HALL_WAR = new SystemMessageId(2241);
		MEMBERS_CANT_LEAVE_WHEN_REGISTERED_TO_TEAM_BATTLE_CLAN_HALL_WAR = new SystemMessageId(2242);
		WHEN_BANDITSTRONGHOLD_WILDBEASTRESERVRE_CLANLORD_IN_DANGER_PREVIOUS_LORD_PARTICIPATES_IN_BATTLE = new SystemMessageId(2243);
		S1_MINUTES_REMAINING = new SystemMessageId(2244);
		S1_SECONDS_REMAINING = new SystemMessageId(2245);
		CONTEST_BEGIN_IN_S1_MINUTES = new SystemMessageId(2246);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_TRANSFORMED = new SystemMessageId(2247);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_PETRIFIED = new SystemMessageId(2248);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_DEAD = new SystemMessageId(2249);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_FISHING = new SystemMessageId(2250);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_IN_BATTLE = new SystemMessageId(2251);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_IN_A_DUEL = new SystemMessageId(2252);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_SITTING = new SystemMessageId(2253);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_CASTING = new SystemMessageId(2254);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_A_CURSED_WEAPON_IS_EQUIPPED = new SystemMessageId(2255);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_HOLDING_A_FLAG = new SystemMessageId(2256);
		YOU_CANNOT_BOARD_AN_AIRSHIP_WHILE_A_PET_OR_A_SERVITOR_IS_SUMMONED = new SystemMessageId(2257);
		YOU_HAVE_ALREADY_BOARDED_ANOTHER_AIRSHIP = new SystemMessageId(2258);
		LOC_FANTASY_ISLAND_S1_S2_S3 = new SystemMessageId(2259);
		PET_CAN_RUN_AWAY_WHEN_HUNGER_BELOW_10_PERCENT = new SystemMessageId(2260);
		C1_GAVE_C2_DAMAGE_OF_S3 = new SystemMessageId(2261);
		C1_RECEIVED_DAMAGE_OF_S3_FROM_C2 = new SystemMessageId(2262);
		C1_RECEIVED_DAMAGE_OF_S3_THROUGH_C2 = new SystemMessageId(2263);
		C1_EVADED_C2_ATTACK = new SystemMessageId(2264);
		C1_ATTACK_WENT_ASTRAY = new SystemMessageId(2265);
		C1_HAD_CRITICAL_HIT = new SystemMessageId(2266);
		C1_RESISTED_C2_DRAIN = new SystemMessageId(2267);
		C1_ATTACK_FAILED = new SystemMessageId(2268);
		C1_RESISTED_C2_DRAIN2 = new SystemMessageId(2269);
		C1_RECEIVED_DAMAGE_FROM_S2_THROUGH_FIRE_OF_MAGIC = new SystemMessageId(2270);
		C1_WEAKLY_RESISTED_C2_MAGIC = new SystemMessageId(2271);
		USE_SHORTCUT_CONFIRM = new SystemMessageId(2272);
		SKILL_NOT_FOR_SUBCLASS = new SystemMessageId(2273);
		NPCS_RECAPTURED_FORTRESS = new SystemMessageId(2276);
		CANNOT_TRANSFORM_WHILE_SITTING = new SystemMessageId(2283);
		CAN_OPERATE_MACHINE_WHEN_IN_PARTY = new SystemMessageId(2291);
		LOC_IN_STEEL_CITADEL_S1_S2_S3 = new SystemMessageId(2293);
		GAINED_VITALITY_POINTS = new SystemMessageId(2296);
		LOC_STEEL_CITADEL = new SystemMessageId(2301);
		YOUR_VITAMIN_ITEM_HAS_ARRIVED = new SystemMessageId(2302);
		S2_SECONDS_REMAINING_FOR_REUSE_S1 = new SystemMessageId(2303);
		S2_MINUTES_S3_SECONDS_REMAINING_FOR_REUSE_S1 = new SystemMessageId(2304);
		S2_HOURS_S3_MINUTES_S4_SECONDS_REMAINING_FOR_REUSE_S1 = new SystemMessageId(2305);
		RESURRECT_USING_CHARM_OF_COURAGE = new SystemMessageId(2306);
		DONT_HAVE_SERVITOR = new SystemMessageId(2311);
		DONT_HAVE_PET = new SystemMessageId(2312);
		VITALITY_IS_AT_MAXIMUM = new SystemMessageId(2314);
		VITALITY_HAS_INCREASED = new SystemMessageId(2315);
		VITALITY_HAS_DECREASED = new SystemMessageId(2316);
		VITALITY_IS_EXHAUSTED = new SystemMessageId(2317);
		ACQUIRED_S1_REPUTATION_SCORE = new SystemMessageId(2319);
		LOC_KAMALOKA = new SystemMessageId(2321);
		LOC_NIA_KAMALOKA = new SystemMessageId(2322);
		LOC_RIM_KAMALOKA = new SystemMessageId(2323);
		ACQUIRED_50_CLAN_FAME_POINTS = new SystemMessageId(2326);
		NOT_ENOUGH_FAME_POINTS = new SystemMessageId(2327);
		YOU_CANNOT_RECEIVE_THE_VITAMIN_ITEM = new SystemMessageId(2333);
		THERE_ARE_NO_MORE_VITAMIN_ITEMS_TO_BE_FOUND = new SystemMessageId(2335);
		HALF_KILL = new SystemMessageId(2336);
		CP_DISAPPEARS_WHEN_HIT_WITH_A_HALF_KILL_SKILL = new SystemMessageId(2337);
		YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_BATTLE = new SystemMessageId(2348);
		YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING = new SystemMessageId(2349);
		YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_DUEL = new SystemMessageId(2350);
		YOU_CANNOT_USE_MY_TELEPORTS_WHILE_FLYING = new SystemMessageId(2351);
		YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING_IN_AN_OLYMPIAD_MATCH = new SystemMessageId(2352);
		YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_PARALYZED = new SystemMessageId(2353);
		YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_DEAD = new SystemMessageId(2354);
		YOU_CANNOT_USE_MY_TELEPORTS_IN_THIS_AREA = new SystemMessageId(2355);
		YOU_CANNOT_USE_MY_TELEPORTS_UNDERWATER = new SystemMessageId(2356);
		YOU_CANNOT_USE_MY_TELEPORTS_IN_AN_INSTANT_ZONE = new SystemMessageId(2357);
		YOU_HAVE_NO_SPACE_TO_SAVE_THE_TELEPORT_LOCATION = new SystemMessageId(2358);
		YOU_CANNOT_TELEPORT_BECAUSE_YOU_DO_NOT_HAVE_A_TELEPORT_ITEM = new SystemMessageId(2359);
		CURRENT_LOCATION_S1 = new SystemMessageId(2361);
		TIME_LIMITED_ITEM_DELETED = new SystemMessageId(2366);
		THERE_NOT_MUCH_TIME_REMAINING_UNTIL_HELPER_LEAVES = new SystemMessageId(2372);
		THE_HELPER_PET_LEAVING = new SystemMessageId(2373);
		THE_HELPER_PET_CANNOT_BE_RETURNED = new SystemMessageId(2375);
		YOU_CANNOT_RECEIVE_A_VITAMIN_ITEM_DURING_AN_EXCHANGE = new SystemMessageId(2376);
		YOUR_NUMBER_OF_MY_TELEPORTS_SLOTS_HAS_REACHED_ITS_MAXIMUM_LIMIT = new SystemMessageId(2390);
		PET_SKILL_CANNOT_BE_USED_RECHARCHING = new SystemMessageId(2396);
		YOU_HAVE_NO_OPEN_MY_TELEPORTS_SLOTS = new SystemMessageId(2398);
		C1_