/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import java.util.Stack;
import org.python.parser.IntStack;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.TreeBuilder;

class JJTPythonGrammarState {
    private Stack nodes = new Stack();
    private IntStack marks = new IntStack();
    private IntStack lines = new IntStack();
    private IntStack columns = new IntStack();
    private int sp = 0;
    private int mk = 0;
    private boolean node_created;
    private TreeBuilder builder = new TreeBuilder(this);

    JJTPythonGrammarState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void reset() {
        this.nodes.removeAllElements();
        this.marks.removeAllElements();
        this.sp = 0;
        this.mk = 0;
    }

    Node rootNode() {
        return (Node)this.nodes.elementAt(0);
    }

    void pushNode(Node node) {
        this.nodes.push(node);
        ++this.sp;
    }

    Node popNode() {
        if (--this.sp < this.mk) {
            this.mk = this.marks.pop();
        }
        return (Node)this.nodes.pop();
    }

    Node peekNode() {
        return (Node)this.nodes.peek();
    }

    int nodeArity() {
        return this.sp - this.mk;
    }

    void pushNodePos(int n, int n2) {
        this.lines.push(n);
        this.columns.push(n2);
    }

    void setNodePos() {
        SimpleNode simpleNode = (SimpleNode)this.peekNode();
        simpleNode.beginLine = this.lines.pop();
        simpleNode.beginColumn = this.columns.pop();
    }

    void clearNodeScope(Node node) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.pop();
    }

    void openNodeScope(Node node) {
        this.marks.push(this.mk);
        this.mk = this.sp;
    }

    void closeNodeScope(Node node, int n) throws ParseException {
        SimpleNode simpleNode = (SimpleNode)node;
        this.mk = this.marks.pop();
        SimpleNode simpleNode2 = null;
        try {
            simpleNode2 = this.builder.closeNode(simpleNode, n);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ParseException("Internal error:" + exception);
        }
        if (simpleNode2 == null) {
            throw new ParseException("Internal AST builder error");
        }
        this.pushNode(simpleNode2);
        this.node_created = true;
    }

    void closeNodeScope(Node node, boolean bl) throws ParseException {
        SimpleNode simpleNode = (SimpleNode)node;
        if (bl) {
            SimpleNode simpleNode2 = null;
            try {
                simpleNode2 = this.builder.closeNode(simpleNode, this.nodeArity());
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ParseException("Internal error:" + exception);
            }
            if (simpleNode2 == null) {
                throw new ParseException("Internal AST builder error");
            }
            this.mk = this.marks.pop();
            this.pushNode(simpleNode2);
            this.node_created = true;
        } else {
            this.mk = this.marks.pop();
            this.node_created = false;
        }
    }

    public void dumpTop(String string) {
        int n = this.nodeArity();
        System.out.println("dumpTop:" + string);
        System.out.println("arity:" + n);
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.nodes.elementAt(this.nodes.size() - i - 1);
            System.out.println("   " + node);
        }
    }

    public Node openNode(int n) {
        return this.builder.openNode(n);
    }

    public void dump(String string) {
        int n;
        int n2 = this.nodeArity();
        System.out.println("dump:" + string);
        System.out.println("  mk:" + this.mk + "  sp:" + this.sp);
        for (n = 0; n < this.nodes.size(); ++n) {
            Node node = (Node)this.nodes.elementAt(n);
            System.out.println("   " + node);
        }
        for (n = 0; n < this.marks.size(); ++n) {
            System.out.println("   " + this.marks.elementAt(n));
        }
    }
}

