/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package custom.Nottingale;

import quests.Q10273_GoodDayToFly.Q10273_GoodDayToFly;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.RadarControl;

/**
 * Nottingale AI.<br>
 * Original Jython script by Kerberos.
 * @author Nyaran
 */
public class Nottingale extends Quest
{
	private static final String qn = "Nottingale";
	
	private static final int NPC = 32627;
	
	public Nottingale(int questId, String name, String descr)
	{
		super(questId, name, descr);
		addStartNpc(NPC);
		addFirstTalkId(NPC);
		addTalkId(NPC);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = event;
		QuestState qs = player.getQuestState(Q10273_GoodDayToFly.class.getSimpleName());
		if ((qs == null) || !qs.isCompleted())
		{
			addRadar(player, -184545, 243120, 1581);
			htmltext = "32627.htm";
		}
		else if (event.equals("32627-3.htm"))
		{
			addRadar(player, -192361, 254528, 3598);
		}
		else if (event.equals("32627-4.htm"))
		{
			addRadar(player, -174600, 219711, 4424);
		}
		else if (event.equals("32627-5.htm"))
		{
			addRadar(player, -181989, 208968, 4424);
		}
		else if (event.equals("32627-6.htm"))
		{
			addRadar(player, -252898, 235845, 5343);
		}
		else if (event.equals("32627-8.htm"))
		{
			addRadar(player, -212819, 209813, 4288);
		}
		else if (event.equals("32627-9.htm"))
		{
			addRadar(player, -246899, 251918, 4352);
		}
		return htmltext;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(qn);
		if (st == null)
		{
			st = newQuestState(player);
		}
		player.setLastQuestNpcObject(npc.getObjectId());
		npc.showChatWindow(player);
		return null;
	}
	
	private void addRadar(L2PcInstance player, int x, int y, int z)
	{
		player.sendPacket(new RadarControl(2, 2, 0, 0, 0));
		player.sendPacket(new RadarControl(0, 2, x, y, z));
	}

	public static void main(String[] args)
	{
		new Nottingale(-1, qn, "custom");
	}
}
