-- Information about category:
-- Only one drop will be given per category, except in the cases when category is -1.
-- Category -1 is used for SPOIL/SWEEP drops only!  Do NOT change this.
-- In general, category 0 is for adena and 1 seal stone color (each seal stone color should be in a different category).
-- In general, category 1 is for full drops and parts of equipable items.  However, you can change this.
-- In general, category 2 is for all other items.  However, you can change this.
-- In general, more categories are only used for RBs who have 1 item per category (i.e. do not really drop categorized),
-- You can create more categories as you see fit.  Just make sure the "category" number is non-negative!!
-- Also, it is NOT a problem if category numbers are skipped (so you can have -1, 1, 5, 10 as your categories).
--
-- If you wish to allow more than one item to be given from the same category, you can
-- split them up over several categories.
-- In addition, RBs and Grandbosses (mainly) may have the exact same item repeated in multiple categories.
-- This allows mobs to give 1 copy of the drop to each of several people (if they are lucky enough to get the drops).
-- Calculation for each drop, when in categories, is equivalent in chance as when outside of categories.
-- First, the sum of chances for each category is calculated as category chance.  If the category is selected
-- for drops (i.e. its chance is successful), then exactly 1 item from that category will be selected, with 
-- such a chance that the overall probability is maintained unchanged. 
--
-- Category Explanation (non-RaidBoss & non-GrandBoss)
--   -1 is sweep
--    0 is adena and one of the seal stones (your choice)
--    1 is any item that is in weapon.sql, any item in armor.sql, and some of the items from etcitem. Before dropping the column, I had those marked in etcitem.sql. However, you can recognize them easily. If they are parts unique for crafting equipable items, it's category 1.
--    2 is almost all of the other items except:
--    3 and 4 are used for the other two seal stones (1 category each).
--
-- Category Explanation (RaidBoss & their minions)
--    0 is full armor and armor mats
--    1 is full weapon and weapon mats
--    2 is anything else (scrolls,arrows,etc)
--
-- Category Explanation (GrandBoss)
--    0+ is defined categories
--    Any other mobs within this range (minions, etc) use the default drop categories (most often 2)

DROP TABLE IF EXISTS `droplist`;
CREATE TABLE `droplist` (
  `mobId` smallint(5) unsigned NOT NULL,
  `itemId` smallint(5) unsigned NOT NULL,
  `min` int(8) unsigned NOT NULL DEFAULT '0',
  `max` int(8) unsigned NOT NULL DEFAULT '0',
  `category` smallint(3) NOT NULL DEFAULT '0',
  `chance` decimal(30,15) unsigned NOT NULL,
  PRIMARY KEY (`mobId`,`itemId`,`category`),
  KEY `key_mobId` (`mobId`)
) ENGINE=MyISAM DEFAULT CHARSET=UTF8;

INSERT INTO `droplist` VALUES
-- Huge Pig
(13031, 9142, 1, 2, 0, 1000000), -- Apiga
-- Super Huge Pig
(13034, 9142, 4, 6, 0, 1000000), -- Apiga
(13034, 9144, 1, 1, 1, 500000), -- Pirate's Booty
-- Golden Pig
(13035, 9142, 1, 3, 0, 1000000), -- Apiga
(13035, 9144, 1, 1, 1, 1000000), -- Pirate's Booty
-- Treasure Chest
(13036, 9170, 1, 4, 0, 1000000), -- Magic Reagents
(13036, 9168, 1, 2, 1, 1000000), -- Philosopher's Stone Ore
(13036, 9169, 1, 1, 2, 100000), -- Philosopher's Stone Conversion Formula
(13036, 9162, 1, 1, 3, 16500), -- Red Philosopher's Stone Transmutation Circle
(13036, 9163, 1, 1, 3, 16500), -- Blue Philosopher's Stone Transmutation Circle
(13036, 9164, 1, 1, 3, 16500), -- Orange Philosopher's Stone Transmutation Circle
(13036, 9165, 1, 1, 3, 16500), -- Black Philosopher's Stone Transmutation Circle
(13036, 9166, 1, 1, 3, 16500), -- White Philosopher's Stone Transmutation Circle
(13036, 9167, 1, 1, 3, 17500), -- Green Philosopher's Stone Transmutation Circle
-- Event Treasure Chest
(13098, 10272, 3, 7, 0, 1000000), -- Treasure Sack Piece
-- Giant Rat
(13120, 10639, 1, 2, 0, 1000000), -- Mouse Coin
-- Super Giant Rat
(13123, 10639, 4, 6, 0, 1000000), -- Mouse Coin
(13123, 9140, 1, 1, 1, 50000), -- Salvation Bow
-- Giant Rat
(13124, 10639, 1, 3, 0, 1000000), -- Mouse Coin
(13124, 9140, 1, 1, 1, 100000), -- Salvation Bow
-- Blood Queen
(18001, 1806, 1, 1, -1, 10868), -- Recipe: Soulshot (B-Grade)
(18001, 57, 765, 1528, 0, 700000), -- Adena
(18001, 2397, 1, 1, 1, 11.433116), -- Tunic of Zubei
(18001, 4069, 1, 1, 1, 2101.99852), -- Tunic of Zubei Fabric
(18001, 2402, 1, 1, 1, 18.323548), -- Stockings of Zubei
(18001, 4070, 1, 1, 1, 3191.561972), -- Stockings of Zubei Fabric
(18001, 2406, 1, 1, 1, 7.821196), -- Avadon Robe
(18001, 4071, 1, 1, 1, 1614.861648), -- Avadon Robe Fabric
(18001, 1864, 1, 1, 2, 178348.515968), -- Stem
(18001, 1866, 1, 1, 2, 59449.60096), -- Suede
(18001, 1878, 1, 1, 2, 35669.760576), -- Braided Hemp
(18001, 1885, 1, 1, 2, 7431.307712), -- High-Grade Suede
(18001, 1889, 1, 1, 2, 5944.81664), -- Compound Braid
(18001, 4197, 1, 1, 2, 67.998144), -- Recipe: Demon's Dagger (100%)
(18001, 1419, 1, 1, 3, 200000), -- Blood Mark
-- Bearded Keltir
(18003, 1871, 1, 1, -1, 9797), -- Charcoal
-- Offering of the Branded, Warrior
(18012, 57, 148, 293, 0, 700000), -- Adena
-- Offering of the Branded, Follower
(18013, 57, 148, 293, 0, 700000), -- Adena
-- Offering of the Branded, Berserker
(18014, 57, 228, 455, 0, 700000), -- Adena
-- Offering of the Branded, Zealot
(18015, 57, 194, 387, 0, 700000), -- Adena
-- Offering of the Branded, Disciple
(18017, 57, 194, 387, 0, 700000), -- Adena
-- Offering of the Branded, Saint
(18018, 57, 253, 504, 0, 700000), -- Adena
-- Apostate's Offering, Warrior
(18022, 57, 265, 529, 0, 700000), -- Adena
-- Apostate's Offering, Follower
(18023, 57, 265, 529, 0, 700000), -- Adena
-- Apostate's Offering, Berserker
(18024, 57, 381, 761, 0, 700000), -- Adena
-- Apostate's Offering, Zealot
(18025, 57, 335, 669, 0, 700000), -- Adena
-- Apostate's Offering, Disciple
(18027, 57, 335, 669, 0, 700000), -- Adena
-- Apostate's Offering, Saint
(18028, 57, 414, 829, 0, 700000), -- Adena
-- Witch's Offering, Warrior
(18032, 57, 431, 863, 0, 700000), -- Adena
-- Witch's Offering, Follower
(18033, 57, 431, 863, 0, 700000), -- Adena
-- Witch's Offering, Berserker
(18034, 57, 585, 1171, 0, 700000), -- Adena
-- Witch's Offering, Zealot
(18035, 57, 525, 1049, 0, 700000), -- Adena
-- Witch's Offering, Disciple
(18037, 57, 525, 1049, 0, 700000), -- Adena
-- Witch's Offering, Saint
(18038, 57, 629, 1257, 0, 700000), -- Adena
-- Dark Omen Offering Warrior
(18042, 57, 651, 1302, 0, 700000), -- Adena
-- Dark Omen Offering Follower
(18043, 57, 651, 1302, 0, 700000), -- Adena
-- Dark Omen Offering Berserker
(18044, 57, 848, 1697, 0, 700000), -- Adena
-- Dark Omen Offering Zealot
(18045, 57, 770, 1541, 0, 700000), -- Adena
-- Dark Omen Offering Disciple
(18047, 57, 770, 1541, 0, 700000), -- Adena
-- Dark Omen Offering Saint
(18048, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Warrior
(18052, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Follower
(18053, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Berserker
(18054, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Zealot
(18055, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Disciple
(18057, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Saint
(18058, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of the Branded, Warrior
(18062, 57, 148, 293, 0, 700000), -- Adena
-- Offering of the Branded, Follower
(18063, 57, 148, 293, 0, 700000), -- Adena
-- Offering of the Branded, Berserker
(18064, 57, 228, 455, 0, 700000), -- Adena
-- Offering of the Branded, Zealot
(18065, 57, 194, 387, 0, 700000), -- Adena
-- Offering of the Branded, Disciple
(18067, 57, 194, 387, 0, 700000), -- Adena
-- Offering of the Branded, Saint
(18068, 57, 253, 504, 0, 700000), -- Adena
-- Apostate's Offering, Warrior
(18072, 57, 265, 529, 0, 700000), -- Adena
-- Apostate's Offering, Follower
(18073, 57, 265, 529, 0, 700000), -- Adena
-- Apostate's Offering, Berserker
(18074, 57, 381, 761, 0, 700000), -- Adena
-- Apostate's Offering, Zealot
(18075, 57, 335, 669, 0, 700000), -- Adena
-- Apostate's Offering, Disciple
(18077, 57, 335, 669, 0, 700000), -- Adena
-- Apostate's Offering, Saint
(18078, 57, 414, 829, 0, 700000), -- Adena
-- Witch's Offering, Warrior
(18082, 57, 431, 863, 0, 700000), -- Adena
-- Witch's Offering, Follower
(18083, 57, 431, 863, 0, 700000), -- Adena
-- Witch's Offering, Berserker
(18084, 57, 585, 1171, 0, 700000), -- Adena
-- Witch's Offering, Zealot
(18085, 57, 525, 1049, 0, 700000), -- Adena
-- Witch's Offering, Disciple
(18087, 57, 525, 1049, 0, 700000), -- Adena
-- Witch's Offering, Saint
(18088, 57, 629, 1257, 0, 700000), -- Adena
-- Dark Omen Offering Warrior
(18092, 57, 651, 1302, 0, 700000), -- Adena
-- Dark Omen Offering Follower
(18093, 57, 651, 1302, 0, 700000), -- Adena
-- Dark Omen Offering Berserker
(18094, 57, 848, 1697, 0, 700000), -- Adena
-- Dark Omen Offering Zealot
(18095, 57, 770, 1541, 0, 700000), -- Adena
-- Dark Omen Offering Disciple
(18097, 57, 770, 1541, 0, 700000), -- Adena
-- Dark Omen Offering Saint
(18098, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Warrior
(18102, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Follower
(18103, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Berserker
(18104, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Zealot
(18105, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Disciple
(18107, 57, 902, 1804, 0, 700000), -- Adena
-- Offering of Forbidden Path, Saint
(18108, 57, 902, 1804, 0, 700000), -- Adena
-- Treasures of the Festival
(18109, 8923, 1, 1, 0, 95.97756), -- Scar
(18109, 8913, 1, 1, 0, 95.97756), -- Butterfly Hairpin
(18109, 955, 1, 1, 0, 956.34783), -- Scroll: Enchant Weapon (D-Grade)
(18109, 956, 1, 1, 0, 7972.307466), -- Scroll: Enchant Armor (D-Grade)
(18109, 1060, 1, 1, 0, 531483.965148), -- Lesser Healing Potion
(18109, 1061, 1, 1, 0, 144949.424436), -- Greater Healing Potion
-- Treasures of the Festival
(18110, 8923, 1, 1, 0, 146.753787), -- Scar
(18110, 8913, 1, 1, 0, 146.753787), -- Butterfly Hairpin
(18110, 951, 1, 1, 0, 665.075673), -- Scroll: Enchant Weapon (C-Grade)
(18110, 952, 1, 1, 0, 4879.303216), -- Scroll: Enchant Armor (C-Grade)
(18110, 1832, 1, 1, 0, 406595.417778), -- Greater Antidote
(18110, 1061, 1, 1, 0, 221779.318788), -- Greater Healing Potion
(18110, 1834, 1, 1, 0, 406594.376971), -- Emergency Dressing
-- Treasures of the Festival
(18111, 8923, 1, 1, 0, 231.639408), -- Scar
(18111, 8913, 1, 1, 0, 231.639408), -- Butterfly Hairpin
(18111, 951, 1, 1, 0, 1053.266368), -- Scroll: Enchant Weapon (C-Grade)
(18111, 952, 1, 1, 0, 7724.990416), -- Scroll: Enchant Armor (C-Grade)
(18111, 734, 1, 1, 0, 96561.390288), -- Haste Potion
(18111, 1539, 1, 1, 0, 128748.237552), -- Greater Healing Potion
(18111, 735, 1, 1, 0, 48280.83656), -- Alacrity Potion
-- Treasures of the Festival
(18112, 8923, 1, 1, 0, 336.91392), -- Scar
(18112, 8913, 1, 1, 0, 336.91392), -- Butterfly Hairpin
(18112, 947, 1, 1, 0, 336.91392), -- Scroll: Enchant Weapon (B-Grade)
(18112, 948, 1, 1, 0, 2106.915264), -- Scroll: Enchant Armor (B-Grade)
(18112, 734, 1, 1, 0, 140459.814336), -- Haste Potion
(18112, 1539, 1, 1, 0, 187280.01984), -- Greater Healing Potion
(18112, 735, 1, 1, 0, 70230.5088), -- Alacrity Potion
-- Treasures of the Festival
(18113, 8923, 1, 1, 0, 450.971144), -- Scar
(18113, 8913, 1, 1, 0, 450.971144), -- Butterfly Hairpin
(18113, 729, 1, 1, 0, 125.032284), -- Scroll: Enchant Weapon (A-Grade)
(18113, 730, 1, 1, 0, 939.345108), -- Scroll: Enchant Armor (A-Grade)
(18113, 734, 1, 1, 0, 187891.463292), -- Haste Potion
(18113, 1539, 1, 1, 0, 250521.951056), -- Greater Healing Potion
(18113, 735, 1, 1, 0, 93946.265972), -- Alacrity Potion
-- Treasures of the Festival
(18114, 8923, 1, 1, 0, 95.97756), -- Scar
(18114, 8913, 1, 1, 0, 95.97756), -- Butterfly Hairpin
(18114, 955, 1, 1, 0, 956.34783), -- Scroll: Enchant Weapon (D-Grade)
(18114, 956, 1, 1, 0, 7972.307466), -- Scroll: Enchant Armor (D-Grade)
(18114, 1060, 1, 1, 0, 531483.965148), -- Lesser Healing Potion
(18114, 1061, 1, 1, 0, 144949.424436), -- Greater Healing Potion
-- Treasures of the Festival
(18115, 8923, 1, 1, 0, 146.753787), -- Scar
(18115, 8913, 1, 1, 0, 146.753787), -- Butterfly Hairpin
(18115, 951, 1, 1, 0, 665.075673), -- Scroll: Enchant Weapon (C-Grade)
(18115, 952, 1, 1, 0, 4879.303216), -- Scroll: Enchant Armor (C-Grade)
(18115, 1832, 1, 1, 0, 406595.417778), -- Greater Antidote
(18115, 1061, 1, 1, 0, 221779.318788), -- Greater Healing Potion
(18115, 1834, 1, 1, 0, 406594.376971), -- Emergency Dressing
-- Treasures of the Festival
(18116, 8923, 1, 1, 0, 231.639408), -- Scar
(18116, 8913, 1, 1, 0, 231.639408), -- Butterfly Hairpin
(18116, 951, 1, 1, 0, 1053.266368), -- Scroll: Enchant Weapon (C-Grade)
(18116, 952, 1, 1, 0, 7724.990416), -- Scroll: Enchant Armor (C-Grade)
(18116, 734, 1, 1, 0, 96561.390288), -- Haste Potion
(18116, 1539, 1, 1, 0, 128748.237552), -- Greater Healing Potion
(18116, 735, 1, 1, 0, 48280.83656), -- Alacrity Potion
-- Treasures of the Festival
(18117, 8923, 1, 1, 0, 336.91392), -- Scar
(18117, 8913, 1, 1, 0, 336.91392), -- Butterfly Hairpin
(18117, 947, 1, 1, 0, 336.91392), -- Scroll: Enchant Weapon (B-Grade)
(18117, 948, 1, 1, 0, 2106.915264), -- Scroll: Enchant Armor (B-Grade)
(18117, 734, 1, 1, 0, 140459.814336), -- Haste Potion
(18117, 1539, 1, 1, 0, 187280.01984), -- Greater Healing Potion
(18117, 735, 1, 1, 0, 70230.5088), -- Alacrity Potion
-- Treasures of the Festival
(18118, 8923, 1, 1, 0, 450.971144), -- Scar
(18118, 8913, 1, 1, 0, 450.971144), -- Butterfly Hairpin
(18118, 729, 1, 1, 0, 125.032284), -- Scroll: Enchant Weapon (A-Grade)
(18118, 730, 1, 1, 0, 939.345108), -- Scroll: Enchant Armor (A-Grade)
(18118, 734, 1, 1, 0, 187891.463292), -- Haste Potion
(18118, 1539, 1, 1, 0, 250521.951056), -- Greater Healing Potion
(18118, 735, 1, 1, 0, 93946.265972), -- Alacrity Potion
-- Halisha's Treasure Chest
(18256, 57, 1370, 2743, 0, 700000), -- Adena
(18256, 81, 1, 1, 1, 1.185316), -- Dragon Slayer
(18256, 5529, 1, 1, 1, 439.07842), -- Dragon Slayer Edge
(18256, 151, 1, 1, 1, 1.185316), -- Sword of Miracles
(18256, 5546, 1, 1, 1, 482.285848), -- Sword of Miracles Edge
(18256, 2500, 1, 1, 1, 1.185316), -- Dark Legion's Edge
(18256, 5545, 1, 1, 1, 439.079784), -- Dark Legion's Edge Blade
(18256, 1895, 1, 1, 2, 54857.316515), -- Metallic Fiber
(18256, 4040, 1, 1, 2, 3840.038795), -- Mold Lubricant
(18256, 4042, 1, 1, 2, 3200.020945), -- Enria
(18256, 4043, 1, 1, 2, 6400.04189), -- Asofe
(18256, 959, 1, 1, 2, 7.581855), -- Scroll: Enchant Weapon (S-Grade)
-- Treasure Chest
(18265, 57, 480, 858, 0, 700000), -- Adena
(18265, 955, 1, 1, 1, 3739.397843), -- Scroll: Enchant Weapon (D-Grade)
(18265, 956, 1, 1, 1, 31161.602157), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18266, 57, 483, 891, 0, 700000), -- Adena
(18266, 955, 1, 1, 1, 3854.576568), -- Scroll: Enchant Weapon (D-Grade)
(18266, 956, 1, 1, 1, 32121.423432), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18267, 57, 484, 932, 0, 700000), -- Adena
(18267, 955, 1, 1, 1, 3904.826635), -- Scroll: Enchant Weapon (D-Grade)
(18267, 956, 1, 1, 1, 32540.173365), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18268, 57, 708, 1417, 0, 700000), -- Adena
(18268, 955, 1, 1, 1, 5803.93631), -- Scroll: Enchant Weapon (D-Grade)
(18268, 956, 1, 1, 1, 48366.06369), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18269, 57, 732, 1465, 0, 700000), -- Adena
(18269, 955, 1, 1, 1, 5939.043633), -- Scroll: Enchant Weapon (D-Grade)
(18269, 956, 1, 1, 1, 49491.956367), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18270, 57, 758, 1520, 0, 700000), -- Adena
(18270, 955, 1, 1, 1, 6162.758217), -- Scroll: Enchant Weapon (D-Grade)
(18270, 956, 1, 1, 1, 51356.241783), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18271, 57, 789, 1572, 0, 700000), -- Adena
(18271, 955, 1, 1, 1, 6337.829879), -- Scroll: Enchant Weapon (D-Grade)
(18271, 956, 1, 1, 1, 52815.170121), -- Scroll: Enchant Armor (D-Grade)
-- Treasure Chest
(18272, 57, 1257, 2519, 0, 700000), -- Adena
(18272, 951, 1, 1, 1, 4563), -- Scroll: Enchant Weapon (C-Grade)
(18272, 952, 1, 1, 1, 33462), -- Scroll: Enchant Armor (C-Grade)
-- Treasure Chest
(18273, 57, 1293, 2582, 0, 700000), -- Adena
(18273, 951, 1, 1, 1, 4603.08), -- Scroll: Enchant Weapon (C-Grade)
(18273, 952, 1, 1, 1, 33755.92), -- Scroll: Enchant Armor (C-Grade)
-- Treasure Chest
(18274, 57, 1330, 2656, 0, 700000), -- Adena
(18274, 951, 1, 1, 1, 4651.44), -- Scroll: Enchant Weapon (C-Grade)
(18274, 952, 1, 1, 1, 34110.56), -- Scroll: Enchant Armor (C-Grade)
-- Treasure Chest
(18275, 57, 1952, 3909, 0, 700000), -- Adena
(18275, 951, 1, 1, 1, 6717.72), -- Scroll: Enchant Weapon (C-Grade)
(18275, 952, 1, 1, 1, 49263.28), -- Scroll: Enchant Armor (C-Grade)
-- Treasure Chest
(18276, 57, 1997, 3995, 0, 700000), -- Adena
(18276, 947, 1, 1, 1, 1467.999633), -- Scroll: Enchant Weapon (B-Grade)
(18276, 948, 1, 1, 1, 9175.000367), -- Scroll: Enchant Armor (B-Grade)
-- Treasure Chest
(18277, 57, 2049, 4095, 0, 700000), -- Adena
(18277, 947, 1, 1, 1, 1432.965159), -- Scroll: Enchant Weapon (B-Grade)
(18277, 948, 1, 1, 1, 8956.034841), -- Scroll: Enchant Armor (B-Grade)
-- Treasure Chest
(18278, 57, 2683, 5361, 0, 700000), -- Adena
(18278, 947, 1, 1, 1, 1876.965048), -- Scroll: Enchant Weapon (B-Grade)
(18278, 948, 1, 1, 1, 11731.034952), -- Scroll: Enchant Armor (B-Grade)
-- Treasure Chest
(18279, 57, 2736, 5473, 0, 700000), -- Adena
(18279, 947, 1, 1, 1, 1915.034004), -- Scroll: Enchant Weapon (B-Grade)
(18279, 948, 1, 1, 1, 11968.965996), -- Scroll: Enchant Armor (B-Grade)
-- Treasure Chest
(18280, 57, 2790, 5576, 0, 700000), -- Adena
(18280, 729, 1, 1, 1, 542.235023), -- Scroll: Enchant Weapon (A-Grade)
(18280, 730, 1, 1, 1, 4066.764977), -- Scroll: Enchant Armor (A-Grade)
-- Treasure Chest
(18281, 57, 2849, 5701, 0, 700000), -- Adena
(18281, 729, 1, 1, 1, 554.235017), -- Scroll: Enchant Weapon (A-Grade)
(18281, 730, 1, 1, 1, 4156.764983), -- Scroll: Enchant Armor (A-Grade)
-- Treasure Chest
(18282, 57, 4009, 8028, 0, 700000), -- Adena
(18282, 729, 1, 1, 1, 780.470198), -- Scroll: Enchant Weapon (A-Grade)
(18282, 730, 1, 1, 1, 5853.529802), -- Scroll: Enchant Armor (A-Grade)
-- Treasure Chest
(18283, 57, 4078, 8168, 0, 700000), -- Adena
(18283, 959, 1, 1, 1, 285.908805), -- Scroll: Enchant Weapon (S-Grade)
(18283, 960, 1, 1, 1, 2859.091195), -- Scroll: Enchant Armor (S-Grade)
-- Treasure Chest
(18284, 57, 4146, 8295, 0, 700000), -- Adena
(18284, 959, 1, 1, 1, 290.363346), -- Scroll: Enchant Weapon (S-Grade)
(18284, 960, 1, 1, 1, 2903.636654), -- Scroll: Enchant Armor (S-Grade)
-- Treasure Chest
(18285, 57, 5312, 10638, 0, 700000), -- Adena
(18285, 959, 1, 1, 1, 372.363264), -- Scroll: Enchant Weapon (S-Grade)
(18285, 960, 1, 1, 1, 3723.636736), -- Scroll: Enchant Armor (S-Grade)
-- Treasure Chest
(18286, 57, 5393, 10798, 0, 700000), -- Adena
(18286, 959, 1, 1, 1, 377.908713), -- Scroll: Enchant Weapon (S-Grade)
(18286, 960, 1, 1, 1, 3779.091287), -- Scroll: Enchant Armor (S-Grade)
-- Otherworldly Invader Food
(18287, 57, 186, 372, 0, 700000), -- Adena
(18287, 955, 1, 1, 1, 1507.180581), -- Scroll: Enchant Weapon (D-Grade)
(18287, 956, 1, 1, 1, 12559.819419), -- Scroll: Enchant Armor (D-Grade)
-- Otherworldly Invader Food
(18288, 57, 207, 413, 0, 700000), -- Adena
(18288, 955, 1, 1, 1, 1679.573668), -- Scroll: Enchant Weapon (D-Grade)
(18288, 956, 1, 1, 1, 13996.426332), -- Scroll: Enchant Armor (D-Grade)
-- Dimension Invader Food
(18289, 57, 308, 617, 0, 700000), -- Adena
(18289, 951, 1, 1, 1, 1118.76), -- Scroll: Enchant Weapon (C-Grade)
(18289, 952, 1, 1, 1, 8204.24), -- Scroll: Enchant Armor (C-Grade)
-- Dimension Invader Food
(18290, 57, 338, 676, 0, 700000), -- Adena
(18290, 951, 1, 1, 1, 1204.44), -- Scroll: Enchant Weapon (C-Grade)
(18290, 952, 1, 1, 1, 8832.56), -- Scroll: Enchant Armor (C-Grade)
-- Purgatory Invader Food
(18291, 57, 472, 944, 0, 700000), -- Adena
(18291, 947, 1, 1, 1, 346.758534), -- Scroll: Enchant Weapon (B-Grade)
(18291, 948, 1, 1, 1, 2167.241466), -- Scroll: Enchant Armor (B-Grade)
-- Purgatory Invader Food
(18292, 57, 519, 1010, 0, 700000), -- Adena
(18292, 947, 1, 1, 1, 374.620596), -- Scroll: Enchant Weapon (B-Grade)
(18292, 948, 1, 1, 1, 2341.379404), -- Scroll: Enchant Armor (B-Grade)
-- Forbidden Path Invader Food
(18293, 57, 681, 1361, 0, 700000), -- Adena
(18293, 729, 1, 1, 1, 132.352875), -- Scroll: Enchant Weapon (A-Grade)
(18293, 730, 1, 1, 1, 992.647125), -- Scroll: Enchant Armor (A-Grade)
-- Forbidden Path Invader Food
(18294, 57, 728, 1457, 0, 700000), -- Adena
(18294, 729, 1, 1, 1, 141.646988), -- Scroll: Enchant Weapon (A-Grade)
(18294, 730, 1, 1, 1, 1062.353012), -- Scroll: Enchant Armor (A-Grade)
-- Dark Omen Invader Food
(18295, 57, 938, 1879, 0, 700000), -- Adena
(18295, 729, 1, 1, 1, 182.588144), -- Scroll: Enchant Weapon (A-Grade)
(18295, 730, 1, 1, 1, 1369.411856), -- Scroll: Enchant Armor (A-Grade)
-- Dark Omen Invader Food
(18296, 57, 995, 1993, 0, 700000), -- Adena
(18296, 959, 1, 1, 1, 69.727203), -- Scroll: Enchant Weapon (S-Grade)
(18296, 960, 1, 1, 1, 697.272797), -- Scroll: Enchant Armor (S-Grade)
-- Messenger Invader Food
(18297, 57, 1239, 2481, 0, 700000), -- Adena
(18297, 959, 1, 1, 1, 86.818095), -- Scroll: Enchant Weapon (S-Grade)
(18297, 960, 1, 1, 1, 868.181905), -- Scroll: Enchant Armor (S-Grade)
-- Messenger Invader Food
(18298, 57, 1301, 2604, 0, 700000), -- Adena
(18298, 959, 1, 1, 1, 91.181727), -- Scroll: Enchant Weapon (S-Grade)
(18298, 960, 1, 1, 1, 911.818273), -- Scroll: Enchant Armor (S-Grade)
-- Caught Frog
(18319, 6529, 1, 1, 0, 1159), -- Baby Duck Rod
(18319, 6535, 12, 36, 1, 120767.548307), -- Fishing Shot (No-Grade)
(18319, 6520, 1, 1, 1, 86952.648307), -- Green Colored Lure
(18319, 6523, 1, 1, 1, 57968.544921), -- Purple Colored Lure
(18319, 6526, 1, 1, 1, 72460.258465), -- Yellow Colored Lure
-- Caught Undine
(18320, 6530, 1, 1, 0, 527), -- Albatross Rod
(18320, 6536, 12, 36, 1, 109760), -- Fishing Shot (D-Grade)
(18320, 6520, 1, 1, 1, 131712), -- Green Colored Lure
(18320, 6523, 1, 1, 1, 87808), -- Purple Colored Lure
(18320, 6526, 1, 1, 1, 109760), -- Yellow Colored Lure
-- Caught Rakul
(18321, 6531, 1, 1, 0, 200), -- Pelican Rod
(18321, 6537, 12, 36, 1, 118752.3), -- Fishing Shot (C-Grade)
(18321, 6520, 2, 6, 1, 33250.644), -- Green Colored Lure
(18321, 6523, 1, 1, 1, 110835.48), -- Purple Colored Lure
(18321, 6526, 1, 1, 1, 133002.576), -- Yellow Colored Lure
-- Caught Sea Giant
(18322, 6532, 1, 1, 0, 108), -- KingFisher Rod
(18322, 6538, 15, 45, 1, 43231.999833), -- Fishing Shot (B-Grade)
(18322, 6520, 2, 6, 1, 67550.347116), -- Green Colored Lure
(18322, 6523, 1, 1, 1, 180133.823052), -- Purple Colored Lure
(18322, 6526, 3, 9, 1, 36026.829999), -- Yellow Colored Lure
-- Caught Sea Horse Soldier
(18323, 6533, 1, 1, 0, 41), -- Cygnus Pole
(18323, 6539, 3, 9, 1, 169120.014807), -- Fishing Shot (A-Grade)
(18323, 6520, 2, 6, 1, 67648.102885), -- Green Colored Lure
(18323, 6523, 1, 1, 1, 202944.308655), -- Purple Colored Lure
(18323, 6526, 2, 6, 1, 45098.573653), -- Yellow Colored Lure
-- Caught Homunculus
(18324, 6533, 1, 1, 0, 61), -- Cygnus Pole
(18324, 6539, 3, 9, 1, 204003.714807), -- Fishing Shot (A-Grade)
(18324, 6520, 2, 6, 1, 81601.602885), -- Green Colored Lure
(18324, 6523, 1, 1, 1, 244804.808655), -- Purple Colored Lure
(18324, 6526, 2, 6, 1, 54400.873653), -- Yellow Colored Lure
-- Caught Flava
(18325, 6534, 1, 1, 0, 17), -- Triton Pole
(18325, 6540, 3, 9, 1, 141546.6), -- Fishing Shot (S-Grade)
(18325, 6520, 2, 6, 1, 70773.3), -- Green Colored Lure
(18325, 6523, 1, 1, 1, 212319.9), -- Purple Colored Lure
(18325, 6526, 2, 6, 1, 47182.2), -- Yellow Colored Lure
-- Caught Gigantic Eye
(18326, 6534, 1, 1, 0, 30), -- Triton Pole
(18326, 6540, 3, 9, 1, 171546.6), -- Fishing Shot (S-Grade)
(18326, 6520, 2, 6, 1, 85773.3), -- Green Colored Lure
(18326, 6523, 1, 1, 1, 257319.9), -- Purple Colored Lure
(18326, 6526, 2, 6, 1, 57182.2), -- Yellow Colored Lure
-- Gremlin
(18342, 57, 7, 13, 0, 1000000), -- Adena
-- Sprigant
(18345, 960, 1, 1, -1, 931), -- Scroll: Enchant Armor (S-Grade)
(18345, 1894, 1, 1, -1, 81680), -- Crafted Leather
(18345, 4039, 1, 1, -1, 77596), -- Mold Glue
(18345, 8787, 1, 1, 0, 397600), -- Sprigant's Fruit
-- Sprigant
(18346, 6701, 1, 1, -1, 6885), -- Sealed Imperial Crusader Breastplate Part
(18346, 6901, 1, 1, -1, 2328), -- Recipe: Shining Arrow (100%)
(18346, 6702, 1, 1, -1, 8863), -- Sealed Imperial Crusader Gaiters Pattern
(18346, 8787, 1, 1, 0, 397600), -- Sprigant's Fruit
-- Kamael Guard
(18352, 9703, 1, 1, 2, 1000000), -- Gate Key: Kamael
-- Guardian of Records
(18353, 9704, 1, 1, 2, 1000000), -- Gate Key: Archives
-- Guardian of Observation
(18354, 9705, 1, 1, 2, 1000000), -- Gate Key: Observation
-- Spicula's Guard
(18355, 9706, 1, 1, 2, 1000000), -- Gate Key: Spicula
-- Harkilgamed's Gatekeeper
(18356, 9707, 1, 1, 2, 1000000), -- Gate Key: Harkilgamed
-- Rodenpicula's Gatekeeper
(18357, 9708, 1, 1, 2, 1000000), -- Gate Key: Rodenpicula
-- Guardian of Secrets
(18358, 9713, 1, 1, 2, 1000000), -- Nornil's Power
-- Arviterre's Guardian
(18359, 9709, 1, 1, 2, 1000000), -- Gate Key: Arviterre
-- Katenar's Gatekeeper
(18360, 9710, 1, 1, 2, 1000000), -- Gate Key: Katenar
-- Guardian of Prediction
(18361, 9711, 1, 1, 2, 1000000), -- Gate Key: Prediction
-- Remnant Diabolist
(18463, 1895, 1, 27, -1, 934652), -- Metallic Fiber
(18463, 4042, 1, 1, -1, 763299), -- Enria
(18463, 6710, 1, 1, -1, 495300), -- Sealed Draconic Leather Helmet Pattern
(18463, 57, 23038, 47020, 0, 700000), -- Adena
(18463, 236, 1, 1, 1, 62.628408), -- Soul Separator
(18463, 5537, 1, 1, 1, 23193.371592), -- Soul Separator Head
(18463, 1873, 3, 9, 2, 140916.6692), -- Silver Nugget
(18463, 1868, 32, 96, 2, 66054.82012), -- Thread
(18463, 1876, 4, 12, 2, 46972.082872), -- Mithril Ore
(18463, 1895, 3, 9, 2, 86275.657672), -- Metallic Fiber
(18463, 4042, 1, 1, 2, 35228.957008), -- Enria
(18463, 1808, 1, 1, 2, 939.584656), -- Recipe: Soulshot (S-Grade)
(18463, 9675, 5, 15, 2, 28183.33384), -- Prayer Fragment
(18463, 1344, 1650, 4950, 2, 16012.894632), -- Mithril Arrow
-- Remnant Diviner
(18464, 6901, 1, 1, -1, 44546), -- Recipe: Shining Arrow (100%)
(18464, 6711, 1, 1, -1, 147144), -- Sealed Major Arcana Robe Part
(18464, 57, 22408, 45735, 0, 700000), -- Adena
(18464, 305, 1, 1, 1, 60.916728), -- Tallum Glaive
(18464, 5541, 1, 1, 1, 22551.083272), -- Tallum Glaive Edge
(18464, 1871, 9, 27, 2, 114219.291882), -- Charcoal
(18464, 1866, 14, 42, 2, 48951.283356), -- Suede
(18464, 1877, 1, 1, 2, 82237.993554), -- Adamantite Nugget
(18464, 4041, 1, 1, 2, 17877.680184), -- Mold Hardener
(18464, 4040, 1, 1, 2, 41118.812136), -- Mold Lubricant
(18464, 6901, 1, 1, 2, 2055.792894), -- Recipe: Shining Arrow (100%)
(18464, 9675, 4, 12, 2, 34265.67678), -- Prayer Fragment
(18464, 1344, 900, 2700, 2, 28555.469214), -- Mithril Arrow
-- Derek
(18465, 6714, 1, 5, -1, 695358), -- Sealed Major Arcana Circlet Pattern
(18465, 6901, 1, 1, -1, 231473), -- Recipe: Shining Arrow (100%)
(18465, 7579, 1, 1, -1, 281174), -- Draconic Bow Shaft
(18465, 57, 116439, 237651, 0, 700000), -- Adena
(18465, 5313, 1, 1, 1, 1214.018262), -- Sealed Gauntlets of Nightmare
(18465, 5514, 1, 1, 1, 180416.481738), -- Sealed Gauntlets of Nightmare Design
(18465, 5314, 1, 1, 1, 1214.018262), -- Sealed Boots of Nightmare
(18465, 5502, 1, 1, 1, 180416.481738), -- Sealed Boots of Nightmare Lining
(18465, 5318, 1, 1, 1, 1214.018262), -- Sealed Majestic Gauntlets
(18465, 5515, 1, 1, 1, 180416.481738), -- Sealed Majestic Gauntlets Design
(18465, 5319, 1, 1, 1, 1214.018262), -- Sealed Majestic Boots
(18465, 5503, 1, 1, 1, 180416.481738), -- Sealed Majestic Boots Lining
(18465, 1875, 3, 9, 2, 158272.236542), -- Stone of Purity
(18465, 1879, 32, 96, 2, 37095.31798), -- Cokes
(18465, 1885, 22, 66, 2, 26378.626078), -- High-Grade Suede
(18465, 5550, 1, 1, 2, 189926.87588), -- Durable Metal Plate
(18465, 5549, 10, 30, 2, 67831.095682), -- Metallic Thread
(18465, 959, 1, 1, 2, 569.847838), -- Scroll: Enchant Weapon (S-Grade)
-- Coral Treasure Chest
(18477, 6684, 1, 1, 0, 12078.56754), -- Sealed Major Arcana Robe
(18477, 6711, 12, 36, 0, 216942.43246), -- Sealed Major Arcana Robe Part
(18477, 9460, 1, 1, 1, 7050.850092), -- Dynasty Ring - Stun Resistance
(18477, 9463, 1, 1, 1, 7050.850092), -- Dynasty Ring - Poison Resistance
(18477, 9466, 1, 1, 1, 7050.850092), -- Dynasty Ring - Bleed Resistance
(18477, 9469, 1, 1, 1, 7050.850092), -- Dynasty Ring - Sleep Resistance
(18477, 9472, 1, 1, 1, 7050.850092), -- Dynasty Ring - Paralysis Resistance
(18477, 9475, 1, 1, 1, 7050.850092), -- Dynasty Ring - Hold Resistance
(18477, 9478, 1, 1, 1, 7050.899448), -- Dynasty Ring - Fear Resistance
-- Beleth's Slave
(18490, 57, 5380, 10776, 0, 700000), -- Adena
(18490, 164, 1, 1, 1, 4.187562), -- Elysian
(18490, 5533, 1, 1, 1, 1549.528413), -- Elysian Head
(18490, 213, 1, 1, 1, 4.187562), -- Branch of the Mother Tree
(18490, 5544, 1, 1, 1, 1548.000015), -- Branch of the Mother Tree Head
(18490, 7895, 1, 1, 1, 4.187562), -- Flaming Dragon Skull
(18490, 8342, 1, 1, 1, 1549.528413), -- Flaming Dragon Skull Piece
(18490, 7902, 1, 1, 1, 4.187562), -- Doom Crusher
(18490, 8349, 1, 1, 1, 1549.192911), -- Doom Crusher Head
(18490, 1873, 2, 6, 2, 64613.214492), -- Silver Nugget
(18490, 1868, 15, 45, 2, 43075.476328), -- Thread
(18490, 1876, 1, 1, 2, 129226.428984), -- Mithril Ore
(18490, 1895, 1, 1, 2, 184609.49369), -- Metallic Fiber
(18490, 4042, 1, 1, 2, 10768.869082), -- Enria
(18490, 960, 1, 1, 2, 258.619206), -- Scroll: Enchant Armor (S-Grade)
(18490, 6901, 1, 1, 2, 645.898218), -- Recipe: Shining Arrow (100%)
-- Ancient Experiment
(18545, 1871, 1, 21, -1, 877846), -- Charcoal
(18545, 4553, 1, 1, -1, 38625), -- Greater Dye of STR (Str+1 Con-1)
(18545, 1908, 1, 1, -1, 914423), -- Moonstone Earring Wire
(18545, 354, 1, 1, 0, 587.201116), -- Chain Mail Shirt
(18545, 1959, 1, 1, 0, 30730.634002), -- Chain Mail Shirt Material
(18545, 381, 1, 1, 0, 939.370152), -- Chain Gaiters
(18545, 1960, 1, 1, 0, 62513.79473), -- Chain Gaiters Part
(18545, 1871, 4, 12, 1, 95077.506048), -- Charcoal
(18545, 1866, 1, 3, 1, 169026.1776), -- Suede
(18545, 1877, 1, 1, 1, 30424.711968), -- Adamantite Nugget
(18545, 4041, 1, 1, 1, 6614.100416), -- Mold Hardener
(18545, 4040, 1, 1, 1, 15212.355984), -- Mold Lubricant
(18545, 2164, 1, 1, 1, 58509.147984), -- Recipe: Ring of Protection
-- Ancient Experiment
(18546, 2163, 1, 7, -1, 745273), -- Recipe: Earring of Protection
(18546, 1909, 1, 17, -1, 876726), -- Aquastone Ring Wire
(18546, 2164, 1, 9, -1, 898914), -- Recipe: Ring of Protection
(18546, 226, 1, 1, 0, 783.216815), -- Cursed Dagger
(18546, 2070, 1, 1, 0, 54819.283185), -- Cursed Dagger Blade
(18546, 232, 1, 1, 0, 783.216815), -- Dark Elven Dagger
(18546, 2072, 1, 1, 0, 54819.283185), -- Dark Elven Dagger Edge
(18546, 1870, 24, 72, 1, 95884.05276), -- Coal
(18546, 1865, 52, 156, 1, 43832.62608), -- Varnish
(18546, 1874, 4, 12, 1, 38353.54782), -- Oriharukon Ore
(18546, 4043, 5, 15, 1, 15341.63898), -- Asofe
(18546, 4039, 1, 1, 1, 153414.5577), -- Mold Glue
(18546, 2165, 4, 12, 1, 19593.57666), -- Recipe: Necklace of Protection
-- Ancient Experiment
(18547, 1910, 1, 17, -1, 945042), -- Aquastone Necklace Chain
(18547, 1866, 1, 159, -1, 941262), -- Suede
(18547, 1871, 1, 237, -1, 949172), -- Charcoal
(18547, 71, 1, 1, 0, 1009.370349), -- Flamberge
(18547, 2059, 1, 1, 0, 66090.296364), -- Flamberge Blade
(18547, 72, 1, 1, 0, 1009.370349), -- Stormbringer
(18547, 2060, 1, 1, 0, 70647.928584), -- Stormbringer Blade
(18547, 7887, 1, 1, 0, 1009.370349), -- Mysterious Sword
(18547, 8334, 1, 1, 0, 70650.664005), -- Mysterious Sword Blade
(18547, 1866, 60, 180, 1, 49428.388719), -- Suede
(18547, 1871, 240, 720, 1, 18535.484916), -- Charcoal
(18547, 5220, 4, 12, 1, 39542.539398), -- Metal Hardener
(18547, 1885, 3, 9, 1, 105917.608161), -- High-Grade Suede
(18547, 4041, 1, 1, 1, 77365.875252), -- Mold Hardener
(18547, 2213, 1, 1, 1, 138153.103554), -- Recipe: Dwarven Chain Mail Shirt
-- Ancient Experiment
(18548, 4554, 1, 1, -1, 115844), -- Greater Dye of STR (Str+1 Dex-1)
(18548, 1954, 1, 3, -1, 769829), -- Karmian Stocking Design
(18548, 2165, 1, 3, -1, 554808), -- Recipe: Necklace of Protection
(18548, 96, 1, 1, 0, 258.805603), -- Scythe
(18548, 2062, 1, 1, 0, 17891.50958), -- Scythe Edge
(18548, 298, 1, 1, 0, 258.805603), -- Orcish Glaive
(18548, 2075, 1, 1, 0, 17891.50958), -- Orcish Glaive Blade
(18548, 302, 1, 1, 0, 258.805603), -- Body Slasher
(18548, 2076, 1, 1, 0, 17891.564031), -- Body Slasher Blade
(18548, 1864, 21, 63, 1, 108630.218445), -- Stem
(18548, 1869, 16, 48, 1, 71288.62734), -- Iron Ore
(18548, 1878, 3, 9, 1, 152082.107485), -- Braided Hemp
(18548, 1884, 22, 66, 1, 31196.58402), -- Cord
(18548, 4039, 1, 1, 1, 76041.301665), -- Mold Glue
(18548, 2214, 1, 1, 1, 56606.161045), -- Recipe: Dwarven Chain Gaiters
-- Ancient Experiment
(18549, 1958, 1, 1, -1, 546211), -- Reinforced Mithril Boots Design
(18549, 2213, 1, 1, -1, 94357), -- Recipe: Dwarven Chain Mail Shirt
(18549, 1959, 1, 1, -1, 163679), -- Chain Mail Shirt Material
(18549, 62, 1, 1, 0, 328.630137), -- Reinforced Mithril Boots
(18549, 1958, 1, 1, 0, 14341.688526), -- Reinforced Mithril Boots Design
(18549, 2429, 1, 1, 0, 328.630137), -- Chain Boots
(18549, 2937, 1, 1, 0, 14341.688526), -- Chain Boots Part
(18549, 2430, 1, 1, 0, 328.630137), -- Karmian Boots
(18549, 2938, 1, 1, 0, 14341.688526), -- Karmian Boots Fabric
(18549, 2431, 1, 1, 0, 328.630137), -- Plated Leather Boots
(18549, 2939, 1, 1, 0, 14341.688526), -- Plate Leather Boots Lining
(18549, 2432, 1, 1, 0, 328.630137), -- Dwarven Chain Boots
(18549, 2940, 1, 1, 0, 14341.688526), -- Dwarven Chain Boots Part
(18549, 2433, 1, 1, 0, 328.630137), -- Boots of Seal
(18549, 2941, 1, 1, 0, 14341.688526), -- Boots of Seal Pattern
(18549, 2452, 1, 1, 0, 328.630137), -- Reinforced Mithril Gloves
(18549, 2942, 1, 1, 0, 14341.688526), -- Reinforced Mithril Gloves Design
(18549, 2453, 1, 1, 0, 328.630137), -- Chain Gloves
(18549, 2943, 1, 1, 0, 14341.688526), -- Chain Gloves Design
(18549, 2454, 1, 1, 0, 328.630137), -- Karmian Gloves
(18549, 2944, 1, 1, 0, 14341.820559), -- Karmian Gloves Fabric
(18549, 1870, 1, 3, 1, 239324.368574), -- Coal
(18549, 1865, 1, 3, 1, 159549.735313), -- Varnish
(18549, 1874, 1, 1, 1, 31910.134579), -- Oriharukon Ore
(18549, 4043, 1, 1, 1, 15954.832894), -- Asofe
(18549, 4039, 1, 1, 1, 15954.832894), -- Mold Glue
(18549, 2215, 1, 1, 1, 6097.095746), -- Recipe: Robe of Seal
-- Cruma Phantom
(18550, 5220, 1, 9, -1, 943019), -- Metal Hardener
(18550, 1885, 1, 21, -1, 893011), -- High-Grade Suede
(18550, 4601, 1, 1, -1, 261950), -- Greater Dye of STR (Str+3 Con-3)
(18550, 75, 1, 1, 0, 210.750709), -- Caliburs
(18550, 2089, 1, 1, 0, 18977.841077), -- Caliburs Edge
(18550, 76, 1, 1, 0, 210.750709), -- Sword of Delusion
(18550, 2090, 1, 1, 0, 18977.841077), -- Delusional Blade
(18550, 77, 1, 1, 0, 210.750709), -- Tsurugi
(18550, 2091, 1, 1, 0, 18977.841077), -- Tsurugi Blade
(18550, 84, 1, 1, 0, 210.750709), -- Homunkulus's Sword
(18550, 2092, 1, 1, 0, 18977.841077), -- Homunkulus's Sword Blade
(18550, 134, 1, 1, 0, 210.750709), -- Sword of Nightmare
(18550, 2095, 1, 1, 0, 18977.841077), -- Sword of Nightmare Blade
(18550, 145, 1, 1, 0, 210.750709), -- Sword of Whispering Death
(18550, 2096, 1, 1, 0, 18977.841077), -- Sword of Whispering Death Blade
(18550, 7882, 1, 1, 0, 210.750709), -- Pa'agrian Sword
(18550, 8329, 1, 1, 0, 18128.698575), -- Pa'agrian Sword Blade
(18550, 1866, 60, 180, 1, 45135.921911), -- Suede
(18550, 1871, 240, 720, 1, 16925.91955), -- Charcoal
(18550, 5220, 4, 12, 1, 36108.491929), -- Metal Hardener
(18550, 1885, 3, 9, 1, 96719.657238), -- High-Grade Suede
(18550, 4041, 1, 1, 1, 70647.191803), -- Mold Hardener
(18550, 2169, 1, 1, 1, 143795.817569), -- Recipe: Necklace of Seal
-- Cruma Phantom
(18551, 1539, 1, 55, -1, 926751), -- Greater Healing Potion
(18551, 1914, 1, 13, -1, 937164), -- Earring of Seal Gemstone
(18551, 2169, 1, 5, -1, 688912), -- Recipe: Necklace of Seal
(18551, 162, 1, 1, 0, 162.37837), -- War Axe
(18551, 2097, 1, 1, 0, 14366.862426), -- War Axe Blade
(18551, 174, 1, 1, 0, 162.37837), -- Nirvana Axe
(18551, 2098, 1, 1, 0, 14366.862426), -- Nirvana Axe Blade
(18551, 196, 1, 1, 0, 162.37837), -- Stick of Eternity
(18551, 2099, 1, 1, 0, 15119.97599), -- Stick of Eternity Shaft
(18551, 197, 1, 1, 0, 162.37837), -- Paradia Staff
(18551, 2100, 1, 1, 0, 15119.97599), -- Paradia Staff Head
(18551, 199, 1, 1, 0, 162.37837), -- Pa'agrian Hammer
(18551, 2102, 1, 1, 0, 14577.685913), -- Pa'agrian Hammer Head
(18551, 200, 1, 1, 0, 162.37837), -- Sage's Staff
(18551, 2103, 1, 1, 0, 15119.97599), -- Sage's Staff Head
(18551, 201, 1, 1, 0, 162.37837), -- Club of Nature
(18551, 2104, 1, 1, 0, 15119.97599), -- Club of Nature Head
(18551, 202, 1, 1, 0, 162.37837), -- Mace of Underworld
(18551, 2105, 1, 1, 0, 14366.862426), -- Mace of Underworld Head
(18551, 7898, 1, 1, 0, 162.37837), -- Karik Horn
(18551, 8345, 1, 1, 0, 14577.417519), -- Karik Horn Piece
(18551, 1871, 240, 720, 1, 16767.050288), -- Charcoal
(18551, 1866, 52, 156, 1, 51099.959128), -- Suede
(18551, 1877, 4, 12, 1, 40241.13678), -- Adamantite Nugget
(18551, 4041, 1, 1, 1, 69984.679656), -- Mold Hardener
(18551, 4040, 1, 1, 1, 160964.54712), -- Mold Lubricant
(18551, 2170, 4, 12, 1, 21090.627028), -- Recipe: Nassen's Earring
-- Cruma Phantom
(18552, 1915, 1, 11, -1, 827471), -- Ring of Ages Gemstone
(18552, 2170, 1, 3, -1, 664514), -- Recipe: Nassen's Earring
(18552, 1916, 1, 5, -1, 799302), -- Necklace of Mermaid Teardrop
(18552, 283, 1, 1, 0, 705.24312), -- Akat Long Bow
(18552, 2109, 1, 1, 0, 65328.75688), -- Akat Longbow Shaft
(18552, 1867, 28, 84, 1, 92473.036317), -- Animal Skin
(18552, 1872, 60, 180, 1, 43153.98417), -- Animal Bone
(18552, 1882, 3, 9, 1, 143847.111123), -- Leather
(18552, 1894, 1, 1, 1, 136276.393725), -- Crafted Leather
(18552, 4042, 1, 1, 1, 64731.473478), -- Enria
(18552, 2231, 1, 1, 1, 16741.001187), -- Recipe: Full Plate Armor
-- Cruma Phantom
(18553, 1865, 1, 123, -1, 934946), -- Varnish
(18553, 1870, 1, 123, -1, 934946), -- Coal
(18553, 4602, 1, 1, -1, 128815), -- Greater Dye of STR (Str+3 Dex-3)
(18553, 854, 1, 1, 0, 3526.248132), -- Earring of Seal
(18553, 1914, 1, 1, 0, 224427.92216), -- Earring of Seal Gemstone
(18553, 885, 1, 1, 0, 5287.477588), -- Ring of Ages
(18553, 1915, 1, 1, 0, 351966.246764), -- Ring of Ages Gemstone
(18553, 917, 1, 1, 0, 2644.87556), -- Necklace of Mermaid
(18553, 1916, 1, 1, 0, 169991.229796), -- Necklace of Mermaid Teardrop
(18553, 1865, 28, 84, 1, 71343.602305), -- Varnish
(18553, 1870, 60, 180, 1, 33293.56505), -- Coal
(18553, 1879, 3, 9, 1, 110979.130295), -- Cokes
(18553, 1875, 4, 12, 1, 29594.550771), -- Stone of Purity
(18553, 4040, 1, 1, 1, 79904.904197), -- Mold Lubricant
(18553, 2232, 1, 1, 1, 22961.247382), -- Recipe: Drake Leather Armor
-- Tomlan Kamos
(18554, 25, 1, 1, 0, 209298.796681), -- Piece Bone Breastplate
(18554, 1926, 8, 22, 0, 172512.732353), -- Piece Bone Breastplate Fragment
(18554, 26, 1, 1, 0, 135474.075386), -- Bronze Breastplate
(18554, 32, 4, 10, 0, 47839.839814), -- Piece Bone Gaiters
(18554, 1928, 24, 72, 0, 77743.592238), -- Piece Bone Gaiters Fragment
(18554, 34, 4, 12, 0, 27137.963528), -- Bronze Gaiters
(18554, 25, 5, 13, 1, 34883.157192), -- Piece Bone Breastplate
(18554, 1926, 8, 22, 1, 258769.259268), -- Piece Bone Breastplate Fragment
(18554, 26, 1, 1, 1, 203211.159996), -- Bronze Breastplate
(18554, 32, 4, 10, 1, 71759.7621), -- Piece Bone Gaiters
(18554, 1928, 24, 72, 1, 116615.96544), -- Piece Bone Gaiters Fragment
(18554, 34, 4, 12, 1, 40706.696004), -- Bronze Gaiters
(18554, 955, 1, 1, 2, 298878.528135), -- Scroll: Enchant Weapon (D-Grade)
(18554, 956, 3, 9, 2, 415108.471865), -- Scroll: Enchant Armor (D-Grade)
-- Ol Ariosh
(18555, 432, 1, 1, 0, 354880.951371), -- Cursed Tunic
(18555, 465, 1, 3, 0, 284140.048629), -- Cursed Stockings
(18555, 432, 2, 4, 1, 177440.48714), -- Cursed Tunic
(18555, 465, 1, 3, 1, 426211.51286), -- Cursed Stockings
(18555, 955, 1, 1, 2, 332602.184145), -- Scroll: Enchant Weapon (D-Grade)
(18555, 956, 3, 9, 2, 461946.815855), -- Scroll: Enchant Armor (D-Grade)
-- Ranc Deumus
(18557, 432, 1, 1, 0, 354880.951371), -- Cursed Tunic
(18557, 465, 1, 3, 0, 284140.048629), -- Cursed Stockings
(18557, 432, 2, 4, 1, 177440.48714), -- Cursed Tunic
(18557, 465, 1, 3, 1, 426211.51286), -- Cursed Stockings
(18557, 955, 1, 1, 2, 332602.184145), -- Scroll: Enchant Weapon (D-Grade)
(18557, 956, 3, 9, 2, 461946.815855), -- Scroll: Enchant Armor (D-Grade)
-- Crimson Hatu Otis
(18558, 63, 3, 9, 0, 26632.283392), -- Gauntlets
(18558, 553, 4, 10, 0, 22828.191121), -- Iron Boots
(18558, 1940, 60, 180, 0, 38855.72159), -- Iron Boots Design
(18558, 2422, 1, 1, 0, 159795.882849), -- Reinforced Leather Boots
(18558, 2423, 1, 1, 0, 159795.882849), -- Boots of Knowledge
(18558, 2446, 1, 1, 0, 159795.882849), -- Reinforced Leather Gloves
(18558, 2447, 1, 1, 0, 159795.15535), -- Gloves of Knowledge
(18558, 63, 3, 9, 1, 39948.457824), -- Gauntlets
(18558, 553, 4, 10, 1, 34241.2488), -- Iron Boots
(18558, 1940, 60, 180, 1, 58283.318016), -- Iron Boots Design
(18558, 2422, 4, 12, 1, 29961.176256), -- Reinforced Leather Boots
(18558, 2423, 5, 13, 1, 26632.305216), -- Boots of Knowledge
(18558, 2446, 1, 1, 1, 239690.746944), -- Reinforced Leather Gloves
(18558, 2447, 1, 1, 1, 239690.746944), -- Gloves of Knowledge
(18558, 955, 1, 1, 2, 425206.739264), -- Scroll: Enchant Weapon (D-Grade)
(18558, 956, 12, 36, 2, 147641.260736), -- Scroll: Enchant Armor (D-Grade)
-- Seer Flouros
(18559, 47, 1, 1, 0, 413972.422365), -- Helmet
(18559, 628, 1, 3, 0, 295838.577635), -- Hoplon
(18559, 47, 2, 4, 1, 206986.048544), -- Helmet
(18559, 628, 1, 3, 1, 443757.951456), -- Hoplon
(18559, 955, 1, 1, 2, 471697.953176), -- Scroll: Enchant Weapon (D-Grade)
(18559, 956, 12, 36, 2, 163784.046824), -- Scroll: Enchant Armor (D-Grade)
-- Granitick Duerga
(18561, 83, 1, 1, 0, 14680.9374), -- Sword of Magic
(18561, 124, 1, 1, 0, 10875.74376), -- Two-Handed Sword
(18561, 2026, 1, 1, 0, 486625.345305), -- Two-Handed Sword Edge
(18561, 127, 1, 1, 0, 10875.74376), -- Crimson Sword
(18561, 130, 1, 1, 0, 10875.74376), -- Elven Sword
(18561, 144, 1, 1, 0, 14681.486015), -- Sword of Occult
(18561, 83, 1, 1, 1, 22021.393563), -- Sword of Magic
(18561, 124, 1, 1, 1, 16313.517227), -- Two-Handed Sword
(18561, 2026, 1, 3, 1, 364965.661193), -- Two-Handed Sword Edge
(18561, 127, 1, 1, 1, 16313.517227), -- Crimson Sword
(18561, 130, 1, 1, 1, 16313.517227), -- Elven Sword
(18561, 144, 1, 1, 1, 22021.393563), -- Sword of Occult
(18561, 955, 1, 1, 2, 471697.953176), -- Scroll: Enchant Weapon (D-Grade)
(18561, 956, 12, 36, 2, 163784.046824), -- Scroll: Enchant Armor (D-Grade)
-- Blade Otis
(18562, 353, 1, 1, 0, 49540.14856), -- Half Plate Armor
(18562, 1950, 8, 22, 0, 161220.990448), -- Half Plate Temper
(18562, 380, 1, 1, 0, 79264.237696), -- Plate Gaiters
(18562, 1951, 4, 12, 0, 470142.623296), -- Plate Gaiters Part
(18562, 353, 1, 1, 1, 74310.286), -- Half Plate Armor
(18562, 1950, 8, 22, 1, 241832.23845), -- Half Plate Temper
(18562, 380, 1, 1, 1, 118896.4576), -- Plate Gaiters
(18562, 1951, 24, 72, 1, 117536.01795), -- Plate Gaiters Part
(18562, 951, 1, 1, 2, 263413.35), -- Scroll: Enchant Weapon (C-Grade)
(18562, 952, 3, 9, 2, 321949.65), -- Scroll: Enchant Armor (C-Grade)
-- Weird Bunei
(18564, 281, 1, 1, 0, 19239.801579), -- Crystallized Ice Bow
(18564, 2074, 1, 3, 0, 600579.198421), -- Crystallized Ice Bow Shaft
(18564, 281, 1, 1, 1, 28859.675064), -- Crystallized Ice Bow
(18564, 2074, 3, 9, 1, 300284.324936), -- Crystallized Ice Bow Shaft
(18564, 951, 1, 1, 2, 299778.75), -- Scroll: Enchant Weapon (C-Grade)
(18564, 952, 3, 9, 2, 366396.25), -- Scroll: Enchant Armor (C-Grade)
-- Brave Martim
(18565, 631, 1, 1, 0, 110842.592416), -- Eldarake
(18565, 1964, 40, 120, 0, 57101.028168), -- Eldarake Temper
(18565, 2413, 1, 1, 0, 77597.5498), -- Chain Hood
(18565, 2936, 14, 42, 0, 148178.142568), -- Chain Hood Pattern
(18565, 2495, 1, 1, 0, 110842.592416), -- Chain Shield
(18565, 2945, 9, 27, 0, 253782.094632), -- Chain Shield Fragment
(18565, 631, 1, 1, 1, 166263.857452), -- Eldarake
(18565, 1964, 40, 120, 1, 85650.811702), -- Eldarake Temper
(18565, 2413, 1, 1, 1, 116396.047976), -- Chain Hood
(18565, 2936, 14, 42, 1, 222265.850216), -- Chain Hood Pattern
(18565, 2495, 1, 1, 1, 166263.857452), -- Chain Shield
(18565, 2945, 81, 243, 1, 42297.575202), -- Chain Shield Fragment
(18565, 951, 1, 1, 2, 299778.75), -- Scroll: Enchant Weapon (C-Grade)
(18565, 952, 3, 9, 2, 366396.25), -- Scroll: Enchant Armor (C-Grade)
-- Kaim Abigore
(18566, 266, 1, 1, 0, 8318.72104), -- Great Pata
(18566, 2120, 1, 3, 0, 470870.27896), -- Great Pata Blade
(18566, 266, 1, 1, 1, 12478.07288), -- Great Pata
(18566, 2120, 1, 3, 1, 706304.92712), -- Great Pata Blade
(18566, 947, 1, 1, 2, 76242.187836), -- Scroll: Enchant Weapon (B-Grade)
(18566, 948, 1, 1, 2, 476513.812164), -- Scroll: Enchant Armor (B-Grade)
-- Knight Montagnar
(18568, 357, 1, 1, 0, 8370.795283), -- Zubei's Breastplate
(18568, 4056, 16, 48, 0, 37781.283302), -- Zubei's Breastplate Part
(18568, 383, 1, 1, 0, 13389.979323), -- Zubei's Gaiters
(18568, 4057, 6, 18, 0, 155704.286973), -- Zubei's Gaiter Material
(18568, 2376, 1, 1, 0, 8370.795283), -- Avadon Breastplate
(18568, 4064, 3, 7, 0, 241799.758908), -- Avadon Breastplate Part
(18568, 2379, 1, 1, 0, 13389.979323), -- Avadon Gaiters
(18568, 4065, 11, 31, 0, 88974.121605), -- Avadon Gaiters Material
(18568, 357, 1, 1, 1, 12556.180609), -- Zubei's Breastplate
(18568, 4056, 16, 48, 1, 56672.977225), -- Zubei's Breastplate Part
(18568, 383, 1, 1, 1, 20085.760567), -- Zubei's Gaiters
(18568, 4057, 6, 18, 1, 233561.472957), -- Zubei's Gaiter Material
(18568, 2376, 1, 1, 1, 12556.180609), -- Avadon Breastplate
(18568, 4064, 23, 67, 1, 40300.666186), -- Avadon Breastplate Part
(18568, 2379, 1, 1, 1, 20085.760567), -- Avadon Gaiters
(18568, 4065, 11, 31, 1, 133464.00128), -- Avadon Gaiters Material
(18568, 947, 1, 1, 2, 103909.353333), -- Scroll: Enchant Weapon (B-Grade)
(18568, 948, 1, 1, 2, 649433.646667), -- Scroll: Enchant Armor (B-Grade)
-- Summer Yaganitan
(18570, 78, 1, 1, 0, 2666.424), -- Great Sword
(18570, 4104, 1, 3, 0, 254821.2536), -- Great Sword Blade
(18570, 142, 1, 1, 0, 2666.424), -- Keshanberk
(18570, 4107, 2, 4, 0, 167248.667875), -- Keshanberk Blade
(18570, 148, 1, 1, 0, 2666.424), -- Sword of Valhalla
(18570, 4108, 2, 6, 0, 125435.806525), -- Sword of Valhalla Blade
(18570, 78, 1, 1, 1, 3999.633894), -- Great Sword
(18570, 4104, 5, 15, 1, 76452.511293), -- Great Sword Blade
(18570, 142, 1, 1, 1, 3999.633894), -- Keshanberk
(18570, 4107, 2, 4, 1, 250894.470438), -- Keshanberk Blade
(18570, 148, 1, 1, 1, 3999.633894), -- Sword of Valhalla
(18570, 4108, 2, 6, 1, 188171.116587), -- Sword of Valhalla Blade
(18570, 947, 1, 1, 2, 103909.353333), -- Scroll: Enchant Weapon (B-Grade)
(18570, 948, 1, 1, 2, 649433.646667), -- Scroll: Enchant Armor (B-Grade)
-- Venomous Storace
(18571, 2398, 1, 1, 0, 9540.4291), -- Blue Wolf Tunic
(18571, 4084, 16, 48, 0, 48108.8423), -- Blue Wolf Tunic Fabric
(18571, 2399, 1, 1, 0, 9540.4291), -- Tunic of Doom
(18571, 4085, 3, 7, 0, 307896.59072), -- Tunic of Doom Pattern
(18571, 2403, 1, 1, 0, 15268.753528), -- Blue Wolf Stockings
(18571, 4086, 6, 18, 0, 173220.978884), -- Blue Wolf Stockings Pattern
(18571, 2404, 1, 1, 0, 15268.753528), -- Stockings of Doom
(18571, 4087, 11, 31, 0, 98983.22284), -- Stockings of Doom Pattern
(18571, 2398, 1, 1, 1, 14310.641774), -- Blue Wolf Tunic
(18571, 4084, 16, 48, 1, 72164.893931), -- Blue Wolf Tunic Fabric
(18571, 2399, 1, 1, 1, 14310.641774), -- Tunic of Doom
(18571, 4085, 23, 67, 1, 51317.28485), -- Tunic of Doom Pattern
(18571, 2403, 1, 1, 1, 22903.937849), -- Blue Wolf Stockings
(18571, 4086, 6, 18, 1, 259838.236606), -- Blue Wolf Stockings Pattern
(18571, 2404, 1, 1, 1, 22903.937849), -- Stockings of Doom
(18571, 4087, 11, 31, 1, 148479.425367), -- Stockings of Doom Pattern
(18571, 729, 1, 1, 2, 38276.569097), -- Scroll: Enchant Weapon (A-Grade)
(18571, 730, 1, 1, 2, 287074.430903), -- Scroll: Enchant Armor (A-Grade)
-- Kel Bilette
(18573, 601, 1, 1, 0, 28834.965858), -- Sealed Doom Boots
(18573, 4099, 60, 180, 0, 33376.171267), -- Sealed Doom Boots Part
(18573, 2439, 1, 1, 0, 28834.965858), -- Sealed Blue Wolf Boots
(18573, 4090, 11, 31, 0, 190722.323133), -- Sealed Blue Wolf Boots Design
(18573, 2475, 1, 1, 0, 28834.965858), -- Sealed Doom Gloves
(18573, 4091, 16, 48, 0, 125161.334255), -- Sealed Doom Gloves Part
(18573, 2487, 1, 1, 0, 28834.965858), -- Sealed Blue Wolf Gloves
(18573, 4096, 23, 67, 0, 89003.307913), -- Sealed Blue Wolf Gloves Fabric
(18573, 601, 1, 1, 1, 43252.495395), -- Sealed Doom Boots
(18573, 4099, 60, 180, 1, 50065.14697), -- Sealed Doom Boots Part
(18573, 2439, 1, 1, 1, 43252.495395), -- Sealed Blue Wolf Boots
(18573, 4090, 116, 346, 1, 26007.846335), -- Sealed Blue Wolf Boots Design
(18573, 2475, 1, 1, 1, 43252.495395), -- Sealed Doom Gloves
(18573, 4091, 16, 48, 1, 187744.01597), -- Sealed Doom Gloves Part
(18573, 2487, 1, 1, 1, 43252.495395), -- Sealed Blue Wolf Gloves
(18573, 4096, 23, 67, 1, 133508.009145), -- Sealed Blue Wolf Gloves Fabric
(18573, 729, 1, 1, 2, 38549.863078), -- Scroll: Enchant Weapon (A-Grade)
(18573, 730, 1, 1, 2, 289124.136922), -- Scroll: Enchant Armor (A-Grade)
-- Warlord Tamuze
(18575, 171, 1, 1, 0, 1414.518996), -- Deadman's Glory
(18575, 4116, 1, 3, 0, 155937.89518), -- Deadman's Glory Stone
(18575, 175, 1, 1, 0, 1414.518996), -- Art of Battle Axe
(18575, 4117, 2, 4, 0, 103958.362556), -- Art of Battle Axe Blade
(18575, 210, 1, 1, 0, 1414.518996), -- Staff of Evil Spirits
(18575, 4118, 1, 1, 0, 295484.094076), -- Evil Spirit Head
(18575, 7893, 1, 1, 0, 1414.518996), -- Kaim Vanul's Bones
(18575, 8340, 2, 6, 0, 77968.596244), -- Bones Head of Kaim Vanul
(18575, 7901, 1, 1, 0, 1414.518996), -- Star Buster
(18575, 8348, 3, 7, 0, 62270.456964), -- Star Buster Head
(18575, 171, 1, 1, 1, 2121.776835), -- Deadman's Glory
(18575, 4116, 1, 3, 1, 233900.73462), -- Deadman's Glory Stone
(18575, 175, 1, 1, 1, 2121.776835), -- Art of Battle Axe
(18575, 4117, 2, 4, 1, 155933.82308), -- Art of Battle Axe Blade
(18575, 210, 1, 1, 1, 2121.776835), -- Staff of Evil Spirits
(18575, 4118, 3, 9, 1, 73869.191515), -- Evil Spirit Head
(18575, 7893, 1, 1, 1, 2121.776835), -- Kaim Vanul's Bones
(18575, 8340, 2, 6, 1, 116950.36731), -- Bones Head of Kaim Vanul
(18575, 7901, 1, 1, 1, 2121.776835), -- Star Buster
(18575, 8348, 3, 7, 1, 93401.9993), -- Star Buster Head
(18575, 729, 1, 1, 2, 38549.863078), -- Scroll: Enchant Weapon (A-Grade)
(18575, 730, 1, 1, 2, 289124.136922), -- Scroll: Enchant Armor (A-Grade)
-- White Allosce
(18577, 6323, 1, 1, 0, 17972.441864), -- Sealed Phoenix Necklace
(18577, 6343, 14, 42, 0, 91949.975538), -- Sealed Phoenix Necklace Beads
(18577, 6324, 1, 1, 0, 23963.118339), -- Sealed Phoenix Earring
(18577, 6341, 9, 27, 0, 185027.559302), -- Sealed Phoenix Earring Gemstone
(18577, 6325, 1, 1, 0, 35944.471289), -- Sealed Phoenix Ring
(18577, 6345, 40, 120, 0, 57581.433668), -- Sealed Phoenix Ring Gemstone
(18577, 6323, 1, 1, 1, 26958.684584), -- Sealed Phoenix Necklace
(18577, 6343, 14, 42, 1, 137925.074778), -- Sealed Phoenix Necklace Beads
(18577, 6324, 1, 1, 1, 35944.706559), -- Sealed Phoenix Earring
(18577, 6341, 9, 27, 1, 277541.563262), -- Sealed Phoenix Earring Gemstone
(18577, 6325, 1, 1, 1, 53916.750509), -- Sealed Phoenix Ring
(18577, 6345, 40, 120, 1, 86372.220308), -- Sealed Phoenix Ring Gemstone
(18577, 729, 1, 1, 2, 39023.5099), -- Scroll: Enchant Weapon (A-Grade)
(18577, 730, 1, 1, 2, 292676.4901), -- Scroll: Enchant Armor (A-Grade)
-- Energy Seed - Water
(18678, 14016, 1, 2, 0, 1000000), -- Water Energy Compression Stone
-- Energy Seed - Fire
(18679, 14015, 1, 2, 0, 1000000), -- Fire Energy Compression Stone
-- Energy Seed - Wind
(18680, 14017, 1, 2, 0, 1000000), -- Wind Energy Compression Stone
-- Energy Seed - Earth
(18681, 14018, 1, 2, 0, 1000000), -- Earth Energy Compression Stone
-- Energy Seed - Holy
(18682, 14020, 1, 2, 0, 1000000), -- Holy Energy Compression Stone
-- Energy Seed - Dark
(18683, 14019, 1, 2, 0, 1000000), -- Dark Energy Compression Stone
-- Red Star Stone
(18684, 14009, 1, 2, 0, 1000000), -- Extracted Red Star Stone
-- Red Star Stone
(18685, 14009, 1, 2, 0, 1000000), -- Extracted Red Star Stone
-- Red Star Stone
(18686, 14009, 1, 2, 0, 1000000), -- Extracted Red Star Stone
-- Blue Star Stone
(18687, 14010, 1, 2, 0, 1000000), -- Extracted Blue Star Stone
-- Blue Star Stone
(18688, 14010, 1, 2, 0, 1000000), -- Extracted Blue Star Stone
-- Blue Star Stone
(18689, 14010, 1, 2, 0, 1000000), -- Extracted Blue Star Stone
-- Green Star Stone
(18690, 14011, 1, 2, 0, 1000000), -- Extracted Green Star Stone
-- Green Star Stone
(18691, 14011, 1, 2, 0, 1000000), -- Extracted Green Star Stone
-- Green Star Stone
(18692, 14011, 1, 2, 0, 1000000), -- Extracted Green Star Stone
-- Newborn Lavasaurus
(18799, 960, 1, 1, -1, 5298), -- Scroll: Enchant Armor (S-Grade)
(18799, 1894, 1, 1, -1, 464713), -- Crafted Leather
(18799, 9540, 1, 1, -1, 23694), -- Sealed Dynasty Tunic Piece
(18799, 57, 2420, 4913, 0, 700000), -- Adena
(18799, 6371, 1, 1, 1, 11.436396), -- Demon Splinter
(18799, 6695, 1, 1, 1, 5184.563604), -- Demon Splinter Blade
(18799, 9628, 1, 1, 2, 12784.656007), -- Leonard
(18799, 9630, 1, 1, 2, 8579.171442), -- Orichalcum
(18799, 9629, 1, 1, 2, 7087.172551), -- Adamantine
-- Fledgling Lavasaurus
(18800, 960, 1, 1, -1, 5298), -- Scroll: Enchant Armor (S-Grade)
(18800, 1894, 1, 1, -1, 464713), -- Crafted Leather
(18800, 9540, 1, 1, -1, 23694), -- Sealed Dynasty Tunic Piece
(18800, 57, 2420, 4913, 0, 700000), -- Adena
(18800, 6680, 1, 1, 1, 31.394825), -- Sealed Draconic Leather Armor
(18800, 6707, 1, 1, 1, 12113.605175), -- Sealed Draconic Leather Armor Part
(18800, 9628, 1, 1, 2, 12784.656007), -- Leonard
(18800, 9630, 1, 1, 2, 8579.171442), -- Orichalcum
(18800, 9629, 1, 1, 2, 7087.172551), -- Adamantine
-- Adult Lavasaurus
(18801, 960, 1, 1, -1, 5298), -- Scroll: Enchant Armor (S-Grade)
(18801, 1894, 1, 1, -1, 464713), -- Crafted Leather
(18801, 9540, 1, 1, -1, 23694), -- Sealed Dynasty Tunic Piece
(18801, 57, 2420, 4913, 0, 700000), -- Adena
(18801, 6370, 1, 1, 1, 11.436432), -- Saint Spear
(18801, 6694, 1, 1, 1, 5380.563568), -- Saint Spear Blade
(18801, 9628, 1, 1, 2, 12784.656007), -- Leonard
(18801, 9630, 1, 1, 2, 8579.171442), -- Orichalcum
(18801, 9629, 1, 1, 2, 7087.172551), -- Adamantine
-- Elderly Lavasaurus
(18802, 960, 1, 1, -1, 5448), -- Scroll: Enchant Armor (S-Grade)
(18802, 1894, 1, 1, -1, 477927), -- Crafted Leather
(18802, 9540, 1, 1, -1, 24368), -- Sealed Dynasty Tunic Piece
(18802, 57, 2540, 5000, 0, 700000), -- Adena
(18802, 6674, 1, 1, 1, 19.674879), -- Sealed Imperial Crusader Breastplate
(18802, 6675, 1, 1, 1, 31.470591), -- Sealed Imperial Crusader Gaiters
(18802, 6701, 1, 1, 1, 6692.638173), -- Sealed Imperial Crusader Breastplate Part
(18802, 6702, 1, 1, 1, 8615.216357), -- Sealed Imperial Crusader Gaiters Pattern
(18802, 9628, 1, 1, 2, 13148.18582), -- Leonard
(18802, 9630, 1, 1, 2, 8823.11892), -- Orichalcum
(18802, 9629, 1, 1, 2, 7288.69526), -- Adamantine
-- Ancient Lavasaurus
(18803, 960, 1, 1, -1, 5448), -- Scroll: Enchant Armor (S-Grade)
(18803, 1894, 1, 1, -1, 477927), -- Crafted Leather
(18803, 9540, 1, 1, -1, 24368), -- Sealed Dynasty Tunic Piece
(18803, 57, 2540, 5000, 0, 700000), -- Adena
(18803, 6674, 1, 1, 1, 19.674879), -- Sealed Imperial Crusader Breastplate
(18803, 6675, 1, 1, 1, 31.470591), -- Sealed Imperial Crusader Gaiters
(18803, 6701, 1, 1, 1, 6692.638173), -- Sealed Imperial Crusader Breastplate Part
(18803, 6702, 1, 1, 1, 8615.216357), -- Sealed Imperial Crusader Gaiters Pattern
(18803, 9628, 1, 1, 2, 13148.18582), -- Leonard
(18803, 9630, 1, 1, 2, 8823.11892), -- Orichalcum
(18803, 9629, 1, 1, 2, 7288.69526), -- Adamantine
-- Frightened Ragna Orc
(18807, 9544, 1, 1, -1, 4497), -- Sealed Dynasty Shoes Piece
(18807, 9630, 1, 1, -1, 4947), -- Orichalcum
(18807, 9619, 1, 1, -1, 526), -- Dynasty Bow Piece
(18807, 5311, 1, 1, 0, 2.630522), -- Sealed Armor of Nightmare
(18807, 5522, 1, 1, 0, 394.369478), -- Sealed Armor of Nightmare Pattern
(18807, 5316, 1, 1, 0, 2.630522), -- Sealed Majestic Plate Armor
(18807, 5523, 1, 1, 0, 394.369478), -- Sealed Majestic Plate Armor Pattern
(18807, 1879, 1, 1, 1, 12861.832924), -- Cokes
(18807, 1885, 1, 1, 1, 6430.916462), -- High-Grade Suede
(18807, 9628, 1, 1, 1, 605.272698), -- Leonard
(18807, 9630, 1, 1, 1, 406.161404), -- Orichalcum
(18807, 9629, 1, 1, 1, 335.518346), -- Adamantine
(18807, 5282, 1, 1, 1, 34.298166), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
-- Dark Shaman Varangka
(18808, 9628, 2, 6, 0, 59214.703296), -- Leonard
(18808, 9630, 3, 9, 0, 26490.574944), -- Orichalcum
(18808, 9629, 3, 9, 0, 18757.417344), -- Adamantine
(18808, 9573, 2, 6, 0, 41943.51168), -- Life Stone - Level 80
(18808, 9574, 1, 1, 0, 52429.3896), -- Mid-Grade Life Stone - Level 80
(18808, 9575, 1, 1, 0, 5243.141664), -- High-Grade Life Stone - Level 80
(18808, 9550, 1, 3, 0, 120797.39472), -- Dark Stone
(18808, 9551, 1, 3, 0, 80531.866752), -- Holy Stone
-- Chieftain's Treasure Chest
(18816, 9546, 1, 1, 0, 25050), -- Fire Stone
(18816, 9547, 1, 1, 0, 25050), -- Water Stone
(18816, 9548, 1, 1, 0, 25050), -- Earth Stone
(18816, 9549, 1, 1, 0, 25050), -- Wind Stone
(18816, 9550, 1, 1, 0, 24900), -- Dark Stone
(18816, 9551, 1, 1, 0, 24900), -- Holy Stone
-- Priest Ugoros
(18863, 57, 285165, 582813, 0, 700000), -- Adena
(18863, 10223, 1, 1, 1, 373.066462), -- Icarus Spitter
(18863, 10405, 1, 1, 1, 123692.933538), -- Icarus Spitter Piece
(18863, 1879, 135, 405, 2, 35731.17086), -- Cokes
(18863, 1885, 144, 432, 2, 16749.12722), -- High-Grade Suede
(18863, 9628, 3, 9, 2, 64856.87628), -- Leonard
(18863, 9630, 5, 15, 2, 30465.66334), -- Orichalcum
(18863, 9629, 5, 15, 2, 22879.15728), -- Adamantine
(18863, 10483, 4, 12, 2, 50247.03488), -- Life Stone - Level 82
(18863, 10484, 1, 1, 2, 100494.06976), -- Mid-Grade Life Stone - Level 82
(18863, 10485, 1, 1, 2, 10049.33762), -- High-Grade Life Stone - Level 82
(18863, 9554, 1, 1, 2, 11576.90352), -- Earth Crystal
(18863, 10381, 1, 1, 2, 3730.65924), -- Recipe - Icarus Spitter (60%)
-- Baby Alpine Kookaburra
(18873, 15772, 1, 1, -1, 13393), -- Sealed Moirai Ring Gem
(18873, 15773, 1, 1, -1, 7527), -- Sealed Moirai Earring Gem
(18873, 15774, 1, 1, -1, 6495), -- Sealed Moirai Necklace Gem
(18873, 15812, 1, 1, -1, 1772), -- Recipe - Sealed Moirai Ring (70%)
(18873, 15813, 1, 1, -1, 1181), -- Recipe - Sealed Moirai Earring (70%)
(18873, 15814, 1, 1, -1, 886), -- Recipe - Sealed Moirai Necklace (70%)
(18873, 57, 475, 959, 0, 700000), -- Adena
(18873, 15766, 1, 1, 1, 5.818546), -- Sealed Moirai Ring
(18873, 15767, 1, 1, 1, 3.877526), -- Sealed Moirai Earring
(18873, 15768, 1, 1, 1, 2.907016), -- Sealed Moirai Necklace
(18873, 15772, 1, 1, 1, 2199.058296), -- Sealed Moirai Ring Gem
(18873, 15773, 1, 1, 1, 1235.906116), -- Sealed Moirai Earring Gem
(18873, 15774, 1, 1, 1, 1066.4325), -- Sealed Moirai Necklace Gem
(18873, 9573, 1, 1, 2, 2214.118422), -- Life Stone - Level 80
(18873, 9574, 1, 1, 2, 553.528194), -- Mid-Grade Life Stone - Level 80
(18873, 9575, 1, 1, 2, 55.353384), -- High-Grade Life Stone - Level 80
-- Young Kookaburra
(18874, 15654, 1, 1, -1, 13628), -- Sealed Moirai Gauntlet Piece
(18874, 15655, 1, 1, -1, 13628), -- Sealed Moirai Leather Gloves Piece
(18874, 15656, 1, 1, -1, 13628), -- Sealed Moirai Gloves Piece
(18874, 15657, 1, 1, -1, 13628), -- Sealed Moirai Boots Piece
(18874, 15658, 1, 1, -1, 13628), -- Sealed Moirai Leather Boots Piece
(18874, 15659, 1, 1, -1, 13628), -- Sealed Moirai Shoes Piece
(18874, 15784, 1, 1, -1, 1813), -- Recipe - Sealed Moirai Gauntlet (60%)
(18874, 15785, 1, 1, -1, 1813), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18874, 15786, 1, 1, -1, 1813), -- Recipe - Sealed Moirai Gloves (60%)
(18874, 15787, 1, 1, -1, 1813), -- Recipe - Sealed Moirai Boots (60%)
(18874, 15788, 1, 1, -1, 1813), -- Recipe - Sealed Moirai Leather Boots (60%)
(18874, 15789, 1, 1, -1, 1813), -- Recipe - Sealed Moirai Shoes (60%)
(18874, 57, 1494, 3016, 0, 700000), -- Adena
(18874, 15703, 1, 1, 1, 11.90856), -- Sealed Moirai Gauntlet
(18874, 15704, 1, 1, 1, 11.90856), -- Sealed Moirai Leather Gloves
(18874, 15705, 1, 1, 1, 11.90856), -- Sealed Moirai Gloves
(18874, 15654, 1, 1, 1, 4473.433744), -- Sealed Moirai Gauntlet Piece
(18874, 15655, 1, 1, 1, 4473.433744), -- Sealed Moirai Leather Gloves Piece
(18874, 15656, 1, 1, 1, 4473.406832), -- Sealed Moirai Gloves Piece
(18874, 1895, 1, 1, 2, 107409.360588), -- Metallic Fiber
(18874, 4040, 1, 1, 2, 7518.687308), -- Mold Lubricant
(18874, 9628, 1, 1, 2, 2948.545938), -- Leonard
(18874, 9630, 1, 1, 2, 1978.647362), -- Orichalcum
(18874, 9573, 1, 1, 2, 2610.610778), -- Life Stone - Level 80
(18874, 9574, 1, 1, 2, 652.683528), -- Mid-Grade Life Stone - Level 80
(18874, 9575, 1, 1, 2, 65.243686), -- High-Grade Life Stone - Level 80
(18874, 960, 1, 1, 2, 150.220812), -- Scroll: Enchant Armor (S-Grade)
(18874, 10550, 1, 1, 2, 501), -- Forgotten Scroll - Protection of Elemental
(18874, 6622, 1, 1, 2, 1203), -- Giant's Codex
-- Adult Kookaburra
(18876, 15649, 1, 1, -1, 55084), -- Sealed Moirai Leather Breastplate Piece
(18876, 1894, 1, 1, -1, 602057), -- Crafted Leather
(18876, 15782, 1, 1, -1, 10871), -- Recipe - Sealed Moirai Leather Legging (60%)
(18876, 57, 4199, 8477, 0, 700000), -- Adena
(18876, 15698, 1, 1, 1, 33.4696), -- Sealed Moirai Leather Breastplate
(18876, 15649, 1, 1, 1, 13566.5304), -- Sealed Moirai Leather Breastplate Piece
(18876, 1879, 1, 1, 2, 100624.99375), -- Cokes
(18876, 1885, 1, 1, 2, 50312.395), -- High-Grade Suede
(18876, 9628, 1, 1, 2, 4735.35375), -- Leonard
(18876, 9630, 1, 1, 2, 3177.685), -- Orichalcum
(18876, 9629, 1, 1, 2, 2624.91125), -- Adamantine
(18876, 5550, 1, 1, 2, 8049.95875), -- Durable Metal Plate
(18876, 1890, 1, 1, 2, 9217.44625), -- Mithril Alloy
(18876, 1888, 1, 1, 2, 18295.5275), -- Synthetic Cokes
(18876, 17030, 1, 1, 2, 1006.32125), -- Forgotten Scroll - Create Item Lv 10
(18876, 9555, 1, 1, 2, 120.82375), -- Wind Crystal
(18876, 10483, 1, 1, 2, 4192.7675), -- Life Stone - Level 82
(18876, 10484, 1, 1, 2, 1048.09), -- Mid-Grade Life Stone - Level 82
(18876, 10485, 1, 1, 2, 104.7275), -- High-Grade Life Stone - Level 82
(18876, 15779, 1, 1, 2, 238.99875), -- Recipe - Sealed Moirai Leather Breastplate (60%)
(18876, 10549, 1, 1, 2, 9392), -- Forgotten Scroll - Protection of Rune
(18876, 6622, 1, 1, 2, 2254), -- Giant's Codex
-- Full Grown Kookaburra
(18878, 10397, 1, 1, -1, 2321), -- Icarus Sawsword Piece
(18878, 10399, 1, 1, -1, 2321), -- Icarus Spirit Piece
(18878, 10400, 1, 1, -1, 2313), -- Icarus Heavy Arms Piece
(18878, 9628, 1, 1, -1, 42455), -- Leonard
(18878, 10373, 1, 1, -1, 349), -- Recipe - Icarus Sawsword (60%)
(18878, 10375, 1, 1, -1, 349), -- Recipe - Icarus Spirit (60%)
(18878, 10376, 1, 1, -1, 349), -- Recipe - Icarus Heavy Arms (60%)
(18878, 15801, 1, 1, -1, 4640), -- Recipe - Sealed Vesper Gauntlet (60%)
(18878, 15802, 1, 1, -1, 4640), -- Recipe - Sealed Vesper Leather Gloves (60%)
(18878, 15803, 1, 1, -1, 4640), -- Recipe - Sealed Vesper Gloves (60%)
(18878, 57, 4416, 8914, 0, 700000), -- Adena
(18878, 10215, 1, 1, 1, 1.145718), -- Icarus Sawsword
(18878, 10217, 1, 1, 1, 1.145718), -- Icarus Spirit
(18878, 10397, 1, 1, 1, 380.590546), -- Icarus Sawsword Piece
(18878, 10399, 1, 1, 1, 380.590546), -- Icarus Spirit Piece
(18878, 14109, 1, 1, 1, 15.212589), -- Sealed Vesper Gauntlet
(18878, 14113, 1, 1, 1, 15.212589), -- Sealed Vesper Leather Gloves
(18878, 14116, 1, 1, 1, 15.212589), -- Sealed Vesper Gloves
(18878, 15667, 1, 1, 1, 6802.615757), -- Sealed Vesper Gauntlet Piece
(18878, 15671, 1, 1, 1, 6802.615757), -- Sealed Vesper Leather Gloves Piece
(18878, 15674, 1, 1, 1, 6802.658191), -- Sealed Vesper Gloves Piece
(18878, 1879, 1, 1, 2, 105812.854197), -- Cokes
(18878, 1885, 1, 1, 2, 52906.320585), -- High-Grade Suede
(18878, 9628, 1, 1, 2, 4979.506125), -- Leonard
(18878, 9630, 1, 1, 2, 3341.541522), -- Orichalcum
(18878, 9629, 1, 1, 2, 2760.403866), -- Adamantine
(18878, 5550, 1, 1, 2, 8465.053899), -- Durable Metal Plate
(18878, 1890, 1, 1, 2, 9692.7285), -- Mithril Alloy
(18878, 1888, 1, 1, 2, 19238.681397), -- Synthetic Cokes
(18878, 10483, 1, 1, 2, 4408.806792), -- Life Stone - Level 82
(18878, 10484, 1, 1, 2, 1102.201698), -- Mid-Grade Life Stone - Level 82
(18878, 10485, 1, 1, 2, 110.134959), -- High-Grade Life Stone - Level 82
(18878, 10373, 1, 1, 2, 40.901184), -- Recipe - Icarus Sawsword (60%)
(18878, 10375, 1, 1, 2, 40.901184), -- Recipe - Icarus Spirit (60%)
(18878, 9553, 1, 1, 2, 126.964092), -- Water Crystal
-- Baby Alpine Cougar
(18880, 15772, 1, 1, -1, 13393), -- Sealed Moirai Ring Gem
(18880, 15773, 1, 1, -1, 7527), -- Sealed Moirai Earring Gem
(18880, 15774, 1, 1, -1, 6495), -- Sealed Moirai Necklace Gem
(18880, 15812, 1, 1, -1, 1772), -- Recipe - Sealed Moirai Ring (70%)
(18880, 15813, 1, 1, -1, 1181), -- Recipe - Sealed Moirai Earring (70%)
(18880, 15814, 1, 1, -1, 886), -- Recipe - Sealed Moirai Necklace (70%)
(18880, 57, 475, 959, 0, 700000), -- Adena
(18880, 15766, 1, 1, 1, 5.818546), -- Sealed Moirai Ring
(18880, 15767, 1, 1, 1, 3.877526), -- Sealed Moirai Earring
(18880, 15768, 1, 1, 1, 2.907016), -- Sealed Moirai Necklace
(18880, 15772, 1, 1, 1, 2199.058296), -- Sealed Moirai Ring Gem
(18880, 15773, 1, 1, 1, 1235.906116), -- Sealed Moirai Earring Gem
(18880, 15774, 1, 1, 1, 1066.4325), -- Sealed Moirai Necklace Gem
(18880, 9573, 1, 1, 2, 2214.118422), -- Life Stone - Level 80
(18880, 9574, 1, 1, 2, 553.528194), -- Mid-Grade Life Stone - Level 80
(18880, 9575, 1, 1, 2, 55.353384), -- High-Grade Life Stone - Level 80
-- Young Cougar
(18881, 15654, 1, 1, -1, 12579), -- Sealed Moirai Gauntlet Piece
(18881, 15655, 1, 1, -1, 12579), -- Sealed Moirai Leather Gloves Piece
(18881, 15656, 1, 1, -1, 12579), -- Sealed Moirai Gloves Piece
(18881, 15657, 1, 1, -1, 12579), -- Sealed Moirai Boots Piece
(18881, 15658, 1, 1, -1, 12579), -- Sealed Moirai Leather Boots Piece
(18881, 15659, 1, 1, -1, 12579), -- Sealed Moirai Shoes Piece
(18881, 960, 1, 1, -1, 564), -- Scroll: Enchant Armor (S-Grade)
(18881, 15784, 1, 1, -1, 1674), -- Recipe - Sealed Moirai Gauntlet (60%)
(18881, 15785, 1, 1, -1, 1674), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18881, 15786, 1, 1, -1, 1674), -- Recipe - Sealed Moirai Gloves (60%)
(18881, 15787, 1, 1, -1, 1674), -- Recipe - Sealed Moirai Boots (60%)
(18881, 15788, 1, 1, -1, 1674), -- Recipe - Sealed Moirai Leather Boots (60%)
(18881, 15789, 1, 1, -1, 1674), -- Recipe - Sealed Moirai Shoes (60%)
(18881, 57, 1494, 3016, 0, 700000), -- Adena
(18881, 15706, 1, 1, 1, 11.90856), -- Sealed Moirai Boots
(18881, 15707, 1, 1, 1, 11.90856), -- Sealed Moirai Leather Boots
(18881, 15708, 1, 1, 1, 11.90856), -- Sealed Moirai Shoes
(18881, 15657, 1, 1, 1, 4473.433744), -- Sealed Moirai Boots Piece
(18881, 15658, 1, 1, 1, 4473.433744), -- Sealed Moirai Leather Boots Piece
(18881, 15659, 1, 1, 1, 4473.406832), -- Sealed Moirai Shoes Piece
(18881, 1895, 1, 1, 2, 107409.360588), -- Metallic Fiber
(18881, 4040, 1, 1, 2, 7518.687308), -- Mold Lubricant
(18881, 9628, 1, 1, 2, 2948.545938), -- Leonard
(18881, 9630, 1, 1, 2, 1978.647362), -- Orichalcum
(18881, 9573, 1, 1, 2, 2610.610778), -- Life Stone - Level 80
(18881, 9574, 1, 1, 2, 652.683528), -- Mid-Grade Life Stone - Level 80
(18881, 9575, 1, 1, 2, 65.243686), -- High-Grade Life Stone - Level 80
(18881, 960, 1, 1, 2, 150.220812), -- Scroll: Enchant Armor (S-Grade)
(18881, 10550, 1, 1, 2, 501), -- Forgotten Scroll - Protection of Elemental
(18881, 6622, 1, 1, 2, 1203), -- Giant's Codex
-- Adult Cougar
(18883, 15648, 1, 1, -1, 20354), -- Sealed Moirai Breastplate Piece
(18883, 15651, 1, 1, -1, 34113), -- Sealed Moirai Gaiter Piece
(18883, 959, 1, 1, -1, 343), -- Scroll: Enchant Weapon (S-Grade)
(18883, 9630, 1, 1, -1, 45154), -- Orichalcum
(18883, 15778, 1, 1, -1, 2548), -- Recipe - Sealed Moirai Breastplate (60%)
(18883, 15781, 1, 1, -1, 4076), -- Recipe - Sealed Moirai Gaiter (60%)
(18883, 57, 4199, 8477, 0, 700000), -- Adena
(18883, 15697, 1, 1, 1, 25.102341), -- Sealed Moirai Breastplate
(18883, 15648, 1, 1, 1, 10027.897659), -- Sealed Moirai Breastplate Piece
(18883, 1879, 1, 1, 2, 100625.187219), -- Cokes
(18883, 1885, 1, 1, 2, 50312.695455), -- High-Grade Suede
(18883, 9628, 1, 1, 2, 4735.408368), -- Leonard
(18883, 9630, 1, 1, 2, 3177.5796), -- Orichalcum
(18883, 9629, 1, 1, 2, 2624.965917), -- Adamantine
(18883, 5550, 1, 1, 2, 8050.072011), -- Durable Metal Plate
(18883, 1890, 1, 1, 2, 9217.628823), -- Mithril Alloy
(18883, 1888, 1, 1, 2, 18295.52562), -- Synthetic Cokes
(18883, 17030, 1, 1, 2, 1006.23354), -- Forgotten Scroll - Create Item Lv 10
(18883, 9555, 1, 1, 2, 120.788763), -- Wind Crystal
(18883, 10483, 1, 1, 2, 4192.775544), -- Life Stone - Level 82
(18883, 10484, 1, 1, 2, 1048.193886), -- Mid-Grade Life Stone - Level 82
(18883, 10485, 1, 1, 2, 104.900865), -- High-Grade Life Stone - Level 82
(18883, 15778, 1, 1, 2, 179.044389), -- Recipe - Sealed Moirai Breastplate (60%)
(18883, 10549, 1, 1, 2, 9392), -- Forgotten Scroll - Protection of Rune
(18883, 6622, 1, 1, 2, 2254), -- Giant's Codex
-- Full Grown Cougar
(18885, 10404, 1, 1, -1, 2892), -- Icarus Hall Piece
(18885, 10402, 1, 1, -1, 2892), -- Icarus Hammer Piece
(18885, 9628, 1, 1, -1, 53068), -- Leonard
(18885, 10380, 1, 1, -1, 436), -- Recipe - Icarus Hall (60%)
(18885, 10378, 1, 1, -1, 436), -- Recipe - Icarus Hammer (60%)
(18885, 15804, 1, 1, -1, 5799), -- Recipe - Sealed Vesper Boots (60%)
(18885, 15805, 1, 1, -1, 5799), -- Recipe - Sealed Vesper Leather Boots (60%)
(18885, 15806, 1, 1, -1, 5799), -- Recipe - Sealed Vesper Shoes (60%)
(18885, 57, 4416, 8914, 0, 700000), -- Adena
(18885, 10222, 1, 1, 1, 1.432145), -- Icarus Hall
(18885, 10404, 1, 1, 1, 474.144151), -- Icarus Hall Piece
(18885, 14110, 1, 1, 1, 19.00847), -- Sealed Vesper Boots
(18885, 14114, 1, 1, 1, 19.00847), -- Sealed Vesper Leather Boots
(18885, 14117, 1, 1, 1, 19.00847), -- Sealed Vesper Shoes
(18885, 15668, 1, 1, 1, 8502.124085), -- Sealed Vesper Boots Piece
(18885, 15672, 1, 1, 1, 8502.124085), -- Sealed Vesper Leather Boots Piece
(18885, 15675, 1, 1, 1, 8502.150124), -- Sealed Vesper Shoes Piece
(18885, 1879, 1, 1, 2, 113952.39222), -- Cokes
(18885, 1885, 1, 1, 2, 56976.19611), -- High-Grade Suede
(18885, 9628, 1, 1, 2, 5362.44123), -- Leonard
(18885, 9630, 1, 1, 2, 3598.58593), -- Orichalcum
(18885, 9629, 1, 1, 2, 2972.6352), -- Adamantine
(18885, 5550, 1, 1, 2, 9116.08128), -- Durable Metal Plate
(18885, 1890, 1, 1, 2, 10438.39933), -- Mithril Alloy
(18885, 1888, 1, 1, 2, 20718.53336), -- Synthetic Cokes
(18885, 10483, 1, 1, 2, 4747.959), -- Life Stone - Level 82
(18885, 10484, 1, 1, 2, 1186.98975), -- Mid-Grade Life Stone - Level 82
(18885, 10485, 1, 1, 2, 118.81366), -- High-Grade Life Stone - Level 82
(18885, 10380, 1, 1, 2, 44.03904), -- Recipe - Icarus Hall (60%)
(18885, 9553, 1, 1, 2, 136.93389), -- Water Crystal
-- Baby Alpine Buffalo
(18887, 15772, 1, 1, -1, 14529), -- Sealed Moirai Ring Gem
(18887, 15773, 1, 1, -1, 8165), -- Sealed Moirai Earring Gem
(18887, 15774, 1, 1, -1, 7046), -- Sealed Moirai Necklace Gem
(18887, 15812, 1, 1, -1, 1922), -- Recipe - Sealed Moirai Ring (70%)
(18887, 15813, 1, 1, -1, 1281), -- Recipe - Sealed Moirai Earring (70%)
(18887, 15814, 1, 1, -1, 961), -- Recipe - Sealed Moirai Necklace (70%)
(18887, 57, 511, 1045, 0, 700000), -- Adena
(18887, 15766, 1, 1, 1, 6.312233), -- Sealed Moirai Ring
(18887, 15767, 1, 1, 1, 4.206523), -- Sealed Moirai Earring
(18887, 15768, 1, 1, 1, 3.153668), -- Sealed Moirai Necklace
(18887, 15772, 1, 1, 1, 2385.642108), -- Sealed Moirai Ring Gem
(18887, 15773, 1, 1, 1, 1340.769218), -- Sealed Moirai Earring Gem
(18887, 15774, 1, 1, 1, 1156.91625), -- Sealed Moirai Necklace Gem
(18887, 9573, 1, 1, 2, 1200.99072), -- Life Stone - Level 80
(18887, 9574, 1, 1, 2, 300.24768), -- Mid-Grade Life Stone - Level 80
(18887, 9575, 1, 1, 2, 30.024325), -- High-Grade Life Stone - Level 80
(18887, 15812, 1, 1, 2, 315.58877), -- Recipe - Sealed Moirai Ring (70%)
(18887, 15813, 1, 1, 2, 210.36741), -- Recipe - Sealed Moirai Earring (70%)
(18887, 15814, 1, 1, 2, 157.781095), -- Recipe - Sealed Moirai Necklace (70%)
-- Young Buffalo
(18888, 15654, 1, 1, -1, 13453), -- Sealed Moirai Gauntlet Piece
(18888, 15655, 1, 1, -1, 13453), -- Sealed Moirai Leather Gloves Piece
(18888, 15656, 1, 1, -1, 13453), -- Sealed Moirai Gloves Piece
(18888, 15657, 1, 1, -1, 13453), -- Sealed Moirai Boots Piece
(18888, 15658, 1, 1, -1, 13453), -- Sealed Moirai Leather Boots Piece
(18888, 15659, 1, 1, -1, 13453), -- Sealed Moirai Shoes Piece
(18888, 960, 1, 1, -1, 603), -- Scroll: Enchant Armor (S-Grade)
(18888, 15784, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Gauntlet (60%)
(18888, 15785, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18888, 15786, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Gloves (60%)
(18888, 15787, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Boots (60%)
(18888, 15788, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Leather Boots (60%)
(18888, 15789, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Shoes (60%)
(18888, 57, 1585, 3238, 0, 700000), -- Adena
(18888, 15703, 1, 1, 1, 12.736035), -- Sealed Moirai Gauntlet
(18888, 15704, 1, 1, 1, 12.736035), -- Sealed Moirai Leather Gloves
(18888, 15705, 1, 1, 1, 12.736035), -- Sealed Moirai Gloves
(18888, 15654, 1, 1, 1, 4784.273559), -- Sealed Moirai Gauntlet Piece
(18888, 15655, 1, 1, 1, 4784.273559), -- Sealed Moirai Leather Gloves Piece
(18888, 15656, 1, 1, 1, 4784.244777), -- Sealed Moirai Gloves Piece
(18888, 1895, 1, 1, 2, 70689.89797), -- Metallic Fiber
(18888, 4040, 1, 1, 2, 4948.314395), -- Mold Lubricant
(18888, 9628, 1, 1, 2, 1940.49271), -- Leonard
(18888, 9630, 1, 1, 2, 1302.1662), -- Orichalcum
(18888, 9573, 1, 1, 2, 1718.16357), -- Life Stone - Level 80
(18888, 9574, 1, 1, 2, 429.499475), -- Mid-Grade Life Stone - Level 80
(18888, 9575, 1, 1, 2, 42.991365), -- High-Grade Life Stone - Level 80
(18888, 15784, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Gauntlet (60%)
(18888, 15785, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18888, 15786, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Gloves (60%)
(18888, 15787, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Boots (60%)
(18888, 15788, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Leather Boots (60%)
(18888, 15789, 1, 1, 2, 293.981415), -- Recipe - Sealed Moirai Shoes (60%)
(18888, 10552, 1, 1, 2, 357), -- Forgotten Scroll - Fighter's Will
(18888, 6622, 1, 1, 2, 858), -- Giant's Codex
-- Adult Buffalo
(18890, 15653, 1, 1, -1, 95975), -- Sealed Moirai Stockings Piece
(18890, 959, 1, 1, -1, 737), -- Scroll: Enchant Weapon (S-Grade)
(18890, 15783, 1, 1, -1, 11675), -- Recipe - Sealed Moirai Stockings (60%)
(18890, 57, 4472, 9140, 0, 700000), -- Adena
(18890, 15699, 1, 1, 1, 35.942905), -- Sealed Moirai Tunic
(18890, 15650, 1, 1, 1, 14569.057095), -- Sealed Moirai Tunic Piece
(18890, 1879, 1, 1, 2, 108064.57611), -- Cokes
(18890, 1885, 1, 1, 2, 54032.178648), -- High-Grade Suede
(18890, 9628, 1, 1, 2, 5085.456174), -- Leonard
(18890, 9630, 1, 1, 2, 3412.623144), -- Orichalcum
(18890, 9629, 1, 1, 2, 2818.980762), -- Adamantine
(18890, 5550, 1, 1, 2, 8645.122326), -- Durable Metal Plate
(18890, 1890, 1, 1, 2, 9898.926546), -- Mithril Alloy
(18890, 1888, 1, 1, 2, 19648.184316), -- Synthetic Cokes
(18890, 17030, 1, 1, 2, 1080.722346), -- Forgotten Scroll - Create Item Lv 10
(18890, 9556, 1, 1, 2, 129.756702), -- Dark Crystal
(18890, 10483, 1, 1, 2, 4502.754492), -- Life Stone - Level 82
(18890, 10484, 1, 1, 2, 1125.579216), -- Mid-Grade Life Stone - Level 82
(18890, 10485, 1, 1, 2, 112.470396), -- High-Grade Life Stone - Level 82
(18890, 15780, 1, 1, 2, 256.668822), -- Recipe - Sealed Moirai Tunic (60%)
(18890, 10552, 1, 1, 2, 10086), -- Forgotten Scroll - Fighter's Will
(18890, 6622, 1, 1, 2, 2421), -- Giant's Codex
-- Full Grown Buffalo
(18892, 10403, 1, 1, -1, 6197), -- Icarus Hand Piece
(18892, 1894, 1, 1, -1, 508785), -- Crafted Leather
(18892, 10379, 1, 1, -1, 935), -- Recipe - Icarus Hand (60%)
(18892, 15819, 1, 1, -1, 1011), -- Recipe - Vesper Fighter (60%)
(18892, 57, 4692, 9589, 0, 700000), -- Adena
(18892, 10221, 1, 1, 1, 2.455272), -- Icarus Hand
(18892, 10403, 1, 1, 1, 814.193856), -- Icarus Hand Piece
(18892, 13457, 1, 1, 1, 2.657448), -- Vesper Cutter
(18892, 13461, 1, 1, 1, 2.657448), -- Vesper Fighter
(18892, 15638, 1, 1, 1, 1122.035976), -- Vesper Fighter Piece
(18892, 1879, 1, 1, 2, 132278.345098), -- Cokes
(18892, 1885, 1, 1, 2, 66139.172549), -- High-Grade Suede
(18892, 9628, 1, 1, 2, 6224.853907), -- Leonard
(18892, 9630, 1, 1, 2, 4177.222102), -- Orichalcum
(18892, 9629, 1, 1, 2, 3450.771832), -- Adamantine
(18892, 5550, 1, 1, 2, 10582.225032), -- Durable Metal Plate
(18892, 1890, 1, 1, 2, 12117.084064), -- Mithril Alloy
(18892, 1888, 1, 1, 2, 24050.559818), -- Synthetic Cokes
(18892, 10483, 1, 1, 2, 5511.708587), -- Life Stone - Level 82
(18892, 10484, 1, 1, 2, 1377.860622), -- Mid-Grade Life Stone - Level 82
(18892, 10485, 1, 1, 2, 137.839282), -- High-Grade Life Stone - Level 82
(18892, 10379, 1, 1, 2, 51.357107), -- Recipe - Icarus Hand (60%)
-- Baby Alpine Grendel
(18894, 15772, 1, 1, -1, 14529), -- Sealed Moirai Ring Gem
(18894, 15773, 1, 1, -1, 8165), -- Sealed Moirai Earring Gem
(18894, 15774, 1, 1, -1, 7046), -- Sealed Moirai Necklace Gem
(18894, 15812, 1, 1, -1, 1922), -- Recipe - Sealed Moirai Ring (70%)
(18894, 15813, 1, 1, -1, 1281), -- Recipe - Sealed Moirai Earring (70%)
(18894, 15814, 1, 1, -1, 961), -- Recipe - Sealed Moirai Necklace (70%)
(18894, 57, 511, 1045, 0, 700000), -- Adena
(18894, 15766, 1, 1, 1, 6.312233), -- Sealed Moirai Ring
(18894, 15767, 1, 1, 1, 4.206523), -- Sealed Moirai Earring
(18894, 15768, 1, 1, 1, 3.153668), -- Sealed Moirai Necklace
(18894, 15772, 1, 1, 1, 2385.642108), -- Sealed Moirai Ring Gem
(18894, 15773, 1, 1, 1, 1340.769218), -- Sealed Moirai Earring Gem
(18894, 15774, 1, 1, 1, 1156.91625), -- Sealed Moirai Necklace Gem
(18894, 9573, 1, 1, 2, 1200.99072), -- Life Stone - Level 80
(18894, 9574, 1, 1, 2, 300.24768), -- Mid-Grade Life Stone - Level 80
(18894, 9575, 1, 1, 2, 30.024325), -- High-Grade Life Stone - Level 80
(18894, 15812, 1, 1, 2, 315.58877), -- Recipe - Sealed Moirai Ring (70%)
(18894, 15813, 1, 1, 2, 210.36741), -- Recipe - Sealed Moirai Earring (70%)
(18894, 15814, 1, 1, 2, 157.781095), -- Recipe - Sealed Moirai Necklace (70%)
-- Young Grendel
(18895, 15654, 1, 1, -1, 13453), -- Sealed Moirai Gauntlet Piece
(18895, 15655, 1, 1, -1, 13453), -- Sealed Moirai Leather Gloves Piece
(18895, 15656, 1, 1, -1, 13453), -- Sealed Moirai Gloves Piece
(18895, 15657, 1, 1, -1, 13453), -- Sealed Moirai Boots Piece
(18895, 15658, 1, 1, -1, 13453), -- Sealed Moirai Leather Boots Piece
(18895, 15659, 1, 1, -1, 13453), -- Sealed Moirai Shoes Piece
(18895, 960, 1, 1, -1, 603), -- Scroll: Enchant Armor (S-Grade)
(18895, 15784, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Gauntlet (60%)
(18895, 15785, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18895, 15786, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Gloves (60%)
(18895, 15787, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Boots (60%)
(18895, 15788, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Leather Boots (60%)
(18895, 15789, 1, 1, -1, 1790), -- Recipe - Sealed Moirai Shoes (60%)
(18895, 57, 1585, 3238, 0, 700000), -- Adena
(18895, 15706, 1, 1, 1, 12.736035), -- Sealed Moirai Boots
(18895, 15707, 1, 1, 1, 12.736035), -- Sealed Moirai Leather Boots
(18895, 15708, 1, 1, 1, 12.736035), -- Sealed Moirai Shoes
(18895, 15657, 1, 1, 1, 4784.273559), -- Sealed Moirai Boots Piece
(18895, 15658, 1, 1, 1, 4784.273559), -- Sealed Moirai Leather Boots Piece
(18895, 15659, 1, 1, 1, 4784.244777), -- Sealed Moirai Shoes Piece
(18895, 1895, 1, 1, 2, 70689.89797), -- Metallic Fiber
(18895, 4040, 1, 1, 2, 4948.314395), -- Mold Lubricant
(18895, 9628, 1, 1, 2, 1940.49271), -- Leonard
(18895, 9630, 1, 1, 2, 1302.1662), -- Orichalcum
(18895, 9573, 1, 1, 2, 1718.16357), -- Life Stone - Level 80
(18895, 9574, 1, 1, 2, 429.499475), -- Mid-Grade Life Stone - Level 80
(18895, 9575, 1, 1, 2, 42.991365), -- High-Grade Life Stone - Level 80
(18895, 15784, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Gauntlet (60%)
(18895, 15785, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18895, 15786, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Gloves (60%)
(18895, 15787, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Boots (60%)
(18895, 15788, 1, 1, 2, 293.89858), -- Recipe - Sealed Moirai Leather Boots (60%)
(18895, 15789, 1, 1, 2, 293.981415), -- Recipe - Sealed Moirai Shoes (60%)
(18895, 10552, 1, 1, 2, 357), -- Forgotten Scroll - Fighter's Will
(18895, 6622, 1, 1, 2, 858), -- Giant's Codex
-- Adult Grendel
(18897, 10398, 1, 1, -1, 7900), -- Icarus Disperser Piece
(18897, 959, 1, 1, -1, 737), -- Scroll: Enchant Weapon (S-Grade)
(18897, 10374, 1, 1, -1, 1188), -- Recipe - Icarus Disperser (60%)
(18897, 57, 4472, 9140, 0, 700000), -- Adena
(18897, 10216, 1, 1, 1, 5.849098), -- Icarus Disperser
(18897, 10398, 1, 1, 1, 1945.150902), -- Icarus Disperser Piece
(18897, 1879, 1, 1, 2, 108064.41565), -- Cokes
(18897, 1885, 1, 1, 2, 54032.207825), -- High-Grade Suede
(18897, 9628, 1, 1, 2, 5085.487136), -- Leonard
(18897, 9630, 1, 1, 2, 3412.548989), -- Orichalcum
(18897, 9629, 1, 1, 2, 2819.052704), -- Adamantine
(18897, 5550, 1, 1, 2, 8645.153252), -- Durable Metal Plate
(18897, 1890, 1, 1, 2, 9899.037116), -- Mithril Alloy
(18897, 1888, 1, 1, 2, 19648.115318), -- Synthetic Cokes
(18897, 17030, 1, 1, 2, 1080.753456), -- Forgotten Scroll - Create Item Lv 10
(18897, 9556, 1, 1, 2, 129.629207), -- Dark Crystal
(18897, 10483, 1, 1, 2, 4502.702202), -- Life Stone - Level 82
(18897, 10484, 1, 1, 2, 1125.566251), -- Mid-Grade Life Stone - Level 82
(18897, 10485, 1, 1, 2, 112.578485), -- High-Grade Life Stone - Level 82
(18897, 10374, 1, 1, 2, 41.752409), -- Recipe - Icarus Disperser (60%)
(18897, 10552, 1, 1, 2, 10086), -- Forgotten Scroll - Fighter's Will
(18897, 6622, 1, 1, 2, 2421), -- Giant's Codex
-- Full Grown Grendel
(18899, 10405, 1, 1, -1, 4957), -- Icarus Spitter Piece
(18899, 1894, 1, 1, -1, 407028), -- Crafted Leather
(18899, 9628, 1, 1, -1, 90983), -- Leonard
(18899, 10381, 1, 1, -1, 748), -- Recipe - Icarus Spitter (60%)
(18899, 15825, 1, 1, -1, 809), -- Recipe - Vesper Thrower (60%)
(18899, 57, 4692, 9589, 0, 700000), -- Adena
(18899, 10223, 1, 1, 1, 3.069664), -- Icarus Spitter
(18899, 10405, 1, 1, 1, 1017.466528), -- Icarus Spitter Piece
(18899, 13467, 1, 1, 1, 3.321396), -- Vesper Thrower
(18899, 15644, 1, 1, 1, 1420.142412), -- Vesper Thrower Piece
(18899, 1879, 1, 1, 2, 132278.345098), -- Cokes
(18899, 1885, 1, 1, 2, 66139.172549), -- High-Grade Suede
(18899, 9628, 1, 1, 2, 6224.853907), -- Leonard
(18899, 9630, 1, 1, 2, 4177.222102), -- Orichalcum
(18899, 9629, 1, 1, 2, 3450.771832), -- Adamantine
(18899, 5550, 1, 1, 2, 10582.225032), -- Durable Metal Plate
(18899, 1890, 1, 1, 2, 12117.084064), -- Mithril Alloy
(18899, 1888, 1, 1, 2, 24050.559818), -- Synthetic Cokes
(18899, 10483, 1, 1, 2, 5511.708587), -- Life Stone - Level 82
(18899, 10484, 1, 1, 2, 1377.860622), -- Mid-Grade Life Stone - Level 82
(18899, 10485, 1, 1, 2, 137.839282), -- High-Grade Life Stone - Level 82
(18899, 10381, 1, 1, 2, 51.357107), -- Recipe - Icarus Spitter (60%)
-- Farm Bandit
(18906, 15654, 1, 1, -1, 5826), -- Sealed Moirai Gauntlet Piece
(18906, 15655, 1, 1, -1, 5826), -- Sealed Moirai Leather Gloves Piece
(18906, 15656, 1, 1, -1, 5826), -- Sealed Moirai Gloves Piece
(18906, 15657, 1, 1, -1, 5826), -- Sealed Moirai Boots Piece
(18906, 15658, 1, 1, -1, 5826), -- Sealed Moirai Leather Boots Piece
(18906, 15659, 1, 1, -1, 5826), -- Sealed Moirai Shoes Piece
(18906, 9630, 1, 1, -1, 3434), -- Orichalcum
(18906, 15784, 1, 1, -1, 775), -- Recipe - Sealed Moirai Gauntlet (60%)
(18906, 15785, 1, 1, -1, 775), -- Recipe - Sealed Moirai Leather Gloves (60%)
(18906, 15786, 1, 1, -1, 775), -- Recipe - Sealed Moirai Gloves (60%)
(18906, 15787, 1, 1, -1, 775), -- Recipe - Sealed Moirai Boots (60%)
(18906, 15788, 1, 1, -1, 775), -- Recipe - Sealed Moirai Leather Boots (60%)
(18906, 15789, 1, 1, -1, 775), -- Recipe - Sealed Moirai Shoes (60%)
(18906, 57, 686, 1402, 0, 700000), -- Adena
(18906, 15703, 1, 1, 1, 2.757638), -- Sealed Moirai Gauntlet
(18906, 15704, 1, 1, 1, 2.757638), -- Sealed Moirai Leather Gloves
(18906, 15705, 1, 1, 1, 2.757638), -- Sealed Moirai Gloves
(18906, 15706, 1, 1, 1, 2.757638), -- Sealed Moirai Boots
(18906, 15707, 1, 1, 1, 2.757638), -- Sealed Moirai Leather Boots
(18906, 15708, 1, 1, 1, 2.757638), -- Sealed Moirai Shoes
(18906, 15654, 1, 1, 1, 1037.071536), -- Sealed Moirai Gauntlet Piece
(18906, 15655, 1, 1, 1, 1037.071536), -- Sealed Moirai Leather Gloves Piece
(18906, 15656, 1, 1, 1, 1037.071536), -- Sealed Moirai Gloves Piece
(18906, 15657, 1, 1, 1, 1037.071536), -- Sealed Moirai Boots Piece
(18906, 15658, 1, 1, 1, 1037.071536), -- Sealed Moirai Leather Boots Piece
(18906, 15659, 1, 1, 1, 1037.096492), -- Sealed Moirai Shoes Piece
(18906, 1879, 1, 1, 2, 29016.503055), -- Cokes
(18906, 1885, 1, 1, 2, 14508.227475), -- High-Grade Suede
(18906, 9628, 1, 1, 2, 1365.460425), -- Leonard
(18906, 9630, 1, 1, 2, 916.30404), -- Orichalcum
(18906, 9629, 1, 1, 2, 756.932175), -- Adamantine
(18906, 10483, 1, 1, 2, 1209.022965), -- Life Stone - Level 82
(18906, 10484, 1, 1, 2, 302.243715), -- Mid-Grade Life Stone - Level 82
(18906, 10485, 1, 1, 2, 30.30615), -- High-Grade Life Stone - Level 82
(18906, 6622, 1, 1, 2, 619), -- Giant's Codex
-- Beast Devourer
(18907, 15645, 1, 1, -1, 5317), -- Sealed Moirai Helmet Piece
(18907, 15646, 1, 1, -1, 5317), -- Sealed Moirai Leather Helmet Piece
(18907, 15647, 1, 1, -1, 5317), -- Sealed Moirai Circlet Piece
(18907, 15693, 1, 1, -1, 9532), -- Sealed Moirai Shield Piece
(18907, 15692, 1, 1, -1, 9532), -- Sealed Moirai Sigil Piece
(18907, 15775, 1, 1, -1, 710), -- Recipe - Sealed Moirai Helmet (60%)
(18907, 15776, 1, 1, -1, 710), -- Recipe - Sealed Moirai Leather Helmet(60%)
(18907, 15777, 1, 1, -1, 710), -- Recipe - Sealed Moirai Circlet (60%)
(18907, 15791, 1, 1, -1, 1014), -- Recipe - Sealed Moirai Shield (60%)
(18907, 15790, 1, 1, -1, 1014), -- Recipe - Sealed Moirai Sigil (60%)
(18907, 57, 725, 1481, 0, 700000), -- Adena
(18907, 15694, 1, 1, 1, 2.330272), -- Sealed Moirai Helmet
(18907, 15695, 1, 1, 1, 2.330272), -- Sealed Moirai Leather Helmet
(18907, 15696, 1, 1, 1, 2.330272), -- Sealed Moirai Circlet
(18907, 15710, 1, 1, 1, 3.333904), -- Sealed Moirai Shield
(18907, 15709, 1, 1, 1, 3.333904), -- Sealed Moirai Sigil
(18907, 15645, 1, 1, 1, 873.840464), -- Sealed Moirai Helmet Piece
(18907, 15646, 1, 1, 1, 873.840464), -- Sealed Moirai Leather Helmet Piece
(18907, 15647, 1, 1, 1, 873.840464), -- Sealed Moirai Circlet Piece
(18907, 15693, 1, 1, 1, 1566.409992), -- Sealed Moirai Shield Piece
(18907, 15692, 1, 1, 1, 1566.409992), -- Sealed Moirai Sigil Piece
(18907, 1879, 1, 1, 2, 30649.944283), -- Cokes
(18907, 1885, 1, 1, 2, 15324.946735), -- High-Grade Suede
(18907, 9628, 1, 1, 2, 1442.327005), -- Leonard
(18907, 9630, 1, 1, 2, 967.886024), -- Orichalcum
(18907, 9629, 1, 1, 2, 799.542555), -- Adamantine
(18907, 10483, 1, 1, 2, 1277.083129), -- Life Stone - Level 82
(18907, 10484, 1, 1, 2, 319.258079), -- Mid-Grade Life Stone - Level 82
(18907, 10485, 1, 1, 2, 32.01219), -- High-Grade Life Stone - Level 82
(18907, 6622, 1, 1, 2, 654), -- Giant's Codex
-- Sel Mahum Chef
(18908, 15492, 1, 2, 0, 250000), -- Sel Mahum Salmon Porridge
-- Solina Knights
(18909, 15667, 1, 1, -1, 8451), -- Sealed Vesper Gauntlet Piece
(18909, 15671, 1, 1, -1, 8451), -- Sealed Vesper Leather Gloves Piece
(18909, 15674, 1, 1, -1, 8451), -- Sealed Vesper Gloves Piece
(18909, 15668, 1, 1, -1, 8451), -- Sealed Vesper Boots Piece
(18909, 15672, 1, 1, -1, 8451), -- Sealed Vesper Leather Boots Piece
(18909, 15675, 1, 1, -1, 8451), -- Sealed Vesper Shoes Piece
(18909, 9630, 1, 1, -1, 5805), -- Orichalcum
(18909, 15801, 1, 1, -1, 945), -- Recipe - Sealed Vesper Gauntlet (60%)
(18909, 15802, 1, 1, -1, 945), -- Recipe - Sealed Vesper Leather Gloves (60%)
(18909, 15803, 1, 1, -1, 945), -- Recipe - Sealed Vesper Gloves (60%)
(18909, 15804, 1, 1, -1, 945), -- Recipe - Sealed Vesper Boots (60%)
(18909, 15805, 1, 1, -1, 945), -- Recipe - Sealed Vesper Leather Boots (60%)
(18909, 15806, 1, 1, -1, 945), -- Recipe - Sealed Vesper Shoes (60%)
(18909, 57, 1170, 2361, 0, 700000), -- Adena
(18909, 14109, 1, 1, 1, 3.363252), -- Sealed Vesper Gauntlet
(18909, 14113, 1, 1, 1, 3.363252), -- Sealed Vesper Leather Gloves
(18909, 14116, 1, 1, 1, 3.363252), -- Sealed Vesper Gloves
(18909, 14110, 1, 1, 1, 3.363252), -- Sealed Vesper Boots
(18909, 14114, 1, 1, 1, 3.363252), -- Sealed Vesper Leather Boots
(18909, 14117, 1, 1, 1, 3.363252), -- Sealed Vesper Shoes
(18909, 15667, 1, 1, 1, 1503.473095), -- Sealed Vesper Gauntlet Piece
(18909, 15671, 1, 1, 1, 1503.473095), -- Sealed Vesper Leather Gloves Piece
(18909, 15674, 1, 1, 1, 1503.473095), -- Sealed Vesper Gloves Piece
(18909, 15668, 1, 1, 1, 1503.473095), -- Sealed Vesper Boots Piece
(18909, 15672, 1, 1, 1, 1503.473095), -- Sealed Vesper Leather Boots Piece
(18909, 15675, 1, 1, 1, 1503.455013), -- Sealed Vesper Shoes Piece
(18909, 1879, 1, 1, 2, 28026.766601), -- Cokes
(18909, 1885, 1, 1, 2, 14013.406965), -- High-Grade Suede
(18909, 9628, 1, 1, 2, 1318.917243), -- Leonard
(18909, 9630, 1, 1, 2, 885.0523), -- Orichalcum
(18909, 9629, 1, 1, 2, 731.138392), -- Adamantine
(18909, 9573, 1, 1, 2, 1167.795746), -- Life Stone - Level 80
(18909, 9574, 1, 1, 2, 291.925272), -- Mid-Grade Life Stone - Level 80
(18909, 9575, 1, 1, 2, 29.201993), -- High-Grade Life Stone - Level 80
(18909, 15801, 1, 1, 2, 144.116805), -- Recipe - Sealed Vesper Gauntlet (60%)
(18909, 15802, 1, 1, 2, 144.116805), -- Recipe - Sealed Vesper Leather Gloves (60%)
(18909, 15803, 1, 1, 2, 144.116805), -- Recipe - Sealed Vesper Gloves (60%)
(18909, 15804, 1, 1, 2, 144.116805), -- Recipe - Sealed Vesper Boots (60%)
(18909, 15805, 1, 1, 2, 144.116805), -- Recipe - Sealed Vesper Leather Boots (60%)
(18909, 15806, 1, 1, 2, 144.211463), -- Recipe - Sealed Vesper Shoes (60%)
-- Solina Knight Captain
(18910, 15667, 1, 1, -1, 13541), -- Sealed Vesper Gauntlet Piece
(18910, 15671, 1, 1, -1, 13541), -- Sealed Vesper Leather Gloves Piece
(18910, 15674, 1, 1, -1, 13541), -- Sealed Vesper Gloves Piece
(18910, 15668, 1, 1, -1, 13541), -- Sealed Vesper Boots Piece
(18910, 15672, 1, 1, -1, 13541), -- Sealed Vesper Leather Boots Piece
(18910, 15675, 1, 1, -1, 13541), -- Sealed Vesper Shoes Piece
(18910, 15801, 1, 1, -1, 1515), -- Recipe - Sealed Vesper Gauntlet (60%)
(18910, 15802, 1, 1, -1, 1515), -- Recipe - Sealed Vesper Leather Gloves (60%)
(18910, 15803, 1, 1, -1, 1515), -- Recipe - Sealed Vesper Gloves (60%)
(18910, 15804, 1, 1, -1, 1515), -- Recipe - Sealed Vesper Boots (60%)
(18910, 15805, 1, 1, -1, 1515), -- Recipe - Sealed Vesper Leather Boots (60%)
(18910, 15806, 1, 1, -1, 1515), -- Recipe - Sealed Vesper Shoes (60%)
(18910, 57, 1730, 3492, 0, 700000), -- Adena
(18910, 14109, 1, 1, 1, 4.974012), -- Sealed Vesper Gauntlet
(18910, 14113, 1, 1, 1, 4.974012), -- Sealed Vesper Leather Gloves
(18910, 14116, 1, 1, 1, 4.974012), -- Sealed Vesper Gloves
(18910, 14110, 1, 1, 1, 4.974012), -- Sealed Vesper Boots
(18910, 14114, 1, 1, 1, 4.974012), -- Sealed Vesper Leather Boots
(18910, 14117, 1, 1, 1, 4.974012), -- Sealed Vesper Shoes
(18910, 15667, 1, 1, 1, 2223.530445), -- Sealed Vesper Gauntlet Piece
(18910, 15671, 1, 1, 1, 2223.530445), -- Sealed Vesper Leather Gloves Piece
(18910, 15674, 1, 1, 1, 2223.530445), -- Sealed Vesper Gloves Piece
(18910, 15668, 1, 1, 1, 2223.530445), -- Sealed Vesper Boots Piece
(18910, 15672, 1, 1, 1, 2223.530445), -- Sealed Vesper Leather Boots Piece
(18910, 15675, 1, 1, 1, 2223.503703), -- Sealed Vesper Shoes Piece
(18910, 1895, 1, 1, 2, 142118.63211), -- Metallic Fiber
(18910, 4040, 1, 1, 2, 9948.240778), -- Mold Lubricant
(18910, 4042, 1, 1, 2, 8290.230872), -- Enria
(18910, 4043, 1, 1, 2, 16580.461744), -- Asofe
(18910, 10483, 1, 1, 2, 3454.202416), -- Life Stone - Level 82
(18910, 10484, 1, 1, 2, 863.550604), -- Mid-Grade Life Stone - Level 82
(18910, 10485, 1, 1, 2, 86.681476), -- High-Grade Life Stone - Level 82
-- Abbey Treasure Chest
(18911, 730, 1, 1, 0, 600000), -- Scroll: Enchant Armor (A-Grade)
(18911, 960, 1, 1, 0, 400000), -- Scroll: Enchant Armor (S-Grade)
-- Pavel Safety Device
(18917, 57, 361, 738, 0, 700000), -- Adena
(18917, 9546, 1, 1, 1, 1767.836869), -- Fire Stone
(18917, 9547, 1, 1, 1, 1767.836869), -- Water Stone
(18917, 9548, 1, 1, 1, 1767.836869), -- Earth Stone
(18917, 9549, 1, 1, 1, 1767.836869), -- Wind Stone
(18917, 9550, 1, 1, 1, 1767.836869), -- Dark Stone
(18917, 9551, 1, 1, 1, 1767.815655), -- Holy Stone
-- Abbey Treasure Chest
(18934, 960, 1, 1, 0, 1000000), -- Scroll: Enchant Armor (S-Grade)
-- Goblin
(20003, 1871, 1, 1, -1, 56617), -- Charcoal
(20003, 116, 1, 1, -1, 452932), -- Magic Ring
(20003, 1786, 1, 1, -1, 45293), -- Recipe: Broad Sword
(20003, 57, 30, 42, 0, 700000), -- Adena
(20003, 112, 1, 1, 1, 102689.2683), -- Apprentice's Earring
(20003, 118, 1, 1, 1, 76513.51329), -- Necklace of Magic
(20003, 116, 1, 1, 1, 156087.21841), -- Magic Ring
(20003, 1864, 1, 1, 2, 19511.058856), -- Stem
(20003, 1865, 1, 1, 2, 9755.529428), -- Varnish
(20003, 1866, 1, 1, 2, 6503.663956), -- Suede
(20003, 1873, 1, 1, 2, 3902.184976), -- Silver Nugget
(20003, 1868, 1, 1, 2, 19511.058856), -- Thread
(20003, 1788, 1, 1, 2, 7804.503928), -- Recipe: Bow
-- Imp
(20004, 1866, 1, 1, -1, 51827), -- Suede
(20004, 2006, 1, 1, -1, 5553), -- Willow Staff Head
(20004, 2005, 1, 1, -1, 5553), -- Broadsword Blade
(20004, 57, 41, 58, 0, 700000), -- Adena
(20004, 1122, 1, 1, 1, 6514.326819), -- Cotton Shoes
(20004, 1129, 1, 1, 1, 6514.326819), -- Crude Leather Shoes
(20004, 1119, 1, 1, 1, 6514.346362), -- Short Leather Gloves
(20004, 1871, 1, 1, 2, 15309), -- Charcoal
(20004, 1866, 1, 1, 2, 10205.989794), -- Suede
(20004, 1666, 1, 1, 2, 5103.010206), -- Recipe: Wooden Arrow
-- Imp Elder
(20005, 1060, 1, 1, -1, 216259), -- Lesser Healing Potion
(20005, 1866, 1, 1, -1, 64878), -- Suede
(20005, 1666, 1, 1, -1, 32439), -- Recipe: Wooden Arrow
(20005, 57, 51, 72, 0, 700000), -- Adena
(20005, 19, 1, 1, 1, 11732.93531), -- Small Shield
(20005, 42, 1, 1, 1, 8213.06469), -- Leather Cap
(20005, 1870, 1, 1, 2, 14372.907594), -- Coal
(20005, 1865, 1, 1, 2, 14372.907594), -- Varnish
(20005, 1789, 1, 1, 2, 2656.750109), -- Recipe: Cedar Staff
(20005, 17, 10, 30, 2, 71864.434703), -- Wooden Arrow
-- Orc Archer
(20006, 1060, 1, 1, -1, 285245), -- Lesser Healing Potion
(20006, 113, 1, 1, -1, 41407), -- Mystic's Earring
(20006, 2006, 1, 1, -1, 9169), -- Willow Staff Head
(20006, 57, 69, 94, 0, 700000), -- Adena
(20006, 14, 1, 1, 1, 789.869388), -- Bow
(20006, 2007, 1, 1, 1, 2708.130612), -- Bow Shaft
(20006, 1866, 1, 1, 2, 16851.42), -- Suede
(20006, 1871, 1, 1, 2, 25277.13), -- Charcoal
(20006, 2136, 1, 1, 2, 7434.45), -- Recipe: Cokes
-- Green Fungus
(20007, 1866, 1, 1, -1, 99228), -- Suede
(20007, 1122, 1, 1, -1, 63337), -- Cotton Shoes
(20007, 1875, 1, 1, -1, 9923), -- Stone of Purity
(20007, 57, 80, 108, 0, 700000), -- Adena
(20007, 22, 1, 1, 1, 4702.317224), -- Leather Shirt
(20007, 29, 1, 1, 1, 7515.682776), -- Leather Pants
(20007, 1864, 1, 1, 2, 58620.9312), -- Stem
(20007, 1869, 1, 1, 2, 29310.528), -- Iron Ore
(20007, 1796, 1, 1, 2, 36868.5408), -- Recipe: Leather Tunic
-- Felim Lizardman
(20008, 1793, 1, 1, -1, 16388), -- Recipe: Sword of Reflection
(20008, 1871, 1, 1, -1, 222882), -- Charcoal
(20008, 1870, 1, 1, -1, 222882), -- Coal
(20008, 57, 114, 168, 0, 700000), -- Adena
(20008, 2371, 1, 1, 1, 675.404192), -- Fist of Butcher
(20008, 255, 1, 1, 1, 316.595808), -- Fox Claw Gloves
(20008, 1870, 1, 1, 2, 43890.42816), -- Coal
(20008, 1865, 1, 1, 2, 43890.42816), -- Varnish
(20008, 1792, 1, 1, 2, 3227.14368), -- Recipe: Short Spear
-- Vuku Orc
(20009, 1870, 1, 1, -1, 222882), -- Coal
(20009, 43, 1, 1, -1, 14567), -- Wooden Helmet
(20009, 1831, 1, 1, -1, 594351), -- Antidote
(20009, 57, 114, 168, 0, 700000), -- Adena
(20009, 2371, 1, 1, 1, 675.404192), -- Fist of Butcher
(20009, 255, 1, 1, 1, 316.595808), -- Fox Claw Gloves
(20009, 1866, 1, 1, 2, 29260.278432), -- Suede
(20009, 1871, 1, 1, 2, 43890.417648), -- Charcoal
(20009, 736, 1, 1, 2, 21945.30392), -- Scroll of Escape
-- Felim Lizardman Scout
(20010, 1833, 1, 1, -1, 617635), -- Bandage
(20010, 1896, 1, 1, -1, 98141), -- Necklace of Anguish Chain
(20010, 1792, 1, 1, -1, 17030), -- Recipe: Short Spear
(20010, 57, 116, 177, 0, 700000), -- Adena
(20010, 271, 1, 1, 1, 658), -- Hunting Bow
(20010, 1871, 1, 1, 2, 45609.893496), -- Charcoal
(20010, 1866, 1, 1, 2, 30406.595664), -- Suede
(20010, 1798, 1, 1, 2, 44715.51084), -- Recipe: Leather Helmet
-- Vuku Orc Archer
(20011, 1792, 1, 1, -1, 17541), -- Recipe: Short Spear
(20011, 1921, 1, 1, -1, 153911), -- Leather Shoes Texture
(20011, 1867, 1, 1, -1, 318082), -- Animal Skin
(20011, 57, 120, 182, 0, 700000), -- Adena
(20011, 271, 1, 1, 1, 678), -- Hunting Bow
(20011, 1867, 1, 1, 2, 62637.833517), -- Animal Skin
(20011, 1872, 1, 1, 2, 62637.833517), -- Animal Bone
(20011, 1799, 1, 1, 2, 69597.332966), -- Recipe: Leather Gloves
-- Gora Werewolf
(20012, 1865, 1, 1, -1, 242317), -- Varnish
(20012, 734, 1, 1, -1, 40386), -- Haste Potion
(20012, 1897, 1, 1, -1, 57694), -- Necklace of Wisdom Chain
(20012, 57, 120, 187, 0, 700000), -- Adena
(20012, 1101, 1, 1, 1, 917.695683), -- Tunic of Devotion
(20012, 1104, 1, 1, 1, 1465.304317), -- Stockings of Devotion
(20012, 1865, 1, 1, 2, 35788.225837), -- Varnish
(20012, 1870, 1, 1, 2, 35788.225837), -- Coal
(20012, 1800, 1, 1, 2, 11254.203324), -- Recipe: Piece Bone Breastplate
(20012, 6035, 1, 1, 2, 2982.345002), -- Magic Haste Potion
-- Dryad
(20013, 1866, 1, 1, -1, 143423), -- Suede
(20013, 1896, 1, 1, -1, 91159), -- Necklace of Anguish Chain
(20013, 1922, 1, 1, -1, 54881), -- Leather Tunic Pattern
(20013, 57, 113, 160, 0, 700000), -- Adena
(20013, 9, 1, 1, 1, 203.6982), -- Cedar Staff
(20013, 2008, 1, 1, 1, 1648.6036), -- Cedar Staff Head
(20013, 154, 1, 1, 1, 203.6982), -- Dwarven Mace
(20013, 1870, 1, 1, 2, 42365.00815), -- Coal
(20013, 1865, 1, 1, 2, 42365.00815), -- Varnish
(20013, 1792, 1, 1, 2, 3114.9837), -- Recipe: Short Spear
-- Felim Lizardman Warrior
(20014, 2254, 1, 1, -1, 10085), -- Recipe: Composite Bow
(20014, 1867, 1, 1, -1, 328104), -- Animal Skin
(20014, 57, 120, 193, 0, 700000), -- Adena
(20014, 2, 1, 1, 1, 69.237785), -- Long Sword
(20014, 120, 1, 1, 1, 69.237785), -- Sword of Reflection
(20014, 2012, 1, 1, 1, 757.286645), -- Sword of Reflection Blade
(20014, 121, 1, 1, 1, 69.237785), -- Sword of Watershadow
(20014, 1867, 1, 1, 2, 64611.193477), -- Animal Skin
(20014, 1872, 1, 1, 2, 64611.193477), -- Animal Bone
(20014, 1800, 1, 1, 2, 15238.613046), -- Recipe: Piece Bone Breastplate
-- Marsh Zombie
(20015, 1798, 1, 1, -1, 237113), -- Recipe: Leather Helmet
(20015, 1871, 1, 1, -1, 241855), -- Charcoal
(20015, 1864, 1, 1, -1, 483710), -- Stem
(20015, 57, 127, 180, 0, 700000), -- Adena
(20015, 9, 1, 1, 1, 228.962325), -- Cedar Staff
(20015, 2008, 1, 1, 1, 1853.07535), -- Cedar Staff Head
(20015, 154, 1, 1, 1, 228.962325), -- Dwarven Mace
(20015, 1864, 1, 1, 2, 95253.418299), -- Stem
(20015, 1869, 1, 1, 2, 47626.803936), -- Iron Ore
(20015, 1798, 1, 1, 2, 46692.777765), -- Recipe: Leather Helmet
-- Stone Golem
(20016, 1865, 1, 1, -1, 241855), -- Varnish
(20016, 37, 1, 1, -1, 23711), -- Leather Shoes
(20016, 1833, 1, 1, -1, 644946), -- Bandage
(20016, 57, 127, 180, 0, 700000), -- Adena
(20016, 271, 1, 1, 1, 687), -- Hunting Bow
(20016, 1871, 1, 1, 2, 47626.567758), -- Charcoal
(20016, 1866, 1, 1, 2, 31751.045172), -- Suede
(20016, 736, 1, 1, 2, 23813.38707), -- Scroll of Escape
-- Vuku Orc Fighter
(20017, 1870, 1, 1, -1, 251000), -- Coal
(20017, 1897, 1, 1, -1, 59762), -- Necklace of Wisdom Chain
(20017, 57, 122, 197, 0, 700000), -- Adena
(20017, 2, 1, 1, 1, 70.601016), -- Long Sword
(20017, 120, 1, 1, 1, 70.601016), -- Sword of Reflection
(20017, 2012, 1, 1, 1, 772.196952), -- Sword of Reflection Blade
(20017, 121, 1, 1, 1, 70.601016), -- Sword of Watershadow
(20017, 1870, 1, 1, 2, 37070.571302), -- Coal
(20017, 1865, 1, 1, 2, 37070.571302), -- Varnish
(20017, 1817, 1, 1, 2, 7414.130868), -- Recipe: Cord
(20017, 5268, 1, 1, 2, 1482.726528), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Dryad Elder
(20019, 1864, 1, 1, -1, 445764), -- Stem
(20019, 1923, 1, 1, -1, 91345), -- Leather Stockings Pattern
(20019, 1792, 1, 1, -1, 16388), -- Recipe: Short Spear
(20019, 57, 114, 168, 0, 700000), -- Adena
(20019, 429, 1, 1, 1, 1075.736025), -- Leather Tunic
(20019, 1922, 1, 1, 1, 8397.233676), -- Leather Tunic Pattern
(20019, 464, 1, 1, 1, 1723.39947), -- Leather Stockings
(20019, 1923, 1, 1, 1, 13490.630829), -- Leather Stockings Pattern
(20019, 1871, 1, 1, 2, 43890.464944), -- Charcoal
(20019, 1866, 1, 1, 2, 29260.335422), -- Suede
(20019, 1793, 1, 1, 2, 3227.199634), -- Recipe: Sword of Reflection
-- Marsh Zombie Lord
(20020, 1831, 1, 1, -1, 668170), -- Antidote
(20020, 1799, 1, 1, -1, 371205), -- Recipe: Leather Gloves
(20020, 1896, 1, 1, -1, 106171), -- Necklace of Anguish Chain
(20020, 57, 128, 189, 0, 700000), -- Adena
(20020, 37, 1, 1, 1, 4837.383828), -- Leather Shoes
(20020, 1921, 1, 1, 1, 31833.190836), -- Leather Shoes Texture
(20020, 49, 1, 1, 1, 4837.425336), -- Gloves
(20020, 1865, 1, 1, 2, 49341.52597), -- Varnish
(20020, 1870, 1, 1, 2, 49341.52597), -- Coal
(20020, 1794, 1, 1, 2, 3627.94806), -- Recipe: Forest Bow
-- Red Bear
(20021, 1792, 1, 1, -1, 16388), -- Recipe: Short Spear
(20021, 1921, 1, 1, -1, 143795), -- Leather Shoes Texture
(20021, 1793, 1, 1, -1, 16388), -- Recipe: Sword of Reflection
(20021, 57, 114, 168, 0, 700000), -- Adena
(20021, 9, 1, 1, 1, 211.02975), -- Cedar Staff
(20021, 2008, 1, 1, 1, 1707.9405), -- Cedar Staff Head
(20021, 154, 1, 1, 1, 211.02975), -- Dwarven Mace
(20021, 1865, 1, 1, 2, 32917.863649), -- Varnish
(20021, 1870, 1, 1, 2, 32917.863649), -- Coal
(20021, 1798, 1, 1, 2, 32272.388478), -- Recipe: Leather Helmet
(20021, 1060, 1, 1, 2, 73150.884224), -- Lesser Healing Potion
-- Misery Skeleton
(20022, 1872, 1, 1, -1, 252599), -- Animal Bone
(20022, 1831, 1, 1, -1, 505199), -- Antidote
(20022, 1921, 1, 1, -1, 122225), -- Leather Shoes Texture
(20022, 57, 97, 143, 0, 700000), -- Adena
(20022, 20, 1, 1, 1, 5229.661794), -- Buckler
(20022, 43, 1, 1, 1, 3657.338206), -- Wooden Helmet
(20022, 1864, 1, 1, 2, 74614.166671), -- Stem
(20022, 1869, 1, 1, 2, 37306.99974), -- Iron Ore
(20022, 1799, 1, 1, 2, 55269.833589), -- Recipe: Leather Gloves
-- Shadow Beast
(20023, 1868, 1, 1, -1, 463226), -- Thread
(20023, 1922, 1, 1, -1, 59085), -- Leather Tunic Pattern
(20023, 1831, 1, 1, -1, 617635), -- Antidote
(20023, 57, 116, 177, 0, 700000), -- Adena
(20023, 429, 1, 1, 1, 1117.87305), -- Leather Tunic
(20023, 1922, 1, 1, 1, 8726.156792), -- Leather Tunic Pattern
(20023, 464, 1, 1, 1, 1790.90574), -- Leather Stockings
(20023, 1923, 1, 1, 1, 14019.064418), -- Leather Stockings Pattern
(20023, 1868, 1, 1, 2, 68414.79603), -- Thread
(20023, 1873, 1, 1, 2, 13682.959206), -- Silver Nugget
(20023, 1803, 1, 1, 2, 28745.708796), -- Recipe: Necklace of Wisdom
(20023, 735, 1, 1, 2, 2850.535968), -- Alacrity Potion
-- Langk Lizardman Warrior
(20024, 1864, 1, 1, -1, 501999), -- Stem
(20024, 734, 1, 1, -1, 41833), -- Haste Potion
(20024, 1897, 1, 1, -1, 59762), -- Necklace of Wisdom Chain
(20024, 57, 122, 197, 0, 700000), -- Adena
(20024, 2, 1, 1, 1, 70.601016), -- Long Sword
(20024, 120, 1, 1, 1, 70.601016), -- Sword of Reflection
(20024, 2012, 1, 1, 1, 772.196952), -- Sword of Reflection Blade
(20024, 121, 1, 1, 1, 70.601016), -- Sword of Watershadow
(20024, 1864, 1, 1, 2, 98855.505408), -- Stem
(20024, 1869, 1, 1, 2, 49427.752704), -- Iron Ore
(20024, 1801, 1, 1, 2, 24900.741888), -- Recipe: Piece Bone Gaiters
-- Lesser Dark Horror
(20025, 1799, 1, 1, -1, 349993), -- Recipe: Leather Gloves
(20025, 1869, 1, 1, -1, 236245), -- Iron Ore
(20025, 1866, 1, 1, -1, 157497), -- Suede
(20025, 57, 119, 180, 0, 700000), -- Adena
(20025, 429, 1, 1, 1, 1140.2706), -- Leather Tunic
(20025, 1922, 1, 1, 1, 8900.992864), -- Leather Tunic Pattern
(20025, 464, 1, 1, 1, 1826.78808), -- Leather Stockings
(20025, 1923, 1, 1, 1, 14299.948456), -- Leather Stockings Pattern
(20025, 1866, 1, 1, 2, 31014.738216), -- Suede
(20025, 1871, 1, 1, 2, 46522.107324), -- Charcoal
(20025, 736, 1, 1, 2, 23261.15446), -- Scroll of Escape
-- Ruin Zombie
(20026, 1866, 1, 1, -1, 173586), -- Suede
(20026, 1923, 1, 1, -1, 106713), -- Leather Stockings Pattern
(20026, 1865, 1, 1, -1, 260379), -- Varnish
(20026, 57, 131, 199, 0, 700000), -- Adena
(20026, 37, 1, 1, 1, 5026.879494), -- Leather Shoes
(20026, 1921, 1, 1, 1, 33080.197878), -- Leather Shoes Texture
(20026, 49, 1, 1, 1, 5026.922628), -- Gloves
(20026, 1870, 1, 1, 2, 51274.9464), -- Coal
(20026, 1865, 1, 1, 2, 51274.9464), -- Varnish
(20026, 1792, 1, 1, 2, 3770.1072), -- Recipe: Short Spear
-- Langk Lizardman Scout
(20027, 1800, 1, 1, -1, 74706), -- Recipe: Piece Bone Breastplate
(20027, 1924, 1, 1, -1, 76634), -- Leather Helmet Design
(20027, 1801, 1, 1, -1, 119680), -- Recipe: Piece Bone Gaiters
(20027, 57, 118, 183, 0, 700000), -- Adena
(20027, 176, 1, 1, 1, 133.5), -- Apprentice's Staff
(20027, 2501, 1, 1, 1, 133.5), -- Bone Club
(20027, 1865, 1, 1, 2, 35086.53225), -- Varnish
(20027, 1870, 1, 1, 2, 35086.53225), -- Coal
(20027, 1800, 1, 1, 2, 11033.47421), -- Recipe: Piece Bone Breastplate
(20027, 5158, 1, 1, 2, 1403.46129), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Pincher
(20028, 1801, 1, 1, -1, 119680), -- Recipe: Piece Bone Gaiters
(20028, 1868, 1, 1, -1, 475131), -- Thread
(20028, 734, 1, 1, -1, 39594), -- Haste Potion
(20028, 57, 118, 183, 0, 700000), -- Adena
(20028, 845, 1, 1, 1, 1025.902512), -- Cat's Eye Earring
(20028, 908, 1, 1, 1, 769.432728), -- Necklace of Wisdom
(20028, 1897, 1, 1, 1, 8353.810992), -- Necklace of Wisdom Chain
(20028, 877, 1, 1, 1, 1538.853768), -- Ring of Wisdom
(20028, 1869, 1, 1, 2, 46782.1875), -- Iron Ore
(20028, 1864, 1, 1, 2, 93564.375), -- Stem
(20028, 1817, 1, 1, 2, 9356.4375), -- Recipe: Cord
-- Ruin Zombie Leader
(20029, 1864, 1, 1, -1, 534142), -- Stem
(20029, 2013, 1, 1, -1, 5764), -- Forest Bow Shaft
(20029, 1897, 1, 1, -1, 63588), -- Necklace of Wisdom Chain
(20029, 57, 132, 206, 0, 700000), -- Adena
(20029, 15, 1, 1, 1, 150.26895), -- Short Spear
(20029, 2011, 1, 1, 1, 1799.73105), -- Short Spear Edge
(20029, 1870, 1, 1, 2, 39444.234295), -- Coal
(20029, 1865, 1, 1, 2, 39444.234295), -- Varnish
(20029, 2139, 1, 1, 2, 7888.86453), -- Recipe: Steel Mold
(20029, 5268, 1, 1, 2, 1577.66688), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Langk Lizardman
(20030, 1831, 1, 1, -1, 617635), -- Antidote
(20030, 1798, 1, 1, -1, 227072), -- Recipe: Leather Helmet
(20030, 1794, 1, 1, -1, 17030), -- Recipe: Forest Bow
(20030, 57, 116, 177, 0, 700000), -- Adena
(20030, 216, 1, 1, 1, 328.91945), -- Dirk
(20030, 2009, 1, 1, 1, 2426.08055), -- Dirk Blade
(20030, 1870, 1, 1, 2, 45610.20298), -- Coal
(20030, 1865, 1, 1, 2, 45610.20298), -- Varnish
(20030, 1793, 1, 1, 2, 3353.59404), -- Recipe: Sword of Reflection
-- Omen Beast
(20031, 1865, 1, 1, -1, 205065), -- Varnish
(20031, 24, 1, 1, -1, 2629), -- Bone Breastplate
(20031, 1924, 1, 1, -1, 66150), -- Leather Helmet Design
(20031, 57, 100, 161, 0, 700000), -- Adena
(20031, 24, 1, 1, 1, 388.37335), -- Bone Breastplate
(20031, 390, 1, 1, 1, 388.37335), -- Cotton Shirt
(20031, 31, 1, 1, 1, 620.12665), -- Bone Gaiters
(20031, 412, 1, 1, 1, 620.12665), -- Cotton Pants
(20031, 1865, 1, 1, 2, 30286.636218), -- Varnish
(20031, 1870, 1, 1, 2, 30286.636218), -- Coal
(20031, 2140, 1, 1, 2, 6057.340812), -- Recipe: High-Grade Suede
(20031, 5273, 1, 1, 2, 1211.386752), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Pinrul
(20032, 734, 1, 1, -1, 41013), -- Haste Potion
(20032, 1868, 1, 1, -1, 492156), -- Thread
(20032, 1800, 1, 1, -1, 77383), -- Recipe: Piece Bone Breastplate
(20032, 57, 120, 193, 0, 700000), -- Adena
(20032, 24, 1, 1, 1, 465.971), -- Bone Breastplate
(20032, 390, 1, 1, 1, 465.971), -- Cotton Shirt
(20032, 31, 1, 1, 1, 744.029), -- Bone Gaiters
(20032, 412, 1, 1, 1, 744.029), -- Cotton Pants
(20032, 1870, 1, 1, 2, 48458.587905), -- Coal
(20032, 1865, 1, 1, 2, 48458.587905), -- Varnish
(20032, 2141, 1, 1, 2, 9691.82419), -- Recipe: Silver Mold
-- Shade Horror
(20033, 2139, 1, 1, -1, 41013), -- Recipe: Steel Mold
(20033, 1924, 1, 1, -1, 66150), -- Leather Helmet Design
(20033, 1925, 1, 1, -1, 134469), -- Leather Gloves Lining
(20033, 57, 100, 161, 0, 700000), -- Adena
(20033, 845, 1, 1, 1, 885.551886), -- Cat's Eye Earring
(20033, 908, 1, 1, 1, 664.168959), -- Necklace of Wisdom
(20033, 1897, 1, 1, 1, 7210.951326), -- Necklace of Wisdom Chain
(20033, 877, 1, 1, 1, 1328.327829), -- Ring of Wisdom
(20033, 1870, 1, 1, 2, 30286.636218), -- Coal
(20033, 1865, 1, 1, 2, 30286.636218), -- Varnish
(20033, 2142, 1, 1, 2, 6057.340812), -- Recipe: Varnish of Purity
(20033, 5158, 1, 1, 2, 1211.386752), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Prowler
(20034, 1868, 1, 1, -1, 501999), -- Thread
(20034, 2254, 1, 1, -1, 10287), -- Recipe: Composite Bow
(20034, 1873, 1, 1, -1, 100400), -- Silver Nugget
(20034, 57, 122, 197, 0, 700000), -- Adena
(20034, 256, 1, 1, 1, 282), -- Cestus
(20034, 1873, 1, 1, 2, 14828.241164), -- Silver Nugget
(20034, 1868, 1, 1, 2, 74141.404766), -- Thread
(20034, 2143, 1, 1, 2, 7414.120582), -- Recipe: Synthetic Cokes
(20034, 6035, 1, 1, 2, 3089.233488), -- Magic Haste Potion
-- Skeleton Tracker
(20035, 2140, 1, 1, -1, 49216), -- Recipe: High-Grade Suede
(20035, 1925, 1, 1, -1, 161363), -- Leather Gloves Lining
(20035, 1868, 1, 1, -1, 492156), -- Thread
(20035, 57, 120, 193, 0, 700000), -- Adena
(20035, 38, 1, 1, 1, 1860.220285), -- Low Boots
(20035, 50, 1, 1, 1, 1860.220285), -- Leather Gloves
(20035, 1925, 1, 1, 1, 31776.55943), -- Leather Gloves Lining
(20035, 1868, 1, 1, 2, 72687.902048), -- Thread
(20035, 1873, 1, 1, 2, 14537.56122), -- Silver Nugget
(20035, 1817, 1, 1, 2, 7268.828584), -- Recipe: Cord
(20035, 5268, 1, 1, 2, 1453.708148), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Lirein
(20036, 1873, 1, 1, -1, 103328), -- Silver Nugget
(20036, 2175, 1, 1, -1, 210017), -- Recipe: Boots
(20036, 735, 1, 1, -1, 21527), -- Alacrity Potion
(20036, 57, 124, 204, 0, 700000), -- Adena
(20036, 845, 1, 1, 1, 1115.519766), -- Cat's Eye Earring
(20036, 908, 1, 1, 1, 836.646179), -- Necklace of Wisdom
(20036, 1897, 1, 1, 1, 9083.554406), -- Necklace of Wisdom Chain
(20036, 877, 1, 1, 1, 1673.279649), -- Ring of Wisdom
(20036, 1864, 1, 1, 2, 76303.90936), -- Stem
(20036, 1869, 1, 1, 2, 38151.95468), -- Iron Ore
(20036, 1878, 1, 1, 2, 15260.781872), -- Braided Hemp
(20036, 2173, 1, 1, 2, 10339.354088), -- Recipe: Hard Leather Shirt
-- Venomous Spider
(20038, 2174, 1, 1, -1, 121122), -- Recipe: Hard Leather Gaiters
(20038, 1868, 1, 1, -1, 557163), -- Thread
(20038, 2011, 1, 1, -1, 6355), -- Short Spear Edge
(20038, 57, 133, 220, 0, 700000), -- Adena
(20038, 217, 1, 1, 1, 156.5), -- Shining Knife
(20038, 218, 1, 1, 1, 156.5), -- Throwing Knife
(20038, 1869, 1, 1, 2, 20572.111932), -- Iron Ore
(20038, 1870, 1, 1, 2, 20572.111932), -- Coal
(20038, 1871, 1, 1, 2, 20572.111932), -- Charcoal
(20038, 1872, 1, 1, 2, 27429.482576), -- Animal Bone
(20038, 1867, 1, 1, 2, 27429.482576), -- Animal Skin
(20038, 2174, 1, 1, 2, 8944.443762), -- Recipe: Hard Leather Gaiters
(20038, 5273, 1, 1, 2, 822.833741), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20038, 1831, 1, 1, 2, 54858.421549), -- Antidote
-- Scavenger Wererat
(20039, 1872, 1, 1, -1, 337674), -- Animal Bone
(20039, 2011, 1, 1, -1, 5777), -- Short Spear Edge
(20039, 1801, 1, 1, -1, 127585), -- Recipe: Piece Bone Gaiters
(20039, 57, 121, 200, 0, 700000), -- Adena
(20039, 945, 1, 1, 1, 2833.69248), -- Skeleton Buckler
(20039, 102, 1, 1, 1, 1367.637272), -- Round Shield
(20039, 44, 1, 1, 1, 956.638184), -- Leather Helmet
(20039, 1924, 1, 1, 1, 12066.032064), -- Leather Helmet Design
(20039, 1864, 1, 1, 2, 42747.3024), -- Stem
(20039, 1865, 1, 1, 2, 21373.6512), -- Varnish
(20039, 1866, 1, 1, 2, 14249.1008), -- Suede
(20039, 1873, 1, 1, 2, 8549.40095), -- Silver Nugget
(20039, 1868, 1, 1, 2, 42747.3024), -- Thread
(20039, 2175, 1, 1, 2, 17376.955825), -- Recipe: Boots
(20039, 735, 1, 1, 2, 1781.286425), -- Alacrity Potion
-- Sukar Wererat
(20040, 2175, 1, 1, -1, 171583), -- Recipe: Boots
(20040, 2140, 1, 1, -1, 42209), -- Recipe: High-Grade Suede
(20040, 2012, 1, 1, -1, 4397), -- Sword of Reflection Blade
(20040, 57, 101, 167, 0, 700000), -- Adena
(20040, 945, 1, 1, 1, 2361.35556), -- Skeleton Buckler
(20040, 102, 1, 1, 1, 1139.671259), -- Round Shield
(20040, 44, 1, 1, 1, 797.179973), -- Leather Helmet
(20040, 1924, 1, 1, 1, 10054.793208), -- Leather Helmet Design
(20040, 1868, 1, 1, 2, 62339.799824), -- Thread
(20040, 1873, 1, 1, 2, 12467.929032), -- Silver Nugget
(20040, 2252, 1, 1, 2, 1277.447308), -- Recipe: Iron Hammer
(20040, 5158, 1, 1, 2, 1246.823836), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Tainted Zombie
(20041, 1880, 1, 1, -1, 23726), -- Steel
(20041, 2012, 1, 1, -1, 4943), -- Sword of Reflection Blade
(20041, 1817, 1, 1, -1, 47452), -- Recipe: Cord
(20041, 57, 114, 187, 0, 700000), -- Adena
(20041, 217, 1, 1, 1, 133.5), -- Shining Knife
(20041, 218, 1, 1, 1, 133.5), -- Throwing Knife
(20041, 1866, 1, 1, 2, 31147.6736), -- Suede
(20041, 1871, 1, 1, 2, 46721.5104), -- Charcoal
(20041, 2253, 1, 1, 2, 1914.816), -- Recipe: Sword Breaker
-- Skeleton Tracker Leader
(20042, 734, 1, 1, -1, 43053), -- Haste Potion
(20042, 2013, 1, 1, -1, 5575), -- Forest Bow Shaft
(20042, 57, 124, 204, 0, 700000), -- Adena
(20042, 309, 1, 1, 1, 145.5), -- Tears of Eva
(20042, 310, 1, 1, 1, 145.5), -- Relic of the Saints
(20042, 1867, 1, 1, 2, 40695.344685), -- Animal Skin
(20042, 1872, 1, 1, 2, 40695.344685), -- Animal Bone
(20042, 1882, 1, 1, 2, 6782.60277), -- Leather
(20042, 2254, 1, 1, 2, 1250.901), -- Recipe: Composite Bow
(20042, 5268, 1, 1, 2, 1220.80686), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Arachnid Tracker
(20043, 1817, 1, 1, -1, 58608), -- Recipe: Cord
(20043, 1924, 1, 1, -1, 94529), -- Leather Helmet Design
(20043, 1864, 1, 1, -1, 586082), -- Stem
(20043, 57, 137, 234, 0, 700000), -- Adena
(20043, 2, 1, 1, 1, 82.439601), -- Long Sword
(20043, 120, 1, 1, 1, 82.439601), -- Sword of Reflection
(20043, 2012, 1, 1, 1, 901.681197), -- Sword of Reflection Blade
(20043, 121, 1, 1, 1, 82.439601), -- Sword of Watershadow
(20043, 1864, 1, 1, 2, 43279.866706), -- Stem
(20043, 1865, 1, 1, 2, 21639.836262), -- Varnish
(20043, 1866, 1, 1, 2, 14426.557508), -- Suede
(20043, 1873, 1, 1, 2, 8656.051014), -- Silver Nugget
(20043, 1868, 1, 1, 2, 43279.866706), -- Thread
(20043, 2143, 1, 1, 2, 4327.928416), -- Recipe: Synthetic Cokes
(20043, 5158, 1, 1, 2, 865.663356), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20043, 1831, 1, 1, 2, 57706.230032), -- Antidote
-- Lirein Elder
(20044, 1865, 1, 1, -1, 266401), -- Varnish
(20044, 2142, 1, 1, -1, 53280), -- Recipe: Varnish of Purity
(20044, 1872, 1, 1, -1, 355202), -- Animal Bone
(20044, 57, 125, 213, 0, 700000), -- Adena
(20044, 309, 1, 1, 1, 150), -- Tears of Eva
(20044, 310, 1, 1, 1, 150), -- Relic of the Saints
(20044, 1872, 1, 1, 2, 52460.391984), -- Animal Bone
(20044, 1867, 1, 1, 2, 52460.391984), -- Animal Skin
(20044, 1881, 1, 1, 2, 5245.991984), -- Coarse Bone Powder
(20044, 2144, 1, 1, 2, 7869.224048), -- Recipe: Compound Braid
-- Skeleton Scout
(20045, 734, 1, 1, -1, 44835), -- Haste Potion
(20045, 1925, 1, 1, -1, 176402), -- Leather Gloves Lining
(20045, 57, 126, 215, 0, 700000), -- Adena
(20045, 217, 1, 1, 1, 151.5), -- Shining Knife
(20045, 218, 1, 1, 1, 151.5), -- Throwing Knife
(20045, 1871, 1, 1, 2, 39731.163947), -- Charcoal
(20045, 1866, 1, 1, 2, 26487.413811), -- Suede
(20045, 2150, 1, 1, 2, 18653.09614), -- Recipe: Blue Diamond Necklace
(20045, 5268, 1, 1, 2, 1589.326102), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Stink Zombie
(20046, 2139, 1, 1, -1, 48936), -- Recipe: Steel Mold
(20046, 735, 1, 1, -1, 20390), -- Alacrity Potion
(20046, 1897, 1, 1, -1, 58257), -- Necklace of Wisdom Chain
(20046, 57, 115, 195, 0, 700000), -- Adena
(20046, 845, 1, 1, 1, 1056.623412), -- Cat's Eye Earring
(20046, 908, 1, 1, 1, 792.473578), -- Necklace of Wisdom
(20046, 1897, 1, 1, 1, 8603.967892), -- Necklace of Wisdom Chain
(20046, 877, 1, 1, 1, 1584.935118), -- Ring of Wisdom
(20046, 1867, 1, 1, 2, 48183.04145), -- Animal Skin
(20046, 1872, 1, 1, 2, 48183.04145), -- Animal Bone
(20046, 1882, 1, 1, 2, 8030.52594), -- Leather
(20046, 2173, 1, 1, 2, 9793.39116), -- Recipe: Hard Leather Shirt
-- Sukar Wererat Leader
(20047, 1869, 1, 1, -1, 222001), -- Iron Ore
(20047, 38, 1, 1, -1, 8522), -- Low Boots
(20047, 2139, 1, 1, -1, 44400), -- Recipe: Steel Mold
(20047, 57, 104, 177, 0, 700000), -- Adena
(20047, 24, 1, 1, 1, 420.33665), -- Bone Breastplate
(20047, 390, 1, 1, 1, 420.33665), -- Cotton Shirt
(20047, 31, 1, 1, 1, 671.16335), -- Bone Gaiters
(20047, 412, 1, 1, 1, 671.16335), -- Cotton Pants
(20047, 1864, 1, 1, 2, 43716.99248), -- Stem
(20047, 1869, 1, 1, 2, 21858.49624), -- Iron Ore
(20047, 1878, 1, 1, 2, 8743.36316), -- Braided Hemp
(20047, 2174, 1, 1, 2, 9503.70554), -- Recipe: Hard Leather Gaiters
(20047, 5273, 1, 1, 2, 874.30098), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20047, 734, 1, 1, 2, 3643.1416), -- Haste Potion
-- Lesser Succubus
(20048, 2144, 1, 1, -1, 45937), -- Recipe: Compound Braid
(20048, 50, 1, 1, -1, 8817), -- Leather Gloves
(20048, 1924, 1, 1, -1, 74091), -- Leather Helmet Design
(20048, 57, 106, 184, 0, 700000), -- Adena
(20048, 256, 1, 1, 1, 258), -- Cestus
(20048, 1868, 1, 1, 2, 90460.027138), -- Thread
(20048, 1873, 1, 1, 2, 18091.981908), -- Silver Nugget
(20048, 2142, 1, 1, 2, 9045.990954), -- Recipe: Varnish of Purity
-- Lycanthrope
(20049, 1882, 1, 1, -1, 61249), -- Leather
(20049, 1924, 1, 1, -1, 88910), -- Leather Helmet Design
(20049, 2140, 1, 1, -1, 55124), -- Recipe: High-Grade Suede
(20049, 57, 127, 221, 0, 700000), -- Adena
(20049, 256, 1, 1, 1, 310), -- Cestus
(20049, 1872, 1, 1, 2, 43420.565404), -- Animal Bone
(20049, 1867, 1, 1, 2, 43420.565404), -- Animal Skin
(20049, 1881, 1, 1, 2, 4342.09614), -- Coarse Bone Powder
(20049, 2143, 1, 1, 2, 6513.045211), -- Recipe: Synthetic Cokes
(20049, 5158, 1, 1, 2, 1302.727841), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Arachnid Predator
(20050, 735, 1, 1, -1, 25265), -- Alacrity Potion
(20050, 1866, 1, 1, -1, 202121), -- Suede
(20050, 1925, 1, 1, -1, 198808), -- Leather Gloves Lining
(20050, 57, 140, 243, 0, 700000), -- Adena
(20050, 15, 1, 1, 1, 170.613054), -- Short Spear
(20050, 2011, 1, 1, 1, 2043.386946), -- Short Spear Edge
(20050, 1866, 1, 1, 2, 29851.800528), -- Suede
(20050, 1871, 1, 1, 2, 44777.599296), -- Charcoal
(20050, 2144, 1, 1, 2, 8955.601056), -- Recipe: Compound Braid
(20050, 1831, 1, 1, 2, 119406.99912), -- Antidote
-- Skeleton Bowman
(20051, 2254, 1, 1, -1, 11407), -- Recipe: Composite Bow
(20051, 1925, 1, 1, -1, 182506), -- Leather Gloves Lining
(20051, 1867, 1, 1, -1, 371096), -- Animal Skin
(20051, 57, 129, 223, 0, 700000), -- Adena
(20051, 272, 1, 1, 1, 156.6041), -- Forest Bow
(20051, 2013, 1, 1, 1, 1774.3959), -- Forest Bow Shaft
(20051, 1872, 1, 1, 2, 43846.562656), -- Animal Bone
(20051, 1867, 1, 1, 2, 43846.562656), -- Animal Skin
(20051, 1881, 1, 1, 2, 4384.623616), -- Coarse Bone Powder
(20051, 2150, 1, 1, 2, 15438.90752), -- Recipe: Blue Diamond Necklace
(20051, 5268, 1, 1, 2, 1315.343552), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Lesser Succubus Turen
(20052, 1866, 1, 1, -1, 193642), -- Suede
(20052, 1868, 1, 1, -1, 580926), -- Thread
(20052, 1869, 1, 1, -1, 290463), -- Iron Ore
(20052, 57, 132, 236, 0, 700000), -- Adena
(20052, 219, 1, 1, 1, 91.30743), -- Sword Breaker
(20052, 2015, 1, 1, 1, 1046.69257), -- Sword Breaker Edge
(20052, 1869, 1, 1, 2, 34319.45224), -- Iron Ore
(20052, 1864, 1, 1, 2, 68639.013616), -- Stem
(20052, 1880, 1, 1, 2, 3431.999792), -- Steel
(20052, 1804, 1, 1, 2, 1372.821744), -- Recipe: Soulshot (D-Grade)
(20052, 5158, 1, 1, 2, 1372.712608), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Ol Mahum Patrol
(20053, 2015, 1, 1, -1, 4292), -- Sword Breaker Edge
(20053, 1926, 1, 1, -1, 35553), -- Piece Bone Breastplate Fragment
(20053, 1898, 1, 1, -1, 36155), -- Blue Diamond Necklace Gem
(20053, 57, 160, 286, 0, 700000), -- Adena
(20053, 39, 1, 1, 1, 1459.212084), -- Boots
(20053, 1930, 1, 1, 1, 17772.555141), -- Boot Lining
(20053, 51, 1, 1, 1, 1459.232775), -- Bracer
(20053, 1864, 1, 1, 2, 83174.087694), -- Stem
(20053, 1869, 1, 1, 2, 41587.043847), -- Iron Ore
(20053, 1878, 1, 1, 2, 16634.75594), -- Braided Hemp
(20053, 2151, 1, 1, 2, 11584.116331), -- Recipe: Necklace of Devotion
(20053, 5437, 1, 1, 2, 1016.996188), -- Recipe: Heavy Sword(100%)
-- Ruin Spartoi
(20054, 1880, 1, 1, -1, 34172), -- Steel
(20054, 3032, 1, 1, -1, 13669), -- Recipe: Spiritshot D
(20054, 1804, 1, 1, -1, 13669), -- Recipe: Soulshot (D-Grade)
(20054, 57, 156, 278, 0, 700000), -- Adena
(20054, 39, 1, 1, 1, 1416.686112), -- Boots
(20054, 1930, 1, 1, 1, 17254.607688), -- Boot Lining
(20054, 51, 1, 1, 1, 1416.7062), -- Bracer
(20054, 1867, 1, 1, 2, 53834.08194), -- Animal Skin
(20054, 1872, 1, 1, 2, 53834.08194), -- Animal Bone
(20054, 1882, 1, 1, 2, 8972.301132), -- Leather
(20054, 2176, 1, 1, 2, 19318.416228), -- Recipe: Leather Boots
(20054, 5268, 1, 1, 2, 1615.11876), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Wandering Eye
(20055, 2176, 1, 1, -1, 163503), -- Recipe: Leather Boots
(20055, 1928, 1, 1, -1, 49777), -- Piece Bone Gaiters Fragment
(20055, 1926, 1, 1, -1, 34517), -- Piece Bone Breastplate Fragment
(20055, 57, 156, 278, 0, 700000), -- Adena
(20055, 219, 1, 1, 1, 107.35443), -- Sword Breaker
(20055, 2015, 1, 1, 1, 1230.64557), -- Sword Breaker Edge
(20055, 1869, 1, 1, 2, 40375.716636), -- Iron Ore
(20055, 1864, 1, 1, 2, 80751.433272), -- Stem
(20055, 1880, 1, 1, 2, 4037.515092), -- Steel
(20055, 2177, 1, 1, 2, 12899.597661), -- Recipe: Bone Helmet
(20055, 735, 1, 1, 2, 3364.737339), -- Alacrity Potion
-- Dre Vanul Disposer
(20056, 1926, 1, 1, -1, 34201), -- Piece Bone Breastplate Fragment
(20056, 5163, 1, 1, -1, 13543), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20056, 2151, 1, 1, -1, 94314), -- Recipe: Necklace of Devotion
(20056, 57, 154, 276, 0, 700000), -- Adena
(20056, 27, 1, 1, 1, 352.163077), -- Hard Leather Shirt
(20056, 1927, 1, 1, 1, 3989.348954), -- Hard Leather Shirt Pattern
(20056, 33, 1, 1, 1, 565.042096), -- Hard Leather Gaiters
(20056, 1929, 1, 1, 1, 6452.445873), -- Hard Leather Gaiters Material
(20056, 1868, 1, 1, 2, 100013.252364), -- Thread
(20056, 1873, 1, 1, 2, 20002.702302), -- Silver Nugget
(20056, 2256, 1, 1, 2, 1222.650828), -- Recipe: Assassin Knife
(20056, 734, 1, 1, 2, 8334.394506), -- Haste Potion
-- Lesser Succubus Tilfo
(20057, 2176, 1, 1, -1, 147276), -- Recipe: Leather Boots
(20057, 2258, 1, 1, -1, 7526), -- Recipe: Temptation of Abyss
(20057, 1927, 1, 1, -1, 24556), -- Hard Leather Shirt Pattern
(20057, 57, 140, 251, 0, 700000), -- Adena
(20057, 1102, 1, 1, 1, 640.425264), -- Tunic of Magic
(20057, 1105, 1, 1, 1, 1027.574736), -- Stockings of Magic
(20057, 1870, 1, 1, 2, 45460.579741), -- Coal
(20057, 1865, 1, 1, 2, 45460.579741), -- Varnish
(20057, 2257, 1, 1, 2, 1111.477393), -- Recipe: Trident
(20057, 5273, 1, 1, 2, 1818.363125), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Ol Mahum Guard
(20058, 1873, 1, 1, -1, 144850), -- Silver Nugget
(20058, 1926, 1, 1, -1, 36578), -- Piece Bone Breastplate Fragment
(20058, 1865, 1, 1, -1, 362125), -- Varnish
(20058, 57, 164, 295, 0, 700000), -- Adena
(20058, 16, 1, 1, 1, 228), -- Great Spear
(20058, 1865, 1, 1, 2, 53483.196944), -- Varnish
(20058, 1870, 1, 1, 2, 53483.196944), -- Coal
(20058, 1879, 1, 1, 2, 8913.90522), -- Cokes
(20058, 2258, 1, 1, 2, 1307.700892), -- Recipe: Temptation of Abyss
-- Hungry Eye
(20059, 2177, 1, 1, -1, 115695), -- Recipe: Bone Helmet
(20059, 32, 1, 1, -1, 4734), -- Piece Bone Gaiters
(20059, 1879, 1, 1, -1, 60354), -- Cokes
(20059, 57, 164, 295, 0, 700000), -- Adena
(20059, 625, 1, 1, 1, 2160.640404), -- Bone Shield
(20059, 1148, 1, 1, 1, 1506.359596), -- Hard Leather Helmet
(20059, 1870, 1, 1, 2, 53483.147405), -- Coal
(20059, 1865, 1, 1, 2, 53483.147405), -- Varnish
(20059, 3032, 1, 1, 2, 2139.352595), -- Recipe: Spiritshot D
(20059, 5158, 1, 1, 2, 2139.352595); -- Recipe: Spiritshot (D) Compressed Package (100%)

INSERT INTO `droplist` VALUES
-- Raging Spartoi
(20060, 1869, 1, 1, -1, 369368), -- Iron Ore
(20060, 1928, 1, 1, -1, 53805), -- Piece Bone Gaiters Fragment
(20060, 57, 168, 301, 0, 700000), -- Adena
(20060, 87, 1, 1, 1, 58.02444), -- Iron Hammer
(20060, 2014, 1, 1, 1, 626.927481), -- Iron Hammer Head
(20060, 155, 1, 1, 1, 58.02444), -- Flanged Mace
(20060, 177, 1, 1, 1, 58.023639), -- Mage Staff
(20060, 1870, 1, 1, 2, 43642.188839), -- Coal
(20060, 1865, 1, 1, 2, 43642.188839), -- Varnish
(20060, 3953, 1, 1, 2, 1745.709363), -- Recipe: Blessed Spiritshot D
(20060, 6666, 1, 1, 2, 43642.188839), -- Deluxe Chest Key - Grade 2
(20060, 735, 1, 1, 2, 3636.72412), -- Alacrity Potion
-- Ol Mahum Straggler
(20061, 1880, 1, 1, -1, 38571), -- Steel
(20061, 1927, 1, 1, -1, 30770), -- Hard Leather Shirt Pattern
(20061, 2176, 1, 1, -1, 184549), -- Recipe: Leather Boots
(20061, 57, 177, 312, 0, 700000), -- Adena
(20061, 273, 1, 1, 1, 121.177056), -- Composite Bow
(20061, 2016, 1, 1, 1, 1334.822944), -- Composite Bow Shaft
(20061, 1866, 1, 1, 2, 30381.9065), -- Suede
(20061, 1871, 1, 1, 2, 45572.984215), -- Charcoal
(20061, 2257, 1, 1, 2, 1114.21068), -- Recipe: Trident
(20061, 5268, 1, 1, 2, 1822.91439), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20061, 6666, 1, 1, 2, 45572.984215), -- Deluxe Chest Key - Grade 2
-- Tumran Bugbear
(20062, 2257, 1, 1, -1, 9246), -- Recipe: Trident
(20062, 27, 1, 1, -1, 2663), -- Hard Leather Shirt
(20062, 1929, 1, 1, -1, 48793), -- Hard Leather Gaiters Material
(20062, 57, 173, 305, 0, 700000), -- Adena
(20062, 219, 1, 1, 1, 118.828035), -- Sword Breaker
(20062, 2015, 1, 1, 1, 1362.171965), -- Sword Breaker Edge
(20062, 1872, 1, 1, 2, 59572.137482), -- Animal Bone
(20062, 1867, 1, 1, 2, 59572.137482), -- Animal Skin
(20062, 1881, 1, 1, 2, 5957.145399), -- Coarse Bone Powder
(20062, 2258, 1, 1, 2, 1092.391089), -- Recipe: Temptation of Abyss
(20062, 6666, 1, 1, 2, 44679.188548), -- Deluxe Chest Key - Grade 2
-- Ol Mahum Shooter
(20063, 2176, 1, 1, -1, 196828), -- Recipe: Leather Boots
(20063, 34, 1, 1, -1, 3486), -- Bronze Gaiters
(20063, 2177, 1, 1, -1, 131428), -- Recipe: Bone Helmet
(20063, 57, 183, 337, 0, 700000), -- Adena
(20063, 273, 1, 1, 1, 129.249978), -- Composite Bow
(20063, 2016, 1, 1, 1, 1423.750022), -- Composite Bow Shaft
(20063, 1867, 1, 1, 2, 54005.375768), -- Animal Skin
(20063, 1872, 1, 1, 2, 54005.375768), -- Animal Bone
(20063, 1882, 1, 1, 2, 9000.842586), -- Leather
(20063, 1804, 1, 1, 2, 1620.154868), -- Recipe: Soulshot (D-Grade)
(20063, 6666, 1, 1, 2, 40504.031826), -- Deluxe Chest Key - Grade 2
(20063, 8294, 1, 1, 2, 990.219184), -- Recipe: Steel Sword (100%)
-- Tumran Bugbear Warrior
(20064, 1873, 1, 1, -1, 162950), -- Silver Nugget
(20064, 1926, 1, 1, -1, 41149), -- Piece Bone Breastplate Fragment
(20064, 1930, 1, 1, -1, 104455), -- Boot Lining
(20064, 57, 181, 334, 0, 700000), -- Adena
(20064, 27, 1, 1, 1, 423.718001), -- Hard Leather Shirt
(20064, 1927, 1, 1, 1, 4799.932402), -- Hard Leather Shirt Pattern
(20064, 33, 1, 1, 1, 679.851248), -- Hard Leather Gaiters
(20064, 1929, 1, 1, 1, 7763.498349), -- Hard Leather Gaiters Material
(20064, 1866, 1, 1, 2, 32088.633729), -- Suede
(20064, 1871, 1, 1, 2, 48132.893994), -- Charcoal
(20064, 2179, 1, 1, 2, 23030.110152), -- Recipe: Crafted Leather Gloves
(20064, 5273, 1, 1, 2, 1925.288592), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20064, 734, 1, 1, 2, 8022.073533), -- Haste Potion
-- Ol Mahum Captain
(20066, 1865, 1, 1, -1, 445204), -- Varnish
(20066, 347, 1, 1, -1, 1387), -- Ring Mail Breastplate
(20066, 1873, 1, 1, -1, 178082), -- Silver Nugget
(20066, 57, 196, 367, 0, 700000), -- Adena
(20066, 347, 1, 1, 1, 389.044172), -- Ring Mail Breastplate
(20066, 376, 1, 1, 1, 622.955828), -- Iron Plate Gaiters
(20066, 1868, 1, 1, 2, 99945.297768), -- Thread
(20066, 1873, 1, 1, 2, 19989.005894), -- Silver Nugget
(20066, 5549, 1, 1, 2, 4997.318548), -- Metallic Thread
(20066, 2178, 1, 1, 2, 7995.682847), -- Recipe: Dark Stockings
(20066, 8294, 1, 1, 2, 1221.694943), -- Recipe: Steel Sword (100%)
-- Monster Eye Watcher
(20067, 2180, 1, 1, -1, 31555), -- Recipe: Scale Mail
(20067, 2020, 1, 1, -1, 7347), -- Temptation of Abyss Piece
(20067, 1869, 1, 1, -1, 419687), -- Iron Ore
(20067, 57, 185, 346, 0, 700000), -- Adena
(20067, 847, 1, 1, 1, 568.9424), -- Red Crescent Earring
(20067, 910, 1, 1, 1, 426.7068), -- Necklace of Devotion
(20067, 1899, 1, 1, 1, 9200.92615), -- Necklace of Devotion Chain
(20067, 890, 1, 1, 1, 853.42465), -- Ring of Devotion
(20067, 1864, 1, 1, 2, 117770.806104), -- Stem
(20067, 1869, 1, 1, 2, 58885.403052), -- Iron Ore
(20067, 1878, 1, 1, 2, 23554.243076), -- Braided Hemp
(20067, 2180, 1, 1, 2, 4427.547768), -- Recipe: Scale Mail
-- Monster Eye Destroyer
(20068, 2261, 1, 1, -1, 7002), -- Recipe: Conjuror's Staff
(20068, 391, 1, 1, -1, 1871), -- Puma Skin Shirt
(20068, 1899, 1, 1, -1, 70456), -- Necklace of Devotion Chain
(20068, 57, 196, 374, 0, 700000), -- Adena
(20068, 101, 1, 1, 1, 32.150125), -- Scroll of Wisdom
(20068, 312, 1, 1, 1, 32.150125), -- Branch of Life
(20068, 313, 1, 1, 1, 32.150125), -- Temptation of Abyss
(20068, 2020, 1, 1, 1, 886.40153), -- Temptation of Abyss Piece
(20068, 314, 1, 1, 1, 32.148095), -- Proof of Revenge
(20068, 1864, 1, 1, 2, 126533.87649), -- Stem
(20068, 1869, 1, 1, 2, 63267.04629), -- Iron Ore
(20068, 1878, 1, 1, 2, 25306.73208), -- Braided Hemp
(20068, 2262, 1, 1, 2, 982.34514), -- Recipe: Elven Bow
-- Lesser Basilisk
(20070, 1872, 1, 1, -1, 621523), -- Animal Bone
(20070, 2182, 1, 1, -1, 55959), -- Recipe: Scale Gaiters
(20070, 2152, 1, 1, -1, 82067), -- Recipe: Enchanted Necklace
(20070, 57, 201, 388, 0, 700000), -- Adena
(20070, 40, 1, 1, 1, 812.471808), -- Leather Boots
(20070, 1931, 1, 1, 1, 8549.528192), -- Leather Boots Lining
(20070, 604, 1, 1, 1, 812.471808), -- Crafted Leather Gloves
(20070, 1934, 1, 1, 1, 8549.528192), -- Crafted Leather Gloves Lining
(20070, 1872, 1, 1, 2, 69763.43844), -- Animal Bone
(20070, 1867, 1, 1, 2, 69763.43844), -- Animal Skin
(20070, 1881, 1, 1, 2, 6976.343844), -- Coarse Bone Powder
(20070, 1875, 1, 1, 2, 3488.247324), -- Stone of Purity
(20070, 2263, 1, 1, 2, 812.531952), -- Recipe: Dwarven Trident
-- Basilisk
(20072, 2263, 1, 1, -1, 7608), -- Recipe: Dwarven Trident
(20072, 3953, 1, 1, -1, 19599), -- Recipe: Blessed Spiritshot D
(20072, 1931, 1, 1, -1, 64050), -- Leather Boots Lining
(20072, 57, 210, 411, 0, 700000), -- Adena
(20072, 626, 1, 1, 1, 1084.75878), -- Bronze Shield
(20072, 45, 1, 1, 1, 760.678815), -- Bone Helmet
(20072, 1932, 1, 1, 1, 14549.562405), -- Bone Helmet Design
(20072, 1866, 1, 1, 2, 26189.970019), -- Suede
(20072, 1871, 1, 1, 2, 39285.011773), -- Charcoal
(20072, 5220, 1, 1, 2, 1571.368694), -- Metal Hardener
(20072, 1885, 1, 1, 2, 3273.703694), -- High-Grade Suede
(20072, 2262, 1, 1, 2, 610.003375), -- Recipe: Elven Bow
(20072, 6666, 1, 1, 2, 39285.011773), -- Deluxe Chest Key - Grade 2
(20072, 6035, 1, 1, 2, 3273.930672), -- Magic Haste Potion
-- Androscorpio
(20074, 1869, 1, 1, -1, 507790), -- Iron Ore
(20074, 1061, 1, 1, -1, 307751), -- Greater Healing Potion
(20074, 1900, 1, 1, -1, 55557), -- Enchanted Necklace Chain
(20074, 57, 215, 426, 0, 700000), -- Adena
(20074, 1123, 1, 1, 1, 1084), -- Blue Buckskin Boots
(20074, 605, 1, 1, 1, 1084), -- Leather Gauntlets
(20074, 1869, 1, 1, 2, 46247.94342), -- Iron Ore
(20074, 1864, 1, 1, 2, 92495.88684), -- Stem
(20074, 1880, 1, 1, 2, 4624.83948), -- Steel
(20074, 5550, 1, 1, 2, 616.58508), -- Durable Metal Plate
(20074, 737, 1, 1, 2, 4624.83948), -- Scroll of Resurrection
(20074, 6387, 1, 1, 2, 1849.9057), -- Blessed Scroll of Resurrection for Pets
-- Ant Larva
(20075, 1061, 1, 1, -1, 282105), -- Greater Healing Potion
(20075, 348, 1, 1, -1, 908), -- Scale Mail
(20075, 2153, 1, 1, -1, 72391), -- Recipe: Tiger's Eye Earring
(20075, 57, 197, 391, 0, 700000), -- Adena
(20075, 848, 1, 1, 1, 387.77028), -- Enchanted Earring
(20075, 911, 1, 1, 1, 291.04554), -- Enchanted Necklace
(20075, 1900, 1, 1, 1, 6957.75324), -- Enchanted Necklace Chain
(20075, 879, 1, 1, 1, 583.43094), -- Enchanted Ring
(20075, 1871, 1, 1, 2, 42393.94416), -- Charcoal
(20075, 1866, 1, 1, 2, 28262.62944), -- Suede
(20075, 1877, 1, 1, 2, 1695.796016), -- Adamantite Nugget
(20075, 955, 1, 1, 2, 169.636976), -- Scroll: Enchant Weapon (D-Grade)
(20075, 2193, 1, 1, 2, 5675.2844), -- Recipe: Boots of Power
(20075, 1831, 1, 1, 2, 113050.709008), -- Antidote
-- Ol Mahum Commander
(20076, 2250, 1, 1, -1, 134666), -- Recipe: Bone Arrow
(20076, 1880, 1, 1, -1, 53866), -- Steel
(20076, 1900, 1, 1, -1, 58935), -- Enchanted Necklace Chain
(20076, 57, 228, 452, 0, 700000), -- Adena
(20076, 1123, 1, 1, 1, 1150), -- Blue Buckskin Boots
(20076, 605, 1, 1, 1, 1150), -- Leather Gauntlets
(20076, 1869, 1, 1, 2, 49059.738825), -- Iron Ore
(20076, 1864, 1, 1, 2, 98119.47765), -- Stem
(20076, 1880, 1, 1, 2, 4906.0203), -- Steel
(20076, 5550, 1, 1, 2, 654.1773), -- Durable Metal Plate
(20076, 956, 1, 1, 2, 1635.288525), -- Scroll: Enchant Armor (D-Grade)
(20076, 2274, 1, 1, 2, 350.2974), -- Recipe: Skull Breaker
-- Androscorpio Hunter
(20077, 2153, 1, 1, -1, 82578), -- Recipe: Tiger's Eye Earring
(20077, 1933, 1, 1, -1, 62468), -- Dark Stockings Fabric
(20077, 2183, 1, 1, -1, 34933), -- Recipe: Mithril Banded Mail
(20077, 57, 224, 448, 0, 700000), -- Adena
(20077, 627, 1, 1, 1, 1078.49287), -- Aspis
(20077, 46, 1, 1, 1, 755.50713), -- Bronze Helmet
(20077, 1870, 1, 1, 2, 72539.884816), -- Coal
(20077, 1865, 1, 1, 2, 72539.884816), -- Varnish
(20077, 1874, 1, 1, 2, 4836.032376), -- Oriharukon Ore
(20077, 955, 1, 1, 2, 290.197992), -- Scroll: Enchant Weapon (D-Grade)
-- Whispering Wind
(20078, 2024, 1, 1, -1, 7564), -- Elven Bow Shaft
(20078, 2023, 1, 1, -1, 6580), -- Conjuror's Staff Head
(20078, 1900, 1, 1, -1, 58094), -- Enchanted Necklace Chain
(20078, 57, 224, 448, 0, 700000), -- Adena
(20078, 433, 1, 1, 1, 94.332676), -- Elven Tunic
(20078, 434, 1, 1, 1, 94.332676), -- White Tunic
(20078, 1936, 1, 1, 1, 2968.270564), -- White Tunic Pattern
(20078, 435, 1, 1, 1, 94.332676), -- Mystic's Tunic
(20078, 466, 1, 1, 1, 151.133176), -- Elven Stockings
(20078, 467, 1, 1, 1, 151.133176), -- Dark Stockings
(20078, 1933, 1, 1, 1, 4267.323908), -- Dark Stockings Fabric
(20078, 468, 1, 1, 1, 151.141148), -- Mystic's Stockings
(20078, 1868, 1, 1, 2, 116063.493736), -- Thread
(20078, 1873, 1, 1, 2, 23212.73434), -- Silver Nugget
(20078, 5549, 1, 1, 2, 5803.228076), -- Metallic Thread
(20078, 1889, 1, 1, 2, 3868.759396), -- Compound Braid
(20078, 736, 1, 1, 2, 29015.784452), -- Scroll of Escape
-- Ant
(20079, 1866, 1, 1, -1, 353985), -- Suede
(20079, 2266, 1, 1, -1, 5491), -- Recipe: Shilen Knife
(20079, 1881, 1, 1, -1, 70797), -- Coarse Bone Powder
(20079, 57, 224, 448, 0, 700000), -- Adena
(20079, 848, 1, 1, 1, 442.303424), -- Enchanted Earring
(20079, 911, 1, 1, 1, 331.976032), -- Enchanted Necklace
(20079, 1900, 1, 1, 1, 7936.240192), -- Enchanted Necklace Chain
(20079, 879, 1, 1, 1, 665.480352), -- Enchanted Ring
(20079, 1872, 1, 1, 2, 55268.379684), -- Animal Bone
(20079, 1867, 1, 1, 2, 55268.379684), -- Animal Skin
(20079, 1881, 1, 1, 2, 5526.88206), -- Coarse Bone Powder
(20079, 1875, 1, 1, 2, 2763.367544), -- Stone of Purity
(20079, 2183, 1, 1, 2, 2727.06546), -- Recipe: Mithril Banded Mail
(20079, 2278, 1, 1, 2, 296.14858), -- Recipe: Reinforced Long Bow
(20079, 1061, 1, 1, 2, 25121.776988), -- Greater Healing Potion
-- Ant Captain
(20080, 2268, 1, 1, -1, 5950), -- Recipe: Tome of Blood
(20080, 2021, 1, 1, -1, 7264), -- Spinebone Sword Blade
(20080, 1878, 1, 1, -1, 230138), -- Braided Hemp
(20080, 57, 243, 485, 0, 700000), -- Adena
(20080, 259, 1, 1, 1, 127), -- Single-Edged Jamadhr
(20080, 1864, 1, 1, 2, 104801.321735), -- Stem
(20080, 1869, 1, 1, 2, 52400.76974), -- Iron Ore
(20080, 1878, 1, 1, 2, 20960.351445), -- Braided Hemp
(20080, 1884, 1, 1, 2, 32246.510285), -- Cord
(20080, 737, 1, 1, 2, 5240.033425), -- Scroll of Resurrection
(20080, 6387, 1, 1, 2, 2096.01337), -- Blessed Scroll of Resurrection for Pets
-- Ant Overseer
(20081, 1061, 1, 1, -1, 583400), -- Greater Healing Potion
(20081, 1933, 1, 1, -1, 113248), -- Dark Stockings Fabric
(20081, 57, 406, 814, 0, 700000), -- Adena
(20081, 848, 1, 1, 1, 801.863652), -- Enchanted Earring
(20081, 911, 1, 1, 1, 601.848186), -- Enchanted Necklace
(20081, 1900, 1, 1, 1, 14387.821116), -- Enchanted Necklace Chain
(20081, 879, 1, 1, 1, 1206.467046), -- Enchanted Ring
(20081, 1874, 1, 1, 2, 5009.78334), -- Oriharukon Ore
(20081, 1878, 1, 1, 2, 30058.609398), -- Braided Hemp
(20081, 1884, 1, 1, 2, 46244.098128), -- Cord
(20081, 1889, 1, 1, 2, 5009.78334), -- Compound Braid
(20081, 5220, 1, 1, 2, 3005.870004), -- Metal Hardener
(20081, 2267, 1, 1, 2, 777.073866), -- Recipe: Gastraphetes
(20081, 2274, 1, 1, 2, 536.781924), -- Recipe: Skull Breaker
-- Ant Recruit
(20082, 1884, 1, 1, -1, 357298), -- Cord
(20082, 2275, 1, 1, -1, 4147), -- Recipe: Heavy Bone Club
(20082, 1901, 1, 1, -1, 80195), -- Tiger's Eye Earring Stone
(20082, 57, 245, 491, 0, 700000), -- Adena
(20082, 553, 1, 1, 1, 225.588736), -- Iron Boots
(20082, 1940, 1, 1, 1, 6582.467584), -- Iron Boots Design
(20082, 2422, 1, 1, 1, 225.588736), -- Reinforced Leather Boots
(20082, 2423, 1, 1, 1, 225.588736), -- Boots of Knowledge
(20082, 63, 1, 1, 1, 225.588736), -- Gauntlets
(20082, 2446, 1, 1, 1, 225.588736), -- Reinforced Leather Gloves
(20082, 2447, 1, 1, 1, 225.588736), -- Gloves of Knowledge
(20082, 1875, 1, 1, 2, 2572.555764), -- Stone of Purity
(20082, 1879, 1, 1, 2, 6431.289876), -- Cokes
(20082, 1885, 1, 1, 2, 3215.678116), -- High-Grade Suede
(20082, 5550, 1, 1, 2, 514.524424), -- Durable Metal Plate
(20082, 5549, 1, 1, 2, 3858.800468), -- Metallic Thread
(20082, 2154, 1, 1, 2, 4131.457272), -- Recipe: Elven Earring
(20082, 2190, 1, 1, 2, 2756.295528), -- Recipe: Mithril Stockings
(20082, 1832, 1, 1, 2, 42875.398552), -- Greater Antidote
-- Granite Golem
(20083, 2987, 1, 1, -1, 69132), -- Recipe: Plate Shield
(20083, 2975, 1, 1, -1, 63577), -- Recipe: Brigandine Helmet
(20083, 2154, 1, 1, -1, 76237), -- Recipe: Elven Earring
(20083, 57, 301, 602, 0, 700000), -- Adena
(20083, 393, 1, 1, 1, 107.856888), -- Mithril Banded Mail
(20083, 1938, 1, 1, 1, 4241.629608), -- Mithril Banded Mail Material
(20083, 394, 1, 1, 1, 107.856888), -- Reinforced Leather Shirt
(20083, 415, 1, 1, 1, 172.393104), -- Mithril Banded Gaiters
(20083, 1939, 1, 1, 1, 5541.880752), -- Mithril Banded Gaiters Material
(20083, 416, 1, 1, 1, 172.38276), -- Reinforced Leather Gaiters
(20083, 1874, 1, 1, 2, 3154.944515), -- Oriharukon Ore
(20083, 1878, 1, 1, 2, 18929.66709), -- Braided Hemp
(20083, 1884, 1, 1, 2, 29122.575362), -- Cord
(20083, 1889, 1, 1, 2, 3154.944515), -- Compound Braid
(20083, 5220, 1, 1, 2, 1892.966709), -- Metal Hardener
(20083, 2155, 1, 1, 2, 7596.138292), -- Recipe: Elven Ring
(20083, 2286, 1, 1, 2, 262.917789), -- Recipe: Bonebreaker
(20083, 2985, 1, 1, 2, 4838.845728), -- Recipe: Plate Boots
-- Ant Patrol
(20084, 1885, 1, 1, -1, 55207), -- High-Grade Suede
(20084, 2978, 1, 1, -1, 88686), -- Recipe: Elven Mithril Boots
(20084, 1938, 1, 1, -1, 44537), -- Mithril Banded Mail Material
(20084, 57, 280, 558, 0, 700000), -- Adena
(20084, 628, 1, 1, 1, 858.99538), -- Hoplon
(20084, 47, 1, 1, 1, 601.00462), -- Helmet
(20084, 1876, 1, 1, 2, 8805.965454), -- Mithril Ore
(20084, 1880, 1, 1, 2, 4402.982727), -- Steel
(20084, 1877, 1, 1, 2, 1761.157079), -- Adamantite Nugget
(20084, 1881, 1, 1, 2, 5870.643636), -- Coarse Bone Powder
(20084, 1882, 1, 1, 2, 9784.40606), -- Leather
(20084, 2269, 1, 1, 2, 314.563073), -- Recipe: Morning Star
(20084, 2971, 1, 1, 2, 2354.451484), -- Recipe: Mithril Scale Gaiters
(20084, 1341, 10, 30, 2, 146764.830487), -- Bone Arrow
-- Puncher
(20085, 2278, 1, 1, -1, 5472), -- Recipe: Reinforced Long Bow
(20085, 2422, 1, 1, -1, 3918), -- Reinforced Leather Boots
(20085, 2155, 1, 1, -1, 122961), -- Recipe: Elven Ring
(20085, 57, 324, 645, 0, 700000), -- Adena
(20085, 553, 1, 1, 1, 297.62022), -- Iron Boots
(20085, 1940, 1, 1, 1, 8684.27868), -- Iron Boots Design
(20085, 2422, 1, 1, 1, 297.62022), -- Reinforced Leather Boots
(20085, 2423, 1, 1, 1, 297.62022), -- Boots of Knowledge
(20085, 63, 1, 1, 1, 297.62022), -- Gauntlets
(20085, 2446, 1, 1, 1, 297.62022), -- Reinforced Leather Gloves
(20085, 2447, 1, 1, 1, 297.62022), -- Gloves of Knowledge
(20085, 1870, 1, 1, 2, 67883.652096), -- Coal
(20085, 1865, 1, 1, 2, 67883.652096), -- Varnish
(20085, 1874, 1, 1, 2, 4525.517568), -- Oriharukon Ore
(20085, 2270, 1, 1, 2, 484.866304), -- Recipe: Goat Head Staff
(20085, 2293, 1, 1, 2, 377.200512), -- Recipe: Glaive
(20085, 2986, 1, 1, 2, 6941.111424), -- Recipe: Sage's Worn Gloves
-- Ant Guard
(20086, 1868, 1, 3, -1, 588224), -- Thread
(20086, 469, 1, 1, -1, 1607), -- Stockings of Knowledge
(20086, 1939, 1, 1, -1, 51667), -- Mithril Banded Gaiters Material
(20086, 57, 248, 496, 0, 700000), -- Adena
(20086, 436, 1, 1, 1, 267.47631), -- Tunic of Knowledge
(20086, 469, 1, 1, 1, 427.52369), -- Stockings of Knowledge
(20086, 1874, 1, 1, 2, 2978.613478), -- Oriharukon Ore
(20086, 1878, 1, 1, 2, 17871.56923), -- Braided Hemp
(20086, 1884, 1, 1, 2, 27494.709011), -- Cord
(20086, 1889, 1, 1, 2, 2978.613478), -- Compound Braid
(20086, 5220, 1, 1, 2, 1787.156923), -- Metal Hardener
(20086, 2972, 1, 1, 2, 2389.220657), -- Recipe: Brigandine Gaiters
(20086, 8307, 1, 1, 2, 319.117223), -- Recipe: Priest Mace (100%)
-- Ant Soldier
(20087, 2191, 1, 1, -1, 188912), -- Recipe: RIP Gauntlets
(20087, 1940, 1, 1, -1, 210623), -- Iron Boots Design
(20087, 1866, 1, 1, -1, 940782), -- Suede
(20087, 57, 596, 1189, 0, 700000), -- Adena
(20087, 393, 1, 1, 1, 213.763927), -- Mithril Banded Mail
(20087, 1938, 1, 1, 1, 8406.578557), -- Mithril Banded Mail Material
(20087, 394, 1, 1, 1, 213.763927), -- Reinforced Leather Shirt
(20087, 415, 1, 1, 1, 341.669666), -- Mithril Banded Gaiters
(20087, 1939, 1, 1, 1, 10983.574758), -- Mithril Banded Gaiters Material
(20087, 416, 1, 1, 1, 341.649165), -- Reinforced Leather Gaiters
(20087, 1871, 1, 1, 2, 93788.817808), -- Charcoal
(20087, 1866, 1, 1, 2, 62525.7801), -- Suede
(20087, 1877, 1, 1, 2, 3751.694464), -- Adamantite Nugget
(20087, 2975, 1, 1, 2, 8373.980496), -- Recipe: Brigandine Helmet
(20087, 2984, 1, 1, 2, 9589.796468), -- Recipe: Salamander Skin Boots
(20087, 3020, 1, 1, 2, 520.937424), -- Recipe: Elven Long Sword
(20087, 2980, 1, 1, 2, 12555.35974), -- Recipe: Brigandine Gauntlets
(20087, 1832, 1, 1, 2, 104209.6335), -- Greater Antidote
-- Ant Warrior Captain
(20088, 2149, 1, 1, -1, 112102), -- Recipe: Metallic Fiber
(20088, 1895, 1, 1, -1, 448410), -- Metallic Fiber
(20088, 1875, 1, 1, -1, 104629), -- Stone of Purity
(20088, 57, 662, 1326, 0, 700000), -- Adena
(20088, 293, 1, 1, 1, 112), -- War Hammer
(20088, 296, 1, 1, 1, 112), -- Dwarven Pike
(20088, 1872, 1, 1, 2, 185434.842315), -- Animal Bone
(20088, 1867, 1, 1, 2, 185434.842315), -- Animal Skin
(20088, 1881, 1, 1, 2, 18543.684457), -- Coarse Bone Powder
(20088, 1875, 1, 1, 2, 9271.642003), -- Stone of Purity
(20088, 2270, 1, 1, 2, 993.518931), -- Recipe: Goat Head Staff
(20088, 2288, 1, 1, 2, 772.469979), -- Recipe: Ghost Staff
-- Noble Ant
(20089, 1884, 1, 1, -1, 402384), -- Cord
(20089, 2159, 1, 1, -1, 40363), -- Recipe: Necklace of Darkness
(20089, 1902, 1, 1, -1, 66249), -- Elven Earring Beads
(20089, 57, 276, 551, 0, 700000), -- Adena
(20089, 395, 1, 1, 1, 98.256501), -- Manticore Skin Shirt
(20089, 1942, 1, 1, 1, 4310.137062), -- Manticore Skin Shirt Texture
(20089, 417, 1, 1, 1, 156.919455), -- Manticore Skin Gaiters
(20089, 1943, 1, 1, 1, 6711.686982), -- Manticore Skin Gaiters Pattern
(20089, 1875, 1, 1, 2, 2816.692902), -- Stone of Purity
(20089, 1879, 1, 1, 2, 7041.719876), -- Cokes
(20089, 1885, 1, 1, 2, 3520.859938), -- High-Grade Suede
(20089, 5550, 1, 1, 2, 563.343532), -- Durable Metal Plate
(20089, 5549, 1, 1, 2, 4225.026974), -- Metallic Thread
(20089, 1825, 1, 1, 2, 3017.87641), -- Recipe: Oriharukon
(20089, 2205, 1, 1, 2, 1337.031032), -- Recipe: Chain Gaiters
(20089, 2989, 1, 1, 2, 2235.449336), -- Recipe: Chain Hood
-- Noble Ant Leader
(20090, 2197, 1, 1, -1, 30160), -- Recipe: Salamander Skin Mail
(20090, 1868, 1, 7, -1, 719317), -- Thread
(20090, 1825, 1, 1, -1, 102760), -- Recipe: Oriharukon
(20090, 57, 608, 1214, 0, 700000), -- Adena
(20090, 352, 1, 1, 1, 107.918108), -- Brigandine Tunic
(20090, 1941, 1, 1, 1, 4929.057129), -- Brigandine Temper
(20090, 2377, 1, 1, 1, 172.624777), -- Mithril Scale Gaiters
(20090, 2918, 1, 1, 1, 7353.397649), -- Mithril Scale Gaiters Material
(20090, 2378, 1, 1, 1, 172.624777), -- Brigandine Gaiters
(20090, 2919, 1, 1, 1, 7353.37756), -- Brigandine Gaiters Material
(20090, 1876, 1, 1, 2, 18591.570984), -- Mithril Ore
(20090, 1880, 1, 1, 2, 9295.785492), -- Steel
(20090, 1877, 1, 1, 2, 3718.47126), -- Adamantite Nugget
(20090, 1881, 1, 1, 2, 12394.24977), -- Coarse Bone Powder
(20090, 1882, 1, 1, 2, 20656.952064), -- Leather
(20090, 2158, 1, 1, 2, 11504.486742), -- Recipe: Mithril Ring
(20090, 5472, 1, 1, 2, 6639.84678), -- Recipe: Metallic Thread(100%)
(20090, 1341, 10, 30, 2, 309856.636908), -- Bone Arrow
-- Monster Eye
(20092, 1666, 1, 1, -1, 49062), -- Recipe: Wooden Arrow
(20092, 1866, 1, 1, -1, 98124), -- Suede
(20092, 2005, 1, 1, -1, 10513), -- Broadsword Blade
(20092, 57, 79, 107, 0, 700000), -- Adena
(20092, 113, 1, 1, 1, 9349.784408), -- Mystic's Earring
(20092, 906, 1, 1, 1, 6984.16868), -- Necklace of Knowledge
(20092, 875, 1, 1, 1, 13802.046912), -- Ring of Knowledge
(20092, 1869, 1, 1, 2, 14492.038992), -- Iron Ore
(20092, 1870, 1, 1, 2, 14492.038992), -- Coal
(20092, 1871, 1, 1, 2, 14492.038992), -- Charcoal
(20092, 1872, 1, 1, 2, 19322.718656), -- Animal Bone
(20092, 1867, 1, 1, 2, 19322.718656), -- Animal Skin
(20092, 2137, 1, 1, 2, 4262.445712), -- Recipe: Steel
-- Orc Fighter
(20093, 1867, 1, 1, -1, 242609), -- Animal Skin
(20093, 2007, 1, 1, -1, 12997), -- Bow Shaft
(20093, 1666, 1, 1, -1, 60652), -- Recipe: Wooden Arrow
(20093, 57, 98, 132, 0, 700000), -- Adena
(20093, 3, 1, 1, 1, 1119.771954), -- Broadsword
(20093, 2005, 1, 1, 1, 3839.228046), -- Broadsword Blade
(20093, 1872, 1, 1, 2, 35831.462786), -- Animal Bone
(20093, 1867, 1, 1, 2, 35831.462786), -- Animal Skin
(20093, 2138, 1, 1, 2, 7904.062642), -- Recipe: Coarse Bone Powder (100%)
(20093, 1060, 1, 1, 2, 59719.011786), -- Lesser Healing Potion
-- Vampire Bat
(20095, 1864, 1, 1, -1, 297315), -- Stem
(20095, 2006, 1, 1, -1, 10618), -- Willow Staff Head
(20095, 57, 80, 108, 0, 700000), -- Adena
(20095, 428, 1, 1, 1, 2348.272102), -- Feriotic Tunic
(20095, 1100, 1, 1, 1, 2348.272102), -- Cotton Tunic
(20095, 463, 1, 1, 1, 3753.227898), -- Feriotic Stockings
(20095, 1103, 1, 1, 1, 3753.227898), -- Cotton Stockings
(20095, 1864, 1, 1, 2, 58547.899942), -- Stem
(20095, 1869, 1, 1, 2, 29273.949971), -- Iron Ore
(20095, 1789, 1, 1, 2, 5411.150087), -- Recipe: Cedar Staff
-- Orc Lieutenant
(20096, 1799, 1, 1, -1, 298635), -- Recipe: Leather Gloves
(20096, 1921, 1, 1, -1, 130051), -- Leather Shoes Texture
(20096, 1792, 1, 1, -1, 14822), -- Recipe: Short Spear
(20096, 57, 109, 147, 0, 700000), -- Adena
(20096, 37, 1, 1, 1, 3891.653613), -- Leather Shoes
(20096, 1921, 1, 1, 1, 25609.659381), -- Leather Shoes Texture
(20096, 49, 1, 1, 1, 3891.687006), -- Gloves
(20096, 1869, 1, 1, 2, 19847.655828), -- Iron Ore
(20096, 1870, 1, 1, 2, 19847.655828), -- Coal
(20096, 1871, 1, 1, 2, 19847.655828), -- Charcoal
(20096, 1872, 1, 1, 2, 26463.541104), -- Animal Bone
(20096, 1867, 1, 1, 2, 26463.541104), -- Animal Skin
(20096, 736, 1, 1, 2, 9923.950308), -- Scroll of Escape
-- Drill Bat
(20097, 1864, 1, 1, -1, 335964), -- Stem
(20097, 1793, 1, 1, -1, 12352), -- Recipe: Sword of Reflection
(20097, 1872, 1, 1, -1, 223976), -- Animal Bone
(20097, 57, 91, 122, 0, 700000), -- Adena
(20097, 23, 1, 1, 1, 1081.06461), -- Wooden Breastplate
(20097, 30, 1, 1, 1, 1731.967695), -- Hard Leather Pants
(20097, 2386, 1, 1, 1, 1731.967695), -- Wooden Gaiters
(20097, 1872, 1, 1, 2, 44105.829452), -- Animal Bone
(20097, 1867, 1, 1, 2, 44105.829452), -- Animal Skin
(20097, 1792, 1, 1, 2, 2432.341096), -- Recipe: Short Spear
-- Orc Fighter Leader
(20098, 1867, 1, 1, -1, 292047), -- Animal Skin
(20098, 1870, 1, 1, -1, 219036), -- Coal
(20098, 1896, 1, 1, -1, 92812), -- Necklace of Anguish Chain
(20098, 57, 117, 161, 0, 700000), -- Adena
(20098, 66, 1, 1, 1, 207.363975), -- Gladius
(20098, 1333, 1, 1, 1, 207.363975), -- Brandish
(20098, 2010, 1, 1, 1, 1678.27205), -- Brandish Blade
(20098, 1865, 1, 1, 2, 43133.26426), -- Varnish
(20098, 1870, 1, 1, 2, 43133.26426), -- Coal
(20098, 1793, 1, 1, 2, 3171.47148), -- Recipe: Sword of Reflection
-- Skeleton
(20099, 2009, 1, 1, -1, 6303), -- Dirk Blade
(20099, 1831, 1, 1, -1, 473949), -- Antidote
(20099, 1896, 1, 1, -1, 75310), -- Necklace of Anguish Chain
(20099, 57, 95, 131, 0, 700000), -- Adena
(20099, 66, 1, 1, 1, 168.22935), -- Gladius
(20099, 1333, 1, 1, 1, 168.22935), -- Brandish
(20099, 2010, 1, 1, 1, 1361.5413), -- Brandish Blade
(20099, 1864, 1, 1, 2, 34999.480344), -- Stem
(20099, 1865, 1, 1, 2, 17499.740172), -- Varnish
(20099, 1866, 1, 1, 2, 11666.493448), -- Suede
(20099, 1873, 1, 1, 2, 6999.853088), -- Silver Nugget
(20099, 1868, 1, 1, 2, 34999.480344), -- Thread
(20099, 1794, 1, 1, 2, 1286.952604), -- Recipe: Forest Bow
-- Skeleton Archer
(20100, 1833, 1, 1, -1, 502269), -- Bandage
(20100, 1866, 1, 1, -1, 125567), -- Suede
(20100, 1792, 1, 1, -1, 13849), -- Recipe: Short Spear
(20100, 57, 99, 140, 0, 700000), -- Adena
(20100, 271, 1, 1, 1, 535), -- Hunting Bow
(20100, 1866, 1, 1, 2, 24727.163755), -- Suede
(20100, 1871, 1, 1, 2, 37090.687249), -- Charcoal
(20100, 1799, 1, 1, 2, 54949.148996), -- Recipe: Leather Gloves
-- Crasher
(20101, 20, 1, 1, -1, 23417), -- Buckler
(20101, 1921, 1, 1, -1, 161654), -- Leather Shoes Texture
(20101, 1793, 1, 1, -1, 18424), -- Recipe: Sword of Reflection
(20101, 57, 128, 189, 0, 700000), -- Adena
(20101, 114, 1, 1, 1, 2192.993905), -- Earring of Strength
(20101, 115, 1, 1, 1, 2192.993905), -- Earring of Wisdom
(20101, 907, 1, 1, 1, 1644.750895), -- Necklace of Anguish
(20101, 1896, 1, 1, 1, 12544.73764), -- Necklace of Anguish Chain
(20101, 876, 1, 1, 1, 3289.523655), -- Ring of Anguish
(20101, 1864, 1, 1, 2, 49341.773522), -- Stem
(20101, 1865, 1, 1, 2, 24670.971962), -- Varnish
(20101, 1866, 1, 1, 2, 16447.20104), -- Suede
(20101, 1873, 1, 1, 2, 9868.320624), -- Silver Nugget
(20101, 1868, 1, 1, 2, 49341.773522), -- Thread
(20101, 1803, 1, 1, 2, 20731.95933), -- Recipe: Necklace of Wisdom
-- Skeleton Marksman
(20102, 1866, 1, 1, -1, 127538), -- Suede
(20102, 1922, 1, 1, -1, 48803), -- Leather Tunic Pattern
(20102, 1793, 1, 1, -1, 14067), -- Recipe: Sword of Reflection
(20102, 57, 98, 145, 0, 700000), -- Adena
(20102, 271, 1, 1, 1, 543), -- Hunting Bow
(20102, 1864, 1, 1, 2, 75345.199366), -- Stem
(20102, 1869, 1, 1, 2, 37672.533756), -- Iron Ore
(20102, 736, 1, 1, 2, 18836.266878), -- Scroll of Escape
-- Giant Spider
(20103, 1803, 1, 1, -1, 198526), -- Recipe: Necklace of Wisdom
(20103, 1871, 1, 1, -1, 236245), -- Charcoal
(20103, 1921, 1, 1, -1, 152416), -- Leather Shoes Texture
(20103, 57, 119, 180, 0, 700000), -- Adena
(20103, 37, 1, 1, 1, 4560.948576), -- Leather Shoes
(20103, 1921, 1, 1, 1, 30014.063712), -- Leather Shoes Texture
(20103, 49, 1, 1, 1, 4560.987712), -- Gloves
(20103, 1867, 1, 1, 2, 46522.183748), -- Animal Skin
(20103, 1872, 1, 1, 2, 46522.183748), -- Animal Bone
(20103, 1794, 1, 1, 2, 2565.646), -- Recipe: Forest Bow
(20103, 17, 10, 30, 2, 174457.986504), -- Wooden Arrow
-- Skeleton Lord
(20104, 1869, 1, 1, -1, 193011), -- Iron Ore
(20104, 1868, 1, 1, -1, 386022), -- Thread
(20104, 57, 97, 147, 0, 700000), -- Adena
(20104, 271, 1, 1, 1, 548), -- Hunting Bow
(20104, 1873, 1, 1, 2, 11402.500967), -- Silver Nugget
(20104, 1868, 1, 1, 2, 57012.504835), -- Thread
(20104, 736, 1, 1, 2, 14253.069909), -- Scroll of Escape
(20104, 17, 10, 30, 2, 142530.924289), -- Wooden Arrow
-- Dark Horror
(20105, 734, 1, 1, -1, 39986), -- Haste Potion
(20105, 1801, 1, 1, -1, 120865), -- Recipe: Piece Bone Gaiters
(20105, 1872, 1, 1, -1, 319890), -- Animal Bone
(20105, 57, 119, 185, 0, 700000), -- Adena
(20105, 15, 1, 1, 1, 135.010872), -- Short Spear
(20105, 2011, 1, 1, 1, 1616.989128), -- Short Spear Edge
(20105, 1867, 1, 1, 2, 47245.15581), -- Animal Skin
(20105, 1872, 1, 1, 2, 47245.15581), -- Animal Bone
(20105, 2140, 1, 1, 2, 7086.82041), -- Recipe: High-Grade Suede
(20105, 735, 1, 1, 2, 2952.86797), -- Alacrity Potion
-- Talon Spider
(20106, 2150, 1, 1, -1, 111533), -- Recipe: Blue Diamond Necklace
(20106, 1897, 1, 1, -1, 56563), -- Necklace of Wisdom Chain
(20106, 734, 1, 1, -1, 39594), -- Haste Potion
(20106, 57, 118, 183, 0, 700000), -- Adena
(20106, 38, 1, 1, 1, 1795.866945), -- Low Boots
(20106, 50, 1, 1, 1, 1795.866945), -- Leather Gloves
(20106, 1925, 1, 1, 1, 30677.26611), -- Leather Gloves Lining
(20106, 1867, 1, 1, 2, 46782.15126), -- Animal Skin
(20106, 1872, 1, 1, 2, 46782.15126), -- Animal Bone
(20106, 2141, 1, 1, 2, 7017.281895), -- Recipe: Silver Mold
(20106, 5273, 1, 1, 2, 1403.415585), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Wererat
(20107, 1869, 1, 1, -1, 197971), -- Iron Ore
(20107, 734, 1, 1, -1, 32995), -- Haste Potion
(20107, 1897, 1, 1, -1, 47136), -- Necklace of Wisdom Chain
(20107, 57, 98, 153, 0, 700000), -- Adena
(20107, 217, 1, 1, 1, 111.5), -- Shining Knife
(20107, 218, 1, 1, 1, 111.5), -- Throwing Knife
(20107, 1865, 1, 1, 2, 29238.818472), -- Varnish
(20107, 1870, 1, 1, 2, 29238.818472), -- Coal
(20107, 2142, 1, 1, 2, 5847.750342), -- Recipe: Varnish of Purity
(20107, 6035, 1, 1, 2, 2436.612714), -- Magic Haste Potion
-- Blade Spider
(20108, 1866, 1, 1, -1, 167333), -- Suede
(20108, 734, 1, 1, -1, 41833), -- Haste Potion
(20108, 1800, 1, 1, -1, 78931), -- Recipe: Piece Bone Breastplate
(20108, 57, 122, 197, 0, 700000), -- Adena
(20108, 38, 1, 1, 1, 1897.427835), -- Low Boots
(20108, 50, 1, 1, 1, 1897.427835), -- Leather Gloves
(20108, 1925, 1, 1, 1, 32412.14433), -- Leather Gloves Lining
(20108, 1872, 1, 1, 2, 49427.752743), -- Animal Bone
(20108, 1867, 1, 1, 2, 49427.752743), -- Animal Skin
(20108, 2144, 1, 1, 2, 7414.212123), -- Recipe: Compound Braid
(20108, 735, 1, 1, 2, 3089.282391), -- Alacrity Potion
-- Salamander
(20109, 1865, 1, 1, -1, 401928), -- Varnish
(20109, 845, 1, 1, -1, 11752), -- Cat's Eye Earring
(20109, 1924, 1, 1, -1, 129654), -- Leather Helmet Design
(20109, 57, 196, 315, 0, 700000), -- Adena
(20109, 24, 1, 1, 1, 760.9576), -- Bone Breastplate
(20109, 390, 1, 1, 1, 760.9576), -- Cotton Shirt
(20109, 31, 1, 1, 1, 1215.0424), -- Bone Gaiters
(20109, 412, 1, 1, 1, 1215.0424), -- Cotton Pants
(20109, 1864, 1, 1, 2, 67841.751901), -- Stem
(20109, 1865, 1, 1, 2, 33920.987485), -- Varnish
(20109, 1866, 1, 1, 2, 22613.842944), -- Suede
(20109, 1873, 1, 1, 2, 13568.394994), -- Silver Nugget
(20109, 1868, 1, 1, 2, 67841.751901), -- Thread
(20109, 2150, 1, 1, 2, 15925.342048), -- Recipe: Blue Diamond Necklace
(20109, 5273, 1, 1, 2, 1356.928727), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Undine
(20110, 734, 1, 1, -1, 64842), -- Haste Potion
(20110, 1897, 1, 1, -1, 92631), -- Necklace of Wisdom Chain
(20110, 1801, 1, 1, -1, 195995), -- Recipe: Piece Bone Gaiters
(20110, 57, 190, 305, 0, 700000), -- Adena
(20110, 24, 1, 1, 1, 736.6963), -- Bone Breastplate
(20110, 390, 1, 1, 1, 736.6963), -- Cotton Shirt
(20110, 31, 1, 1, 1, 1176.3037), -- Bone Gaiters
(20110, 412, 1, 1, 1, 1176.3037), -- Cotton Pants
(20110, 1871, 1, 1, 2, 76612.6698), -- Charcoal
(20110, 1866, 1, 1, 2, 51075.1132), -- Suede
(20110, 2173, 1, 1, 2, 20762.217), -- Recipe: Hard Leather Shirt
-- Salamander Elder
(20112, 1800, 1, 1, -1, 123442), -- Recipe: Piece Bone Breastplate
(20112, 1924, 1, 1, -1, 126628), -- Leather Helmet Design
(20112, 1801, 1, 1, -1, 197756), -- Recipe: Piece Bone Gaiters
(20112, 57, 188, 310, 0, 700000), -- Adena
(20112, 1101, 1, 1, 1, 1486.48986), -- Tunic of Devotion
(20112, 1104, 1, 1, 1, 2373.51014), -- Stockings of Devotion
(20112, 1864, 1, 1, 2, 92761.67314), -- Stem
(20112, 1869, 1, 1, 2, 46380.83657), -- Iron Ore
(20112, 1878, 1, 1, 2, 18552.37063), -- Braided Hemp
(20112, 1800, 1, 1, 2, 14585.13024), -- Recipe: Piece Bone Breastplate
(20112, 734, 1, 1, 2, 7729.98942), -- Haste Potion
-- Undine Elder
(20113, 1925, 1, 1, -1, 262556), -- Leather Gloves Lining
(20113, 1870, 1, 1, -1, 400397), -- Coal
(20113, 1879, 1, 1, -1, 66733), -- Cokes
(20113, 57, 192, 316, 0, 700000), -- Adena
(20113, 24, 1, 1, 1, 758.06935), -- Bone Breastplate
(20113, 390, 1, 1, 1, 758.06935), -- Cotton Shirt
(20113, 31, 1, 1, 1, 1210.43065), -- Bone Gaiters
(20113, 412, 1, 1, 1, 1210.43065), -- Cotton Pants
(20113, 1865, 1, 1, 2, 47308.454061), -- Varnish
(20113, 1870, 1, 1, 2, 47308.454061), -- Coal
(20113, 1879, 1, 1, 2, 7884.806457), -- Cokes
(20113, 1801, 1, 1, 2, 23833.039582), -- Recipe: Piece Bone Gaiters
(20113, 5273, 1, 1, 2, 1892.245839), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Salamander Noble
(20114, 735, 1, 1, -1, 33735), -- Alacrity Potion
(20114, 2011, 1, 1, -1, 9235), -- Short Spear Edge
(20114, 1817, 1, 1, -1, 80965), -- Recipe: Cord
(20114, 57, 190, 323, 0, 700000), -- Adena
(20114, 845, 1, 1, 1, 1748.194758), -- Cat's Eye Earring
(20114, 908, 1, 1, 1, 1311.156027), -- Necklace of Wisdom
(20114, 1897, 1, 1, 1, 14235.357078), -- Necklace of Wisdom Chain
(20114, 877, 1, 1, 1, 2622.292137), -- Ring of Wisdom
(20114, 1866, 1, 1, 2, 39859.7892), -- Suede
(20114, 1871, 1, 1, 2, 59789.80039), -- Charcoal
(20114, 1817, 1, 1, 2, 11957.93676), -- Recipe: Cord
(20114, 6035, 1, 1, 2, 4982.47365), -- Magic Haste Potion
-- Undine Noble
(20115, 2012, 1, 1, -1, 8603), -- Sword of Reflection Blade
(20115, 2139, 1, 1, -1, 82584), -- Recipe: Steel Mold
(20115, 2013, 1, 1, -1, 8912), -- Forest Bow Shaft
(20115, 57, 194, 330, 0, 700000), -- Adena
(20115, 38, 1, 1, 1, 3121.45142), -- Low Boots
(20115, 50, 1, 1, 1, 3121.45142), -- Leather Gloves
(20115, 1925, 1, 1, 1, 53321.09716), -- Leather Gloves Lining
(20115, 1869, 1, 1, 2, 34848.712), -- Iron Ore
(20115, 1870, 1, 1, 2, 34848.712), -- Coal
(20115, 1871, 1, 1, 2, 34848.712), -- Charcoal
(20115, 1872, 1, 1, 2, 46465.08656), -- Animal Bone
(20115, 1867, 1, 1, 2, 46465.08656), -- Animal Skin
(20115, 2139, 1, 1, 2, 6969.7424), -- Recipe: Steel Mold
(20115, 5158, 1, 1, 2, 1393.94848), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Dre Vanul
(20117, 1868, 1, 1, -1, 505303), -- Thread
(20117, 734, 1, 1, -1, 42109), -- Haste Potion
(20117, 1925, 1, 1, -1, 165673), -- Leather Gloves Lining
(20117, 57, 117, 203, 0, 700000), -- Adena
(20117, 176, 1, 1, 1, 142), -- Apprentice's Staff
(20117, 2501, 1, 1, 1, 142), -- Bone Club
(20117, 1867, 1, 1, 2, 39802.316208), -- Animal Skin
(20117, 1872, 1, 1, 2, 39802.316208), -- Animal Bone
(20117, 1882, 1, 1, 2, 6633.735504), -- Leather
(20117, 2173, 1, 1, 2, 8089.94496), -- Recipe: Hard Leather Shirt
(20117, 735, 1, 1, 2, 2487.68712), -- Alacrity Potion
-- Dre Vanul Scout
(20118, 1866, 1, 1, -1, 193642), -- Suede
(20118, 846, 1, 1, -1, 4723), -- Coral Earring
(20118, 5549, 1, 1, -1, 29046), -- Metallic Thread
(20118, 57, 132, 236, 0, 700000), -- Adena
(20118, 87, 1, 1, 1, 45.6372), -- Iron Hammer
(20118, 2014, 1, 1, 1, 493.08903), -- Iron Hammer Head
(20118, 155, 1, 1, 1, 45.6372), -- Flanged Mace
(20118, 177, 1, 1, 1, 45.63657), -- Mage Staff
(20118, 1868, 1, 1, 2, 85798.4332), -- Thread
(20118, 1873, 1, 1, 2, 17159.6616), -- Silver Nugget
(20118, 2179, 1, 1, 2, 20525.914), -- Recipe: Crafted Leather Gloves
(20118, 5273, 1, 1, 2, 1715.9912), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Wolf
(20120, 1787, 1, 1, -1, 30885), -- Recipe: Willow Staff
(20120, 1864, 1, 1, -1, 77212), -- Stem
(20120, 1874, 1, 1, -1, 2574), -- Oriharukon Ore
(20120, 57, 19, 29, 0, 700000), -- Adena
(20120, 13, 1, 1, 1, 13530), -- Short Bow
(20120, 1870, 1, 1, 2, 9978.249995), -- Coal
(20120, 1865, 1, 1, 2, 9978.249995), -- Varnish
(20120, 1786, 1, 1, 2, 7982.599996), -- Recipe: Broad Sword
(20120, 1060, 1, 1, 2, 22173.900014), -- Lesser Healing Potion
-- Giant Toad
(20121, 1788, 1, 1, -1, 45293), -- Recipe: Bow
(20121, 1864, 1, 1, -1, 113233), -- Stem
(20121, 1786, 1, 1, -1, 45293), -- Recipe: Broad Sword
(20121, 57, 30, 42, 0, 700000), -- Adena
(20121, 4, 1, 1, 1, 9921), -- Club
(20121, 7, 1, 1, 1, 9921), -- Apprentice's Rod
(20121, 1871, 1, 1, 2, 14633.216469), -- Charcoal
(20121, 1866, 1, 1, 2, 9755.477646), -- Suede
(20121, 1786, 1, 1, 2, 11706.551323), -- Recipe: Broad Sword
(20121, 17, 10, 30, 2, 73165.754562), -- Wooden Arrow
-- Orc
(20130, 1666, 1, 1, -1, 25914), -- Recipe: Wooden Arrow
(20130, 1060, 1, 1, -1, 172757), -- Lesser Healing Potion
(20130, 2005, 1, 1, -1, 5553), -- Broadsword Blade
(20130, 57, 41, 58, 0, 700000), -- Adena
(20130, 1122, 1, 1, 1, 6514.326819), -- Cotton Shoes
(20130, 1129, 1, 1, 1, 6514.326819), -- Crude Leather Shoes
(20130, 1119, 1, 1, 1, 6514.346362), -- Short Leather Gloves
(20130, 1864, 1, 1, 2, 30618), -- Stem
(20130, 1869, 1, 1, 2, 15309), -- Iron Ore
(20130, 1666, 1, 1, 2, 5103), -- Recipe: Wooden Arrow
-- Orc Grunt
(20131, 1789, 1, 1, -1, 17988), -- Recipe: Cedar Staff
(20131, 2006, 1, 1, -1, 6951), -- Willow Staff Head
(20131, 1666, 1, 1, -1, 32439), -- Recipe: Wooden Arrow
(20131, 57, 51, 72, 0, 700000), -- Adena
(20131, 19, 1, 1, 1, 11732.93531), -- Small Shield
(20131, 42, 1, 1, 1, 8213.06469), -- Leather Cap
(20131, 1865, 1, 1, 2, 19163.735248), -- Varnish
(20131, 1870, 1, 1, 2, 19163.735248), -- Coal
(20131, 1797, 1, 1, 2, 38714.529504), -- Recipe: Leather Stockings
-- Werewolf
(20132, 1060, 1, 1, -1, 330759), -- Lesser Healing Potion
(20132, 2006, 1, 1, -1, 10632), -- Willow Staff Head
(20132, 57, 80, 108, 0, 700000), -- Adena
(20132, 254, 1, 1, 1, 1832), -- Iron Gloves
(20132, 1872, 1, 1, 2, 29310.335516), -- Animal Bone
(20132, 1867, 1, 1, 2, 29310.335516), -- Animal Skin
(20132, 1797, 1, 1, 2, 44409.563702), -- Recipe: Leather Stockings
(20132, 734, 1, 1, 2, 3663.765266), -- Haste Potion
-- Cave Maiden
(20134, 947, 1, 1, -1, 832), -- Scroll: Enchant Weapon (B-Grade)
(20134, 356, 1, 1, -1, 233), -- Full Plate Armor
(20134, 1871, 1, 5, -1, 693087), -- Charcoal
(20134, 57, 821, 1673, 0, 700000), -- Adena
(20134, 357, 1, 1, 1, 9.6201), -- Zubei's Breastplate
(20134, 4056, 1, 1, 1, 1389.919174), -- Zubei's Breastplate Part
(20134, 2376, 1, 1, 1, 9.6201), -- Avadon Breastplate
(20134, 4064, 1, 1, 1, 1389.919174), -- Avadon Breastplate Part
(20134, 383, 1, 1, 1, 15.39216), -- Zubei's Gaiters
(20134, 4057, 1, 1, 1, 2148.06144), -- Zubei's Gaiter Material
(20134, 2379, 1, 1, 1, 15.39216), -- Avadon Gaiters
(20134, 4065, 1, 1, 1, 2148.075692), -- Avadon Gaiters Material
(20134, 1866, 1, 1, 2, 34121.337873), -- Suede
(20134, 1871, 1, 1, 2, 51182.053734), -- Charcoal
(20134, 5220, 1, 1, 2, 2047.315935), -- Metal Hardener
(20134, 1885, 1, 1, 2, 4265.155503), -- High-Grade Suede
(20134, 4041, 1, 1, 2, 445.031958), -- Mold Hardener
(20134, 947, 1, 1, 2, 20.459082), -- Scroll: Enchant Weapon (B-Grade)
(20134, 4993, 1, 1, 2, 636.577767), -- Recipe: Sealed Doom Gloves (60%)
(20134, 4192, 1, 1, 2, 39.041184), -- Recipe: Sword of Damascus (100%)
(20134, 8728, 1, 1, 2, 852.993561), -- Life Stone - Level 61
(20134, 8738, 1, 1, 2, 213.224928), -- Mid-Grade Life Stone - Level 61
(20134, 8748, 1, 1, 2, 21.303723), -- High-Grade Life Stone - Level 61
(20134, 8758, 1, 1, 2, 4.504752), -- Top-Grade Life Stone - Level 61
-- Alligator
(20135, 2038, 1, 1, -1, 9877), -- Maingauche Edge
(20135, 5231, 1, 1, -1, 66770), -- Recipe: Metal Hardener (100%)
(20135, 1882, 1, 1, -1, 207728), -- Leather
(20135, 57, 390, 779, 0, 700000), -- Adena
(20135, 261, 1, 1, 1, 44.994933), -- Bich'Hwa
(20135, 2039, 1, 1, 1, 2446.005067), -- Bich'Hwa Edge
(20135, 1867, 1, 1, 2, 92039.390346), -- Animal Skin
(20135, 1872, 1, 1, 2, 92039.390346), -- Animal Bone
(20135, 1882, 1, 1, 2, 15340.003224), -- Leather
(20135, 1894, 1, 1, 2, 2422.061632), -- Crafted Leather
(20135, 2296, 1, 1, 2, 383.479114), -- Recipe: Atuba Mace
(20135, 2286, 1, 1, 2, 383.479114), -- Recipe: Bonebreaker
(20135, 2985, 1, 1, 2, 7058.196224), -- Recipe: Plate Boots
-- Death Knight
(20136, 1914, 1, 1, -1, 257308), -- Earring of Seal Gemstone
(20136, 4601, 1, 1, -1, 10178), -- Greater Dye of STR (Str+3 Con-3)
(20136, 1539, 1, 3, -1, 508898), -- Greater Healing Potion
(20136, 57, 1812, 3683, 0, 700000), -- Adena
(20136, 75, 1, 1, 1, 9.554158), -- Caliburs
(20136, 2089, 1, 1, 1, 860.114248), -- Caliburs Edge
(20136, 76, 1, 1, 1, 9.554158), -- Sword of Delusion
(20136, 2090, 1, 1, 1, 860.114248), -- Delusional Blade
(20136, 77, 1, 1, 1, 9.554158), -- Tsurugi
(20136, 2091, 1, 1, 1, 860.114248), -- Tsurugi Blade
(20136, 84, 1, 1, 1, 9.554158), -- Homunkulus's Sword
(20136, 2092, 1, 1, 1, 860.114248), -- Homunkulus's Sword Blade
(20136, 134, 1, 1, 1, 9.554158), -- Sword of Nightmare
(20136, 2095, 1, 1, 1, 860.114248), -- Sword of Nightmare Blade
(20136, 145, 1, 1, 1, 9.554158), -- Sword of Whispering Death
(20136, 2096, 1, 1, 1, 860.103812), -- Sword of Whispering Death Blade
(20136, 1869, 1, 1, 2, 172185.330568), -- Iron Ore
(20136, 1864, 1, 3, 2, 172185.330568), -- Stem
(20136, 1880, 1, 1, 2, 17218.646992), -- Steel
(20136, 5550, 1, 1, 2, 2295.79428), -- Durable Metal Plate
(20136, 4043, 1, 1, 2, 5739.675592), -- Asofe
(20136, 2169, 1, 1, 2, 3047.386816), -- Recipe: Necklace of Seal
(20136, 2232, 1, 1, 2, 989.717104), -- Recipe: Drake Leather Armor
(20136, 8725, 1, 1, 2, 4782.999696), -- Life Stone - Level 52
(20136, 8735, 1, 1, 2, 1195.560032), -- Mid-Grade Life Stone - Level 52
(20136, 8745, 1, 1, 2, 119.63196), -- High-Grade Life Stone - Level 52
(20136, 8755, 1, 1, 2, 23.926392), -- Top-Grade Life Stone - Level 52
-- Drake
(20137, 2961, 1, 1, -1, 106305), -- Full Plate Boots Part
(20137, 1877, 1, 1, -1, 78092), -- Adamantite Nugget
(20137, 4049, 1, 1, -1, 102402), -- Adamantite Earring Gemstone
(20137, 57, 770, 1572, 0, 700000), -- Adena
(20137, 11889, 1, 1, 1, 55.00082), -- Common Item - Great Sword
(20137, 4104, 1, 1, 1, 550.013594), -- Great Sword Blade
(20137, 11916, 1, 1, 1, 55.00082), -- Common Item - Keshanberk
(20137, 4107, 1, 1, 1, 541.491074), -- Keshanberk Blade
(20137, 11900, 1, 1, 1, 55.00082), -- Common Item - Sword of Valhalla
(20137, 4108, 1, 1, 1, 541.492872), -- Sword of Valhalla Blade
(20137, 1869, 1, 1, 2, 44359.859222), -- Iron Ore
(20137, 1864, 1, 1, 2, 88719.565991), -- Stem
(20137, 1880, 1, 1, 2, 4435.924941), -- Steel
(20137, 5550, 1, 1, 2, 591.51764), -- Durable Metal Plate
(20137, 4043, 1, 1, 2, 1478.641647), -- Asofe
(20137, 4952, 1, 1, 2, 570.17422), -- Recipe: Avadon Circlet (60%)
(20137, 4999, 1, 1, 2, 551.727407), -- Recipe: Sealed Doom Boots (60%)
(20137, 4163, 1, 1, 2, 293.776931), -- Recipe: Blue Wolf Stockings (100%)
(20137, 6669, 1, 1, 2, 10316.189604), -- Deluxe Chest Key - Grade 5
(20137, 8727, 1, 1, 2, 887.124007), -- Life Stone - Level 58
(20137, 8737, 1, 1, 2, 221.819115), -- Mid-Grade Life Stone - Level 58
(20137, 8747, 1, 1, 2, 22.105685), -- High-Grade Life Stone - Level 58
(20137, 8757, 1, 1, 2, 4.57359), -- Top-Grade Life Stone - Level 58
-- Grizzly
(20143, 1872, 1, 1, -1, 284370), -- Animal Bone
(20143, 1867, 1, 1, -1, 284370), -- Animal Skin
(20143, 1792, 1, 1, -1, 15682), -- Recipe: Short Spear
(20143, 57, 114, 157, 0, 700000), -- Adena
(20143, 20, 1, 1, 1, 5887.56231), -- Buckler
(20143, 43, 1, 1, 1, 4117.43769), -- Wooden Helmet
(20143, 1866, 1, 1, 2, 20999.590341), -- Suede
(20143, 1871, 1, 1, 2, 31499.505951), -- Charcoal
(20143, 1798, 1, 1, 2, 30881.892195), -- Recipe: Leather Helmet
(20143, 17, 10, 30, 2, 157498.011513), -- Wooden Arrow
-- Hangman Tree
(20144, 1880, 1, 1, -1, 71999), -- Steel
(20144, 2272, 1, 1, -1, 5143), -- Recipe: Sword of Revolution
(20144, 1901, 1, 1, -1, 99446), -- Tiger's Eye Earring Stone
(20144, 57, 304, 607, 0, 700000), -- Adena
(20144, 393, 1, 1, 1, 109.06642), -- Mithril Banded Mail
(20144, 1938, 1, 1, 1, 4289.19622), -- Mithril Banded Mail Material
(20144, 394, 1, 1, 1, 109.06642), -- Reinforced Leather Shirt
(20144, 415, 1, 1, 1, 174.32636), -- Mithril Banded Gaiters
(20144, 1939, 1, 1, 1, 5604.02868), -- Mithril Banded Gaiters Material
(20144, 416, 1, 1, 1, 174.3159), -- Reinforced Leather Gaiters
(20144, 1875, 1, 1, 2, 2552.070594), -- Stone of Purity
(20144, 1879, 1, 1, 2, 6380.176485), -- Cokes
(20144, 1885, 1, 1, 2, 3189.999592), -- High-Grade Suede
(20144, 5550, 1, 1, 2, 510.449579), -- Durable Metal Plate
(20144, 5549, 1, 1, 2, 3828.105891), -- Metallic Thread
(20144, 2976, 1, 1, 2, 5124.530803), -- Recipe: Manticore Skin Boots
(20144, 2274, 1, 1, 2, 273.398142), -- Recipe: Skull Breaker
(20144, 2985, 1, 1, 2, 3914.274177), -- Recipe: Plate Boots
(20144, 6667, 1, 1, 2, 23925.528843), -- Deluxe Chest Key - Grade 3
(20144, 1341, 10, 30, 2, 127602.465894), -- Bone Arrow
-- Harpy
(20145, 2183, 1, 1, -1, 39675), -- Recipe: Mithril Banded Mail
(20145, 2268, 1, 1, -1, 6236), -- Recipe: Tome of Blood
(20145, 2153, 1, 1, -1, 93789), -- Recipe: Tiger's Eye Earring
(20145, 57, 254, 510, 0, 700000), -- Adena
(20145, 848, 1, 1, 1, 502.355926), -- Enchanted Earring
(20145, 911, 1, 1, 1, 377.049143), -- Enchanted Necklace
(20145, 1900, 1, 1, 1, 9013.760858), -- Enchanted Necklace Chain
(20145, 879, 1, 1, 1, 755.834073), -- Enchanted Ring
(20145, 1868, 1, 1, 2, 109850.451315), -- Thread
(20145, 1873, 1, 1, 2, 21970.11865), -- Silver Nugget
(20145, 5549, 1, 1, 2, 5492.458695), -- Metallic Thread
(20145, 1889, 1, 1, 2, 3661.63913), -- Compound Braid
(20145, 2268, 1, 1, 2, 568.02387), -- Recipe: Tome of Blood
(20145, 2276, 1, 1, 2, 392.30834), -- Recipe: Maingauche
-- Headless Knight
(20146, 1915, 1, 1, -1, 130858), -- Ring of Ages Gemstone
(20146, 1869, 1, 3, -1, 742616), -- Iron Ore
(20146, 1914, 1, 1, -1, 83440), -- Earring of Seal Gemstone
(20146, 57, 587, 1194, 0, 700000), -- Adena
(20146, 103, 1, 1, 1, 77.434918), -- Tower Shield
(20146, 1978, 1, 1, 1, 4921.495953), -- Tower Shield Fragment
(20146, 107, 1, 1, 1, 77.434918), -- Composite Shield
(20146, 4055, 1, 1, 1, 4921.495953), -- Composite Shield Fragment
(20146, 517, 1, 1, 1, 54.22802), -- Composite Helmet
(20146, 2957, 1, 1, 1, 3367.341109), -- Composite Helmet Design
(20146, 1149, 1, 1, 1, 54.22802), -- Shining Circlet
(20146, 1983, 1, 1, 1, 3367.341109), -- Shining Circlet Pattern
(20146, 1871, 1, 1, 2, 47246.417626), -- Charcoal
(20146, 1866, 1, 1, 2, 31497.640505), -- Suede
(20146, 1877, 1, 1, 2, 1889.849804), -- Adamantite Nugget
(20146, 4041, 1, 1, 2, 410.870669), -- Mold Hardener
(20146, 4040, 1, 1, 2, 944.924902), -- Mold Lubricant
(20146, 2170, 1, 1, 2, 1114.345434), -- Recipe: Nassen's Earring
(20146, 4609, 1, 1, 2, 104.982071), -- Greater Dye of MEN (Men+3 Int-3)
(20146, 3014, 1, 1, 2, 1319.737637), -- Recipe: Full Plate Boots
(20146, 4188, 1, 1, 2, 54.431953), -- Recipe: Hell Knife (100%)
(20146, 8725, 1, 1, 2, 1312.405282), -- Life Stone - Level 52
(20146, 8735, 1, 1, 2, 328.058189), -- Mid-Grade Life Stone - Level 52
(20146, 8745, 1, 1, 2, 32.77994), -- High-Grade Life Stone - Level 52
(20146, 8755, 1, 1, 2, 6.555988), -- Top-Grade Life Stone - Level 52
-- Hobgoblin
(20147, 1870, 1, 1, -1, 341721), -- Coal
(20147, 1876, 1, 1, -1, 68344), -- Mithril Ore
(20147, 57, 156, 278, 0, 700000), -- Adena
(20147, 27, 1, 1, 1, 355.418392), -- Hard Leather Shirt
(20147, 1927, 1, 1, 1, 4026.225584), -- Hard Leather Shirt Pattern
(20147, 33, 1, 1, 1, 570.265216), -- Hard Leather Gaiters
(20147, 1929, 1, 1, 1, 6512.090808), -- Hard Leather Gaiters Material
(20147, 1873, 1, 1, 2, 20187.870617), -- Silver Nugget
(20147, 1868, 1, 1, 2, 100939.353085), -- Thread
(20147, 2255, 1, 1, 2, 1234.01334), -- Recipe: Saber
(20147, 6666, 1, 1, 2, 50469.762958), -- Deluxe Chest Key - Grade 2
-- Magical Weaver
(20153, 1831, 1, 1, -1, 537542), -- Antidote
(20153, 30, 1, 1, -1, 10554), -- Hard Leather Pants
(20153, 1867, 1, 1, -1, 268771), -- Animal Skin
(20153, 57, 109, 147, 0, 700000), -- Adena
(20153, 429, 1, 1, 1, 972.9426), -- Leather Tunic
(20153, 1922, 1, 1, 1, 7594.824544), -- Leather Tunic Pattern
(20153, 464, 1, 1, 1, 1558.71768), -- Leather Stockings
(20153, 1923, 1, 1, 1, 12201.515176), -- Leather Stockings Pattern
(20153, 1867, 1, 1, 2, 52927.092659), -- Animal Skin
(20153, 1872, 1, 1, 2, 52927.092659), -- Animal Bone
(20153, 1793, 1, 1, 2, 2918.814682), -- Recipe: Sword of Reflection
-- Mandragora Sprout
(20154, 2178, 1, 1, -1, 54675), -- Recipe: Dark Stockings
(20154, 1929, 1, 1, -1, 44093), -- Hard Leather Gaiters Material
(20154, 1898, 1, 1, -1, 35102), -- Blue Diamond Necklace Gem
(20154, 57, 156, 278, 0, 700000), -- Adena
(20154, 846, 1, 1, 1, 820.594371), -- Coral Earring
(20154, 909, 1, 1, 1, 615.447741), -- Blue Diamond Necklace
(20154, 1898, 1, 1, 1, 5184.054555), -- Blue Diamond Necklace Gem
(20154, 878, 1, 1, 1, 1230.903333), -- Blue Coral Ring
(20154, 1868, 1, 1, 2, 100939.3452), -- Thread
(20154, 1873, 1, 1, 2, 20187.86904), -- Silver Nugget
(20154, 2256, 1, 1, 2, 1233.97398), -- Recipe: Assassin Knife
(20154, 5158, 1, 1, 2, 2018.81178), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Mandragora Sapling
(20155, 1865, 1, 1, -1, 385707), -- Varnish
(20155, 1898, 1, 1, -1, 39621), -- Blue Diamond Necklace Gem
(20155, 1804, 1, 1, -1, 15428), -- Recipe: Soulshot (D-Grade)
(20155, 57, 177, 312, 0, 700000), -- Adena
(20155, 846, 1, 1, 1, 926.265102), -- Coral Earring
(20155, 909, 1, 1, 1, 694.701042), -- Blue Diamond Necklace
(20155, 1898, 1, 1, 1, 5851.62291), -- Blue Diamond Necklace Gem
(20155, 878, 1, 1, 1, 1389.410946), -- Blue Coral Ring
(20155, 1869, 1, 1, 2, 32551.95924), -- Iron Ore
(20155, 1864, 1, 1, 2, 65103.91848), -- Stem
(20155, 1880, 1, 1, 2, 3255.22368), -- Steel
(20155, 3032, 1, 1, 2, 1302.03396), -- Recipe: Spiritshot D
(20155, 5273, 1, 1, 2, 1302.03396), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20155, 6666, 1, 1, 2, 32551.95924), -- Deluxe Chest Key - Grade 2
(20155, 735, 1, 1, 2, 2712.87144), -- Alacrity Potion
-- Mandragora Blossom
(20156, 2181, 1, 1, -1, 42851), -- Recipe: White Tunic
(20156, 1899, 1, 1, -1, 66888), -- Necklace of Devotion Chain
(20156, 57, 188, 353, 0, 700000), -- Adena
(20156, 847, 1, 1, 1, 580.321248), -- Red Crescent Earring
(20156, 910, 1, 1, 1, 435.240936), -- Necklace of Devotion
(20156, 1899, 1, 1, 1, 9384.944673), -- Necklace of Devotion Chain
(20156, 890, 1, 1, 1, 870.493143), -- Ring of Devotion
(20156, 1876, 1, 1, 2, 6864.288338), -- Mithril Ore
(20156, 1880, 1, 1, 2, 3432.144169), -- Steel
(20156, 1877, 1, 1, 2, 1372.838424), -- Adamantite Nugget
(20156, 1881, 1, 1, 2, 4576.176189), -- Coarse Bone Powder
(20156, 1882, 1, 1, 2, 7627.008424), -- Leather
(20156, 2181, 1, 1, 2, 3435.608017), -- Recipe: White Tunic
(20156, 1061, 1, 1, 2, 20800.936439), -- Greater Healing Potion
-- Marsh Stakato
(20157, 1879, 1, 1, -1, 102726), -- Cokes
(20157, 2024, 1, 1, -1, 8780), -- Elven Bow Shaft
(20157, 2153, 1, 1, -1, 95856), -- Recipe: Tiger's Eye Earring
(20157, 57, 261, 517, 0, 700000), -- Adena
(20157, 86, 1, 1, 1, 13.597838), -- Tomahawk
(20157, 179, 1, 1, 1, 13.597838), -- Mace of Prayer
(20157, 180, 1, 1, 1, 13.597838), -- Mace of Judgment
(20157, 2022, 1, 1, 1, 524.75379), -- Mace of Judgment Head
(20157, 181, 1, 1, 1, 13.597838), -- Mace of Miracle
(20157, 182, 1, 1, 1, 13.597838), -- Doom Hammer
(20157, 183, 1, 1, 1, 13.597838), -- Mystic Staff
(20157, 184, 1, 1, 1, 13.597838), -- Conjuror's Staff
(20157, 2023, 1, 1, 1, 417.462455), -- Conjuror's Staff Head
(20157, 185, 1, 1, 1, 13.598889), -- Staff of Mana
(20157, 1864, 1, 1, 2, 84203.507106), -- Stem
(20157, 1869, 1, 1, 2, 42101.753553), -- Iron Ore
(20157, 1878, 1, 1, 2, 16840.616616), -- Braided Hemp
(20157, 1884, 1, 1, 2, 25908.836652), -- Cord
(20157, 1829, 1, 1, 2, 16840.616616), -- Scroll of Escape: Clan Hall
(20157, 2274, 1, 1, 2, 300.634434), -- Recipe: Skull Breaker
(20157, 2282, 1, 1, 2, 300.634434), -- Recipe: Cursed Maingauche
(20157, 1061, 1, 1, 2, 25516.400589), -- Greater Healing Potion
-- Medusa
(20158, 1876, 1, 1, -1, 136283), -- Mithril Ore
(20158, 1939, 1, 1, -1, 59852), -- Mithril Banded Gaiters Material
(20158, 1901, 1, 1, -1, 94118), -- Tiger's Eye Earring Stone
(20158, 57, 288, 574, 0, 700000), -- Adena
(20158, 436, 1, 1, 1, 309.81069), -- Tunic of Knowledge
(20158, 469, 1, 1, 1, 495.18931), -- Stockings of Knowledge
(20158, 1869, 1, 1, 2, 60383.782575), -- Iron Ore
(20158, 1864, 1, 1, 2, 120767.373495), -- Stem
(20158, 1880, 1, 1, 2, 6038.28243), -- Steel
(20158, 5550, 1, 1, 2, 805.142655), -- Durable Metal Plate
(20158, 2271, 1, 1, 2, 431.22375), -- Recipe: Winged Spear
(20158, 2972, 1, 1, 2, 3229.195095), -- Recipe: Brigandine Gaiters
-- Neer Crawler
(20160, 2152, 1, 1, -1, 87127), -- Recipe: Enchanted Necklace
(20160, 2261, 1, 1, -1, 7685), -- Recipe: Conjuror's Staff
(20160, 1874, 1, 1, -1, 32992), -- Oriharukon Ore
(20160, 57, 212, 415, 0, 700000), -- Adena
(20160, 258, 1, 1, 1, 176), -- Bagh-Nakh
(20160, 1874, 1, 1, 2, 3086.021248), -- Oriharukon Ore
(20160, 1878, 1, 1, 2, 18516.190664), -- Braided Hemp
(20160, 1884, 1, 1, 2, 28486.437456), -- Cord
(20160, 1889, 1, 1, 2, 3086.021248), -- Compound Braid
(20160, 5220, 1, 1, 2, 1851.625384), -- Metal Hardener
(20160, 2152, 1, 1, 2, 8149.704), -- Recipe: Enchanted Necklace
-- Oel Mahum
(20161, 1984, 1, 1, -1, 34800), -- Theca Leather Armor Pattern
(20161, 1806, 1, 1, -1, 3247), -- Recipe: Soulshot (B-Grade)
(20161, 1872, 1, 5, -1, 721517), -- Animal Bone
(20161, 57, 643, 1305, 0, 700000), -- Adena
(20161, 266, 1, 1, 1, 12.713712), -- Great Pata
(20161, 2120, 1, 1, 1, 1439.286288), -- Great Pata Blade
(20161, 1867, 1, 1, 2, 53281.330256), -- Animal Skin
(20161, 1872, 1, 1, 2, 53281.330256), -- Animal Bone
(20161, 1882, 1, 1, 2, 8880.17746), -- Leather
(20161, 1894, 1, 1, 2, 1402.084376), -- Crafted Leather
(20161, 4042, 1, 1, 2, 665.996716), -- Enria
(20161, 1806, 1, 1, 2, 79.914296), -- Recipe: Soulshot (B-Grade)
(20161, 5165, 1, 1, 2, 79.914296), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20161, 4180, 1, 1, 2, 4440.155104), -- Recipe: Silver Arrow (100%)
(20161, 3955, 1, 1, 2, 79.914296), -- Recipe: Blessed Spiritshot B
(20161, 5280, 1, 1, 2, 79.914296), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20161, 6669, 1, 1, 2, 9293.289236), -- Deluxe Chest Key - Grade 5
(20161, 8726, 1, 1, 2, 924.988064), -- Life Stone - Level 55
(20161, 8736, 1, 1, 2, 231.247016), -- Mid-Grade Life Stone - Level 55
(20161, 8746, 1, 1, 2, 23.098152), -- High-Grade Life Stone - Level 55
(20161, 8756, 1, 1, 2, 4.64618), -- Top-Grade Life Stone - Level 55
-- Silenos
(20168, 1877, 1, 1, -1, 21239), -- Adamantite Nugget
(20168, 1061, 1, 1, -1, 321804), -- Greater Healing Potion
(20168, 955, 1, 1, -1, 2124), -- Scroll: Enchant Weapon (D-Grade)
(20168, 57, 224, 448, 0, 700000), -- Adena
(20168, 627, 1, 1, 1, 1078.49287), -- Aspis
(20168, 46, 1, 1, 1, 755.50713), -- Bronze Helmet
(20168, 1865, 1, 1, 2, 48359.887005), -- Varnish
(20168, 1870, 1, 1, 2, 48359.887005), -- Coal
(20168, 1879, 1, 1, 2, 8060.037882), -- Cokes
(20168, 1875, 1, 1, 2, 3223.992467), -- Stone of Purity
(20168, 2184, 1, 1, 2, 5079.804336), -- Recipe: Mithril Banded Gaiters
(20168, 2274, 1, 1, 2, 345.391305), -- Recipe: Skull Breaker
-- Specter
(20171, 1880, 1, 1, -1, 45092), -- Steel
(20171, 2019, 1, 1, -1, 9697), -- Trident Edge
(20171, 1899, 1, 1, -1, 70456), -- Necklace of Devotion Chain
(20171, 57, 196, 374, 0, 700000), -- Adena
(20171, 101, 1, 1, 1, 32.150125), -- Scroll of Wisdom
(20171, 312, 1, 1, 1, 32.150125), -- Branch of Life
(20171, 313, 1, 1, 1, 32.150125), -- Temptation of Abyss
(20171, 2020, 1, 1, 1, 886.40153), -- Temptation of Abyss Piece
(20171, 314, 1, 1, 1, 32.148095), -- Proof of Revenge
(20171, 1875, 1, 1, 2, 2811.846308), -- Stone of Purity
(20171, 1879, 1, 1, 2, 7029.61577), -- Cokes
(20171, 5549, 1, 1, 2, 4217.769462), -- Metallic Thread
(20171, 2263, 1, 1, 2, 654.932122), -- Recipe: Dwarven Trident
(20171, 6666, 1, 1, 2, 42177.612166), -- Deluxe Chest Key - Grade 2
(20171, 1061, 1, 1, 2, 25562.224172), -- Greater Healing Potion
-- Wyrm
(20176, 1873, 1, 1, -1, 287994), -- Silver Nugget
(20176, 2273, 1, 1, -1, 5143), -- Recipe: Tarbar
(20176, 2154, 1, 1, -1, 77086), -- Recipe: Elven Earring
(20176, 57, 304, 607, 0, 700000), -- Adena
(20176, 553, 1, 1, 1, 279.740266), -- Iron Boots
(20176, 1940, 1, 1, 1, 8162.558404), -- Iron Boots Design
(20176, 2422, 1, 1, 1, 279.740266), -- Reinforced Leather Boots
(20176, 2423, 1, 1, 1, 279.740266), -- Boots of Knowledge
(20176, 63, 1, 1, 1, 279.740266), -- Gauntlets
(20176, 2446, 1, 1, 1, 279.740266), -- Reinforced Leather Gloves
(20176, 2447, 1, 1, 1, 279.740266), -- Gloves of Knowledge
(20176, 1867, 1, 1, 2, 72916.469689), -- Animal Skin
(20176, 1872, 1, 1, 2, 72916.469689), -- Animal Bone
(20176, 1882, 1, 1, 2, 12152.774702), -- Leather
(20176, 2977, 1, 1, 2, 7320.871184), -- Recipe: Brigandine Boots
(20176, 2286, 1, 1, 2, 303.846146), -- Recipe: Bonebreaker
(20176, 2985, 1, 1, 2, 5591.697406), -- Recipe: Plate Boots
(20176, 2981, 1, 1, 2, 7320.871184), -- Recipe: Mithril Gloves
-- Skeleton Marauder
(20190, 1864, 1, 3, -1, 533484), -- Stem
(20190, 2025, 1, 1, -1, 7389), -- Dwarven Trident Edge
(20190, 1900, 1, 1, -1, 58368), -- Enchanted Necklace Chain
(20190, 57, 226, 448, 0, 700000), -- Adena
(20190, 275, 1, 1, 1, 39.230345), -- Long Bow
(20190, 276, 1, 1, 1, 39.230345), -- Elven Bow
(20190, 2024, 1, 1, 1, 1384.53931), -- Elven Bow Shaft
(20190, 1866, 1, 1, 2, 38870.431145), -- Suede
(20190, 1871, 1, 1, 2, 58305.703435), -- Charcoal
(20190, 5220, 1, 1, 2, 2332.2236), -- Metal Hardener
(20190, 1885, 1, 1, 2, 4858.761355), -- High-Grade Suede
(20190, 2153, 1, 1, 2, 9067.880465), -- Recipe: Tiger's Eye Earring
-- Skeleton Raider
(20191, 2264, 1, 1, -1, 5601), -- Recipe: Two-handed Sword
(20191, 1900, 1, 1, -1, 59256), -- Enchanted Necklace Chain
(20191, 2153, 1, 1, -1, 84230), -- Recipe: Tiger's Eye Earring
(20191, 57, 228, 457, 0, 700000), -- Adena
(20191, 1123, 1, 1, 1, 1156), -- Blue Buckskin Boots
(20191, 605, 1, 1, 1, 1156), -- Leather Gauntlets
(20191, 1867, 1, 1, 2, 56373.602805), -- Animal Skin
(20191, 1872, 1, 1, 2, 56373.602805), -- Animal Bone
(20191, 1882, 1, 1, 2, 9395.679215), -- Leather
(20191, 2185, 1, 1, 2, 8322.823275), -- Recipe: Iron Boots
(20191, 2274, 1, 1, 2, 302.07541), -- Recipe: Skull Breaker
(20191, 2279, 1, 1, 2, 302.07541), -- Recipe: War Pick
(20191, 6667, 1, 1, 2, 26425.14108), -- Deluxe Chest Key - Grade 3
-- Tyrant
(20192, 2146, 1, 1, -1, 50419), -- Recipe: Artisan's frame
(20192, 2447, 1, 1, -1, 3611), -- Gloves of Knowledge
(20192, 1901, 1, 1, -1, 97496), -- Tiger's Eye Earring Stone
(20192, 57, 298, 595, 0, 700000), -- Adena
(20192, 223, 1, 1, 1, 20.19948), -- Kukuri
(20192, 238, 1, 1, 1, 20.19948), -- Dagger of Mana
(20192, 239, 1, 1, 1, 20.19948), -- Mystic Knife
(20192, 241, 1, 1, 1, 20.19948), -- Shilen Knife
(20192, 2028, 1, 1, 1, 892.20208), -- Shilen Knife Edge
(20192, 1864, 1, 1, 2, 107229.801952), -- Stem
(20192, 1869, 1, 1, 2, 53614.900976), -- Iron Ore
(20192, 1878, 1, 1, 2, 21446.062932), -- Braided Hemp
(20192, 1884, 1, 1, 2, 32993.785216), -- Cord
(20192, 2978, 1, 1, 2, 7177.399292), -- Recipe: Elven Mithril Boots
(20192, 6667, 1, 1, 2, 33509.31311), -- Deluxe Chest Key - Grade 3
(20192, 8307, 1, 1, 2, 382.736522), -- Recipe: Priest Mace (100%)
-- Tyrant Kingpin
(20193, 1874, 1, 1, -1, 50678), -- Oriharukon Ore
(20193, 2027, 1, 1, -1, 9958), -- Spiked Club Head
(20193, 1882, 1, 1, -1, 168925), -- Leather
(20193, 57, 320, 642, 0, 700000), -- Adena
(20193, 628, 1, 1, 1, 986.079628), -- Hoplon
(20193, 47, 1, 1, 1, 689.920372), -- Helmet
(20193, 1867, 1, 1, 2, 76985.489672), -- Animal Skin
(20193, 1872, 1, 1, 2, 76985.489672), -- Animal Bone
(20193, 1882, 1, 1, 2, 12830.854608), -- Leather
(20193, 1894, 1, 1, 2, 2025.886304), -- Crafted Leather
(20193, 2271, 1, 1, 2, 412.345336), -- Recipe: Winged Spear
(20193, 2286, 1, 1, 2, 320.753264), -- Recipe: Bonebreaker
(20193, 1341, 10, 30, 2, 192463.181144), -- Bone Arrow
-- Sorrow Maiden
(20197, 2259, 1, 1, -1, 7096), -- Recipe: Spinebone Sword
(20197, 2020, 1, 1, -1, 8000), -- Temptation of Abyss Piece
(20197, 1876, 1, 1, -1, 91400), -- Mithril Ore
(20197, 57, 197, 380, 0, 700000), -- Adena
(20197, 847, 1, 1, 1, 619.503616), -- Red Crescent Earring
(20197, 910, 1, 1, 1, 464.627712), -- Necklace of Devotion
(20197, 1899, 1, 1, 1, 10018.601216), -- Necklace of Devotion Chain
(20197, 890, 1, 1, 1, 929.267456), -- Ring of Devotion
(20197, 1876, 1, 1, 2, 6412.072376), -- Mithril Ore
(20197, 1880, 1, 1, 2, 3206.036188), -- Steel
(20197, 1877, 1, 1, 2, 1282.468508), -- Adamantite Nugget
(20197, 1881, 1, 1, 2, 4274.804972), -- Coarse Bone Powder
(20197, 1882, 1, 1, 2, 7124.629926), -- Leather
(20197, 2178, 1, 1, 2, 5129.73895), -- Recipe: Dark Stockings
(20197, 8294, 1, 1, 2, 783.880846), -- Recipe: Steel Sword (100%)
(20197, 1341, 10, 30, 2, 106868.368234), -- Bone Arrow
-- Neer Ghoul Berserker
(20198, 1832, 1, 1, -1, 575495), -- Greater Antidote
(20198, 57, 220, 435, 0, 700000), -- Adena
(20198, 259, 1, 1, 1, 114), -- Single-Edged Jamadhr
(20198, 1874, 1, 1, 2, 2358.65935), -- Oriharukon Ore
(20198, 1878, 1, 1, 2, 14152.00525), -- Braided Hemp
(20198, 1884, 1, 1, 2, 21772.31955), -- Cord
(20198, 1889, 1, 1, 2, 2358.65935), -- Compound Braid
(20198, 5220, 1, 1, 2, 1415.2251), -- Metal Hardener
(20198, 2183, 1, 1, 2, 2327.6457), -- Recipe: Mithril Banded Mail
(20198, 2274, 1, 1, 2, 252.7293), -- Recipe: Skull Breaker
(20198, 2982, 1, 1, 2, 4512.7564), -- Recipe: Brigandine Shield
-- Amber Basilisk
(20199, 1882, 1, 1, -1, 140414), -- Leather
(20199, 1834, 1, 1, -1, 702070), -- Emergency Dressing
(20199, 1900, 1, 1, -1, 69132), -- Enchanted Necklace Chain
(20199, 57, 267, 533, 0, 700000), -- Adena
(20199, 1123, 1, 1, 1, 1349), -- Blue Buckskin Boots
(20199, 605, 1, 1, 1, 1349), -- Leather Gauntlets
(20199, 1867, 1, 1, 2, 92076.804567), -- Animal Skin
(20199, 1872, 1, 1, 2, 92076.804567), -- Animal Bone
(20199, 1882, 1, 1, 2, 15346.245354), -- Leather
(20199, 2250, 1, 1, 2, 17264.359134), -- Recipe: Bone Arrow
(20199, 6035, 1, 1, 2, 5754.786378), -- Magic Haste Potion
-- Strain
(20200, 1877, 1, 1, -1, 22339), -- Adamantite Nugget
(20200, 1061, 1, 1, -1, 338473), -- Greater Healing Potion
(20200, 2183, 1, 1, -1, 36742), -- Recipe: Mithril Banded Mail
(20200, 57, 236, 471, 0, 700000), -- Adena
(20200, 433, 1, 1, 1, 99.219705), -- Elven Tunic
(20200, 434, 1, 1, 1, 99.219705), -- White Tunic
(20200, 1936, 1, 1, 1, 3122.045745), -- White Tunic Pattern
(20200, 435, 1, 1, 1, 99.219705), -- Mystic's Tunic
(20200, 466, 1, 1, 1, 158.96283), -- Elven Stockings
(20200, 467, 1, 1, 1, 158.96283), -- Dark Stockings
(20200, 1933, 1, 1, 1, 4488.398265), -- Dark Stockings Fabric
(20200, 468, 1, 1, 1, 158.971215), -- Mystic's Stockings
(20200, 1875, 1, 1, 2, 2260.643151), -- Stone of Purity
(20200, 1879, 1, 1, 2, 5651.721894), -- Cokes
(20200, 1885, 1, 1, 2, 2825.860947), -- High-Grade Suede
(20200, 5550, 1, 1, 2, 452.113428), -- Durable Metal Plate
(20200, 5549, 1, 1, 2, 3391.002732), -- Metallic Thread
(20200, 955, 1, 1, 2, 135.603624), -- Scroll: Enchant Weapon (D-Grade)
(20200, 2188, 1, 1, 2, 2422.166526), -- Recipe: Manticore Skin Gaiters
(20200, 6667, 1, 1, 2, 21193.843086), -- Deluxe Chest Key - Grade 3
(20200, 1834, 1, 1, 2, 37678.044612), -- Emergency Dressing
-- Ghoul
(20201, 1870, 1, 1, -1, 664672), -- Coal
(20201, 466, 1, 1, -1, 2769), -- Elven Stockings
(20201, 1933, 1, 1, -1, 78197), -- Dark Stockings Fabric
(20201, 57, 280, 562, 0, 700000), -- Adena
(20201, 392, 1, 1, 1, 472.313303), -- Lion Skin Shirt
(20201, 414, 1, 1, 1, 756.686697), -- Lion Skin Gaiters
(20201, 1876, 1, 1, 2, 10377.53951), -- Mithril Ore
(20201, 1880, 1, 1, 2, 5188.769755), -- Steel
(20201, 1877, 1, 1, 2, 2075.49056), -- Adamantite Nugget
(20201, 1881, 1, 1, 2, 6918.33077), -- Coarse Bone Powder
(20201, 1882, 1, 1, 2, 11530.565735), -- Leather
(20201, 737, 1, 1, 2, 5188.769755), -- Scroll of Resurrection
(20201, 6387, 1, 1, 2, 2075.533915), -- Blessed Scroll of Resurrection for Pets
-- Dead Seeker
(20202, 2198, 1, 1, -1, 13867), -- Recipe: Sage's Rag
(20202, 1872, 1, 1, -1, 881920), -- Animal Bone
(20202, 2154, 1, 1, -1, 70818), -- Recipe: Elven Earring
(20202, 57, 279, 557, 0, 700000), -- Adena
(20202, 849, 1, 1, 1, 355.947735), -- Tiger's Eye Earring
(20202, 1901, 1, 1, 1, 12143.396694), -- Tiger's Eye Earring Stone
(20202, 912, 1, 1, 1, 266.817837), -- Near Forest Necklace
(20202, 880, 1, 1, 1, 532.837734), -- Black Pearl Ring
(20202, 1874, 1, 1, 2, 3349.348063), -- Oriharukon Ore
(20202, 1878, 1, 1, 2, 20096.027939), -- Braided Hemp
(20202, 1884, 1, 1, 2, 30916.96606), -- Cord
(20202, 1889, 1, 1, 2, 3349.348063), -- Compound Braid
(20202, 5220, 1, 1, 2, 2009.59675), -- Metal Hardener
(20202, 2272, 1, 1, 2, 358.886782), -- Recipe: Sword of Revolution
(20202, 2274, 1, 1, 2, 358.826343), -- Recipe: Skull Breaker
-- Dion Grizzly
(20203, 1882, 1, 1, -1, 59453), -- Leather
(20203, 1897, 1, 1, -1, 63700), -- Necklace of Wisdom Chain
(20203, 57, 124, 215, 0, 700000), -- Adena
(20203, 176, 1, 1, 1, 150.5), -- Apprentice's Staff
(20203, 2501, 1, 1, 1, 150.5), -- Bone Club
(20203, 1867, 1, 1, 2, 42147.964968), -- Animal Skin
(20203, 1872, 1, 1, 2, 42147.964968), -- Animal Bone
(20203, 1882, 1, 1, 2, 7024.625385), -- Leather
(20203, 2174, 1, 1, 2, 13743.873882), -- Recipe: Hard Leather Gaiters
(20203, 5273, 1, 1, 2, 1264.570797), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Bloody Bee
(20204, 1868, 1, 1, -1, 823680), -- Thread
(20204, 2014, 1, 1, -1, 4734), -- Iron Hammer Head
(20204, 1867, 1, 1, -1, 549120), -- Animal Skin
(20204, 57, 188, 333, 0, 700000), -- Adena
(20204, 846, 1, 1, 1, 989.082223), -- Coral Earring
(20204, 909, 1, 1, 1, 741.814033), -- Blue Diamond Necklace
(20204, 1898, 1, 1, 1, 6248.466215), -- Blue Diamond Necklace Gem
(20204, 878, 1, 1, 1, 1483.637529), -- Blue Coral Ring
(20204, 1867, 1, 1, 2, 64880.682372), -- Animal Skin
(20204, 1872, 1, 1, 2, 64880.682372), -- Animal Bone
(20204, 1882, 1, 1, 2, 10813.447062), -- Leather
(20204, 3953, 1, 1, 2, 1946.551167), -- Recipe: Blessed Spiritshot D
(20204, 1831, 1, 1, 2, 129761.637027), -- Antidote
-- Dire Wolf
(20205, 1871, 1, 1, -1, 407376), -- Charcoal
(20205, 1928, 1, 1, -1, 59341), -- Piece Bone Gaiters Fragment
(20205, 1868, 1, 1, -1, 814752), -- Thread
(20205, 57, 181, 334, 0, 700000), -- Adena
(20205, 257, 1, 1, 1, 256), -- Viper Fang
(20205, 1868, 1, 1, 2, 120332.806902), -- Thread
(20205, 1873, 1, 1, 2, 24066.614621), -- Silver Nugget
(20205, 2255, 1, 1, 2, 1471.037778), -- Recipe: Saber
(20205, 6037, 1, 1, 2, 120332.540699), -- Waking Scroll
-- Kadif Werewolf
(20206, 2182, 1, 1, -1, 49884), -- Recipe: Scale Gaiters
(20206, 376, 1, 1, -1, 2072), -- Iron Plate Gaiters
(20206, 1899, 1, 1, -1, 64927), -- Necklace of Devotion Chain
(20206, 57, 183, 343, 0, 700000), -- Adena
(20206, 391, 1, 1, 1, 483.983521), -- Puma Skin Shirt
(20206, 413, 1, 1, 1, 775.016479), -- Puma Skin Gaiters
(20206, 1869, 1, 1, 2, 46641.861084), -- Iron Ore
(20206, 1864, 1, 1, 2, 93283.722168), -- Stem
(20206, 1880, 1, 1, 2, 4664.107376), -- Steel
(20206, 2182, 1, 1, 2, 5599.251457), -- Recipe: Scale Gaiters
(20206, 6666, 1, 1, 2, 46642.057915), -- Deluxe Chest Key - Grade 2
-- Ol Mahum Guerilla
(20207, 2263, 1, 1, -1, 12768), -- Recipe: Dwarven Trident
(20207, 2181, 1, 1, -1, 82308), -- Recipe: White Tunic
(20207, 2152, 1, 1, -1, 144764), -- Recipe: Enchanted Necklace
(20207, 57, 357, 682, 0, 700000), -- Adena
(20207, 220, 1, 1, 1, 293), -- Crafted Dagger
(20207, 1865, 1, 1, 2, 92295.187125), -- Varnish
(20207, 1870, 1, 1, 2, 92295.187125), -- Coal
(20207, 1879, 1, 1, 2, 15382.56825), -- Cokes
(20207, 1875, 1, 1, 2, 6153.11625), -- Stone of Purity
(20207, 2152, 1, 1, 2, 16248.94125), -- Recipe: Enchanted Necklace
-- Ol Mahum Raider
(20208, 1869, 1, 1, -1, 858524), -- Iron Ore
(20208, 1872, 1, 3, -1, 572349), -- Animal Bone
(20208, 1931, 1, 1, -1, 112225), -- Leather Boots Lining
(20208, 57, 371, 714, 0, 700000), -- Adena
(20208, 626, 1, 1, 1, 1900.693228), -- Bronze Shield
(20208, 45, 1, 1, 1, 1332.846619), -- Bone Helmet
(20208, 1932, 1, 1, 1, 25493.460153), -- Bone Helmet Design
(20208, 1866, 1, 1, 2, 53536.648342), -- Suede
(20208, 1871, 1, 1, 2, 80304.972513), -- Charcoal
(20208, 5220, 1, 1, 2, 3212.272529), -- Metal Hardener
(20208, 1885, 1, 1, 2, 6692.138565), -- High-Grade Suede
(20208, 2180, 1, 1, 2, 6037.995538), -- Recipe: Scale Mail
(20208, 6666, 1, 1, 2, 80304.972513), -- Deluxe Chest Key - Grade 2
-- Ol Mahum Marksman
(20209, 1889, 1, 1, -1, 61967), -- Compound Braid
(20209, 45, 1, 1, -1, 7714), -- Bone Helmet
(20209, 2178, 1, 1, -1, 148721), -- Recipe: Dark Stockings
(20209, 57, 398, 780, 0, 700000), -- Adena
(20209, 274, 1, 1, 1, 331), -- Reinforced Bow
(20209, 1867, 1, 1, 2, 139111.405868), -- Animal Skin
(20209, 1872, 1, 1, 2, 139111.405868), -- Animal Bone
(20209, 1882, 1, 1, 2, 23185.1072), -- Leather
(20209, 2178, 1, 1, 2, 16693.277184), -- Recipe: Dark Stockings
(20209, 1061, 1, 1, 2, 63232.80388), -- Greater Healing Potion
-- Ol Mahum Sergeant
(20210, 2183, 1, 1, -1, 62137), -- Recipe: Mithril Banded Mail
(20210, 377, 1, 1, -1, 2947), -- Scale Gaiters
(20210, 1900, 1, 1, -1, 103336), -- Enchanted Necklace Chain
(20210, 57, 400, 793, 0, 700000), -- Adena
(20210, 348, 1, 1, 1, 251.775363), -- Scale Mail
(20210, 1935, 1, 1, 1, 7208.843866), -- Scale Mail Fragment
(20210, 377, 1, 1, 1, 402.609403), -- Scale Gaiters
(20210, 1937, 1, 1, 1, 11085.771368), -- Scale Gaiters Fragment
(20210, 1868, 1, 1, 2, 172042.475982), -- Thread
(20210, 1873, 1, 1, 2, 34408.541284), -- Silver Nugget
(20210, 5549, 1, 1, 2, 8602.020102), -- Metallic Thread
(20210, 1889, 1, 1, 2, 5734.680068), -- Compound Braid
(20210, 2184, 1, 1, 2, 9035.934856), -- Recipe: Mithril Banded Gaiters
(20210, 2274, 1, 1, 2, 614.347708), -- Recipe: Skull Breaker
-- Ol Mahum Captain
(20211, 1869, 1, 3, -1, 503685), -- Iron Ore
(20211, 1865, 1, 3, -1, 503685), -- Varnish
(20211, 57, 425, 850, 0, 700000), -- Adena
(20211, 86, 1, 1, 1, 22.214546), -- Tomahawk
(20211, 179, 1, 1, 1, 22.214546), -- Mace of Prayer
(20211, 180, 1, 1, 1, 22.214546), -- Mace of Judgment
(20211, 2022, 1, 1, 1, 857.28093), -- Mace of Judgment Head
(20211, 181, 1, 1, 1, 22.214546), -- Mace of Miracle
(20211, 182, 1, 1, 1, 22.214546), -- Doom Hammer
(20211, 183, 1, 1, 1, 22.214546), -- Mystic Staff
(20211, 184, 1, 1, 1, 22.214546), -- Conjuror's Staff
(20211, 2023, 1, 1, 1, 682.000985), -- Conjuror's Staff Head
(20211, 185, 1, 1, 1, 22.216263), -- Staff of Mana
(20211, 1869, 1, 1, 2, 91748.128035), -- Iron Ore
(20211, 1864, 1, 1, 2, 183496.543317), -- Stem
(20211, 1880, 1, 1, 2, 9174.956427), -- Steel
(20211, 5550, 1, 1, 2, 1223.384973), -- Durable Metal Plate
(20211, 2264, 1, 1, 2, 948.776841), -- Recipe: Two-handed Sword
(20211, 2280, 1, 1, 2, 655.210407), -- Recipe: Crucifix of Blood
-- Porta
(20213, 2292, 1, 1, -1, 18643), -- Recipe: Light Crossbow
(20213, 1894, 1, 1, -1, 117742), -- Crafted Leather
(20213, 1884, 1, 5, -1, 688339), -- Cord
(20213, 57, 1401, 2796, 0, 700000), -- Adena
(20213, 352, 1, 1, 1, 251.721176), -- Brigandine Tunic
(20213, 1941, 1, 1, 1, 11497.125738), -- Brigandine Temper
(20213, 2377, 1, 1, 1, 402.650794), -- Mithril Scale Gaiters
(20213, 2918, 1, 1, 1, 17151.949178), -- Mithril Scale Gaiters Material
(20213, 2378, 1, 1, 1, 402.650794), -- Brigandine Gaiters
(20213, 2919, 1, 1, 1, 17151.90232), -- Brigandine Gaiters Material
(20213, 1864, 9, 27, 2, 24091.834679), -- Stem
(20213, 1869, 2, 6, 2, 43365.144373), -- Iron Ore
(20213, 1878, 1, 1, 2, 86730.683869), -- Braided Hemp
(20213, 1884, 1, 1, 2, 133431.851731), -- Cord
(20213, 2983, 1, 1, 2, 14749.94159), -- Recipe: Plate Helmet
(20213, 2286, 1, 1, 2, 1204.730027), -- Recipe: Bonebreaker
(20213, 2290, 1, 1, 2, 1204.730027), -- Recipe: Mithril Dagger
(20213, 1341, 80, 240, 2, 90344.083704), -- Bone Arrow
-- Excuro
(20214, 1877, 1, 1, -1, 87132), -- Adamantite Nugget
(20214, 2997, 1, 1, -1, 172880), -- Recipe: Karmian Gloves
(20214, 1879, 1, 1, -1, 363049), -- Cokes
(20214, 57, 883, 1766, 0, 700000), -- Adena
(20214, 851, 1, 1, 1, 390.795928), -- Omen Beast's Eye Earring
(20214, 1905, 1, 1, 1, 17733.578136), -- Omen Beast's Eye Earring Gemstone
(20214, 914, 1, 1, 1, 293.08276), -- Necklace of Darkness
(20214, 1907, 1, 1, 1, 12681.830048), -- Necklace of Darkness Gem
(20214, 882, 1, 1, 1, 586.16552), -- Mithril Ring
(20214, 1906, 1, 1, 1, 25058.547608), -- Mithril Ring Wire
(20214, 1865, 1, 1, 2, 182306.425014), -- Varnish
(20214, 1870, 1, 1, 2, 182306.425014), -- Coal
(20214, 1879, 1, 1, 2, 30384.47223), -- Cokes
(20214, 1875, 1, 1, 2, 12153.788892), -- Stone of Purity
(20214, 1805, 1, 1, 2, 607.648608), -- Recipe: Soulshot (C-Grade)
(20214, 5269, 1, 1, 2, 607.240242), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
-- Mordeo
(20215, 1872, 1, 7, -1, 839007), -- Animal Bone
(20215, 2206, 1, 1, -1, 66412), -- Recipe: Mithril Shirt
(20215, 4469, 1, 1, -1, 14383), -- Dye of STR (Str+1 Con-1)
(20215, 57, 1014, 2049, 0, 700000), -- Adena
(20215, 297, 1, 1, 1, 91.13338), -- Glaive
(20215, 2055, 1, 1, 1, 5225.86662), -- Glaive Edge
(20215, 1866, 1, 1, 2, 105327.600752), -- Suede
(20215, 1871, 1, 1, 2, 157991.098612), -- Charcoal
(20215, 5220, 1, 1, 2, 6319.55924), -- Metal Hardener
(20215, 1885, 1, 1, 2, 13165.798836), -- High-Grade Suede
(20215, 2212, 1, 1, 2, 5662.797004), -- Recipe: Plated Leather Gaiters
(20215, 2205, 1, 1, 2, 4999.681932), -- Recipe: Chain Gaiters
(20215, 2989, 1, 1, 2, 8359.424628), -- Recipe: Chain Hood
(20215, 2299, 1, 1, 2, 690.038996), -- Recipe: Big Hammer
-- Ricenseo
(20216, 2297, 1, 1, -1, 9822), -- Recipe: Flamberge
(20216, 2933, 1, 1, -1, 251030), -- Sage's Worn Gloves Lining
(20216, 1905, 1, 1, -1, 218797), -- Omen Beast's Eye Earring Gemstone
(20216, 57, 889, 1806, 0, 700000), -- Adena
(20216, 1125, 1, 1, 1, 250.323507), -- Assault Boots
(20216, 1957, 1, 1, 1, 10505.133471), -- Assault Boots Part
(20216, 2427, 1, 1, 1, 250.323507), -- Salamander Skin Boots
(20216, 2931, 1, 1, 1, 10505.133471), -- Salamander Skin Boot Lining
(20216, 2428, 1, 1, 1, 250.323507), -- Plate Boots
(20216, 2932, 1, 1, 1, 10505.133471), -- Plate Boots Design
(20216, 61, 1, 1, 1, 250.323507), -- Mithril Plate Gloves
(20216, 1949, 1, 1, 1, 10505.133471), -- Mithril Gloves Design
(20216, 607, 1, 1, 1, 250.323507), -- Ogre Power Gauntlets
(20216, 1963, 1, 1, 1, 10505.133471), -- Ogre Power Gauntlets Part
(20216, 2451, 1, 1, 1, 250.323507), -- Sage's Worn Gloves
(20216, 2933, 1, 1, 1, 10505.391603), -- Sage's Worn Gloves Lining
(20216, 1867, 1, 3, 2, 125495.644209), -- Animal Skin
(20216, 1872, 1, 1, 2, 250991.288418), -- Animal Bone
(20216, 1882, 1, 1, 2, 41831.881403), -- Leather
(20216, 1894, 1, 1, 2, 6604.944143), -- Crafted Leather
(20216, 2314, 1, 1, 2, 822.047144), -- Recipe: Body Slasher
(20216, 5269, 1, 1, 2, 627.194683), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
-- Krator
(20217, 1873, 1, 3, -1, 524276), -- Silver Nugget
(20217, 2075, 1, 1, -1, 20560), -- Orcish Glaive Blade
(20217, 2163, 1, 1, -1, 133744), -- Recipe: Earring of Protection
(20217, 57, 1032, 2115, 0, 700000), -- Adena
(20217, 62, 1, 1, 1, 141.768462), -- Reinforced Mithril Boots
(20217, 1958, 1, 1, 1, 6186.891876), -- Reinforced Mithril Boots Design
(20217, 2429, 1, 1, 1, 141.768462), -- Chain Boots
(20217, 2937, 1, 1, 1, 6186.891876), -- Chain Boots Part
(20217, 2430, 1, 1, 1, 141.768462), -- Karmian Boots
(20217, 2938, 1, 1, 1, 6186.891876), -- Karmian Boots Fabric
(20217, 2431, 1, 1, 1, 141.768462), -- Plated Leather Boots
(20217, 2939, 1, 1, 1, 6186.891876), -- Plate Leather Boots Lining
(20217, 2432, 1, 1, 1, 141.768462), -- Dwarven Chain Boots
(20217, 2940, 1, 1, 1, 6186.891876), -- Dwarven Chain Boots Part
(20217, 2433, 1, 1, 1, 141.768462), -- Boots of Seal
(20217, 2941, 1, 1, 1, 6186.891876), -- Boots of Seal Pattern
(20217, 2452, 1, 1, 1, 141.768462), -- Reinforced Mithril Gloves
(20217, 2942, 1, 1, 1, 6186.891876), -- Reinforced Mithril Gloves Design
(20217, 2453, 1, 1, 1, 141.768462), -- Chain Gloves
(20217, 2943, 1, 1, 1, 6186.891876), -- Chain Gloves Design
(20217, 2454, 1, 1, 1, 141.768462), -- Karmian Gloves
(20217, 2944, 1, 1, 1, 6186.948834), -- Karmian Gloves Fabric
(20217, 1868, 1, 1, 2, 206484.46107), -- Thread
(20217, 1873, 1, 1, 2, 41297.00361), -- Silver Nugget
(20217, 5549, 1, 1, 2, 10324.18128), -- Metallic Thread
(20217, 1889, 1, 1, 2, 6882.88035), -- Compound Braid
(20217, 2163, 1, 1, 2, 5267.35986), -- Recipe: Earring of Protection
(20217, 2225, 1, 1, 2, 2244.35091), -- Recipe: Demon's Stockings
(20217, 2321, 1, 1, 2, 359.80908), -- Recipe: Stiletto
(20217, 5279, 1, 1, 2, 344.21364), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20217, 8723, 1, 1, 2, 4129.72821), -- Life Stone - Level 46
(20217, 8733, 1, 1, 2, 1032.36243), -- Mid-Grade Life Stone - Level 46
(20217, 8743, 1, 1, 2, 103.31979), -- High-Grade Life Stone - Level 46
(20217, 8753, 1, 1, 2, 20.32977), -- Top-Grade Life Stone - Level 46
-- Premo
(20218, 1876, 1, 1, -1, 545172), -- Mithril Ore
(20218, 2073, 1, 1, -1, 21069), -- Chakram Edge
(20218, 1908, 1, 1, -1, 258131), -- Moonstone Earring Wire
(20218, 57, 1078, 2190, 0, 700000), -- Adena
(20218, 631, 1, 1, 1, 421.00704), -- Eldarake
(20218, 1964, 1, 1, 1, 17349.669162), -- Eldarake Temper
(20218, 2495, 1, 1, 1, 421.00704), -- Chain Shield
(20218, 2945, 1, 1, 1, 17349.669162), -- Chain Shield Fragment
(20218, 2413, 1, 1, 1, 294.704928), -- Chain Hood
(20218, 2936, 1, 1, 1, 15757.942668), -- Chain Hood Pattern
(20218, 1864, 1, 1, 2, 214713.70785), -- Stem
(20218, 1869, 1, 1, 2, 107356.853925), -- Iron Ore
(20218, 1878, 1, 1, 2, 42942.74157), -- Braided Hemp
(20218, 1884, 1, 1, 2, 66065.82507), -- Cord
(20218, 4039, 1, 1, 2, 3578.487255), -- Mold Glue
(20218, 2320, 1, 1, 2, 373.90518), -- Recipe: Cursed Staff
(20218, 2319, 1, 1, 2, 373.90518), -- Recipe: Raid Sword
(20218, 2217, 1, 1, 2, 6352.362765), -- Recipe: Knight's Shield
(20218, 8723, 1, 1, 2, 4294.095255), -- Life Stone - Level 46
(20218, 8733, 1, 1, 2, 1073.412), -- Mid-Grade Life Stone - Level 46
(20218, 8743, 1, 1, 2, 107.3412), -- High-Grade Life Stone - Level 46
(20218, 8753, 1, 1, 2, 22.36275), -- Top-Grade Life Stone - Level 46
-- Validus
(20219, 1873, 1, 3, -1, 614037), -- Silver Nugget
(20219, 2060, 1, 1, -1, 24378), -- Stormbringer Blade
(20219, 2164, 1, 1, -1, 236168), -- Recipe: Ring of Protection
(20219, 57, 1209, 2473, 0, 700000), -- Adena
(20219, 281, 1, 1, 1, 82.309065), -- Crystallized Ice Bow
(20219, 2074, 1, 1, 1, 5138.690935), -- Crystallized Ice Bow Shaft
(20219, 1870, 1, 1, 2, 131910.492938), -- Coal
(20219, 1865, 1, 1, 2, 131910.492938), -- Varnish
(20219, 1874, 1, 1, 2, 8793.896979), -- Oriharukon Ore
(20219, 4043, 1, 1, 2, 4397.094079), -- Asofe
(20219, 4039, 1, 1, 2, 4397.094079), -- Mold Glue
(20219, 2230, 1, 1, 2, 2556.260441), -- Recipe: Theca Leather Gaiters
(20219, 2326, 1, 1, 2, 459.480462), -- Recipe: Horn of Glory
(20219, 8723, 1, 1, 2, 5276.454659), -- Life Stone - Level 46
(20219, 8733, 1, 1, 2, 1319.04087), -- Mid-Grade Life Stone - Level 46
(20219, 8743, 1, 1, 2, 131.904087), -- High-Grade Life Stone - Level 46
(20219, 8753, 1, 1, 2, 26.788468), -- Top-Grade Life Stone - Level 46
-- Dicor
(20220, 1895, 1, 1, -1, 883618), -- Metallic Fiber
(20220, 2944, 1, 1, -1, 277992), -- Karmian Gloves Fabric
(20220, 1911, 1, 1, -1, 230023), -- Earring of Protection Gemstone
(20220, 57, 1221, 2490, 0, 700000), -- Adena
(20220, 1126, 1, 1, 1, 184.3264), -- Crimson Boots
(20220, 1974, 1, 1, 1, 9603.23888), -- Crimson Boot Fabric
(20220, 2434, 1, 1, 1, 184.3264), -- Rind Leather Boots
(20220, 2948, 1, 1, 1, 9603.23888), -- Rind Leather Boots Lining
(20220, 2455, 1, 1, 1, 199.5944), -- Plated Leather Gloves
(20220, 2946, 1, 1, 1, 6382.46816), -- Plate Leather Gloves Design
(20220, 2456, 1, 1, 1, 184.3264), -- Dwarven Chain Gloves
(20220, 2949, 1, 1, 1, 9603.23888), -- Dwarven Chain Gloves Design
(20220, 2457, 1, 1, 1, 184.3264), -- Gloves of Seal
(20220, 2950, 1, 1, 1, 9603.23888), -- Gloves of Seal Pattern
(20220, 2458, 1, 1, 1, 184.3264), -- Rind Leather Gloves
(20220, 2951, 1, 1, 1, 9603.34992), -- Rind Leather Gloves Design
(20220, 1871, 1, 1, 2, 114190.721286), -- Charcoal
(20220, 1866, 1, 1, 2, 76127.147524), -- Suede
(20220, 1877, 1, 1, 2, 4567.571795), -- Adamantite Nugget
(20220, 4041, 1, 1, 2, 992.985829), -- Mold Hardener
(20220, 4040, 1, 1, 2, 2283.887784), -- Mold Lubricant
(20220, 951, 1, 1, 2, 207.644687), -- Scroll: Enchant Weapon (C-Grade)
(20220, 2343, 1, 1, 2, 265.516219), -- Recipe: Mace of Underworld
(20220, 2345, 1, 1, 2, 265.516219), -- Recipe: Dark Screamer
(20220, 8724, 1, 1, 2, 3806.275867), -- Life Stone - Level 49
(20220, 8734, 1, 1, 2, 951.61991), -- Mid-Grade Life Stone - Level 49
(20220, 8744, 1, 1, 2, 95.161991), -- High-Grade Life Stone - Level 49
(20220, 8754, 1, 1, 2, 18.950889), -- Top-Grade Life Stone - Level 49
-- Perum
(20221, 2352, 1, 1, -1, 9326), -- Recipe: Widow Maker
(20221, 2073, 1, 1, -1, 34456), -- Chakram Edge
(20221, 951, 1, 1, -1, 8105), -- Scroll: Enchant Weapon (C-Grade)
(20221, 57, 1763, 3583, 0, 700000), -- Adena
(20221, 1126, 1, 1, 1, 265.68964), -- Crimson Boots
(20221, 1974, 1, 1, 1, 13842.190163), -- Crimson Boot Fabric
(20221, 2434, 1, 1, 1, 265.68964), -- Rind Leather Boots
(20221, 2948, 1, 1, 1, 13842.190163), -- Rind Leather Boots Lining
(20221, 2455, 1, 1, 1, 287.697065), -- Plated Leather Gloves
(20221, 2946, 1, 1, 1, 9199.743866), -- Plate Leather Gloves Design
(20221, 2456, 1, 1, 1, 265.68964), -- Dwarven Chain Gloves
(20221, 2949, 1, 1, 1, 13842.190163), -- Dwarven Chain Gloves Design
(20221, 2457, 1, 1, 1, 265.68964), -- Gloves of Seal
(20221, 2950, 1, 1, 1, 13842.190163), -- Gloves of Seal Pattern
(20221, 2458, 1, 1, 1, 265.68964), -- Rind Leather Gloves
(20221, 2951, 1, 1, 1, 13842.350217), -- Rind Leather Gloves Design
(20221, 1872, 1, 1, 2, 188107.597296), -- Animal Bone
(20221, 1867, 1, 1, 2, 188107.597296), -- Animal Skin
(20221, 1881, 1, 1, 2, 18810.859689), -- Coarse Bone Powder
(20221, 1875, 1, 1, 2, 9405.179946), -- Stone of Purity
(20221, 4041, 1, 1, 2, 1227.001635), -- Mold Hardener
(20221, 2334, 1, 1, 2, 327.866832), -- Recipe: Sword of Whispering Death
(20221, 2351, 1, 1, 2, 295.380027), -- Recipe: Scorpion
(20221, 3005, 1, 1, 2, 5758.161237), -- Recipe: Demon's Boots
(20221, 6668, 1, 1, 2, 50386.034961), -- Deluxe Chest Key - Grade 4
(20221, 8724, 1, 1, 2, 4702.589973), -- Life Stone - Level 49
(20221, 8734, 1, 1, 2, 1175.522544), -- Mid-Grade Life Stone - Level 49
(20221, 8744, 1, 1, 2, 117.452295), -- High-Grade Life Stone - Level 49
(20221, 8754, 1, 1, 2, 23.490459), -- Top-Grade Life Stone - Level 49
(20221, 1539, 1, 1, 2, 31352.26581), -- Greater Healing Potion
-- Torfe
(20222, 1876, 1, 1, -1, 679016), -- Mithril Ore
(20222, 2168, 1, 1, -1, 86389), -- Recipe: Necklace of Mermaid
(20222, 1895, 1, 3, -1, 485011), -- Metallic Fiber
(20222, 57, 1340, 2733, 0, 700000), -- Adena
(20222, 2496, 1, 1, 1, 417.505968), -- Dwarven Chain Shield
(20222, 2947, 1, 1, 1, 17907.400368), -- Dwarven Chain Shield Fragment
(20222, 632, 1, 1, 1, 385.419408), -- Knight's Shield
(20222, 1972, 1, 1, 1, 20056.27536), -- Knight's Shield Fragment
(20222, 500, 1, 1, 1, 269.853408), -- Great Helmet
(20222, 1971, 1, 1, 1, 15347.545488), -- Great Helmet Material
(20222, 1873, 1, 1, 2, 50142.783922), -- Silver Nugget
(20222, 1868, 1, 1, 2, 250714.725492), -- Thread
(20222, 1876, 1, 1, 2, 25071.391961), -- Mithril Ore
(20222, 1895, 1, 1, 2, 35816.216667), -- Metallic Fiber
(20222, 4042, 1, 1, 2, 2089.249085), -- Enria
(20222, 3006, 1, 1, 2, 5116.544818), -- Recipe: Demon's Gloves
(20222, 2222, 1, 1, 2, 783.317304), -- Recipe: Composite Armor
(20222, 8724, 1, 1, 2, 4178.49817), -- Life Stone - Level 49
(20222, 8734, 1, 1, 2, 1044.826013), -- Mid-Grade Life Stone - Level 49
(20222, 8744, 1, 1, 2, 104.361719), -- High-Grade Life Stone - Level 49
(20222, 8754, 1, 1, 2, 20.952932), -- Top-Grade Life Stone - Level 49
(20222, 1539, 1, 1, 2, 27858.131917), -- Greater Healing Potion
-- Mandragora Sprout
(20223, 734, 1, 1, -1, 49539), -- Haste Potion
(20223, 2011, 1, 1, -1, 6781), -- Short Spear Edge
(20223, 1864, 1, 1, -1, 594474), -- Stem
(20223, 57, 137, 239, 0, 700000), -- Adena
(20223, 845, 1, 1, 1, 1283.606976), -- Cat's Eye Earring
(20223, 908, 1, 1, 1, 962.712544), -- Necklace of Wisdom
(20223, 1897, 1, 1, 1, 10452.270016), -- Necklace of Wisdom Chain
(20223, 877, 1, 1, 1, 1925.410464), -- Ring of Wisdom
(20223, 1864, 1, 1, 2, 87798.98928), -- Stem
(20223, 1869, 1, 1, 2, 43899.49464), -- Iron Ore
(20223, 1878, 1, 1, 2, 17559.797856), -- Braided Hemp
(20223, 2175, 1, 1, 2, 35690.718224), -- Recipe: Boots
-- Ol Mahum Ranger
(20224, 2178, 1, 1, -1, 74717), -- Recipe: Dark Stockings
(20224, 1865, 1, 1, -1, 466983), -- Varnish
(20224, 1898, 1, 1, -1, 47969), -- Blue Diamond Necklace Gem
(20224, 57, 212, 381, 0, 700000), -- Adena
(20224, 27, 1, 1, 1, 485.692998), -- Hard Leather Shirt
(20224, 1927, 1, 1, 1, 5501.993196), -- Hard Leather Shirt Pattern
(20224, 33, 1, 1, 1, 779.289504), -- Hard Leather Gaiters
(20224, 1929, 1, 1, 1, 8899.024302), -- Hard Leather Gaiters Material
(20224, 1872, 1, 1, 2, 73567.598478), -- Animal Bone
(20224, 1867, 1, 1, 2, 73567.598478), -- Animal Skin
(20224, 1881, 1, 1, 2, 7356.712176), -- Coarse Bone Powder
(20224, 5153, 1, 1, 2, 2207.045434), -- Recipe: Soulshot (D) Compressed Package (100%)
(20224, 5268, 1, 1, 2, 2207.045434), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Giant Mist Leech
(20225, 2259, 1, 1, -1, 6517), -- Recipe: Spinebone Sword
(20225, 1931, 1, 1, -1, 54861), -- Leather Boots Lining
(20225, 2152, 1, 1, -1, 73889), -- Recipe: Enchanted Necklace
(20225, 57, 185, 346, 0, 700000), -- Adena
(20225, 40, 1, 1, 1, 731.502336), -- Leather Boots
(20225, 1931, 1, 1, 1, 7697.497664), -- Leather Boots Lining
(20225, 604, 1, 1, 1, 731.502336), -- Crafted Leather Gloves
(20225, 1934, 1, 1, 1, 7697.497664), -- Crafted Leather Gloves Lining
(20225, 1865, 1, 1, 2, 39256.835541), -- Varnish
(20225, 1870, 1, 1, 2, 39256.835541), -- Coal
(20225, 1879, 1, 1, 2, 6542.761302), -- Cokes
(20225, 1875, 1, 1, 2, 2617.140218), -- Stone of Purity
(20225, 2259, 1, 1, 2, 609.618933), -- Recipe: Spinebone Sword
(20225, 5437, 1, 1, 2, 959.808465), -- Recipe: Heavy Sword(100%)
-- Gray Ant
(20226, 1868, 1, 1, -1, 884148), -- Thread
(20226, 413, 1, 1, -1, 2937), -- Puma Skin Gaiters
(20226, 1899, 1, 1, -1, 69074), -- Necklace of Devotion Chain
(20226, 57, 192, 367, 0, 700000), -- Adena
(20226, 123, 1, 1, 1, 39.373776), -- Saber
(20226, 2017, 1, 1, 1, 824.082984), -- Saber Blade
(20226, 5285, 1, 1, 1, 39.373776), -- Heavy Sword
(20226, 5531, 1, 1, 1, 1041.169464), -- Heavy Sword Edge
(20226, 1866, 1, 1, 2, 41351.087969), -- Suede
(20226, 1871, 1, 1, 2, 62026.574062), -- Charcoal
(20226, 5220, 1, 1, 2, 2481.113907), -- Metal Hardener
(20226, 2178, 1, 1, 2, 9924.224062), -- Recipe: Dark Stockings
-- Horror Mist Ripper
(20227, 2260, 1, 1, -1, 7238), -- Recipe: Mace of Judgment
(20227, 1899, 1, 1, -1, 72835), -- Necklace of Devotion Chain
(20227, 2178, 1, 1, -1, 74583), -- Recipe: Dark Stockings
(20227, 57, 201, 388, 0, 700000), -- Adena
(20227, 391, 1, 1, 1, 542.799628), -- Puma Skin Shirt
(20227, 413, 1, 1, 1, 869.200372), -- Puma Skin Gaiters
(20227, 1867, 1, 1, 2, 69763.474464), -- Animal Skin
(20227, 1872, 1, 1, 2, 69763.474464), -- Animal Bone
(20227, 1882, 1, 1, 2, 11627.19216), -- Leather
(20227, 2181, 1, 1, 2, 5237.460912), -- Recipe: White Tunic
(20227, 6035, 1, 1, 2, 4360.398), -- Magic Haste Potion
-- Giant Crimson Ant
(20228, 2180, 1, 1, -1, 40128), -- Recipe: Scale Mail
(20228, 1884, 1, 1, -1, 328429), -- Cord
(20228, 1931, 1, 1, -1, 69764), -- Leather Boots Lining
(20228, 57, 229, 448, 0, 700000), -- Adena
(20228, 847, 1, 1, 1, 723.509376), -- Red Crescent Earring
(20228, 910, 1, 1, 1, 542.632032), -- Necklace of Devotion
(20228, 1899, 1, 1, 1, 11700.580476), -- Necklace of Devotion Chain
(20228, 890, 1, 1, 1, 1085.278116), -- Ring of Devotion
(20228, 1868, 1, 1, 2, 99842.559024), -- Thread
(20228, 1873, 1, 1, 2, 19968.617808), -- Silver Nugget
(20228, 5549, 1, 1, 2, 4992.220704), -- Metallic Thread
(20228, 1889, 1, 1, 2, 3327.970464), -- Compound Braid
(20228, 2180, 1, 1, 2, 3753.573312), -- Recipe: Scale Mail
(20228, 1831, 1, 1, 2, 133123.058688), -- Antidote
-- Stinger Wasp
(20229, 1061, 1, 1, -1, 357490), -- Greater Healing Potion
(20229, 414, 1, 1, -1, 2458), -- Lion Skin Gaiters
(20229, 1864, 1, 3, -1, 589858), -- Stem
(20229, 57, 249, 498, 0, 700000), -- Adena
(20229, 848, 1, 1, 1, 491.364384), -- Enchanted Earring
(20229, 911, 1, 1, 1, 368.799312), -- Enchanted Necklace
(20229, 1900, 1, 1, 1, 8816.539872), -- Enchanted Necklace Chain
(20229, 879, 1, 1, 1, 739.296432), -- Enchanted Ring
(20229, 1869, 1, 1, 2, 46047.720602), -- Iron Ore
(20229, 1864, 1, 1, 2, 92095.441204), -- Stem
(20229, 1880, 1, 1, 2, 4604.732994), -- Steel
(20229, 5550, 1, 1, 2, 613.925333), -- Durable Metal Plate
(20229, 2265, 1, 1, 2, 476.216978), -- Recipe: Spiked Club
(20229, 2274, 1, 1, 2, 328.937404), -- Recipe: Skull Breaker
(20229, 1832, 1, 1, 2, 51164.025485), -- Greater Antidote
-- Marsh Stakato Worker
(20230, 1834, 1, 1, -1, 745819), -- Emergency Dressing
(20230, 434, 1, 1, -1, 1746), -- White Tunic
(20230, 1870, 1, 1, -1, 671237), -- Coal
(20230, 57, 284, 566, 0, 700000), -- Adena
(20230, 292, 1, 1, 1, 148), -- Pike
(20230, 1870, 1, 1, 2, 91701.33687), -- Coal
(20230, 1865, 1, 1, 2, 91701.33687), -- Varnish
(20230, 1874, 1, 1, 2, 6113.422458), -- Oriharukon Ore
(20230, 956, 1, 1, 2, 3056.903802), -- Scroll: Enchant Armor (D-Grade)
-- Toad Lord
(20231, 1832, 1, 1, -1, 722627), -- Greater Antidote
(20231, 2282, 1, 1, -1, 4645), -- Recipe: Cursed Maingauche
(20231, 1877, 1, 1, -1, 26015), -- Adamantite Nugget
(20231, 57, 274, 550, 0, 700000), -- Adena
(20231, 1123, 1, 1, 1, 1388.5), -- Blue Buckskin Boots
(20231, 605, 1, 1, 1, 1388.5), -- Leather Gauntlets
(20231, 1871, 1, 1, 2, 59233.240472), -- Charcoal
(20231, 1866, 1, 1, 2, 39488.771126), -- Suede
(20231, 1877, 1, 1, 2, 2369.38324), -- Adamantite Nugget
(20231, 955, 1, 1, 2, 236.938324), -- Scroll: Enchant Weapon (D-Grade)
(20231, 2277, 1, 1, 2, 423.10415), -- Recipe: Bich'hwa
(20231, 1832, 1, 1, 2, 65814.562688), -- Greater Antidote
-- Marsh Stakato Soldier
(20232, 2147, 1, 1, -1, 45242), -- Recipe: Blacksmith's frame
(20232, 2027, 1, 1, -1, 8298), -- Spiked Club Head
(20232, 1901, 1, 1, -1, 87485), -- Tiger's Eye Earring Stone
(20232, 57, 268, 535, 0, 700000), -- Adena
(20232, 628, 1, 1, 1, 821.340788), -- Hoplon
(20232, 47, 1, 1, 1, 574.659212), -- Helmet
(20232, 1872, 1, 1, 2, 74837.606625), -- Animal Bone
(20232, 1867, 1, 1, 2, 74837.606625), -- Animal Skin
(20232, 1881, 1, 1, 2, 7483.847115), -- Coarse Bone Powder
(20232, 1875, 1, 1, 2, 3741.837105), -- Stone of Purity
(20232, 2156, 1, 1, 2, 4490.34285), -- Recipe: Elven Necklace
(20232, 2191, 1, 1, 2, 7513.75968), -- Recipe: RIP Gauntlets
-- Marsh Spider
(20233, 2280, 1, 1, -1, 5301), -- Recipe: Crucifix of Blood
(20233, 955, 1, 1, -1, 2969), -- Scroll: Enchant Weapon (D-Grade)
(20233, 2154, 1, 1, -1, 79458), -- Recipe: Elven Earring
(20233, 57, 313, 625, 0, 700000), -- Adena
(20233, 849, 1, 1, 1, 399.38733), -- Tiger's Eye Earring
(20233, 1901, 1, 1, 1, 13625.367732), -- Tiger's Eye Earring Stone
(20233, 912, 1, 1, 1, 299.380086), -- Near Forest Necklace
(20233, 880, 1, 1, 1, 597.864852), -- Black Pearl Ring
(20233, 1873, 1, 1, 2, 22547.825456), -- Silver Nugget
(20233, 1868, 1, 1, 2, 112739.12728), -- Thread
(20233, 1876, 1, 1, 2, 11273.912728), -- Mithril Ore
(20233, 2273, 1, 1, 2, 402.539904), -- Recipe: Tarbar
(20233, 2274, 1, 1, 2, 402.539904), -- Recipe: Skull Breaker
(20233, 2975, 1, 1, 2, 5033.038992), -- Recipe: Brigandine Helmet
(20233, 1832, 1, 1, 2, 62633.015736), -- Greater Antidote
-- Marsh Stakato Drone
(20234, 1879, 1, 1, -1, 124798), -- Cokes
(20234, 2971, 1, 1, -1, 40042), -- Recipe: Mithril Scale Gaiters
(20234, 1938, 1, 1, -1, 50339), -- Mithril Banded Mail Material
(20234, 57, 316, 631, 0, 700000), -- Adena
(20234, 293, 1, 1, 1, 53.5), -- War Hammer
(20234, 296, 1, 1, 1, 53.5), -- Dwarven Pike
(20234, 1873, 1, 1, 2, 31849.943364), -- Silver Nugget
(20234, 1868, 1, 1, 2, 159250.163564), -- Thread
(20234, 1876, 1, 1, 2, 15925.083368), -- Mithril Ore
(20234, 2979, 1, 1, 2, 10659.31184), -- Recipe: Manticore Skin Gloves
(20234, 2188, 1, 1, 2, 5687.497864), -- Recipe: Manticore Skin Gaiters
-- Shackle
(20235, 2074, 1, 1, -1, 8417), -- Crystallized Ice Bow Shaft
(20235, 2340, 1, 1, -1, 2764), -- Recipe: Pa'agrian Hammer
(20235, 2163, 1, 1, -1, 60630), -- Recipe: Earring of Protection
(20235, 57, 470, 955, 0, 700000), -- Adena
(20235, 96, 1, 1, 1, 10.618202), -- Scythe
(20235, 2062, 1, 1, 1, 734.04772), -- Scythe Edge
(20235, 298, 1, 1, 1, 10.618202), -- Orcish Glaive
(20235, 2075, 1, 1, 1, 734.04772), -- Orcish Glaive Blade
(20235, 302, 1, 1, 1, 10.618202), -- Body Slasher
(20235, 2076, 1, 1, 1, 734.049954), -- Body Slasher Blade
(20235, 1870, 1, 1, 2, 56163.066915), -- Coal
(20235, 1865, 1, 1, 2, 56163.066915), -- Varnish
(20235, 1874, 1, 1, 2, 3744.204461), -- Oriharukon Ore
(20235, 4043, 1, 1, 2, 1872.164736), -- Asofe
(20235, 4039, 1, 1, 2, 1872.164736), -- Mold Glue
(20235, 2216, 1, 1, 2, 2320.829215), -- Recipe: Great Helmet
(20235, 8723, 1, 1, 2, 2246.572681), -- Life Stone - Level 46
(20235, 8733, 1, 1, 2, 561.674423), -- Mid-Grade Life Stone - Level 46
(20235, 8743, 1, 1, 2, 56.129939), -- High-Grade Life Stone - Level 46
(20235, 8753, 1, 1, 2, 11.125979), -- Top-Grade Life Stone - Level 46
-- Cave Servant
(20236, 2219, 1, 1, -1, 76370), -- Recipe: Crimson Boots
(20236, 3021, 1, 1, -1, 4284), -- Recipe: Dwarven War Hammer
(20236, 1908, 1, 1, -1, 116435), -- Moonstone Earring Wire
(20236, 57, 484, 990, 0, 700000), -- Adena
(20236, 62, 1, 1, 1, 66.496124), -- Reinforced Mithril Boots
(20236, 1958, 1, 1, 1, 2901.945352), -- Reinforced Mithril Boots Design
(20236, 2429, 1, 1, 1, 66.496124), -- Chain Boots
(20236, 2937, 1, 1, 1, 2901.945352), -- Chain Boots Part
(20236, 2430, 1, 1, 1, 66.496124), -- Karmian Boots
(20236, 2938, 1, 1, 1, 2901.945352), -- Karmian Boots Fabric
(20236, 2431, 1, 1, 1, 66.496124), -- Plated Leather Boots
(20236, 2939, 1, 1, 1, 2901.945352), -- Plate Leather Boots Lining
(20236, 2432, 1, 1, 1, 66.496124), -- Dwarven Chain Boots
(20236, 2940, 1, 1, 1, 2901.945352), -- Dwarven Chain Boots Part
(20236, 2433, 1, 1, 1, 66.496124), -- Boots of Seal
(20236, 2941, 1, 1, 1, 2901.945352), -- Boots of Seal Pattern
(20236, 2452, 1, 1, 1, 66.496124), -- Reinforced Mithril Gloves
(20236, 2942, 1, 1, 1, 2901.945352), -- Reinforced Mithril Gloves Design
(20236, 2453, 1, 1, 1, 66.496124), -- Chain Gloves
(20236, 2943, 1, 1, 1, 2901.945352), -- Chain Gloves Design
(20236, 2454, 1, 1, 1, 66.496124), -- Karmian Gloves
(20236, 2944, 1, 1, 1, 2901.972068), -- Karmian Gloves Fabric
(20236, 1870, 1, 1, 2, 58110.63069), -- Coal
(20236, 1865, 1, 1, 2, 58110.63069), -- Varnish
(20236, 1874, 1, 1, 2, 3874.042046), -- Oriharukon Ore
(20236, 4043, 1, 1, 2, 1937.085696), -- Asofe
(20236, 4039, 1, 1, 2, 1937.085696), -- Mold Glue
(20236, 2216, 1, 1, 2, 2401.30849), -- Recipe: Great Helmet
(20236, 8723, 1, 1, 2, 2324.476966), -- Life Stone - Level 46
(20236, 8733, 1, 1, 2, 581.151578), -- Mid-Grade Life Stone - Level 46
(20236, 8743, 1, 1, 2, 58.076354), -- High-Grade Life Stone - Level 46
(20236, 8753, 1, 1, 2, 11.511794), -- Top-Grade Life Stone - Level 46
-- Cave Servant Archer
(20237, 2329, 1, 1, -1, 3846), -- Recipe: Tsurugi
(20237, 3010, 1, 1, -1, 44939), -- Recipe: Composite Helmet
(20237, 951, 1, 1, -1, 3007), -- Scroll: Enchant Weapon (C-Grade)
(20237, 57, 653, 1332, 0, 700000), -- Adena
(20237, 282, 1, 1, 1, 16.581576), -- Elemental Bow
(20237, 2085, 1, 1, 1, 1267.418424), -- Crossbow Shaft
(20237, 285, 1, 1, 1, 16.581576), -- Noble Elven Bow
(20237, 2086, 1, 1, 1, 1267.418424), -- Noble Elven Bow Shaft
(20237, 1869, 1, 1, 2, 61061.755032), -- Iron Ore
(20237, 1864, 1, 1, 2, 122123.510064), -- Stem
(20237, 1880, 1, 1, 2, 6106.30305), -- Steel
(20237, 5550, 1, 1, 2, 814.067451), -- Durable Metal Plate
(20237, 4043, 1, 1, 2, 2035.328061), -- Asofe
(20237, 952, 1, 1, 2, 814.067451), -- Scroll: Enchant Armor (C-Grade)
(20237, 2230, 1, 1, 2, 1183.315437), -- Recipe: Theca Leather Gaiters
(20237, 8724, 1, 1, 2, 2035.328061), -- Life Stone - Level 49
(20237, 8734, 1, 1, 2, 508.911732), -- Mid-Grade Life Stone - Level 49
(20237, 8744, 1, 1, 2, 51.01872), -- High-Grade Life Stone - Level 49
(20237, 8754, 1, 1, 2, 10.203744), -- Top-Grade Life Stone - Level 49
(20237, 1342, 10, 30, 2, 122123.191197), -- Steel Arrow
-- Cave Servant Warrior
(20238, 2357, 1, 1, -1, 2599), -- Recipe: Crystal Dagger
(20238, 1877, 1, 1, -1, 63734), -- Adamantite Nugget
(20238, 4041, 1, 1, -1, 13855), -- Mold Hardener
(20238, 57, 630, 1281, 0, 700000), -- Adena
(20238, 355, 1, 1, 1, 71.23571), -- Dwarven Chain Mail Shirt
(20238, 1968, 1, 1, 1, 4252.67124), -- Dwarven Chain Mail Shirt Material
(20238, 382, 1, 1, 1, 113.977136), -- Dwarven Chain Gaiters
(20238, 1969, 1, 1, 1, 6745.115914), -- Dwarven Chain Gaiters Material
(20238, 1871, 1, 1, 2, 58830.987264), -- Charcoal
(20238, 1866, 1, 1, 2, 39220.658176), -- Suede
(20238, 1877, 1, 1, 2, 2353.224384), -- Adamantite Nugget
(20238, 4041, 1, 1, 2, 511.608832), -- Mold Hardener
(20238, 4040, 1, 1, 2, 1176.675136), -- Mold Lubricant
(20238, 2335, 1, 1, 2, 136.840256), -- Recipe: War Axe
(20238, 2348, 1, 1, 2, 136.840256), -- Recipe: Heathen's Book
(20238, 6668, 1, 1, 2, 21011.084864), -- Deluxe Chest Key - Grade 4
(20238, 8724, 1, 1, 2, 1961.083264), -- Life Stone - Level 49
(20238, 8734, 1, 1, 2, 490.207872), -- Mid-Grade Life Stone - Level 49
(20238, 8744, 1, 1, 2, 48.970432), -- High-Grade Life Stone - Level 49
(20238, 8754, 1, 1, 2, 9.819264), -- Top-Grade Life Stone - Level 49
-- Cave Servant Captain
(20239, 3007, 1, 1, -1, 61644), -- Recipe: Theca Leather Boots
(20239, 2079, 1, 1, -1, 11647), -- Bec De Corbin Blade
(20239, 1867, 1, 5, -1, 753426), -- Animal Skin
(20239, 57, 669, 1365, 0, 700000), -- Adena
(20239, 73, 1, 1, 1, 8.49744), -- Shamshir
(20239, 2077, 1, 1, 1, 623.75256), -- Shamshir Blade
(20239, 74, 1, 1, 1, 8.49744), -- Katana
(20239, 2078, 1, 1, 1, 623.75256), -- Katana Blade
(20239, 131, 1, 1, 1, 8.49744), -- Spirit Sword
(20239, 2080, 1, 1, 1, 623.75256), -- Spirit Sword Blade
(20239, 133, 1, 1, 1, 8.49744), -- Raid Sword
(20239, 2081, 1, 1, 1, 623.75256), -- Raid Sword Blade
(20239, 1872, 1, 1, 2, 83456.462368), -- Animal Bone
(20239, 1867, 1, 1, 2, 83456.462368), -- Animal Skin
(20239, 1881, 1, 1, 2, 8345.627648), -- Coarse Bone Powder
(20239, 1875, 1, 1, 2, 4172.813824), -- Stone of Purity
(20239, 4041, 1, 1, 2, 544.280064), -- Mold Hardener
(20239, 3007, 1, 1, 2, 2276.012672), -- Recipe: Theca Leather Boots
(20239, 2351, 1, 1, 2, 130.865152), -- Recipe: Scorpion
(20239, 952, 1, 1, 2, 834.63712), -- Scroll: Enchant Armor (C-Grade)
(20239, 8724, 1, 1, 2, 2086.406912), -- Life Stone - Level 49
(20239, 8734, 1, 1, 2, 521.601728), -- Mid-Grade Life Stone - Level 49
(20239, 8744, 1, 1, 2, 52.234528), -- High-Grade Life Stone - Level 49
(20239, 8754, 1, 1, 2, 10.595616), -- Top-Grade Life Stone - Level 49
-- Royal Cave Servant
(20240, 2092, 1, 1, -1, 9934), -- Homunkulus's Sword Blade
(20240, 2353, 1, 1, -1, 2974), -- Recipe: Samurai Longsword
(20240, 4601, 1, 1, -1, 4051), -- Greater Dye of STR (Str+3 Con-3)
(20240, 57, 722, 1466, 0, 700000), -- Adena
(20240, 265, 1, 1, 1, 22.817308), -- Fisted Blade
(20240, 2108, 1, 1, 1, 2019.182692), -- Fisted Blade Piece
(20240, 1864, 1, 1, 2, 137054.470422), -- Stem
(20240, 1869, 1, 1, 2, 68527.235211), -- Iron Ore
(20240, 1878, 1, 1, 2, 27410.950449), -- Braided Hemp
(20240, 1884, 1, 1, 2, 42170.584605), -- Cord
(20240, 4039, 1, 1, 2, 2284.175415), -- Mold Glue
(20240, 3022, 1, 1, 2, 111.883731), -- Recipe: Yaksa Mace
(20240, 3019, 1, 1, 2, 1827.340332), -- Recipe: Full Plate Shield
(20240, 8725, 1, 1, 2, 1903.432542), -- Life Stone - Level 52
(20240, 8735, 1, 1, 2, 475.999047), -- Mid-Grade Life Stone - Level 52
(20240, 8745, 1, 1, 2, 47.628087), -- High-Grade Life Stone - Level 52
(20240, 8755, 1, 1, 2, 9.300159), -- Top-Grade Life Stone - Level 52
-- Hunter Gargoyle
(20241, 2100, 1, 1, -1, 10217), -- Paradia Staff Head
(20241, 3015, 1, 1, -1, 50627), -- Recipe: Drake Leather Gloves
(20241, 1539, 1, 1, -1, 402767), -- Greater Healing Potion
(20241, 57, 720, 1455, 0, 700000), -- Adena
(20241, 854, 1, 1, 1, 110.257488), -- Earring of Seal
(20241, 1914, 1, 1, 1, 7017.33344), -- Earring of Seal Gemstone
(20241, 917, 1, 1, 1, 82.69904), -- Necklace of Mermaid
(20241, 1916, 1, 1, 1, 5315.24976), -- Necklace of Mermaid Teardrop
(20241, 885, 1, 1, 1, 165.326992), -- Ring of Ages
(20241, 1915, 1, 1, 1, 11005.13328), -- Ring of Ages Gemstone
(20241, 1872, 1, 1, 2, 76873.44124), -- Animal Bone
(20241, 1867, 1, 1, 2, 76873.44124), -- Animal Skin
(20241, 1881, 1, 1, 2, 7687.41204), -- Coarse Bone Powder
(20241, 1875, 1, 1, 2, 3843.70602), -- Stone of Purity
(20241, 4041, 1, 1, 2, 501.38987), -- Mold Hardener
(20241, 4604, 1, 1, 2, 128.19145), -- Greater Dye of CON (Con+3 Dex-3)
(20241, 4609, 1, 1, 2, 128.19145), -- Greater Dye of MEN (Men+3 Int-3)
(20241, 3014, 1, 1, 2, 1610.45815), -- Recipe: Full Plate Boots
(20241, 2359, 1, 1, 2, 94.06366), -- Recipe: Eminence Bow
(20241, 8725, 1, 1, 2, 1601.45928), -- Life Stone - Level 52
(20241, 8735, 1, 1, 2, 400.36482), -- Mid-Grade Life Stone - Level 52
(20241, 8745, 1, 1, 2, 40.07044), -- High-Grade Life Stone - Level 52
(20241, 8755, 1, 1, 2, 7.81034), -- Top-Grade Life Stone - Level 52
-- Dustwind Gargoyle
(20242, 1985, 1, 1, -1, 66727), -- Theca Leather Gaiters Pattern
(20242, 1868, 1, 9, -1, 774035), -- Thread
(20242, 1918, 1, 1, -1, 83806), -- Nassen's Earring Gemstone
(20242, 57, 766, 1556, 0, 700000), -- Adena
(20242, 400, 1, 1, 1, 37.508306), -- Theca Leather Armor
(20242, 1984, 1, 1, 1, 2552.652421), -- Theca Leather Armor Pattern
(20242, 401, 1, 1, 1, 17.757597), -- Drake Leather Armor
(20242, 1987, 1, 1, 1, 1816.790316), -- Drake Leather Armor Texture
(20242, 420, 1, 1, 1, 60.033908), -- Theca Leather Gaiters
(20242, 1985, 1, 1, 1, 4106.257452), -- Theca Leather Gaiters Pattern
(20242, 1872, 1, 1, 2, 68047.178448), -- Animal Bone
(20242, 1867, 1, 1, 2, 68047.178448), -- Animal Skin
(20242, 1881, 1, 1, 2, 6804.750186), -- Coarse Bone Powder
(20242, 1875, 1, 1, 2, 3402.29424), -- Stone of Purity
(20242, 4041, 1, 1, 2, 443.721264), -- Mold Hardener
(20242, 3034, 1, 1, 2, 102.036486), -- Recipe: Spiritshot B
(20242, 5270, 1, 1, 2, 102.036486), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20242, 4959, 1, 1, 2, 983.334186), -- Recipe: Sealed Avadon Boots (60%)
(20242, 4941, 1, 1, 2, 392.622168), -- Recipe: Zubei's Gaiters (60%)
(20242, 6669, 1, 1, 2, 11868.735282), -- Deluxe Chest Key - Grade 5
(20242, 8726, 1, 1, 2, 1181.424036), -- Life Stone - Level 55
(20242, 8736, 1, 1, 2, 295.275156), -- Mid-Grade Life Stone - Level 55
(20242, 8746, 1, 1, 2, 29.592198), -- High-Grade Life Stone - Level 55
(20242, 8756, 1, 1, 2, 5.821416), -- Top-Grade Life Stone - Level 55
-- Thunder Wyrm
(20243, 4599, 1, 1, -1, 5751), -- Greater Dye of WIT (Wit+2 Int-2)
(20243, 1873, 1, 1, -1, 690175), -- Silver Nugget
(20243, 1806, 1, 1, -1, 3451), -- Recipe: Soulshot (B-Grade)
(20243, 57, 682, 1388, 0, 700000), -- Adena
(20243, 203, 1, 1, 1, 3.463976), -- Pa'agrian Axe
(20243, 2112, 1, 1, 1, 308.507784), -- Pa'agrian Axe Blade
(20243, 204, 1, 1, 1, 2.703032), -- Deadman's Staff
(20243, 2116, 1, 1, 1, 299.73248), -- Deadman's Staff Head
(20243, 205, 1, 1, 1, 2.703032), -- Ghoul's Staff
(20243, 2117, 1, 1, 1, 299.73248), -- Ghoul's Staff Head
(20243, 206, 1, 1, 1, 2.703032), -- Demon's Staff
(20243, 2118, 1, 1, 1, 299.73248), -- Demon's Staff Head
(20243, 2503, 1, 1, 1, 2.703032), -- Yaksa Mace
(20243, 2969, 1, 1, 1, 306.018672), -- Yaksa Mace Head
(20243, 1869, 1, 1, 2, 53090.529408), -- Iron Ore
(20243, 1864, 1, 1, 2, 106180.889472), -- Stem
(20243, 1880, 1, 1, 2, 5309.103744), -- Steel
(20243, 5550, 1, 1, 2, 707.85792), -- Durable Metal Plate
(20243, 4043, 1, 1, 2, 1769.6448), -- Asofe
(20243, 4144, 1, 1, 2, 545.626368), -- Recipe: Zubei's Leather Gaiters (100%)
(20243, 4184, 1, 1, 2, 61.133184), -- Recipe: Sprite's Staff (100%)
(20243, 5155, 1, 1, 2, 106.178688), -- Recipe: Soulshot (B) Compressed Package (100%)
(20243, 8726, 1, 1, 2, 1228.929408), -- Life Stone - Level 55
(20243, 8736, 1, 1, 2, 307.190016), -- Mid-Grade Life Stone - Level 55
(20243, 8746, 1, 1, 2, 30.651264), -- High-Grade Life Stone - Level 55
(20243, 8756, 1, 1, 2, 6.265728), -- Top-Grade Life Stone - Level 55
-- Maluk Succubus
(20244, 3955, 1, 1, -1, 3548), -- Recipe: Blessed Spiritshot B
(20244, 2117, 1, 1, -1, 8346), -- Ghoul's Staff Head
(20244, 4592, 1, 1, -1, 5913), -- Greater Dye of CON (Con+2 Dex-2)
(20244, 57, 701, 1428, 0, 700000), -- Adena
(20244, 400, 1, 1, 1, 34.38225), -- Theca Leather Armor
(20244, 1984, 1, 1, 1, 2339.906625), -- Theca Leather Armor Pattern
(20244, 401, 1, 1, 1, 16.277625), -- Drake Leather Armor
(20244, 1987, 1, 1, 1, 1665.3735), -- Drake Leather Armor Texture
(20244, 420, 1, 1, 1, 55.0305), -- Theca Leather Gaiters
(20244, 1985, 1, 1, 1, 3764.0295), -- Theca Leather Gaiters Pattern
(20244, 1872, 1, 1, 2, 72778.24202), -- Animal Bone
(20244, 1867, 1, 1, 2, 72778.24202), -- Animal Skin
(20244, 1881, 1, 1, 2, 7277.84008), -- Coarse Bone Powder
(20244, 1875, 1, 1, 2, 3638.92004), -- Stone of Purity
(20244, 4041, 1, 1, 2, 474.59342), -- Mold Hardener
(20244, 4185, 1, 1, 2, 62.87688), -- Recipe: Keshanberk (100%)
(20244, 5436, 1, 1, 2, 89.07558), -- Recipe: Berserker Blade(100%)
(20244, 8322, 1, 1, 2, 62.87688), -- Recipe: Ice Storm Hammer (60%)
(20244, 8726, 1, 1, 2, 1263.57124), -- Life Stone - Level 55
(20244, 8736, 1, 1, 2, 315.81342), -- Mid-Grade Life Stone - Level 55
(20244, 8746, 1, 1, 2, 31.59722), -- High-Grade Life Stone - Level 55
(20244, 8756, 1, 1, 2, 6.3512), -- Top-Grade Life Stone - Level 55
-- Maluk Succubus Turen
(20245, 1895, 1, 1, -1, 526594), -- Metallic Fiber
(20245, 4071, 1, 1, -1, 33383), -- Avadon Robe Fabric
(20245, 4129, 1, 1, -1, 19947), -- Recipe: Earrings of Black Ore (100%)
(20245, 57, 727, 1485, 0, 700000), -- Adena
(20245, 12159, 1, 1, 1, 621.488992), -- Common Item - Zubei's Shield
(20245, 4101, 1, 1, 1, 3945.07984), -- Zubei's Shield Fragment
(20245, 12171, 1, 1, 1, 621.488992), -- Common Item - Avadon Shield
(20245, 4439, 1, 1, 1, 4693.284928), -- Avadon Shield Fragment
(20245, 12160, 1, 1, 1, 434.83824), -- Common Item - Zubei's Helmet
(20245, 4102, 1, 1, 1, 3056.481952), -- Zubei's Helmet Design
(20245, 12170, 1, 1, 1, 434.83824), -- Common Item - Avadon Circlet
(20245, 4072, 1, 1, 1, 3056.498816), -- Avadon Circlet Pattern
(20245, 1864, 1, 1, 2, 83756.319034), -- Stem
(20245, 1869, 1, 1, 2, 41878.159517), -- Iron Ore
(20245, 1878, 1, 1, 2, 16751.298423), -- Braided Hemp
(20245, 1884, 1, 1, 2, 25771.241657), -- Cord
(20245, 4039, 1, 1, 2, 1395.898265), -- Mold Glue
(20245, 4945, 1, 1, 2, 322.103741), -- Recipe: Avadon Gaiters (60%)
(20245, 4999, 1, 1, 2, 520.800729), -- Recipe: Sealed Doom Boots (60%)
(20245, 8322, 1, 1, 2, 48.289599), -- Recipe: Ice Storm Hammer (60%)
(20245, 8726, 1, 1, 2, 969.426681), -- Life Stone - Level 55
(20245, 8736, 1, 1, 2, 242.3134), -- Mid-Grade Life Stone - Level 55
(20245, 8746, 1, 1, 2, 24.23134), -- High-Grade Life Stone - Level 55
(20245, 8756, 1, 1, 2, 4.846268), -- Top-Grade Life Stone - Level 55
(20245, 6036, 1, 1, 2, 1396.071346), -- Greater Magic Haste Potion
-- Cave Keeper
(20246, 2964, 1, 1, -1, 128620), -- Divine Gloves Pattern
(20246, 4049, 1, 1, -1, 123897), -- Adamantite Earring Gemstone
(20246, 947, 1, 1, -1, 945), -- Scroll: Enchant Weapon (B-Grade)
(20246, 57, 933, 1900, 0, 700000), -- Adena
(20246, 12338, 1, 1, 1, 953.195154), -- Common Item - Adamantite Earring
(20246, 4049, 1, 1, 1, 6099.582939), -- Adamantite Earring Gemstone
(20246, 12339, 1, 1, 1, 715.618071), -- Common Item - Adamantite Necklace
(20246, 4051, 1, 1, 1, 4509.92721), -- Adamantite Necklace Chain
(20246, 12340, 1, 1, 1, 1435.67097), -- Common Item - Adamantite Ring
(20246, 4050, 1, 1, 1, 7205.005656), -- Adamantite Ring Wire
(20246, 1869, 1, 1, 2, 58144.104144), -- Iron Ore
(20246, 1864, 1, 1, 2, 116288.208288), -- Stem
(20246, 1880, 1, 1, 2, 5814.44752), -- Steel
(20246, 5550, 1, 1, 2, 775.321512), -- Durable Metal Plate
(20246, 4043, 1, 1, 2, 1938.211016), -- Asofe
(20246, 4969, 1, 1, 2, 66.975608), -- Recipe: Hell Knife (60%)
(20246, 4176, 1, 1, 2, 723.188144), -- Recipe: Sealed Doom Boots (100%)
(20246, 4157, 1, 1, 2, 289.238152), -- Recipe: Blue Wolf Gaiters (100%)
(20246, 8727, 1, 1, 2, 1162.889504), -- Life Stone - Level 58
(20246, 8737, 1, 1, 2, 290.722376), -- Mid-Grade Life Stone - Level 58
(20246, 8747, 1, 1, 2, 29.127896), -- High-Grade Life Stone - Level 58
(20246, 8757, 1, 1, 2, 5.56584), -- Top-Grade Life Stone - Level 58
-- Turak Bugbear
(20248, 2250, 1, 1, -1, 141016), -- Recipe: Bone Arrow
(20248, 955, 1, 1, -1, 2256), -- Scroll: Enchant Weapon (D-Grade)
(20248, 1865, 1, 1, -1, 564065), -- Varnish
(20248, 57, 239, 476, 0, 700000), -- Adena
(20248, 86, 1, 1, 1, 12.446356), -- Tomahawk
(20248, 179, 1, 1, 1, 12.446356), -- Mace of Prayer
(20248, 180, 1, 1, 1, 12.446356), -- Mace of Judgment
(20248, 2022, 1, 1, 1, 480.31698), -- Mace of Judgment Head
(20248, 181, 1, 1, 1, 12.446356), -- Mace of Miracle
(20248, 182, 1, 1, 1, 12.446356), -- Doom Hammer
(20248, 183, 1, 1, 1, 12.446356), -- Mystic Staff
(20248, 184, 1, 1, 1, 12.446356), -- Conjuror's Staff
(20248, 2023, 1, 1, 1, 382.11121), -- Conjuror's Staff Head
(20248, 185, 1, 1, 1, 12.447318), -- Staff of Mana
(20248, 1870, 1, 1, 2, 51373.471374), -- Coal
(20248, 1865, 1, 1, 2, 51373.471374), -- Varnish
(20248, 1874, 1, 1, 2, 3424.951548), -- Oriharukon Ore
(20248, 1829, 1, 1, 2, 20549.442006), -- Scroll of Escape: Clan Hall
(20248, 2274, 1, 1, 2, 366.978186), -- Recipe: Skull Breaker
(20248, 2192, 1, 1, 2, 6552.685512), -- Recipe: Kite Shield
-- Turak Bugbear Warrior
(20249, 1873, 1, 1, -1, 480668), -- Silver Nugget
(20249, 1865, 1, 3, -1, 600835), -- Varnish
(20249, 57, 508, 1015, 0, 700000), -- Adena
(20249, 260, 1, 1, 1, 172), -- Triple-Edged Jamadhr
(20249, 1868, 1, 1, 2, 182548.216557), -- Thread
(20249, 1873, 1, 1, 2, 36509.73261), -- Silver Nugget
(20249, 5549, 1, 1, 2, 9127.209906), -- Metallic Thread
(20249, 1889, 1, 1, 2, 6084.806604), -- Compound Braid
(20249, 2186, 1, 1, 2, 3052.672641), -- Recipe: Brigandine Tunic
(20249, 6667, 1, 1, 2, 57046.178145), -- Deluxe Chest Key - Grade 3
(20249, 1341, 20, 60, 2, 152124.183537), -- Bone Arrow
-- Glass Jaguar
(20250, 1884, 1, 1, -1, 281232), -- Cord
(20250, 2259, 1, 1, -1, 7096), -- Recipe: Spinebone Sword
(20250, 1899, 1, 1, -1, 71407), -- Necklace of Devotion Chain
(20250, 57, 197, 380, 0, 700000), -- Adena
(20250, 847, 1, 1, 1, 619.503616), -- Red Crescent Earring
(20250, 910, 1, 1, 1, 464.627712), -- Necklace of Devotion
(20250, 1899, 1, 1, 1, 10018.601216), -- Necklace of Devotion Chain
(20250, 890, 1, 1, 1, 929.267456), -- Ring of Devotion
(20250, 1870, 1, 1, 2, 51296.9085), -- Coal
(20250, 1865, 1, 1, 2, 51296.9085), -- Varnish
(20250, 1874, 1, 1, 2, 3419.7939), -- Oriharukon Ore
(20250, 2182, 1, 1, 2, 6158.124392), -- Recipe: Scale Gaiters
(20250, 5437, 1, 1, 2, 1254.264708), -- Recipe: Heavy Sword(100%)
-- Delu Lizardman
(20251, 1880, 1, 1, -1, 48038), -- Steel
(20251, 2017, 1, 1, -1, 6384), -- Saber Blade
(20251, 2152, 1, 1, -1, 84573), -- Recipe: Enchanted Necklace
(20251, 57, 206, 403, 0, 700000), -- Adena
(20251, 123, 1, 1, 1, 42.796702), -- Saber
(20251, 2017, 1, 1, 1, 895.723943), -- Saber Blade
(20251, 5285, 1, 1, 1, 42.796702), -- Heavy Sword
(20251, 5531, 1, 1, 1, 1131.682653), -- Heavy Sword Edge
(20251, 1871, 1, 1, 2, 67400.525075), -- Charcoal
(20251, 1866, 1, 1, 2, 44933.642791), -- Suede
(20251, 1877, 1, 1, 2, 2696.021003), -- Adamantite Nugget
(20251, 2181, 1, 1, 2, 6746.811131), -- Recipe: White Tunic
-- Delu Lizardman Scout
(20252, 1865, 1, 1, -1, 502762), -- Varnish
(20252, 1900, 1, 1, -1, 55007), -- Enchanted Necklace Chain
(20252, 1061, 1, 1, -1, 304704), -- Greater Healing Potion
(20252, 57, 213, 422, 0, 700000), -- Adena
(20252, 1123, 1, 1, 1, 1073), -- Blue Buckskin Boots
(20252, 605, 1, 1, 1, 1073), -- Leather Gauntlets
(20252, 1872, 1, 1, 2, 45790.07202), -- Animal Bone
(20252, 1867, 1, 1, 2, 45790.07202), -- Animal Skin
(20252, 1881, 1, 1, 2, 4578.95067), -- Coarse Bone Powder
(20252, 1875, 1, 1, 2, 2289.546), -- Stone of Purity
(20252, 2185, 1, 1, 2, 6760.37922), -- Recipe: Iron Boots
(20252, 2274, 1, 1, 2, 245.34888), -- Recipe: Skull Breaker
(20252, 2187, 1, 1, 2, 1533.14784), -- Recipe: Manticore Skin Shirt
(20252, 6666, 1, 1, 2, 34342.48335), -- Deluxe Chest Key - Grade 2
-- Delu Lizardman Warrior
(20253, 2265, 1, 1, -1, 5545), -- Recipe: Spiked Club
(20253, 2153, 1, 1, -1, 83396), -- Recipe: Tiger's Eye Earring
(20253, 1900, 1, 1, -1, 58669), -- Enchanted Necklace Chain
(20253, 57, 226, 452, 0, 700000), -- Adena
(20253, 348, 1, 1, 1, 142.941546), -- Scale Mail
(20253, 1935, 1, 1, 1, 4092.708972), -- Scale Mail Fragment
(20253, 377, 1, 1, 1, 228.575226), -- Scale Gaiters
(20253, 1937, 1, 1, 1, 6293.774256), -- Scale Gaiters Fragment
(20253, 1873, 1, 1, 2, 23442.52872), -- Silver Nugget
(20253, 1868, 1, 1, 2, 117212.955834), -- Thread
(20253, 1876, 1, 1, 2, 11721.26436), -- Mithril Ore
(20253, 2266, 1, 1, 2, 606.046194), -- Recipe: Shilen Knife
(20253, 2971, 1, 1, 2, 3134.204892), -- Recipe: Mithril Scale Gaiters
-- Skeleton Axeman
(20254, 2181, 1, 1, -1, 49538), -- Recipe: White Tunic
(20254, 2262, 1, 1, -1, 7685), -- Recipe: Elven Bow
(20254, 1899, 1, 1, -1, 77326); -- Necklace of Devotion Chain

INSERT INTO `droplist` VALUES
(20254, 57, 212, 415, 0, 700000), -- Adena
(20254, 291, 1, 1, 1, 88.181775), -- Trident
(20254, 2019, 1, 1, 1, 2986.818225), -- Trident Edge
(20254, 1876, 1, 1, 2, 9258.167835), -- Mithril Ore
(20254, 1880, 1, 1, 2, 4629.102795), -- Steel
(20254, 1877, 1, 1, 2, 1851.618465), -- Adamantite Nugget
(20254, 1881, 1, 1, 2, 6172.11189), -- Coarse Bone Powder
(20254, 1882, 1, 1, 2, 10286.87832), -- Leather
(20254, 2182, 1, 1, 2, 5557.120695), -- Recipe: Scale Gaiters
-- Monster Eye Searcher
(20265, 1866, 1, 1, -1, 449035), -- Suede
(20265, 2015, 1, 1, -1, 8214), -- Sword Breaker Edge
(20265, 1872, 1, 1, -1, 898071), -- Animal Bone
(20265, 57, 306, 549, 0, 700000), -- Adena
(20265, 219, 1, 1, 1, 211.65993), -- Sword Breaker
(20265, 2015, 1, 1, 1, 2426.34007), -- Sword Breaker Edge
(20265, 1867, 1, 1, 2, 106110.762776), -- Animal Skin
(20265, 1872, 1, 1, 2, 106110.762776), -- Animal Bone
(20265, 1882, 1, 1, 2, 17685.048784), -- Leather
(20265, 5158, 1, 1, 2, 3183.327584), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20265, 8294, 1, 1, 2, 1946.09808), -- Recipe: Steel Sword (100%)
-- Monster Eye Gazer
(20266, 1866, 1, 1, -1, 279792), -- Suede
(20266, 2180, 1, 1, -1, 31555), -- Recipe: Scale Mail
(20266, 1878, 1, 1, -1, 167875), -- Braided Hemp
(20266, 57, 185, 346, 0, 700000), -- Adena
(20266, 432, 1, 1, 1, 488.596549), -- Cursed Tunic
(20266, 465, 1, 1, 1, 782.403451), -- Cursed Stockings
(20266, 1874, 1, 1, 2, 3925.7295), -- Oriharukon Ore
(20266, 1878, 1, 1, 2, 23554.4385), -- Braided Hemp
(20266, 5220, 1, 1, 2, 2355.45), -- Metal Hardener
(20266, 2260, 1, 1, 2, 914.382), -- Recipe: Mace of Judgment
-- Breka Orc
(20267, 2203, 1, 1, -1, 122890), -- Recipe: Reinforced Mithril Boots
(20267, 1882, 1, 1, -1, 125348), -- Leather
(20267, 1061, 1, 1, -1, 341857), -- Greater Healing Potion
(20267, 57, 239, 476, 0, 700000), -- Adena
(20267, 69, 1, 1, 1, 24.885154), -- Bastard Sword
(20267, 125, 1, 1, 1, 24.885154), -- Spinebone Sword
(20267, 2021, 1, 1, 1, 778.457628), -- Spinebone Sword Blade
(20267, 126, 1, 1, 1, 24.885154), -- Artisan's Sword
(20267, 128, 1, 1, 1, 24.88691), -- Knight's Sword
(20267, 1873, 1, 1, 2, 24659.133856), -- Silver Nugget
(20267, 1868, 1, 1, 2, 123295.498968), -- Thread
(20267, 1876, 1, 1, 2, 12329.566928), -- Mithril Ore
(20267, 2153, 1, 1, 2, 9587.543728), -- Recipe: Tiger's Eye Earring
(20267, 2274, 1, 1, 2, 440.25652), -- Recipe: Skull Breaker
-- Breka Orc Archer
(20268, 1878, 1, 1, -1, 308026), -- Braided Hemp
(20268, 1900, 1, 1, -1, 84252), -- Enchanted Necklace Chain
(20268, 57, 324, 651, 0, 700000), -- Adena
(20268, 275, 1, 1, 1, 56.606465), -- Long Bow
(20268, 276, 1, 1, 1, 56.606465), -- Elven Bow
(20268, 2024, 1, 1, 1, 1997.78707), -- Elven Bow Shaft
(20268, 1872, 1, 1, 2, 112216.0639), -- Animal Bone
(20268, 1867, 1, 1, 2, 112216.0639), -- Animal Skin
(20268, 1881, 1, 1, 2, 11221.60639), -- Coarse Bone Powder
(20268, 1875, 1, 1, 2, 5610.92523), -- Stone of Purity
(20268, 956, 1, 1, 2, 2805.34058), -- Scroll: Enchant Armor (D-Grade)
-- Breka Orc Shaman
(20269, 1879, 1, 1, -1, 111342), -- Cokes
(20269, 2029, 1, 1, -1, 7969), -- Gastraphetes Shaft
(20269, 2154, 1, 1, -1, 71526), -- Recipe: Elven Earring
(20269, 57, 282, 563, 0, 700000), -- Adena
(20269, 157, 1, 1, 1, 31.85426), -- Spiked Club
(20269, 2027, 1, 1, 1, 1551.29148), -- Spiked Club Head
(20269, 186, 1, 1, 1, 31.85426), -- Staff of Magic
(20269, 1875, 1, 1, 2, 2959.9682), -- Stone of Purity
(20269, 1879, 1, 1, 2, 7399.873095), -- Cokes
(20269, 1885, 1, 1, 2, 3699.96025), -- High-Grade Suede
(20269, 5550, 1, 1, 2, 591.99364), -- Durable Metal Plate
(20269, 5549, 1, 1, 2, 4439.904895), -- Metallic Thread
(20269, 2275, 1, 1, 2, 317.13945), -- Recipe: Heavy Bone Club
(20269, 2286, 1, 1, 2, 246.648215), -- Recipe: Bonebreaker
(20269, 6667, 1, 1, 2, 27749.512255), -- Deluxe Chest Key - Grade 3
-- Breka Orc Overlord
(20270, 2972, 1, 1, -1, 50438), -- Recipe: Brigandine Gaiters
(20270, 2976, 1, 1, -1, 126263), -- Recipe: Manticore Skin Boots
(20270, 1901, 1, 1, -1, 130274), -- Tiger's Eye Earring Stone
(20270, 57, 398, 795, 0, 700000), -- Adena
(20270, 393, 1, 1, 1, 142.870754), -- Mithril Banded Mail
(20270, 1938, 1, 1, 1, 5618.601014), -- Mithril Banded Mail Material
(20270, 394, 1, 1, 1, 142.870754), -- Reinforced Leather Shirt
(20270, 415, 1, 1, 1, 228.357532), -- Mithril Banded Gaiters
(20270, 1939, 1, 1, 1, 7340.956116), -- Mithril Banded Gaiters Material
(20270, 416, 1, 1, 1, 228.34383), -- Reinforced Leather Gaiters
(20270, 1870, 1, 1, 2, 100296.588195), -- Coal
(20270, 1865, 1, 1, 2, 100296.588195), -- Varnish
(20270, 1874, 1, 1, 2, 6686.439213), -- Oriharukon Ore
(20270, 2980, 1, 1, 2, 13426.404072), -- Recipe: Brigandine Gauntlets
(20270, 1341, 20, 60, 2, 167160.980325), -- Bone Arrow
-- Breka Orc Warrior
(20271, 1882, 1, 1, -1, 170847), -- Leather
(20271, 2271, 1, 1, -1, 5492), -- Recipe: Winged Spear
(20271, 2155, 1, 1, -1, 123405), -- Recipe: Elven Ring
(20271, 57, 325, 650, 0, 700000), -- Adena
(20271, 849, 1, 1, 1, 413.73337), -- Tiger's Eye Earring
(20271, 1901, 1, 1, 1, 14114.792548), -- Tiger's Eye Earring Stone
(20271, 912, 1, 1, 1, 310.133854), -- Near Forest Necklace
(20271, 880, 1, 1, 1, 619.340228), -- Black Pearl Ring
(20271, 1874, 1, 1, 2, 3406.418838), -- Oriharukon Ore
(20271, 1878, 1, 1, 2, 20438.513028), -- Braided Hemp
(20271, 1884, 1, 1, 2, 31443.890685), -- Cord
(20271, 1889, 1, 1, 2, 3406.418838), -- Compound Braid
(20271, 5220, 1, 1, 2, 2043.838569), -- Metal Hardener
(20271, 2187, 1, 1, 2, 2281.069263), -- Recipe: Manticore Skin Shirt
(20271, 2293, 1, 1, 2, 283.900071), -- Recipe: Glaive
(20271, 2269, 1, 1, 2, 364.950708), -- Recipe: Morning Star
-- Enku Orc Champion
(20291, 1879, 1, 1, -1, 69130), -- Cokes
(20291, 2255, 1, 1, -1, 10141), -- Recipe: Saber
(20291, 1898, 1, 1, -1, 42607), -- Blue Diamond Necklace Gem
(20291, 57, 189, 337, 0, 700000), -- Adena
(20291, 27, 1, 1, 1, 431.406745), -- Hard Leather Shirt
(20291, 1927, 1, 1, 1, 4887.03149), -- Hard Leather Shirt Pattern
(20291, 33, 1, 1, 1, 692.18776), -- Hard Leather Gaiters
(20291, 1929, 1, 1, 1, 7904.374005), -- Hard Leather Gaiters Material
(20291, 1864, 1, 1, 2, 98016.33842), -- Stem
(20291, 1869, 1, 1, 2, 49008.16921), -- Iron Ore
(20291, 1878, 1, 1, 2, 19603.267684), -- Braided Hemp
(20291, 2257, 1, 1, 2, 1198.167152), -- Recipe: Trident
(20291, 734, 1, 1, 2, 8168.057534), -- Haste Potion
-- Enku Orc Shaman
(20292, 2150, 1, 1, -1, 144749), -- Recipe: Blue Diamond Necklace
(20292, 2139, 1, 1, -1, 61663), -- Recipe: Steel Mold
(20292, 5220, 1, 1, -1, 12333), -- Metal Hardener
(20292, 57, 142, 248, 0, 700000), -- Adena
(20292, 845, 1, 1, 1, 1331.443806), -- Cat's Eye Earring
(20292, 908, 1, 1, 1, 998.590439), -- Necklace of Wisdom
(20292, 1897, 1, 1, 1, 10841.800046), -- Necklace of Wisdom Chain
(20292, 877, 1, 1, 1, 1997.165709), -- Ring of Wisdom
(20292, 1871, 1, 1, 2, 45536.009457), -- Charcoal
(20292, 1866, 1, 1, 2, 30357.366165), -- Suede
(20292, 2252, 1, 1, 2, 1866.254031), -- Recipe: Iron Hammer
(20292, 5158, 1, 1, 2, 1821.370347), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Garum Werewolf
(20307, 2137, 1, 1, -1, 43777), -- Recipe: Steel
(20307, 1867, 1, 1, -1, 198456), -- Animal Skin
(20307, 1060, 1, 1, -1, 330759), -- Lesser Healing Potion
(20307, 57, 80, 108, 0, 700000), -- Adena
(20307, 152, 1, 1, 1, 709.063155), -- Heavy Chisel
(20307, 5, 1, 1, 1, 457.936155), -- Mace
(20307, 8, 1, 1, 1, 457.936155), -- Willow Staff
(20307, 2006, 1, 1, 1, 1570.064535), -- Willow Staff Head
(20307, 1864, 1, 1, 2, 29310.4816), -- Stem
(20307, 1865, 1, 1, 2, 14655.2408), -- Varnish
(20307, 1866, 1, 1, 2, 9770.200675), -- Suede
(20307, 1873, 1, 1, 2, 5862.04815), -- Silver Nugget
(20307, 1868, 1, 1, 2, 29310.4816), -- Thread
(20307, 1802, 1, 1, 2, 31516.547175), -- Recipe: Necklace of Anguish
-- Hook Spider
(20308, 1868, 1, 1, -1, 475131), -- Thread
(20308, 1924, 1, 1, -1, 76634), -- Leather Helmet Design
(20308, 1897, 1, 1, -1, 56563), -- Necklace of Wisdom Chain
(20308, 57, 118, 183, 0, 700000), -- Adena
(20308, 38, 1, 1, 1, 1795.866945), -- Low Boots
(20308, 50, 1, 1, 1, 1795.866945), -- Leather Gloves
(20308, 1925, 1, 1, 1, 30677.26611), -- Leather Gloves Lining
(20308, 1868, 1, 1, 2, 70173.507304), -- Thread
(20308, 1873, 1, 1, 2, 14034.682935), -- Silver Nugget
(20308, 2143, 1, 1, 2, 7017.387782), -- Recipe: Synthetic Cokes
(20308, 5158, 1, 1, 2, 1403.421979), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Brown Bear
(20310, 735, 1, 1, -1, 19993), -- Alacrity Potion
(20310, 1872, 1, 1, -1, 319890), -- Animal Bone
(20310, 1800, 1, 1, -1, 75446), -- Recipe: Piece Bone Breastplate
(20310, 57, 119, 185, 0, 700000), -- Adena
(20310, 38, 1, 1, 1, 1813.63224), -- Low Boots
(20310, 50, 1, 1, 1, 1813.63224), -- Leather Gloves
(20310, 1925, 1, 1, 1, 30980.73552), -- Leather Gloves Lining
(20310, 1865, 1, 1, 2, 47245.4073), -- Varnish
(20310, 1870, 1, 1, 2, 47245.4073), -- Coal
(20310, 2144, 1, 1, 2, 9449.1854), -- Recipe: Compound Braid
-- Rakeclaw Imp
(20311, 1060, 1, 1, -1, 172757), -- Lesser Healing Potion
(20311, 2005, 1, 1, -1, 5553), -- Broadsword Blade
(20311, 57, 41, 58, 0, 700000), -- Adena
(20311, 1122, 1, 1, 1, 6514.326819), -- Cotton Shoes
(20311, 1129, 1, 1, 1, 6514.326819), -- Crude Leather Shoes
(20311, 1119, 1, 1, 1, 6514.346362), -- Short Leather Gloves
(20311, 1873, 1, 1, 2, 4592.664723), -- Silver Nugget
(20311, 1868, 1, 1, 2, 22963.268422), -- Thread
(20311, 1789, 1, 1, 2, 2122.281236), -- Recipe: Cedar Staff
(20311, 1060, 1, 1, 2, 25514.785619), -- Lesser Healing Potion
-- Rakeclaw Imp Hunter
(20312, 1866, 1, 1, -1, 64878), -- Suede
(20312, 2136, 1, 1, -1, 28622), -- Recipe: Cokes
(20312, 1666, 1, 1, -1, 32439), -- Recipe: Wooden Arrow
(20312, 57, 51, 72, 0, 700000), -- Adena
(20312, 19, 1, 1, 1, 11732.93531), -- Small Shield
(20312, 42, 1, 1, 1, 8213.06469), -- Leather Cap
(20312, 1869, 1, 1, 2, 14372.985256), -- Iron Ore
(20312, 1864, 1, 1, 2, 28745.970512), -- Stem
(20312, 1802, 1, 1, 2, 30909.610376), -- Recipe: Necklace of Anguish
(20312, 734, 1, 1, 2, 2395.433856), -- Haste Potion
-- Rakeclaw Imp Chieftain
(20313, 1814, 1, 1, -1, 95767), -- Recipe: Leather
(20313, 22, 1, 1, -1, 19461), -- Leather Shirt
(20313, 2006, 1, 1, -1, 12997), -- Willow Staff Head
(20313, 57, 98, 132, 0, 700000), -- Adena
(20313, 428, 1, 1, 1, 2874.194224), -- Feriotic Tunic
(20313, 1100, 1, 1, 1, 2874.194224), -- Cotton Tunic
(20313, 463, 1, 1, 1, 4593.805776), -- Feriotic Stockings
(20313, 1103, 1, 1, 1, 4593.805776), -- Cotton Stockings
(20313, 1864, 1, 1, 2, 53747.0829), -- Stem
(20313, 1869, 1, 1, 2, 26873.54145), -- Iron Ore
(20313, 1790, 1, 1, 2, 4967.432085), -- Recipe: Dirk
(20313, 6037, 1, 1, 2, 53746.943565), -- Waking Scroll
-- Great White Shark
(20314, 1874, 1, 1, -1, 57718), -- Oriharukon Ore
(20314, 4472, 1, 1, -1, 4947), -- Dye of CON (Con+1 Dex-1)
(20314, 1869, 1, 1, -1, 865765), -- Iron Ore
(20314, 57, 349, 705, 0, 700000), -- Adena
(20314, 70, 1, 1, 1, 15.669267), -- Claymore
(20314, 2047, 1, 1, 1, 955.292883), -- Claymore Blade
(20314, 2499, 1, 1, 1, 15.669267), -- Elven Long Sword
(20314, 2967, 1, 1, 1, 942.368583), -- Elven Long Sword Blade
(20314, 1864, 1, 1, 2, 124213.539318), -- Stem
(20314, 1869, 1, 1, 2, 62106.769659), -- Iron Ore
(20314, 1878, 1, 1, 2, 24842.605348), -- Braided Hemp
(20314, 1884, 1, 1, 2, 38219.609703), -- Cord
(20314, 2205, 1, 1, 2, 1965.480341), -- Recipe: Chain Gaiters
(20314, 2299, 1, 1, 2, 271.153762), -- Recipe: Big Hammer
(20314, 2209, 1, 1, 2, 4669.841869), -- Recipe: Eldarake
-- Darkwing Bat
(20316, 1803, 1, 1, -1, 169394), -- Recipe: Necklace of Wisdom
(20316, 1864, 1, 1, -1, 403157), -- Stem
(20316, 1792, 1, 1, -1, 14822), -- Recipe: Short Spear
(20316, 57, 109, 147, 0, 700000), -- Adena
(20316, 23, 1, 1, 1, 1297.277532), -- Wooden Breastplate
(20316, 30, 1, 1, 1, 2078.361234), -- Hard Leather Pants
(20316, 2386, 1, 1, 1, 2078.361234), -- Wooden Gaiters
(20316, 1865, 1, 1, 2, 29771.467966), -- Varnish
(20316, 1870, 1, 1, 2, 29771.467966), -- Coal
(20316, 1794, 1, 1, 2, 2189.097162), -- Recipe: Forest Bow
(20316, 734, 1, 1, 2, 4961.966906), -- Haste Potion
-- Black Wolf
(20317, 1867, 1, 1, -1, 51475), -- Animal Skin
(20317, 1786, 1, 1, -1, 30885), -- Recipe: Broad Sword
(20317, 57, 19, 29, 0, 700000), -- Adena
(20317, 1, 1, 1, 1, 13530), -- Short Sword
(20317, 1869, 1, 1, 2, 6652.105863), -- Iron Ore
(20317, 1870, 1, 1, 2, 6652.105863), -- Coal
(20317, 1871, 1, 1, 2, 6652.105863), -- Charcoal
(20317, 1872, 1, 1, 2, 8869.503162), -- Animal Bone
(20317, 1867, 1, 1, 2, 8869.503162), -- Animal Skin
(20317, 1787, 1, 1, 2, 5321.676087), -- Recipe: Willow Staff
-- Black Timber Wolf
(20318, 1866, 1, 1, -1, 51314), -- Suede
(20318, 1060, 1, 1, -1, 171046), -- Lesser Healing Potion
(20318, 2005, 1, 1, -1, 5498), -- Broadsword Blade
(20318, 57, 41, 58, 0, 700000), -- Adena
(20318, 3, 1, 1, 1, 473.740988), -- Broadsword
(20318, 2005, 1, 1, 1, 1624.259012), -- Broadsword Blade
(20318, 1866, 1, 1, 2, 15157.2), -- Suede
(20318, 1871, 1, 1, 2, 22735.8), -- Charcoal
-- Goblin Grave Robber
(20319, 1865, 1, 1, -1, 56617), -- Varnish
(20319, 1787, 1, 1, -1, 45293), -- Recipe: Willow Staff
(20319, 57, 30, 42, 0, 700000), -- Adena
(20319, 112, 1, 1, 1, 102689.2683), -- Apprentice's Earring
(20319, 118, 1, 1, 1, 76513.51329), -- Necklace of Magic
(20319, 116, 1, 1, 1, 156087.21841), -- Magic Ring
(20319, 1864, 1, 1, 2, 19511.058856), -- Stem
(20319, 1865, 1, 1, 2, 9755.529428), -- Varnish
(20319, 1866, 1, 1, 2, 6503.663956), -- Suede
(20319, 1873, 1, 1, 2, 3902.184976), -- Silver Nugget
(20319, 1868, 1, 1, 2, 19511.058856), -- Thread
(20319, 1787, 1, 1, 2, 7804.503928), -- Recipe: Willow Staff
-- Goblin Tomb Raider Leader
(20320, 1831, 1, 1, -1, 557587), -- Antidote
(20320, 2010, 1, 1, -1, 8136), -- Brandish Blade
(20320, 1867, 1, 1, -1, 278794), -- Animal Skin
(20320, 57, 112, 154, 0, 700000), -- Adena
(20320, 216, 1, 1, 1, 296.92293), -- Dirk
(20320, 2009, 1, 1, 1, 2190.07707), -- Dirk Blade
(20320, 1867, 1, 1, 2, 54901.037487), -- Animal Skin
(20320, 1872, 1, 1, 2, 54901.037487), -- Animal Bone
(20320, 1799, 1, 1, 2, 61000.925026), -- Recipe: Leather Gloves
-- Goblin Thief
(20321, 1870, 1, 1, -1, 178389), -- Coal
(20321, 2005, 1, 1, -1, 12742), -- Broadsword Blade
(20321, 1060, 1, 1, -1, 396420), -- Lesser Healing Potion
(20321, 57, 96, 130, 0, 700000), -- Adena
(20321, 152, 1, 1, 1, 849.98807), -- Heavy Chisel
(20321, 5, 1, 1, 1, 548.95007), -- Mace
(20321, 8, 1, 1, 1, 548.95007), -- Willow Staff
(20321, 2006, 1, 1, 1, 1882.11179), -- Willow Staff Head
(20321, 1864, 1, 1, 2, 30110.403165), -- Stem
(20321, 1865, 1, 1, 2, 15055.268715), -- Varnish
(20321, 1866, 1, 1, 2, 10036.84581), -- Suede
(20321, 1873, 1, 1, 2, 6022.05378), -- Silver Nugget
(20321, 1868, 1, 1, 2, 30110.403165), -- Thread
(20321, 1791, 1, 1, 2, 2782.910655), -- Recipe: Brandish
(20321, 1833, 1, 1, 2, 40147.11471), -- Bandage
-- Goblin Brigand
(20322, 1796, 1, 1, -1, 156757), -- Recipe: Leather Tunic
(20322, 1870, 1, 1, -1, 124622), -- Coal
(20322, 2005, 1, 1, -1, 8902), -- Broadsword Blade
(20322, 57, 67, 91, 0, 700000), -- Adena
(20322, 12, 1, 1, 1, 767), -- Knife
(20322, 215, 1, 1, 1, 767), -- Doom Dagger
(20322, 1872, 1, 1, 2, 24540.844224), -- Animal Bone
(20322, 1867, 1, 1, 2, 24540.844224), -- Animal Skin
(20322, 2137, 1, 1, 2, 5413.438758), -- Recipe: Steel
(20322, 17, 10, 30, 2, 92027.872794), -- Wooden Arrow
-- Goblin Brigand Leader
(20323, 1869, 1, 1, -1, 227339), -- Iron Ore
(20323, 1865, 1, 1, -1, 227339), -- Varnish
(20323, 1792, 1, 1, -1, 16716), -- Recipe: Short Spear
(20323, 57, 116, 172, 0, 700000), -- Adena
(20323, 216, 1, 1, 1, 322.83056), -- Dirk
(20323, 2009, 1, 1, 1, 2381.16944), -- Dirk Blade
(20323, 1871, 1, 1, 2, 33576.357012), -- Charcoal
(20323, 1866, 1, 1, 2, 22384.238008), -- Suede
(20323, 1792, 1, 1, 2, 2468.816538), -- Recipe: Short Spear
(20323, 6037, 1, 1, 2, 67152.588442), -- Waking Scroll
-- Goblin Brigand Lieutenant
(20324, 1791, 1, 1, -1, 33633), -- Recipe: Brandish
(20324, 1871, 1, 1, -1, 181957), -- Charcoal
(20324, 2006, 1, 1, -1, 12997), -- Willow Staff Head
(20324, 57, 98, 132, 0, 700000), -- Adena
(20324, 152, 1, 1, 1, 866.854674), -- Heavy Chisel
(20324, 5, 1, 1, 1, 559.843074), -- Mace
(20324, 8, 1, 1, 1, 559.843074), -- Willow Staff
(20324, 2006, 1, 1, 1, 1919.459178), -- Willow Staff Head
(20324, 1869, 1, 1, 2, 17915.77177), -- Iron Ore
(20324, 1870, 1, 1, 2, 17915.77177), -- Coal
(20324, 1871, 1, 1, 2, 17915.77177), -- Charcoal
(20324, 1872, 1, 1, 2, 23887.75207), -- Animal Bone
(20324, 1867, 1, 1, 2, 23887.75207), -- Animal Skin
(20324, 1795, 1, 1, 2, 67607.18055), -- Recipe: Leather Shoes
-- Goblin Raider
(20325, 1787, 1, 1, -1, 45293), -- Recipe: Willow Staff
(20325, 118, 1, 1, -1, 222026), -- Necklace of Magic
(20325, 1786, 1, 1, -1, 45293), -- Recipe: Broad Sword
(20325, 57, 30, 42, 0, 700000), -- Adena
(20325, 112, 1, 1, 1, 102689.2683), -- Apprentice's Earring
(20325, 118, 1, 1, 1, 76513.51329), -- Necklace of Magic
(20325, 116, 1, 1, 1, 156087.21841), -- Magic Ring
(20325, 1865, 1, 1, 2, 11706.54543), -- Varnish
(20325, 1870, 1, 1, 2, 11706.54543), -- Coal
(20325, 1788, 1, 1, 2, 9365.236344), -- Recipe: Bow
(20325, 6037, 1, 1, 2, 23413.09086), -- Waking Scroll
(20325, 1060, 1, 1, 2, 26014.581936), -- Lesser Healing Potion
-- Goblin Scout
(20326, 2135, 1, 1, -1, 36653), -- Recipe: Braided Hemp
(20326, 2006, 1, 1, -1, 8902), -- Willow Staff Head
(20326, 2007, 1, 1, -1, 8902), -- Bow Shaft
(20326, 57, 67, 91, 0, 700000), -- Adena
(20326, 22, 1, 1, 1, 3937.19964), -- Leather Shirt
(20326, 29, 1, 1, 1, 6292.80036), -- Leather Pants
(20326, 1864, 1, 1, 2, 24541.02735), -- Stem
(20326, 1865, 1, 1, 2, 12270.47465), -- Varnish
(20326, 1866, 1, 1, 2, 8180.34245), -- Suede
(20326, 1873, 1, 1, 2, 4908.17425), -- Silver Nugget
(20326, 1868, 1, 1, 2, 24541.02735), -- Thread
(20326, 2138, 1, 1, 2, 3608.95395), -- Recipe: Coarse Bone Powder (100%)
-- Goblin Snooper
(20327, 1870, 1, 1, -1, 56617), -- Coal
(20327, 1865, 1, 1, -1, 56617), -- Varnish
(20327, 1872, 1, 1, -1, 75489), -- Animal Bone
(20327, 57, 30, 42, 0, 700000), -- Adena
(20327, 112, 1, 1, 1, 102689.2683), -- Apprentice's Earring
(20327, 118, 1, 1, 1, 76513.51329), -- Necklace of Magic
(20327, 116, 1, 1, 1, 156087.21841), -- Magic Ring
(20327, 1867, 1, 1, 2, 26014.58937), -- Animal Skin
(20327, 1872, 1, 1, 2, 26014.58937), -- Animal Bone
(20327, 1786, 1, 1, 2, 15608.82126), -- Recipe: Broad Sword
-- Goblin Lookout
(20328, 1865, 1, 1, -1, 124622), -- Varnish
(20328, 2137, 1, 1, -1, 36653), -- Recipe: Steel
(20328, 1869, 1, 1, -1, 124622), -- Iron Ore
(20328, 57, 67, 91, 0, 700000), -- Adena
(20328, 12, 1, 1, 1, 767), -- Knife
(20328, 215, 1, 1, 1, 767), -- Doom Dagger
(20328, 1869, 1, 1, 2, 10517.505694), -- Iron Ore
(20328, 1870, 1, 1, 2, 10517.505694), -- Coal
(20328, 1871, 1, 1, 2, 10517.505694), -- Charcoal
(20328, 1872, 1, 1, 2, 14023.283274), -- Animal Bone
(20328, 1867, 1, 1, 2, 14023.283274), -- Animal Skin
(20328, 1666, 1, 1, 2, 3505.864057), -- Recipe: Wooden Arrow
(20328, 1060, 1, 1, 2, 23372.052313), -- Lesser Healing Potion
-- Ghost Guardian
(20329, 1869, 1, 1, -1, 287587), -- Iron Ore
(20329, 1880, 1, 1, -1, 28759), -- Steel
(20329, 1898, 1, 1, -1, 29542), -- Blue Diamond Necklace Gem
(20329, 57, 131, 234, 0, 700000), -- Adena
(20329, 16, 1, 1, 1, 181), -- Great Spear
(20329, 1869, 1, 1, 2, 24271.177086), -- Iron Ore
(20329, 1870, 1, 1, 2, 24271.177086), -- Coal
(20329, 1871, 1, 1, 2, 24271.177086), -- Charcoal
(20329, 1872, 1, 1, 2, 32361.569448), -- Animal Bone
(20329, 1867, 1, 1, 2, 32361.569448), -- Animal Skin
(20329, 2258, 1, 1, 2, 593.404866), -- Recipe: Temptation of Abyss
(20329, 5268, 1, 1, 2, 970.92498), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Mineshaft Bat
(20330, 1866, 1, 1, -1, 111988), -- Suede
(20330, 1896, 1, 1, -1, 71179), -- Necklace of Anguish Chain
(20330, 1792, 1, 1, -1, 12352), -- Recipe: Short Spear
(20330, 57, 91, 122, 0, 700000), -- Adena
(20330, 37, 1, 1, 1, 3243.102948), -- Leather Shoes
(20330, 1921, 1, 1, 1, 21341.766276), -- Leather Shoes Texture
(20330, 49, 1, 1, 1, 3243.130776), -- Gloves
(20330, 1864, 1, 1, 2, 66158.800747), -- Stem
(20330, 1869, 1, 1, 2, 33079.466208), -- Iron Ore
(20330, 1798, 1, 1, 2, 32430.733045), -- Recipe: Leather Helmet
-- Monster Eye Tracker
(20331, 1871, 1, 1, -1, 148657), -- Charcoal
(20331, 2007, 1, 1, -1, 10618), -- Bow Shaft
(20331, 2005, 1, 1, -1, 10618), -- Broadsword Blade
(20331, 57, 80, 108, 0, 700000), -- Adena
(20331, 113, 1, 1, 1, 9443.170561), -- Mystic's Earring
(20331, 906, 1, 1, 1, 7053.926935), -- Necklace of Knowledge
(20331, 875, 1, 1, 1, 13939.902504), -- Ring of Knowledge
(20331, 1865, 1, 1, 2, 21955.431057), -- Varnish
(20331, 1870, 1, 1, 2, 21955.431057), -- Coal
(20331, 1796, 1, 1, 2, 27616.861783), -- Recipe: Leather Tunic
(20331, 734, 1, 1, 2, 3659.276103), -- Haste Potion
-- Greystone Golem
(20333, 1792, 1, 1, -1, 17783), -- Recipe: Short Spear
(20333, 2008, 1, 1, -1, 9411), -- Cedar Staff Head
(20333, 1798, 1, 1, -1, 237113), -- Recipe: Leather Helmet
(20333, 57, 127, 180, 0, 700000), -- Adena
(20333, 2371, 1, 1, 1, 732.595676), -- Fist of Butcher
(20333, 255, 1, 1, 1, 343.404324), -- Fox Claw Gloves
(20333, 1868, 1, 1, 2, 71439.890148), -- Thread
(20333, 1873, 1, 1, 2, 14287.95369), -- Silver Nugget
(20333, 1803, 1, 1, 2, 30016.8117), -- Recipe: Necklace of Wisdom
(20333, 734, 1, 1, 2, 5953.344462), -- Haste Potion
-- Grizzly Bear
(20335, 1867, 1, 1, -1, 324856), -- Animal Skin
(20335, 734, 1, 1, -1, 40607), -- Haste Potion
(20335, 1897, 1, 1, -1, 58010), -- Necklace of Wisdom Chain
(20335, 57, 119, 191, 0, 700000), -- Adena
(20335, 2, 1, 1, 1, 68.520295), -- Long Sword
(20335, 120, 1, 1, 1, 68.520295), -- Sword of Reflection
(20335, 2012, 1, 1, 1, 749.439115), -- Sword of Reflection Blade
(20335, 121, 1, 1, 1, 68.520295), -- Sword of Watershadow
(20335, 1867, 1, 1, 2, 47978.755186), -- Animal Skin
(20335, 1872, 1, 1, 2, 47978.755186), -- Animal Bone
(20335, 2174, 1, 1, 2, 15645.238884), -- Recipe: Hard Leather Gaiters
(20335, 5158, 1, 1, 2, 1439.250744), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Green Dryad
(20336, 1802, 1, 1, -1, 268004), -- Recipe: Necklace of Anguish
(20336, 29, 1, 1, -1, 21303), -- Leather Pants
(20336, 1060, 1, 1, -1, 276937), -- Lesser Healing Potion
(20336, 57, 67, 91, 0, 700000), -- Adena
(20336, 428, 1, 1, 1, 1968.59982), -- Feriotic Tunic
(20336, 1100, 1, 1, 1, 1968.59982), -- Cotton Tunic
(20336, 463, 1, 1, 1, 3146.40018), -- Feriotic Stockings
(20336, 1103, 1, 1, 1, 3146.40018), -- Cotton Stockings
(20336, 1864, 1, 1, 2, 24540.973407), -- Stem
(20336, 1865, 1, 1, 2, 12270.448349), -- Varnish
(20336, 1866, 1, 1, 2, 8180.324469), -- Suede
(20336, 1873, 1, 1, 2, 4908.225365), -- Silver Nugget
(20336, 1868, 1, 1, 2, 24540.973407), -- Thread
(20336, 1789, 1, 1, 2, 2268.055003), -- Recipe: Cedar Staff
-- Nightmare Weaver
(20338, 3032, 1, 1, -1, 12654), -- Recipe: Spiritshot D
(20338, 1927, 1, 1, -1, 25237), -- Hard Leather Shirt Pattern
(20338, 1898, 1, 1, -1, 32496), -- Blue Diamond Necklace Gem
(20338, 57, 144, 257, 0, 700000), -- Adena
(20338, 16, 1, 1, 1, 199), -- Great Spear
(20338, 1868, 1, 1, 2, 93443.755485), -- Thread
(20338, 1873, 1, 1, 2, 18688.751097), -- Silver Nugget
(20338, 3032, 1, 1, 2, 1868.898969), -- Recipe: Spiritshot D
(20338, 1831, 1, 1, 2, 124591.594449), -- Antidote
-- Slave Skeleton
(20340, 1792, 1, 1, -1, 13068), -- Recipe: Short Spear
(20340, 57, 95, 131, 0, 700000), -- Adena
(20340, 2371, 1, 1, 1, 538.553141), -- Fist of Butcher
(20340, 255, 1, 1, 1, 252.446859), -- Fox Claw Gloves
(20340, 1870, 1, 1, 2, 34999.37811), -- Coal
(20340, 1865, 1, 1, 2, 34999.37811), -- Varnish
(20340, 1803, 1, 1, 2, 29411.24378), -- Recipe: Necklace of Wisdom
-- Undead Slave
(20341, 2141, 1, 1, -1, 48936), -- Recipe: Silver Mold
(20341, 2143, 1, 1, -1, 48936), -- Recipe: Synthetic Cokes
(20341, 1897, 1, 1, -1, 58257), -- Necklace of Wisdom Chain
(20341, 57, 115, 195, 0, 700000), -- Adena
(20341, 945, 1, 1, 1, 2737.6128), -- Skeleton Buckler
(20341, 102, 1, 1, 1, 1321.26592), -- Round Shield
(20341, 44, 1, 1, 1, 924.20224), -- Leather Helmet
(20341, 1924, 1, 1, 1, 11656.91904), -- Leather Helmet Design
(20341, 1866, 1, 1, 2, 32122.168108), -- Suede
(20341, 1871, 1, 1, 2, 48183.371641), -- Charcoal
(20341, 2175, 1, 1, 2, 39173.460251), -- Recipe: Boots
-- Werewolf Chieftain
(20342, 1870, 1, 1, -1, 213277), -- Coal
(20342, 429, 1, 1, -1, 6970), -- Leather Tunic
(20342, 1793, 1, 1, -1, 15682), -- Recipe: Sword of Reflection
(20342, 57, 114, 157, 0, 700000), -- Adena
(20342, 2371, 1, 1, 1, 646.127599), -- Fist of Butcher
(20342, 255, 1, 1, 1, 302.872401), -- Fox Claw Gloves
(20342, 1869, 1, 1, 2, 41999.100858), -- Iron Ore
(20342, 1864, 1, 1, 2, 83998.348713), -- Stem
(20342, 736, 1, 1, 2, 20999.550429), -- Scroll of Escape
-- Werewolf Hunter
(20343, 1060, 1, 1, -1, 404348), -- Lesser Healing Potion
(20343, 1795, 1, 1, -1, 686629), -- Recipe: Leather Shoes
(20343, 2005, 1, 1, -1, 12997), -- Broadsword Blade
(20343, 57, 98, 132, 0, 700000), -- Adena
(20343, 113, 1, 1, 1, 11558.475515), -- Mystic's Earring
(20343, 906, 1, 1, 1, 8634.032525), -- Necklace of Knowledge
(20343, 875, 1, 1, 1, 17062.49196), -- Ring of Knowledge
(20343, 1869, 1, 1, 2, 35831.395795), -- Iron Ore
(20343, 1864, 1, 1, 2, 71662.79159), -- Stem
(20343, 1797, 1, 1, 2, 72386.812615), -- Recipe: Leather Stockings
-- Dark Terror
(20345, 2174, 1, 1, -1, 96576), -- Recipe: Hard Leather Gaiters
(20345, 1925, 1, 1, -1, 145655), -- Leather Gloves Lining
(20345, 5220, 1, 1, -1, 8885), -- Metal Hardener
(20345, 57, 110, 171, 0, 700000), -- Adena
(20345, 24, 1, 1, 1, 420.5292), -- Bone Breastplate
(20345, 390, 1, 1, 1, 420.5292), -- Cotton Shirt
(20345, 31, 1, 1, 1, 671.4708), -- Bone Gaiters
(20345, 412, 1, 1, 1, 671.4708), -- Cotton Pants
(20345, 1866, 1, 1, 2, 17496.46539), -- Suede
(20345, 1871, 1, 1, 2, 26244.7596), -- Charcoal
(20345, 1800, 1, 1, 2, 8253.09846), -- Recipe: Piece Bone Breastplate
(20345, 5268, 1, 1, 2, 1049.81499), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20345, 1831, 1, 1, 2, 69985.86156), -- Antidote
-- Darkstone Golem
(20346, 1869, 1, 1, -1, 201546), -- Iron Ore
(20346, 1803, 1, 1, -1, 169366), -- Recipe: Necklace of Wisdom
(20346, 1831, 1, 1, -1, 537455), -- Antidote
(20346, 57, 106, 150, 0, 700000), -- Adena
(20346, 20, 1, 1, 1, 5563.90821), -- Buckler
(20346, 43, 1, 1, 1, 3891.09179), -- Wooden Helmet
(20346, 1866, 1, 1, 2, 26459.358156), -- Suede
(20346, 1871, 1, 1, 2, 39689.037234), -- Charcoal
(20346, 736, 1, 1, 2, 19844.60461), -- Scroll of Escape
-- Cave Spider
(20348, 1794, 1, 1, -1, 14192), -- Recipe: Forest Bow
(20348, 1831, 1, 1, -1, 514696), -- Antidote
(20348, 1896, 1, 1, -1, 81784), -- Necklace of Anguish Chain
(20348, 57, 97, 147, 0, 700000), -- Adena
(20348, 66, 1, 1, 1, 182.6943), -- Gladius
(20348, 1333, 1, 1, 1, 182.6943), -- Brandish
(20348, 2010, 1, 1, 1, 1478.6114), -- Brandish Blade
(20348, 1871, 1, 1, 2, 38008.369432), -- Charcoal
(20348, 1866, 1, 1, 2, 25338.95284), -- Suede
(20348, 1799, 1, 1, 2, 56308.677728), -- Recipe: Leather Gloves
-- Cave Bat
(20349, 2009, 1, 1, -1, 6357), -- Dirk Blade
(20349, 1794, 1, 1, -1, 13182), -- Recipe: Forest Bow
(20349, 1921, 1, 1, -1, 115664), -- Leather Shoes Texture
(20349, 57, 94, 133, 0, 700000), -- Adena
(20349, 23, 1, 1, 1, 1153.849158), -- Wooden Breastplate
(20349, 30, 1, 1, 1, 1848.575421), -- Hard Leather Pants
(20349, 2386, 1, 1, 1, 1848.575421), -- Wooden Gaiters
(20349, 1872, 1, 1, 2, 47072.526003), -- Animal Bone
(20349, 1867, 1, 1, 2, 47072.526003), -- Animal Skin
(20349, 1792, 1, 1, 2, 2595.947994), -- Recipe: Short Spear
-- Cave Fang Spider
(20350, 1866, 1, 1, -1, 134620), -- Suede
(20350, 2150, 1, 1, -1, 94803), -- Recipe: Blue Diamond Necklace
(20350, 1800, 1, 1, -1, 63500), -- Recipe: Piece Bone Breastplate
(20350, 57, 100, 156, 0, 700000), -- Adena
(20350, 845, 1, 1, 1, 872.03469), -- Cat's Eye Earring
(20350, 908, 1, 1, 1, 654.030985), -- Necklace of Wisdom
(20350, 1897, 1, 1, 1, 7100.88229), -- Necklace of Wisdom Chain
(20350, 877, 1, 1, 1, 1308.052035), -- Ring of Wisdom
(20350, 1873, 1, 1, 2, 11929.468554), -- Silver Nugget
(20350, 1868, 1, 1, 2, 59647.252221), -- Thread
(20350, 2150, 1, 1, 2, 14001.682419), -- Recipe: Blue Diamond Necklace
(20350, 734, 1, 1, 2, 4970.596806), -- Haste Potion
-- Dre Vanul Tracker
(20351, 2173, 1, 1, -1, 62245), -- Recipe: Hard Leather Shirt
(20351, 735, 1, 1, -1, 19140), -- Alacrity Potion
(20351, 1897, 1, 1, -1, 54686), -- Necklace of Wisdom Chain
(20351, 57, 106, 184, 0, 700000), -- Adena
(20351, 272, 1, 1, 1, 129.1923), -- Forest Bow
(20351, 2013, 1, 1, 1, 1463.8077), -- Forest Bow Shaft
(20351, 1864, 1, 1, 2, 67845.117483), -- Stem
(20351, 1869, 1, 1, 2, 33922.617105), -- Iron Ore
(20351, 1878, 1, 1, 2, 13569.046842), -- Braided Hemp
(20351, 2253, 1, 1, 2, 1390.21857), -- Recipe: Sword Breaker
-- Dre Vanul Slayer
(20352, 1878, 1, 1, -1, 135435), -- Braided Hemp
(20352, 26, 1, 1, -1, 1791), -- Bronze Breastplate
(20352, 57, 154, 276, 0, 700000), -- Adena
(20352, 68, 1, 1, 1, 106.5), -- Falchion
(20352, 5284, 1, 1, 1, 106.5), -- Zweihander
(20352, 1864, 1, 1, 2, 80010.969147), -- Stem
(20352, 1869, 1, 1, 2, 40005.414964), -- Iron Ore
(20352, 1878, 1, 1, 2, 16002.249517), -- Braided Hemp
(20352, 5163, 1, 1, 2, 1600.183186), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20352, 5273, 1, 1, 2, 1600.183186), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Dre Vanul Beholder
(20353, 1878, 1, 1, -1, 116185), -- Braided Hemp
(20353, 2256, 1, 1, -1, 7102), -- Recipe: Assassin Knife
(20353, 1864, 1, 1, -1, 580926), -- Stem
(20353, 57, 132, 236, 0, 700000), -- Adena
(20353, 16, 1, 1, 1, 183), -- Great Spear
(20353, 1864, 1, 1, 2, 68638.548303), -- Stem
(20353, 1869, 1, 1, 2, 34319.214436), -- Iron Ore
(20353, 1878, 1, 1, 2, 13727.757433), -- Braided Hemp
(20353, 3953, 1, 1, 2, 1372.739914), -- Recipe: Blessed Spiritshot D
(20353, 5273, 1, 1, 2, 1372.739914), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Langk Lizardman Leader
(20356, 1899, 1, 1, -1, 66888), -- Necklace of Devotion Chain
(20356, 1868, 1, 1, -1, 856162), -- Thread
(20356, 1873, 1, 1, -1, 171232), -- Silver Nugget
(20356, 57, 188, 353, 0, 700000), -- Adena
(20356, 220, 1, 1, 1, 153), -- Crafted Dagger
(20356, 1868, 1, 1, 2, 120126.36384), -- Thread
(20356, 1873, 1, 1, 2, 24025.272768), -- Silver Nugget
(20356, 5549, 1, 1, 2, 6006.318192), -- Metallic Thread
(20356, 2178, 1, 1, 2, 9610.0452), -- Recipe: Dark Stockings
-- Langk Lizardman Lieutenant
(20357, 1898, 1, 1, -1, 37198), -- Blue Diamond Necklace Gem
(20357, 1804, 1, 1, -1, 14485), -- Recipe: Soulshot (D-Grade)
(20357, 1926, 1, 1, -1, 36578), -- Piece Bone Breastplate Fragment
(20357, 57, 164, 295, 0, 700000), -- Adena
(20357, 68, 1, 1, 1, 114), -- Falchion
(20357, 5284, 1, 1, 1, 114), -- Zweihander
(20357, 1869, 1, 1, 2, 53483.185212), -- Iron Ore
(20357, 1864, 1, 1, 2, 106966.370424), -- Stem
(20357, 1880, 1, 1, 2, 5348.33766), -- Steel
(20357, 2176, 1, 1, 2, 25590.106704), -- Recipe: Leather Boots
-- Ratman Hunter
(20358, 2140, 1, 1, -1, 50651), -- Recipe: High-Grade Suede
(20358, 1924, 1, 1, -1, 81695), -- Leather Helmet Design
(20358, 2141, 1, 1, -1, 50651), -- Recipe: Silver Mold
(20358, 57, 121, 200, 0, 700000), -- Adena
(20358, 217, 1, 1, 1, 142.5), -- Shining Knife
(20358, 218, 1, 1, 1, 142.5), -- Throwing Knife
(20358, 1871, 1, 1, 2, 49871.999886), -- Charcoal
(20358, 1866, 1, 1, 2, 33247.999924), -- Suede
(20358, 1800, 1, 1, 2, 15683.00019), -- Recipe: Piece Bone Breastplate
-- Ratman Warrior
(20359, 1872, 1, 1, -1, 348237), -- Animal Bone
(20359, 44, 1, 1, -1, 6680), -- Leather Helmet
(20359, 1924, 1, 1, -1, 84251), -- Leather Helmet Design
(20359, 57, 122, 208, 0, 700000), -- Adena
(20359, 176, 1, 1, 1, 147), -- Apprentice's Staff
(20359, 2501, 1, 1, 1, 147), -- Bone Club
(20359, 1870, 1, 1, 2, 38574.067424), -- Coal
(20359, 1865, 1, 1, 2, 38574.067424), -- Varnish
(20359, 2252, 1, 1, 2, 1580.876768), -- Recipe: Iron Hammer
(20359, 5268, 1, 1, 2, 1542.988384), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Ratman Spy
(20360, 2175, 1, 1, -1, 193143), -- Recipe: Boots
(20360, 908, 1, 1, -1, 5210), -- Necklace of Wisdom
(20360, 1801, 1, 1, -1, 119680), -- Recipe: Piece Bone Gaiters
(20360, 57, 118, 183, 0, 700000), -- Adena
(20360, 945, 1, 1, 1, 2658.14964), -- Skeleton Buckler
(20360, 102, 1, 1, 1, 1282.914271), -- Round Shield
(20360, 44, 1, 1, 1, 897.375937), -- Leather Helmet
(20360, 1924, 1, 1, 1, 11318.560152), -- Leather Helmet Design
(20360, 1872, 1, 1, 2, 46781.949852), -- Animal Bone
(20360, 1867, 1, 1, 2, 46781.949852), -- Animal Skin
(20360, 2173, 1, 1, 2, 9508.569712), -- Recipe: Hard Leather Shirt
(20360, 5273, 1, 1, 2, 1403.530584), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Tunath Orc Marksman
(20361, 1790, 1, 1, -1, 28303), -- Recipe: Dirk
(20361, 42, 1, 1, -1, 43748), -- Leather Cap
(20361, 2005, 1, 1, -1, 10937), -- Broadsword Blade
(20361, 57, 82, 111, 0, 700000), -- Adena
(20361, 14, 1, 1, 1, 942.288438), -- Bow
(20361, 2007, 1, 1, 1, 3230.711562), -- Bow Shaft
(20361, 1864, 1, 1, 2, 45228.43336), -- Stem
(20361, 1869, 1, 1, 2, 22614.21668), -- Iron Ore
(20361, 1802, 1, 1, 2, 48632.82204), -- Recipe: Necklace of Anguish
(20361, 735, 1, 1, 2, 1884.52792), -- Alacrity Potion
-- Tunath Orc Warrior
(20362, 1799, 1, 1, -1, 263305), -- Recipe: Leather Gloves
(20362, 1867, 1, 1, -1, 236975), -- Animal Skin
(20362, 1792, 1, 1, -1, 13068), -- Recipe: Short Spear
(20362, 57, 95, 131, 0, 700000), -- Adena
(20362, 37, 1, 1, 1, 3431.316663), -- Leather Shoes
(20362, 1921, 1, 1, 1, 22580.337231), -- Leather Shoes Texture
(20362, 49, 1, 1, 1, 3431.346106), -- Gloves
(20362, 1869, 1, 1, 2, 26249.586141), -- Iron Ore
(20362, 1864, 1, 1, 2, 52499.033271), -- Stem
(20362, 1792, 1, 1, 2, 1930.167735), -- Recipe: Short Spear
(20362, 1060, 1, 1, 2, 58332.212853), -- Lesser Healing Potion
-- Maraku Werewolf
(20363, 1867, 1, 1, -1, 198456), -- Animal Skin
(20363, 2005, 1, 1, -1, 10632), -- Broadsword Blade
(20363, 2006, 1, 1, -1, 10632), -- Willow Staff Head
(20363, 57, 80, 108, 0, 700000), -- Adena
(20363, 254, 1, 1, 1, 1832), -- Iron Gloves
(20363, 1869, 1, 1, 2, 21982.72725), -- Iron Ore
(20363, 1864, 1, 1, 2, 43965.4545), -- Stem
(20363, 1814, 1, 1, 2, 11569.8648), -- Recipe: Leather
(20363, 735, 1, 1, 2, 1831.95345), -- Alacrity Potion
-- Maraku Werewolf Chieftain
(20364, 1867, 1, 1, -1, 303119), -- Animal Skin
(20364, 2008, 1, 1, -1, 8846), -- Cedar Staff Head
(20364, 1896, 1, 1, -1, 96330), -- Necklace of Anguish Chain
(20364, 57, 116, 172, 0, 700000), -- Adena
(20364, 2371, 1, 1, 1, 689.021212), -- Fist of Butcher
(20364, 255, 1, 1, 1, 322.978788), -- Fox Claw Gloves
(20364, 1870, 1, 1, 2, 44768.15956), -- Coal
(20364, 1865, 1, 1, 2, 44768.15956), -- Varnish
(20364, 1793, 1, 1, 2, 3291.68088), -- Recipe: Sword of Reflection
-- Mountain Fungus
(20365, 1866, 1, 1, -1, 83081), -- Suede
(20365, 1864, 1, 1, -1, 249244), -- Stem
(20365, 1871, 1, 1, -1, 124622), -- Charcoal
(20365, 57, 67, 91, 0, 700000), -- Adena
(20365, 22, 1, 1, 1, 3937.19964), -- Leather Shirt
(20365, 29, 1, 1, 1, 6292.80036), -- Leather Pants
(20365, 1871, 1, 1, 2, 24541), -- Charcoal
(20365, 1866, 1, 1, 2, 16360.650306), -- Suede
(20365, 1666, 1, 1, 2, 8180.349694), -- Recipe: Wooden Arrow
-- Merkenis' Escort
(20367, 1864, 1, 1, -1, 459366), -- Stem
(20367, 1831, 1, 1, -1, 612488), -- Antidote
(20367, 1896, 1, 1, -1, 97323), -- Necklace of Anguish Chain
(20367, 57, 106, 184, 0, 700000), -- Adena
(20367, 945, 1, 1, 1, 2569.8024), -- Skeleton Buckler
(20367, 102, 1, 1, 1, 1240.27486), -- Round Shield
(20367, 44, 1, 1, 1, 867.55042), -- Leather Helmet
(20367, 1924, 1, 1, 1, 10942.37232), -- Leather Helmet Design
(20367, 1864, 1, 1, 2, 54275.848704), -- Stem
(20367, 1869, 1, 1, 2, 27137.924352), -- Iron Ore
(20367, 1878, 1, 1, 2, 10855.188864), -- Braided Hemp
(20367, 5153, 1, 1, 2, 1085.528448), -- Recipe: Soulshot (D) Compressed Package (100%)
(20367, 735, 1, 1, 2, 2261.509632), -- Alacrity Potion
-- Grave Keeper
(20368, 1873, 1, 1, -1, 80618), -- Silver Nugget
(20368, 1833, 1, 1, -1, 537455), -- Bandage
(20368, 1793, 1, 1, -1, 14820), -- Recipe: Sword of Reflection
(20368, 57, 106, 150, 0, 700000), -- Adena
(20368, 271, 1, 1, 1, 572), -- Hunting Bow
(20368, 1866, 1, 1, 2, 26459.498633), -- Suede
(20368, 1871, 1, 1, 2, 39689.213416), -- Charcoal
(20368, 1793, 1, 1, 2, 2918.287951), -- Recipe: Sword of Reflection
-- Moonstone Beast
(20369, 2143, 1, 1, -1, 48728), -- Recipe: Synthetic Cokes
(20369, 390, 1, 1, -1, 3124), -- Cotton Shirt
(20369, 1897, 1, 1, -1, 58010), -- Necklace of Wisdom Chain
(20369, 57, 119, 191, 0, 700000), -- Adena
(20369, 1101, 1, 1, 1, 922.701996), -- Tunic of Devotion
(20369, 1104, 1, 1, 1, 1473.298004), -- Stockings of Devotion
(20369, 1868, 1, 1, 2, 95957.48532), -- Thread
(20369, 1873, 1, 1, 2, 19191.497064), -- Silver Nugget
(20369, 2175, 1, 1, 2, 39007.017616), -- Recipe: Boots
-- Barbed Bat
(20370, 1864, 1, 1, -1, 418191), -- Stem
(20370, 1922, 1, 1, -1, 53341), -- Leather Tunic Pattern
(20370, 1794, 1, 1, -1, 15375), -- Recipe: Forest Bow
(20370, 57, 112, 154, 0, 700000), -- Adena
(20370, 23, 1, 1, 1, 1345.562706), -- Wooden Breastplate
(20370, 30, 1, 1, 1, 2155.718647), -- Hard Leather Pants
(20370, 2386, 1, 1, 1, 2155.718647), -- Wooden Gaiters
(20370, 1864, 1, 1, 2, 82351.61649), -- Stem
(20370, 1869, 1, 1, 2, 41175.808245), -- Iron Ore
(20370, 1793, 1, 1, 2, 3027.575265), -- Recipe: Sword of Reflection
-- Mist Terror
(20371, 1869, 1, 1, -1, 196871), -- Iron Ore
(20371, 114, 1, 1, -1, 14583), -- Earring of Strength
(20371, 1896, 1, 1, -1, 83420), -- Necklace of Anguish Chain
(20371, 57, 99, 150, 0, 700000), -- Adena
(20371, 429, 1, 1, 1, 950.19645), -- Leather Tunic
(20371, 1922, 1, 1, 1, 7417.267288), -- Leather Tunic Pattern
(20371, 464, 1, 1, 1, 1522.27686), -- Leather Stockings
(20371, 1923, 1, 1, 1, 11916.259402), -- Leather Stockings Pattern
(20371, 1866, 1, 1, 2, 25845.756946), -- Suede
(20371, 1871, 1, 1, 2, 38768.635419), -- Charcoal
(20371, 1803, 1, 1, 2, 32578.607635), -- Recipe: Necklace of Wisdom
-- Baraq Orc Fighter
(20372, 1870, 1, 1, -1, 151631), -- Coal
(20372, 1864, 1, 1, -1, 303261), -- Stem
(20372, 57, 81, 110, 0, 700000), -- Adena
(20372, 3, 1, 1, 1, 933.030392), -- Broadsword
(20372, 2005, 1, 1, 1, 3198.969608), -- Broadsword Blade
(20372, 1869, 1, 1, 2, 29859.483108), -- Iron Ore
(20372, 1864, 1, 1, 2, 59718.966216), -- Stem
(20372, 1814, 1, 1, 2, 15715.550676), -- Recipe: Leather
-- Baraq Orc Warrior Leader
(20373, 1793, 1, 1, -1, 12352), -- Recipe: Sword of Reflection
(20373, 1871, 1, 1, -1, 167982), -- Charcoal
(20373, 1869, 1, 1, -1, 167982), -- Iron Ore
(20373, 57, 91, 122, 0, 700000), -- Adena
(20373, 2371, 1, 1, 1, 508.595697), -- Fist of Butcher
(20373, 255, 1, 1, 1, 238.404303), -- Fox Claw Gloves
(20373, 1869, 1, 1, 2, 33079.61244), -- Iron Ore
(20373, 1864, 1, 1, 2, 66159.373126), -- Stem
(20373, 1799, 1, 1, 2, 49007.014434), -- Recipe: Leather Gloves
-- Varangka's Guard
(20374, 2255, 1, 1, -1, 9821), -- Recipe: Saber
(20374, 1871, 1, 1, -1, 401688), -- Charcoal
(20374, 1898, 1, 1, -1, 41262), -- Blue Diamond Necklace Gem
(20374, 57, 182, 327, 0, 700000), -- Adena
(20374, 257, 1, 1, 1, 252), -- Viper Fang
(20374, 1873, 1, 1, 2, 23730.43641), -- Silver Nugget
(20374, 1868, 1, 1, 2, 118652.476308), -- Thread
(20374, 5273, 1, 1, 2, 2373.043641), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20374, 5158, 1, 1, 2, 2373.043641), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Varangka's Escort
(20375, 2257, 1, 1, -1, 7102), -- Recipe: Trident
(20375, 2014, 1, 1, -1, 3339), -- Iron Hammer Head
(20375, 1804, 1, 1, -1, 11619), -- Recipe: Soulshot (D-Grade)
(20375, 57, 132, 236, 0, 700000), -- Adena
(20375, 16, 1, 1, 1, 183), -- Great Spear
(20375, 1865, 1, 1, 2, 34319.298816), -- Varnish
(20375, 1870, 1, 1, 2, 34319.298816), -- Coal
(20375, 1879, 1, 1, 2, 5719.883136), -- Cokes
(20375, 5158, 1, 1, 2, 1372.759616), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Stone Giant
(20378, 1831, 1, 1, -1, 537455), -- Antidote
(20378, 49, 1, 1, -1, 19759), -- Gloves
(20378, 1896, 1, 1, -1, 85401), -- Necklace of Anguish Chain
(20378, 57, 106, 150, 0, 700000), -- Adena
(20378, 114, 1, 1, 1, 1763.923339), -- Earring of Strength
(20378, 115, 1, 1, 1, 1763.923339), -- Earring of Wisdom
(20378, 907, 1, 1, 1, 1322.946901), -- Necklace of Anguish
(20378, 1896, 1, 1, 1, 10090.295032), -- Necklace of Anguish Chain
(20378, 876, 1, 1, 1, 2645.911389), -- Ring of Anguish
(20378, 1866, 1, 1, 2, 26459.358156), -- Suede
(20378, 1871, 1, 1, 2, 39689.037234), -- Charcoal
(20378, 736, 1, 1, 2, 19844.60461), -- Scroll of Escape
-- Stone Soldier
(20379, 1792, 1, 1, -1, 18424), -- Recipe: Short Spear
(20379, 1871, 1, 1, -1, 250564), -- Charcoal
(20379, 1872, 1, 1, -1, 334085), -- Animal Bone
(20379, 57, 128, 189, 0, 700000), -- Adena
(20379, 114, 1, 1, 1, 2192.993905), -- Earring of Strength
(20379, 115, 1, 1, 1, 2192.993905), -- Earring of Wisdom
(20379, 907, 1, 1, 1, 1644.750895), -- Necklace of Anguish
(20379, 1896, 1, 1, 1, 12544.73764), -- Necklace of Anguish Chain
(20379, 876, 1, 1, 1, 3289.523655), -- Ring of Anguish
(20379, 1872, 1, 1, 2, 65788.941098), -- Animal Bone
(20379, 1867, 1, 1, 2, 65788.941098), -- Animal Skin
(20379, 1794, 1, 1, 2, 3628.117804), -- Recipe: Forest Bow
-- Stone Guardian
(20380, 1869, 1, 1, -1, 267071), -- Iron Ore
(20380, 1873, 1, 1, -1, 106828), -- Silver Nugget
(20380, 1866, 1, 1, -1, 178047), -- Suede
(20380, 57, 132, 206, 0, 700000), -- Adena
(20380, 176, 1, 1, 1, 150.5), -- Apprentice's Staff
(20380, 2501, 1, 1, 1, 150.5), -- Bone Club
(20380, 1871, 1, 1, 2, 52592.26824), -- Charcoal
(20380, 1866, 1, 1, 2, 35061.47532), -- Suede
(20380, 2174, 1, 1, 2, 22866.25644), -- Recipe: Hard Leather Gaiters
-- Vaiss Orc
(20381, 1867, 1, 1, -1, 198210), -- Animal Skin
(20381, 2006, 1, 1, -1, 10618), -- Willow Staff Head
(20381, 1875, 1, 1, -1, 9910), -- Stone of Purity
(20381, 57, 80, 108, 0, 700000), -- Adena
(20381, 99, 1, 1, 1, 1830), -- Apprentice's Spellbook
(20381, 1865, 1, 1, 2, 29273.970726), -- Varnish
(20381, 1870, 1, 1, 2, 29273.970726), -- Coal
(20381, 2136, 1, 1, 2, 8610.058548), -- Recipe: Cokes
-- Vaiss Orc Warrior Leader
(20382, 1870, 1, 1, -1, 167982), -- Coal
(20382, 2008, 1, 1, -1, 6536), -- Cedar Staff Head
(20382, 1831, 1, 1, -1, 447952), -- Antidote
(20382, 57, 91, 122, 0, 700000), -- Adena
(20382, 20, 1, 1, 1, 4637.08056), -- Buckler
(20382, 43, 1, 1, 1, 3242.91944), -- Wooden Helmet
(20382, 1866, 1, 1, 2, 22052.91146), -- Suede
(20382, 1871, 1, 1, 2, 33079.36719), -- Charcoal
(20382, 1803, 1, 1, 2, 27797.72135), -- Recipe: Necklace of Wisdom
-- Balor Orc Archer
(20385, 1060, 1, 1, -1, 285245), -- Lesser Healing Potion
(20385, 2005, 1, 1, -1, 9169), -- Broadsword Blade
(20385, 57, 69, 94, 0, 700000), -- Adena
(20385, 14, 1, 1, 1, 789.869388), -- Bow
(20385, 2007, 1, 1, 1, 2708.130612), -- Bow Shaft
(20385, 1873, 1, 1, 2, 10110.924824), -- Silver Nugget
(20385, 1868, 1, 1, 2, 50554.689458), -- Thread
(20385, 1790, 1, 1, 2, 4672.385718), -- Recipe: Dirk
-- Balor Orc Fighter
(20386, 1060, 1, 1, -1, 404348), -- Lesser Healing Potion
(20386, 1796, 1, 1, -1, 228876), -- Recipe: Leather Tunic
(20386, 1666, 1, 1, -1, 60652), -- Recipe: Wooden Arrow
(20386, 57, 98, 132, 0, 700000), -- Adena
(20386, 3, 1, 1, 1, 1119.771954), -- Broadsword
(20386, 2005, 1, 1, 1, 3839.228046), -- Broadsword Blade
(20386, 1869, 1, 1, 2, 26873.64), -- Iron Ore
(20386, 1864, 1, 1, 2, 53747.28), -- Stem
(20386, 1666, 1, 1, 2, 8957.88), -- Recipe: Wooden Arrow
(20386, 17, 10, 30, 2, 134368.2), -- Wooden Arrow
-- Balor Orc Fighter Leader
(20387, 1833, 1, 1, -1, 568739), -- Bandage
(20387, 1794, 1, 1, -1, 15682), -- Recipe: Forest Bow
(20387, 1896, 1, 1, -1, 90372), -- Necklace of Anguish Chain
(20387, 57, 114, 157, 0, 700000), -- Adena
(20387, 66, 1, 1, 1, 201.91485), -- Gladius
(20387, 1333, 1, 1, 1, 201.91485), -- Brandish
(20387, 2010, 1, 1, 1, 1634.1703), -- Brandish Blade
(20387, 1869, 1, 1, 2, 41999.291874), -- Iron Ore
(20387, 1864, 1, 1, 2, 83998.583748), -- Stem
(20387, 1794, 1, 1, 2, 3088.124378), -- Recipe: Forest Bow
-- Balor Orc Lieutenant
(20388, 1833, 1, 1, -1, 537542), -- Bandage
(20388, 1880, 1, 1, -1, 20158), -- Steel
(20388, 57, 109, 147, 0, 700000), -- Adena
(20388, 37, 1, 1, 1, 3891.653613), -- Leather Shoes
(20388, 1921, 1, 1, 1, 25609.659381), -- Leather Shoes Texture
(20388, 49, 1, 1, 1, 3891.687006), -- Gloves
(20388, 1869, 1, 1, 2, 29771.46667), -- Iron Ore
(20388, 1864, 1, 1, 2, 59542.93334), -- Stem
(20388, 736, 1, 1, 2, 14885.733335), -- Scroll of Escape
(20388, 735, 1, 1, 2, 2480.866655), -- Alacrity Potion
-- Boogle Ratman
(20389, 734, 1, 1, -1, 32995), -- Haste Potion
(20389, 2011, 1, 1, -1, 4516), -- Short Spear Edge
(20389, 1872, 1, 1, -1, 263962), -- Animal Bone
(20389, 57, 98, 153, 0, 700000), -- Adena
(20389, 945, 1, 1, 1, 2215.09728), -- Skeleton Buckler
(20389, 102, 1, 1, 1, 1069.081992), -- Round Shield
(20389, 44, 1, 1, 1, 747.804024), -- Leather Helmet
(20389, 1924, 1, 1, 1, 9432.016704), -- Leather Helmet Design
(20389, 1867, 1, 1, 2, 38985.053753), -- Animal Skin
(20389, 1872, 1, 1, 2, 38985.053753), -- Animal Bone
(20389, 2175, 1, 1, 2, 23771.41189), -- Recipe: Boots
(20389, 5158, 1, 1, 2, 1169.480604), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Boogle Ratman Leader
(20390, 1881, 1, 1, -1, 28140), -- Coarse Bone Powder
(20390, 1897, 1, 1, -1, 50249), -- Necklace of Wisdom Chain
(20390, 1873, 1, 1, -1, 84419), -- Silver Nugget
(20390, 57, 101, 167, 0, 700000), -- Adena
(20390, 2, 1, 1, 1, 59.336423), -- Long Sword
(20390, 120, 1, 1, 1, 59.336423), -- Sword of Reflection
(20390, 2012, 1, 1, 1, 648.990731), -- Sword of Reflection Blade
(20390, 121, 1, 1, 1, 59.336423), -- Sword of Watershadow
(20390, 1868, 1, 1, 2, 49871.97819), -- Thread
(20390, 1873, 1, 1, 2, 9974.395638), -- Silver Nugget
(20390, 1801, 1, 1, 2, 12562.174206), -- Recipe: Piece Bone Gaiters
(20390, 5158, 1, 1, 2, 997.44732), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20390, 734, 1, 1, 2, 4156.004646), -- Haste Potion
-- Redeye Bat
(20392, 1798, 1, 1, -1, 227072), -- Recipe: Leather Helmet
(20392, 1833, 1, 1, -1, 617635), -- Bandage
(20392, 1831, 1, 1, -1, 617635), -- Antidote
(20392, 57, 116, 177, 0, 700000), -- Adena
(20392, 23, 1, 1, 1, 1490.418228), -- Wooden Breastplate
(20392, 30, 1, 1, 1, 2387.790886), -- Hard Leather Pants
(20392, 2386, 1, 1, 1, 2387.790886), -- Wooden Gaiters
(20392, 1869, 1, 1, 2, 34207.459451), -- Iron Ore
(20392, 1864, 1, 1, 2, 68415.114645), -- Stem
(20392, 736, 1, 1, 2, 17103.827597), -- Scroll of Escape
(20392, 1060, 1, 1, 2, 76016.598307), -- Lesser Healing Potion
-- Red Scavenger Spider
(20393, 2252, 1, 1, -1, 9736), -- Recipe: Iron Hammer
(20393, 1897, 1, 1, -1, 56563), -- Necklace of Wisdom Chain
(20393, 57, 118, 183, 0, 700000), -- Adena
(20393, 217, 1, 1, 1, 133.5), -- Shining Knife
(20393, 218, 1, 1, 1, 133.5), -- Throwing Knife
(20393, 1867, 1, 1, 2, 62376.36144), -- Animal Skin
(20393, 1872, 1, 1, 2, 62376.36144), -- Animal Bone
(20393, 2252, 1, 1, 2, 1917.27712), -- Recipe: Iron Hammer
-- Blood Fungus
(20400, 1803, 1, 1, -1, 175710), -- Recipe: Necklace of Wisdom
(20400, 1923, 1, 1, -1, 85695), -- Leather Stockings Pattern
(20400, 1921, 1, 1, -1, 134900), -- Leather Shoes Texture
(20400, 57, 112, 154, 0, 700000), -- Adena
(20400, 114, 1, 1, 1, 1830.019062), -- Earring of Strength
(20400, 115, 1, 1, 1, 1830.019062), -- Earring of Wisdom
(20400, 907, 1, 1, 1, 1372.518858), -- Necklace of Anguish
(20400, 1896, 1, 1, 1, 10468.387056), -- Necklace of Anguish Chain
(20400, 876, 1, 1, 1, 2745.055962), -- Ring of Anguish
(20400, 1864, 1, 1, 2, 82351.173385), -- Stem
(20400, 1869, 1, 1, 2, 41175.66864), -- Iron Ore
(20400, 1798, 1, 1, 2, 40368.157975), -- Recipe: Leather Helmet
-- Veelan Bugbear
(20401, 2151, 1, 1, -1, 105333), -- Recipe: Necklace of Devotion
(20401, 1873, 1, 1, -1, 151258), -- Silver Nugget
(20401, 1866, 1, 1, -1, 252096), -- Suede
(20401, 57, 173, 305, 0, 700000), -- Adena
(20401, 87, 1, 1, 1, 59.4008), -- Iron Hammer
(20401, 2014, 1, 1, 1, 641.79842), -- Iron Hammer Head
(20401, 155, 1, 1, 1, 59.4008), -- Flanged Mace
(20401, 177, 1, 1, 1, 59.39998), -- Mage Staff
(20401, 1866, 1, 1, 2, 37232.78645), -- Suede
(20401, 1871, 1, 1, 2, 55849.22845), -- Charcoal
(20401, 5153, 1, 1, 2, 2233.99255), -- Recipe: Soulshot (D) Compressed Package (100%)
(20401, 5158, 1, 1, 2, 2233.99255), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Veelan Bugbear Warrior
(20402, 2179, 1, 1, -1, 194917), -- Recipe: Crafted Leather Gloves
(20402, 1880, 1, 1, -1, 40738), -- Steel
(20402, 1871, 1, 1, -1, 407376), -- Charcoal
(20402, 57, 181, 334, 0, 700000), -- Adena
(20402, 25, 1, 1, 1, 327.716196), -- Piece Bone Breastplate
(20402, 1926, 1, 1, 1, 4051.787503), -- Piece Bone Breastplate Fragment
(20402, 26, 1, 1, 1, 212.127426), -- Bronze Breastplate
(20402, 32, 1, 1, 1, 524.352693), -- Piece Bone Gaiters
(20402, 1928, 1, 1, 1, 5843.074468), -- Piece Bone Gaiters Fragment
(20402, 34, 1, 1, 1, 339.941714), -- Bronze Gaiters
(20402, 1866, 1, 1, 2, 40110.92374), -- Suede
(20402, 1871, 1, 1, 2, 60166.38561), -- Charcoal
(20402, 2256, 1, 1, 2, 1471.08522), -- Recipe: Assassin Knife
(20402, 5158, 1, 1, 2, 2406.60543), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Hunter Tarantula
(20403, 1868, 1, 1, -1, 475131), -- Thread
(20403, 2012, 1, 1, -1, 4949), -- Sword of Reflection Blade
(20403, 734, 1, 1, -1, 39594), -- Haste Potion
(20403, 57, 118, 183, 0, 700000), -- Adena
(20403, 38, 1, 1, 1, 1795.866945), -- Low Boots
(20403, 50, 1, 1, 1, 1795.866945), -- Leather Gloves
(20403, 1925, 1, 1, 1, 30677.26611), -- Leather Gloves Lining
(20403, 1867, 1, 1, 2, 37425.875256), -- Animal Skin
(20403, 1872, 1, 1, 2, 37425.875256), -- Animal Bone
(20403, 2253, 1, 1, 2, 1150.400328), -- Recipe: Sword Breaker
(20403, 5268, 1, 1, 2, 1122.746856), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20403, 735, 1, 1, 2, 2339.102304), -- Alacrity Potion
-- Silent Horror
(20404, 2253, 1, 1, -1, 8276), -- Recipe: Sword Breaker
(20404, 735, 1, 1, -1, 16828), -- Alacrity Potion
(20404, 1897, 1, 1, -1, 48079), -- Necklace of Wisdom Chain
(20404, 57, 100, 156, 0, 700000), -- Adena
(20404, 1101, 1, 1, 1, 764.810586), -- Tunic of Devotion
(20404, 1104, 1, 1, 1, 1221.189414), -- Stockings of Devotion
(20404, 1866, 1, 1, 2, 19882.56029), -- Suede
(20404, 1871, 1, 1, 2, 29823.813728), -- Charcoal
(20404, 2254, 1, 1, 2, 1222.272562), -- Recipe: Composite Bow
(20404, 6035, 1, 1, 2, 2485.35342), -- Magic Haste Potion
-- Scavenger Spider
(20410, 1868, 1, 1, -1, 472491), -- Thread
(20410, 2009, 1, 1, -1, 8377), -- Dirk Blade
(20410, 1792, 1, 1, -1, 17371), -- Recipe: Short Spear
(20410, 57, 119, 180, 0, 700000), -- Adena
(20410, 9, 1, 1, 1, 223.71135), -- Cedar Staff
(20410, 2008, 1, 1, 1, 1810.5773), -- Cedar Staff Head
(20410, 154, 1, 1, 1, 223.71135), -- Dwarven Mace
(20410, 1867, 1, 1, 2, 62029.60084), -- Animal Skin
(20410, 1872, 1, 1, 2, 62029.60084), -- Animal Bone
(20410, 1793, 1, 1, 2, 3420.79832), -- Recipe: Sword of Reflection
-- Scavenger Bat
(20411, 735, 1, 1, -1, 21105), -- Alacrity Potion
(20411, 2141, 1, 1, -1, 50651), -- Recipe: Silver Mold
(20411, 1897, 1, 1, -1, 60299), -- Necklace of Wisdom Chain
(20411, 57, 121, 200, 0, 700000), -- Adena
(20411, 217, 1, 1, 1, 142.5), -- Shining Knife
(20411, 218, 1, 1, 1, 142.5), -- Throwing Knife
(20411, 1864, 1, 1, 2, 59846.45251), -- Stem
(20411, 1869, 1, 1, 2, 29923.14247), -- Iron Ore
(20411, 1878, 1, 1, 2, 11969.35753), -- Braided Hemp
(20411, 1817, 1, 1, 2, 5984.59498), -- Recipe: Cord
(20411, 6037, 1, 1, 2, 59846.45251), -- Waking Scroll
-- Scarlet Salamander
(20415, 2144, 1, 1, -1, 45114), -- Recipe: Compound Braid
(20415, 1865, 1, 1, -1, 225572), -- Varnish
(20415, 735, 1, 1, -1, 18798), -- Alacrity Potion
(20415, 57, 110, 177, 0, 700000), -- Adena
(20415, 309, 1, 1, 1, 127), -- Tears of Eva
(20415, 310, 1, 1, 1, 127), -- Relic of the Saints
(20415, 1864, 1, 1, 2, 44420.332616), -- Stem
(20415, 1865, 1, 1, 2, 22210.166308), -- Varnish
(20415, 1866, 1, 1, 2, 14806.822756), -- Suede
(20415, 1873, 1, 1, 2, 8884.120784), -- Silver Nugget
(20415, 1868, 1, 1, 2, 44420.332616), -- Thread
(20415, 2253, 1, 1, 2, 910.22492), -- Recipe: Sword Breaker
-- Scarlet Salamander Elder
(20416, 2254, 1, 1, -1, 9514), -- Recipe: Composite Bow
(20416, 102, 1, 1, -1, 8488), -- Round Shield
(20416, 1924, 1, 1, -1, 74887), -- Leather Helmet Design
(20416, 57, 111, 183, 0, 700000), -- Adena
(20416, 1101, 1, 1, 1, 879.185583), -- Tunic of Devotion
(20416, 1104, 1, 1, 1, 1403.814417), -- Stockings of Devotion
(20416, 1866, 1, 1, 2, 22858.0191), -- Suede
(20416, 1871, 1, 1, 2, 34287.094024), -- Charcoal
(20416, 2139, 1, 1, 2, 6857.40573), -- Recipe: Steel Mold
(20416, 5268, 1, 1, 2, 1371.481146), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Crystalline Beast
(20418, 1872, 1, 1, -1, 334331), -- Animal Bone
(20418, 1800, 1, 1, -1, 78852), -- Recipe: Piece Bone Breastplate
(20418, 1925, 1, 1, -1, 164425), -- Leather Gloves Lining
(20418, 57, 120, 198, 0, 700000), -- Adena
(20418, 845, 1, 1, 1, 1082.867838), -- Cat's Eye Earring
(20418, 908, 1, 1, 1, 812.157047), -- Necklace of Wisdom
(20418, 1897, 1, 1, 1, 8817.673358), -- Necklace of Wisdom Chain
(20418, 877, 1, 1, 1, 1624.301757), -- Ring of Wisdom
(20418, 1867, 1, 1, 2, 49378.310415), -- Animal Skin
(20418, 1872, 1, 1, 2, 49378.310415), -- Animal Bone
(20418, 1882, 1, 1, 2, 8229.661206), -- Leather
(20418, 2140, 1, 1, 2, 7406.717964), -- Recipe: High-Grade Suede
-- Akaste Succubus Turen
(20420, 1868, 1, 1, -1, 580926), -- Thread
(20420, 1866, 1, 1, -1, 193642), -- Suede
(20420, 1804, 1, 1, -1, 11619), -- Recipe: Soulshot (D-Grade)
(20420, 57, 132, 236, 0, 700000), -- Adena
(20420, 1102, 1, 1, 1, 604.334152), -- Tunic of Magic
(20420, 1105, 1, 1, 1, 969.665848), -- Stockings of Magic
(20420, 1864, 1, 1, 2, 57198.813617), -- Stem
(20420, 1865, 1, 1, 2, 28599.319485), -- Varnish
(20420, 1866, 1, 1, 2, 19066.21299), -- Suede
(20420, 1873, 1, 1, 2, 11439.727794), -- Silver Nugget
(20420, 1868, 1, 1, 2, 57198.813617), -- Thread
(20420, 5163, 1, 1, 2, 1144.112497), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
-- Akaste Succubus Tilfo
(20421, 1866, 1, 1, -1, 205204), -- Suede
(20421, 1929, 1, 1, -1, 39717), -- Hard Leather Gaiters Material
(20421, 1898, 1, 1, -1, 31619), -- Blue Diamond Necklace Gem
(20421, 57, 140, 251, 0, 700000), -- Adena
(20421, 273, 1, 1, 1, 96.708612), -- Composite Bow
(20421, 2016, 1, 1, 1, 1065.291388), -- Composite Bow Shaft
(20421, 1869, 1, 1, 2, 30307.070768), -- Iron Ore
(20421, 1870, 1, 1, 2, 30307.070768), -- Coal
(20421, 1871, 1, 1, 2, 30307.070768), -- Charcoal
(20421, 1872, 1, 1, 2, 40409.37004), -- Animal Bone
(20421, 1867, 1, 1, 2, 40409.37004), -- Animal Skin
(20421, 5278, 1, 1, 2, 1212.047616), -- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
-- Akaste Bone Warlord
(20422, 1869, 1, 1, -1, 248908), -- Iron Ore
(20422, 2013, 1, 1, -1, 5372), -- Forest Bow Shaft
(20422, 1864, 1, 1, -1, 497816), -- Stem
(20422, 57, 121, 195, 0, 700000), -- Adena
(20422, 176, 1, 1, 1, 140), -- Apprentice's Staff
(20422, 2501, 1, 1, 1, 140), -- Bone Club
(20422, 1869, 1, 1, 2, 36761.673864), -- Iron Ore
(20422, 1864, 1, 1, 2, 73523.234466), -- Stem
(20422, 2254, 1, 1, 2, 1506.611124), -- Recipe: Composite Bow
(20422, 5273, 1, 1, 2, 1470.480546), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Akaste Bone Archer
(20423, 1792, 1, 1, -1, 14067), -- Recipe: Short Spear
(20423, 1921, 1, 1, -1, 123424), -- Leather Shoes Texture
(20423, 1793, 1, 1, -1, 14067), -- Recipe: Sword of Reflection
(20423, 57, 98, 145, 0, 700000), -- Adena
(20423, 271, 1, 1, 1, 543), -- Hunting Bow
(20423, 1872, 1, 1, 2, 75345.5), -- Animal Bone
(20423, 1867, 1, 1, 2, 75345.5), -- Animal Skin
-- Akaste Bone Lord
(20424, 2142, 1, 1, -1, 45599), -- Recipe: Varnish of Purity
(20424, 1880, 1, 1, -1, 22799), -- Steel
(20424, 1870, 1, 1, -1, 227995), -- Coal
(20424, 57, 107, 182, 0, 700000), -- Adena
(20424, 2, 1, 1, 1, 64.143606), -- Long Sword
(20424, 120, 1, 1, 1, 64.143606), -- Sword of Reflection
(20424, 2012, 1, 1, 1, 701.569182), -- Sword of Reflection Blade
(20424, 121, 1, 1, 1, 64.143606), -- Sword of Watershadow
(20424, 1870, 1, 1, 2, 44897.4846), -- Coal
(20424, 1865, 1, 1, 2, 44897.4846), -- Varnish
(20424, 2253, 1, 1, 2, 1840.0308), -- Recipe: Sword Breaker
-- Akaste Bone Soldier
(20425, 1869, 1, 1, -1, 177731), -- Iron Ore
(20425, 1831, 1, 1, -1, 473949), -- Antidote
(20425, 57, 95, 131, 0, 700000), -- Adena
(20425, 66, 1, 1, 1, 168.22935), -- Gladius
(20425, 1333, 1, 1, 1, 168.22935), -- Brandish
(20425, 2010, 1, 1, 1, 1361.5413), -- Brandish Blade
(20425, 1871, 1, 1, 2, 34999.299401), -- Charcoal
(20425, 1866, 1, 1, 2, 23332.902995), -- Suede
(20425, 1799, 1, 1, 2, 51850.797604), -- Recipe: Leather Gloves
-- Evil Eye
(20426, 1796, 1, 1, -1, 224389), -- Recipe: Leather Tunic
(20426, 2005, 1, 1, -1, 12742), -- Broadsword Blade
(20426, 57, 96, 130, 0, 700000), -- Adena
(20426, 113, 1, 1, 1, 11331.990825), -- Mystic's Earring
(20426, 906, 1, 1, 1, 8464.851375), -- Necklace of Knowledge
(20426, 875, 1, 1, 1, 16728.1578), -- Ring of Knowledge
(20426, 1873, 1, 1, 2, 10538.69033), -- Silver Nugget
(20426, 1868, 1, 1, 2, 52693.71071), -- Thread
(20426, 2137, 1, 1, 2, 7749.13225), -- Recipe: Steel
(20426, 1060, 1, 1, 2, 58548.46671), -- Lesser Healing Potion
-- Evil Eye Watcher
(20427, 1866, 1, 1, -1, 99105), -- Suede
(20427, 1060, 1, 1, -1, 330350), -- Lesser Healing Potion
(20427, 1666, 1, 1, -1, 49552), -- Recipe: Wooden Arrow
(20427, 57, 80, 108, 0, 700000), -- Adena
(20427, 254, 1, 1, 1, 1830), -- Iron Gloves
(20427, 1864, 1, 1, 2, 58548.013776), -- Stem
(20427, 1869, 1, 1, 2, 29273.958672), -- Iron Ore
(20427, 2138, 1, 1, 2, 8610.027552), -- Recipe: Coarse Bone Powder (100%)
-- Evil Eye Patroller
(20428, 1831, 1, 1, -1, 594351), -- Antidote
(20428, 1864, 1, 1, -1, 445764), -- Stem
(20428, 1896, 1, 1, -1, 94441), -- Necklace of Anguish Chain
(20428, 57, 114, 168, 0, 700000), -- Adena
(20428, 114, 1, 1, 1, 1950.676353), -- Earring of Strength
(20428, 115, 1, 1, 1, 1950.676353), -- Earring of Wisdom
(20428, 907, 1, 1, 1, 1463.012127), -- Necklace of Anguish
(20428, 1896, 1, 1, 1, 11158.591464), -- Necklace of Anguish Chain
(20428, 876, 1, 1, 1, 2926.043703), -- Ring of Anguish
(20428, 1864, 1, 1, 2, 37620.446542), -- Stem
(20428, 1865, 1, 1, 2, 18810.223271), -- Varnish
(20428, 1866, 1, 1, 2, 12540.212895), -- Suede
(20428, 1873, 1, 1, 2, 7524.127737), -- Silver Nugget
(20428, 1868, 1, 1, 2, 37620.446542), -- Thread
(20428, 1799, 1, 1, 2, 27867.075719), -- Recipe: Leather Gloves
(20428, 1833, 1, 1, 2, 50160.467294), -- Bandage
-- Evil Eye Lookout
(20429, 2009, 1, 1, -1, 6586), -- Dirk Blade
(20429, 1792, 1, 1, -1, 13657), -- Recipe: Short Spear
(20429, 1921, 1, 1, -1, 119829), -- Leather Shoes Texture
(20429, 57, 95, 140, 0, 700000), -- Adena
(20429, 429, 1, 1, 1, 896.468475), -- Leather Tunic
(20429, 1922, 1, 1, 1, 6997.864804), -- Leather Tunic Pattern
(20429, 464, 1, 1, 1, 1436.20113), -- Leather Stockings
(20429, 1923, 1, 1, 1, 11242.465591), -- Leather Stockings Pattern
(20429, 1868, 1, 1, 2, 73151.06274), -- Thread
(20429, 1873, 1, 1, 2, 14630.212548), -- Silver Nugget
(20429, 1803, 1, 1, 2, 30735.724712), -- Recipe: Necklace of Wisdom
-- Elpy
(20432, 1871, 1, 1, -1, 15920), -- Charcoal
(20432, 1873, 1, 1, -1, 6368), -- Silver Nugget
(20432, 57, 8, 12, 0, 700000), -- Adena
(20432, 11, 1, 1, 1, 5579), -- Bone Dagger
(20432, 1864, 1, 1, 2, 4702.406639), -- Stem
(20432, 1865, 1, 1, 2, 2351.21727), -- Varnish
(20432, 1866, 1, 1, 2, 1567.47818), -- Suede
(20432, 1873, 1, 1, 2, 940.486908), -- Silver Nugget
(20432, 1868, 1, 1, 2, 4702.406639), -- Thread
(20432, 1787, 1, 1, 2, 1880.973816), -- Recipe: Willow Staff
(20432, 17, 10, 30, 2, 11756.030548), -- Wooden Arrow
-- Festering Bat
(20433, 1864, 1, 1, -1, 430270), -- Stem
(20433, 1865, 1, 1, -1, 215135), -- Varnish
(20433, 1921, 1, 1, -1, 138797), -- Leather Shoes Texture
(20433, 57, 113, 160, 0, 700000), -- Adena
(20433, 429, 1, 1, 1, 1038.348675), -- Leather Tunic
(20433, 1922, 1, 1, 1, 8105.386692), -- Leather Tunic Pattern
(20433, 464, 1, 1, 1, 1663.50249), -- Leather Stockings
(20433, 1923, 1, 1, 1, 13021.762143), -- Leather Stockings Pattern
(20433, 1870, 1, 1, 2, 31773.902352), -- Coal
(20433, 1865, 1, 1, 2, 31773.902352), -- Varnish
(20433, 1794, 1, 1, 2, 2336.324412), -- Recipe: Forest Bow
(20433, 735, 1, 1, 2, 2647.870884), -- Alacrity Potion
-- Opal Beast
(20435, 1871, 1, 1, -1, 194922), -- Charcoal
(20435, 1793, 1, 1, -1, 14332), -- Recipe: Sword of Reflection
(20435, 1833, 1, 1, -1, 519792), -- Bandage
(20435, 57, 98, 149, 0, 700000), -- Adena
(20435, 216, 1, 1, 1, 276.86541), -- Dirk
(20435, 2009, 1, 1, 1, 2042.13459), -- Dirk Blade
(20435, 1872, 1, 1, 2, 51179.286523), -- Animal Bone
(20435, 1867, 1, 1, 2, 51179.286523), -- Animal Skin
(20435, 1794, 1, 1, 2, 2822.426954), -- Recipe: Forest Bow
-- Ol Mahum Supplier
(20436, 1869, 1, 1, -1, 378144), -- Iron Ore
(20436, 2016, 1, 1, -1, 4431), -- Composite Bow Shaft
(20436, 1898, 1, 1, -1, 38844), -- Blue Diamond Necklace Gem
(20436, 57, 173, 305, 0, 700000), -- Adena
(20436, 16, 1, 1, 1, 238), -- Great Spear
(20436, 1870, 1, 1, 2, 74465.184164), -- Coal
(20436, 1865, 1, 1, 2, 74465.184164), -- Varnish
(20436, 5158, 1, 1, 2, 2978.631672), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Ol Mahum Recruit
(20437, 2258, 1, 1, -1, 8355), -- Recipe: Temptation of Abyss
(20437, 2016, 1, 1, -1, 4004), -- Composite Bow Shaft
(20437, 1804, 1, 1, -1, 13669), -- Recipe: Soulshot (D-Grade)
(20437, 57, 156, 278, 0, 700000), -- Adena
(20437, 39, 1, 1, 1, 1416.686112), -- Boots
(20437, 1930, 1, 1, 1, 17254.607688), -- Boot Lining
(20437, 51, 1, 1, 1, 1416.7062), -- Bracer
(20437, 1871, 1, 1, 2, 50469.751278), -- Charcoal
(20437, 1866, 1, 1, 2, 33646.500852), -- Suede
(20437, 5268, 1, 1, 2, 2018.748114), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20437, 5437, 1, 1, 2, 1233.999756), -- Recipe: Heavy Sword(100%)
-- Ol Mahum General
(20438, 1865, 1, 1, -1, 450915), -- Varnish
(20438, 1869, 1, 1, -1, 450915), -- Iron Ore
(20438, 1899, 1, 1, -1, 70456), -- Necklace of Devotion Chain
(20438, 57, 196, 374, 0, 700000), -- Adena
(20438, 291, 1, 1, 1, 80.352954), -- Trident
(20438, 2019, 1, 1, 1, 2721.647046), -- Trident Edge
(20438, 1875, 1, 1, 2, 3374.22699), -- Stone of Purity
(20438, 1879, 1, 1, 2, 8435.53183), -- Cokes
(20438, 5549, 1, 1, 2, 5061.30484), -- Metallic Thread
(20438, 2180, 1, 1, 2, 3805.53149), -- Recipe: Scale Mail
(20438, 6666, 1, 1, 2, 50613.40485), -- Deluxe Chest Key - Grade 2
-- Ol Mahum Officer
(20439, 2255, 1, 1, -1, 9765), -- Recipe: Saber
(20439, 2015, 1, 1, -1, 4871), -- Sword Breaker Edge
(20439, 2151, 1, 1, -1, 111250), -- Recipe: Necklace of Devotion
(20439, 57, 177, 327, 0, 700000), -- Adena
(20439, 25, 1, 1, 1, 321.277308), -- Piece Bone Breastplate
(20439, 1926, 1, 1, 1, 3972.178969), -- Piece Bone Breastplate Fragment
(20439, 26, 1, 1, 1, 207.959598), -- Bronze Breastplate
(20439, 32, 1, 1, 1, 514.050339), -- Piece Bone Gaiters
(20439, 1928, 1, 1, 1, 5728.271164), -- Piece Bone Gaiters Fragment
(20439, 34, 1, 1, 1, 333.262622), -- Bronze Gaiters
(20439, 1873, 1, 1, 2, 31459.53048), -- Silver Nugget
(20439, 1868, 1, 1, 2, 157297.46172), -- Thread
(20439, 2257, 1, 1, 2, 1923.0078), -- Recipe: Trident
-- Elder Wolf
(20442, 1786, 1, 1, -1, 44845), -- Recipe: Broad Sword
(20442, 1864, 1, 1, -1, 112112), -- Stem
(20442, 5549, 1, 1, -1, 5606), -- Metallic Thread
(20442, 57, 30, 42, 0, 700000), -- Adena
(20442, 4, 1, 1, 1, 9822.5), -- Club
(20442, 7, 1, 1, 1, 9822.5), -- Apprentice's Rod
(20442, 1868, 1, 1, 2, 28976.533208), -- Thread
(20442, 1873, 1, 1, 2, 5795.25912), -- Silver Nugget
(20442, 1787, 1, 1, 2, 11590.637044), -- Recipe: Willow Staff
(20442, 17, 10, 30, 2, 72441.570628), -- Wooden Arrow
-- Utuku Orc
(20446, 1870, 1, 1, -1, 77741), -- Coal
(20446, 2007, 1, 1, -1, 5553), -- Bow Shaft
(20446, 1869, 1, 1, -1, 77741), -- Iron Ore
(20446, 57, 41, 58, 0, 700000), -- Adena
(20446, 22, 1, 1, 1, 2455.842708), -- Leather Shirt
(20446, 29, 1, 1, 1, 3925.157292), -- Leather Pants
(20446, 1869, 1, 1, 2, 15308.750172), -- Iron Ore
(20446, 1864, 1, 1, 2, 30617.500344), -- Stem
(20446, 1791, 1, 1, 2, 2829.749484), -- Recipe: Brandish
-- Utuku Orc Archer
(20447, 1797, 1, 1, -1, 259314), -- Recipe: Leather Stockings
(20447, 2138, 1, 1, -1, 37753), -- Recipe: Coarse Bone Powder (100%)
(20447, 1060, 1, 1, -1, 285245), -- Lesser Healing Potion
(20447, 57, 69, 94, 0, 700000), -- Adena
(20447, 14, 1, 1, 1, 789.869388), -- Bow
(20447, 2007, 1, 1, 1, 2708.130612), -- Bow Shaft
(20447, 1873, 1, 1, 2, 10110.924824), -- Silver Nugget
(20447, 1868, 1, 1, 2, 50554.689458), -- Thread
(20447, 1791, 1, 1, 2, 4672.385718), -- Recipe: Brandish
-- Utuku Orc Grunt
(20448, 1666, 1, 1, -1, 32439), -- Recipe: Wooden Arrow
(20448, 2006, 1, 1, -1, 6951), -- Willow Staff Head
(20448, 1789, 1, 1, -1, 17988), -- Recipe: Cedar Staff
(20448, 57, 51, 72, 0, 700000), -- Adena
(20448, 3, 1, 1, 1, 598.837512), -- Broadsword
(20448, 2005, 1, 1, 1, 2053.162488), -- Broadsword Blade
(20448, 1866, 1, 1, 2, 19164), -- Suede
(20448, 1871, 1, 1, 2, 28746), -- Charcoal
-- Will-O-Wisp
(20449, 1873, 1, 1, -1, 92414), -- Silver Nugget
(20449, 115, 1, 1, -1, 17114), -- Earring of Wisdom
(20449, 1896, 1, 1, -1, 97896), -- Necklace of Anguish Chain
(20449, 57, 116, 177, 0, 700000), -- Adena
(20449, 429, 1, 1, 1, 1115.08425), -- Leather Tunic
(20449, 1922, 1, 1, 1, 8704.38732), -- Leather Tunic Pattern
(20449, 464, 1, 1, 1, 1786.4379), -- Leather Stockings
(20449, 1923, 1, 1, 1, 13984.09053), -- Leather Stockings Pattern
(20449, 1873, 1, 1, 2, 18198.408555), -- Silver Nugget
(20449, 1868, 1, 1, 2, 90992.350365), -- Thread
(20449, 1798, 1, 1, 2, 44604.24108), -- Recipe: Leather Helmet
-- Relic Werewolf
(20450, 1870, 1, 1, -1, 124035), -- Coal
(20450, 1666, 1, 1, -1, 41345), -- Recipe: Wooden Arrow
(20450, 57, 67, 90, 0, 700000), -- Adena
(20450, 152, 1, 1, 1, 590.996927), -- Heavy Chisel
(20450, 5, 1, 1, 1, 381.685127), -- Mace
(20450, 8, 1, 1, 1, 381.685127), -- Willow Staff
(20450, 2006, 1, 1, 1, 1308.632819), -- Willow Staff Head
(20450, 1869, 1, 1, 2, 24425.32266), -- Iron Ore
(20450, 1864, 1, 1, 2, 48850.72578), -- Stem
(20450, 2135, 1, 1, 2, 7183.95156), -- Recipe: Braided Hemp
-- Doom Soldier
(20455, 1869, 1, 1, -1, 189449), -- Iron Ore
(20455, 1794, 1, 1, -1, 13930), -- Recipe: Forest Bow
(20455, 1896, 1, 1, -1, 80275), -- Necklace of Anguish Chain
(20455, 57, 97, 143, 0, 700000), -- Adena
(20455, 20, 1, 1, 1, 5229.661794), -- Buckler
(20455, 43, 1, 1, 1, 3657.338206), -- Wooden Helmet
(20455, 1868, 1, 1, 2, 74613.77445), -- Thread
(20455, 1873, 1, 1, 2, 14922.75489), -- Silver Nugget
(20455, 736, 1, 1, 2, 18653.47066), -- Scroll of Escape
-- Ashen Wolf
(20456, 1872, 1, 1, -1, 51475), -- Animal Bone
(20456, 1788, 1, 1, -1, 30885), -- Recipe: Bow
(20456, 1868, 1, 1, -1, 77212), -- Thread
(20456, 57, 19, 29, 0, 700000), -- Adena
(20456, 308, 1, 1, 1, 13530), -- Buffalo's Horn
(20456, 1868, 1, 1, 2, 19956.305542), -- Thread
(20456, 1873, 1, 1, 2, 3991.22838), -- Silver Nugget
(20456, 1788, 1, 1, 2, 7982.538581), -- Recipe: Bow
(20456, 17, 10, 30, 2, 49890.927497), -- Wooden Arrow
-- Zombie Soldier
(20457, 1866, 1, 1, -1, 195744), -- Suede
(20457, 2013, 1, 1, -1, 6337), -- Forest Bow Shaft
(20457, 1864, 1, 1, -1, 587232), -- Stem
(20457, 57, 138, 234, 0, 700000), -- Adena
(20457, 15, 1, 1, 1, 165.218784), -- Short Spear
(20457, 2011, 1, 1, 1, 1978.781216), -- Short Spear Edge
(20457, 1869, 1, 1, 2, 34691.766272), -- Iron Ore
(20457, 1864, 1, 1, 2, 69383.532544), -- Stem
(20457, 1880, 1, 1, 2, 3469.198698), -- Steel
(20457, 2254, 1, 1, 2, 1421.800936), -- Recipe: Composite Bow
(20457, 5273, 1, 1, 2, 1387.70155), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Zombie Warrior
(20458, 2256, 1, 1, -1, 10153), -- Recipe: Assassin Knife
(20458, 2176, 1, 1, -1, 198681), -- Recipe: Leather Boots
(20458, 1898, 1, 1, -1, 42655), -- Blue Diamond Necklace Gem
(20458, 57, 188, 339, 0, 700000), -- Adena
(20458, 846, 1, 1, 1, 997.234861), -- Coral Earring
(20458, 909, 1, 1, 1, 747.928531), -- Blue Diamond Necklace
(20458, 1898, 1, 1, 1, 6299.970005), -- Blue Diamond Necklace Gem
(20458, 878, 1, 1, 1, 1495.866603), -- Blue Coral Ring
(20458, 1869, 1, 1, 2, 35044.738992), -- Iron Ore
(20458, 1864, 1, 1, 2, 70089.477984), -- Stem
(20458, 1880, 1, 1, 2, 3504.429696), -- Steel
(20458, 1804, 1, 1, 2, 1401.830816), -- Recipe: Soulshot (D-Grade)
(20458, 5437, 1, 1, 2, 856.80536), -- Recipe: Heavy Sword(100%)
(20458, 5268, 1, 1, 2, 1401.830816), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20458, 6666, 1, 1, 2, 35044.886336), -- Deluxe Chest Key - Grade 2
-- Crimson Spider
(20460, 1833, 1, 1, -1, 629988), -- Bandage
(20460, 1866, 1, 1, -1, 157497), -- Suede
(20460, 1792, 1, 1, -1, 17371), -- Recipe: Short Spear
(20460, 57, 119, 180, 0, 700000), -- Adena
(20460, 66, 1, 1, 1, 223.71135), -- Gladius
(20460, 1333, 1, 1, 1, 223.71135), -- Brandish
(20460, 2010, 1, 1, 1, 1810.5773), -- Brandish Blade
(20460, 1867, 1, 1, 2, 62029.689849), -- Animal Skin
(20460, 1872, 1, 1, 2, 62029.689849), -- Animal Bone
(20460, 1799, 1, 1, 2, 68921.620302), -- Recipe: Leather Gloves
-- Dungeon Spider
(20461, 1803, 1, 1, -1, 165438), -- Recipe: Necklace of Wisdom
(20461, 2010, 1, 1, -1, 7660), -- Brandish Blade
(20461, 1896, 1, 1, -1, 83420), -- Necklace of Anguish Chain
(20461, 57, 99, 150, 0, 700000), -- Adena
(20461, 66, 1, 1, 1, 186.360075), -- Gladius
(20461, 1333, 1, 1, 1, 186.360075), -- Brandish
(20461, 2010, 1, 1, 1, 1508.27985), -- Brandish Blade
(20461, 1867, 1, 1, 2, 51691.284512), -- Animal Skin
(20461, 1872, 1, 1, 2, 51691.284512), -- Animal Bone
(20461, 1803, 1, 1, 2, 32578.430976), -- Recipe: Necklace of Wisdom
-- Cave Blade Spider
(20462, 1865, 1, 1, -1, 209166), -- Varnish
(20462, 1872, 1, 1, -1, 278888), -- Animal Bone
(20462, 1800, 1, 1, -1, 65776), -- Recipe: Piece Bone Breastplate
(20462, 57, 102, 164, 0, 700000), -- Adena
(20462, 256, 1, 1, 1, 235), -- Cestus
(20462, 1867, 1, 1, 2, 54919.581544), -- Animal Skin
(20462, 1872, 1, 1, 2, 54919.581544), -- Animal Bone
(20462, 1800, 1, 1, 2, 12952.836912), -- Recipe: Piece Bone Breastplate
-- Dungeon Skeleton Archer
(20463, 2010, 1, 1, -1, 7185), -- Brandish Blade
(20463, 1921, 1, 1, -1, 119134), -- Leather Shoes Texture
(20463, 1799, 1, 1, -1, 273567), -- Recipe: Leather Gloves
(20463, 57, 97, 137, 0, 700000), -- Adena
(20463, 271, 1, 1, 1, 524), -- Hunting Bow
(20463, 1864, 1, 1, 2, 72726.49462), -- Stem
(20463, 1869, 1, 1, 2, 36363.31968), -- Iron Ore
(20463, 1798, 1, 1, 2, 35650.1857), -- Recipe: Leather Helmet
-- Dungeon Skeleton
(20464, 464, 1, 1, -1, 9305), -- Leather Stockings
(20464, 1874, 1, 1, -1, 11849), -- Oriharukon Ore
(20464, 1870, 1, 1, -1, 177731), -- Coal
(20464, 57, 95, 131, 0, 700000), -- Adena
(20464, 9, 1, 1, 1, 168.22935), -- Cedar Staff
(20464, 2008, 1, 1, 1, 1361.5413), -- Cedar Staff Head
(20464, 154, 1, 1, 1, 168.22935), -- Dwarven Mace
(20464, 1870, 1, 1, 2, 34999.37811), -- Coal
(20464, 1865, 1, 1, 2, 34999.37811), -- Varnish
(20464, 1803, 1, 1, 2, 29411.24378), -- Recipe: Necklace of Wisdom
-- Pincer Spider
(20466, 1868, 1, 1, -1, 501999), -- Thread
(20466, 1897, 1, 1, -1, 59762), -- Necklace of Wisdom Chain
(20466, 734, 1, 1, -1, 41833), -- Haste Potion
(20466, 57, 122, 197, 0, 700000), -- Adena
(20466, 24, 1, 1, 1, 475.2134), -- Bone Breastplate
(20466, 390, 1, 1, 1, 475.2134), -- Cotton Shirt
(20466, 31, 1, 1, 1, 758.7866), -- Bone Gaiters
(20466, 412, 1, 1, 1, 758.7866), -- Cotton Pants
(20466, 1867, 1, 1, 2, 49427.823354), -- Animal Skin
(20466, 1872, 1, 1, 2, 49427.823354), -- Animal Bone
(20466, 1801, 1, 1, 2, 18675.557866), -- Recipe: Piece Bone Gaiters
(20466, 5158, 1, 1, 2, 1482.795426), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Kaboo Orc
(20468, 1814, 1, 1, -1, 40916), -- Recipe: Leather
(20468, 1790, 1, 1, -1, 14370), -- Recipe: Dirk
(20468, 2005, 1, 1, -1, 5553), -- Broadsword Blade
(20468, 57, 41, 58, 0, 700000), -- Adena
(20468, 99, 1, 1, 1, 957), -- Apprentice's Spellbook
(20468, 1869, 1, 1, 2, 15308.847872), -- Iron Ore
(20468, 1864, 1, 1, 2, 30617.79944), -- Stem
(20468, 1795, 1, 1, 2, 57769.352688), -- Recipe: Leather Shoes
-- Kaboo Orc Archer
(20469, 1864, 1, 1, -1, 256721), -- Stem
(20469, 2007, 1, 1, -1, 9169), -- Bow Shaft
(20469, 1666, 1, 1, -1, 42787), -- Recipe: Wooden Arrow
(20469, 57, 69, 94, 0, 700000), -- Adena
(20469, 14, 1, 1, 1, 789.869388), -- Bow
(20469, 2007, 1, 1, 1, 2708.130612), -- Bow Shaft
(20469, 1873, 1, 1, 2, 7583.157568), -- Silver Nugget
(20469, 1868, 1, 1, 2, 37915.452658), -- Thread
(20469, 1795, 1, 1, 2, 71538.564624), -- Recipe: Leather Shoes
(20469, 1833, 1, 1, 2, 50553.82515), -- Bandage
-- Kaboo Orc Grunt
(20470, 1791, 1, 1, -1, 17988), -- Recipe: Brandish
(20470, 1060, 1, 1, -1, 216259), -- Lesser Healing Potion
(20470, 2006, 1, 1, -1, 6951), -- Willow Staff Head
(20470, 57, 51, 72, 0, 700000), -- Adena
(20470, 19, 1, 1, 1, 11732.93531), -- Small Shield
(20470, 42, 1, 1, 1, 8213.06469), -- Leather Cap
(20470, 1869, 1, 1, 2, 14372.956064), -- Iron Ore
(20470, 1864, 1, 1, 2, 28745.960672), -- Stem
(20470, 2135, 1, 1, 2, 4227.357152), -- Recipe: Braided Hemp
(20470, 735, 1, 1, 2, 1197.726112), -- Alacrity Potion
-- Kaboo Orc Fighter
(20471, 1797, 1, 1, -1, 367589), -- Recipe: Leather Stockings
(20471, 428, 1, 1, -1, 19461), -- Feriotic Tunic
(20471, 1869, 1, 1, -1, 181957), -- Iron Ore
(20471, 57, 98, 132, 0, 700000), -- Adena
(20471, 3, 1, 1, 1, 1119.771954), -- Broadsword
(20471, 2005, 1, 1, 1, 3839.228046), -- Broadsword Blade
(20471, 1869, 1, 1, 2, 35831.4), -- Iron Ore
(20471, 1864, 1, 1, 2, 71662.8), -- Stem
(20471, 1666, 1, 1, 2, 11943.8), -- Recipe: Wooden Arrow
-- Kaboo Orc Fighter Leader
(20472, 1867, 1, 1, -1, 284370), -- Animal Skin
(20472, 1864, 1, 1, -1, 426554), -- Stem
(20472, 1922, 1, 1, -1, 54407), -- Leather Tunic Pattern
(20472, 57, 114, 157, 0, 700000), -- Adena
(20472, 66, 1, 1, 1, 201.91485), -- Gladius
(20472, 1333, 1, 1, 1, 201.91485), -- Brandish
(20472, 2010, 1, 1, 1, 1634.1703), -- Brandish Blade
(20472, 1869, 1, 1, 2, 41999.100858), -- Iron Ore
(20472, 1864, 1, 1, 2, 83998.348713), -- Stem
(20472, 736, 1, 1, 2, 20999.550429), -- Scroll of Escape
-- Kaboo Orc Fighter Lieutenant
(20473, 23, 1, 1, -1, 6588), -- Wooden Breastplate
(20473, 1831, 1, 1, -1, 537542), -- Antidote
(20473, 1896, 1, 1, -1, 85415), -- Necklace of Anguish Chain
(20473, 57, 109, 147, 0, 700000), -- Adena
(20473, 9, 1, 1, 1, 190.81845), -- Cedar Staff
(20473, 2008, 1, 1, 1, 1544.3631), -- Cedar Staff Head
(20473, 154, 1, 1, 1, 190.81845), -- Dwarven Mace
(20473, 1869, 1, 1, 2, 39695.424795), -- Iron Ore
(20473, 1864, 1, 1, 2, 79390.84959), -- Stem
(20473, 1792, 1, 1, 2, 2918.725615), -- Recipe: Short Spear
-- Kasha Spider
(20474, 1866, 1, 1, -1, 154409), -- Suede
(20474, 1799, 1, 1, -1, 343131), -- Recipe: Leather Gloves
(20474, 1792, 1, 1, -1, 17030), -- Recipe: Short Spear
(20474, 57, 116, 177, 0, 700000), -- Adena
(20474, 216, 1, 1, 1, 328.91945), -- Dirk
(20474, 2009, 1, 1, 1, 2426.08055), -- Dirk Blade
(20474, 1869, 1, 1, 2, 22805.004222), -- Iron Ore
(20474, 1870, 1, 1, 2, 22805.004222), -- Coal
(20474, 1871, 1, 1, 2, 22805.004222), -- Charcoal
(20474, 1872, 1, 1, 2, 30406.672296), -- Animal Bone
(20474, 1867, 1, 1, 2, 30406.672296), -- Animal Skin
(20474, 736, 1, 1, 2, 11402.642742), -- Scroll of Escape
-- Kasha Wolf
(20475, 426, 1, 1, -1, 68329), -- Tunic
(20475, 1786, 1, 1, -1, 30885), -- Recipe: Broad Sword
(20475, 1873, 1, 1, -1, 15442), -- Silver Nugget
(20475, 57, 19, 29, 0, 700000), -- Adena
(20475, 253, 1, 1, 1, 13530), -- Spiked Gloves
(20475, 1868, 1, 1, 2, 26608.75), -- Thread
(20475, 1873, 1, 1, 2, 5321.75), -- Silver Nugget
(20475, 1786, 1, 1, 2, 10643.5), -- Recipe: Broad Sword
-- Kasha Fang Spider
(20476, 1866, 1, 1, -1, 158377), -- Suede
(20476, 945, 1, 1, -1, 17997), -- Skeleton Buckler
(20476, 5549, 1, 1, -1, 23757), -- Metallic Thread
(20476, 57, 118, 183, 0, 700000), -- Adena
(20476, 2, 1, 1, 1, 66.798319), -- Long Sword
(20476, 120, 1, 1, 1, 66.798319), -- Sword of Reflection
(20476, 2012, 1, 1, 1, 730.605043), -- Sword of Reflection Blade
(20476, 121, 1, 1, 1, 66.798319), -- Sword of Watershadow
(20476, 1868, 1, 1, 2, 70173.35463), -- Thread
(20476, 1873, 1, 1, 2, 14034.690255), -- Silver Nugget
(20476, 1800, 1, 1, 2, 11033.57307), -- Recipe: Piece Bone Breastplate
(20476, 5273, 1, 1, 2, 1403.382045), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Kasha Timber Wolf
(20477, 1872, 1, 1, -1, 102628), -- Animal Bone
(20477, 906, 1, 1, -1, 18547), -- Necklace of Knowledge
(20477, 1060, 1, 1, -1, 171046), -- Lesser Healing Potion
(20477, 57, 41, 58, 0, 700000), -- Adena
(20477, 12, 1, 1, 1, 473.5), -- Knife
(20477, 215, 1, 1, 1, 473.5), -- Doom Dagger
(20477, 1866, 1, 1, 2, 7578.695835), -- Suede
(20477, 1871, 1, 1, 2, 11368.075533), -- Charcoal
(20477, 1796, 1, 1, 2, 14299.445292), -- Recipe: Leather Tunic
(20477, 1833, 1, 1, 2, 30314.78334), -- Bandage
-- Kasha Blade Spider
(20478, 1801, 1, 1, -1, 136366), -- Recipe: Piece Bone Gaiters
(20478, 735, 1, 1, -1, 22557), -- Alacrity Potion
(20478, 1897, 1, 1, -1, 64449), -- Necklace of Wisdom Chain
(20478, 57, 132, 212, 0, 700000), -- Adena
(20478, 217, 1, 1, 1, 152.5), -- Shining Knife
(20478, 218, 1, 1, 1, 152.5), -- Throwing Knife
(20478, 1869, 1, 1, 2, 26652.16661), -- Iron Ore
(20478, 1864, 1, 1, 2, 53304.33322), -- Stem
(20478, 1817, 1, 1, 2, 5330.390945), -- Recipe: Cord
(20478, 6037, 1, 1, 2, 53304.33322), -- Waking Scroll
(20478, 735, 1, 1, 2, 2220.97857), -- Alacrity Potion
(20478, 1831, 1, 1, 2, 71072.797435), -- Antidote
-- Kasha Bear
(20479, 1793, 1, 1, -1, 17199), -- Recipe: Sword of Reflection
(20479, 1922, 1, 1, -1, 59670), -- Leather Tunic Pattern
(20479, 1792, 1, 1, -1, 17199), -- Recipe: Short Spear
(20479, 57, 118, 179, 0, 700000), -- Adena
(20479, 9, 1, 1, 1, 221.432625), -- Cedar Staff
(20479, 2008, 1, 1, 1, 1792.13475), -- Cedar Staff Head
(20479, 154, 1, 1, 1, 221.432625), -- Dwarven Mace
(20479, 1872, 1, 1, 2, 46061.6742), -- Animal Bone
(20479, 1867, 1, 1, 2, 46061.6742), -- Animal Skin
(20479, 1792, 1, 1, 2, 2540.116413), -- Recipe: Short Spear
(20479, 1833, 1, 1, 2, 92123.535187), -- Bandage
-- Blade Bat
(20480, 1864, 1, 1, -1, 356778), -- Stem
(20480, 2007, 1, 1, -1, 12742), -- Bow Shaft
(20480, 2005, 1, 1, -1, 12742), -- Broadsword Blade
(20480, 57, 96, 130, 0, 700000), -- Adena
(20480, 22, 1, 1, 1, 5635.622124), -- Leather Shirt
(20480, 29, 1, 1, 1, 9007.377876), -- Leather Pants
(20480, 1864, 1, 1, 2, 70257.73112), -- Stem
(20480, 1869, 1, 1, 2, 35128.86556), -- Iron Ore
(20480, 1789, 1, 1, 2, 6493.40332), -- Recipe: Cedar Staff
-- Bearded Keltir
(20481, 1788, 1, 1, -1, 12736), -- Recipe: Bow
(20481, 1786, 1, 1, -1, 12736), -- Recipe: Broad Sword
(20481, 1868, 1, 1, -1, 31839), -- Thread
(20481, 57, 8, 12, 0, 700000), -- Adena
(20481, 426, 1, 1, 1, 14565.04902), -- Tunic
(20481, 462, 1, 1, 1, 23180.95098), -- Stockings
(20481, 1868, 1, 1, 2, 8229.25348), -- Thread
(20481, 1873, 1, 1, 2, 1645.8372), -- Silver Nugget
(20481, 1786, 1, 1, 2, 3291.70814), -- Recipe: Broad Sword
(20481, 17, 10, 30, 2, 20573.20118), -- Wooden Arrow
-- Corpse Candle
(20483, 1868, 1, 1, -1, 490926), -- Thread
(20483, 1833, 1, 1, -1, 654568), -- Bandage
(20483, 57, 120, 192, 0, 700000), -- Adena
(20483, 845, 1, 1, 1, 1060.046598), -- Cat's Eye Earring
(20483, 908, 1, 1, 1, 795.040987), -- Necklace of Wisdom
(20483, 1897, 1, 1, 1, 8631.842518), -- Necklace of Wisdom Chain
(20483, 877, 1, 1, 1, 1590.069897), -- Ring of Wisdom
(20483, 1864, 1, 1, 2, 41432.064125), -- Stem
(20483, 1865, 1, 1, 2, 20715.966738), -- Varnish
(20483, 1866, 1, 1, 2, 13810.644492), -- Suede
(20483, 1873, 1, 1, 2, 8286.412825), -- Silver Nugget
(20483, 1868, 1, 1, 2, 41432.064125), -- Thread
(20483, 2139, 1, 1, 2, 4143.141088), -- Recipe: Steel Mold
(20483, 5268, 1, 1, 2, 828.706607), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Kuruka Ratman
(20487, 2136, 1, 1, -1, 58227), -- Recipe: Cokes
(20487, 1060, 1, 1, -1, 439936), -- Lesser Healing Potion
(20487, 1897, 1, 1, -1, 47136), -- Necklace of Wisdom Chain
(20487, 57, 98, 153, 0, 700000), -- Adena
(20487, 217, 1, 1, 1, 111.5), -- Shining Knife
(20487, 218, 1, 1, 1, 111.5), -- Throwing Knife
(20487, 1870, 1, 1, 2, 38985.22495), -- Coal
(20487, 1865, 1, 1, 2, 38985.22495), -- Varnish
(20487, 1800, 1, 1, 2, 12259.5501), -- Recipe: Piece Bone Breastplate
-- Kuruka Ratman Hunter
(20488, 734, 1, 1, -1, 34178), -- Haste Potion
(20488, 412, 1, 1, -1, 4198), -- Cotton Pants
(20488, 1800, 1, 1, -1, 64486), -- Recipe: Piece Bone Breastplate
(20488, 57, 100, 161, 0, 700000), -- Adena
(20488, 256, 1, 1, 1, 231), -- Cestus
(20488, 1869, 1, 1, 2, 40382.1875), -- Iron Ore
(20488, 1864, 1, 1, 2, 80764.375), -- Stem
(20488, 2140, 1, 1, 2, 8076.4375), -- Recipe: High-Grade Suede
-- Quicksilver Beast
(20489, 1060, 1, 1, -1, 433160), -- Lesser Healing Potion
(20489, 1872, 1, 1, -1, 259896), -- Animal Bone
(20489, 1896, 1, 1, -1, 82594), -- Necklace of Anguish Chain
(20489, 57, 98, 149, 0, 700000), -- Adena
(20489, 429, 1, 1, 1, 940.78425), -- Leather Tunic
(20489, 1922, 1, 1, 1, 7343.79532), -- Leather Tunic Pattern
(20489, 464, 1, 1, 1, 1507.1979), -- Leather Stockings
(20489, 1923, 1, 1, 1, 11798.22253), -- Leather Stockings Pattern
(20489, 1868, 1, 1, 2, 76769.632706), -- Thread
(20489, 1873, 1, 1, 2, 15353.907552), -- Silver Nugget
(20489, 1793, 1, 1, 2, 2822.459742), -- Recipe: Sword of Reflection
-- Crypt Horror
(20491, 1794, 1, 1, -1, 14476), -- Recipe: Forest Bow
(20491, 876, 1, 1, -1, 21875), -- Ring of Anguish
(20491, 1803, 1, 1, -1, 165438), -- Recipe: Necklace of Wisdom
(20491, 57, 99, 150, 0, 700000), -- Adena
(20491, 37, 1, 1, 1, 3800.868174), -- Leather Shoes
(20491, 1921, 1, 1, 1, 25012.231038), -- Leather Shoes Texture
(20491, 49, 1, 1, 1, 3800.900788), -- Gloves
(20491, 1866, 1, 1, 2, 25845.774035), -- Suede
(20491, 1871, 1, 1, 2, 38768.62732), -- Charcoal
(20491, 1794, 1, 1, 2, 2850.598645), -- Recipe: Forest Bow
-- Kirunak's Guards
(20492, 1879, 1, 1, -1, 47461), -- Cokes
(20492, 25, 1, 1, -1, 2327), -- Piece Bone Breastplate
(20492, 1865, 1, 1, -1, 284768), -- Varnish
(20492, 57, 130, 231, 0, 700000), -- Adena
(20492, 27, 1, 1, 1, 296.171659), -- Hard Leather Shirt
(20492, 1927, 1, 1, 1, 3355.070918), -- Hard Leather Shirt Pattern
(20492, 33, 1, 1, 1, 475.204432), -- Hard Leather Gaiters
(20492, 1929, 1, 1, 1, 5426.552991), -- Hard Leather Gaiters Material
(20492, 1865, 1, 1, 2, 33646.376214), -- Varnish
(20492, 1870, 1, 1, 2, 33646.376214), -- Coal
(20492, 1879, 1, 1, 2, 5607.729369), -- Cokes
(20492, 5278, 1, 1, 2, 1345.837032), -- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
(20492, 5437, 1, 1, 2, 822.681171), -- Recipe: Heavy Sword(100%)
-- Turek War Hound
(20494, 1881, 1, 1, -1, 99048), -- Coarse Bone Powder
(20494, 2179, 1, 1, -1, 355437), -- Recipe: Crafted Leather Gloves
(20494, 1804, 1, 1, -1, 29714), -- Recipe: Soulshot (D-Grade)
(20494, 57, 330, 609, 0, 700000), -- Adena
(20494, 257, 1, 1, 1, 467), -- Viper Fang
(20494, 1871, 1, 1, 2, 87772.020798), -- Charcoal
(20494, 1866, 1, 1, 2, 58514.733618), -- Suede
(20494, 2258, 1, 1, 2, 2146.00155), -- Recipe: Temptation of Abyss
(20494, 5268, 1, 1, 2, 3510.84261), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20494, 735, 1, 1, 2, 7314.401424), -- Alacrity Potion
-- Turek Orc Warlord
(20495, 2267, 1, 1, -1, 11668), -- Recipe: Gastraphetes
(20495, 1936, 1, 1, -1, 92328), -- White Tunic Pattern
(20495, 1900, 1, 1, -1, 123441), -- Enchanted Necklace Chain
(20495, 57, 476, 952, 0, 700000), -- Adena
(20495, 69, 1, 1, 1, 49.770308), -- Bastard Sword
(20495, 125, 1, 1, 1, 49.770308), -- Spinebone Sword
(20495, 2021, 1, 1, 1, 1556.915256), -- Spinebone Sword Blade
(20495, 126, 1, 1, 1, 49.770308), -- Artisan's Sword
(20495, 128, 1, 1, 1, 49.77382), -- Knight's Sword
(20495, 1875, 1, 1, 2, 4566.991248), -- Stone of Purity
(20495, 1879, 1, 1, 2, 11417.438544), -- Cokes
(20495, 1885, 1, 1, 2, 5708.679696), -- High-Grade Suede
(20495, 5550, 1, 1, 2, 913.41408), -- Durable Metal Plate
(20495, 5549, 1, 1, 2, 6850.447296), -- Metallic Thread
(20495, 955, 1, 1, 2, 274.024224), -- Scroll: Enchant Weapon (D-Grade)
(20495, 2274, 1, 1, 2, 489.317664), -- Recipe: Skull Breaker
(20495, 2975, 1, 1, 2, 6116.4708), -- Recipe: Brigandine Helmet
(20495, 6667, 1, 1, 2, 42815.216448), -- Deluxe Chest Key - Grade 3
-- Turek Orc Archer
(20496, 1885, 1, 1, -1, 74420), -- High-Grade Suede
(20496, 465, 1, 1, -1, 5934), -- Cursed Stockings
(20496, 2152, 1, 1, -1, 157224), -- Recipe: Enchanted Necklace
(20496, 57, 386, 743, 0, 700000), -- Adena
(20496, 274, 1, 1, 1, 318), -- Reinforced Bow
(20496, 1876, 1, 1, 2, 14319.932005), -- Mithril Ore
(20496, 1880, 1, 1, 2, 7160.027259), -- Steel
(20496, 1877, 1, 1, 2, 2863.986401), -- Adamantite Nugget
(20496, 1881, 1, 1, 2, 9546.580499), -- Coarse Bone Powder
(20496, 1882, 1, 1, 2, 15911.008336), -- Leather
(20496, 2260, 1, 1, 2, 1111.805475), -- Recipe: Mace of Judgment
(20496, 6666, 1, 1, 2, 71599.660025), -- Deluxe Chest Key - Grade 2
-- Turek Orc Skirmisher
(20497, 2259, 1, 1, -1, 14293), -- Recipe: Spinebone Sword
(20497, 2018, 1, 1, -1, 12232), -- Assassin Knife Edge
(20497, 1899, 1, 1, -1, 143825), -- Necklace of Devotion Chain
(20497, 57, 395, 773, 0, 700000), -- Adena
(20497, 391, 1, 1, 1, 1071.760172), -- Puma Skin Shirt
(20497, 413, 1, 1, 1, 1716.239828), -- Puma Skin Gaiters
(20497, 1874, 1, 1, 2, 5740.05696), -- Oriharukon Ore
(20497, 1878, 1, 1, 2, 34440.134388), -- Braided Hemp
(20497, 1884, 1, 1, 2, 52984.790232), -- Cord
(20497, 1889, 1, 1, 2, 5740.05696), -- Compound Braid
(20497, 5220, 1, 1, 2, 3444.034176), -- Metal Hardener
(20497, 2261, 1, 1, 2, 1336.927284), -- Recipe: Conjuror's Staff
-- Turek Orc Supplier
(20498, 2262, 1, 1, -1, 13331), -- Recipe: Elven Bow
(20498, 3953, 1, 1, -1, 34341), -- Recipe: Blessed Spiritshot D
(20498, 1885, 1, 1, -1, 71544), -- High-Grade Suede
(20498, 57, 371, 714, 0, 700000), -- Adena
(20498, 626, 1, 1, 1, 1900.693228), -- Bronze Shield
(20498, 45, 1, 1, 1, 1332.846619), -- Bone Helmet
(20498, 1932, 1, 1, 1, 25493.460153), -- Bone Helmet Design
(20498, 1875, 1, 1, 2, 5353.64103), -- Stone of Purity
(20498, 1879, 1, 1, 2, 13384.120464), -- Cokes
(20498, 1885, 1, 1, 2, 6692.060232), -- High-Grade Suede
(20498, 5550, 1, 1, 2, 1070.728206), -- Durable Metal Plate
(20498, 5549, 1, 1, 2, 8030.479434), -- Metallic Thread
(20498, 2261, 1, 1, 2, 1246.970634), -- Recipe: Conjuror's Staff
-- Turek Orc Footman
(20499, 1870, 1, 1, -1, 822258), -- Coal
(20499, 2017, 1, 1, -1, 10927), -- Saber Blade
(20499, 1880, 1, 1, -1, 82226), -- Steel
(20499, 57, 357, 682, 0, 700000), -- Adena
(20499, 40, 1, 1, 1, 1433.150976), -- Leather Boots
(20499, 1931, 1, 1, 1, 15080.849024), -- Leather Boots Lining
(20499, 604, 1, 1, 1, 1433.150976), -- Crafted Leather Gloves
(20499, 1934, 1, 1, 1, 15080.849024), -- Crafted Leather Gloves Lining
(20499, 1876, 1, 1, 2, 15382.46241), -- Mithril Ore
(20499, 1880, 1, 1, 2, 7691.26257), -- Steel
(20499, 1877, 1, 1, 2, 3076.46739), -- Adamantite Nugget
(20499, 1881, 1, 1, 2, 10254.97494), -- Coarse Bone Powder
(20499, 1882, 1, 1, 2, 17091.66672), -- Leather
(20499, 2182, 1, 1, 2, 9233.16597), -- Recipe: Scale Gaiters
-- Turek Orc Sentinel
(20500, 1867, 1, 3, -1, 520412), -- Animal Skin
(20500, 1932, 1, 1, -1, 123908), -- Bone Helmet Design
(20500, 1931, 1, 1, -1, 102042), -- Leather Boots Lining
(20500, 57, 344, 644, 0, 700000), -- Adena
(20500, 847, 1, 1, 1, 1058.232864), -- Red Crescent Earring
(20500, 910, 1, 1, 1, 793.674648), -- Necklace of Devotion
(20500, 1899, 1, 1, 1, 17113.722639), -- Necklace of Devotion Chain
(20500, 890, 1, 1, 1, 1587.369849), -- Ring of Devotion
(20500, 1874, 1, 1, 2, 7301.729204), -- Oriharukon Ore
(20500, 1878, 1, 1, 2, 43810.489612), -- Braided Hemp
(20500, 5220, 1, 1, 2, 4381.0604), -- Metal Hardener
(20500, 2262, 1, 1, 2, 1700.720784), -- Recipe: Elven Bow
-- Turek Orc Shaman
(20501, 1870, 1, 1, -1, 944489), -- Coal
(20501, 1933, 1, 1, -1, 111116), -- Dark Stockings Fabric
(20501, 2153, 1, 1, -1, 146888), -- Recipe: Tiger's Eye Earring
(20501, 57, 400, 793, 0, 700000), -- Adena
(20501, 433, 1, 1, 1, 167.79194), -- Elven Tunic
(20501, 434, 1, 1, 1, 167.79194), -- White Tunic
(20501, 1936, 1, 1, 1, 5279.73866), -- White Tunic Pattern
(20501, 435, 1, 1, 1, 167.79194), -- Mystic's Tunic
(20501, 466, 1, 1, 1, 268.82444), -- Elven Stockings
(20501, 467, 1, 1, 1, 268.82444), -- Dark Stockings
(20501, 1933, 1, 1, 1, 7590.39802), -- Dark Stockings Fabric
(20501, 468, 1, 1, 1, 268.83862), -- Mystic's Stockings
(20501, 1875, 1, 1, 2, 4915.479114), -- Stone of Purity
(20501, 1879, 1, 1, 2, 12288.714282), -- Cokes
(20501, 1885, 1, 1, 2, 6144.340644), -- High-Grade Suede
(20501, 5550, 1, 1, 2, 983.089224), -- Durable Metal Plate
(20501, 5549, 1, 1, 2, 7373.235168), -- Metallic Thread
(20501, 2264, 1, 1, 2, 762.49134), -- Recipe: Two-handed Sword
(20501, 2274, 1, 1, 2, 526.650228), -- Recipe: Skull Breaker
-- Twink Puma
(20502, 1871, 1, 1, -1, 233906), -- Charcoal
(20502, 1896, 1, 1, -1, 99113), -- Necklace of Anguish Chain
(20502, 1923, 1, 1, -1, 95863), -- Leather Stockings Pattern
(20502, 57, 118, 179, 0, 700000), -- Adena
(20502, 23, 1, 1, 1, 1505.165424), -- Wooden Breastplate
(20502, 30, 1, 1, 1, 2411.417288), -- Hard Leather Pants
(20502, 2386, 1, 1, 1, 2411.417288), -- Wooden Gaiters
(20502, 1868, 1, 1, 2, 92122.987782), -- Thread
(20502, 1873, 1, 1, 2, 18424.535274), -- Silver Nugget
(20502, 1798, 1, 1, 2, 45158.476944), -- Recipe: Leather Helmet
-- Dread Soldier
(20504, 2010, 1, 1, -1, 7372), -- Brandish Blade
(20504, 1792, 1, 1, -1, 13930), -- Recipe: Short Spear
(20504, 1921, 1, 1, -1, 122225), -- Leather Shoes Texture
(20504, 57, 97, 143, 0, 700000), -- Adena
(20504, 20, 1, 1, 1, 5229.661794), -- Buckler
(20504, 43, 1, 1, 1, 3657.338206), -- Wooden Helmet
(20504, 1870, 1, 1, 2, 37306.96039), -- Coal
(20504, 1865, 1, 1, 2, 37306.96039), -- Varnish
(20504, 1792, 1, 1, 2, 2743.07922), -- Recipe: Short Spear
-- Ruin Bat
(20505, 734, 1, 1, -1, 45036), -- Haste Potion
(20505, 1800, 1, 1, -1, 84973), -- Recipe: Piece Bone Breastplate
(20505, 1869, 1, 1, -1, 270215), -- Iron Ore
(20505, 57, 125, 217, 0, 700000), -- Adena
(20505, 217, 1, 1, 1, 152), -- Shining Knife
(20505, 218, 1, 1, 1, 152), -- Throwing Knife
(20505, 1864, 1, 1, 2, 63853.898514), -- Stem
(20505, 1869, 1, 1, 2, 31926.89115), -- Iron Ore
(20505, 1878, 1, 1, 2, 12770.75646), -- Braided Hemp
(20505, 1817, 1, 1, 2, 6385.37823), -- Recipe: Cord
(20505, 5273, 1, 1, 2, 1277.075646), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Ruin Imp
(20506, 2150, 1, 1, -1, 115530), -- Recipe: Blue Diamond Necklace
(20506, 1924, 1, 1, -1, 79380), -- Leather Helmet Design
(20506, 1864, 1, 1, -1, 492156), -- Stem
(20506, 57, 120, 193, 0, 700000), -- Adena
(20506, 24, 1, 1, 1, 465.971), -- Bone Breastplate
(20506, 390, 1, 1, 1, 465.971), -- Cotton Shirt
(20506, 31, 1, 1, 1, 744.029), -- Bone Gaiters
(20506, 412, 1, 1, 1, 744.029), -- Cotton Pants
(20506, 1864, 1, 1, 2, 72687.660136), -- Stem
(20506, 1869, 1, 1, 2, 36343.830068), -- Iron Ore
(20506, 2141, 1, 1, 2, 7268.718912), -- Recipe: Silver Mold
(20506, 5273, 1, 1, 2, 1453.790884), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Ruin Imp Elder
(20507, 3032, 1, 1, -1, 13942), -- Recipe: Spiritshot D
(20507, 1866, 1, 1, -1, 232371), -- Suede
(20507, 1898, 1, 1, -1, 35804), -- Blue Diamond Necklace Gem
(20507, 57, 159, 283, 0, 700000), -- Adena
(20507, 273, 1, 1, 1, 109.525416), -- Composite Bow
(20507, 2016, 1, 1, 1, 1206.474584), -- Composite Bow Shaft
(20507, 1864, 1, 1, 2, 82366.143021), -- Stem
(20507, 1869, 1, 1, 2, 41182.999852), -- Iron Ore
(20507, 1878, 1, 1, 2, 16473.285931), -- Braided Hemp
(20507, 1804, 1, 1, 2, 1647.285598), -- Recipe: Soulshot (D-Grade)
(20507, 5273, 1, 1, 2, 1647.285598), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
-- Plunder Tarantula
(20508, 1866, 1, 1, -1, 167333), -- Suede
(20508, 1800, 1, 1, -1, 78931), -- Recipe: Piece Bone Breastplate
(20508, 57, 122, 197, 0, 700000), -- Adena
(20508, 1101, 1, 1, 1, 950.429268), -- Tunic of Devotion
(20508, 1104, 1, 1, 1, 1517.570732), -- Stockings of Devotion
(20508, 1867, 1, 1, 2, 65903.681388), -- Animal Skin
(20508, 1872, 1, 1, 2, 65903.681388), -- Animal Bone
(20508, 2142, 1, 1, 2, 9885.637224), -- Recipe: Varnish of Purity
-- Spore Fungus
(20509, 1060, 1, 1, -1, 330759), -- Lesser Healing Potion
(20509, 1129, 1, 1, -1, 63337), -- Crude Leather Shoes
(20509, 2005, 1, 1, -1, 10632), -- Broadsword Blade
(20509, 57, 80, 108, 0, 700000), -- Adena
(20509, 428, 1, 1, 1, 2351.158612), -- Feriotic Tunic
(20509, 1100, 1, 1, 1, 2351.158612), -- Cotton Tunic
(20509, 463, 1, 1, 1, 3757.841388), -- Feriotic Stockings
(20509, 1103, 1, 1, 1, 3757.841388), -- Cotton Stockings
(20509, 1864, 1, 1, 2, 43965.66228), -- Stem
(20509, 1869, 1, 1, 2, 21982.739976), -- Iron Ore
(20509, 2136, 1, 1, 2, 6465.533208), -- Recipe: Cokes
(20509, 17, 10, 30, 2, 109914.064536), -- Wooden Arrow
-- Puma
(20510, 1798, 1, 1, -1, 202966), -- Recipe: Leather Helmet
(20510, 1923, 1, 1, -1, 84846), -- Leather Stockings Pattern
(20510, 1792, 1, 1, -1, 15222), -- Recipe: Short Spear
(20510, 57, 110, 152, 0, 700000), -- Adena
(20510, 23, 1, 1, 1, 1332.242658), -- Wooden Breastplate
(20510, 30, 1, 1, 1, 2134.378671), -- Hard Leather Pants
(20510, 2386, 1, 1, 1, 2134.378671), -- Wooden Gaiters
(20510, 1868, 1, 1, 2, 81536.099801), -- Thread
(20510, 1873, 1, 1, 2, 16307.199792), -- Silver Nugget
(20510, 1792, 1, 1, 2, 2997.700407), -- Recipe: Short Spear
-- Pitchstone Golem
(20511, 734, 1, 1, -1, 40780), -- Haste Potion
(20511, 2144, 1, 1, -1, 48936), -- Recipe: Compound Braid
(20511, 1897, 1, 1, -1, 58257), -- Necklace of Wisdom Chain
(20511, 57, 115, 195, 0, 700000), -- Adena
(20511, 176, 1, 1, 1, 137.5), -- Apprentice's Staff
(20511, 2501, 1, 1, 1, 137.5), -- Bone Club
(20511, 1869, 1, 1, 2, 20649.965745), -- Iron Ore
(20511, 1870, 1, 1, 2, 20649.965745), -- Coal
(20511, 1871, 1, 1, 2, 20649.965745), -- Charcoal
(20511, 1872, 1, 1, 2, 27533.28766), -- Animal Bone
(20511, 1867, 1, 1, 2, 27533.28766), -- Animal Skin
(20511, 1800, 1, 1, 2, 6493.728274), -- Recipe: Piece Bone Breastplate
(20511, 735, 1, 1, 2, 1720.799171), -- Alacrity Potion
-- Shield Skeleton
(20514, 1872, 1, 1, -1, 308818), -- Animal Bone
(20514, 1870, 1, 1, -1, 231613), -- Coal
(20514, 57, 116, 177, 0, 700000), -- Adena
(20514, 20, 1, 1, 1, 6393.63963), -- Buckler
(20514, 43, 1, 1, 1, 4471.36037), -- Wooden Helmet
(20514, 1870, 1, 1, 2, 34207.532928), -- Coal
(20514, 1865, 1, 1, 2, 34207.532928), -- Varnish
(20514, 1799, 1, 1, 2, 50677.720254), -- Recipe: Leather Gloves
(20514, 734, 1, 1, 2, 5701.21389), -- Haste Potion
-- Skeleton Infantryman
(20515, 735, 1, 1, -1, 19797), -- Alacrity Potion
(20515, 2013, 1, 1, -1, 5127), -- Forest Bow Shaft
(20515, 1865, 1, 1, -1, 237565), -- Varnish
(20515, 57, 118, 183, 0, 700000), -- Adena
(20515, 15, 1, 1, 1, 133.700835), -- Short Spear
(20515, 2011, 1, 1, 1, 1601.299165), -- Short Spear Edge
(20515, 1870, 1, 1, 2, 35086.782348), -- Coal
(20515, 1865, 1, 1, 2, 35086.782348), -- Varnish
(20515, 1801, 1, 1, 2, 17675.931879), -- Recipe: Piece Bone Gaiters
(20515, 5158, 1, 1, 2, 1403.503425), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Skeleton Hunter
(20517, 1831, 1, 1, -1, 473949), -- Antidote
(20517, 1921, 1, 1, -1, 114665), -- Leather Shoes Texture
(20517, 1869, 1, 1, -1, 177731), -- Iron Ore
(20517, 57, 95, 131, 0, 700000), -- Adena
(20517, 271, 1, 1, 1, 505), -- Hunting Bow
(20517, 1869, 1, 1, 2, 26249.44017), -- Iron Ore
(20517, 1864, 1, 1, 2, 52498.88034), -- Stem
(20517, 1793, 1, 1, 2, 1930.17237), -- Recipe: Sword of Reflection
(20517, 1833, 1, 1, 2, 69998.50712), -- Bandage
-- Skeleton Hunter Archer
(20518, 1866, 1, 1, -1, 123105), -- Suede
(20518, 1864, 1, 1, -1, 369315), -- Stem
(20518, 1831, 1, 1, -1, 492420), -- Antidote
(20518, 57, 97, 137, 0, 700000), -- Adena
(20518, 271, 1, 1, 1, 524), -- Hunting Bow
(20518, 1870, 1, 1, 2, 36363.249932), -- Coal
(20518, 1865, 1, 1, 2, 36363.249932), -- Varnish
(20518, 1799, 1, 1, 2, 53871.500136), -- Recipe: Leather Gloves
-- Whinstone Golem
(20521, 2143, 1, 1, -1, 50113), -- Recipe: Synthetic Cokes
(20521, 1897, 1, 1, -1, 59658), -- Necklace of Wisdom Chain
(20521, 1896, 1, 1, -1, 106171), -- Necklace of Anguish Chain
(20521, 57, 128, 189, 0, 700000), -- Adena
(20521, 9, 1, 1, 1, 237.18555), -- Cedar Staff
(20521, 2008, 1, 1, 1, 1919.6289), -- Cedar Staff Head
(20521, 154, 1, 1, 1, 237.18555), -- Dwarven Mace
(20521, 1866, 1, 1, 2, 24670.861524), -- Suede
(20521, 1871, 1, 1, 2, 37006.362852), -- Charcoal
(20521, 1793, 1, 1, 2, 2721.02496), -- Recipe: Sword of Reflection
(20521, 734, 1, 1, 2, 6167.750664), -- Haste Potion
-- Gray Wolf
(20525, 1867, 1, 1, -1, 51475), -- Animal Skin
(20525, 1872, 1, 1, -1, 51475), -- Animal Bone
(20525, 5549, 1, 1, -1, 3861), -- Metallic Thread
(20525, 57, 19, 29, 0, 700000), -- Adena
(20525, 1, 1, 1, 1, 13530), -- Short Sword
(20525, 1868, 1, 1, 2, 19956.368608), -- Thread
(20525, 1873, 1, 1, 2, 3991.25208), -- Silver Nugget
(20525, 1787, 1, 1, 2, 7982.558264), -- Recipe: Willow Staff
(20525, 1060, 1, 1, 2, 22173.821048), -- Lesser Healing Potion
-- Obsidian Golem
(20526, 1833, 1, 1, -1, 694345), -- Bandage
(20526, 1921, 1, 1, -1, 167987), -- Leather Shoes Texture
(20526, 5220, 1, 1, -1, 10415), -- Metal Hardener
(20526, 57, 131, 199, 0, 700000), -- Adena
(20526, 114, 1, 1, 1, 2278.848137), -- Earring of Strength
(20526, 115, 1, 1, 1, 2278.848137), -- Earring of Wisdom
(20526, 907, 1, 1, 1, 1709.141783), -- Necklace of Anguish
(20526, 1896, 1, 1, 1, 13035.855656), -- Necklace of Anguish Chain
(20526, 876, 1, 1, 1, 3418.306287), -- Ring of Anguish
(20526, 1866, 1, 1, 2, 34183.209412), -- Suede
(20526, 1871, 1, 1, 2, 51274.814118), -- Charcoal
(20526, 1803, 1, 1, 2, 43087.97647), -- Recipe: Necklace of Wisdom
-- Goblin Lord
(20528, 1833, 1, 1, -1, 568013), -- Bandage
(20528, 1922, 1, 1, -1, 54338), -- Leather Tunic Pattern
(20528, 57, 112, 158, 0, 700000), -- Adena
(20528, 216, 1, 1, 1, 302.53426), -- Dirk
(20528, 2009, 1, 1, 1, 2231.46574), -- Dirk Blade
(20528, 1865, 1, 1, 2, 41945.73894), -- Varnish
(20528, 1870, 1, 1, 2, 41945.73894), -- Coal
(20528, 1803, 1, 1, 2, 35248.52212), -- Recipe: Necklace of Wisdom
-- Young Brown Keltir
(20529, 1867, 1, 1, -1, 21226), -- Animal Skin
(20529, 1121, 1, 1, -1, 636783), -- Apprentice's Shoes
(20529, 1786, 1, 1, -1, 12736), -- Recipe: Broad Sword
(20529, 57, 8, 12, 0, 700000), -- Adena
(20529, 1121, 1, 1, 1, 164584.052902), -- Apprentice's Shoes
(20529, 35, 1, 1, 1, 29389.982366), -- Cloth Shoes
(20529, 36, 1, 1, 1, 29389.982366), -- Leather Sandals
(20529, 48, 1, 1, 1, 29389.982366), -- Short Gloves
(20529, 1868, 1, 1, 2, 10972.5), -- Thread
(20529, 1873, 1, 1, 2, 2194.5), -- Silver Nugget
(20529, 1788, 1, 1, 2, 4389), -- Recipe: Bow
-- Young Red Keltir
(20530, 1867, 1, 1, -1, 21226), -- Animal Skin
(20530, 1787, 1, 1, -1, 12736), -- Recipe: Willow Staff
(20530, 1868, 1, 1, -1, 31839), -- Thread
(20530, 57, 8, 12, 0, 700000), -- Adena
(20530, 426, 1, 1, 1, 14565.04902), -- Tunic
(20530, 462, 1, 1, 1, 23180.95098), -- Stockings
(20530, 1868, 1, 1, 2, 8229.08812), -- Thread
(20530, 1873, 1, 1, 2, 1645.8087), -- Silver Nugget
(20530, 1786, 1, 1, 2, 3291.63971), -- Recipe: Broad Sword
(20530, 1060, 1, 1, 2, 9143.46347), -- Lesser Healing Potion
-- Young Prairie Keltir
(20531, 1872, 1, 1, -1, 21226), -- Animal Bone
(20531, 1873, 1, 1, -1, 6368), -- Silver Nugget
(20531, 1788, 1, 1, -1, 12736), -- Recipe: Bow
(20531, 57, 8, 12, 0, 700000), -- Adena
(20531, 426, 1, 1, 1, 14565.04902), -- Tunic
(20531, 462, 1, 1, 1, 23180.95098), -- Stockings
(20531, 1868, 1, 1, 2, 10972.5), -- Thread
(20531, 1873, 1, 1, 2, 2194.5), -- Silver Nugget
(20531, 1787, 1, 1, 2, 4389), -- Recipe: Willow Staff
-- Brown Keltir
(20532, 1787, 1, 1, -1, 14332), -- Recipe: Willow Staff
(20532, 35, 1, 1, -1, 127969), -- Cloth Shoes
(20532, 1786, 1, 1, -1, 14332), -- Recipe: Broad Sword
(20532, 57, 8, 13, 0, 700000), -- Adena
(20532, 18, 1, 1, 1, 61739.96472), -- Leather Shield
(20532, 41, 1, 1, 1, 44100.03528), -- Cloth Cap
(20532, 1868, 1, 1, 2, 12348.125), -- Thread
(20532, 1873, 1, 1, 2, 2469.625), -- Silver Nugget
(20532, 1786, 1, 1, 2, 4939.25), -- Recipe: Broad Sword
-- Longtail Keltir
(20533, 1872, 1, 1, -1, 23887), -- Animal Bone
(20533, 5549, 1, 1, -1, 1792), -- Metallic Thread
(20533, 57, 8, 13, 0, 700000), -- Adena
(20533, 13, 1, 1, 1, 6279), -- Short Bow
(20533, 1868, 1, 1, 2, 9261.136016), -- Thread
(20533, 1873, 1, 1, 2, 1852.21716), -- Silver Nugget
(20533, 1787, 1, 1, 2, 3704.459428), -- Recipe: Willow Staff
(20533, 1060, 1, 1, 2, 10290.187396), -- Lesser Healing Potion
-- Red Keltir
(20534, 1786, 1, 1, -1, 14332), -- Recipe: Broad Sword
(20534, 1868, 1, 1, -1, 35831), -- Thread
(20534, 57, 8, 13, 0, 700000), -- Adena
(20534, 21, 1, 1, 1, 16390.98586), -- Shirt
(20534, 28, 1, 1, 1, 26087.01414), -- Pants
(20534, 1868, 1, 1, 2, 12348.125), -- Thread
(20534, 1873, 1, 1, 2, 2469.625), -- Silver Nugget
(20534, 1788, 1, 1, 2, 4939.25), -- Recipe: Bow
-- Prairie Keltir
(20535, 1867, 1, 1, -1, 23887), -- Animal Skin
(20535, 36, 1, 1, -1, 127969), -- Leather Sandals
(20535, 1787, 1, 1, -1, 14332), -- Recipe: Willow Staff
(20535, 57, 8, 13, 0, 700000), -- Adena
(20535, 21, 1, 1, 1, 16390.98586), -- Shirt
(20535, 28, 1, 1, 1, 26087.01414), -- Pants
(20535, 1870, 1, 1, 2, 4630.50819), -- Coal
(20535, 1865, 1, 1, 2, 4630.50819), -- Varnish
(20535, 1786, 1, 1, 2, 3704.406552), -- Recipe: Broad Sword
(20535, 17, 10, 30, 2, 23152.577068), -- Wooden Arrow
-- Elder Brown Keltir
(20536, 1871, 1, 1, -1, 27106), -- Charcoal
(20536, 18, 1, 1, -1, 180709), -- Leather Shield
(20536, 1788, 1, 1, -1, 21685), -- Recipe: Bow
(20536, 57, 13, 20, 0, 700000), -- Adena
(20536, 13, 1, 1, 1, 9500), -- Short Bow
(20536, 1869, 1, 1, 2, 9341.319526), -- Iron Ore
(20536, 1864, 1, 1, 2, 18682.639052), -- Stem
(20536, 1787, 1, 1, 2, 7473.041422), -- Recipe: Willow Staff
-- Elder Red Keltir
(20537, 1788, 1, 1, -1, 21685), -- Recipe: Bow
(20537, 1867, 1, 1, -1, 36142), -- Animal Skin
(20537, 1864, 1, 1, -1, 54213), -- Stem
(20537, 57, 13, 20, 0, 700000), -- Adena
(20537, 308, 1, 1, 1, 9500), -- Buffalo's Horn
(20537, 1869, 1, 1, 2, 7005.899932), -- Iron Ore
(20537, 1864, 1, 1, 2, 14011.757673), -- Stem
(20537, 1788, 1, 1, 2, 5604.694631), -- Recipe: Bow
(20537, 1060, 1, 1, 2, 15568.647764), -- Lesser Healing Potion
-- Elder Prairie Keltir
(20538, 1865, 1, 1, -1, 27106), -- Varnish
(20538, 1786, 1, 1, -1, 21685), -- Recipe: Broad Sword
(20538, 1869, 1, 1, -1, 27106), -- Iron Ore
(20538, 57, 13, 20, 0, 700000), -- Adena
(20538, 1, 1, 1, 1, 9500), -- Short Sword
(20538, 1869, 1, 1, 2, 9341.319526), -- Iron Ore
(20538, 1864, 1, 1, 2, 18682.639052), -- Stem
(20538, 1786, 1, 1, 2, 7473.041422), -- Recipe: Broad Sword
-- Elder Longtail Keltir
(20539, 41, 1, 1, -1, 129078), -- Cloth Cap
(20539, 1786, 1, 1, -1, 21685), -- Recipe: Broad Sword
(20539, 1787, 1, 1, -1, 21685), -- Recipe: Willow Staff
(20539, 57, 13, 20, 0, 700000), -- Adena
(20539, 253, 1, 1, 1, 9500), -- Spiked Gloves
(20539, 1869, 1, 1, 2, 7006.000308), -- Iron Ore
(20539, 1864, 1, 1, 2, 14012.062269), -- Stem
(20539, 1787, 1, 1, 2, 5604.812577), -- Recipe: Willow Staff
(20539, 17, 10, 30, 2, 35030.124846), -- Wooden Arrow
-- Gemstone Beast
(20540, 1873, 1, 1, -1, 69008), -- Silver Nugget
(20540, 1831, 1, 1, -1, 460056), -- Antidote
(20540, 1896, 1, 1, -1, 73102), -- Necklace of Anguish Chain
(20540, 57, 92, 127, 0, 700000), -- Adena
(20540, 23, 1, 1, 1, 1110.321144), -- Wooden Breastplate
(20540, 30, 1, 1, 1, 1778.839428), -- Hard Leather Pants
(20540, 2386, 1, 1, 1, 1778.839428), -- Wooden Gaiters
(20540, 1873, 1, 1, 2, 13589.375913), -- Silver Nugget
(20540, 1868, 1, 1, 2, 67946.879565), -- Thread
(20540, 736, 1, 1, 2, 16986.744522), -- Scroll of Escape
-- Ore Bat
(20541, 2173, 1, 1, -1, 55023), -- Recipe: Hard Leather Shirt
(20541, 1925, 1, 1, -1, 133138), -- Leather Gloves Lining
(20541, 1897, 1, 1, -1, 48342), -- Necklace of Wisdom Chain
(20541, 57, 99, 159, 0, 700000), -- Adena
(20541, 272, 1, 1, 1, 114.2699), -- Forest Bow
(20541, 2013, 1, 1, 1, 1294.7301), -- Forest Bow Shaft
(20541, 1864, 1, 1, 2, 29986.73072), -- Stem
(20541, 1865, 1, 1, 2, 14993.36536), -- Varnish
(20541, 1866, 1, 1, 2, 9995.609259), -- Suede
(20541, 1873, 1, 1, 2, 5997.346144), -- Silver Nugget
(20541, 1868, 1, 1, 2, 29986.73072), -- Thread
(20541, 2143, 1, 1, 2, 2998.673072), -- Recipe: Synthetic Cokes
(20541, 5158, 1, 1, 2, 599.715203), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20541, 734, 1, 1, 2, 2498.829522), -- Haste Potion
-- Skeleton Longbowman
(20542, 1878, 1, 1, -1, 90559), -- Braided Hemp
(20542, 734, 1, 1, -1, 37733), -- Haste Potion
(20542, 1869, 1, 1, -1, 226397), -- Iron Ore
(20542, 57, 106, 181, 0, 700000), -- Adena
(20542, 272, 1, 1, 1, 127.4081), -- Forest Bow
(20542, 2013, 1, 1, 1, 1443.5919), -- Forest Bow Shaft
(20542, 1864, 1, 1, 2, 53499.46836), -- Stem
(20542, 1869, 1, 1, 2, 26749.73418), -- Iron Ore
(20542, 1878, 1, 1, 2, 10699.93587), -- Braided Hemp
(20542, 1801, 1, 1, 2, 13475.9313), -- Recipe: Piece Bone Gaiters
(20542, 5158, 1, 1, 2, 1069.93029), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Ghost
(20543, 2252, 1, 1, -1, 9320), -- Recipe: Iron Hammer
(20543, 908, 1, 1, -1, 4987), -- Necklace of Wisdom
(20543, 1882, 1, 1, -1, 50535), -- Leather
(20543, 57, 105, 183, 0, 700000), -- Adena
(20543, 309, 1, 1, 1, 128), -- Tears of Eva
(20543, 310, 1, 1, 1, 128), -- Relic of the Saints
(20543, 1867, 1, 1, 2, 35825.538606), -- Animal Skin
(20543, 1872, 1, 1, 2, 35825.538606), -- Animal Bone
(20543, 1882, 1, 1, 2, 5970.900312), -- Leather
(20543, 2139, 1, 1, 2, 5373.782934), -- Recipe: Steel Mold
(20543, 6037, 1, 1, 2, 53738.239542), -- Waking Scroll
-- Elder Keltir
(20544, 1870, 1, 1, -1, 27106), -- Coal
(20544, 1872, 1, 1, -1, 36142), -- Animal Bone
(20544, 1788, 1, 1, -1, 21685), -- Recipe: Bow
(20544, 57, 13, 20, 0, 700000), -- Adena
(20544, 21, 1, 1, 1, 24799.8649), -- Shirt
(20544, 28, 1, 1, 1, 39470.1351), -- Pants
(20544, 1869, 1, 1, 2, 9341.319526), -- Iron Ore
(20544, 1864, 1, 1, 2, 18682.639052), -- Stem
(20544, 1788, 1, 1, 2, 7473.041422), -- Recipe: Bow
-- Young Keltir
(20545, 21, 1, 1, -1, 28176), -- Shirt
(20545, 1786, 1, 1, -1, 12736), -- Recipe: Broad Sword
(20545, 1873, 1, 1, -1, 6368), -- Silver Nugget
(20545, 57, 8, 12, 0, 700000), -- Adena
(20545, 18, 1, 1, 1, 54861.301984), -- Leather Shield
(20545, 41, 1, 1, 1, 39186.698016), -- Cloth Cap
(20545, 1868, 1, 1, 2, 6583.31885), -- Thread
(20545, 1873, 1, 1, 2, 1316.6772), -- Silver Nugget
(20545, 1788, 1, 1, 2, 2633.320825), -- Recipe: Bow
(20545, 6037, 1, 1, 2, 6583.31885), -- Waking Scroll
(20545, 17, 10, 30, 2, 16458.364275), -- Wooden Arrow
-- Turek Orc Elder
(20546, 2279, 1, 1, -1, 4867), -- Recipe: War Pick
(20546, 2979, 1, 1, -1, 91220), -- Recipe: Manticore Skin Gloves
(20546, 1877, 1, 1, -1, 27257), -- Adamantite Nugget
(20546, 57, 288, 574, 0, 700000), -- Adena
(20546, 849, 1, 1, 1, 366.707265), -- Tiger's Eye Earring
(20546, 1901, 1, 1, 1, 12510.465306), -- Tiger's Eye Earring Stone
(20546, 912, 1, 1, 1, 274.883163), -- Near Forest Necklace
(20546, 880, 1, 1, 1, 548.944266), -- Black Pearl Ring
(20546, 1876, 1, 1, 2, 9057.60408), -- Mithril Ore
(20546, 1880, 1, 1, 2, 4528.80204), -- Steel
(20546, 1877, 1, 1, 2, 1811.5361), -- Adamantite Nugget
(20546, 1881, 1, 1, 2, 6038.40272), -- Coarse Bone Powder
(20546, 1882, 1, 1, 2, 10064.01727), -- Leather
(20546, 2276, 1, 1, 2, 323.48586), -- Recipe: Maingauche
(20546, 2274, 1, 1, 2, 323.48586), -- Recipe: Skull Breaker
(20546, 2976, 1, 1, 2, 6062.66607), -- Recipe: Manticore Skin Boots
-- Ol Mahum Reserve
(20547, 2151, 1, 1, -1, 105333), -- Recipe: Necklace of Devotion
(20547, 1804, 1, 1, -1, 15126), -- Recipe: Soulshot (D-Grade)
(20547, 1898, 1, 1, -1, 38844), -- Blue Diamond Necklace Gem
(20547, 57, 173, 305, 0, 700000), -- Adena
(20547, 39, 1, 1, 1, 1567.677996), -- Boots
(20547, 1930, 1, 1, 1, 19093.621779), -- Boot Lining
(20547, 51, 1, 1, 1, 1567.700225), -- Bracer
(20547, 1870, 1, 1, 2, 44679.094416), -- Coal
(20547, 1865, 1, 1, 2, 44679.094416); -- Varnish

INSERT INTO `droplist` VALUES
(20547, 5163, 1, 1, 2, 1787.147716), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20547, 5268, 1, 1, 2, 1787.147716), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
(20547, 734, 1, 1, 2, 7446.515736), -- Haste Potion
-- Ol Mahum Deserter
(20548, 1865, 1, 1, -1, 385707), -- Varnish
(20548, 1930, 1, 1, -1, 98899), -- Boot Lining
(20548, 1804, 1, 1, -1, 15428), -- Recipe: Soulshot (D-Grade)
(20548, 57, 177, 312, 0, 700000), -- Adena
(20548, 625, 1, 1, 1, 2301.462072), -- Bone Shield
(20548, 1148, 1, 1, 1, 1604.537928), -- Hard Leather Helmet
(20548, 1869, 1, 1, 2, 56965.863183), -- Iron Ore
(20548, 1864, 1, 1, 2, 113931.905239), -- Stem
(20548, 1880, 1, 1, 2, 5696.568431), -- Steel
(20548, 5268, 1, 1, 2, 2278.663147), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Ol Mahum Lord
(20549, 1880, 1, 1, -1, 140167), -- Steel
(20549, 1938, 1, 1, -1, 94230), -- Mithril Banded Mail Material
(20549, 1901, 1, 1, -1, 193601), -- Tiger's Eye Earring Stone
(20549, 57, 592, 1181, 0, 700000), -- Adena
(20549, 83, 1, 1, 1, 45.0906), -- Sword of Magic
(20549, 144, 1, 1, 1, 45.0906), -- Sword of Occult
(20549, 124, 1, 1, 1, 33.40344), -- Two-Handed Sword
(20549, 2026, 1, 1, 1, 1494.606795), -- Two-Handed Sword Edge
(20549, 127, 1, 1, 1, 33.40344), -- Crimson Sword
(20549, 130, 1, 1, 1, 33.405125), -- Elven Sword
(20549, 1871, 1, 1, 2, 124209.598502), -- Charcoal
(20549, 1866, 1, 1, 2, 82806.564841), -- Suede
(20549, 1877, 1, 1, 2, 4968.224734), -- Adamantite Nugget
(20549, 2277, 1, 1, 2, 887.076377), -- Recipe: Bich'hwa
(20549, 6667, 1, 1, 2, 77630.874684), -- Deluxe Chest Key - Grade 3
(20549, 1341, 20, 60, 2, 207016.660862), -- Bone Arrow
-- Guardian Basilisk
(20550, 2276, 1, 1, -1, 5536), -- Recipe: Maingauche
(20550, 394, 1, 1, -1, 1325), -- Reinforced Leather Shirt
(20550, 2154, 1, 1, -1, 82984), -- Recipe: Elven Earring
(20550, 57, 327, 655, 0, 700000), -- Adena
(20550, 393, 1, 1, 1, 117.40802), -- Mithril Banded Mail
(20550, 1938, 1, 1, 1, 4617.24182), -- Mithril Banded Mail Material
(20550, 394, 1, 1, 1, 117.40802), -- Reinforced Leather Shirt
(20550, 415, 1, 1, 1, 187.65916), -- Mithril Banded Gaiters
(20550, 1939, 1, 1, 1, 6032.63508), -- Mithril Banded Gaiters Material
(20550, 416, 1, 1, 1, 187.6479), -- Reinforced Leather Gaiters
(20550, 1868, 1, 1, 2, 117742.435811), -- Thread
(20550, 1873, 1, 1, 2, 23548.518392), -- Silver Nugget
(20550, 5549, 1, 1, 2, 5887.129598), -- Metallic Thread
(20550, 1889, 1, 1, 2, 3924.805115), -- Compound Braid
(20550, 2272, 1, 1, 2, 420.509257), -- Recipe: Sword of Revolution
(20550, 2274, 1, 1, 2, 420.509257), -- Recipe: Skull Breaker
(20550, 2148, 1, 1, 2, 4205.09257), -- Recipe: Crafted Leather
-- Road Scavenger
(20551, 1874, 1, 1, -1, 52310), -- Oriharukon Ore
(20551, 2034, 1, 1, -1, 8290), -- Sword of Revolution Blade
(20551, 1902, 1, 1, -1, 79498), -- Elven Earring Beads
(20551, 57, 332, 662, 0, 700000), -- Adena
(20551, 850, 1, 1, 1, 188.03786), -- Elven Earring
(20551, 1902, 1, 1, 1, 6848.930925), -- Elven Earring Beads
(20551, 913, 1, 1, 1, 141.128575), -- Elven Necklace
(20551, 1904, 1, 1, 1, 6308.810455), -- Elven Necklace Beads
(20551, 881, 1, 1, 1, 282.25715), -- Elven Ring
(20551, 1903, 1, 1, 1, 11275.835035), -- Elven Ring Piece
(20551, 1872, 1, 1, 2, 77257.841813), -- Animal Bone
(20551, 1867, 1, 1, 2, 77257.841813), -- Animal Skin
(20551, 1881, 1, 1, 2, 7725.80127), -- Coarse Bone Powder
(20551, 1875, 1, 1, 2, 3862.900635), -- Stone of Purity
(20551, 2145, 1, 1, 2, 4138.88314), -- Recipe: Mithril Alloy
(20551, 2288, 1, 1, 2, 321.951108), -- Recipe: Ghost Staff
(20551, 2287, 1, 1, 2, 321.780221), -- Recipe: Atuba Hammer
-- Fettered Soul
(20552, 1902, 1, 1, -1, 170992), -- Elven Earring Beads
(20552, 1825, 1, 1, -1, 120549), -- Recipe: Oriharukon
(20552, 1903, 1, 1, -1, 281516), -- Elven Ring Piece
(20552, 57, 714, 1424, 0, 700000), -- Adena
(20552, 129, 1, 1, 1, 81.2308), -- Sword of Revolution
(20552, 2034, 1, 1, 1, 4608.7692), -- Sword of Revolution Blade
(20552, 1864, 1, 3, 2, 145400.811275), -- Stem
(20552, 1869, 1, 1, 2, 145400.811275), -- Iron Ore
(20552, 1878, 1, 1, 2, 58160.32451), -- Braided Hemp
(20552, 1884, 1, 1, 2, 89477.457255), -- Cord
(20552, 2285, 1, 1, 2, 807.870585), -- Recipe: Claymore
(20552, 2208, 1, 1, 2, 14867.7251), -- Recipe: Ogre Power Gauntlets
-- Windsus
(20553, 2145, 1, 1, -1, 62124), -- Recipe: Mithril Alloy
(20553, 1904, 1, 1, -1, 81170), -- Elven Necklace Beads
(20553, 1865, 1, 1, -1, 869731), -- Varnish
(20553, 57, 368, 733, 0, 700000), -- Adena
(20553, 318, 1, 1, 1, 41.858726), -- Crucifix of Blood
(20553, 2042, 1, 1, 1, 2077.141274), -- Crucifix of Blood Piece
(20553, 1865, 1, 1, 2, 74930.706489), -- Varnish
(20553, 1870, 1, 1, 2, 74930.706489), -- Coal
(20553, 1879, 1, 1, 2, 12488.36337), -- Cokes
(20553, 1875, 1, 1, 2, 4995.345348), -- Stone of Purity
(20553, 2285, 1, 1, 2, 416.278779), -- Recipe: Claymore
(20553, 2208, 1, 1, 2, 7661.599525), -- Recipe: Ogre Power Gauntlets
-- Grandis
(20554, 1941, 1, 1, -1, 40488), -- Brigandine Temper
(20554, 2146, 1, 1, -1, 72720), -- Recipe: Artisan's frame
(20554, 1902, 1, 1, -1, 103148), -- Elven Earring Beads
(20554, 57, 425, 848, 0, 700000), -- Adena
(20554, 224, 1, 1, 1, 24.49914), -- Maingauche
(20554, 2038, 1, 1, 1, 1390.00086), -- Maingauche Edge
(20554, 1660, 1, 1, 1, 24.49914), -- Cursed Maingauche
(20554, 2044, 1, 1, 1, 1390.00086), -- Cursed Maingauche Edge
(20554, 1869, 1, 1, 2, 75180.860924), -- Iron Ore
(20554, 1864, 1, 1, 2, 150361.472222), -- Stem
(20554, 1880, 1, 1, 2, 7517.986242), -- Steel
(20554, 5550, 1, 1, 2, 1002.498016), -- Durable Metal Plate
(20554, 5473, 1, 1, 2, 5369.954512), -- Recipe: Durable Metal Plate(100%)
(20554, 2208, 1, 1, 2, 7687.23267), -- Recipe: Ogre Power Gauntlets
(20554, 6036, 1, 1, 2, 2505.995414), -- Greater Magic Haste Potion
-- Giant Fungus
(20555, 1903, 1, 1, -1, 152869), -- Elven Ring Piece
(20555, 2296, 1, 1, -1, 5091), -- Recipe: Atuba Mace
(20555, 1878, 1, 1, -1, 366579), -- Braided Hemp
(20555, 57, 383, 764, 0, 700000), -- Adena
(20555, 395, 1, 1, 1, 137.708965), -- Manticore Skin Shirt
(20555, 1942, 1, 1, 1, 6040.76583), -- Manticore Skin Shirt Texture
(20555, 417, 1, 1, 1, 219.926575), -- Manticore Skin Gaiters
(20555, 1943, 1, 1, 1, 9406.59863), -- Manticore Skin Gaiters Pattern
(20555, 1869, 1, 1, 2, 78955.380156), -- Iron Ore
(20555, 1864, 1, 1, 2, 157910.500785), -- Stem
(20555, 1880, 1, 1, 2, 7895.589921), -- Steel
(20555, 5550, 1, 1, 2, 1052.641512), -- Durable Metal Plate
(20555, 5473, 1, 1, 2, 5639.781237), -- Recipe: Durable Metal Plate(100%)
(20555, 2208, 1, 1, 2, 8073.106389), -- Recipe: Ogre Power Gauntlets
-- Giant Monstereye
(20556, 2305, 1, 1, -1, 4246), -- Recipe: Crystal Staff
(20556, 1957, 1, 1, -1, 108518), -- Assault Boots Part
(20556, 1874, 1, 1, -1, 64821), -- Oriharukon Ore
(20556, 57, 394, 788, 0, 700000), -- Adena
(20556, 438, 1, 1, 1, 133.188891), -- Sage's Rag
(20556, 1953, 1, 1, 1, 7819.811109), -- Sage's Rag Lining
(20556, 1870, 1, 1, 2, 81375.725358), -- Coal
(20556, 1865, 1, 1, 2, 81375.725358), -- Varnish
(20556, 1874, 1, 1, 2, 5424.977848), -- Oriharukon Ore
(20556, 2160, 1, 1, 2, 5250.115032), -- Recipe: Moonstone Earring
(20556, 2205, 1, 1, 2, 2575.172257), -- Recipe: Chain Gaiters
(20556, 5154, 1, 1, 2, 271.284147), -- Recipe: Soulshot (C) Compressed Package (100%)
-- Dire Wyrm
(20557, 2055, 1, 1, -1, 8505), -- Glaive Edge
(20557, 3954, 1, 1, -1, 3429), -- Recipe: Blessed Spiritshot C
(20557, 4469, 1, 1, -1, 5878), -- Dye of STR (Str+1 Con-1)
(20557, 57, 414, 837, 0, 700000), -- Adena
(20557, 297, 1, 1, 1, 37.24522), -- Glaive
(20557, 2055, 1, 1, 1, 2135.75478), -- Glaive Edge
(20557, 1871, 1, 1, 2, 73789.958951), -- Charcoal
(20557, 1866, 1, 1, 2, 49193.253063), -- Suede
(20557, 1877, 1, 1, 2, 2951.585661), -- Adamantite Nugget
(20557, 2297, 1, 1, 2, 322.18739), -- Recipe: Flamberge
(20557, 5154, 1, 1, 2, 246.00515), -- Recipe: Soulshot (C) Compressed Package (100%)
(20557, 2994, 1, 1, 2, 5856.350987), -- Recipe: Boots of Seal
(20557, 6668, 1, 1, 2, 26353.658798), -- Deluxe Chest Key - Grade 4
-- Rotting tree
(20558, 2932, 1, 1, -1, 118674), -- Plate Boots Design
(20558, 2310, 1, 1, -1, 4643), -- Recipe: Dark Elven Dagger
(20558, 1905, 1, 1, -1, 103435), -- Omen Beast's Eye Earring Gemstone
(20558, 57, 420, 854, 0, 700000), -- Adena
(20558, 851, 1, 1, 1, 190.763013), -- Omen Beast's Eye Earring
(20558, 1905, 1, 1, 1, 8656.463781), -- Omen Beast's Eye Earring Gemstone
(20558, 914, 1, 1, 1, 143.065335), -- Necklace of Darkness
(20558, 1907, 1, 1, 1, 6190.504908), -- Necklace of Darkness Gem
(20558, 882, 1, 1, 1, 286.13067), -- Mithril Ring
(20558, 1906, 1, 1, 1, 12232.072293), -- Mithril Ring Wire
(20558, 1875, 1, 1, 2, 4449.576105), -- Stone of Purity
(20558, 1879, 1, 1, 2, 11124.02291), -- Cokes
(20558, 1885, 1, 1, 2, 5562.011455), -- High-Grade Suede
(20558, 5550, 1, 1, 2, 889.94828), -- Durable Metal Plate
(20558, 5549, 1, 1, 2, 6674.446805), -- Metallic Thread
(20558, 2988, 1, 1, 2, 2816.130915), -- Recipe: Reinforced Mithril Gaiters
(20558, 2303, 1, 1, 2, 291.415085), -- Recipe: Skull Graver
(20558, 1342, 10, 30, 2, 133487.448445), -- Steel Arrow
-- Rotting Golem
(20559, 2164, 1, 1, -1, 96165), -- Recipe: Ring of Protection
(20559, 1873, 1, 1, -1, 500056), -- Silver Nugget
(20559, 2163, 1, 1, -1, 63783), -- Recipe: Earring of Protection
(20559, 57, 492, 1009, 0, 700000), -- Adena
(20559, 71, 1, 1, 1, 16.754325), -- Flamberge
(20559, 2059, 1, 1, 1, 1096.923506), -- Flamberge Blade
(20559, 72, 1, 1, 1, 16.754325), -- Stormbringer
(20559, 2060, 1, 1, 1, 1172.567844), -- Stormbringer Blade
(20559, 1895, 1, 1, 2, 21101.178213), -- Metallic Fiber
(20559, 2164, 1, 1, 2, 5681.076912), -- Recipe: Ring of Protection
(20559, 5154, 1, 1, 2, 246.186135), -- Recipe: Soulshot (C) Compressed Package (100%)
(20559, 2219, 1, 1, 2, 4587.203421), -- Recipe: Crimson Boots
(20559, 8723, 1, 1, 2, 2954.162826), -- Life Stone - Level 46
(20559, 8733, 1, 1, 2, 738.558405), -- Mid-Grade Life Stone - Level 46
(20559, 8743, 1, 1, 2, 73.838142), -- High-Grade Life Stone - Level 46
(20559, 8753, 1, 1, 2, 14.795946), -- Top-Grade Life Stone - Level 46
-- Trisalim Spider
(20560, 2165, 1, 1, -1, 44638), -- Recipe: Necklace of Protection
(20560, 2320, 1, 1, -1, 4059), -- Recipe: Cursed Staff
(20560, 1908, 1, 1, -1, 110326), -- Moonstone Earring Wire
(20560, 57, 461, 936, 0, 700000), -- Adena
(20560, 852, 1, 1, 1, 153.844505), -- Moonstone Earring
(20560, 1908, 1, 1, 1, 8690.69005), -- Moonstone Earring Wire
(20560, 915, 1, 1, 1, 115.433245), -- Aquastone Necklace
(20560, 1910, 1, 1, 1, 6910.66439), -- Aquastone Necklace Chain
(20560, 883, 1, 1, 1, 230.86649), -- Aquastone Ring
(20560, 1909, 1, 1, 1, 12393.50132), -- Aquastone Ring Wire
(20560, 1864, 1, 1, 2, 84710.585259), -- Stem
(20560, 1865, 1, 1, 2, 42355.424115), -- Varnish
(20560, 1866, 1, 1, 2, 28236.774096), -- Suede
(20560, 1873, 1, 1, 2, 16942.169646), -- Silver Nugget
(20560, 1868, 1, 1, 2, 84710.585259), -- Thread
(20560, 2323, 1, 1, 2, 147.526731), -- Recipe: Elemental Bow
(20560, 2225, 1, 1, 2, 920.661471), -- Recipe: Demon's Stockings
(20560, 2321, 1, 1, 2, 147.526731), -- Recipe: Stiletto
(20560, 3003, 1, 1, 2, 2630.761884), -- Recipe: Gloves of Seal
(20560, 8723, 1, 1, 2, 1694.322153), -- Life Stone - Level 46
(20560, 8733, 1, 1, 2, 423.646281), -- Mid-Grade Life Stone - Level 46
(20560, 8743, 1, 1, 2, 42.338331), -- High-Grade Life Stone - Level 46
(20560, 8753, 1, 1, 2, 8.678043), -- Top-Grade Life Stone - Level 46
-- Trisalim Tarantula
(20561, 1880, 1, 1, -1, 137957), -- Steel
(20561, 2940, 1, 1, -1, 124006), -- Dwarven Chain Boots Part
(20561, 2164, 1, 1, -1, 106120), -- Recipe: Ring of Protection
(20561, 57, 543, 1111, 0, 700000), -- Adena
(20561, 96, 1, 1, 1, 12.329282), -- Scythe
(20561, 2062, 1, 1, 1, 852.33652), -- Scythe Edge
(20561, 298, 1, 1, 1, 12.329282), -- Orcish Glaive
(20561, 2075, 1, 1, 1, 852.33652), -- Orcish Glaive Blade
(20561, 302, 1, 1, 1, 12.329282), -- Body Slasher
(20561, 2076, 1, 1, 1, 852.339114), -- Body Slasher Blade
(20561, 1866, 1, 1, 2, 36222.406578), -- Suede
(20561, 1871, 1, 1, 2, 54333.46539), -- Charcoal
(20561, 5220, 1, 1, 2, 2173.223034), -- Metal Hardener
(20561, 1885, 1, 1, 2, 4527.90918), -- High-Grade Suede
(20561, 4041, 1, 1, 2, 472.43979), -- Mold Hardener
(20561, 6037, 1, 1, 2, 108667.219734), -- Waking Scroll
(20561, 6668, 1, 1, 2, 19404.70587), -- Deluxe Chest Key - Grade 4
(20561, 8723, 1, 1, 2, 2173.223034), -- Life Stone - Level 46
(20561, 8733, 1, 1, 2, 543.23352), -- Mid-Grade Life Stone - Level 46
(20561, 8743, 1, 1, 2, 54.323352), -- High-Grade Life Stone - Level 46
(20561, 8753, 1, 1, 2, 10.980252), -- Top-Grade Life Stone - Level 46
(20561, 1832, 1, 1, 2, 60370.870266), -- Greater Antidote
-- Spore Zombie
(20562, 1867, 1, 3, -1, 885212), -- Animal Skin
(20562, 2346, 1, 1, -1, 3088), -- Recipe: Fisted Blade
(20562, 440, 1, 1, -1, 440), -- Robe of Seal
(20562, 57, 524, 1069, 0, 700000), -- Adena
(20562, 853, 1, 1, 1, 130.303378), -- Earring of Protection
(20562, 1911, 1, 1, 1, 7293.4976), -- Earring of Protection Gemstone
(20562, 916, 1, 1, 1, 97.763904), -- Necklace of Protection
(20562, 1913, 1, 1, 1, 5962.967722), -- Necklace of Protection Gemstone
(20562, 884, 1, 1, 1, 195.527808), -- Ring of Protection
(20562, 1912, 1, 1, 1, 10566.939588), -- Ring of Protection Gemstone
(20562, 1869, 1, 1, 2, 45255.831726), -- Iron Ore
(20562, 1864, 1, 1, 2, 90511.663452), -- Stem
(20562, 1880, 1, 1, 2, 4525.559262), -- Steel
(20562, 5550, 1, 1, 2, 603.503544), -- Durable Metal Plate
(20562, 4043, 1, 1, 2, 1508.519754), -- Asofe
(20562, 2166, 1, 1, 2, 1534.104096), -- Recipe: Earrings of Binding (100%)
(20562, 2230, 1, 1, 2, 877.040808), -- Recipe: Theca Leather Gaiters
(20562, 2226, 1, 1, 2, 1847.09385), -- Recipe: Mithril Gauntlets
(20562, 8724, 1, 1, 2, 1508.519754), -- Life Stone - Level 49
(20562, 8734, 1, 1, 2, 377.070162), -- Mid-Grade Life Stone - Level 49
(20562, 8744, 1, 1, 2, 37.778748), -- High-Grade Life Stone - Level 49
(20562, 8754, 1, 1, 2, 7.651392), -- Top-Grade Life Stone - Level 49
(20562, 1342, 10, 30, 2, 90511.663452), -- Steel Arrow
-- Manashen Gargoyle
(20563, 1825, 1, 1, -1, 77898), -- Recipe: Oriharukon
(20563, 1941, 1, 1, -1, 43371), -- Brigandine Temper
(20563, 1864, 1, 5, -1, 727049), -- Stem
(20563, 57, 455, 909, 0, 700000), -- Adena
(20563, 1124, 1, 1, 1, 122.767366), -- Boots of Power
(20563, 1948, 1, 1, 1, 4761.357634), -- Boots of Power Pattern
(20563, 2424, 1, 1, 1, 122.767366), -- Manticore Skin Boots
(20563, 2923, 1, 1, 1, 4761.357634), -- Manticore Skin Boot Lining
(20563, 2425, 1, 1, 1, 122.767366), -- Brigandine Boots
(20563, 2924, 1, 1, 1, 4761.357634), -- Brigandine Boots Design
(20563, 2426, 1, 1, 1, 122.767366), -- Elven Mithril Boots
(20563, 2925, 1, 1, 1, 4761.357634), -- Elven Mithril Boots Design
(20563, 606, 1, 1, 1, 122.767366), -- Rip Gauntlets
(20563, 1946, 1, 1, 1, 4761.357634), -- Rip Gauntlets Pattern
(20563, 2448, 1, 1, 1, 122.767366), -- Manticore Skin Gloves
(20563, 2926, 1, 1, 1, 4761.357634), -- Manticore Skin Gloves Lining
(20563, 2449, 1, 1, 1, 122.767366), -- Brigandine Gauntlets
(20563, 2927, 1, 1, 1, 4761.357634), -- Brigandine Gauntlets Pattern
(20563, 2450, 1, 1, 1, 122.767366), -- Mithril Gloves
(20563, 2928, 1, 1, 1, 4761.357634), -- Mithril Gloves Design
(20563, 1870, 1, 1, 2, 93956.963796), -- Coal
(20563, 1865, 1, 1, 2, 93956.963796), -- Varnish
(20563, 1874, 1, 1, 2, 6263.716176), -- Oriharukon Ore
(20563, 2160, 1, 1, 2, 6061.818384), -- Recipe: Moonstone Earring
(20563, 2205, 1, 1, 2, 2973.311334), -- Recipe: Chain Gaiters
(20563, 5154, 1, 1, 2, 313.226514), -- Recipe: Soulshot (C) Compressed Package (100%)
-- Enchanted Monstereye
(20564, 1885, 1, 1, -1, 82647), -- High-Grade Suede
(20564, 2306, 1, 1, -1, 4331), -- Recipe: Stick of Faith
(20564, 1864, 1, 5, -1, 661179), -- Stem
(20564, 57, 402, 804, 0, 700000), -- Adena
(20564, 630, 1, 1, 1, 210.139151), -- Square Shield
(20564, 1956, 1, 1, 1, 9421.286455), -- Square Shield Fragment
(20564, 2494, 1, 1, 1, 210.139151), -- Plate Shield
(20564, 2934, 1, 1, 1, 9421.286455), -- Plate Shield Fragment
(20564, 2412, 1, 1, 1, 147.157438), -- Plate Helmet
(20564, 2930, 1, 1, 1, 6690.99135), -- Plate Helmet Design
(20564, 1871, 1, 1, 2, 71145.919102), -- Charcoal
(20564, 1866, 1, 1, 2, 47430.561726), -- Suede
(20564, 1877, 1, 1, 2, 2845.824522), -- Adamantite Nugget
(20564, 2297, 1, 1, 2, 310.64278), -- Recipe: Flamberge
(20564, 5154, 1, 1, 2, 237.1903), -- Recipe: Soulshot (C) Compressed Package (100%)
(20564, 2994, 1, 1, 2, 5646.506374), -- Recipe: Boots of Seal
(20564, 6668, 1, 1, 2, 25409.355196), -- Deluxe Chest Key - Grade 4
-- Enchanted Stone Golem
(20565, 1865, 1, 3, -1, 572525), -- Varnish
(20565, 3954, 1, 1, -1, 3817), -- Recipe: Blessed Spiritshot C
(20565, 4470, 1, 1, -1, 6543), -- Dye of STR (Str+1 Dex-1)
(20565, 57, 461, 932, 0, 700000), -- Adena
(20565, 262, 1, 1, 1, 41.46166), -- Scallop Jamadhr
(20565, 2053, 1, 1, 1, 2377.53834), -- Scallop Jamadhr Edge
(20565, 1875, 1, 1, 2, 5476.173086), -- Stone of Purity
(20565, 1879, 1, 1, 2, 13690.452288), -- Cokes
(20565, 1885, 1, 1, 2, 6845.226144), -- High-Grade Suede
(20565, 5550, 1, 1, 2, 1095.226788), -- Durable Metal Plate
(20565, 5549, 1, 1, 2, 8214.279202), -- Metallic Thread
(20565, 2988, 1, 1, 2, 3465.947694), -- Recipe: Reinforced Mithril Gaiters
(20565, 2303, 1, 1, 2, 358.694798), -- Recipe: Skull Graver
-- Enchanted Iron Golem
(20566, 2995, 1, 1, -1, 95820), -- Recipe: Reinforced Mithril Gloves
(20566, 3000, 1, 1, -1, 77393), -- Recipe: Dwarven Chain Shield
(20566, 1905, 1, 1, -1, 117445), -- Omen Beast's Eye Earring Gemstone
(20566, 57, 477, 970, 0, 700000), -- Adena
(20566, 630, 1, 1, 1, 255.812474), -- Square Shield
(20566, 1956, 1, 1, 1, 11468.98417), -- Square Shield Fragment
(20566, 2494, 1, 1, 1, 255.812474), -- Plate Shield
(20566, 2934, 1, 1, 1, 11468.98417), -- Plate Shield Fragment
(20566, 2412, 1, 1, 1, 179.141812), -- Plate Helmet
(20566, 2930, 1, 1, 1, 8145.2649), -- Plate Helmet Design
(20566, 1895, 1, 1, 2, 21652.597538), -- Metallic Fiber
(20566, 2164, 1, 1, 2, 5829.535712), -- Recipe: Ring of Protection
(20566, 5154, 1, 1, 2, 252.61951), -- Recipe: Soulshot (C) Compressed Package (100%)
(20566, 2219, 1, 1, 2, 4707.076946), -- Recipe: Crimson Boots
(20566, 8723, 1, 1, 2, 3031.361476), -- Life Stone - Level 46
(20566, 8733, 1, 1, 2, 757.85853), -- Mid-Grade Life Stone - Level 46
(20566, 8743, 1, 1, 2, 75.767692), -- High-Grade Life Stone - Level 46
(20566, 8753, 1, 1, 2, 15.182596), -- Top-Grade Life Stone - Level 46
-- Enchanted Gargoyle
(20567, 2061, 1, 1, -1, 10331), -- Big Hammer Head
(20567, 3004, 1, 1, -1, 83015), -- Recipe: Rind Leather Gloves
(20567, 2165, 1, 1, -1, 51209), -- Recipe: Necklace of Protection
(20567, 57, 526, 1078, 0, 700000), -- Adena
(20567, 263, 1, 1, 1, 35.829805), -- Chakram
(20567, 2073, 1, 1, 1, 2441.170195), -- Chakram Edge
(20567, 1864, 1, 1, 2, 97180.198849), -- Stem
(20567, 1865, 1, 1, 2, 48590.250265), -- Varnish
(20567, 1866, 1, 1, 2, 32393.299056), -- Suede
(20567, 1873, 1, 1, 2, 19436.100106), -- Silver Nugget
(20567, 1868, 1, 1, 2, 97180.198849), -- Thread
(20567, 2323, 1, 1, 2, 169.243041), -- Recipe: Elemental Bow
(20567, 2225, 1, 1, 2, 1056.185181), -- Recipe: Demon's Stockings
(20567, 2321, 1, 1, 2, 169.243041), -- Recipe: Stiletto
(20567, 3003, 1, 1, 2, 3018.016724), -- Recipe: Gloves of Seal
(20567, 8723, 1, 1, 2, 1943.730683), -- Life Stone - Level 46
(20567, 8733, 1, 1, 2, 486.008091), -- Mid-Grade Life Stone - Level 46
(20567, 8743, 1, 1, 2, 48.570641), -- High-Grade Life Stone - Level 46
(20567, 8753, 1, 1, 2, 9.955473), -- Top-Grade Life Stone - Level 46
-- Formor
(20568, 1961, 1, 1, -1, 37654), -- Mithril Shirt Fabric
(20568, 1884, 1, 1, -1, 724122), -- Cord
(20568, 1908, 1, 1, -1, 111430), -- Moonstone Earring Wire
(20568, 57, 465, 945, 0, 700000), -- Adena
(20568, 89, 1, 1, 1, 3.942464), -- Big Hammer
(20568, 2061, 1, 1, 1, 268.608336), -- Big Hammer Head
(20568, 160, 1, 1, 1, 3.942464), -- Battle Axe
(20568, 2063, 1, 1, 1, 268.608336), -- Battle Axe Head
(20568, 161, 1, 1, 1, 3.942464), -- Silver Axe
(20568, 2064, 1, 1, 1, 268.608336), -- Silver Axe Head
(20568, 173, 1, 1, 1, 3.942464), -- Skull Graver
(20568, 2065, 1, 1, 1, 268.608336), -- Skull Graver Head
(20568, 191, 1, 1, 1, 3.942464), -- Heavy Doom Hammer
(20568, 2066, 1, 1, 1, 272.557256), -- Heavy Doom Hammer Head
(20568, 192, 1, 1, 1, 3.942464), -- Crystal Staff
(20568, 2067, 1, 1, 1, 250.458368), -- Crystal Staff Head
(20568, 193, 1, 1, 1, 3.942464), -- Stick of Faith
(20568, 2068, 1, 1, 1, 250.458368), -- Stick of Faith Shaft
(20568, 194, 1, 1, 1, 3.942464), -- Heavy Doom Axe
(20568, 2069, 1, 1, 1, 272.552952), -- Heavy Doom Axe Blade
(20568, 1864, 1, 1, 2, 101113.780967), -- Stem
(20568, 1865, 1, 1, 2, 50557.04531), -- Varnish
(20568, 1866, 1, 1, 2, 33704.490438), -- Suede
(20568, 1873, 1, 1, 2, 20222.818124), -- Silver Nugget
(20568, 1868, 1, 1, 2, 101113.780967), -- Thread
(20568, 2324, 1, 1, 2, 176.192557), -- Recipe: Noble Elven Bow
(20568, 2321, 1, 1, 2, 176.192557), -- Recipe: Stiletto
(20568, 8723, 1, 1, 2, 2022.343743), -- Life Stone - Level 46
(20568, 8733, 1, 1, 2, 505.663349), -- Mid-Grade Life Stone - Level 46
(20568, 8743, 1, 1, 2, 50.473439), -- High-Grade Life Stone - Level 46
(20568, 8753, 1, 1, 2, 10.218549), -- Top-Grade Life Stone - Level 46
-- Formor Elder
(20569, 3001, 1, 1, -1, 79425), -- Recipe: Rind Leather Boots
(20569, 1961, 1, 1, -1, 40920), -- Mithril Shirt Fabric
(20569, 2213, 1, 1, -1, 19856), -- Recipe: Dwarven Chain Mail Shirt
(20569, 57, 504, 1030, 0, 700000), -- Adena
(20569, 631, 1, 1, 1, 197.50464), -- Eldarake
(20569, 1964, 1, 1, 1, 8139.151692), -- Eldarake Temper
(20569, 2495, 1, 1, 1, 197.50464), -- Chain Shield
(20569, 2945, 1, 1, 1, 8139.151692), -- Chain Shield Fragment
(20569, 2413, 1, 1, 1, 138.253248), -- Chain Hood
(20569, 2936, 1, 1, 1, 7392.434088), -- Chain Hood Pattern
(20569, 1865, 1, 1, 2, 50362.6134), -- Varnish
(20569, 1870, 1, 1, 2, 50362.6134), -- Coal
(20569, 1879, 1, 1, 2, 8393.82225), -- Cokes
(20569, 1875, 1, 1, 2, 3357.5289), -- Stone of Purity
(20569, 4040, 1, 1, 2, 1007.19465), -- Mold Lubricant
(20569, 2508, 1, 1, 2, 41968.9512), -- Cursed Bone
(20569, 2230, 1, 1, 2, 975.9849), -- Recipe: Theca Leather Gaiters
(20569, 2220, 1, 1, 2, 1042.72575), -- Recipe: Rind Leather Armor
(20569, 8723, 1, 1, 2, 2014.54935), -- Life Stone - Level 46
(20569, 8733, 1, 1, 2, 503.67735), -- Mid-Grade Life Stone - Level 46
(20569, 8743, 1, 1, 2, 50.41575), -- High-Grade Life Stone - Level 46
(20569, 8753, 1, 1, 2, 9.9231), -- Top-Grade Life Stone - Level 46
-- Tarlk Bugbear
(20570, 3008, 1, 1, -1, 46633), -- Recipe: Theca Leather Gloves
(20570, 2216, 1, 1, -1, 52993), -- Recipe: Great Helmet
(20570, 1911, 1, 1, -1, 95383), -- Earring of Protection Gemstone
(20570, 57, 506, 1033, 0, 700000), -- Adena
(20570, 355, 1, 1, 1, 57.33637), -- Dwarven Chain Mail Shirt
(20570, 1968, 1, 1, 1, 3422.90028), -- Dwarven Chain Mail Shirt Material
(20570, 382, 1, 1, 1, 91.738192), -- Dwarven Chain Gaiters
(20570, 1969, 1, 1, 1, 5429.025158), -- Dwarven Chain Gaiters Material
(20570, 1866, 1, 1, 2, 34436.948304), -- Suede
(20570, 1871, 1, 1, 2, 51655.471392), -- Charcoal
(20570, 5220, 1, 1, 2, 2066.175792), -- Metal Hardener
(20570, 1885, 1, 1, 2, 4304.606304), -- High-Grade Suede
(20570, 4041, 1, 1, 2, 449.134608), -- Mold Hardener
(20570, 2167, 1, 1, 2, 2635.497216), -- Recipe: Ring of Ages
(20570, 2343, 1, 1, 2, 120.088944), -- Recipe: Mace of Underworld
(20570, 8724, 1, 1, 2, 1721.862096), -- Life Stone - Level 49
(20570, 8734, 1, 1, 2, 430.441056), -- Mid-Grade Life Stone - Level 49
(20570, 8744, 1, 1, 2, 43.06368), -- High-Grade Life Stone - Level 49
(20570, 8754, 1, 1, 2, 8.710608), -- Top-Grade Life Stone - Level 49
-- Tarlk Bugbear Warrior
(20571, 2335, 1, 1, -1, 3525), -- Recipe: War Axe
(20571, 2968, 1, 1, -1, 10228), -- Dwarven War Hammer Head
(20571, 951, 1, 1, -1, 2756), -- Scroll: Enchant Weapon (C-Grade)
(20571, 57, 599, 1219, 0, 700000), -- Adena
(20571, 73, 1, 1, 1, 7.60032), -- Shamshir
(20571, 2077, 1, 1, 1, 557.89968), -- Shamshir Blade
(20571, 74, 1, 1, 1, 7.60032), -- Katana
(20571, 2078, 1, 1, 1, 557.89968), -- Katana Blade
(20571, 131, 1, 1, 1, 7.60032), -- Spirit Sword
(20571, 2080, 1, 1, 1, 557.89968), -- Spirit Sword Blade
(20571, 133, 1, 1, 1, 7.60032), -- Raid Sword
(20571, 2081, 1, 1, 1, 557.89968), -- Raid Sword Blade
(20571, 1866, 1, 1, 2, 34445.326013), -- Suede
(20571, 1871, 1, 1, 2, 51667.910581), -- Charcoal
(20571, 5220, 1, 1, 2, 2066.697598), -- Metal Hardener
(20571, 1885, 1, 1, 2, 4305.646142), -- High-Grade Suede
(20571, 4041, 1, 1, 2, 449.295728), -- Mold Hardener
(20571, 2336, 1, 1, 2, 120.167782), -- Recipe: Nirvana Axe
(20571, 2508, 1, 1, 2, 43056.618297), -- Cursed Bone
(20571, 2351, 1, 1, 2, 108.088253), -- Recipe: Scorpion
(20571, 6668, 1, 1, 2, 18452.814002), -- Deluxe Chest Key - Grade 4
(20571, 8724, 1, 1, 2, 1722.195706), -- Life Stone - Level 49
(20571, 8734, 1, 1, 2, 430.627365), -- Mid-Grade Life Stone - Level 49
(20571, 8744, 1, 1, 2, 42.984298), -- High-Grade Life Stone - Level 49
(20571, 8754, 1, 1, 2, 8.628235), -- Top-Grade Life Stone - Level 49
-- Tarlk Bugbear High Warrior
(20572, 2950, 1, 1, -1, 139779), -- Gloves of Seal Pattern
(20572, 4125, 1, 1, -1, 73865), -- Recipe: Maestro Mold (100%)
(20572, 1894, 1, 1, -1, 58315), -- Crafted Leather
(20572, 57, 656, 1338, 0, 700000), -- Adena
(20572, 94, 1, 1, 1, 33.326689), -- Bec de Corbin
(20572, 2079, 1, 1, 1, 2529.673311), -- Bec De Corbin Blade
(20572, 1867, 1, 1, 2, 75526.054989), -- Animal Skin
(20572, 1872, 1, 1, 2, 75526.054989), -- Animal Bone
(20572, 1882, 1, 1, 2, 12587.842113), -- Leather
(20572, 1894, 1, 1, 2, 1987.396488), -- Crafted Leather
(20572, 4042, 1, 1, 2, 944.146357), -- Enria
(20572, 3009, 1, 1, 2, 2311.977976), -- Recipe: Composite Boots
(20572, 2508, 1, 1, 2, 47203.659657), -- Cursed Bone
(20572, 2224, 1, 1, 2, 769.550782), -- Recipe: Demon's Tunic
(20572, 8724, 1, 1, 2, 1888.292714), -- Life Stone - Level 49
(20572, 8734, 1, 1, 2, 471.906897), -- Mid-Grade Life Stone - Level 49
(20572, 8744, 1, 1, 2, 47.223946), -- High-Grade Life Stone - Level 49
(20572, 8754, 1, 1, 2, 9.311764), -- Top-Grade Life Stone - Level 49
(20572, 1342, 10, 30, 2, 113289.581328), -- Steel Arrow
-- Tarlk Basilisk
(20573, 2119, 1, 1, -1, 5433), -- Crystal Dagger Blade
(20573, 4122, 1, 1, -1, 52996), -- Recipe: Maestro Holder (100%)
(20573, 5549, 1, 1, -1, 119240), -- Metallic Thread
(20573, 57, 472, 959, 0, 700000), -- Adena
(20573, 64, 1, 1, 1, 130.58758), -- Composite Boots
(20573, 2956, 1, 1, 1, 7251.41242), -- Composite Boots Part
(20573, 608, 1, 1, 1, 130.58758), -- Mithril Gauntlets
(20573, 1981, 1, 1, 1, 7251.41242), -- Mithril Gauntlets Design
(20573, 1868, 1, 1, 2, 75862.170244), -- Thread
(20573, 1873, 1, 1, 2, 15172.469662), -- Silver Nugget
(20573, 5549, 1, 1, 2, 3793.161932), -- Metallic Thread
(20573, 1889, 1, 1, 2, 2528.715266), -- Compound Braid
(20573, 4044, 1, 1, 2, 1264.446666), -- Thons
(20573, 2231, 1, 1, 2, 163.464588), -- Recipe: Full Plate Armor
(20573, 3014, 1, 1, 2, 1059.4927), -- Recipe: Full Plate Boots
(20573, 3019, 1, 1, 2, 1011.41488), -- Recipe: Full Plate Shield
(20573, 8725, 1, 1, 2, 1053.616522), -- Life Stone - Level 52
(20573, 8735, 1, 1, 2, 263.359614), -- Mid-Grade Life Stone - Level 52
(20573, 8745, 1, 1, 2, 26.353768), -- High-Grade Life Stone - Level 52
(20573, 8755, 1, 1, 2, 5.34198), -- Top-Grade Life Stone - Level 52
(20573, 1342, 10, 30, 2, 75861.992178), -- Steel Arrow
-- Elder Tarlk Basilisk 
(20574, 1867, 1, 3, -1, 836382), -- Animal Skin
(20574, 1539, 1, 1, -1, 278794), -- Greater Healing Potion
(20574, 4601, 1, 1, -1, 2788), -- Greater Dye of STR (Str+3 Con-3)
(20574, 57, 497, 1009, 0, 700000), -- Adena
(20574, 75, 1, 1, 1, 2.616499), -- Caliburs
(20574, 2089, 1, 1, 1, 235.550644), -- Caliburs Edge
(20574, 76, 1, 1, 1, 2.616499), -- Sword of Delusion
(20574, 2090, 1, 1, 1, 235.550644), -- Delusional Blade
(20574, 77, 1, 1, 1, 2.616499), -- Tsurugi
(20574, 2091, 1, 1, 1, 235.550644), -- Tsurugi Blade
(20574, 84, 1, 1, 1, 2.616499), -- Homunkulus's Sword
(20574, 2092, 1, 1, 1, 235.550644), -- Homunkulus's Sword Blade
(20574, 134, 1, 1, 1, 2.616499), -- Sword of Nightmare
(20574, 2095, 1, 1, 1, 235.550644), -- Sword of Nightmare Blade
(20574, 145, 1, 1, 1, 2.616499), -- Sword of Whispering Death
(20574, 2096, 1, 1, 1, 235.547786), -- Sword of Whispering Death Blade
(20574, 1869, 1, 1, 2, 39908.739234), -- Iron Ore
(20574, 1864, 1, 1, 2, 79817.338965), -- Stem
(20574, 1880, 1, 1, 2, 3990.901824), -- Steel
(20574, 5550, 1, 1, 2, 532.064442), -- Durable Metal Plate
(20574, 4043, 1, 1, 2, 1330.300608), -- Asofe
(20574, 4122, 1, 1, 2, 1773.780645), -- Recipe: Maestro Holder (100%)
(20574, 4609, 1, 1, 2, 88.723908), -- Greater Dye of MEN (Men+3 Int-3)
(20574, 4123, 1, 1, 2, 1773.780645), -- Recipe: Maestro Anvil Lock (100%)
(20574, 8725, 1, 1, 2, 1108.630341), -- Life Stone - Level 52
(20574, 8735, 1, 1, 2, 277.192461), -- Mid-Grade Life Stone - Level 52
(20574, 8745, 1, 1, 2, 27.761097), -- High-Grade Life Stone - Level 52
(20574, 8755, 1, 1, 2, 5.58012), -- Top-Grade Life Stone - Level 52
(20574, 1539, 1, 1, 2, 8868.20571), -- Greater Healing Potion
-- Oel Mahum Warrior
(20575, 4598, 1, 1, -1, 4711), -- Greater Dye of MEN (Men+2 Wit-2)
(20575, 1806, 1, 1, -1, 2826), -- Recipe: Soulshot (B-Grade)
(20575, 1870, 1, 3, -1, 706598), -- Coal
(20575, 57, 558, 1137, 0, 700000), -- Adena
(20575, 135, 1, 1, 1, 5.534095), -- Samurai Longsword
(20575, 2115, 1, 1, 1, 597.588114), -- Samurai Longsword Blade
(20575, 5286, 1, 1, 1, 5.534095), -- Berserker Blade
(20575, 5530, 1, 1, 1, 598.343696), -- Berserker Blade Edge
(20575, 1870, 1, 1, 2, 40137.885173), -- Coal
(20575, 1865, 1, 1, 2, 40137.885173), -- Varnish
(20575, 1874, 1, 1, 2, 2675.846801), -- Oriharukon Ore
(20575, 4043, 1, 1, 2, 1337.96919), -- Asofe
(20575, 4039, 1, 1, 2, 1337.96919), -- Mold Glue
(20575, 4145, 1, 1, 2, 176.014838), -- Recipe: Avadon Leather Armor (100%)
(20575, 4184, 1, 1, 2, 46.247395), -- Recipe: Sprite's Staff (100%)
(20575, 5165, 1, 1, 2, 80.314783), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20575, 4180, 1, 1, 2, 4459.805721), -- Recipe: Silver Arrow (100%)
(20575, 8726, 1, 1, 2, 929.160534), -- Life Stone - Level 55
(20575, 8736, 1, 1, 2, 232.244344), -- Mid-Grade Life Stone - Level 55
(20575, 8746, 1, 1, 2, 23.261066), -- High-Grade Life Stone - Level 55
(20575, 8756, 1, 1, 2, 4.395792), -- Top-Grade Life Stone - Level 55
-- Oel Mahum Witch Doctor
(20576, 2119, 1, 1, -1, 12928), -- Crystal Dagger Blade
(20576, 4145, 1, 1, -1, 12443), -- Recipe: Avadon Leather Armor (100%)
(20576, 4591, 1, 1, -1, 9457), -- Greater Dye of CON (Con+2 Str-2)
(20576, 57, 1121, 2284, 0, 700000), -- Adena
(20576, 855, 1, 1, 1, 107.178066), -- Nassen's Earring
(20576, 1918, 1, 1, 1, 7561.673208), -- Nassen's Earring Gemstone
(20576, 119, 1, 1, 1, 80.395506), -- Necklace of Seal
(20576, 1920, 1, 1, 1, 5974.304355), -- Necklace of Seal Chain
(20576, 886, 1, 1, 1, 160.767099), -- Ring of Seal
(20576, 2917, 1, 1, 1, 10028.681766), -- Ring of Seal Gemstone
(20576, 1865, 1, 1, 2, 80579.603656), -- Varnish
(20576, 1870, 1, 1, 2, 80579.603656), -- Coal
(20576, 1879, 1, 1, 2, 13429.995894), -- Cokes
(20576, 1875, 1, 1, 2, 5371.924016), -- Stone of Purity
(20576, 4040, 1, 1, 2, 1611.540034), -- Mold Lubricant
(20576, 4187, 1, 1, 2, 92.741146), -- Recipe: Kris (100%)
(20576, 5155, 1, 1, 2, 161.135418), -- Recipe: Soulshot (B) Compressed Package (100%)
(20576, 5275, 1, 1, 2, 161.135418), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20576, 4178, 1, 1, 2, 1478.46857), -- Recipe: Zubei's Shield (100%)
(20576, 8726, 1, 1, 2, 1865.230744), -- Life Stone - Level 55
(20576, 8736, 1, 1, 2, 466.307686), -- Mid-Grade Life Stone - Level 55
(20576, 8746, 1, 1, 2, 46.649354), -- High-Grade Life Stone - Level 55
(20576, 8756, 1, 1, 2, 9.664408), -- Top-Grade Life Stone - Level 55
-- Leto Lizardman
(20577, 351, 1, 1, -1, 904), -- Blast Plate
(20577, 2030, 1, 1, -1, 8256), -- Tome of Blood Page
(20577, 2154, 1, 1, -1, 75575), -- Recipe: Elven Earring
(20577, 57, 298, 595, 0, 700000), -- Adena
(20577, 849, 1, 1, 1, 379.875645), -- Tiger's Eye Earring
(20577, 1901, 1, 1, 1, 12959.713458), -- Tiger's Eye Earring Stone
(20577, 912, 1, 1, 1, 284.754159), -- Near Forest Necklace
(20577, 880, 1, 1, 1, 568.656738), -- Black Pearl Ring
(20577, 1872, 1, 1, 2, 71486.457854), -- Animal Bone
(20577, 1867, 1, 1, 2, 71486.457854), -- Animal Skin
(20577, 1881, 1, 1, 2, 7148.693846), -- Coarse Bone Powder
(20577, 1875, 1, 1, 2, 3574.266822), -- Stone of Purity
(20577, 2154, 1, 1, 2, 5740.358064), -- Recipe: Elven Earring
(20577, 2274, 1, 1, 2, 382.88278), -- Recipe: Skull Breaker
(20577, 2270, 1, 1, 2, 382.88278), -- Recipe: Goat Head Staff
-- Leto Lizardman Archer
(20578, 1882, 1, 1, -1, 170581), -- Leather
(20578, 1939, 1, 1, -1, 67424), -- Mithril Banded Gaiters Material
(20578, 1901, 1, 1, -1, 106024), -- Tiger's Eye Earring Stone
(20578, 57, 324, 649, 0, 700000), -- Adena
(20578, 278, 1, 1, 1, 54.892406), -- Gastraphetes
(20578, 2029, 1, 1, 1, 2434.107594), -- Gastraphetes Shaft
(20578, 1868, 1, 1, 2, 136045.376456), -- Thread
(20578, 1873, 1, 1, 2, 27208.950842), -- Silver Nugget
(20578, 5549, 1, 1, 2, 6802.393272), -- Metallic Thread
(20578, 1889, 1, 1, 2, 4534.928848), -- Compound Braid
(20578, 2273, 1, 1, 2, 485.974126), -- Recipe: Tarbar
(20578, 6037, 1, 1, 2, 136045.376456), -- Waking Scroll
-- Leto Lizardman Soldier
(20579, 1943, 1, 1, -1, 63570), -- Manticore Skin Gaiters Pattern
(20579, 1946, 1, 1, -1, 108154), -- Rip Gauntlets Pattern
(20579, 1889, 1, 1, -1, 53356), -- Compound Braid
(20579, 57, 338, 675, 0, 700000), -- Adena
(20579, 1124, 1, 1, 1, 90.093708), -- Boots of Power
(20579, 1948, 1, 1, 1, 3494.156292), -- Boots of Power Pattern
(20579, 2424, 1, 1, 1, 90.093708), -- Manticore Skin Boots
(20579, 2923, 1, 1, 1, 3494.156292), -- Manticore Skin Boot Lining
(20579, 2425, 1, 1, 1, 90.093708), -- Brigandine Boots
(20579, 2924, 1, 1, 1, 3494.156292), -- Brigandine Boots Design
(20579, 2426, 1, 1, 1, 90.093708), -- Elven Mithril Boots
(20579, 2925, 1, 1, 1, 3494.156292), -- Elven Mithril Boots Design
(20579, 606, 1, 1, 1, 90.093708), -- Rip Gauntlets
(20579, 1946, 1, 1, 1, 3494.156292), -- Rip Gauntlets Pattern
(20579, 2448, 1, 1, 1, 90.093708), -- Manticore Skin Gloves
(20579, 2926, 1, 1, 1, 3494.156292), -- Manticore Skin Gloves Lining
(20579, 2449, 1, 1, 1, 90.093708), -- Brigandine Gauntlets
(20579, 2927, 1, 1, 1, 3494.156292), -- Brigandine Gauntlets Pattern
(20579, 2450, 1, 1, 1, 90.093708), -- Mithril Gloves
(20579, 2928, 1, 1, 1, 3494.156292), -- Mithril Gloves Design
(20579, 1868, 1, 1, 2, 118204.00097), -- Thread
(20579, 1873, 1, 1, 2, 23640.800194), -- Silver Nugget
(20579, 5549, 1, 1, 2, 5910.288725), -- Metallic Thread
(20579, 1889, 1, 1, 2, 3940.074248), -- Compound Braid
(20579, 2146, 1, 1, 2, 4221.533459), -- Recipe: Artisan's frame
(20579, 2286, 1, 1, 2, 328.280403), -- Recipe: Bonebreaker
(20579, 6668, 1, 1, 2, 21108.022001), -- Deluxe Chest Key - Grade 4
-- Leto Lizardman Warrior
(20580, 2031, 1, 1, -1, 15545), -- Morning Star Head
(20580, 1881, 1, 1, -1, 204752), -- Coarse Bone Powder
(20580, 1868, 1, 7, -1, 767821), -- Thread
(20580, 57, 649, 1296, 0, 700000), -- Adena
(20580, 395, 1, 1, 1, 230.755092), -- Manticore Skin Shirt
(20580, 1942, 1, 1, 1, 10122.343704), -- Manticore Skin Shirt Texture
(20580, 417, 1, 1, 1, 368.52486), -- Manticore Skin Gaiters
(20580, 1943, 1, 1, 1, 15762.376344), -- Manticore Skin Gaiters Pattern
(20580, 1868, 1, 1, 2, 264603.200807), -- Thread
(20580, 1873, 1, 1, 2, 52920.569394), -- Silver Nugget
(20580, 5549, 1, 1, 2, 13230.319267), -- Metallic Thread
(20580, 1889, 1, 1, 2, 8820.094899), -- Compound Braid
(20580, 2194, 1, 1, 2, 13527.896184), -- Recipe: Mithril Gloves
(20580, 2288, 1, 1, 2, 734.919449), -- Recipe: Ghost Staff
-- Leto Lizardman Shaman
(20581, 2202, 1, 1, -1, 88930), -- Recipe: Assault Boots
(20581, 2036, 1, 1, -1, 8804), -- Skull Breaker Head
(20581, 1902, 1, 1, -1, 88119), -- Elven Earring Beads
(20581, 57, 368, 733, 0, 700000), -- Adena
(20581, 279, 1, 1, 1, 41.86512), -- Reinforced Long Bow
(20581, 2040, 1, 1, 1, 2601.13488), -- Reinforced Long Bow Shaft
(20581, 1875, 1, 1, 2, 3330.25374), -- Stone of Purity
(20581, 1879, 1, 1, 2, 8325.729148), -- Cokes
(20581, 1885, 1, 1, 2, 4162.769776), -- High-Grade Suede
(20581, 5550, 1, 1, 2, 666.050748), -- Durable Metal Plate
(20581, 5549, 1, 1, 2, 4995.475408), -- Metallic Thread
(20581, 2287, 1, 1, 2, 277.568544), -- Recipe: Atuba Hammer
(20581, 2293, 1, 1, 2, 277.568544), -- Recipe: Glaive
(20581, 2198, 1, 1, 2, 1047.328304), -- Recipe: Sage's Rag
(20581, 1341, 10, 30, 2, 166513.255788), -- Bone Arrow
-- Leto Lizardman Overlord
(20582, 1942, 1, 1, -1, 88686), -- Manticore Skin Shirt Texture
(20582, 1894, 1, 1, -1, 61006), -- Crafted Leather
(20582, 1825, 1, 1, -1, 124192), -- Recipe: Oriharukon
(20582, 57, 726, 1449, 0, 700000), -- Adena
(20582, 629, 1, 1, 1, 496.832448), -- Kite Shield
(20582, 1947, 1, 1, 1, 21567.794024), -- Kite Shield Fragment
(20582, 2493, 1, 1, 1, 496.832448), -- Brigandine Shield
(20582, 2929, 1, 1, 1, 21567.794024), -- Brigandine Shield Fragment
(20582, 2411, 1, 1, 1, 347.95355), -- Brigandine Helmet
(20582, 2922, 1, 1, 1, 5768.793506), -- Brigandine Helmet Design
(20582, 1869, 1, 1, 2, 128395.14093), -- Iron Ore
(20582, 1864, 1, 3, 2, 85596.76062), -- Stem
(20582, 1880, 1, 1, 2, 12839.286236), -- Steel
(20582, 5550, 1, 1, 2, 1712.117498), -- Durable Metal Plate
(20582, 2987, 1, 1, 2, 12465.600756), -- Recipe: Plate Shield
(20582, 3020, 1, 1, 2, 713.19241), -- Recipe: Elven Long Sword
(20582, 1341, 20, 60, 2, 213991.90155), -- Bone Arrow
-- Timak Orc
(20583, 1944, 1, 1, -1, 46746), -- Mithril Tunic Fabric
(20583, 2157, 1, 1, -1, 75739), -- Recipe: Omen Beast's Eye Earring
(20583, 1903, 1, 1, -1, 152869), -- Elven Ring Piece
(20583, 57, 383, 764, 0, 700000), -- Adena
(20583, 261, 1, 1, 1, 44.109846), -- Bich'Hwa
(20583, 2039, 1, 1, 1, 2397.890154), -- Bich'Hwa Edge
(20583, 1870, 1, 1, 2, 78955.31538), -- Coal
(20583, 1865, 1, 1, 2, 78955.31538), -- Varnish
(20583, 1874, 1, 1, 2, 5263.61928), -- Oriharukon Ore
(20583, 2160, 1, 1, 2, 5093.95752), -- Recipe: Moonstone Earring
(20583, 2205, 1, 1, 2, 2498.57727), -- Recipe: Chain Gaiters
(20583, 5154, 1, 1, 2, 263.21517), -- Recipe: Soulshot (C) Compressed Package (100%)
-- Timak Orc Archer
(20584, 2988, 1, 1, -1, 52906), -- Recipe: Reinforced Mithril Gaiters
(20584, 2211, 1, 1, -1, 28114), -- Recipe: Plated Leather Armor
(20584, 1805, 1, 1, -1, 4180), -- Recipe: Soulshot (C-Grade)
(20584, 57, 508, 1017, 0, 700000), -- Adena
(20584, 280, 1, 1, 1, 45.401225), -- Light Crossbow
(20584, 2054, 1, 1, 1, 2679.598775), -- Light Crossbow Shaft
(20584, 1871, 1, 1, 2, 89948.031909), -- Charcoal
(20584, 1866, 1, 1, 2, 59965.290117), -- Suede
(20584, 1877, 1, 1, 2, 3597.905799), -- Adamantite Nugget
(20584, 2297, 1, 1, 2, 392.73801), -- Recipe: Flamberge
(20584, 5154, 1, 1, 2, 299.87385), -- Recipe: Soulshot (C) Compressed Package (100%)
(20584, 2994, 1, 1, 2, 7138.738833), -- Recipe: Boots of Seal
(20584, 6668, 1, 1, 2, 32124.421482), -- Deluxe Chest Key - Grade 4
-- Timak Orc Soldier
(20585, 2204, 1, 1, -1, 24481), -- Recipe: Chain Mail Shirt
(20585, 2308, 1, 1, -1, 5399), -- Recipe: Cursed Dagger
(20585, 1905, 1, 1, -1, 120264), -- Omen Beast's Eye Earring Gemstone
(20585, 57, 498, 1006, 0, 700000), -- Adena
(20585, 159, 1, 1, 1, 8.951877), -- Bonebreaker
(20585, 2048, 1, 1, 1, 513.264114), -- Bonebreaker Head
(20585, 187, 1, 1, 1, 8.951877), -- Atuba Hammer
(20585, 2049, 1, 1, 1, 513.264114), -- Atuba Hammer Head
(20585, 188, 1, 1, 1, 8.951877), -- Ghost Staff
(20585, 2050, 1, 1, 1, 544.225473), -- Ghost Staff Head
(20585, 189, 1, 1, 1, 8.951877), -- Staff of Life
(20585, 2051, 1, 1, 1, 544.225473), -- Staff of Life Shaft
(20585, 190, 1, 1, 1, 8.951877), -- Atuba Mace
(20585, 2058, 1, 1, 1, 513.261441), -- Atuba Mace Head
(20585, 1875, 1, 1, 2, 5912.493115), -- Stone of Purity
(20585, 1879, 1, 1, 2, 14781.25392), -- Cokes
(20585, 1885, 1, 1, 2, 7390.62696), -- High-Grade Suede
(20585, 5550, 1, 1, 2, 1182.49017), -- Durable Metal Plate
(20585, 5549, 1, 1, 2, 8868.760805), -- Metallic Thread
(20585, 2988, 1, 1, 2, 3742.100835), -- Recipe: Reinforced Mithril Gaiters
(20585, 2303, 1, 1, 2, 387.274195), -- Recipe: Skull Graver
-- Timak Orc Warrior
(20586, 3954, 1, 1, -1, 3974), -- Recipe: Blessed Spiritshot C
(20586, 2314, 1, 1, -1, 5206), -- Recipe: Body Slasher
(20586, 1884, 1, 1, -1, 733590), -- Cord
(20586, 57, 471, 957, 0, 700000), -- Adena
(20586, 70, 1, 1, 1, 21.582811), -- Claymore
(20586, 2047, 1, 1, 1, 1315.818139), -- Claymore Blade
(20586, 2499, 1, 1, 1, 21.582811), -- Elven Long Sword
(20586, 2967, 1, 1, 1, 1298.016239), -- Elven Long Sword Blade
(20586, 1895, 1, 1, 2, 21378.974327), -- Metallic Fiber
(20586, 2164, 1, 1, 2, 5755.868048), -- Recipe: Ring of Protection
(20586, 5154, 1, 1, 2, 249.427165), -- Recipe: Soulshot (C) Compressed Package (100%)
(20586, 2219, 1, 1, 2, 4647.593759), -- Recipe: Crimson Boots
(20586, 8723, 1, 1, 2, 2993.054254), -- Life Stone - Level 46
(20586, 8733, 1, 1, 2, 748.281495), -- Mid-Grade Life Stone - Level 46
(20586, 8743, 1, 1, 2, 74.810218), -- High-Grade Life Stone - Level 46
(20586, 8753, 1, 1, 2, 14.990734), -- Top-Grade Life Stone - Level 46
-- Timak Orc Shaman
(20587, 2062, 1, 1, -1, 8809), -- Scythe Edge
(20587, 1953, 1, 1, -1, 35975), -- Sage's Rag Lining
(20587, 1875, 1, 1, -1, 74876), -- Stone of Purity
(20587, 57, 442, 906, 0, 700000), -- Adena
(20587, 89, 1, 1, 1, 3.762928), -- Big Hammer
(20587, 2061, 1, 1, 1, 256.376172), -- Big Hammer Head
(20587, 160, 1, 1, 1, 3.762928), -- Battle Axe
(20587, 2063, 1, 1, 1, 256.376172), -- Battle Axe Head
(20587, 161, 1, 1, 1, 3.762928), -- Silver Axe
(20587, 2064, 1, 1, 1, 256.376172), -- Silver Axe Head
(20587, 173, 1, 1, 1, 3.762928), -- Skull Graver
(20587, 2065, 1, 1, 1, 256.376172), -- Skull Graver Head
(20587, 191, 1, 1, 1, 3.762928), -- Heavy Doom Hammer
(20587, 2066, 1, 1, 1, 260.145262), -- Heavy Doom Hammer Head
(20587, 192, 1, 1, 1, 3.762928), -- Crystal Staff
(20587, 2067, 1, 1, 1, 239.052736), -- Crystal Staff Head
(20587, 193, 1, 1, 1, 3.762928), -- Stick of Faith
(20587, 2068, 1, 1, 1, 239.052736), -- Stick of Faith Shaft
(20587, 194, 1, 1, 1, 3.762928), -- Heavy Doom Axe
(20587, 2069, 1, 1, 1, 260.141154), -- Heavy Doom Axe Blade
(20587, 1864, 1, 1, 2, 81664.211306), -- Stem
(20587, 1865, 1, 1, 2, 40832.23241), -- Varnish
(20587, 1866, 1, 1, 2, 27221.319264), -- Suede
(20587, 1873, 1, 1, 2, 16332.892964), -- Silver Nugget
(20587, 1868, 1, 1, 2, 81664.211306), -- Thread
(20587, 2323, 1, 1, 2, 142.221354), -- Recipe: Elemental Bow
(20587, 2225, 1, 1, 2, 887.552514), -- Recipe: Demon's Stockings
(20587, 2321, 1, 1, 2, 142.221354), -- Recipe: Stiletto
(20587, 3003, 1, 1, 2, 2536.154056), -- Recipe: Gloves of Seal
(20587, 8723, 1, 1, 2, 1633.390702), -- Life Stone - Level 46
(20587, 8733, 1, 1, 2, 408.411054), -- Mid-Grade Life Stone - Level 46
(20587, 8743, 1, 1, 2, 40.815754), -- High-Grade Life Stone - Level 46
(20587, 8753, 1, 1, 2, 8.365962), -- Top-Grade Life Stone - Level 46
-- Timak Orc Overlord
(20588, 1959, 1, 1, -1, 59745), -- Chain Mail Shirt Material
(20588, 2324, 1, 1, -1, 7728), -- Recipe: Noble Elven Bow
(20588, 57, 585, 1188, 0, 700000), -- Adena
(20588, 71, 1, 1, 1, 19.824375), -- Flamberge
(20588, 2059, 1, 1, 1, 1297.92295), -- Flamberge Blade
(20588, 72, 1, 1, 1, 19.824375), -- Stormbringer
(20588, 2060, 1, 1, 1, 1387.4283), -- Stormbringer Blade
(20588, 1868, 1, 1, 2, 127063.620066), -- Thread
(20588, 1873, 1, 1, 2, 25412.65443), -- Silver Nugget
(20588, 5549, 1, 1, 2, 6353.120118), -- Metallic Thread
(20588, 1889, 1, 1, 2, 4235.529384), -- Compound Braid
(20588, 4044, 1, 1, 2, 2117.764692), -- Thons
(20588, 3003, 1, 1, 2, 3946.063272), -- Recipe: Gloves of Seal
(20588, 2214, 1, 1, 2, 1576.407396), -- Recipe: Dwarven Chain Gaiters
(20588, 8723, 1, 1, 2, 2541.352422), -- Life Stone - Level 46
(20588, 8733, 1, 1, 2, 635.294616), -- Mid-Grade Life Stone - Level 46
(20588, 8743, 1, 1, 2, 63.49467), -- High-Grade Life Stone - Level 46
(20588, 8753, 1, 1, 2, 12.698934), -- Top-Grade Life Stone - Level 46
-- Fline
(20589, 1961, 1, 1, -1, 70730), -- Mithril Shirt Fabric
(20589, 1962, 1, 1, -1, 70730), -- Karmian Tunic Pattern
(20589, 1908, 1, 1, -1, 209311), -- Moonstone Earring Wire
(20589, 57, 874, 1776, 0, 700000), -- Adena
(20589, 439, 1, 1, 1, 179.491936), -- Karmian Tunic
(20589, 1962, 1, 1, 1, 8357.661397), -- Karmian Tunic Pattern
(20589, 471, 1, 1, 1, 286.860088), -- Karmian Stockings
(20589, 1954, 1, 1, 1, 13884.986579), -- Karmian Stocking Design
(20589, 1868, 1, 1, 2, 189933.663237), -- Thread
(20589, 1873, 1, 1, 2, 37986.628635), -- Silver Nugget
(20589, 5549, 1, 1, 2, 9496.592151), -- Metallic Thread
(20589, 1889, 1, 1, 2, 6331.234788), -- Compound Braid
(20589, 4044, 1, 1, 2, 3165.617394), -- Thons
(20589, 3003, 1, 1, 2, 5898.543204), -- Recipe: Gloves of Seal
(20589, 2214, 1, 1, 2, 2356.400922), -- Recipe: Dwarven Chain Gaiters
(20589, 8723, 1, 1, 2, 3798.792879), -- Life Stone - Level 46
(20589, 8733, 1, 1, 2, 949.633212), -- Mid-Grade Life Stone - Level 46
(20589, 8743, 1, 1, 2, 94.911315), -- High-Grade Life Stone - Level 46
(20589, 8753, 1, 1, 2, 18.982263), -- Top-Grade Life Stone - Level 46
-- Liele
(20590, 2935, 1, 1, -1, 121583), -- Reinforced Mithril Gaiters Fragment
(20590, 2068, 1, 1, -1, 16483), -- Stick of Faith Shaft
(20590, 2163, 1, 1, -1, 116683), -- Recipe: Earring of Protection
(20590, 57, 901, 1842, 0, 700000), -- Adena
(20590, 354, 1, 1, 1, 139.06922), -- Chain Mail Shirt
(20590, 1959, 1, 1, 1, 7278.06059), -- Chain Mail Shirt Material
(20590, 381, 1, 1, 1, 222.47484), -- Chain Gaiters
(20590, 1960, 1, 1, 1, 14805.39535), -- Chain Gaiters Part
(20590, 1867, 1, 1, 2, 131013.650376), -- Animal Skin
(20590, 1872, 1, 1, 2, 131013.650376), -- Animal Bone
(20590, 1882, 1, 1, 2, 21835.707138), -- Leather
(20590, 1894, 1, 1, 2, 3447.774414), -- Crafted Leather
(20590, 4042, 1, 1, 2, 1637.537328), -- Enria
(20590, 2230, 1, 1, 2, 1904.140728), -- Recipe: Theca Leather Gaiters
(20590, 2320, 1, 1, 2, 342.437256), -- Recipe: Cursed Staff
(20590, 8723, 1, 1, 2, 3930.326568), -- Life Stone - Level 46
(20590, 8733, 1, 1, 2, 982.581642), -- Mid-Grade Life Stone - Level 46
(20590, 8743, 1, 1, 2, 98.347032), -- High-Grade Life Stone - Level 46
(20590, 8753, 1, 1, 2, 19.847142), -- Top-Grade Life Stone - Level 46
-- Valley Treant
(20591, 2947, 1, 1, -1, 191540), -- Dwarven Chain Shield Fragment
(20591, 951, 1, 1, -1, 4876), -- Scroll: Enchant Weapon (C-Grade)
(20591, 1911, 1, 1, -1, 199446), -- Earring of Protection Gemstone
(20591, 57, 1058, 2159, 0, 700000), -- Adena
(20591, 94, 1, 1, 1, 53.767405), -- Bec de Corbin
(20591, 2079, 1, 1, 1, 4081.232595), -- Bec De Corbin Blade
(20591, 1867, 1, 1, 2, 144016.564776), -- Animal Skin
(20591, 1872, 1, 1, 2, 144016.564776), -- Animal Bone
(20591, 1882, 1, 1, 2, 24002.869338), -- Leather
(20591, 1894, 1, 1, 2, 3789.961014), -- Crafted Leather
(20591, 4042, 1, 1, 2, 1800.060528), -- Enria
(20591, 2230, 1, 1, 2, 2093.123928), -- Recipe: Theca Leather Gaiters
(20591, 2320, 1, 1, 2, 376.423656), -- Recipe: Cursed Staff
(20591, 8723, 1, 1, 2, 4320.405768), -- Life Stone - Level 46
(20591, 8733, 1, 1, 2, 1080.101442), -- Mid-Grade Life Stone - Level 46
(20591, 8743, 1, 1, 2, 108.107832), -- High-Grade Life Stone - Level 46
(20591, 8753, 1, 1, 2, 21.816942), -- Top-Grade Life Stone - Level 46
-- Satyr
(20592, 1880, 1, 1, -1, 368745), -- Steel
(20592, 2951, 1, 1, -1, 310131), -- Rind Leather Gloves Design
(20592, 2166, 1, 1, -1, 124998), -- Recipe: Earrings of Binding (100%)
(20592, 57, 1458, 2964, 0, 700000), -- Adena
(20592, 195, 1, 1, 1, 36.971484), -- Cursed Staff
(20592, 2082, 1, 1, 1, 2879.003028), -- Cursed Staff Head
(20592, 2502, 1, 1, 1, 36.971484), -- Dwarven War Hammer
(20592, 2968, 1, 1, 1, 2756.054004), -- Dwarven War Hammer Head
(20592, 1871, 1, 1, 2, 148529.640306), -- Charcoal
(20592, 1866, 1, 1, 2, 99019.85037), -- Suede
(20592, 1877, 1, 1, 2, 5941.218072), -- Adamantite Nugget
(20592, 4041, 1, 1, 2, 1291.62795), -- Mold Hardener
(20592, 4040, 1, 1, 2, 2970.609036), -- Mold Lubricant
(20592, 2340, 1, 1, 2, 345.425946), -- Recipe: Pa'agrian Hammer
(20592, 3006, 1, 1, 2, 6062.401176), -- Recipe: Demon's Gloves
(20592, 8724, 1, 1, 2, 4950.924894), -- Life Stone - Level 49
(20592, 8734, 1, 1, 2, 1237.798848), -- Mid-Grade Life Stone - Level 49
(20592, 8744, 1, 1, 2, 123.888084), -- High-Grade Life Stone - Level 49
(20592, 8754, 1, 1, 2, 24.615318), -- Top-Grade Life Stone - Level 49
-- Unicorn
(20593, 2083, 1, 1, -1, 26308), -- Stiletto Edge
(20593, 2341, 1, 1, -1, 9208), -- Recipe: Sage's Staff
(20593, 1912, 1, 1, -1, 426659), -- Ring of Protection Gemstone
(20593, 57, 1563, 3187, 0, 700000), -- Adena
(20593, 398, 1, 1, 1, 127.866228), -- Plated Leather
(20593, 1966, 1, 1, 1, 8005.832895), -- Plated Leather Fragment
(20593, 399, 1, 1, 1, 117.910106), -- Rind Leather Armor
(20593, 1975, 1, 1, 1, 7202.472588), -- Rind Leather Armor Design
(20593, 418, 1, 1, 1, 204.47077), -- Plated Leather Gaiters
(20593, 1967, 1, 1, 1, 11959.606418), -- Plated Leather Gaiters Material
(20593, 419, 1, 1, 1, 188.796049), -- Rind Leather Gaiters
(20593, 1976, 1, 1, 1, 13334.044946), -- Rind Leather Gaiters Material
(20593, 1871, 1, 1, 2, 159483.576359), -- Charcoal
(20593, 1866, 1, 1, 2, 106322.481055), -- Suede
(20593, 1877, 1, 1, 2, 6379.377908), -- Adamantite Nugget
(20593, 4041, 1, 1, 2, 1386.884425), -- Mold Hardener
(20593, 4040, 1, 1, 2, 3189.688954), -- Mold Lubricant
(20593, 2340, 1, 1, 2, 370.900819), -- Recipe: Pa'agrian Hammer
(20593, 3006, 1, 1, 2, 6509.498164), -- Recipe: Demon's Gloves
(20593, 8724, 1, 1, 2, 5316.051441), -- Life Stone - Level 49
(20593, 8734, 1, 1, 2, 1329.085472), -- Mid-Grade Life Stone - Level 49
(20593, 8744, 1, 1, 2, 133.024726), -- High-Grade Life Stone - Level 49
(20593, 8754, 1, 1, 2, 26.430677), -- Top-Grade Life Stone - Level 49
-- Forest Runner
(20594, 1978, 1, 1, -1, 173613), -- Tower Shield Fragment
(20594, 1871, 1, 5, -1, 902788), -- Charcoal
(20594, 1895, 1, 1, -1, 773819), -- Metallic Fiber
(20594, 57, 1071, 2178, 0, 700000), -- Adena
(20594, 231, 1, 1, 1, 16.948312), -- Grace Dagger
(20594, 2106, 1, 1, 1, 1526.051688), -- Grace Dagger Edge
(20594, 233, 1, 1, 1, 16.948312), -- Dark Screamer
(20594, 2107, 1, 1, 1, 1526.051688), -- Dark Screamer Edge
(20594, 1867, 1, 1, 2, 114873.23559), -- Animal Skin
(20594, 1872, 1, 1, 2, 114873.23559), -- Animal Bone
(20594, 1882, 1, 1, 2, 19145.400232), -- Leather
(20594, 1894, 1, 1, 2, 3022.855486), -- Crafted Leather
(20594, 4042, 1, 1, 2, 1435.932824), -- Enria
(20594, 2234, 1, 1, 2, 1284.108788), -- Recipe: Divine Stockings
(20594, 4609, 1, 1, 2, 191.587474), -- Greater Dye of MEN (Men+3 Int-3)
(20594, 2356, 1, 1, 2, 140.42333), -- Recipe: Demon's Staff
(20594, 6669, 1, 1, 2, 20036.04563), -- Deluxe Chest Key - Grade 5
(20594, 8725, 1, 1, 2, 2393.314062), -- Life Stone - Level 52
(20594, 8735, 1, 1, 2, 598.398032), -- Mid-Grade Life Stone - Level 52
(20594, 8745, 1, 1, 2, 59.78419), -- High-Grade Life Stone - Level 52
(20594, 8755, 1, 1, 2, 11.678772), -- Top-Grade Life Stone - Level 52
-- Fline Elder
(20595, 2096, 1, 1, -1, 15374), -- Sword of Whispering Death Blade
(20595, 2354, 1, 1, -1, 4602), -- Recipe: Deadman's Staff
(20595, 1894, 1, 1, -1, 98988), -- Crafted Leather
(20595, 57, 1117, 2270, 0, 700000), -- Adena
(20595, 231, 1, 1, 1, 17.651288), -- Grace Dagger
(20595, 2106, 1, 1, 1, 1589.348712), -- Grace Dagger Edge
(20595, 233, 1, 1, 1, 17.651288), -- Dark Screamer
(20595, 2107, 1, 1, 1, 1589.348712), -- Dark Screamer Edge
(20595, 1870, 1, 1, 2, 106059.604608), -- Coal
(20595, 1865, 1, 1, 2, 106059.604608), -- Varnish
(20595, 1874, 1, 1, 2, 7070.62446), -- Oriharukon Ore
(20595, 4043, 1, 1, 2, 3535.431084), -- Asofe
(20595, 4039, 1, 1, 2, 3535.431084), -- Mold Glue
(20595, 4125, 1, 1, 2, 4713.74964), -- Recipe: Maestro Mold (100%)
(20595, 3014, 1, 1, 2, 2962.554804), -- Recipe: Full Plate Boots
(20595, 8725, 1, 1, 2, 2946.152952), -- Life Stone - Level 52
(20595, 8735, 1, 1, 2, 736.419384), -- Mid-Grade Life Stone - Level 52
(20595, 8745, 1, 1, 2, 73.68948), -- High-Grade Life Stone - Level 52
(20595, 8755, 1, 1, 2, 14.737896), -- Top-Grade Life Stone - Level 52
-- Liele Elder
(20596, 1875, 1, 1, -1, 199596), -- Stone of Purity
(20596, 1539, 1, 1, -1, 665319), -- Greater Healing Potion
(20596, 4609, 1, 1, -1, 6653), -- Greater Dye of MEN (Men+3 Int-3)
(20596, 57, 1189, 2403, 0, 700000), -- Adena
(20596, 162, 1, 1, 1, 4.683114), -- War Axe
(20596, 2097, 1, 1, 1, 414.443528), -- War Axe Blade
(20596, 174, 1, 1, 1, 4.683114), -- Nirvana Axe
(20596, 2098, 1, 1, 1, 414.443528), -- Nirvana Axe Blade
(20596, 196, 1, 1, 1, 4.683114), -- Stick of Eternity
(20596, 2099, 1, 1, 1, 436.170558), -- Stick of Eternity Shaft
(20596, 197, 1, 1, 1, 4.683114), -- Paradia Staff
(20596, 2100, 1, 1, 1, 436.170558), -- Paradia Staff Head
(20596, 199, 1, 1, 1, 4.683114), -- Pa'agrian Hammer
(20596, 2102, 1, 1, 1, 420.525718), -- Pa'agrian Hammer Head
(20596, 200, 1, 1, 1, 4.683114), -- Sage's Staff
(20596, 2103, 1, 1, 1, 436.170558), -- Sage's Staff Head
(20596, 201, 1, 1, 1, 4.683114), -- Club of Nature
(20596, 2104, 1, 1, 1, 436.170558), -- Club of Nature Head
(20596, 202, 1, 1, 1, 4.683114), -- Mace of Underworld
(20596, 2105, 1, 1, 1, 414.440082), -- Mace of Underworld Head
(20596, 1873, 1, 1, 2, 35374.5169), -- Silver Nugget
(20596, 1868, 1, 1, 2, 176872.0131), -- Thread
(20596, 1876, 1, 1, 2, 17687.1156), -- Mithril Ore
(20596, 1895, 1, 1, 2, 25267.308), -- Metallic Fiber
(20596, 4042, 1, 1, 2, 1473.9263), -- Enria
(20596, 4608, 1, 1, 2, 196.5616), -- Greater Dye of INT (Int+3 Wit-3)
(20596, 3017, 1, 1, 2, 2470.1622), -- Recipe: Divine Gloves
(20596, 5155, 1, 1, 2, 176.8483), -- Recipe: Soulshot (B) Compressed Package (100%)
(20596, 6669, 1, 1, 2, 20566.4002), -- Deluxe Chest Key - Grade 5
(20596, 8725, 1, 1, 2, 2456.4486), -- Life Stone - Level 52
(20596, 8735, 1, 1, 2, 614.255), -- Mid-Grade Life Stone - Level 52
(20596, 8745, 1, 1, 2, 61.4255), -- High-Grade Life Stone - Level 52
(20596, 8755, 1, 1, 2, 12.8565), -- Top-Grade Life Stone - Level 52
-- Valley Treant Elder
(20597, 3034, 1, 1, -1, 9970), -- Recipe: Spiritshot B
(20597, 2113, 1, 1, -1, 24141), -- Scorpion Blade
(20597, 1918, 1, 1, -1, 215903), -- Nassen's Earring Gemstone
(20597, 57, 1973, 4008, 0, 700000), -- Adena
(20597, 442, 1, 1, 1, 111.55485), -- Divine Tunic
(20597, 1988, 1, 1, 1, 8841.906414), -- Divine Tunic Fabric
(20597, 473, 1, 1, 1, 178.441758), -- Divine Stockings
(20597, 1989, 1, 1, 1, 13869.096978), -- Divine Stocking Pattern
(20597, 1870, 1, 1, 2, 153390.651687), -- Coal
(20597, 1865, 1, 1, 2, 153390.651687), -- Varnish
(20597, 1874, 1, 1, 2, 10226.110776), -- Oriharukon Ore
(20597, 4043, 1, 1, 2, 5113.055388), -- Asofe
(20597, 4039, 1, 1, 2, 5113.055388), -- Mold Glue
(20597, 4133, 1, 1, 2, 737.602341), -- Recipe: Zubei's Breastplate (100%)
(20597, 4959, 1, 1, 2, 2955.459129), -- Recipe: Sealed Avadon Boots (60%)
(20597, 4941, 1, 1, 2, 1179.961755), -- Recipe: Zubei's Gaiters (60%)
(20597, 8726, 1, 1, 2, 3550.658097), -- Life Stone - Level 55
(20597, 8736, 1, 1, 2, 887.748687), -- Mid-Grade Life Stone - Level 55
(20597, 8746, 1, 1, 2, 88.875864), -- High-Grade Life Stone - Level 55
(20597, 8756, 1, 1, 2, 17.169201), -- Top-Grade Life Stone - Level 55
-- Satyr Elder
(20598, 4180, 1, 1, -1, 512556), -- Recipe: Silver Arrow (100%)
(20598, 2120, 1, 1, -1, 22159), -- Great Pata Blade
(20598, 1806, 1, 1, -1, 9226), -- Recipe: Soulshot (B-Grade)
(20598, 57, 1822, 3711, 0, 700000), -- Adena
(20598, 442, 1, 1, 1, 103.2274), -- Divine Tunic
(20598, 1988, 1, 1, 1, 8181.867576), -- Divine Tunic Fabric
(20598, 473, 1, 1, 1, 165.121272), -- Divine Stockings
(20598, 1989, 1, 1, 1, 12833.783752), -- Divine Stocking Pattern
(20598, 1864, 1, 3, 2, 141938.691444), -- Stem
(20598, 1869, 1, 1, 2, 141938.691444), -- Iron Ore
(20598, 1878, 1, 1, 2, 56775.740571), -- Braided Hemp
(20598, 1884, 1, 1, 2, 87347.056269), -- Cord
(20598, 4039, 1, 1, 2, 4731.201717), -- Mold Glue
(20598, 4178, 1, 1, 2, 2604.294891), -- Recipe: Zubei's Shield (100%)
(20598, 4184, 1, 1, 2, 163.675908), -- Recipe: Sprite's Staff (100%)
(20598, 5160, 1, 1, 2, 283.792905), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20598, 8726, 1, 1, 2, 3285.837852), -- Life Stone - Level 55
(20598, 8736, 1, 1, 2, 821.459463), -- Mid-Grade Life Stone - Level 55
(20598, 8746, 1, 1, 2, 82.277943), -- High-Grade Life Stone - Level 55
(20598, 8756, 1, 1, 2, 16.279593), -- Top-Grade Life Stone - Level 55
-- Unicorn Elder
(20599, 2120, 1, 1, -1, 23008), -- Great Pata Blade
(20599, 4146, 1, 1, -1, 30703), -- Recipe: Tunic of Zubei (100%)
(20599, 4590, 1, 1, -1, 15966), -- Greater Dye of STR (Str+2 Dex-2)
(20599, 57, 1893, 3856, 0, 700000), -- Adena
(20599, 2436, 1, 1, 1, 119.39733), -- Theca Leather Boots
(20599, 2954, 1, 1, 1, 7996.6068), -- Theca Leather Boots Texture
(20599, 2437, 1, 1, 1, 91.85982), -- Drake Leather Boots
(20599, 2960, 1, 1, 1, 6879.72831), -- Drake Leather Boots Design
(20599, 2438, 1, 1, 1, 91.85982), -- Full Plate Boots
(20599, 2961, 1, 1, 1, 6879.72831), -- Full Plate Boots Part
(20599, 2460, 1, 1, 1, 119.39733), -- Theca Leather Gloves
(20599, 2955, 1, 1, 1, 7996.6068), -- Theca Leather Gloves Texture
(20599, 2461, 1, 1, 1, 91.85982), -- Drake Leather Gloves
(20599, 2962, 1, 1, 1, 6879.72831), -- Drake Leather Gloves Design
(20599, 2462, 1, 1, 1, 91.85982), -- Full Plate Gauntlets
(20599, 2963, 1, 1, 1, 6879.72831), -- Full Plate Gauntlets Part
(20599, 2463, 1, 1, 1, 91.85982), -- Divine Gloves
(20599, 2964, 1, 1, 1, 6879.7794), -- Divine Gloves Pattern
(20599, 1864, 1, 3, 2, 147375.724428), -- Stem
(20599, 1869, 1, 1, 2, 147375.724428), -- Iron Ore
(20599, 1878, 1, 1, 2, 58950.563877), -- Braided Hemp
(20599, 1884, 1, 1, 2, 90692.929203), -- Cord
(20599, 4039, 1, 1, 2, 4912.432779), -- Mold Glue
(20599, 4178, 1, 1, 2, 2704.053717), -- Recipe: Zubei's Shield (100%)
(20599, 4184, 1, 1, 2, 169.945596), -- Recipe: Sprite's Staff (100%)
(20599, 5160, 1, 1, 2, 294.663735), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20599, 8726, 1, 1, 2, 3411.703524), -- Life Stone - Level 55
(20599, 8736, 1, 1, 2, 852.925881), -- Mid-Grade Life Stone - Level 55
(20599, 8746, 1, 1, 2, 85.429641), -- High-Grade Life Stone - Level 55
(20599, 8756, 1, 1, 2, 16.903191), -- Top-Grade Life Stone - Level 55
-- Karul Bugbear
(20600, 1945, 1, 1, -1, 85765), -- Mithril Stocking Design
(20600, 1873, 1, 1, -1, 431910), -- Silver Nugget
(20600, 1825, 1, 1, -1, 77127), -- Recipe: Oriharukon
(20600, 57, 451, 900, 0, 700000), -- Adena
(20600, 629, 1, 1, 1, 308.545152), -- Kite Shield
(20600, 1947, 1, 1, 1, 13394.129776), -- Kite Shield Fragment
(20600, 2493, 1, 1, 1, 308.545152), -- Brigandine Shield
(20600, 2929, 1, 1, 1, 13394.129776), -- Brigandine Shield Fragment
(20600, 2411, 1, 1, 1, 216.0877), -- Brigandine Helmet
(20600, 2922, 1, 1, 1, 3582.562444), -- Brigandine Helmet Design
(20600, 1868, 1, 1, 2, 186053.4229), -- Thread
(20600, 1873, 1, 1, 2, 37210.68458), -- Silver Nugget
(20600, 5549, 1, 1, 2, 9302.54818), -- Metallic Thread
(20600, 1889, 1, 1, 2, 6201.86274), -- Compound Braid
(20600, 5231, 1, 1, 2, 6644.78267), -- Recipe: Metal Hardener (100%)
(20600, 2286, 1, 1, 2, 516.69893), -- Recipe: Bonebreaker
-- Tamlin Orc
(20601, 1880, 1, 1, -1, 97232), -- Steel
(20601, 2304, 1, 1, -1, 4246), -- Recipe: Heavy Doom Hammer
(20601, 1905, 1, 1, -1, 94584), -- Omen Beast's Eye Earring Gemstone
(20601, 57, 394, 788, 0, 700000), -- Adena
(20601, 353, 1, 1, 1, 81.160755), -- Half Plate Armor
(20601, 1950, 1, 1, 1, 3961.994595), -- Half Plate Temper
(20601, 380, 1, 1, 1, 129.859275), -- Plate Gaiters
(20601, 1951, 1, 1, 1, 6161.985375), -- Plate Gaiters Part
(20601, 1869, 1, 1, 2, 81375.90135), -- Iron Ore
(20601, 1864, 1, 1, 2, 162751.8027), -- Stem
(20601, 1880, 1, 1, 2, 8137.590135), -- Steel
(20601, 5550, 1, 1, 2, 1085.029155), -- Durable Metal Plate
(20601, 2199, 1, 1, 2, 3433.483635), -- Recipe: Karmian Stockings
(20601, 5269, 1, 1, 2, 271.193025), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
-- Tamlin Orc Archer
(20602, 1889, 1, 1, -1, 87565), -- Compound Braid
(20602, 2999, 1, 1, -1, 88153), -- Recipe: Plated Leather Gloves
(20602, 1873, 1, 1, -1, 525391), -- Silver Nugget
(20602, 57, 529, 1069, 0, 700000), -- Adena
(20602, 280, 1, 1, 1, 47.550494), -- Light Crossbow
(20602, 2054, 1, 1, 1, 2806.449506), -- Light Crossbow Shaft
(20602, 1873, 1, 1, 2, 32978.3484), -- Silver Nugget
(20602, 1868, 1, 1, 2, 164892.22504), -- Thread
(20602, 1876, 1, 1, 2, 16489.29496), -- Mithril Ore
(20602, 1895, 1, 1, 2, 23555.92864), -- Metallic Fiber
(20602, 2300, 1, 1, 2, 360.10632), -- Recipe: Scythe
(20602, 2205, 1, 1, 2, 2609.14056), -- Recipe: Chain Gaiters
(20602, 5154, 1, 1, 2, 274.84976), -- Recipe: Soulshot (C) Compressed Package (100%)
(20602, 2311, 1, 1, 2, 360.10632), -- Recipe: Chakram
-- Kronbe Spider
(20603, 1952, 1, 1, -1, 34740), -- Salamander Skin Mail Texture
(20603, 2311, 1, 1, -1, 4736), -- Recipe: Chakram
(20603, 1872, 1, 3, -1, 723055), -- Animal Bone
(20603, 57, 429, 871, 0, 700000), -- Adena
(20603, 1125, 1, 1, 1, 120.706722), -- Assault Boots
(20603, 1957, 1, 1, 1, 5065.605866), -- Assault Boots Part
(20603, 2427, 1, 1, 1, 120.706722), -- Salamander Skin Boots
(20603, 2931, 1, 1, 1, 5065.605866), -- Salamander Skin Boot Lining
(20603, 2428, 1, 1, 1, 120.706722), -- Plate Boots
(20603, 2932, 1, 1, 1, 5065.605866), -- Plate Boots Design
(20603, 61, 1, 1, 1, 120.706722), -- Mithril Plate Gloves
(20603, 1949, 1, 1, 1, 5065.605866), -- Mithril Gloves Design
(20603, 607, 1, 1, 1, 120.706722), -- Ogre Power Gauntlets
(20603, 1963, 1, 1, 1, 5065.605866), -- Ogre Power Gauntlets Part
(20603, 2451, 1, 1, 1, 120.706722), -- Sage's Worn Gloves
(20603, 2933, 1, 1, 1, 5065.730338), -- Sage's Worn Gloves Lining
(20603, 1872, 1, 1, 2, 103738.405455), -- Animal Bone
(20603, 1867, 1, 1, 2, 103738.405455), -- Animal Skin
(20603, 1881, 1, 1, 2, 10373.969175), -- Coarse Bone Powder
(20603, 1875, 1, 1, 2, 5186.855958), -- Stone of Purity
(20603, 2991, 1, 1, 2, 6174.987777), -- Recipe: Karmian Boots
(20603, 5279, 1, 1, 2, 259.317072), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20603, 6668, 1, 1, 2, 27787.059108), -- Deluxe Chest Key - Grade 4
-- Lakin
(20604, 2323, 1, 1, -1, 4611), -- Recipe: Elemental Bow
(20604, 2322, 1, 1, -1, 4611), -- Recipe: Soulfire Dirk
(20604, 4553, 1, 1, -1, 5293), -- Greater Dye of STR (Str+1 Con-1)
(20604, 57, 521, 1068, 0, 700000), -- Adena
(20604, 852, 1, 1, 1, 174.744034), -- Moonstone Earring
(20604, 1908, 1, 1, 1, 9871.30634), -- Moonstone Earring Wire
(20604, 915, 1, 1, 1, 131.114666), -- Aquastone Necklace
(20604, 1910, 1, 1, 1, 7849.467052), -- Aquastone Necklace Chain
(20604, 883, 1, 1, 1, 262.229332), -- Aquastone Ring
(20604, 1909, 1, 1, 1, 14077.138576), -- Aquastone Ring Wire
(20604, 1872, 1, 1, 2, 119127.041145), -- Animal Bone
(20604, 1867, 1, 1, 2, 119127.041145), -- Animal Skin
(20604, 1881, 1, 1, 2, 11912.851825), -- Coarse Bone Powder
(20604, 1875, 1, 1, 2, 5956.278202), -- Stone of Purity
(20604, 2991, 1, 1, 2, 7090.990263), -- Recipe: Karmian Boots
(20604, 5279, 1, 1, 2, 297.784368), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
(20604, 6668, 1, 1, 2, 31909.013052), -- Deluxe Chest Key - Grade 4
-- Weird Drake
(20605, 2059, 1, 1, -1, 8915), -- Flamberge Blade
(20605, 1867, 1, 3, -1, 800154), -- Animal Skin
(20605, 1908, 1, 1, -1, 113658), -- Moonstone Earring Wire
(20605, 57, 475, 964, 0, 700000), -- Adena
(20605, 439, 1, 1, 1, 97.464224), -- Karmian Tunic
(20605, 1962, 1, 1, 1, 4538.214923), -- Karmian Tunic Pattern
(20605, 471, 1, 1, 1, 155.765192), -- Karmian Stockings
(20605, 1954, 1, 1, 1, 7539.555661), -- Karmian Stocking Design
(20605, 1868, 1, 1, 2, 103136.2924), -- Thread
(20605, 1873, 1, 1, 2, 20627.202), -- Silver Nugget
(20605, 5549, 1, 1, 2, 5156.7652), -- Metallic Thread
(20605, 1889, 1, 1, 2, 3437.9376), -- Compound Braid
(20605, 4044, 1, 1, 2, 1718.9688), -- Thons
(20605, 3003, 1, 1, 2, 3202.9808), -- Recipe: Gloves of Seal
(20605, 2214, 1, 1, 2, 1279.5544), -- Recipe: Dwarven Chain Gaiters
(20605, 8723, 1, 1, 2, 2062.7908), -- Life Stone - Level 46
(20605, 8733, 1, 1, 2, 515.6624), -- Mid-Grade Life Stone - Level 46
(20605, 8743, 1, 1, 2, 51.538), -- High-Grade Life Stone - Level 46
(20605, 8753, 1, 1, 2, 10.3076), -- Top-Grade Life Stone - Level 46
-- Kuran Kobold
(20606, 2260, 1, 1, -1, 12244), -- Recipe: Mace of Judgment
(20606, 1932, 1, 1, -1, 125162), -- Bone Helmet Design
(20606, 2152, 1, 1, -1, 138824), -- Recipe: Enchanted Necklace
(20606, 57, 340, 656, 0, 700000), -- Adena
(20606, 220, 1, 1, 1, 281), -- Crafted Dagger
(20606, 1869, 1, 1, 2, 88508.21265), -- Iron Ore
(20606, 1864, 1, 1, 2, 177016.4253), -- Stem
(20606, 1880, 1, 1, 2, 8850.95973), -- Steel
(20606, 5550, 1, 1, 2, 1179.99873), -- Durable Metal Plate
(20606, 2262, 1, 1, 2, 1374.40359), -- Recipe: Elven Bow
-- Kuran Kobold Warrior
(20607, 626, 1, 1, -1, 9809), -- Bronze Shield
(20607, 2020, 1, 1, -1, 14509), -- Temptation of Abyss Piece
(20607, 1899, 1, 1, -1, 129508), -- Necklace of Devotion Chain
(20607, 57, 355, 696, 0, 700000), -- Adena
(20607, 101, 1, 1, 1, 59.073875), -- Scroll of Wisdom
(20607, 312, 1, 1, 1, 59.073875), -- Branch of Life
(20607, 313, 1, 1, 1, 59.073875), -- Temptation of Abyss
(20607, 2020, 1, 1, 1, 1628.70823), -- Temptation of Abyss Piece
(20607, 314, 1, 1, 1, 59.070145), -- Proof of Revenge
(20607, 1870, 1, 1, 2, 116293.764398), -- Coal
(20607, 1865, 1, 1, 2, 116293.764398), -- Varnish
(20607, 1874, 1, 1, 2, 7753.030628), -- Oriharukon Ore
(20607, 2262, 1, 1, 2, 1805.440576), -- Recipe: Elven Bow
-- Patin Archer
(20608, 1874, 1, 1, -1, 55672), -- Oriharukon Ore
(20608, 2022, 1, 1, -1, 13008), -- Mace of Judgment Head
(20608, 2153, 1, 1, -1, 129874), -- Recipe: Tiger's Eye Earring
(20608, 57, 354, 701, 0, 700000), -- Adena
(20608, 315, 1, 1, 1, 184), -- Divine Tome
(20608, 1872, 1, 1, 2, 86922.24825), -- Animal Bone
(20608, 1867, 1, 1, 2, 86922.24825), -- Animal Skin
(20608, 1881, 1, 1, 2, 8692.224825), -- Coarse Bone Powder
(20608, 1875, 1, 1, 2, 4346.207879), -- Stone of Purity
(20608, 2265, 1, 1, 2, 674.184423), -- Recipe: Spiked Club
(20608, 2274, 1, 1, 2, 465.685587), -- Recipe: Skull Breaker
(20608, 2189, 1, 1, 2, 2910.200786), -- Recipe: Mithril Tunic
-- Lakin Salamander
(20609, 2265, 1, 1, -1, 8969), -- Recipe: Spiked Club
(20609, 433, 1, 1, -1, 2256), -- Elven Tunic
(20609, 1900, 1, 1, -1, 94887), -- Enchanted Necklace Chain
(20609, 57, 366, 732, 0, 700000), -- Adena
(20609, 259, 1, 1, 1, 191), -- Single-Edged Jamadhr
(20609, 1866, 1, 1, 2, 52658.392072), -- Suede
(20609, 1871, 1, 1, 2, 78987.588108), -- Charcoal
(20609, 5220, 1, 1, 2, 3159.573144), -- Metal Hardener
(20609, 1885, 1, 1, 2, 6582.347356), -- High-Grade Suede
(20609, 956, 1, 1, 2, 2632.97762), -- Scroll: Enchant Armor (D-Grade)
(20609, 6667, 1, 1, 2, 49367.1217), -- Deluxe Chest Key - Grade 3
-- Sentinel Of Water
(20610, 2025, 1, 1, -1, 12109), -- Dwarven Trident Edge
(20610, 2267, 1, 1, -1, 9041), -- Recipe: Gastraphetes
(20610, 1864, 1, 3, -1, 874300), -- Stem
(20610, 57, 370, 737, 0, 700000), -- Adena
(20610, 292, 1, 1, 1, 193), -- Pike
(20610, 1864, 1, 1, 2, 119442.817208), -- Stem
(20610, 1865, 1, 1, 2, 59721.408604), -- Varnish
(20610, 1866, 1, 1, 2, 39814.117002), -- Suede
(20610, 1873, 1, 1, 2, 23888.656682), -- Silver Nugget
(20610, 1868, 1, 1, 2, 119442.817208), -- Thread
(20610, 2183, 1, 1, 2, 3929.150456), -- Recipe: Mithril Banded Mail
(20610, 2270, 1, 1, 2, 426.57483), -- Recipe: Goat Head Staff
(20610, 1341, 20, 60, 2, 99536.45801), -- Bone Arrow
-- Dre Vanul Warrior
(20611, 2153, 1, 1, -1, 143948), -- Recipe: Tiger's Eye Earring
(20611, 467, 1, 1, -1, 3857), -- Dark Stockings
(20611, 1884, 1, 1, -1, 569592), -- Cord
(20611, 57, 390, 782, 0, 700000), -- Adena
(20611, 86, 1, 1, 1, 20.416164), -- Tomahawk
(20611, 179, 1, 1, 1, 20.416164), -- Mace of Prayer
(20611, 180, 1, 1, 1, 20.416164), -- Mace of Judgment
(20611, 2022, 1, 1, 1, 787.87962), -- Mace of Judgment Head
(20611, 181, 1, 1, 1, 20.416164), -- Mace of Miracle
(20611, 182, 1, 1, 1, 20.416164), -- Doom Hammer
(20611, 183, 1, 1, 1, 20.416164), -- Mystic Staff
(20611, 184, 1, 1, 1, 20.416164), -- Conjuror's Staff
(20611, 2023, 1, 1, 1, 626.78949), -- Conjuror's Staff Head
(20611, 185, 1, 1, 1, 20.417742), -- Staff of Mana
(20611, 1864, 1, 1, 2, 144513.606), -- Stem
(20611, 1869, 1, 1, 2, 72256.803), -- Iron Ore
(20611, 1878, 1, 1, 2, 28902.803), -- Braided Hemp
(20611, 1884, 1, 1, 2, 44465.662), -- Cord
(20611, 1829, 1, 1, 2, 28902.803), -- Scroll of Escape: Clan Hall
(20611, 2193, 1, 1, 2, 9672.85), -- Recipe: Boots of Power
(20611, 1834, 1, 1, 2, 80285.473), -- Emergency Dressing
-- Salamander Rowin
(20612, 349, 1, 1, -1, 1496), -- Compound Scale Mail
(20612, 1869, 1, 3, -1, 527615), -- Iron Ore
(20612, 1885, 1, 1, -1, 87936), -- High-Grade Suede
(20612, 57, 446, 892, 0, 700000), -- Adena
(20612, 436, 1, 1, 1, 479.533068), -- Tunic of Knowledge
(20612, 469, 1, 1, 1, 766.466932), -- Stockings of Knowledge
(20612, 1866, 1, 1, 2, 53433.989025), -- Suede
(20612, 1871, 1, 1, 2, 80151.10295), -- Charcoal
(20612, 5220, 1, 1, 2, 3205.9868), -- Metal Hardener
(20612, 1885, 1, 1, 2, 6679.218775), -- High-Grade Suede
(20612, 2188, 1, 1, 2, 5725.1129), -- Recipe: Manticore Skin Gaiters
(20612, 2274, 1, 1, 2, 572.463525), -- Recipe: Skull Breaker
(20612, 1832, 1, 1, 2, 89057.126025), -- Greater Antidote
-- Lafi Lizardman
(20613, 40, 1, 1, -1, 9795), -- Leather Boots
(20613, 1934, 1, 1, -1, 103074), -- Crafted Leather Gloves Lining
(20613, 1899, 1, 1, -1, 123206), -- Necklace of Devotion Chain
(20613, 57, 340, 656, 0, 700000), -- Adena
(20613, 432, 1, 1, 1, 917.992572), -- Cursed Tunic
(20613, 465, 1, 1, 1, 1470.007428), -- Cursed Stockings
(20613, 1864, 1, 1, 2, 126440.201944), -- Stem
(20613, 1865, 1, 1, 2, 63220.100972), -- Varnish
(20613, 1866, 1, 1, 2, 42146.577711), -- Suede
(20613, 1873, 1, 1, 2, 25288.134151), -- Silver Nugget
(20613, 1868, 1, 1, 2, 126440.201944), -- Thread
(20613, 2263, 1, 1, 2, 981.690234), -- Recipe: Dwarven Trident
(20613, 1831, 1, 3, 2, 84294.093044), -- Antidote
-- Lafi Lizardman Scout
(20614, 1869, 1, 1, -1, 774589), -- Iron Ore
(20614, 1899, 1, 1, -1, 121030), -- Necklace of Devotion Chain
(20614, 2152, 1, 1, -1, 136371), -- Recipe: Enchanted Necklace
(20614, 57, 332, 650, 0, 700000), -- Adena
(20614, 220, 1, 1, 1, 276), -- Crafted Dagger
(20614, 1870, 1, 1, 2, 86944.667355), -- Coal
(20614, 1865, 1, 1, 2, 86944.667355), -- Varnish
(20614, 1874, 1, 1, 2, 5796.311157), -- Oriharukon Ore
(20614, 2263, 1, 1, 2, 1350.168183), -- Recipe: Dwarven Trident
(20614, 1834, 1, 1, 2, 96605.18595), -- Emergency Dressing
-- Ritmal Swordsman
(20615, 2185, 1, 1, -1, 175902), -- Recipe: Iron Boots
(20615, 392, 1, 1, -1, 2324), -- Lion Skin Shirt
(20615, 1900, 1, 1, -1, 97766), -- Enchanted Necklace Chain
(20615, 57, 379, 750, 0, 700000), -- Adena
(20615, 627, 1, 1, 1, 1815.325785), -- Aspis
(20615, 46, 1, 1, 1, 1271.674215), -- Bronze Helmet
(20615, 1875, 1, 1, 2, 4650.55716), -- Stone of Purity
(20615, 1879, 1, 1, 2, 11626.501128), -- Cokes
(20615, 1885, 1, 1, 2, 5813.250564), -- High-Grade Suede
(20615, 5550, 1, 1, 2, 930.111432), -- Durable Metal Plate
(20615, 5549, 1, 1, 2, 6975.943968), -- Metallic Thread
(20615, 2266, 1, 1, 2, 721.447848), -- Recipe: Shilen Knife
(20615, 1834, 1, 1, 2, 77510.1879), -- Emergency Dressing
-- Lakin Undine
(20616, 1874, 1, 1, -1, 61682), -- Oriharukon Ore
(20616, 1937, 1, 1, -1, 79487), -- Scale Gaiters Fragment
(20616, 2153, 1, 1, -1, 143893), -- Recipe: Tiger's Eye Earring
(20616, 57, 390, 781, 0, 700000), -- Adena
(20616, 433, 1, 1, 1, 164.372203), -- Elven Tunic
(20616, 434, 1, 1, 1, 164.372203), -- White Tunic
(20616, 1936, 1, 1, 1, 5172.133267), -- White Tunic Pattern
(20616, 435, 1, 1, 1, 164.372203), -- Mystic's Tunic
(20616, 466, 1, 1, 1, 263.345578), -- Elven Stockings
(20616, 467, 1, 1, 1, 263.345578), -- Dark Stockings
(20616, 1933, 1, 1, 1, 7435.699499), -- Dark Stockings Fabric
(20616, 468, 1, 1, 1, 263.359469), -- Mystic's Stockings
(20616, 1872, 1, 1, 2, 84267.395842), -- Animal Bone
(20616, 1867, 1, 1, 2, 84267.395842), -- Animal Skin
(20616, 1881, 1, 1, 2, 8426.833947), -- Coarse Bone Powder
(20616, 1875, 1, 1, 2, 4213.29902), -- Stone of Purity
(20616, 737, 1, 1, 2, 6319.94853), -- Scroll of Resurrection
(20616, 2274, 1, 1, 2, 451.525998), -- Recipe: Skull Breaker
(20616, 2976, 1, 1, 2, 8460.568648), -- Recipe: Manticore Skin Boots
(20616, 6667, 1, 1, 2, 39500.032173), -- Deluxe Chest Key - Grade 3
-- Sentinel Of Water
(20617, 435, 1, 1, -1, 2296), -- Mystic's Tunic
(20617, 1875, 1, 1, -1, 58864), -- Stone of Purity
(20617, 1933, 1, 1, -1, 103877), -- Dark Stockings Fabric
(20617, 57, 373, 744, 0, 700000), -- Adena
(20617, 392, 1, 1, 1, 627.573331), -- Lion Skin Shirt
(20617, 414, 1, 1, 1, 1005.426669), -- Lion Skin Gaiters
(20617, 1872, 1, 1, 2, 128667.265196), -- Animal Bone
(20617, 1867, 1, 1, 2, 128667.265196), -- Animal Skin
(20617, 1881, 1, 1, 2, 12866.841228), -- Coarse Bone Powder
(20617, 1875, 1, 1, 2, 6433.420614), -- Stone of Purity
(20617, 2184, 1, 1, 2, 10136.207766), -- Recipe: Mithril Banded Gaiters
-- Kanil Succubus
(20618, 1885, 1, 1, -1, 81279), -- High-Grade Suede
(20618, 1935, 1, 1, -1, 54489), -- Scale Mail Fragment
(20618, 955, 1, 1, -1, 3901), -- Scroll: Enchant Weapon (D-Grade)
(20618, 57, 411, 824, 0, 700000), -- Adena
(20618, 315, 1, 1, 1, 215), -- Divine Tome
(20618, 1875, 1, 1, 2, 5922.148167), -- Stone of Purity
(20618, 1879, 1, 1, 2, 14805.344411), -- Cokes
(20618, 1885, 1, 1, 2, 7402.646199), -- High-Grade Suede
(20618, 5550, 1, 1, 2, 1184.440036), -- Durable Metal Plate
(20618, 5549, 1, 1, 2, 8883.196244), -- Metallic Thread
(20618, 2153, 1, 1, 2, 13815.224943), -- Recipe: Tiger's Eye Earring
-- Rowin Undine
(20619, 2981, 1, 1, -1, 134055), -- Recipe: Mithril Gloves
(20619, 2270, 1, 1, -1, 7153), -- Recipe: Goat Head Staff
(20619, 1867, 1, 3, -1, 667594), -- Animal Skin
(20619, 57, 423, 846, 0, 700000), -- Adena
(20619, 157, 1, 1, 1, 47.73208), -- Spiked Club
(20619, 2027, 1, 1, 1, 2324.53584), -- Spiked Club Head
(20619, 186, 1, 1, 1, 47.73208), -- Staff of Magic
(20619, 1872, 1, 1, 2, 118318.290624), -- Animal Bone
(20619, 1867, 1, 1, 2, 118318.290624), -- Animal Skin
(20619, 1881, 1, 1, 2, 11831.93487), -- Coarse Bone Powder
(20619, 1875, 1, 1, 2, 5915.967435), -- Stone of Purity
(20619, 2154, 1, 1, 2, 9500.993442), -- Recipe: Elven Earring
(20619, 2278, 1, 1, 2, 633.523005), -- Recipe: Reinforced Long Bow
-- Cave Beast
(20620, 4051, 1, 1, -1, 204462), -- Adamantite Necklace Chain
(20620, 948, 1, 1, -1, 13180), -- Scroll: Enchant Armor (B-Grade)
(20620, 4039, 1, 1, -1, 175735), -- Mold Glue
(20620, 57, 2089, 4237, 0, 700000), -- Adena
(20620, 78, 1, 1, 1, 7.771049), -- Great Sword
(20620, 4104, 1, 1, 1, 1485.236753), -- Great Sword Blade
(20620, 142, 1, 1, 1, 7.771049), -- Keshanberk
(20620, 4107, 1, 1, 1, 1462.22505), -- Keshanberk Blade
(20620, 148, 1, 1, 1, 7.771049), -- Sword of Valhalla
(20620, 4108, 1, 1, 1, 1462.22505), -- Sword of Valhalla Blade
(20620, 1894, 1, 1, 2, 4967.418016), -- Crafted Leather
(20620, 4039, 1, 1, 2, 4719.04816), -- Mold Glue
(20620, 4041, 1, 1, 2, 1231.046048), -- Mold Hardener
(20620, 4044, 1, 1, 2, 4719.04816), -- Thons
(20620, 4614, 1, 1, 2, 195.27312), -- Greater Dye of STR (Str+4 Dex-4)
(20620, 4402, 1, 1, 2, 283.1408), -- Blue Dimensional Stone
(20620, 4999, 1, 1, 2, 1760.843232), -- Recipe: Sealed Doom Boots (60%)
(20620, 8728, 1, 1, 2, 2359.513632), -- Life Stone - Level 61
(20620, 8738, 1, 1, 2, 589.873184), -- Mid-Grade Life Stone - Level 61
(20620, 8748, 1, 1, 2, 58.989408), -- High-Grade Life Stone - Level 61
(20620, 8758, 1, 1, 2, 11.80624), -- Top-Grade Life Stone - Level 61
-- Death Wave
(20621, 4199, 1, 1, -1, 4349), -- Recipe: Bow of Peril (100%)
(20621, 4052, 1, 1, -1, 201691), -- Earring of Black Ore Piece
(20621, 5230, 1, 1, -1, 7596), -- Recipe: Mithril Arrow (100%)
(20621, 57, 2259, 4576, 0, 700000), -- Adena
(20621, 2391, 1, 1, 1, 27.888624), -- Blue Wolf Leather Armor
(20621, 4082, 1, 1, 1, 4754.111376), -- Blue Wolf Leather Armor Texture
(20621, 2392, 1, 1, 1, 27.888624), -- Leather Armor of Doom
(20621, 4083, 1, 1, 1, 4754.111376), -- Leather Armor of Doom Design
(20621, 1873, 1, 1, 2, 61190.3327), -- Silver Nugget
(20621, 1868, 1, 1, 2, 305951.6635), -- Thread
(20621, 1876, 1, 1, 2, 30595.38986), -- Mithril Ore
(20621, 1895, 1, 1, 2, 43707.3805), -- Metallic Fiber
(20621, 4042, 1, 1, 2, 2549.80208), -- Enria
(20621, 4623, 1, 1, 2, 210.99344), -- Greater Dye of WIT (Wit+4 Int-4)
(20621, 5276, 1, 1, 2, 203.84112), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20621, 8729, 1, 1, 2, 2039.75226), -- Life Stone - Level 64
(20621, 8739, 1, 1, 2, 510.04982), -- Mid-Grade Life Stone - Level 64
(20621, 8749, 1, 1, 2, 50.96028), -- High-Grade Life Stone - Level 64
(20621, 8759, 1, 1, 2, 9.83444), -- Top-Grade Life Stone - Level 64
-- Maluk Soldier
(20622, 4044, 1, 1, -1, 203292), -- Thons
(20622, 4042, 1, 1, -1, 101646), -- Enria
(20622, 4053, 1, 1, -1, 261413), -- Ring of Black Ore Gemstone
(20622, 57, 2419, 4898, 0, 700000), -- Adena
(20622, 864, 1, 1, 1, 84.45667), -- Earring of Black Ore
(20622, 4052, 1, 1, 1, 10629.36916), -- Earring of Black Ore Piece
(20622, 926, 1, 1, 1, 63.349924), -- Necklace of Black Ore
(20622, 4054, 1, 1, 1, 5913.4512), -- Necklace of Black Ore Beads
(20622, 895, 1, 1, 1, 126.670162), -- Ring of Black Ore
(20622, 4053, 1, 1, 1, 12868.702884), -- Ring of Black Ore Gemstone
(20622, 1867, 1, 1, 2, 200165.035026), -- Animal Skin
(20622, 1872, 1, 1, 2, 200165.035026), -- Animal Bone
(20622, 1882, 1, 1, 2, 33361.07434), -- Leather
(20622, 1894, 1, 1, 2, 5267.315262), -- Crafted Leather
(20622, 4042, 1, 1, 2, 2502.19816), -- Enria
(20622, 4988, 1, 1, 2, 994.294532), -- Recipe: Blue Wolf Stockings (60%)
(20622, 4401, 1, 1, 2, 300.075644), -- Green Dimensional Stone
(20622, 6670, 1, 1, 2, 25020.570586), -- Deluxe Chest Key - Grade 6
(20622, 8729, 1, 1, 2, 2001.758528), -- Life Stone - Level 64
(20622, 8739, 1, 1, 2, 500.439632), -- Mid-Grade Life Stone - Level 64
(20622, 8749, 1, 1, 2, 49.855828), -- High-Grade Life Stone - Level 64
(20622, 8759, 1, 1, 2, 10.347436), -- Top-Grade Life Stone - Level 64
-- Plando
(20623, 4039, 1, 1, -1, 271715), -- Mold Glue
(20623, 4040, 1, 1, -1, 163029), -- Mold Lubricant
(20623, 5230, 1, 1, -1, 10869), -- Recipe: Mithril Arrow (100%)
(20623, 57, 3236, 6545, 0, 700000), -- Adena
(20623, 110, 1, 1, 1, 123.516382), -- Doom Shield
(20623, 4077, 1, 1, 1, 18053.98595), -- Doom Shield Fragment
(20623, 2416, 1, 1, 1, 86.466336), -- Blue Wolf Helmet
(20623, 4088, 1, 1, 1, 15167.782498), -- Blue Wolf Helmet Design
(20623, 2417, 1, 1, 1, 86.466336), -- Doom Helmet
(20623, 4089, 1, 1, 1, 15167.782498), -- Doom Helmet Pattern
(20623, 1868, 1, 3, 2, 218891.932928), -- Thread
(20623, 1873, 1, 1, 2, 87556.701409), -- Silver Nugget
(20623, 5549, 1, 1, 2, 21889.265055), -- Metallic Thread
(20623, 1889, 1, 1, 2, 14592.84337), -- Compound Braid
(20623, 4044, 1, 1, 2, 7296.421685), -- Thons
(20623, 4177, 1, 1, 2, 4217.464494), -- Recipe: Sealed Zubei's Gauntlets (100%)
(20623, 5332, 1, 1, 2, 630.789738), -- Recipe: Sealed Dark Crystal Leather Armor(60%)
(20623, 8729, 1, 1, 2, 2918.568674), -- Life Stone - Level 64
(20623, 8739, 1, 1, 2, 729.462763), -- Mid-Grade Life Stone - Level 64
(20623, 8749, 1, 1, 2, 72.838633), -- High-Grade Life Stone - Level 64
(20623, 8759, 1, 1, 2, 14.711251), -- Top-Grade Life Stone - Level 64
-- Cave Howler
(20624, 1877, 1, 1, -1, 332612), -- Adamantite Nugget
(20624, 4054, 1, 1, -1, 163784), -- Necklace of Black Ore Beads
(20624, 4052, 1, 1, -1, 294399), -- Earring of Black Ore Piece
(20624, 57, 3295, 6681, 0, 700000), -- Adena
(20624, 79, 1, 1, 1, 8.113194), -- Sword of Damascus
(20624, 4114, 1, 1, 1, 1792.222368), -- Sword of Damascus Blade
(20624, 7883, 1, 1, 1, 8.113194), -- Guardian Sword
(20624, 8330, 1, 1, 1, 1789.210284), -- Guardian Sword Blade
(20624, 7889, 1, 1, 1, 8.113194), -- Wizard's Tear
(20624, 8336, 1, 1, 1, 1792.227766), -- Blade of the Wizard's Tear
(20624, 1873, 1, 1, 2, 75575.770128), -- Silver Nugget
(20624, 1868, 1, 3, 2, 188939.42532), -- Thread
(20624, 1876, 1, 1, 2, 37787.885064), -- Mithril Ore
(20624, 1895, 1, 1, 2, 53982.588264), -- Metallic Fiber
(20624, 4042, 1, 1, 2, 3149.17362), -- Enria
(20624, 4154, 1, 1, 2, 2236.114788), -- Recipe: Doom Shield (100%)
(20624, 4403, 1, 1, 2, 377.754276), -- Red Dimensional Stone
(20624, 5281, 1, 1, 2, 252.080448), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(20624, 5340, 1, 1, 2, 870.556896), -- Recipe: Sealed Dark Crystal Leggings(60%)
(20624, 8729, 1, 1, 2, 2519.338896), -- Life Stone - Level 64
(20624, 8739, 1, 1, 2, 629.834724), -- Mid-Grade Life Stone - Level 64
(20624, 8749, 1, 1, 2, 63.020112), -- High-Grade Life Stone - Level 64
(20624, 8759, 1, 1, 2, 12.457464), -- Top-Grade Life Stone - Level 64
-- Maluk Knight
(20625, 4043, 1, 1, -1, 277527), -- Asofe
(20625, 4044, 1, 1, -1, 277527), -- Thons
(20625, 5230, 1, 1, -1, 11101), -- Recipe: Mithril Arrow (100%)
(20625, 57, 3298, 6689, 0, 700000), -- Adena
(20625, 268, 1, 1, 1, 24.37197), -- Bellion Cestus
(20625, 4120, 1, 1, 1, 5373.62803), -- Bellion Cestus Edge
(20625, 1894, 1, 1, 2, 8629.183836), -- Crafted Leather
(20625, 4039, 1, 1, 2, 8197.7103), -- Mold Glue
(20625, 4041, 1, 1, 2, 2138.528964), -- Mold Hardener
(20625, 4044, 1, 1, 2, 8197.7103), -- Thons
(20625, 4192, 1, 1, 2, 187.74964), -- Recipe: Sword of Damascus (100%)
(20625, 5276, 1, 1, 2, 327.908412), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20625, 8729, 1, 1, 2, 3279.08412), -- Life Stone - Level 64
(20625, 8739, 1, 1, 2, 819.786968), -- Mid-Grade Life Stone - Level 64
(20625, 8749, 1, 1, 2, 81.985072), -- High-Grade Life Stone - Level 64
(20625, 8759, 1, 1, 2, 16.352388), -- Top-Grade Life Stone - Level 64
-- Maluk Berserker
(20626, 1875, 1, 1, -1, 685963), -- Stone of Purity
(20626, 4053, 1, 1, -1, 441039), -- Ring of Black Ore Gemstone
(20626, 5230, 1, 1, -1, 13719), -- Recipe: Mithril Arrow (100%)
(20626, 57, 4056, 8290, 0, 700000), -- Adena
(20626, 358, 1, 1, 1, 40.93388), -- Blue Wolf Breastplate
(20626, 4078, 1, 1, 1, 7399.831335), -- Blue Wolf Breastplate Part
(20626, 2381, 1, 1, 1, 25.19361), -- Doom Plate Armor
(20626, 4081, 1, 1, 1, 4993.038505), -- Doom Plate Armor Temper
(20626, 2380, 1, 1, 1, 65.48503), -- Blue Wolf Gaiters
(20626, 4080, 1, 1, 1, 10420.51764), -- Blue Wolf Gaiters Material
(20626, 1872, 1, 3, 2, 168852.683584), -- Animal Bone
(20626, 1867, 1, 3, 2, 112568.342644), -- Animal Skin
(20626, 1881, 1, 1, 2, 33770.604564), -- Coarse Bone Powder
(20626, 1875, 1, 1, 2, 16885.132664), -- Stone of Purity
(20626, 4041, 1, 1, 2, 2202.320112), -- Mold Hardener
(20626, 4615, 1, 1, 2, 349.41308), -- Greater Dye of CON (Con+4 Str-4)
(20626, 4402, 1, 1, 2, 506.479348), -- Blue Dimensional Stone
(20626, 5334, 1, 1, 2, 498.67692), -- Recipe: Sealed Tallum Leather Armor(60%)
(20626, 8730, 1, 1, 2, 2814.301856), -- Life Stone - Level 67
(20626, 8740, 1, 1, 2, 703.575464), -- Mid-Grade Life Stone - Level 67
(20626, 8750, 1, 1, 2, 70.221852), -- High-Grade Life Stone - Level 67
(20626, 8760, 1, 1, 2, 14.247912), -- Top-Grade Life Stone - Level 67
-- Maluk Lord
(20627, 1877, 1, 1, -1, 413122), -- Adamantite Nugget
(20627, 5478, 1, 1, -1, 86849), -- Sealed Dark Crystal Leather Armor Pattern
(20627, 57, 4085, 8305, 0, 700000), -- Adena
(20627, 5291, 1, 1, 1, 85.696149), -- Sealed Dark Crystal Boots
(20627, 5496, 1, 1, 1, 8942.553851), -- Sealed Dark Crystal Boots Lining
(20627, 5296, 1, 1, 1, 85.696149), -- Sealed Tallum Boots
(20627, 5497, 1, 1, 1, 8942.553851), -- Sealed Tallum Boots Lining
(20627, 5290, 1, 1, 1, 85.696149), -- Sealed Dark Crystal Gloves
(20627, 5508, 1, 1, 1, 8942.553851), -- Sealed Dark Crystal Gloves Design
(20627, 5295, 1, 1, 1, 85.696149), -- Sealed Tallum Gloves
(20627, 5509, 1, 1, 1, 8942.553851), -- Sealed Tallum Gloves Design
(20627, 1871, 1, 1, 2, 254229.140691), -- Charcoal
(20627, 1866, 1, 1, 2, 169485.766956), -- Suede
(20627, 1877, 1, 1, 2, 10169.400951), -- Adamantite Nugget
(20627, 4041, 1, 1, 2, 2210.568813), -- Mold Hardener
(20627, 4040, 1, 1, 2, 5084.455347), -- Mold Lubricant
(20627, 4973, 1, 1, 2, 2751.322284), -- Recipe: Earring of Black Ore (70%)
(20627, 3956, 1, 1, 2, 338.767587), -- Recipe: Blessed Spiritshot A
(20627, 6670, 1, 1, 2, 42371.441739), -- Deluxe Chest Key - Grade 6
(20627, 8730, 1, 1, 2, 2824.860834), -- Life Stone - Level 67
(20627, 8740, 1, 1, 2, 705.97008), -- Mid-Grade Life Stone - Level 67
(20627, 8750, 1, 1, 2, 70.597008), -- High-Grade Life Stone - Level 67
(20627, 8760, 1, 1, 2, 14.70771), -- Top-Grade Life Stone - Level 67
-- Limal Karinness
(20628, 1807, 1, 1, -1, 14876), -- Recipe: Soulshot (A-Grade)
(20628, 5479, 1, 1, -1, 66016), -- Sealed Tallum Leather Armor Pattern
(20628, 1895, 1, 7, -1, 796908), -- Metallic Fiber
(20628, 57, 4416, 8967, 0, 700000), -- Adena
(20628, 5304, 1, 1, 1, 41.126553), -- Sealed Tallum Tunic
(20628, 5485, 1, 1, 1, 4618.266393), -- Sealed Tallum Tunic Texture
(20628, 5308, 1, 1, 1, 25.298091), -- Sealed Dark Crystal Robe
(20628, 5486, 1, 1, 1, 3249.729639), -- Sealed Dark Crystal Robe Fabric
(20628, 5305, 1, 1, 1, 65.768937), -- Sealed Tallum Stockings
(20628, 5489, 1, 1, 1, 7248.810387), -- Sealed Tallum Stockings Fabric
(20628, 1895, 1, 1, 2, 94157.83821), -- Metallic Fiber
(20628, 4040, 1, 1, 2, 6591.05616), -- Mold Lubricant
(20628, 4042, 1, 1, 2, 5492.588385), -- Enria
(20628, 4043, 1, 1, 2, 10985.052015), -- Asofe
(20628, 4988, 1, 1, 2, 2182.46397), -- Recipe: Blue Wolf Stockings (60%)
(20628, 4401, 1, 1, 2, 659.080665), -- Green Dimensional Stone
(20628, 8730, 1, 1, 2, 3661.684005), -- Life Stone - Level 67
(20628, 8740, 1, 1, 2, 915.45219), -- Mid-Grade Life Stone - Level 67
(20628, 8750, 1, 1, 2, 91.57017), -- High-Grade Life Stone - Level 67
(20628, 8760, 1, 1, 2, 18.21423), -- Top-Grade Life Stone - Level 67
-- Karik
(20629, 4077, 1, 1, -1, 589396), -- Doom Shield Fragment
(20629, 4078, 1, 1, -1, 191386), -- Blue Wolf Breastplate Part
(20629, 3035, 1, 1, -1, 17470), -- Recipe: Spiritshot A
(20629, 57, 5182, 10542, 0, 700000), -- Adena
(20629, 5292, 1, 1, 1, 137.97336), -- Sealed Dark Crystal Shield
(20629, 5494, 1, 1, 1, 13545.568435), -- Sealed Dark Crystal Shield Fragment
(20629, 5289, 1, 1, 1, 96.547535), -- Sealed Dark Crystal Helmet
(20629, 5525, 1, 1, 1, 9970.198476), -- Sealed Dark Crystal Helmet Design
(20629, 5294, 1, 1, 1, 96.547535), -- Sealed Tallum Helmet
(20629, 5526, 1, 1, 1, 9970.164659), -- Sealed Tallum Helm Design
(20629, 1873, 1, 1, 2, 154808.395587), -- Silver Nugget
(20629, 1868, 3, 9, 2, 129006.754299), -- Thread
(20629, 1876, 1, 1, 2, 77403.95577), -- Mithril Ore
(20629, 1895, 1, 1, 2, 110577.632868), -- Metallic Fiber
(20629, 4042, 1, 1, 2, 6450.410322), -- Enria
(20629, 5006, 1, 1, 2, 295.26867), -- Recipe: Bellion Cestus (60%)
(20629, 8730, 1, 1, 2, 4300.273548), -- Life Stone - Level 67
(20629, 8740, 1, 1, 2, 1075.068387), -- Mid-Grade Life Stone - Level 67
(20629, 8750, 1, 1, 2, 107.458434), -- High-Grade Life Stone - Level 67
(20629, 8760, 1, 1, 2, 21.782115), -- Top-Grade Life Stone - Level 67
-- Taik Orc
(20630, 2291, 1, 1, -1, 5091), -- Recipe: Scallop Jamadhr
(20630, 1943, 1, 1, -1, 72792), -- Manticore Skin Gaiters Pattern
(20630, 1902, 1, 1, -1, 92852), -- Elven Earring Beads
(20630, 57, 383, 764, 0, 700000), -- Adena
(20630, 629, 1, 1, 1, 261.873792), -- Kite Shield
(20630, 1947, 1, 1, 1, 11368.098096), -- Kite Shield Fragment
(20630, 2493, 1, 1, 1, 261.873792), -- Brigandine Shield
(20630, 2929, 1, 1, 1, 11368.098096), -- Brigandine Shield Fragment
(20630, 2411, 1, 1, 1, 183.4017), -- Brigandine Helmet
(20630, 2922, 1, 1, 1, 3040.654524), -- Brigandine Helmet Design
(20630, 1866, 1, 1, 2, 45117.507951), -- Suede
(20630, 1871, 1, 1, 2, 67676.195466), -- Charcoal
(20630, 5220, 1, 1, 2, 2707.069086), -- Metal Hardener
(20630, 1885, 1, 1, 2, 5639.705109), -- High-Grade Suede
(20630, 5472, 1, 1, 2, 4834.070928), -- Recipe: Metallic Thread(100%)
(20630, 2286, 1, 1, 2, 376.033509), -- Recipe: Bonebreaker
(20630, 2987, 1, 1, 2, 6570.417951), -- Recipe: Plate Shield
-- Taik Orc Archer
(20631, 2998, 1, 1, -1, 94276), -- Recipe: Chain Shield
(20631, 2996, 1, 1, -1, 99513), -- Recipe: Chain Gloves
(20631, 1873, 1, 1, -1, 501547), -- Silver Nugget
(20631, 57, 508, 1017, 0, 700000), -- Adena
(20631, 1125, 1, 1, 1, 139.547025), -- Assault Boots
(20631, 1957, 1, 1, 1, 5856.262325), -- Assault Boots Part
(20631, 2427, 1, 1, 1, 139.547025), -- Salamander Skin Boots
(20631, 2931, 1, 1, 1, 5856.262325), -- Salamander Skin Boot Lining
(20631, 2428, 1, 1, 1, 139.547025), -- Plate Boots
(20631, 2932, 1, 1, 1, 5856.262325), -- Plate Boots Design
(20631, 61, 1, 1, 1, 139.547025), -- Mithril Plate Gloves
(20631, 1949, 1, 1, 1, 5856.262325), -- Mithril Gloves Design
(20631, 607, 1, 1, 1, 139.547025), -- Ogre Power Gauntlets
(20631, 1963, 1, 1, 1, 5856.262325), -- Ogre Power Gauntlets Part
(20631, 2451, 1, 1, 1, 139.547025), -- Sage's Worn Gloves
(20631, 2933, 1, 1, 1, 5856.406225), -- Sage's Worn Gloves Lining
(20631, 1868, 1, 1, 2, 157408.598016), -- Thread
(20631, 1873, 1, 1, 2, 31481.568768), -- Silver Nugget
(20631, 5549, 1, 1, 2, 7870.580736), -- Metallic Thread
(20631, 1889, 1, 1, 2, 5246.802432), -- Compound Braid
(20631, 2203, 1, 1, 2, 17146.945536), -- Recipe: Reinforced Mithril Boots
(20631, 5274, 1, 1, 2, 262.453248), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20631, 5164, 1, 1, 2, 262.453248), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20631, 1342, 10, 30, 2, 157408.598016), -- Steel Arrow
-- Taik Orc Warrior
(20632, 1951, 1, 1, -1, 63026), -- Plate Gaiters Part
(20632, 1873, 1, 1, -1, 499421), -- Silver Nugget
(20632, 1880, 1, 1, -1, 124855), -- Steel
(20632, 57, 503, 1016, 0, 700000), -- Adena
(20632, 353, 1, 1, 1, 104.217163), -- Half Plate Armor
(20632, 1950, 1, 1, 1, 5087.530747), -- Half Plate Temper
(20632, 380, 1, 1, 1, 166.750115), -- Plate Gaiters
(20632, 1951, 1, 1, 1, 7912.501975), -- Plate Gaiters Part
(20632, 1869, 1, 1, 2, 78370.714305), -- Iron Ore
(20632, 1864, 1, 1, 2, 156741.153543), -- Stem
(20632, 1880, 1, 1, 2, 7836.933897), -- Steel
(20632, 5550, 1, 1, 2, 1044.979533), -- Durable Metal Plate
(20632, 2301, 1, 1, 2, 342.183348), -- Recipe: Battle Axe
(20632, 2205, 1, 1, 2, 2480.004072), -- Recipe: Chain Gaiters
(20632, 5274, 1, 1, 2, 261.31365), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20632, 6668, 1, 1, 2, 27989.717652), -- Deluxe Chest Key - Grade 4
-- Taik Orc Shaman
(20633, 2313, 1, 1, -1, 5351), -- Recipe: Orcish Glaive
(20633, 2212, 1, 1, -1, 43920), -- Recipe: Plated Leather Gaiters
(20633, 4469, 1, 1, -1, 7002), -- Dye of STR (Str+1 Con-1)
(20633, 57, 485, 984, 0, 700000), -- Adena
(20633, 851, 1, 1, 1, 219.839927), -- Omen Beast's Eye Earring
(20633, 1905, 1, 1, 1, 9975.918999), -- Omen Beast's Eye Earring Gemstone
(20633, 914, 1, 1, 1, 164.871965), -- Necklace of Darkness
(20633, 1907, 1, 1, 1, 7134.088132), -- Necklace of Darkness Gem
(20633, 882, 1, 1, 1, 329.74393), -- Mithril Ring
(20633, 1906, 1, 1, 1, 14096.537047), -- Mithril Ring Wire
(20633, 1873, 1, 1, 2, 35161.574252), -- Silver Nugget
(20633, 1868, 1, 1, 2, 175807.87126), -- Thread
(20633, 1876, 1, 1, 2, 17580.787126), -- Mithril Ore
(20633, 1895, 1, 1, 2, 25115.41018), -- Metallic Fiber
(20633, 2992, 1, 1, 2, 6976.473616), -- Recipe: Plated Leather Boots
(20633, 5159, 1, 1, 2, 293.14019), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20633, 2211, 1, 1, 2, 1970.743376), -- Recipe: Plated Leather Armor
-- Taik Orc Captain
(20634, 2213, 1, 1, -1, 36467), -- Recipe: Dwarven Chain Mail Shirt
(20634, 1880, 1, 1, -1, 234850), -- Steel
(20634, 1908, 1, 1, -1, 222396), -- Moonstone Earring Wire
(20634, 57, 925, 1895, 0, 700000), -- Adena
(20634, 354, 1, 1, 1, 142.811604), -- Chain Mail Shirt
(20634, 1959, 1, 1, 1, 7473.914838), -- Chain Mail Shirt Material
(20634, 381, 1, 1, 1, 228.461688), -- Chain Gaiters
(20634, 1960, 1, 1, 1, 15203.81187), -- Chain Gaiters Part
(20634, 1872, 1, 1, 2, 123326.177326), -- Animal Bone
(20634, 1867, 1, 1, 2, 123326.177326), -- Animal Skin
(20634, 1881, 1, 1, 2, 12332.646614), -- Coarse Bone Powder
(20634, 1875, 1, 1, 2, 6166.1789), -- Stone of Purity
(20634, 2215, 1, 1, 2, 1178.36112), -- Recipe: Robe of Seal
(20634, 2225, 1, 1, 2, 2010.723068), -- Recipe: Demon's Stockings
(20634, 2321, 1, 1, 2, 322.316424), -- Recipe: Stiletto
(20634, 2251, 1, 1, 2, 15415.736064), -- Recipe: Steel Arrow
(20634, 8723, 1, 1, 2, 3699.70734), -- Life Stone - Level 46
(20634, 8733, 1, 1, 2, 925.071242), -- Mid-Grade Life Stone - Level 46
(20634, 8743, 1, 1, 2, 92.42048), -- High-Grade Life Stone - Level 46
(20634, 8753, 1, 1, 2, 18.484096), -- Top-Grade Life Stone - Level 46
-- Carinkain
(20635, 2215, 1, 1, -1, 15138), -- Recipe: Robe of Seal
(20635, 1959, 1, 1, -1, 32009), -- Chain Mail Shirt Material
(20635, 2163, 1, 1, -1, 60630), -- Recipe: Earring of Protection
(20635, 57, 470, 955, 0, 700000), -- Adena
(20635, 263, 1, 1, 1, 31.85193), -- Chakram
(20635, 2073, 1, 1, 1, 2170.14807), -- Chakram Edge
(20635, 1866, 1, 1, 2, 34038.436182), -- Suede
(20635, 1871, 1, 1, 2, 51057.70467), -- Charcoal
(20635, 5220, 1, 1, 2, 2042.288028), -- Metal Hardener
(20635, 1885, 1, 1, 2, 4254.817122), -- High-Grade Suede
(20635, 4041, 1, 1, 2, 443.99757), -- Mold Hardener
(20635, 3004, 1, 1, 2, 3171.281622), -- Recipe: Rind Leather Gloves
(20635, 3002, 1, 1, 2, 3171.281622), -- Recipe: Dwarven Chain Gloves
(20635, 8723, 1, 1, 2, 2042.288028), -- Life Stone - Level 46
(20635, 8733, 1, 1, 2, 510.622404), -- Mid-Grade Life Stone - Level 46
(20635, 8743, 1, 1, 2, 51.102558), -- High-Grade Life Stone - Level 46
(20635, 8753, 1, 1, 2, 10.180194), -- Top-Grade Life Stone - Level 46
-- Forest of Mirrors Ghost
(20636, 2163, 1, 1, -1, 67491), -- Recipe: Earring of Protection
(20636, 2214, 1, 1, -1, 32824), -- Recipe: Dwarven Chain Gaiters
(20636, 1909, 1, 1, -1, 178638), -- Aquastone Ring Wire
(20636, 57, 521, 1066, 0, 700000), -- Adena
(20636, 89, 1, 1, 1, 4.43344), -- Big Hammer
(20636, 2061, 1, 1, 1, 302.05956), -- Big Hammer Head
(20636, 160, 1, 1, 1, 4.43344), -- Battle Axe
(20636, 2063, 1, 1, 1, 302.05956), -- Battle Axe Head
(20636, 161, 1, 1, 1, 4.43344), -- Silver Axe
(20636, 2064, 1, 1, 1, 302.05956), -- Silver Axe Head
(20636, 173, 1, 1, 1, 4.43344), -- Skull Graver
(20636, 2065, 1, 1, 1, 302.05956), -- Skull Graver Head
(20636, 191, 1, 1, 1, 4.43344), -- Heavy Doom Hammer
(20636, 2066, 1, 1, 1, 306.50026), -- Heavy Doom Hammer Head
(20636, 192, 1, 1, 1, 4.43344), -- Crystal Staff
(20636, 2067, 1, 1, 1, 281.64928), -- Crystal Staff Head
(20636, 193, 1, 1, 1, 4.43344), -- Stick of Faith
(20636, 2068, 1, 1, 1, 281.64928), -- Stick of Faith Shaft
(20636, 194, 1, 1, 1, 4.43344), -- Heavy Doom Axe
(20636, 2069, 1, 1, 1, 306.49542), -- Heavy Doom Axe Blade
(20636, 1867, 1, 1, 2, 75780.012116), -- Animal Skin
(20636, 1872, 1, 1, 2, 75780.012116), -- Animal Bone
(20636, 1882, 1, 1, 2, 12630.059133), -- Leather
(20636, 1894, 1, 1, 2, 1994.237899), -- Crafted Leather
(20636, 4042, 1, 1, 2, 947.173048), -- Enria
(20636, 2230, 1, 1, 2, 1101.379948), -- Recipe: Theca Leather Gaiters
(20636, 2320, 1, 1, 2, 198.070196), -- Recipe: Cursed Staff
(20636, 8723, 1, 1, 2, 2273.352388), -- Life Stone - Level 46
(20636, 8733, 1, 1, 2, 568.338097), -- Mid-Grade Life Stone - Level 46
(20636, 8743, 1, 1, 2, 56.885212), -- High-Grade Life Stone - Level 46
(20636, 8753, 1, 1, 2, 11.479847), -- Top-Grade Life Stone - Level 46
-- Forest of Mirrors Ghost
(20637, 2337, 1, 1, -1, 3209), -- Recipe: Stick of Eternity
(20637, 2338, 1, 1, -1, 3209), -- Recipe: Paradia Staff
(20637, 440, 1, 1, -1, 457), -- Robe of Seal
(20637, 57, 545, 1111, 0, 700000), -- Adena
(20637, 1126, 1, 1, 1, 82.22976), -- Crimson Boots
(20637, 1974, 1, 1, 1, 4284.096192), -- Crimson Boot Fabric
(20637, 2434, 1, 1, 1, 82.22976), -- Rind Leather Boots
(20637, 2948, 1, 1, 1, 4284.096192), -- Rind Leather Boots Lining
(20637, 2455, 1, 1, 1, 89.04096), -- Plated Leather Gloves
(20637, 2946, 1, 1, 1, 2847.279744), -- Plate Leather Gloves Design
(20637, 2456, 1, 1, 1, 82.22976), -- Dwarven Chain Gloves
(20637, 2949, 1, 1, 1, 4284.096192), -- Dwarven Chain Gloves Design
(20637, 2457, 1, 1, 1, 82.22976), -- Gloves of Seal
(20637, 2950, 1, 1, 1, 4284.096192), -- Gloves of Seal Pattern
(20637, 2458, 1, 1, 1, 82.22976), -- Rind Leather Gloves
(20637, 2951, 1, 1, 1, 4284.145728), -- Rind Leather Gloves Design
(20637, 1869, 1, 1, 2, 50942.36372), -- Iron Ore
(20637, 1864, 1, 1, 2, 101884.919745), -- Stem
(20637, 1880, 1, 1, 2, 5094.15945), -- Steel
(20637, 5550, 1, 1, 2, 679.22126), -- Durable Metal Plate
(20637, 4043, 1, 1, 2, 1698.05315), -- Asofe
(20637, 2222, 1, 1, 2, 318.45708), -- Recipe: Composite Armor
(20637, 6668, 1, 1, 2, 18193.783745), -- Deluxe Chest Key - Grade 4
(20637, 8724, 1, 1, 2, 1698.05315), -- Life Stone - Level 49
(20637, 8734, 1, 1, 2, 424.60944), -- Mid-Grade Life Stone - Level 49
(20637, 8744, 1, 1, 2, 42.499405), -- High-Grade Life Stone - Level 49
(20637, 8754, 1, 1, 2, 8.46142), -- Top-Grade Life Stone - Level 49
(20637, 1539, 1, 1, 2, 11320.418435), -- Greater Healing Potion
-- Forest of Mirrors Ghost
(20638, 1873, 1, 1, -1, 576200), -- Silver Nugget
(20638, 2946, 1, 1, -1, 80520), -- Plate Leather Gloves Design
(20638, 1911, 1, 1, -1, 107140), -- Earring of Protection Gemstone
(20638, 57, 570, 1158, 0, 700000), -- Adena
(20638, 282, 1, 1, 1, 14.444309), -- Elemental Bow
(20638, 2085, 1, 1, 1, 1104.055691), -- Crossbow Shaft
(20638, 285, 1, 1, 1, 14.444309), -- Noble Elven Bow
(20638, 2086, 1, 1, 1, 1104.055691), -- Noble Elven Bow Shaft
(20638, 1867, 1, 1, 2, 65461.79647), -- Animal Skin
(20638, 1872, 1, 1, 2, 65461.79647), -- Animal Bone
(20638, 1882, 1, 1, 2, 10910.24963), -- Leather
(20638, 1894, 1, 1, 2, 1722.694575), -- Crafted Leather
(20638, 4042, 1, 1, 2, 818.261255), -- Enria
(20638, 2338, 1, 1, 2, 114.248925), -- Recipe: Paradia Staff
(20638, 2351, 1, 1, 2, 102.74936), -- Recipe: Scorpion
(20638, 3005, 1, 1, 2, 2003.91121), -- Recipe: Demon's Boots
(20638, 952, 1, 1, 2, 654.579135), -- Scroll: Enchant Armor (C-Grade)
(20638, 8724, 1, 1, 2, 1636.52251), -- Life Stone - Level 49
(20638, 8734, 1, 1, 2, 409.2053), -- Mid-Grade Life Stone - Level 49
(20638, 8744, 1, 1, 2, 40.92053), -- High-Grade Life Stone - Level 49
(20638, 8754, 1, 1, 2, 8.06463), -- Top-Grade Life Stone - Level 49
-- Mirror
(20639, 2342, 1, 1, -1, 7048), -- Recipe: Club of Nature
(20639, 2334, 1, 1, -1, 7048), -- Recipe: Sword of Whispering Death
(20639, 951, 1, 1, -1, 5510), -- Scroll: Enchant Weapon (C-Grade)
(20639, 57, 1196, 2440, 0, 700000), -- Adena
(20639, 227, 1, 1, 1, 30.383318), -- Stiletto
(20639, 2083, 1, 1, 1, 2230.616682), -- Stiletto Edge
(20639, 242, 1, 1, 1, 30.383318), -- Soulfire Dirk
(20639, 2084, 1, 1, 1, 2230.616682), -- Soulfire Dirk Blade
(20639, 1868, 1, 1, 2, 223801.838579), -- Thread
(20639, 1873, 1, 1, 2, 44760.29966), -- Silver Nugget
(20639, 5549, 1, 1, 2, 11190.074915), -- Metallic Thread
(20639, 1889, 1, 1, 2, 7459.936517), -- Compound Braid
(20639, 4044, 1, 1, 2, 3730.138398), -- Thons
(20639, 4132, 1, 1, 2, 4337.196134), -- Recipe: Composite Shield (100%)
(20639, 2328, 1, 1, 2, 260.313435), -- Recipe: Sword of Delusion
(20639, 6668, 1, 1, 2, 39964.747713), -- Deluxe Chest Key - Grade 4
(20639, 8724, 1, 1, 2, 3730.138398), -- Life Stone - Level 49
(20639, 8734, 1, 1, 2, 932.36446), -- Mid-Grade Life Stone - Level 49
(20639, 8744, 1, 1, 2, 93.236446), -- High-Grade Life Stone - Level 49
(20639, 8754, 1, 1, 2, 18.715345), -- Top-Grade Life Stone - Level 49
-- Harit Lizardman
(20640, 1868, 1, 7, -1, 728055), -- Thread
(20640, 1539, 1, 1, -1, 323580), -- Greater Healing Potion
(20640, 1870, 1, 3, -1, 728055), -- Coal
(20640, 57, 576, 1171, 0, 700000), -- Adena
(20640, 283, 1, 1, 1, 18.22008), -- Akat Long Bow
(20640, 2109, 1, 1, 1, 1687.77992), -- Akat Longbow Shaft
(20640, 1865, 1, 1, 2, 46319.687274), -- Varnish
(20640, 1870, 1, 1, 2, 46319.687274), -- Coal
(20640, 1879, 1, 1, 2, 7719.927852), -- Cokes
(20640, 1875, 1, 1, 2, 3087.923076), -- Stone of Purity
(20640, 4040, 1, 1, 2, 926.44902), -- Mold Lubricant
(20640, 2233, 1, 1, 2, 432.943686), -- Recipe: Divine Tunic
(20640, 3014, 1, 1, 2, 1293.904416), -- Recipe: Full Plate Boots
(20640, 2970, 1, 1, 2, 1642.494378), -- Recipe: Ring of Seal
(20640, 6669, 1, 1, 2, 10772.042652), -- Deluxe Chest Key - Grade 5
(20640, 8725, 1, 1, 2, 1286.694696), -- Life Stone - Level 52
(20640, 8735, 1, 1, 2, 321.673674), -- Mid-Grade Life Stone - Level 52
(20640, 8745, 1, 1, 2, 32.203416), -- High-Grade Life Stone - Level 52
(20640, 8755, 1, 1, 2, 6.368586), -- Top-Grade Life Stone - Level 52
-- Harit Lizardman Grunt
(20641, 2097, 1, 1, -1, 9668), -- War Axe Blade
(20641, 2355, 1, 1, -1, 2944), -- Recipe: Ghoul's Staff
(20641, 4042, 1, 1, -1, 30082), -- Enria
(20641, 57, 715, 1452, 0, 700000), -- Adena
(20641, 854, 1, 1, 1, 109.796841), -- Earring of Seal
(20641, 1914, 1, 1, 1, 6988.01558), -- Earring of Seal Gemstone
(20641, 917, 1, 1, 1, 82.35353), -- Necklace of Mermaid
(20641, 1916, 1, 1, 1, 5293.04307), -- Necklace of Mermaid Teardrop
(20641, 885, 1, 1, 1, 164.636269), -- Ring of Ages
(20641, 1915, 1, 1, 1, 10959.15471), -- Ring of Ages Gemstone
(20641, 1867, 1, 1, 2, 82934.40647), -- Animal Skin
(20641, 1872, 1, 1, 2, 82934.40647), -- Animal Bone
(20641, 1882, 1, 1, 2, 13822.369724), -- Leather
(20641, 1894, 1, 1, 2, 2182.449726), -- Crafted Leather
(20641, 4042, 1, 1, 2, 1036.762386), -- Enria
(20641, 4124, 1, 1, 2, 2764.51157), -- Recipe: Craftsman Mold (100%)
(20641, 4609, 1, 1, 2, 138.27261), -- Greater Dye of MEN (Men+3 Int-3)
(20641, 2353, 1, 1, 2, 101.399914), -- Recipe: Samurai Longsword
(20641, 8725, 1, 1, 2, 1727.749184), -- Life Stone - Level 52
(20641, 8735, 1, 1, 2, 431.937296), -- Mid-Grade Life Stone - Level 52
(20641, 8745, 1, 1, 2, 43.26898), -- High-Grade Life Stone - Level 52
(20641, 8755, 1, 1, 2, 8.46567), -- Top-Grade Life Stone - Level 52
-- Harit Lizardman Archer
(20642, 2103, 1, 1, -1, 9533), -- Sage's Staff Head
(20642, 2358, 1, 1, -1, 2759), -- Recipe: Great Pata
(20642, 4602, 1, 1, -1, 3758), -- Greater Dye of STR (Str+3 Dex-3)
(20642, 57, 672, 1357, 0, 700000), -- Adena
(20642, 283, 1, 1, 1, 21.16776), -- Akat Long Bow
(20642, 2109, 1, 1, 1, 1960.83224), -- Akat Longbow Shaft
(20642, 1873, 1, 1, 2, 18648.809658), -- Silver Nugget
(20642, 1868, 1, 1, 2, 93244.04829), -- Thread
(20642, 1876, 1, 1, 2, 9324.241698), -- Mithril Ore
(20642, 1895, 1, 1, 2, 13320.624936), -- Metallic Fiber
(20642, 4042, 1, 1, 2, 777.156084), -- Enria
(20642, 4606, 1, 1, 2, 103.751316), -- Greater Dye of DEX (Dex+3 Con-3)
(20642, 3017, 1, 1, 2, 1302.437904), -- Recipe: Divine Gloves
(20642, 5155, 1, 1, 2, 93.310932), -- Recipe: Soulshot (B) Compressed Package (100%)
(20642, 3015, 1, 1, 2, 1302.437904), -- Recipe: Drake Leather Gloves
(20642, 8725, 1, 1, 2, 1294.933878), -- Life Stone - Level 52
(20642, 8735, 1, 1, 2, 323.651904), -- Mid-Grade Life Stone - Level 52
(20642, 8745, 1, 1, 2, 32.299938), -- High-Grade Life Stone - Level 52
(20642, 8755, 1, 1, 2, 6.52524), -- Top-Grade Life Stone - Level 52
(20642, 1342, 10, 30, 2, 93244.04829), -- Steel Arrow
-- Harit Lizardman Warrior
(20643, 3955, 1, 1, -1, 3483), -- Recipe: Blessed Spiritshot B
(20643, 2114, 1, 1, -1, 8434), -- Widowmaker Head
(20643, 1918, 1, 1, -1, 75426), -- Nassen's Earring Gemstone
(20643, 57, 689, 1400, 0, 700000), -- Adena
(20643, 2497, 1, 1, 1, 111.328191), -- Full Plate Shield
(20643, 2966, 1, 1, 1, 8796.905481), -- Full Plate Shield Fragment
(20643, 2414, 1, 1, 1, 77.928279), -- Full Plate Helmet
(20643, 2959, 1, 1, 1, 5560.838049), -- Full Plate Helmet Design
(20643, 1894, 1, 1, 2, 1880.22975), -- Crafted Leather
(20643, 4039, 1, 1, 2, 1786.228796), -- Mold Glue
(20643, 4041, 1, 1, 2, 465.959906), -- Mold Hardener
(20643, 4044, 1, 1, 2, 1786.228796), -- Thons
(20643, 4126, 1, 1, 2, 884.266258), -- Recipe: Adamantite Earrings (100%)
(20643, 5270, 1, 1, 2, 107.167829), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20643, 5275, 1, 1, 2, 107.167829), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20643, 6669, 1, 1, 2, 12461.994247), -- Deluxe Chest Key - Grade 5
(20643, 8726, 1, 1, 2, 1240.42496), -- Life Stone - Level 55
(20643, 8736, 1, 1, 2, 310.10624), -- Mid-Grade Life Stone - Level 55
(20643, 8746, 1, 1, 2, 31.010624), -- High-Grade Life Stone - Level 55
(20643, 8756, 1, 1, 2, 6.214765), -- Top-Grade Life Stone - Level 55
-- Harit Lizardman Shaman
(20644, 1865, 1, 3, -1, 854261), -- Varnish
(20644, 1987, 1, 1, -1, 26066), -- Drake Leather Armor Texture
(20644, 1806, 1, 1, -1, 3417), -- Recipe: Soulshot (B-Grade)
(20644, 57, 675, 1374, 0, 700000), -- Adena
(20644, 442, 1, 1, 1, 38.23255), -- Divine Tunic
(20644, 1988, 1, 1, 1, 3030.335562), -- Divine Tunic Fabric
(20644, 473, 1, 1, 1, 61.156314), -- Divine Stockings
(20644, 1989, 1, 1, 1, 4753.275574), -- Divine Stocking Pattern
(20644, 1864, 1, 1, 2, 97052.069108), -- Stem
(20644, 1869, 1, 1, 2, 48526.034554), -- Iron Ore
(20644, 1878, 1, 1, 2, 19410.493394), -- Braided Hemp
(20644, 1884, 1, 1, 2, 29862.129203), -- Cord
(20644, 4039, 1, 1, 2, 1617.507961), -- Mold Glue
(20644, 4147, 1, 1, 2, 498.720017), -- Recipe: Stockings of Zubei (100%)
(20644, 4184, 1, 1, 2, 55.899611), -- Recipe: Sprite's Staff (100%)
(20644, 5160, 1, 1, 2, 97.078328), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20644, 4142, 1, 1, 2, 373.194556), -- Recipe: Avadon Gaiters (100%)
(20644, 8726, 1, 1, 2, 1123.363357), -- Life Stone - Level 55
(20644, 8736, 1, 1, 2, 280.890572), -- Mid-Grade Life Stone - Level 55
(20644, 8746, 1, 1, 2, 28.049271), -- High-Grade Life Stone - Level 55
(20644, 8756, 1, 1, 2, 5.570068), -- Top-Grade Life Stone - Level 55
-- Harit Lizardman Matriarch
(20645, 2121, 1, 1, -1, 17683), -- Eminence Bow Shaft
(20645, 1885, 1, 1, -1, 320445), -- High-Grade Suede
(20645, 1920, 1, 1, -1, 131577), -- Necklace of Seal Chain
(20645, 57, 1520, 3096, 0, 700000), -- Adena
(20645, 286, 1, 1, 1, 30.126185), -- Eminence Bow
(20645, 2121, 1, 1, 1, 3264.873815), -- Eminence Bow Shaft
(20645, 1870, 1, 1, 2, 118317.975663), -- Coal
(20645, 1865, 1, 1, 2, 118317.975663), -- Varnish
(20645, 1874, 1, 1, 2, 7887.985356), -- Oriharukon Ore
(20645, 4043, 1, 1, 2, 3943.992678), -- Asofe
(20645, 4039, 1, 1, 2, 3943.992678), -- Mold Glue
(20645, 4189, 1, 1, 2, 136.382019), -- Recipe: Arthro Nail (100%)
(20645, 5275, 1, 1, 2, 236.670498), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20645, 4179, 1, 1, 2, 1520.827089), -- Recipe: Zubei's Helmet (100%)
(20645, 8726, 1, 1, 2, 2738.726253), -- Life Stone - Level 55
(20645, 8736, 1, 1, 2, 684.746016), -- Mid-Grade Life Stone - Level 55
(20645, 8746, 1, 1, 2, 68.577726), -- High-Grade Life Stone - Level 55
(20645, 8756, 1, 1, 2, 13.148361), -- Top-Grade Life Stone - Level 55
-- Halingka
(20646, 4044, 1, 1, -1, 96583), -- Thons
(20646, 2122, 1, 1, -1, 13225), -- Orcish Poleaxe Blade
(20646, 3034, 1, 1, -1, 5795), -- Recipe: Spiritshot B
(20646, 57, 1145, 2333, 0, 700000), -- Adena
(20646, 301, 1, 1, 1, 9.696768), -- Scorpion
(20646, 2113, 1, 1, 1, 863.5542), -- Scorpion Blade
(20646, 303, 1, 1, 1, 9.696768), -- Widow Maker
(20646, 2114, 1, 1, 1, 863.5542), -- Widowmaker Head
(20646, 299, 1, 1, 1, 7.565328), -- Orcish Poleaxe
(20646, 2122, 1, 1, 1, 813.932736), -- Orcish Poleaxe Blade
(20646, 1864, 1, 1, 2, 178306.774196), -- Stem
(20646, 1869, 1, 1, 2, 89153.387098), -- Iron Ore
(20646, 1878, 1, 1, 2, 35661.500432), -- Braided Hemp
(20646, 1884, 1, 1, 2, 54863.734824), -- Cord
(20646, 4039, 1, 1, 2, 2971.91303), -- Mold Glue
(20646, 4190, 1, 1, 2, 102.642924), -- Recipe: Dark Elven Long Bow (100%)
(20646, 4186, 1, 1, 2, 102.642924), -- Recipe: Sword of Valhalla (100%)
(20646, 5165, 1, 1, 2, 178.35118), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20646, 8726, 1, 1, 2, 2063.77794), -- Life Stone - Level 55
(20646, 8736, 1, 1, 2, 515.762494), -- Mid-Grade Life Stone - Level 55
(20646, 8746, 1, 1, 2, 51.685444), -- High-Grade Life Stone - Level 55
(20646, 8756, 1, 1, 2, 9.827514), -- Top-Grade Life Stone - Level 55
-- Yintzu
(20647, 2960, 1, 1, -1, 158666), -- Drake Leather Boots Design
(20647, 4049, 1, 1, -1, 152841), -- Adamantite Earring Gemstone
(20647, 947, 1, 1, -1, 1166), -- Scroll: Enchant Weapon (B-Grade)
(20647, 57, 1150, 2348, 0, 700000), -- Adena
(20647, 554, 1, 1, 1, 53.916544), -- Sealed Zubei's Boots
(20647, 4097, 1, 1, 1, 5600.083456), -- Sealed Zubei's Boots Design
(20647, 600, 1, 1, 1, 53.916544), -- Sealed Avadon Boots
(20647, 4098, 1, 1, 1, 5600.083456), -- Sealed Avadon Boots Design
(20647, 612, 1, 1, 1, 53.916544), -- Sealed Zubei's Gauntlets
(20647, 4100, 1, 1, 1, 5600.083456), -- Sealed Zubei's Gauntlets Part
(20647, 2464, 1, 1, 1, 53.916544), -- Sealed Avadon Gloves
(20647, 4073, 1, 1, 1, 5600.083456), -- Sealed Avadon Gloves Part
(20647, 1865, 1, 1, 2, 71726.827744), -- Varnish
(20647, 1870, 1, 1, 2, 71726.827744), -- Coal
(20647, 1879, 1, 1, 2, 11954.526276), -- Cokes
(20647, 1875, 1, 1, 2, 4781.744528), -- Stone of Purity
(20647, 4040, 1, 1, 2, 1434.457376), -- Mold Lubricant
(20647, 4946, 1, 1, 2, 459.732372), -- Recipe: Zubei's Leather Shirt (60%)
(20647, 5280, 1, 1, 2, 143.51172), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20647, 4176, 1, 1, 2, 892.082048), -- Recipe: Sealed Doom Boots (100%)
(20647, 8727, 1, 1, 2, 1434.457376), -- Life Stone - Level 58
(20647, 8737, 1, 1, 2, 358.614344), -- Mid-Grade Life Stone - Level 58
(20647, 8747, 1, 1, 2, 35.795452), -- High-Grade Life Stone - Level 58
(20647, 8757, 1, 1, 2, 7.42302), -- Top-Grade Life Stone - Level 58
-- Paliote
(20648, 4191, 1, 1, -1, 3620), -- Recipe: Great Axe (100%)
(20648, 2963, 1, 1, -1, 171074), -- Full Plate Gauntlets Part
(20648, 1868, 1, 13, -1, 897647), -- Thread
(20648, 57, 1239, 2531, 0, 700000), -- Adena
(20648, 554, 1, 1, 1, 58.131456), -- Sealed Zubei's Boots
(20648, 4097, 1, 1, 1, 6037.868544), -- Sealed Zubei's Boots Design
(20648, 600, 1, 1, 1, 58.131456), -- Sealed Avadon Boots
(20648, 4098, 1, 1, 1, 6037.868544), -- Sealed Avadon Boots Design
(20648, 612, 1, 1, 1, 58.131456), -- Sealed Zubei's Gauntlets
(20648, 4100, 1, 1, 1, 6037.868544), -- Sealed Zubei's Gauntlets Part
(20648, 2464, 1, 1, 1, 58.131456), -- Sealed Avadon Gloves
(20648, 4073, 1, 1, 1, 6037.868544), -- Sealed Avadon Gloves Part
(20648, 1873, 1, 1, 2, 30934.28802), -- Silver Nugget
(20648, 1868, 1, 1, 2, 154671.193297), -- Thread
(20648, 1876, 1, 1, 2, 15467.14401), -- Mithril Ore
(20648, 1895, 1, 1, 2, 22095.778984), -- Metallic Fiber
(20648, 4042, 1, 1, 2, 1288.805266), -- Enria
(20648, 4961, 1, 1, 2, 1419.11725), -- Recipe: Zubei's Shield (60%)
(20648, 4999, 1, 1, 2, 961.791291), -- Recipe: Sealed Doom Boots (60%)
(20648, 6669, 1, 1, 2, 17985.028216), -- Deluxe Chest Key - Grade 5
(20648, 8727, 1, 1, 2, 1546.714401), -- Life Stone - Level 58
(20648, 8737, 1, 1, 2, 386.740301), -- Mid-Grade Life Stone - Level 58
(20648, 8747, 1, 1, 2, 38.748071), -- High-Grade Life Stone - Level 58
(20648, 8757, 1, 1, 2, 7.650893), -- Top-Grade Life Stone - Level 58
-- Hamrut
(20649, 2112, 1, 1, -1, 16014), -- Pa'agrian Axe Blade
(20649, 4133, 1, 1, -1, 15899), -- Recipe: Zubei's Breastplate (100%)
(20649, 5549, 1, 1, -1, 330694), -- Metallic Thread
(20649, 57, 1306, 2660, 0, 700000), -- Adena
(20649, 78, 1, 1, 1, 4.87334), -- Great Sword
(20649, 4104, 1, 1, 1, 931.41398), -- Great Sword Blade
(20649, 142, 1, 1, 1, 4.87334), -- Keshanberk
(20649, 4107, 1, 1, 1, 916.983), -- Keshanberk Blade
(20649, 148, 1, 1, 1, 4.87334), -- Sword of Valhalla
(20649, 4108, 1, 1, 1, 916.983), -- Sword of Valhalla Blade
(20649, 1868, 1, 1, 2, 150280.240366), -- Thread
(20649, 1873, 1, 1, 2, 30055.935682), -- Silver Nugget
(20649, 5549, 1, 1, 2, 7513.913676), -- Metallic Thread
(20649, 1889, 1, 1, 2, 5009.275784), -- Compound Braid
(20649, 4044, 1, 1, 2, 2504.637892), -- Thons
(20649, 4970, 1, 1, 2, 86.541224), -- Recipe: Arthro Nail (60%)
(20649, 4194, 1, 1, 2, 57.319512), -- Recipe: Deadman's Glory (100%)
(20649, 8311, 1, 1, 2, 57.319512), -- Recipe: Kaim Vanul's Bones (100%)
(20649, 8727, 1, 1, 2, 1502.670344), -- Life Stone - Level 58
(20649, 8737, 1, 1, 2, 375.667586), -- Mid-Grade Life Stone - Level 58
(20649, 8747, 1, 1, 2, 37.651052), -- High-Grade Life Stone - Level 58
(20649, 8757, 1, 1, 2, 7.586406), -- Top-Grade Life Stone - Level 58
(20649, 1832, 1, 1, 2, 83489.240964), -- Greater Antidote
-- Kranrot
(20650, 4049, 1, 1, -1, 188177), -- Adamantite Earring Gemstone
(20650, 4195, 1, 1, -1, 2739), -- Recipe: Art of Battle Axe (100%)
(20650, 4613, 1, 1, -1, 4948), -- Greater Dye of STR (Str+4 Con-4)
(20650, 57, 1417, 2887, 0, 700000), -- Adena
(20650, 856, 1, 1, 1, 75.817654), -- Adamantite Earring
(20650, 4049, 1, 1, 1, 9263.677808), -- Adamantite Earring Gemstone
(20650, 918, 1, 1, 1, 56.870066), -- Adamantite Necklace
(20650, 4051, 1, 1, 1, 6849.416552), -- Adamantite Necklace Chain
(20650, 887, 1, 1, 1, 113.71283), -- Adamantite Ring
(20650, 4050, 1, 1, 1, 10942.50509), -- Adamantite Ring Wire
(20650, 1867, 1, 1, 2, 117746.485692), -- Animal Skin
(20650, 1872, 1, 1, 2, 117746.485692), -- Animal Bone
(20650, 1882, 1, 1, 2, 19624.414282), -- Leather
(20650, 1894, 1, 1, 2, 3098.702882), -- Crafted Leather
(20650, 4042, 1, 1, 2, 1471.738675), -- Enria
(20650, 948, 1, 1, 2, 220.694804), -- Scroll: Enchant Armor (B-Grade)
(20650, 4167, 1, 1, 2, 1098.458229), -- Recipe: Sealed Blue Wolf Boots (100%)
(20650, 4168, 1, 1, 2, 1098.458229), -- Recipe: Sealed Doom Gloves (100%)
(20650, 8728, 1, 1, 2, 1471.738675), -- Life Stone - Level 61
(20650, 8738, 1, 1, 2, 368.000666), -- Mid-Grade Life Stone - Level 61
(20650, 8748, 1, 1, 2, 36.694471), -- High-Grade Life Stone - Level 61
(20650, 8758, 1, 1, 2, 7.127703), -- Top-Grade Life Stone - Level 61
-- Gamlin
(20651, 4050, 1, 1, -1, 206850), -- Adamantite Ring Wire
(20651, 4196, 1, 1, -1, 2549), -- Recipe: Staff of Evil Spirits (100%)
(20651, 57, 1320, 2684, 0, 700000), -- Adena
(20651, 78, 1, 1, 1, 4.920671), -- Great Sword
(20651, 4104, 1, 1, 1, 940.460087), -- Great Sword Blade
(20651, 142, 1, 1, 1, 4.920671), -- Keshanberk
(20651, 4107, 1, 1, 1, 925.88895), -- Keshanberk Blade
(20651, 148, 1, 1, 1, 4.920671), -- Sword of Valhalla
(20651, 4108, 1, 1, 1, 925.88895), -- Sword of Valhalla Blade
(20651, 1867, 1, 1, 2, 109573.022592), -- Animal Skin
(20651, 1872, 1, 1, 2, 109573.022592), -- Animal Bone
(20651, 1882, 1, 1, 2, 18262.170432), -- Leather
(20651, 1894, 1, 1, 2, 2883.604032), -- Crafted Leather
(20651, 4042, 1, 1, 2, 1369.5768), -- Enria
(20651, 948, 1, 1, 2, 205.375104), -- Scroll: Enchant Armor (B-Grade)
(20651, 4167, 1, 1, 2, 1022.207904), -- Recipe: Sealed Blue Wolf Boots (100%)
(20651, 4168, 1, 1, 2, 1022.207904), -- Recipe: Sealed Doom Gloves (100%)
(20651, 8728, 1, 1, 2, 1369.5768), -- Life Stone - Level 61
(20651, 8738, 1, 1, 2, 342.455616), -- Mid-Grade Life Stone - Level 61
(20651, 8748, 1, 1, 2, 34.147296), -- High-Grade Life Stone - Level 61
(20651, 8758, 1, 1, 2, 6.632928), -- Top-Grade Life Stone - Level 61
-- Leogul
(20652, 4042, 1, 1, -1, 58802), -- Enria
(20652, 4043, 1, 1, -1, 117603), -- Asofe
(20652, 4129, 1, 1, -1, 38183), -- Recipe: Earrings of Black Ore (100%)
(20652, 57, 1398, 2835, 0, 700000), -- Adena
(20652, 2384, 1, 1, 1, 29.021255), -- Zubei's Leather Shirt
(20652, 4066, 1, 1, 1, 4095.94146), -- Zubei's Leather Shirt Fabric
(20652, 2390, 1, 1, 1, 17.851935), -- Avadon Leather Armor
(20652, 4068, 1, 1, 1, 3146.698365), -- Avadon Leather Armor Lining
(20652, 2388, 1, 1, 1, 46.43943), -- Zubei's Leather Gaiters
(20652, 4067, 1, 1, 1, 6219.047555), -- Zubei's Leather Gaiter Texture
(20652, 1869, 1, 1, 2, 86845.277172), -- Iron Ore
(20652, 1864, 1, 1, 2, 173690.554344), -- Stem
(20652, 1880, 1, 1, 2, 8684.472236), -- Steel
(20652, 5550, 1, 1, 2, 1157.892644), -- Durable Metal Plate
(20652, 4043, 1, 1, 2, 2894.73161), -- Asofe
(20652, 4615, 1, 1, 2, 119.839392), -- Greater Dye of CON (Con+4 Str-4)
(20652, 4998, 1, 1, 2, 1080.218964), -- Recipe: Sealed Blue Wolf Gloves (60%)
(20652, 4173, 1, 1, 2, 1080.218964), -- Recipe: Sealed Blue Wolf Gloves (100%)
(20652, 8728, 1, 1, 2, 1447.504508), -- Life Stone - Level 61
(20652, 8738, 1, 1, 2, 361.737424), -- Mid-Grade Life Stone - Level 61
(20652, 8748, 1, 1, 2, 36.06278), -- High-Grade Life Stone - Level 61
(20652, 8758, 1, 1, 2, 7.489962), -- Top-Grade Life Stone - Level 61
-- Lesser Giant Soldier
(20654, 4064, 1, 1, -1, 119042), -- Avadon Breastplate Part
(20654, 4052, 1, 1, -1, 232857), -- Earring of Black Ore Piece
(20654, 5230, 1, 1, -1, 8769), -- Recipe: Mithril Arrow (100%)
(20654, 57, 2608, 5284, 0, 700000), -- Adena
(20654, 2398, 1, 1, 1, 26.155129), -- Blue Wolf Tunic
(20654, 4084, 1, 1, 1, 4221.905376), -- Blue Wolf Tunic Fabric
(20654, 2399, 1, 1, 1, 26.155129), -- Tunic of Doom
(20654, 4085, 1, 1, 1, 4221.905376), -- Tunic of Doom Pattern
(20654, 2403, 1, 1, 1, 41.880176), -- Blue Wolf Stockings
(20654, 4086, 1, 1, 1, 5700.539338), -- Blue Wolf Stockings Pattern
(20654, 2404, 1, 1, 1, 41.880176), -- Stockings of Doom
(20654, 4087, 1, 1, 1, 5700.5793), -- Stockings of Doom Pattern
(20654, 1894, 1, 1, 2, 6197.111536), -- Crafted Leather
(20654, 4039, 1, 1, 2, 5887.22996), -- Mold Glue
(20654, 4041, 1, 1, 2, 1535.801632), -- Mold Hardener
(20654, 4044, 1, 1, 2, 5887.22996), -- Thons
(20654, 4624, 1, 1, 2, 243.612504), -- Greater Dye of WIT (Wit+4 Men-4)
(20654, 5276, 1, 1, 2, 235.494976), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20654, 8729, 1, 1, 2, 2354.891984), -- Life Stone - Level 64
(20654, 8739, 1, 1, 2, 588.73744); -- Mid-Grade Life Stone - Level 64

INSERT INTO `droplist` VALUES
(20654, 8749, 1, 1, 2, 58.873744), -- High-Grade Life Stone - Level 64
(20654, 8759, 1, 1, 2, 11.786304), -- Top-Grade Life Stone - Level 64
(20654, 6036, 1, 1, 2, 5887.22996), -- Greater Magic Haste Potion
-- Lesser Giant Shooter
(20655, 4067, 1, 1, -1, 212287), -- Zubei's Leather Gaiter Texture
(20655, 4160, 1, 1, -1, 16800), -- Recipe: Leather Armor of Doom (100%)
(20655, 4053, 1, 1, -1, 254190), -- Ring of Black Ore Gemstone
(20655, 57, 2352, 4762, 0, 700000), -- Adena
(20655, 110, 1, 1, 1, 89.858003), -- Doom Shield
(20655, 4077, 1, 1, 1, 13134.250675), -- Doom Shield Fragment
(20655, 2416, 1, 1, 1, 62.904144), -- Blue Wolf Helmet
(20655, 4088, 1, 1, 1, 11034.541517), -- Blue Wolf Helmet Design
(20655, 2417, 1, 1, 1, 62.904144), -- Doom Helmet
(20655, 4089, 1, 1, 1, 11034.541517), -- Doom Helmet Pattern
(20655, 1870, 1, 1, 2, 134746.353792), -- Coal
(20655, 1865, 1, 1, 2, 134746.353792), -- Varnish
(20655, 1874, 1, 1, 2, 8983.17216), -- Oriharukon Ore
(20655, 4043, 1, 1, 2, 4491.381312), -- Asofe
(20655, 4039, 1, 1, 2, 4491.381312), -- Mold Glue
(20655, 4989, 1, 1, 2, 892.378944), -- Recipe: Stockings of Doom (60%)
(20655, 5276, 1, 1, 2, 179.786304), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20655, 6670, 1, 1, 2, 22457.725632), -- Deluxe Chest Key - Grade 6
(20655, 8729, 1, 1, 2, 1796.634432), -- Life Stone - Level 64
(20655, 8739, 1, 1, 2, 449.260992), -- Mid-Grade Life Stone - Level 64
(20655, 8749, 1, 1, 2, 45.04896), -- High-Grade Life Stone - Level 64
(20655, 8759, 1, 1, 2, 9.009792), -- Top-Grade Life Stone - Level 64
(20655, 1343, 20, 60, 2, 96247.512576), -- Silver Arrow
-- Lesser Giant Scout
(20656, 4069, 1, 1, -1, 134666), -- Tunic of Zubei Fabric
(20656, 4040, 1, 1, -1, 114237), -- Mold Lubricant
(20656, 57, 2265, 4587, 0, 700000), -- Adena
(20656, 2398, 1, 1, 1, 22.713768), -- Blue Wolf Tunic
(20656, 4084, 1, 1, 1, 3666.408192), -- Blue Wolf Tunic Fabric
(20656, 2399, 1, 1, 1, 22.713768), -- Tunic of Doom
(20656, 4085, 1, 1, 1, 3666.408192), -- Tunic of Doom Pattern
(20656, 2403, 1, 1, 1, 36.369792), -- Blue Wolf Stockings
(20656, 4086, 1, 1, 1, 4950.490896), -- Blue Wolf Stockings Pattern
(20656, 2404, 1, 1, 1, 36.369792), -- Stockings of Doom
(20656, 4087, 1, 1, 1, 4950.5256), -- Stockings of Doom Pattern
(20656, 1895, 1, 1, 2, 48205.247259), -- Metallic Fiber
(20656, 4040, 1, 1, 2, 3374.407044), -- Mold Lubricant
(20656, 4042, 1, 1, 2, 2812.00587), -- Enria
(20656, 4043, 1, 1, 2, 5623.919331), -- Asofe
(20656, 4990, 1, 1, 2, 1394.359401), -- Recipe: Blue Wolf Helmet (60%)
(20656, 6670, 1, 1, 2, 28119.689064), -- Deluxe Chest Key - Grade 6
(20656, 8729, 1, 1, 2, 2249.604696), -- Life Stone - Level 64
(20656, 8739, 1, 1, 2, 562.401174), -- Mid-Grade Life Stone - Level 64
(20656, 8749, 1, 1, 2, 56.277081), -- High-Grade Life Stone - Level 64
(20656, 8759, 1, 1, 2, 11.08908), -- Top-Grade Life Stone - Level 64
-- Lesser Giant Mage
(20657, 1920, 1, 1, -1, 144429), -- Necklace of Seal Chain
(20657, 1914, 1, 1, -1, 237131), -- Earring of Seal Gemstone
(20657, 1877, 1, 1, -1, 168837), -- Adamantite Nugget
(20657, 57, 1676, 3389, 0, 700000), -- Adena
(20657, 2398, 1, 1, 1, 16.785307), -- Blue Wolf Tunic
(20657, 4084, 1, 1, 1, 2709.448608), -- Blue Wolf Tunic Fabric
(20657, 2399, 1, 1, 1, 16.785307), -- Tunic of Doom
(20657, 4085, 1, 1, 1, 2709.448608), -- Tunic of Doom Pattern
(20657, 2403, 1, 1, 1, 26.877008), -- Blue Wolf Stockings
(20657, 4086, 1, 1, 1, 3658.376254), -- Blue Wolf Stockings Pattern
(20657, 2404, 1, 1, 1, 26.877008), -- Stockings of Doom
(20657, 4087, 1, 1, 1, 3658.4019), -- Stockings of Doom Pattern
(20657, 1871, 1, 1, 2, 103899.577968), -- Charcoal
(20657, 1866, 1, 1, 2, 69266.385312), -- Suede
(20657, 1877, 1, 1, 2, 4155.931522), -- Adamantite Nugget
(20657, 4041, 1, 1, 2, 903.495422), -- Mold Hardener
(20657, 4040, 1, 1, 2, 2078.057898), -- Mold Lubricant
(20657, 4960, 1, 1, 2, 2001.952736), -- Recipe: Sealed Zubei's Gauntlets (60%)
(20657, 5276, 1, 1, 2, 138.574048), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20657, 8300, 1, 1, 2, 56.756392), -- Recipe: Infernal Master (60%)
(20657, 8729, 1, 1, 2, 1385.371932), -- Life Stone - Level 64
(20657, 8739, 1, 1, 2, 346.250846), -- Mid-Grade Life Stone - Level 64
(20657, 8749, 1, 1, 2, 34.643512), -- High-Grade Life Stone - Level 64
(20657, 8759, 1, 1, 2, 7.002412), -- Top-Grade Life Stone - Level 64
-- Lesser Giant Elder
(20658, 2220, 1, 1, -1, 84264), -- Recipe: Rind Leather Armor
(20658, 1960, 1, 1, -1, 223012), -- Chain Gaiters Part
(20658, 4054, 1, 1, -1, 80165), -- Necklace of Black Ore Beads
(20658, 57, 1613, 3270, 0, 700000), -- Adena
(20658, 864, 1, 1, 1, 56.362295), -- Earring of Black Ore
(20658, 4052, 1, 1, 1, 7093.52666), -- Earring of Black Ore Piece
(20658, 926, 1, 1, 1, 42.276674), -- Necklace of Black Ore
(20658, 4054, 1, 1, 1, 3946.3512), -- Necklace of Black Ore Beads
(20658, 895, 1, 1, 1, 84.533537), -- Ring of Black Ore
(20658, 4053, 1, 1, 1, 8587.949634), -- Ring of Black Ore Gemstone
(20658, 1866, 1, 1, 2, 66789.15416), -- Suede
(20658, 1871, 1, 1, 2, 100183.73124), -- Charcoal
(20658, 5220, 1, 1, 2, 4007.32576), -- Metal Hardener
(20658, 1885, 1, 1, 2, 8348.79108), -- High-Grade Suede
(20658, 4041, 1, 1, 2, 871.17054), -- Mold Hardener
(20658, 4155, 1, 1, 2, 311.2372), -- Recipe: Blue Wolf Breastplate (100%)
(20658, 730, 1, 1, 2, 83.38808), -- Scroll: Enchant Armor (A-Grade)
(20658, 8729, 1, 1, 2, 1335.67738), -- Life Stone - Level 64
(20658, 8739, 1, 1, 2, 333.84594), -- Mid-Grade Life Stone - Level 64
(20658, 8749, 1, 1, 2, 33.47268), -- High-Grade Life Stone - Level 64
(20658, 8759, 1, 1, 2, 6.75326), -- Top-Grade Life Stone - Level 64
(20658, 1832, 1, 1, 2, 111315.45268), -- Greater Antidote
-- Grave Wanderer
(20659, 2062, 1, 1, -1, 10273), -- Scythe Edge
(20659, 1885, 1, 1, -1, 109145), -- High-Grade Suede
(20659, 2163, 1, 1, -1, 66824), -- Recipe: Earring of Protection
(20659, 57, 518, 1052, 0, 700000), -- Adena
(20659, 631, 1, 1, 1, 202.2864), -- Eldarake
(20659, 1964, 1, 1, 1, 8336.20767), -- Eldarake Temper
(20659, 2495, 1, 1, 1, 202.2864), -- Chain Shield
(20659, 2945, 1, 1, 1, 8336.20767), -- Chain Shield Fragment
(20659, 2413, 1, 1, 1, 141.60048), -- Chain Hood
(20659, 2936, 1, 1, 1, 7571.41138), -- Chain Hood Pattern
(20659, 1868, 1, 1, 2, 95232.000732), -- Thread
(20659, 1873, 1, 1, 2, 19046.425789), -- Silver Nugget
(20659, 5549, 1, 1, 2, 4761.574394), -- Metallic Thread
(20659, 1889, 1, 1, 2, 3174.425667), -- Compound Braid
(20659, 4044, 1, 1, 2, 1587.148727), -- Thons
(20659, 3021, 1, 1, 2, 165.907622), -- Recipe: Dwarven War Hammer
(20659, 2225, 1, 1, 2, 1035.191762), -- Recipe: Demon's Stockings
(20659, 2321, 1, 1, 2, 165.907622), -- Recipe: Stiletto
(20659, 2215, 1, 1, 2, 606.575703), -- Recipe: Robe of Seal
(20659, 8723, 1, 1, 2, 1904.604115), -- Life Stone - Level 46
(20659, 8733, 1, 1, 2, 476.183082), -- Mid-Grade Life Stone - Level 46
(20659, 8743, 1, 1, 2, 47.567023), -- High-Grade Life Stone - Level 46
(20659, 8753, 1, 1, 2, 9.487762), -- Top-Grade Life Stone - Level 46
-- Archer of Greed
(20660, 2330, 1, 1, -1, 3761), -- Recipe: Homunkulus's Sword
(20660, 2084, 1, 1, -1, 10746), -- Soulfire Dirk Blade
(20660, 1908, 1, 1, -1, 153154), -- Moonstone Earring Wire
(20660, 57, 637, 1303, 0, 700000), -- Adena
(20660, 439, 1, 1, 1, 131.332864), -- Karmian Tunic
(20660, 1962, 1, 1, 1, 6115.236328), -- Karmian Tunic Pattern
(20660, 471, 1, 1, 1, 209.893312), -- Karmian Stockings
(20660, 1954, 1, 1, 1, 10159.537496), -- Karmian Stocking Design
(20660, 1869, 1, 1, 2, 76436.092936), -- Iron Ore
(20660, 1864, 1, 1, 2, 152871.93754), -- Stem
(20660, 1880, 1, 1, 2, 7643.65896), -- Steel
(20660, 5550, 1, 1, 2, 1019.154528), -- Durable Metal Plate
(20660, 4043, 1, 1, 2, 2547.88632), -- Asofe
(20660, 2163, 1, 1, 2, 3899.805728), -- Recipe: Earring of Protection
(20660, 8723, 1, 1, 2, 3057.463584), -- Life Stone - Level 46
(20660, 8733, 1, 1, 2, 764.365896), -- Mid-Grade Life Stone - Level 46
(20660, 8743, 1, 1, 2, 76.486256), -- High-Grade Life Stone - Level 46
(20660, 8753, 1, 1, 2, 15.148252), -- Top-Grade Life Stone - Level 46
-- Hatar Ratman Thief
(20661, 2223, 1, 1, -1, 59150), -- Recipe: Tower Shield
(20661, 2347, 1, 1, -1, 3549), -- Recipe: Akat Long Bow
(20661, 2166, 1, 1, -1, 51732), -- Recipe: Earrings of Binding (100%)
(20661, 57, 602, 1229, 0, 700000), -- Adena
(20661, 2496, 1, 1, 1, 187.671942), -- Dwarven Chain Shield
(20661, 2947, 1, 1, 1, 8049.505542), -- Dwarven Chain Shield Fragment
(20661, 632, 1, 1, 1, 173.248802), -- Knight's Shield
(20661, 1972, 1, 1, 1, 9015.44034), -- Knight's Shield Fragment
(20661, 500, 1, 1, 1, 121.301052), -- Great Helmet
(20661, 1971, 1, 1, 1, 6898.832322), -- Great Helmet Material
(20661, 1873, 1, 1, 2, 19319.157744), -- Silver Nugget
(20661, 1868, 1, 1, 2, 96595.322192), -- Thread
(20661, 1876, 1, 1, 2, 9659.46224), -- Mithril Ore
(20661, 1895, 1, 1, 2, 13799.431712), -- Metallic Fiber
(20661, 4042, 1, 1, 2, 804.994064), -- Enria
(20661, 2223, 1, 1, 2, 1871.9436), -- Recipe: Tower Shield
(20661, 2230, 1, 1, 2, 936.088432), -- Recipe: Theca Leather Gaiters
(20661, 3005, 1, 1, 2, 1971.314064), -- Recipe: Demon's Boots
(20661, 6668, 1, 1, 2, 17249.173008), -- Deluxe Chest Key - Grade 4
(20661, 8724, 1, 1, 2, 1609.988128), -- Life Stone - Level 49
(20661, 8734, 1, 1, 2, 402.3804), -- Mid-Grade Life Stone - Level 49
(20661, 8744, 1, 1, 2, 40.354672), -- High-Grade Life Stone - Level 49
(20661, 8754, 1, 1, 2, 8.16424), -- Top-Grade Life Stone - Level 49
(20661, 1343, 10, 30, 2, 68996.225504), -- Silver Arrow
-- Hatar Ratman Boss
(20662, 951, 1, 1, -1, 2897), -- Scroll: Enchant Weapon (C-Grade)
(20662, 1873, 1, 1, -1, 637338), -- Silver Nugget
(20662, 1911, 1, 1, -1, 118508), -- Earring of Protection Gemstone
(20662, 57, 630, 1281, 0, 700000), -- Adena
(20662, 73, 1, 1, 1, 7.98672), -- Shamshir
(20662, 2077, 1, 1, 1, 586.26328), -- Shamshir Blade
(20662, 74, 1, 1, 1, 7.98672), -- Katana
(20662, 2078, 1, 1, 1, 586.26328), -- Katana Blade
(20662, 131, 1, 1, 1, 7.98672), -- Spirit Sword
(20662, 2080, 1, 1, 1, 586.26328), -- Spirit Sword Blade
(20662, 133, 1, 1, 1, 7.98672), -- Raid Sword
(20662, 2081, 1, 1, 1, 586.26328), -- Raid Sword Blade
(20662, 1871, 1, 1, 2, 58831.182362), -- Charcoal
(20662, 1866, 1, 1, 2, 39220.660784), -- Suede
(20662, 1877, 1, 1, 2, 2353.308474), -- Adamantite Nugget
(20662, 4041, 1, 1, 2, 511.613736), -- Mold Hardener
(20662, 4040, 1, 1, 2, 1176.558644), -- Mold Lubricant
(20662, 2340, 1, 1, 2, 136.889176), -- Recipe: Pa'agrian Hammer
(20662, 3006, 1, 1, 2, 2401.29616), -- Recipe: Demon's Gloves
(20662, 8724, 1, 1, 2, 1960.994802), -- Life Stone - Level 49
(20662, 8734, 1, 1, 2, 490.200904), -- Mid-Grade Life Stone - Level 49
(20662, 8744, 1, 1, 2, 48.943616), -- High-Grade Life Stone - Level 49
(20662, 8754, 1, 1, 2, 9.750486), -- Top-Grade Life Stone - Level 49
(20662, 1343, 10, 30, 2, 84044.600856), -- Silver Arrow
-- Hatar Hanishee
(20663, 1981, 1, 1, -1, 82154), -- Mithril Gauntlets Design
(20663, 4123, 1, 1, -1, 62072), -- Recipe: Maestro Anvil Lock (100%)
(20663, 951, 1, 1, -1, 2539), -- Scroll: Enchant Weapon (C-Grade)
(20663, 57, 551, 1124, 0, 700000), -- Adena
(20663, 853, 1, 1, 1, 137.053122), -- Earring of Protection
(20663, 1911, 1, 1, 1, 7671.3024), -- Earring of Protection Gemstone
(20663, 916, 1, 1, 1, 102.828096), -- Necklace of Protection
(20663, 1913, 1, 1, 1, 6271.850778), -- Necklace of Protection Gemstone
(20663, 884, 1, 1, 1, 205.656192), -- Ring of Protection
(20663, 1912, 1, 1, 1, 11114.309412), -- Ring of Protection Gemstone
(20663, 1871, 1, 1, 2, 56254.98765), -- Charcoal
(20663, 1866, 1, 1, 2, 37503.35925), -- Suede
(20663, 1877, 1, 1, 2, 2250.2118), -- Adamantite Nugget
(20663, 4041, 1, 1, 2, 489.19875), -- Mold Hardener
(20663, 4040, 1, 1, 2, 1125.1059), -- Mold Lubricant
(20663, 2340, 1, 1, 2, 130.82865), -- Recipe: Pa'agrian Hammer
(20663, 3006, 1, 1, 2, 2296.1094), -- Recipe: Demon's Gloves
(20663, 8724, 1, 1, 2, 1875.14235), -- Life Stone - Level 49
(20663, 8734, 1, 1, 2, 468.8112), -- Mid-Grade Life Stone - Level 49
(20663, 8744, 1, 1, 2, 46.9221), -- High-Grade Life Stone - Level 49
(20663, 8754, 1, 1, 2, 9.32295), -- Top-Grade Life Stone - Level 49
-- Deprive
(20664, 2098, 1, 1, -1, 7876), -- Nirvana Axe Blade
(20664, 1865, 1, 3, -1, 735264), -- Varnish
(20664, 1867, 1, 5, -1, 653568), -- Animal Skin
(20664, 57, 582, 1182, 0, 700000), -- Adena
(20664, 64, 1, 1, 1, 161.04976), -- Composite Boots
(20664, 2956, 1, 1, 1, 8942.95024), -- Composite Boots Part
(20664, 608, 1, 1, 1, 161.04976), -- Mithril Gauntlets
(20664, 1981, 1, 1, 1, 8942.95024), -- Mithril Gauntlets Design
(20664, 1867, 1, 1, 2, 57916.315041), -- Animal Skin
(20664, 1872, 1, 1, 2, 57916.315041), -- Animal Bone
(20664, 1882, 1, 1, 2, 9652.694199), -- Leather
(20664, 1894, 1, 1, 2, 1524.093837), -- Crafted Leather
(20664, 4042, 1, 1, 2, 723.910857), -- Enria
(20664, 2234, 1, 1, 2, 647.33904), -- Recipe: Divine Stockings
(20664, 4609, 1, 1, 2, 96.501468), -- Greater Dye of MEN (Men+3 Int-3)
(20664, 2356, 1, 1, 2, 70.877631), -- Recipe: Demon's Staff
(20664, 6669, 1, 1, 2, 10101.635811), -- Deluxe Chest Key - Grade 5
(20664, 8725, 1, 1, 2, 1206.568044), -- Life Stone - Level 52
(20664, 8735, 1, 1, 2, 301.642011), -- Mid-Grade Life Stone - Level 52
(20664, 8745, 1, 1, 2, 30.119247), -- High-Grade Life Stone - Level 52
(20664, 8755, 1, 1, 2, 5.99388), -- Top-Grade Life Stone - Level 52
(20664, 1539, 1, 1, 2, 9652.993893), -- Greater Healing Potion
-- Taik Orc Supply
(20665, 2104, 1, 1, -1, 10174), -- Club of Nature Head
(20665, 2359, 1, 1, -1, 2944), -- Recipe: Eminence Bow
(20665, 4043, 1, 1, -1, 60164), -- Asofe
(20665, 57, 715, 1452, 0, 700000), -- Adena
(20665, 162, 1, 1, 1, 2.824002), -- War Axe
(20665, 2097, 1, 1, 1, 249.916904), -- War Axe Blade
(20665, 174, 1, 1, 1, 2.824002), -- Nirvana Axe
(20665, 2098, 1, 1, 1, 249.916904), -- Nirvana Axe Blade
(20665, 196, 1, 1, 1, 2.824002), -- Stick of Eternity
(20665, 2099, 1, 1, 1, 263.018694), -- Stick of Eternity Shaft
(20665, 197, 1, 1, 1, 2.824002), -- Paradia Staff
(20665, 2100, 1, 1, 1, 263.018694), -- Paradia Staff Head
(20665, 199, 1, 1, 1, 2.824002), -- Pa'agrian Hammer
(20665, 2102, 1, 1, 1, 253.584574), -- Pa'agrian Hammer Head
(20665, 200, 1, 1, 1, 2.824002), -- Sage's Staff
(20665, 2103, 1, 1, 1, 263.018694), -- Sage's Staff Head
(20665, 201, 1, 1, 1, 2.824002), -- Club of Nature
(20665, 2104, 1, 1, 1, 263.018694), -- Club of Nature Head
(20665, 202, 1, 1, 1, 2.824002), -- Mace of Underworld
(20665, 2105, 1, 1, 1, 249.914826), -- Mace of Underworld Head
(20665, 1870, 1, 1, 2, 67855.338432), -- Coal
(20665, 1865, 1, 1, 2, 67855.338432), -- Varnish
(20665, 1874, 1, 1, 2, 4523.67909), -- Oriharukon Ore
(20665, 4043, 1, 1, 2, 2261.915586), -- Asofe
(20665, 4039, 1, 1, 2, 2261.915586), -- Mold Glue
(20665, 4125, 1, 1, 2, 3015.78606), -- Recipe: Maestro Mold (100%)
(20665, 3014, 1, 1, 2, 1895.397966), -- Recipe: Full Plate Boots
(20665, 8725, 1, 1, 2, 1884.904308), -- Life Stone - Level 52
(20665, 8735, 1, 1, 2, 471.150036), -- Mid-Grade Life Stone - Level 52
(20665, 8745, 1, 1, 2, 47.14542), -- High-Grade Life Stone - Level 52
(20665, 8755, 1, 1, 2, 9.429084), -- Top-Grade Life Stone - Level 52
-- Taik Orc Seeker
(20666, 1977, 1, 1, -1, 27780), -- Composite Armor Temper
(20666, 1884, 1, 3, -1, 577821), -- Cord
(20666, 4606, 1, 1, -1, 4173), -- Greater Dye of DEX (Dex+3 Con-3)
(20666, 57, 746, 1507, 0, 700000), -- Adena
(20666, 64, 1, 1, 1, 205.66394), -- Composite Boots
(20666, 2956, 1, 1, 1, 11420.33606), -- Composite Boots Part
(20666, 608, 1, 1, 1, 205.66394), -- Mithril Gauntlets
(20666, 1981, 1, 1, 1, 11420.33606), -- Mithril Gauntlets Design
(20666, 1870, 1, 1, 2, 59737.700113), -- Coal
(20666, 1865, 1, 1, 2, 59737.700113), -- Varnish
(20666, 1874, 1, 1, 2, 3982.452642), -- Oriharukon Ore
(20666, 4043, 1, 1, 2, 1991.226321), -- Asofe
(20666, 4039, 1, 1, 2, 1991.226321), -- Mold Glue
(20666, 4607, 1, 1, 2, 132.800449), -- Greater Dye of INT (Int+3 Men-3)
(20666, 4609, 1, 1, 2, 132.800449), -- Greater Dye of MEN (Men+3 Int-3)
(20666, 3955, 1, 1, 2, 119.533411), -- Recipe: Blessed Spiritshot B
(20666, 5280, 1, 1, 2, 119.533411), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20666, 8725, 1, 1, 2, 1659.420302), -- Life Stone - Level 52
(20666, 8735, 1, 1, 2, 414.790041), -- Mid-Grade Life Stone - Level 52
(20666, 8745, 1, 1, 2, 41.492011), -- High-Grade Life Stone - Level 52
(20666, 8755, 1, 1, 2, 8.324416), -- Top-Grade Life Stone - Level 52
-- Farcran
(20667, 1988, 1, 1, -1, 37181), -- Divine Tunic Fabric
(20667, 4141, 1, 1, -1, 9303), -- Recipe: Avadon Breastplate (100%)
(20667, 4604, 1, 1, -1, 4300), -- Greater Dye of CON (Con+3 Dex-3)
(20667, 57, 766, 1556, 0, 700000), -- Adena
(20667, 301, 1, 1, 1, 6.47584), -- Scorpion
(20667, 2113, 1, 1, 1, 576.711625), -- Scorpion Blade
(20667, 303, 1, 1, 1, 6.47584), -- Widow Maker
(20667, 2114, 1, 1, 1, 576.711625), -- Widowmaker Head
(20667, 299, 1, 1, 1, 5.05239), -- Orcish Poleaxe
(20667, 2122, 1, 1, 1, 543.57268), -- Orcish Poleaxe Blade
(20667, 1875, 1, 1, 2, 3664.03052), -- Stone of Purity
(20667, 1879, 1, 1, 2, 9160.0763), -- Cokes
(20667, 1885, 1, 1, 2, 4580.03815), -- High-Grade Suede
(20667, 5550, 1, 1, 2, 732.811485), -- Durable Metal Plate
(20667, 5549, 1, 1, 2, 5496.04578), -- Metallic Thread
(20667, 4127, 1, 1, 2, 1360.397515), -- Recipe: Adamantite Ring (100%)
(20667, 4184, 1, 1, 2, 63.307465), -- Recipe: Sprite's Staff (100%)
(20667, 5155, 1, 1, 2, 109.93383), -- Recipe: Soulshot (B) Compressed Package (100%)
(20667, 5165, 1, 1, 2, 109.93383), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(20667, 8726, 1, 1, 2, 1272.22983), -- Life Stone - Level 55
(20667, 8736, 1, 1, 2, 318.07091), -- Mid-Grade Life Stone - Level 55
(20667, 8746, 1, 1, 2, 31.80171), -- High-Grade Life Stone - Level 55
(20667, 8756, 1, 1, 2, 6.322675), -- Top-Grade Life Stone - Level 55
-- Grave Guard
(20668, 4147, 1, 1, -1, 17733), -- Recipe: Stockings of Zubei (100%)
(20668, 2917, 1, 1, -1, 99106), -- Ring of Seal Gemstone
(20668, 1806, 1, 1, -1, 3451), -- Recipe: Soulshot (B-Grade)
(20668, 57, 682, 1388, 0, 700000), -- Adena
(20668, 203, 1, 1, 1, 3.463976), -- Pa'agrian Axe
(20668, 2112, 1, 1, 1, 308.507784), -- Pa'agrian Axe Blade
(20668, 204, 1, 1, 1, 2.703032), -- Deadman's Staff
(20668, 2116, 1, 1, 1, 299.73248), -- Deadman's Staff Head
(20668, 205, 1, 1, 1, 2.703032), -- Ghoul's Staff
(20668, 2117, 1, 1, 1, 299.73248), -- Ghoul's Staff Head
(20668, 206, 1, 1, 1, 2.703032), -- Demon's Staff
(20668, 2118, 1, 1, 1, 299.73248), -- Demon's Staff Head
(20668, 2503, 1, 1, 1, 2.703032), -- Yaksa Mace
(20668, 2969, 1, 1, 1, 306.018672), -- Yaksa Mace Head
(20668, 1866, 1, 1, 2, 35393.71655), -- Suede
(20668, 1871, 1, 1, 2, 53090.574825), -- Charcoal
(20668, 5220, 1, 1, 2, 2123.64266), -- Metal Hardener
(20668, 1885, 1, 1, 2, 4424.189985), -- High-Grade Suede
(20668, 4041, 1, 1, 2, 461.682825), -- Mold Hardener
(20668, 4148, 1, 1, 2, 232.85728), -- Recipe: Avadon Robe (100%)
(20668, 4936, 1, 1, 2, 974.10651), -- Recipe: Avadon Shield (60%)
(20668, 8309, 1, 1, 2, 61.16437), -- Recipe: Spell Breaker (100%)
(20668, 8726, 1, 1, 2, 1228.99083), -- Life Stone - Level 55
(20668, 8736, 1, 1, 2, 307.19854), -- Mid-Grade Life Stone - Level 55
(20668, 8746, 1, 1, 2, 30.68052), -- High-Grade Life Stone - Level 55
(20668, 8756, 1, 1, 2, 6.195105), -- Top-Grade Life Stone - Level 55
-- Taik Orc Supply Leader
(20669, 4057, 1, 1, -1, 60231), -- Zubei's Gaiter Material
(20669, 4198, 1, 1, -1, 1644), -- Recipe: Bellion Cestus (100%)
(20669, 4589, 1, 1, -1, 7177), -- Greater Dye of STR (Str+2 Con-2)
(20669, 57, 851, 1734, 0, 700000), -- Adena
(20669, 286, 1, 1, 1, 16.868835), -- Eminence Bow
(20669, 2121, 1, 1, 1, 1828.131165), -- Eminence Bow Shaft
(20669, 1871, 1, 1, 2, 56789.027286), -- Charcoal
(20669, 1866, 1, 1, 2, 37859.351524), -- Suede
(20669, 1877, 1, 1, 2, 2271.615714), -- Adamantite Nugget
(20669, 4041, 1, 1, 2, 493.765183), -- Mold Hardener
(20669, 4040, 1, 1, 2, 1135.807857), -- Mold Lubricant
(20669, 4191, 1, 1, 2, 65.433275), -- Recipe: Great Axe (100%)
(20669, 4186, 1, 1, 2, 65.433275), -- Recipe: Sword of Valhalla (100%)
(20669, 5160, 1, 1, 2, 113.569406), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20669, 5275, 1, 1, 2, 113.569406), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20669, 6669, 1, 1, 2, 13206.710835), -- Deluxe Chest Key - Grade 5
(20669, 8726, 1, 1, 2, 1314.582944), -- Life Stone - Level 55
(20669, 8736, 1, 1, 2, 328.645736), -- Mid-Grade Life Stone - Level 55
(20669, 8746, 1, 1, 2, 32.887333), -- High-Grade Life Stone - Level 55
(20669, 8756, 1, 1, 2, 6.600226), -- Top-Grade Life Stone - Level 55
-- Crimson Drake
(20670, 4065, 1, 1, -1, 62421), -- Avadon Gaiters Material
(20670, 948, 1, 1, -1, 5579), -- Scroll: Enchant Armor (B-Grade)
(20670, 4129, 1, 1, -1, 24151), -- Recipe: Earrings of Black Ore (100%)
(20670, 57, 884, 1793, 0, 700000), -- Adena
(20670, 12159, 1, 1, 1, 752.464554), -- Common Item - Zubei's Shield
(20670, 4101, 1, 1, 1, 4776.48483), -- Zubei's Shield Fragment
(20670, 12171, 1, 1, 1, 752.464554), -- Common Item - Avadon Shield
(20670, 4439, 1, 1, 1, 5682.370236), -- Avadon Shield Fragment
(20670, 12160, 1, 1, 1, 526.47813), -- Common Item - Zubei's Helmet
(20670, 4102, 1, 1, 1, 3700.619574), -- Zubei's Helmet Design
(20670, 12170, 1, 1, 1, 526.47813), -- Common Item - Avadon Circlet
(20670, 4072, 1, 1, 1, 3700.639992), -- Avadon Circlet Pattern
(20670, 1869, 1, 1, 2, 54930.624519), -- Iron Ore
(20670, 1864, 1, 1, 2, 109861.249038), -- Stem
(20670, 1880, 1, 1, 2, 5493.009909), -- Steel
(20670, 5550, 1, 1, 2, 732.448026), -- Durable Metal Plate
(20670, 4043, 1, 1, 2, 1830.944922), -- Asofe
(20670, 4616, 1, 1, 2, 75.836919), -- Greater Dye of CON (Con+4 Dex-4)
(20670, 4168, 1, 1, 2, 683.232843), -- Recipe: Sealed Doom Gloves (100%)
(20670, 4164, 1, 1, 2, 363.772011), -- Recipe: Stockings of Doom (100%)
(20670, 8728, 1, 1, 2, 915.472461), -- Life Stone - Level 61
(20670, 8738, 1, 1, 2, 228.911901), -- Mid-Grade Life Stone - Level 61
(20670, 8748, 1, 1, 2, 22.943733), -- High-Grade Life Stone - Level 61
(20670, 8758, 1, 1, 2, 4.553718), -- Top-Grade Life Stone - Level 61
-- Kadios
(20671, 2098, 1, 1, -1, 12502), -- Nirvana Axe Blade
(20671, 947, 1, 1, -1, 934), -- Scroll: Enchant Weapon (B-Grade)
(20671, 4052, 1, 1, -1, 82640), -- Earring of Black Ore Piece
(20671, 57, 926, 1875, 0, 700000), -- Adena
(20671, 358, 1, 1, 1, 9.28572), -- Blue Wolf Breastplate
(20671, 4078, 1, 1, 1, 1678.628115), -- Blue Wolf Breastplate Part
(20671, 2381, 1, 1, 1, 5.71509), -- Doom Plate Armor
(20671, 4081, 1, 1, 1, 1132.654845), -- Doom Plate Armor Temper
(20671, 2380, 1, 1, 1, 14.85507), -- Blue Wolf Gaiters
(20671, 4080, 1, 1, 1, 2363.86116), -- Blue Wolf Gaiters Material
(20671, 1869, 1, 1, 2, 57456.624701), -- Iron Ore
(20671, 1864, 1, 1, 2, 114913.249402), -- Stem
(20671, 1880, 1, 1, 2, 5745.607511), -- Steel
(20671, 5550, 1, 1, 2, 766.129854), -- Durable Metal Plate
(20671, 4043, 1, 1, 2, 1915.141438), -- Asofe
(20671, 4616, 1, 1, 2, 79.324301), -- Greater Dye of CON (Con+4 Dex-4)
(20671, 4168, 1, 1, 2, 714.651497), -- Recipe: Sealed Doom Gloves (100%)
(20671, 4164, 1, 1, 2, 380.500169), -- Recipe: Stockings of Doom (100%)
(20671, 8728, 1, 1, 2, 957.570719), -- Life Stone - Level 61
(20671, 8738, 1, 1, 2, 239.438479), -- Mid-Grade Life Stone - Level 61
(20671, 8748, 1, 1, 2, 23.998807), -- High-Grade Life Stone - Level 61
(20671, 8758, 1, 1, 2, 4.763122), -- Top-Grade Life Stone - Level 61
-- Trives
(20672, 4070, 1, 1, -1, 84802), -- Stockings of Zubei Fabric
(20672, 4154, 1, 1, -1, 28035), -- Recipe: Doom Shield (100%)
(20672, 4052, 1, 1, -1, 83872), -- Earring of Black Ore Piece
(20672, 57, 940, 1902, 0, 700000), -- Adena
(20672, 601, 1, 1, 1, 28.27034), -- Sealed Doom Boots
(20672, 4099, 1, 1, 1, 3926.72966), -- Sealed Doom Boots Part
(20672, 2439, 1, 1, 1, 28.27034), -- Sealed Blue Wolf Boots
(20672, 4090, 1, 1, 1, 3926.72966), -- Sealed Blue Wolf Boots Design
(20672, 2475, 1, 1, 1, 28.27034), -- Sealed Doom Gloves
(20672, 4091, 1, 1, 1, 3926.72966), -- Sealed Doom Gloves Part
(20672, 2487, 1, 1, 1, 28.27034), -- Sealed Blue Wolf Gloves
(20672, 4096, 1, 1, 1, 3926.72966), -- Sealed Blue Wolf Gloves Fabric
(20672, 1868, 1, 1, 2, 127227.524824), -- Thread
(20672, 1873, 1, 1, 2, 25445.438128), -- Silver Nugget
(20672, 5549, 1, 1, 2, 6361.359532), -- Metallic Thread
(20672, 1889, 1, 1, 2, 4240.962052), -- Compound Braid
(20672, 4044, 1, 1, 2, 2120.39748), -- Thons
(20672, 4991, 1, 1, 2, 525.671432), -- Recipe: Doom Helmet (60%)
(20672, 5276, 1, 1, 2, 84.882736), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20672, 8729, 1, 1, 2, 848.158992), -- Life Stone - Level 64
(20672, 8739, 1, 1, 2, 212.039748), -- Mid-Grade Life Stone - Level 64
(20672, 8749, 1, 1, 2, 21.220684), -- High-Grade Life Stone - Level 64
(20672, 8759, 1, 1, 2, 4.344392), -- Top-Grade Life Stone - Level 64
-- Falibati
(20673, 4052, 1, 1, -1, 87623), -- Earring of Black Ore Piece
(20673, 4041, 1, 1, -1, 21521), -- Mold Hardener
(20673, 5230, 1, 1, -1, 3300), -- Recipe: Mithril Arrow (100%)
(20673, 57, 983, 1987, 0, 700000), -- Adena
(20673, 79, 1, 1, 1, 2.415321), -- Sword of Damascus
(20673, 4114, 1, 1, 1, 533.549712), -- Sword of Damascus Blade
(20673, 7883, 1, 1, 1, 2.415321), -- Guardian Sword
(20673, 8330, 1, 1, 1, 532.653006), -- Guardian Sword Blade
(20673, 7889, 1, 1, 1, 2.415321), -- Wizard's Tear
(20673, 8336, 1, 1, 1, 533.551319), -- Blade of the Wizard's Tear
(20673, 1872, 1, 1, 2, 88612.199847), -- Animal Bone
(20673, 1867, 1, 1, 2, 88612.199847), -- Animal Skin
(20673, 1881, 1, 1, 2, 8861.187342), -- Coarse Bone Powder
(20673, 1875, 1, 1, 2, 4430.593671), -- Stone of Purity
(20673, 4041, 1, 1, 2, 577.77579), -- Mold Hardener
(20673, 4150, 1, 1, 2, 1280.573121), -- Recipe: Sealed Avadon Gloves (100%)
(20673, 6037, 1, 1, 2, 132918.136557), -- Waking Scroll
(20673, 8729, 1, 1, 2, 886.249305), -- Life Stone - Level 64
(20673, 8739, 1, 1, 2, 221.643933), -- Mid-Grade Life Stone - Level 64
(20673, 8749, 1, 1, 2, 22.197036), -- High-Grade Life Stone - Level 64
(20673, 8759, 1, 1, 2, 4.243551), -- Top-Grade Life Stone - Level 64
-- Doom Knight
(20674, 2089, 1, 1, -1, 19453), -- Caliburs Edge
(20674, 4124, 1, 1, -1, 158653), -- Recipe: Craftsman Mold (100%)
(20674, 4053, 1, 1, -1, 153008), -- Ring of Black Ore Gemstone
(20674, 57, 1415, 2868, 0, 700000), -- Adena
(20674, 601, 1, 1, 1, 42.600293), -- Sealed Doom Boots
(20674, 4099, 1, 1, 1, 5917.149707), -- Sealed Doom Boots Part
(20674, 2439, 1, 1, 1, 42.600293), -- Sealed Blue Wolf Boots
(20674, 4090, 1, 1, 1, 5917.149707), -- Sealed Blue Wolf Boots Design
(20674, 2475, 1, 1, 1, 42.600293), -- Sealed Doom Gloves
(20674, 4091, 1, 1, 1, 5917.149707), -- Sealed Doom Gloves Part
(20674, 2487, 1, 1, 1, 42.600293), -- Sealed Blue Wolf Gloves
(20674, 4096, 1, 1, 1, 5917.149707), -- Sealed Blue Wolf Gloves Fabric
(20674, 1872, 1, 1, 2, 117158.902704), -- Animal Bone
(20674, 1867, 1, 1, 2, 117158.902704), -- Animal Skin
(20674, 1881, 1, 1, 2, 11715.839322), -- Coarse Bone Powder
(20674, 1875, 1, 1, 2, 5858.047032), -- Stone of Purity
(20674, 4041, 1, 1, 2, 763.971258), -- Mold Hardener
(20674, 4157, 1, 1, 2, 437.137272), -- Recipe: Blue Wolf Gaiters (100%)
(20674, 5276, 1, 1, 2, 117.18132), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20674, 8316, 1, 1, 2, 32.606976), -- Recipe: Flaming Dragon Skull (60%)
(20674, 8729, 1, 1, 2, 1171.558458), -- Life Stone - Level 64
(20674, 8739, 1, 1, 2, 292.9533), -- Mid-Grade Life Stone - Level 64
(20674, 8749, 1, 1, 2, 29.29533), -- High-Grade Life Stone - Level 64
(20674, 8759, 1, 1, 2, 5.604324), -- Top-Grade Life Stone - Level 64
-- Tairim
(20675, 4042, 1, 1, -1, 25482), -- Enria
(20675, 1539, 1, 1, -1, 339759), -- Greater Healing Potion
(20675, 4602, 1, 1, -1, 3398), -- Greater Dye of STR (Str+3 Dex-3)
(20675, 57, 605, 1229, 0, 700000), -- Adena
(20675, 60, 1, 1, 1, 51.530472), -- Composite Armor
(20675, 1977, 1, 1, 1, 4676.469528), -- Composite Armor Temper
(20675, 1872, 1, 1, 2, 70251.79075), -- Animal Bone
(20675, 1867, 1, 1, 2, 70251.79075), -- Animal Skin
(20675, 1881, 1, 1, 2, 7025.117625), -- Coarse Bone Powder
(20675, 1875, 1, 1, 2, 3512.635625), -- Stone of Purity
(20675, 4041, 1, 1, 2, 458.10975), -- Mold Hardener
(20675, 2353, 1, 1, 2, 85.876375), -- Recipe: Samurai Longsword
(20675, 4184, 1, 1, 2, 60.681875), -- Recipe: Sprite's Staff (100%)
(20675, 5155, 1, 1, 2, 105.38675), -- Recipe: Soulshot (B) Compressed Package (100%)
(20675, 8725, 1, 1, 2, 1463.585375), -- Life Stone - Level 52
(20675, 8735, 1, 1, 2, 365.93475), -- Mid-Grade Life Stone - Level 52
(20675, 8745, 1, 1, 2, 36.56275), -- High-Grade Life Stone - Level 52
(20675, 8755, 1, 1, 2, 7.527625), -- Top-Grade Life Stone - Level 52
-- Judge of Marsh
(20676, 5478, 1, 1, -1, 21536), -- Sealed Dark Crystal Leather Armor Pattern
(20676, 1807, 1, 1, -1, 3415), -- Recipe: Soulshot (A-Grade)
(20676, 5479, 1, 1, -1, 15155), -- Sealed Tallum Leather Armor Pattern
(20676, 57, 1015, 2058, 0, 700000), -- Adena
(20676, 12341, 1, 1, 1, 585.074805), -- Common Item - Earring of Black Ore
(20676, 4052, 1, 1, 1, 4463.954738), -- Earring of Black Ore Piece
(20676, 12342, 1, 1, 1, 438.560274), -- Common Item - Necklace of Black Ore
(20676, 4054, 1, 1, 1, 2483.436264), -- Necklace of Black Ore Beads
(20676, 12343, 1, 1, 1, 875.58144), -- Common Item - Ring of Black Ore
(20676, 4053, 1, 1, 1, 5404.392479), -- Ring of Black Ore Gemstone
(20676, 1867, 1, 1, 2, 100868.629675), -- Animal Skin
(20676, 1872, 1, 1, 2, 100868.629675), -- Animal Bone
(20676, 1882, 1, 1, 2, 16811.475992), -- Leather
(20676, 1894, 1, 1, 2, 2654.455487), -- Crafted Leather
(20676, 4042, 1, 1, 2, 1260.815444), -- Enria
(20676, 8729, 1, 1, 2, 1008.742866), -- Life Stone - Level 64
(20676, 8739, 1, 1, 2, 252.072578), -- Mid-Grade Life Stone - Level 64
(20676, 8749, 1, 1, 2, 25.116747), -- High-Grade Life Stone - Level 64
(20676, 8759, 1, 1, 2, 4.978094), -- Top-Grade Life Stone - Level 64
(20676, 6036, 1, 1, 2, 2522.083442), -- Greater Magic Haste Potion
-- Tulben
(20677, 3035, 1, 1, -1, 3845), -- Recipe: Spiritshot A
(20677, 5482, 1, 1, -1, 38058), -- Sealed Dark Crystal Leggings Design
(20677, 5230, 1, 1, -1, 3845), -- Recipe: Mithril Arrow (100%)
(20677, 57, 1142, 2317, 0, 700000), -- Adena
(20677, 11944, 1, 1, 1, 139.117392), -- Common Item - Bow of Peril
(20677, 4121, 1, 1, 1, 1854.882608), -- Bow of Peril Shaft
(20677, 1869, 1, 1, 2, 85174.1275), -- Iron Ore
(20677, 1864, 1, 1, 2, 170348.5245), -- Stem
(20677, 1880, 1, 1, 2, 8517.5475), -- Steel
(20677, 5550, 1, 1, 2, 1135.673), -- Durable Metal Plate
(20677, 4043, 1, 1, 2, 2839.1825), -- Asofe
(20677, 8316, 1, 1, 2, 31.5315), -- Recipe: Flaming Dragon Skull (60%)
(20677, 8729, 1, 1, 2, 1135.673), -- Life Stone - Level 64
(20677, 8739, 1, 1, 2, 283.7835), -- Mid-Grade Life Stone - Level 64
(20677, 8749, 1, 1, 2, 28.2975), -- High-Grade Life Stone - Level 64
(20677, 8759, 1, 1, 2, 5.6595), -- Top-Grade Life Stone - Level 64
-- Tortured Undead
(20678, 1989, 1, 1, -1, 49499), -- Divine Stocking Pattern
(20678, 4142, 1, 1, -1, 12634), -- Recipe: Avadon Gaiters (100%)
(20678, 1918, 1, 1, -1, 71130), -- Nassen's Earring Gemstone
(20678, 57, 650, 1321, 0, 700000), -- Adena
(20678, 266, 1, 1, 1, 12.862564), -- Great Pata
(20678, 2120, 1, 1, 1, 1456.137436), -- Great Pata Blade
(20678, 1895, 1, 1, 2, 15750.9734), -- Metallic Fiber
(20678, 4040, 1, 1, 2, 1102.5614), -- Mold Lubricant
(20678, 4042, 1, 1, 2, 918.81614), -- Enria
(20678, 4043, 1, 1, 2, 1837.60982), -- Asofe
(20678, 4128, 1, 1, 2, 682.28988), -- Recipe: Adamantite Necklace (100%)
(20678, 5280, 1, 1, 2, 110.25614), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20678, 4134, 1, 1, 2, 424.06726), -- Recipe: Zubei's Gaiters (100%)
(20678, 8726, 1, 1, 2, 1276.10982), -- Life Stone - Level 55
(20678, 8736, 1, 1, 2, 319.02184), -- Mid-Grade Life Stone - Level 55
(20678, 8746, 1, 1, 2, 31.8932), -- High-Grade Life Stone - Level 55
(20678, 8756, 1, 1, 2, 6.4011), -- Top-Grade Life Stone - Level 55
-- Marsh Stalker
(20679, 4148, 1, 1, -1, 7419), -- Recipe: Avadon Robe (100%)
(20679, 1806, 1, 1, -1, 3383), -- Recipe: Soulshot (B-Grade)
(20679, 1920, 1, 1, -1, 57882), -- Necklace of Seal Chain
(20679, 57, 668, 1361, 0, 700000), -- Adena
(20679, 203, 1, 1, 1, 3.395966), -- Pa'agrian Axe
(20679, 2112, 1, 1, 1, 302.450694), -- Pa'agrian Axe Blade
(20679, 204, 1, 1, 1, 2.649962), -- Deadman's Staff
(20679, 2116, 1, 1, 1, 293.84768), -- Deadman's Staff Head
(20679, 205, 1, 1, 1, 2.649962), -- Ghoul's Staff
(20679, 2117, 1, 1, 1, 293.84768), -- Ghoul's Staff Head
(20679, 206, 1, 1, 1, 2.649962), -- Demon's Staff
(20679, 2118, 1, 1, 1, 293.84768), -- Demon's Staff Head
(20679, 2503, 1, 1, 1, 2.649962), -- Yaksa Mace
(20679, 2969, 1, 1, 1, 300.010452), -- Yaksa Mace Head
(20679, 1869, 1, 1, 2, 48045.55767), -- Iron Ore
(20679, 1870, 1, 1, 2, 48045.55767), -- Coal
(20679, 1871, 1, 1, 2, 48045.55767), -- Charcoal
(20679, 1872, 1, 1, 2, 64060.651974), -- Animal Bone
(20679, 1867, 1, 1, 2, 64060.651974), -- Animal Skin
(20679, 4149, 1, 1, 2, 617.655984), -- Recipe: Avadon Circlet (100%)
(20679, 4186, 1, 1, 2, 55.226358), -- Recipe: Sword of Valhalla (100%)
(20679, 5160, 1, 1, 2, 96.1653), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20679, 4143, 1, 1, 2, 308.003718), -- Recipe: Zubei's Leather Shirt (100%)
(20679, 8726, 1, 1, 2, 1112.220384), -- Life Stone - Level 55
(20679, 8736, 1, 1, 2, 278.055096), -- Mid-Grade Life Stone - Level 55
(20679, 8746, 1, 1, 2, 27.750558), -- High-Grade Life Stone - Level 55
(20679, 8756, 1, 1, 2, 4.945644), -- Top-Grade Life Stone - Level 55
-- Marsh Drake
(20680, 1873, 1, 1, -1, 716613), -- Silver Nugget
(20680, 1876, 1, 1, -1, 358306), -- Mithril Ore
(20680, 3034, 1, 1, -1, 3583), -- Recipe: Spiritshot B
(20680, 57, 708, 1442, 0, 700000), -- Adena
(20680, 301, 1, 1, 1, 5.996288), -- Scorpion
(20680, 2113, 1, 1, 1, 534.0047), -- Scorpion Blade
(20680, 303, 1, 1, 1, 5.996288), -- Widow Maker
(20680, 2114, 1, 1, 1, 534.0047), -- Widowmaker Head
(20680, 299, 1, 1, 1, 4.678248), -- Orcish Poleaxe
(20680, 2122, 1, 1, 1, 503.319776), -- Orcish Poleaxe Blade
(20680, 1874, 1, 1, 2, 3674.942988), -- Oriharukon Ore
(20680, 1878, 1, 1, 2, 22049.589604), -- Braided Hemp
(20680, 1884, 1, 1, 2, 33922.456056), -- Cord
(20680, 1889, 1, 1, 2, 3674.942988), -- Compound Braid
(20680, 5220, 1, 1, 2, 2204.952128), -- Metal Hardener
(20680, 4441, 1, 1, 2, 1011.468496), -- Recipe: Avadon Shield
(20680, 5280, 1, 1, 2, 110.274936), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20680, 8311, 1, 1, 2, 42.087584), -- Recipe: Kaim Vanul's Bones (100%)
(20680, 8726, 1, 1, 2, 1276.019024), -- Life Stone - Level 55
(20680, 8736, 1, 1, 2, 319.004756), -- Mid-Grade Life Stone - Level 55
(20680, 8746, 1, 1, 2, 31.907308), -- High-Grade Life Stone - Level 55
(20680, 8756, 1, 1, 2, 6.354132), -- Top-Grade Life Stone - Level 55
-- Vanor Silenos
(20681, 1873, 1, 1, -1, 494213), -- Silver Nugget
(20681, 2063, 1, 1, -1, 9550), -- Battle Axe Head
(20681, 1908, 1, 1, -1, 117001), -- Moonstone Earring Wire
(20681, 57, 489, 993, 0, 700000), -- Adena
(20681, 71, 1, 1, 1, 16.565175), -- Flamberge
(20681, 2059, 1, 1, 1, 1084.539654), -- Flamberge Blade
(20681, 72, 1, 1, 1, 16.565175), -- Stormbringer
(20681, 2060, 1, 1, 1, 1159.329996), -- Stormbringer Blade
(20681, 1866, 1, 1, 2, 32440.80671), -- Suede
(20681, 1871, 1, 1, 2, 48661.11865), -- Charcoal
(20681, 5220, 1, 1, 2, 1946.40818), -- Metal Hardener
(20681, 1885, 1, 1, 2, 4055.077985), -- High-Grade Suede
(20681, 4041, 1, 1, 2, 423.160035), -- Mold Hardener
(20681, 4440, 1, 1, 2, 169.574825), -- Recipe: Knuckle Duster
(20681, 2225, 1, 1, 2, 1057.85438), -- Recipe: Demon's Stockings
(20681, 2321, 1, 1, 2, 169.574825), -- Recipe: Stiletto
(20681, 8723, 1, 1, 2, 1946.40818), -- Life Stone - Level 46
(20681, 8733, 1, 1, 2, 486.602045), -- Mid-Grade Life Stone - Level 46
(20681, 8743, 1, 1, 2, 48.63278), -- High-Grade Life Stone - Level 46
(20681, 8753, 1, 1, 2, 9.781405), -- Top-Grade Life Stone - Level 46
-- Vanor Silenos Grunt
(20682, 951, 1, 1, -1, 2236), -- Scroll: Enchant Weapon (C-Grade)
(20682, 1876, 1, 1, -1, 245912), -- Mithril Ore
(20682, 4039, 1, 1, -1, 40985), -- Mold Glue
(20682, 57, 484, 990, 0, 700000), -- Adena
(20682, 397, 1, 1, 1, 99.843328), -- Mithril Shirt
(20682, 1961, 1, 1, 1, 4648.992856), -- Mithril Shirt Fabric
(20682, 2387, 1, 1, 1, 159.567424), -- Reinforced Mithril Gaiters
(20682, 2935, 1, 1, 1, 7723.596392), -- Reinforced Mithril Gaiters Fragment
(20682, 1870, 1, 1, 2, 58110.629145), -- Coal
(20682, 1865, 1, 1, 2, 58110.629145), -- Varnish
(20682, 1874, 1, 1, 2, 3874.041943), -- Oriharukon Ore
(20682, 4043, 1, 1, 2, 1936.957398), -- Asofe
(20682, 4039, 1, 1, 2, 1936.957398), -- Mold Glue
(20682, 2323, 1, 1, 2, 202.418024), -- Recipe: Elemental Bow
(20682, 8723, 1, 1, 2, 2324.374307), -- Life Stone - Level 46
(20682, 8733, 1, 1, 2, 581.06179), -- Mid-Grade Life Stone - Level 46
(20682, 8743, 1, 1, 2, 58.106179), -- High-Grade Life Stone - Level 46
(20682, 8753, 1, 1, 2, 11.824671), -- Top-Grade Life Stone - Level 46
-- Vanor Silenos Scout
(20683, 2336, 1, 1, -1, 3717), -- Recipe: Nirvana Axe
(20683, 1974, 1, 1, -1, 134435), -- Crimson Boot Fabric
(20683, 1889, 1, 1, -1, 106562), -- Compound Braid
(20683, 57, 631, 1287, 0, 700000), -- Adena
(20683, 227, 1, 1, 1, 16.024815), -- Stiletto
(20683, 2083, 1, 1, 1, 1176.475185), -- Stiletto Edge
(20683, 242, 1, 1, 1, 16.024815), -- Soulfire Dirk
(20683, 2084, 1, 1, 1, 1176.475185), -- Soulfire Dirk Blade
(20683, 1868, 1, 1, 2, 118037.87411), -- Thread
(20683, 1873, 1, 1, 2, 23607.574822), -- Silver Nugget
(20683, 5549, 1, 1, 2, 5901.933786), -- Metallic Thread
(20683, 1889, 1, 1, 2, 3934.622524), -- Compound Braid
(20683, 4044, 1, 1, 2, 1967.311262), -- Thons
(20683, 2224, 1, 1, 2, 801.930644), -- Recipe: Demon's Tunic
(20683, 2230, 1, 1, 2, 1143.737148), -- Recipe: Theca Leather Gaiters
(20683, 3005, 1, 1, 2, 2408.998372), -- Recipe: Demon's Boots
(20683, 8724, 1, 1, 2, 1967.311262), -- Life Stone - Level 49
(20683, 8734, 1, 1, 2, 491.867896), -- Mid-Grade Life Stone - Level 49
(20683, 8744, 1, 1, 2, 49.218854), -- High-Grade Life Stone - Level 49
(20683, 8754, 1, 1, 2, 9.61932), -- Top-Grade Life Stone - Level 49
-- Vanor Silenos Warrior
(20684, 1876, 1, 1, -1, 334736), -- Mithril Ore
(20684, 2078, 1, 1, -1, 11121), -- Katana Blade
(20684, 1966, 1, 1, -1, 61106), -- Plated Leather Fragment
(20684, 57, 662, 1345, 0, 700000), -- Adena
(20684, 398, 1, 1, 1, 54.051228), -- Plated Leather
(20684, 1966, 1, 1, 1, 3384.201645), -- Plated Leather Fragment
(20684, 399, 1, 1, 1, 49.842606), -- Rind Leather Armor
(20684, 1975, 1, 1, 1, 3044.607588), -- Rind Leather Armor Design
(20684, 418, 1, 1, 1, 86.43327), -- Plated Leather Gaiters
(20684, 1967, 1, 1, 1, 5055.528918), -- Plated Leather Gaiters Material
(20684, 419, 1, 1, 1, 79.807299), -- Rind Leather Gaiters
(20684, 1976, 1, 1, 1, 5636.527446), -- Rind Leather Gaiters Material
(20684, 1871, 1, 1, 2, 61797.572675), -- Charcoal
(20684, 1866, 1, 1, 2, 41198.333175), -- Suede
(20684, 1877, 1, 1, 2, 2471.879575), -- Adamantite Nugget
(20684, 4041, 1, 1, 2, 537.365125), -- Mold Hardener
(20684, 4040, 1, 1, 2, 1236.0127), -- Mold Lubricant
(20684, 2341, 1, 1, 2, 143.78345), -- Recipe: Sage's Staff
(20684, 6668, 1, 1, 2, 22070.61375), -- Deluxe Chest Key - Grade 4
(20684, 8724, 1, 1, 2, 2059.92395), -- Life Stone - Level 49
(20684, 8734, 1, 1, 2, 514.908075), -- Mid-Grade Life Stone - Level 49
(20684, 8744, 1, 1, 2, 51.476225), -- High-Grade Life Stone - Level 49
(20684, 8754, 1, 1, 2, 10.353575), -- Top-Grade Life Stone - Level 49
(20684, 1539, 1, 1, 2, 13732.777725), -- Greater Healing Potion
-- Vanor Silenos Shaman
(20685, 2090, 1, 1, -1, 7611), -- Delusional Blade
(20685, 1970, 1, 1, -1, 31188), -- Robe of Seal Fabric
(20685, 2166, 1, 1, -1, 47343), -- Recipe: Earrings of Binding (100%)
(20685, 57, 551, 1124, 0, 700000), -- Adena
(20685, 195, 1, 1, 1, 14.001112), -- Cursed Staff
(20685, 2082, 1, 1, 1, 1090.279304), -- Cursed Staff Head
(20685, 2502, 1, 1, 1, 14.001112), -- Dwarven War Hammer
(20685, 2968, 1, 1, 1, 1043.718472), -- Dwarven War Hammer Head
(20685, 1872, 1, 1, 2, 75007.060317), -- Animal Bone
(20685, 1867, 1, 1, 2, 75007.060317), -- Animal Skin
(20685, 1881, 1, 1, 2, 7500.722472), -- Coarse Bone Powder
(20685, 1875, 1, 1, 2, 3750.361236), -- Stone of Purity
(20685, 4041, 1, 1, 2, 489.098925), -- Mold Hardener
(20685, 2351, 1, 1, 2, 117.712548), -- Recipe: Scorpion
(20685, 2330, 1, 1, 2, 130.864788), -- Recipe: Homunkulus's Sword
(20685, 8724, 1, 1, 2, 1875.180618), -- Life Stone - Level 49
(20685, 8734, 1, 1, 2, 468.712953), -- Mid-Grade Life Stone - Level 49
(20685, 8744, 1, 1, 2, 46.854855), -- High-Grade Life Stone - Level 49
(20685, 8754, 1, 1, 2, 9.370971), -- Top-Grade Life Stone - Level 49
-- Vanor Silenos Chieftain
(20686, 2231, 1, 1, -1, 12559), -- Recipe: Full Plate Armor
(20686, 1880, 1, 1, -1, 291368), -- Steel
(20686, 2169, 1, 1, -1, 51570), -- Recipe: Necklace of Seal
(20686, 57, 1152, 2343, 0, 700000), -- Adena
(20686, 326, 1, 1, 1, 36.468759), -- Heathen's Book
(20686, 2110, 1, 1, 1, 3396.531241), -- Heathen's Book Page
(20686, 1871, 1, 1, 2, 100409.59008), -- Charcoal
(20686, 1866, 1, 1, 2, 66939.72672), -- Suede
(20686, 1877, 1, 1, 2, 4016.312256), -- Adamantite Nugget
(20686, 4041, 1, 1, 2, 873.11136), -- Mold Hardener
(20686, 4040, 1, 1, 2, 2008.245312), -- Mold Lubricant
(20686, 2354, 1, 1, 2, 163.741824), -- Recipe: Deadman's Staff
(20686, 4609, 1, 1, 2, 223.138368), -- Greater Dye of MEN (Men+3 Int-3)
(20686, 2358, 1, 1, 2, 163.741824), -- Recipe: Great Pata
(20686, 8725, 1, 1, 2, 2789.140416), -- Life Stone - Level 52
(20686, 8735, 1, 1, 2, 697.240512), -- Mid-Grade Life Stone - Level 52
(20686, 8745, 1, 1, 2, 69.741888), -- High-Grade Life Stone - Level 52
(20686, 8755, 1, 1, 2, 14.26944), -- Top-Grade Life Stone - Level 52
-- Gigantiops
(20745, 848, 1, 1, -1, 6478), -- Enchanted Earring
(20745, 1832, 1, 3, -1, 590229), -- Greater Antidote
(20745, 1901, 1, 1, -1, 146742), -- Tiger's Eye Earring Stone
(20745, 57, 449, 895, 0, 700000), -- Adena
(20745, 393, 1, 1, 1, 160.930318), -- Mithril Banded Mail
(20745, 1938, 1, 1, 1, 6328.819738), -- Mithril Banded Mail Material
(20745, 394, 1, 1, 1, 160.930318), -- Reinforced Leather Shirt
(20745, 415, 1, 1, 1, 257.223044), -- Mithril Banded Gaiters
(20745, 1939, 1, 1, 1, 8268.888972), -- Mithril Banded Gaiters Material
(20745, 416, 1, 1, 1, 257.20761), -- Reinforced Leather Gaiters
(20745, 1867, 1, 1, 2, 150633.733232), -- Animal Skin
(20745, 1872, 1, 1, 2, 150633.733232), -- Animal Bone
(20745, 1882, 1, 1, 2, 25105.734278), -- Leather
(20745, 2156, 1, 1, 2, 9037.876058), -- Recipe: Elven Necklace
(20745, 2272, 1, 1, 2, 806.9232), -- Recipe: Sword of Revolution
-- Young Gigantiops
(20746, 2153, 1, 1, -1, 129445), -- Recipe: Tiger's Eye Earring
(20746, 1900, 1, 1, -1, 91065), -- Enchanted Necklace Chain
(20746, 1061, 1, 1, -1, 504445), -- Greater Healing Potion
(20746, 57, 352, 702, 0, 700000), -- Adena
(20746, 259, 1, 1, 1, 184), -- Single-Edged Jamadhr
(20746, 1865, 1, 1, 2, 75806.272725), -- Varnish
(20746, 1870, 1, 1, 2, 75806.272725), -- Coal
(20746, 1879, 1, 1, 2, 12634.46769), -- Cokes
(20746, 1875, 1, 1, 2, 5053.751515), -- Stone of Purity
(20746, 2184, 1, 1, 2, 7962.81912), -- Recipe: Mithril Banded Gaiters
(20746, 2272, 1, 1, 2, 541.416225), -- Recipe: Sword of Revolution
-- Roxide
(20747, 2024, 1, 1, -1, 16676), -- Elven Bow Shaft
(20747, 2203, 1, 1, -1, 255050), -- Recipe: Reinforced Mithril Boots
(20747, 1900, 1, 1, -1, 128083), -- Enchanted Necklace Chain
(20747, 57, 493, 989, 0, 700000), -- Adena
(20747, 627, 1, 1, 1, 2378.09442), -- Aspis
(20747, 46, 1, 1, 1, 1665.90558), -- Bronze Helmet
(20747, 1872, 1, 1, 2, 121853.866008), -- Animal Bone
(20747, 1867, 1, 1, 2, 121853.866008), -- Animal Skin
(20747, 1881, 1, 1, 2, 12185.467392), -- Coarse Bone Powder
(20747, 1875, 1, 1, 2, 6092.733696), -- Stone of Purity
(20747, 2183, 1, 1, 2, 6012.481104), -- Recipe: Mithril Banded Mail
(20747, 2274, 1, 1, 2, 652.792896), -- Recipe: Skull Breaker
(20747, 2282, 1, 1, 2, 652.792896), -- Recipe: Cursed Maingauche
-- Roxide Cohort
(20748, 1866, 1, 1, -1, 734952), -- Suede
(20748, 1871, 1, 3, -1, 551214), -- Charcoal
(20748, 1061, 1, 1, -1, 668138), -- Greater Healing Potion
(20748, 57, 467, 925, 0, 700000), -- Adena
(20748, 275, 1, 1, 1, 81.061745), -- Long Bow
(20748, 276, 1, 1, 1, 81.061745), -- Elven Bow
(20748, 2024, 1, 1, 1, 2860.87651), -- Elven Bow Shaft
(20748, 1866, 1, 1, 2, 57374.698598), -- Suede
(20748, 1871, 1, 1, 2, 86062.24418), -- Charcoal
(20748, 5220, 1, 1, 2, 3442.411254), -- Metal Hardener
(20748, 1885, 1, 1, 2, 7171.788254), -- High-Grade Suede
(20748, 956, 1, 1, 2, 2868.872328), -- Scroll: Enchant Armor (D-Grade)
(20748, 2190, 1, 1, 2, 6147.190994), -- Recipe: Mithril Stockings
(20748, 1831, 1, 1, 2, 229498.794392), -- Antidote
-- Death Fire
(20749, 2025, 1, 1, -1, 16214), -- Dwarven Trident Edge
(20749, 1871, 1, 3, -1, 585341), -- Charcoal
(20749, 2153, 1, 1, -1, 182066), -- Recipe: Tiger's Eye Earring
(20749, 57, 493, 989, 0, 700000), -- Adena
(20749, 627, 1, 1, 1, 2378.09442), -- Aspis
(20749, 46, 1, 1, 1, 1665.90558), -- Bronze Helmet
(20749, 1871, 1, 1, 2, 159932.96268), -- Charcoal
(20749, 1866, 1, 1, 2, 106622.071704), -- Suede
(20749, 1877, 1, 1, 2, 6397.434408), -- Adamantite Nugget
(20749, 2184, 1, 1, 2, 16799.531208), -- Recipe: Mithril Banded Gaiters
-- Fire Archer
(20750, 1933, 1, 1, -1, 134288), -- Dark Stockings Fabric
(20750, 2183, 1, 1, -1, 75095), -- Recipe: Mithril Banded Mail
(20750, 1935, 1, 1, -1, 63768), -- Scale Mail Fragment
(20750, 57, 484, 958, 0, 700000), -- Adena
(20750, 222, 1, 1, 1, 252), -- Poniard Dagger
(20750, 1867, 1, 3, 2, 55445.058376), -- Animal Skin
(20750, 1872, 1, 1, 2, 166334.709391), -- Animal Bone
(20750, 1882, 1, 1, 2, 27722.529188), -- Leather
(20750, 1829, 1, 1, 2, 49900.459391), -- Scroll of Escape: Clan Hall
(20750, 1831, 1, 3, 2, 166334.243654), -- Antidote
-- Snipe
(20751, 2161, 1, 1, -1, 423261), -- Recipe: Aquastone Ring
(20751, 1949, 1, 1, -1, 486561), -- Mithril Gloves Design
(20751, 1894, 1, 1, -1, 152968), -- Crafted Leather
(20751, 57, 1716, 3517, 0, 700000), -- Adena
(20751, 62, 1, 1, 1, 235.770525), -- Reinforced Mithril Boots
(20751, 1958, 1, 1, 1, 10289.21895), -- Reinforced Mithril Boots Design
(20751, 2429, 1, 1, 1, 235.770525), -- Chain Boots
(20751, 2937, 1, 1, 1, 10289.21895), -- Chain Boots Part
(20751, 2430, 1, 1, 1, 235.770525), -- Karmian Boots
(20751, 2938, 1, 1, 1, 10289.21895), -- Karmian Boots Fabric
(20751, 2431, 1, 1, 1, 235.770525), -- Plated Leather Boots
(20751, 2939, 1, 1, 1, 10289.21895), -- Plate Leather Boots Lining
(20751, 2432, 1, 1, 1, 235.770525), -- Dwarven Chain Boots
(20751, 2940, 1, 1, 1, 10289.21895), -- Dwarven Chain Boots Part
(20751, 2433, 1, 1, 1, 235.770525), -- Boots of Seal
(20751, 2941, 1, 1, 1, 10289.21895), -- Boots of Seal Pattern
(20751, 2452, 1, 1, 1, 235.770525), -- Reinforced Mithril Gloves
(20751, 2942, 1, 1, 1, 10289.21895), -- Reinforced Mithril Gloves Design
(20751, 2453, 1, 1, 1, 235.770525), -- Chain Gloves
(20751, 2943, 1, 1, 1, 10289.21895), -- Chain Gloves Design
(20751, 2454, 1, 1, 1, 235.770525), -- Karmian Gloves
(20751, 2944, 1, 1, 1, 10289.313675), -- Karmian Gloves Fabric
(20751, 1894, 1, 1, 2, 9036.767322), -- Crafted Leather
(20751, 2216, 1, 1, 2, 10642.50075), -- Recipe: Great Helmet
(20751, 2225, 1, 1, 2, 5598.890242), -- Recipe: Demon's Stockings
(20751, 2321, 1, 1, 2, 897.374876), -- Recipe: Stiletto
(20751, 8723, 1, 1, 2, 10301.940726), -- Life Stone - Level 46
(20751, 8733, 1, 1, 2, 2575.495022), -- Mid-Grade Life Stone - Level 46
(20751, 8743, 1, 1, 2, 257.545566), -- High-Grade Life Stone - Level 46
(20751, 8753, 1, 1, 2, 51.485496), -- Top-Grade Life Stone - Level 46
-- Snipe Cohort
(20752, 1805, 1, 1, -1, 7711), -- Recipe: Soulshot (C-Grade)
(20752, 1905, 1, 1, -1, 225036), -- Omen Beast's Eye Earring Gemstone
(20752, 5549, 1, 1, -1, 231337), -- Metallic Thread
(20752, 57, 932, 1883, 0, 700000), -- Adena
(20752, 353, 1, 1, 1, 193.097417), -- Half Plate Armor
(20752, 1950, 1, 1, 1, 9426.365273), -- Half Plate Temper
(20752, 380, 1, 1, 1, 308.960785), -- Plate Gaiters
(20752, 1951, 1, 1, 1, 14660.576525), -- Plate Gaiters Part
(20752, 1868, 1, 1, 2, 331904.637384), -- Thread
(20752, 1873, 1, 1, 2, 66380.839891), -- Silver Nugget
(20752, 5549, 1, 1, 2, 16595.319455), -- Metallic Thread
(20752, 1889, 1, 1, 2, 11063.400327), -- Compound Braid
(20752, 2160, 1, 1, 2, 10706.488192), -- Recipe: Moonstone Earring
(20752, 5159, 1, 1, 2, 553.104327), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20752, 2312, 1, 1, 2, 725.210424), -- Recipe: Crystallized Ice Bow
-- Dark Lord
(20753, 1874, 1, 1, -1, 250765), -- Oriharukon Ore
(20753, 1875, 1, 1, -1, 250765), -- Stone of Purity
(20753, 4601, 1, 1, -1, 8359), -- Greater Dye of STR (Str+3 Con-3)
(20753, 57, 1488, 3024, 0, 700000), -- Adena
(20753, 75, 1, 1, 1, 7.845835), -- Caliburs
(20753, 2089, 1, 1, 1, 706.32226), -- Caliburs Edge
(20753, 76, 1, 1, 1, 7.845835), -- Sword of Delusion
(20753, 2090, 1, 1, 1, 706.32226), -- Delusional Blade
(20753, 77, 1, 1, 1, 7.845835), -- Tsurugi
(20753, 2091, 1, 1, 1, 706.32226), -- Tsurugi Blade
(20753, 84, 1, 1, 1, 7.845835), -- Homunkulus's Sword
(20753, 2092, 1, 1, 1, 706.32226), -- Homunkulus's Sword Blade
(20753, 134, 1, 1, 1, 7.845835), -- Sword of Nightmare
(20753, 2095, 1, 1, 1, 706.32226), -- Sword of Nightmare Blade
(20753, 145, 1, 1, 1, 7.845835), -- Sword of Whispering Death
(20753, 2096, 1, 1, 1, 706.31369), -- Sword of Whispering Death Blade
(20753, 1868, 1, 3, 2, 119654.817944), -- Thread
(20753, 1873, 1, 1, 2, 47861.751712), -- Silver Nugget
(20753, 5549, 1, 1, 2, 11965.437928), -- Metallic Thread
(20753, 1889, 1, 1, 2, 7977.10484), -- Compound Braid
(20753, 4044, 1, 1, 2, 3988.333088), -- Thons
(20753, 2355, 1, 1, 2, 195.20548), -- Recipe: Ghoul's Staff
(20753, 4609, 1, 1, 2, 265.830384), -- Greater Dye of MEN (Men+3 Int-3)
(20753, 3019, 1, 1, 2, 3190.841936), -- Recipe: Full Plate Shield
(20753, 8725, 1, 1, 2, 3323.757128), -- Life Stone - Level 52
(20753, 8735, 1, 1, 2, 830.829616), -- Mid-Grade Life Stone - Level 52
(20753, 8745, 1, 1, 2, 82.907496), -- High-Grade Life Stone - Level 52
(20753, 8755, 1, 1, 2, 16.669232), -- Top-Grade Life Stone - Level 52
(20753, 1342, 10, 30, 2, 239310.513216), -- Steel Arrow
-- Dark Knight
(20754, 1869, 1, 9, -1, 826759), -- Iron Ore
(20754, 1911, 1, 1, -1, 307460), -- Earring of Protection Gemstone
(20754, 1967, 1, 1, -1, 225459), -- Plated Leather Gaiters Material
(20754, 57, 1634, 3323, 0, 700000), -- Adena
(20754, 94, 1, 1, 1, 82.894125), -- Bec de Corbin
(20754, 2079, 1, 1, 1, 6292.105875), -- Bec De Corbin Blade
(20754, 1869, 1, 1, 2, 166508.151876), -- Iron Ore
(20754, 1864, 1, 3, 2, 166508.151876), -- Stem
(20754, 1880, 1, 1, 2, 16650.739221), -- Steel
(20754, 5550, 1, 1, 2, 2220.123885), -- Durable Metal Plate
(20754, 4043, 1, 1, 2, 5550.119796), -- Asofe
(20754, 2167, 1, 1, 2, 8495.344878), -- Recipe: Ring of Ages
(20754, 3009, 1, 1, 2, 6796.351869), -- Recipe: Composite Boots
(20754, 8724, 1, 1, 2, 5550.119796), -- Life Stone - Level 49
(20754, 8734, 1, 1, 2, 1387.529949), -- Mid-Grade Life Stone - Level 49
(20754, 8744, 1, 1, 2, 138.639045), -- High-Grade Life Stone - Level 49
(20754, 8754, 1, 1, 2, 27.727809), -- Top-Grade Life Stone - Level 49
-- Talakin
(20755, 2184, 1, 1, -1, 83948), -- Recipe: Mithril Banded Gaiters
(20755, 1900, 1, 1, -1, 87438), -- Enchanted Necklace Chain
(20755, 1061, 1, 1, -1, 484352), -- Greater Healing Potion
(20755, 57, 337, 674, 0, 700000), -- Adena
(20755, 222, 1, 1, 1, 176), -- Poniard Dagger
(20755, 1876, 1, 1, 2, 10918.05411), -- Mithril Ore
(20755, 1880, 1, 1, 2, 5459.148138), -- Steel
(20755, 1877, 1, 1, 2, 2183.610822), -- Adamantite Nugget
(20755, 1881, 1, 1, 2, 7278.783462), -- Coarse Bone Powder
(20755, 1882, 1, 1, 2, 12131.30577), -- Leather
(20755, 1829, 1, 1, 2, 21836.350386), -- Scroll of Escape: Clan Hall
(20755, 2274, 1, 1, 2, 389.88726), -- Recipe: Skull Breaker
(20755, 1341, 10, 30, 2, 181968.860052), -- Bone Arrow
-- Talakin Archer
(20756, 1932, 1, 1, -1, 123147), -- Bone Helmet Design
(20756, 2262, 1, 1, -1, 12047), -- Recipe: Elven Bow
(20756, 1899, 1, 1, -1, 121223), -- Necklace of Devotion Chain
(20756, 57, 333, 651, 0, 700000), -- Adena
(20756, 274, 1, 1, 1, 276), -- Reinforced Bow
(20756, 1873, 1, 1, 2, 34833.58923), -- Silver Nugget
(20756, 1868, 1, 1, 2, 174167.94615), -- Thread
(20756, 1876, 1, 1, 2, 17416.794615), -- Mithril Ore
(20756, 2152, 1, 1, 2, 15331.609997), -- Recipe: Enchanted Necklace
(20756, 6035, 1, 1, 2, 7257.060008), -- Magic Haste Potion
-- Talakin Raider
(20757, 1868, 1, 3, -1, 572349), -- Thread
(20757, 847, 1, 1, -1, 5530), -- Red Crescent Earring
(20757, 2180, 1, 1, -1, 43034), -- Recipe: Scale Mail
(20757, 57, 247, 476, 0, 700000), -- Adena
(20757, 291, 1, 1, 1, 101.975412), -- Trident
(20757, 2019, 1, 1, 1, 3454.024588), -- Trident Edge
(20757, 1875, 1, 1, 2, 3569.092446), -- Stone of Purity
(20757, 1879, 1, 1, 2, 8922.714892), -- Cokes
(20757, 1885, 1, 1, 2, 4461.357446), -- High-Grade Suede
(20757, 5550, 1, 1, 2, 713.812), -- Durable Metal Plate
(20757, 5549, 1, 1, 2, 5353.622446), -- Metallic Thread
(20757, 2152, 1, 1, 2, 9425.40077), -- Recipe: Enchanted Necklace
-- Dragon Bearer Chief
(20758, 2946, 1, 1, -1, 117499), -- Plate Leather Gloves Design
(20758, 2167, 1, 1, -1, 107248), -- Recipe: Ring of Ages
(20758, 57, 830, 1692, 0, 700000), -- Adena
(20758, 853, 1, 1, 1, 206.286364), -- Earring of Protection
(20758, 1911, 1, 1, 1, 11546.5088), -- Earring of Protection Gemstone
(20758, 916, 1, 1, 1, 154.772352), -- Necklace of Protection
(20758, 1913, 1, 1, 1, 9440.115436), -- Necklace of Protection Gemstone
(20758, 884, 1, 1, 1, 309.544704), -- Ring of Protection
(20758, 1912, 1, 1, 1, 16728.772344), -- Ring of Protection Gemstone
(20758, 1872, 1, 1, 2, 124182.965169), -- Animal Bone
(20758, 1867, 1, 1, 2, 124182.965169), -- Animal Skin
(20758, 1881, 1, 1, 2, 12418.269215), -- Coarse Bone Powder
(20758, 1875, 1, 1, 2, 6209.271117), -- Stone of Purity
(20758, 4041, 1, 1, 2, 809.774354), -- Mold Hardener
(20758, 952, 1, 1, 2, 1241.963431), -- Scroll: Enchant Armor (C-Grade)
(20758, 8724, 1, 1, 2, 3104.499049), -- Life Stone - Level 49
(20758, 8734, 1, 1, 2, 776.193017), -- Mid-Grade Life Stone - Level 49
(20758, 8744, 1, 1, 2, 77.537396), -- High-Grade Life Stone - Level 49
(20758, 8754, 1, 1, 2, 15.562083), -- Top-Grade Life Stone - Level 49
-- Dragon Bearer Warrior
(20759, 2166, 1, 1, -1, 66974), -- Recipe: Earrings of Binding (100%)
(20759, 1912, 1, 1, -1, 212904), -- Ring of Protection Gemstone
(20759, 2167, 1, 1, -1, 100803), -- Recipe: Ring of Ages
(20759, 57, 781, 1588, 0, 700000), -- Adena
(20759, 398, 1, 1, 1, 63.804132), -- Plated Leather
(20759, 1966, 1, 1, 1, 3994.840755), -- Plated Leather Fragment
(20759, 399, 1, 1, 1, 58.836114), -- Rind Leather Armor
(20759, 1975, 1, 1, 1, 3593.970972), -- Rind Leather Armor Design
(20759, 418, 1, 1, 1, 102.02913), -- Plated Leather Gaiters
(20759, 1967, 1, 1, 1, 5967.739242), -- Plated Leather Gaiters Material
(20759, 419, 1, 1, 1, 94.207581), -- Rind Leather Gaiters
(20759, 1976, 1, 1, 1, 6653.572074), -- Rind Leather Gaiters Material
(20759, 1870, 1, 1, 2, 79582.602096), -- Coal
(20759, 1865, 1, 1, 2, 79582.602096), -- Varnish
(20759, 1874, 1, 1, 2, 5305.542058), -- Oriharukon Ore
(20759, 4043, 1, 1, 2, 2652.6829), -- Asofe
(20759, 4039, 1, 1, 2, 2652.6829), -- Mold Glue
(20759, 2168, 1, 1, 2, 2025.028162), -- Recipe: Necklace of Mermaid
(20759, 952, 1, 1, 2, 1061.07316), -- Scroll: Enchant Armor (C-Grade)
(20759, 8724, 1, 1, 2, 2652.6829), -- Life Stone - Level 49
(20759, 8734, 1, 1, 2, 663.258854), -- Mid-Grade Life Stone - Level 49
(20759, 8744, 1, 1, 2, 66.273008), -- High-Grade Life Stone - Level 49
(20759, 8754, 1, 1, 2, 13.571866), -- Top-Grade Life Stone - Level 49
-- Dragon Bearer Archer
(20760, 1911, 1, 1, -1, 152522), -- Earring of Protection Gemstone
(20760, 951, 1, 1, -1, 3728), -- Scroll: Enchant Weapon (C-Grade)
(20760, 1871, 1, 5, -1, 683553), -- Charcoal
(20760, 57, 809, 1651, 0, 700000), -- Adena
(20760, 398, 1, 1, 1, 66.225264), -- Plated Leather
(20760, 1966, 1, 1, 1, 4146.43026), -- Plated Leather Fragment
(20760, 399, 1, 1, 1, 61.068728), -- Rind Leather Armor
(20760, 1975, 1, 1, 1, 3730.348944), -- Rind Leather Armor Design
(20760, 418, 1, 1, 1, 105.90076), -- Plated Leather Gaiters
(20760, 1967, 1, 1, 1, 6194.192984), -- Plated Leather Gaiters Material
(20760, 419, 1, 1, 1, 97.782412), -- Rind Leather Gaiters
(20760, 1976, 1, 1, 1, 6906.050648), -- Rind Leather Gaiters Material
(20760, 1871, 1, 1, 2, 75716.574312), -- Charcoal
(20760, 1866, 1, 1, 2, 50477.716208), -- Suede
(20760, 1877, 1, 1, 2, 3028.62514), -- Adamantite Nugget
(20760, 4041, 1, 1, 2, 658.420268), -- Mold Hardener
(20760, 4040, 1, 1, 2, 1514.380128), -- Mold Lubricant
(20760, 951, 1, 1, 2, 137.683204), -- Scroll: Enchant Weapon (C-Grade)
(20760, 2343, 1, 1, 2, 176.056148), -- Recipe: Mace of Underworld
(20760, 2327, 1, 1, 2, 176.056148), -- Recipe: Caliburs
(20760, 8724, 1, 1, 2, 2523.831764), -- Life Stone - Level 49
(20760, 8734, 1, 1, 2, 630.99172), -- Mid-Grade Life Stone - Level 49
(20760, 8744, 1, 1, 2, 63.099172), -- High-Grade Life Stone - Level 49
(20760, 8754, 1, 1, 2, 12.565788), -- Top-Grade Life Stone - Level 49
-- Pytan
(20761, 1875, 1, 1, -1, 553373), -- Stone of Purity
(20761, 1874, 1, 1, -1, 553373), -- Oriharukon Ore
(20761, 1807, 1, 1, -1, 11067), -- Recipe: Soulshot (A-Grade)
(20761, 57, 3285, 6671, 0, 700000), -- Adena
(20761, 5287, 1, 1, 1, 22.945393), -- Sealed Dark Crystal breastplate
(20761, 5520, 1, 1, 1, 2635.436141), -- Sealed Dark Crystal Breastplate Pattern
(20761, 5293, 1, 1, 1, 14.124871), -- Sealed Tallum Plate Armor
(20761, 5521, 1, 1, 1, 1859.668652), -- Sealed Tallum Plate Armor Pattern
(20761, 5288, 1, 1, 1, 36.717787), -- Sealed Dark Crystal Gaiters
(20761, 5524, 1, 1, 1, 4028.107156), -- Sealed Dark Crystal Gaiters Pattern
(20761, 1868, 1, 3, 2, 204322.463928), -- Thread
(20761, 1873, 1, 1, 2, 81728.852832), -- Silver Nugget
(20761, 5549, 1, 1, 2, 20432.213208), -- Metallic Thread
(20761, 1889, 1, 1, 2, 13621.364856), -- Compound Braid
(20761, 4044, 1, 1, 2, 6810.848352), -- Thons
(20761, 4989, 1, 1, 2, 1353.276144), -- Recipe: Stockings of Doom (60%)
(20761, 4403, 1, 1, 2, 408.504888), -- Red Dimensional Stone
(20761, 5338, 1, 1, 2, 264.482856), -- Recipe: Sealed Majestic Leather Armor(60%)
(20761, 8730, 1, 1, 2, 2270.172168), -- Life Stone - Level 67
(20761, 8740, 1, 1, 2, 567.46008), -- Mid-Grade Life Stone - Level 67
(20761, 8750, 1, 1, 2, 56.746008), -- High-Grade Life Stone - Level 67
(20761, 8760, 1, 1, 2, 11.61468), -- Top-Grade Life Stone - Level 67
-- Pytan Knight
(20762, 5478, 1, 1, -1, 49132), -- Sealed Dark Crystal Leather Armor Pattern
(20762, 1807, 1, 1, -1, 7790), -- Recipe: Soulshot (A-Grade)
(20762, 57, 2311, 4698, 0, 700000), -- Adena
(20762, 5297, 1, 1, 1, 21.538242), -- Sealed Dark Crystal Leather Armor
(20762, 5478, 1, 1, 1, 2418.616002), -- Sealed Dark Crystal Leather Armor Pattern
(20762, 5301, 1, 1, 1, 13.248774), -- Sealed Tallum Leather Armor
(20762, 5479, 1, 1, 1, 1701.904446), -- Sealed Tallum Leather Armor Pattern
(20762, 5298, 1, 1, 1, 34.443618), -- Sealed Dark Crystal Leggings
(20762, 5482, 1, 1, 1, 3796.248918), -- Sealed Dark Crystal Leggings Design
(20762, 1872, 1, 1, 2, 209195.749232), -- Animal Bone
(20762, 1867, 1, 1, 2, 209195.749232), -- Animal Skin
(20762, 1881, 1, 1, 2, 20919.665679), -- Coarse Bone Powder
(20762, 1875, 1, 1, 2, 10459.60595), -- Stone of Purity
(20762, 4041, 1, 1, 2, 1364.513453), -- Mold Hardener
(20762, 1807, 1, 1, 2, 209.192119), -- Recipe: Soulshot (A-Grade)
(20762, 5336, 1, 1, 2, 202.839213), -- Recipe: Sealed Leather Armor of Nightmare(60%)
(20762, 8730, 1, 1, 2, 1743.418918), -- Life Stone - Level 67
(20762, 8740, 1, 1, 2, 435.62784), -- Mid-Grade Life Stone - Level 67
(20762, 8750, 1, 1, 2, 43.562784), -- High-Grade Life Stone - Level 67
(20762, 8760, 1, 1, 2, 9.07558), -- Top-Grade Life Stone - Level 67
-- Lord of the Plains
(20763, 1941, 1, 1, -1, 60607), -- Brigandine Temper
(20763, 1873, 1, 1, -1, 609587), -- Silver Nugget
(20763, 1902, 1, 1, -1, 154404), -- Elven Earring Beads
(20763, 57, 636, 1270, 0, 700000), -- Adena
(20763, 129, 1, 1, 1, 73.3502), -- Sword of Revolution
(20763, 2034, 1, 1, 1, 4161.6498), -- Sword of Revolution Blade
(20763, 1872, 1, 1, 2, 175060.96524), -- Animal Bone
(20763, 1867, 1, 1, 2, 175060.96524), -- Animal Skin
(20763, 1881, 1, 1, 2, 17506.25298), -- Coarse Bone Powder
(20763, 1875, 1, 1, 2, 8752.93092), -- Stone of Purity
(20763, 2146, 1, 1, 2, 9378.36378), -- Recipe: Artisan's frame
(20763, 2196, 1, 1, 2, 5380.52184), -- Recipe: Plate Gaiters
-- Shaman of the Plains
(20764, 1902, 1, 1, -1, 137744), -- Elven Earring Beads
(20764, 1825, 1, 1, -1, 97110), -- Recipe: Oriharukon
(20764, 1903, 1, 1, -1, 226779), -- Elven Ring Piece
(20764, 57, 575, 1146, 0, 700000), -- Adena
(20764, 437, 1, 1, 1, 204.293711), -- Mithril Tunic
(20764, 1944, 1, 1, 1, 8961.584082), -- Mithril Tunic Fabric
(20764, 470, 1, 1, 1, 326.265005), -- Mithril Stockings
(20764, 1945, 1, 1, 1, 13954.857202), -- Mithril Stocking Design
(20764, 1872, 1, 1, 2, 156172.667152), -- Animal Bone
(20764, 1867, 1, 1, 2, 156172.667152), -- Animal Skin
(20764, 1881, 1, 1, 2, 15617.337216), -- Coarse Bone Powder
(20764, 1875, 1, 1, 2, 7808.668608), -- Stone of Purity
(20764, 2149, 1, 1, 2, 8366.329936), -- Recipe: Metallic Fiber
(20764, 5473, 1, 1, 2, 8366.329936), -- Recipe: Durable Metal Plate(100%)
-- Warrior of the Plains
(20765, 2145, 1, 1, -1, 84024), -- Recipe: Mithril Alloy
(20765, 1904, 1, 1, -1, 109784), -- Elven Necklace Beads
(20765, 1873, 1, 1, -1, 470534), -- Silver Nugget
(20765, 57, 497, 993, 0, 700000), -- Adena
(20765, 850, 1, 1, 1, 281.910384), -- Elven Earring
(20765, 1902, 1, 1, 1, 10268.06382), -- Elven Earring Beads
(20765, 913, 1, 1, 1, 211.58298), -- Elven Necklace
(20765, 1904, 1, 1, 1, 9458.303652), -- Elven Necklace Beads
(20765, 881, 1, 1, 1, 423.16596), -- Elven Ring
(20765, 1903, 1, 1, 1, 16904.973204), -- Elven Ring Piece
(20765, 1873, 1, 1, 2, 40538.354184), -- Silver Nugget
(20765, 1868, 1, 1, 2, 202691.77092), -- Thread
(20765, 1876, 1, 1, 2, 20269.177092), -- Mithril Ore
(20765, 1895, 1, 1, 2, 28955.922669), -- Metallic Fiber
(20765, 2145, 1, 1, 2, 7238.902608), -- Recipe: Mithril Alloy
(20765, 2158, 1, 1, 2, 12542.872527), -- Recipe: Mithril Ring
-- Scout of the Plains
(20766, 1869, 1, 3, -1, 525817), -- Iron Ore
(20766, 1901, 1, 1, -1, 145253), -- Tiger's Eye Earring Stone
(20766, 2154, 1, 1, -1, 112595), -- Recipe: Elven Earring
(20766, 57, 443, 889, 0, 700000), -- Adena
(20766, 553, 1, 1, 1, 408.595324), -- Iron Boots
(20766, 1940, 1, 1, 1, 11922.428056), -- Iron Boots Design
(20766, 2422, 1, 1, 1, 408.595324), -- Reinforced Leather Boots
(20766, 2423, 1, 1, 1, 408.595324), -- Boots of Knowledge
(20766, 63, 1, 1, 1, 408.595324), -- Gauntlets
(20766, 2446, 1, 1, 1, 408.595324), -- Reinforced Leather Gloves
(20766, 2447, 1, 1, 1, 408.595324), -- Gloves of Knowledge
(20766, 1864, 1, 1, 2, 159755.92243), -- Stem
(20766, 1869, 1, 1, 2, 79878.132346), -- Iron Ore
(20766, 1878, 1, 1, 2, 31951.184486), -- Braided Hemp
(20766, 1884, 1, 1, 2, 49155.66844), -- Cord
(20766, 2155, 1, 1, 2, 12821.476782), -- Recipe: Elven Ring
(20766, 2195, 1, 1, 2, 2042.961878), -- Recipe: Half Plate Armor
(20766, 6035, 1, 1, 2, 6656.653638), -- Magic Haste Potion
-- Timak Orc Troop Leader
(20767, 2076, 1, 1, -1, 15046), -- Body Slasher Blade
(20767, 2220, 1, 1, -1, 39718), -- Recipe: Rind Leather Armor
(20767, 1879, 1, 1, -1, 319728), -- Cokes
(20767, 57, 759, 1541, 0, 700000), -- Adena
(20767, 281, 1, 1, 1, 51.42543), -- Crystallized Ice Bow
(20767, 2074, 1, 1, 1, 3210.57457), -- Crystallized Ice Bow Shaft
(20767, 1865, 1, 1, 2, 75554.064168), -- Varnish
(20767, 1870, 1, 1, 2, 75554.064168), -- Coal
(20767, 1879, 1, 1, 2, 12592.285266), -- Cokes
(20767, 1875, 1, 1, 2, 5037.019878), -- Stone of Purity
(20767, 4040, 1, 1, 2, 1511.123592), -- Mold Lubricant
(20767, 2225, 1, 1, 2, 1642.456662), -- Recipe: Demon's Stockings
(20767, 2321, 1, 1, 2, 263.194998), -- Recipe: Stiletto
(20767, 2322, 1, 1, 2, 263.194998), -- Recipe: Soulfire Dirk
(20767, 8723, 1, 1, 2, 3022.247184), -- Life Stone - Level 46
(20767, 8733, 1, 1, 2, 755.561796), -- Mid-Grade Life Stone - Level 46
(20767, 8743, 1, 1, 2, 75.626694), -- High-Grade Life Stone - Level 46
(20767, 8753, 1, 1, 2, 15.160596), -- Top-Grade Life Stone - Level 46
-- Timak Orc Troop Shaman
(20768, 1908, 1, 1, -1, 174999), -- Moonstone Earring Wire
(20768, 2163, 1, 1, -1, 94285), -- Recipe: Earring of Protection
(20768, 1909, 1, 1, -1, 249560), -- Aquastone Ring Wire
(20768, 57, 727, 1491, 0, 700000), -- Adena
(20768, 631, 1, 1, 1, 285.42048), -- Eldarake
(20768, 1964, 1, 1, 1, 11762.156994), -- Eldarake Temper
(20768, 2495, 1, 1, 1, 285.42048), -- Chain Shield
(20768, 2945, 1, 1, 1, 11762.156994), -- Chain Shield Fragment
(20768, 2413, 1, 1, 1, 199.794336), -- Chain Hood
(20768, 2936, 1, 1, 1, 10683.050716), -- Chain Hood Pattern
(20768, 1865, 1, 1, 2, 72782.4462), -- Varnish
(20768, 1870, 1, 1, 2, 72782.4462), -- Coal
(20768, 1879, 1, 1, 2, 12130.323912), -- Cokes
(20768, 1875, 1, 1, 2, 4852.079292), -- Stone of Purity
(20768, 2163, 1, 1, 2, 3713.400372), -- Recipe: Earring of Protection
(20768, 2315, 1, 1, 2, 253.626276), -- Recipe: Shamshir
(20768, 2319, 1, 1, 2, 253.626276), -- Recipe: Raid Sword
(20768, 8723, 1, 1, 2, 2911.297848), -- Life Stone - Level 46
(20768, 8733, 1, 1, 2, 727.950144), -- Mid-Grade Life Stone - Level 46
(20768, 8743, 1, 1, 2, 72.89556), -- High-Grade Life Stone - Level 46
(20768, 8753, 1, 1, 2, 14.579112), -- Top-Grade Life Stone - Level 46
(20768, 1832, 1, 1, 2, 80869.328808), -- Greater Antidote
-- Timak Orc Troop Warrior
(20769, 5220, 1, 1, -1, 58852), -- Metal Hardener
(20769, 1885, 1, 1, -1, 122609), -- High-Grade Suede
(20769, 4469, 1, 1, -1, 8407), -- Dye of STR (Str+1 Con-1)
(20769, 57, 582, 1182, 0, 700000), -- Adena
(20769, 70, 1, 1, 1, 26.635317), -- Claymore
(20769, 2047, 1, 1, 1, 1623.849333), -- Claymore Blade
(20769, 2499, 1, 1, 1, 26.635317), -- Elven Long Sword
(20769, 2967, 1, 1, 1, 1601.880033), -- Elven Long Sword Blade
(20769, 1866, 1, 1, 2, 70364.177896), -- Suede
(20769, 1871, 1, 1, 2, 105546.466832), -- Charcoal
(20769, 5220, 1, 1, 2, 4221.946668), -- Metal Hardener
(20769, 1885, 1, 1, 2, 8795.47224), -- High-Grade Suede
(20769, 2161, 1, 1, 2, 10247.185132), -- Recipe: Aquastone Ring
(20769, 5269, 1, 1, 2, 351.778892), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
(20769, 2297, 1, 1, 2, 460.97234), -- Recipe: Flamberge
-- Timak Orc Troop Archer
(20770, 1905, 1, 1, -1, 167101), -- Omen Beast's Eye Earring Gemstone
(20770, 1805, 1, 1, -1, 5726), -- Recipe: Soulshot (C-Grade)
(20770, 1906, 1, 1, -1, 236124), -- Mithril Ring Wire
(20770, 57, 696, 1393, 0, 700000), -- Adena
(20770, 159, 1, 1, 1, 12.438186), -- Bonebreaker
(20770, 2048, 1, 1, 1, 713.154852), -- Bonebreaker Head
(20770, 187, 1, 1, 1, 12.438186), -- Atuba Hammer
(20770, 2049, 1, 1, 1, 713.154852), -- Atuba Hammer Head
(20770, 188, 1, 1, 1, 12.438186), -- Ghost Staff
(20770, 2050, 1, 1, 1, 756.174114), -- Ghost Staff Head
(20770, 189, 1, 1, 1, 12.438186), -- Staff of Life
(20770, 2051, 1, 1, 1, 756.174114), -- Staff of Life Shaft
(20770, 190, 1, 1, 1, 12.438186), -- Atuba Mace
(20770, 2058, 1, 1, 1, 713.151138), -- Atuba Mace Head
(20770, 1867, 1, 1, 2, 164304.797622), -- Animal Skin
(20770, 1872, 1, 1, 2, 164304.797622), -- Animal Bone
(20770, 1882, 1, 1, 2, 27384.012378), -- Leather
(20770, 1894, 1, 1, 2, 4323.848535), -- Crafted Leather
(20770, 1805, 1, 1, 2, 410.865072), -- Recipe: Soulshot (C-Grade)
(20770, 2298, 1, 1, 2, 538.175376), -- Recipe: Stormbringer
(20770, 5269, 1, 1, 2, 410.503395), -- Recipe: Greater Soulshot (C) Compressed Package(100%)
-- Barif
(20771, 1875, 1, 1, -1, 357372), -- Stone of Purity
(20771, 948, 1, 1, -1, 13401), -- Scroll: Enchant Armor (B-Grade)
(20771, 4042, 1, 1, -1, 89343), -- Enria
(20771, 57, 2128, 4304, 0, 700000), -- Adena
(20771, 171, 1, 1, 1, 5.230248), -- Deadman's Glory
(20771, 4116, 1, 1, 1, 1152.969252), -- Deadman's Glory Stone
(20771, 175, 1, 1, 1, 5.230248), -- Art of Battle Axe
(20771, 4117, 1, 1, 1, 1152.969252), -- Art of Battle Axe Blade
(20771, 210, 1, 1, 1, 5.230248), -- Staff of Evil Spirits
(20771, 4118, 1, 1, 1, 1092.370752), -- Evil Spirit Head
(20771, 1895, 1, 1, 2, 45241.35158), -- Metallic Fiber
(20771, 4040, 1, 1, 2, 3166.88589), -- Mold Lubricant
(20771, 4042, 1, 1, 2, 2639.10272), -- Enria
(20771, 4043, 1, 1, 2, 5278.14315), -- Asofe
(20771, 4953, 1, 1, 2, 3050.9642), -- Recipe: Sealed Avadon Gloves (60%)
(20771, 5276, 1, 1, 2, 211.10081), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20771, 8729, 1, 1, 2, 2111.25726), -- Life Stone - Level 64
(20771, 8739, 1, 1, 2, 527.84546), -- Mid-Grade Life Stone - Level 64
(20771, 8749, 1, 1, 2, 52.75963), -- High-Grade Life Stone - Level 64
(20771, 8759, 1, 1, 2, 10.5893), -- Top-Grade Life Stone - Level 64
-- Barif's Pet
(20772, 1875, 1, 1, -1, 344772), -- Stone of Purity
(20772, 1986, 1, 1, -1, 54648), -- Full Plate Armor Temper
(20772, 4613, 1, 1, -1, 7133), -- Greater Dye of STR (Str+4 Con-4)
(20772, 57, 2049, 4156, 0, 700000), -- Adena
(20772, 300, 1, 1, 1, 22.864152), -- Great Axe
(20772, 4113, 1, 1, 1, 3930.135848), -- Great Axe Head
(20772, 1872, 1, 1, 2, 169733.487288), -- Animal Bone
(20772, 1867, 1, 1, 2, 169733.487288), -- Animal Skin
(20772, 1881, 1, 1, 2, 16973.385864), -- Coarse Bone Powder
(20772, 1875, 1, 1, 2, 8486.507256), -- Stone of Purity
(20772, 4041, 1, 1, 2, 1107.000312), -- Mold Hardener
(20772, 4618, 1, 1, 2, 175.649496), -- Greater Dye of DEX (Dex+4 Con-4)
(20772, 4999, 1, 1, 2, 1583.444928), -- Recipe: Sealed Doom Boots (60%)
(20772, 4163, 1, 1, 2, 842.96904), -- Recipe: Blue Wolf Stockings (100%)
(20772, 8728, 1, 1, 2, 2121.533976), -- Life Stone - Level 61
(20772, 8738, 1, 1, 2, 530.290656), -- Mid-Grade Life Stone - Level 61
(20772, 8748, 1, 1, 2, 53.103336), -- High-Grade Life Stone - Level 61
(20772, 8758, 1, 1, 2, 11.14056), -- Top-Grade Life Stone - Level 61
-- Conjurer Bat Lord
(20773, 5478, 1, 1, -1, 29805), -- Sealed Dark Crystal Leather Armor Pattern
(20773, 1807, 1, 1, -1, 4726), -- Recipe: Soulshot (A-Grade)
(20773, 5479, 1, 1, -1, 20973), -- Sealed Tallum Leather Armor Pattern
(20773, 57, 1748, 3569, 0, 700000), -- Adena
(20773, 6324, 1, 1, 1, 43.406603), -- Sealed Phoenix Earring
(20773, 6341, 1, 1, 1, 6032.61631), -- Sealed Phoenix Earring Gemstone
(20773, 6323, 1, 1, 1, 32.550157), -- Sealed Phoenix Necklace
(20773, 6343, 1, 1, 1, 4663.438168), -- Sealed Phoenix Necklace Beads
(20773, 6325, 1, 1, 1, 65.100314), -- Sealed Phoenix Ring
(20773, 6345, 1, 1, 1, 8343.888448), -- Sealed Phoenix Ring Gemstone
(20773, 1868, 1, 1, 2, 237949.17195), -- Thread
(20773, 1873, 1, 1, 2, 47589.83439), -- Silver Nugget
(20773, 5549, 1, 1, 2, 11897.302739), -- Metallic Thread
(20773, 1889, 1, 1, 2, 7931.639065), -- Compound Braid
(20773, 4044, 1, 1, 2, 3965.663674), -- Thons
(20773, 4157, 1, 1, 2, 591.950583), -- Recipe: Blue Wolf Gaiters (100%)
(20773, 730, 1, 1, 2, 99.126006), -- Scroll: Enchant Armor (A-Grade)
(20773, 8730, 1, 1, 2, 1321.991797), -- Life Stone - Level 67
(20773, 8740, 1, 1, 2, 330.42002), -- Mid-Grade Life Stone - Level 67
(20773, 8750, 1, 1, 2, 33.042002), -- High-Grade Life Stone - Level 67
(20773, 8760, 1, 1, 2, 6.857774), -- Top-Grade Life Stone - Level 67
-- Conjurer Bat 
(20774, 1807, 1, 1, -1, 6216), -- Recipe: Soulshot (A-Grade)
(20774, 5478, 1, 1, -1, 39204), -- Sealed Dark Crystal Leather Armor Pattern
(20774, 1889, 1, 1, -1, 310807), -- Compound Braid
(20774, 57, 1844, 3751, 0, 700000), -- Adena
(20774, 5291, 1, 1, 1, 38.682273), -- Sealed Dark Crystal Boots
(20774, 5496, 1, 1, 1, 4036.567727), -- Sealed Dark Crystal Boots Lining
(20774, 5296, 1, 1, 1, 38.682273), -- Sealed Tallum Boots
(20774, 5497, 1, 1, 1, 4036.567727), -- Sealed Tallum Boots Lining
(20774, 5290, 1, 1, 1, 38.682273), -- Sealed Dark Crystal Gloves
(20774, 5508, 1, 1, 1, 4036.567727), -- Sealed Dark Crystal Gloves Design
(20774, 5295, 1, 1, 1, 38.682273), -- Sealed Tallum Gloves
(20774, 5509, 1, 1, 1, 4036.567727), -- Sealed Tallum Gloves Design
(20774, 1873, 1, 1, 2, 55084.610222), -- Silver Nugget
(20774, 1868, 1, 1, 2, 275423.452944), -- Thread
(20774, 1876, 1, 1, 2, 27542.506028), -- Mithril Ore
(20774, 1895, 1, 1, 2, 39346.379778), -- Metallic Fiber
(20774, 4042, 1, 1, 2, 2295.275808), -- Enria
(20774, 5271, 1, 1, 2, 183.638138), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(20774, 8730, 1, 1, 2, 1530.183872), -- Life Stone - Level 67
(20774, 8740, 1, 1, 2, 382.545968), -- Mid-Grade Life Stone - Level 67
(20774, 8750, 1, 1, 2, 38.17423), -- High-Grade Life Stone - Level 67
(20774, 8760, 1, 1, 2, 7.233012), -- Top-Grade Life Stone - Level 67
-- Bugbear Raider
(20775, 2253, 1, 1, -1, 9985), -- Recipe: Sword Breaker
(20775, 1897, 1, 1, -1, 58010), -- Necklace of Wisdom Chain
(20775, 1800, 1, 1, -1, 76617), -- Recipe: Piece Bone Breastplate
(20775, 57, 119, 191, 0, 700000), -- Adena
(20775, 15, 1, 1, 1, 137.091519), -- Short Spear
(20775, 2011, 1, 1, 1, 1641.908481), -- Short Spear Edge
(20775, 1873, 1, 1, 2, 19191.51927), -- Silver Nugget
(20775, 1868, 1, 1, 2, 95957.721095), -- Thread
(20775, 2144, 1, 1, 2, 9595.759635), -- Recipe: Compound Braid
-- Dark Succubus
(20776, 1865, 1, 1, -1, 297237), -- Varnish
(20776, 1866, 1, 1, -1, 198158), -- Suede
(20776, 1897, 1, 1, -1, 70771), -- Necklace of Wisdom Chain
(20776, 57, 137, 239, 0, 700000), -- Adena
(20776, 1101, 1, 1, 1, 1125.650223), -- Tunic of Devotion
(20776, 1104, 1, 1, 1, 1797.349777), -- Stockings of Devotion
(20776, 1869, 1, 1, 2, 19510.9902), -- Iron Ore
(20776, 1870, 1, 1, 2, 19510.9902), -- Coal
(20776, 1871, 1, 1, 2, 19510.9902), -- Charcoal
(20776, 1872, 1, 1, 2, 26014.6536), -- Animal Bone
(20776, 1867, 1, 1, 2, 26014.6536), -- Animal Skin
(20776, 2140, 1, 1, 2, 3902.2656), -- Recipe: High-Grade Suede
(20776, 5158, 1, 1, 2, 780.4869), -- Recipe: Spiritshot (D) Compressed Package (100%)
(20776, 735, 1, 1, 2, 1625.8314), -- Alacrity Potion
(20776, 1831, 1, 1, 2, 52029.1383), -- Antidote
-- Hunter Bear
(20777, 1831, 1, 1, -1, 594351), -- Antidote
(20777, 1896, 1, 1, -1, 94441), -- Necklace of Anguish Chain
(20777, 1792, 1, 1, -1, 16388), -- Recipe: Short Spear
(20777, 57, 114, 168, 0, 700000), -- Adena
(20777, 37, 1, 1, 1, 4303.043343), -- Leather Shoes
(20777, 1921, 1, 1, 1, 28316.876391), -- Leather Shoes Texture
(20777, 49, 1, 1, 1, 4303.080266), -- Gloves
(20777, 1868, 1, 1, 2, 87781.424965), -- Thread
(20777, 1873, 1, 1, 2, 17556.26328), -- Silver Nugget
(20777, 1794, 1, 1, 2, 3227.311755), -- Recipe: Forest Bow
-- Ragna Orc Overlord
(20778, 2290, 1, 1, -1, 5412), -- Recipe: Mithril Dagger
(20778, 1903, 1, 1, -1, 162485), -- Elven Ring Piece
(20778, 1902, 1, 1, -1, 98693), -- Elven Earring Beads
(20778, 57, 412, 821, 0, 700000), -- Adena
(20778, 352, 1, 1, 1, 73.069944), -- Brigandine Tunic
(20778, 1941, 1, 1, 1, 3337.400322), -- Brigandine Temper
(20778, 2377, 1, 1, 1, 116.881986), -- Mithril Scale Gaiters
(20778, 2918, 1, 1, 1, 4978.889682), -- Mithril Scale Gaiters Material
(20778, 2378, 1, 1, 1, 116.881986), -- Brigandine Gaiters
(20778, 2919, 1, 1, 1, 4978.87608), -- Brigandine Gaiters Material
(20778, 1871, 1, 1, 2, 83922.320522), -- Charcoal
(20778, 1866, 1, 1, 2, 55948.264595), -- Suede
(20778, 1877, 1, 1, 2, 3356.941698), -- Adamantite Nugget
(20778, 2289, 1, 1, 2, 466.165532), -- Recipe: Staff of Life
(20778, 2288, 1, 1, 2, 466.165532), -- Recipe: Ghost Staff
(20778, 2202, 1, 1, 2, 8581.142121), -- Recipe: Assault Boots
-- Ragna Orc Priest
(20779, 2158, 1, 1, -1, 107640), -- Recipe: Mithril Ring
(20779, 1904, 1, 1, -1, 81170), -- Elven Necklace Beads
(20779, 1866, 1, 1, -1, 579821), -- Suede
(20779, 57, 368, 733, 0, 700000), -- Adena
(20779, 318, 1, 1, 1, 41.858726), -- Crucifix of Blood
(20779, 2042, 1, 1, 1, 2077.141274), -- Crucifix of Blood Piece
(20779, 1871, 1, 1, 2, 89916.679179), -- Charcoal
(20779, 1866, 1, 1, 2, 59944.452786), -- Suede
(20779, 1877, 1, 1, 2, 3596.685702), -- Adamantite Nugget
(20779, 2290, 1, 1, 2, 499.513938), -- Recipe: Mithril Dagger
(20779, 2286, 1, 1, 2, 499.668395), -- Recipe: Bonebreaker
-- Bloody Axe Elite
(20780, 2980, 1, 1, -1, 95429), -- Recipe: Brigandine Gauntlets
(20780, 1901, 1, 1, -1, 98461), -- Tiger's Eye Earring Stone
(20780, 1877, 1, 1, -1, 28514), -- Adamantite Nugget
(20780, 57, 301, 601, 0, 700000), -- Adena
(20780, 157, 1, 1, 1, 33.984452), -- Spiked Club
(20780, 2027, 1, 1, 1, 1655.031096), -- Spiked Club Head
(20780, 186, 1, 1, 1, 33.984452), -- Staff of Magic
(20780, 1871, 1, 1, 2, 94755.45226), -- Charcoal
(20780, 1866, 1, 1, 2, 63170.246545), -- Suede
(20780, 1877, 1, 1, 2, 3790.211495), -- Adamantite Nugget
(20780, 2186, 1, 1, 2, 3169.0897), -- Recipe: Brigandine Tunic
-- Delu Lizardman Shaman
(20781, 2192, 1, 1, -1, 90034), -- Recipe: Kite Shield
(20781, 1938, 1, 1, -1, 47453), -- Mithril Banded Mail Material
(20781, 1901, 1, 1, -1, 97496), -- Tiger's Eye Earring Stone
(20781, 57, 298, 595, 0, 700000), -- Adena
(20781, 436, 1, 1, 1, 320.586714), -- Tunic of Knowledge
(20781, 469, 1, 1, 1, 512.413286), -- Stockings of Knowledge
(20781, 1875, 1, 1, 2, 3127.529982), -- Stone of Purity
(20781, 1879, 1, 1, 2, 7818.876878), -- Cokes
(20781, 1885, 1, 1, 2, 3909.438439), -- High-Grade Suede
(20781, 5550, 1, 1, 2, 625.516381), -- Durable Metal Plate
(20781, 5549, 1, 1, 2, 4691.346896), -- Metallic Thread
(20781, 2187, 1, 1, 2, 2094.366128), -- Recipe: Manticore Skin Shirt
(20781, 2273, 1, 1, 2, 335.111042), -- Recipe: Tarbar
(20781, 6667, 1, 1, 2, 29320.814254), -- Deluxe Chest Key - Grade 3
-- Ol Mahum Novice
(20782, 1801, 1, 1, -1, 126448), -- Recipe: Piece Bone Gaiters
(20782, 1924, 1, 1, -1, 80968), -- Leather Helmet Design
(20782, 1800, 1, 1, -1, 78931), -- Recipe: Piece Bone Breastplate
(20782, 57, 122, 197, 0, 700000), -- Adena
(20782, 256, 1, 1, 1, 282), -- Cestus
(20782, 1872, 1, 1, 2, 49427.50289), -- Animal Bone
(20782, 1867, 1, 1, 2, 49427.50289), -- Animal Skin
(20782, 2150, 1, 1, 2, 17404.03373), -- Recipe: Blue Diamond Necklace
(20782, 5268, 1, 1, 2, 1482.96049), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Dread Wolf
(20783, 2203, 1, 1, -1, 70587), -- Recipe: Reinforced Mithril Boots
(20783, 1935, 1, 1, -1, 18100), -- Scale Mail Fragment
(20783, 1900, 1, 1, -1, 35448), -- Enchanted Necklace Chain
(20783, 57, 137, 273, 0, 700000), -- Adena
(20783, 316, 1, 1, 1, 15.435576), -- Sage's Blood
(20783, 317, 1, 1, 1, 15.435576), -- Tome of Blood
(20783, 2030, 1, 1, 1, 671.128848), -- Tome of Blood Page
(20783, 1874, 1, 1, 2, 1435.544052), -- Oriharukon Ore
(20783, 1878, 1, 1, 2, 8613.23233), -- Braided Hemp
(20783, 1884, 1, 1, 2, 13251.10206), -- Cord
(20783, 1889, 1, 1, 2, 1435.544052), -- Compound Braid
(20783, 5220, 1, 1, 2, 861.307242), -- Metal Hardener
(20783, 2153, 1, 1, 2, 3348.83522), -- Recipe: Tiger's Eye Earring
(20783, 2977, 1, 1, 2, 2882.601624), -- Recipe: Brigandine Boots
(20783, 8307, 1, 1, 2, 153.83342), -- Recipe: Priest Mace (100%)
-- Tasaba Lizardman
(20784, 2021, 1, 1, -1, 4623), -- Spinebone Sword Blade
(20784, 2184, 1, 1, -1, 38461), -- Recipe: Mithril Banded Gaiters
(20784, 2153, 1, 1, -1, 56945), -- Recipe: Tiger's Eye Earring
(20784, 57, 154, 309, 0, 700000), -- Adena
(20784, 83, 1, 1, 1, 11.7744), -- Sword of Magic
(20784, 144, 1, 1, 1, 11.7744), -- Sword of Occult
(20784, 124, 1, 1, 1, 8.72256), -- Two-Handed Sword
(20784, 2026, 1, 1, 1, 390.28308), -- Two-Handed Sword Edge
(20784, 127, 1, 1, 1, 8.72256), -- Crimson Sword
(20784, 130, 1, 1, 1, 8.723), -- Elven Sword
(20784, 1875, 1, 1, 2, 2163.132496), -- Stone of Purity
(20784, 1879, 1, 1, 2, 5407.842272), -- Cokes
(20784, 1885, 1, 1, 2, 2703.921136), -- High-Grade Suede
(20784, 5550, 1, 1, 2, 432.630912), -- Durable Metal Plate
(20784, 5549, 1, 1, 2, 3244.709776), -- Metallic Thread
(20784, 2250, 1, 1, 2, 8111.763408), -- Recipe: Bone Arrow
-- Tasaba Lizardman Shaman
(20785, 2022, 1, 1, -1, 5500), -- Mace of Judgment Head
(20785, 1933, 1, 1, -1, 41540), -- Dark Stockings Fabric
(20785, 1875, 1, 1, -1, 23539), -- Stone of Purity
(20785, 57, 149, 298, 0, 700000), -- Adena
(20785, 1124, 1, 1, 1, 39.7463), -- Boots of Power
(20785, 1948, 1, 1, 1, 1541.5037), -- Boots of Power Pattern
(20785, 2424, 1, 1, 1, 39.7463), -- Manticore Skin Boots
(20785, 2923, 1, 1, 1, 1541.5037), -- Manticore Skin Boot Lining
(20785, 2425, 1, 1, 1, 39.7463), -- Brigandine Boots
(20785, 2924, 1, 1, 1, 1541.5037), -- Brigandine Boots Design
(20785, 2426, 1, 1, 1, 39.7463), -- Elven Mithril Boots
(20785, 2925, 1, 1, 1, 1541.5037), -- Elven Mithril Boots Design
(20785, 606, 1, 1, 1, 39.7463), -- Rip Gauntlets
(20785, 1946, 1, 1, 1, 1541.5037), -- Rip Gauntlets Pattern
(20785, 2448, 1, 1, 1, 39.7463), -- Manticore Skin Gloves
(20785, 2926, 1, 1, 1, 1541.5037), -- Manticore Skin Gloves Lining
(20785, 2449, 1, 1, 1, 39.7463), -- Brigandine Gauntlets
(20785, 2927, 1, 1, 1, 1541.5037), -- Brigandine Gauntlets Pattern
(20785, 2450, 1, 1, 1, 39.7463), -- Mithril Gloves
(20785, 2928, 1, 1, 1, 1541.5037), -- Mithril Gloves Design
(20785, 1875, 1, 1, 2, 1352.00395), -- Stone of Purity
(20785, 1879, 1, 1, 2, 3380.009875), -- Cokes
(20785, 1885, 1, 1, 2, 1690.052725), -- High-Grade Suede
(20785, 5550, 1, 1, 2, 270.381675), -- Durable Metal Plate
(20785, 5549, 1, 1, 2, 2028.005925), -- Metallic Thread
(20785, 2185, 1, 1, 2, 3992.16775), -- Recipe: Iron Boots
(20785, 2982, 1, 1, 2, 2586.737375), -- Recipe: Brigandine Shield
(20785, 6667, 1, 1, 2, 12675.060925), -- Deluxe Chest Key - Grade 3
(20785, 1341, 10, 30, 2, 67600.5798), -- Bone Arrow
-- Lienrik
(20786, 2026, 1, 1, -1, 4711), -- Two-Handed Sword Edge
(20786, 2155, 1, 1, -1, 62822), -- Recipe: Elven Ring
(20786, 5550, 1, 1, -1, 5218), -- Durable Metal Plate
(20786, 57, 166, 330, 0, 700000), -- Adena
(20786, 395, 1, 1, 1, 58.81275), -- Manticore Skin Shirt
(20786, 1942, 1, 1, 1, 2579.8905), -- Manticore Skin Shirt Texture
(20786, 417, 1, 1, 1, 93.92625), -- Manticore Skin Gaiters
(20786, 1943, 1, 1, 1, 4017.3705), -- Manticore Skin Gaiters Pattern
(20786, 1875, 1, 1, 2, 1685.957287), -- Stone of Purity
(20786, 1879, 1, 1, 2, 4214.885927), -- Cokes
(20786, 1885, 1, 1, 2, 2107.450254), -- High-Grade Suede
(20786, 5550, 1, 1, 2, 337.185625), -- Durable Metal Plate
(20786, 5549, 1, 1, 2, 2528.92864), -- Metallic Thread
(20786, 2278, 1, 1, 2, 180.644009), -- Recipe: Reinforced Long Bow
(20786, 2286, 1, 1, 2, 140.502516), -- Recipe: Bonebreaker
(20786, 2977, 1, 1, 2, 3385.445742), -- Recipe: Brigandine Boots
-- Lienrik Lad
(20787, 1870, 1, 1, -1, 476736), -- Coal
(20787, 2029, 1, 1, -1, 5687), -- Gastraphetes Shaft
(20787, 5549, 1, 1, -1, 47674), -- Metallic Thread
(20787, 57, 199, 397, 0, 700000), -- Adena
(20787, 850, 1, 1, 1, 114.249236), -- Elven Earring
(20787, 1902, 1, 1, 1, 4161.316905), -- Elven Earring Beads
(20787, 913, 1, 1, 1, 85.747795), -- Elven Necklace
(20787, 1904, 1, 1, 1, 3833.147083), -- Elven Necklace Beads
(20787, 881, 1, 1, 1, 171.49559), -- Elven Ring
(20787, 1903, 1, 1, 1, 6851.043391), -- Elven Ring Piece
(20787, 1875, 1, 1, 2, 1825.447782), -- Stone of Purity
(20787, 1879, 1, 1, 2, 4563.688148), -- Cokes
(20787, 1885, 1, 1, 2, 2281.844074), -- High-Grade Suede
(20787, 5550, 1, 1, 2, 365.034602), -- Durable Metal Plate
(20787, 5549, 1, 1, 2, 2738.240366), -- Metallic Thread
(20787, 2188, 1, 1, 2, 1955.827096), -- Recipe: Manticore Skin Gaiters
(20787, 5473, 1, 1, 2, 1955.827096), -- Recipe: Durable Metal Plate(100%)
(20787, 1832, 1, 1, 2, 30424.954016), -- Greater Antidote
(20787, 1341, 10, 30, 2, 91275.13682), -- Bone Arrow
-- Rakul
(20788, 2186, 1, 1, -1, 28093), -- Recipe: Brigandine Tunic
(20788, 1901, 1, 1, -1, 116020), -- Tiger's Eye Earring Stone
(20788, 57, 355, 708, 0, 700000), -- Adena
(20788, 260, 1, 1, 1, 120), -- Triple-Edged Jamadhr
(20788, 1874, 1, 1, 2, 3721.759626), -- Oriharukon Ore
(20788, 1878, 1, 1, 2, 22330.557756), -- Braided Hemp
(20788, 1884, 1, 1, 2, 34354.730995), -- Cord
(20788, 1889, 1, 1, 2, 3721.759626), -- Compound Braid
(20788, 5220, 1, 1, 2, 2233.041863), -- Metal Hardener
(20788, 2189, 1, 1, 2, 2492.233601), -- Recipe: Mithril Tunic
(20788, 2293, 1, 1, 2, 310.181417), -- Recipe: Glaive
(20788, 2275, 1, 1, 2, 398.735116), -- Recipe: Heavy Bone Club
-- Crokian
(20789, 2030, 1, 1, -1, 9246), -- Tome of Blood Page
(20789, 2188, 1, 1, -1, 56469), -- Recipe: Manticore Skin Gaiters
(20789, 2154, 1, 1, -1, 84644), -- Recipe: Elven Earring
(20789, 57, 333, 668, 0, 700000), -- Adena
(20789, 393, 1, 1, 1, 119.754095), -- Mithril Banded Mail
(20789, 1938, 1, 1, 1, 4709.504645), -- Mithril Banded Mail Material
(20789, 394, 1, 1, 1, 119.754095), -- Reinforced Leather Shirt
(20789, 415, 1, 1, 1, 191.40901), -- Mithril Banded Gaiters
(20789, 1939, 1, 1, 1, 6153.18063), -- Mithril Banded Gaiters Material
(20789, 416, 1, 1, 1, 191.397525), -- Reinforced Leather Gaiters
(20789, 1874, 1, 1, 2, 3502.836657), -- Oriharukon Ore
(20789, 1878, 1, 1, 2, 21016.771461), -- Braided Hemp
(20789, 1884, 1, 1, 2, 32333.590125), -- Cord
(20789, 1889, 1, 1, 2, 3502.836657), -- Compound Braid
(20789, 5220, 1, 1, 2, 2101.652298), -- Metal Hardener
(20789, 2275, 1, 1, 2, 375.20631), -- Recipe: Heavy Bone Club
(20789, 1661, 1, 1, 2, 10508.509971), -- Thief Key
(20789, 1341, 10, 30, 2, 175139.596521), -- Bone Arrow
-- Dailaon
(20790, 2039, 1, 1, -1, 10243), -- Bich'Hwa Edge
(20790, 1868, 1, 5, -1, 674568), -- Thread
(20790, 1902, 1, 1, -1, 102518), -- Elven Earring Beads
(20790, 57, 428, 853, 0, 700000), -- Adena
(20790, 224, 1, 1, 1, 24.35192), -- Maingauche
(20790, 2038, 1, 1, 1, 1381.64808), -- Maingauche Edge
(20790, 1660, 1, 1, 1, 24.35192), -- Cursed Maingauche
(20790, 2044, 1, 1, 1, 1381.64808), -- Cursed Maingauche Edge
(20790, 1874, 1, 1, 2, 3486.998377), -- Oriharukon Ore
(20790, 1878, 1, 1, 2, 20921.154519), -- Braided Hemp
(20790, 1884, 1, 1, 2, 32186.412997), -- Cord
(20790, 1889, 1, 1, 2, 3486.998377), -- Compound Braid
(20790, 5220, 1, 1, 2, 2092.14331), -- Metal Hardener
(20790, 2147, 1, 1, 2, 3736.049791), -- Recipe: Blacksmith's frame
(20790, 2984, 1, 1, 2, 5347.919457), -- Recipe: Salamander Skin Boots
(20790, 2289, 1, 1, 2, 290.559983), -- Recipe: Staff of Life
(20790, 6667, 1, 1, 2, 32689.530283), -- Deluxe Chest Key - Grade 3
(20790, 1341, 10, 30, 2, 174343.232906), -- Bone Arrow
-- Crokian Warrior
(20791, 2196, 1, 1, -1, 71256), -- Recipe: Plate Gaiters
(20791, 2041, 1, 1, -1, 19395), -- War Pick Head
(20791, 1825, 1, 1, -1, 124190), -- Recipe: Oriharukon
(20791, 57, 735, 1467, 0, 700000), -- Adena
(20791, 352, 1, 1, 1, 130.421416), -- Brigandine Tunic
(20791, 1941, 1, 1, 1, 5956.874358), -- Brigandine Temper
(20791, 2377, 1, 1, 1, 208.620854), -- Mithril Scale Gaiters
(20791, 2918, 1, 1, 1, 8886.743398), -- Mithril Scale Gaiters Material
(20791, 2378, 1, 1, 1, 208.620854), -- Brigandine Gaiters
(20791, 2919, 1, 1, 1, 8886.71912), -- Brigandine Gaiters Material
(20791, 1876, 1, 1, 2, 25678.72309), -- Mithril Ore
(20791, 1880, 1, 1, 2, 12839.4079), -- Steel
(20791, 1877, 1, 1, 2, 5135.76316), -- Adamantite Nugget
(20791, 1881, 1, 1, 2, 17119.17963), -- Coarse Bone Powder
(20791, 1882, 1, 1, 2, 28531.96605), -- Leather
(20791, 2198, 1, 1, 2, 2691.64943), -- Recipe: Sage's Rag
(20791, 3020, 1, 1, 2, 713.31074), -- Recipe: Elven Long Sword
-- Farhite
(20792, 2035, 1, 1, -1, 16376), -- Tarbar Head
(20792, 2202, 1, 1, -1, 165409), -- Recipe: Assault Boots
(20792, 1903, 1, 1, -1, 269842), -- Elven Ring Piece
(20792, 57, 684, 1363, 0, 700000), -- Adena
(20792, 88, 1, 1, 1, 15.571536), -- Morning Star
(20792, 2031, 1, 1, 1, 846.382452), -- Morning Star Head
(20792, 90, 1, 1, 1, 15.571536), -- Goat Head Staff
(20792, 2032, 1, 1, 1, 772.62522), -- Goat Head Staff Head
(20792, 158, 1, 1, 1, 15.571536), -- Tarbar
(20792, 2035, 1, 1, 1, 846.382452), -- Tarbar Head
(20792, 169, 1, 1, 1, 15.571536), -- Skull Breaker
(20792, 2036, 1, 1, 1, 846.382452), -- Skull Breaker Head
(20792, 172, 1, 1, 1, 15.571536), -- Heavy Bone Club
(20792, 2037, 1, 1, 1, 846.369744), -- Heavy Bone Club Head
(20792, 1876, 1, 1, 2, 23892.20854), -- Mithril Ore
(20792, 1880, 1, 1, 2, 11946.1474), -- Steel
(20792, 1877, 1, 1, 2, 4778.45896), -- Adamantite Nugget
(20792, 1881, 1, 1, 2, 15928.16778), -- Coarse Bone Powder
(20792, 1882, 1, 1, 2, 26546.9463), -- Leather
(20792, 2198, 1, 1, 2, 2504.38658), -- Recipe: Sage's Rag
(20792, 3020, 1, 1, 2, 663.68444), -- Recipe: Elven Long Sword
-- Nos
(20793, 2037, 1, 1, -1, 17953), -- Heavy Bone Club Head
(20793, 1877, 1, 1, -1, 70938), -- Adamantite Nugget
(20793, 1881, 1, 1, -1, 236461), -- Coarse Bone Powder
(20793, 57, 740, 1478, 0, 700000), -- Adena
(20793, 93, 1, 1, 1, 42.67558), -- Winged Spear
(20793, 2033, 1, 1, 1, 2556.32442), -- Winged Spear Blade
(20793, 294, 1, 1, 1, 42.67558), -- War Pick
(20793, 2041, 1, 1, 1, 2556.32442), -- War Pick Head
(20793, 1876, 1, 1, 2, 22918.530082), -- Mithril Ore
(20793, 1880, 1, 1, 2, 11459.501788), -- Steel
(20793, 1877, 1, 1, 2, 4583.895414), -- Adamantite Nugget
(20793, 1881, 1, 1, 2, 15279.177886), -- Coarse Bone Powder
(20793, 1882, 1, 1, 2, 25464.980814), -- Leather
(20793, 2147, 1, 1, 2, 8185.290778), -- Recipe: Blacksmith's frame
(20793, 2205, 1, 1, 2, 3626.490546), -- Recipe: Chain Gaiters
(20793, 1341, 10, 30, 2, 381976.132692), -- Bone Arrow
-- Blade Stakato
(20794, 2991, 1, 1, -1, 132768), -- Recipe: Karmian Boots
(20794, 1952, 1, 1, -1, 53584), -- Salamander Skin Mail Texture
(20794, 1866, 1, 3, -1, 557627), -- Suede
(20794, 57, 678, 1356, 0, 700000), -- Adena
(20794, 225, 1, 1, 1, 60.562565), -- Mithril Dagger
(20794, 2052, 1, 1, 1, 3642.437435), -- Mithril Dagger Blade
(20794, 1866, 1, 1, 2, 80004.198474), -- Suede
(20794, 1871, 1, 1, 2, 120006.40714), -- Charcoal
(20794, 5220, 1, 1, 2, 4800.212514), -- Metal Hardener
(20794, 1885, 1, 1, 2, 10000.497452), -- High-Grade Suede
(20794, 2206, 1, 1, 2, 3166.437544), -- Recipe: Mithril Shirt
(20794, 4556, 1, 1, 2, 479.955594), -- Greater Dye of CON (Con+1 Dex-1)
(20794, 5274, 1, 1, 2, 400.291282), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
-- Blade Stakato Worker
(20795, 2161, 1, 1, -1, 153276), -- Recipe: Aquastone Ring
(20795, 2047, 1, 1, -1, 13879), -- Claymore Blade
(20795, 4469, 1, 1, -1, 9021), -- Dye of STR (Str+1 Con-1)
(20795, 57, 636, 1285, 0, 700000), -- Adena
(20795, 851, 1, 1, 1, 283.234762), -- Omen Beast's Eye Earring
(20795, 1905, 1, 1, 1, 12852.656394), -- Omen Beast's Eye Earring Gemstone
(20795, 914, 1, 1, 1, 212.41579), -- Necklace of Darkness
(20795, 1907, 1, 1, 1, 9191.331992), -- Necklace of Darkness Gem
(20795, 882, 1, 1, 1, 424.83158), -- Mithril Ring
(20795, 1906, 1, 1, 1, 18161.529482), -- Mithril Ring Wire
(20795, 1867, 1, 1, 2, 151004.48972), -- Animal Skin
(20795, 1872, 1, 1, 2, 151004.48972), -- Animal Bone
(20795, 1882, 1, 1, 2, 25167.544542), -- Leather
(20795, 1894, 1, 1, 2, 3973.966052), -- Crafted Leather
(20795, 2304, 1, 1, 2, 494.510352), -- Recipe: Heavy Doom Hammer
(20795, 736, 1, 1, 2, 56626.878028), -- Scroll of Escape
(20795, 2303, 1, 1, 2, 494.121586), -- Recipe: Skull Graver
-- Blade Stakato Warrior
(20796, 2199, 1, 1, -1, 71642), -- Recipe: Karmian Stockings
(20796, 2930, 1, 1, -1, 136873), -- Plate Helmet Design
(20796, 1905, 1, 1, -1, 165167), -- Omen Beast's Eye Earring Gemstone
(20796, 57, 671, 1364, 0, 700000), -- Adena
(20796, 396, 1, 1, 1, 232.565589), -- Salamander Skin Mail
(20796, 1952, 1, 1, 1, 13654.434411), -- Salamander Skin Mail Texture
(20796, 1868, 1, 1, 2, 170522.522904), -- Thread
(20796, 1873, 1, 1, 2, 34104.451554), -- Silver Nugget
(20796, 5549, 1, 1, 2, 8526.179172), -- Metallic Thread
(20796, 1889, 1, 1, 2, 5684.207826), -- Compound Braid
(20796, 2998, 1, 1, 2, 6410.674986), -- Recipe: Chain Shield
(20796, 737, 1, 1, 2, 8526.179172), -- Scroll of Resurrection
(20796, 4557, 1, 1, 2, 340.962324), -- Greater Dye of DEX (Dex+1 Str-1)
(20796, 3033, 1, 1, 2, 284.223648), -- Recipe: Spiritshot C
(20796, 3954, 1, 1, 2, 284.223648), -- Recipe: Blessed Spiritshot C
(20796, 6668, 1, 1, 2, 30450.374766), -- Deluxe Chest Key - Grade 4
-- Blade Stakato Drone
(20797, 4440, 1, 1, -1, 8981), -- Recipe: Knuckle Duster
(20797, 1908, 1, 1, -1, 244093), -- Moonstone Earring Wire
(20797, 2163, 1, 1, -1, 131511), -- Recipe: Earring of Protection
(20797, 57, 1015, 2079, 0, 700000), -- Adena
(20797, 397, 1, 1, 1, 209.313728), -- Mithril Shirt
(20797, 1961, 1, 1, 1, 9746.249906), -- Mithril Shirt Fabric
(20797, 2387, 1, 1, 1, 334.520624), -- Reinforced Mithril Gaiters
(20797, 2935, 1, 1, 1, 16191.915742), -- Reinforced Mithril Gaiters Fragment
(20797, 1869, 1, 1, 2, 110747.736582), -- Iron Ore
(20797, 1864, 1, 1, 2, 221495.473164), -- Stem
(20797, 1880, 1, 1, 2, 11074.702548), -- Steel
(20797, 5550, 1, 1, 2, 1476.603303), -- Durable Metal Plate
(20797, 2220, 1, 1, 2, 2292.948399), -- Recipe: Rind Leather Armor
(20797, 2225, 1, 1, 2, 2407.435821), -- Recipe: Demon's Stockings
(20797, 2321, 1, 1, 2, 385.772835), -- Recipe: Stiletto
(20797, 8723, 1, 1, 2, 4429.809909), -- Life Stone - Level 46
(20797, 8733, 1, 1, 2, 1107.541365), -- Mid-Grade Life Stone - Level 46
(20797, 8743, 1, 1, 2, 110.576361), -- High-Grade Life Stone - Level 46
(20797, 8753, 1, 1, 2, 22.399713), -- Top-Grade Life Stone - Level 46
-- Water Giant
(20798, 4042, 1, 1, -1, 34793), -- Enria
(20798, 4043, 1, 1, -1, 69587), -- Asofe
(20798, 1908, 1, 1, -1, 197690), -- Moonstone Earring Wire
(20798, 57, 826, 1677, 0, 700000), -- Adena
(20798, 71, 1, 1, 1, 27.97965), -- Flamberge
(20798, 2059, 1, 1, 1, 1831.857492), -- Flamberge Blade
(20798, 72, 1, 1, 1, 27.97965), -- Stormbringer
(20798, 2060, 1, 1, 1, 1958.183208), -- Stormbringer Blade
(20798, 1869, 1, 1, 2, 89694.045238), -- Iron Ore
(20798, 1864, 1, 1, 2, 179388.090476), -- Stem
(20798, 1880, 1, 1, 2, 8969.346932), -- Steel
(20798, 5550, 1, 1, 2, 1195.893727), -- Durable Metal Plate
(20798, 2220, 1, 1, 2, 1857.047591), -- Recipe: Rind Leather Armor
(20798, 2225, 1, 1, 2, 1949.770389), -- Recipe: Demon's Stockings
(20798, 2321, 1, 1, 2, 312.435515), -- Recipe: Stiletto
(20798, 8723, 1, 1, 2, 3587.681181), -- Life Stone - Level 46
(20798, 8733, 1, 1, 2, 896.992285), -- Mid-Grade Life Stone - Level 46
(20798, 8743, 1, 1, 2, 89.555249), -- High-Grade Life Stone - Level 46
(20798, 8753, 1, 1, 2, 18.141417), -- Top-Grade Life Stone - Level 46
-- Queen Undine Lad
(20799, 2317, 1, 1, -1, 7323), -- Recipe: Bec de Corbin
(20799, 2065, 1, 1, -1, 16244), -- Skull Graver Head
(20799, 2164, 1, 1, -1, 161662), -- Recipe: Ring of Protection
(20799, 57, 828, 1693, 0, 700000), -- Adena
(20799, 354, 1, 1, 1, 127.798696), -- Chain Mail Shirt
(20799, 1959, 1, 1, 1, 6688.228012), -- Chain Mail Shirt Material
(20799, 381, 1, 1, 1, 204.444912), -- Chain Gaiters
(20799, 1960, 1, 1, 1, 13605.52838), -- Chain Gaiters Part
(20799, 1871, 1, 1, 2, 90295.964824), -- Charcoal
(20799, 1866, 1, 1, 2, 60197.364344), -- Suede
(20799, 1877, 1, 1, 2, 3611.766704), -- Adamantite Nugget
(20799, 4041, 1, 1, 2, 785.223504), -- Mold Hardener
(20799, 4040, 1, 1, 2, 1805.883352), -- Mold Lubricant
(20799, 2230, 1, 1, 2, 1749.84264), -- Recipe: Theca Leather Gaiters
(20799, 2326, 1, 1, 2, 314.677584), -- Recipe: Horn of Glory
(20799, 8723, 1, 1, 2, 3611.766704), -- Life Stone - Level 46
(20799, 8733, 1, 1, 2, 903.023368), -- Mid-Grade Life Stone - Level 46
(20799, 8743, 1, 1, 2, 90.351352), -- High-Grade Life Stone - Level 46
(20799, 8753, 1, 1, 2, 18.135624), -- Top-Grade Life Stone - Level 46
-- Eva's Seeker
(20800, 2223, 1, 1, -1, 76282), -- Recipe: Tower Shield
(20800, 1966, 1, 1, -1, 71854), -- Plated Leather Fragment
(20800, 1911, 1, 1, -1, 146379), -- Earring of Protection Gemstone
(20800, 57, 777, 1585, 0, 700000), -- Adena
(20800, 355, 1, 1, 1, 87.99518), -- Dwarven Chain Mail Shirt
(20800, 1968, 1, 1, 1, 5253.18792), -- Dwarven Chain Mail Shirt Material
(20800, 382, 1, 1, 1, 140.792288), -- Dwarven Chain Gaiters
(20800, 1969, 1, 1, 1, 8332.024612), -- Dwarven Chain Gaiters Material
(20800, 1872, 1, 1, 2, 105697.749824), -- Animal Bone
(20800, 1867, 1, 1, 2, 105697.749824), -- Animal Skin
(20800, 1881, 1, 1, 2, 10569.728034), -- Coarse Bone Powder
(20800, 1875, 1, 1, 2, 5284.981388), -- Stone of Purity
(20800, 4041, 1, 1, 2, 689.437254), -- Mold Hardener
(20800, 2226, 1, 1, 2, 3235.683728), -- Recipe: Mithril Gauntlets
(20800, 2333, 1, 1, 2, 184.27247), -- Recipe: Sword of Nightmare
(20800, 8724, 1, 1, 2, 2642.490694), -- Life Stone - Level 49
(20800, 8734, 1, 1, 2, 660.563988), -- Mid-Grade Life Stone - Level 49
(20800, 8744, 1, 1, 2, 65.962502), -- High-Grade Life Stone - Level 49
(20800, 8754, 1, 1, 2, 13.380294), -- Top-Grade Life Stone - Level 49
-- Theeder Piker
(20801, 2946, 1, 1, -1, 132781), -- Plate Leather Gloves Design
(20801, 2330, 1, 1, -1, 5524), -- Recipe: Homunkulus's Sword
(20801, 951, 1, 1, -1, 4319), -- Scroll: Enchant Weapon (C-Grade)
(20801, 57, 939, 1909, 0, 700000), -- Adena
(20801, 4233, 1, 1, 1, 47.634132), -- Knuckle Duster
(20801, 4438, 1, 1, 1, 3753.365868), -- Knuckle Duster Edge
(20801, 1873, 1, 1, 2, 30071.557296), -- Silver Nugget
(20801, 1868, 1, 1, 2, 150357.519144), -- Thread
(20801, 1876, 1, 1, 2, 15035.778648), -- Mithril Ore
(20801, 1895, 1, 1, 2, 21479.645592), -- Metallic Fiber
(20801, 4042, 1, 1, 2, 1253.003832), -- Enria
(20801, 2347, 1, 1, 2, 174.837744), -- Recipe: Akat Long Bow
(20801, 2351, 1, 1, 2, 157.193568), -- Recipe: Scorpion
(20801, 3010, 1, 1, 2, 2042.981712), -- Recipe: Composite Helmet
(20801, 6668, 1, 1, 2, 26849.623824), -- Deluxe Chest Key - Grade 4
(20801, 8724, 1, 1, 2, 2506.007664), -- Life Stone - Level 49
(20801, 8734, 1, 1, 2, 626.368248), -- Mid-Grade Life Stone - Level 49
(20801, 8744, 1, 1, 2, 62.556624), -- High-Grade Life Stone - Level 49
(20801, 8754, 1, 1, 2, 12.564792), -- Top-Grade Life Stone - Level 49
(20801, 1539, 1, 1, 2, 16706.361312), -- Greater Healing Potion
-- Theeder Mage
(20802, 2333, 1, 1, -1, 5213), -- Recipe: Sword of Nightmare
(20802, 1975, 1, 1, -1, 73621), -- Rind Leather Armor Design
(20802, 4039, 1, 1, -1, 74713), -- Mold Glue
(20802, 57, 885, 1804, 0, 700000), -- Adena
(20802, 325, 1, 1, 1, 44.93792), -- Horn of Glory
(20802, 2088, 1, 1, 1, 3499.06208), -- Horn of Glory Fragment
(20802, 1894, 1, 1, 2, 3167.794125), -- Crafted Leather
(20802, 4039, 1, 1, 2, 3009.373875), -- Mold Glue
(20802, 4041, 1, 1, 2, 784.974375), -- Mold Hardener
(20802, 4044, 1, 1, 2, 3009.373875), -- Thons
(20802, 737, 1, 1, 2, 9028.121625), -- Scroll of Resurrection
(20802, 2334, 1, 1, 2, 209.937375), -- Recipe: Sword of Whispering Death
(20802, 8724, 1, 1, 2, 3009.373875), -- Life Stone - Level 49
(20802, 8734, 1, 1, 2, 752.394375), -- Mid-Grade Life Stone - Level 49
(20802, 8744, 1, 1, 2, 75.137625), -- High-Grade Life Stone - Level 49
(20802, 8754, 1, 1, 2, 15.06825), -- Top-Grade Life Stone - Level 49
(20802, 1342, 10, 30, 2, 180563.450625), -- Steel Arrow
-- Doll Master
(20803, 4044, 1, 1, -1, 140295), -- Thons
(20803, 4042, 1, 1, -1, 70147), -- Enria
(20803, 4043, 1, 1, -1, 140295), -- Asofe
(20803, 57, 1665, 3384, 0, 700000), -- Adena
(20803, 231, 1, 1, 1, 26.339632), -- Grace Dagger
(20803, 2106, 1, 1, 1, 2371.660368), -- Grace Dagger Edge
(20803, 233, 1, 1, 1, 26.339632), -- Dark Screamer
(20803, 2107, 1, 1, 1, 2371.660368), -- Dark Screamer Edge
(20803, 1895, 1, 1, 2, 45208.083492), -- Metallic Fiber
(20803, 4040, 1, 1, 2, 3164.556486), -- Mold Lubricant
(20803, 4042, 1, 1, 2, 2637.141546), -- Enria
(20803, 4043, 1, 1, 2, 5274.283092), -- Asofe
(20803, 2356, 1, 1, 2, 258.092406), -- Recipe: Demon's Staff
(20803, 3014, 1, 1, 2, 4419.790674), -- Recipe: Full Plate Boots
(20803, 2360, 1, 1, 2, 258.092406), -- Recipe: Orcish Poleaxe
(20803, 8725, 1, 1, 2, 4395.258192), -- Life Stone - Level 52
(20803, 8735, 1, 1, 2, 1098.814548), -- Mid-Grade Life Stone - Level 52
(20803, 8745, 1, 1, 2, 109.894824), -- High-Grade Life Stone - Level 52
(20803, 8755, 1, 1, 2, 21.992334), -- Top-Grade Life Stone - Level 52
-- Crokian Lad
(20804, 2160, 1, 1, -1, 132104), -- Recipe: Moonstone Earring
(20804, 1953, 1, 1, -1, 65586), -- Sage's Rag Lining
(20804, 4470, 1, 1, -1, 11701), -- Dye of STR (Str+1 Dex-1)
(20804, 57, 830, 1660, 0, 700000), -- Adena
(20804, 630, 1, 1, 1, 433.844237), -- Square Shield
(20804, 1956, 1, 1, 1, 19450.782085), -- Square Shield Fragment
(20804, 2494, 1, 1, 1, 433.844237), -- Plate Shield
(20804, 2934, 1, 1, 1, 19450.782085), -- Plate Shield Fragment
(20804, 2412, 1, 1, 1, 303.814906), -- Plate Helmet
(20804, 2930, 1, 1, 1, 13813.93245), -- Plate Helmet Design
(20804, 1864, 1, 3, 2, 128526.768747), -- Stem
(20804, 1869, 1, 1, 2, 128526.768747), -- Iron Ore
(20804, 1878, 1, 1, 2, 51410.626969), -- Braided Hemp
(20804, 1884, 1, 1, 2, 79093.551017), -- Cord
(20804, 2207, 1, 1, 2, 3391.109878), -- Recipe: Karmian Tunic
(20804, 2298, 1, 1, 2, 561.292706), -- Recipe: Stormbringer
(20804, 5274, 1, 1, 2, 428.418536), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20804, 735, 1, 1, 2, 10710.4634), -- Alacrity Potion
-- Dailaon Lad
(20805, 2162, 1, 1, -1, 107039), -- Recipe: Aquastone Necklace
(20805, 2053, 1, 1, -1, 18321), -- Scallop Jamadhr Edge
(20805, 1905, 1, 1, -1, 215536), -- Omen Beast's Eye Earring Gemstone
(20805, 57, 892, 1803, 0, 700000), -- Adena
(20805, 159, 1, 1, 1, 16.045059), -- Bonebreaker
(20805, 2048, 1, 1, 1, 919.958238), -- Bonebreaker Head
(20805, 187, 1, 1, 1, 16.045059), -- Atuba Hammer
(20805, 2049, 1, 1, 1, 919.958238), -- Atuba Hammer Head
(20805, 188, 1, 1, 1, 16.045059), -- Ghost Staff
(20805, 2050, 1, 1, 1, 975.452391), -- Ghost Staff Head
(20805, 189, 1, 1, 1, 16.045059), -- Staff of Life
(20805, 2051, 1, 1, 1, 975.452391), -- Staff of Life Shaft
(20805, 190, 1, 1, 1, 16.045059), -- Atuba Mace
(20805, 2058, 1, 1, 1, 919.953447), -- Atuba Mace Head
(20805, 1895, 1, 1, 2, 63578.441477), -- Metallic Fiber
(20805, 2305, 1, 1, 2, 971.716607), -- Recipe: Crystal Staff
(20805, 2205, 1, 1, 2, 7041.871309), -- Recipe: Chain Gaiters
(20805, 5164, 1, 1, 2, 741.729002), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(20805, 6668, 1, 1, 2, 79473.241605), -- Deluxe Chest Key - Grade 4
-- Crokian Lad Warrior
(20806, 2204, 1, 1, -1, 42364), -- Recipe: Chain Mail Shirt
(20806, 2934, 1, 1, -1, 242834), -- Plate Shield Fragment
(20806, 1805, 1, 1, -1, 7131), -- Recipe: Soulshot (C-Grade)
(20806, 57, 846, 1718, 0, 700000), -- Adena
(20806, 70, 1, 1, 1, 38.730464), -- Claymore
(20806, 2047, 1, 1, 1, 2361.242336), -- Claymore Blade
(20806, 2499, 1, 1, 1, 38.730464), -- Elven Long Sword
(20806, 2967, 1, 1, 1, 2329.296736), -- Elven Long Sword Blade
(20806, 1865, 1, 1, 2, 153470.305536), -- Varnish
(20806, 1870, 1, 1, 2, 153470.305536), -- Coal
(20806, 1879, 1, 1, 2, 25578.384256), -- Cokes
(20806, 1875, 1, 1, 2, 10231.282856), -- Stone of Purity
(20806, 2999, 1, 1, 2, 10300.003864), -- Recipe: Plated Leather Gloves
(20806, 5159, 1, 1, 2, 511.511008), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20806, 2300, 1, 1, 2, 670.206944), -- Recipe: Scythe
-- Farhite Lad
(20807, 2164, 1, 1, -1, 172878), -- Recipe: Ring of Protection
(20807, 1910, 1, 1, -1, 169233), -- Aquastone Necklace Chain
(20807, 1908, 1, 1, -1, 212824), -- Moonstone Earring Wire
(20807, 57, 885, 1813, 0, 700000), -- Adena
(20807, 439, 1, 1, 1, 182.50336), -- Karmian Tunic
(20807, 1962, 1, 1, 1, 8497.88197), -- Karmian Tunic Pattern
(20807, 471, 1, 1, 1, 291.67288), -- Karmian Stockings
(20807, 1954, 1, 1, 1, 14117.94179), -- Karmian Stocking Design
(20807, 1866, 1, 1, 2, 54469.790136), -- Suede
(20807, 1871, 1, 1, 2, 81704.603376), -- Charcoal
(20807, 5220, 1, 1, 2, 3268.21032), -- Metal Hardener
(20807, 1885, 1, 1, 2, 6808.744224), -- High-Grade Suede
(20807, 2221, 1, 1, 2, 2705.397336), -- Recipe: Rind Leather Gaiters
(20807, 737, 1, 1, 2, 8170.5258), -- Scroll of Resurrection
(20807, 2225, 1, 1, 2, 1776.158568), -- Recipe: Demon's Stockings
(20807, 2321, 1, 1, 2, 284.76144), -- Recipe: Stiletto
(20807, 2316, 1, 1, 2, 284.76144), -- Recipe: Katana
(20807, 8723, 1, 1, 2, 3268.21032), -- Life Stone - Level 46
(20807, 8733, 1, 1, 2, 816.970752), -- Mid-Grade Life Stone - Level 46
(20807, 8743, 1, 1, 2, 81.664344), -- High-Grade Life Stone - Level 46
(20807, 8753, 1, 1, 2, 16.201944), -- Top-Grade Life Stone - Level 46
-- Nos Lad
(20808, 1954, 1, 1, -1, 148174), -- Karmian Stocking Design
(20808, 2163, 1, 1, -1, 142201), -- Recipe: Earring of Protection
(20808, 1908, 1, 1, -1, 263934), -- Moonstone Earring Wire
(20808, 57, 1102, 2239, 0, 700000), -- Adena
(20808, 439, 1, 1, 1, 226.33104), -- Karmian Tunic
(20808, 1962, 1, 1, 1, 10538.624955), -- Karmian Tunic Pattern
(20808, 471, 1, 1, 1, 361.71732), -- Karmian Stockings
(20808, 1954, 1, 1, 1, 17508.326685), -- Karmian Stocking Design
(20808, 1894, 1, 1, 2, 4621.920054), -- Crafted Leather
(20808, 4039, 1, 1, 2, 4390.830931), -- Mold Glue
(20808, 4041, 1, 1, 2, 1145.401253), -- Mold Hardener
(20808, 4044, 1, 1, 2, 4390.830931), -- Thons
(20808, 2324, 1, 1, 2, 458.944787), -- Recipe: Noble Elven Bow
(20808, 6668, 1, 1, 2, 47044.695743), -- Deluxe Chest Key - Grade 4
(20808, 8723, 1, 1, 2, 5269.024636), -- Life Stone - Level 46
(20808, 8733, 1, 1, 2, 1317.256159), -- Mid-Grade Life Stone - Level 46
(20808, 8743, 1, 1, 2, 131.746255), -- High-Grade Life Stone - Level 46
(20808, 8753, 1, 1, 2, 26.349251), -- Top-Grade Life Stone - Level 46
-- Ghost of the Tower
(20809, 4439, 1, 1, -1, 340912), -- Avadon Shield Fragment
(20809, 4973, 1, 1, -1, 53498), -- Recipe: Earring of Black Ore (70%)
(20809, 4049, 1, 1, -1, 259282), -- Adamantite Earring Gemstone
(20809, 57, 1955, 3974, 0, 700000), -- Adena
(20809, 357, 1, 1, 1, 22.8717), -- Zubei's Breastplate
(20809, 4056, 1, 1, 1, 3304.520158), -- Zubei's Breastplate Part
(20809, 2376, 1, 1, 1, 22.8717), -- Avadon Breastplate
(20809, 4064, 1, 1, 1, 3304.520158), -- Avadon Breastplate Part
(20809, 383, 1, 1, 1, 36.59472), -- Zubei's Gaiters
(20809, 4057, 1, 1, 1, 5106.99648), -- Zubei's Gaiter Material
(20809, 2379, 1, 1, 1, 36.59472), -- Avadon Gaiters
(20809, 4065, 1, 1, 1, 5107.030364), -- Avadon Gaiters Material
(20809, 1868, 1, 1, 2, 243358.145793), -- Thread
(20809, 1873, 1, 1, 2, 48671.757603), -- Silver Nugget
(20809, 5549, 1, 1, 2, 12167.859123), -- Metallic Thread
(20809, 1889, 1, 1, 2, 8111.906082), -- Compound Braid
(20809, 4044, 1, 1, 2, 4055.953041), -- Thons
(20809, 4158, 1, 1, 2, 258.494355), -- Recipe: Doom Plate Armor (100%)
(20809, 4999, 1, 1, 2, 1513.396143), -- Recipe: Sealed Doom Boots (60%)
(20809, 4981, 1, 1, 2, 377.947647), -- Recipe: Blue Wolf Breastplate (60%)
(20809, 8728, 1, 1, 2, 2028.137076), -- Life Stone - Level 61
(20809, 8738, 1, 1, 2, 507.034269), -- Mid-Grade Life Stone - Level 61
(20809, 8748, 1, 1, 2, 50.735538), -- High-Grade Life Stone - Level 61
(20809, 8758, 1, 1, 2, 9.63333), -- Top-Grade Life Stone - Level 61
-- Hallate's Seer
(20810, 4109, 1, 1, -1, 27849), -- Kris Edge
(20810, 4974, 1, 1, -1, 80247), -- Recipe: Ring of Black Ore (70%)
(20810, 947, 1, 1, -1, 1977), -- Scroll: Enchant Weapon (B-Grade)
(20810, 57, 1955, 3974, 0, 700000), -- Adena
(20810, 91, 1, 1, 1, 10.92896), -- Heavy War Axe
(20810, 4105, 1, 1, 1, 2088.70585), -- Heavy War Axe Head
(20810, 92, 1, 1, 1, 10.92896), -- Sprite's Staff
(20810, 4106, 1, 1, 1, 2054.43623), -- Sprite's Staff Head
(20810, 1874, 1, 1, 2, 8849.375712), -- Oriharukon Ore
(20810, 1878, 1, 1, 2, 53096.577024), -- Braided Hemp
(20810, 1884, 1, 1, 2, 81687.078816), -- Cord
(20810, 1889, 1, 1, 2, 8849.375712), -- Compound Braid
(20810, 5220, 1, 1, 2, 5309.593152), -- Metal Hardener
(20810, 4159, 1, 1, 2, 376.00608), -- Recipe: Blue Wolf Leather Armor (100%)
(20810, 8728, 1, 1, 2, 2212.303584), -- Life Stone - Level 61
(20810, 8738, 1, 1, 2, 553.035552), -- Mid-Grade Life Stone - Level 61
(20810, 8748, 1, 1, 2, 55.351968), -- High-Grade Life Stone - Level 61
(20810, 8758, 1, 1, 2, 11.29632), -- Top-Grade Life Stone - Level 61
-- Ghastly Warrior
(20811, 947, 1, 1, -1, 2337), -- Scroll: Enchant Weapon (B-Grade)
(20811, 1875, 1, 1, -1, 389481), -- Stone of Purity
(20811, 4040, 1, 1, -1, 116844), -- Mold Lubricant
(20811, 57, 2315, 4695, 0, 700000), -- Adena
(20811, 78, 1, 1, 1, 8.610736), -- Great Sword
(20811, 4104, 1, 1, 1, 1645.721392), -- Great Sword Blade
(20811, 142, 1, 1, 1, 8.610736), -- Keshanberk
(20811, 4107, 1, 1, 1, 1620.2232), -- Keshanberk Blade
(20811, 148, 1, 1, 1, 8.610736), -- Sword of Valhalla
(20811, 4108, 1, 1, 1, 1620.2232), -- Sword of Valhalla Blade
(20811, 1865, 1, 1, 2, 132746.29155), -- Varnish
(20811, 1870, 1, 1, 2, 132746.29155), -- Coal
(20811, 1879, 1, 1, 2, 22124.327562), -- Cokes
(20811, 1875, 1, 1, 2, 8849.861496), -- Stone of Purity
(20811, 4040, 1, 1, 2, 2655.08892), -- Mold Lubricant
(20811, 4619, 1, 1, 2, 182.985858), -- Greater Dye of INT (Int+4 Men-4)
(20811, 4401, 1, 1, 2, 265.508892), -- Green Dimensional Stone
(20811, 4167, 1, 1, 2, 1651.113036), -- Recipe: Sealed Blue Wolf Boots (100%)
(20811, 6670, 1, 1, 2, 22124.327562), -- Deluxe Chest Key - Grade 6
(20811, 8728, 1, 1, 2, 2212.465374), -- Life Stone - Level 61
(20811, 8738, 1, 1, 2, 553.197888), -- Mid-Grade Life Stone - Level 61
(20811, 8748, 1, 1, 2, 55.45026), -- High-Grade Life Stone - Level 61
(20811, 8758, 1, 1, 2, 11.090052), -- Top-Grade Life Stone - Level 61
-- Archer of Despair
(20812, 1875, 1, 1, -1, 384494), -- Stone of Purity
(20812, 4617, 1, 1, -1, 7955), -- Greater Dye of DEX (Dex+4 Str-4)
(20812, 4613, 1, 1, -1, 7955), -- Greater Dye of STR (Str+4 Con-4)
(20812, 57, 2285, 4635, 0, 700000), -- Adena
(20812, 284, 1, 1, 1, 25.50048), -- Dark Elven Long Bow
(20812, 4112, 1, 1, 1, 4822.49952), -- Dark Elven Longbow Shaft
(20812, 1872, 1, 1, 2, 227147.342492), -- Animal Bone
(20812, 1867, 1, 1, 2, 227147.342492), -- Animal Skin
(20812, 1881, 1, 1, 2, 22714.931736), -- Coarse Bone Powder
(20812, 1875, 1, 1, 2, 11357.465868), -- Stone of Purity
(20812, 4041, 1, 1, 2, 1481.151), -- Mold Hardener
(20812, 4620, 1, 1, 2, 235.009292), -- Greater Dye of INT (Int+4 Wit-4)
(20812, 8728, 1, 1, 2, 2839.366467), -- Life Stone - Level 61
(20812, 8738, 1, 1, 2, 709.965046), -- Mid-Grade Life Stone - Level 61
(20812, 8748, 1, 1, 2, 71.095248), -- High-Grade Life Stone - Level 61
(20812, 8758, 1, 1, 2, 13.330359), -- Top-Grade Life Stone - Level 61
-- Crendion
(20813, 4982, 1, 1, -1, 26129), -- Recipe: Blue Wolf Gaiters (60%)
(20813, 4052, 1, 1, -1, 185940), -- Earring of Black Ore Piece
(20813, 5230, 1, 1, -1, 7003), -- Recipe: Mithril Arrow (100%)
(20813, 57, 2083, 4219, 0, 700000), -- Adena
(20813, 2398, 1, 1, 1, 20.885095), -- Blue Wolf Tunic
(20813, 4084, 1, 1, 1, 3371.22768), -- Blue Wolf Tunic Fabric
(20813, 2399, 1, 1, 1, 20.885095), -- Tunic of Doom
(20813, 4085, 1, 1, 1, 3371.22768), -- Tunic of Doom Pattern
(20813, 2403, 1, 1, 1, 33.44168), -- Blue Wolf Stockings
(20813, 4086, 1, 1, 1, 4551.92959), -- Blue Wolf Stockings Pattern
(20813, 2404, 1, 1, 1, 33.44168), -- Stockings of Doom
(20813, 4087, 1, 1, 1, 4551.9615), -- Stockings of Doom Pattern
(20813, 1872, 1, 1, 2, 206843.26846), -- Animal Bone
(20813, 1867, 1, 1, 2, 206843.26846), -- Animal Skin
(20813, 1881, 1, 1, 2, 20684.50668), -- Coarse Bone Powder
(20813, 1875, 1, 1, 2, 10342.25334), -- Stone of Purity
(20813, 4041, 1, 1, 2, 1348.755), -- Mold Hardener
(20813, 4620, 1, 1, 2, 214.00246), -- Greater Dye of INT (Int+4 Wit-4)
(20813, 8728, 1, 1, 2, 2585.563335), -- Life Stone - Level 61
(20813, 8738, 1, 1, 2, 646.50323), -- Mid-Grade Life Stone - Level 61
(20813, 8748, 1, 1, 2, 64.74024), -- High-Grade Life Stone - Level 61
(20813, 8758, 1, 1, 2, 12.138795), -- Top-Grade Life Stone - Level 61
-- Blader of Despair
(20814, 948, 1, 1, -1, 15160), -- Scroll: Enchant Armor (B-Grade)
(20814, 4053, 1, 1, -1, 259927), -- Ring of Black Ore Gemstone
(20814, 5230, 1, 1, -1, 8085), -- Recipe: Mithril Arrow (100%)
(20814, 57, 2405, 4872, 0, 700000), -- Adena
(20814, 601, 1, 1, 1, 72.368139), -- Sealed Doom Boots
(20814, 4099, 1, 1, 1, 10051.881861), -- Sealed Doom Boots Part
(20814, 2439, 1, 1, 1, 72.368139), -- Sealed Blue Wolf Boots
(20814, 4090, 1, 1, 1, 10051.881861), -- Sealed Blue Wolf Boots Design
(20814, 2475, 1, 1, 1, 72.368139), -- Sealed Doom Gloves
(20814, 4091, 1, 1, 1, 10051.881861), -- Sealed Doom Gloves Part
(20814, 2487, 1, 1, 1, 72.368139), -- Sealed Blue Wolf Gloves
(20814, 4096, 1, 1, 1, 10051.881861), -- Sealed Blue Wolf Gloves Fabric
(20814, 1871, 1, 1, 2, 162840.379804), -- Charcoal
(20814, 1866, 1, 1, 2, 108560.157567), -- Suede
(20814, 1877, 1, 1, 2, 6513.649621), -- Adamantite Nugget
(20814, 4041, 1, 1, 2, 1415.886045), -- Mold Hardener
(20814, 4040, 1, 1, 2, 3256.681357), -- Mold Lubricant
(20814, 4975, 1, 1, 2, 1323.788898), -- Recipe: Necklace of Black Ore (70%)
(20814, 5276, 1, 1, 2, 217.188599), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20814, 8729, 1, 1, 2, 2171.312176), -- Life Stone - Level 64
(20814, 8739, 1, 1, 2, 542.828044), -- Mid-Grade Life Stone - Level 64
(20814, 8749, 1, 1, 2, 54.225423), -- High-Grade Life Stone - Level 64
(20814, 8759, 1, 1, 2, 10.902466), -- Top-Grade Life Stone - Level 64
-- Hound Dog of Hallate
(20815, 4984, 1, 1, -1, 21315), -- Recipe: Blue Wolf Leather Armor (60%)
(20815, 4054, 1, 1, -1, 148200), -- Necklace of Black Ore Beads
(20815, 4052, 1, 1, -1, 266388), -- Earring of Black Ore Piece
(20815, 57, 2984, 6042, 0, 700000), -- Adena
(20815, 2391, 1, 1, 1, 36.831996), -- Blue Wolf Leather Armor
(20815, 4082, 1, 1, 1, 6278.668004), -- Blue Wolf Leather Armor Texture
(20815, 2392, 1, 1, 1, 36.831996), -- Leather Armor of Doom
(20815, 4083, 1, 1, 1, 6278.668004), -- Leather Armor of Doom Design
(20815, 1870, 1, 1, 2, 202046.298342), -- Coal
(20815, 1865, 1, 1, 2, 202046.298342), -- Varnish
(20815, 1874, 1, 1, 2, 13469.971767), -- Oriharukon Ore
(20815, 4043, 1, 1, 2, 6734.751729), -- Asofe
(20815, 4039, 1, 1, 2, 6734.751729), -- Mold Glue
(20815, 5000, 1, 1, 2, 154.073661), -- Recipe: Sword of Damascus (60%)
(20815, 6670, 1, 1, 2, 33674.226954), -- Deluxe Chest Key - Grade 6
(20815, 8729, 1, 1, 2, 2694.181677), -- Life Stone - Level 64
(20815, 8739, 1, 1, 2, 673.428342), -- Mid-Grade Life Stone - Level 64
(20815, 8749, 1, 1, 2, 67.436496), -- High-Grade Life Stone - Level 64
(20815, 8759, 1, 1, 2, 13.580961), -- Top-Grade Life Stone - Level 64
-- Hallate's Royal Guard
(20816, 947, 1, 1, -1, 2511), -- Scroll: Enchant Weapon (B-Grade)
(20816, 4039, 1, 1, -1, 209252), -- Mold Glue
(20816, 5230, 1, 1, -1, 8370), -- Recipe: Mithril Arrow (100%)
(20816, 57, 2490, 5041, 0, 700000), -- Adena
(20816, 2391, 1, 1, 1, 30.731724), -- Blue Wolf Leather Armor
(20816, 4082, 1, 1, 1, 5238.768276), -- Blue Wolf Leather Armor Texture
(20816, 2392, 1, 1, 1, 30.731724), -- Leather Armor of Doom
(20816, 4083, 1, 1, 1, 5238.768276), -- Leather Armor of Doom Design
(20816, 1864, 1, 3, 2, 154524.632885), -- Stem
(20816, 1869, 1, 1, 2, 154524.632885), -- Iron Ore
(20816, 1878, 1, 1, 2, 61809.853154), -- Braided Hemp
(20816, 1884, 1, 1, 2, 95092.337207), -- Cord
(20816, 4039, 1, 1, 2, 5150.742034), -- Mold Glue
(20816, 5001, 1, 1, 2, 118.118877), -- Recipe: Lance (60%)
(20816, 4402, 1, 1, 2, 308.816823), -- Blue Dimensional Stone
(20816, 5276, 1, 1, 2, 205.877882), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20816, 8729, 1, 1, 2, 2060.201939), -- Life Stone - Level 64
(20816, 8739, 1, 1, 2, 515.169078), -- Mid-Grade Life Stone - Level 64
(20816, 8749, 1, 1, 2, 51.706657), -- High-Grade Life Stone - Level 64
(20816, 8759, 1, 1, 2, 10.910579), -- Top-Grade Life Stone - Level 64
-- Corrupt Sage
(20817, 4040, 1, 1, -1, 121827), -- Mold Lubricant
(20817, 4053, 1, 1, -1, 261096), -- Ring of Black Ore Gemstone
(20817, 5230, 1, 1, -1, 8122), -- Recipe: Mithril Arrow (100%)
(20817, 57, 2418, 4891, 0, 700000), -- Adena
(20817, 268, 1, 1, 1, 17.829735), -- Bellion Cestus
(20817, 4120, 1, 1, 1, 3931.170265), -- Bellion Cestus Edge
(20817, 1865, 1, 1, 2, 163572.416002), -- Varnish
(20817, 1870, 1, 1, 2, 163572.416002), -- Coal
(20817, 1879, 1, 1, 2, 27262.006858), -- Cokes
(20817, 1875, 1, 1, 2, 10904.877714), -- Stone of Purity
(20817, 4040, 1, 1, 2, 3271.350858), -- Mold Lubricant
(20817, 4174, 1, 1, 2, 3151.772432), -- Recipe: Sealed Zubei's Boots (100%)
(20817, 4402, 1, 1, 2, 327.247542), -- Blue Dimensional Stone
(20817, 8729, 1, 1, 2, 2180.900572), -- Life Stone - Level 64
(20817, 8739, 1, 1, 2, 545.41257), -- Mid-Grade Life Stone - Level 64
(20817, 8749, 1, 1, 2, 54.35383), -- High-Grade Life Stone - Level 64
(20817, 8759, 1, 1, 2, 11.24562), -- Top-Grade Life Stone - Level 64
-- Hallate's Warrior
(20818, 4620, 1, 1, -1, 8386), -- Greater Dye of INT (Int+4 Wit-4)
(20818, 4105, 1, 1, -1, 34790), -- Heavy War Axe Head
(20818, 4077, 1, 1, -1, 273487), -- Doom Shield Fragment
(20818, 57, 2414, 4882, 0, 700000), -- Adena
(20818, 287, 1, 1, 1, 17.79384), -- Bow of Peril
(20818, 4121, 1, 1, 1, 3910.20616), -- Bow of Peril Shaft
(20818, 1866, 1, 1, 2, 92093.780216), -- Suede
(20818, 1871, 1, 1, 2, 138140.670324), -- Charcoal
(20818, 5220, 1, 1, 2, 5525.636983), -- Metal Hardener
(20818, 1885, 1, 1, 2, 11511.722527), -- High-Grade Suede
(20818, 4041, 1, 1, 2, 1201.335975), -- Mold Hardener
(20818, 4958, 1, 1, 2, 2661.753719), -- Recipe: Sealed Zubei's Boots (60%)
(20818, 4401, 1, 1, 2, 276.370837), -- Green Dimensional Stone
(20818, 5276, 1, 1, 2, 184.077724), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20818, 5416, 1, 1, 2, 298.236423), -- Recipe: Sealed Dark Crystal Breastplate(60%)
(20818, 8729, 1, 1, 2, 1841.794244), -- Life Stone - Level 64
(20818, 8739, 1, 1, 2, 460.448561), -- Mid-Grade Life Stone - Level 64
(20818, 8749, 1, 1, 2, 46.019431), -- High-Grade Life Stone - Level 64
(20818, 8759, 1, 1, 2, 9.153036), -- Top-Grade Life Stone - Level 64
-- Archer of Abyss
(20819, 4053, 1, 1, -1, 259498), -- Ring of Black Ore Gemstone
(20819, 5230, 1, 1, -1, 8072), -- Recipe: Mithril Arrow (100%)
(20819, 4078, 1, 1, -1, 88433), -- Blue Wolf Breastplate Part
(20819, 57, 2399, 4864, 0, 700000), -- Adena
(20819, 171, 1, 1, 1, 5.907392), -- Deadman's Glory
(20819, 4116, 1, 1, 1, 1302.240608), -- Deadman's Glory Stone
(20819, 175, 1, 1, 1, 5.907392), -- Art of Battle Axe
(20819, 4117, 1, 1, 1, 1302.240608), -- Art of Battle Axe Blade
(20819, 210, 1, 1, 1, 5.907392), -- Staff of Evil Spirits
(20819, 4118, 1, 1, 1, 1233.796608), -- Evil Spirit Head
(20819, 1874, 1, 1, 2, 9934.89608), -- Oriharukon Ore
(20819, 1878, 1, 1, 2, 59609.918088), -- Braided Hemp
(20819, 1884, 1, 1, 2, 91707.413528), -- Cord
(20819, 1889, 1, 1, 2, 9934.89608), -- Compound Braid
(20819, 5220, 1, 1, 2, 5960.937648), -- Metal Hardener
(20819, 4159, 1, 1, 2, 422.093168), -- Recipe: Blue Wolf Leather Armor (100%)
(20819, 4402, 1, 1, 2, 298.064936); -- Blue Dimensional Stone

INSERT INTO `droplist` VALUES
(20819, 730, 1, 1, 2, 124.208768), -- Scroll: Enchant Armor (A-Grade)
(20819, 8729, 1, 1, 2, 1986.979216), -- Life Stone - Level 64
(20819, 8739, 1, 1, 2, 496.835072), -- Mid-Grade Life Stone - Level 64
(20819, 8749, 1, 1, 2, 49.6474), -- High-Grade Life Stone - Level 64
(20819, 8759, 1, 1, 2, 10.110016), -- Top-Grade Life Stone - Level 64
-- Hallate's Knight
(20820, 4080, 1, 1, -1, 214391), -- Blue Wolf Gaiters Material
(20820, 5230, 1, 1, -1, 13897), -- Recipe: Mithril Arrow (100%)
(20820, 4054, 1, 1, -1, 205291), -- Necklace of Black Ore Beads
(20820, 57, 4130, 8374, 0, 700000), -- Adena
(20820, 864, 1, 1, 1, 144.335385), -- Earring of Black Ore
(20820, 4052, 1, 1, 1, 18165.45798), -- Earring of Black Ore Piece
(20820, 926, 1, 1, 1, 108.264222), -- Necklace of Black Ore
(20820, 4054, 1, 1, 1, 10106.0136), -- Necklace of Black Ore Beads
(20820, 895, 1, 1, 1, 216.477711), -- Ring of Black Ore
(20820, 4053, 1, 1, 1, 21992.451102), -- Ring of Black Ore Gemstone
(20820, 1867, 1, 3, 2, 171038.026143), -- Animal Skin
(20820, 1872, 1, 3, 2, 114025.350762), -- Animal Bone
(20820, 1882, 1, 1, 2, 57012.675381), -- Leather
(20820, 1894, 1, 1, 2, 9002.077521), -- Crafted Leather
(20820, 4042, 1, 1, 2, 4275.887358), -- Enria
(20820, 4160, 1, 1, 2, 726.633201), -- Recipe: Leather Armor of Doom (100%)
(20820, 5276, 1, 1, 2, 342.157794), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20820, 5424, 1, 1, 2, 887.584806), -- Recipe: Sealed Dark Crystal Gaiters(60%)
(20820, 8729, 1, 1, 2, 3420.854562), -- Life Stone - Level 64
(20820, 8739, 1, 1, 2, 855.032796), -- Mid-Grade Life Stone - Level 64
(20820, 8749, 1, 1, 2, 85.358604), -- High-Grade Life Stone - Level 64
(20820, 8759, 1, 1, 2, 17.361072), -- Top-Grade Life Stone - Level 64
-- Erin Ediunce
(20821, 4084, 1, 1, -1, 142125), -- Blue Wolf Tunic Fabric
(20821, 4080, 1, 1, -1, 168217), -- Blue Wolf Gaiters Material
(20821, 1894, 1, 1, -1, 286943), -- Crafted Leather
(20821, 57, 3240, 6570, 0, 700000), -- Adena
(20821, 97, 1, 1, 1, 23.935716), -- Lance
(20821, 4115, 1, 1, 1, 5268.064284), -- Lance Blade
(20821, 1867, 1, 3, 2, 146401.197624), -- Animal Skin
(20821, 1872, 1, 3, 2, 97600.695624), -- Animal Bone
(20821, 1882, 1, 1, 2, 48800.502), -- Leather
(20821, 1894, 1, 1, 2, 7705.391112), -- Crafted Leather
(20821, 4042, 1, 1, 2, 3660.114744), -- Enria
(20821, 4195, 1, 1, 2, 167.756544), -- Recipe: Art of Battle Axe (100%)
(20821, 5276, 1, 1, 2, 292.648824), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20821, 8729, 1, 1, 2, 2928.03012), -- Life Stone - Level 64
(20821, 8739, 1, 1, 2, 732.084624), -- Mid-Grade Life Stone - Level 64
(20821, 8749, 1, 1, 2, 73.085112), -- High-Grade Life Stone - Level 64
(20821, 8759, 1, 1, 2, 14.493672), -- Top-Grade Life Stone - Level 64
-- Hallate's Maid
(20822, 1894, 1, 1, -1, 288329), -- Crafted Leather
(20822, 1889, 1, 1, -1, 547825), -- Compound Braid
(20822, 4077, 1, 1, -1, 369652), -- Doom Shield Fragment
(20822, 57, 3255, 6602, 0, 700000), -- Adena
(20822, 97, 1, 1, 1, 24.053314), -- Lance
(20822, 4115, 1, 1, 1, 5293.946686), -- Lance Blade
(20822, 1868, 1, 3, 2, 202273.626555), -- Thread
(20822, 1873, 1, 1, 2, 80909.450622), -- Silver Nugget
(20822, 5549, 1, 1, 2, 20227.181975), -- Metallic Thread
(20822, 1889, 1, 1, 2, 13484.908437), -- Compound Braid
(20822, 4044, 1, 1, 2, 6742.273538), -- Thons
(20822, 4196, 1, 1, 2, 154.301147), -- Recipe: Staff of Evil Spirits (100%)
(20822, 4402, 1, 1, 2, 404.72432), -- Blue Dimensional Stone
(20822, 6670, 1, 1, 2, 33712.090412), -- Deluxe Chest Key - Grade 6
(20822, 8729, 1, 1, 2, 2696.837143), -- Life Stone - Level 64
(20822, 8739, 1, 1, 2, 674.299626), -- Mid-Grade Life Stone - Level 64
(20822, 8749, 1, 1, 2, 67.574507), -- High-Grade Life Stone - Level 64
(20822, 8759, 1, 1, 2, 13.731718), -- Top-Grade Life Stone - Level 64
-- Platinum Tribe Soldier
(20823, 4088, 1, 1, -1, 343233), -- Blue Wolf Helmet Design
(20823, 4089, 1, 1, -1, 343233), -- Doom Helmet Pattern
(20823, 5416, 1, 1, -1, 19615), -- Recipe: Sealed Dark Crystal Breastplate(60%)
(20823, 57, 3580, 7317, 0, 700000), -- Adena
(20823, 2398, 1, 1, 1, 36.11531), -- Blue Wolf Tunic
(20823, 4084, 1, 1, 1, 5829.65664), -- Blue Wolf Tunic Fabric
(20823, 2399, 1, 1, 1, 36.11531), -- Tunic of Doom
(20823, 4085, 1, 1, 1, 5829.65664), -- Tunic of Doom Pattern
(20823, 2403, 1, 1, 1, 57.82864), -- Blue Wolf Stockings
(20823, 4086, 1, 1, 1, 7871.37182), -- Blue Wolf Stockings Pattern
(20823, 2404, 1, 1, 1, 57.82864), -- Stockings of Doom
(20823, 4087, 1, 1, 1, 7871.427), -- Stockings of Doom Pattern
(20823, 1869, 1, 1, 2, 223555.158436), -- Iron Ore
(20823, 1864, 1, 3, 2, 223555.158436), -- Stem
(20823, 1880, 1, 1, 2, 22355.467452), -- Steel
(20823, 5550, 1, 1, 2, 2980.92256), -- Durable Metal Plate
(20823, 4043, 1, 1, 2, 7451.822484), -- Asofe
(20823, 4616, 1, 1, 2, 308.254492), -- Greater Dye of CON (Con+4 Dex-4)
(20823, 4402, 1, 1, 2, 447.138384), -- Blue Dimensional Stone
(20823, 8316, 1, 1, 2, 82.749636), -- Recipe: Flaming Dragon Skull (60%)
(20823, 8730, 1, 1, 2, 2483.940828), -- Life Stone - Level 67
(20823, 8740, 1, 1, 2, 620.864228), -- Mid-Grade Life Stone - Level 67
(20823, 8750, 1, 1, 2, 61.941248), -- High-Grade Life Stone - Level 67
(20823, 8760, 1, 1, 2, 12.581816), -- Top-Grade Life Stone - Level 67
-- Hallate's Commander
(20824, 4081, 1, 1, -1, 84768), -- Doom Plate Armor Temper
(20824, 5424, 1, 1, -1, 29760), -- Recipe: Sealed Dark Crystal Gaiters(60%)
(20824, 4078, 1, 1, -1, 125629), -- Blue Wolf Breastplate Part
(20824, 57, 3391, 6929, 0, 700000), -- Adena
(20824, 864, 1, 1, 1, 119.10308), -- Earring of Black Ore
(20824, 4052, 1, 1, 1, 14989.82384), -- Earring of Black Ore Piece
(20824, 926, 1, 1, 1, 89.337776), -- Necklace of Black Ore
(20824, 4054, 1, 1, 1, 8339.3088), -- Necklace of Black Ore Beads
(20824, 895, 1, 1, 1, 178.633688), -- Ring of Black Ore
(20824, 4053, 1, 1, 1, 18147.792816), -- Ring of Black Ore Gemstone
(20824, 1870, 1, 1, 2, 211706.202438), -- Coal
(20824, 1865, 1, 1, 2, 211706.202438), -- Varnish
(20824, 1874, 1, 1, 2, 14113.931742), -- Oriharukon Ore
(20824, 4043, 1, 1, 2, 7056.73473), -- Asofe
(20824, 4039, 1, 1, 2, 7056.73473), -- Mold Glue
(20824, 4617, 1, 1, 2, 292.162224), -- Greater Dye of DEX (Dex+4 Str-4)
(20824, 5276, 1, 1, 2, 282.454302), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20824, 8730, 1, 1, 2, 2352.090816), -- Life Stone - Level 67
(20824, 8740, 1, 1, 2, 588.022704), -- Mid-Grade Life Stone - Level 67
(20824, 8750, 1, 1, 2, 58.709814), -- High-Grade Life Stone - Level 67
(20824, 8760, 1, 1, 2, 11.55705), -- Top-Grade Life Stone - Level 67
(20824, 6036, 1, 1, 2, 7057.197012), -- Greater Magic Haste Potion
-- Hallate's Inspector
(20825, 1876, 1, 3, -1, 901136), -- Mithril Ore
(20825, 1807, 1, 1, -1, 12015), -- Recipe: Soulshot (A-Grade)
(20825, 57, 3565, 7246, 0, 700000), -- Adena
(20825, 5292, 1, 1, 1, 94.89672), -- Sealed Dark Crystal Shield
(20825, 5494, 1, 1, 1, 9316.508745), -- Sealed Dark Crystal Shield Fragment
(20825, 5289, 1, 1, 1, 66.404445), -- Sealed Dark Crystal Helmet
(20825, 5525, 1, 1, 1, 6857.404452), -- Sealed Dark Crystal Helmet Design
(20825, 5294, 1, 1, 1, 66.404445), -- Sealed Tallum Helmet
(20825, 5526, 1, 1, 1, 6857.381193), -- Sealed Tallum Helm Design
(20825, 1871, 1, 1, 2, 241983.002954), -- Charcoal
(20825, 1866, 1, 1, 2, 161321.860029), -- Suede
(20825, 1877, 1, 1, 2, 9679.337151), -- Adamantite Nugget
(20825, 4041, 1, 1, 2, 2104.407382), -- Mold Hardener
(20825, 4040, 1, 1, 2, 4839.455665), -- Mold Lubricant
(20825, 4975, 1, 1, 2, 1967.29302), -- Recipe: Necklace of Black Ore (70%)
(20825, 4402, 1, 1, 2, 484.158477), -- Blue Dimensional Stone
(20825, 8730, 1, 1, 2, 2688.633794), -- Life Stone - Level 67
(20825, 8740, 1, 1, 2, 672.371359), -- Mid-Grade Life Stone - Level 67
(20825, 8750, 1, 1, 2, 67.279718), -- High-Grade Life Stone - Level 67
(20825, 8760, 1, 1, 2, 13.200451), -- Top-Grade Life Stone - Level 67
-- Platinum Tribe Archer
(20826, 5478, 1, 1, -1, 68984), -- Sealed Dark Crystal Leather Armor Pattern
(20826, 4041, 1, 1, -1, 71335), -- Mold Hardener
(20826, 57, 3245, 6597, 0, 700000), -- Adena
(20826, 5287, 1, 1, 1, 22.675824), -- Sealed Dark Crystal breastplate
(20826, 5520, 1, 1, 1, 2604.474288), -- Sealed Dark Crystal Breastplate Pattern
(20826, 5293, 1, 1, 1, 13.958928), -- Sealed Tallum Plate Armor
(20826, 5521, 1, 1, 1, 1837.820736), -- Sealed Tallum Plate Armor Pattern
(20826, 5288, 1, 1, 1, 36.286416), -- Sealed Dark Crystal Gaiters
(20826, 5524, 1, 1, 1, 3980.783808), -- Sealed Dark Crystal Gaiters Pattern
(20826, 1872, 1, 3, 2, 134622.2047), -- Animal Bone
(20826, 1867, 1, 1, 2, 269243.924205), -- Animal Skin
(20826, 1881, 1, 1, 2, 26924.44094), -- Coarse Bone Powder
(20826, 1875, 1, 1, 2, 13462.22047), -- Stone of Purity
(20826, 4041, 1, 1, 2, 1755.920705), -- Mold Hardener
(20826, 4980, 1, 1, 2, 2389.585375), -- Recipe: Doom Shield (60%)
(20826, 3956, 1, 1, 2, 269.283225), -- Recipe: Blessed Spiritshot A
(20826, 6670, 1, 1, 2, 33655.551175), -- Deluxe Chest Key - Grade 6
(20826, 8730, 1, 1, 2, 2243.54168), -- Life Stone - Level 67
(20826, 8740, 1, 1, 2, 560.88542), -- Mid-Grade Life Stone - Level 67
(20826, 8750, 1, 1, 2, 56.28262), -- High-Grade Life Stone - Level 67
(20826, 8760, 1, 1, 2, 11.159485), -- Top-Grade Life Stone - Level 67
-- Platinum Tribe Warrior
(20827, 4117, 1, 1, -1, 43680), -- Art of Battle Axe Blade
(20827, 4118, 1, 1, -1, 41384), -- Evil Spirit Head
(20827, 3035, 1, 1, -1, 13328), -- Recipe: Spiritshot A
(20827, 57, 3956, 8034, 0, 700000), -- Adena
(20827, 5297, 1, 1, 1, 36.849111), -- Sealed Dark Crystal Leather Armor
(20827, 5478, 1, 1, 1, 4137.935191), -- Sealed Dark Crystal Leather Armor Pattern
(20827, 5301, 1, 1, 1, 22.666917), -- Sealed Tallum Leather Armor
(20827, 5479, 1, 1, 1, 2911.735593), -- Sealed Tallum Leather Armor Pattern
(20827, 5298, 1, 1, 1, 58.928519), -- Sealed Dark Crystal Leggings
(20827, 5482, 1, 1, 1, 6494.884669), -- Sealed Dark Crystal Leggings Design
(20827, 1873, 1, 1, 2, 98421.399072), -- Silver Nugget
(20827, 1868, 1, 3, 2, 246053.972032), -- Thread
(20827, 1876, 1, 1, 2, 49210.699536), -- Mithril Ore
(20827, 1895, 1, 1, 2, 70300.863808), -- Metallic Fiber
(20827, 4042, 1, 1, 2, 4100.77304), -- Enria
(20827, 4990, 1, 1, 2, 2033.547024), -- Recipe: Blue Wolf Helmet (60%)
(20827, 4402, 1, 1, 2, 491.903024), -- Blue Dimensional Stone
(20827, 5420, 1, 1, 2, 239.073408), -- Recipe: Sealed Armor of Nightmare(60%)
(20827, 8730, 1, 1, 2, 2734.164928), -- Life Stone - Level 67
(20827, 8740, 1, 1, 2, 683.541232), -- Mid-Grade Life Stone - Level 67
(20827, 8750, 1, 1, 2, 68.306688), -- High-Grade Life Stone - Level 67
(20827, 8760, 1, 1, 2, 13.756208), -- Top-Grade Life Stone - Level 67
-- Platinum Tribe Shaman
(20828, 4120, 1, 1, -1, 49809), -- Bellion Cestus Edge
(20828, 4121, 1, 1, -1, 49642), -- Bow of Peril Shaft
(20828, 5479, 1, 1, -1, 67447), -- Sealed Tallum Leather Armor Pattern
(20828, 57, 4508, 9172, 0, 700000), -- Adena
(20828, 5304, 1, 1, 1, 42.01926), -- Sealed Tallum Tunic
(20828, 5485, 1, 1, 1, 4718.51206), -- Sealed Tallum Tunic Texture
(20828, 5308, 1, 1, 1, 25.84722), -- Sealed Dark Crystal Robe
(20828, 5486, 1, 1, 1, 3320.26938), -- Sealed Dark Crystal Robe Fabric
(20828, 5305, 1, 1, 1, 67.19654), -- Sealed Tallum Stockings
(20828, 5489, 1, 1, 1, 7406.15554), -- Sealed Tallum Stockings Fabric
(20828, 1864, 3, 9, 2, 112232.24376), -- Stem
(20828, 1869, 2, 6, 2, 84174.084064), -- Iron Ore
(20828, 1878, 1, 1, 2, 134678.692512), -- Braided Hemp
(20828, 1884, 2, 6, 2, 41439.597696), -- Cord
(20828, 4039, 1, 1, 2, 11223.421888), -- Mold Glue
(20828, 4177, 1, 1, 2, 6487.479152), -- Recipe: Sealed Zubei's Gauntlets (100%)
(20828, 8730, 1, 1, 2, 3741.272304), -- Life Stone - Level 67
(20828, 8740, 1, 1, 2, 935.416832), -- Mid-Grade Life Stone - Level 67
(20828, 8750, 1, 1, 2, 93.620688), -- High-Grade Life Stone - Level 67
(20828, 8760, 1, 1, 2, 18.171104), -- Top-Grade Life Stone - Level 67
-- Platinum Tribe Overlord
(20829, 1894, 1, 1, -1, 428952), -- Crafted Leather
(20829, 5550, 1, 1, -1, 163002), -- Durable Metal Plate
(20829, 5479, 1, 1, -1, 72338), -- Sealed Tallum Leather Armor Pattern
(20829, 57, 6033, 12296, 0, 700000), -- Adena
(20829, 5287, 1, 1, 1, 42.242263), -- Sealed Dark Crystal breastplate
(20829, 5520, 1, 1, 1, 4851.814331), -- Sealed Dark Crystal Breastplate Pattern
(20829, 5293, 1, 1, 1, 26.003761), -- Sealed Tallum Plate Armor
(20829, 5521, 1, 1, 1, 3423.633332), -- Sealed Tallum Plate Armor Pattern
(20829, 5288, 1, 1, 1, 67.597117), -- Sealed Dark Crystal Gaiters
(20829, 5524, 1, 1, 1, 7415.709196), -- Sealed Dark Crystal Gaiters Pattern
(20829, 1871, 1, 3, 2, 205177.152999), -- Charcoal
(20829, 1866, 1, 3, 2, 91189.972587), -- Suede
(20829, 1877, 1, 1, 2, 16414.370063), -- Adamantite Nugget
(20829, 4041, 1, 1, 2, 3568.42402), -- Mold Hardener
(20829, 4040, 1, 1, 2, 8206.994817), -- Mold Lubricant
(20829, 4129, 1, 1, 2, 4441.128146), -- Recipe: Earrings of Black Ore (100%)
(20829, 6671, 1, 1, 2, 45594.796079), -- Deluxe Chest Key - Grade 7
(20829, 8730, 1, 1, 2, 4559.441565), -- Life Stone - Level 67
(20829, 8740, 1, 1, 2, 1139.765284), -- Mid-Grade Life Stone - Level 67
(20829, 8750, 1, 1, 2, 114.1287), -- High-Grade Life Stone - Level 67
(20829, 8760, 1, 1, 2, 22.82574), -- Top-Grade Life Stone - Level 67
-- Zaken's Pikeman
(20832, 5231, 1, 1, -1, 77593), -- Recipe: Metal Hardener (100%)
(20832, 1902, 1, 1, -1, 110061), -- Elven Earring Beads
(20832, 1825, 1, 1, -1, 77593), -- Recipe: Oriharukon
(20832, 57, 430, 872, 0, 700000), -- Adena
(20832, 1125, 1, 1, 1, 120.896793), -- Assault Boots
(20832, 1957, 1, 1, 1, 5073.582429), -- Assault Boots Part
(20832, 2427, 1, 1, 1, 120.896793), -- Salamander Skin Boots
(20832, 2931, 1, 1, 1, 5073.582429), -- Salamander Skin Boot Lining
(20832, 2428, 1, 1, 1, 120.896793), -- Plate Boots
(20832, 2932, 1, 1, 1, 5073.582429), -- Plate Boots Design
(20832, 61, 1, 1, 1, 120.896793), -- Mithril Plate Gloves
(20832, 1949, 1, 1, 1, 5073.582429), -- Mithril Gloves Design
(20832, 607, 1, 1, 1, 120.896793), -- Ogre Power Gauntlets
(20832, 1963, 1, 1, 1, 5073.582429), -- Ogre Power Gauntlets Part
(20832, 2451, 1, 1, 1, 120.896793), -- Sage's Worn Gloves
(20832, 2933, 1, 1, 1, 5073.707097), -- Sage's Worn Gloves Lining
(20832, 1865, 1, 1, 2, 77927.242414), -- Varnish
(20832, 1870, 1, 1, 2, 77927.242414), -- Coal
(20832, 1879, 1, 1, 2, 12987.844002), -- Cokes
(20832, 1875, 1, 1, 2, 5195.06624), -- Stone of Purity
(20832, 2162, 1, 1, 2, 3764.639004), -- Recipe: Aquastone Necklace
(20832, 5159, 1, 1, 2, 259.753312), -- Recipe: Spiritshot (C) Compressed Package (100%)
(20832, 2312, 1, 1, 2, 340.212614), -- Recipe: Crystallized Ice Bow
-- Zaken's Archer
(20833, 1874, 1, 1, -1, 80465), -- Oriharukon Ore
(20833, 1875, 1, 1, -1, 80465), -- Stone of Purity
(20833, 1905, 1, 1, -1, 117410), -- Omen Beast's Eye Earring Gemstone
(20833, 57, 475, 974, 0, 700000), -- Adena
(20833, 281, 1, 1, 1, 32.34978), -- Crystallized Ice Bow
(20833, 2074, 1, 1, 1, 2019.65022), -- Crystallized Ice Bow Shaft
(20833, 1872, 1, 1, 2, 69143.4744), -- Animal Bone
(20833, 1867, 1, 1, 2, 69143.4744), -- Animal Skin
(20833, 1881, 1, 1, 2, 6914.34744), -- Coarse Bone Powder
(20833, 1875, 1, 1, 2, 3457.17372), -- Stone of Purity
(20833, 2209, 1, 1, 2, 3899.03976), -- Recipe: Eldarake
(20833, 2205, 1, 1, 2, 1641.01476), -- Recipe: Chain Gaiters
(20833, 2299, 1, 1, 2, 226.50936), -- Recipe: Big Hammer
(20833, 8723, 1, 1, 2, 2074.2414), -- Life Stone - Level 46
(20833, 8733, 1, 1, 2, 518.52108), -- Mid-Grade Life Stone - Level 46
(20833, 8743, 1, 1, 2, 51.8364), -- High-Grade Life Stone - Level 46
(20833, 8753, 1, 1, 2, 10.36728), -- Top-Grade Life Stone - Level 46
-- Mardian
(20834, 1878, 1, 1, -1, 714983), -- Braided Hemp
(20834, 1885, 1, 1, -1, 148955), -- High-Grade Suede
(20834, 1805, 1, 1, -1, 5958), -- Recipe: Soulshot (C-Grade)
(20834, 57, 720, 1455, 0, 700000), -- Adena
(20834, 353, 1, 1, 1, 149.199147), -- Half Plate Armor
(20834, 1950, 1, 1, 1, 7283.399643), -- Half Plate Temper
(20834, 380, 1, 1, 1, 238.722435), -- Plate Gaiters
(20834, 1951, 1, 1, 1, 11327.678775), -- Plate Gaiters Part
(20834, 1864, 1, 3, 2, 112197.458058), -- Stem
(20834, 1869, 1, 1, 2, 112197.458058), -- Iron Ore
(20834, 1878, 1, 1, 2, 44879.216118), -- Braided Hemp
(20834, 1884, 1, 1, 2, 69044.768724), -- Cord
(20834, 2306, 1, 1, 2, 489.855396), -- Recipe: Stick of Faith
(20834, 5274, 1, 1, 2, 374.184312), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20834, 2996, 1, 1, 2, 8904.732678), -- Recipe: Chain Gloves
(20834, 6668, 1, 1, 2, 40070.326656), -- Deluxe Chest Key - Grade 4
-- Zaken's Seer
(20835, 1871, 1, 3, -1, 495145), -- Charcoal
(20835, 1879, 1, 1, -1, 165048), -- Cokes
(20835, 1906, 1, 1, -1, 136122), -- Mithril Ring Wire
(20835, 57, 392, 796, 0, 700000), -- Adena
(20835, 439, 1, 1, 1, 80.415296), -- Karmian Tunic
(20835, 1962, 1, 1, 1, 3744.367742), -- Karmian Tunic Pattern
(20835, 471, 1, 1, 1, 128.517968), -- Karmian Stockings
(20835, 1954, 1, 1, 1, 6220.698994), -- Karmian Stocking Design
(20835, 1865, 1, 1, 2, 33430.627448), -- Varnish
(20835, 1870, 1, 1, 2, 33430.627448), -- Coal
(20835, 1879, 1, 1, 2, 5571.743839), -- Cokes
(20835, 1875, 1, 1, 2, 2228.713977), -- Stone of Purity
(20835, 4040, 1, 1, 2, 668.589531), -- Mold Lubricant
(20835, 3000, 1, 1, 2, 2142.972076), -- Recipe: Dwarven Chain Shield
(20835, 2303, 1, 1, 2, 145.999632), -- Recipe: Skull Graver
(20835, 2990, 1, 1, 2, 2653.230925), -- Recipe: Chain Boots
(20835, 3033, 1, 1, 2, 111.472692), -- Recipe: Spiritshot C
(20835, 3954, 1, 1, 2, 111.472692), -- Recipe: Blessed Spiritshot C
(20835, 8723, 1, 1, 2, 1337.261269), -- Life Stone - Level 46
(20835, 8733, 1, 1, 2, 334.335869), -- Mid-Grade Life Stone - Level 46
(20835, 8743, 1, 1, 2, 33.458249), -- High-Grade Life Stone - Level 46
(20835, 8753, 1, 1, 2, 6.494353), -- Top-Grade Life Stone - Level 46
-- Pirate Zombie
(20836, 1874, 1, 1, -1, 139288), -- Oriharukon Ore
(20836, 1875, 1, 1, -1, 139288), -- Stone of Purity
(20836, 57, 822, 1686, 0, 700000), -- Adena
(20836, 96, 1, 1, 1, 18.669784), -- Scythe
(20836, 2062, 1, 1, 1, 1290.66224), -- Scythe Edge
(20836, 298, 1, 1, 1, 18.669784), -- Orcish Glaive
(20836, 2075, 1, 1, 1, 1290.66224), -- Orcish Glaive Blade
(20836, 302, 1, 1, 1, 18.669784), -- Body Slasher
(20836, 2076, 1, 1, 1, 1290.666168), -- Body Slasher Blade
(20836, 1872, 1, 1, 2, 131658.865024), -- Animal Bone
(20836, 1867, 1, 1, 2, 131658.865024), -- Animal Skin
(20836, 1881, 1, 1, 2, 13166.008472), -- Coarse Bone Powder
(20836, 1875, 1, 1, 2, 6583.004236), -- Stone of Purity
(20836, 2251, 1, 1, 2, 16457.358128), -- Recipe: Steel Arrow
(20836, 2319, 1, 1, 2, 343.954272), -- Recipe: Raid Sword
(20836, 8723, 1, 1, 2, 3949.680572), -- Life Stone - Level 46
(20836, 8733, 1, 1, 2, 987.343912), -- Mid-Grade Life Stone - Level 46
(20836, 8743, 1, 1, 2, 98.795376), -- High-Grade Life Stone - Level 46
(20836, 8753, 1, 1, 2, 20.124984), -- Top-Grade Life Stone - Level 46
-- Tainted Ogre
(20837, 2214, 1, 1, -1, 50878), -- Recipe: Dwarven Chain Gaiters
(20837, 1960, 1, 1, -1, 112350), -- Chain Gaiters Part
(20837, 1895, 1, 1, -1, 585827), -- Metallic Fiber
(20837, 57, 811, 1647, 0, 700000), -- Adena
(20837, 62, 1, 1, 1, 110.887439), -- Reinforced Mithril Boots
(20837, 1958, 1, 1, 1, 4839.218722), -- Reinforced Mithril Boots Design
(20837, 2429, 1, 1, 1, 110.887439), -- Chain Boots
(20837, 2937, 1, 1, 1, 4839.218722), -- Chain Boots Part
(20837, 2430, 1, 1, 1, 110.887439), -- Karmian Boots
(20837, 2938, 1, 1, 1, 4839.218722), -- Karmian Boots Fabric
(20837, 2431, 1, 1, 1, 110.887439), -- Plated Leather Boots
(20837, 2939, 1, 1, 1, 4839.218722), -- Plate Leather Boots Lining
(20837, 2432, 1, 1, 1, 110.887439), -- Dwarven Chain Boots
(20837, 2940, 1, 1, 1, 4839.218722), -- Dwarven Chain Boots Part
(20837, 2433, 1, 1, 1, 110.887439), -- Boots of Seal
(20837, 2941, 1, 1, 1, 4839.218722), -- Boots of Seal Pattern
(20837, 2452, 1, 1, 1, 110.887439), -- Reinforced Mithril Gloves
(20837, 2942, 1, 1, 1, 4839.218722), -- Reinforced Mithril Gloves Design
(20837, 2453, 1, 1, 1, 110.887439), -- Chain Gloves
(20837, 2943, 1, 1, 1, 4839.218722), -- Chain Gloves Design
(20837, 2454, 1, 1, 1, 110.887439), -- Karmian Gloves
(20837, 2944, 1, 1, 1, 4839.263273), -- Karmian Gloves Fabric
(20837, 1873, 1, 1, 2, 35238.148158), -- Silver Nugget
(20837, 1868, 1, 1, 2, 176190.74079), -- Thread
(20837, 1876, 1, 1, 2, 17619.074079), -- Mithril Ore
(20837, 1895, 1, 1, 2, 25170.180804), -- Metallic Fiber
(20837, 4042, 1, 1, 2, 1468.234305), -- Enria
(20837, 2225, 1, 1, 2, 1915.133862), -- Recipe: Demon's Stockings
(20837, 2321, 1, 1, 2, 307.03023), -- Recipe: Stiletto
(20837, 8723, 1, 1, 2, 3523.762332), -- Life Stone - Level 46
(20837, 8733, 1, 1, 2, 880.940583), -- Mid-Grade Life Stone - Level 46
(20837, 8743, 1, 1, 2, 88.172784), -- High-Grade Life Stone - Level 46
(20837, 8753, 1, 1, 2, 17.582073), -- Top-Grade Life Stone - Level 46
-- Bloody Bat
(20838, 2216, 1, 1, -1, 79419), -- Recipe: Great Helmet
(20838, 1964, 1, 1, -1, 155308), -- Eldarake Temper
(20838, 1866, 1, 3, -1, 640646), -- Suede
(20838, 57, 760, 1544, 0, 700000), -- Adena
(20838, 852, 1, 1, 1, 253.796192), -- Moonstone Earring
(20838, 1908, 1, 1, 1, 14336.96992), -- Moonstone Earring Wire
(20838, 915, 1, 1, 1, 190.429408), -- Aquastone Necklace
(20838, 1910, 1, 1, 1, 11400.474176), -- Aquastone Necklace Chain
(20838, 883, 1, 1, 1, 380.858816), -- Aquastone Ring
(20838, 1909, 1, 1, 1, 20445.471488), -- Aquastone Ring Wire
(20838, 1866, 1, 1, 2, 60555.95695), -- Suede
(20838, 1871, 1, 1, 2, 90833.935425), -- Charcoal
(20838, 5220, 1, 1, 2, 3633.281), -- Metal Hardener
(20838, 1885, 1, 1, 2, 7569.4512), -- High-Grade Suede
(20838, 4041, 1, 1, 2, 789.8739), -- Mold Hardener
(20838, 3004, 1, 1, 2, 5641.832375), -- Recipe: Rind Leather Gloves
(20838, 8723, 1, 1, 2, 3633.281), -- Life Stone - Level 46
(20838, 8733, 1, 1, 2, 908.32025), -- Mid-Grade Life Stone - Level 46
(20838, 8743, 1, 1, 2, 90.832025), -- High-Grade Life Stone - Level 46
(20838, 8753, 1, 1, 2, 18.235875), -- Top-Grade Life Stone - Level 46
-- Unpleasant Humming
(20839, 2320, 1, 1, -1, 4006), -- Recipe: Cursed Staff
(20839, 2066, 1, 1, -1, 9017), -- Heavy Doom Hammer Head
(20839, 1908, 1, 1, -1, 108867), -- Moonstone Earring Wire
(20839, 57, 453, 926, 0, 700000), -- Adena
(20839, 631, 1, 1, 1, 177.5616), -- Eldarake
(20839, 1964, 1, 1, 1, 7317.30048), -- Eldarake Temper
(20839, 2495, 1, 1, 1, 177.5616), -- Chain Shield
(20839, 2945, 1, 1, 1, 7317.30048), -- Chain Shield Fragment
(20839, 2413, 1, 1, 1, 124.29312), -- Chain Hood
(20839, 2936, 1, 1, 1, 6645.98272), -- Chain Hood Pattern
(20839, 1867, 1, 1, 2, 60370.846201), -- Animal Skin
(20839, 1872, 1, 1, 2, 60370.846201), -- Animal Bone
(20839, 1882, 1, 1, 2, 10061.782255), -- Leather
(20839, 1894, 1, 1, 2, 1588.694426), -- Crafted Leather
(20839, 4042, 1, 1, 2, 754.652753), -- Enria
(20839, 2230, 1, 1, 2, 877.552908), -- Recipe: Theca Leather Gaiters
(20839, 2326, 1, 1, 2, 157.709143), -- Recipe: Horn of Glory
(20839, 6668, 1, 1, 2, 16170.759649), -- Deluxe Chest Key - Grade 4
(20839, 8723, 1, 1, 2, 1811.136073), -- Life Stone - Level 46
(20839, 8733, 1, 1, 2, 452.822186), -- Mid-Grade Life Stone - Level 46
(20839, 8743, 1, 1, 2, 45.343287), -- High-Grade Life Stone - Level 46
(20839, 8753, 1, 1, 2, 8.854918), -- Top-Grade Life Stone - Level 46
-- Death Flyer
(20840, 2328, 1, 1, -1, 2759), -- Recipe: Sword of Delusion
(20840, 1967, 1, 1, -1, 64698), -- Plated Leather Gaiters Material
(20840, 2166, 1, 1, -1, 40211), -- Recipe: Earrings of Binding (100%)
(20840, 57, 468, 955, 0, 700000), -- Adena
(20840, 227, 1, 1, 1, 11.89263), -- Stiletto
(20840, 2083, 1, 1, 1, 873.10737), -- Stiletto Edge
(20840, 242, 1, 1, 1, 11.89263), -- Soulfire Dirk
(20840, 2084, 1, 1, 1, 873.10737), -- Soulfire Dirk Blade
(20840, 1868, 1, 1, 2, 95562.358226), -- Thread
(20840, 1873, 1, 1, 2, 19112.446148), -- Silver Nugget
(20840, 5549, 1, 1, 2, 4778.17528), -- Metallic Thread
(20840, 1889, 1, 1, 2, 3185.365196), -- Compound Braid
(20840, 4044, 1, 1, 2, 1592.682598), -- Thons
(20840, 2229, 1, 1, 2, 579.168898), -- Recipe: Theca Leather Armor
(20840, 952, 1, 1, 2, 637.047542), -- Scroll: Enchant Armor (C-Grade)
(20840, 8724, 1, 1, 2, 1592.682598), -- Life Stone - Level 49
(20840, 8734, 1, 1, 2, 398.138778), -- Mid-Grade Life Stone - Level 49
(20840, 8744, 1, 1, 2, 39.775632), -- High-Grade Life Stone - Level 49
(20840, 8754, 1, 1, 2, 8.159104), -- Top-Grade Life Stone - Level 49
-- Fiend Archer
(20841, 4438, 1, 1, -1, 8698), -- Knuckle Duster Edge
(20841, 951, 1, 1, -1, 2217), -- Scroll: Enchant Weapon (C-Grade)
(20841, 1911, 1, 1, -1, 90711), -- Earring of Protection Gemstone
(20841, 57, 482, 980, 0, 700000), -- Adena
(20841, 282, 1, 1, 1, 12.229558), -- Elemental Bow
(20841, 2085, 1, 1, 1, 934.770442), -- Crossbow Shaft
(20841, 285, 1, 1, 1, 12.229558), -- Noble Elven Bow
(20841, 2086, 1, 1, 1, 934.770442), -- Noble Elven Bow Shaft
(20841, 1869, 1, 1, 2, 45031.6002), -- Iron Ore
(20841, 1864, 1, 1, 2, 90063.05598), -- Stem
(20841, 1880, 1, 1, 2, 4503.16002), -- Steel
(20841, 5550, 1, 1, 2, 600.35394), -- Durable Metal Plate
(20841, 4043, 1, 1, 2, 1501.10148), -- Asofe
(20841, 2348, 1, 1, 2, 104.7045), -- Recipe: Heathen's Book
(20841, 2351, 1, 1, 2, 94.16184), -- Recipe: Scorpion
(20841, 952, 1, 1, 2, 600.35394), -- Scroll: Enchant Armor (C-Grade)
(20841, 8724, 1, 1, 2, 1501.10148), -- Life Stone - Level 49
(20841, 8734, 1, 1, 2, 375.20316), -- Mid-Grade Life Stone - Level 49
(20841, 8744, 1, 1, 2, 37.5492), -- High-Grade Life Stone - Level 49
(20841, 8754, 1, 1, 2, 7.65426), -- Top-Grade Life Stone - Level 49
-- Musveren
(20842, 2335, 1, 1, -1, 2707), -- Recipe: War Axe
(20842, 1976, 1, 1, -1, 70772), -- Rind Leather Gaiters Material
(20842, 2167, 1, 1, -1, 59380), -- Recipe: Ring of Ages
(20842, 57, 459, 937, 0, 700000), -- Adena
(20842, 853, 1, 1, 1, 114.213622), -- Earring of Protection
(20842, 1911, 1, 1, 1, 6392.9024), -- Earring of Protection Gemstone
(20842, 916, 1, 1, 1, 85.692096), -- Necklace of Protection
(20842, 1913, 1, 1, 1, 5226.665278), -- Necklace of Protection Gemstone
(20842, 884, 1, 1, 1, 171.384192), -- Ring of Protection
(20842, 1912, 1, 1, 1, 9262.142412), -- Ring of Protection Gemstone
(20842, 1870, 1, 1, 2, 51567.29048), -- Coal
(20842, 1865, 1, 1, 2, 51567.29048), -- Varnish
(20842, 1874, 1, 1, 2, 3437.856998), -- Oriharukon Ore
(20842, 4043, 1, 1, 2, 1718.87205), -- Asofe
(20842, 4039, 1, 1, 2, 1718.87205), -- Mold Glue
(20842, 952, 1, 1, 2, 687.54882), -- Scroll: Enchant Armor (C-Grade)
(20842, 8724, 1, 1, 2, 1718.87205), -- Life Stone - Level 49
(20842, 8734, 1, 1, 2, 429.689788), -- Mid-Grade Life Stone - Level 49
(20842, 8744, 1, 1, 2, 43.014138), -- High-Grade Life Stone - Level 49
(20842, 8754, 1, 1, 2, 8.693146), -- Top-Grade Life Stone - Level 49
-- Zaken's Royal Guard
(20843, 4601, 1, 1, -1, 3273), -- Greater Dye of STR (Str+3 Con-3)
(20843, 1539, 1, 1, -1, 327301), -- Greater Healing Potion
(20843, 1914, 1, 1, -1, 82745), -- Earring of Seal Gemstone
(20843, 57, 583, 1184, 0, 700000), -- Adena
(20843, 283, 1, 1, 1, 18.43368), -- Akat Long Bow
(20843, 2109, 1, 1, 1, 1707.56632), -- Akat Longbow Shaft
(20843, 1871, 1, 1, 2, 50756.73014), -- Charcoal
(20843, 1866, 1, 1, 2, 33837.75913), -- Suede
(20843, 1877, 1, 1, 2, 2030.26189), -- Adamantite Nugget
(20843, 4041, 1, 1, 2, 441.405015), -- Mold Hardener
(20843, 4040, 1, 1, 2, 1015.130945), -- Mold Lubricant
(20843, 2357, 1, 1, 2, 82.757725), -- Recipe: Crystal Dagger
(20843, 3014, 1, 1, 2, 1417.76328), -- Recipe: Full Plate Boots
(20843, 4188, 1, 1, 2, 58.433355), -- Recipe: Hell Knife (100%)
(20843, 8725, 1, 1, 2, 1409.89901), -- Life Stone - Level 52
(20843, 8735, 1, 1, 2, 352.520475), -- Mid-Grade Life Stone - Level 52
(20843, 8745, 1, 1, 2, 35.206325), -- High-Grade Life Stone - Level 52
(20843, 8755, 1, 1, 2, 7.13271), -- Top-Grade Life Stone - Level 52
-- Kaim Vanul
(20844, 4603, 1, 1, -1, 2922), -- Greater Dye of CON (Con+3 Str-3)
(20844, 1539, 1, 1, -1, 292227), -- Greater Healing Potion
(20844, 4041, 1, 1, -1, 11435), -- Mold Hardener
(20844, 57, 521, 1058, 0, 700000), -- Adena
(20844, 854, 1, 1, 1, 79.994376), -- Earring of Seal
(20844, 1914, 1, 1, 1, 5091.23888), -- Earring of Seal Gemstone
(20844, 917, 1, 1, 1, 60.00008), -- Necklace of Mermaid
(20844, 1916, 1, 1, 1, 3856.33752), -- Necklace of Mermaid Teardrop
(20844, 885, 1, 1, 1, 119.948584), -- Ring of Ages
(20844, 1915, 1, 1, 1, 7984.48056), -- Ring of Ages Gemstone
(20844, 1872, 1, 1, 2, 60423.448572), -- Animal Bone
(20844, 1867, 1, 1, 2, 60423.448572), -- Animal Skin
(20844, 1881, 1, 1, 2, 6042.318419), -- Coarse Bone Powder
(20844, 1875, 1, 1, 2, 3021.225305), -- Stone of Purity
(20844, 4041, 1, 1, 2, 394.061371), -- Mold Hardener
(20844, 4601, 1, 1, 2, 100.729542), -- Greater Dye of STR (Str+3 Con-3)
(20844, 4609, 1, 1, 2, 100.729542), -- Greater Dye of MEN (Men+3 Int-3)
(20844, 2355, 1, 1, 2, 73.894769), -- Recipe: Ghoul's Staff
(20844, 8725, 1, 1, 2, 1258.854893), -- Life Stone - Level 52
(20844, 8735, 1, 1, 2, 314.746771), -- Mid-Grade Life Stone - Level 52
(20844, 8745, 1, 1, 2, 31.461458), -- High-Grade Life Stone - Level 52
(20844, 8755, 1, 1, 2, 6.080786), -- Top-Grade Life Stone - Level 52
-- Pirate Zombie Captain
(20845, 2100, 1, 1, -1, 10102), -- Paradia Staff Head
(20845, 2354, 1, 1, -1, 2923), -- Recipe: Deadman's Staff
(20845, 4042, 1, 1, -1, 29868), -- Enria
(20845, 57, 712, 1439, 0, 700000), -- Adena
(20845, 75, 1, 1, 1, 3.738902), -- Caliburs
(20845, 2089, 1, 1, 1, 336.595112), -- Caliburs Edge
(20845, 76, 1, 1, 1, 3.738902), -- Sword of Delusion
(20845, 2090, 1, 1, 1, 336.595112), -- Delusional Blade
(20845, 77, 1, 1, 1, 3.738902), -- Tsurugi
(20845, 2091, 1, 1, 1, 336.595112), -- Tsurugi Blade
(20845, 84, 1, 1, 1, 3.738902), -- Homunkulus's Sword
(20845, 2092, 1, 1, 1, 336.595112), -- Homunkulus's Sword Blade
(20845, 134, 1, 1, 1, 3.738902), -- Sword of Nightmare
(20845, 2095, 1, 1, 1, 336.595112), -- Sword of Nightmare Blade
(20845, 145, 1, 1, 1, 3.738902), -- Sword of Whispering Death
(20845, 2096, 1, 1, 1, 336.591028), -- Sword of Whispering Death Blade
(20845, 1873, 1, 1, 2, 21173.94517), -- Silver Nugget
(20845, 1868, 1, 1, 2, 105869.38383), -- Thread
(20845, 1876, 1, 1, 2, 10586.88708), -- Mithril Ore
(20845, 1895, 1, 1, 2, 15124.1244), -- Metallic Fiber
(20845, 4042, 1, 1, 2, 882.24059), -- Enria
(20845, 4608, 1, 1, 2, 117.65488), -- Greater Dye of INT (Int+3 Wit-3)
(20845, 3017, 1, 1, 2, 1478.55246), -- Recipe: Divine Gloves
(20845, 5155, 1, 1, 2, 105.85519), -- Recipe: Soulshot (B) Compressed Package (100%)
(20845, 6669, 1, 1, 2, 12310.32586), -- Deluxe Chest Key - Grade 5
(20845, 8725, 1, 1, 2, 1470.34398), -- Life Stone - Level 52
(20845, 8735, 1, 1, 2, 367.6715), -- Mid-Grade Life Stone - Level 52
(20845, 8745, 1, 1, 2, 36.76715), -- High-Grade Life Stone - Level 52
(20845, 8755, 1, 1, 2, 7.69545), -- Top-Grade Life Stone - Level 52
-- Doll Blader
(20846, 2955, 1, 1, -1, 100037), -- Theca Leather Gloves Texture
(20846, 4042, 1, 1, -1, 26343), -- Enria
(20846, 1918, 1, 1, -1, 68453), -- Nassen's Earring Gemstone
(20846, 57, 626, 1271, 0, 700000), -- Adena
(20846, 400, 1, 1, 1, 30.636222), -- Theca Leather Armor
(20846, 1984, 1, 1, 1, 2084.968227), -- Theca Leather Armor Pattern
(20846, 401, 1, 1, 1, 14.504139), -- Drake Leather Armor
(20846, 1987, 1, 1, 1, 1483.927092), -- Drake Leather Armor Texture
(20846, 420, 1, 1, 1, 49.034796), -- Theca Leather Gaiters
(20846, 1985, 1, 1, 1, 3353.929524), -- Theca Leather Gaiters Pattern
(20846, 1870, 1, 1, 2, 48633.326469), -- Coal
(20846, 1865, 1, 1, 2, 48633.326469), -- Varnish
(20846, 1874, 1, 1, 2, 3242.243112), -- Oriharukon Ore
(20846, 4043, 1, 1, 2, 1621.121556), -- Asofe
(20846, 4039, 1, 1, 2, 1621.121556), -- Mold Glue
(20846, 4133, 1, 1, 2, 233.860767), -- Recipe: Zubei's Breastplate (100%)
(20846, 4959, 1, 1, 2, 937.044123), -- Recipe: Sealed Avadon Boots (60%)
(20846, 4941, 1, 1, 2, 374.113185), -- Recipe: Zubei's Gaiters (60%)
(20846, 8726, 1, 1, 2, 1125.755139), -- Life Stone - Level 55
(20846, 8736, 1, 1, 2, 281.465469), -- Mid-Grade Life Stone - Level 55
(20846, 8746, 1, 1, 2, 28.178568), -- High-Grade Life Stone - Level 55
(20846, 8756, 1, 1, 2, 5.443587), -- Top-Grade Life Stone - Level 55
-- Veil Master
(20847, 1985, 1, 1, -1, 52100), -- Theca Leather Gaiters Pattern
(20847, 4937, 1, 1, -1, 24933), -- Recipe: Adamantite Earrings (70%)
(20847, 1806, 1, 1, -1, 3022), -- Recipe: Soulshot (B-Grade)
(20847, 57, 597, 1215, 0, 700000), -- Adena
(20847, 2436, 1, 1, 1, 37.663092), -- Theca Leather Boots
(20847, 2954, 1, 1, 1, 2522.47632), -- Theca Leather Boots Texture
(20847, 2437, 1, 1, 1, 28.976568), -- Drake Leather Boots
(20847, 2960, 1, 1, 1, 2170.164444), -- Drake Leather Boots Design
(20847, 2438, 1, 1, 1, 28.976568), -- Full Plate Boots
(20847, 2961, 1, 1, 1, 2170.164444), -- Full Plate Boots Part
(20847, 2460, 1, 1, 1, 37.663092), -- Theca Leather Gloves
(20847, 2955, 1, 1, 1, 2522.47632), -- Theca Leather Gloves Texture
(20847, 2461, 1, 1, 1, 28.976568), -- Drake Leather Gloves
(20847, 2962, 1, 1, 1, 2170.164444), -- Drake Leather Gloves Design
(20847, 2462, 1, 1, 1, 28.976568), -- Full Plate Gauntlets
(20847, 2963, 1, 1, 1, 2170.164444), -- Full Plate Gauntlets Part
(20847, 2463, 1, 1, 1, 28.976568), -- Divine Gloves
(20847, 2964, 1, 1, 1, 2170.18056), -- Divine Gloves Pattern
(20847, 1864, 1, 1, 2, 92979.551623), -- Stem
(20847, 1869, 1, 1, 2, 46489.680511), -- Iron Ore
(20847, 1878, 1, 1, 2, 18595.986565), -- Braided Hemp
(20847, 1884, 1, 1, 2, 28609.019499), -- Cord
(20847, 4039, 1, 1, 2, 1549.58613), -- Mold Glue
(20847, 4178, 1, 1, 2, 852.939475), -- Recipe: Zubei's Shield (100%)
(20847, 4184, 1, 1, 2, 53.558881), -- Recipe: Sprite's Staff (100%)
(20847, 5160, 1, 1, 2, 93.013288), -- Recipe: Spiritshot (B) Compressed Package (100%)
(20847, 8726, 1, 1, 2, 1076.133246), -- Life Stone - Level 55
(20847, 8736, 1, 1, 2, 269.128612), -- Mid-Grade Life Stone - Level 55
(20847, 8746, 1, 1, 2, 26.874741), -- High-Grade Life Stone - Level 55
(20847, 8756, 1, 1, 2, 5.527429), -- Top-Grade Life Stone - Level 55
-- Light Bringer
(20848, 1895, 1, 1, -1, 555409), -- Metallic Fiber
(20848, 1871, 1, 5, -1, 647978), -- Charcoal
(20848, 1908, 1, 1, -1, 184085), -- Moonstone Earring Wire
(20848, 57, 766, 1566, 0, 700000), -- Adena
(20848, 96, 1, 1, 1, 17.372215), -- Scythe
(20848, 2062, 1, 1, 1, 1200.9599), -- Scythe Edge
(20848, 298, 1, 1, 1, 17.372215), -- Orcish Glaive
(20848, 2075, 1, 1, 1, 1200.9599), -- Orcish Glaive Blade
(20848, 302, 1, 1, 1, 17.372215), -- Body Slasher
(20848, 2076, 1, 1, 1, 1200.963555), -- Body Slasher Blade
(20848, 1864, 1, 3, 2, 91873.219761), -- Stem
(20848, 1865, 1, 1, 2, 91873.219761), -- Varnish
(20848, 1866, 1, 1, 2, 61248.813174), -- Suede
(20848, 1873, 1, 1, 2, 36749.097), -- Silver Nugget
(20848, 1868, 1, 1, 2, 183745.962261), -- Thread
(20848, 2164, 1, 1, 2, 7067.280888), -- Recipe: Ring of Protection
(20848, 8723, 1, 1, 2, 3674.9097), -- Life Stone - Level 46
(20848, 8733, 1, 1, 2, 918.727425), -- Mid-Grade Life Stone - Level 46
(20848, 8743, 1, 1, 2, 92.111373), -- High-Grade Life Stone - Level 46
(20848, 8753, 1, 1, 2, 17.658657), -- Top-Grade Life Stone - Level 46
-- Light Worm
(20849, 4469, 1, 1, -1, 8784), -- Dye of STR (Str+1 Con-1)
(20849, 1956, 1, 1, -1, 174488), -- Square Shield Fragment
(20849, 1805, 1, 1, -1, 5124), -- Recipe: Soulshot (C-Grade)
(20849, 57, 623, 1246, 0, 700000), -- Adena
(20849, 438, 1, 1, 1, 210.560031), -- Sage's Rag
(20849, 1953, 1, 1, 1, 12362.439969), -- Sage's Rag Lining
(20849, 1869, 1, 1, 2, 85770.187359), -- Iron Ore
(20849, 1870, 1, 1, 2, 85770.187359), -- Coal
(20849, 1871, 1, 1, 2, 85770.187359), -- Charcoal
(20849, 1872, 1, 1, 2, 114360.413559), -- Animal Bone
(20849, 1867, 1, 1, 2, 114360.413559), -- Animal Skin
(20849, 2211, 1, 1, 2, 1923.208515), -- Recipe: Plated Leather Armor
(20849, 2205, 1, 1, 2, 2714.106525), -- Recipe: Chain Gaiters
(20849, 5274, 1, 1, 2, 285.902262), -- Recipe: Greater Spiritshot (C) Compressed Package(100%)
(20849, 5279, 1, 1, 2, 286.393503), -- Recipe: Greater Blessed Spiritshot (C) Compressed Package(100%)
-- Guardian Angel
(20859, 5479, 1, 1, -1, 99083), -- Sealed Tallum Leather Armor Pattern
(20859, 3035, 1, 1, -1, 22327), -- Recipe: Spiritshot A
(20859, 57, 8257, 16860, 0, 700000), -- Adena
(20859, 5287, 1, 1, 1, 57.858582), -- Sealed Dark Crystal breastplate
(20859, 5520, 1, 1, 1, 6645.455934), -- Sealed Dark Crystal Breastplate Pattern
(20859, 5293, 1, 1, 1, 35.616954), -- Sealed Tallum Plate Armor
(20859, 5521, 1, 1, 1, 4689.298248), -- Sealed Tallum Plate Armor Pattern
(20859, 5288, 1, 1, 1, 92.586738), -- Sealed Dark Crystal Gaiters
(20859, 5524, 1, 1, 1, 10157.183544), -- Sealed Dark Crystal Gaiters Pattern
(20859, 1872, 4, 12, 2, 103046.67411), -- Animal Bone
(20859, 1867, 7, 21, 2, 54958.3053), -- Animal Skin
(20859, 1881, 1, 1, 2, 82437.45795), -- Coarse Bone Powder
(20859, 1875, 1, 1, 2, 41218.728975), -- Stone of Purity
(20859, 4041, 1, 1, 2, 5376.278565), -- Mold Hardener
(20859, 3035, 1, 1, 2, 824.404245), -- Recipe: Spiritshot A
(20859, 8730, 1, 1, 2, 6869.639835), -- Life Stone - Level 67
(20859, 8740, 1, 1, 2, 1717.335795), -- Mid-Grade Life Stone - Level 67
(20859, 8750, 1, 1, 2, 171.763245), -- High-Grade Life Stone - Level 67
(20859, 8760, 1, 1, 2, 34.41198), -- Top-Grade Life Stone - Level 67
-- Seal Angel
(20860, 5482, 1, 1, -1, 310640), -- Sealed Dark Crystal Leggings Design
(20860, 5156, 1, 1, -1, 31381), -- Recipe: Soulshot (A) Compressed Package (100%)
(20860, 5485, 1, 1, -1, 197912), -- Sealed Tallum Tunic Texture
(20860, 57, 11622, 23663, 0, 700000), -- Adena
(20860, 5287, 1, 1, 1, 81.321761), -- Sealed Dark Crystal breastplate
(20860, 5520, 1, 1, 1, 9340.363357), -- Sealed Dark Crystal Breastplate Pattern
(20860, 5293, 1, 1, 1, 50.060567), -- Sealed Tallum Plate Armor
(20860, 5521, 1, 1, 1, 6590.932204), -- Sealed Tallum Plate Armor Pattern
(20860, 5288, 1, 1, 1, 130.133099), -- Sealed Dark Crystal Gaiters
(20860, 5524, 1, 1, 1, 14276.189012), -- Sealed Dark Crystal Gaiters Pattern
(20860, 1873, 2, 6, 2, 86900.8238), -- Silver Nugget
(20860, 1868, 15, 45, 2, 57934.13984), -- Thread
(20860, 1876, 1, 1, 2, 173802.03356), -- Mithril Ore
(20860, 1895, 3, 9, 2, 41381.47332), -- Metallic Fiber
(20860, 4042, 1, 1, 2, 14483.53496), -- Enria
(20860, 5271, 1, 1, 2, 1158.65192), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(20860, 8731, 1, 1, 2, 8046.49408), -- Life Stone - Level 70
(20860, 8741, 1, 1, 2, 2011.62352), -- Mid-Grade Life Stone - Level 70
(20860, 8751, 1, 1, 2, 201.08516), -- High-Grade Life Stone - Level 70
(20860, 8761, 1, 1, 2, 40.13984), -- Top-Grade Life Stone - Level 70
-- Maille Lizardman
(20919, 1865, 1, 1, -1, 121597), -- Varnish
(20919, 734, 1, 1, -1, 20266), -- Haste Potion
(20919, 5220, 1, 1, -1, 4864), -- Metal Hardener
(20919, 57, 56, 98, 0, 700000), -- Adena
(20919, 24, 1, 1, 1, 230.2898), -- Bone Breastplate
(20919, 390, 1, 1, 1, 230.2898), -- Cotton Shirt
(20919, 31, 1, 1, 1, 367.7102), -- Bone Gaiters
(20919, 412, 1, 1, 1, 367.7102), -- Cotton Pants
(20919, 1872, 1, 1, 2, 23945.309388), -- Animal Bone
(20919, 1867, 1, 1, 2, 23945.309388), -- Animal Skin
(20919, 1881, 1, 1, 2, 2394.509388), -- Coarse Bone Powder
(20919, 2141, 1, 1, 2, 3591.871836), -- Recipe: Silver Mold
-- Maille Lizardman Scout
(20920, 2014, 1, 1, -1, 3010), -- Iron Hammer Head
(20920, 5163, 1, 1, -1, 10474), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(20920, 1898, 1, 1, -1, 26897), -- Blue Diamond Necklace Gem
(20920, 57, 119, 213, 0, 700000), -- Adena
(20920, 273, 1, 1, 1, 82.310514), -- Composite Bow
(20920, 2016, 1, 1, 1, 906.689486), -- Composite Bow Shaft
(20920, 1865, 1, 1, 2, 25780.999642), -- Varnish
(20920, 1870, 1, 1, 2, 25780.999642), -- Coal
(20920, 1879, 1, 1, 2, 4296.775744), -- Cokes
(20920, 1060, 1, 1, 2, 57290.91855), -- Lesser Healing Potion
(20920, 735, 1, 1, 2, 2148.387872), -- Alacrity Potion
-- Maille Lizardman Guard
(20921, 1864, 1, 1, -1, 366638), -- Stem
(20921, 1928, 1, 1, -1, 26703), -- Piece Bone Gaiters Fragment
(20921, 1804, 1, 1, -1, 7333), -- Recipe: Soulshot (D-Grade)
(20921, 57, 81, 150, 0, 700000), -- Adena
(20921, 39, 1, 1, 1, 759.966624), -- Boots
(20921, 1930, 1, 1, 1, 9256.055976), -- Boot Lining
(20921, 51, 1, 1, 1, 759.9774), -- Bracer
(20921, 1880, 1, 1, 2, 2165.957945), -- Steel
(20921, 1881, 1, 1, 2, 2887.933129), -- Coarse Bone Powder
(20921, 1882, 1, 1, 2, 4813.211084), -- Leather
(20921, 3032, 1, 1, 2, 866.383178), -- Recipe: Spiritshot D
(20921, 6666, 1, 1, 2, 21659.514664), -- Deluxe Chest Key - Grade 2
-- Maille Lizardman Warrior
(20922, 1870, 1, 1, -1, 198933), -- Coal
(20922, 1932, 1, 1, -1, 31577), -- Bone Helmet Design
(20922, 1899, 1, 1, -1, 31083), -- Necklace of Devotion Chain
(20922, 57, 86, 165, 0, 700000), -- Adena
(20922, 123, 1, 1, 1, 17.72225), -- Saber
(20922, 2017, 1, 1, 1, 370.922125), -- Saber Blade
(20922, 5285, 1, 1, 1, 17.72225), -- Heavy Sword
(20922, 5531, 1, 1, 1, 468.633375), -- Heavy Sword Edge
(20922, 1874, 1, 1, 2, 1488.638052), -- Oriharukon Ore
(20922, 1878, 1, 1, 2, 8931.70575), -- Braided Hemp
(20922, 5220, 1, 1, 2, 893.170575), -- Metal Hardener
(20922, 2259, 1, 1, 2, 346.727898), -- Recipe: Spinebone Sword
(20922, 1060, 1, 1, 2, 49620.757725), -- Lesser Healing Potion
-- Maille Lizardman Shaman
(20923, 2263, 1, 1, -1, 4453), -- Recipe: Dwarven Trident
(20923, 2019, 1, 1, -1, 6166), -- Trident Edge
(20923, 2152, 1, 1, -1, 50483), -- Recipe: Enchanted Necklace
(20923, 57, 123, 241, 0, 700000), -- Adena
(20923, 432, 1, 1, 1, 334.060111), -- Cursed Tunic
(20923, 465, 1, 1, 1, 534.939889), -- Cursed Stockings
(20923, 1875, 1, 1, 2, 1788.05016), -- Stone of Purity
(20923, 1879, 1, 1, 2, 4470.1254), -- Cokes
(20923, 1885, 1, 1, 2, 2235.069584), -- High-Grade Suede
(20923, 5550, 1, 1, 2, 357.610032), -- Durable Metal Plate
(20923, 5549, 1, 1, 2, 2682.07524), -- Metallic Thread
(20923, 735, 1, 1, 2, 2235.069584), -- Alacrity Potion
-- Maille Lizardman Matriarch
(20924, 2250, 1, 1, -1, 86656), -- Recipe: Bone Arrow
(20924, 1937, 1, 1, -1, 29779), -- Scale Gaiters Fragment
(20924, 1900, 1, 1, -1, 37924), -- Enchanted Necklace Chain
(20924, 57, 146, 292, 0, 700000), -- Adena
(20924, 259, 1, 1, 1, 76), -- Single-Edged Jamadhr
(20924, 1876, 1, 1, 2, 4735.320325), -- Mithril Ore
(20924, 1880, 1, 1, 2, 2367.643666), -- Steel
(20924, 1877, 1, 1, 2, 947.064065), -- Adamantite Nugget
(20924, 1881, 1, 1, 2, 3156.869219), -- Coarse Bone Powder
(20924, 1882, 1, 1, 2, 5261.459696), -- Leather
(20924, 2183, 1, 1, 2, 1557.665516), -- Recipe: Mithril Banded Mail
(20924, 2274, 1, 1, 2, 169.122118), -- Recipe: Skull Breaker
(20924, 6667, 1, 1, 2, 14797.855395), -- Deluxe Chest Key - Grade 3
-- Giant Araneid
(20925, 2016, 1, 1, -1, 2190), -- Composite Bow Shaft
(20925, 2258, 1, 1, -1, 4570), -- Recipe: Temptation of Abyss
(20925, 1874, 1, 1, -1, 12461), -- Oriharukon Ore
(20925, 57, 83, 153, 0, 700000), -- Adena
(20925, 846, 1, 1, 1, 448.917695), -- Coral Earring
(20925, 909, 1, 1, 1, 336.689345), -- Blue Diamond Necklace
(20925, 1898, 1, 1, 1, 2836.009975), -- Blue Diamond Necklace Gem
(20925, 878, 1, 1, 1, 673.382985), -- Blue Coral Ring
(20925, 1872, 1, 1, 2, 24538.382522), -- Animal Bone
(20925, 1867, 1, 1, 2, 24538.382522), -- Animal Skin
(20925, 1881, 1, 1, 2, 2453.810168), -- Coarse Bone Powder
(20925, 5273, 1, 1, 2, 736.180496), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(20925, 8294, 1, 1, 2, 450.002498), -- Recipe: Steel Sword (100%)
(20925, 1060, 1, 1, 2, 40897.241794), -- Lesser Healing Potion
-- Poison Araneid
(20926, 2018, 1, 1, -1, 2844), -- Assassin Knife Edge
(20926, 1869, 1, 1, -1, 214041), -- Iron Ore
(20926, 1875, 1, 1, -1, 14269), -- Stone of Purity
(20926, 57, 94, 177, 0, 700000), -- Adena
(20926, 156, 1, 1, 1, 25.333308), -- Hand Axe
(20926, 167, 1, 1, 1, 25.333308), -- Scalpel
(20926, 178, 1, 1, 1, 25.333384), -- Bone Staff
(20926, 1875, 1, 1, 2, 1144.0568), -- Stone of Purity
(20926, 1879, 1, 1, 2, 2860.142), -- Cokes
(20926, 5549, 1, 1, 2, 1716.0852), -- Metallic Thread
(20926, 2178, 1, 1, 2, 2745.73632), -- Recipe: Dark Stockings
(20926, 5437, 1, 1, 2, 419.58578), -- Recipe: Heavy Sword(100%)
(20926, 1834, 1, 1, 2, 19067.490475), -- Emergency Dressing
(20926, 1831, 1, 1, 2, 45761.903425), -- Antidote
-- King of the Araneid
(20927, 1866, 1, 1, -1, 200876), -- Suede
(20927, 1932, 1, 1, -1, 47828), -- Bone Helmet Design
(20927, 1899, 1, 1, -1, 47080), -- Necklace of Devotion Chain
(20927, 57, 130, 251, 0, 700000), -- Adena
(20927, 220, 1, 1, 1, 107), -- Crafted Dagger
(20927, 1876, 1, 1, 2, 5636.799558), -- Mithril Ore
(20927, 1880, 1, 1, 2, 2818.399779), -- Steel
(20927, 1877, 1, 1, 2, 1127.355089), -- Adamantite Nugget
(20927, 1881, 1, 1, 2, 3757.866372), -- Coarse Bone Powder
(20927, 1882, 1, 1, 2, 6263.11062), -- Leather
(20927, 2178, 1, 1, 2, 4509.468582), -- Recipe: Dark Stockings
-- Hatu Weird Bee
(20928, 2183, 1, 1, -1, 19597), -- Recipe: Mithril Banded Mail
(20928, 2025, 1, 1, -1, 4126), -- Dwarven Trident Edge
(20928, 2153, 1, 1, -1, 46326), -- Recipe: Tiger's Eye Earring
(20928, 57, 126, 251, 0, 700000), -- Adena
(20928, 348, 1, 1, 1, 79.403112), -- Scale Mail
(20928, 1935, 1, 1, 1, 2273.473584), -- Scale Mail Fragment
(20928, 377, 1, 1, 1, 126.972072), -- Scale Gaiters
(20928, 1937, 1, 1, 1, 3496.151232), -- Scale Gaiters Fragment
(20928, 1872, 1, 1, 2, 27129.856536), -- Animal Bone
(20928, 1867, 1, 1, 2, 27129.856536), -- Animal Skin
(20928, 1881, 1, 1, 2, 2712.994248), -- Coarse Bone Powder
(20928, 1875, 1, 1, 2, 1356.454152), -- Stone of Purity
(20928, 2184, 1, 1, 2, 2137.341336), -- Recipe: Mithril Banded Gaiters
(20928, 2274, 1, 1, 2, 145.331304), -- Recipe: Skull Breaker
(20928, 2978, 1, 1, 2, 2723.909136), -- Recipe: Elven Mithril Boots
(20928, 1832, 1, 1, 2, 22608.256752), -- Greater Antidote
-- Hatu Dire Wolf
(20929, 1871, 1, 1, -1, 279467), -- Charcoal
(20929, 1900, 1, 1, -1, 30576), -- Enchanted Necklace Chain
(20929, 956, 1, 1, -1, 9316), -- Scroll: Enchant Armor (D-Grade)
(20929, 57, 118, 236, 0, 700000), -- Adena
(20929, 315, 1, 1, 1, 62), -- Divine Tome
(20929, 1865, 1, 1, 2, 21816.784359), -- Varnish
(20929, 1870, 1, 1, 2, 21816.784359), -- Coal
(20929, 1879, 1, 1, 2, 3636.182493), -- Cokes
(20929, 1875, 1, 1, 2, 1454.431584), -- Stone of Purity
(20929, 2250, 1, 1, 2, 5454.221973), -- Recipe: Bone Arrow
(20929, 6387, 1, 1, 2, 872.679657), -- Blessed Scroll of Resurrection for Pets
(20929, 1060, 1, 1, 2, 48481.915575), -- Lesser Healing Potion
-- Hatu Brown Bear
(20930, 2028, 1, 1, -1, 5182), -- Shilen Knife Edge
(20930, 2156, 1, 1, -1, 34888), -- Recipe: Elven Necklace
(20930, 2154, 1, 1, -1, 46692), -- Recipe: Elven Earring
(20930, 57, 184, 367, 0, 700000), -- Adena
(20930, 83, 1, 1, 1, 14.02224), -- Sword of Magic
(20930, 144, 1, 1, 1, 14.02224), -- Sword of Occult
(20930, 124, 1, 1, 1, 10.387776), -- Two-Handed Sword
(20930, 2026, 1, 1, 1, 464.791668), -- Two-Handed Sword Edge
(20930, 127, 1, 1, 1, 10.387776), -- Crimson Sword
(20930, 130, 1, 1, 1, 10.3883), -- Elven Sword
(20930, 1869, 1, 1, 2, 33124.743108), -- Iron Ore
(20930, 1864, 1, 1, 2, 66249.486216), -- Stem
(20930, 1880, 1, 1, 2, 3312.431766), -- Steel
(20930, 5550, 1, 1, 2, 441.615024), -- Durable Metal Plate
(20930, 2279, 1, 1, 2, 236.65545), -- Recipe: War Pick
(20930, 8317, 1, 1, 2, 236.65545), -- Recipe: Titan Hammer (100%)
(20930, 735, 1, 1, 2, 2760.412986), -- Alacrity Potion
-- Hatu Onyx Beast
(20931, 2271, 1, 1, -1, 3460), -- Recipe: Winged Spear
(20931, 1940, 1, 1, -1, 72301), -- Iron Boots Design
(20931, 1901, 1, 1, -1, 66909), -- Tiger's Eye Earring Stone
(20931, 57, 204, 409, 0, 700000), -- Adena
(20931, 293, 1, 1, 1, 34.5), -- War Hammer
(20931, 296, 1, 1, 1, 34.5), -- Dwarven Pike
(20931, 1865, 1, 1, 2, 36794.475256), -- Varnish
(20931, 1870, 1, 1, 2, 36794.475256), -- Coal
(20931, 1879, 1, 1, 2, 6132.440347), -- Cokes
(20931, 1875, 1, 1, 2, 2452.926091), -- Stone of Purity
(20931, 2276, 1, 1, 2, 262.834363), -- Recipe: Maingauche
(20931, 2286, 1, 1, 2, 204.445263), -- Recipe: Bonebreaker
(20931, 2197, 1, 1, 2, 771.403424), -- Recipe: Salamander Skin Mail
-- Hatu Crimson Bear
(20932, 1825, 1, 1, -1, 37742), -- Recipe: Oriharukon
(20932, 2032, 1, 1, -1, 4883), -- Goat Head Staff Head
(20932, 5220, 1, 1, -1, 21136), -- Metal Hardener
(20932, 57, 223, 446, 0, 700000), -- Adena
(20932, 850, 1, 1, 1, 126.629928), -- Elven Earring
(20932, 1902, 1, 1, 1, 4612.26069), -- Elven Earring Beads
(20932, 913, 1, 1, 1, 95.03991), -- Elven Necklace
(20932, 1904, 1, 1, 1, 4248.528534), -- Elven Necklace Beads
(20932, 881, 1, 1, 1, 190.07982), -- Elven Ring
(20932, 1903, 1, 1, 1, 7593.461118), -- Elven Ring Piece
(20932, 1866, 1, 1, 2, 26013.137496), -- Suede
(20932, 1871, 1, 1, 2, 39019.706244), -- Charcoal
(20932, 5220, 1, 1, 2, 1560.80127), -- Metal Hardener
(20932, 1885, 1, 1, 2, 3251.642187), -- High-Grade Suede
(20932, 2201, 1, 1, 2, 3788.401581), -- Recipe: Square Shield
(20932, 2159, 1, 1, 2, 2408.581647), -- Recipe: Necklace of Darkness
(20932, 1060, 1, 1, 2, 86710.729575), -- Lesser Healing Potion
-- Hatu Windsus
(20933, 1879, 1, 1, -1, 101112), -- Cokes
(20933, 1894, 1, 1, -1, 21287), -- Crafted Leather
(20933, 1880, 1, 1, -1, 60667), -- Steel
(20933, 57, 253, 505, 0, 700000), -- Adena
(20933, 261, 1, 1, 1, 29.207871), -- Bich'Hwa
(20933, 2039, 1, 1, 1, 1587.792129), -- Bich'Hwa Edge
(20933, 1865, 1, 1, 2, 52266.939944), -- Varnish
(20933, 1870, 1, 1, 2, 52266.939944), -- Coal
(20933, 1879, 1, 1, 2, 8711.176688), -- Cokes
(20933, 1875, 1, 1, 2, 3484.494712), -- Stone of Purity
(20933, 2159, 1, 1, 2, 3226.33948), -- Recipe: Necklace of Darkness
(20933, 2298, 1, 1, 2, 228.109232), -- Recipe: Stormbringer
-- Wasp Worker
(20934, 1868, 1, 1, -1, 654152), -- Thread
(20934, 2028, 1, 1, -1, 3886), -- Shilen Knife Edge
(20934, 1938, 1, 1, -1, 21988), -- Mithril Banded Mail Material
(20934, 57, 138, 276, 0, 700000), -- Adena
(20934, 436, 1, 1, 1, 148.555188), -- Tunic of Knowledge
(20934, 469, 1, 1, 1, 237.444812), -- Stockings of Knowledge
(20934, 1867, 1, 1, 2, 46374.15549), -- Animal Skin
(20934, 1872, 1, 1, 2, 46374.15549), -- Animal Bone
(20934, 1882, 1, 1, 2, 7728.99153), -- Leather
(20934, 2190, 1, 1, 2, 2484.281865), -- Recipe: Mithril Stockings
(20934, 3020, 1, 1, 2, 193.415625), -- Recipe: Elven Long Sword
-- Wasp Leader
(20935, 1872, 1, 1, -1, 475451), -- Animal Bone
(20935, 2040, 1, 1, -1, 4126), -- Reinforced Long Bow Shaft
(20935, 1825, 1, 1, -1, 25471), -- Recipe: Oriharukon
(20935, 57, 151, 301, 0, 700000), -- Adena
(20935, 629, 1, 1, 1, 101.89584), -- Kite Shield
(20935, 1947, 1, 1, 1, 4423.35942), -- Kite Shield Fragment
(20935, 2493, 1, 1, 1, 101.89584), -- Brigandine Shield
(20935, 2929, 1, 1, 1, 4423.35942), -- Brigandine Shield Fragment
(20935, 2411, 1, 1, 1, 71.362125), -- Brigandine Helmet
(20935, 2922, 1, 1, 1, 1183.127355), -- Brigandine Helmet Design
(20935, 1868, 1, 1, 2, 52665.454213), -- Thread
(20935, 1873, 1, 1, 2, 10533.105304), -- Silver Nugget
(20935, 5549, 1, 1, 2, 2633.276326), -- Metallic Thread
(20935, 1889, 1, 1, 2, 1755.541653), -- Compound Braid
(20935, 2148, 1, 1, 2, 1880.921991), -- Recipe: Crafted Leather
(20935, 2984, 1, 1, 2, 2692.495759), -- Recipe: Salamander Skin Boots
(20935, 2288, 1, 1, 2, 146.204754), -- Recipe: Ghost Staff
-- Tanor Silenos
(20936, 1874, 1, 1, -1, 45199), -- Oriharukon Ore
(20936, 1875, 1, 1, -1, 45199), -- Stone of Purity
(20936, 1902, 1, 1, -1, 68692), -- Elven Earring Beads
(20936, 57, 283, 565, 0, 700000), -- Adena
(20936, 437, 1, 1, 1, 101.881109), -- Mithril Tunic
(20936, 1944, 1, 1, 1, 4469.134758), -- Mithril Tunic Fabric
(20936, 470, 1, 1, 1, 162.708095), -- Mithril Stockings
(20936, 1945, 1, 1, 1, 6959.276038), -- Mithril Stocking Design
(20936, 1865, 1, 1, 2, 58411.514883), -- Varnish
(20936, 1870, 1, 1, 2, 58411.514883), -- Coal
(20936, 1879, 1, 1, 2, 9735.274866), -- Cokes
(20936, 1875, 1, 1, 2, 3894.136809), -- Stone of Purity
(20936, 2159, 1, 1, 2, 3605.632485), -- Recipe: Necklace of Darkness
(20936, 2298, 1, 1, 2, 254.926074), -- Recipe: Stormbringer
-- Tanor Silenos Grunt
(20937, 4480, 1, 1, -1, 5103), -- Dye of WIT (Wit+1 Men-1)
(20937, 2054, 1, 1, -1, 7601), -- Light Crossbow Shaft
(20937, 1805, 1, 1, -1, 2977), -- Recipe: Soulshot (C-Grade)
(20937, 57, 360, 727, 0, 700000), -- Adena
(20937, 1125, 1, 1, 1, 99.391617), -- Assault Boots
(20937, 1957, 1, 1, 1, 4171.091301), -- Assault Boots Part
(20937, 2427, 1, 1, 1, 99.391617), -- Salamander Skin Boots
(20937, 2931, 1, 1, 1, 4171.091301), -- Salamander Skin Boot Lining
(20937, 2428, 1, 1, 1, 99.391617), -- Plate Boots
(20937, 2932, 1, 1, 1, 4171.091301), -- Plate Boots Design
(20937, 61, 1, 1, 1, 99.391617), -- Mithril Plate Gloves
(20937, 1949, 1, 1, 1, 4171.091301), -- Mithril Gloves Design
(20937, 607, 1, 1, 1, 99.391617), -- Ogre Power Gauntlets
(20937, 1963, 1, 1, 1, 4171.091301), -- Ogre Power Gauntlets Part
(20937, 2451, 1, 1, 1, 99.391617), -- Sage's Worn Gloves
(20937, 2933, 1, 1, 1, 4171.193793), -- Sage's Worn Gloves Lining
(20937, 1866, 1, 1, 2, 42709.985513), -- Suede
(20937, 1871, 1, 1, 2, 64065.036868), -- Charcoal
(20937, 5220, 1, 1, 2, 2562.629602), -- Metal Hardener
(20937, 1885, 1, 1, 2, 5338.792138), -- High-Grade Suede
(20937, 2307, 1, 1, 2, 279.749239), -- Recipe: Heavy Doom Axe
(20937, 2205, 1, 1, 2, 2027.390903), -- Recipe: Chain Gaiters
(20937, 5164, 1, 1, 2, 213.415737), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
-- Tanor Silenos Scout
(20938, 2323, 1, 1, -1, 3431), -- Recipe: Elemental Bow
(20938, 2070, 1, 1, -1, 7819), -- Cursed Dagger Blade
(20938, 1908, 1, 1, -1, 93255), -- Moonstone Earring Wire
(20938, 57, 388, 794, 0, 700000), -- Adena
(20938, 281, 1, 1, 1, 26.406375), -- Crystallized Ice Bow
(20938, 2074, 1, 1, 1, 1648.593625), -- Crystallized Ice Bow Shaft
(20938, 1867, 1, 1, 2, 56414.7238), -- Animal Skin
(20938, 1872, 1, 1, 2, 56414.7238), -- Animal Bone
(20938, 1882, 1, 1, 2, 9402.496075), -- Leather
(20938, 1894, 1, 1, 2, 1484.5714), -- Crafted Leather
(20938, 2315, 1, 1, 2, 147.421275), -- Recipe: Shamshir
(20938, 2321, 1, 1, 2, 147.421275), -- Recipe: Stiletto
(20938, 2317, 1, 1, 2, 147.421275), -- Recipe: Bec de Corbin
(20938, 8723, 1, 1, 2, 1692.50235), -- Life Stone - Level 46
(20938, 8733, 1, 1, 2, 423.062425), -- Mid-Grade Life Stone - Level 46
(20938, 8743, 1, 1, 2, 42.318875), -- High-Grade Life Stone - Level 46
(20938, 8753, 1, 1, 2, 8.33745), -- Top-Grade Life Stone - Level 46
-- Tanor Silenos Warrior
(20939, 2067, 1, 1, -1, 7925), -- Crystal Staff Head
(20939, 1873, 1, 1, -1, 439855), -- Silver Nugget
(20939, 1868, 1, 5, -1, 733092), -- Thread
(20939, 57, 433, 886, 0, 700000), -- Adena
(20939, 397, 1, 1, 1, 89.299392), -- Mithril Shirt
(20939, 1961, 1, 1, 1, 4158.036834), -- Mithril Shirt Fabric
(20939, 2387, 1, 1, 1, 142.716336), -- Reinforced Mithril Gaiters
(20939, 2935, 1, 1, 1, 6907.947438), -- Reinforced Mithril Gaiters Fragment
(20939, 1868, 1, 1, 2, 94492.38564), -- Thread
(20939, 1873, 1, 1, 2, 18898.477128), -- Silver Nugget
(20939, 5549, 1, 1, 2, 4724.556084), -- Metallic Thread
(20939, 1889, 1, 1, 2, 3149.78832), -- Compound Braid
(20939, 4044, 1, 1, 2, 1574.89416), -- Thons
(20939, 2225, 1, 1, 2, 1027.093896), -- Recipe: Demon's Stockings
(20939, 2343, 1, 1, 2, 109.838124), -- Recipe: Mace of Underworld
(20939, 8723, 1, 1, 2, 1889.872992), -- Life Stone - Level 46
(20939, 8733, 1, 1, 2, 472.468248), -- Mid-Grade Life Stone - Level 46
(20939, 8743, 1, 1, 2, 47.272104), -- High-Grade Life Stone - Level 46
(20939, 8753, 1, 1, 2, 9.353304), -- Top-Grade Life Stone - Level 46
-- Tanor Silenos Shaman
(20940, 1970, 1, 1, -1, 36908), -- Robe of Seal Fabric
(20940, 5550, 1, 1, -1, 22037), -- Durable Metal Plate
(20940, 4589, 1, 1, -1, 5509), -- Greater Dye of STR (Str+2 Con-2)
(20940, 57, 653, 1328, 0, 700000), -- Adena
(20940, 4233, 1, 1, 1, 33.134608), -- Knuckle Duster
(20940, 4438, 1, 1, 1, 2610.865392), -- Knuckle Duster Edge
(20940, 1869, 1, 1, 2, 61024.781804), -- Iron Ore
(20940, 1864, 1, 1, 2, 122049.563608), -- Stem
(20940, 1880, 1, 1, 2, 6102.538064), -- Steel
(20940, 5550, 1, 1, 2, 813.618512), -- Durable Metal Plate
(20940, 4043, 1, 1, 2, 2034.245892), -- Asofe
(20940, 2350, 1, 1, 2, 127.75168), -- Recipe: Pa'agrian Axe
(20940, 3005, 1, 1, 2, 2490.758536), -- Recipe: Demon's Boots
(20940, 4132, 1, 1, 2, 2365.202588), -- Recipe: Composite Shield (100%)
(20940, 8724, 1, 1, 2, 2034.245892), -- Life Stone - Level 49
(20940, 8734, 1, 1, 2, 508.611376), -- Mid-Grade Life Stone - Level 49
(20940, 8744, 1, 1, 2, 50.90106), -- High-Grade Life Stone - Level 49
(20940, 8754, 1, 1, 2, 9.780988), -- Top-Grade Life Stone - Level 49
-- Tanor Silenos Chieftain
(20941, 2233, 1, 1, -1, 12171), -- Recipe: Divine Tunic
(20941, 2109, 1, 1, -1, 7302), -- Akat Longbow Shaft
(20941, 4601, 1, 1, -1, 2894), -- Greater Dye of STR (Str+3 Con-3)
(20941, 57, 515, 1047, 0, 700000), -- Adena
(20941, 60, 1, 1, 1, 43.890273), -- Composite Armor
(20941, 1977, 1, 1, 1, 3983.109727), -- Composite Armor Temper
(20941, 1870, 1, 1, 2, 44877.48583), -- Coal
(20941, 1865, 1, 1, 2, 44877.48583), -- Varnish
(20941, 1874, 1, 1, 2, 2991.80543), -- Oriharukon Ore
(20941, 4043, 1, 1, 2, 1495.902715), -- Asofe
(20941, 4039, 1, 1, 2, 1495.902715), -- Mold Glue
(20941, 3013, 1, 1, 2, 1253.578), -- Recipe: Drake Leather Boots
(20941, 3014, 1, 1, 2, 1253.578), -- Recipe: Full Plate Boots
(20941, 8725, 1, 1, 2, 1246.602445), -- Life Stone - Level 52
(20941, 8735, 1, 1, 2, 311.675885), -- Mid-Grade Life Stone - Level 52
(20941, 8745, 1, 1, 2, 31.13726), -- High-Grade Life Stone - Level 52
(20941, 8755, 1, 1, 2, 6.26789), -- Top-Grade Life Stone - Level 52
-- Nightmare Guide
(20942, 2301, 1, 1, -1, 2863), -- Recipe: Battle Axe
(20942, 2931, 1, 1, -1, 73162), -- Salamander Skin Boot Lining
(20942, 1905, 1, 1, -1, 63768), -- Omen Beast's Eye Earring Gemstone
(20942, 57, 259, 526, 0, 700000), -- Adena
(20942, 225, 1, 1, 1, 23.731105), -- Mithril Dagger
(20942, 2052, 1, 1, 1, 1427.268895), -- Mithril Dagger Blade
(20942, 1871, 1, 1, 2, 41147.300372), -- Charcoal
(20942, 1866, 1, 1, 2, 27431.55799), -- Suede
(20942, 1877, 1, 1, 2, 1645.900802), -- Adamantite Nugget
(20942, 2225, 1, 1, 2, 894.528816), -- Recipe: Demon's Stockings
(20942, 8723, 1, 1, 2, 1645.900802), -- Life Stone - Level 46
(20942, 8733, 1, 1, 2, 411.456894), -- Mid-Grade Life Stone - Level 46
(20942, 8743, 1, 1, 2, 41.153012), -- High-Grade Life Stone - Level 46
(20942, 8753, 1, 1, 2, 8.201312), -- Top-Grade Life Stone - Level 46
-- Nightmare Keeper
(20943, 1874, 1, 1, -1, 62887), -- Oriharukon Ore
(20943, 1875, 1, 1, -1, 62887), -- Stone of Purity
(20943, 2163, 1, 1, -1, 48128), -- Recipe: Earring of Protection
(20943, 57, 373, 758, 0, 700000), -- Adena
(20943, 263, 1, 1, 1, 25.28482), -- Chakram
(20943, 2073, 1, 1, 1, 1722.71518), -- Chakram Edge
(20943, 1872, 1, 1, 2, 59442.614958), -- Animal Bone
(20943, 1867, 1, 1, 2, 59442.614958), -- Animal Skin
(20943, 1881, 1, 1, 2, 5944.287784), -- Coarse Bone Powder
(20943, 1875, 1, 1, 2, 2972.143892), -- Stone of Purity
(20943, 4041, 1, 1, 2, 387.619509), -- Mold Hardener
(20943, 2225, 1, 1, 2, 969.114493), -- Recipe: Demon's Stockings
(20943, 8723, 1, 1, 2, 1783.260047), -- Life Stone - Level 46
(20943, 8733, 1, 1, 2, 445.847872), -- Mid-Grade Life Stone - Level 46
(20943, 8743, 1, 1, 2, 44.558499), -- High-Grade Life Stone - Level 46
(20943, 8753, 1, 1, 2, 8.937988), -- Top-Grade Life Stone - Level 46
-- Nightmare Lord
(20944, 2947, 1, 1, -1, 57031), -- Dwarven Chain Shield Fragment
(20944, 2329, 1, 1, -1, 1857), -- Recipe: Tsurugi
(20944, 1911, 1, 1, -1, 59386), -- Earring of Protection Gemstone
(20944, 57, 315, 643, 0, 700000), -- Adena
(20944, 853, 1, 1, 1, 78.35292), -- Earring of Protection
(20944, 1911, 1, 1, 1, 4385.664), -- Earring of Protection Gemstone
(20944, 916, 1, 1, 1, 58.78656), -- Necklace of Protection
(20944, 1913, 1, 1, 1, 3585.60108), -- Necklace of Protection Gemstone
(20944, 884, 1, 1, 1, 117.57312), -- Ring of Protection
(20944, 1912, 1, 1, 1, 6354.02232), -- Ring of Protection Gemstone
(20944, 1873, 1, 1, 2, 14150.763066), -- Silver Nugget
(20944, 1868, 1, 1, 2, 70753.81533), -- Thread
(20944, 1876, 1, 1, 2, 7075.381533), -- Mithril Ore
(20944, 1895, 1, 1, 2, 10107.732591), -- Metallic Fiber
(20944, 4042, 1, 1, 2, 589.641195), -- Enria
(20944, 2328, 1, 1, 2, 82.268241), -- Recipe: Sword of Delusion
(20944, 8724, 1, 1, 2, 1179.28239), -- Life Stone - Level 49
(20944, 8734, 1, 1, 2, 294.768463), -- Mid-Grade Life Stone - Level 49
(20944, 8744, 1, 1, 2, 29.508127), -- High-Grade Life Stone - Level 49
(20944, 8754, 1, 1, 2, 5.839064), -- Top-Grade Life Stone - Level 49
-- Cadeine
(20945, 1868, 1, 3, -1, 897692), -- Thread
(20945, 1876, 1, 1, -1, 179538), -- Mithril Ore
(20945, 4601, 1, 1, -1, 1995), -- Greater Dye of STR (Str+3 Con-3)
(20945, 57, 355, 722, 0, 700000), -- Adena
(20945, 64, 1, 1, 1, 98.312175), -- Composite Boots
(20945, 2956, 1, 1, 1, 5459.187825), -- Composite Boots Part
(20945, 608, 1, 1, 1, 98.312175), -- Mithril Gauntlets
(20945, 1981, 1, 1, 1, 5459.187825), -- Mithril Gauntlets Design
(20945, 1873, 1, 1, 2, 13499.220456), -- Silver Nugget
(20945, 1868, 1, 1, 2, 67495.899996), -- Thread
(20945, 1876, 1, 1, 2, 6749.610228), -- Mithril Ore
(20945, 1895, 1, 1, 2, 9642.271428), -- Metallic Fiber
(20945, 4042, 1, 1, 2, 562.450662), -- Enria
(20945, 2170, 1, 1, 2, 795.98754), -- Recipe: Nassen's Earring
(20945, 2970, 1, 1, 2, 1196.712144), -- Recipe: Ring of Seal
(20945, 8725, 1, 1, 2, 937.485198), -- Life Stone - Level 52
(20945, 8735, 1, 1, 2, 234.346014), -- Mid-Grade Life Stone - Level 52
(20945, 8745, 1, 1, 2, 23.464944), -- High-Grade Life Stone - Level 52
(20945, 8755, 1, 1, 2, 4.55139), -- Top-Grade Life Stone - Level 52
-- Sanhidro
(20946, 1539, 1, 1, -1, 307481), -- Greater Healing Potion
(20946, 1914, 1, 1, -1, 77734), -- Earring of Seal Gemstone
(20946, 2169, 1, 1, -1, 24490), -- Recipe: Necklace of Seal
(20946, 57, 550, 1111, 0, 700000), -- Adena
(20946, 103, 1, 1, 1, 72.138022), -- Tower Shield
(20946, 1978, 1, 1, 1, 4584.843537), -- Tower Shield Fragment
(20946, 107, 1, 1, 1, 72.138022), -- Composite Shield
(20946, 4055, 1, 1, 1, 4584.843537), -- Composite Shield Fragment
(20946, 517, 1, 1, 1, 50.51858), -- Composite Helmet
(20946, 2957, 1, 1, 1, 3136.999861), -- Composite Helmet Design
(20946, 1149, 1, 1, 1, 50.51858), -- Shining Circlet
(20946, 1983, 1, 1, 1, 3136.999861), -- Shining Circlet Pattern
(20946, 1864, 1, 1, 2, 104035.737255), -- Stem
(20946, 1869, 1, 1, 2, 52017.759267), -- Iron Ore
(20946, 1878, 1, 1, 2, 20807.147451), -- Braided Hemp
(20946, 1884, 1, 1, 2, 32010.911955), -- Cord
(20946, 4039, 1, 1, 2, 1734.020088), -- Mold Glue
(20946, 2233, 1, 1, 2, 486.216783), -- Recipe: Divine Tunic
(20946, 4180, 1, 1, 2, 5779.702425), -- Recipe: Silver Arrow (100%)
(20946, 8725, 1, 1, 2, 1444.870926), -- Life Stone - Level 52
(20946, 8735, 1, 1, 2, 361.327092), -- Mid-Grade Life Stone - Level 52
(20946, 8745, 1, 1, 2, 36.088965), -- High-Grade Life Stone - Level 52
(20946, 8755, 1, 1, 2, 7.217793), -- Top-Grade Life Stone - Level 52
-- Connabi
(20947, 4967, 1, 1, -1, 1726), -- Recipe: Sword of Valhalla (60%)
(20947, 4938, 1, 1, -1, 37080), -- Recipe: Adamantite Ring (70%)
(20947, 1806, 1, 1, -1, 2996), -- Recipe: Soulshot (B-Grade)
(20947, 57, 592, 1205, 0, 700000), -- Adena
(20947, 356, 1, 1, 1, 30.932675), -- Full Plate Armor
(20947, 1986, 1, 1, 1, 2922.067325), -- Full Plate Armor Temper
(20947, 1869, 1, 1, 2, 46093.153575), -- Iron Ore
(20947, 1864, 1, 1, 2, 92186.454675), -- Stem
(20947, 1880, 1, 1, 2, 4609.2711), -- Steel
(20947, 5550, 1, 1, 2, 614.58915), -- Durable Metal Plate
(20947, 4043, 1, 1, 2, 1536.472875), -- Asofe
(20947, 4179, 1, 1, 2, 592.4604), -- Recipe: Zubei's Helmet (100%)
(20947, 4184, 1, 1, 2, 53.109), -- Recipe: Sprite's Staff (100%)
(20947, 4144, 1, 1, 2, 473.702775), -- Recipe: Zubei's Leather Gaiters (100%)
(20947, 8726, 1, 1, 2, 1066.9008), -- Life Stone - Level 55
(20947, 8736, 1, 1, 2, 266.7252), -- Mid-Grade Life Stone - Level 55
(20947, 8746, 1, 1, 2, 26.702025), -- High-Grade Life Stone - Level 55
(20947, 8756, 1, 1, 2, 5.458425), -- Top-Grade Life Stone - Level 55
-- Bartal
(20948, 4049, 1, 1, -1, 78274), -- Adamantite Earring Gemstone
(20948, 4129, 1, 1, -1, 16150), -- Recipe: Earrings of Black Ore (100%)
(20948, 4050, 1, 1, -1, 92459), -- Adamantite Ring Wire
(20948, 57, 589, 1202, 0, 700000), -- Adena
(20948, 11889, 1, 1, 1, 42.03066), -- Common Item - Great Sword
(20948, 4104, 1, 1, 1, 420.310722), -- Great Sword Blade
(20948, 11916, 1, 1, 1, 42.03066), -- Common Item - Keshanberk
(20948, 4107, 1, 1, 1, 413.797962), -- Keshanberk Blade
(20948, 11900, 1, 1, 1, 42.03066), -- Common Item - Sword of Valhalla
(20948, 4108, 1, 1, 1, 413.799336), -- Sword of Valhalla Blade
(20948, 1865, 1, 1, 2, 36733.092399), -- Varnish
(20948, 1870, 1, 1, 2, 36733.092399), -- Coal
(20948, 1879, 1, 1, 2, 6122.16801), -- Cokes
(20948, 1875, 1, 1, 2, 2448.867204), -- Stone of Purity
(20948, 4040, 1, 1, 2, 734.677029), -- Mold Lubricant
(20948, 948, 1, 1, 2, 91.845171), -- Scroll: Enchant Armor (B-Grade)
(20948, 4176, 1, 1, 2, 456.864363), -- Recipe: Sealed Doom Boots (100%)
(20948, 4158, 1, 1, 2, 78.013575), -- Recipe: Doom Plate Armor (100%)
(20948, 8727, 1, 1, 2, 734.677029), -- Life Stone - Level 58
(20948, 8737, 1, 1, 2, 183.690342), -- Mid-Grade Life Stone - Level 58
(20948, 8747, 1, 1, 2, 18.385902), -- High-Grade Life Stone - Level 58
(20948, 8757, 1, 1, 2, 3.626577), -- Top-Grade Life Stone - Level 58
-- Luminun
(20949, 947, 1, 1, -1, 706), -- Scroll: Enchant Weapon (B-Grade)
(20949, 4041, 1, 1, -1, 15347), -- Mold Hardener
(20949, 1866, 1, 3, -1, 588296), -- Suede
(20949, 57, 697, 1420, 0, 700000), -- Adena
(20949, 11918, 1, 1, 1, 74.601684), -- Common Item - Heavy War Axe
(20949, 4105, 1, 1, 1, 746.018469), -- Heavy War Axe Head
(20949, 11908, 1, 1, 1, 74.601684), -- Common Item - Sprite's Staff
(20949, 4106, 1, 1, 1, 733.778163), -- Sprite's Staff Head
(20949, 1866, 1, 1, 2, 28962.20029), -- Suede
(20949, 1871, 1, 1, 2, 43443.300435), -- Charcoal
(20949, 5220, 1, 1, 2, 1737.748142), -- Metal Hardener
(20949, 1885, 1, 1, 2, 3620.295192), -- High-Grade Suede
(20949, 4041, 1, 1, 2, 377.799378), -- Mold Hardener
(20949, 4129, 1, 1, 2, 470.193336), -- Recipe: Earrings of Black Ore (100%)
(20949, 4993, 1, 1, 2, 540.335346), -- Recipe: Sealed Doom Gloves (60%)
(20949, 4165, 1, 1, 2, 359.014219), -- Recipe: Blue Wolf Helmet (100%)
(20949, 8727, 1, 1, 2, 868.874071), -- Life Stone - Level 58
(20949, 8737, 1, 1, 2, 217.198362), -- Mid-Grade Life Stone - Level 58
(20949, 8747, 1, 1, 2, 21.687587), -- High-Grade Life Stone - Level 58
(20949, 8757, 1, 1, 2, 4.353642), -- Top-Grade Life Stone - Level 58
-- Innersen
(20950, 4056, 1, 1, -1, 34524), -- Zubei's Breastplate Part
(20950, 4049, 1, 1, -1, 100049), -- Adamantite Earring Gemstone
(20950, 947, 1, 1, -1, 763), -- Scroll: Enchant Weapon (B-Grade)
(20950, 57, 754, 1534, 0, 700000), -- Adena
(20950, 11890, 1, 1, 1, 161.225658), -- Common Item - Great Axe
(20950, 4113, 1, 1, 1, 1449.774342), -- Great Axe Head
(20950, 1869, 1, 1, 2, 51220.563425), -- Iron Ore
(20950, 1864, 1, 1, 2, 102440.964015), -- Stem
(20950, 1880, 1, 1, 2, 5121.974925), -- Steel
(20950, 5550, 1, 1, 2, 682.92999), -- Durable Metal Plate
(20950, 4043, 1, 1, 2, 1707.324975), -- Asofe
(20950, 4159, 1, 1, 2, 145.085985), -- Recipe: Blue Wolf Leather Armor (100%)
(20950, 4990, 1, 1, 2, 423.371), -- Recipe: Blue Wolf Helmet (60%)
(20950, 8728, 1, 1, 2, 853.743905), -- Life Stone - Level 61
(20950, 8738, 1, 1, 2, 213.476685), -- Mid-Grade Life Stone - Level 61
(20950, 8748, 1, 1, 2, 21.331385), -- High-Grade Life Stone - Level 61
(20950, 8758, 1, 1, 2, 4.23371), -- Top-Grade Life Stone - Level 61
-- Pobby's Maid
(20951, 1918, 1, 1, -1, 43851), -- Nassen's Earring Gemstone
(20951, 1806, 1, 1, -1, 2025), -- Recipe: Soulshot (B-Grade)
(20951, 1920, 1, 1, -1, 34646), -- Necklace of Seal Chain
(20951, 57, 401, 814, 0, 700000), -- Adena
(20951, 266, 1, 1, 1, 7.932936), -- Great Pata
(20951, 2120, 1, 1, 1, 898.067064), -- Great Pata Blade
(20951, 1867, 1, 1, 2, 41539.858702), -- Animal Skin
(20951, 1872, 1, 1, 2, 41539.858702), -- Animal Bone
(20951, 1882, 1, 1, 2, 6923.325236), -- Leather
(20951, 1894, 1, 1, 2, 1093.190774), -- Crafted Leather
(20951, 4042, 1, 1, 2, 519.291114), -- Enria
(20951, 1806, 1, 1, 2, 62.303808), -- Recipe: Soulshot (B-Grade)
(20951, 5270, 1, 1, 2, 62.303808), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20951, 5436, 1, 1, 2, 50.807272), -- Recipe: Berserker Blade(100%)
(20951, 8726, 1, 1, 2, 721.222206), -- Life Stone - Level 55
(20951, 8736, 1, 1, 2, 180.32873), -- Mid-Grade Life Stone - Level 55
(20951, 8746, 1, 1, 2, 17.986516), -- High-Grade Life Stone - Level 55
(20951, 8756, 1, 1, 2, 3.523132), -- Top-Grade Life Stone - Level 55
-- Pobby Escort
(20952, 3034, 1, 1, -1, 3670), -- Recipe: Spiritshot B
(20952, 1984, 1, 1, -1, 39333), -- Theca Leather Armor Pattern
(20952, 4044, 1, 1, -1, 61163), -- Thons
(20952, 57, 725, 1477, 0, 700000), -- Adena
(20952, 286, 1, 1, 1, 14.372796), -- Eminence Bow
(20952, 2121, 1, 1, 1, 1557.627204), -- Eminence Bow Shaft
(20952, 1868, 1, 1, 2, 112917.336858), -- Thread
(20952, 1873, 1, 1, 2, 22583.49724), -- Silver Nugget
(20952, 5549, 1, 1, 2, 5645.87431), -- Metallic Thread
(20952, 1889, 1, 1, 2, 3763.866426), -- Compound Braid
(20952, 4044, 1, 1, 2, 1882.007884), -- Thons
(20952, 4128, 1, 1, 2, 698.771218), -- Recipe: Adamantite Necklace (100%)
(20952, 5275, 1, 1, 2, 112.902552), -- Recipe: Greater Spiritshot (B) Compressed Package(100%)
(20952, 4187, 1, 1, 2, 65.113112), -- Recipe: Kris (100%)
(20952, 8726, 1, 1, 2, 1306.891842), -- Life Stone - Level 55
(20952, 8736, 1, 1, 2, 326.760296), -- Mid-Grade Life Stone - Level 55
(20952, 8746, 1, 1, 2, 32.705898), -- High-Grade Life Stone - Level 55
(20952, 8756, 1, 1, 2, 6.272364), -- Top-Grade Life Stone - Level 55
-- Pobby
(20953, 4948, 1, 1, -1, 7508), -- Recipe: Avadon Leather Armor (60%)
(20953, 2962, 1, 1, -1, 93209), -- Drake Leather Gloves Design
(20953, 1864, 1, 7, -1, 855888), -- Stem
(20953, 57, 675, 1379, 0, 700000), -- Adena
(20953, 12338, 1, 1, 1, 690.734994), -- Common Item - Adamantite Earring
(20953, 4049, 1, 1, 1, 4420.076379), -- Adamantite Earring Gemstone
(20953, 12339, 1, 1, 1, 518.574231), -- Common Item - Adamantite Necklace
(20953, 4051, 1, 1, 1, 3268.12881), -- Adamantite Necklace Chain
(20953, 12340, 1, 1, 1, 1040.36217), -- Common Item - Adamantite Ring
(20953, 4050, 1, 1, 1, 5221.123416), -- Adamantite Ring Wire
(20953, 1864, 1, 1, 2, 84271.931253), -- Stem
(20953, 1869, 1, 1, 2, 42135.87924), -- Iron Ore
(20953, 1878, 1, 1, 2, 16854.351696), -- Braided Hemp
(20953, 1884, 1, 1, 2, 25929.77184), -- Cord
(20953, 4039, 1, 1, 2, 1404.471717), -- Mold Glue
(20953, 4962, 1, 1, 2, 541.643355), -- Recipe: Zubei's Helmet (60%)
(20953, 4999, 1, 1, 2, 524.020509), -- Recipe: Sealed Doom Boots (60%)
(20953, 8311, 1, 1, 2, 32.135778), -- Recipe: Kaim Vanul's Bones (100%)
(20953, 8727, 1, 1, 2, 842.786694), -- Life Stone - Level 58
(20953, 8737, 1, 1, 2, 210.610287), -- Mid-Grade Life Stone - Level 58
(20953, 8747, 1, 1, 2, 21.078306), -- High-Grade Life Stone - Level 58
(20953, 8757, 1, 1, 2, 4.319325), -- Top-Grade Life Stone - Level 58
-- Hungered Corpse
(20954, 4613, 1, 1, -1, 2805), -- Greater Dye of STR (Str+4 Con-4)
(20954, 4049, 1, 1, -1, 106679), -- Adamantite Earring Gemstone
(20954, 1869, 1, 5, -1, 677943), -- Iron Ore
(20954, 57, 804, 1635, 0, 700000), -- Adena
(20954, 11915, 1, 1, 1, 85.937856), -- Common Item - Kris
(20954, 4109, 1, 1, 1, 846.062144), -- Kris Edge
(20954, 11919, 1, 1, 1, 85.937856), -- Common Item - Hell Knife
(20954, 4110, 1, 1, 1, 846.062144), -- Hell Knife Edge
(20954, 1869, 1, 1, 2, 54614.611875), -- Iron Ore
(20954, 1864, 1, 1, 2, 109229.050125), -- Stem
(20954, 1880, 1, 1, 2, 5461.374375), -- Steel
(20954, 5550, 1, 1, 2, 728.18325), -- Durable Metal Plate
(20954, 4043, 1, 1, 2, 1820.458125), -- Asofe
(20954, 4159, 1, 1, 2, 154.699875), -- Recipe: Blue Wolf Leather Armor (100%)
(20954, 4990, 1, 1, 2, 451.425), -- Recipe: Blue Wolf Helmet (60%)
(20954, 8728, 1, 1, 2, 910.315875), -- Life Stone - Level 61
(20954, 8738, 1, 1, 2, 227.622375), -- Mid-Grade Life Stone - Level 61
(20954, 8748, 1, 1, 2, 22.744875), -- High-Grade Life Stone - Level 61
(20954, 8758, 1, 1, 2, 4.51425), -- Top-Grade Life Stone - Level 61
-- Ghostly Warrior
(20955, 5230, 1, 1, -1, 3164), -- Recipe: Mithril Arrow (100%)
(20955, 4052, 1, 1, -1, 84007), -- Earring of Black Ore Piece
(20955, 57, 941, 1906, 0, 700000), -- Adena
(20955, 12194, 1, 1, 1, 191.508928), -- Common Item - Blue Wolf Leather Armor
(20955, 4082, 1, 1, 1, 1979.991072), -- Blue Wolf Leather Armor Texture
(20955, 12186, 1, 1, 1, 191.508928), -- Common Item - Leather Armor of Doom
(20955, 4083, 1, 1, 1, 1979.991072), -- Leather Armor of Doom Design
(20955, 1870, 1, 1, 2, 63717.00321), -- Coal
(20955, 1865, 1, 1, 2, 63717.00321), -- Varnish
(20955, 1874, 1, 1, 2, 4247.800214), -- Oriharukon Ore
(20955, 4043, 1, 1, 2, 2123.900107), -- Asofe
(20955, 4039, 1, 1, 2, 2123.900107), -- Mold Glue
(20955, 1830, 1, 1, 2, 25486.801284), -- Scroll of Escape: Castle
(20955, 5276, 1, 1, 2, 85.034047), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20955, 8729, 1, 1, 2, 849.527525), -- Life Stone - Level 64
(20955, 8739, 1, 1, 2, 212.341234), -- Mid-Grade Life Stone - Level 64
(20955, 8749, 1, 1, 2, 21.299159), -- High-Grade Life Stone - Level 64
(20955, 8759, 1, 1, 2, 4.389903), -- Top-Grade Life Stone - Level 64
-- Past Knight
(20956, 4987, 1, 1, -1, 9891), -- Recipe: Tunic of Doom (60%)
(20956, 4106, 1, 1, -1, 13417), -- Sprite's Staff Head
(20956, 1884, 1, 3, -1, 733439), -- Cord
(20956, 57, 946, 1914, 0, 700000), -- Adena
(20956, 11939, 1, 1, 1, 114.995952), -- Common Item - Demon's Dagger
(20956, 4119, 1, 1, 1, 1541.004048), -- Demon's Dagger Edge
(20956, 1874, 1, 1, 2, 3911.681418), -- Oriharukon Ore
(20956, 1878, 1, 1, 2, 23469.967654), -- Braided Hemp
(20956, 1884, 1, 1, 2, 36107.670434), -- Cord
(20956, 1889, 1, 1, 2, 3911.681418), -- Compound Braid
(20956, 5220, 1, 1, 2, 2346.98468), -- Metal Hardener
(20956, 4175, 1, 1, 2, 1130.58917), -- Recipe: Sealed Avadon Boots (100%)
(20956, 2508, 1, 1, 2, 48895.836444), -- Cursed Bone
(20956, 3956, 1, 1, 2, 78.192538), -- Recipe: Blessed Spiritshot A
(20956, 8729, 1, 1, 2, 782.287942), -- Life Stone - Level 64
(20956, 8739, 1, 1, 2, 195.541772), -- Mid-Grade Life Stone - Level 64
(20956, 8749, 1, 1, 2, 19.578348), -- High-Grade Life Stone - Level 64
(20956, 8759, 1, 1, 2, 3.988182), -- Top-Grade Life Stone - Level 64
-- Nihil Invader
(20957, 4053, 1, 1, -1, 107147), -- Ring of Black Ore Gemstone
(20957, 1877, 1, 1, -1, 99989), -- Adamantite Nugget
(20957, 4052, 1, 1, -1, 88502), -- Earring of Black Ore Piece
(20957, 57, 990, 2008, 0, 700000), -- Adena
(20957, 12183, 1, 1, 1, 624.694206), -- Common Item - Doom Shield
(20957, 4077, 1, 1, 1, 5535.988494), -- Doom Shield Fragment
(20957, 12202, 1, 1, 1, 437.17812), -- Common Item - Blue Wolf Helmet
(20957, 4088, 1, 1, 1, 4650.98053), -- Blue Wolf Helmet Design
(20957, 12185, 1, 1, 1, 437.17812), -- Common Item - Doom Helmet
(20957, 4089, 1, 1, 1, 4650.98053), -- Doom Helmet Pattern
(20957, 1871, 1, 1, 2, 61532.00592), -- Charcoal
(20957, 1866, 1, 1, 2, 41021.33728), -- Suede
(20957, 1877, 1, 1, 2, 2461.33888), -- Adamantite Nugget
(20957, 4041, 1, 1, 2, 535.1192), -- Mold Hardener
(20957, 4040, 1, 1, 2, 1230.66944), -- Mold Lubricant
(20957, 1830, 1, 1, 2, 24612.76048), -- Scroll of Escape: Castle
(20957, 5276, 1, 1, 2, 82.10048), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20957, 8729, 1, 1, 2, 820.37648), -- Life Stone - Level 64
(20957, 8739, 1, 1, 2, 205.04176), -- Mid-Grade Life Stone - Level 64
(20957, 8749, 1, 1, 2, 20.52512), -- High-Grade Life Stone - Level 64
(20957, 8759, 1, 1, 2, 4.1888), -- Top-Grade Life Stone - Level 64
(20957, 1344, 10, 30, 2, 76914.53616), -- Mithril Arrow
-- Death Agent
(20958, 5478, 1, 1, -1, 15776), -- Sealed Dark Crystal Leather Armor Pattern
(20958, 1807, 1, 1, -1, 2501), -- Recipe: Soulshot (A-Grade)
(20958, 57, 742, 1509, 0, 700000), -- Adena
(20958, 12225, 1, 1, 1, 383.207895), -- Common Item - Sealed Dark Crystal Shield
(20958, 5494, 1, 1, 1, 1939.59099), -- Sealed Dark Crystal Shield Fragment
(20958, 12226, 1, 1, 1, 268.46784), -- Common Item - Sealed Dark Crystal Helmet
(20958, 5525, 1, 1, 1, 1427.62986), -- Sealed Dark Crystal Helmet Design
(20958, 12234, 1, 1, 1, 268.46784), -- Common Item - Sealed Tallum Helmet
(20958, 5526, 1, 1, 1, 1427.635575), -- Sealed Tallum Helm Design
(20958, 1872, 1, 1, 2, 73888.48786), -- Animal Bone
(20958, 1867, 1, 1, 2, 73888.48786), -- Animal Skin
(20958, 1881, 1, 1, 2, 7388.768684), -- Coarse Bone Powder
(20958, 1875, 1, 1, 2, 3694.464444), -- Stone of Purity
(20958, 4041, 1, 1, 2, 481.893632), -- Mold Hardener
(20958, 5156, 1, 1, 2, 73.854044), -- Recipe: Soulshot (A) Compressed Package (100%)
(20958, 8730, 1, 1, 2, 615.663972), -- Life Stone - Level 67
(20958, 8740, 1, 1, 2, 153.956044), -- Mid-Grade Life Stone - Level 67
(20958, 8750, 1, 1, 2, 15.379584), -- High-Grade Life Stone - Level 67
(20958, 8760, 1, 1, 2, 3.043876), -- Top-Grade Life Stone - Level 67
-- Dark Guard
(20959, 4054, 1, 1, -1, 59502), -- Necklace of Black Ore Beads
(20959, 5478, 1, 1, -1, 25403), -- Sealed Dark Crystal Leather Armor Pattern
(20959, 1807, 1, 1, -1, 4028), -- Recipe: Soulshot (A-Grade)
(20959, 57, 1195, 2431, 0, 700000), -- Adena
(20959, 12232, 1, 1, 1, 216.001044), -- Common Item - Sealed Tallum Tunic
(20959, 5485, 1, 1, 1, 1250.548992), -- Sealed Tallum Tunic Texture
(20959, 12223, 1, 1, 1, 132.780816), -- Common Item - Sealed Dark Crystal Robe
(20959, 5486, 1, 1, 1, 879.972156), -- Sealed Dark Crystal Robe Fabric
(20959, 12235, 1, 1, 1, 345.851604), -- Common Item - Sealed Tallum Stockings
(20959, 5489, 1, 1, 1, 1962.845388), -- Sealed Tallum Stockings Fabric
(20959, 1871, 1, 1, 2, 81120.798288), -- Charcoal
(20959, 1866, 1, 1, 2, 54080.532192), -- Suede
(20959, 1877, 1, 1, 2, 3244.763004), -- Adamantite Nugget
(20959, 4041, 1, 1, 2, 705.358288), -- Mold Hardener
(20959, 4040, 1, 1, 2, 1622.381502), -- Mold Lubricant
(20959, 4953, 1, 1, 2, 1563.075115), -- Recipe: Sealed Avadon Gloves (60%)
(20959, 5281, 1, 1, 2, 108.130047), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(20959, 8730, 1, 1, 2, 901.370923), -- Life Stone - Level 67
(20959, 8740, 1, 1, 2, 225.306831), -- Mid-Grade Life Stone - Level 67
(20959, 8750, 1, 1, 2, 22.545043), -- High-Grade Life Stone - Level 67
(20959, 8760, 1, 1, 2, 4.738767), -- Top-Grade Life Stone - Level 67
-- Bloody Ghost
(20960, 4052, 1, 1, -1, 58175), -- Earring of Black Ore Piece
(20960, 5230, 1, 1, -1, 2191), -- Recipe: Mithril Arrow (100%)
(20960, 4053, 1, 1, -1, 70431), -- Ring of Black Ore Gemstone
(20960, 57, 652, 1319, 0, 700000), -- Adena
(20960, 11932, 1, 1, 1, 79.271942), -- Common Item - Lance
(20960, 4115, 1, 1, 1, 1058.728058), -- Lance Blade
(20960, 1873, 1, 1, 2, 16178.77374), -- Silver Nugget
(20960, 1868, 1, 1, 2, 80893.516758), -- Thread
(20960, 1876, 1, 1, 2, 8089.38687), -- Mithril Ore
(20960, 1895, 1, 1, 2, 11556.191541), -- Metallic Fiber
(20960, 4042, 1, 1, 2, 674.144901), -- Enria
(20960, 5230, 1, 1, 2, 53.847126), -- Recipe: Mithril Arrow (100%)
(20960, 5276, 1, 1, 2, 53.847126), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20960, 8729, 1, 1, 2, 539.351115), -- Life Stone - Level 64
(20960, 8739, 1, 1, 2, 134.793786), -- Mid-Grade Life Stone - Level 64
(20960, 8749, 1, 1, 2, 13.549767), -- High-Grade Life Stone - Level 64
(20960, 8759, 1, 1, 2, 2.639565), -- Top-Grade Life Stone - Level 64
(20960, 1343, 10, 30, 2, 57780.957705), -- Silver Arrow
-- Bloody Knight
(20961, 1884, 1, 3, -1, 744103), -- Cord
(20961, 4053, 1, 1, -1, 103658), -- Ring of Black Ore Gemstone
(20961, 5230, 1, 1, -1, 3224), -- Recipe: Mithril Arrow (100%)
(20961, 57, 958, 1943, 0, 700000), -- Adena
(20961, 12188, 1, 1, 1, 474.972605), -- Common Item - Sealed Doom Boots
(20961, 4099, 1, 1, 1, 4008.777395), -- Sealed Doom Boots Part
(20961, 12189, 1, 1, 1, 474.972605), -- Common Item - Sealed Blue Wolf Boots
(20961, 4090, 1, 1, 1, 4008.777395), -- Sealed Blue Wolf Boots Design
(20961, 12187, 1, 1, 1, 474.972605), -- Common Item - Sealed Doom Gloves
(20961, 4091, 1, 1, 1, 4008.777395), -- Sealed Doom Gloves Part
(20961, 12190, 1, 1, 1, 474.972605), -- Common Item - Sealed Blue Wolf Gloves
(20961, 4096, 1, 1, 1, 4008.777395), -- Sealed Blue Wolf Gloves Fabric
(20961, 1864, 1, 1, 2, 119056.63003), -- Stem
(20961, 1869, 1, 1, 2, 59528.19391), -- Iron Ore
(20961, 1878, 1, 1, 2, 23811.42289), -- Braided Hemp
(20961, 1884, 1, 1, 2, 36632.80924), -- Cord
(20961, 4039, 1, 1, 2, 1984.18432), -- Mold Glue
(20961, 5230, 1, 1, 2, 79.44488), -- Recipe: Mithril Arrow (100%)
(20961, 3956, 1, 1, 2, 79.44488), -- Recipe: Blessed Spiritshot A
(20961, 8326, 1, 1, 2, 22.04111), -- Recipe: Doom Crusher (60%)
(20961, 8729, 1, 1, 2, 793.72217), -- Life Stone - Level 64
(20961, 8739, 1, 1, 2, 198.36999), -- Mid-Grade Life Stone - Level 64
(20961, 8749, 1, 1, 2, 19.86122), -- High-Grade Life Stone - Level 64
(20961, 8759, 1, 1, 2, 3.87536), -- Top-Grade Life Stone - Level 64
-- Bloody Priest
(20962, 4054, 1, 1, -1, 45467), -- Necklace of Black Ore Beads
(20962, 5230, 1, 1, -1, 3078), -- Recipe: Mithril Arrow (100%)
(20962, 4077, 1, 1, -1, 103839), -- Doom Shield Fragment
(20962, 57, 914, 1854, 0, 700000), -- Adena
(20962, 12194, 1, 1, 1, 186.3056), -- Common Item - Blue Wolf Leather Armor
(20962, 4082, 1, 1, 1, 1926.1944), -- Blue Wolf Leather Armor Texture
(20962, 12186, 1, 1, 1, 186.3056), -- Common Item - Leather Armor of Doom
(20962, 4083, 1, 1, 1, 1926.1944), -- Leather Armor of Doom Design
(20962, 1865, 1, 1, 2, 56821.062477), -- Varnish
(20962, 1870, 1, 1, 2, 56821.062477), -- Coal
(20962, 1879, 1, 1, 2, 9470.11249), -- Cokes
(20962, 1875, 1, 1, 2, 3788.044996), -- Stone of Purity
(20962, 4040, 1, 1, 2, 1136.387663), -- Mold Lubricant
(20962, 5230, 1, 1, 2, 75.698894), -- Recipe: Mithril Arrow (100%)
(20962, 3956, 1, 1, 2, 75.698894), -- Recipe: Blessed Spiritshot A
(20962, 8326, 1, 1, 2, 21.056177), -- Recipe: Doom Crusher (60%)
(20962, 8729, 1, 1, 2, 757.634835), -- Life Stone - Level 64
(20962, 8739, 1, 1, 2, 189.376414), -- Mid-Grade Life Stone - Level 64
(20962, 8749, 1, 1, 2, 18.989313), -- High-Grade Life Stone - Level 64
(20962, 8759, 1, 1, 2, 3.87537), -- Top-Grade Life Stone - Level 64
-- Bloody Lord
(20963, 4116, 1, 1, -1, 9589), -- Deadman's Glory Stone
(20963, 5479, 1, 1, -1, 12984), -- Sealed Tallum Leather Armor Pattern
(20963, 5478, 1, 1, -1, 18452), -- Sealed Dark Crystal Leather Armor Pattern
(20963, 57, 868, 1764, 0, 700000), -- Adena
(20963, 12224, 1, 1, 1, 353.041969), -- Common Item - Sealed Dark Crystal Boots
(20963, 5496, 1, 1, 1, 1899.708031), -- Sealed Dark Crystal Boots Lining
(20963, 12231, 1, 1, 1, 353.041969), -- Common Item - Sealed Tallum Boots
(20963, 5497, 1, 1, 1, 1899.708031), -- Sealed Tallum Boots Lining
(20963, 12221, 1, 1, 1, 353.041969), -- Common Item - Sealed Dark Crystal Gloves
(20963, 5508, 1, 1, 1, 1899.708031), -- Sealed Dark Crystal Gloves Design
(20963, 12229, 1, 1, 1, 353.041969), -- Common Item - Sealed Tallum Gloves
(20963, 5509, 1, 1, 1, 1899.708031), -- Sealed Tallum Gloves Design
(20963, 1869, 1, 1, 2, 64815.97998), -- Iron Ore
(20963, 1864, 1, 1, 2, 129632.16502), -- Stem
(20963, 1880, 1, 1, 2, 6481.53648), -- Steel
(20963, 5550, 1, 1, 2, 864.12284), -- Durable Metal Plate
(20963, 4043, 1, 1, 2, 2160.51216), -- Asofe
(20963, 4984, 1, 1, 2, 183.5287), -- Recipe: Blue Wolf Leather Armor (60%)
(20963, 8730, 1, 1, 2, 720.17072), -- Life Stone - Level 67
(20963, 8740, 1, 1, 2, 180.04268), -- Mid-Grade Life Stone - Level 67
(20963, 8750, 1, 1, 2, 18.04528), -- High-Grade Life Stone - Level 67
(20963, 8760, 1, 1, 2, 3.89614), -- Top-Grade Life Stone - Level 67
-- Chimera Piece
(20965, 4089, 1, 1, -1, 230094), -- Doom Helmet Pattern
(20965, 5482, 1, 1, -1, 80357), -- Sealed Dark Crystal Leggings Design
(20965, 4043, 1, 1, -1, 202943), -- Asofe
(20965, 57, 3002, 6130, 0, 700000), -- Adena
(20965, 12345, 1, 1, 1, 1446.571137), -- Common Item - Sealed Phoenix Earring
(20965, 6341, 1, 1, 1, 10362.734767), -- Sealed Phoenix Earring Gemstone
(20965, 12344, 1, 1, 1, 1085.966508), -- Common Item - Sealed Phoenix Necklace
(20965, 6343, 1, 1, 1, 8010.780019), -- Sealed Phoenix Necklace Beads
(20965, 12346, 1, 1, 1, 2171.970427), -- Common Item - Sealed Phoenix Ring
(20965, 6345, 1, 1, 1, 14332.977142), -- Sealed Phoenix Ring Gemstone
(20965, 1869, 1, 1, 2, 224798.068656), -- Iron Ore
(20965, 1864, 1, 3, 2, 224798.068656), -- Stem
(20965, 1880, 1, 1, 2, 22480.001544), -- Steel
(20965, 5550, 1, 1, 2, 2997.073968), -- Durable Metal Plate
(20965, 4043, 1, 1, 2, 7493.171616), -- Asofe
(20965, 4161, 1, 1, 2, 932.996232), -- Recipe: Blue Wolf Tunic (100%)
(20965, 8730, 1, 1, 2, 2497.723872), -- Life Stone - Level 67
(20965, 8740, 1, 1, 2, 624.430968), -- Mid-Grade Life Stone - Level 67
(20965, 8750, 1, 1, 2, 62.297088), -- High-Grade Life Stone - Level 67
(20965, 8760, 1, 1, 2, 12.1674), -- Top-Grade Life Stone - Level 67
-- Changed Creation
(20966, 4085, 1, 1, -1, 149386), -- Tunic of Doom Pattern
(20966, 4044, 1, 1, -1, 286523), -- Thons
(20966, 1894, 1, 1, -1, 301603), -- Crafted Leather
(20966, 57, 4242, 8646, 0, 700000), -- Adena
(20966, 12222, 1, 1, 1, 768.27439), -- Common Item - Sealed Dark Crystal Leather Armor
(20966, 5478, 1, 1, 1, 4447.96352), -- Sealed Dark Crystal Leather Armor Pattern
(20966, 12230, 1, 1, 1, 472.27596), -- Common Item - Sealed Tallum Leather Armor
(20966, 5479, 1, 1, 1, 3129.89261), -- Sealed Tallum Leather Armor Pattern
(20966, 12228, 1, 1, 1, 1230.12799), -- Common Item - Sealed Dark Crystal Leggings
(20966, 5482, 1, 1, 1, 6981.46553), -- Sealed Dark Crystal Leggings Design
(20966, 1894, 1, 1, 2, 11136.12838), -- Crafted Leather
(20966, 4039, 1, 1, 2, 10579.07232), -- Mold Glue
(20966, 4041, 1, 1, 2, 2759.95957), -- Mold Hardener
(20966, 4044, 1, 1, 2, 10579.07232), -- Thons
(20966, 4617, 1, 1, 2, 437.58501), -- Greater Dye of DEX (Dex+4 Str-4)
(20966, 6037, 1, 3, 2, 317376.44916), -- Waking Scroll
(20966, 8731, 1, 1, 2, 2938.6312), -- Life Stone - Level 70
(20966, 8741, 1, 1, 2, 734.6578), -- Mid-Grade Life Stone - Level 70
(20966, 8751, 1, 1, 2, 73.46578), -- High-Grade Life Stone - Level 70
(20966, 8761, 1, 1, 2, 14.97846), -- Top-Grade Life Stone - Level 70
-- Ancient Creature
(20967, 5485, 1, 1, -1, 53992), -- Sealed Tallum Tunic Texture
(20967, 5156, 1, 1, -1, 8561), -- Recipe: Soulshot (A) Compressed Package (100%)
(20967, 4041, 1, 1, -1, 55832), -- Mold Hardener
(20967, 57, 3159, 6468, 0, 700000), -- Adena
(20967, 12345, 1, 1, 1, 1525.567818), -- Common Item - Sealed Phoenix Earring
(20967, 6341, 1, 1, 1, 10928.639638), -- Sealed Phoenix Earring Gemstone
(20967, 12344, 1, 1, 1, 1145.270712), -- Common Item - Sealed Phoenix Necklace
(20967, 6343, 1, 1, 1, 8448.245566), -- Sealed Phoenix Necklace Beads
(20967, 12346, 1, 1, 1, 2290.580878), -- Common Item - Sealed Phoenix Ring
(20967, 6345, 1, 1, 1, 15115.695388), -- Sealed Phoenix Ring Gemstone
(20967, 1867, 1, 3, 2, 175609.124592), -- Animal Skin
(20967, 1872, 1, 3, 2, 117072.627111), -- Animal Bone
(20967, 1882, 1, 1, 2, 58536.497481), -- Leather
(20967, 1894, 1, 1, 2, 9242.624226), -- Crafted Leather
(20967, 4042, 1, 1, 2, 4390.301685), -- Enria
(20967, 5001, 1, 1, 2, 201.214497), -- Recipe: Lance (60%)
(20967, 8732, 1, 1, 2, 2194.966917), -- Life Stone - Level 76
(20967, 8742, 1, 1, 2, 548.833692), -- Mid-Grade Life Stone - Level 76
(20967, 8752, 1, 1, 2, 54.809799), -- High-Grade Life Stone - Level 76
-- Forgotten Face
(20968, 5486, 1, 1, -1, 46360), -- Sealed Dark Crystal Robe Fabric
(20968, 5480, 1, 1, -1, 35156), -- Sealed Leather Armor of Nightmare Fabric
(20968, 5481, 1, 1, -1, 35156), -- Sealed Majestic Leather Armor Fabric
(20968, 57, 3864, 7887, 0, 700000), -- Adena
(20968, 12224, 1, 1, 1, 1575.622664), -- Common Item - Sealed Dark Crystal Boots
(20968, 5496, 1, 1, 1, 8478.377336), -- Sealed Dark Crystal Boots Lining
(20968, 12231, 1, 1, 1, 1575.622664), -- Common Item - Sealed Tallum Boots
(20968, 5497, 1, 1, 1, 8478.377336), -- Sealed Tallum Boots Lining
(20968, 12221, 1, 1, 1, 1575.622664), -- Common Item - Sealed Dark Crystal Gloves
(20968, 5508, 1, 1, 1, 8478.377336), -- Sealed Dark Crystal Gloves Design
(20968, 12229, 1, 1, 1, 1575.622664), -- Common Item - Sealed Tallum Gloves
(20968, 5509, 1, 1, 1, 8478.377336), -- Sealed Tallum Gloves Design
(20968, 1868, 1, 3, 2, 262985.596155), -- Thread
(20968, 1873, 1, 1, 2, 105194.238462), -- Silver Nugget
(20968, 5549, 1, 1, 2, 26298.343332), -- Metallic Thread
(20968, 1889, 1, 1, 2, 17532.373077), -- Compound Braid
(20968, 4044, 1, 1, 2, 8765.970255), -- Thons
(20968, 5007, 1, 1, 2, 200.711088), -- Recipe: Bow of Peril (60%)
(20968, 729, 1, 1, 2, 29.414556), -- Scroll: Enchant Weapon (A-Grade)
(20968, 8732, 1, 1, 2, 2191.384422), -- Life Stone - Level 76
(20968, 8742, 1, 1, 2, 548.062389), -- Mid-Grade Life Stone - Level 76
(20968, 8752, 1, 1, 2, 54.936009), -- High-Grade Life Stone - Level 76
(20968, 6036, 1, 1, 2, 8765.970255), -- Greater Magic Haste Potion
-- Giant's Shadow
(20969, 5161, 1, 1, -1, 13821), -- Recipe: Spiritshot (A) Compressed Package (100%)
(20969, 5487, 1, 1, -1, 46678), -- Sealed Robe of Nightmare Fabric
(20969, 729, 1, 1, -1, 1152), -- Scroll: Enchant Weapon (A-Grade)
(20969, 57, 5111, 10430, 0, 700000), -- Adena
(20969, 12267, 1, 1, 1, 1301.84632), -- Common Item - Sealed Boots of Nightmare
(20969, 5502, 1, 1, 1, 8080.15368), -- Sealed Boots of Nightmare Lining
(20969, 12260, 1, 1, 1, 1301.84632), -- Common Item - Sealed Majestic Boots
(20969, 5503, 1, 1, 1, 8080.15368), -- Sealed Majestic Boots Lining
(20969, 12264, 1, 1, 1, 1301.84632), -- Common Item - Sealed Gauntlet of Nightmare
(20969, 5514, 1, 1, 1, 8080.15368), -- Sealed Gauntlets of Nightmare Design
(20969, 12257, 1, 1, 1, 1301.84632), -- Common Item - Sealed Majestic Gauntlet
(20969, 5515, 1, 1, 1, 8080.15368), -- Sealed Majestic Gauntlets Design
(20969, 1894, 1, 1, 2, 16786.690002), -- Crafted Leather
(20969, 4039, 1, 1, 2, 15947.402502), -- Mold Glue
(20969, 4041, 1, 1, 2, 4160.18028), -- Mold Hardener
(20969, 4044, 1, 1, 2, 15947.402502), -- Thons
(20969, 4150, 1, 1, 2, 9218.129613), -- Recipe: Sealed Avadon Gloves (100%)
(20969, 8732, 1, 1, 2, 3986.817054), -- Life Stone - Level 76
(20969, 8742, 1, 1, 2, 996.737835), -- Mid-Grade Life Stone - Level 76
(20969, 8752, 1, 1, 2, 99.640212), -- High-Grade Life Stone - Level 76
-- Soldier of Ancient Times
(20970, 5489, 1, 1, -1, 82857), -- Sealed Tallum Stockings Fabric
(20970, 1895, 1, 3, -1, 896811), -- Metallic Fiber
(20970, 4042, 1, 1, -1, 104628), -- Enria
(20970, 57, 3100, 6312, 0, 700000), -- Adena
(20970, 12224, 1, 1, 1, 1262.464917), -- Common Item - Sealed Dark Crystal Boots
(20970, 5496, 1, 1, 1, 6793.285083), -- Sealed Dark Crystal Boots Lining
(20970, 12231, 1, 1, 1, 1262.464917), -- Common Item - Sealed Tallum Boots
(20970, 5497, 1, 1, 1, 6793.285083), -- Sealed Tallum Boots Lining
(20970, 12221, 1, 1, 1, 1262.464917), -- Common Item - Sealed Dark Crystal Gloves
(20970, 5508, 1, 1, 1, 6793.285083), -- Sealed Dark Crystal Gloves Design
(20970, 12229, 1, 1, 1, 1262.464917), -- Common Item - Sealed Tallum Gloves
(20970, 5509, 1, 1, 1, 6793.285083), -- Sealed Tallum Gloves Design
(20970, 10581, 1, 1, 2, 12010), -- Forgotten Scroll - Improve Condition
(20970, 10584, 1, 1, 2, 12010), -- Forgotten Scroll - Improve Movement
(20970, 10609, 1, 1, 2, 12010), -- Forgotten Scroll - Chant of Critical
(20970, 14217, 1, 1, 2, 12010), -- Forgotten Scroll - Condition of Pa'agrio
-- Warrior of Ancient Times
(20971, 1877, 1, 1, -1, 266382), -- Adamantite Nugget
(20971, 1876, 1, 3, -1, 665954), -- Mithril Ore
(20971, 1895, 1, 5, -1, 634242), -- Metallic Fiber
(20971, 57, 3285, 6703, 0, 700000), -- Adena
(20971, 12225, 1, 1, 1, 1700.46408), -- Common Item - Sealed Dark Crystal Shield
(20971, 5494, 1, 1, 1, 8606.82896), -- Sealed Dark Crystal Shield Fragment
(20971, 12226, 1, 1, 1, 1191.31136), -- Common Item - Sealed Dark Crystal Helmet
(20971, 5525, 1, 1, 1, 6335.02944), -- Sealed Dark Crystal Helmet Design
(20971, 12234, 1, 1, 1, 1191.31136), -- Common Item - Sealed Tallum Helmet
(20971, 5526, 1, 1, 1, 6335.0548), -- Sealed Tallum Helm Design
(20971, 12768, 1, 1, 2, 19671.5), -- Forgotten Scroll - Evasion Counter
(20971, 12769, 1, 1, 2, 19671.5), -- Forgotten Scroll - Evasion Chance
-- Shaman of Ancient Times
(20972, 4077, 1, 1, -1, 310559), -- Doom Shield Fragment
(20972, 4087, 1, 1, -1, 162002), -- Stockings of Doom Pattern
(20972, 5494, 1, 1, -1, 144990), -- Sealed Dark Crystal Shield Fragment
(20972, 57, 3405, 6948, 0, 700000), -- Adena
(20972, 12224, 1, 1, 1, 1388.386223), -- Common Item - Sealed Dark Crystal Boots
(20972, 5496, 1, 1, 1, 7470.863777), -- Sealed Dark Crystal Boots Lining
(20972, 12231, 1, 1, 1, 1388.386223), -- Common Item - Sealed Tallum Boots
(20972, 5497, 1, 1, 1, 7470.863777), -- Sealed Tallum Boots Lining
(20972, 12221, 1, 1, 1, 1388.386223), -- Common Item - Sealed Dark Crystal Gloves
(20972, 5508, 1, 1, 1, 7470.863777), -- Sealed Dark Crystal Gloves Design
(20972, 12229, 1, 1, 1, 1388.386223), -- Common Item - Sealed Tallum Gloves
(20972, 5509, 1, 1, 1, 7470.863777), -- Sealed Tallum Gloves Design
(20972, 12771, 1, 1, 2, 20392.5), -- Forgotten Scroll - Shadow Step
(20972, 12770, 1, 1, 2, 20392.5), -- Forgotten Scroll - Evasion Haste
-- Forgotten Ancient People
(20973, 4078, 1, 1, -1, 128365), -- Blue Wolf Breastplate Part
(20973, 5166, 1, 1, -1, 11717), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(20973, 5496, 1, 1, -1, 206046), -- Sealed Dark Crystal Boots Lining
(20973, 57, 4332, 8850, 0, 700000), -- Adena
(20973, 12345, 1, 1, 1, 2088.018), -- Common Item - Sealed Phoenix Earring
(20973, 6341, 1, 1, 1, 14957.838), -- Sealed Phoenix Earring Gemstone
(20973, 12344, 1, 1, 1, 1567.512), -- Common Item - Sealed Phoenix Necklace
(20973, 6343, 1, 1, 1, 11562.966), -- Sealed Phoenix Necklace Beads
(20973, 12346, 1, 1, 1, 3135.078), -- Common Item - Sealed Phoenix Ring
(20973, 6345, 1, 1, 1, 20688.588), -- Sealed Phoenix Ring Gemstone
(20973, 1872, 1, 3, 2, 180263.991168), -- Animal Bone
(20973, 1867, 1, 3, 2, 120175.994112), -- Animal Skin
(20973, 1881, 1, 1, 2, 36052.94301), -- Coarse Bone Powder
(20973, 1875, 1, 1, 2, 18026.471505), -- Stone of Purity
(20973, 4041, 1, 1, 2, 2351.168736), -- Mold Hardener
(20973, 4982, 1, 1, 2, 1345.334697), -- Recipe: Blue Wolf Gaiters (60%)
(20973, 4624, 1, 1, 2, 372.79923), -- Greater Dye of WIT (Wit+4 Men-4)
(20973, 8314, 1, 1, 2, 147.671928), -- Recipe: Spiritual Eye (60%)
(20973, 8731, 1, 1, 2, 2503.545897), -- Life Stone - Level 70
(20973, 8741, 1, 1, 2, 625.795989), -- Mid-Grade Life Stone - Level 70
(20973, 8751, 1, 1, 2, 62.615793), -- High-Grade Life Stone - Level 70
(20973, 8761, 1, 1, 2, 12.667935), -- Top-Grade Life Stone - Level 70
-- Spiteful Soul Leader
(20974, 5230, 1, 1, -1, 6478), -- Recipe: Mithril Arrow (100%)
(20974, 4052, 1, 1, -1, 172021), -- Earring of Black Ore Piece
(20974, 57, 1925, 3904, 0, 700000), -- Adena
(20974, 268, 1, 1, 1, 14.22225), -- Bellion Cestus
(20974, 4120, 1, 1, 1, 3135.77775), -- Bellion Cestus Edge
(20974, 1871, 1, 1, 2, 130472.173904), -- Charcoal
(20974, 1866, 1, 1, 2, 86981.525808), -- Suede
(20974, 1877, 1, 1, 2, 5218.942064), -- Adamantite Nugget
(20974, 4041, 1, 1, 2, 1134.532656), -- Mold Hardener
(20974, 4040, 1, 1, 2, 2609.356224), -- Mold Lubricant
(20974, 4164, 1, 1, 2, 864.045008), -- Recipe: Stockings of Doom (100%)
(20974, 730, 1, 1, 2, 108.837984), -- Scroll: Enchant Armor (A-Grade)
(20974, 8729, 1, 1, 2, 1739.570816), -- Life Stone - Level 64
(20974, 8739, 1, 1, 2, 434.892704), -- Mid-Grade Life Stone - Level 64
(20974, 8749, 1, 1, 2, 43.397424), -- High-Grade Life Stone - Level 64
(20974, 8759, 1, 1, 2, 8.725408), -- Top-Grade Life Stone - Level 64
-- Spiteful Soul Wizard
(20975, 5230, 1, 1, -1, 5745), -- Recipe: Mithril Arrow (100%)
(20975, 4078, 1, 1, -1, 62938), -- Blue Wolf Breastplate Part
(20975, 4053, 1, 1, -1, 184685), -- Ring of Black Ore Gemstone
(20975, 57, 1709, 3460, 0, 700000), -- Adena
(20975, 110, 1, 1, 1, 65.287158), -- Doom Shield
(20975, 4077, 1, 1, 1, 9542.81055), -- Doom Shield Fragment
(20975, 2416, 1, 1, 1, 45.703584), -- Blue Wolf Helmet
(20975, 4088, 1, 1, 1, 8017.247562), -- Blue Wolf Helmet Design
(20975, 2417, 1, 1, 1, 45.703584), -- Doom Helmet
(20975, 4089, 1, 1, 1, 8017.247562), -- Doom Helmet Pattern
(20975, 1866, 1, 1, 2, 77134.926962), -- Suede
(20975, 1871, 1, 1, 2, 115702.390443), -- Charcoal
(20975, 5220, 1, 1, 2, 4628.187966), -- Metal Hardener
(20975, 1885, 1, 1, 2, 9641.930001), -- High-Grade Suede
(20975, 4041, 1, 1, 2, 1006.083206), -- Mold Hardener
(20975, 1830, 1, 1, 2, 46280.853568), -- Scroll of Escape: Castle
(20975, 5276, 1, 1, 2, 154.170323), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20975, 8729, 1, 1, 2, 1542.729322), -- Life Stone - Level 64
(20975, 8739, 1, 1, 2, 385.554069), -- Mid-Grade Life Stone - Level 64
(20975, 8749, 1, 1, 2, 38.47845), -- High-Grade Life Stone - Level 64
(20975, 8759, 1, 1, 2, 7.69569), -- Top-Grade Life Stone - Level 64
-- Spiteful Soul Fighter
(20976, 4080, 1, 1, -1, 75035), -- Blue Wolf Gaiters Material
(20976, 5230, 1, 1, -1, 4864), -- Recipe: Mithril Arrow (100%)
(20976, 4054, 1, 1, -1, 71850), -- Necklace of Black Ore Beads
(20976, 57, 1447, 2930, 0, 700000), -- Adena
(20976, 358, 1, 1, 1, 14.51284), -- Blue Wolf Breastplate
(20976, 4078, 1, 1, 1, 2623.561905), -- Blue Wolf Breastplate Part
(20976, 2381, 1, 1, 1, 8.93223), -- Doom Plate Armor
(20976, 4081, 1, 1, 1, 1770.249215), -- Doom Plate Armor Temper
(20976, 2380, 1, 1, 1, 23.21729), -- Blue Wolf Gaiters
(20976, 4080, 1, 1, 1, 3694.52652), -- Blue Wolf Gaiters Material
(20976, 1867, 1, 1, 2, 119724.213714), -- Animal Skin
(20976, 1872, 1, 1, 2, 119724.213714), -- Animal Bone
(20976, 1882, 1, 1, 2, 19953.969936), -- Leather
(20976, 1894, 1, 1, 2, 3150.81351), -- Crafted Leather
(20976, 4042, 1, 1, 2, 1496.390106), -- Enria
(20976, 5230, 1, 1, 2, 119.805792), -- Recipe: Mithril Arrow (100%)
(20976, 5276, 1, 1, 2, 119.805792), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20976, 8729, 1, 1, 2, 1197.269724), -- Life Stone - Level 64
(20976, 8739, 1, 1, 2, 299.120382), -- Mid-Grade Life Stone - Level 64
(20976, 8749, 1, 1, 2, 29.951448), -- High-Grade Life Stone - Level 64
(20976, 8759, 1, 1, 2, 5.91147), -- Top-Grade Life Stone - Level 64
(20976, 1343, 10, 30, 2, 128276.534412), -- Silver Arrow
-- Elmoreden's Lady
(20977, 947, 1, 1, -1, 2297), -- Scroll: Enchant Weapon (B-Grade)
(20977, 1876, 1, 3, -1, 574367), -- Mithril Ore
(20977, 4052, 1, 1, -1, 203352), -- Earring of Black Ore Piece
(20977, 57, 2276, 4615, 0, 700000), -- Adena
(20977, 864, 1, 1, 1, 79.54051), -- Earring of Black Ore
(20977, 4052, 1, 1, 1, 10010.64148), -- Earring of Black Ore Piece
(20977, 926, 1, 1, 1, 59.662372), -- Necklace of Black Ore
(20977, 4054, 1, 1, 1, 5569.2336), -- Necklace of Black Ore Beads
(20977, 895, 1, 1, 1, 119.296786), -- Ring of Black Ore
(20977, 4053, 1, 1, 1, 12119.625252), -- Ring of Black Ore Gemstone
(20977, 1871, 1, 1, 2, 154235.660703), -- Charcoal
(20977, 1866, 1, 1, 2, 102823.864281), -- Suede
(20977, 1877, 1, 1, 2, 6169.491573), -- Adamantite Nugget
(20977, 4041, 1, 1, 2, 1341.170217), -- Mold Hardener
(20977, 4040, 1, 1, 2, 3084.610068), -- Mold Lubricant
(20977, 4164, 1, 1, 2, 1021.417431), -- Recipe: Stockings of Doom (100%)
(20977, 730, 1, 1, 2, 128.661138), -- Scroll: Enchant Armor (A-Grade)
(20977, 8729, 1, 1, 2, 2056.406712), -- Life Stone - Level 64
(20977, 8739, 1, 1, 2, 514.101678), -- Mid-Grade Life Stone - Level 64
(20977, 8749, 1, 1, 2, 51.301593), -- High-Grade Life Stone - Level 64
(20977, 8759, 1, 1, 2, 10.314606), -- Top-Grade Life Stone - Level 64
-- Elmoreden's Archer Escort
(20978, 5230, 1, 1, -1, 8195), -- Recipe: Mithril Arrow (100%)
(20978, 4081, 1, 1, -1, 60581), -- Doom Plate Armor Temper
(20978, 57, 2440, 4935, 0, 700000), -- Adena
(20978, 79, 1, 1, 1, 5.99697), -- Sword of Damascus
(20978, 4114, 1, 1, 1, 1324.74384), -- Sword of Damascus Blade
(20978, 7883, 1, 1, 1, 5.99697), -- Guardian Sword
(20978, 8330, 1, 1, 1, 1322.51742), -- Guardian Sword Blade
(20978, 7889, 1, 1, 1, 5.99697), -- Wizard's Tear
(20978, 8336, 1, 1, 1, 1324.74783), -- Blade of the Wizard's Tear
(20978, 1868, 1, 1, 2, 330107.489394), -- Thread
(20978, 1873, 1, 1, 2, 66021.697158), -- Silver Nugget
(20978, 5549, 1, 1, 2, 16505.29974), -- Metallic Thread
(20978, 1889, 1, 1, 2, 11003.699226), -- Compound Braid
(20978, 4044, 1, 1, 2, 5501.600514), -- Thons
(20978, 1830, 1, 1, 2, 66021.697158), -- Scroll of Escape: Castle
(20978, 3956, 1, 1, 2, 220.203516), -- Recipe: Blessed Spiritshot A
(20978, 8729, 1, 1, 2, 2200.540566), -- Life Stone - Level 64
(20978, 8739, 1, 1, 2, 550.010592), -- Mid-Grade Life Stone - Level 64
(20978, 8749, 1, 1, 2, 54.80178), -- High-Grade Life Stone - Level 64
(20978, 8759, 1, 1, 2, 10.960356), -- Top-Grade Life Stone - Level 64
-- Elmoreden's Maid
(20979, 4082, 1, 1, -1, 61486), -- Blue Wolf Leather Armor Texture
(20979, 5550, 1, 1, -1, 72554), -- Durable Metal Plate
(20979, 57, 2160, 4369, 0, 700000), -- Adena
(20979, 171, 1, 1, 1, 5.309912), -- Deadman's Glory
(20979, 4116, 1, 1, 1, 1170.530588), -- Deadman's Glory Stone
(20979, 175, 1, 1, 1, 5.309912), -- Art of Battle Axe
(20979, 4117, 1, 1, 1, 1170.530588), -- Art of Battle Axe Blade
(20979, 210, 1, 1, 1, 5.309912), -- Staff of Evil Spirits
(20979, 4118, 1, 1, 1, 1109.009088), -- Evil Spirit Head
(20979, 1869, 1, 1, 2, 133945.27398), -- Iron Ore
(20979, 1864, 1, 3, 2, 133945.27398), -- Stem
(20979, 1880, 1, 1, 2, 13394.72001), -- Steel
(20979, 5550, 1, 1, 2, 1785.99477), -- Durable Metal Plate
(20979, 4043, 1, 1, 2, 4464.74616), -- Asofe
(20979, 5230, 1, 1, 2, 178.64763), -- Recipe: Mithril Arrow (100%)
(20979, 5276, 1, 1, 2, 178.64763), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(20979, 8729, 1, 1, 2, 1785.99477), -- Life Stone - Level 64
(20979, 8739, 1, 1, 2, 446.37831), -- Mid-Grade Life Stone - Level 64
(20979, 8749, 1, 1, 2, 44.78229), -- High-Grade Life Stone - Level 64
(20979, 8759, 1, 1, 2, 9.14907), -- Top-Grade Life Stone - Level 64
(20979, 1343, 10, 30, 2, 191350.3914), -- Silver Arrow
-- Hallate's Follower Mul
(20980, 4041, 1, 1, -1, 55038), -- Mold Hardener
(20980, 4039, 1, 1, -1, 210979), -- Mold Glue
(20980, 4085, 1, 1, -1, 109999), -- Tunic of Doom Pattern
(20980, 57, 2504, 5090, 0, 700000), -- Adena
(20980, 5287, 1, 1, 1, 17.495295), -- Sealed Dark Crystal breastplate
(20980, 5520, 1, 1, 1, 2009.454915), -- Sealed Dark Crystal Breastplate Pattern
(20980, 5293, 1, 1, 1, 10.769865), -- Sealed Tallum Plate Armor
(20980, 5521, 1, 1, 1, 1417.95138), -- Sealed Tallum Plate Armor Pattern
(20980, 5288, 1, 1, 1, 27.996405), -- Sealed Dark Crystal Gaiters
(20980, 5524, 1, 1, 1, 3071.33214), -- Sealed Dark Crystal Gaiters Pattern
(20980, 1869, 2, 6, 2, 42490.85418), -- Iron Ore
(20980, 1870, 2, 6, 2, 33992.50803), -- Coal
(20980, 1871, 1, 1, 2, 169962.54015), -- Charcoal
(20980, 1872, 1, 3, 2, 113308.506195), -- Animal Bone
(20980, 1867, 1, 3, 2, 75538.858035), -- Animal Skin
(20980, 4985, 1, 1, 2, 481.675215), -- Recipe: Leather Armor of Doom (60%)
(20980, 8314, 1, 1, 2, 92.91642), -- Recipe: Spiritual Eye (60%)
(20980, 8730, 1, 1, 2, 1888.570065), -- Life Stone - Level 67
(20980, 8740, 1, 1, 2, 472.032945), -- Mid-Grade Life Stone - Level 67
(20980, 8750, 1, 1, 2, 47.33478), -- High-Grade Life Stone - Level 67
(20980, 8760, 1, 1, 2, 9.203985), -- Top-Grade Life Stone - Level 67
-- Mul's Wizard
(20981, 4083, 1, 1, -1, 67397), -- Leather Armor of Doom Design
(20981, 5230, 1, 1, -1, 7953), -- Recipe: Mithril Arrow (100%)
(20981, 4085, 1, 1, -1, 103660), -- Tunic of Doom Pattern
(20981, 57, 2351, 4805, 0, 700000), -- Adena
(20981, 358, 1, 1, 1, 23.728984), -- Blue Wolf Breastplate
(20981, 4078, 1, 1, 1, 4289.612403), -- Blue Wolf Breastplate Part
(20981, 2381, 1, 1, 1, 14.604498), -- Doom Plate Armor
(20981, 4081, 1, 1, 1, 2894.417309), -- Doom Plate Armor Temper
(20981, 2380, 1, 1, 1, 37.961054), -- Blue Wolf Gaiters
(20981, 4080, 1, 1, 1, 6040.675752), -- Blue Wolf Gaiters Material
(20981, 1869, 1, 1, 2, 160168.355966), -- Iron Ore
(20981, 1864, 1, 3, 2, 160168.355966), -- Stem
(20981, 1880, 1, 1, 2, 16016.999701), -- Steel
(20981, 5550, 1, 1, 2, 2135.408505), -- Durable Metal Plate
(20981, 4043, 1, 1, 2, 5339.136654), -- Asofe
(20981, 1830, 1, 1, 2, 64067.178282), -- Scroll of Escape: Castle
(20981, 8487, 1, 1, 2, 87.385593), -- Recipe: Destroyer Hammer (60%)
(20981, 8730, 1, 1, 2, 1779.712218), -- Life Stone - Level 67
(20981, 8740, 1, 1, 2, 444.722924), -- Mid-Grade Life Stone - Level 67
(20981, 8750, 1, 1, 2, 44.308188), -- High-Grade Life Stone - Level 67
(20981, 8760, 1, 1, 2, 9.436003), -- Top-Grade Life Stone - Level 67
-- Mul's Knight
(20982, 4084, 1, 1, -1, 96257), -- Blue Wolf Tunic Fabric
(20982, 5418, 1, 1, -1, 8181), -- Recipe: Sealed Tallum Plate Armor(60%)
(20982, 4085, 1, 1, -1, 96257), -- Tunic of Doom Pattern
(20982, 57, 2184, 4462, 0, 700000), -- Adena
(20982, 2398, 1, 1, 1, 22.025234), -- Blue Wolf Tunic
(20982, 4084, 1, 1, 1, 3555.266496), -- Blue Wolf Tunic Fabric
(20982, 2399, 1, 1, 1, 22.025234), -- Tunic of Doom
(20982, 4085, 1, 1, 1, 3555.266496), -- Tunic of Doom Pattern
(20982, 2403, 1, 1, 1, 35.267296), -- Blue Wolf Stockings
(20982, 4086, 1, 1, 1, 4800.424148), -- Blue Wolf Stockings Pattern
(20982, 2404, 1, 1, 1, 35.267296), -- Stockings of Doom
(20982, 4087, 1, 1, 1, 4800.4578), -- Stockings of Doom Pattern
(20982, 1869, 1, 1, 2, 136335.691248), -- Iron Ore
(20982, 1864, 1, 3, 2, 136335.691248), -- Stem
(20982, 1880, 1, 1, 2, 13633.406716), -- Steel
(20982, 5550, 1, 1, 2, 1817.760494), -- Durable Metal Plate
(20982, 4043, 1, 1, 2, 4544.604246), -- Asofe
(20982, 1830, 1, 1, 2, 54534.438908), -- Scroll of Escape: Castle
(20982, 8487, 1, 1, 2, 74.302026), -- Recipe: Destroyer Hammer (60%)
(20982, 8730, 1, 1, 2, 1514.868082), -- Life Stone - Level 67
(20982, 8740, 1, 1, 2, 378.818526), -- Mid-Grade Life Stone - Level 67
(20982, 8750, 1, 1, 2, 37.760046), -- High-Grade Life Stone - Level 67
(20982, 8760, 1, 1, 2, 7.714418), -- Top-Grade Life Stone - Level 67
(20982, 1344, 30, 90, 2, 56806.944042), -- Mithril Arrow
-- Binder
(20983, 4080, 1, 1, -1, 136641), -- Blue Wolf Gaiters Material
(20983, 5549, 1, 1, -1, 664283), -- Metallic Thread
(20983, 5478, 1, 1, -1, 55860), -- Sealed Dark Crystal Leather Armor Pattern
(20983, 57, 3280, 6679, 0, 700000), -- Adena
(20983, 5297, 1, 1, 1, 30.608253), -- Sealed Dark Crystal Leather Armor
(20983, 5478, 1, 1, 1, 3437.124093), -- Sealed Dark Crystal Leather Armor Pattern
(20983, 5301, 1, 1, 1, 18.827991), -- Sealed Tallum Leather Armor
(20983, 5479, 1, 1, 1, 2418.596739), -- Sealed Tallum Leather Armor Pattern
(20983, 5298, 1, 1, 1, 48.948237), -- Sealed Dark Crystal Leggings
(20983, 5482, 1, 1, 1, 5394.894687), -- Sealed Dark Crystal Leggings Design
(20983, 1867, 1, 3, 2, 148650.69776), -- Animal Skin
(20983, 1872, 1, 3, 2, 99100.56912), -- Animal Bone
(20983, 1882, 1, 1, 2, 49550.12864), -- Leather
(20983, 1894, 1, 1, 2, 7823.75376), -- Crafted Leather
(20983, 4042, 1, 1, 2, 3716.19728), -- Enria
(20983, 4199, 1, 1, 2, 170.26464), -- Recipe: Bow of Peril (100%)
(20983, 730, 1, 1, 2, 185.85664), -- Scroll: Enchant Armor (A-Grade)
(20983, 8731, 1, 1, 2, 2064.69264), -- Life Stone - Level 70
(20983, 8741, 1, 1, 2, 516.0952), -- Mid-Grade Life Stone - Level 70
(20983, 8751, 1, 1, 2, 51.76544), -- High-Grade Life Stone - Level 70
(20983, 8761, 1, 1, 2, 9.97888), -- Top-Grade Life Stone - Level 70
-- Bound Warrior
(20984, 5478, 1, 1, -1, 51267), -- Sealed Dark Crystal Leather Armor Pattern
(20984, 4041, 1, 1, -1, 53015), -- Mold Hardener
(20984, 57, 3006, 6139, 0, 700000), -- Adena
(20984, 5304, 1, 1, 1, 28.091952), -- Sealed Tallum Tunic
(20984, 5485, 1, 1, 1, 3154.558512), -- Sealed Tallum Tunic Texture
(20984, 5308, 1, 1, 1, 17.280144), -- Sealed Dark Crystal Robe
(20984, 5486, 1, 1, 1, 2219.764176), -- Sealed Dark Crystal Robe Fabric
(20984, 5305, 1, 1, 1, 44.924208), -- Sealed Tallum Stockings
(20984, 5489, 1, 1, 1, 4951.381008), -- Sealed Tallum Stockings Fabric
(20984, 1870, 1, 1, 2, 187591.547868), -- Coal
(20984, 1865, 1, 1, 2, 187591.547868), -- Varnish
(20984, 1874, 1, 1, 2, 12506.022528), -- Oriharukon Ore
(20984, 4043, 1, 1, 2, 6253.011264), -- Asofe
(20984, 4039, 1, 1, 2, 6253.011264), -- Mold Glue
(20984, 5156, 1, 1, 2, 250.05592), -- Recipe: Soulshot (A) Compressed Package (100%)
(20984, 729, 1, 1, 2, 20.972432), -- Scroll: Enchant Weapon (A-Grade)
(20984, 5420, 1, 1, 2, 182.298832), -- Recipe: Sealed Armor of Nightmare(60%)
(20984, 8730, 1, 1, 2, 2084.337088), -- Life Stone - Level 67
(20984, 8740, 1, 1, 2, 521.084272), -- Mid-Grade Life Stone - Level 67
(20984, 8750, 1, 1, 2, 52.027764), -- High-Grade Life Stone - Level 67
(20984, 8760, 1, 1, 2, 10.0829), -- Top-Grade Life Stone - Level 67
-- Bound Archer
(20985, 1807, 1, 1, -1, 8655), -- Recipe: Soulshot (A-Grade)
(20985, 5479, 1, 1, -1, 38410), -- Sealed Tallum Leather Armor Pattern
(20985, 3035, 1, 1, -1, 8655), -- Recipe: Spiritshot A
(20985, 57, 3201, 6536, 0, 700000), -- Adena
(20985, 6324, 1, 1, 1, 79.494664), -- Sealed Phoenix Earring
(20985, 6341, 1, 1, 1, 11048.10728), -- Sealed Phoenix Earring Gemstone
(20985, 6323, 1, 1, 1, 59.612216), -- Sealed Phoenix Necklace
(20985, 6343, 1, 1, 1, 8540.600384), -- Sealed Phoenix Necklace Beads
(20985, 6325, 1, 1, 1, 119.224432), -- Sealed Phoenix Ring
(20985, 6345, 1, 1, 1, 15280.961024), -- Sealed Phoenix Ring Gemstone
(20985, 1871, 1, 3, 2, 72629.206225), -- Charcoal
(20985, 1866, 1, 1, 2, 145258.41245), -- Suede
(20985, 1877, 1, 1, 2, 8715.48985), -- Adamantite Nugget
(20985, 4041, 1, 1, 2, 1894.525975), -- Mold Hardener
(20985, 4040, 1, 1, 2, 4357.744925), -- Mold Lubricant
(20985, 5161, 1, 1, 2, 290.4915), -- Recipe: Spiritshot (A) Compressed Package (100%)
(20985, 8730, 1, 1, 2, 2421.134925), -- Life Stone - Level 67
(20985, 8740, 1, 1, 2, 605.190625), -- Mid-Grade Life Stone - Level 67
(20985, 8750, 1, 1, 2, 60.705275), -- High-Grade Life Stone - Level 67
(20985, 8760, 1, 1, 2, 12.290025), -- Top-Grade Life Stone - Level 67
(20985, 1344, 20, 60, 2, 136179.808225), -- Mithril Arrow
-- Sairon
(20986, 1984, 1, 1, -1, 95413), -- Theca Leather Armor Pattern
(20986, 4043, 1, 1, -1, 148367), -- Asofe
(20986, 1806, 1, 1, -1, 8902), -- Recipe: Soulshot (B-Grade)
(20986, 57, 1758, 3581, 0, 700000), -- Adena
(20986, 2497, 1, 1, 1, 284.530887), -- Full Plate Shield
(20986, 2966, 1, 1, 1, 22482.996417), -- Full Plate Shield Fragment
(20986, 2414, 1, 1, 1, 199.167903), -- Full Plate Helmet
(20986, 2959, 1, 1, 1, 14212.304793), -- Full Plate Helmet Design
(20986, 1894, 1, 1, 2, 5242.291475), -- Crafted Leather
(20986, 4039, 1, 1, 2, 4980.167415), -- Mold Glue
(20986, 4041, 1, 1, 2, 1299.16091), -- Mold Hardener
(20986, 4044, 1, 1, 2, 4980.167415), -- Thons
(20986, 4180, 1, 1, 2, 16600.55805), -- Recipe: Silver Arrow (100%)
(20986, 4184, 1, 1, 2, 172.11852), -- Recipe: Sprite's Staff (100%)
(20986, 5436, 1, 1, 2, 243.720735), -- Recipe: Berserker Blade(100%)
(20986, 8726, 1, 1, 2, 3458.45908), -- Life Stone - Level 55
(20986, 8736, 1, 1, 2, 864.61477), -- Mid-Grade Life Stone - Level 55
(20986, 8746, 1, 1, 2, 86.476655), -- High-Grade Life Stone - Level 55
(20986, 8756, 1, 1, 2, 17.264975), -- Top-Grade Life Stone - Level 55
-- Sairon's Doll
(20987, 1918, 1, 1, -1, 174977), -- Nassen's Earring Gemstone
(20987, 4039, 1, 1, -1, 134674), -- Mold Glue
(20987, 1864, 1, 17, -1, 897829), -- Stem
(20987, 57, 1599, 3249, 0, 700000), -- Adena
(20987, 301, 1, 1, 1, 13.521856), -- Scorpion
(20987, 2113, 1, 1, 1, 1204.200775), -- Scorpion Blade
(20987, 303, 1, 1, 1, 13.521856), -- Widow Maker
(20987, 2114, 1, 1, 1, 1204.200775), -- Widowmaker Head
(20987, 299, 1, 1, 1, 10.549626), -- Orcish Poleaxe
(20987, 2122, 1, 1, 1, 1135.005112), -- Orcish Poleaxe Blade
(20987, 1864, 1, 3, 2, 124314.583522), -- Stem
(20987, 1869, 1, 1, 2, 124314.583522), -- Iron Ore
(20987, 1878, 1, 1, 2, 49725.756723), -- Braided Hemp
(20987, 1884, 1, 1, 2, 76501.370651), -- Cord
(20987, 4039, 1, 1, 2, 4143.717203), -- Mold Glue
(20987, 3034, 1, 1, 2, 248.461992), -- Recipe: Spiritshot B
(20987, 5270, 1, 1, 2, 248.461992), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20987, 3955, 1, 1, 2, 248.461992), -- Recipe: Blessed Spiritshot B
(20987, 8726, 1, 1, 2, 2877.634645), -- Life Stone - Level 55
(20987, 8736, 1, 1, 2, 719.312804), -- Mid-Grade Life Stone - Level 55
(20987, 8746, 1, 1, 2, 72.084652), -- High-Grade Life Stone - Level 55
(20987, 8756, 1, 1, 2, 14.570302), -- Top-Grade Life Stone - Level 55
-- Sairon's Puppet
(20988, 1920, 1, 1, -1, 152063), -- Necklace of Seal Chain
(20988, 1806, 1, 1, -1, 8888), -- Recipe: Soulshot (B-Grade)
(20988, 1984, 1, 1, -1, 95264), -- Theca Leather Armor Pattern
(20988, 57, 1759, 3573, 0, 700000), -- Adena
(20988, 400, 1, 1, 1, 86.136814), -- Theca Leather Armor
(20988, 1984, 1, 1, 1, 5862.097499), -- Theca Leather Armor Pattern
(20988, 401, 1, 1, 1, 40.779843), -- Drake Leather Armor
(20988, 1987, 1, 1, 1, 4172.210004), -- Drake Leather Armor Texture
(20988, 420, 1, 1, 1, 137.866252), -- Theca Leather Gaiters
(20988, 1985, 1, 1, 1, 9429.909588), -- Theca Leather Gaiters Pattern
(20988, 1865, 1, 1, 2, 136739.952216), -- Varnish
(20988, 1870, 1, 1, 2, 136739.952216), -- Coal
(20988, 1879, 1, 1, 2, 22790.150088), -- Cokes
(20988, 1875, 1, 1, 2, 9116.123256), -- Stone of Purity
(20988, 4040, 1, 1, 2, 2734.931808), -- Mold Lubricant
(20988, 3955, 1, 1, 2, 273.42996), -- Recipe: Blessed Spiritshot B
(20988, 5270, 1, 1, 2, 273.42996), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20988, 4127, 1, 1, 2, 3384.525528), -- Recipe: Adamantite Ring (100%)
(20988, 8726, 1, 1, 2, 3165.149352), -- Life Stone - Level 55
(20988, 8736, 1, 1, 2, 791.208312), -- Mid-Grade Life Stone - Level 55
(20988, 8746, 1, 1, 2, 79.026), -- High-Grade Life Stone - Level 55
(20988, 8756, 1, 1, 2, 16.121304), -- Top-Grade Life Stone - Level 55
-- Lageos
(20989, 1825, 1, 1, -1, 77195), -- Recipe: Oriharukon
(20989, 1902, 1, 1, -1, 109496), -- Elven Earring Beads
(20989, 1871, 1, 3, -1, 540365), -- Charcoal
(20989, 57, 457, 912, 0, 700000), -- Adena
(20989, 352, 1, 1, 1, 81.068852), -- Brigandine Tunic
(20989, 1941, 1, 1, 1, 3702.742851), -- Brigandine Temper
(20989, 2377, 1, 1, 1, 129.676963), -- Mithril Scale Gaiters
(20989, 2918, 1, 1, 1, 5523.924731), -- Mithril Scale Gaiters Material
(20989, 2378, 1, 1, 1, 129.676963), -- Brigandine Gaiters
(20989, 2919, 1, 1, 1, 5523.90964), -- Brigandine Gaiters Material
(20989, 1866, 1, 1, 2, 62072.612958), -- Suede
(20989, 1871, 1, 1, 2, 93108.829454), -- Charcoal
(20989, 5220, 1, 1, 2, 3724.39637), -- Metal Hardener
(20989, 1885, 1, 1, 2, 7759.054124), -- High-Grade Suede
(20989, 2146, 1, 1, 2, 6650.64353), -- Recipe: Artisan's frame
(20989, 5473, 1, 1, 2, 6650.463564), -- Recipe: Durable Metal Plate(100%)
-- Pageos
(20990, 1882, 1, 1, -1, 227993), -- Leather
(20990, 1903, 1, 1, -1, 171137), -- Elven Ring Piece
(20990, 2145, 1, 1, -1, 73283), -- Recipe: Mithril Alloy
(20990, 57, 434, 866, 0, 700000), -- Adena
(20990, 437, 1, 1, 1, 154.167822), -- Mithril Tunic
(20990, 1944, 1, 1, 1, 6762.752964), -- Mithril Tunic Fabric
(20990, 470, 1, 1, 1, 246.21201), -- Mithril Stockings
(20990, 1945, 1, 1, 1, 10530.867204), -- Mithril Stocking Design
(20990, 1867, 1, 1, 2, 101018.567302), -- Animal Skin
(20990, 1872, 1, 1, 2, 101018.567302), -- Animal Bone
(20990, 1882, 1, 1, 2, 16836.50909), -- Leather
(20990, 1894, 1, 1, 2, 2658.370528), -- Crafted Leather
(20990, 2147, 1, 1, 2, 5411.752466), -- Recipe: Blacksmith's frame
(20990, 2194, 1, 1, 2, 7746.596962), -- Recipe: Mithril Gloves
(20990, 1341, 10, 30, 2, 252547.63635), -- Bone Arrow
-- Swamp Tribe
(20991, 2064, 1, 1, -1, 31742), -- Silver Axe Head
(20991, 1908, 1, 1, -1, 388880), -- Moonstone Earring Wire
(20991, 1909, 1, 1, -1, 554567), -- Aquastone Ring Wire
(20991, 57, 1624, 3299, 0, 700000), -- Adena
(20991, 354, 1, 1, 1, 249.723584), -- Chain Mail Shirt
(20991, 1959, 1, 1, 1, 13069.055648), -- Chain Mail Shirt Material
(20991, 381, 1, 1, 1, 399.493248), -- Chain Gaiters
(20991, 1960, 1, 1, 1, 26585.72752), -- Chain Gaiters Part
(20991, 1875, 1, 1, 2, 11762.627883), -- Stone of Purity
(20991, 1879, 1, 1, 2, 29406.526596), -- Cokes
(20991, 1885, 1, 1, 2, 14703.263298), -- High-Grade Suede
(20991, 5550, 1, 1, 2, 2352.508332), -- Durable Metal Plate
(20991, 5549, 1, 1, 2, 17643.898713), -- Metallic Thread
(20991, 4556, 1, 1, 2, 705.735255), -- Greater Dye of CON (Con+1 Dex-1)
(20991, 3021, 1, 1, 2, 614.76999), -- Recipe: Dwarven War Hammer
(20991, 8723, 1, 1, 2, 7057.524996), -- Life Stone - Level 46
(20991, 8733, 1, 1, 2, 1764.381249), -- Mid-Grade Life Stone - Level 46
(20991, 8743, 1, 1, 2, 176.412258), -- High-Grade Life Stone - Level 46
(20991, 8753, 1, 1, 2, 35.35143), -- Top-Grade Life Stone - Level 46
-- Swamp Alligator
(20992, 1908, 1, 1, -1, 347561), -- Moonstone Earring Wire
(20992, 2163, 1, 1, -1, 187257), -- Recipe: Earring of Protection
(20992, 1909, 1, 1, -1, 495644), -- Aquastone Ring Wire
(20992, 57, 1445, 2961, 0, 700000), -- Adena
(20992, 852, 1, 1, 1, 484.662831), -- Moonstone Earring
(20992, 1908, 1, 1, 1, 27378.64731), -- Moonstone Earring Wire
(20992, 915, 1, 1, 1, 363.654219), -- Aquastone Necklace
(20992, 1910, 1, 1, 1, 21770.957418), -- Aquastone Necklace Chain
(20992, 883, 1, 1, 1, 727.308438), -- Aquastone Ring
(20992, 1909, 1, 1, 1, 39043.769784), -- Aquastone Ring Wire
(20992, 1868, 1, 1, 2, 346922.71589), -- Thread
(20992, 1873, 1, 1, 2, 69384.543178), -- Silver Nugget
(20992, 5549, 1, 1, 2, 17346.252806), -- Metallic Thread
(20992, 1889, 1, 1, 2, 11564.012522), -- Compound Braid
(20992, 2164, 1, 1, 2, 13343.055368), -- Recipe: Ring of Protection
(20992, 2319, 1, 1, 2, 604.247386), -- Recipe: Raid Sword
(20992, 8723, 1, 1, 2, 6938.313904), -- Life Stone - Level 46
(20992, 8733, 1, 1, 2, 1734.578476), -- Mid-Grade Life Stone - Level 46
(20992, 8743, 1, 1, 2, 173.645066), -- High-Grade Life Stone - Level 46
(20992, 8753, 1, 1, 2, 34.635404), -- Top-Grade Life Stone - Level 46
-- Swamp Warrior
(20993, 1869, 1, 9, -1, 778937), -- Iron Ore
(20993, 1864, 1, 17, -1, 865485), -- Stem
(20993, 2163, 1, 1, -1, 198708), -- Recipe: Earring of Protection
(20993, 57, 1533, 3142, 0, 700000), -- Adena
(20993, 62, 1, 1, 1, 210.629136), -- Reinforced Mithril Boots
(20993, 1958, 1, 1, 1, 9192.028128), -- Reinforced Mithril Boots Design
(20993, 2429, 1, 1, 1, 210.629136), -- Chain Boots
(20993, 2937, 1, 1, 1, 9192.028128), -- Chain Boots Part
(20993, 2430, 1, 1, 1, 210.629136), -- Karmian Boots
(20993, 2938, 1, 1, 1, 9192.028128), -- Karmian Boots Fabric
(20993, 2431, 1, 1, 1, 210.629136), -- Plated Leather Boots
(20993, 2939, 1, 1, 1, 9192.028128), -- Plate Leather Boots Lining
(20993, 2432, 1, 1, 1, 210.629136), -- Dwarven Chain Boots
(20993, 2940, 1, 1, 1, 9192.028128), -- Dwarven Chain Boots Part
(20993, 2433, 1, 1, 1, 210.629136), -- Boots of Seal
(20993, 2941, 1, 1, 1, 9192.028128), -- Boots of Seal Pattern
(20993, 2452, 1, 1, 1, 210.629136), -- Reinforced Mithril Gloves
(20993, 2942, 1, 1, 1, 9192.028128), -- Reinforced Mithril Gloves Design
(20993, 2453, 1, 1, 1, 210.629136), -- Chain Gloves
(20993, 2943, 1, 1, 1, 9192.028128), -- Chain Gloves Design
(20993, 2454, 1, 1, 1, 210.629136), -- Karmian Gloves
(20993, 2944, 1, 1, 1, 9192.112752), -- Karmian Gloves Fabric
(20993, 1869, 1, 1, 2, 184068.875197), -- Iron Ore
(20993, 1864, 1, 3, 2, 184068.875197), -- Stem
(20993, 1880, 1, 1, 2, 18406.846908), -- Steel
(20993, 5550, 1, 1, 2, 2454.165031), -- Durable Metal Plate
(20993, 2165, 1, 1, 2, 7052.627822), -- Recipe: Necklace of Protection
(20993, 2318, 1, 1, 2, 641.258743), -- Recipe: Spirit Sword
(20993, 8723, 1, 1, 2, 7362.90121), -- Life Stone - Level 46
(20993, 8733, 1, 1, 2, 1840.522244), -- Mid-Grade Life Stone - Level 46
(20993, 8743, 1, 1, 2, 183.971001), -- High-Grade Life Stone - Level 46
(20993, 8753, 1, 1, 2, 36.956647), -- Top-Grade Life Stone - Level 46
-- Garden Guard Leader
(20994, 4043, 1, 1, -1, 148005), -- Asofe
(20994, 4044, 1, 1, -1, 148005), -- Thons
(20994, 2169, 1, 1, -1, 78587), -- Recipe: Necklace of Seal
(20994, 57, 1756, 3570, 0, 700000), -- Adena
(20994, 265, 1, 1, 1, 55.568302), -- Fisted Blade
(20994, 2108, 1, 1, 1, 4917.431698), -- Fisted Blade Piece
(20994, 1894, 1, 1, 2, 5857.07314), -- Crafted Leather
(20994, 4039, 1, 1, 2, 5564.22965), -- Mold Glue
(20994, 4041, 1, 1, 2, 1451.54259), -- Mold Hardener
(20994, 4044, 1, 1, 2, 5564.22965), -- Thons
(20994, 3015, 1, 1, 2, 4662.75565), -- Recipe: Drake Leather Gloves
(20994, 4186, 1, 1, 2, 192.32575), -- Recipe: Sword of Valhalla (100%)
(20994, 3016, 1, 1, 2, 4662.75565), -- Recipe: Full Plate Gauntlets
(20994, 8725, 1, 1, 2, 4636.8298), -- Life Stone - Level 52
(20994, 8735, 1, 1, 2, 1159.20745), -- Mid-Grade Life Stone - Level 52
(20994, 8745, 1, 1, 2, 115.93769), -- High-Grade Life Stone - Level 52
(20994, 8755, 1, 1, 2, 23.11298), -- Top-Grade Life Stone - Level 52
-- Garden Guard
(20995, 1911, 1, 1, -1, 250980), -- Earring of Protection Gemstone
(20995, 2166, 1, 1, -1, 114387), -- Recipe: Earrings of Binding (100%)
(20995, 1966, 1, 1, -1, 123199); -- Plated Leather Fragment

INSERT INTO `droplist` VALUES
(20995, 57, 1334, 2712, 0, 700000), -- Adena
(20995, 2496, 1, 1, 1, 414.964881), -- Dwarven Chain Shield
(20995, 2947, 1, 1, 1, 17798.409681), -- Dwarven Chain Shield Fragment
(20995, 632, 1, 1, 1, 383.073611), -- Knight's Shield
(20995, 1972, 1, 1, 1, 19934.20587), -- Knight's Shield Fragment
(20995, 500, 1, 1, 1, 268.210986), -- Great Helmet
(20995, 1971, 1, 1, 1, 15254.134971), -- Great Helmet Material
(20995, 1870, 1, 1, 2, 135920.991656), -- Coal
(20995, 1865, 1, 1, 2, 135920.991656), -- Varnish
(20995, 1874, 1, 1, 2, 9061.355868), -- Oriharukon Ore
(20995, 4043, 1, 1, 2, 4530.677934), -- Asofe
(20995, 4039, 1, 1, 2, 4530.677934), -- Mold Glue
(20995, 2222, 1, 1, 2, 849.399982), -- Recipe: Composite Armor
(20995, 8724, 1, 1, 2, 4530.677934), -- Life Stone - Level 49
(20995, 8734, 1, 1, 2, 1132.751188), -- Mid-Grade Life Stone - Level 49
(20995, 8744, 1, 1, 2, 113.405846), -- High-Grade Life Stone - Level 49
(20995, 8754, 1, 1, 2, 22.550442), -- Top-Grade Life Stone - Level 49
(20995, 1539, 1, 1, 2, 30204.51956), -- Greater Healing Potion
-- Spiteful Ghost of Ruins
(20996, 1914, 1, 1, -1, 95679), -- Earring of Seal Gemstone
(20996, 1864, 1, 7, -1, 851546), -- Stem
(20996, 1869, 1, 3, -1, 851546), -- Iron Ore
(20996, 57, 674, 1369, 0, 700000), -- Adena
(20996, 265, 1, 1, 1, 21.319992), -- Fisted Blade
(20996, 2108, 1, 1, 1, 1886.680008), -- Fisted Blade Piece
(20996, 1864, 1, 1, 2, 128053.300403), -- Stem
(20996, 1869, 1, 1, 2, 64026.782373), -- Iron Ore
(20996, 1878, 1, 1, 2, 25610.607212), -- Braided Hemp
(20996, 1884, 1, 1, 2, 39401.117179), -- Cord
(20996, 4039, 1, 1, 2, 2134.305382), -- Mold Glue
(20996, 2169, 1, 1, 2, 1133.238441), -- Recipe: Necklace of Seal
(20996, 3019, 1, 1, 2, 1707.391437), -- Recipe: Full Plate Shield
(20996, 8725, 1, 1, 2, 1778.499704), -- Life Stone - Level 52
(20996, 8735, 1, 1, 2, 444.624926), -- Mid-Grade Life Stone - Level 52
(20996, 8745, 1, 1, 2, 44.409624), -- High-Grade Life Stone - Level 52
(20996, 8755, 1, 1, 2, 8.723319), -- Top-Grade Life Stone - Level 52
-- Soldier of Grief
(20997, 4601, 1, 1, -1, 3371), -- Greater Dye of STR (Str+3 Con-3)
(20997, 1539, 1, 1, -1, 337056), -- Greater Healing Potion
(20997, 1915, 1, 1, -1, 133634), -- Ring of Ages Gemstone
(20997, 57, 601, 1220, 0, 700000), -- Adena
(20997, 60, 1, 1, 1, 51.11631), -- Composite Armor
(20997, 1977, 1, 1, 1, 4638.88369), -- Composite Armor Temper
(20997, 1873, 1, 1, 2, 22808.54148), -- Silver Nugget
(20997, 1868, 1, 1, 2, 114042.877334), -- Thread
(20997, 1876, 1, 1, 2, 11404.27074), -- Mithril Ore
(20997, 1895, 1, 1, 2, 16291.912448), -- Metallic Fiber
(20997, 4042, 1, 1, 2, 950.440862), -- Enria
(20997, 2170, 1, 1, 2, 1344.857676), -- Recipe: Nassen's Earring
(20997, 3012, 1, 1, 2, 1063.78684), -- Recipe: Full Plate Helmet
(20997, 8725, 1, 1, 2, 1583.954814), -- Life Stone - Level 52
(20997, 8735, 1, 1, 2, 395.94622), -- Mid-Grade Life Stone - Level 52
(20997, 8745, 1, 1, 2, 39.594622), -- High-Grade Life Stone - Level 52
(20997, 8755, 1, 1, 2, 7.816964), -- Top-Grade Life Stone - Level 52
-- Cruel Punisher
(20998, 2169, 1, 1, -1, 29606), -- Recipe: Necklace of Seal
(20998, 1916, 1, 1, -1, 71182), -- Necklace of Mermaid Teardrop
(20998, 2170, 1, 1, -1, 39452), -- Recipe: Nassen's Earring
(20998, 57, 664, 1343, 0, 700000), -- Adena
(20998, 162, 1, 1, 1, 2.617434), -- War Axe
(20998, 2097, 1, 1, 1, 231.636168), -- War Axe Blade
(20998, 174, 1, 1, 1, 2.617434), -- Nirvana Axe
(20998, 2098, 1, 1, 1, 231.636168), -- Nirvana Axe Blade
(20998, 196, 1, 1, 1, 2.617434), -- Stick of Eternity
(20998, 2099, 1, 1, 1, 243.779598), -- Stick of Eternity Shaft
(20998, 197, 1, 1, 1, 2.617434), -- Paradia Staff
(20998, 2100, 1, 1, 1, 243.779598), -- Paradia Staff Head
(20998, 199, 1, 1, 1, 2.617434), -- Pa'agrian Hammer
(20998, 2102, 1, 1, 1, 235.035558), -- Pa'agrian Hammer Head
(20998, 200, 1, 1, 1, 2.617434), -- Sage's Staff
(20998, 2103, 1, 1, 1, 243.779598), -- Sage's Staff Head
(20998, 201, 1, 1, 1, 2.617434), -- Club of Nature
(20998, 2104, 1, 1, 1, 243.779598), -- Club of Nature Head
(20998, 202, 1, 1, 1, 2.617434), -- Mace of Underworld
(20998, 2105, 1, 1, 1, 231.634242), -- Mace of Underworld Head
(20998, 1871, 1, 1, 2, 53211.674628), -- Charcoal
(20998, 1866, 1, 1, 2, 35474.449752), -- Suede
(20998, 1877, 1, 1, 2, 2128.493556), -- Adamantite Nugget
(20998, 4041, 1, 1, 2, 462.665448), -- Mold Hardener
(20998, 4040, 1, 1, 2, 1064.163744), -- Mold Lubricant
(20998, 2231, 1, 1, 2, 229.339908), -- Recipe: Full Plate Armor
(20998, 5155, 1, 1, 2, 106.449588), -- Recipe: Soulshot (B) Compressed Package (100%)
(20998, 6669, 1, 1, 2, 12374.723088), -- Deluxe Chest Key - Grade 5
(20998, 8725, 1, 1, 2, 1478.171268), -- Life Stone - Level 52
(20998, 8735, 1, 1, 2, 369.5013), -- Mid-Grade Life Stone - Level 52
(20998, 8745, 1, 1, 2, 37.033164), -- High-Grade Life Stone - Level 52
(20998, 8755, 1, 1, 2, 7.47306), -- Top-Grade Life Stone - Level 52
(20998, 1832, 1, 1, 2, 59123.861496), -- Greater Antidote
-- Roving Soul
(20999, 1918, 1, 1, -1, 86067), -- Nassen's Earring Gemstone
(20999, 1868, 1, 9, -1, 794915), -- Thread
(20999, 1873, 1, 1, -1, 794915), -- Silver Nugget
(20999, 57, 787, 1598, 0, 700000), -- Adena
(20999, 228, 1, 1, 1, 15.564262), -- Crystal Dagger
(20999, 2119, 1, 1, 1, 1671.435738), -- Crystal Dagger Blade
(20999, 1868, 1, 1, 2, 122294.882784), -- Thread
(20999, 1873, 1, 1, 2, 24458.912092), -- Silver Nugget
(20999, 5549, 1, 1, 2, 6114.808604), -- Metallic Thread
(20999, 1889, 1, 1, 2, 4076.431628), -- Compound Braid
(20999, 4044, 1, 1, 2, 2038.215814), -- Thons
(20999, 1806, 1, 1, 2, 122.321958), -- Recipe: Soulshot (B-Grade)
(20999, 5270, 1, 1, 2, 122.321958), -- Recipe: Greater Soulshot (B) Compressed Package(100%)
(20999, 5280, 1, 1, 2, 122.321958), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(20999, 8726, 1, 1, 2, 1415.485846), -- Life Stone - Level 55
(20999, 8736, 1, 1, 2, 353.911752), -- Mid-Grade Life Stone - Level 55
(20999, 8746, 1, 1, 2, 35.45564), -- High-Grade Life Stone - Level 55
(20999, 8756, 1, 1, 2, 6.929966), -- Top-Grade Life Stone - Level 55
-- Soul of Ruins
(21000, 1865, 1, 3, -1, 871346), -- Varnish
(21000, 1986, 1, 1, -1, 18415), -- Full Plate Armor Temper
(21000, 1918, 1, 1, -1, 75474), -- Nassen's Earring Gemstone
(21000, 57, 688, 1402, 0, 700000), -- Adena
(21000, 301, 1, 1, 1, 5.83392), -- Scorpion
(21000, 2113, 1, 1, 1, 519.544875), -- Scorpion Blade
(21000, 303, 1, 1, 1, 5.83392), -- Widow Maker
(21000, 2114, 1, 1, 1, 519.544875), -- Widowmaker Head
(21000, 299, 1, 1, 1, 4.55157), -- Orcish Poleaxe
(21000, 2122, 1, 1, 1, 489.69084), -- Orcish Poleaxe Blade
(21000, 1865, 1, 1, 2, 49496.61717), -- Varnish
(21000, 1870, 1, 1, 2, 49496.61717), -- Coal
(21000, 1879, 1, 1, 2, 8249.398344), -- Cokes
(21000, 1875, 1, 1, 2, 3299.736627), -- Stone of Purity
(21000, 4040, 1, 1, 2, 989.955054), -- Mold Lubricant
(21000, 4182, 1, 1, 2, 57.003606), -- Recipe: Great Sword (100%)
(21000, 5160, 1, 1, 2, 99.018216), -- Recipe: Spiritshot (B) Compressed Package (100%)
(21000, 5436, 1, 1, 2, 80.736183), -- Recipe: Berserker Blade(100%)
(21000, 4146, 1, 1, 2, 317.267082), -- Recipe: Tunic of Zubei (100%)
(21000, 8726, 1, 1, 2, 1145.74977), -- Life Stone - Level 55
(21000, 8736, 1, 1, 2, 286.494219), -- Mid-Grade Life Stone - Level 55
(21000, 8746, 1, 1, 2, 28.615356), -- High-Grade Life Stone - Level 55
(21000, 8756, 1, 1, 2, 5.791203), -- Top-Grade Life Stone - Level 55
-- Wretched Archer
(21001, 1988, 1, 1, -1, 45373), -- Divine Tunic Fabric
(21001, 1895, 1, 1, -1, 674702), -- Metallic Fiber
(21001, 4042, 1, 1, -1, 39358), -- Enria
(21001, 57, 933, 1901, 0, 700000), -- Adena
(21001, 286, 1, 1, 1, 18.496289), -- Eminence Bow
(21001, 2121, 1, 1, 1, 2004.503711), -- Eminence Bow Shaft
(21001, 1873, 1, 1, 2, 24912.121482), -- Silver Nugget
(21001, 1868, 1, 1, 2, 124560.988542), -- Thread
(21001, 1876, 1, 1, 2, 12456.156024), -- Mithril Ore
(21001, 1895, 1, 1, 2, 17794.481382), -- Metallic Fiber
(21001, 4042, 1, 1, 2, 1038.013002), -- Enria
(21001, 4939, 1, 1, 2, 770.83947), -- Recipe: Adamantite Necklace (70%)
(21001, 4966, 1, 1, 2, 71.843382), -- Recipe: Keshanberk (60%)
(21001, 5165, 1, 1, 2, 124.630164), -- Recipe: Blessed Spiritshot (B) Compressed Package (100%)
(21001, 4180, 1, 1, 2, 6920.023158), -- Recipe: Silver Arrow (100%)
(21001, 4971, 1, 1, 2, 71.843382), -- Recipe: Dark Elven Long Bow (60%)
(21001, 8726, 1, 1, 2, 1441.63179), -- Life Stone - Level 55
(21001, 8736, 1, 1, 2, 360.360306), -- Mid-Grade Life Stone - Level 55
(21001, 8746, 1, 1, 2, 36.016974), -- High-Grade Life Stone - Level 55
(21001, 8756, 1, 1, 2, 7.050942), -- Top-Grade Life Stone - Level 55
-- Doom Scout
(21002, 1874, 1, 1, -1, 139115), -- Oriharukon Ore
(21002, 2960, 1, 1, -1, 113625), -- Drake Leather Boots Design
(21002, 4613, 1, 1, -1, 2878), -- Greater Dye of STR (Str+4 Con-4)
(21002, 57, 823, 1681, 0, 700000), -- Adena
(21002, 11896, 1, 1, 1, 176.338195), -- Common Item - Dark Elven Long Bow
(21002, 4112, 1, 1, 1, 1744.661805), -- Dark Elven Longbow Shaft
(21002, 1872, 1, 1, 2, 68487.411027), -- Animal Bone
(21002, 1867, 1, 1, 2, 68487.411027), -- Animal Skin
(21002, 1881, 1, 1, 2, 6848.726101), -- Coarse Bone Powder
(21002, 1875, 1, 1, 2, 3424.438059), -- Stone of Purity
(21002, 4041, 1, 1, 2, 446.600609), -- Mold Hardener
(21002, 4949, 1, 1, 2, 329.287315), -- Recipe: Tunic of Zubei (60%)
(21002, 4992, 1, 1, 2, 638.922403), -- Recipe: Sealed Blue Wolf Boots (60%)
(21002, 8311, 1, 1, 2, 39.154437), -- Recipe: Kaim Vanul's Bones (100%)
(21002, 8727, 1, 1, 2, 1027.316416), -- Life Stone - Level 58
(21002, 8737, 1, 1, 2, 256.829104), -- Mid-Grade Life Stone - Level 58
(21002, 8747, 1, 1, 2, 25.652907), -- High-Grade Life Stone - Level 58
(21002, 8757, 1, 1, 2, 5.250595), -- Top-Grade Life Stone - Level 58
-- Grave Lich
(21003, 2963, 1, 1, -1, 104221), -- Full Plate Gauntlets Part
(21003, 4949, 1, 1, -1, 12269), -- Recipe: Tunic of Zubei (60%)
(21003, 4049, 1, 1, -1, 100394), -- Adamantite Earring Gemstone
(21003, 57, 755, 1542, 0, 700000), -- Adena
(21003, 12159, 1, 1, 1, 645.406589), -- Common Item - Zubei's Shield
(21003, 4101, 1, 1, 1, 4096.903655), -- Zubei's Shield Fragment
(21003, 12171, 1, 1, 1, 645.406589), -- Common Item - Avadon Shield
(21003, 4439, 1, 1, 1, 4873.902926), -- Avadon Shield Fragment
(21003, 12160, 1, 1, 1, 451.572705), -- Common Item - Zubei's Helmet
(21003, 4102, 1, 1, 1, 3174.108659), -- Zubei's Helmet Design
(21003, 12170, 1, 1, 1, 451.572705), -- Common Item - Avadon Circlet
(21003, 4072, 1, 1, 1, 3174.126172), -- Avadon Circlet Pattern
(21003, 1866, 1, 1, 2, 28993.364988), -- Suede
(21003, 1871, 1, 1, 2, 43490.047482), -- Charcoal
(21003, 5220, 1, 1, 2, 1739.607051), -- Metal Hardener
(21003, 1885, 1, 1, 2, 3624.23502), -- High-Grade Suede
(21003, 4041, 1, 1, 2, 378.136248), -- Mold Hardener
(21003, 4963, 1, 1, 2, 50.100477), -- Recipe: Great Sword (60%)
(21003, 4999, 1, 1, 2, 540.9306), -- Recipe: Sealed Doom Boots (60%)
(21003, 4993, 1, 1, 2, 540.9306), -- Recipe: Sealed Doom Gloves (60%)
(21003, 8727, 1, 1, 2, 869.739129), -- Life Stone - Level 58
(21003, 8737, 1, 1, 2, 217.402584), -- Mid-Grade Life Stone - Level 58
(21003, 8747, 1, 1, 2, 21.766017), -- High-Grade Life Stone - Level 58
(21003, 8757, 1, 1, 2, 4.378962), -- Top-Grade Life Stone - Level 58
(21003, 1832, 1, 1, 2, 48322.360842), -- Greater Antidote
-- Dismal Pole
(21004, 4951, 1, 1, -1, 9324), -- Recipe: Avadon Robe (60%)
(21004, 1920, 1, 1, -1, 72742), -- Necklace of Seal Chain
(21004, 4129, 1, 1, -1, 23007), -- Recipe: Earrings of Black Ore (100%)
(21004, 57, 840, 1710, 0, 700000), -- Adena
(21004, 12151, 1, 1, 1, 334.38911), -- Common Item - Zubei's Leather Shirt
(21004, 4066, 1, 1, 1, 2467.60536), -- Zubei's Leather Shirt Fabric
(21004, 12165, 1, 1, 1, 205.220455), -- Common Item - Avadon Leather Armor
(21004, 4068, 1, 1, 1, 1895.738075), -- Avadon Leather Armor Lining
(21004, 12150, 1, 1, 1, 535.366095), -- Common Item - Zubei's Leather Gaiters
(21004, 4067, 1, 1, 1, 3746.680905), -- Zubei's Leather Gaiter Texture
(21004, 1873, 1, 1, 2, 20931.805038), -- Silver Nugget
(21004, 1868, 1, 1, 2, 104659.179444), -- Thread
(21004, 1876, 1, 1, 2, 10465.979646), -- Mithril Ore
(21004, 1895, 1, 1, 2, 14951.377458), -- Metallic Fiber
(21004, 4042, 1, 1, 2, 872.152116), -- Enria
(21004, 4129, 1, 1, 2, 566.266434), -- Recipe: Earrings of Black Ore (100%)
(21004, 4167, 1, 1, 2, 650.797626), -- Recipe: Sealed Blue Wolf Boots (100%)
(21004, 4197, 1, 1, 2, 39.951786), -- Recipe: Demon's Dagger (100%)
(21004, 8728, 1, 1, 2, 872.152116), -- Life Stone - Level 61
(21004, 8738, 1, 1, 2, 218.115156), -- Mid-Grade Life Stone - Level 61
(21004, 8748, 1, 1, 2, 21.749814), -- High-Grade Life Stone - Level 61
(21004, 8758, 1, 1, 2, 4.473366), -- Top-Grade Life Stone - Level 61
-- Grave Predator
(21005, 947, 1, 1, -1, 932), -- Scroll: Enchant Weapon (B-Grade)
(21005, 1880, 1, 1, -1, 233106), -- Steel
(21005, 4050, 1, 1, -1, 144427), -- Adamantite Ring Wire
(21005, 57, 920, 1876, 0, 700000), -- Adena
(21005, 11889, 1, 1, 1, 65.67673), -- Common Item - Great Sword
(21005, 4104, 1, 1, 1, 656.773741), -- Great Sword Blade
(21005, 11916, 1, 1, 1, 65.67673), -- Common Item - Keshanberk
(21005, 4107, 1, 1, 1, 646.596961), -- Keshanberk Blade
(21005, 11900, 1, 1, 1, 65.67673), -- Common Item - Sword of Valhalla
(21005, 4108, 1, 1, 1, 646.599108), -- Sword of Valhalla Blade
(21005, 1873, 1, 1, 2, 22951.926277), -- Silver Nugget
(21005, 1868, 1, 1, 2, 114759.800526), -- Thread
(21005, 1876, 1, 1, 2, 11476.047709), -- Mithril Ore
(21005, 1895, 1, 1, 2, 16394.329707), -- Metallic Fiber
(21005, 4042, 1, 1, 2, 956.323214), -- Enria
(21005, 4129, 1, 1, 2, 620.916611), -- Recipe: Earrings of Black Ore (100%)
(21005, 4167, 1, 1, 2, 713.605879), -- Recipe: Sealed Blue Wolf Boots (100%)
(21005, 4197, 1, 1, 2, 43.807519), -- Recipe: Demon's Dagger (100%)
(21005, 8728, 1, 1, 2, 956.323214), -- Life Stone - Level 61
(21005, 8738, 1, 1, 2, 239.165374), -- Mid-Grade Life Stone - Level 61
(21005, 8748, 1, 1, 2, 23.848881), -- High-Grade Life Stone - Level 61
(21005, 8758, 1, 1, 2, 4.905089), -- Top-Grade Life Stone - Level 61
-- Doom Servant
(21006, 4066, 1, 1, -1, 52315), -- Zubei's Leather Shirt Fabric
(21006, 948, 1, 1, -1, 5547), -- Scroll: Enchant Armor (B-Grade)
(21006, 4130, 1, 1, -1, 36022), -- Recipe: Ring of Black Ore (100%)
(21006, 57, 878, 1784, 0, 700000), -- Adena
(21006, 357, 1, 1, 1, 10.26675), -- Zubei's Breastplate
(21006, 4056, 1, 1, 1, 1483.347645), -- Zubei's Breastplate Part
(21006, 2376, 1, 1, 1, 10.26675), -- Avadon Breastplate
(21006, 4064, 1, 1, 1, 1483.347645), -- Avadon Breastplate Part
(21006, 383, 1, 1, 1, 16.4268), -- Zubei's Gaiters
(21006, 4057, 1, 1, 1, 2292.4512), -- Zubei's Gaiter Material
(21006, 2379, 1, 1, 1, 16.4268), -- Avadon Gaiters
(21006, 4065, 1, 1, 1, 2292.46641), -- Avadon Gaiters Material
(21006, 1869, 1, 1, 2, 54620.614071), -- Iron Ore
(21006, 1864, 1, 1, 2, 109241.401943), -- Stem
(21006, 1880, 1, 1, 2, 5462.044027), -- Steel
(21006, 5550, 1, 1, 2, 728.22619), -- Durable Metal Plate
(21006, 4043, 1, 1, 2, 1820.739276), -- Asofe
(21006, 4193, 1, 1, 2, 41.71224), -- Recipe: Lance (100%)
(21006, 4173, 1, 1, 2, 679.388109), -- Recipe: Sealed Blue Wolf Gloves (100%)
(21006, 5003, 1, 1, 2, 41.71224), -- Recipe: Art of Battle Axe (60%)
(21006, 8728, 1, 1, 2, 910.369638), -- Life Stone - Level 61
(21006, 8738, 1, 1, 2, 227.505509), -- Mid-Grade Life Stone - Level 61
(21006, 8748, 1, 1, 2, 22.767931), -- High-Grade Life Stone - Level 61
(21006, 8758, 1, 1, 2, 4.518826), -- Top-Grade Life Stone - Level 61
-- Doom Guard
(21007, 4981, 1, 1, -1, 7411), -- Recipe: Blue Wolf Breastplate (60%)
(21007, 4051, 1, 1, -1, 92552), -- Adamantite Necklace Chain
(21007, 948, 1, 1, -1, 5966), -- Scroll: Enchant Armor (B-Grade)
(21007, 57, 946, 1918, 0, 700000), -- Adena
(21007, 11918, 1, 1, 1, 100.842792), -- Common Item - Heavy War Axe
(21007, 4105, 1, 1, 1, 1008.430122), -- Heavy War Axe Head
(21007, 11908, 1, 1, 1, 100.842792), -- Common Item - Sprite's Staff
(21007, 4106, 1, 1, 1, 991.884294), -- Sprite's Staff Head
(21007, 1894, 1, 1, 2, 2061.183042), -- Crafted Leather
(21007, 4039, 1, 1, 2, 1958.116459), -- Mold Glue
(21007, 4041, 1, 1, 2, 510.800066), -- Mold Hardener
(21007, 4044, 1, 1, 2, 1958.116459), -- Thons
(21007, 4621, 1, 1, 2, 80.99681), -- Greater Dye of MEN (Men+4 Int-4)
(21007, 4998, 1, 1, 2, 730.606088), -- Recipe: Sealed Blue Wolf Gloves (60%)
(21007, 4166, 1, 1, 2, 485.460697), -- Recipe: Doom Helmet (100%)
(21007, 8728, 1, 1, 2, 979.021075), -- Life Stone - Level 61
(21007, 8738, 1, 1, 2, 244.773846), -- Mid-Grade Life Stone - Level 61
(21007, 8748, 1, 1, 2, 24.447661), -- High-Grade Life Stone - Level 61
(21007, 8758, 1, 1, 2, 4.904394), -- Top-Grade Life Stone - Level 61
(21007, 1832, 1, 1, 2, 65270.573403), -- Greater Antidote
-- Doom Archer
(21008, 4983, 1, 1, -1, 6493), -- Recipe: Doom Plate Armor (60%)
(21008, 5230, 1, 1, -1, 4078), -- Recipe: Mithril Arrow (100%)
(21008, 4052, 1, 1, -1, 108272), -- Earring of Black Ore Piece
(21008, 57, 1213, 2457, 0, 700000), -- Adena
(21008, 12188, 1, 1, 1, 600.607957), -- Common Item - Sealed Doom Boots
(21008, 4099, 1, 1, 1, 5069.142043), -- Sealed Doom Boots Part
(21008, 12189, 1, 1, 1, 600.607957), -- Common Item - Sealed Blue Wolf Boots
(21008, 4090, 1, 1, 1, 5069.142043), -- Sealed Blue Wolf Boots Design
(21008, 12187, 1, 1, 1, 600.607957), -- Common Item - Sealed Doom Gloves
(21008, 4091, 1, 1, 1, 5069.142043), -- Sealed Doom Gloves Part
(21008, 12190, 1, 1, 1, 600.607957), -- Common Item - Sealed Blue Wolf Gloves
(21008, 4096, 1, 1, 1, 5069.142043), -- Sealed Blue Wolf Gloves Fabric
(21008, 1867, 1, 1, 2, 109494.236229), -- Animal Skin
(21008, 1872, 1, 1, 2, 109494.236229), -- Animal Bone
(21008, 1882, 1, 1, 2, 18249.160958), -- Leather
(21008, 1894, 1, 1, 2, 2881.356877), -- Crafted Leather
(21008, 4042, 1, 1, 2, 1368.577644), -- Enria
(21008, 4983, 1, 1, 2, 174.355041), -- Recipe: Doom Plate Armor (60%)
(21008, 5276, 1, 1, 2, 109.42785), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21008, 8729, 1, 1, 2, 1095.008019), -- Life Stone - Level 64
(21008, 8739, 1, 1, 2, 273.812798), -- Mid-Grade Life Stone - Level 64
(21008, 8749, 1, 1, 2, 27.478549), -- High-Grade Life Stone - Level 64
(21008, 8759, 1, 1, 2, 5.349806), -- Top-Grade Life Stone - Level 64
-- Doom Trooper 
(21009, 4104, 1, 1, -1, 18708), -- Great Sword Blade
(21009, 948, 1, 1, -1, 8173), -- Scroll: Enchant Armor (B-Grade)
(21009, 4052, 1, 1, -1, 115743), -- Earring of Black Ore Piece
(21009, 57, 1297, 2625, 0, 700000), -- Adena
(21009, 12204, 1, 1, 1, 214.314874), -- Common Item - Blue Wolf Breastplate
(21009, 4078, 1, 1, 1, 2350.979085), -- Blue Wolf Breastplate Part
(21009, 12184, 1, 1, 1, 131.920877), -- Common Item - Doom Plate Armor
(21009, 4081, 1, 1, 1, 1586.320568), -- Doom Plate Armor Temper
(21009, 12193, 1, 1, 1, 342.806967), -- Common Item - Blue Wolf Gaiters
(21009, 4080, 1, 1, 1, 3310.657629), -- Blue Wolf Gaiters Material
(21009, 1865, 1, 1, 2, 87787.21732), -- Varnish
(21009, 1870, 1, 1, 2, 87787.21732), -- Coal
(21009, 1879, 1, 1, 2, 14631.236136), -- Cokes
(21009, 1875, 1, 1, 2, 5852.414656), -- Stone of Purity
(21009, 4040, 1, 1, 2, 1755.764296), -- Mold Lubricant
(21009, 5004, 1, 1, 2, 67.030656), -- Recipe: Staff of Evil Spirits (60%)
(21009, 5281, 1, 1, 2, 117.104152), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21009, 8729, 1, 1, 2, 1170.443032), -- Life Stone - Level 64
(21009, 8739, 1, 1, 2, 292.660632), -- Mid-Grade Life Stone - Level 64
(21009, 8749, 1, 1, 2, 29.325912), -- High-Grade Life Stone - Level 64
(21009, 8759, 1, 1, 2, 5.585888), -- Top-Grade Life Stone - Level 64
-- Doom Warrior
(21010, 4621, 1, 1, -1, 3620), -- Greater Dye of MEN (Men+4 Int-4)
(21010, 5230, 1, 1, -1, 3500), -- Recipe: Mithril Arrow (100%)
(21010, 57, 1042, 2108, 0, 700000), -- Adena
(21010, 11933, 1, 1, 1, 126.65055), -- Common Item - Bellion Cestus
(21010, 4120, 1, 1, 1, 1694.34945), -- Bellion Cestus Edge
(21010, 1868, 1, 1, 2, 119273.46406), -- Thread
(21010, 1873, 1, 1, 2, 23854.75954), -- Silver Nugget
(21010, 5549, 1, 1, 2, 5963.64818), -- Metallic Thread
(21010, 1889, 1, 1, 2, 3975.82106), -- Compound Braid
(21010, 4044, 1, 1, 2, 1987.82712), -- Thons
(21010, 4129, 1, 1, 2, 645.42658), -- Recipe: Earrings of Black Ore (100%)
(21010, 4624, 1, 1, 2, 82.24226), -- Greater Dye of WIT (Wit+4 Men-4)
(21010, 3956, 1, 1, 2, 79.57314), -- Recipe: Blessed Spiritshot A
(21010, 6670, 1, 1, 2, 9939.46924), -- Deluxe Chest Key - Grade 6
(21010, 8729, 1, 1, 2, 795.23094), -- Life Stone - Level 64
(21010, 8739, 1, 1, 2, 198.84944), -- Mid-Grade Life Stone - Level 64
(21010, 8749, 1, 1, 2, 19.85158), -- High-Grade Life Stone - Level 64
(21010, 8759, 1, 1, 2, 3.83686), -- Top-Grade Life Stone - Level 64
-- Ol Mahum Van Grunt
(21011, 1884, 1, 1, -1, 326755), -- Cord
(21011, 1832, 1, 1, -1, 589975), -- Greater Antidote
(21011, 1900, 1, 1, -1, 58094), -- Enchanted Necklace Chain
(21011, 57, 224, 448, 0, 700000), -- Adena
(21011, 627, 1, 1, 1, 1078.49287), -- Aspis
(21011, 46, 1, 1, 1, 755.50713), -- Bronze Helmet
(21011, 1864, 1, 1, 2, 72539.733448), -- Stem
(21011, 1865, 1, 1, 2, 36269.866724), -- Varnish
(21011, 1866, 1, 1, 2, 24179.82801), -- Suede
(21011, 1873, 1, 1, 2, 14507.896806), -- Silver Nugget
(21011, 1868, 1, 1, 2, 72539.733448), -- Thread
(21011, 2185, 1, 1, 2, 7139.839668), -- Recipe: Iron Boots
(21011, 2274, 1, 1, 2, 259.145302), -- Recipe: Skull Breaker
(21011, 1061, 1, 1, 2, 21981.956594), -- Greater Healing Potion
-- Magical Eye
(21012, 1936, 1, 1, -1, 53457), -- White Tunic Pattern
(21012, 2185, 1, 1, -1, 128592), -- Recipe: Iron Boots
(21012, 2153, 1, 1, -1, 101594), -- Recipe: Tiger's Eye Earring
(21012, 57, 276, 551, 0, 700000), -- Adena
(21012, 275, 1, 1, 1, 48.025665), -- Long Bow
(21012, 276, 1, 1, 1, 48.025665), -- Elven Bow
(21012, 2024, 1, 1, 1, 1694.94867), -- Elven Bow Shaft
(21012, 1868, 1, 1, 2, 101992.861289), -- Thread
(21012, 1873, 1, 1, 2, 20398.679367), -- Silver Nugget
(21012, 5549, 1, 1, 2, 5099.736785), -- Metallic Thread
(21012, 1889, 1, 1, 2, 3399.646008), -- Compound Braid
(21012, 2264, 1, 1, 2, 527.245037), -- Recipe: Two-handed Sword
(21012, 2273, 1, 1, 2, 364.17128), -- Recipe: Tarbar
(21012, 1833, 1, 1, 2, 135990.660234), -- Bandage
-- Ol Mahum Van Archer
(21013, 1061, 1, 1, -1, 466705), -- Greater Healing Potion
(21013, 2023, 1, 1, -1, 9542), -- Conjuror's Staff Head
(21013, 1933, 1, 1, -1, 90596), -- Dark Stockings Fabric
(21013, 57, 324, 651, 0, 700000), -- Adena
(21013, 848, 1, 1, 1, 641.472052), -- Enchanted Earring
(21013, 911, 1, 1, 1, 481.464386), -- Enchanted Necklace
(21013, 1900, 1, 1, 1, 11509.918316), -- Enchanted Necklace Chain
(21013, 879, 1, 1, 1, 965.145246), -- Enchanted Ring
(21013, 1871, 1, 1, 2, 70135.122772), -- Charcoal
(21013, 1866, 1, 1, 2, 46756.805964), -- Suede
(21013, 1877, 1, 1, 2, 2805.480744), -- Adamantite Nugget
(21013, 737, 1, 1, 2, 7013.529512), -- Scroll of Resurrection
(21013, 2187, 1, 1, 2, 3131.046116), -- Recipe: Manticore Skin Shirt
(21013, 1061, 1, 1, 2, 42506.014892), -- Greater Healing Potion
-- Lesser Warlike Tyrant
(21014, 2977, 1, 1, -1, 106414), -- Recipe: Brigandine Boots
(21014, 1958, 1, 1, -1, 71453), -- Reinforced Mithril Boots Design
(21014, 1865, 1, 1, -1, 794911), -- Varnish
(21014, 57, 336, 672, 0, 700000), -- Adena
(21014, 316, 1, 1, 1, 37.907312), -- Sage's Blood
(21014, 317, 1, 1, 1, 37.907312), -- Tome of Blood
(21014, 2030, 1, 1, 1, 1648.185376), -- Tome of Blood Page
(21014, 1865, 1, 1, 2, 70441.29989), -- Varnish
(21014, 1870, 1, 1, 2, 70441.29989), -- Coal
(21014, 1879, 1, 1, 2, 11740.16303), -- Cokes
(21014, 1875, 1, 1, 2, 4696.161725), -- Stone of Purity
(21014, 2189, 1, 1, 2, 3144.71525), -- Recipe: Mithril Tunic
(21014, 2286, 1, 1, 2, 391.360215), -- Recipe: Bonebreaker
-- Ol Mahum Van Leader
(21015, 1940, 1, 1, -1, 121028), -- Iron Boots Design
(21015, 1869, 1, 1, -1, 810885), -- Iron Ore
(21015, 1873, 1, 1, -1, 324354), -- Silver Nugget
(21015, 57, 342, 683, 0, 700000), -- Adena
(21015, 83, 1, 1, 1, 26.091), -- Sword of Magic
(21015, 144, 1, 1, 1, 26.091), -- Sword of Occult
(21015, 124, 1, 1, 1, 19.3284), -- Two-Handed Sword
(21015, 2026, 1, 1, 1, 864.831825), -- Two-Handed Sword Edge
(21015, 127, 1, 1, 1, 19.3284), -- Crimson Sword
(21015, 130, 1, 1, 1, 19.329375), -- Elven Sword
(21015, 1873, 1, 1, 2, 34491.320064), -- Silver Nugget
(21015, 1868, 1, 1, 2, 172456.127616), -- Thread
(21015, 1876, 1, 1, 2, 17245.660032), -- Mithril Ore
(21015, 2280, 1, 1, 2, 615.933312), -- Recipe: Crucifix of Blood
(21015, 2978, 1, 1, 2, 11542.958976), -- Recipe: Elven Mithril Boots
-- Warlike Tyrant
(21016, 1870, 1, 1, -1, 868501), -- Coal
(21016, 1882, 1, 1, -1, 193000), -- Leather
(21016, 1901, 1, 1, -1, 119959), -- Tiger's Eye Earring Stone
(21016, 57, 367, 732, 0, 700000), -- Adena
(21016, 58, 1, 1, 1, 93.563163), -- Mithril Breastplate
(21016, 349, 1, 1, 1, 93.563163), -- Compound Scale Mail
(21016, 350, 1, 1, 1, 93.563163), -- Dwarven Scale Mail
(21016, 351, 1, 1, 1, 84.518562), -- Blast Plate
(21016, 59, 1, 1, 1, 135.26424), -- Mithril Gaiters
(21016, 378, 1, 1, 1, 135.26424), -- Compound Scale Gaiters
(21016, 379, 1, 1, 1, 135.263469), -- Dwarven Scale Gaiters
(21016, 1869, 1, 1, 2, 65968.001142), -- Iron Ore
(21016, 1864, 1, 1, 2, 131936.002284), -- Stem
(21016, 1880, 1, 1, 2, 6596.843124), -- Steel
(21016, 5550, 1, 1, 2, 879.55041), -- Durable Metal Plate
(21016, 2191, 1, 1, 2, 8830.987185), -- Recipe: RIP Gauntlets
(21016, 2293, 1, 1, 2, 366.443496), -- Recipe: Glaive
(21016, 2276, 1, 1, 2, 471.172359), -- Recipe: Maingauche
-- Fallen Orc
(21017, 1989, 1, 1, -1, 53465), -- Divine Stocking Pattern
(21017, 1880, 1, 1, -1, 177397), -- Steel
(21017, 1806, 1, 1, -1, 3548), -- Recipe: Soulshot (B-Grade)
(21017, 57, 701, 1428, 0, 700000), -- Adena
(21017, 400, 1, 1, 1, 34.38225), -- Theca Leather Armor
(21017, 1984, 1, 1, 1, 2339.906625), -- Theca Leather Armor Pattern
(21017, 401, 1, 1, 1, 16.277625), -- Drake Leather Armor
(21017, 1987, 1, 1, 1, 1665.3735), -- Drake Leather Armor Texture
(21017, 420, 1, 1, 1, 55.0305), -- Theca Leather Gaiters
(21017, 1985, 1, 1, 1, 3764.0295), -- Theca Leather Gaiters Pattern
(21017, 1866, 1, 1, 2, 36389.065012), -- Suede
(21017, 1871, 1, 1, 2, 54583.597518), -- Charcoal
(21017, 5220, 1, 1, 2, 2183.331873), -- Metal Hardener
(21017, 1885, 1, 1, 2, 4548.583011), -- High-Grade Suede
(21017, 4041, 1, 1, 2, 474.593785), -- Mold Hardener
(21017, 4940, 1, 1, 2, 262.404758), -- Recipe: Zubei's Breastplate (60%)
(21017, 5280, 1, 1, 2, 109.151559), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21017, 4189, 1, 1, 2, 62.844837), -- Recipe: Arthro Nail (100%)
(21017, 8726, 1, 1, 2, 1263.511986), -- Life Stone - Level 55
(21017, 8736, 1, 1, 2, 315.827881), -- Mid-Grade Life Stone - Level 55
(21017, 8746, 1, 1, 2, 31.572765), -- High-Grade Life Stone - Level 55
(21017, 8756, 1, 1, 2, 6.515015), -- Top-Grade Life Stone - Level 55
-- Ancient Gargoyle
(21018, 4947, 1, 1, -1, 22992), -- Recipe: Zubei's Leather Gaiters (60%)
(21018, 2961, 1, 1, -1, 121815), -- Full Plate Boots Part
(21018, 4049, 1, 1, -1, 117342), -- Adamantite Earring Gemstone
(21018, 57, 883, 1802, 0, 700000), -- Adena
(21018, 11918, 1, 1, 1, 94.522944), -- Common Item - Heavy War Axe
(21018, 4105, 1, 1, 1, 945.231504), -- Heavy War Axe Head
(21018, 11908, 1, 1, 1, 94.522944), -- Common Item - Sprite's Staff
(21018, 4106, 1, 1, 1, 929.722608), -- Sprite's Staff Head
(21018, 1872, 1, 1, 2, 73423.762488), -- Animal Bone
(21018, 1867, 1, 1, 2, 73423.762488), -- Animal Skin
(21018, 1881, 1, 1, 2, 7342.424568), -- Coarse Bone Powder
(21018, 1875, 1, 1, 2, 3671.131752), -- Stone of Purity
(21018, 4041, 1, 1, 2, 478.843272), -- Mold Hardener
(21018, 4950, 1, 1, 2, 565.978896), -- Recipe: Stockings of Zubei (60%)
(21018, 4999, 1, 1, 2, 684.844128), -- Recipe: Sealed Doom Boots (60%)
(21018, 8309, 1, 1, 2, 63.459216), -- Recipe: Spell Breaker (100%)
(21018, 8727, 1, 1, 2, 1101.355632), -- Life Stone - Level 58
(21018, 8737, 1, 1, 2, 275.41944), -- Mid-Grade Life Stone - Level 58
(21018, 8747, 1, 1, 2, 27.541944), -- High-Grade Life Stone - Level 58
(21018, 8757, 1, 1, 2, 5.476176), -- Top-Grade Life Stone - Level 58
-- Fallen Orc Archer
(21019, 2964, 1, 1, -1, 134399), -- Divine Gloves Pattern
(21019, 4950, 1, 1, -1, 25367), -- Recipe: Stockings of Zubei (60%)
(21019, 4129, 1, 1, -1, 26713), -- Recipe: Earrings of Black Ore (100%)
(21019, 57, 973, 1988, 0, 700000), -- Adena
(21019, 11903, 1, 1, 1, 208.636155), -- Common Item - Arthro Nail
(21019, 4111, 1, 1, 1, 2086.363845), -- Arthro Nail Blade
(21019, 1870, 1, 1, 2, 60756.881586), -- Coal
(21019, 1865, 1, 1, 2, 60756.881586), -- Varnish
(21019, 1874, 1, 1, 2, 4050.520392), -- Oriharukon Ore
(21019, 4043, 1, 1, 2, 2025.260196), -- Asofe
(21019, 4039, 1, 1, 2, 2025.260196), -- Mold Glue
(21019, 4964, 1, 1, 2, 69.98226), -- Recipe: Heavy War Axe (60%)
(21019, 4176, 1, 1, 2, 755.676366), -- Recipe: Sealed Doom Boots (100%)
(21019, 5003, 1, 1, 2, 46.346742), -- Recipe: Art of Battle Axe (60%)
(21019, 8727, 1, 1, 2, 1215.182526), -- Life Stone - Level 58
(21019, 8737, 1, 1, 2, 303.828642), -- Mid-Grade Life Stone - Level 58
(21019, 8747, 1, 1, 2, 30.36966), -- High-Grade Life Stone - Level 58
(21019, 8757, 1, 1, 2, 5.809848), -- Top-Grade Life Stone - Level 58
-- Fallen Orc Shaman
(21020, 4952, 1, 1, -1, 35974), -- Recipe: Avadon Circlet (60%)
(21020, 1987, 1, 1, -1, 42700), -- Drake Leather Armor Texture
(21020, 4050, 1, 1, -1, 173407), -- Adamantite Ring Wire
(21020, 57, 1105, 2252, 0, 700000), -- Adena
(21020, 78, 1, 1, 1, 4.124809), -- Great Sword
(21020, 4104, 1, 1, 1, 788.351473), -- Great Sword Blade
(21020, 142, 1, 1, 1, 4.124809), -- Keshanberk
(21020, 4107, 1, 1, 1, 776.13705), -- Keshanberk Blade
(21020, 148, 1, 1, 1, 4.124809), -- Sword of Valhalla
(21020, 4108, 1, 1, 1, 776.13705), -- Sword of Valhalla Blade
(21020, 4167, 1, 1, 2, 5141.29545), -- Recipe: Sealed Blue Wolf Boots (100%)
(21020, 1832, 1, 1, 2, 459293.70455), -- Greater Antidote
-- Sharp Talon Tiger
(21021, 4040, 1, 1, -1, 51678), -- Mold Lubricant
(21021, 4613, 1, 1, -1, 3564), -- Greater Dye of STR (Str+4 Con-4)
(21021, 947, 1, 1, -1, 1034), -- Scroll: Enchant Weapon (B-Grade)
(21021, 57, 1020, 2079, 0, 700000), -- Adena
(21021, 11896, 1, 1, 1, 218.380305), -- Common Item - Dark Elven Long Bow
(21021, 4112, 1, 1, 1, 2160.619695), -- Dark Elven Longbow Shaft
(21021, 1869, 1, 1, 2, 63603.8396), -- Iron Ore
(21021, 1870, 1, 1, 2, 63603.8396), -- Coal
(21021, 1871, 1, 1, 2, 63603.8396), -- Charcoal
(21021, 1872, 1, 1, 2, 84804.99825), -- Animal Bone
(21021, 1867, 1, 1, 2, 84804.99825), -- Animal Skin
(21021, 4130, 1, 1, 2, 1032.40235), -- Recipe: Ring of Black Ore (100%)
(21021, 4998, 1, 1, 2, 790.93875), -- Recipe: Sealed Blue Wolf Gloves (60%)
(21021, 5001, 1, 1, 2, 48.7291), -- Recipe: Lance (60%)
(21021, 8728, 1, 1, 2, 1060.03975), -- Life Stone - Level 61
(21021, 8738, 1, 1, 2, 265.10085), -- Mid-Grade Life Stone - Level 61
(21021, 8748, 1, 1, 2, 26.54645), -- High-Grade Life Stone - Level 61
(21021, 8758, 1, 1, 2, 4.72745), -- Top-Grade Life Stone - Level 61
-- Fallen Orc Captain
(21022, 4049, 1, 1, -1, 138069), -- Adamantite Earring Gemstone
(21022, 947, 1, 1, -1, 1053), -- Scroll: Enchant Weapon (B-Grade)
(21022, 4613, 1, 1, -1, 3631), -- Greater Dye of STR (Str+4 Con-4)
(21022, 57, 1041, 2116, 0, 700000), -- Adena
(21022, 12175, 1, 1, 1, 414.009032), -- Common Item - Tunic of Zubei
(21022, 4069, 1, 1, 1, 3055.156032), -- Tunic of Zubei Fabric
(21022, 12166, 1, 1, 1, 254.084596), -- Common Item - Avadon Robe
(21022, 4071, 1, 1, 1, 2347.12394), -- Avadon Robe Fabric
(21022, 12176, 1, 1, 1, 662.839764), -- Common Item - Stockings of Zubei
(21022, 4070, 1, 1, 1, 4638.786636), -- Stockings of Zubei Fabric
(21022, 1869, 1, 1, 2, 64794.760936), -- Iron Ore
(21022, 1870, 1, 1, 2, 64794.760936), -- Coal
(21022, 1871, 1, 1, 2, 64794.760936), -- Charcoal
(21022, 1872, 1, 1, 2, 86392.891095), -- Animal Bone
(21022, 1867, 1, 1, 2, 86392.891095), -- Animal Skin
(21022, 4130, 1, 1, 2, 1051.733101), -- Recipe: Ring of Black Ore (100%)
(21022, 4998, 1, 1, 2, 805.748325), -- Recipe: Sealed Blue Wolf Gloves (60%)
(21022, 5001, 1, 1, 2, 49.641506), -- Recipe: Lance (60%)
(21022, 8728, 1, 1, 2, 1079.887985), -- Life Stone - Level 61
(21022, 8738, 1, 1, 2, 270.064611), -- Mid-Grade Life Stone - Level 61
(21022, 8748, 1, 1, 2, 27.043507), -- High-Grade Life Stone - Level 61
(21022, 8758, 1, 1, 2, 4.815967), -- Top-Grade Life Stone - Level 61
-- Sobbing Wind
(21023, 2019, 1, 1, -1, 9507), -- Trident Edge
(21023, 2263, 1, 1, -1, 6865), -- Recipe: Dwarven Trident
(21023, 1866, 1, 1, -1, 294716), -- Suede
(21023, 57, 192, 367, 0, 700000), -- Adena
(21023, 156, 1, 1, 1, 52.666614), -- Hand Axe
(21023, 167, 1, 1, 1, 52.666614), -- Scalpel
(21023, 178, 1, 1, 1, 52.666772), -- Bone Staff
(21023, 1864, 1, 1, 2, 82701.808816), -- Stem
(21023, 1865, 1, 1, 2, 41350.778656), -- Varnish
(21023, 1866, 1, 1, 2, 27567.35344), -- Suede
(21023, 1873, 1, 1, 2, 16540.412064), -- Silver Nugget
(21023, 1868, 1, 1, 2, 82701.808816), -- Thread
(21023, 2260, 1, 1, 2, 641.838208), -- Recipe: Mace of Judgment
-- Babbling Wind
(21024, 2178, 1, 1, -1, 73852), -- Recipe: Dark Stockings
(21024, 1934, 1, 1, -1, 60336), -- Crafted Leather Gloves Lining
(21024, 1899, 1, 1, -1, 72121), -- Necklace of Devotion Chain
(21024, 57, 199, 384, 0, 700000), -- Adena
(21024, 220, 1, 1, 1, 164), -- Crafted Dagger
(21024, 1864, 1, 1, 2, 103619.211899), -- Stem
(21024, 1869, 1, 1, 2, 51809.711915), -- Iron Ore
(21024, 1878, 1, 1, 2, 20723.884766), -- Braided Hemp
(21024, 1884, 1, 1, 2, 31882.89964), -- Cord
(21024, 2180, 1, 1, 2, 3895.29178), -- Recipe: Scale Mail
-- Giggling Wind
(21025, 1871, 1, 1, -1, 485180), -- Charcoal
(21025, 1868, 1, 3, -1, 485180), -- Thread
(21025, 2152, 1, 1, -1, 85419), -- Recipe: Enchanted Necklace
(21025, 57, 208, 407, 0, 700000), -- Adena
(21025, 291, 1, 1, 1, 86.432478), -- Trident
(21025, 2019, 1, 1, 1, 2927.567522), -- Trident Edge
(21025, 1864, 1, 1, 2, 90765.871725), -- Stem
(21025, 1865, 1, 1, 2, 45382.796495), -- Varnish
(21025, 1866, 1, 1, 2, 30255.290575), -- Suede
(21025, 1873, 1, 1, 2, 18153.174345), -- Silver Nugget
(21025, 1868, 1, 1, 2, 90765.871725), -- Thread
(21025, 2180, 1, 1, 2, 3411.995135), -- Recipe: Scale Mail
-- Singing Wind
(21026, 1834, 1, 1, -1, 575495), -- Emergency Dressing
(21026, 2025, 1, 1, -1, 7174), -- Dwarven Trident Edge
(21026, 1900, 1, 1, -1, 56668), -- Enchanted Necklace Chain
(21026, 57, 220, 435, 0, 700000), -- Adena
(21026, 275, 1, 1, 1, 38.0773), -- Long Bow
(21026, 276, 1, 1, 1, 38.0773), -- Elven Bow
(21026, 2024, 1, 1, 1, 1343.8454), -- Elven Bow Shaft
(21026, 1872, 1, 1, 2, 53911.649475), -- Animal Bone
(21026, 1867, 1, 1, 2, 53911.649475), -- Animal Skin
(21026, 1881, 1, 1, 2, 5391.10212), -- Coarse Bone Powder
(21026, 1875, 1, 1, 2, 2695.55106), -- Stone of Purity
(21026, 737, 1, 1, 2, 4043.32659), -- Scroll of Resurrection
(21026, 2274, 1, 1, 2, 288.75519), -- Recipe: Skull Breaker
(21026, 2191, 1, 1, 2, 5412.96609), -- Recipe: RIP Gauntlets
-- Ogre
(21034, 2302, 1, 1, -1, 3085), -- Recipe: Silver Axe
(21034, 1956, 1, 1, -1, 80198), -- Square Shield Fragment
(21034, 2154, 1, 1, -1, 75647), -- Recipe: Elven Earring
(21034, 57, 299, 596, 0, 700000), -- Adena
(21034, 88, 1, 1, 1, 6.8006), -- Morning Star
(21034, 2031, 1, 1, 1, 369.64295), -- Morning Star Head
(21034, 90, 1, 1, 1, 6.8006), -- Goat Head Staff
(21034, 2032, 1, 1, 1, 337.43075), -- Goat Head Staff Head
(21034, 158, 1, 1, 1, 6.8006), -- Tarbar
(21034, 2035, 1, 1, 1, 369.64295), -- Tarbar Head
(21034, 169, 1, 1, 1, 6.8006), -- Skull Breaker
(21034, 2036, 1, 1, 1, 369.64295), -- Skull Breaker Head
(21034, 172, 1, 1, 1, 6.8006), -- Heavy Bone Club
(21034, 2037, 1, 1, 1, 369.6374), -- Heavy Bone Club Head
(21034, 1874, 1, 1, 2, 3043.573712), -- Oriharukon Ore
(21034, 1878, 1, 1, 2, 18261.23224), -- Braided Hemp
(21034, 1884, 1, 1, 2, 28094.090352), -- Cord
(21034, 1889, 1, 1, 2, 3043.573712), -- Compound Braid
(21034, 5220, 1, 1, 2, 1826.018208), -- Metal Hardener
(21034, 2190, 1, 1, 2, 3260.956832), -- Recipe: Mithril Stockings
(21034, 2279, 1, 1, 2, 326.179696), -- Recipe: War Pick
(21034, 1341, 10, 30, 2, 152176.375248), -- Bone Arrow
-- Catherok
(21035, 1952, 1, 1, -1, 72876), -- Salamander Skin Mail Texture
(21035, 1873, 1, 1, -1, 910076), -- Silver Nugget
(21035, 1905, 1, 1, -1, 221322), -- Omen Beast's Eye Earring Gemstone
(21035, 57, 916, 1852, 0, 700000), -- Adena
(21035, 396, 1, 1, 1, 311.644923), -- Salamander Skin Mail
(21035, 1952, 1, 1, 1, 18297.355077), -- Salamander Skin Mail Texture
(21035, 1865, 1, 1, 2, 126944.108529), -- Varnish
(21035, 1870, 1, 1, 2, 126944.108529), -- Coal
(21035, 1879, 1, 1, 2, 21157.526526), -- Cokes
(21035, 1875, 1, 1, 2, 8462.800485), -- Stone of Purity
(21035, 2308, 1, 1, 2, 554.380847), -- Recipe: Cursed Dagger
(21035, 2205, 1, 1, 2, 4017.247439), -- Recipe: Chain Gaiters
(21035, 2989, 1, 1, 2, 6716.658411), -- Recipe: Chain Hood
(21035, 2997, 1, 1, 2, 10074.812512), -- Recipe: Karmian Gloves
(21035, 6668, 1, 1, 2, 45337.356722), -- Deluxe Chest Key - Grade 4
-- Shindebarn
(21036, 2070, 1, 1, -1, 21261), -- Cursed Dagger Blade
(21036, 2316, 1, 1, -1, 9330), -- Recipe: Katana
(21036, 1895, 1, 1, -1, 765042), -- Metallic Fiber
(21036, 57, 1054, 2160, 0, 700000), -- Adena
(21036, 354, 1, 1, 1, 162.83088), -- Chain Mail Shirt
(21036, 1959, 1, 1, 1, 8521.60536), -- Chain Mail Shirt Material
(21036, 381, 1, 1, 1, 260.48736), -- Chain Gaiters
(21036, 1960, 1, 1, 1, 17335.0764), -- Chain Gaiters Part
(21036, 1895, 1, 1, 2, 60262.116192), -- Metallic Fiber
(21036, 2318, 1, 1, 2, 734.903856), -- Recipe: Spirit Sword
(21036, 8723, 1, 1, 2, 8436.676164), -- Life Stone - Level 46
(21036, 8733, 1, 1, 2, 2109.151092), -- Mid-Grade Life Stone - Level 46
(21036, 8743, 1, 1, 2, 210.936648), -- High-Grade Life Stone - Level 46
(21036, 8753, 1, 1, 2, 42.216048), -- Top-Grade Life Stone - Level 46
-- Ossiud
(21037, 5231, 1, 1, -1, 247709), -- Recipe: Metal Hardener (100%)
(21037, 4040, 1, 1, -1, 69359), -- Mold Lubricant
(21037, 2166, 1, 1, -1, 117557), -- Recipe: Earrings of Binding (100%)
(21037, 57, 1369, 2792, 0, 700000), -- Adena
(21037, 1126, 1, 1, 1, 206.69324), -- Crimson Boots
(21037, 1974, 1, 1, 1, 10768.531033), -- Crimson Boot Fabric
(21037, 2434, 1, 1, 1, 206.69324), -- Rind Leather Boots
(21037, 2948, 1, 1, 1, 10768.531033), -- Rind Leather Boots Lining
(21037, 2455, 1, 1, 1, 223.813915), -- Plated Leather Gloves
(21037, 2946, 1, 1, 1, 7156.940206), -- Plate Leather Gloves Design
(21037, 2456, 1, 1, 1, 206.69324), -- Dwarven Chain Gloves
(21037, 2949, 1, 1, 1, 10768.531033), -- Dwarven Chain Gloves Design
(21037, 2457, 1, 1, 1, 206.69324), -- Gloves of Seal
(21037, 2950, 1, 1, 1, 10768.531033), -- Gloves of Seal Pattern
(21037, 2458, 1, 1, 1, 206.69324), -- Rind Leather Gloves
(21037, 2951, 1, 1, 1, 10768.655547), -- Rind Leather Gloves Design
(21037, 1895, 1, 1, 2, 36584.521984), -- Metallic Fiber
(21037, 4040, 1, 1, 2, 2560.929664), -- Mold Lubricant
(21037, 4042, 1, 1, 2, 2134.089824), -- Enria
(21037, 4043, 1, 1, 2, 4268.179648), -- Asofe
(21037, 2329, 1, 1, 2, 297.77616), -- Recipe: Tsurugi
(21037, 2225, 1, 1, 2, 2783.6192), -- Recipe: Demon's Stockings
(21037, 2345, 1, 1, 2, 297.77616), -- Recipe: Dark Screamer
(21037, 2344, 1, 1, 2, 297.77616), -- Recipe: Grace Dagger
(21037, 8724, 1, 1, 2, 4268.179648), -- Life Stone - Level 49
(21037, 8734, 1, 1, 2, 1067.072256), -- Mid-Grade Life Stone - Level 49
(21037, 8744, 1, 1, 2, 106.696288), -- High-Grade Life Stone - Level 49
(21037, 8754, 1, 1, 2, 21.383008), -- Top-Grade Life Stone - Level 49
-- Liangma
(21038, 5231, 1, 1, -1, 187644), -- Recipe: Metal Hardener (100%)
(21038, 1911, 1, 1, -1, 195390), -- Earring of Protection Gemstone
(21038, 2166, 1, 1, -1, 89051), -- Recipe: Earrings of Binding (100%)
(21038, 57, 1037, 2115, 0, 700000), -- Adena
(21038, 2496, 1, 1, 1, 323.055837), -- Dwarven Chain Shield
(21038, 2947, 1, 1, 1, 13856.305437), -- Dwarven Chain Shield Fragment
(21038, 632, 1, 1, 1, 298.228047), -- Knight's Shield
(21038, 1972, 1, 1, 1, 15519.05199), -- Knight's Shield Fragment
(21038, 500, 1, 1, 1, 208.805922), -- Great Helmet
(21038, 1971, 1, 1, 1, 11875.552767), -- Great Helmet Material
(21038, 1872, 1, 1, 2, 141087.342613), -- Animal Bone
(21038, 1867, 1, 1, 2, 141087.342613), -- Animal Skin
(21038, 1881, 1, 1, 2, 14108.640775), -- Coarse Bone Powder
(21038, 1875, 1, 1, 2, 7054.476198), -- Stone of Purity
(21038, 4041, 1, 1, 2, 920.216813), -- Mold Hardener
(21038, 2224, 1, 1, 2, 1437.819294), -- Recipe: Demon's Tunic
(21038, 952, 1, 1, 2, 1411.019888), -- Scroll: Enchant Armor (C-Grade)
(21038, 8724, 1, 1, 2, 3527.238099), -- Life Stone - Level 49
(21038, 8734, 1, 1, 2, 881.88743), -- Mid-Grade Life Stone - Level 49
(21038, 8744, 1, 1, 2, 88.188743), -- High-Grade Life Stone - Level 49
(21038, 8754, 1, 1, 2, 16.827534), -- Top-Grade Life Stone - Level 49
-- Snipe Cohort
(21039, 1805, 1, 1, -1, 8706), -- Recipe: Soulshot (C-Grade)
(21039, 1905, 1, 1, -1, 254068), -- Omen Beast's Eye Earring Gemstone
(21039, 1871, 1, 5, -1, 870607), -- Charcoal
(21039, 57, 1033, 2097, 0, 700000), -- Adena
(21039, 70, 1, 1, 1, 47.27586), -- Claymore
(21039, 2047, 1, 1, 1, 2882.22114), -- Claymore Blade
(21039, 2499, 1, 1, 1, 47.27586), -- Elven Long Sword
(21039, 2967, 1, 1, 1, 2843.22714), -- Elven Long Sword Blade
(21039, 1871, 1, 1, 2, 218589.145338), -- Charcoal
(21039, 1866, 1, 1, 2, 145726.225326), -- Suede
(21039, 1877, 1, 1, 2, 8743.658286), -- Adamantite Nugget
(21039, 2162, 1, 1, 2, 10559.971914), -- Recipe: Aquastone Necklace
(21039, 5159, 1, 1, 2, 728.606082), -- Recipe: Spiritshot (C) Compressed Package (100%)
(21039, 2312, 1, 1, 2, 954.393054), -- Recipe: Crystallized Ice Bow
-- Soldier of Darkness
(21040, 1875, 1, 1, -1, 277649), -- Stone of Purity
(21040, 1911, 1, 1, -1, 309761), -- Earring of Protection Gemstone
(21040, 1967, 1, 1, -1, 227147), -- Plated Leather Gaiters Material
(21040, 57, 1644, 3353, 0, 700000), -- Adena
(21040, 195, 1, 1, 1, 41.757248), -- Cursed Staff
(21040, 2082, 1, 1, 1, 3251.674816), -- Cursed Staff Head
(21040, 2502, 1, 1, 1, 41.757248), -- Dwarven War Hammer
(21040, 2968, 1, 1, 1, 3112.810688), -- Dwarven War Hammer Head
(21040, 1872, 1, 1, 2, 223672.659084), -- Animal Bone
(21040, 1867, 1, 1, 2, 223672.659084), -- Animal Skin
(21040, 1881, 1, 1, 2, 22367.1177), -- Coarse Bone Powder
(21040, 1875, 1, 1, 2, 11183.805864), -- Stone of Purity
(21040, 4041, 1, 1, 2, 1458.864684), -- Mold Hardener
(21040, 2224, 1, 1, 2, 2279.445192), -- Recipe: Demon's Tunic
(21040, 952, 1, 1, 2, 2236.958784), -- Scroll: Enchant Armor (C-Grade)
(21040, 8724, 1, 1, 2, 5591.902932), -- Life Stone - Level 49
(21040, 8734, 1, 1, 2, 1398.09924), -- Mid-Grade Life Stone - Level 49
(21040, 8744, 1, 1, 2, 139.809924), -- High-Grade Life Stone - Level 49
(21040, 8754, 1, 1, 2, 26.677512), -- Top-Grade Life Stone - Level 49
-- Beast Lord
(21058, 4617, 1, 1, -1, 8254), -- Greater Dye of DEX (Dex+4 Str-4)
(21058, 4049, 1, 1, -1, 313879), -- Adamantite Earring Gemstone
(21058, 4129, 1, 1, -1, 64763), -- Recipe: Earrings of Black Ore (100%)
(21058, 57, 2367, 4811, 0, 700000), -- Adena
(21058, 78, 1, 1, 1, 8.819343), -- Great Sword
(21058, 4104, 1, 1, 1, 1685.591271), -- Great Sword Blade
(21058, 142, 1, 1, 1, 8.819343), -- Keshanberk
(21058, 4107, 1, 1, 1, 1659.47535), -- Keshanberk Blade
(21058, 148, 1, 1, 1, 8.819343), -- Sword of Valhalla
(21058, 4108, 1, 1, 1, 1659.47535), -- Sword of Valhalla Blade
(21058, 1895, 1, 1, 2, 45911.986758), -- Metallic Fiber
(21058, 4040, 1, 1, 2, 3213.826956), -- Mold Lubricant
(21058, 4042, 1, 1, 2, 2678.18913), -- Enria
(21058, 4043, 1, 1, 2, 5356.37826), -- Asofe
(21058, 4195, 1, 1, 2, 122.637402), -- Recipe: Art of Battle Axe (100%)
(21058, 4999, 1, 1, 2, 1998.67716), -- Recipe: Sealed Doom Boots (60%)
(21058, 4163, 1, 1, 2, 1064.196738), -- Recipe: Blue Wolf Stockings (100%)
(21058, 8728, 1, 1, 2, 2678.18913), -- Life Stone - Level 61
(21058, 8738, 1, 1, 2, 669.563226), -- Mid-Grade Life Stone - Level 61
(21058, 8748, 1, 1, 2, 66.9627), -- High-Grade Life Stone - Level 61
(21058, 8758, 1, 1, 2, 13.39254), -- Top-Grade Life Stone - Level 61
-- Beast Guardian
(21059, 4129, 1, 1, -1, 55362), -- Recipe: Earrings of Black Ore (100%)
(21059, 4049, 1, 1, -1, 268315), -- Adamantite Earring Gemstone
(21059, 4130, 1, 1, -1, 83043), -- Recipe: Ring of Black Ore (100%)
(21059, 57, 2020, 4116, 0, 700000), -- Adena
(21059, 284, 1, 1, 1, 22.618), -- Dark Elven Long Bow
(21059, 4112, 1, 1, 1, 4277.382), -- Dark Elven Longbow Shaft
(21059, 1864, 1, 3, 2, 125918.281528), -- Stem
(21059, 1869, 1, 1, 2, 125918.281528), -- Iron Ore
(21059, 1878, 1, 1, 2, 50367.157308), -- Braided Hemp
(21059, 1884, 1, 1, 2, 77488.143382), -- Cord
(21059, 4039, 1, 1, 2, 4197.457238), -- Mold Glue
(21059, 4154, 1, 1, 2, 1490.134204), -- Recipe: Doom Shield (100%)
(21059, 4198, 1, 1, 2, 96.287984), -- Recipe: Bellion Cestus (100%)
(21059, 4194, 1, 1, 2, 96.287984), -- Recipe: Deadman's Glory (100%)
(21059, 8728, 1, 1, 2, 2098.53449), -- Life Stone - Level 61
(21059, 8738, 1, 1, 2, 524.536558), -- Mid-Grade Life Stone - Level 61
(21059, 8748, 1, 1, 2, 52.41483), -- High-Grade Life Stone - Level 61
(21059, 8758, 1, 1, 2, 10.482966), -- Top-Grade Life Stone - Level 61
-- Beast Seer
(21060, 4050, 1, 1, -1, 316941), -- Adamantite Ring Wire
(21060, 947, 1, 1, -1, 2046), -- Scroll: Enchant Weapon (B-Grade)
(21060, 1865, 1, 11, -1, 852572), -- Varnish
(21060, 57, 2020, 4116, 0, 700000), -- Adena
(21060, 229, 1, 1, 1, 11.309397), -- Kris
(21060, 4109, 1, 1, 1, 2128.190603), -- Kris Edge
(21060, 243, 1, 1, 1, 11.309397), -- Hell Knife
(21060, 4110, 1, 1, 1, 2128.190603), -- Hell Knife Edge
(21060, 1865, 1, 1, 2, 137365.603308), -- Varnish
(21060, 1870, 1, 1, 2, 137365.603308), -- Coal
(21060, 1879, 1, 1, 2, 22894.267218), -- Cokes
(21060, 1875, 1, 1, 2, 9157.624686), -- Stone of Purity
(21060, 4040, 1, 1, 2, 2747.164104), -- Mold Lubricant
(21060, 4155, 1, 1, 2, 426.624228), -- Recipe: Blue Wolf Breastplate (100%)
(21060, 8728, 1, 1, 2, 2289.30342), -- Life Stone - Level 61
(21060, 8738, 1, 1, 2, 572.531358), -- Mid-Grade Life Stone - Level 61
(21060, 8748, 1, 1, 2, 57.129834), -- High-Grade Life Stone - Level 61
(21060, 8758, 1, 1, 2, 11.508168), -- Top-Grade Life Stone - Level 61
(21060, 1343, 20, 60, 2, 98118.640368), -- Silver Arrow
-- Hallate's Guardian
(21061, 5478, 1, 1, -1, 85417), -- Sealed Dark Crystal Leather Armor Pattern
(21061, 1895, 1, 7, -1, 725557), -- Metallic Fiber
(21061, 57, 4020, 8164, 0, 700000), -- Adena
(21061, 5287, 1, 1, 1, 28.07788), -- Sealed Dark Crystal breastplate
(21061, 5520, 1, 1, 1, 3224.93756), -- Sealed Dark Crystal Breastplate Pattern
(21061, 5293, 1, 1, 1, 17.28436), -- Sealed Tallum Plate Armor
(21061, 5521, 1, 1, 1, 2275.64432), -- Sealed Tallum Plate Armor Pattern
(21061, 5288, 1, 1, 1, 44.93092), -- Sealed Dark Crystal Gaiters
(21061, 5524, 1, 1, 1, 4929.12496), -- Sealed Dark Crystal Gaiters Pattern
(21061, 1873, 1, 1, 2, 100015.319741), -- Silver Nugget
(21061, 1868, 1, 3, 2, 250038.539286), -- Thread
(21061, 1876, 1, 1, 2, 50007.899804), -- Mithril Ore
(21061, 1895, 1, 1, 2, 71439.719758), -- Metallic Fiber
(21061, 4042, 1, 1, 2, 4167.165028), -- Enria
(21061, 5000, 1, 1, 2, 190.987066), -- Recipe: Sword of Damascus (60%)
(21061, 730, 1, 1, 2, 208.262278), -- Scroll: Enchant Armor (A-Grade)
(21061, 5422, 1, 1, 2, 242.812702), -- Recipe: Sealed Majestic Plate Armor(60%)
(21061, 8730, 1, 1, 2, 2778.42993), -- Life Stone - Level 67
(21061, 8740, 1, 1, 2, 694.367549), -- Mid-Grade Life Stone - Level 67
(21061, 8750, 1, 1, 2, 69.580715), -- High-Grade Life Stone - Level 67
(21061, 8760, 1, 1, 2, 13.916143), -- Top-Grade Life Stone - Level 67
-- Messenger Angel
(21063, 5220, 1, 1, -1, 875838), -- Metal Hardener
(21063, 5478, 1, 1, -1, 184123), -- Sealed Dark Crystal Leather Armor Pattern
(21063, 1807, 1, 1, -1, 29195), -- Recipe: Soulshot (A-Grade)
(21063, 57, 8659, 17618, 0, 700000), -- Adena
(21063, 5287, 1, 1, 1, 60.524913), -- Sealed Dark Crystal breastplate
(21063, 5520, 1, 1, 1, 6951.702381), -- Sealed Dark Crystal Breastplate Pattern
(21063, 5293, 1, 1, 1, 37.258311), -- Sealed Tallum Plate Armor
(21063, 5521, 1, 1, 1, 4905.397932), -- Sealed Tallum Plate Armor Pattern
(21063, 5288, 1, 1, 1, 96.853467), -- Sealed Dark Crystal Gaiters
(21063, 5524, 1, 1, 1, 10625.262996), -- Sealed Dark Crystal Gaiters Pattern
(21063, 1864, 4, 12, 2, 134744.464995), -- Stem
(21063, 1865, 2, 6, 2, 107795.649885), -- Varnish
(21063, 1866, 3, 9, 2, 59886.51543), -- Suede
(21063, 1873, 4, 12, 2, 26948.81511), -- Silver Nugget
(21063, 1868, 10, 30, 2, 51331.18767), -- Thread
(21063, 5281, 1, 1, 2, 718.526025), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21063, 729, 1, 1, 2, 59.97453), -- Scroll: Enchant Weapon (A-Grade)
(21063, 8314, 1, 1, 2, 294.42042), -- Recipe: Spiritual Eye (60%)
(21063, 8730, 1, 1, 2, 5988.495765), -- Life Stone - Level 67
(21063, 8740, 1, 1, 2, 1497.02658), -- Mid-Grade Life Stone - Level 67
(21063, 8750, 1, 1, 2, 149.54688), -- High-Grade Life Stone - Level 67
(21063, 8760, 1, 1, 2, 30.37671), -- Top-Grade Life Stone - Level 67
-- Platinum Guardian Archer
(21064, 4119, 1, 1, -1, 39452), -- Demon's Dagger Edge
(21064, 5230, 1, 1, -1, 12018), -- Recipe: Mithril Arrow (100%)
(21064, 5479, 1, 1, -1, 53333), -- Sealed Tallum Leather Armor Pattern
(21064, 57, 4448, 9066, 0, 700000), -- Adena
(21064, 5287, 1, 1, 1, 31.144561), -- Sealed Dark Crystal breastplate
(21064, 5520, 1, 1, 1, 3577.166957), -- Sealed Dark Crystal Breastplate Pattern
(21064, 5293, 1, 1, 1, 19.172167), -- Sealed Tallum Plate Armor
(21064, 5521, 1, 1, 1, 2524.191404), -- Sealed Tallum Plate Armor Pattern
(21064, 5288, 1, 1, 1, 49.838299), -- Sealed Dark Crystal Gaiters
(21064, 5524, 1, 1, 1, 5467.486612), -- Sealed Dark Crystal Gaiters Pattern
(21064, 1872, 1, 3, 2, 184888.594158), -- Animal Bone
(21064, 1867, 1, 3, 2, 123259.370568), -- Animal Skin
(21064, 1881, 1, 1, 2, 36977.534154), -- Coarse Bone Powder
(21064, 1875, 1, 1, 2, 18488.997924), -- Stone of Purity
(21064, 4041, 1, 1, 2, 2411.427762), -- Mold Hardener
(21064, 4130, 1, 1, 2, 4501.978194), -- Recipe: Ring of Black Ore (100%)
(21064, 4403, 1, 1, 2, 554.494494), -- Red Dimensional Stone
(21064, 8730, 1, 1, 2, 3081.345756), -- Life Stone - Level 67
(21064, 8740, 1, 1, 2, 770.567286), -- Mid-Grade Life Stone - Level 67
(21064, 8750, 1, 1, 2, 77.102898), -- High-Grade Life Stone - Level 67
(21064, 8760, 1, 1, 2, 15.235902), -- Top-Grade Life Stone - Level 67
(21064, 1344, 40, 120, 2, 86667.350904), -- Mithril Arrow
-- Platinum Guardian Warrior
(21065, 4120, 1, 1, -1, 44373), -- Bellion Cestus Edge
(21065, 1807, 1, 1, -1, 13539), -- Recipe: Soulshot (A-Grade)
(21065, 57, 5007, 10224, 0, 700000), -- Adena
(21065, 5291, 1, 1, 1, 105.318486), -- Sealed Dark Crystal Boots
(21065, 5496, 1, 1, 1, 10990.181514), -- Sealed Dark Crystal Boots Lining
(21065, 5296, 1, 1, 1, 105.318486), -- Sealed Tallum Boots
(21065, 5497, 1, 1, 1, 10990.181514), -- Sealed Tallum Boots Lining
(21065, 5290, 1, 1, 1, 105.318486), -- Sealed Dark Crystal Gloves
(21065, 5508, 1, 1, 1, 10990.181514), -- Sealed Dark Crystal Gloves Design
(21065, 5295, 1, 1, 1, 105.318486), -- Sealed Tallum Gloves
(21065, 5509, 1, 1, 1, 10990.181514), -- Sealed Tallum Gloves Design
(21065, 1872, 1, 3, 2, 227233.97532), -- Animal Bone
(21065, 1867, 1, 3, 2, 151489.31688), -- Animal Skin
(21065, 1881, 1, 1, 2, 45446.795064), -- Coarse Bone Powder
(21065, 1875, 1, 1, 2, 22723.397532), -- Stone of Purity
(21065, 4041, 1, 1, 2, 2963.702544), -- Mold Hardener
(21065, 4164, 1, 1, 2, 2257.100208), -- Recipe: Stockings of Doom (100%)
(21065, 4401, 1, 1, 2, 681.88956), -- Green Dimensional Stone
(21065, 8730, 1, 1, 2, 3787.0041), -- Life Stone - Level 67
(21065, 8740, 1, 1, 2, 946.865436), -- Mid-Grade Life Stone - Level 67
(21065, 8750, 1, 1, 2, 94.732308), -- High-Grade Life Stone - Level 67
(21065, 8760, 1, 1, 2, 19.221048), -- Top-Grade Life Stone - Level 67
-- Platinum Guardian Shaman
(21066, 5230, 1, 1, -1, 13627), -- Recipe: Mithril Arrow (100%)
(21066, 4081, 1, 1, -1, 100730), -- Doom Plate Armor Temper
(21066, 5482, 1, 1, -1, 134892), -- Sealed Dark Crystal Leggings Design
(21066, 57, 5047, 10276, 0, 700000), -- Adena
(21066, 5292, 1, 1, 1, 134.52984), -- Sealed Dark Crystal Shield
(21066, 5494, 1, 1, 1, 13207.500015), -- Sealed Dark Crystal Shield Fragment
(21066, 5289, 1, 1, 1, 94.137915), -- Sealed Dark Crystal Helmet
(21066, 5525, 1, 1, 1, 9721.363644), -- Sealed Dark Crystal Helmet Design
(21066, 5294, 1, 1, 1, 94.137915), -- Sealed Tallum Helmet
(21066, 5526, 1, 1, 1, 9721.330671), -- Sealed Tallum Helm Design
(21066, 1868, 3, 9, 2, 104821.254228), -- Thread
(21066, 1873, 1, 1, 2, 125785.638128), -- Silver Nugget
(21066, 5549, 1, 1, 2, 31446.409532), -- Metallic Thread
(21066, 1889, 1, 1, 2, 20964.3839), -- Compound Braid
(21066, 4044, 1, 1, 2, 10482.025632), -- Thons
(21066, 4613, 1, 1, 2, 433.757344), -- Greater Dye of STR (Str+4 Con-4)
(21066, 729, 1, 1, 2, 34.92678), -- Scroll: Enchant Weapon (A-Grade)
(21066, 6671, 1, 1, 2, 34940.418076), -- Deluxe Chest Key - Grade 7
(21066, 8731, 1, 1, 2, 2911.562908), -- Life Stone - Level 70
(21066, 8741, 1, 1, 2, 727.807568), -- Mid-Grade Life Stone - Level 70
(21066, 8751, 1, 1, 2, 72.847284), -- High-Grade Life Stone - Level 70
(21066, 8761, 1, 1, 2, 14.96862), -- Top-Grade Life Stone - Level 70
-- Guardian Archangel
(21068, 3035, 1, 1, -1, 32034), -- Recipe: Spiritshot A
(21068, 5485, 1, 1, -1, 202033), -- Sealed Tallum Tunic Texture
(21068, 5479, 1, 1, -1, 142164), -- Sealed Tallum Leather Armor Pattern
(21068, 57, 11856, 24167, 0, 700000), -- Adena
(21068, 5287, 1, 1, 1, 83.016576), -- Sealed Dark Crystal breastplate
(21068, 5520, 1, 1, 1, 9535.024512), -- Sealed Dark Crystal Breastplate Pattern
(21068, 5293, 1, 1, 1, 51.103872), -- Sealed Tallum Plate Armor
(21068, 5521, 1, 1, 1, 6728.292864), -- Sealed Tallum Plate Armor Pattern
(21068, 5288, 1, 1, 1, 132.845184), -- Sealed Dark Crystal Gaiters
(21068, 5524, 1, 1, 1, 14573.716992), -- Sealed Dark Crystal Gaiters Pattern
(21068, 1869, 18, 54, 2, 22401.583128), -- Iron Ore
(21068, 1870, 2, 6, 2, 161291.488716), -- Coal
(21068, 1871, 3, 9, 2, 134409.498768), -- Charcoal
(21068, 1872, 7, 21, 2, 76805.492292), -- Animal Bone
(21068, 1867, 12, 36, 2, 44803.166256), -- Animal Skin
(21068, 4402, 1, 1, 2, 1613.126844), -- Blue Dimensional Stone
(21068, 729, 1, 1, 2, 89.743428), -- Scroll: Enchant Weapon (A-Grade)
(21068, 8731, 1, 1, 2, 7467.194376), -- Life Stone - Level 70
(21068, 8741, 1, 1, 2, 1867.02408), -- Mid-Grade Life Stone - Level 70
(21068, 8751, 1, 1, 2, 186.702408), -- High-Grade Life Stone - Level 70
(21068, 8761, 1, 1, 2, 36.979704), -- Top-Grade Life Stone - Level 70
-- Platinum Guardian Prefect
(21069, 4080, 1, 1, -1, 265874), -- Blue Wolf Gaiters Material
(21069, 4041, 1, 1, -1, 112395), -- Mold Hardener
(21069, 3035, 1, 1, -1, 17234), -- Recipe: Spiritshot A
(21069, 57, 6379, 13001, 0, 700000), -- Adena
(21069, 5291, 1, 1, 1, 134.057889), -- Sealed Dark Crystal Boots
(21069, 5496, 1, 1, 1, 13989.192111), -- Sealed Dark Crystal Boots Lining
(21069, 5296, 1, 1, 1, 134.057889), -- Sealed Tallum Boots
(21069, 5497, 1, 1, 1, 13989.192111), -- Sealed Tallum Boots Lining
(21069, 5290, 1, 1, 1, 134.057889), -- Sealed Dark Crystal Gloves
(21069, 5508, 1, 1, 1, 13989.192111), -- Sealed Dark Crystal Gloves Design
(21069, 5295, 1, 1, 1, 134.057889), -- Sealed Tallum Gloves
(21069, 5509, 1, 1, 1, 13989.192111), -- Sealed Tallum Gloves Design
(21069, 1871, 1, 3, 2, 198852.888312), -- Charcoal
(21069, 1866, 1, 1, 2, 265137.184416), -- Suede
(21069, 1877, 1, 1, 2, 15908.072024), -- Adamantite Nugget
(21069, 4041, 1, 1, 2, 3458.146874), -- Mold Hardener
(21069, 4040, 1, 1, 2, 7954.036012), -- Mold Lubricant
(21069, 4619, 1, 1, 2, 548.691312), -- Greater Dye of INT (Int+4 Men-4)
(21069, 5422, 1, 1, 2, 386.171331), -- Recipe: Sealed Majestic Plate Armor(60%)
(21069, 729, 1, 1, 2, 44.233267), -- Scroll: Enchant Weapon (A-Grade)
(21069, 8731, 1, 1, 2, 3682.295227), -- Life Stone - Level 70
(21069, 8741, 1, 1, 2, 920.449556), -- Mid-Grade Life Stone - Level 70
(21069, 8751, 1, 1, 2, 91.945555), -- High-Grade Life Stone - Level 70
(21069, 8761, 1, 1, 2, 18.886114), -- Top-Grade Life Stone - Level 70
-- Seal Archangel
(21071, 5486, 1, 1, -1, 147834), -- Sealed Dark Crystal Robe Fabric
(21071, 5156, 1, 1, -1, 33312), -- Recipe: Soulshot (A) Compressed Package (100%)
(21071, 5489, 1, 1, -1, 329756), -- Sealed Tallum Stockings Fabric
(21071, 57, 12324, 25146, 0, 700000), -- Adena
(21071, 5297, 1, 1, 1, 115.124142), -- Sealed Dark Crystal Leather Armor
(21071, 5478, 1, 1, 1, 12927.753902), -- Sealed Dark Crystal Leather Armor Pattern
(21071, 5301, 1, 1, 1, 70.816074), -- Sealed Tallum Leather Armor
(21071, 5479, 1, 1, 1, 9096.856146), -- Sealed Tallum Leather Armor Pattern
(21071, 5298, 1, 1, 1, 184.104718), -- Sealed Dark Crystal Leggings
(21071, 5482, 1, 1, 1, 20291.345018), -- Sealed Dark Crystal Leggings Design
(21071, 1894, 1, 1, 2, 32367.841994), -- Crafted Leather
(21071, 4039, 1, 1, 2, 30749.484325), -- Mold Glue
(21071, 4041, 1, 1, 2, 8021.549717), -- Mold Hardener
(21071, 4044, 1, 1, 2, 30749.484325), -- Thons
(21071, 4403, 1, 1, 2, 1844.911675), -- Red Dimensional Stone
(21071, 729, 1, 1, 2, 102.488717), -- Scroll: Enchant Weapon (A-Grade)
(21071, 8731, 1, 1, 2, 8541.568056), -- Life Stone - Level 70
(21071, 8741, 1, 1, 2, 2135.392014), -- Mid-Grade Life Stone - Level 70
(21071, 8751, 1, 1, 2, 213.585109), -- High-Grade Life Stone - Level 70
(21071, 8761, 1, 1, 2, 42.694068), -- Top-Grade Life Stone - Level 70
-- Platinum Guardian Chief
(21072, 4083, 1, 1, -1, 119814), -- Leather Armor of Doom Design
(21072, 5230, 1, 1, -1, 14138), -- Recipe: Mithril Arrow (100%)
(21072, 5161, 1, 1, -1, 14138), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21072, 57, 5231, 10672, 0, 700000), -- Adena
(21072, 5292, 1, 1, 1, 139.5768), -- Sealed Dark Crystal Shield
(21072, 5494, 1, 1, 1, 13702.98655), -- Sealed Dark Crystal Shield Fragment
(21072, 5289, 1, 1, 1, 97.66955), -- Sealed Dark Crystal Helmet
(21072, 5525, 1, 1, 1, 10086.06588), -- Sealed Dark Crystal Helmet Design
(21072, 5294, 1, 1, 1, 97.66955), -- Sealed Tallum Helmet
(21072, 5526, 1, 1, 1, 10086.03167), -- Sealed Tallum Helm Design
(21072, 1868, 3, 9, 2, 118641.414714), -- Thread
(21072, 1873, 1, 1, 2, 142369.63003), -- Silver Nugget
(21072, 5549, 1, 1, 2, 35592.322974), -- Metallic Thread
(21072, 1889, 1, 1, 2, 23728.215316), -- Compound Braid
(21072, 4044, 1, 1, 2, 11864.107658), -- Thons
(21072, 4984, 1, 1, 2, 1008.315588), -- Recipe: Blue Wolf Leather Armor (60%)
(21072, 4403, 1, 1, 2, 711.77207), -- Red Dimensional Stone
(21072, 8731, 1, 1, 2, 3295.453964), -- Life Stone - Level 70
(21072, 8741, 1, 1, 2, 824.032558), -- Mid-Grade Life Stone - Level 70
(21072, 8751, 1, 1, 2, 82.504696), -- High-Grade Life Stone - Level 70
(21072, 8761, 1, 1, 2, 16.230432), -- Top-Grade Life Stone - Level 70
-- Elmoreden's Guardian Warrior
(21073, 5230, 1, 1, -1, 7723), -- Recipe: Mithril Arrow (100%)
(21073, 4052, 1, 1, -1, 205074), -- Earring of Black Ore Piece
(21073, 57, 2300, 4651, 0, 700000), -- Adena
(21073, 287, 1, 1, 1, 16.95579), -- Bow of Peril
(21073, 4121, 1, 1, 1, 3726.04421), -- Bow of Peril Shaft
(21073, 1869, 1, 1, 2, 155542.380381), -- Iron Ore
(21073, 1864, 1, 3, 2, 155542.380381), -- Stem
(21073, 1880, 1, 1, 2, 15554.118345), -- Steel
(21073, 5550, 1, 1, 2, 2073.882446), -- Durable Metal Plate
(21073, 4043, 1, 1, 2, 5184.706115), -- Asofe
(21073, 1830, 1, 1, 2, 62216.872357), -- Scroll of Escape: Castle
(21073, 5276, 1, 1, 2, 207.46804), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21073, 8729, 1, 1, 2, 2073.882446), -- Life Stone - Level 64
(21073, 8739, 1, 1, 2, 518.6701), -- Mid-Grade Life Stone - Level 64
(21073, 8749, 1, 1, 2, 51.86701), -- High-Grade Life Stone - Level 64
(21073, 8759, 1, 1, 2, 10.772379), -- Top-Grade Life Stone - Level 64
-- Bound Shaman
(21074, 5478, 1, 1, -1, 50828), -- Sealed Dark Crystal Leather Armor Pattern
(21074, 1874, 1, 1, -1, 402961), -- Oriharukon Ore
(21074, 5482, 1, 1, -1, 79779), -- Sealed Dark Crystal Leggings Design
(21074, 57, 2981, 6086, 0, 700000), -- Adena
(21074, 5291, 1, 1, 1, 62.689914), -- Sealed Dark Crystal Boots
(21074, 5496, 1, 1, 1, 6541.810086), -- Sealed Dark Crystal Boots Lining
(21074, 5296, 1, 1, 1, 62.689914), -- Sealed Tallum Boots
(21074, 5497, 1, 1, 1, 6541.810086), -- Sealed Tallum Boots Lining
(21074, 5290, 1, 1, 1, 62.689914), -- Sealed Dark Crystal Gloves
(21074, 5508, 1, 1, 1, 6541.810086), -- Sealed Dark Crystal Gloves Design
(21074, 5295, 1, 1, 1, 62.689914), -- Sealed Tallum Gloves
(21074, 5509, 1, 1, 1, 6541.810086), -- Sealed Tallum Gloves Design
(21074, 1870, 1, 1, 2, 202889.768632), -- Coal
(21074, 1865, 1, 1, 2, 202889.768632), -- Varnish
(21074, 1874, 1, 1, 2, 13526.100884), -- Oriharukon Ore
(21074, 4043, 1, 1, 2, 6763.050442), -- Asofe
(21074, 4039, 1, 1, 2, 6763.050442), -- Mold Glue
(21074, 5166, 1, 1, 2, 270.41734), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21074, 730, 1, 1, 2, 169.228916), -- Scroll: Enchant Armor (A-Grade)
(21074, 8730, 1, 1, 2, 2254.495533), -- Life Stone - Level 67
(21074, 8740, 1, 1, 2, 563.514844), -- Mid-Grade Life Stone - Level 67
(21074, 8750, 1, 1, 2, 56.264253), -- High-Grade Life Stone - Level 67
(21074, 8760, 1, 1, 2, 11.340082), -- Top-Grade Life Stone - Level 67
-- Slaughter Bathin
(21075, 4616, 1, 1, -1, 7536), -- Greater Dye of CON (Con+4 Dex-4)
(21075, 4052, 1, 1, -1, 193443), -- Earring of Black Ore Piece
(21075, 4041, 1, 1, -1, 47511), -- Mold Hardener
(21075, 57, 2167, 4388, 0, 700000), -- Adena
(21075, 601, 1, 1, 1, 65.204056), -- Sealed Doom Boots
(21075, 4099, 1, 1, 1, 9056.795944), -- Sealed Doom Boots Part
(21075, 2439, 1, 1, 1, 65.204056), -- Sealed Blue Wolf Boots
(21075, 4090, 1, 1, 1, 9056.795944), -- Sealed Blue Wolf Boots Design
(21075, 2475, 1, 1, 1, 65.204056), -- Sealed Doom Gloves
(21075, 4091, 1, 1, 1, 9056.795944), -- Sealed Doom Gloves Part
(21075, 2487, 1, 1, 1, 65.204056), -- Sealed Blue Wolf Gloves
(21075, 4096, 1, 1, 1, 9056.795944), -- Sealed Blue Wolf Gloves Fabric
(21075, 1871, 1, 1, 2, 134493.480225), -- Charcoal
(21075, 1866, 1, 1, 2, 89662.32015), -- Suede
(21075, 1877, 1, 1, 2, 5379.739209), -- Adamantite Nugget
(21075, 4041, 1, 1, 2, 1169.518792), -- Mold Hardener
(21075, 4040, 1, 1, 2, 2689.98769), -- Mold Lubricant
(21075, 5005, 1, 1, 2, 102.734385), -- Recipe: Demon's Dagger (60%)
(21075, 5276, 1, 1, 2, 179.253789), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21075, 5418, 1, 1, 2, 198.619811), -- Recipe: Sealed Tallum Plate Armor(60%)
(21075, 8729, 1, 1, 2, 1793.246403), -- Life Stone - Level 64
(21075, 8739, 1, 1, 2, 448.252558), -- Mid-Grade Life Stone - Level 64
(21075, 8749, 1, 1, 2, 44.87249), -- High-Grade Life Stone - Level 64
(21075, 8759, 1, 1, 2, 8.974498), -- Top-Grade Life Stone - Level 64
-- Bathin's Knight
(21076, 4052, 1, 1, -1, 189765), -- Earring of Black Ore Piece
(21076, 5230, 1, 1, -1, 7147), -- Recipe: Mithril Arrow (100%)
(21076, 4053, 1, 1, -1, 229743), -- Ring of Black Ore Gemstone
(21076, 57, 2126, 4306, 0, 700000), -- Adena
(21076, 2398, 1, 1, 1, 21.314447), -- Blue Wolf Tunic
(21076, 4084, 1, 1, 1, 3440.532768), -- Blue Wolf Tunic Fabric
(21076, 2399, 1, 1, 1, 21.314447), -- Tunic of Doom
(21076, 4085, 1, 1, 1, 3440.532768), -- Tunic of Doom Pattern
(21076, 2403, 1, 1, 1, 34.129168), -- Blue Wolf Stockings
(21076, 4086, 1, 1, 1, 4645.507334), -- Blue Wolf Stockings Pattern
(21076, 2404, 1, 1, 1, 34.129168), -- Stockings of Doom
(21076, 4087, 1, 1, 1, 4645.5399), -- Stockings of Doom Pattern
(21076, 1871, 1, 1, 2, 158323.32098), -- Charcoal
(21076, 1866, 1, 1, 2, 105549.10784), -- Suede
(21076, 1877, 1, 1, 2, 6333.05552), -- Adamantite Nugget
(21076, 4041, 1, 1, 2, 1376.7512), -- Mold Hardener
(21076, 4040, 1, 1, 2, 3166.52776), -- Mold Lubricant
(21076, 1830, 1, 1, 2, 63329.53286), -- Scroll of Escape: Castle
(21076, 8729, 1, 1, 2, 2111.1321), -- Life Stone - Level 64
(21076, 8739, 1, 1, 2, 527.86822), -- Mid-Grade Life Stone - Level 64
(21076, 8749, 1, 1, 2, 52.8209), -- High-Grade Life Stone - Level 64
(21076, 8759, 1, 1, 2, 9.88262), -- Top-Grade Life Stone - Level 64
-- Bathin's Wizard
(21077, 5230, 1, 1, -1, 6798), -- Recipe: Mithril Arrow (100%)
(21077, 4054, 1, 1, -1, 100424), -- Necklace of Black Ore Beads
(21077, 4041, 1, 1, -1, 44335), -- Mold Hardener
(21077, 57, 2022, 4096, 0, 700000), -- Adena
(21077, 864, 1, 1, 1, 70.60721), -- Earring of Black Ore
(21077, 4052, 1, 1, 1, 8886.33308), -- Earring of Black Ore Piece
(21077, 926, 1, 1, 1, 52.961612), -- Necklace of Black Ore
(21077, 4054, 1, 1, 1, 4943.7456), -- Necklace of Black Ore Beads
(21077, 895, 1, 1, 1, 105.898406), -- Ring of Black Ore
(21077, 4053, 1, 1, 1, 10758.454092), -- Ring of Black Ore Gemstone
(21077, 1872, 1, 1, 2, 167336.28288), -- Animal Bone
(21077, 1867, 1, 1, 2, 167336.28288), -- Animal Skin
(21077, 1881, 1, 1, 2, 16733.718885), -- Coarse Bone Powder
(21077, 1875, 1, 1, 2, 8366.63295), -- Stone of Purity
(21077, 4041, 1, 1, 2, 1091.240865), -- Mold Hardener
(21077, 5230, 1, 1, 2, 167.151465), -- Recipe: Mithril Arrow (100%)
(21077, 5276, 1, 1, 2, 167.151465), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21077, 8729, 1, 1, 2, 1673.32659), -- Life Stone - Level 64
(21077, 8739, 1, 1, 2, 418.55814), -- Mid-Grade Life Stone - Level 64
(21077, 8749, 1, 1, 2, 41.67462), -- High-Grade Life Stone - Level 64
(21077, 8759, 1, 1, 2, 8.15373), -- Top-Grade Life Stone - Level 64
(21077, 1343, 20, 60, 2, 89644.82553), -- Silver Arrow
-- Magus Valac
(21078, 4040, 1, 1, -1, 135112), -- Mold Lubricant
(21078, 5485, 1, 1, -1, 56808), -- Sealed Tallum Tunic Texture
(21078, 3956, 1, 1, -1, 9007), -- Recipe: Blessed Spiritshot A
(21078, 57, 2672, 5436, 0, 700000), -- Adena
(21078, 5292, 1, 1, 1, 71.13888), -- Sealed Dark Crystal Shield
(21078, 5494, 1, 1, 1, 6984.07698), -- Sealed Dark Crystal Shield Fragment
(21078, 5289, 1, 1, 1, 49.77978), -- Sealed Dark Crystal Helmet
(21078, 5525, 1, 1, 1, 5140.621008), -- Sealed Dark Crystal Helmet Design
(21078, 5294, 1, 1, 1, 49.77978), -- Sealed Tallum Helmet
(21078, 5526, 1, 1, 1, 5140.603572), -- Sealed Tallum Helm Design
(21078, 1873, 1, 1, 2, 79819.857375), -- Silver Nugget
(21078, 1868, 1, 3, 2, 199549.836589), -- Thread
(21078, 1876, 1, 1, 2, 39910.121839), -- Mithril Ore
(21078, 1895, 1, 1, 2, 57014.45977), -- Metallic Fiber
(21078, 4042, 1, 1, 2, 3325.682527), -- Enria
(21078, 4175, 1, 1, 2, 3844.873759), -- Recipe: Sealed Avadon Boots (100%)
(21078, 8730, 1, 1, 2, 2217.37922), -- Life Stone - Level 67
(21078, 8740, 1, 1, 2, 554.344805), -- Mid-Grade Life Stone - Level 67
(21078, 8750, 1, 1, 2, 55.241329), -- High-Grade Life Stone - Level 67
(21078, 8760, 1, 1, 2, 11.202787), -- Top-Grade Life Stone - Level 67
-- Valac's Creature
(21079, 1895, 1, 3, -1, 918483), -- Metallic Fiber
(21079, 4042, 1, 1, -1, 107156), -- Enria
(21079, 5478, 1, 1, -1, 54065), -- Sealed Dark Crystal Leather Armor Pattern
(21079, 57, 2545, 5167, 0, 700000), -- Adena
(21079, 5304, 1, 1, 1, 23.701236), -- Sealed Tallum Tunic
(21079, 5485, 1, 1, 1, 2661.507316), -- Sealed Tallum Tunic Texture
(21079, 5308, 1, 1, 1, 14.579292), -- Sealed Dark Crystal Robe
(21079, 5486, 1, 1, 1, 1872.819468), -- Sealed Dark Crystal Robe Fabric
(21079, 5305, 1, 1, 1, 37.902644), -- Sealed Tallum Stockings
(21079, 5489, 1, 1, 1, 4177.490044), -- Sealed Tallum Stockings Fabric
(21079, 1873, 1, 1, 2, 69059.696958), -- Silver Nugget
(21079, 1868, 1, 3, 2, 172649.076758), -- Thread
(21079, 1876, 1, 1, 2, 34529.682842), -- Mithril Ore
(21079, 1895, 1, 1, 2, 49328.35497), -- Metallic Fiber
(21079, 4042, 1, 1, 2, 2877.445964), -- Enria
(21079, 5161, 1, 1, 2, 230.23543), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21079, 730, 1, 1, 2, 143.772916), -- Scroll: Enchant Armor (A-Grade)
(21079, 8730, 1, 1, 2, 1918.407734), -- Life Stone - Level 67
(21079, 8740, 1, 1, 2, 479.684752), -- Mid-Grade Life Stone - Level 67
(21079, 8750, 1, 1, 2, 48.03473), -- High-Grade Life Stone - Level 67
(21079, 8760, 1, 1, 2, 9.606946), -- Top-Grade Life Stone - Level 67
-- Valac's Guardian Spirit
(21080, 1807, 1, 1, -1, 7923), -- Recipe: Soulshot (A-Grade)
(21080, 5479, 1, 1, -1, 35162), -- Sealed Tallum Leather Armor Pattern
(21080, 3035, 1, 1, -1, 7923), -- Recipe: Spiritshot A
(21080, 57, 2352, 4776, 0, 700000), -- Adena
(21080, 6324, 1, 1, 1, 58.217938), -- Sealed Phoenix Earring
(21080, 6341, 1, 1, 1, 8091.08426), -- Sealed Phoenix Earring Gemstone
(21080, 6323, 1, 1, 1, 43.657022), -- Sealed Phoenix Necklace
(21080, 6343, 1, 1, 1, 6254.710928), -- Sealed Phoenix Necklace Beads
(21080, 6325, 1, 1, 1, 87.314044), -- Sealed Phoenix Ring
(21080, 6345, 1, 1, 1, 11191.015808), -- Sealed Phoenix Ring Gemstone
(21080, 1864, 1, 3, 2, 146273.299821), -- Stem
(21080, 1869, 1, 1, 2, 146273.299821), -- Iron Ore
(21080, 1878, 1, 1, 2, 58509.229293), -- Braided Hemp
(21080, 1884, 1, 1, 2, 90014.094333), -- Cord
(21080, 4039, 1, 1, 2, 4875.731343), -- Mold Glue
(21080, 5166, 1, 1, 2, 194.86611), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21080, 8314, 1, 1, 2, 79.759152), -- Recipe: Spiritual Eye (60%)
(21080, 8730, 1, 1, 2, 1625.092722), -- Life Stone - Level 67
(21080, 8740, 1, 1, 2, 406.499769), -- Mid-Grade Life Stone - Level 67
(21080, 8750, 1, 1, 2, 40.78593), -- High-Grade Life Stone - Level 67
(21080, 8760, 1, 1, 2, 8.157186), -- Top-Grade Life Stone - Level 67
(21080, 6036, 1, 1, 2, 4876.18452), -- Greater Magic Haste Potion
-- Power Angel Amon
(21081, 5230, 1, 1, -1, 8037), -- Recipe: Mithril Arrow (100%)
(21081, 4119, 1, 1, -1, 26385), -- Demon's Dagger Edge
(21081, 5478, 1, 1, -1, 50689), -- Sealed Dark Crystal Leather Armor Pattern
(21081, 57, 2973, 6067, 0, 700000), -- Adena
(21081, 5297, 1, 1, 1, 27.776403), -- Sealed Dark Crystal Leather Armor
(21081, 5478, 1, 1, 1, 3119.124243), -- Sealed Dark Crystal Leather Armor Pattern
(21081, 5301, 1, 1, 1, 17.086041), -- Sealed Tallum Leather Armor
(21081, 5479, 1, 1, 1, 2194.830189), -- Sealed Tallum Leather Armor Pattern
(21081, 5298, 1, 1, 1, 44.419587), -- Sealed Dark Crystal Leggings
(21081, 5482, 1, 1, 1, 4895.763537), -- Sealed Dark Crystal Leggings Design
(21081, 1872, 1, 3, 2, 148380.202152), -- Animal Bone
(21081, 1867, 1, 1, 2, 296759.909446), -- Animal Skin
(21081, 1881, 1, 1, 2, 29676.139402), -- Coarse Bone Powder
(21081, 1875, 1, 1, 2, 14837.822272), -- Stone of Purity
(21081, 4041, 1, 1, 2, 1935.389638), -- Mold Hardener
(21081, 4985, 1, 1, 2, 630.449092), -- Recipe: Leather Armor of Doom (60%)
(21081, 8731, 1, 1, 2, 2060.588712), -- Life Stone - Level 70
(21081, 8741, 1, 1, 2, 515.147178), -- Mid-Grade Life Stone - Level 70
(21081, 8751, 1, 1, 2, 51.465232), -- High-Grade Life Stone - Level 70
(21081, 8761, 1, 1, 2, 10.886876), -- Top-Grade Life Stone - Level 70
-- Amon's Captain of the Guards
(21082, 5482, 1, 1, -1, 76302), -- Sealed Dark Crystal Leggings Design
(21082, 5486, 1, 1, -1, 34207), -- Sealed Dark Crystal Robe Fabric
(21082, 5156, 1, 1, -1, 7708), -- Recipe: Soulshot (A) Compressed Package (100%)
(21082, 57, 2853, 5815, 0, 700000), -- Adena
(21082, 5304, 1, 1, 1, 26.638269), -- Sealed Tallum Tunic
(21082, 5485, 1, 1, 1, 2991.318589), -- Sealed Tallum Tunic Texture
(21082, 5308, 1, 1, 1, 16.385943), -- Sealed Dark Crystal Robe
(21082, 5486, 1, 1, 1, 2104.897347), -- Sealed Dark Crystal Robe Fabric
(21082, 5305, 1, 1, 1, 42.599501), -- Sealed Tallum Stockings
(21082, 5489, 1, 1, 1, 4695.160351), -- Sealed Tallum Stockings Fabric
(21082, 1865, 1, 1, 2, 213451.890565), -- Varnish
(21082, 1870, 1, 1, 2, 213451.890565), -- Coal
(21082, 1879, 1, 1, 2, 35575.234462), -- Cokes
(21082, 1875, 1, 1, 2, 14230.287302), -- Stone of Purity
(21082, 4040, 1, 1, 2, 4268.989432), -- Mold Lubricant
(21082, 5281, 1, 1, 2, 284.470284), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21082, 8731, 1, 1, 2, 1976.294405), -- Life Stone - Level 70
(21082, 8741, 1, 1, 2, 493.952653), -- Mid-Grade Life Stone - Level 70
(21082, 8751, 1, 1, 2, 49.346886), -- High-Grade Life Stone - Level 70
(21082, 8761, 1, 1, 2, 10.643446), -- Top-Grade Life Stone - Level 70
-- Amon's Spirits
(21083, 5485, 1, 1, -1, 50785), -- Sealed Tallum Tunic Texture
(21083, 5156, 1, 1, -1, 8052), -- Recipe: Soulshot (A) Compressed Package (100%)
(21083, 5486, 1, 1, -1, 35736), -- Sealed Dark Crystal Robe Fabric
(21083, 57, 2980, 6075, 0, 700000), -- Adena
(21083, 6324, 1, 1, 1, 73.959366), -- Sealed Phoenix Earring
(21083, 6341, 1, 1, 1, 10278.81582), -- Sealed Phoenix Earring Gemstone
(21083, 6323, 1, 1, 1, 55.461354), -- Sealed Phoenix Necklace
(21083, 6343, 1, 1, 1, 7945.909296), -- Sealed Phoenix Necklace Beads
(21083, 6325, 1, 1, 1, 110.922708), -- Sealed Phoenix Ring
(21083, 6345, 1, 1, 1, 14216.931456), -- Sealed Phoenix Ring Gemstone
(21083, 1866, 1, 1, 2, 135145.54431), -- Suede
(21083, 1871, 1, 1, 2, 202718.13273), -- Charcoal
(21083, 5220, 1, 1, 2, 8108.59302), -- Metal Hardener
(21083, 1885, 1, 1, 2, 16893.33084), -- High-Grade Suede
(21083, 4041, 1, 1, 2, 1762.75359), -- Mold Hardener
(21083, 1807, 1, 1, 2, 270.45792), -- Recipe: Soulshot (A-Grade)
(21083, 730, 1, 1, 2, 169.0362), -- Scroll: Enchant Armor (A-Grade)
(21083, 8731, 1, 1, 2, 1877.03676), -- Life Stone - Level 70
(21083, 8741, 1, 1, 2, 469.25919), -- Mid-Grade Life Stone - Level 70
(21083, 8751, 1, 1, 2, 47.03616), -- High-Grade Life Stone - Level 70
(21083, 8761, 1, 1, 2, 8.81928), -- Top-Grade Life Stone - Level 70
-- Bloody Lady
(21084, 4129, 1, 1, -1, 54392), -- Recipe: Earrings of Black Ore (100%)
(21084, 4056, 1, 1, -1, 90964), -- Zubei's Breastplate Part
(21084, 57, 1988, 4041, 0, 700000), -- Adena
(21084, 78, 1, 1, 1, 7.408178), -- Great Sword
(21084, 4104, 1, 1, 1, 1415.883266), -- Great Sword Blade
(21084, 142, 1, 1, 1, 7.408178), -- Keshanberk
(21084, 4107, 1, 1, 1, 1393.9461), -- Keshanberk Blade
(21084, 148, 1, 1, 1, 7.408178), -- Sword of Valhalla
(21084, 4108, 1, 1, 1, 1393.9461), -- Sword of Valhalla Blade
(21084, 1868, 1, 1, 2, 228390.933016), -- Thread
(21084, 1873, 1, 1, 2, 45678.101277), -- Silver Nugget
(21084, 5549, 1, 1, 2, 11419.631977), -- Metallic Thread
(21084, 1889, 1, 1, 2, 7613.230195), -- Compound Braid
(21084, 4044, 1, 1, 2, 3806.401782), -- Thons
(21084, 4196, 1, 1, 2, 87.032724), -- Recipe: Staff of Evil Spirits (100%)
(21084, 4402, 1, 1, 2, 228.247585), -- Blue Dimensional Stone
(21084, 5002, 1, 1, 2, 87.032724), -- Recipe: Deadman's Glory (60%)
(21084, 8728, 1, 1, 2, 1903.200891), -- Life Stone - Level 61
(21084, 8738, 1, 1, 2, 475.693565), -- Mid-Grade Life Stone - Level 61
(21084, 8748, 1, 1, 2, 47.782672), -- High-Grade Life Stone - Level 61
(21084, 8758, 1, 1, 2, 9.385882), -- Top-Grade Life Stone - Level 61
(21084, 1832, 1, 1, 2, 126884.32571), -- Greater Antidote
-- Bloody Sniper
(21085, 5479, 1, 1, -1, 55365), -- Sealed Tallum Leather Armor Pattern
(21085, 5489, 1, 1, -1, 123496), -- Sealed Tallum Stockings Fabric
(21085, 1889, 1, 1, -1, 623779), -- Compound Braid
(21085, 57, 4617, 9411, 0, 700000), -- Adena
(21085, 5297, 1, 1, 1, 43.114242), -- Sealed Dark Crystal Leather Armor
(21085, 5478, 1, 1, 1, 4841.472002), -- Sealed Dark Crystal Leather Armor Pattern
(21085, 5301, 1, 1, 1, 26.520774), -- Sealed Tallum Leather Armor
(21085, 5479, 1, 1, 1, 3406.792446), -- Sealed Tallum Leather Armor Pattern
(21085, 5298, 1, 1, 1, 68.947618), -- Sealed Dark Crystal Leggings
(21085, 5482, 1, 1, 1, 7599.152918), -- Sealed Dark Crystal Leggings Design
(21085, 1868, 3, 9, 2, 104690.175148), -- Thread
(21085, 1873, 1, 1, 2, 125628.272302), -- Silver Nugget
(21085, 5549, 1, 1, 2, 31406.99042), -- Metallic Thread
(21085, 1889, 1, 1, 2, 20938.097154), -- Compound Braid
(21085, 4044, 1, 1, 2, 10468.893266), -- Thons
(21085, 4131, 1, 1, 2, 2553.31284), -- Recipe: Necklace of Black Ore (100%)
(21085, 8730, 1, 1, 2, 3489.527548), -- Life Stone - Level 67
(21085, 8740, 1, 1, 2, 872.537198), -- Mid-Grade Life Stone - Level 67
(21085, 8750, 1, 1, 2, 87.284782), -- High-Grade Life Stone - Level 67
(21085, 8760, 1, 1, 2, 17.394832), -- Top-Grade Life Stone - Level 67
(21085, 6036, 1, 1, 2, 10469.51451), -- Greater Magic Haste Potion
-- Bloody Liviona
(21086, 1807, 1, 1, -1, 12483), -- Recipe: Soulshot (A-Grade)
(21086, 5482, 1, 1, -1, 123574), -- Sealed Dark Crystal Leggings Design
(21086, 1895, 1, 5, -1, 891673), -- Metallic Fiber
(21086, 57, 4617, 9427, 0, 700000), -- Adena
(21086, 5287, 1, 1, 1, 32.350949), -- Sealed Dark Crystal breastplate
(21086, 5520, 1, 1, 1, 3715.728913), -- Sealed Dark Crystal Breastplate Pattern
(21086, 5293, 1, 1, 1, 19.914803), -- Sealed Tallum Plate Armor
(21086, 5521, 1, 1, 1, 2621.966236), -- Sealed Tallum Plate Armor Pattern
(21086, 5288, 1, 1, 1, 51.768791), -- Sealed Dark Crystal Gaiters
(21086, 5524, 1, 1, 1, 5679.270308), -- Sealed Dark Crystal Gaiters Pattern
(21086, 1895, 1, 1, 2, 98770.285188), -- Metallic Fiber
(21086, 4040, 1, 1, 2, 6913.954136), -- Mold Lubricant
(21086, 4042, 1, 1, 2, 5761.540824), -- Enria
(21086, 4043, 1, 1, 2, 11523.213082), -- Asofe
(21086, 4166, 1, 1, 2, 2856.980858), -- Recipe: Doom Helmet (100%)
(21086, 4401, 1, 1, 2, 691.34284), -- Green Dimensional Stone
(21086, 8730, 1, 1, 2, 3841.027216), -- Life Stone - Level 67
(21086, 8740, 1, 1, 2, 960.256804), -- Mid-Grade Life Stone - Level 67
(21086, 8750, 1, 1, 2, 96.078254), -- High-Grade Life Stone - Level 67
(21086, 8760, 1, 1, 2, 19.320798), -- Top-Grade Life Stone - Level 67
-- Bloody Knight
(21087, 4082, 1, 1, -1, 146799), -- Blue Wolf Leather Armor Texture
(21087, 1894, 1, 1, -1, 455851), -- Crafted Leather
(21087, 5494, 1, 1, -1, 272850), -- Sealed Dark Crystal Shield Fragment
(21087, 57, 6416, 13062, 0, 700000), -- Adena
(21087, 5287, 1, 1, 1, 44.889911), -- Sealed Dark Crystal breastplate
(21087, 5520, 1, 1, 1, 5155.914907), -- Sealed Dark Crystal Breastplate Pattern
(21087, 5293, 1, 1, 1, 27.633617), -- Sealed Tallum Plate Armor
(21087, 5521, 1, 1, 1, 3638.218804), -- Sealed Tallum Plate Armor Pattern
(21087, 5288, 1, 1, 1, 71.833949), -- Sealed Dark Crystal Gaiters
(21087, 5524, 1, 1, 1, 7880.508812), -- Sealed Dark Crystal Gaiters Pattern
(21087, 1869, 2, 6, 2, 92249.215127), -- Iron Ore
(21087, 1864, 5, 15, 2, 73799.494938), -- Stem
(21087, 1880, 1, 1, 2, 36899.747469), -- Steel
(21087, 5550, 1, 1, 2, 4919.904911), -- Durable Metal Plate
(21087, 4043, 1, 1, 2, 12299.915823), -- Asofe
(21087, 4614, 1, 1, 2, 508.849787), -- Greater Dye of STR (Str+4 Dex-4)
(21087, 6037, 9, 27, 2, 40999.71941), -- Waking Scroll
(21087, 729, 1, 1, 2, 41.150194), -- Scroll: Enchant Weapon (A-Grade)
(21087, 6671, 1, 1, 2, 40999.71941), -- Deluxe Chest Key - Grade 7
(21087, 8731, 1, 1, 2, 3416.694466), -- Life Stone - Level 70
(21087, 8741, 1, 1, 2, 854.020071), -- Mid-Grade Life Stone - Level 70
(21087, 8751, 1, 1, 2, 85.371298), -- High-Grade Life Stone - Level 70
(21087, 8761, 1, 1, 2, 17.197096), -- Top-Grade Life Stone - Level 70
-- Bloody Banshee
(21088, 5338, 1, 1, -1, 12863), -- Recipe: Sealed Majestic Leather Armor(60%)
(21088, 4042, 1, 1, -1, 165717), -- Enria
(21088, 5485, 1, 1, -1, 83611), -- Sealed Tallum Tunic Texture
(21088, 57, 4907, 10001, 0, 700000), -- Adena
(21088, 5304, 1, 1, 1, 45.816636), -- Sealed Tallum Tunic
(21088, 5485, 1, 1, 1, 5144.934716), -- Sealed Tallum Tunic Texture
(21088, 5308, 1, 1, 1, 28.183092), -- Sealed Dark Crystal Robe
(21088, 5486, 1, 1, 1, 3620.329668), -- Sealed Dark Crystal Robe Fabric
(21088, 5305, 1, 1, 1, 73.269244), -- Sealed Tallum Stockings
(21088, 5489, 1, 1, 1, 8075.466644), -- Sealed Tallum Stockings Fabric
(21088, 1873, 1, 1, 2, 146851.06194), -- Silver Nugget
(21088, 1868, 3, 9, 2, 122375.96154), -- Thread
(21088, 1876, 1, 1, 2, 73425.76074), -- Mithril Ore
(21088, 1895, 1, 1, 2, 104893.68132), -- Metallic Fiber
(21088, 4042, 1, 1, 2, 6118.7751), -- Enria
(21088, 4986, 1, 1, 2, 1523.3751), -- Recipe: Blue Wolf Tunic (60%)
(21088, 8731, 1, 1, 2, 3399.21738), -- Life Stone - Level 70
(21088, 8741, 1, 1, 2, 849.68946), -- Mid-Grade Life Stone - Level 70
(21088, 8751, 1, 1, 2, 85.0149), -- High-Grade Life Stone - Level 70
(21088, 8761, 1, 1, 2, 17.46252), -- Top-Grade Life Stone - Level 70
-- Bloody Lord
(21089, 4116, 1, 1, -1, 50514), -- Deadman's Glory Stone
(21089, 3035, 1, 1, -1, 15413), -- Recipe: Spiritshot A
(21089, 5480, 1, 1, -1, 51871), -- Sealed Leather Armor of Nightmare Fabric
(21089, 57, 5702, 11635, 0, 700000), -- Adena
(21089, 5304, 1, 1, 1, 53.26575), -- Sealed Tallum Tunic
(21089, 5485, 1, 1, 1, 5981.42575), -- Sealed Tallum Tunic Texture
(21089, 5308, 1, 1, 1, 32.76525), -- Sealed Dark Crystal Robe
(21089, 5486, 1, 1, 1, 4208.94225), -- Sealed Dark Crystal Robe Fabric
(21089, 5305, 1, 1, 1, 85.18175), -- Sealed Tallum Stockings
(21089, 5489, 1, 1, 1, 9388.41925), -- Sealed Tallum Stockings Fabric
(21089, 1873, 2, 6, 2, 42682.333768), -- Silver Nugget
(21089, 1868, 3, 9, 2, 142275.12292), -- Thread
(21089, 1876, 1, 1, 2, 85365.073752), -- Mithril Ore
(21089, 1895, 1, 1, 2, 121950.10536), -- Metallic Fiber
(21089, 4042, 1, 1, 2, 7113.654592), -- Enria
(21089, 4986, 1, 1, 2, 1771.10176), -- Recipe: Blue Wolf Tunic (60%)
(21089, 8731, 1, 1, 2, 3952.075464), -- Life Stone - Level 70
(21089, 8741, 1, 1, 2, 987.917312), -- Mid-Grade Life Stone - Level 70
(21089, 8751, 1, 1, 2, 98.710488), -- High-Grade Life Stone - Level 70
(21089, 8761, 1, 1, 2, 19.904584), -- Top-Grade Life Stone - Level 70
-- Bloody Guardian
(21090, 5230, 1, 1, -1, 11849), -- Recipe: Mithril Arrow (100%)
(21090, 5486, 1, 1, -1, 52583), -- Sealed Dark Crystal Robe Fabric
(21090, 5156, 1, 1, -1, 11849), -- Recipe: Soulshot (A) Compressed Package (100%)
(21090, 57, 4384, 8944, 0, 700000), -- Adena
(21090, 5287, 1, 1, 1, 30.704176), -- Sealed Dark Crystal breastplate
(21090, 5520, 1, 1, 1, 3526.585712), -- Sealed Dark Crystal Breastplate Pattern
(21090, 5293, 1, 1, 1, 18.901072), -- Sealed Tallum Plate Armor
(21090, 5521, 1, 1, 1, 2488.499264), -- Sealed Tallum Plate Armor Pattern
(21090, 5288, 1, 1, 1, 49.133584), -- Sealed Dark Crystal Gaiters
(21090, 5524, 1, 1, 1, 5390.176192), -- Sealed Dark Crystal Gaiters Pattern
(21090, 1871, 1, 3, 2, 91143.638391), -- Charcoal
(21090, 1866, 1, 1, 2, 182286.809659), -- Suede
(21090, 1877, 1, 1, 2, 10937.217922), -- Adamantite Nugget
(21090, 4041, 1, 1, 2, 2377.65607), -- Mold Hardener
(21090, 4040, 1, 1, 2, 5468.608961), -- Mold Lubricant
(21090, 4401, 1, 1, 2, 547.001033), -- Green Dimensional Stone
(21090, 730, 1, 1, 2, 227.956024), -- Scroll: Enchant Armor (A-Grade)
(21090, 8731, 1, 1, 2, 2531.80666), -- Life Stone - Level 70
(21090, 8741, 1, 1, 2, 632.951665), -- Mid-Grade Life Stone - Level 70
(21090, 8751, 1, 1, 2, 63.061605), -- High-Grade Life Stone - Level 70
(21090, 8761, 1, 1, 2, 12.612321), -- Top-Grade Life Stone - Level 70
(21090, 1344, 20, 60, 2, 170893.679689), -- Mithril Arrow
-- Bloody Keeper
(21091, 5479, 1, 1, -1, 35349), -- Sealed Tallum Leather Armor Pattern
(21091, 3035, 1, 1, -1, 7965), -- Recipe: Spiritshot A
(21091, 5336, 1, 1, -1, 7728), -- Recipe: Sealed Leather Armor of Nightmare(60%)
(21091, 57, 2948, 6009, 0, 700000), -- Adena
(21091, 5297, 1, 1, 1, 27.528279), -- Sealed Dark Crystal Leather Armor
(21091, 5478, 1, 1, 1, 3091.261399), -- Sealed Dark Crystal Leather Armor Pattern
(21091, 5301, 1, 1, 1, 16.933413), -- Sealed Tallum Leather Armor
(21091, 5479, 1, 1, 1, 2175.223977), -- Sealed Tallum Leather Armor Pattern
(21091, 5298, 1, 1, 1, 44.022791), -- Sealed Dark Crystal Leggings
(21091, 5482, 1, 1, 1, 4852.030141), -- Sealed Dark Crystal Leggings Design
(21091, 1867, 1, 3, 2, 210072.547114), -- Animal Skin
(21091, 1872, 1, 3, 2, 140048.218698), -- Animal Bone
(21091, 1882, 1, 1, 2, 70024.328416), -- Leather
(21091, 1894, 1, 1, 2, 11056.31149), -- Crafted Leather
(21091, 4042, 1, 1, 2, 5251.912258), -- Enria
(21091, 3035, 1, 1, 2, 420.170506), -- Recipe: Spiritshot A
(21091, 10306, 1, 1, 2, 1260.511518), -- Transformation Sealbook: Doll Blader
-- Bloody Mystic
(21092, 5485, 1, 1, -1, 49077), -- Sealed Tallum Tunic Texture
(21092, 5161, 1, 1, -1, 7782), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21092, 5478, 1, 1, -1, 49077), -- Sealed Dark Crystal Leather Armor Pattern
(21092, 57, 2880, 5870, 0, 700000), -- Adena
(21092, 5292, 1, 1, 1, 76.82232), -- Sealed Dark Crystal Shield
(21092, 5494, 1, 1, 1, 7542.050095), -- Sealed Dark Crystal Shield Fragment
(21092, 5289, 1, 1, 1, 53.756795), -- Sealed Dark Crystal Helmet
(21092, 5525, 1, 1, 1, 5551.316412), -- Sealed Dark Crystal Helmet Design
(21092, 5294, 1, 1, 1, 53.756795), -- Sealed Tallum Helmet
(21092, 5526, 1, 1, 1, 5551.297583), -- Sealed Tallum Helm Design
(21092, 1868, 4, 12, 2, 67340.646289), -- Thread
(21092, 1873, 1, 1, 2, 107744.828485), -- Silver Nugget
(21092, 5549, 1, 1, 2, 26936.121464), -- Metallic Thread
(21092, 1889, 1, 1, 2, 17957.528519), -- Compound Braid
(21092, 4044, 1, 1, 2, 8978.592945), -- Thons
(21092, 3956, 1, 1, 2, 359.075192), -- Recipe: Blessed Spiritshot A
(21092, 10306, 1, 1, 2, 1077.568205), -- Transformation Sealbook: Doll Blader
(21092, 1344, 30, 90, 2, 112234.638901), -- Mithril Arrow
-- Ratman Sub Chieftain
(21093, 1800, 1, 1, -1, 83774), -- Recipe: Piece Bone Breastplate
(21093, 1897, 1, 1, -1, 63429), -- Necklace of Wisdom Chain
(21093, 1864, 1, 1, -1, 532802), -- Stem
(21093, 57, 125, 213, 0, 700000), -- Adena
(21093, 2, 1, 1, 1, 74.977705), -- Long Sword
(21093, 120, 1, 1, 1, 74.977705), -- Sword of Reflection
(21093, 2012, 1, 1, 1, 820.066885), -- Sword of Reflection Blade
(21093, 121, 1, 1, 1, 74.977705), -- Sword of Watershadow
(21093, 1864, 1, 1, 2, 78690.917104), -- Stem
(21093, 1869, 1, 1, 2, 39345.458552), -- Iron Ore
(21093, 1878, 1, 1, 2, 15738.21414), -- Braided Hemp
(21093, 1801, 1, 1, 2, 19821.410204), -- Recipe: Piece Bone Gaiters
-- Ratman Chieftain
(21094, 1870, 1, 1, -1, 270215), -- Coal
(21094, 734, 1, 1, -1, 45036), -- Haste Potion
(21094, 1924, 1, 1, -1, 87166), -- Leather Helmet Design
(21094, 57, 125, 217, 0, 700000), -- Adena
(21094, 176, 1, 1, 1, 152), -- Apprentice's Staff
(21094, 2501, 1, 1, 1, 152), -- Bone Club
(21094, 1865, 1, 1, 2, 39908.853285), -- Varnish
(21094, 1870, 1, 1, 2, 39908.853285), -- Coal
(21094, 1879, 1, 1, 2, 6651.522773), -- Cokes
(21094, 2141, 1, 1, 2, 7981.770657), -- Recipe: Silver Mold
-- Giant Poison Bee
(21095, 1804, 1, 1, -1, 15036), -- Recipe: Soulshot (D-Grade)
(21095, 1898, 1, 1, -1, 38613), -- Blue Diamond Necklace Gem
(21095, 2151, 1, 1, -1, 104706), -- Recipe: Necklace of Devotion
(21095, 57, 171, 306, 0, 700000), -- Adena
(21095, 257, 1, 1, 1, 236), -- Viper Fang
(21095, 1870, 1, 1, 2, 55516.67957), -- Coal
(21095, 1865, 1, 1, 2, 55516.67957), -- Varnish
(21095, 1804, 1, 1, 2, 2220.771702), -- Recipe: Soulshot (D-Grade)
(21095, 1831, 1, 1, 2, 148043.869158), -- Antidote
-- Cloudy Beast 
(21096, 1926, 1, 1, -1, 37310), -- Piece Bone Breastplate Fragment
(21096, 1866, 1, 1, -1, 246245), -- Suede
(21096, 1871, 1, 1, -1, 369368), -- Charcoal
(21096, 57, 168, 301, 0, 700000), -- Adena
(21096, 39, 1, 1, 1, 1531.287612), -- Boots
(21096, 1930, 1, 1, 1, 18650.403063), -- Boot Lining
(21096, 51, 1, 1, 1, 1531.309325), -- Bracer
(21096, 1866, 1, 1, 2, 48491.470211), -- Suede
(21096, 1871, 1, 1, 2, 72737.127301), -- Charcoal
(21096, 2179, 1, 1, 2, 34802.402488), -- Recipe: Crafted Leather Gloves
-- Young Araneid
(21097, 1927, 1, 1, -1, 33847), -- Hard Leather Shirt Pattern
(21097, 2176, 1, 1, -1, 203004), -- Recipe: Leather Boots
(21097, 1928, 1, 1, -1, 61803), -- Piece Bone Gaiters Fragment
(21097, 57, 194, 343, 0, 700000), -- Adena
(21097, 846, 1, 1, 1, 1018.870708), -- Coral Earring
(21097, 909, 1, 1, 1, 764.155468), -- Blue Diamond Necklace
(21097, 1898, 1, 1, 1, 6436.65314), -- Blue Diamond Necklace Gem
(21097, 878, 1, 1, 1, 1528.320684), -- Blue Coral Ring
(21097, 1870, 1, 1, 2, 50130.015455), -- Coal
(21097, 1865, 1, 1, 2, 50130.015455), -- Varnish
(21097, 2257, 1, 1, 2, 1225.641193), -- Recipe: Trident
(21097, 734, 1, 1, 2, 8354.961989), -- Haste Potion
(21097, 1831, 1, 1, 2, 133680.365908), -- Antidote
-- Plain Grizzly
(21098, 2177, 1, 1, -1, 127600), -- Recipe: Bone Helmet
(21098, 1929, 1, 1, -1, 51534), -- Hard Leather Gaiters Material
(21098, 1879, 1, 1, -1, 66565), -- Cokes
(21098, 57, 177, 327, 0, 700000), -- Adena
(21098, 16, 1, 1, 1, 251), -- Great Spear
(21098, 1865, 1, 1, 2, 58986.680208), -- Varnish
(21098, 1870, 1, 1, 2, 58986.680208), -- Coal
(21098, 1879, 1, 1, 2, 9831.156756), -- Cokes
(21098, 5158, 1, 1, 2, 2359.482828), -- Recipe: Spiritshot (D) Compressed Package (100%)
-- Cloudy Beast Turen
(21099, 1875, 1, 1, -1, 28539), -- Stone of Purity
(21099, 1899, 1, 1, -1, 66888), -- Necklace of Devotion Chain
(21099, 2152, 1, 1, -1, 75366), -- Recipe: Enchanted Necklace
(21099, 57, 188, 353, 0, 700000), -- Adena
(21099, 626, 1, 1, 1, 947.733136), -- Bronze Shield
(21099, 45, 1, 1, 1, 664.590628), -- Bone Helmet
(21099, 1932, 1, 1, 1, 12711.676236), -- Bone Helmet Design
(21099, 1875, 1, 1, 2, 3203.322531), -- Stone of Purity
(21099, 1879, 1, 1, 2, 8008.344804), -- Cokes
(21099, 5549, 1, 1, 2, 4804.996622), -- Metallic Thread
(21099, 2152, 1, 1, 2, 8459.520243), -- Recipe: Enchanted Necklace
(21099, 8294, 1, 1, 2, 1174.8158), -- Recipe: Steel Sword (100%)
-- Langk Lizardman Sentinel
(21100, 1897, 1, 1, -1, 63429), -- Necklace of Wisdom Chain
(21100, 1800, 1, 1, -1, 83774), -- Recipe: Piece Bone Breastplate
(21100, 1924, 1, 1, -1, 85936), -- Leather Helmet Design
(21100, 57, 125, 213, 0, 700000), -- Adena
(21100, 845, 1, 1, 1, 1150.453818), -- Cat's Eye Earring
(21100, 908, 1, 1, 1, 862.846917), -- Necklace of Wisdom
(21100, 1897, 1, 1, 1, 9368.018538), -- Necklace of Wisdom Chain
(21100, 877, 1, 1, 1, 1725.680727), -- Ring of Wisdom
(21100, 1869, 1, 1, 2, 39345.4152), -- Iron Ore
(21100, 1864, 1, 1, 2, 78690.96024), -- Stem
(21100, 1880, 1, 1, 2, 3934.54152), -- Steel
(21100, 1817, 1, 1, 2, 7869.08304), -- Recipe: Cord
-- Langk Lizardman Shaman
(21101, 1870, 1, 1, -1, 399388), -- Coal
(21101, 1865, 1, 1, -1, 399388), -- Varnish
(21101, 1898, 1, 1, -1, 41026), -- Blue Diamond Necklace Gem
(21101, 57, 177, 327, 0, 700000), -- Adena
(21101, 39, 1, 1, 1, 1655.762472), -- Boots
(21101, 1930, 1, 1, 1, 20166.451578), -- Boot Lining
(21101, 51, 1, 1, 1, 1655.78595), -- Bracer
(21101, 1870, 1, 1, 2, 47189.363348), -- Coal
(21101, 1865, 1, 1, 2, 47189.363348), -- Varnish
(21101, 5163, 1, 1, 2, 1887.598116), -- Recipe: Blessed Spiritshot (D) Compressed Package (100%)
(21101, 6666, 1, 1, 2, 47189.363348), -- Deluxe Chest Key - Grade 2
(21101, 6035, 1, 1, 2, 3932.31184), -- Magic Haste Potion
-- Watchman of the Plains
(21102, 2153, 1, 1, -1, 84230), -- Recipe: Tiger's Eye Earring
(21102, 1900, 1, 1, -1, 59256), -- Enchanted Necklace Chain
(21102, 2183, 1, 1, -1, 35631), -- Recipe: Mithril Banded Mail
(21102, 57, 228, 457, 0, 700000), -- Adena
(21102, 433, 1, 1, 1, 96.214123), -- Elven Tunic
(21102, 434, 1, 1, 1, 96.214123), -- White Tunic
(21102, 1936, 1, 1, 1, 3027.472147), -- White Tunic Pattern
(21102, 435, 1, 1, 1, 96.214123), -- Mystic's Tunic
(21102, 466, 1, 1, 1, 154.147498), -- Elven Stockings
(21102, 467, 1, 1, 1, 154.147498), -- Dark Stockings
(21102, 1933, 1, 1, 1, 4352.434859), -- Dark Stockings Fabric
(21102, 468, 1, 1, 1, 154.155629), -- Mystic's Stockings
(21102, 1874, 1, 1, 2, 3288.45484), -- Oriharukon Ore
(21102, 1878, 1, 1, 2, 19730.78932), -- Braided Hemp
(21102, 1884, 1, 1, 2, 30355.01876), -- Cord
(21102, 1889, 1, 1, 2, 3288.45484), -- Compound Braid
(21102, 5220, 1, 1, 2, 1973.08496), -- Metal Hardener
(21102, 956, 1, 1, 2, 1644.19728), -- Scroll: Enchant Armor (D-Grade)
-- Roughly Hewn Rock Golem
(21103, 1933, 1, 1, -1, 66361), -- Dark Stockings Fabric
(21103, 1879, 1, 1, -1, 94011), -- Cokes
(21103, 955, 1, 1, -1, 2256), -- Scroll: Enchant Weapon (D-Grade)
(21103, 57, 239, 476, 0, 700000), -- Adena
(21103, 348, 1, 1, 1, 150.355692), -- Scale Mail
(21103, 1935, 1, 1, 1, 4304.991144), -- Scale Mail Fragment
(21103, 377, 1, 1, 1, 240.431052), -- Scale Gaiters
(21103, 1937, 1, 1, 1, 6620.222112), -- Scale Gaiters Fragment
(21103, 1875, 1, 1, 2, 2935.62317), -- Stone of Purity
(21103, 1879, 1, 1, 2, 7338.97649), -- Cokes
(21103, 1885, 1, 1, 2, 3669.51539), -- High-Grade Suede
(21103, 5550, 1, 1, 2, 587.14635), -- Durable Metal Plate
(21103, 5549, 1, 1, 2, 4403.40761), -- Metallic Thread
(21103, 2185, 1, 1, 2, 8668.10427), -- Recipe: Iron Boots
(21103, 1061, 1, 1, 2, 26687.22672), -- Greater Healing Potion
-- Delu Lizardman Supplier
(21104, 1876, 1, 1, -1, 140715), -- Mithril Ore
(21104, 1061, 1, 1, -1, 426409), -- Greater Healing Potion
(21104, 1935, 1, 1, -1, 39306), -- Scale Mail Fragment
(21104, 57, 296, 595, 0, 700000), -- Adena
(21104, 1123, 1, 1, 1, 1502), -- Blue Buckskin Boots
(21104, 605, 1, 1, 1, 1502), -- Leather Gauntlets
(21104, 1876, 1, 1, 2, 10985.1025), -- Mithril Ore
(21104, 1880, 1, 1, 2, 5492.5147), -- Steel
(21104, 1877, 1, 1, 2, 2197.0205), -- Adamantite Nugget
(21104, 1881, 1, 1, 2, 7323.3773), -- Coarse Bone Powder
(21104, 1882, 1, 1, 2, 12205.6532), -- Leather
(21104, 2264, 1, 1, 2, 567.987), -- Recipe: Two-handed Sword
(21104, 6667, 1, 1, 2, 34328.3448), -- Deluxe Chest Key - Grade 3
-- Delu Lizardman Special Agent
(21105, 2154, 1, 1, -1, 86586), -- Recipe: Elven Earring
(21105, 1901, 1, 1, -1, 111700), -- Tiger's Eye Earring Stone
(21105, 2155, 1, 1, -1, 129809), -- Recipe: Elven Ring
(21105, 57, 342, 683, 0, 700000), -- Adena
(21105, 393, 1, 1, 1, 122.506823), -- Mithril Banded Mail
(21105, 1938, 1, 1, 1, 4817.759693), -- Mithril Banded Mail Material
(21105, 394, 1, 1, 1, 122.506823), -- Reinforced Leather Shirt
(21105, 415, 1, 1, 1, 195.808834), -- Mithril Banded Gaiters
(21105, 1939, 1, 1, 1, 6294.620742), -- Mithril Banded Gaiters Material
(21105, 416, 1, 1, 1, 195.797085), -- Reinforced Leather Gaiters
(21105, 1874, 1, 1, 2, 4777.605589), -- Oriharukon Ore
(21105, 1878, 1, 1, 2, 28665.540673), -- Braided Hemp
(21105, 1884, 1, 1, 2, 44100.896093), -- Cord
(21105, 1889, 1, 1, 2, 4777.605589), -- Compound Braid
(21105, 5220, 1, 1, 2, 2866.526209), -- Metal Hardener
(21105, 2154, 1, 1, 2, 7672.825847), -- Recipe: Elven Earring
-- Cursed Seer
(21106, 1938, 1, 1, -1, 45809), -- Mithril Banded Mail Material
(21106, 1885, 1, 1, -1, 56785), -- High-Grade Suede
(21106, 5550, 1, 1, -1, 9086), -- Durable Metal Plate
(21106, 57, 288, 574, 0, 700000), -- Adena
(21106, 628, 1, 1, 1, 883.706206), -- Hoplon
(21106, 47, 1, 1, 1, 618.293794), -- Helmet
(21106, 1875, 1, 1, 2, 3019.186494), -- Stone of Purity
(21106, 1879, 1, 1, 2, 7547.793966), -- Cokes
(21106, 1885, 1, 1, 2, 3773.896983), -- High-Grade Suede
(21106, 5550, 1, 1, 2, 603.802845), -- Durable Metal Plate
(21106, 5549, 1, 1, 2, 4528.779741), -- Metallic Thread
(21106, 2186, 1, 1, 2, 1514.589048), -- Recipe: Brigandine Tunic
(21106, 8317, 1, 1, 2, 323.521182), -- Recipe: Titan Hammer (100%)
(21106, 1341, 10, 30, 2, 150957.429741), -- Bone Arrow
-- Delu Lizardman Commander
(21107, 1939, 1, 1, -1, 126271), -- Mithril Banded Gaiters Material
(21107, 2156, 1, 1, -1, 115008), -- Recipe: Elven Necklace
(21107, 1940, 1, 1, -1, 214567), -- Iron Boots Design
(21107, 57, 607, 1211, 0, 700000), -- Adena
(21107, 260, 1, 1, 1, 206), -- Triple-Edged Jamadhr
(21107, 1876, 1, 1, 2, 25478.533496), -- Mithril Ore
(21107, 1880, 1, 1, 2, 12739.266748), -- Steel
(21107, 1877, 1, 1, 2, 5095.667616), -- Adamantite Nugget
(21107, 1881, 1, 1, 2, 16985.656428), -- Coarse Bone Powder
(21107, 1882, 1, 1, 2, 28309.42738), -- Leather
(21107, 2188, 1, 1, 2, 9099.448332), -- Recipe: Manticore Skin Gaiters
-- Glow Wisp
(21108, 5230, 1, 1, -1, 3610), -- Recipe: Mithril Arrow (100%)
(21108, 4052, 1, 1, -1, 95871), -- Earring of Black Ore Piece
(21108, 5550, 1, 1, -1, 36105), -- Durable Metal Plate
(21108, 57, 1068, 2182, 0, 700000), -- Adena
(21108, 12204, 1, 1, 1, 177.511148), -- Common Item - Blue Wolf Breastplate
(21108, 4078, 1, 1, 1, 1947.25167), -- Blue Wolf Breastplate Part
(21108, 12184, 1, 1, 1, 109.266454), -- Common Item - Doom Plate Armor
(21108, 4081, 1, 1, 1, 1313.905936), -- Doom Plate Armor Temper
(21108, 12193, 1, 1, 1, 283.937634), -- Common Item - Blue Wolf Gaiters
(21108, 4080, 1, 1, 1, 2742.127158), -- Blue Wolf Gaiters Material
(21108, 1869, 1, 1, 2, 72714.84642), -- Iron Ore
(21108, 1864, 1, 1, 2, 145429.46286), -- Stem
(21108, 1880, 1, 1, 2, 7271.50764), -- Steel
(21108, 5550, 1, 1, 2, 969.59568), -- Durable Metal Plate
(21108, 4043, 1, 1, 2, 2423.75922), -- Asofe
(21108, 5230, 1, 1, 2, 97.05156), -- Recipe: Mithril Arrow (100%)
(21108, 8487, 1, 1, 2, 39.78654), -- Recipe: Destroyer Hammer (60%)
(21108, 8730, 1, 1, 2, 807.91974), -- Life Stone - Level 67
(21108, 8740, 1, 1, 2, 201.92244), -- Mid-Grade Life Stone - Level 67
(21108, 8750, 1, 1, 2, 20.23824), -- High-Grade Life Stone - Level 67
(21108, 8760, 1, 1, 2, 3.90966), -- Top-Grade Life Stone - Level 67
-- Hames Orc Scout
(21109, 1874, 1, 1, -1, 224175), -- Oriharukon Ore
(21109, 4043, 1, 1, -1, 112087), -- Asofe
(21109, 5478, 1, 1, -1, 28276), -- Sealed Dark Crystal Leather Armor Pattern
(21109, 57, 1330, 2704, 0, 700000), -- Adena
(21109, 12345, 1, 1, 1, 639.16551), -- Common Item - Sealed Phoenix Earring
(21109, 6341, 1, 1, 1, 4578.76041), -- Sealed Phoenix Earring Gemstone
(21109, 12344, 1, 1, 1, 479.83284), -- Common Item - Sealed Phoenix Necklace
(21109, 6343, 1, 1, 1, 3539.55237), -- Sealed Phoenix Necklace Beads
(21109, 12346, 1, 1, 1, 959.68221), -- Common Item - Sealed Phoenix Ring
(21109, 6345, 1, 1, 1, 6333.00666), -- Sealed Phoenix Ring Gemstone
(21109, 1870, 1, 1, 2, 82772.23776), -- Coal
(21109, 1865, 1, 1, 2, 82772.23776), -- Varnish
(21109, 1874, 1, 1, 2, 5518.149184), -- Oriharukon Ore
(21109, 4043, 1, 1, 2, 2759.074592), -- Asofe
(21109, 4039, 1, 1, 2, 2759.074592), -- Mold Glue
(21109, 1807, 1, 1, 2, 110.377272), -- Recipe: Soulshot (A-Grade)
(21109, 6037, 1, 1, 2, 165544.47552), -- Waking Scroll
(21109, 6670, 1, 1, 2, 13795.37296), -- Deluxe Chest Key - Grade 6
(21109, 8730, 1, 1, 2, 919.8106), -- Life Stone - Level 67
(21109, 8740, 1, 1, 2, 230.041952), -- Mid-Grade Life Stone - Level 67
(21109, 8750, 1, 1, 2, 22.861312), -- High-Grade Life Stone - Level 67
(21109, 8760, 1, 1, 2, 4.286496), -- Top-Grade Life Stone - Level 67
-- Marsh Predator
(21110, 1807, 1, 1, -1, 3832), -- Recipe: Soulshot (A-Grade)
(21110, 5479, 1, 1, -1, 17005), -- Sealed Tallum Leather Armor Pattern
(21110, 3035, 1, 1, -1, 3832), -- Recipe: Spiritshot A
(21110, 57, 1137, 2310, 0, 700000), -- Adena
(21110, 12222, 1, 1, 1, 205.489715), -- Common Item - Sealed Dark Crystal Leather Armor
(21110, 5478, 1, 1, 1, 1189.69312), -- Sealed Dark Crystal Leather Armor Pattern
(21110, 12230, 1, 1, 1, 126.31926), -- Common Item - Sealed Tallum Leather Armor
(21110, 5479, 1, 1, 1, 837.149785), -- Sealed Tallum Leather Armor Pattern
(21110, 12228, 1, 1, 1, 329.021315), -- Common Item - Sealed Dark Crystal Leggings
(21110, 5482, 1, 1, 1, 1867.326805), -- Sealed Dark Crystal Leggings Design
(21110, 1871, 1, 1, 2, 77173.162866), -- Charcoal
(21110, 1866, 1, 1, 2, 51448.775244), -- Suede
(21110, 1877, 1, 1, 2, 3086.921108), -- Adamantite Nugget
(21110, 4041, 1, 1, 2, 671.09919), -- Mold Hardener
(21110, 4040, 1, 1, 2, 1543.460554), -- Mold Lubricant
(21110, 3956, 1, 1, 2, 102.861326), -- Recipe: Blessed Spiritshot A
(21110, 8487, 1, 1, 2, 42.171792), -- Recipe: Destroyer Hammer (60%)
(21110, 8730, 1, 1, 2, 857.493104), -- Life Stone - Level 67
(21110, 8740, 1, 1, 2, 214.373276), -- Mid-Grade Life Stone - Level 67
(21110, 8750, 1, 1, 2, 21.491394), -- High-Grade Life Stone - Level 67
(21110, 8760, 1, 1, 2, 4.190146), -- Top-Grade Life Stone - Level 67
-- Lava Wyrm
(21111, 5482, 1, 1, -1, 39755), -- Sealed Dark Crystal Leggings Design
(21111, 4041, 1, 1, -1, 26191), -- Mold Hardener
(21111, 5479, 1, 1, -1, 17822), -- Sealed Tallum Leather Armor Pattern
(21111, 57, 1191, 2424, 0, 700000), -- Adena
(21111, 12222, 1, 1, 1, 215.369462), -- Common Item - Sealed Dark Crystal Leather Armor
(21111, 5478, 1, 1, 1, 1246.892416), -- Sealed Dark Crystal Leather Armor Pattern
(21111, 12230, 1, 1, 1, 132.392568), -- Common Item - Sealed Tallum Leather Armor
(21111, 5479, 1, 1, 1, 877.399138), -- Sealed Tallum Leather Armor Pattern
(21111, 12228, 1, 1, 1, 344.840342), -- Common Item - Sealed Dark Crystal Leggings
(21111, 5482, 1, 1, 1, 1957.106074), -- Sealed Dark Crystal Leggings Design
(21111, 1865, 1, 1, 2, 74141.595432), -- Varnish
(21111, 1870, 1, 1, 2, 74141.595432), -- Coal
(21111, 1879, 1, 1, 2, 12356.932572), -- Cokes
(21111, 1875, 1, 1, 2, 4942.668654), -- Stone of Purity
(21111, 4040, 1, 1, 2, 1482.904971), -- Mold Lubricant
(21111, 5166, 1, 1, 2, 98.895123), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21111, 8487, 1, 1, 2, 40.445235), -- Recipe: Destroyer Hammer (60%)
(21111, 8730, 1, 1, 2, 823.778109), -- Life Stone - Level 67
(21111, 8740, 1, 1, 2, 205.879293), -- Mid-Grade Life Stone - Level 67
(21111, 8750, 1, 1, 2, 20.614023), -- High-Grade Life Stone - Level 67
(21111, 8760, 1, 1, 2, 4.174992), -- Top-Grade Life Stone - Level 67
(21111, 1344, 10, 30, 2, 92677.516164), -- Mithril Arrow
-- Hames Orc Footsoldier
(21112, 5485, 1, 1, -1, 24627), -- Sealed Tallum Tunic Texture
(21112, 3956, 1, 1, -1, 3905), -- Recipe: Blessed Spiritshot A
(21112, 5486, 1, 1, -1, 17329), -- Sealed Dark Crystal Robe Fabric
(21112, 57, 1445, 2946, 0, 700000), -- Adena
(21112, 12224, 1, 1, 1, 588.977907), -- Common Item - Sealed Dark Crystal Boots
(21112, 5496, 1, 1, 1, 3169.272093), -- Sealed Dark Crystal Boots Lining
(21112, 12231, 1, 1, 1, 588.977907), -- Common Item - Sealed Tallum Boots
(21112, 5497, 1, 1, 1, 3169.272093), -- Sealed Tallum Boots Lining
(21112, 12221, 1, 1, 1, 588.977907), -- Common Item - Sealed Dark Crystal Gloves
(21112, 5508, 1, 1, 1, 3169.272093), -- Sealed Dark Crystal Gloves Design
(21112, 12229, 1, 1, 1, 588.977907), -- Common Item - Sealed Tallum Gloves
(21112, 5509, 1, 1, 1, 3169.272093), -- Sealed Tallum Gloves Design
(21112, 1873, 1, 1, 2, 43253.661907), -- Silver Nugget
(21112, 1868, 1, 1, 2, 216268.625064), -- Thread
(21112, 1876, 1, 1, 2, 21626.988718), -- Mithril Ore
(21112, 1895, 1, 1, 2, 30895.653093), -- Metallic Fiber
(21112, 4042, 1, 1, 2, 1802.301648), -- Enria
(21112, 5281, 1, 1, 2, 144.196753), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21112, 8730, 1, 1, 2, 1201.534432), -- Life Stone - Level 67
(21112, 8740, 1, 1, 2, 300.383608), -- Mid-Grade Life Stone - Level 67
(21112, 8750, 1, 1, 2, 29.975255), -- High-Grade Life Stone - Level 67
(21112, 8760, 1, 1, 2, 5.679522), -- Top-Grade Life Stone - Level 67
-- Hames Orc Sniper
(21113, 5156, 1, 1, -1, 4361), -- Recipe: Soulshot (A) Compressed Package (100%)
(21113, 5489, 1, 1, -1, 43172), -- Sealed Tallum Stockings Fabric
(21113, 5166, 1, 1, -1, 4361), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21113, 57, 1613, 3293, 0, 700000), -- Adena
(21113, 12222, 1, 1, 1, 292.377353), -- Common Item - Sealed Dark Crystal Leather Armor
(21113, 5478, 1, 1, 1, 1692.733504), -- Sealed Dark Crystal Leather Armor Pattern
(21113, 12230, 1, 1, 1, 179.731092), -- Common Item - Sealed Tallum Leather Armor
(21113, 5479, 1, 1, 1, 1191.123547), -- Sealed Tallum Leather Armor Pattern
(21113, 12228, 1, 1, 1, 468.142073), -- Common Item - Sealed Dark Crystal Leggings
(21113, 5482, 1, 1, 1, 2656.892431), -- Sealed Dark Crystal Leggings Design
(21113, 1864, 1, 3, 2, 109793.118153), -- Stem
(21113, 1869, 1, 1, 2, 109793.118153), -- Iron Ore
(21113, 1878, 1, 1, 2, 43916.963055), -- Braided Hemp
(21113, 1884, 1, 1, 2, 67564.813603), -- Cord
(21113, 4039, 1, 1, 2, 3659.628502), -- Mold Glue
(21113, 3035, 1, 1, 2, 146.366193), -- Recipe: Spiritshot A
(21113, 8730, 1, 1, 2, 1219.718275), -- Life Stone - Level 67
(21113, 8740, 1, 1, 2, 305.047988), -- Mid-Grade Life Stone - Level 67
(21113, 8750, 1, 1, 2, 30.315328), -- High-Grade Life Stone - Level 67
(21113, 8760, 1, 1, 2, 6.157801), -- Top-Grade Life Stone - Level 67
(21113, 1344, 10, 30, 2, 137241.752949), -- Mithril Arrow
-- Cursed Guardian
(21114, 1875, 1, 1, -1, 207673), -- Stone of Purity
(21114, 5494, 1, 1, -1, 65423), -- Sealed Dark Crystal Shield Fragment
(21114, 5161, 1, 1, -1, 4153), -- Recipe: Spiritshot (A) Compressed Package (100%)
(21114, 57, 1538, 3132, 0, 700000), -- Adena
(21114, 12227, 1, 1, 1, 208.942419), -- Common Item - Sealed Dark Crystal Breastplate
(21114, 5520, 1, 1, 1, 1236.21113), -- Sealed Dark Crystal Breastplate Pattern
(21114, 12233, 1, 1, 1, 128.658964), -- Common Item - Sealed Tallum Plate Armor
(21114, 5521, 1, 1, 1, 872.318608), -- Sealed Tallum Plate Armor Pattern
(21114, 12220, 1, 1, 1, 333.399283), -- Common Item - Sealed Dark Crystal Gaiters
(21114, 5524, 1, 1, 1, 1889.469596), -- Sealed Dark Crystal Gaiters Pattern
(21114, 1870, 1, 1, 2, 104562.90785), -- Coal
(21114, 1865, 1, 1, 2, 104562.90785), -- Varnish
(21114, 1874, 1, 1, 2, 6970.8842), -- Oriharukon Ore
(21114, 4043, 1, 1, 2, 3485.4421), -- Asofe
(21114, 4039, 1, 1, 2, 3485.4421), -- Mold Glue
(21114, 5271, 1, 1, 2, 139.57395), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21114, 8731, 1, 1, 2, 968.1389), -- Life Stone - Level 70
(21114, 8741, 1, 1, 2, 242.2123), -- Mid-Grade Life Stone - Level 70
(21114, 8751, 1, 1, 2, 24.1502), -- High-Grade Life Stone - Level 70
(21114, 8761, 1, 1, 2, 4.9721), -- Top-Grade Life Stone - Level 70
(21114, 1344, 10, 30, 2, 130703.36845), -- Mithril Arrow
-- Hames Orc Shaman
(21115, 5496, 1, 1, -1, 63784), -- Sealed Dark Crystal Boots Lining
(21115, 5166, 1, 1, -1, 3627), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21115, 5497, 1, 1, -1, 63784), -- Sealed Tallum Boots Lining
(21115, 57, 1342, 2736, 0, 700000), -- Adena
(21115, 12232, 1, 1, 1, 243.15907), -- Common Item - Sealed Tallum Tunic
(21115, 5485, 1, 1, 1, 1407.78176), -- Sealed Tallum Tunic Texture
(21115, 12223, 1, 1, 1, 149.47548), -- Common Item - Sealed Dark Crystal Robe
(21115, 5486, 1, 1, 1, 990.61193), -- Sealed Dark Crystal Robe Fabric
(21115, 12235, 1, 1, 1, 389.33587), -- Common Item - Sealed Tallum Stockings
(21115, 5489, 1, 1, 1, 2209.63589), -- Sealed Tallum Stockings Fabric
(21115, 1866, 1, 1, 2, 60875.972472), -- Suede
(21115, 1871, 1, 1, 2, 91313.958708), -- Charcoal
(21115, 5220, 1, 1, 2, 3652.572396), -- Metal Hardener
(21115, 1885, 1, 1, 2, 7609.45266), -- High-Grade Suede
(21115, 4041, 1, 1, 2, 794.045112), -- Mold Hardener
(21115, 5281, 1, 1, 2, 121.688028), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21115, 6671, 1, 1, 2, 10145.93688), -- Deluxe Chest Key - Grade 7
(21115, 8731, 1, 1, 2, 845.49474), -- Life Stone - Level 70
(21115, 8741, 1, 1, 2, 211.417584), -- Mid-Grade Life Stone - Level 70
(21115, 8751, 1, 1, 2, 21.07152), -- High-Grade Life Stone - Level 70
(21115, 8761, 1, 1, 2, 4.3899), -- Top-Grade Life Stone - Level 70
-- Hames Orc Overlord
(21116, 729, 1, 1, -1, 479), -- Scroll: Enchant Weapon (A-Grade)
(21116, 5480, 1, 1, -1, 19326), -- Sealed Leather Armor of Nightmare Fabric
(21116, 5481, 1, 1, -1, 19326), -- Sealed Majestic Leather Armor Fabric
(21116, 57, 2125, 4335, 0, 700000), -- Adena
(21116, 12345, 1, 1, 1, 1023.322155), -- Common Item - Sealed Phoenix Earring
(21116, 6341, 1, 1, 1, 7330.725605), -- Sealed Phoenix Earring Gemstone
(21116, 12344, 1, 1, 1, 768.22602), -- Common Item - Sealed Phoenix Necklace
(21116, 6343, 1, 1, 1, 5666.923985), -- Sealed Phoenix Necklace Beads
(21116, 12346, 1, 1, 1, 1536.478505), -- Common Item - Sealed Phoenix Ring
(21116, 6345, 1, 1, 1, 10139.32373), -- Sealed Phoenix Ring Gemstone
(21116, 1867, 1, 1, 2, 192758.694975), -- Animal Skin
(21116, 1872, 1, 1, 2, 192758.694975), -- Animal Bone
(21116, 1882, 1, 1, 2, 32126.235435), -- Leather
(21116, 1894, 1, 1, 2, 5072.608485), -- Crafted Leather
(21116, 4042, 1, 1, 2, 2409.563835), -- Enria
(21116, 729, 1, 1, 2, 16.24329), -- Scroll: Enchant Weapon (A-Grade)
(21116, 4987, 1, 1, 2, 599.719365), -- Recipe: Tunic of Doom (60%)
(21116, 8731, 1, 1, 2, 1338.78906), -- Life Stone - Level 70
(21116, 8741, 1, 1, 2, 334.697265), -- Mid-Grade Life Stone - Level 70
(21116, 8751, 1, 1, 2, 33.34149), -- High-Grade Life Stone - Level 70
(21116, 8761, 1, 1, 2, 6.411825), -- Top-Grade Life Stone - Level 70
-- Kasha Imp
(21117, 734, 1, 1, -1, 43530), -- Haste Potion
(21117, 1897, 1, 1, -1, 62185), -- Necklace of Wisdom Chain
(21117, 1800, 1, 1, -1, 82131), -- Recipe: Piece Bone Breastplate
(21117, 57, 122, 208, 0, 700000), -- Adena
(21117, 38, 1, 1, 1, 1974.358375), -- Low Boots
(21117, 50, 1, 1, 1, 1974.358375), -- Leather Gloves
(21117, 1925, 1, 1, 1, 33726.28325), -- Leather Gloves Lining
(21117, 1868, 1, 1, 2, 102863.877013), -- Thread
(21117, 1873, 1, 1, 2, 20572.748658), -- Silver Nugget
(21117, 2139, 1, 1, 2, 10286.374329), -- Recipe: Steel Mold
-- Baar Dre Vanul
(21118, 1924, 1, 1, -1, 88910), -- Leather Helmet Design
(21118, 1801, 1, 1, -1, 138851), -- Recipe: Piece Bone Gaiters
(21118, 1925, 1, 1, -1, 180734), -- Leather Gloves Lining
(21118, 57, 127, 221, 0, 700000), -- Adena
(21118, 945, 1, 1, 1, 3083.9274), -- Skeleton Buckler
(21118, 102, 1, 1, 1, 1488.409235), -- Round Shield
(21118, 44, 1, 1, 1, 1041.116045), -- Leather Helmet
(21118, 1924, 1, 1, 1, 13131.54732), -- Leather Helmet Design
(21118, 1869, 1, 1, 2, 32565.57206), -- Iron Ore
(21118, 1864, 1, 1, 2, 65131.03394), -- Stem
(21118, 1880, 1, 1, 2, 3256.59026), -- Steel
(21118, 2142, 1, 1, 2, 6513.07034), -- Recipe: Varnish of Purity
(21118, 6035, 1, 1, 2, 2713.7334), -- Magic Haste Potion
-- Hobgoblin
(21119, 1868, 1, 1, -1, 683443), -- Thread
(21119, 1873, 1, 1, -1, 136689), -- Silver Nugget
(21119, 1898, 1, 1, -1, 35102), -- Blue Diamond Necklace Gem
(21119, 57, 156, 278, 0, 700000), -- Adena
(21119, 27, 1, 1, 1, 355.418392), -- Hard Leather Shirt
(21119, 1927, 1, 1, 1, 4026.225584), -- Hard Leather Shirt Pattern
(21119, 33, 1, 1, 1, 570.265216), -- Hard Leather Gaiters
(21119, 1929, 1, 1, 1, 6512.090808), -- Hard Leather Gaiters Material
(21119, 1868, 1, 1, 2, 201878.252582), -- Thread
(21119, 1873, 1, 1, 2, 40375.747418), -- Silver Nugget
-- Kasha Imp Turen
(21120, 1804, 1, 1, -1, 17582), -- Recipe: Soulshot (D-Grade)
(21120, 1926, 1, 1, -1, 44399), -- Piece Bone Breastplate Fragment
(21120, 2151, 1, 1, -1, 122437), -- Recipe: Necklace of Devotion
(21120, 57, 199, 358, 0, 700000), -- Adena
(21120, 87, 1, 1, 1, 69.03532), -- Iron Hammer
(21120, 2014, 1, 1, 1, 745.894993), -- Iron Hammer Head
(21120, 155, 1, 1, 1, 69.03532), -- Flanged Mace
(21120, 177, 1, 1, 1, 69.034367), -- Mage Staff
(21120, 1867, 1, 1, 2, 86557.26612), -- Animal Skin
(21120, 1872, 1, 1, 2, 86557.26612), -- Animal Bone
(21120, 1882, 1, 1, 2, 14426.305584), -- Leather
(21120, 2255, 1, 1, 2, 1587.162176), -- Recipe: Saber
-- Kasha Dire Wolf
(21121, 1927, 1, 1, -1, 30770), -- Hard Leather Shirt Pattern
(21121, 1881, 1, 1, -1, 51428), -- Coarse Bone Powder
(21121, 1875, 1, 1, -1, 25714), -- Stone of Purity
(21121, 57, 177, 312, 0, 700000), -- Adena
(21121, 257, 1, 1, 1, 242), -- Viper Fang
(21121, 1872, 1, 1, 2, 75954.797064), -- Animal Bone
(21121, 1867, 1, 1, 2, 75954.797064), -- Animal Skin
(21121, 1881, 1, 1, 2, 7595.511886), -- Coarse Bone Powder
(21121, 2258, 1, 1, 2, 1392.893986), -- Recipe: Temptation of Abyss
-- Kasha Bugbear
(21122, 1928, 1, 1, -1, 59341), -- Piece Bone Gaiters Fragment
(21122, 2176, 1, 1, -1, 194917), -- Recipe: Leather Boots
(21122, 1929, 1, 1, -1, 52565), -- Hard Leather Gaiters Material
(21122, 57, 181, 334, 0, 700000), -- Adena
(21122, 273, 1, 1, 1, 128.001588), -- Composite Bow
(21122, 2016, 1, 1, 1, 1409.998412), -- Composite Bow Shaft
(21122, 1873, 1, 1, 2, 32088.769028), -- Silver Nugget
(21122, 1868, 1, 1, 2, 160444.236624), -- Thread
(21122, 5268, 1, 1, 2, 3208.994348), -- Recipe: Greater Soulshot (D) Compressed Package (100%)
-- Baar Dre Vanul Destroyer
(21123, 2152, 1, 1, -1, 94359), -- Recipe: Enchanted Necklace
(21123, 1899, 1, 1, -1, 83743), -- Necklace of Devotion Chain
(21123, 1874, 1, 1, -1, 35730), -- Oriharukon Ore
(21123, 57, 236, 442, 0, 700000), -- Adena
(21123, 220, 1, 1, 1, 191), -- Crafted Dagger
(21123, 1874, 1, 1, 2, 5013.3), -- Oriharukon Ore
(21123, 1878, 1, 1, 2, 30079.8), -- Braided Hemp
(21123, 5220, 1, 1, 2, 3007.98), -- Metal Hardener
(21123, 2178, 1, 1, 2, 12031.92), -- Recipe: Dark Stockings
-- Red Eye Barbed Bat
(21124, 1865, 1, 1, -1, 253256), -- Varnish
(21124, 735, 1, 1, -1, 21105), -- Alacrity Potion
(21124, 1897, 1, 1, -1, 60299), -- Necklace of Wisdom Chain
(21124, 57, 121, 200, 0, 700000), -- Adena
(21124, 309, 1, 1, 1, 142.5), -- Tears of Eva
(21124, 310, 1, 1, 1, 142.5), -- Relic of the Saints
(21124, 1865, 1, 1, 2, 37403.909768), -- Varnish
(21124, 1870, 1, 1, 2, 37403.909768), -- Coal
(21124, 1879, 1, 1, 2, 6234.015896), -- Cokes
(21124, 1800, 1, 1, 2, 11762.164568), -- Recipe: Piece Bone Breastplate
-- Northern Trimden
(21125, 1800, 1, 1, -1, 82944), -- Recipe: Piece Bone Breastplate
(21125, 1924, 1, 1, -1, 85085), -- Leather Helmet Design
(21125, 1801, 1, 1, -1, 132878), -- Recipe: Piece Bone Gaiters
(21125, 57, 124, 211, 0, 700000), -- Adena
(21125, 15, 1, 1, 1, 148.419486), -- Short Spear
(21125, 2011, 1, 1, 1, 1777.580514), -- Short Spear Edge
(21125, 1866, 1, 1, 2, 25970.50349), -- Suede
(21125, 1871, 1, 1, 2, 38955.71563), -- Charcoal
(21125, 2140, 1, 1, 2, 7791.17481), -- Recipe: High-Grade Suede
(21125, 734, 1, 1, 2, 6492.60607), -- Haste Potion
-- Kerope Werewolf
(21126, 1925, 1, 1, -1, 177190), -- Leather Gloves Lining
(21126, 1864, 1, 1, -1, 540431), -- Stem
(21126, 1865, 1, 1, -1, 270215), -- Varnish
(21126, 57, 125, 217, 0, 700000), -- Adena
(21126, 24, 1, 1, 1, 511.60535), -- Bone Breastplate
(21126, 390, 1, 1, 1, 511.60535), -- Cotton Shirt
(21126, 31, 1, 1, 1, 816.89465), -- Bone Gaiters
(21126, 412, 1, 1, 1, 816.89465), -- Cotton Pants
(21126, 1864, 1, 1, 2, 53211.71277), -- Stem
(21126, 1865, 1, 1, 2, 26605.77302), -- Varnish
(21126, 1866, 1, 1, 2, 17737.23759), -- Suede
(21126, 1873, 1, 1, 2, 10642.3759), -- Silver Nugget
(21126, 1868, 1, 1, 2, 53211.71277), -- Thread
(21126, 2143, 1, 1, 2, 5321.18795), -- Recipe: Synthetic Cokes
-- Northern Goblin
(21127, 1898, 1, 1, -1, 35102), -- Blue Diamond Necklace Gem
(21127, 1804, 1, 1, -1, 13669), -- Recipe: Soulshot (D-Grade)
(21127, 1926, 1, 1, -1, 34517), -- Piece Bone Breastplate Fragment
(21127, 57, 156, 278, 0, 700000), -- Adena
(21127, 25, 1, 1, 1, 274.899912), -- Piece Bone Breastplate
(21127, 1926, 1, 1, 1, 3398.782366), -- Piece Bone Breastplate Fragment
(21127, 26, 1, 1, 1, 177.939972), -- Bronze Breastplate
(21127, 32, 1, 1, 1, 439.845546), -- Piece Bone Gaiters
(21127, 1928, 1, 1, 1, 4901.377096), -- Piece Bone Gaiters Fragment
(21127, 34, 1, 1, 1, 285.155108), -- Bronze Gaiters
(21127, 1868, 1, 1, 2, 100939.016913), -- Thread
(21127, 1873, 1, 1, 2, 20187.859139), -- Silver Nugget
(21127, 2151, 1, 1, 2, 14058.418696), -- Recipe: Necklace of Devotion
(21127, 6035, 1, 1, 2, 4205.705252), -- Magic Haste Potion
-- Spine Golem
(21128, 2151, 1, 1, -1, 100871), -- Recipe: Necklace of Devotion
(21128, 1927, 1, 1, -1, 28889), -- Hard Leather Shirt Pattern
(21128, 1869, 1, 1, -1, 362125), -- Iron Ore
(21128, 57, 164, 295, 0, 700000), -- Adena
(21128, 1102, 1, 1, 1, 753.305976), -- Tunic of Magic
(21128, 1105, 1, 1, 1, 1208.694024), -- Stockings of Magic
(21128, 1869, 1, 1, 2, 35655.47904), -- Iron Ore
(21128, 1870, 1, 1, 2, 35655.47904), -- Coal
(21128, 1871, 1, 1, 2, 35655.47904), -- Charcoal
(21128, 1872, 1, 1, 2, 47540.70636), -- Animal Bone
(21128, 1867, 1, 1, 2, 47540.70636), -- Animal Skin
(21128, 2256, 1, 1, 2, 872.15016), -- Recipe: Assassin Knife
-- Kerope Werewolf Chief
(21129, 1870, 1, 1, -1, 385707), -- Coal
(21129, 1928, 1, 1, -1, 56185), -- Piece Bone Gaiters Fragment
(21129, 2176, 1, 1, -1, 184549), -- Recipe: Leather Boots
(21129, 57, 177, 312, 0, 700000), -- Adena
(21129, 846, 1, 1, 1, 926.265102), -- Coral Earring
(21129, 909, 1, 1, 1, 694.701042), -- Blue Diamond Necklace
(21129, 1898, 1, 1, 1, 5851.62291), -- Blue Diamond Necklace Gem
(21129, 878, 1, 1, 1, 1389.410946), -- Blue Coral Ring
(21129, 1870, 1, 1, 2, 56966.137764), -- Coal
(21129, 1865, 1, 1, 2, 56966.137764), -- Varnish
(21129, 3032, 1, 1, 2, 2278.606804), -- Recipe: Spiritshot D
(21129, 6035, 1, 1, 2, 4747.117668), -- Magic Haste Potion
-- Northern Goblin Leader
(21130, 1929, 1, 1, -1, 52565), -- Hard Leather Gaiters Material
(21130, 2177, 1, 1, -1, 130152), -- Recipe: Bone Helmet
(21130, 1930, 1, 1, -1, 104455), -- Boot Lining
(21130, 57, 181, 334, 0, 700000), -- Adena
(21130, 39, 1, 1, 1, 1688.908752), -- Boots
(21130, 1930, 1, 1, 1, 20570.158548), -- Boot Lining
(21130, 51, 1, 1, 1, 1688.9327), -- Bracer
(21130, 1871, 1, 1, 2, 60166.567296), -- Charcoal
(21130, 1866, 1, 1, 2, 40111.044864), -- Suede
(21130, 5273, 1, 1, 2, 2406.626624), -- Recipe: Greater Spiritshot (D) Compressed Package(100%)
(21130, 734, 1, 1, 2, 10027.761216), -- Haste Potion
-- Enchanted Spine Golem
(21131, 1872, 1, 1, -1, 559583), -- Animal Bone
(21131, 1867, 1, 1, -1, 559583), -- Animal Skin
(21131, 1899, 1, 1, -1, 65576), -- Necklace of Devotion Chain
(21131, 57, 185, 346, 0, 700000), -- Adena
(21131, 626, 1, 1, 1, 929.141052), -- Bronze Shield
(21131, 45, 1, 1, 1, 651.553071), -- Bone Helmet
(21131, 1932, 1, 1, 1, 12462.305877), -- Bone Helmet Design
(21131, 1872, 1, 1, 2, 62811.194194), -- Animal Bone
(21131, 1867, 1, 1, 2, 62811.194194), -- Animal Skin
(21131, 1881, 1, 1, 2, 6281.133278), -- Coarse Bone Powder
(21131, 1875, 1, 1, 2, 3140.497346), -- Stone of Purity
(21131, 2180, 1, 1, 2, 3541.980988), -- Recipe: Scale Mail
-- Underground Kobold
(21132, 2179, 1, 1, -1, 159246), -- Recipe: Crafted Leather Gloves
(21132, 1898, 1, 1, -1, 34188), -- Blue Diamond Necklace Gem
(21132, 2255, 1, 1, -1, 8137), -- Recipe: Saber
(21132, 57, 148, 273, 0, 700000), -- Adena
(21132, 68, 1, 1, 1, 104.5), -- Falchion
(21132, 5284, 1, 1, 1, 104.5), -- Zweihander
(21132, 1873, 1, 1, 2, 26216.32528), -- Silver Nugget
(21132, 1868, 1, 1, 2, 131081.94624), -- Thread
(21132, 5278, 1, 1, 2, 2621.72848), -- Recipe: Greater Blessed Spiritshot (D) Compressed Package(100%)
-- Dead Pit Skeleton Archer
(21133, 1899, 1, 1, -1, 56286), -- Necklace of Devotion Chain
(21133, 1878, 1, 1, -1, 144093), -- Braided Hemp
(21133, 1864, 1, 1, -1, 720463), -- Stem
(21133, 57, 159, 297, 0, 700000), -- Adena
(21133, 156, 1, 1, 1, 42.666624), -- Hand Axe
(21133, 167, 1, 1, 1, 42.666624), -- Scalpel
(21133, 178, 1, 1, 1, 42.666752), -- Bone Staff
(21133, 1864, 1, 1, 2, 80869.217263), -- Stem
(21133, 1869, 1, 1, 2, 40434.525616), -- Iron Ore
(21133, 1878, 1, 1, 2, 16173.909865), -- Braided Hemp
(21133, 2181, 1, 1, 2, 4047.503718), -- Recipe: White Tunic
(21133, 1061, 1, 1, 2, 24505.843538), -- Greater Healing Potion
-- Dead Pit Spartoi
(21134, 1931, 1, 1, -1, 49119), -- Leather Boots Lining
(21134, 2152, 1, 1, -1, 66155), -- Recipe: Enchanted Necklace
(21134, 1932, 1, 1, -1, 59645), -- Bone Helmet Design
(21134, 57, 163, 312, 0, 700000), -- Adena
(21134, 258, 1, 1, 1, 134), -- Bagh-Nakh
(21134, 1865, 1, 1, 2, 42177.743988), -- Varnish
(21134, 1870, 1, 1, 2, 42177.743988), -- Coal
(21134, 1879, 1, 1, 2, 7029.671424), -- Cokes
(21134, 1875, 1, 1, 2, 2811.88754), -- Stone of Purity
(21134, 2259, 1, 1, 2, 654.95306), -- Recipe: Spinebone Sword
-- Underground Kobold Warrior
(21135, 2178, 1, 1, -1, 73236), -- Recipe: Dark Stockings
(21135, 1934, 1, 1, -1, 59833), -- Crafted Leather Gloves Lining
(21135, 5220, 1, 1, -1, 18309), -- Metal Hardener
(21135, 57, 198, 381, 0, 700000), -- Adena
(21135, 274, 1, 1, 1, 163), -- Reinforced Bow
(21135, 1866, 1, 1, 2, 34251.808304), -- Suede
(21135, 1871, 1, 1, 2, 51377.80522), -- Charcoal
(21135, 5220, 1, 1, 2, 2055.093656), -- Metal Hardener
(21135, 1885, 1, 1, 2, 4281.52242), -- High-Grade Suede
(21135, 2261, 1, 1, 2, 797.7704), -- Recipe: Conjuror's Staff
-- Dead Pit Horror
(21136, 1882, 1, 1, -1, 89848), -- Leather
(21136, 2017, 1, 1, -1, 5373), -- Saber Blade
(21136, 2180, 1, 1, -1, 30400), -- Recipe: Scale Mail
(21136, 57, 173, 339, 0, 700000), -- Adena
(21136, 220, 1, 1, 1, 144), -- Crafted Dagger
(21136, 1867, 1, 1, 2, 60510.58416), -- Animal Skin
(21136, 1872, 1, 1, 2, 60510.58416), -- Animal Bone
(21136, 1882, 1, 1, 2, 10085.034186), -- Leather
(21136, 2152, 1, 1, 2, 7990.057998), -- Recipe: Enchanted Necklace
(21136, 1834, 1, 1, 2, 50425.739496), -- Emergency Dressing
-- Iron Ore Golem
(21137, 1900, 1, 1, -1, 47223), -- Enchanted Necklace Chain
(21137, 2153, 1, 1, -1, 67126), -- Recipe: Tiger's Eye Earring
(21137, 1933, 1, 1, -1, 50779), -- Dark Stockings Fabric
(21137, 57, 183, 362, 0, 700000), -- Adena
(21137, 315, 1, 1, 1, 95), -- Divine Tome
(21137, 1868, 1, 1, 2, 78621.401316), -- Thread
(21137, 1873, 1, 1, 2, 15724.258983), -- Silver Nugget
(21137, 5549, 1, 1, 2, 3931.091346), -- Metallic Thread
(21137, 1889, 1, 1, 2, 2620.763031), -- Compound Braid
(21137, 737, 1, 1, 2, 3931.091346), -- Scroll of Resurrection
(21137, 6387, 1, 1, 2, 1572.393978), -- Blessed Scroll of Resurrection for Pets
-- Greedy Geist
(21138, 1869, 1, 1, -1, 460180), -- Iron Ore
(21138, 1864, 1, 1, -1, 920360), -- Stem
(21138, 956, 1, 1, -1, 15339), -- Scroll: Enchant Armor (D-Grade)
(21138, 57, 194, 388, 0, 700000), -- Adena
(21138, 292, 1, 1, 1, 102), -- Pike
(21138, 1869, 1, 1, 2, 41911.791592), -- Iron Ore
(21138, 1864, 1, 1, 2, 83823.870141); -- Stem

INSERT INTO `droplist` VALUES
(21138, 1880, 1, 1, 2, 4191.293942), -- Steel
(21138, 5550, 1, 1, 2, 558.705279), -- Durable Metal Plate
(21138, 1829, 1, 1, 2, 16764.888811), -- Scroll of Escape: Clan Hall
(21138, 1341, 10, 30, 2, 139706.450235), -- Bone Arrow
-- Catacomb Barbed Bat
(21139, 1898, 1, 1, -1, 96575), -- Blue Diamond Necklace Gem
(21139, 1804, 1, 1, -1, 37606), -- Recipe: Soulshot (D-Grade)
(21139, 1926, 1, 1, -1, 94966), -- Piece Bone Breastplate Fragment
(21139, 57, 430, 759, 0, 700000), -- Adena
(21139, 27, 1, 1, 1, 977.83462), -- Hard Leather Shirt
(21139, 1927, 1, 1, 1, 11077.03724), -- Hard Leather Shirt Pattern
(21139, 33, 1, 1, 1, 1568.92576), -- Hard Leather Gaiters
(21139, 1929, 1, 1, 1, 17916.20238), -- Hard Leather Gaiters Material
(21139, 1870, 1, 1, 2, 185139.186064), -- Coal
(21139, 1865, 1, 1, 2, 185139.186064), -- Varnish
(21139, 3953, 1, 1, 2, 7405.627872), -- Recipe: Blessed Spiritshot D
-- Catacomb Wisp
(21140, 2152, 1, 1, -1, 193505), -- Recipe: Enchanted Necklace
(21140, 1899, 1, 1, -1, 171735), -- Necklace of Devotion Chain
(21140, 1871, 1, 3, -1, 549553), -- Charcoal
(21140, 57, 477, 911, 0, 700000), -- Adena
(21140, 347, 1, 1, 1, 960.693069), -- Ring Mail Breastplate
(21140, 376, 1, 1, 1, 1538.306931), -- Iron Plate Gaiters
(21140, 1871, 1, 1, 2, 154212.99259), -- Charcoal
(21140, 1866, 1, 1, 2, 102808.750255), -- Suede
(21140, 1877, 1, 1, 2, 6168.47721), -- Adamantite Nugget
(21140, 2260, 1, 1, 2, 2394.779945), -- Recipe: Mace of Judgment
-- Catacomb Serpent
(21141, 1881, 1, 1, -1, 169543), -- Coarse Bone Powder
(21141, 1931, 1, 1, -1, 166219), -- Leather Boots Lining
(21141, 2178, 1, 1, -1, 203452), -- Recipe: Dark Stockings
(21141, 57, 545, 1067, 0, 700000), -- Adena
(21141, 432, 1, 1, 1, 1480.781988), -- Cursed Tunic
(21141, 465, 1, 1, 1, 2371.218012), -- Cursed Stockings
(21141, 1872, 1, 1, 2, 190305.884826), -- Animal Bone
(21141, 1867, 1, 1, 2, 190305.884826), -- Animal Skin
(21141, 1881, 1, 1, 2, 19030.631682), -- Coarse Bone Powder
(21141, 1875, 1, 1, 2, 9515.099844), -- Stone of Purity
(21141, 2178, 1, 1, 2, 22836.498822), -- Recipe: Dark Stockings
-- Grave Keeper Spartoi
(21142, 1900, 1, 1, -1, 138128), -- Enchanted Necklace Chain
(21142, 2153, 1, 1, -1, 196344), -- Recipe: Tiger's Eye Earring
(21142, 1933, 1, 1, -1, 148528), -- Dark Stockings Fabric
(21142, 57, 535, 1059, 0, 700000), -- Adena
(21142, 848, 1, 1, 1, 1051.697156), -- Enchanted Earring
(21142, 911, 1, 1, 1, 789.363658), -- Enchanted Necklace
(21142, 1900, 1, 1, 1, 18870.577948), -- Enchanted Necklace Chain
(21142, 879, 1, 1, 1, 1582.361238), -- Enchanted Ring
(21142, 1873, 1, 1, 2, 68990.39847), -- Silver Nugget
(21142, 1868, 1, 1, 2, 344951.543223), -- Thread
(21142, 1876, 1, 1, 2, 34495.199235), -- Mithril Ore
(21142, 955, 1, 1, 2, 689.859072), -- Scroll: Enchant Weapon (D-Grade)
-- Catacomb Scavenger Bat
(21143, 955, 1, 1, -1, 5610), -- Scroll: Enchant Weapon (D-Grade)
(21143, 1875, 1, 1, -1, 93494), -- Stone of Purity
(21143, 1872, 1, 3, -1, 934937), -- Animal Bone
(21143, 57, 593, 1182, 0, 700000), -- Adena
(21143, 1123, 1, 1, 1, 2993.5), -- Blue Buckskin Boots
(21143, 605, 1, 1, 1, 2993.5), -- Leather Gauntlets
(21143, 1872, 1, 1, 2, 170302.636242), -- Animal Bone
(21143, 1867, 1, 1, 2, 170302.636242), -- Animal Skin
(21143, 1881, 1, 1, 2, 17030.386242), -- Coarse Bone Powder
(21143, 1875, 1, 1, 2, 8514.988758), -- Stone of Purity
(21143, 2250, 1, 1, 2, 31931.71875), -- Recipe: Bone Arrow
(21143, 6035, 1, 1, 2, 10643.633766), -- Magic Haste Potion
-- Catacomb Shadow
(21144, 1901, 1, 1, -1, 229413), -- Tiger's Eye Earring Stone
(21144, 2154, 1, 1, -1, 177832), -- Recipe: Elven Earring
(21144, 1938, 1, 1, -1, 111661), -- Mithril Banded Mail Material
(21144, 57, 702, 1399, 0, 700000), -- Adena
(21144, 628, 1, 1, 1, 2153.960333), -- Hoplon
(21144, 47, 1, 1, 1, 1507.039667), -- Helmet
(21144, 1865, 1, 1, 2, 126159.284034), -- Varnish
(21144, 1870, 1, 1, 2, 126159.284034), -- Coal
(21144, 1879, 1, 1, 2, 21026.397938), -- Cokes
(21144, 1875, 1, 1, 2, 8410.678696), -- Stone of Purity
(21144, 2187, 1, 1, 2, 5632.118898), -- Recipe: Manticore Skin Shirt
(21144, 8317, 1, 1, 2, 901.186832), -- Recipe: Titan Hammer (100%)
(21144, 6035, 1, 1, 2, 10513.049568), -- Magic Haste Potion
-- Catacomb Stakato Soldier
(21145, 1825, 1, 1, -1, 150797), -- Recipe: Oriharukon
(21145, 1902, 1, 1, -1, 213897), -- Elven Earring Beads
(21145, 1885, 1, 1, -1, 175930), -- High-Grade Suede
(21145, 57, 893, 1781, 0, 700000), -- Adena
(21145, 129, 1, 1, 1, 101.61644), -- Sword of Revolution
(21145, 2034, 1, 1, 1, 5765.38356), -- Sword of Revolution Blade
(21145, 1866, 1, 1, 2, 103934.33472), -- Suede
(21145, 1871, 1, 1, 2, 155901.97664), -- Charcoal
(21145, 5220, 1, 1, 2, 6236.19296), -- Metal Hardener
(21145, 1885, 1, 1, 2, 12992.02912), -- High-Grade Suede
(21145, 2146, 1, 1, 2, 11136.02496), -- Recipe: Artisan's frame
(21145, 5473, 1, 1, 2, 11136.02496), -- Recipe: Durable Metal Plate(100%)
(21145, 1832, 1, 1, 2, 173223.41664), -- Greater Antidote
-- Grave Keeper Dark Horror
(21146, 1894, 1, 1, -1, 79948), -- Crafted Leather
(21146, 1903, 1, 1, -1, 380070), -- Elven Ring Piece
(21146, 2145, 1, 1, -1, 162751), -- Recipe: Mithril Alloy
(21146, 57, 951, 1898, 0, 700000), -- Adena
(21146, 88, 1, 1, 1, 21.934692), -- Morning Star
(21146, 2031, 1, 1, 1, 1192.248369), -- Morning Star Head
(21146, 90, 1, 1, 1, 21.934692), -- Goat Head Staff
(21146, 2032, 1, 1, 1, 1088.350965), -- Goat Head Staff Head
(21146, 158, 1, 1, 1, 21.934692), -- Tarbar
(21146, 2035, 1, 1, 1, 1192.248369), -- Tarbar Head
(21146, 169, 1, 1, 1, 21.934692), -- Skull Breaker
(21146, 2036, 1, 1, 1, 1192.248369), -- Skull Breaker Head
(21146, 172, 1, 1, 1, 21.934692), -- Heavy Bone Club
(21146, 2037, 1, 1, 1, 1192.230468), -- Heavy Bone Club Head
(21146, 1872, 1, 1, 2, 224346.478044), -- Animal Bone
(21146, 1867, 1, 1, 2, 224346.478044), -- Animal Skin
(21146, 1881, 1, 1, 2, 22434.449076), -- Coarse Bone Powder
(21146, 1875, 1, 1, 2, 11217.224538), -- Stone of Purity
(21146, 1805, 1, 1, 2, 560.910909), -- Recipe: Soulshot (C-Grade)
(21146, 2990, 1, 1, 2, 13354.051659), -- Recipe: Chain Boots
(21146, 5164, 1, 1, 2, 561.40773), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
-- Catacomb Gargoyle
(21147, 1905, 1, 1, -1, 273798), -- Omen Beast's Eye Earring Gemstone
(21147, 1805, 1, 1, -1, 9382), -- Recipe: Soulshot (C-Grade)
(21147, 1906, 1, 1, -1, 386892), -- Mithril Ring Wire
(21147, 57, 1113, 2260, 0, 700000), -- Adena
(21147, 262, 1, 1, 1, 101.8973), -- Scallop Jamadhr
(21147, 2053, 1, 1, 1, 5843.1027), -- Scallop Jamadhr Edge
(21147, 1868, 1, 3, 2, 235563.65775), -- Thread
(21147, 1873, 1, 1, 2, 94225.4631), -- Silver Nugget
(21147, 5549, 1, 1, 2, 23556.555784), -- Metallic Thread
(21147, 1889, 1, 1, 2, 15704.24385), -- Compound Braid
(21147, 2199, 1, 1, 2, 9939.37079), -- Recipe: Karmian Stockings
(21147, 2301, 1, 1, 2, 1028.708726), -- Recipe: Battle Axe
-- Catacomb Liviona
(21148, 1880, 1, 1, -1, 279242), -- Steel
(21148, 5550, 1, 1, -1, 37232), -- Durable Metal Plate
(21148, 1869, 1, 5, -1, 930808), -- Iron Ore
(21148, 57, 1099, 2253, 0, 700000), -- Adena
(21148, 281, 1, 1, 1, 74.867985), -- Crystallized Ice Bow
(21148, 2074, 1, 1, 1, 4674.132015), -- Crystallized Ice Bow Shaft
(21148, 1869, 1, 1, 2, 119976.49755), -- Iron Ore
(21148, 1864, 1, 3, 2, 119976.49755), -- Stem
(21148, 1880, 1, 1, 2, 11997.826204), -- Steel
(21148, 5550, 1, 1, 2, 1599.686634), -- Durable Metal Plate
(21148, 2163, 1, 1, 2, 6121.368708), -- Recipe: Earring of Protection
(21148, 6037, 1, 3, 2, 79984.3317), -- Waking Scroll
(21148, 2217, 1, 1, 2, 7099.249066), -- Recipe: Knight's Shield
(21148, 8723, 1, 1, 2, 4799.059902), -- Life Stone - Level 46
(21148, 8733, 1, 1, 2, 1199.8532), -- Mid-Grade Life Stone - Level 46
(21148, 8743, 1, 1, 2, 119.98532), -- High-Grade Life Stone - Level 46
(21148, 8753, 1, 1, 2, 23.644166), -- Top-Grade Life Stone - Level 46
-- Decayed Ancient Pikeman
(21149, 1908, 1, 1, -1, 305158), -- Moonstone Earring Wire
(21149, 2163, 1, 1, -1, 164412), -- Recipe: Earring of Protection
(21149, 1909, 1, 1, -1, 435175), -- Aquastone Ring Wire
(21149, 57, 1269, 2596, 0, 700000), -- Adena
(21149, 226, 1, 1, 1, 43.194719), -- Cursed Dagger
(21149, 2070, 1, 1, 1, 3023.305281), -- Cursed Dagger Blade
(21149, 232, 1, 1, 1, 43.194719), -- Dark Elven Dagger
(21149, 2072, 1, 1, 1, 3023.305281), -- Dark Elven Dagger Edge
(21149, 1873, 1, 1, 2, 55381.38858), -- Silver Nugget
(21149, 1868, 1, 1, 2, 276907.35736), -- Thread
(21149, 1876, 1, 1, 2, 27690.90152), -- Mithril Ore
(21149, 1895, 1, 1, 2, 39558.1347), -- Metallic Fiber
(21149, 4042, 1, 1, 2, 2307.71328), -- Enria
(21149, 2215, 1, 1, 2, 1763.94176), -- Recipe: Robe of Seal
(21149, 2228, 1, 1, 2, 3762.46788), -- Recipe: Shining Circlet
(21149, 8723, 1, 1, 2, 5538.01452), -- Life Stone - Level 46
(21149, 8733, 1, 1, 2, 1384.71086), -- Mid-Grade Life Stone - Level 46
(21149, 8743, 1, 1, 2, 138.42964), -- High-Grade Life Stone - Level 46
(21149, 8753, 1, 1, 2, 26.9399), -- Top-Grade Life Stone - Level 46
-- Decayed Ancient Soldier
(21150, 2166, 1, 1, -1, 124078), -- Recipe: Earrings of Binding (100%)
(21150, 1911, 1, 1, -1, 272241), -- Earring of Protection Gemstone
(21150, 951, 1, 1, -1, 6655), -- Scroll: Enchant Weapon (C-Grade)
(21150, 57, 1445, 2946, 0, 700000), -- Adena
(21150, 325, 1, 1, 1, 73.39184), -- Horn of Glory
(21150, 2088, 1, 1, 1, 5714.60816), -- Horn of Glory Fragment
(21150, 1871, 1, 1, 2, 124753.040586), -- Charcoal
(21150, 1866, 1, 1, 2, 83168.693724), -- Suede
(21150, 1877, 1, 1, 2, 4990.237038), -- Adamantite Nugget
(21150, 4041, 1, 1, 2, 1084.896864), -- Mold Hardener
(21150, 4040, 1, 1, 2, 2494.878072), -- Mold Lubricant
(21150, 2166, 1, 1, 2, 4228.981836), -- Recipe: Earrings of Binding (100%)
(21150, 3014, 1, 1, 2, 3484.557924), -- Recipe: Full Plate Boots
(21150, 2234, 1, 1, 2, 1859.136204), -- Recipe: Divine Stockings
(21150, 8724, 1, 1, 2, 4158.290418), -- Life Stone - Level 49
(21150, 8734, 1, 1, 2, 1039.692828), -- Mid-Grade Life Stone - Level 49
(21150, 8744, 1, 1, 2, 103.873104), -- High-Grade Life Stone - Level 49
(21150, 8754, 1, 1, 2, 20.678442), -- Top-Grade Life Stone - Level 49
(21150, 1342, 10, 30, 2, 249507.04296), -- Steel Arrow
-- Decayed Ancient Knight
(21151, 4043, 1, 1, -1, 127207), -- Asofe
(21151, 1869, 1, 9, -1, 763245), -- Iron Ore
(21151, 4601, 1, 1, -1, 8480), -- Greater Dye of STR (Str+3 Con-3)
(21151, 57, 1509, 3068, 0, 700000), -- Adena
(21151, 231, 1, 1, 1, 23.879216), -- Grace Dagger
(21151, 2106, 1, 1, 1, 2150.120784), -- Grace Dagger Edge
(21151, 233, 1, 1, 1, 23.879216), -- Dark Screamer
(21151, 2107, 1, 1, 1, 2150.120784), -- Dark Screamer Edge
(21151, 1869, 1, 1, 2, 157815.289722), -- Iron Ore
(21151, 1864, 1, 3, 2, 157815.289722), -- Stem
(21151, 1880, 1, 1, 2, 15781.459536), -- Steel
(21151, 5550, 1, 1, 2, 2104.264041), -- Durable Metal Plate
(21151, 4043, 1, 1, 2, 5260.486512), -- Asofe
(21151, 2169, 1, 1, 2, 2793.071145), -- Recipe: Necklace of Seal
(21151, 8725, 1, 1, 2, 4383.854487), -- Life Stone - Level 52
(21151, 8735, 1, 1, 2, 1096.050417), -- Mid-Grade Life Stone - Level 52
(21151, 8745, 1, 1, 2, 109.709196), -- High-Grade Life Stone - Level 52
(21151, 8755, 1, 1, 2, 21.525222), -- Top-Grade Life Stone - Level 52
-- Purgatory Wisp
(21152, 4600, 1, 1, -1, 13611), -- Greater Dye of WIT (Wit+2 Men-2)
(21152, 1806, 1, 1, -1, 8167), -- Recipe: Soulshot (B-Grade)
(21152, 1920, 1, 1, -1, 139722), -- Necklace of Seal Chain
(21152, 57, 1616, 3283, 0, 700000), -- Adena
(21152, 400, 1, 1, 1, 79.146848), -- Theca Leather Armor
(21152, 1984, 1, 1, 1, 5386.390768), -- Theca Leather Armor Pattern
(21152, 401, 1, 1, 1, 37.470576), -- Drake Leather Armor
(21152, 1987, 1, 1, 1, 3833.636928), -- Drake Leather Armor Texture
(21152, 420, 1, 1, 1, 126.678464), -- Theca Leather Gaiters
(21152, 1985, 1, 1, 1, 8664.676416), -- Theca Leather Gaiters Pattern
(21152, 1873, 1, 1, 2, 50256.959093), -- Silver Nugget
(21152, 1868, 1, 1, 2, 251284.423442), -- Thread
(21152, 1876, 1, 1, 2, 25128.293535), -- Mithril Ore
(21152, 1895, 1, 1, 2, 35897.615339), -- Metallic Fiber
(21152, 4042, 1, 1, 2, 2094.117467), -- Enria
(21152, 1806, 1, 1, 2, 251.115525), -- Recipe: Soulshot (B-Grade)
(21152, 4959, 1, 1, 2, 2420.753661), -- Recipe: Sealed Avadon Boots (60%)
(21152, 4941, 1, 1, 2, 966.515754), -- Recipe: Zubei's Gaiters (60%)
(21152, 8726, 1, 1, 2, 2908.475814), -- Life Stone - Level 55
(21152, 8736, 1, 1, 2, 726.932942), -- Mid-Grade Life Stone - Level 55
(21152, 8746, 1, 1, 2, 72.544485), -- High-Grade Life Stone - Level 55
(21152, 8756, 1, 1, 2, 15.252943), -- Top-Grade Life Stone - Level 55
-- Purgatory Serpent
(21153, 4129, 1, 1, -1, 52277), -- Recipe: Earrings of Black Ore (100%)
(21153, 4049, 1, 1, -1, 253365), -- Adamantite Earring Gemstone
(21153, 947, 1, 1, -1, 1932), -- Scroll: Enchant Weapon (B-Grade)
(21153, 57, 1906, 3892, 0, 700000), -- Adena
(21153, 357, 1, 1, 1, 22.3506), -- Zubei's Breastplate
(21153, 4056, 1, 1, 1, 3229.231244), -- Zubei's Breastplate Part
(21153, 2376, 1, 1, 1, 22.3506), -- Avadon Breastplate
(21153, 4064, 1, 1, 1, 3229.231244), -- Avadon Breastplate Part
(21153, 383, 1, 1, 1, 35.76096), -- Zubei's Gaiters
(21153, 4057, 1, 1, 1, 4990.64064), -- Zubei's Gaiter Material
(21153, 2379, 1, 1, 1, 35.76096), -- Avadon Gaiters
(21153, 4065, 1, 1, 1, 4990.673752), -- Avadon Gaiters Material
(21153, 1894, 1, 1, 2, 4551.275414), -- Crafted Leather
(21153, 4039, 1, 1, 2, 4323.714376), -- Mold Glue
(21153, 4041, 1, 1, 2, 1127.931034), -- Mold Hardener
(21153, 4044, 1, 1, 2, 4323.714376), -- Thons
(21153, 947, 1, 1, 2, 51.884864), -- Scroll: Enchant Weapon (B-Grade)
(21153, 3955, 1, 1, 2, 259.42432), -- Recipe: Blessed Spiritshot B
(21153, 5280, 1, 1, 2, 259.42432), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21153, 8727, 1, 1, 2, 2594.224982), -- Life Stone - Level 58
(21153, 8737, 1, 1, 2, 648.5608), -- Mid-Grade Life Stone - Level 58
(21153, 8747, 1, 1, 2, 64.85608), -- High-Grade Life Stone - Level 58
(21153, 8757, 1, 1, 2, 12.989434), -- Top-Grade Life Stone - Level 58
-- Hell Keeper Medusa
(21154, 4613, 1, 1, -1, 7001), -- Greater Dye of STR (Str+4 Con-4)
(21154, 4614, 1, 1, -1, 7001), -- Greater Dye of STR (Str+4 Dex-4)
(21154, 4049, 1, 1, -1, 266232), -- Adamantite Earring Gemstone
(21154, 57, 2005, 4083, 0, 700000), -- Adena
(21154, 2397, 1, 1, 1, 41.751641), -- Tunic of Zubei
(21154, 4069, 1, 1, 1, 5892.656172), -- Tunic of Zubei Fabric
(21154, 2406, 1, 1, 1, 25.682817), -- Avadon Robe
(21154, 4071, 1, 1, 1, 4527.020643), -- Avadon Robe Fabric
(21154, 2402, 1, 1, 1, 66.810426), -- Stockings of Zubei
(21154, 4070, 1, 1, 1, 8947.078301), -- Stockings of Zubei Fabric
(21154, 1872, 1, 3, 2, 111058.181145), -- Animal Bone
(21154, 1867, 1, 3, 2, 74038.78743), -- Animal Skin
(21154, 1881, 1, 1, 2, 22211.55499), -- Coarse Bone Powder
(21154, 1875, 1, 1, 2, 11105.777495), -- Stone of Purity
(21154, 4041, 1, 1, 2, 1448.49137), -- Mold Hardener
(21154, 948, 1, 1, 2, 416.349875), -- Scroll: Enchant Armor (B-Grade)
(21154, 4162, 1, 1, 2, 691.34389), -- Recipe: Tunic of Doom (100%)
(21154, 5003, 1, 1, 2, 127.139035), -- Recipe: Art of Battle Axe (60%)
(21154, 1832, 1, 1, 2, 185097.37477), -- Greater Antidote
-- Purgatory Conjurer
(21155, 4050, 1, 1, -1, 317155), -- Adamantite Ring Wire
(21155, 4130, 1, 1, -1, 83099), -- Recipe: Ring of Black Ore (100%)
(21155, 4051, 1, 1, -1, 198522), -- Adamantite Necklace Chain
(21155, 57, 2021, 4119, 0, 700000), -- Adena
(21155, 856, 1, 1, 1, 108.180812), -- Adamantite Earring
(21155, 4049, 1, 1, 1, 13217.926624), -- Adamantite Earring Gemstone
(21155, 918, 1, 1, 1, 81.145348), -- Adamantite Necklace
(21155, 4051, 1, 1, 1, 9773.125456), -- Adamantite Necklace Chain
(21155, 887, 1, 1, 1, 162.25174), -- Adamantite Ring
(21155, 4050, 1, 1, 1, 15613.37002), -- Adamantite Ring Wire
(21155, 1895, 1, 1, 2, 43201.079614), -- Metallic Fiber
(21155, 4040, 1, 1, 2, 3024.025004), -- Mold Lubricant
(21155, 4042, 1, 1, 2, 2520.141239), -- Enria
(21155, 4043, 1, 1, 2, 5040.282478), -- Asofe
(21155, 4154, 1, 1, 2, 1789.419478), -- Recipe: Doom Shield (100%)
(21155, 6037, 1, 1, 2, 302406.834884), -- Waking Scroll
(21155, 8728, 1, 1, 2, 2520.141239), -- Life Stone - Level 61
(21155, 8738, 1, 1, 2, 629.945008), -- Mid-Grade Life Stone - Level 61
(21155, 8748, 1, 1, 2, 62.850018), -- High-Grade Life Stone - Level 61
(21155, 8758, 1, 1, 2, 12.281038), -- Top-Grade Life Stone - Level 61
-- Purgatory Shadow
(21156, 4131, 1, 1, -1, 44665), -- Recipe: Necklace of Black Ore (100%)
(21156, 4056, 1, 1, -1, 99436), -- Zubei's Breastplate Part
(21156, 948, 1, 1, -1, 13735), -- Scroll: Enchant Armor (B-Grade)
(21156, 57, 2177, 4415, 0, 700000), -- Adena
(21156, 554, 1, 1, 1, 101.65376), -- Sealed Zubei's Boots
(21156, 4097, 1, 1, 1, 10558.34624), -- Sealed Zubei's Boots Design
(21156, 600, 1, 1, 1, 101.65376), -- Sealed Avadon Boots
(21156, 4098, 1, 1, 1, 10558.34624), -- Sealed Avadon Boots Design
(21156, 612, 1, 1, 1, 101.65376), -- Sealed Zubei's Gauntlets
(21156, 4100, 1, 1, 1, 10558.34624), -- Sealed Zubei's Gauntlets Part
(21156, 2464, 1, 1, 1, 101.65376), -- Sealed Avadon Gloves
(21156, 4073, 1, 1, 1, 10558.34624), -- Sealed Avadon Gloves Part
(21156, 1865, 1, 1, 2, 147526.144134), -- Varnish
(21156, 1870, 1, 1, 2, 147526.144134), -- Coal
(21156, 1879, 1, 1, 2, 24587.617128), -- Cokes
(21156, 1875, 1, 1, 2, 9834.958578), -- Stone of Purity
(21156, 4040, 1, 1, 2, 2950.53171), -- Mold Lubricant
(21156, 4160, 1, 1, 2, 417.973602), -- Recipe: Leather Armor of Doom (100%)
(21156, 8728, 1, 1, 2, 2458.849986), -- Life Stone - Level 61
(21156, 8738, 1, 1, 2, 614.822838), -- Mid-Grade Life Stone - Level 61
(21156, 8748, 1, 1, 2, 61.349874), -- High-Grade Life Stone - Level 61
(21156, 8758, 1, 1, 2, 12.358248), -- Top-Grade Life Stone - Level 61
(21156, 1343, 20, 60, 2, 105375.249768), -- Silver Arrow
-- Purgatory Tarantula
(21157, 5549, 1, 1, -1, 626651), -- Metallic Thread
(21157, 1889, 1, 1, -1, 417768), -- Compound Braid
(21157, 4052, 1, 1, -1, 221863), -- Earring of Black Ore Piece
(21157, 57, 2488, 5032, 0, 700000), -- Adena
(21157, 110, 1, 1, 1, 94.954836), -- Doom Shield
(21157, 4077, 1, 1, 1, 13879.2381), -- Doom Shield Fragment
(21157, 2416, 1, 1, 1, 66.472128), -- Blue Wolf Helmet
(21157, 4088, 1, 1, 1, 11660.431404), -- Blue Wolf Helmet Design
(21157, 2417, 1, 1, 1, 66.472128), -- Doom Helmet
(21157, 4089, 1, 1, 1, 11660.431404), -- Doom Helmet Pattern
(21157, 1868, 1, 3, 2, 154252.604066), -- Thread
(21157, 1873, 1, 1, 2, 61701.234672), -- Silver Nugget
(21157, 5549, 1, 1, 2, 15425.308668), -- Metallic Thread
(21157, 1889, 1, 1, 2, 10283.539112), -- Compound Braid
(21157, 4044, 1, 1, 2, 5141.769556), -- Thons
(21157, 1830, 1, 1, 2, 61701.234672), -- Scroll of Escape: Castle
(21157, 8487, 1, 1, 2, 84.45745), -- Recipe: Destroyer Hammer (60%)
(21157, 8729, 1, 1, 2, 2056.900868), -- Life Stone - Level 64
(21157, 8739, 1, 1, 2, 513.98391), -- Mid-Grade Life Stone - Level 64
(21157, 8749, 1, 1, 2, 51.639698), -- High-Grade Life Stone - Level 64
(21157, 8759, 1, 1, 2, 10.134894), -- Top-Grade Life Stone - Level 64
(21157, 1832, 1, 1, 2, 171391.192434), -- Greater Antidote
-- Hell Keeper Crimson Doll
(21158, 5230, 1, 1, -1, 9462), -- Recipe: Mithril Arrow (100%)
(21158, 4053, 1, 1, -1, 304195), -- Ring of Black Ore Gemstone
(21158, 57, 2798, 5718, 0, 700000), -- Adena
(21158, 2391, 1, 1, 1, 34.741224), -- Blue Wolf Leather Armor
(21158, 4082, 1, 1, 1, 5922.258776), -- Blue Wolf Leather Armor Texture
(21158, 2392, 1, 1, 1, 34.741224), -- Leather Armor of Doom
(21158, 4083, 1, 1, 1, 5922.258776), -- Leather Armor of Doom Design
(21158, 1869, 2, 6, 2, 43672.998096), -- Iron Ore
(21158, 1864, 1, 3, 2, 174691.992384), -- Stem
(21158, 1880, 1, 1, 2, 17469.121392), -- Steel
(21158, 5550, 1, 1, 2, 2329.164288), -- Durable Metal Plate
(21158, 4043, 1, 1, 2, 5822.91072), -- Asofe
(21158, 1830, 1, 1, 2, 69876.8748), -- Scroll of Escape: Castle
(21158, 8487, 1, 1, 2, 95.36184), -- Recipe: Destroyer Hammer (60%)
(21158, 8730, 1, 1, 2, 1941.099984), -- Life Stone - Level 67
(21158, 8740, 1, 1, 2, 485.372304), -- Mid-Grade Life Stone - Level 67
(21158, 8750, 1, 1, 2, 48.654), -- High-Grade Life Stone - Level 67
(21158, 8760, 1, 1, 2, 9.7308), -- Top-Grade Life Stone - Level 67
(21158, 1344, 30, 90, 2, 72788.719392), -- Mithril Arrow
-- Purgatory Gargoyle
(21159, 5478, 1, 1, -1, 61665), -- Sealed Dark Crystal Leather Armor Pattern
(21159, 1874, 1, 1, -1, 488878), -- Oriharukon Ore
(21159, 4043, 1, 1, -1, 244439), -- Asofe
(21159, 57, 2901, 5897, 0, 700000), -- Adena
(21159, 5304, 1, 1, 1, 27.032031), -- Sealed Tallum Tunic
(21159, 5485, 1, 1, 1, 3035.535711), -- Sealed Tallum Tunic Texture
(21159, 5308, 1, 1, 1, 16.628157), -- Sealed Dark Crystal Robe
(21159, 5486, 1, 1, 1, 2136.011553), -- Sealed Dark Crystal Robe Fabric
(21159, 5305, 1, 1, 1, 43.229199), -- Sealed Tallum Stockings
(21159, 5489, 1, 1, 1, 4764.563349), -- Sealed Tallum Stockings Fabric
(21159, 1870, 1, 1, 2, 166623.321557), -- Coal
(21159, 1865, 1, 1, 2, 166623.321557), -- Varnish
(21159, 1874, 1, 1, 2, 11108.283101), -- Oriharukon Ore
(21159, 4043, 1, 1, 2, 5553.910311), -- Asofe
(21159, 4039, 1, 1, 2, 5553.910311), -- Mold Glue
(21159, 3035, 1, 1, 2, 221.98992), -- Recipe: Spiritshot A
(21159, 5281, 1, 1, 2, 221.98992), -- Recipe: Greater Blessed Spiritshot (A) Compressed Package(100%)
(21159, 8326, 1, 1, 2, 61.509707), -- Recipe: Doom Crusher (60%)
(21159, 8730, 1, 1, 2, 1851.303437), -- Life Stone - Level 67
(21159, 8740, 1, 1, 2, 462.941479), -- Mid-Grade Life Stone - Level 67
(21159, 8750, 1, 1, 2, 46.2479), -- High-Grade Life Stone - Level 67
(21159, 8760, 1, 1, 2, 9.24958), -- Top-Grade Life Stone - Level 67
(21159, 1344, 20, 60, 2, 104141.02122), -- Mithril Arrow
-- Purgatory Liviona
(21160, 5479, 1, 1, -1, 36206), -- Sealed Tallum Leather Armor Pattern
(21160, 1807, 1, 1, -1, 8158), -- Recipe: Soulshot (A-Grade)
(21160, 5482, 1, 1, -1, 80760), -- Sealed Dark Crystal Leggings Design
(21160, 57, 3019, 6154, 0, 700000), -- Adena
(21160, 5304, 1, 1, 1, 28.194438), -- Sealed Tallum Tunic
(21160, 5485, 1, 1, 1, 3166.067078), -- Sealed Tallum Tunic Texture
(21160, 5308, 1, 1, 1, 17.343186), -- Sealed Dark Crystal Robe
(21160, 5486, 1, 1, 1, 2227.862394), -- Sealed Dark Crystal Robe Fabric
(21160, 5305, 1, 1, 1, 45.088102), -- Sealed Tallum Stockings
(21160, 5489, 1, 1, 1, 4969.444802), -- Sealed Tallum Stockings Fabric
(21160, 1894, 1, 1, 2, 7206.497034), -- Crafted Leather
(21160, 4039, 1, 1, 2, 6846.237684), -- Mold Glue
(21160, 4041, 1, 1, 2, 1786.01302), -- Mold Hardener
(21160, 4044, 1, 1, 2, 6846.237684), -- Thons
(21160, 1807, 1, 1, 2, 273.797106), -- Recipe: Soulshot (A-Grade)
(21160, 6037, 1, 1, 2, 410775.134396), -- Waking Scroll
(21160, 729, 1, 1, 2, 22.707256), -- Scroll: Enchant Weapon (A-Grade)
(21160, 8730, 1, 1, 2, 2282.079228), -- Life Stone - Level 67
(21160, 8740, 1, 1, 2, 570.738146), -- Mid-Grade Life Stone - Level 67
(21160, 8750, 1, 1, 2, 57.204818), -- High-Grade Life Stone - Level 67
(21160, 8760, 1, 1, 2, 11.353628), -- Top-Grade Life Stone - Level 67
-- Lesser Ancient Soldier
(21161, 3035, 1, 1, -1, 8917), -- Recipe: Spiritshot A
(21161, 5485, 1, 1, -1, 56237), -- Sealed Tallum Tunic Texture
(21161, 4041, 1, 1, -1, 58154), -- Mold Hardener
(21161, 57, 3302, 6724, 0, 700000), -- Adena
(21161, 6324, 1, 1, 1, 81.900233), -- Sealed Phoenix Earring
(21161, 6341, 1, 1, 1, 11382.43141), -- Sealed Phoenix Earring Gemstone
(21161, 6323, 1, 1, 1, 61.416127), -- Sealed Phoenix Necklace
(21161, 6343, 1, 1, 1, 8799.045448), -- Sealed Phoenix Necklace Beads
(21161, 6325, 1, 1, 1, 122.832254), -- Sealed Phoenix Ring
(21161, 6345, 1, 1, 1, 15743.374528), -- Sealed Phoenix Ring Gemstone
(21161, 1871, 1, 1, 2, 224482.756764), -- Charcoal
(21161, 1866, 1, 1, 2, 149655.171176), -- Suede
(21161, 1877, 1, 1, 2, 8979.200342), -- Adamantite Nugget
(21161, 4041, 1, 1, 2, 1952.017144), -- Mold Hardener
(21161, 4040, 1, 1, 2, 4489.796472), -- Mold Lubricant
(21161, 5276, 1, 1, 2, 299.162724), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
(21161, 8326, 1, 1, 2, 83.231624), -- Recipe: Doom Crusher (60%)
(21161, 8731, 1, 1, 2, 2078.434988), -- Life Stone - Level 70
(21161, 8741, 1, 1, 2, 519.805048), -- Mid-Grade Life Stone - Level 70
(21161, 8751, 1, 1, 2, 51.823464), -- High-Grade Life Stone - Level 70
(21161, 8761, 1, 1, 2, 10.600254), -- Top-Grade Life Stone - Level 70
-- Lesser Ancient Scout
(21162, 5486, 1, 1, -1, 39629), -- Sealed Dark Crystal Robe Fabric
(21162, 3956, 1, 1, -1, 8930), -- Recipe: Blessed Spiritshot A
(21162, 5478, 1, 1, -1, 56317), -- Sealed Dark Crystal Leather Armor Pattern
(21162, 57, 3305, 6737, 0, 700000), -- Adena
(21162, 5297, 1, 1, 1, 30.859074), -- Sealed Dark Crystal Leather Armor
(21162, 5478, 1, 1, 1, 3465.289794), -- Sealed Dark Crystal Leather Armor Pattern
(21162, 5301, 1, 1, 1, 18.982278), -- Sealed Tallum Leather Armor
(21162, 5479, 1, 1, 1, 2438.416062), -- Sealed Tallum Leather Armor Pattern
(21162, 5298, 1, 1, 1, 49.349346), -- Sealed Dark Crystal Leggings
(21162, 5482, 1, 1, 1, 5439.103446), -- Sealed Dark Crystal Leggings Design
(21162, 1873, 1, 1, 2, 89921.50128), -- Silver Nugget
(21162, 1868, 1, 3, 2, 224803.7532), -- Thread
(21162, 1876, 1, 1, 2, 44960.75064), -- Mithril Ore
(21162, 1895, 1, 1, 2, 64229.70636), -- Metallic Fiber
(21162, 4042, 1, 1, 2, 3746.80224), -- Enria
(21162, 1807, 1, 1, 2, 299.67408), -- Recipe: Soulshot (A-Grade)
(21162, 8731, 1, 1, 2, 2081.50812), -- Life Stone - Level 70
(21162, 8741, 1, 1, 2, 520.48656), -- Mid-Grade Life Stone - Level 70
(21162, 8751, 1, 1, 2, 52.13628), -- High-Grade Life Stone - Level 70
(21162, 8761, 1, 1, 2, 10.51488), -- Top-Grade Life Stone - Level 70
(21162, 6036, 1, 1, 2, 7493.16636), -- Greater Magic Haste Potion
-- Lesser Ancient Shaman
(21163, 5480, 1, 1, -1, 31860), -- Sealed Leather Armor of Nightmare Fabric
(21163, 5481, 1, 1, -1, 31860), -- Sealed Majestic Leather Armor Fabric
(21163, 729, 1, 1, -1, 789), -- Scroll: Enchant Weapon (A-Grade)
(21163, 57, 3493, 7152, 0, 700000), -- Adena
(21163, 5291, 1, 1, 1, 73.638936), -- Sealed Dark Crystal Boots
(21163, 5496, 1, 1, 1, 7684.361064), -- Sealed Dark Crystal Boots Lining
(21163, 5296, 1, 1, 1, 73.638936), -- Sealed Tallum Boots
(21163, 5497, 1, 1, 1, 7684.361064), -- Sealed Tallum Boots Lining
(21163, 5290, 1, 1, 1, 73.638936), -- Sealed Dark Crystal Gloves
(21163, 5508, 1, 1, 1, 7684.361064), -- Sealed Dark Crystal Gloves Design
(21163, 5295, 1, 1, 1, 73.638936), -- Sealed Tallum Gloves
(21163, 5509, 1, 1, 1, 7684.361064), -- Sealed Tallum Gloves Design
(21163, 1867, 1, 3, 2, 158882.97502), -- Animal Skin
(21163, 1872, 1, 3, 2, 105921.76072), -- Animal Bone
(21163, 1882, 1, 1, 2, 52960.88036), -- Leather
(21163, 1894, 1, 1, 2, 8362.19154), -- Crafted Leather
(21163, 4042, 1, 1, 2, 3972.2163), -- Enria
(21163, 729, 1, 1, 2, 26.38126), -- Scroll: Enchant Weapon (A-Grade)
(21163, 4987, 1, 1, 2, 988.79634), -- Recipe: Tunic of Doom (60%)
(21163, 8731, 1, 1, 2, 2206.67552), -- Life Stone - Level 70
(21163, 8741, 1, 1, 2, 551.66888), -- Mid-Grade Life Stone - Level 70
(21163, 8751, 1, 1, 2, 55.1001), -- High-Grade Life Stone - Level 70
(21163, 8761, 1, 1, 2, 11.35396), -- Top-Grade Life Stone - Level 70
-- Guardian Spirit of Ancient Holy Ground
(21164, 5487, 1, 1, -1, 36693), -- Sealed Robe of Nightmare Fabric
(21164, 5480, 1, 1, -1, 36564), -- Sealed Leather Armor of Nightmare Fabric
(21164, 5481, 1, 1, -1, 36564), -- Sealed Majestic Leather Armor Fabric
(21164, 57, 4018, 8199, 0, 700000), -- Adena
(21164, 6327, 1, 1, 1, 66.949245), -- Sealed Majestic Earring
(21164, 6342, 1, 1, 1, 11359.619315), -- Sealed Majestic Earring Gemstone
(21164, 6326, 1, 1, 1, 50.20312), -- Sealed Majestic Necklace
(21164, 6344, 1, 1, 1, 7351.30209), -- Sealed Majestic Necklace Beads
(21164, 6328, 1, 1, 1, 100.40624), -- Sealed Majestic Ring
(21164, 6346, 1, 1, 1, 16326.51999), -- Sealed Majestic Ring Gemstone
(21164, 1871, 1, 3, 2, 167148.341884), -- Charcoal
(21164, 1866, 1, 1, 2, 222864.594701), -- Suede
(21164, 1877, 1, 1, 2, 13371.8007), -- Adamantite Nugget
(21164, 4041, 1, 1, 2, 2906.804526), -- Mold Hardener
(21164, 4040, 1, 1, 2, 6685.90035), -- Mold Lubricant
(21164, 729, 1, 1, 2, 37.074463), -- Scroll: Enchant Weapon (A-Grade)
(21164, 8732, 1, 1, 2, 2786.000096), -- Life Stone - Level 76
(21164, 8742, 1, 1, 2, 696.500024), -- Mid-Grade Life Stone - Level 76
(21164, 8752, 1, 1, 2, 69.983256), -- High-Grade Life Stone - Level 76
-- Lesser Ancient Warrior
(21165, 5488, 1, 1, -1, 37883), -- Sealed Majestic Robe Fabric
(21165, 5495, 1, 1, -1, 127745), -- Sealed Shield of Nightmare Fragment
(21165, 730, 1, 1, -1, 7011), -- Scroll: Enchant Armor (A-Grade)
(21165, 57, 4147, 8467, 0, 700000), -- Adena
(21165, 5320, 1, 1, 1, 23.520984), -- Sealed Leather Armor of Nightmare
(21165, 5480, 1, 1, 1, 3484.979016), -- Sealed Leather Armor of Nightmare Fabric
(21165, 5323, 1, 1, 1, 23.520984), -- Sealed Majestic Leather Armor
(21165, 5481, 1, 1, 1, 3484.979016), -- Sealed Majestic Leather Armor Fabric
(21165, 1895, 1, 1, 2, 88748.898255), -- Metallic Fiber
(21165, 4040, 1, 1, 2, 6212.613996), -- Mold Lubricant
(21165, 4042, 1, 1, 2, 5177.17833), -- Enria
(21165, 4043, 1, 1, 2, 10353.931953), -- Asofe
(21165, 730, 1, 1, 2, 258.646563), -- Scroll: Enchant Armor (A-Grade)
(21165, 6037, 1, 3, 2, 310620.931539), -- Waking Scroll
(21165, 729, 1, 1, 2, 34.401267), -- Scroll: Enchant Weapon (A-Grade)
(21165, 8732, 1, 1, 2, 2588.589165), -- Life Stone - Level 76
(21165, 8742, 1, 1, 2, 647.253468), -- Mid-Grade Life Stone - Level 76
(21165, 8752, 1, 1, 2, 64.555464), -- High-Grade Life Stone - Level 76
-- Lith Scout
(21166, 1868, 1, 3, -1, 886728), -- Thread
(21166, 1873, 1, 1, -1, 354691), -- Silver Nugget
(21166, 1898, 1, 1, -1, 91087), -- Blue Diamond Necklace Gem
(21166, 6362, 23, 42, 0, 700000), -- Red Seal Stone
(21166, 6360, 53, 109, 1, 700000), -- Blue Seal Stone
(21166, 25, 1, 1, 2, 713.295372), -- Piece Bone Breastplate
(21166, 1926, 1, 1, 2, 8818.976021), -- Piece Bone Breastplate Fragment
(21166, 26, 1, 1, 2, 461.708982), -- Bronze Breastplate
(21166, 32, 1, 1, 2, 1141.287351), -- Piece Bone Gaiters
(21166, 1928, 1, 1, 2, 12717.827276), -- Piece Bone Gaiters Fragment
(21166, 34, 1, 1, 2, 739.904998), -- Bronze Gaiters
(21166, 1868, 1, 3, 3, 130962.642108), -- Thread
(21166, 1873, 1, 1, 3, 52385.256834), -- Silver Nugget
(21166, 2176, 1, 1, 3, 62661.450774), -- Recipe: Leather Boots
(21166, 6037, 1, 3, 3, 87308.650284), -- Waking Scroll
-- Lith Witch
(21167, 1804, 1, 1, -1, 39326), -- Recipe: Soulshot (D-Grade)
(21167, 1926, 1, 1, -1, 99308), -- Piece Bone Breastplate Fragment
(21167, 2151, 1, 1, -1, 273857), -- Recipe: Necklace of Devotion
(21167, 6362, 21, 39, 0, 700000), -- Red Seal Stone
(21167, 6360, 72, 143, 1, 700000), -- Blue Seal Stone
(21167, 1102, 1, 1, 2, 2045.290996), -- Tunic of Magic
(21167, 1105, 1, 1, 2, 3281.709004), -- Stockings of Magic
(21167, 1867, 1, 1, 3, 193604.579046), -- Animal Skin
(21167, 1872, 1, 1, 3, 193604.579046), -- Animal Bone
(21167, 1882, 1, 1, 3, 32267.285982), -- Leather
(21167, 735, 1, 1, 3, 12100.555926), -- Alacrity Potion
-- Lith Warrior
(21168, 1899, 1, 1, -1, 184636), -- Necklace of Devotion Chain
(21168, 5549, 1, 1, -1, 118167), -- Metallic Thread
(21168, 1889, 1, 1, -1, 78778), -- Compound Braid
(21168, 6362, 22, 41, 0, 700000), -- Red Seal Stone
(21168, 6360, 97, 190, 1, 700000), -- Blue Seal Stone
(21168, 847, 1, 1, 2, 1601.894656), -- Red Crescent Earring
(21168, 910, 1, 1, 2, 1201.420992), -- Necklace of Devotion
(21168, 1899, 1, 1, 2, 25905.811256), -- Necklace of Devotion Chain
(21168, 890, 1, 1, 2, 2402.873096), -- Ring of Devotion
(21168, 1868, 1, 3, 3, 110531.493468), -- Thread
(21168, 1873, 1, 1, 3, 44212.518198), -- Silver Nugget
(21168, 5549, 1, 1, 3, 11053.228536), -- Metallic Thread
(21168, 1889, 1, 1, 3, 7368.951006), -- Compound Braid
(21168, 2262, 1, 1, 3, 1716.42591), -- Recipe: Elven Bow
(21168, 6037, 1, 1, 3, 221063.382882), -- Waking Scroll
-- Lith Guard
(21169, 1061, 1, 1, -1, 881783), -- Greater Healing Potion
(21169, 1900, 1, 1, -1, 159184), -- Enchanted Necklace Chain
(21169, 2153, 1, 1, -1, 226274), -- Recipe: Tiger's Eye Earring
(21169, 6362, 24, 44, 0, 700000), -- Red Seal Stone
(21169, 6360, 128, 259, 1, 700000), -- Blue Seal Stone
(21169, 1123, 1, 1, 2, 3105.5), -- Blue Buckskin Boots
(21169, 605, 1, 1, 2, 3105.5), -- Leather Gauntlets
(21169, 1869, 1, 1, 3, 159014.14578), -- Iron Ore
(21169, 1864, 1, 3, 3, 159014.14578), -- Stem
(21169, 1880, 1, 1, 3, 15901.3785), -- Steel
(21169, 5550, 1, 1, 3, 2120.30406), -- Durable Metal Plate
(21169, 2153, 1, 1, 3, 24730.02588), -- Recipe: Tiger's Eye Earring
-- Lith Medium
(21170, 1901, 1, 1, -1, 222980), -- Tiger's Eye Earring Stone
(21170, 2154, 1, 1, -1, 172845), -- Recipe: Elven Earring
(21170, 1938, 1, 1, -1, 108529), -- Mithril Banded Mail Material
(21170, 6362, 22, 41, 0, 700000), -- Red Seal Stone
(21170, 6361, 33, 63, 1, 700000), -- Green Seal Stone
(21170, 6360, 108, 211, 2, 700000), -- Blue Seal Stone
(21170, 628, 1, 1, 3, 2093.359974), -- Hoplon
(21170, 47, 1, 1, 3, 1464.640026), -- Helmet
(21170, 1869, 1, 1, 4, 143058.140368), -- Iron Ore
(21170, 1864, 1, 1, 4, 286116.280736), -- Stem
(21170, 1880, 1, 1, 4, 14305.862064), -- Steel
(21170, 5550, 1, 1, 4, 1907.640384), -- Durable Metal Plate
(21170, 2155, 1, 1, 4, 22962.764864), -- Recipe: Elven Ring
(21170, 6035, 1, 1, 4, 11921.311584), -- Magic Haste Potion
-- Lith Overlord
(21171, 1870, 1, 5, -1, 684631), -- Coal
(21171, 1865, 1, 5, -1, 684631), -- Varnish
(21171, 1939, 1, 1, -1, 180403), -- Mithril Banded Gaiters Material
(21171, 6362, 24, 44, 0, 700000), -- Red Seal Stone
(21171, 6361, 68, 136, 1, 700000), -- Green Seal Stone
(21171, 6360, 96, 192, 2, 700000), -- Blue Seal Stone
(21171, 83, 1, 1, 3, 66.0972), -- Sword of Magic
(21171, 144, 1, 1, 3, 66.0972), -- Sword of Occult
(21171, 124, 1, 1, 3, 48.96528), -- Two-Handed Sword
(21171, 2026, 1, 1, 3, 2190.90729), -- Two-Handed Sword Edge
(21171, 127, 1, 1, 3, 48.96528), -- Crimson Sword
(21171, 130, 1, 1, 3, 48.96775), -- Elven Sword
(21171, 1870, 1, 3, 4, 136504.928575), -- Coal
(21171, 1865, 1, 1, 4, 273009.85715), -- Varnish
(21171, 1874, 1, 1, 4, 18200.502389), -- Oriharukon Ore
(21171, 2191, 1, 1, 4, 36547.711886), -- Recipe: RIP Gauntlets
-- Lith Patrolman
(21172, 1825, 1, 1, -1, 172903), -- Recipe: Oriharukon
(21172, 1902, 1, 1, -1, 245252), -- Elven Earring Beads
(21172, 2145, 1, 1, -1, 172903), -- Recipe: Mithril Alloy
(21172, 6362, 24, 45, 0, 700000), -- Red Seal Stone
(21172, 6361, 105, 206, 1, 700000), -- Green Seal Stone
(21172, 6360, 89, 178, 2, 700000), -- Blue Seal Stone
(21172, 88, 1, 1, 3, 23.302164), -- Morning Star
(21172, 2031, 1, 1, 3, 1266.576573), -- Morning Star Head
(21172, 90, 1, 1, 3, 23.302164), -- Goat Head Staff
(21172, 2032, 1, 1, 3, 1156.201905), -- Goat Head Staff Head
(21172, 158, 1, 1, 3, 23.302164), -- Tarbar
(21172, 2035, 1, 1, 3, 1266.576573), -- Tarbar Head
(21172, 169, 1, 1, 3, 23.302164), -- Skull Breaker
(21172, 2036, 1, 1, 3, 1266.576573), -- Skull Breaker Head
(21172, 172, 1, 1, 3, 23.302164), -- Heavy Bone Club
(21172, 2037, 1, 1, 3, 1266.557556), -- Heavy Bone Club Head
(21172, 1871, 2, 6, 4, 62564.106297), -- Charcoal
(21172, 1866, 1, 1, 4, 166837.616792), -- Suede
(21172, 1877, 1, 1, 4, 10010.225302), -- Adamantite Nugget
(21172, 2147, 1, 1, 4, 17875.572176), -- Recipe: Blacksmith's frame
(21172, 1341, 60, 180, 4, 139031.479433), -- Bone Arrow
-- Lith Shaman
(21173, 1905, 1, 1, -1, 252534), -- Omen Beast's Eye Earring Gemstone
(21173, 1881, 1, 1, -1, 346140), -- Coarse Bone Powder
(21173, 1875, 1, 1, -1, 173070), -- Stone of Purity
(21173, 6362, 22, 41, 0, 700000), -- Red Seal Stone
(21173, 6361, 137, 274, 1, 700000), -- Green Seal Stone
(21173, 6360, 56, 111, 2, 700000), -- Blue Seal Stone
(21173, 262, 1, 1, 3, 93.99576), -- Scallop Jamadhr
(21173, 2053, 1, 1, 3, 5390.00424), -- Scallop Jamadhr Edge
(21173, 1872, 1, 1, 4, 217269.16134), -- Animal Bone
(21173, 1867, 1, 1, 4, 217269.16134), -- Animal Skin
(21173, 1881, 1, 1, 4, 21726.77016), -- Coarse Bone Powder
(21173, 1875, 1, 1, 4, 10863.38508), -- Stone of Purity
(21173, 1805, 1, 1, 4, 543.02328), -- Recipe: Soulshot (C-Grade)
(21173, 2990, 1, 1, 4, 12932.80982), -- Recipe: Chain Boots
(21173, 5164, 1, 1, 4, 543.02328), -- Recipe: Blessed Spiritshot (C) Compressed Package (100%)
(21173, 6036, 1, 1, 4, 5432.6657), -- Greater Magic Haste Potion
-- Lith Commander
(21174, 1908, 1, 1, -1, 316239), -- Moonstone Earring Wire
(21174, 2163, 1, 1, -1, 170382), -- Recipe: Earring of Protection
(21174, 1873, 1, 3, -1, 667898), -- Silver Nugget
(21174, 6362, 25, 45, 0, 700000), -- Red Seal Stone
(21174, 6361, 211, 425, 1, 700000), -- Green Seal Stone
(21174, 6360, 33, 62, 2, 700000), -- Blue Seal Stone
(21174, 281, 1, 1, 3, 89.529435), -- Crystallized Ice Bow
(21174, 2074, 1, 1, 3, 5589.470565), -- Crystallized Ice Bow Shaft
(21174, 1873, 1, 1, 4, 90188.18376), -- Silver Nugget
(21174, 1868, 1, 3, 4, 225470.91968), -- Thread
(21174, 1876, 1, 1, 4, 45094.09188), -- Mithril Ore
(21174, 1895, 1, 1, 4, 64420.32852), -- Metallic Fiber
(21174, 4042, 1, 1, 4, 3757.72592), -- Enria
(21174, 2164, 1, 1, 4, 17343.81068), -- Recipe: Ring of Protection
(21174, 3002, 1, 1, 4, 14004.93956), -- Recipe: Dwarven Chain Gloves
-- Lilim Butcher
(21175, 440, 1, 1, -1, 1258), -- Robe of Seal
(21175, 1912, 1, 1, -1, 409204), -- Ring of Protection Gemstone
(21175, 4590, 1, 1, -1, 12658), -- Greater Dye of STR (Str+2 Dex-2)
(21175, 6362, 25, 45, 0, 700000), -- Red Seal Stone
(21175, 6361, 268, 532, 1, 700000), -- Green Seal Stone
(21175, 227, 1, 1, 2, 38.069854), -- Stiletto
(21175, 2083, 1, 1, 2, 2794.930146), -- Stiletto Edge
(21175, 242, 1, 1, 2, 38.069854), -- Soulfire Dirk
(21175, 2084, 1, 1, 2, 2794.930146), -- Soulfire Dirk Blade
(21175, 1871, 1, 3, 3, 80121.356916), -- Charcoal
(21175, 1866, 1, 1, 3, 160242.216156), -- Suede
(21175, 1877, 1, 1, 3, 9614.602644), -- Adamantite Nugget
(21175, 4041, 1, 1, 3, 2090.2392), -- Mold Hardener
(21175, 4040, 1, 1, 3, 4807.052484), -- Mold Lubricant
(21175, 951, 1, 1, 3, 436.959528), -- Scroll: Enchant Weapon (C-Grade)
(21175, 6037, 1, 3, 3, 240363.573072), -- Waking Scroll
-- Lilim Magus
(21176, 4041, 1, 1, -1, 33616), -- Mold Hardener
(21176, 1872, 1, 11, -1, 859080), -- Animal Bone
(21176, 4601, 1, 1, -1, 8591), -- Greater Dye of STR (Str+3 Con-3)
(21176, 6362, 11, 22, 0, 700000), -- Red Seal Stone
(21176, 6361, 219, 437, 1, 700000), -- Green Seal Stone
(21176, 6360, 133, 267, 2, 700000), -- Blue Seal Stone
(21176, 326, 1, 1, 3, 48.377142), -- Heathen's Book
(21176, 2110, 1, 1, 3, 4505.622858), -- Heathen's Book Page
(21176, 1864, 4, 12, 4, 57095.68895), -- Stem
(21176, 1865, 2, 6, 4, 45676.55116), -- Varnish
(21176, 1866, 3, 9, 4, 25375.81983), -- Suede
(21176, 1873, 1, 1, 4, 91353.10232), -- Silver Nugget
(21176, 1868, 1, 3, 4, 152255.29631), -- Thread
(21176, 2232, 1, 1, 4, 1312.73107), -- Recipe: Drake Leather Armor
(21176, 3012, 1, 1, 4, 4260.81036), -- Recipe: Full Plate Helmet
-- Lilim Knight-Errant
(21177, 4594, 1, 1, -1, 17584), -- Greater Dye of DEX (Dex+2 Con-2)
(21177, 1806, 1, 1, -1, 10550), -- Recipe: Soulshot (B-Grade)
(21177, 1920, 1, 1, -1, 180500), -- Necklace of Seal Chain
(21177, 6362, 13, 27, 0, 700000), -- Red Seal Stone
(21177, 6361, 314, 633, 1, 700000), -- Green Seal Stone
(21177, 6360, 148, 301, 2, 700000), -- Blue Seal Stone
(21177, 301, 1, 1, 3, 17.6528), -- Scorpion
(21177, 2113, 1, 1, 3, 1572.085625), -- Scorpion Blade
(21177, 303, 1, 1, 3, 17.6528), -- Widow Maker
(21177, 2114, 1, 1, 3, 1572.085625), -- Widowmaker Head
(21177, 299, 1, 1, 3, 13.77255), -- Orcish Poleaxe
(21177, 2122, 1, 1, 3, 1481.7506), -- Orcish Poleaxe Blade
(21177, 1873, 1, 1, 4, 97386.731248), -- Silver Nugget
(21177, 1868, 1, 3, 4, 243466.595568), -- Thread
(21177, 1876, 1, 1, 4, 48693.133072), -- Mithril Ore
(21177, 1895, 1, 1, 4, 69561.884448), -- Metallic Fiber
(21177, 4042, 1, 1, 4, 4057.567296), -- Enria
(21177, 3034, 1, 1, 4, 486.963888), -- Recipe: Spiritshot B
(21177, 4944, 1, 1, 4, 1170.666768), -- Recipe: Avadon Breastplate (60%)
(21177, 4968, 1, 1, 4, 280.457712), -- Recipe: Kris (60%)
-- Lilim Marauder
(21178, 4129, 1, 1, -1, 61196), -- Recipe: Earrings of Black Ore (100%)
(21178, 4610, 1, 1, -1, 12566), -- Greater Dye of MEN (Men+3 Wit-3)
(21178, 947, 1, 1, -1, 2262), -- Scroll: Enchant Weapon (B-Grade)
(21178, 6362, 13, 26, 0, 700000), -- Red Seal Stone
(21178, 6361, 391, 782, 1, 700000), -- Green Seal Stone
(21178, 6360, 73, 146, 2, 700000), -- Blue Seal Stone
(21178, 2384, 1, 1, 3, 46.513225), -- Zubei's Leather Shirt
(21178, 4066, 1, 1, 3, 6564.6867), -- Zubei's Leather Shirt Fabric
(21178, 2390, 1, 1, 3, 28.611825), -- Avadon Leather Armor
(21178, 4068, 1, 1, 3, 5043.306675), -- Avadon Leather Armor Lining
(21178, 2388, 1, 1, 3, 74.42985), -- Zubei's Leather Gaiters
(21178, 4067, 1, 1, 3, 9967.451725), -- Zubei's Leather Gaiter Texture
(21178, 1872, 1, 3, 4, 139188.904008), -- Animal Bone
(21178, 1867, 1, 1, 4, 278377.34533), -- Animal Skin
(21178, 1881, 1, 1, 4, 27837.965876), -- Coarse Bone Powder
(21178, 1875, 1, 1, 4, 13918.982938), -- Stone of Purity
(21178, 4041, 1, 1, 4, 1815.579864), -- Mold Hardener
(21178, 948, 1, 1, 4, 521.909808), -- Scroll: Enchant Armor (B-Grade)
(21178, 4162, 1, 1, 4, 866.148192), -- Recipe: Tunic of Doom (100%)
(21178, 5003, 1, 1, 4, 159.163984), -- Recipe: Art of Battle Axe (60%)
-- Lilim Priest
(21179, 4613, 1, 1, -1, 7498), -- Greater Dye of STR (Str+4 Con-4)
(21179, 947, 1, 1, -1, 2174), -- Scroll: Enchant Weapon (B-Grade)
(21179, 1872, 1, 15, -1, 906001), -- Animal Bone
(21179, 6362, 11, 22, 0, 700000), -- Red Seal Stone
(21179, 6361, 415, 830, 1, 700000), -- Green Seal Stone
(21179, 6360, 7, 15, 2, 700000), -- Blue Seal Stone
(21179, 357, 1, 1, 3, 25.15185), -- Zubei's Breastplate
(21179, 4056, 1, 1, 3, 3633.957919), -- Zubei's Breastplate Part
(21179, 2376, 1, 1, 3, 25.15185), -- Avadon Breastplate
(21179, 4064, 1, 1, 3, 3633.957919), -- Avadon Breastplate Part
(21179, 383, 1, 1, 3, 40.24296), -- Zubei's Gaiters
(21179, 4057, 1, 1, 3, 5616.12864), -- Zubei's Gaiter Material
(21179, 2379, 1, 1, 3, 40.24296), -- Avadon Gaiters
(21179, 4065, 1, 1, 3, 5616.165902), -- Avadon Gaiters Material
(21179, 1872, 1, 3, 4, 101949.964025), -- Animal Bone
(21179, 1867, 2, 6, 4, 76462.57073), -- Animal Skin
(21179, 1881, 1, 1, 4, 30584.793785), -- Coarse Bone Powder
(21179, 1875, 1, 1, 4, 15292.592315), -- Stone of Purity
(21179, 4041, 1, 1, 4, 1994.482035), -- Mold Hardener
(21179, 4155, 1, 1, 4, 712.510435), -- Recipe: Blue Wolf Breastplate (100%)
(21179, 1343, 20, 60, 4, 163848.086675), -- Silver Arrow
-- Lilim Knight
(21180, 4052, 1, 1, -1, 271551), -- Earring of Black Ore Piece
(21180, 5230, 1, 1, -1, 10227), -- Recipe: Mithril Arrow (100%)
(21180, 4053, 1, 1, -1, 328759), -- Ring of Black Ore Gemstone
(21180, 6362, 14, 28, 0, 700000), -- Red Seal Stone
(21180, 6361, 574, 1144, 1, 700000), -- Green Seal Stone
(21180, 2398, 1, 1, 2, 30.501009), -- Blue Wolf Tunic
(21180, 4084, 1, 1, 2, 4923.408096), -- Blue Wolf Tunic Fabric
(21180, 2399, 1, 1, 2, 30.501009), -- Tunic of Doom
(21180, 4085, 1, 1, 2, 4923.408096), -- Tunic of Doom Pattern
(21180, 2403, 1, 1, 2, 48.838896), -- Blue Wolf Stockings
(21180, 4086, 1, 1, 2, 6647.728698), -- Blue Wolf Stockings Pattern
(21180, 2404, 1, 1, 2, 48.838896), -- Stockings of Doom
(21180, 4087, 1, 1, 2, 6647.7753), -- Stockings of Doom Pattern
(21180, 1871, 1, 3, 3, 188798.808672), -- Charcoal
(21180, 1866, 1, 3, 3, 83910.431736), -- Suede
(21180, 1877, 1, 1, 3, 15104.120544), -- Adamantite Nugget
(21180, 4041, 1, 1, 3, 3283.621776), -- Mold Hardener
(21180, 4040, 1, 1, 3, 7552.060272), -- Mold Lubricant
(21180, 1830, 1, 1, 3, 151038.957), -- Scroll of Escape: Castle
-- Lilim Assassin
(21181, 5230, 1, 1, -1, 10851), -- Recipe: Mithril Arrow (100%)
(21181, 4054, 1, 1, -1, 160289), -- Necklace of Black Ore Beads
(21181, 4041, 1, 1, -1, 70764), -- Mold Hardener
(21181, 6362, 14, 27, 0, 700000), -- Red Seal Stone
(21181, 6361, 578, 1160, 1, 700000), -- Green Seal Stone
(21181, 864, 1, 1, 2, 112.69614), -- Earring of Black Ore
(21181, 4052, 1, 1, 2, 14183.47272), -- Earring of Black Ore Piece
(21181, 926, 1, 1, 2, 84.532008), -- Necklace of Black Ore
(21181, 4054, 1, 1, 2, 7890.7104), -- Necklace of Black Ore Beads
(21181, 895, 1, 1, 2, 169.024404), -- Ring of Black Ore
(21181, 4053, 1, 1, 2, 17171.564328), -- Ring of Black Ore Gemstone
(21181, 1872, 1, 3, 3, 228933.690628), -- Animal Bone
(21181, 1867, 1, 3, 3, 152622.611798), -- Animal Skin
(21181, 1881, 1, 1, 3, 45786.647298), -- Coarse Bone Powder
(21181, 1875, 1, 1, 3, 22893.550718), -- Stone of Purity
(21181, 4041, 1, 1, 3, 2985.95735), -- Mold Hardener
(21181, 5230, 1, 1, 3, 457.771104), -- Recipe: Mithril Arrow (100%)
(21181, 5276, 1, 1, 3, 457.771104), -- Recipe: Greater Spiritshot (A) Compressed Package(100%)
-- Lilim Soldier
(21182, 1876, 1, 3, -1, 736136), -- Mithril Ore
(21182, 5478, 1, 1, -1, 61902), -- Sealed Dark Crystal Leather Armor Pattern
(21182, 6362, 11, 22, 0, 700000), -- Red Seal Stone
(21182, 6361, 512, 1023, 1, 700000), -- Green Seal Stone
(21182, 5291, 1, 1, 2, 61.078647), -- Sealed Dark Crystal Boots
(21182, 5496, 1, 1, 2, 6373.671353), -- Sealed Dark Crystal Boots Lining
(21182, 5296, 1, 1, 2, 61.078647), -- Sealed Tallum Boots
(21182, 5497, 1, 1, 2, 6373.671353), -- Sealed Tallum Boots Lining
(21182, 5290, 1, 1, 2, 61.078647), -- Sealed Dark Crystal Gloves
(21182, 5508, 1, 1, 2, 6373.671353), -- Sealed Dark Crystal Gloves Design
(21182, 5295, 1, 1, 2, 61.078647), -- Sealed Tallum Gloves
(21182, 5509, 1, 1, 2, 6373.671353), -- Sealed Tallum Gloves Design
(21182, 1873, 1, 1, 3, 124253.288295), -- Silver Nugget
(21182, 1868, 4, 12, 3, 77658.366161), -- Thread
(21182, 1876, 1, 1, 3, 62126.888054), -- Mithril Ore
(21182, 1895, 1, 1, 3, 88752.209407), -- Metallic Fiber
(21182, 4042, 1, 1, 3, 5177.159369), -- Enria
(21182, 5156, 1, 1, 3, 414.153237), -- Recipe: Soulshot (A) Compressed Package (100%)
(21182, 1344, 30, 90, 3, 129430.935477), -- Mithril Arrow
-- Lilim Knight Commander
(21183, 1807, 1, 1, -1, 10950), -- Recipe: Soulshot (A-Grade)
(21183, 5479, 1, 1, -1, 48593), -- Sealed Tallum Leather Armor Pattern
(21183, 3035, 1, 1, -1, 10950), -- Recipe: Spiritshot A
(21183, 6362, 14, 28, 0, 700000), -- Red Seal Stone
(21183, 6361, 687, 1380, 1, 700000), -- Green Seal Stone
(21183, 5292, 1, 1, 2, 108.0996), -- Sealed Dark Crystal Shield
(21183, 5494, 1, 1, 2, 10612.704725), -- Sealed Dark Crystal Shield Fragment
(21183, 5289, 1, 1, 2, 75.643225), -- Sealed Dark Crystal Helmet
(21183, 5525, 1, 1, 2, 7811.46786), -- Sealed Dark Crystal Helmet Design
(21183, 5294, 1, 1, 2, 75.643225), -- Sealed Tallum Helmet
(21183, 5526, 1, 1, 2, 7811.441365), -- Sealed Tallum Helm Design
(21183, 1894, 1, 1, 3, 21278.91699), -- Crafted Leather
(21183, 4039, 1, 1, 3, 20215.005036), -- Mold Glue
(21183, 4041, 1, 1, 3, 5273.46189), -- Mold Hardener
(21183, 4044, 1, 1, 3, 20215.005036), -- Thons
(21183, 5156, 1, 1, 3, 808.611048), -- Recipe: Soulshot (A) Compressed Package (100%)
-- Lilim Slayer
(21184, 5480, 1, 1, -1, 38649), -- Sealed Leather Armor of Nightmare Fabric
(21184, 729, 1, 1, -1, 957), -- Scroll: Enchant Weapon (A-Grade)
(21184, 1895, 1, 5, -1, 820300), -- Metallic Fiber
(21184, 6362, 14, 27, 0, 700000), -- Red Seal Stone
(21184, 6361, 700, 1400, 1, 700000), -- Green Seal Stone
(21184, 5304, 1, 1, 2, 39.689052), -- Sealed Tallum Tunic
(21184, 5485, 1, 1, 2, 4456.843612), -- Sealed Tallum Tunic Texture
(21184, 5308, 1, 1, 2, 24.413844), -- Sealed Dark Crystal Robe
(21184, 5486, 1, 1, 2, 3136.141476), -- Sealed Dark Crystal Robe Fabric
(21184, 5305, 1, 1, 2, 63.470108), -- Sealed Tallum Stockings
(21184, 5489, 1, 1, 2, 6995.441908), -- Sealed Tallum Stockings Fabric
(21184, 1867, 1, 3, 3, 192741.596432), -- Animal Skin
(21184, 1872, 1, 3, 3, 128494.127552), -- Animal Bone
(21184, 1882, 1, 1, 3, 64247.063776), -- Leather
(21184, 1894, 1, 1, 3, 10144.209264), -- Crafted Leather
(21184, 4042, 1, 1, 3, 4818.71208), -- Enria
(21184, 729, 1, 1, 3, 32.003216), -- Scroll: Enchant Weapon (A-Grade)
(21184, 4987, 1, 1, 3, 1199.512944), -- Recipe: Tunic of Doom (60%)
(21184, 8731, 1, 1, 3, 2676.927232), -- Life Stone - Level 70
(21184, 8741, 1, 1, 3, 669.231808), -- Mid-Grade Life Stone - Level 70
(21184, 8751, 1, 1, 3, 66.84216), -- High-Grade Life Stone - Level 70
(21184, 8761, 1, 1, 3, 13.773536), -- Top-Grade Life Stone - Level 70
-- Lilim Great Magus
(21185, 1875, 1, 1, -1, 513582), -- Stone of Purity
(21185, 5481, 1, 1, -1, 34568), -- Sealed Majestic Leather Armor Fabric
(21185, 5487, 1, 1, -1, 34691), -- Sealed Robe of Nightmare Fabric
(21185, 6362, 11, 22, 0, 700000), -- Red Seal Stone
(21185, 6361, 612, 1227, 1, 700000), -- Green Seal Stone
(21185, 5304, 1, 1, 2, 35.497914), -- Sealed Tallum Tunic
(21185, 5485, 1, 1, 2, 3986.203834), -- Sealed Tallum Tunic Texture
(21185, 5308, 1, 1, 2, 21.835758), -- Sealed Dark Crystal Robe
(21185, 5486, 1, 1, 2, 2804.966982), -- Sealed Dark Crystal Robe Fabric
(21185, 5305, 1, 1, 2, 56.767706), -- Sealed Tallum Stockings
(21185, 5489, 1, 1, 2, 6256.727806), -- Sealed Tallum Stockings Fabric
(21185, 1873, 1, 1, 3, 113778.029204), -- Silver Nugget
(21185, 1868, 3, 9, 3, 94814.895588), -- Thread
(21185, 1876, 1, 1, 3, 56889.014602), -- Mithril Ore
(21185, 1895, 1, 1, 3, 81270.02086), -- Metallic Fiber
(21185, 4042, 1, 1, 3, 4740.783404), -- Enria
(21185, 5282, 1, 1, 3, 126.302442), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21185, 6671, 1, 1, 3, 31604.965196), -- Deluxe Chest Key - Grade 7
(21185, 8732, 1, 1, 3, 2370.391702), -- Life Stone - Level 76
(21185, 8742, 1, 1, 3, 592.501364), -- Mid-Grade Life Stone - Level 76
(21185, 8752, 1, 1, 3, 59.095638), -- High-Grade Life Stone - Level 76
-- Lilim Guard Knight
(21186, 5488, 1, 1, -1, 46584), -- Sealed Majestic Robe Fabric
(21186, 730, 1, 1, -1, 8621), -- Scroll: Enchant Armor (A-Grade)
(21186, 5480, 1, 1, -1, 46420), -- Sealed Leather Armor of Nightmare Fabric
(21186, 6362, 14, 28, 0, 700000), -- Red Seal Stone
(21186, 6361, 805, 1610, 1, 700000), -- Green Seal Stone
(21186, 5315, 1, 1, 2, 89.538834), -- Sealed Shield of Nightmare
(21186, 5495, 1, 1, 2, 9665.951834), -- Sealed Shield of Nightmare Fragment
(21186, 5312, 1, 1, 2, 62.654592), -- Sealed Helm of Nightmare
(21186, 5527, 1, 1, 2, 7610.600074), -- Sealed Helm of Nightmare Design
(21186, 5317, 1, 1, 2, 62.654592), -- Sealed Majestic Circlet
(21186, 5528, 1, 1, 2, 7610.600074), -- Sealed Majestic Circlet Design
(21186, 1871, 4, 12, 3, 79576.53054), -- Charcoal
(21186, 1866, 1, 3, 3, 141469.358199), -- Suede
(21186, 1877, 1, 1, 3, 25464.436803), -- Adamantite Nugget
(21186, 4041, 1, 1, 3, 5535.873798), -- Mold Hardener
(21186, 4040, 1, 1, 3, 12732.350826), -- Mold Lubricant
(21186, 729, 1, 1, 3, 70.449834), -- Scroll: Enchant Weapon (A-Grade)
-- Gigant Slave
(21187, 1868, 1, 3, -1, 886728), -- Thread
(21187, 1873, 1, 1, -1, 354691), -- Silver Nugget
(21187, 1898, 1, 1, -1, 91087), -- Blue Diamond Necklace Gem
(21187, 6362, 23, 42, 0, 700000), -- Red Seal Stone
(21187, 6360, 53, 109, 1, 700000), -- Blue Seal Stone
(21187, 25, 1, 1, 2, 713.295372), -- Piece Bone Breastplate
(21187, 1926, 1, 1, 2, 8818.976021), -- Piece Bone Breastplate Fragment
(21187, 26, 1, 1, 2, 461.708982), -- Bronze Breastplate
(21187, 32, 1, 1, 2, 1141.287351), -- Piece Bone Gaiters
(21187, 1928, 1, 1, 2, 12717.827276), -- Piece Bone Gaiters Fragment
(21187, 34, 1, 1, 2, 739.904998), -- Bronze Gaiters
(21187, 1868, 1, 1, 3, 261925.83979), -- Thread
(21187, 1873, 1, 1, 3, 52385.167958), -- Silver Nugget
(21187, 2176, 1, 1, 3, 62661.819642), -- Recipe: Leather Boots
(21187, 6035, 1, 1, 3, 10913.17261), -- Magic Haste Potion
-- Gigant Acolyte
(21188, 1804, 1, 1, -1, 39326), -- Recipe: Soulshot (D-Grade)
(21188, 1926, 1, 1, -1, 99308), -- Piece Bone Breastplate Fragment
(21188, 2151, 1, 1, -1, 273857), -- Recipe: Necklace of Devotion
(21188, 6362, 21, 39, 0, 700000), -- Red Seal Stone
(21188, 6360, 72, 143, 1, 700000), -- Blue Seal Stone
(21188, 1102, 1, 1, 2, 2045.290996), -- Tunic of Magic
(21188, 1105, 1, 1, 2, 3281.709004), -- Stockings of Magic
(21188, 1867, 1, 1, 3, 193604.579046), -- Animal Skin
(21188, 1872, 1, 1, 3, 193604.579046), -- Animal Bone
(21188, 1882, 1, 1, 3, 32267.285982), -- Leather
(21188, 735, 1, 1, 3, 12100.555926), -- Alacrity Potion
-- Gigant Overseer
(21189, 1899, 1, 1, -1, 184636), -- Necklace of Devotion Chain
(21189, 5549, 1, 1, -1, 118167), -- Metallic Thread
(21189, 1889, 1, 1, -1, 78778), -- Compound Braid
(21189, 6362, 22, 41, 0, 700000), -- Red Seal Stone
(21189, 6360, 97, 190, 1, 700000), -- Blue Seal Stone
(21189, 847, 1, 1, 2, 1601.894656), -- Red Crescent Earring
(21189, 910, 1, 1, 2, 1201.420992), -- Necklace of Devotion
(21189, 1899, 1, 1, 2, 25905.811256), -- Necklace of Devotion Chain
(21189, 890, 1, 1, 2, 2402.873096), -- Ring of Devotion
(21189, 1868, 1, 1, 3, 265275.913895), -- Thread
(21189, 1873, 1, 1, 3, 53055.182779), -- Silver Nugget
(21189, 5549, 1, 1, 3, 13263.881319), -- Metallic Thread
(21189, 1889, 1, 1, 3, 8842.587546), -- Compound Braid
(21189, 2262, 1, 1, 3, 2059.434461), -- Recipe: Elven Bow
-- Gigant Footman
(21190, 1061, 1, 1, -1, 881783), -- Greater Healing Potion
(21190, 1900, 1, 1, -1, 159184), -- Enchanted Necklace Chain
(21190, 2153, 1, 1, -1, 226274), -- Recipe: Tiger's Eye Earring
(21190, 6362, 24, 44, 0, 700000), -- Red Seal Stone
(21190, 6360, 128, 259, 1, 700000), -- Blue Seal Stone
(21190, 1123, 1, 1, 2, 3105.5), -- Blue Buckskin Boots
(21190, 605, 1, 1, 2, 3105.5), -- Leather Gauntlets
(21190, 1869, 1, 1, 3, 132511.529539), -- Iron Ore
(21190, 1864, 1, 1, 3, 265022.614875), -- Stem
(21190, 1880, 1, 1, 3, 13251.019693), -- Steel
(21190, 5550, 1, 1, 3, 1767.039534), -- Durable Metal Plate
(21190, 2153, 1, 1, 3, 20608.353982), -- Recipe: Tiger's Eye Earring
(21190, 6035, 1, 1, 3, 11042.442377), -- Magic Haste Potion
-- Gigant Cleric
(21191, 1901, 1, 1, -1, 222980), -- Tiger's Eye Earring Stone
(21191, 2154, 1, 1, -1, 172845), -- Recipe: Elven Earring
(21191, 1938, 1, 1, -1, 108529), -- Mithril Banded Mail Material
(21191, 6362, 22, 41, 0, 700000), -- Red Seal Stone
(21191, 6361, 33, 63, 1, 700000), -- Green Seal Stone
(21191, 6360, 108, 211, 2, 700000), -- Blue Seal Stone
(21191, 628, 1, 1, 3, 2093.359974), -- Hoplon
(21191, 47, 1, 1, 3, 1464.640026), -- Helmet
(21191, 1869, 1, 1, 4, 171669.733833), -- Iron Ore
(21191, 1864, 1, 3, 4, 171669.733833), -- Stem
(21191, 1880, 1, 1, 4, 17166.856278), -- Steel
(21191, 5550, 1, 1, 4, 2289.018264), -- Durable Metal Plate
(21191, 2155, 1, 1, 4, 27555.657792), -- Recipe: Elven Ring
-- Gigant Officer
(21192, 1870, 1, 5, -1, 684631), -- Coal
(21192, 1865, 1, 5, -1, 684631), -- Varnish
(21192, 1939, 1, 1, -1, 180403), -- Mithril Banded Gaiters Material
(21192, 6362, 24, 44, 0, 700000), -- Red Seal Stone
(21192, 6361, 68, 136, 1, 700000), -- Green Seal Stone
(21192, 6360, 96, 192, 2, 700000), -- Blue Seal Stone
(21192, 83, 1, 1, 3, 66.0972), -- Sword of Magic
(21192, 144, 1, 1, 3, 66.0972), -- Sword of Occult
(21192, 124, 1, 1, 3, 48.96528), -- Two-Handed Sword
(21192, 2026, 1, 1, 3, 2190.90729), -- Two-Handed Sword Edge
(21192, 127, 1, 1, 3, 48.96528), -- Crimson Sword
(21192, 130, 1, 1, 3, 48.96775), -- Elven Sword
(21192, 1870, 1, 1, 4, 218407.94591), -- Coal
(21192, 1865, 1, 1, 4, 218407.94591), -- Varnish
(21192, 1874, 1, 1, 4, 14560.690452), -- Oriharukon Ore
(21192, 2191, 1, 1, 4, 29238.067012), -- Recipe: RIP Gauntlets
(21192, 8317, 1, 1, 4, 1559.350716), -- Recipe: Titan Hammer (100%)
-- Gigant Raider
(21193, 1825, 1, 1, -1, 172903), -- Recipe: Oriharukon
(21193, 1902, 1, 1, -1, 245252), -- Elven Earring Beads
(21193, 2145, 1, 1, -1, 172903), -- Recipe: Mithril Alloy
(21193, 6362, 24, 45, 0, 700000), -- Red Seal Stone
(21193, 6361, 105, 206, 1, 700000), -- Green Seal Stone
(21193, 6360, 89, 178, 2, 700000), -- Blue Seal Stone
(21193, 88, 1, 1, 3, 23.302164), -- Morning Star
(21193, 2031, 1, 1, 3, 1266.576573), -- Morning Star Head
(21193, 90, 1, 1, 3, 23.302164), -- Goat Head Staff
(21193, 2032, 1, 1, 3, 1156.201905), -- Goat Head Staff Head
(21193, 158, 1, 1, 3, 23.302164), -- Tarbar
(21193, 2035, 1, 1, 3, 1266.576573), -- Tarbar Head
(21193, 169, 1, 1, 3, 23.302164), -- Skull Breaker
(21193, 2036, 1, 1, 3, 1266.576573), -- Skull Breaker Head
(21193, 172, 1, 1, 3, 23.302164), -- Heavy Bone Club
(21193, 2037, 1, 1, 3, 1266.557556), -- Heavy Bone Club Head
(21193, 1871, 1, 3, 4, 156410.426705), -- Charcoal
(21193, 1866, 1, 1, 4, 208547.50215), -- Suede
(21193, 1877, 1, 1, 4, 12513.010055), -- Adamantite Nugget
(21193, 2147, 1, 1, 4, 22344.06109), -- Recipe: Blacksmith's frame
-- Gigant Confessor
(21194, 1905, 1, 1, -1, 252534), -- Omen Beast's Eye Earring Gemstone
(21194, 1881, 1, 1, -1, 346140), -- Coarse Bone Powder
(21194, 1875, 1, 1, -1, 173070), -- Stone of Purity
(21194, 6362, 22, 41, 0, 700000), -- Red Seal Stone
(21194, 6361, 137, 274, 1, 700000), -- Green Seal Stone
(21194, 6360, 56, 111, 2, 700000), -- Blue Seal Stone
(21194, 262, 1, 1, 3, 93.99576), -- Scallop Jamadhr
(21194, 2053, 1, 1, 3, 5390.00424), -- Scallop Jamadhr Edge
(21194, 1872, 1, 3, 4, 82769.2668), -- Animal Bone
(21194, 1867, 2, 6, 4, 62076.9501), -- Animal Skin
(21194, 1881, 1, 1, 4, 24830.78004), -- Coarse Bone Powder
(21194, 1875, 1, 1, 4, 12415.39002), -- Stone of Purity
(21194, 1805, 1, 1, 4, 620.865432), -- Recipe: Soulshot (C-Grade)
(21194, 6037, 1, 3, 4, 186230.8503), -- Waking Scroll
(21194, 2994, 1, 1, 4, 14779.897308), -- Recipe: Boots of Seal
-- Gigant Commander
(21195, 1908, 1, 1, -1, 316239), -- Moonstone Earring Wire
(21195, 440, 1, 1, -1, 1106), -- Robe of Seal
(21195, 6362, 25, 45, 0, 700000), -- Red Seal Stone
(21195, 6361, 211, 425, 1, 700000), -- Green Seal Stone
(21195, 6360, 33, 62, 2, 700000), -- Blue Seal Stone
(21195, 281, 1, 1, 3, 89.529435), -- Crystallized Ice Bow
(21195, 2074, 1, 1, 3, 5589.470565), -- Crystallized Ice Bow Shaft
(21195, 1873, 1, 1, 4, 78914.727419), -- Silver Nugget
(21195, 1868, 1, 3, 4, 197286.214907), -- Thread
(21195, 1876, 1, 1, 4, 39457.162496), -- Mithril Ore
(21195, 1895, 1, 1, 4, 56367.547463), -- Metallic Fiber
(21195, 4042, 1, 1, 4, 3288.231017), -- Enria
(21195, 2164, 1, 1, 4, 15175.924597), -- Recipe: Ring of Protection
(21195, 2228, 1, 1, 4, 5361.132494), -- Recipe: Shining Circlet
(21195, 6036, 1, 1, 4, 6576.059607), -- Greater Magic Haste Potion
-- Nephilim Sentinel
(21196, 1911, 1, 1, -1, 282441), -- Earring of Protection Gemstone
(21196, 2166, 1, 1, -1, 128726), -- Recipe: Earrings of Binding (100%)
(21196, 2167, 1, 1, -1, 193746), -- Recipe: Ring of Ages
(21196, 6362, 25, 45, 0, 700000), -- Red Seal Stone
(21196, 6361, 268, 532, 1, 700000), -- Green Seal Stone
(21196, 227, 1, 1, 2, 38.069854), -- Stiletto
(21196, 2083, 1, 1, 2, 2794.930146), -- Stiletto Edge
(21196, 242, 1, 1, 2, 38.069854), -- Soulfire Dirk
(21196, 2084, 1, 1, 2, 2794.930146), -- Soulfire Dirk Blade
(21196, 1871, 1, 1, 3, 280424.31046), -- Charcoal
(21196, 1866, 1, 1, 3, 186949.865072), -- Suede
(21196, 1877, 1, 1, 3, 11217.069848), -- Adamantite Nugget
(21196, 4041, 1, 1, 3, 2438.662888), -- Mold Hardener
(21196, 4040, 1, 1, 3, 5608.534924), -- Mold Lubricant
(21196, 951, 1, 1, 3, 509.556808), -- Scroll: Enchant Weapon (C-Grade)
-- Nephilim Priest
(21197, 4041, 1, 1, -1, 36601), -- Mold Hardener
(21197, 1872, 1, 11, -1, 935364), -- Animal Bone
(21197, 4603, 1, 1, -1, 9354), -- Greater Dye of CON (Con+3 Str-3)
(21197, 6362, 12, 24, 0, 700000), -- Red Seal Stone
(21197, 6361, 238, 476, 1, 700000), -- Green Seal Stone
(21197, 6360, 145, 291, 2, 700000), -- Blue Seal Stone
(21197, 326, 1, 1, 3, 52.679457), -- Heathen's Book
(21197, 2110, 1, 1, 3, 4906.320543), -- Heathen's Book Page
(21197, 1869, 2, 6, 4, 72526.748024), -- Iron Ore
(21197, 1870, 2, 6, 4, 58021.600699), -- Coal
(21197, 1871, 3, 9, 4, 48351.277727), -- Charcoal
(21197, 1872, 7, 21, 4, 27629.397882), -- Animal Bone
(21197, 1867, 1, 3, 4, 128936.852983), -- Animal Skin
(21197, 2232, 1, 1, 4, 1667.122685), -- Recipe: Drake Leather Armor
-- Nephilim Swordsman
(21198, 4593, 1, 1, -1, 17584), -- Greater Dye of DEX (Dex+2 Str-2)
(21198, 1806, 1, 1, -1, 10550), -- Recipe: Soulshot (B-Grade)
(21198, 1920, 1, 1, -1, 180500), -- Necklace of Seal Chain
(21198, 6362, 13, 27, 0, 700000), -- Red Seal Stone
(21198, 6361, 314, 633, 1, 700000), -- Green Seal Stone
(21198, 6360, 148, 301, 2, 700000), -- Blue Seal Stone
(21198, 301, 1, 1, 3, 17.6528), -- Scorpion
(21198, 2113, 1, 1, 3, 1572.085625), -- Scorpion Blade
(21198, 303, 1, 1, 3, 17.6528), -- Widow Maker
(21198, 2114, 1, 1, 3, 1572.085625), -- Widowmaker Head
(21198, 299, 1, 1, 3, 13.77255), -- Orcish Poleaxe
(21198, 2122, 1, 1, 3, 1481.7506), -- Orcish Poleaxe Blade
(21198, 1873, 1, 1, 4, 97386.731248), -- Silver Nugget
(21198, 1868, 1, 3, 4, 243466.595568), -- Thread
(21198, 1876, 1, 1, 4, 48693.133072), -- Mithril Ore
(21198, 1895, 1, 1, 4, 69561.884448), -- Metallic Fiber
(21198, 4042, 1, 1, 4, 4057.567296), -- Enria
(21198, 3034, 1, 1, 4, 486.963888), -- Recipe: Spiritshot B
(21198, 4944, 1, 1, 4, 1170.666768), -- Recipe: Avadon Breastplate (60%)
(21198, 4968, 1, 1, 4, 280.457712), -- Recipe: Kris (60%)
-- Nephilim Guard
(21199, 4129, 1, 1, -1, 61196), -- Recipe: Earrings of Black Ore (100%)
(21199, 4611, 1, 1, -1, 12566), -- Greater Dye of WIT (Wit+3 Int-3)
(21199, 947, 1, 1, -1, 2262), -- Scroll: Enchant Weapon (B-Grade)
(21199, 6362, 13, 26, 0, 700000), -- Red Seal Stone
(21199, 6361, 391, 782, 1, 700000), -- Green Seal Stone
(21199, 6360, 73, 146, 2, 700000), -- Blue Seal Stone
(21199, 2384, 1, 1, 3, 46.513225), -- Zubei's Leather Shirt
(21199, 4066, 1, 1, 3, 6564.6867), -- Zubei's Leather Shirt Fabric
(21199, 2390, 1, 1, 3, 28.611825), -- Avadon Leather Armor
(21199, 4068, 1, 1, 3, 5043.306675), -- Avadon Leather Armor Lining
(21199, 2388, 1, 1, 3, 74.42985), -- Zubei's Leather Gaiters
(21199, 4067, 1, 1, 3, 9967.451725), -- Zubei's Leather Gaiter Texture
(21199, 1872, 1, 3, 4, 139189.096368), -- Animal Bone
(21199, 1867, 1, 1, 4, 278378.65594), -- Animal Skin
(21199, 1881, 1, 1, 4, 27837.633992), -- Coarse Bone Powder
(21199, 1875, 1, 1, 4, 13918.816996), -- Stone of Purity
(21199, 4041, 1, 1, 4, 1815.296476), -- Mold Hardener
(21199, 948, 1, 1, 4, 522.030908), -- Scroll: Enchant Armor (B-Grade)
(21199, 4163, 1, 1, 4, 1382.66394), -- Recipe: Blue Wolf Stockings (100%)
(21199, 8311, 1, 1, 4, 159.80538), -- Recipe: Kaim Vanul's Bones (100%)
-- Nephilim Bishop
(21200, 4613, 1, 1, -1, 8164), -- Greater Dye of STR (Str+4 Con-4)
(21200, 4129, 1, 1, -1, 64055), -- Recipe: Earrings of Black Ore (100%)
(21200, 4049, 1, 1, -1, 310449), -- Adamantite Earring Gemstone
(21200, 6362, 12, 24, 0, 700000), -- Red Seal Stone
(21200, 6361, 452, 904, 1, 700000), -- Green Seal Stone
(21200, 6360, 8, 16, 2, 700000), -- Blue Seal Stone
(21200, 357, 1, 1, 3, 27.3861), -- Zubei's Breastplate
(21200, 4056, 1, 1, 3, 3956.764014), -- Zubei's Breastplate Part
(21200, 2376, 1, 1, 3, 27.3861), -- Avadon Breastplate
(21200, 4064, 1, 1, 3, 3956.764014), -- Avadon Breastplate Part
(21200, 383, 1, 1, 3, 43.81776), -- Zubei's Gaiters
(21200, 4057, 1, 1, 3, 6115.01184), -- Zubei's Gaiter Material
(21200, 2379, 1, 1, 3, 43.81776), -- Avadon Gaiters
(21200, 4065, 1, 1, 3, 6115.052412), -- Avadon Gaiters Material
(21200, 1872, 1, 3, 4, 111002.850595), -- Animal Bone
(21200, 1867, 2, 6, 4, 83252.244334), -- Animal Skin
(21200, 1881, 1, 1, 4, 33300.642403), -- Coarse Bone Powder
(21200, 1875, 1, 1, 4, 16650.533977), -- Stone of Purity
(21200, 4041, 1, 1, 4, 2171.586753), -- Mold Hardener
(21200, 4155, 1, 1, 4, 775.779473), -- Recipe: Blue Wolf Breastplate (100%)
(21200, 1343, 20, 60, 4, 178397.362465), -- Silver Arrow
-- Nephilim Centurion
(21201, 4052, 1, 1, -1, 271551), -- Earring of Black Ore Piece
(21201, 5230, 1, 1, -1, 10227), -- Recipe: Mithril Arrow (100%)
(21201, 4053, 1, 1, -1, 328759), -- Ring of Black Ore Gemstone
(21201, 6362, 14, 28, 0, 700000), -- Red Seal Stone
(21201, 6361, 574, 1144, 1, 700000), -- Green Seal Stone
(21201, 2398, 1, 1, 2, 30.501009), -- Blue Wolf Tunic
(21201, 4084, 1, 1, 2, 4923.408096), -- Blue Wolf Tunic Fabric
(21201, 2399, 1, 1, 2, 30.501009), -- Tunic of Doom
(21201, 4085, 1, 1, 2, 4923.408096), -- Tunic of Doom Pattern
(21201, 2403, 1, 1, 2, 48.838896), -- Blue Wolf Stockings
(21201, 4086, 1, 1, 2, 6647.728698), -- Blue Wolf Stockings Pattern
(21201, 2404, 1, 1, 2, 48.838896), -- Stockings of Doom
(21201, 4087, 1, 1, 2, 6647.7753), -- Stockings of Doom Pattern
(21201, 1871, 1, 3, 3, 161827.525055), -- Charcoal
(21201, 1866, 1, 3, 3, 71923.388495), -- Suede
(21201, 1877, 1, 1, 3, 12946.186155), -- Adamantite Nugget
(21201, 4041, 1, 1, 3, 2814.457205), -- Mold Hardener
(21201, 4040, 1, 1, 3, 6473.291195), -- Mold Lubricant
(21201, 1830, 1, 1, 3, 129461.86155), -- Scroll of Escape: Castle
(21201, 6036, 1, 1, 3, 10788.290345), -- Greater Magic Haste Potion
-- Nephilim Scout
(21202, 5230, 1, 1, -1, 10851), -- Recipe: Mithril Arrow (100%)
(21202, 4054, 1, 1, -1, 160289), -- Necklace of Black Ore Beads
(21202, 4041, 1, 1, -1, 70764), -- Mold Hardener
(21202, 6362, 14, 27, 0, 700000), -- Red Seal Stone
(21202, 6361, 578, 1160, 1, 700000), -- Green Seal Stone
(21202, 864, 1, 1, 2, 112.69614), -- Earring of Black Ore
(21202, 4052, 1, 1, 2, 14183.47272), -- Earring of Black Ore Piece
(21202, 926, 1, 1, 2, 84.532008), -- Necklace of Black Ore
(21202, 4054, 1, 1, 2, 7890.7104), -- Necklace of Black Ore Beads
(21202, 895, 1, 1, 2, 169.024404), -- Ring of Black Ore
(21202, 4053, 1, 1, 2, 17171.564328), -- Ring of Black Ore Gemstone
(21202, 1872, 4, 12, 3, 66772.25872), -- Animal Bone
(21202, 1867, 1, 3, 3, 178059.246928), -- Animal Skin
(21202, 1881, 1, 1, 3, 53417.806976), -- Coarse Bone Powder
(21202, 1875, 1, 1, 3, 26708.903488), -- Stone of Purity
(21202, 4041, 1, 1, 3, 3483.85584), -- Mold Hardener
(21202, 5230, 1, 1, 3, 533.928048), -- Recipe: Mithril Arrow (100%)
-- Nephilim Archbishop
(21203, 1876, 1, 3, -1, 801503), -- Mithril Ore
(21203, 5478, 1, 1, -1, 67398), -- Sealed Dark Crystal Leather Armor Pattern
(21203, 4042, 1, 1, -1, 133584), -- Enria
(21203, 6362, 12, 24, 0, 700000), -- Red Seal Stone
(21203, 6361, 557, 1114, 1, 700000), -- Green Seal Stone
(21203, 5291, 1, 1, 2, 66.503325), -- Sealed Dark Crystal Boots
(21203, 5496, 1, 1, 2, 6939.746675), -- Sealed Dark Crystal Boots Lining
(21203, 5296, 1, 1, 2, 66.503325), -- Sealed Tallum Boots
(21203, 5497, 1, 1, 2, 6939.746675), -- Sealed Tallum Boots Lining
(21203, 5290, 1, 1, 2, 66.503325), -- Sealed Dark Crystal Gloves
(21203, 5508, 1, 1, 2, 6939.746675), -- Sealed Dark Crystal Gloves Design
(21203, 5295, 1, 1, 2, 66.503325), -- Sealed Tallum Gloves
(21203, 5509, 1, 1, 2, 6939.746675), -- Sealed Tallum Gloves Design
(21203, 1873, 1, 1, 3, 135286.501539), -- Silver Nugget
(21203, 1868, 4, 12, 3, 84553.906566), -- Thread
(21203, 1876, 1, 1, 3, 67643.041575), -- Mithril Ore
(21203, 1895, 1, 1, 3, 96633.215385), -- Metallic Fiber
(21203, 4042, 1, 1, 3, 5636.954997), -- Enria
(21203, 5156, 1, 1, 3, 451.023342), -- Recipe: Soulshot (A) Compressed Package (100%)
(21203, 1344, 150, 450, 3, 28184.356596), -- Mithril Arrow
-- Nephilim Praetorian
(21204, 1807, 1, 1, -1, 10950), -- Recipe: Soulshot (A-Grade)
(21204, 5479, 1, 1, -1, 48593), -- Sealed Tallum Leather Armor Pattern
(21204, 3035, 1, 1, -1, 10950), -- Recipe: Spiritshot A
(21204, 6362, 14, 28, 0, 700000), -- Red Seal Stone
(21204, 6361, 687, 1380, 1, 700000), -- Green Seal Stone
(21204, 5292, 1, 1, 2, 108.0996), -- Sealed Dark Crystal Shield
(21204, 5494, 1, 1, 2, 10612.704725), -- Sealed Dark Crystal Shield Fragment
(21204, 5289, 1, 1, 2, 75.643225), -- Sealed Dark Crystal Helmet
(21204, 5525, 1, 1, 2, 7811.46786), -- Sealed Dark Crystal Helmet Design
(21204, 5294, 1, 1, 2, 75.643225), -- Sealed Tallum Helmet
(21204, 5526, 1, 1, 2, 7811.441365), -- Sealed Tallum Helm Design
(21204, 1894, 1, 1, 3, 21278.91699), -- Crafted Leather
(21204, 4039, 1, 1, 3, 20215.005036), -- Mold Glue
(21204, 4041, 1, 1, 3, 5273.46189), -- Mold Hardener
(21204, 4044, 1, 1, 3, 20215.005036), -- Thons
(21204, 3956, 1, 1, 3, 808.611048), -- Recipe: Blessed Spiritshot A
-- Nephilim Royal Guard
(21205, 5480, 1, 1, -1, 38649), -- Sealed Leather Armor of Nightmare Fabric
(21205, 729, 1, 1, -1, 957), -- Scroll: Enchant Weapon (A-Grade)
(21205, 1895, 1, 5, -1, 820300), -- Metallic Fiber
(21205, 6362, 14, 27, 0, 700000), -- Red Seal Stone
(21205, 6361, 700, 1400, 1, 700000), -- Green Seal Stone
(21205, 5297, 1, 1, 2, 39.689052), -- Sealed Dark Crystal Leather Armor
(21205, 5478, 1, 1, 2, 4456.843612), -- Sealed Dark Crystal Leather Armor Pattern
(21205, 5301, 1, 1, 2, 24.413844), -- Sealed Tallum Leather Armor
(21205, 5479, 1, 1, 2, 3136.141476), -- Sealed Tallum Leather Armor Pattern
(21205, 5298, 1, 1, 2, 63.470108), -- Sealed Dark Crystal Leggings
(21205, 5482, 1, 1, 2, 6995.441908), -- Sealed Dark Crystal Leggings Design
(21205, 1895, 1, 1, 3, 181727.779416), -- Metallic Fiber
(21205, 4040, 1, 1, 3, 12720.826633), -- Mold Lubricant
(21205, 4042, 1, 1, 3, 10600.877845), -- Enria
(21205, 4043, 1, 1, 3, 21201.528909), -- Asofe
(21205, 730, 1, 1, 3, 529.987197), -- Scroll: Enchant Armor (A-Grade)
-- Nephilim Cardinal
(21206, 1875, 1, 1, -1, 559187), -- Stone of Purity
(21206, 5481, 1, 1, -1, 37638), -- Sealed Majestic Leather Armor Fabric
(21206, 5487, 1, 1, -1, 37771), -- Sealed Robe of Nightmare Fabric
(21206, 6362, 12, 24, 0, 700000), -- Red Seal Stone
(21206, 6361, 666, 1336, 1, 700000), -- Green Seal Stone
(21206, 5287, 1, 1, 2, 28.982671), -- Sealed Dark Crystal breastplate
(21206, 5520, 1, 1, 2, 3328.859027), -- Sealed Dark Crystal Breastplate Pattern
(21206, 5293, 1, 1, 2, 17.841337), -- Sealed Tallum Plate Armor
(21206, 5521, 1, 1, 2, 2348.975444), -- Sealed Tallum Plate Armor Pattern
(21206, 5288, 1, 1, 2, 46.378789), -- Sealed Dark Crystal Gaiters
(21206, 5524, 1, 1, 2, 5087.962732), -- Sealed Dark Crystal Gaiters Pattern
(21206, 1873, 1, 1, 3, 123881.328256), -- Silver Nugget
(21206, 1868, 3, 9, 3, 103234.300032), -- Thread
(21206, 1876, 1, 1, 3, 61940.664128), -- Mithril Ore
(21206, 1895, 1, 1, 3, 88486.66304), -- Metallic Fiber
(21206, 4042, 1, 1, 3, 5161.757056), -- Enria
(21206, 5282, 1, 1, 3, 137.517888), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21206, 6671, 1, 1, 3, 34411.433344), -- Deluxe Chest Key - Grade 7
(21206, 8732, 1, 1, 3, 2580.878528), -- Life Stone - Level 76
(21206, 8742, 1, 1, 3, 645.114496), -- Mid-Grade Life Stone - Level 76
(21206, 8752, 1, 1, 3, 64.343232), -- High-Grade Life Stone - Level 76
-- Nephilim Commander
(21207, 5488, 1, 1, -1, 46584), -- Sealed Majestic Robe Fabric
(21207, 730, 1, 1, -1, 8621), -- Scroll: Enchant Armor (A-Grade)
(21207, 5480, 1, 1, -1, 46420), -- Sealed Leather Armor of Nightmare Fabric
(21207, 6362, 14, 28, 0, 700000), -- Red Seal Stone
(21207, 6361, 805, 1610, 1, 700000), -- Green Seal Stone
(21207, 5315, 1, 1, 2, 89.538834), -- Sealed Shield of Nightmare
(21207, 5495, 1, 1, 2, 9665.951834), -- Sealed Shield of Nightmare Fragment
(21207, 5312, 1, 1, 2, 62.654592), -- Sealed Helm of Nightmare
(21207, 5527, 1, 1, 2, 7610.600074), -- Sealed Helm of Nightmare Design
(21207, 5317, 1, 1, 2, 62.654592), -- Sealed Majestic Circlet
(21207, 5528, 1, 1, 2, 7610.600074), -- Sealed Majestic Circlet Design
(21207, 1871, 4, 12, 3, 79576.53054), -- Charcoal
(21207, 1866, 1, 3, 3, 141469.358199), -- Suede
(21207, 1877, 1, 1, 3, 25464.436803), -- Adamantite Nugget
(21207, 4041, 1, 1, 3, 5535.873798), -- Mold Hardener
(21207, 4040, 1, 1, 3, 12732.350826), -- Mold Lubricant
(21207, 729, 1, 1, 3, 70.449834), -- Scroll: Enchant Weapon (A-Grade)
-- Hallowed Watchman
(21208, 1871, 1, 1, -1, 790380), -- Charcoal
(21208, 734, 1, 1, -1, 131730), -- Haste Potion
(21208, 1897, 1, 1, -1, 188186), -- Necklace of Wisdom Chain
(21208, 57, 365, 635, 0, 700000), -- Adena
(21208, 38, 1, 1, 1, 5974.79886), -- Low Boots
(21208, 50, 1, 1, 1, 5974.79886), -- Leather Gloves
(21208, 1925, 1, 1, 1, 102062.40228), -- Leather Gloves Lining
(21208, 1871, 1, 1, 2, 155643.947885), -- Charcoal
(21208, 1866, 1, 1, 2, 103762.441692), -- Suede
(21208, 734, 1, 1, 2, 25940.610423), -- Haste Potion
-- Hallowed Seer
(21209, 1804, 1, 1, -1, 36013), -- Recipe: Soulshot (D-Grade)
(21209, 1898, 1, 1, -1, 92484), -- Blue Diamond Necklace Gem
(21209, 2151, 1, 1, -1, 250789), -- Recipe: Necklace of Devotion
(21209, 57, 409, 734, 0, 700000), -- Adena
(21209, 625, 1, 1, 1, 5372.435016), -- Bone Shield
(21209, 1148, 1, 1, 1, 3745.564984), -- Hard Leather Helmet
(21209, 1870, 1, 1, 2, 177296.591934), -- Coal
(21209, 1865, 1, 1, 2, 177296.591934), -- Varnish
(21209, 734, 1, 1, 2, 29549.816132), -- Haste Potion
-- Vault Guardian
(21210, 1899, 1, 1, -1, 171864), -- Necklace of Devotion Chain
(21210, 1866, 1, 1, -1, 733287), -- Suede
(21210, 1877, 1, 1, -1, 43997), -- Adamantite Nugget
(21210, 57, 484, 907, 0, 700000), -- Adena
(21210, 123, 1, 1, 1, 97.988852), -- Saber
(21210, 2017, 1, 1, 1, 2050.881418), -- Saber Blade
(21210, 5285, 1, 1, 1, 97.988852), -- Heavy Sword
(21210, 5531, 1, 1, 1, 2591.140878), -- Heavy Sword Edge
(21210, 1871, 1, 1, 2, 154328.462934), -- Charcoal
(21210, 1866, 1, 1, 2, 102885.641956), -- Suede
(21210, 1877, 1, 1, 2, 6173.070858), -- Adamantite Nugget
(21210, 2182, 1, 1, 2, 18526.824252), -- Recipe: Scale Gaiters
-- Vault Seer
(21211, 1931, 1, 1, -1, 150011), -- Leather Boots Lining
(21211, 2152, 1, 1, -1, 202039), -- Recipe: Enchanted Necklace
(21211, 1932, 1, 1, -1, 182156), -- Bone Helmet Design
(21211, 57, 495, 955, 0, 700000), -- Adena
(21211, 156, 1, 1, 1, 136.333197), -- Hand Axe
(21211, 167, 1, 1, 1, 136.333197), -- Scalpel
(21211, 178, 1, 1, 1, 136.333606), -- Bone Staff
(21211, 1872, 1, 1, 2, 171749.16103), -- Animal Bone
(21211, 1867, 1, 1, 2, 171749.16103), -- Animal Skin
(21211, 1881, 1, 1, 2, 17174.80438), -- Coarse Bone Powder
(21211, 1875, 1, 1, 2, 8587.40219), -- Stone of Purity
(21211, 5437, 1, 1, 2, 3149.47137), -- Recipe: Heavy Sword(100%)
-- Hallowed Monk
(21213, 2153, 1, 1, -1, 230897), -- Recipe: Tiger's Eye Earring
(21213, 1900, 1, 1, -1, 162437), -- Enchanted Necklace Chain
(21213, 57, 626, 1255, 0, 700000), -- Adena
(21213, 275, 1, 1, 1, 109.163865), -- Long Bow
(21213, 276, 1, 1, 1, 109.163865), -- Elven Bow
(21213, 2024, 1, 1, 1, 3852.67227), -- Elven Bow Shaft
(21213, 1864, 3, 9, 2, 54087.7134), -- Stem
(21213, 1869, 1, 1, 2, 162262.66075), -- Iron Ore
(21213, 1878, 1, 1, 2, 64905.0643), -- Braided Hemp
(21213, 1884, 1, 1, 2, 99854.0926), -- Cord
(21213, 1061, 1, 1, 2, 98340.46895), -- Greater Healing Potion
-- Vault Sentinel
(21214, 1875, 1, 1, -1, 123331), -- Stone of Purity
(21214, 1865, 1, 3, -1, 924982), -- Varnish
(21214, 1901, 1, 1, -1, 255520), -- Tiger's Eye Earring Stone
(21214, 57, 781, 1559, 0, 700000), -- Adena
(21214, 223, 1, 1, 1, 52.91724), -- Kukuri
(21214, 238, 1, 1, 1, 52.91724), -- Dagger of Mana
(21214, 239, 1, 1, 1, 52.91724), -- Mystic Knife
(21214, 241, 1, 1, 1, 52.91724), -- Shilen Knife
(21214, 2028, 1, 1, 1, 2337.33104), -- Shilen Knife Edge
(21214, 1865, 1, 1, 2, 196722.357194), -- Varnish
(21214, 1870, 1, 1, 2, 196722.357194), -- Coal
(21214, 1879, 1, 1, 2, 32786.910156), -- Cokes
(21214, 1875, 1, 1, 2, 13114.943314), -- Stone of Purity
(21214, 2189, 1, 1, 2, 8782.432142), -- Recipe: Mithril Tunic
-- Vault Monk
(21215, 1825, 1, 1, -1, 139345), -- Recipe: Oriharukon
(21215, 1902, 1, 1, -1, 197653), -- Elven Earring Beads
(21215, 2145, 1, 1, -1, 139345), -- Recipe: Mithril Alloy
(21215, 57, 824, 1645, 0, 700000), -- Adena
(21215, 318, 1, 1, 1, 93.890762), -- Crucifix of Blood
(21215, 2042, 1, 1, 1, 4659.109238), -- Crucifix of Blood Piece
(21215, 1866, 1, 1, 2, 112047.747354), -- Suede
(21215, 1871, 1, 1, 2, 168071.458602), -- Charcoal
(21215, 5220, 1, 1, 2, 6722.93631), -- Metal Hardener
(21215, 1885, 1, 1, 2, 14005.927812), -- High-Grade Suede
(21215, 1825, 1, 1, 2, 12005.12739), -- Recipe: Oriharukon
(21215, 5473, 1, 1, 2, 12004.802532), -- Recipe: Durable Metal Plate(100%)
-- Hallowed Priest
(21217, 1905, 1, 1, -1, 246339), -- Omen Beast's Eye Earring Gemstone
(21217, 1889, 1, 1, -1, 168824), -- Compound Braid
(21217, 1868, 1, 11, -1, 844121), -- Thread
(21217, 57, 1020, 2061, 0, 700000), -- Adena
(21217, 396, 1, 1, 1, 346.880611), -- Salamander Skin Mail
(21217, 1952, 1, 1, 1, 20366.119389), -- Salamander Skin Mail Texture
(21217, 1868, 1, 3, 2, 211938.94854), -- Thread
(21217, 1873, 1, 1, 2, 84775.72719), -- Silver Nugget
(21217, 5549, 1, 1, 2, 21193.74708), -- Metallic Thread
(21217, 1889, 1, 1, 2, 14129.41101), -- Compound Braid
(21217, 2161, 1, 1, 2, 20576.79063), -- Recipe: Aquastone Ring
(21217, 2993, 1, 1, 2, 16820.37555), -- Recipe: Dwarven Chain Boots
-- Vault Overlord
(21218, 1908, 1, 1, -1, 292039), -- Moonstone Earring Wire
(21218, 2163, 1, 1, -1, 157343), -- Recipe: Earring of Protection
(21218, 1909, 1, 1, -1, 416466), -- Aquastone Ring Wire
(21218, 57, 1220, 2478, 0, 700000), -- Adena
(21218, 354, 1, 1, 1, 187.534332), -- Chain Mail Shirt
(21218, 1959, 1, 1, 1, 9814.437954), -- Chain Mail Shirt Material
(21218, 381, 1, 1, 1, 300.006504), -- Chain Gaiters
(21218, 1960, 1, 1, 1, 19965.02121), -- Chain Gaiters Part
(21218, 1869, 1, 1, 2, 145751.293329), -- Iron Ore
(21218, 1864, 1, 1, 2, 291503.055015), -- Stem
(21218, 1880, 1, 1, 2, 14575.26984), -- Steel
(21218, 5550, 1, 1, 2, 1943.213193), -- Durable Metal Plate
(21218, 4043, 1, 1, 2, 4858.267161), -- Asofe
(21218, 2213, 1, 1, 2, 2263.101024), -- Recipe: Dwarven Chain Mail Shirt
(21218, 8723, 1, 1, 2, 5830.107936), -- Life Stone - Level 46
(21218, 8733, 1, 1, 2, 1457.526984), -- Mid-Grade Life Stone - Level 46
(21218, 8743, 1, 1, 2, 145.659027), -- High-Grade Life Stone - Level 46
(21218, 8753, 1, 1, 2, 29.506491), -- Top-Grade Life Stone - Level 46
-- Vault Priest
(21219, 1911, 1, 1, -1, 237145), -- Earring of Protection Gemstone
(21219, 2166, 1, 1, -1, 108082), -- Recipe: Earrings of Binding (100%)
(21219, 1912, 1, 1, -1, 343579), -- Ring of Protection Gemstone
(21219, 57, 1258, 2567, 0, 700000), -- Adena
(21219, 440, 1, 1, 1, 233.926298), -- Robe of Seal
(21219, 1970, 1, 1, 1, 15773.073702), -- Robe of Seal Fabric
(21219, 1871, 1, 1, 2, 235452.62048), -- Charcoal
(21219, 1866, 1, 1, 2, 156968.686336), -- Suede
(21219, 1877, 1, 1, 2, 9418.186624), -- Adamantite Nugget
(21219, 4041, 1, 1, 2, 2047.574144), -- Mold Hardener
(21219, 4040, 1, 1, 2, 4709.093312), -- Mold Lubricant
(21219, 951, 1, 1, 2, 427.839104), -- Scroll: Enchant Weapon (C-Grade)
-- Sepulcher Inquisitor
(21221, 1872, 1, 11, -1, 871890), -- Animal Bone
(21221, 1867, 1, 11, -1, 871890), -- Animal Skin
(21221, 4605, 1, 1, -1, 8719), -- Greater Dye of DEX (Dex+3 Str-3)
(21221, 57, 1558, 3150, 0, 700000), -- Adena
(21221, 64, 1, 1, 1, 429.6901), -- Composite Boots
(21221, 2956, 1, 1, 1, 23860.3099), -- Composite Boots Part
(21221, 608, 1, 1, 1, 429.6901), -- Mithril Gauntlets
(21221, 1981, 1, 1, 1, 23860.3099), -- Mithril Gauntlets Design
(21221, 1872, 2, 6, 2, 38631.479279), -- Animal Bone
(21221, 1867, 1, 1, 2, 154525.917116), -- Animal Skin
(21221, 1881, 1, 1, 2, 15452.508349), -- Coarse Bone Powder
(21221, 1875, 1, 1, 2, 7726.462581), -- Stone of Purity
(21221, 4041, 1, 1, 2, 1007.853834), -- Mold Hardener
(21221, 2234, 1, 1, 2, 1727.273072), -- Recipe: Divine Stockings
(21221, 6037, 1, 3, 2, 115894.437837), -- Waking Scroll
(21221, 3955, 1, 1, 2, 231.748028), -- Recipe: Blessed Spiritshot B
(21221, 5280, 1, 1, 2, 231.748028), -- Recipe: Greater Blessed Spiritshot (B) Compressed Package(100%)
(21221, 8725, 1, 1, 2, 3219.463612), -- Life Stone - Level 52
(21221, 8735, 1, 1, 2, 804.865903), -- Mid-Grade Life Stone - Level 52
(21221, 8745, 1, 1, 2, 80.444909), -- High-Grade Life Stone - Level 52
(21221, 8755, 1, 1, 2, 16.255707), -- Top-Grade Life Stone - Level 52
(21221, 1342, 30, 90, 2, 77262.541745), -- Steel Arrow
-- Sepulcher Archon
(21222, 1806, 1, 1, -1, 9299), -- Recipe: Soulshot (B-Grade)
(21222, 1920, 1, 1, -1, 159086), -- Necklace of Seal Chain
(21222, 4126, 1, 1, -1, 76721), -- Recipe: Adamantite Earrings (100%)
(21222, 57, 1837, 3743, 0, 700000), -- Adena
(21222, 2497, 1, 1, 1, 297.204255), -- Full Plate Shield
(21222, 2966, 1, 1, 1, 23484.417705), -- Full Plate Shield Fragment
(21222, 2414, 1, 1, 1, 208.039095), -- Full Plate Helmet
(21222, 2959, 1, 1, 1, 14845.338945), -- Full Plate Helmet Design
(21222, 1873, 1, 1, 2, 57221.847612), -- Silver Nugget
(21222, 1868, 1, 1, 2, 286108.815933), -- Thread
(21222, 1876, 1, 1, 2, 28610.923806), -- Mithril Ore
(21222, 1895, 1, 1, 2, 40872.868902), -- Metallic Fiber
(21222, 4042, 1, 1, 2, 2384.173296), -- Enria
(21222, 4126, 1, 1, 2, 2360.534184), -- Recipe: Adamantite Earrings (100%)
(21222, 4965, 1, 1, 2, 164.62953), -- Recipe: Sprite's Staff (60%)
(21222, 4183, 1, 1, 2, 164.62953), -- Recipe: Heavy War Axe (100%)
(21222, 8726, 1, 1, 2, 3311.586315), -- Life Stone - Level 55
(21222, 8736, 1, 1, 2, 827.791047), -- Mid-Grade Life Stone - Level 55
(21222, 8746, 1, 1, 2, 82.736892), -- High-Grade Life Stone - Level 55
(21222, 8756, 1, 1, 2, 16.462953), -- Top-Grade Life Stone - Level 55
-- Sepulcher Inquisitor
(21223, 4129, 1, 1, -1, 51501), -- Recipe: Earrings of Black Ore (100%)
(21223, 4049, 1, 1, -1, 249606), -- Adamantite Earring Gemstone
(21223, 4603, 1, 1, -1, 10575), -- Greater Dye of CON (Con+3 Str-3)
(21223, 57, 1877, 3833, 0, 700000), -- Adena
(21223, 78, 1, 1, 1, 7.013753), -- Great Sword
(21223, 4104, 1, 1, 1, 1340.499041), -- Great Sword Blade
(21223, 142, 1, 1, 1, 7.013753), -- Keshanberk
(21223, 4107, 1, 1, 1, 1319.72985), -- Keshanberk Blade
(21223, 148, 1, 1, 1, 7.013753), -- Sword of Valhalla
(21223, 4108, 1, 1, 1, 1319.72985), -- Sword of Valhalla Blade
(21223, 1873, 1, 1, 2, 51114.767046), -- Silver Nugget
(21223, 1868, 1, 1, 2, 255573.082474), -- Thread
(21223, 1876, 1, 1, 2, 25557.195334), -- Mithril Ore
(21223, 1895, 1, 1, 2, 36510.54789), -- Metallic Fiber
(21223, 4042, 1, 1, 2, 2129.923102), -- Enria
(21223, 4130, 1, 1, 2, 2074.595536), -- Recipe: Ring of Black Ore (100%)
(21223, 4182, 1, 1, 2, 147.163798), -- Recipe: Great Sword (100%)
(21223, 8727, 1, 1, 2, 2555.60662), -- Life Stone - Level 58
(21223, 8737, 1, 1, 2, 639.089844), -- Mid-Grade Life Stone - Level 58
(21223, 8747, 1, 1, 2, 63.98426), -- High-Grade Life Stone - Level 58
(21223, 8757, 1, 1, 2, 12.044096), -- Top-Grade Life Stone - Level 58
-- Sepulcher Guardian
(21224, 1894, 1, 1, -1, 182410), -- Crafted Leather
(21224, 4039, 1, 1, -1, 173289), -- Mold Glue
(21224, 4613, 1, 1, -1, 7171), -- Greater Dye of STR (Str+4 Con-4)
(21224, 57, 2056, 4180, 0, 700000), -- Adena
(21224, 91, 1, 1, 1, 11.49312), -- Heavy War Axe
(21224, 4105, 1, 1, 1, 2196.5262), -- Heavy War Axe Head
(21224, 92, 1, 1, 1, 11.49312), -- Sprite's Staff
(21224, 4106, 1, 1, 1, 2160.48756), -- Sprite's Staff Head
(21224, 1894, 1, 1, 2, 5388.115096), -- Crafted Leather
(21224, 4039, 1, 1, 2, 5118.901294), -- Mold Glue
(21224, 4041, 1, 1, 2, 1335.271665), -- Mold Hardener
(21224, 4044, 1, 1, 2, 5118.901294), -- Thons
(21224, 4158, 1, 1, 2, 326.079819), -- Recipe: Doom Plate Armor (100%)
(21224, 8728, 1, 1, 2, 2559.450647), -- Life Stone - Level 61
(21224, 8738, 1, 1, 2, 639.922647), -- Mid-Grade Life Stone - Level 61
(21224, 8748, 1, 1, 2, 64.064247), -- High-Grade Life Stone - Level 61
(21224, 8758, 1, 1, 2, 12.716873), -- Top-Grade Life Stone - Level 61
(21224, 1343, 10, 30, 2, 219377.576418), -- Silver Arrow
-- Sepulcher Sage
(21225, 4052, 1, 1, -1, 201435), -- Earring of Black Ore Piece
(21225, 5230, 1, 1, -1, 7586), -- Recipe: Mithril Arrow (100%)
(21225, 4053, 1, 1, -1, 243872), -- Ring of Black Ore Gemstone
(21225, 57, 2256, 4571, 0, 700000), -- Adena
(21225, 2391, 1, 1, 1, 27.853632), -- Blue Wolf Leather Armor
(21225, 4082, 1, 1, 1, 4748.146368), -- Blue Wolf Leather Armor Texture
(21225, 2392, 1, 1, 1, 27.853632), -- Leather Armor of Doom
(21225, 4083, 1, 1, 1, 4748.146368), -- Leather Armor of Doom Design
(21225, 1871, 1, 3, 2, 140050.167295), -- Charcoal
(21225, 1866, 1, 1, 2, 186733.403705), -- Suede
(21225, 1877, 1, 1, 2, 11203.811835), -- Adamantite Nugget
(21225, 4041, 1, 1, 2, 2435.531605), -- Mold Hardener
(21225, 4040, 1, 1, 2, 5602.13495), -- Mold Lubricant
(21225, 1830, 1, 1, 2, 112039.95061), -- Scroll of Escape: Castle
-- Sepulcher Guardian
(21226, 5230, 1, 1, -1, 8862), -- Recipe: Mithril Arrow (100%)
(21226, 4054, 1, 1, -1, 130913), -- Necklace of Black Ore Beads
(21226, 4052, 1, 1, -1, 235314), -- Earring of Black Ore Piece
(21226, 57, 2634, 5340, 0, 700000), -- Adena
(21226, 79, 1, 1, 1, 6.485445), -- Sword of Damascus
(21226, 4114, 1, 1, 1, 1432.64904), -- Sword of Damascus Blade
(21226, 7883, 1, 1, 1, 6.485445), -- Guardian Sword
(21226, 8330, 1, 1, 1, 1430.24127), -- Guardian Sword Blade
(21226, 7889, 1, 1, 1, 6.485445), -- Wizard's Tear
(21226, 8336, 1, 1, 1, 1432.653355), -- Blade of the Wizard's Tear
(21226, 1867, 1, 3, 2, 118985.367), -- Animal Skin
(21226, 1872, 1, 1, 2, 237970.324764), -- Animal Bone
(21226, 1882, 1, 1, 2, 39661.925412), -- Leather
(21226, 1894, 1, 1, 2, 6262.538508), -- Crafted Leather
(21226, 4042, 1, 1, 2, 2974.736484), -- Enria
(21226, 5230, 1, 1, 2, 237.766116), -- Recipe: Mithril Arrow (100%)
(21226, 8314, 1, 1, 2, 97.398168), -- Recipe: Spiritual Eye (60%)
(21226, 8729, 1, 1, 2, 2379.70734), -- Life Stone - Level 64
(21226, 8739, 1, 1, 2, 595.029144), -- Mid-Grade Life Stone - Level 64
(21226, 8749, 1, 1, 2, 59.33922), -- High-Grade Life Stone - Level 64
(21226, 8759, 1, 1, 2, 11.867844), -- Top-Grade Life Stone - Level 64
-- Sepulcher Sage
(21227, 5549, 1, 1, -1, 712964), -- Metallic Thread
(21227, 4077, 1, 1, -1, 320722), -- Doom Shield Fragment
(21227, 5230, 1, 1, -1, 9506), -- Recipe: Mithril Arrow (100%)
(21227, 57, 2811, 5744, 0, 700000), -- Adena
(21227, 287, 1, 1, 1, 20.86971), -- Bow of Peril
(21227, 4121, 1, 1, 1, 4586.13029), -- Bow of Peril Shaft
(21227, 1868, 1, 3, 2, 191453.316384), -- Thread
(21227, 1873, 1, 1, 2, 76581.264672), -- Silver Nugget
(21227, 5549, 1, 1, 2, 19145.238816), -- Metallic Thread
(21227, 1889, 1, 1, 2, 12763.698816), -- Compound Braid
(21227, 4044, 1, 1, 2, 6381.849408), -- Thons
(21227, 5230, 1, 1, 2, 255.2616), -- Recipe: Mithril Arrow (100%)
(21227, 8314, 1, 1, 2, 104.579904), -- Recipe: Spiritual Eye (60%)
(21227, 8730, 1, 1, 2, 2127.18), -- Life Stone - Level 67
(21227, 8740, 1, 1, 2, 531.872352), -- Mid-Grade Life Stone - Level 67
(21227, 8750, 1, 1, 2, 53.218176), -- High-Grade Life Stone - Level 67
(21227, 8760, 1, 1, 2, 10.519872), -- Top-Grade Life Stone - Level 67
-- Sepulcher Guard 
(21228, 1807, 1, 1, -1, 9693), -- Recipe: Soulshot (A-Grade)
(21228, 5478, 1, 1, -1, 61132), -- Sealed Dark Crystal Leather Armor Pattern
(21228, 3035, 1, 1, -1, 9693), -- Recipe: Spiritshot A
(21228, 57, 2875, 5849, 0, 700000), -- Adena
(21228, 5287, 1, 1, 1, 20.094901), -- Sealed Dark Crystal breastplate
(21228, 5520, 1, 1, 1, 2308.037537), -- Sealed Dark Crystal Breastplate Pattern
(21228, 5293, 1, 1, 1, 12.370147), -- Sealed Tallum Plate Armor
(21228, 5521, 1, 1, 1, 1628.643164), -- Sealed Tallum Plate Armor Pattern
(21228, 5288, 1, 1, 1, 32.156359), -- Sealed Dark Crystal Gaiters
(21228, 5524, 1, 1, 1, 3527.697892), -- Sealed Dark Crystal Gaiters Pattern
(21228, 1866, 1, 1, 2, 143158.763529), -- Suede
(21228, 1871, 1, 1, 2, 214738.340088), -- Charcoal
(21228, 5220, 1, 1, 2, 8589.658272), -- Metal Hardener
(21228, 1885, 1, 1, 2, 17894.991537), -- High-Grade Suede
(21228, 4041, 1, 1, 2, 1867.300077), -- Mold Hardener
(21228, 5271, 1, 1, 2, 286.347915), -- Recipe: Greater Soulshot (A) Compressed Package(100%)
(21228, 8730, 1, 1, 2, 2385.843036), -- Life Stone - Level 67
(21228, 8740, 1, 1, 2, 596.460759), -- Mid-Grade Life Stone - Level 67
(21228, 8750, 1, 1, 2, 59.607117), -- High-Grade Life Stone - Level 67
(21228, 8760, 1, 1, 2, 11.68767), -- Top-Grade Life Stone - Level 67
-- Sepulcher Preacher
(21229, 5479, 1, 1, -1, 37315), -- Sealed Tallum Leather Armor Pattern
(21229, 4041, 1, 1, -1, 54837), -- Mold Hardener
(21229, 4044, 1, 1, -1, 210209), -- Thons
(21229, 57, 3110, 6350, 0, 700000), -- Adena
(21229, 6324, 1, 1, 1, 77.229401), -- Sealed Phoenix Earring
(21229, 6341, 1, 1, 1, 10733.28277), -- Sealed Phoenix Earring Gemstone
(21229, 6323, 1, 1, 1, 57.913519), -- Sealed Phoenix Necklace
(21229, 6343, 1, 1, 1, 8297.229256), -- Sealed Phoenix Necklace Beads
(21229, 6325, 1, 1, 1, 115.827038), -- Sealed Phoenix Ring
(21229, 6345, 1, 1, 1, 14845.518016), -- Sealed Phoenix Ring Gemstone
(21229, 1894, 1, 1, 2, 9077.747721), -- Crafted Leather
(21229, 4039, 1, 1, 2, 8623.849185), -- Mold Glue
(21229, 4041, 1, 1, 2, 2249.709483), -- Mold Hardener
(21229, 4044, 1, 1, 2, 8623.849185), -- Thons
(21229, 730, 1, 1, 2, 215.608176), -- Scroll: Enchant Armor (A-Grade)
(21229, 8731, 1, 1, 2, 2395.518972), -- Life Stone - Level 70
(21229, 8741, 1, 1, 2, 598.879743), -- Mid-Grade Life Stone - Level 70
(21229, 8751, 1, 1, 2, 59.89116), -- High-Grade Life Stone - Level 70
(21229, 8761, 1, 1, 2, 11.946375), -- Top-Grade Life Stone - Level 70
-- Sepulcher Guard
(21230, 5480, 1, 1, -1, 32628), -- Sealed Leather Armor of Nightmare Fabric
(21230, 5481, 1, 1, -1, 32628), -- Sealed Majestic Leather Armor Fabric
(21230, 5487, 1, 1, -1, 32744), -- Sealed Robe of Nightmare Fabric
(21230, 57, 3587, 7319, 0, 700000), -- Adena
(21230, 5292, 1, 1, 1, 95.7168), -- Sealed Dark Crystal Shield
(21230, 5494, 1, 1, 1, 9397.0203), -- Sealed Dark Crystal Shield Fragment
(21230, 5289, 1, 1, 1, 66.9783), -- Sealed Dark Crystal Helmet
(21230, 5525, 1, 1, 1, 6916.66488), -- Sealed Dark Crystal Helmet Design
(21230, 5294, 1, 1, 1, 66.9783), -- Sealed Tallum Helmet
(21230, 5526, 1, 1, 1, 6916.64142), -- Sealed Tallum Helm Design
(21230, 1895, 1, 1, 2, 85232.828844), -- Metallic Fiber
(21230, 4040, 1, 1, 2, 5966.306811), -- Mold Lubricant
(21230, 4042, 1, 1, 2, 4971.940659), -- Enria
(21230, 4043, 1, 1, 2, 9943.771419), -- Asofe
(21230, 730, 1, 1, 2, 248.591538), -- Scroll: Enchant Armor (A-Grade)
(21230, 8731, 1, 1, 2, 2762.201466), -- Life Stone - Level 70
(21230, 8741, 1, 1, 2, 690.495417), -- Mid-Grade Life Stone - Level 70
(21230, 8751, 1, 1, 2, 69.016572), -- High-Grade Life Stone - Level 70
(21230, 8761, 1, 1, 2, 13.847274), -- Top-Grade Life Stone - Level 70
-- Sepulcher Preacher
(21231, 729, 1, 1, -1, 812), -- Scroll: Enchant Weapon (A-Grade)
(21231, 1875, 1, 1, -1, 487115), -- Stone of Purity
(21231, 5480, 1, 1, -1, 32787), -- Sealed Leather Armor of Nightmare Fabric
(21231, 57, 3602, 7359, 0, 700000), -- Adena
(21231, 5292, 1, 1, 1, 96.18192), -- Sealed Dark Crystal Shield
(21231, 5494, 1, 1, 1, 9442.68357), -- Sealed Dark Crystal Shield Fragment
(21231, 5289, 1, 1, 1, 67.30377), -- Sealed Dark Crystal Helmet
(21231, 5525, 1, 1, 1, 6950.275272), -- Sealed Dark Crystal Helmet Design
(21231, 5294, 1, 1, 1, 67.30377), -- Sealed Tallum Helmet
(21231, 5526, 1, 1, 1, 6950.251698), -- Sealed Tallum Helm Design
(21231, 1872, 1, 3, 2, 199842.391552), -- Animal Bone
(21231, 1867, 1, 3, 2, 133227.995136), -- Animal Skin
(21231, 1881, 1, 1, 2, 39968.55808), -- Coarse Bone Powder
(21231, 1875, 1, 1, 2, 19984.27904), -- Stone of Purity
(21231, 4041, 1, 1, 2, 2606.47168), -- Mold Hardener
(21231, 729, 1, 1, 2, 33.503232), -- Scroll: Enchant Weapon (A-Grade)
(21231, 8732, 1, 1, 2, 2497.985024), -- Life Stone - Level 76
(21231, 8742, 1, 1, 2, 624.595968), -- Mid-Grade Life Stone - Level 76
(21231, 8752, 1, 1, 2, 62.220288), -- High-Grade Life Stone - Level 76
-- Barrow Sentinel
(21236, 1061, 1, 1, -1, 784398), -- Greater Healing Potion
(21236, 1900, 1, 1, -1, 141604), -- Enchanted Necklace Chain
(21236, 2153, 1, 1, -1, 201284), -- Recipe: Tiger's Eye Earring
(21236, 57, 546, 1092, 0, 700000), -- Adena
(21236, 69, 1, 1, 1, 57.082802), -- Bastard Sword
(21236, 125, 1, 1, 1, 57.082802), -- Spinebone Sword
(21236, 2021, 1, 1, 1, 1785.664764), -- Spinebone Sword Blade
(21236, 126, 1, 1, 1, 57.082802), -- Artisan's Sword
(21236, 128, 1, 1, 1, 57.08683), -- Knight's Sword
(21236, 1867, 1, 3, 2, 117877.019123), -- Animal Skin
(21236, 1872, 1, 1, 2, 235754.449743), -- Animal Bone
(21236, 1882, 1, 1, 2, 39292.202542), -- Leather
(21236, 2184, 1, 1, 2, 18573.328592), -- Recipe: Mithril Banded Gaiters
-- Barrow Monk
(21237, 1933, 1, 1, -1, 174667), -- Dark Stockings Fabric
(21237, 2183, 1, 1, -1, 97676), -- Recipe: Mithril Banded Mail
(21237, 1935, 1, 1, -1, 82942), -- Scale Mail Fragment
(21237, 57, 626, 1255, 0, 700000), -- Adena
(21237, 86, 1, 1, 1, 32.746078), -- Tomahawk
(21237, 179, 1, 1, 1, 32.746078), -- Mace of Prayer
(21237, 180, 1, 1, 1, 32.746078), -- Mace of Judgment
(21237, 2022, 1, 1, 1, 1263.70299), -- Mace of Judgment Head
(21237, 181, 1, 1, 1, 32.746078), -- Mace of Miracle
(21237, 182, 1, 1, 1, 32.746078), -- Doom Hammer
(21237, 183, 1, 1, 1, 32.746078), -- Mystic Staff
(21237, 184, 1, 1, 1, 32.746078), -- Conjuror's Staff
(21237, 2023, 1, 1, 1, 1005.325855), -- Conjuror's Staff Head
(21237, 185, 1, 1, 1, 32.748609), -- Staff of Mana
(21237, 1868, 1, 3, 2, 135219.311403), -- Thread
(21237, 1873, 1, 1, 2, 54087.627825), -- Silver Nugget
(21237, 5549, 1, 1, 2, 13521.786036), -- Metallic Thread
(21237, 1889, 1, 1, 2, 9014.846478), -- Compound Braid
(21237, 2265, 1, 1, 2, 1398.321771), -- Recipe: Spiked Club
(21237, 6037, 1, 1, 2, 270439.106487), -- Waking Scroll
-- Grave Sentinel
(21238, 1878, 1, 1, -1, 739986), -- Braided Hemp
(21238, 1884, 1, 3, -1, 569220), -- Cord
(21238, 1901, 1, 1, -1, 255520), -- Tiger's Eye Earring Stone
(21238, 57, 781, 1559, 0, 700000), -- Adena
(21238, 260, 1, 1, 1, 265), -- Triple-Edged Jamadhr
(21238, 1874, 1, 1, 2, 9367.725836), -- Oriharukon Ore
(21238, 1878, 1, 1, 2, 56205.943754), -- Braided Hemp
(21238, 1884, 1, 1, 2, 86471.125596), -- Cord
(21238, 1889, 1, 1, 2, 9367.725836), -- Compound Braid
(21238, 5220, 1, 1, 2, 5620.717754), -- Metal Hardener
(21238, 2190, 1, 1, 2, 10036.84911), -- Recipe: Mithril Stockings
(21238, 1341, 20, 60, 2, 234191.912114), -- Bone Arrow
-- Grave Monk
(21239, 1825, 1, 1, -1, 139345), -- Recipe: Oriharukon
(21239, 1902, 1, 1, -1, 197653), -- Elven Earring Beads
(21239, 2145, 1, 1, -1, 139345), -- Recipe: Mithril Alloy
(21239, 57, 824, 1645, 0, 700000), -- Adena
(21239, 279, 1, 1, 1, 93.89952), -- Reinforced Long Bow
(21239, 2040, 1, 1, 1, 5834.10048), -- Reinforced Long Bow Shaft
(21239, 1870, 1, 1, 2, 168071.726056), -- Coal
(21239, 1865, 1, 1, 2, 168071.726056), -- Varnish
(21239, 1874, 1, 1, 2, 11204.756261), -- Oriharukon Ore
(21239, 2145, 1, 1, 2, 12004.959515), -- Recipe: Mithril Alloy
(21239, 2208, 1, 1, 2, 17185.262911), -- Recipe: Ogre Power Gauntlets
(21239, 6036, 1, 1, 2, 5602.569201), -- Greater Magic Haste Potion
-- Barrow Overlord
(21240, 1903, 1, 1, -1, 372617), -- Elven Ring Piece
(21240, 1871, 1, 5, -1, 744614), -- Charcoal
(21240, 1866, 1, 3, -1, 744614), -- Suede
(21240, 57, 932, 1861, 0, 700000), -- Adena
(21240, 224, 1, 1, 1, 53.76128), -- Maingauche
(21240, 2038, 1, 1, 1, 3050.23872), -- Maingauche Edge
(21240, 1660, 1, 1, 1, 53.76128), -- Cursed Maingauche
(21240, 2044, 1, 1, 1, 3050.23872), -- Cursed Maingauche Edge
(21240, 1871, 2, 6, 2, 72170.28068), -- Charcoal
(21240, 1866, 1, 1, 2, 192453.499748), -- Suede
(21240, 1877, 1, 1, 2, 11547.157599), -- Adamantite Nugget
(21240, 1341, 60, 180, 2, 160378.061973), -- Bone Arrow
-- Barrow Priest
(21241, 4469, 1, 1, -1, 14471), -- Dye of STR (Str+1 Con-1)
(21241, 1905, 1, 1, -1, 246339), -- Omen Beast's Eye Earring Gemstone
(21241, 1805, 1, 1, -1, 8441), -- Recipe: Soulshot (C-Grade)
(21241, 57, 1020, 2061, 0, 700000), -- Adena
(21241, 396, 1, 1, 1, 346.880611), -- Salamander Skin Mail
(21241, 1952, 1, 1, 1, 20366.119389), -- Salamander Skin Mail Texture
(21241, 1872, 1, 3, 2, 121108.069957), -- Animal Bone
(21241, 1867, 1, 1, 2, 242215.712271), -- Animal Skin
(21241, 1881, 1, 1, 2, 24221.69952), -- Coarse Bone Powder
(21241, 1875, 1, 1, 2, 12110.84976), -- Stone of Purity
(21241, 2162, 1, 1, 2, 8776.089646), -- Recipe: Aquastone Necklace
(21241, 2990, 1, 1, 2, 14417.556102), -- Recipe: Chain Boots
(21241, 2206, 1, 1, 2, 4793.022744), -- Recipe: Mithril Shirt
-- Grave Overlord
(21242, 1908, 1, 1, -1, 292039), -- Moonstone Earring Wire
(21242, 2163, 1, 1, -1, 157343), -- Recipe: Earring of Protection
(21242, 1909, 1, 1, -1, 416466), -- Aquastone Ring Wire
(21242, 57, 1220, 2478, 0, 700000), -- Adena
(21242, 96, 1, 1, 1, 27.557894), -- Scythe
(21242, 2062, 1, 1, 1, 1905.10684), -- Scythe Edge
(21242, 298, 1, 1, 1, 27.557894), -- Orcish Glaive
(21242, 2075, 1, 1, 1, 1905.10684), -- Orcish Glaive Blade
(21242, 302, 1, 1, 1, 27.557894), -- Body Slasher
(21242, 2076, 1, 1, 1, 1905.112638), -- Body Slasher Blade
(21242, 1873, 1, 1, 2, 58300.467003), -- Silver Nugget
(21242, 1868, 1, 1, 2, 291501.466809), -- Thread
(21242, 1876, 1, 1, 2, 29150.01645), -- Mithril Ore
(21242, 1895, 1, 1, 2, 41643.066687), -- Metallic Fiber
(21242, 4042, 1, 1, 2, 2429.240388), -- Enria
(21242, 2214, 1, 1, 2, 3616.512093), -- Recipe: Dwarven Chain Gaiters
(21242, 8723, 1, 1, 2, 5830.00329), -- Life Stone - Level 46
(21242, 8733, 1, 1, 2, 1457.717874), -- Mid-Grade Life Stone - Level 46
(21242, 8743, 1, 1, 2, 145.858608), -- High-Grade Life Stone - Level 46
(21242, 8753, 1, 1, 2, 28.650798), -- Top-Grade Life Stone - Level 46
-- Grave Priest
(21243, 951, 1, 1, -1, 5797), -- Scroll: Enchant Weapon (C-Grade)
(21243, 2166, 1, 1, -1, 108082), -- Recipe: Earrings of Binding (100%)
(21243, 1911, 1, 1, -1, 237145), -- Earring of Protection Gemstone
(21243, 57, 1258, 2567, 0, 700000), -- Adena
(21243, 398, 1, 1, 1, 102.96804), -- Plated Leather
(21243, 1966, 1, 1, 1, 6446.93235), -- Plated Leather Fragment
(21243, 399, 1, 1, 1, 94.95058), -- Rind Leather Armor
(21243, 1975, 1, 1, 1, 5800.00284), -- Rind Leather Armor Design
(21243, 418, 1, 1, 1, 164.6561), -- Plated Leather Gaiters
(21243, 1967, 1, 1, 1, 9630.82474), -- Plated Leather Gaiters Material
(21243, 419, 1, 1, 1, 152.03357), -- Rind Leather Gaiters
(21243, 1976, 1, 1, 1, 10737.63178), -- Rind Leather Gaiters Material
(21243, 1873, 1, 1, 2, 56508.534733), -- Silver Nugget
(21243, 1868, 1, 1, 2, 282543.506283), -- Thread
(21243, 1876, 1, 1, 2, 28254.475521), -- Mithril Ore
(21243, 1895, 1, 1, 2, 40363.239095), -- Metallic Fiber
(21243, 4042, 1, 1, 2, 2354.643704), -- Enria
(21243, 951, 1, 1, 2, 256.862653), -- Scroll: Enchant Weapon (C-Grade)
(21243, 8724, 1, 1, 2, 4708.871099), -- Life Stone - Level 49
(21243, 8734, 1, 1, 2, 1177.321852), -- Mid-Grade Life Stone - Level 49
(21243, 8744, 1, 1, 2, 117.815447), -- High-Grade Life Stone - Level 49
(21243, 8754, 1, 1, 2, 23.729613), -- Top-Grade Life Stone - Level 49
-- Crypt Archon
(21244, 4601, 1, 1, -1, 7887), -- Greater Dye of STR (Str+3 Con-3)
(21244, 1539, 1, 1, -1, 788726), -- Greater Healing Potion
(21244, 1914, 1, 1, -1, 199397), -- Earring of Seal Gemstone
(21244, 57, 1404, 2854, 0, 700000), -- Adena
(21244, 60, 1, 1, 1, 119.616525), -- Composite Armor
(21244, 1977, 1, 1, 1, 10855.383475), -- Composite Armor Temper
(21244, 1865, 1, 1, 2, 133432.516646), -- Varnish
(21244, 1870, 1, 1, 2, 133432.516646), -- Coal
(21244, 1879, 1, 1, 2, 22238.648344), -- Cokes
(21244, 1875, 1, 1, 2, 8895.584654), -- Stone of Purity
(21244, 4040, 1, 1, 2, 2668.612738), -- Mold Lubricant
(21244, 2170, 1, 1, 2, 3147.008095), -- Recipe: Nassen's Earring
(21244, 2970, 1, 1, 2, 4731.633973), -- Recipe: Ring of Seal
(21244, 8725, 1, 1, 2, 3706.545821), -- Life Stone - Level 52
(21244, 8735, 1, 1, 2, 926.714778), -- Mid-Grade Life Stone - Level 52
(21244, 8745, 1, 1, 2, 92.734136), -- High-Grade Life Stone - Level 52
(21244, 8755, 1, 1, 2, 18.484169), -- Top-Grade Life Stone - Level 52
-- Crypt Inquisitor
(21245, 2169, 1, 1, -1, 69443), -- Recipe: Necklace of Seal
(21245, 1915, 1, 1, -1, 345683), -- Ring of Ages Gemstone
(21245, 2170, 1, 1, -1, 92536), -- Recipe: Nassen's Earring
(21245, 57, 1558, 3150, 0, 700000), -- Adena
(21245, 60, 1, 1, 1, 132.237567), -- Composite Armor
(21245, 1977, 1, 1, 1, 12000.762433), -- Composite Armor Temper
(21245, 1871, 1, 1, 2, 135209.754141), -- Charcoal
(21245, 1866, 1, 1, 2, 90139.836094), -- Suede
(21245, 1877, 1, 1, 2, 5408.282), -- Adamantite Nugget
(21245, 4041, 1, 1, 2, 1175.809673), -- Mold Hardener
(21245, 4040, 1, 1, 2, 2704.141), -- Mold Lubricant
(21245, 2353, 1, 1, 2, 220.510407), -- Recipe: Samurai Longsword
(21245, 4122, 1, 1, 2, 6009.338795), -- Recipe: Maestro Holder (100%)
(21245, 8309, 1, 1, 2, 155.856854), -- Recipe: Spell Breaker (100%)
(21245, 8725, 1, 1, 2, 3755.806018), -- Life Stone - Level 52
(21245, 8735, 1, 1, 2, 939.07442), -- Mid-Grade Life Stone - Level 52
(21245, 8745, 1, 1, 2, 93.907442), -- High-Grade Life Stone - Level 52
(21245, 8755, 1, 1, 2, 18.683156), -- Top-Grade Life Stone - Level 52
-- Tomb Archon
(21246, 1918, 1, 1, -1, 201354), -- Nassen's Earring Gemstone
(21246, 4042, 1, 1, -1, 77488), -- Enria
(21246, 1867, 1, 13, -1, 885576), -- Animal Skin
(21246, 57, 1837, 3743, 0, 700000), -- Adena
(21246, 855, 1, 1, 1, 175.636134), -- Nassen's Earring
(21246, 1918, 1, 1, 1, 12391.556392), -- Nassen's Earring Gemstone
(21246, 119, 1, 1, 1, 131.746694), -- Necklace of Seal
(21246, 1920, 1, 1, 1, 9790.284145), -- Necklace of Seal Chain
(21246, 886, 1, 1, 1, 263.454201), -- Ring of Seal
(21246, 2917, 1, 1, 1, 16434.322434), -- Ring of Seal Gemstone
(21246, 1867, 1, 1, 2, 190739.38488), -- Animal Skin
(21246, 1872, 1, 1, 2, 190739.38488), -- Animal Bone
(21246, 1882, 1, 1, 2, 31789.89748), -- Leather
(21246, 1894, 1, 1, 2, 5019.322092), -- Crafted Leather
(21246, 4042, 1, 1, 2, 2384.456702), -- Enria
(21246, 4127, 1, 1, 2, 3540.881756), -- Recipe: Adamantite Ring (100%)
(21246, 4965, 1, 1, 2, 164.652288), -- Recipe: Sprite's Staff (60%)
(21246, 4183, 1, 1, 2, 164.652288), -- Recipe: Heavy War Axe (100%)
(21246, 8726, 1, 1, 2, 3311.483386), -- Life Stone - Level 55
(21246, 8736, 1, 1, 2, 827.978042), -- Mid-Grade Life Stone - Level 55
(21246, 8746, 1, 1, 2, 82.754926), -- High-Grade Life Stone - Level 55
(21246, 8756, 1, 1, 2, 17.15128), -- Top-Grade Life Stone - Level 55
-- Tomb Inquisitor
(21247, 4613, 1, 1, -1, 6564), -- Greater Dye of STR (Str+4 Con-4)
(21247, 4049, 1, 1, -1, 249606), -- Adamantite Earring Gemstone
(21247, 4129, 1, 1, -1, 51501), -- Recipe: Earrings of Black Ore (100%)
(21247, 57, 1877, 3833, 0, 700000), -- Adena
(21247, 554, 1, 1, 1, 88.050656), -- Sealed Zubei's Boots
(21247, 4097, 1, 1, 1, 9145.449344), -- Sealed Zubei's Boots Design
(21247, 600, 1, 1, 1, 88.050656), -- Sealed Avadon Boots
(21247, 4098, 1, 1, 1, 9145.449344), -- Sealed Avadon Boots Design
(21247, 612, 1, 1, 1, 88.050656), -- Sealed Zubei's Gauntlets
(21247, 4100, 1, 1, 1, 9145.449344), -- Sealed Zubei's Gauntlets Part
(21247, 2464, 1, 1, 1, 88.050656), -- Sealed Avadon Gloves
(21247, 4073, 1, 1, 1, 9145.449344), -- Sealed Avadon Gloves Part
(21247, 1872, 1, 1, 2, 170382.461206), -- Animal Bone
(21247, 1867, 1, 1, 2, 170382.461206), -- Animal Skin
(21247, 1881, 1, 1, 2, 17038.171454), -- Coarse Bone Powder
(21247, 1875, 1, 1, 2, 8519.085727), -- Stone of Purity
(21247, 4041, 1, 1, 2, 1111.039008), -- Mold Hardener
(21247, 4131, 1, 1, 2, 1038.985739), -- Recipe: Necklace of Black Ore (100%)
(21247, 4173, 1, 1, 2, 1589.278581), -- Recipe: Sealed Blue Wolf Gloves (100%)
(21247, 8727, 1, 1, 2, 2555.837718), -- Life Stone - Level 58
(21247, 8737, 1, 1, 2, 638.772763), -- Mid-Grade Life Stone - Level 58
(21247, 8747, 1, 1, 2, 63.839943), -- High-Grade Life Stone - Level 58
(21247, 8757, 1, 1, 2, 13.066655), -- Top-Grade Life Stone - Level 58
-- Crypt Guardian
(21248, 4050, 1, 1, -1, 322099), -- Adamantite Ring Wire
(21248, 4130, 1, 1, -1, 84394), -- Recipe: Ring of Black Ore (100%)
(21248, 4051, 1, 1, -1, 201616), -- Adamantite Necklace Chain
(21248, 57, 2056, 4180, 0, 700000), -- Adena
(21248, 633, 1, 1, 1, 91.624004), -- Zubei's Shield
(21248, 4101, 1, 1, 1, 11126.113214), -- Zubei's Shield Fragment
(21248, 673, 1, 1, 1, 91.624004), -- Avadon Shield
(21248, 4439, 1, 1, 1, 13236.273544), -- Avadon Shield Fragment
(21248, 503, 1, 1, 1, 64.12842), -- Zubei's Helmet
(21248, 4102, 1, 1, 1, 8620.075154), -- Zubei's Helmet Design
(21248, 2415, 1, 1, 1, 64.12842), -- Avadon Circlet
(21248, 4072, 1, 1, 1, 8620.03324), -- Avadon Circlet Pattern
(21248, 1869, 1, 1, 2, 139600.894576), -- Iron Ore
(21248, 1864, 1, 1, 2, 279201.341848), -- Stem
(21248, 1880, 1, 1, 2, 13959.910536), -- Steel
(21248, 5550, 1, 1, 2, 1861.231944), -- Durable Metal Plate
(21248, 4043, 1, 1, 2, 4653.303512), -- Asofe
(21248, 4159, 1, 1, 2, 395.416736), -- Recipe: Blue Wolf Leather Armor (100%)
(21248, 8728, 1, 1, 2, 2326.875408), -- Life Stone - Level 61
(21248, 8738, 1, 1, 2, 581.4952), -- Mid-Grade Life Stone - Level 61
(21248, 8748, 1, 1, 2, 58.14952), -- High-Grade Life Stone - Level 61
(21248, 8758, 1, 1, 2, 11.629904), -- Top-Grade Life Stone - Level 61
(21248, 6036, 1, 1, 2, 4653.750816), -- Greater Magic Haste Potion
-- Crypt Sage
(21249, 5230, 1, 1, -1, 7586), -- Recipe: Mithril Arrow (100%)
(21249, 4052, 1, 1, -1, 201435), -- Earring of Black Ore Piece
(21249, 4053, 1, 1, -1, 243872), -- Ring of Black Ore Gemstone
(21249, 57, 2256, 4571, 0, 700000), -- Adena
(21249, 358, 1, 1, 1, 22.633608), -- Blue Wolf Breastplate
(21249, 4078, 1, 1, 1, 4091.595561), -- Blue Wolf Breastplate Part
(21249, 2381, 1, 1, 1, 13.930326), -- Doom Plate Armor
(21249, 4081, 1, 1, 1, 2760.805383), -- Doom Plate Armor Temper
(21249, 2380, 1, 1, 1, 36.208698), -- Blue Wolf Gaiters
(21249, 4080, 1, 1, 1, 5761.826424), -- Blue Wolf Gaiters Material
(21249, 1871, 1, 1, 2, 168059.921611), -- Charcoal
(21249, 1866, 1, 1, 2, 112039.849495), -- Suede
(21249, 1877, 1, 1, 2, 6722.361496), -- Adamantite Nugget
(21249, 4041, 1, 1, 2, 1461.306046), -- Mold Hardener
(21249, 4040, 1, 1, 2, 3361.180748), -- Mold Lubricant
(21249, 5166, 1, 1, 2, 224.00012), -- Recipe: Blessed Spiritshot (A) Compressed Package (100%)
(21249, 8729, 1, 1, 2, 2240.885411), -- Life Stone - Level 64
(21249, 8739, 1, 1, 2, 560.295037), -- Mid-Grade Life Stone - Level 64
(21249, 8749, 1, 1, 2, 56.00003), -- High-Grade Life Stone - Level 64
(21249, 8759, 1, 1, 2, 11.200006), -- Top-Grade Life Stone - Level 64
-- Tomb Guardian
(21250, 4052, 1, 1, -1, 235314), -- Earring of Black Ore Piece
(21250, 5230, 1, 1, -1, 8862), -- Recipe: Mithril Arrow (100%)
(21250, 4053, 1, 1, -1, 284889), -- Ring of Black Ore Gemstone
(21250, 57, 2634, 5340, 0, 700000), -- Adena
(21250, 171, 1, 1, 1, 6.484956), -- Deadman's Glory
(21250, 4116, 1, 1, 1, 1429.560294), -- Deadman's Glory Stone
(21250, 175, 1, 1, 1, 6.484956), -- Art of Battle Axe
(21250, 4117, 1, 1, 1, 1429.560294), -- Art of Battle Axe Blade
(21250, 210, 1, 1, 1, 6.484956), -- Staff of Evil Spirits
(21250, 4118, 1, 1, 1, 1354.424544), -- Evil Spirit Head
(21250, 1871, 1, 1, 2, 178478.266995), -- Charcoal
(21250, 1866, 1, 1, 2, 118985.51133), -- Suede
(21250, 1877, 1, 1, 2, 7139.229822), -- Adamantite Nugget
(21250, 4041, 1, 1, 2, 1552.071141), -- Mold Hardener
(21250, 4040, 1, 1, 2, 3569.614911), -- Mold Lubricant
(21250, 1830, 1, 1, 2, 71391.306798), -- Scroll of Escape: Castle
(21250, 8729, 1, 1, 2, 2379.908511), -- Life Stone - Level 64
(21250, 8739, 1, 1, 2, 594.8532), -- Mid-Grade Life Stone - Level 64
(21250, 8749, 1, 1, 2, 59.48532), -- High-Grade Life Stone - Level 64
(21250, 8759, 1, 1, 2, 11.897064), -- Top-Grade Life Stone - Level 64
(21250, 1344, 20, 60, 2, 111548.854908), -- Mithril Arrow
-- Tomb Sage
(21251, 5230, 1, 1, -1, 9506), -- Recipe: Mithril Arrow (100%)
(21251, 4054, 1, 1, -1, 140430), -- Necklace of Black Ore Beads
(21251, 4053, 1, 1, -1, 305600), -- Ring of Black Ore Gemstone
(21251, 57, 2811, 5744, 0, 700000), -- Adena
(21251, 2398, 1, 1, 1, 28.351631), -- Blue Wolf Tunic
(21251, 4084, 1, 1, 1, 4576.460064), -- Blue Wolf Tunic Fabric
(21251, 2399, 1, 1, 1, 28.351631), -- Tunic of Doom
(21251, 4085, 1, 1, 1, 4576.460064), -- Tunic of Doom Pattern
(21251, 2403, 1, 1, 1, 45.397264), -- Blue Wolf Stockings
(21251, 4086, 1, 1, 1, 6179.269382), -- Blue Wolf Stockings Pattern
(21251, 2404, 1, 1, 1, 45.397264), -- Stockings of Doom
(21251, 4087, 1, 1, 1, 6179.3127), -- Stockings of Doom Pattern
(21251, 1866, 1, 1, 2, 127635.625799), -- Suede
(21251, 1871, 1, 3, 2, 63817.605053), -- Charcoal
(21251, 5220, 1, 1, 2, 7658.312139), -- Metal Hardener
(21251, 1885, 1, 1, 2, 15954.29734), -- High-Grade Suede
(21251, 4041, 1, 1, 2, 1664.850465), -- Mold Hardener
(21251, 1830, 1, 1, 2, 76581.458618), -- Scroll of Escape: Castle
(21251, 8730, 1, 1, 2, 2127.101081), -- Life Stone - Level 67
(21251, 8740, 1, 1, 2, 531.671347), -- Mid-Grade Life Stone - Level 67
(21251, 8750, 1, 1, 2, 53.208704), -- High-Grade Life Stone - Level 67
(21251, 8760, 1, 1, 2, 10.808018), -- Top-Grade Life Stone - Level 67
(21251, 1344, 20, 60, 2, 119658.061436), -- Mithril Arrow
-- Crypt Guard 
(21252, 5478, 1, 1, -1, 61132), -- Sealed Dark Crystal Leather Armor Pattern
(21252, 4053, 1, 1, -1, 311606), -- Ring of Black Ore Gemstone
(21252, 5230, 1, 1, -1, 9693), -- Recipe: Mithril Arrow (100%)
(21252, 57, 2875, 5849, 0, 700000), -- Adena
(21252, 5297, 1, 1, 1, 26.797392), -- Sealed Dark Crystal Leather Armor
(21252, 5478, 1, 1, 1, 3009.187152), -- Sealed Dark Crystal Leather Armor Pattern
(21252, 5301, 1, 1, 1, 16.483824), -- Sealed Tallum Leather Armor
(21252, 5479, 1, 1, 1, 2117.470896), -- Sealed Tallum Leather Armor Pattern
(21252, 5298, 1, 1, 1, 42.853968), -- Sealed Dark Crystal Leggings
(21252, 5482, 1, 1, 1, 4723.206768), -- Sealed Dark Crystal Leggings Design
(21252, 10579, 1, 1, 2, 11545), -- Forgotten Scroll - Improve Combat
(21252, 10583, 1, 1, 2, 11545), -- Forgotten Scroll - Improve Shield Defense
(21252, 10608, 1, 1, 2, 11545), -- Forgotten Scroll - Chant of Combat
(21252, 14214, 1, 1, 2, 11545), -- Forgotten Scroll - Chant of Movement
-- Crypt Preacher
(21253, 1807, 1, 1, -1, 8408), -- Recipe: Soulshot (A-Grade)
(21253, 5479, 1, 1, -1, 37315), -- Sealed Tallum Leather Armor Pattern
(21253, 3035, 1, 1, -1, 8408), -- Recipe: Spiritshot A
(21253, 57, 3110, 6350, 0, 700000), -- Adena
(21253, 5304, 1, 1, 1, 29.057478), -- Sealed Tallum Tunic
(21253, 5485, 1, 1, 1, 3262.981318), -- Sealed Tallum Tunic Texture
(21253, 5308, 1, 1, 1, 17.874066), -- Sealed Dark Crystal Robe
(21253, 5486, 1, 1, 1, 2296.057914), -- Sealed Dark Crystal Robe Fabric
(21253, 5305, 1, 1, 1, 46.468262), -- Sealed Tallum Stockings
(21253, 5489, 1, 1, 1, 5121.560962), -- Sealed Tallum Stockings Fabric
(21253, 10580, 1, 1, 2, 11642.455968), -- Forgotten Scroll - Improve Magic
(21253, 10582, 1, 1, 2, 11642.455968), -- Forgotten Scroll - Improve Critical Attack
(21253, 10610, 1, 1, 2, 11642.455968), -- Forgotten Scroll - Chant of Blood Awakening
(21253, 14215, 1, 1, 2, 12064.632096), -- Forgotten Scroll - Combat of Pa'agrio
-- Tomb Guard
(21254, 5480, 1, 1, -1, 32628), -- Sealed Leather Armor of Nightmare Fabric
(21254, 729, 1, 1, -1, 808), -- Scroll: Enchant Weapon (A-Grade)
(21254, 1877, 1, 1, -1, 290856), -- Adamantite Nugget
(21254, 57, 3587, 7319, 0, 700000), -- Adena
(21254, 6324, 1, 1, 1, 89.04905), -- Sealed Phoenix Earring
(21254, 6341, 1, 1, 1, 12375.9685), -- Sealed Phoenix Earring Gemstone
(21254, 6323, 1, 1, 1, 66.77695), -- Sealed Phoenix Necklace
(21254, 6343, 1, 1, 1, 9567.0868), -- Sealed Phoenix Necklace Beads
(21254, 6325, 1, 1, 1, 133.5539), -- Sealed Phoenix Ring
(21254, 6345, 1, 1, 1, 17117.5648), -- Sealed Phoenix Ring Gemstone
(21254, 14216, 1, 1, 2, 53696), -- Forgotten Scroll - Critical of Pa'agrio
-- Tomb Preacher
(21255, 4041, 1, 1, -1, 67285), -- Mold Hardener
(21255, 5481, 1, 1, -1, 34721), -- Sealed Majestic Leather Armor Fabric
(21255, 5487, 1, 1, -1, 34844), -- Sealed Robe of Nightmare Fabric
(21255, 57, 3814, 7793, 0, 700000), -- Adena
(21255, 5297, 1, 1, 1, 35.65434), -- Sealed Dark Crystal Leather Armor
(21255, 5478, 1, 1, 1, 4003.76954), -- Sealed Dark Crystal Leather Armor Pattern
(21255, 5301, 1, 1, 1, 21.93198), -- Sealed Tallum Leather Armor
(21255, 5479, 1, 1, 1, 2817.32742), -- Sealed Tallum Leather Armor Pattern
(21255, 5298, 1, 1, 1, 57.01786), -- Sealed Dark Crystal Leggings
(21255, 5482, 1, 1, 1, 6284.29886), -- Sealed Dark Crystal Leggings Design
(21255, 1873, 1, 1, 2, 114281.750744), -- Silver Nugget
(21255, 1868, 3, 9, 2, 95234.662968), -- Thread
(21255, 1876, 1, 1, 2, 57140.875372), -- Mithril Ore
(21255, 1895, 1, 1, 2, 81629.82196), -- Metallic Fiber
(21255, 4042, 1, 1, 2, 4761.771944), -- Enria
(21255, 5282, 1, 1, 2, 126.861612), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21255, 6671, 1, 1, 2, 31744.887656), -- Deluxe Chest Key - Grade 7
(21255, 8732, 1, 1, 2, 2380.885972), -- Life Stone - Level 76
(21255, 8742, 1, 1, 2, 595.124504), -- Mid-Grade Life Stone - Level 76
(21255, 8752, 1, 1, 2, 59.357268), -- High-Grade Life Stone - Level 76
-- Underground Werewolf
(21256, 1804, 1, 1, -1, 12984), -- Recipe: Soulshot (D-Grade)
(21256, 1898, 1, 1, -1, 33344), -- Blue Diamond Necklace Gem
(21256, 1872, 1, 1, -1, 432806), -- Animal Bone
(21256, 57, 149, 262, 0, 700000), -- Adena
(21256, 27, 1, 1, 1, 337.62267), -- Hard Leather Shirt
(21256, 1927, 1, 1, 1, 3824.63334), -- Hard Leather Shirt Pattern
(21256, 33, 1, 1, 1, 541.71216), -- Hard Leather Gaiters
(21256, 1929, 1, 1, 1, 6186.03183), -- Hard Leather Gaiters Material
(21256, 1867, 1, 1, 2, 42614.618235), -- Animal Skin
(21256, 1872, 1, 1, 2, 42614.618235), -- Animal Bone
(21256, 1882, 1, 1, 2, 7102.4849), -- Leather
(21256, 5153, 1, 1, 2, 1278.40846), -- Recipe: Soulshot (D) Compressed Package (100%)
(21256, 8294, 1, 1, 2, 781.48686), -- Recipe: Steel Sword (100%)
(21256, 735, 1, 1, 2, 2663.38331), -- Alacrity Potion
-- Evil Eye Seer
(21257, 1868, 1, 1, -1, 511527), -- Thread
(21257, 734, 1, 1, -1, 42627), -- Haste Potion
(21257, 1897, 1, 1, -1, 60896), -- Necklace of Wisdom Chain
(21257, 57, 122, 202, 0, 700000), -- Adena
(21257, 217, 1, 1, 1, 144), -- Shining Knife
(21257, 218, 1, 1, 1, 144), -- Throwing Knife
(21257, 1868, 1, 1, 2, 100731.527675), -- Thread
(21257, 1873, 1, 1, 2, 20146.33055), -- Silver Nugget
(21257, 735, 1, 1, 2, 4197.141775), -- Alacrity Potion
-- Fallen Orc Shaman
(21259, 4613, 1, 1, -1, 7283), -- Greater Dye of STR (Str+4 Con-4)
(21259, 4049, 1, 1, -1, 276943), -- Adamantite Earring Gemstone
(21259, 4129, 1, 1, -1, 57142), -- Recipe: Earrings of Black Ore (100%)
(21259, 57, 2085, 4248, 0, 700000), -- Adena
(21259, 229, 1, 1, 1, 11.674131), -- Kris
(21259, 4109, 1, 1, 1, 2196.825869), -- Kris Edge
(21259, 243, 1, 1, 1, 11.674131), -- Hell Knife
(21259, 4110, 1, 1, 1, 2196.825869), -- Hell Knife Edge
(21259, 1873, 1, 1, 2, 62384.21973), -- Silver Nugget
(21259, 1868, 1, 1, 2, 311920.18656), -- Thread
(21259, 1876, 1, 1, 2, 31192.109865), -- Mithril Ore
(21259, 1895, 1, 1, 2, 44560.15695), -- Metallic Fiber
(21259, 4042, 1, 1, 2, 2599.4565), -- Enria
(21259, 947, 1, 1, 2, 62.478165), -- Scroll: Enchant Weapon (B-Grade)
(21259, 8728, 1, 1, 2, 2599.4565), -- Life Stone - Level 61
(21259, 8738, 1, 1, 2, 649.864125), -- Mid-Grade Life Stone - Level 61
(21259, 8748, 1, 1, 2, 64.75839), -- High-Grade Life Stone - Level 61
(21259, 8758, 1, 1, 2, 12.313215), -- Top-Grade Life Stone - Level 61
-- Ol Mahum Transcender
(21261, 2169, 1, 1, -1, 29259), -- Recipe: Necklace of Seal
(21261, 1914, 1, 1, -1, 92873), -- Earring of Seal Gemstone
(21261, 2170, 1, 1, -1, 38989), -- Recipe: Nassen's Earring
(21261, 57, 654, 1329, 0, 700000), -- Adena
(21261, 231, 1, 1, 1, 10.346928), -- Grace Dagger
(21261, 2106, 1, 1, 1, 931.653072), -- Grace Dagger Edge
(21261, 233, 1, 1, 1, 10.346928), -- Dark Screamer
(21261, 2107, 1, 1, 1, 931.653072), -- Dark Screamer Edge
(21261, 1869, 1, 1, 2, 62148.7397), -- Iron Ore
(21261, 1864, 1, 1, 2, 124297.69125), -- Stem
(21261, 1880, 1, 1, 2, 6214.8316), -- Steel
(21261, 5550, 1, 1, 2, 828.54535), -- Durable Metal Plate
(21261, 4043, 1, 1, 2, 2071.68115), -- Asofe
(21261, 2231, 1, 1, 2, 267.7784), -- Recipe: Full Plate Armor
(21261, 8725, 1, 1, 2, 1726.36565), -- Life Stone - Level 52
(21261, 8735, 1, 1, 2, 431.53845), -- Mid-Grade Life Stone - Level 52
(21261, 8745, 1, 1, 2, 43.2174), -- High-Grade Life Stone - Level 52
(21261, 8755, 1, 1, 2, 8.68585), -- Top-Grade Life Stone - Level 52
(21261, 1539, 1, 1, 2, 13810.9252), -- Greater Healing Potion
-- Ol Mahum Transcender
(21262, 2169, 1, 1, -1, 39317), -- Recipe: Necklace of Seal
(21262, 1914, 1, 1, -1, 124797), -- Earring of Seal Gemstone
(21262, 2170, 1, 1, -1, 52391), -- Recipe: Nassen's Earring
(21262, 57, 879, 1786, 0, 700000), -- Adena
(21262, 228, 1, 1, 1, 17.400236), -- Crystal Dagger
(21262, 2119, 1, 1, 1, 1868.599764), -- Crystal Dagger Blade
(21262, 1869, 1, 1, 2, 74564.102417), -- Iron Ore
(21262, 1864, 1, 1, 2, 149128.204834), -- Stem
(21262, 1880, 1, 1, 2, 7456.334123), -- Steel
(21262, 5550, 1, 1, 2, 994.110222), -- Durable Metal Plate
(21262, 4043, 1, 1, 2, 2485.529284), -- Asofe
(21262, 2231, 1, 1, 2, 321.474643), -- Recipe: Full Plate Armor
(21262, 8726, 1, 1, 2, 1726.118387), -- Life Stone - Level 55
(21262, 8736, 1, 1, 2, 431.593029), -- Mid-Grade Life Stone - Level 55
(21262, 8746, 1, 1, 2, 43.13393), -- High-Grade Life Stone - Level 55
(21262, 8756, 1, 1, 2, 8.626786), -- Top-Grade Life Stone - Level 55
(21262, 1539, 1, 1, 2, 16569.772345), -- Greater Healing Potion
-- Ol Mahum Transcender
(21263, 2169, 1, 1, -1, 55228), -- Recipe: Necklace of Seal
(21263, 1914, 1, 1, -1, 175302), -- Earring of Seal Gemstone
(21263, 2170, 1, 1, -1, 73594), -- Recipe: Nassen's Earring
(21263, 57, 1233, 2512, 0, 700000), -- Adena
(21263, 228, 1, 1, 1, 24.439674), -- Crystal Dagger
(21263, 2119, 1, 1, 1, 2624.560326), -- Crystal Dagger Blade
(21263, 1869, 1, 1, 2, 104739.863676), -- Iron Ore
(21263, 1864, 1, 1, 2, 209479.727352), -- Stem
(21263, 1880, 1, 1, 2, 10473.879444), -- Steel
(21263, 5550, 1, 1, 2, 1396.422216), -- Durable Metal Plate
(21263, 4043, 1, 1, 2, 3491.411952), -- Asofe
(21263, 2231, 1, 1, 2, 451.574004), -- Recipe: Full Plate Armor
(21263, 8726, 1, 1, 2, 2424.670836), -- Life Stone - Level 55
(21263, 8736, 1, 1, 2, 606.256812), -- Mid-Grade Life Stone - Level 55
(21263, 8746, 1, 1, 2, 60.59004), -- High-Grade Life Stone - Level 55
(21263, 8756, 1, 1, 2, 12.118008), -- Top-Grade Life Stone - Level 55
(21263, 1539, 1, 1, 2, 23275.48566), -- Greater Healing Potion
-- Ol Mahum Transcender
(21264, 2169, 1, 1, -1, 76366), -- Recipe: Necklace of Seal
(21264, 1914, 1, 1, -1, 242396), -- Earring of Seal Gemstone
(21264, 2170, 1, 1, -1, 101761), -- Recipe: Nassen's Earring
(21264, 57, 1704, 3471, 0, 700000), -- Adena
(21264, 229, 1, 1, 1, 9.538587), -- Kris
(21264, 4109, 1, 1, 1, 1794.961413), -- Kris Edge
(21264, 243, 1, 1, 1, 9.538587), -- Hell Knife
(21264, 4110, 1, 1, 1, 1794.961413), -- Hell Knife Edge
(21264, 1869, 1, 1, 2, 115861.975602), -- Iron Ore
(21264, 1864, 1, 1, 2, 231723.557413), -- Stem
(21264, 1880, 1, 1, 2, 11586.118802), -- Steel
(21264, 5550, 1, 1, 2, 1544.842093), -- Durable Metal Plate
(21264, 4043, 1, 1, 2, 3861.908337), -- Asofe
(21264, 2231, 1, 1, 2, 499.326988), -- Recipe: Full Plate Armor
(21264, 8727, 1, 1, 2, 2317.066244), -- Life Stone - Level 58
(21264, 8737, 1, 1, 2, 579.266561), -- Mid-Grade Life Stone - Level 58
(21264, 8747, 1, 1, 2, 57.887277), -- High-Grade Life Stone - Level 58
(21264, 8757, 1, 1, 2, 11.419939), -- Top-Grade Life Stone - Level 58
(21264, 1539, 1, 1, 2, 25747.630744), -- Greater Healing Potion
-- Cave Ant Larva
(21265, 1864, 1, 3, -1, 627198), -- Stem
(21265, 1869, 1, 1, -1, 627198), -- Iron Ore
(21265, 1901, 1, 1, -1, 86630), -- Tiger's Eye Earring Stone
(21265, 57, 264, 530, 0, 700000), -- Adena
(21265, 83, 1, 1, 1, 20.17704), -- Sword of Magic
(21265, 144, 1, 1, 1, 20.17704), -- Sword of Occult
(21265, 124, 1, 1, 1, 14.947296), -- Two-Handed Sword
(21265, 2026, 1, 1, 1, 668.803278), -- Two-Handed Sword Edge
(21265, 127, 1, 1, 1, 14.947296), -- Crimson Sword
(21265, 130, 1, 1, 1, 14.94805), -- Elven Sword
(21265, 1864, 1, 1, 2, 133390.472304), -- Stem
(21265, 1869, 1, 1, 2, 66695.236152); -- Iron Ore

INSERT INTO `droplist` VALUES
(21265, 1878, 1, 1, 2, 26678.20444), -- Braided Hemp
(21265, 1884, 1, 1, 2, 41043.137648), -- Cord
(21265, 2154, 1, 1, 2, 7140.949456), -- Recipe: Elven Earring
-- Cave Ant Larva
(21268, 1940, 1, 1, -1, 174118), -- Iron Boots Design
(21268, 2156, 1, 1, -1, 93327), -- Recipe: Elven Necklace
(21268, 2026, 1, 1, -1, 14041), -- Two-Handed Sword Edge
(21268, 57, 492, 986, 0, 700000), -- Adena
(21268, 278, 1, 1, 1, 83.430282), -- Gastraphetes
(21268, 2029, 1, 1, 1, 3699.569718), -- Gastraphetes Shaft
(21268, 1867, 1, 1, 2, 118145.997732), -- Animal Skin
(21268, 1872, 1, 1, 2, 118145.997732), -- Animal Bone
(21268, 1882, 1, 1, 2, 19690.999622), -- Leather
(21268, 1894, 1, 1, 2, 3109.154552), -- Crafted Leather
(21268, 2186, 1, 1, 2, 2963.354331), -- Recipe: Brigandine Tunic
(21268, 6037, 1, 3, 2, 59072.998866), -- Waking Scroll
(21268, 1341, 20, 60, 2, 147682.497165), -- Bone Arrow
-- Cave Ant
(21269, 1825, 1, 1, -1, 94807), -- Recipe: Oriharukon
(21269, 1902, 1, 1, -1, 134478), -- Elven Earring Beads
(21269, 2145, 1, 1, -1, 94807), -- Recipe: Mithril Alloy
(21269, 57, 561, 1119, 0, 700000), -- Adena
(21269, 129, 1, 1, 1, 63.87616), -- Sword of Revolution
(21269, 2034, 1, 1, 1, 3624.12384), -- Sword of Revolution Blade
(21269, 1872, 1, 1, 2, 182963.082148), -- Animal Bone
(21269, 1867, 1, 1, 2, 182963.082148), -- Animal Skin
(21269, 1881, 1, 1, 2, 18296.348532), -- Coarse Bone Powder
(21269, 1875, 1, 1, 2, 9147.97268), -- Stone of Purity
(21269, 1825, 1, 1, 2, 9801.514492), -- Recipe: Oriharukon
-- Cave Ant Soldier
(21270, 1903, 1, 1, -1, 255201), -- Elven Ring Piece
(21270, 6036, 1, 1, -1, 50998), -- Greater Magic Haste Potion
(21270, 1902, 1, 1, -1, 155008), -- Elven Earring Beads
(21270, 57, 647, 1291, 0, 700000), -- Adena
(21270, 88, 1, 1, 1, 14.726056), -- Morning Star
(21270, 2031, 1, 1, 1, 800.426842), -- Morning Star Head
(21270, 90, 1, 1, 1, 14.726056), -- Goat Head Staff
(21270, 2032, 1, 1, 1, 730.67437), -- Goat Head Staff Head
(21270, 158, 1, 1, 1, 14.726056), -- Tarbar
(21270, 2035, 1, 1, 1, 800.426842), -- Tarbar Head
(21270, 169, 1, 1, 1, 14.726056), -- Skull Breaker
(21270, 2036, 1, 1, 1, 800.426842), -- Skull Breaker Head
(21270, 172, 1, 1, 1, 14.726056), -- Heavy Bone Club
(21270, 2037, 1, 1, 1, 800.414824), -- Heavy Bone Club Head
(21270, 1868, 1, 1, 2, 316342.742333), -- Thread
(21270, 1873, 1, 1, 2, 63268.715375), -- Silver Nugget
(21270, 5549, 1, 1, 2, 15817.074526), -- Metallic Thread
(21270, 1889, 1, 1, 2, 10544.855441), -- Compound Braid
(21270, 2145, 1, 1, 2, 11297.612325), -- Recipe: Mithril Alloy
-- Cave Ant
(21271, 1864, 1, 3, -1, 905720), -- Stem
(21271, 1869, 1, 1, -1, 905720), -- Iron Ore
(21271, 1901, 1, 1, -1, 125099), -- Tiger's Eye Earring Stone
(21271, 57, 383, 764, 0, 700000), -- Adena
(21271, 129, 1, 1, 1, 43.59444), -- Sword of Revolution
(21271, 2034, 1, 1, 1, 2473.40556), -- Sword of Revolution Blade
(21271, 1864, 1, 1, 2, 187274.890368), -- Stem
(21271, 1869, 1, 1, 2, 93637.445184), -- Iron Ore
(21271, 1878, 1, 1, 2, 37455.13248), -- Braided Hemp
(21271, 1884, 1, 1, 2, 57622.924416), -- Cord
(21271, 2154, 1, 1, 2, 10025.607552), -- Recipe: Elven Earring
-- Cave Ant Soldier
(21272, 1864, 1, 7, -1, 802957), -- Stem
(21272, 1869, 1, 3, -1, 802957), -- Iron Ore
(21272, 1901, 1, 1, -1, 221811), -- Tiger's Eye Earring Stone
(21272, 57, 679, 1355, 0, 700000), -- Adena
(21272, 129, 1, 1, 1, 77.29916), -- Sword of Revolution
(21272, 2034, 1, 1, 1, 4385.70084), -- Sword of Revolution Blade
(21272, 1864, 3, 9, 2, 55342.280884), -- Stem
(21272, 1869, 1, 1, 2, 166026.842652), -- Iron Ore
(21272, 1878, 1, 1, 2, 66410.818606), -- Braided Hemp
(21272, 1884, 1, 1, 2, 102170.427436), -- Cord
(21272, 2154, 1, 1, 2, 17775.630422), -- Recipe: Elven Earring
-- Cave Noble Ant
(21273, 1864, 1, 19, -1, 930725), -- Stem
(21273, 1869, 1, 9, -1, 930725), -- Iron Ore
(21273, 1901, 1, 1, -1, 642766), -- Tiger's Eye Earring Stone
(21273, 57, 1969, 3922, 0, 700000), -- Adena
(21273, 129, 1, 1, 1, 223.98224), -- Sword of Revolution
(21273, 2034, 1, 1, 1, 12708.01776), -- Sword of Revolution Blade
(21273, 1864, 3, 9, 2, 160371.145974), -- Stem
(21273, 1869, 2, 6, 2, 120278.571205), -- Iron Ore
(21273, 1878, 3, 9, 2, 32074.144505), -- Braided Hemp
(21273, 1884, 2, 6, 2, 59213.837813), -- Cord
(21273, 2154, 1, 1, 2, 51511.300503), -- Recipe: Elven Earring
-- Kookaburra
(21274, 4087, 1, 1, -1, 72770), -- Stockings of Doom Pattern
(21274, 6333, 1, 1, -1, 35604), -- Recipe: Sealed Phoenix Ring(70%)
(21274, 4088, 1, 1, -1, 117199), -- Blue Wolf Helmet Design
(21274, 57, 1223, 2498, 0, 700000), -- Adena
(21274, 12341, 1, 1, 1, 708.44508), -- Common Item - Earring of Black Ore
(21274, 4052, 1, 1, 1, 5405.234928), -- Earring of Black Ore Piece
(21274, 12342, 1, 1, 1, 531.036144), -- Common Item - Necklace of Black Ore
(21274, 4054, 1, 1, 1, 3007.099584), -- Necklace of Black Ore Beads
(21274, 12343, 1, 1, 1, 1060.20864), -- Common Item - Ring of Black Ore
(21274, 4053, 1, 1, 1, 6543.975624), -- Ring of Black Ore Gemstone
(21274, 1864, 1, 1, 2, 166548.059594), -- Stem
(21274, 1869, 1, 1, 2, 83274.029797), -- Iron Ore
(21274, 1878, 1, 1, 2, 33309.703385), -- Braided Hemp
(21274, 1884, 1, 1, 2, 51245.767874), -- Cord
(21274, 4039, 1, 1, 2, 2775.99917), -- Mold Glue
(21274, 5456, 1, 1, 2, 30.641177), -- Recipe: Tallum Glaive(60%)
(21274, 8730, 1, 1, 2, 925.180613), -- Life Stone - Level 67
(21274, 8740, 1, 1, 2, 231.409486), -- Mid-Grade Life Stone - Level 67
(21274, 8750, 1, 1, 2, 23.323881), -- High-Grade Life Stone - Level 67
(21274, 8760, 1, 1, 2, 4.57331), -- Top-Grade Life Stone - Level 67
(21274, 1343, 10, 30, 2, 118962.311713), -- Silver Arrow
-- Kookaburra
(21275, 4087, 1, 1, -1, 73242), -- Stockings of Doom Pattern
(21275, 6333, 1, 1, -1, 35835), -- Recipe: Sealed Phoenix Ring(70%)
(21275, 4088, 1, 1, -1, 117959), -- Blue Wolf Helmet Design
(21275, 57, 1230, 2515, 0, 700000), -- Adena
(21275, 12341, 1, 1, 1, 713.04324), -- Common Item - Earring of Black Ore
(21275, 4052, 1, 1, 1, 5440.317584), -- Earring of Black Ore Piece
(21275, 12342, 1, 1, 1, 534.482832), -- Common Item - Necklace of Black Ore
(21275, 4054, 1, 1, 1, 3026.617152), -- Necklace of Black Ore Beads
(21275, 12343, 1, 1, 1, 1067.08992), -- Common Item - Ring of Black Ore
(21275, 4053, 1, 1, 1, 6586.449272), -- Ring of Black Ore Gemstone
(21275, 1864, 1, 1, 2, 167627.835504), -- Stem
(21275, 1869, 1, 1, 2, 83813.917752), -- Iron Ore
(21275, 1878, 1, 1, 2, 33525.65916), -- Braided Hemp
(21275, 1884, 1, 1, 2, 51578.007984), -- Cord
(21275, 4039, 1, 1, 2, 2793.99672), -- Mold Glue
(21275, 5456, 1, 1, 2, 30.839832), -- Recipe: Tallum Glaive(60%)
(21275, 8730, 1, 1, 2, 931.178808), -- Life Stone - Level 67
(21275, 8740, 1, 1, 2, 232.909776), -- Mid-Grade Life Stone - Level 67
(21275, 8750, 1, 1, 2, 23.475096), -- High-Grade Life Stone - Level 67
(21275, 8760, 1, 1, 2, 4.60296), -- Top-Grade Life Stone - Level 67
(21275, 1343, 10, 30, 2, 119733.576408), -- Silver Arrow
-- Kookaburra
(21276, 4087, 1, 1, -1, 72350), -- Stockings of Doom Pattern
(21276, 6333, 1, 1, -1, 35399), -- Recipe: Sealed Phoenix Ring(70%)
(21276, 4088, 1, 1, -1, 116524), -- Blue Wolf Helmet Design
(21276, 57, 1216, 2484, 0, 700000), -- Adena
(21276, 12341, 1, 1, 1, 704.33958), -- Common Item - Earring of Black Ore
(21276, 4052, 1, 1, 1, 5373.911128), -- Earring of Black Ore Piece
(21276, 12342, 1, 1, 1, 527.958744), -- Common Item - Necklace of Black Ore
(21276, 4054, 1, 1, 1, 2989.673184), -- Necklace of Black Ore Beads
(21276, 12343, 1, 1, 1, 1054.06464), -- Common Item - Ring of Black Ore
(21276, 4053, 1, 1, 1, 6506.052724), -- Ring of Black Ore Gemstone
(21276, 1864, 1, 1, 2, 165588.09693), -- Stem
(21276, 1869, 1, 1, 2, 82794.048465), -- Iron Ore
(21276, 1878, 1, 1, 2, 33117.710325), -- Braided Hemp
(21276, 1884, 1, 1, 2, 50950.39353), -- Cord
(21276, 4039, 1, 1, 2, 2759.99865), -- Mold Glue
(21276, 5456, 1, 1, 2, 30.464565), -- Recipe: Tallum Glaive(60%)
(21276, 8730, 1, 1, 2, 919.847985), -- Life Stone - Level 67
(21276, 8740, 1, 1, 2, 230.07567), -- Mid-Grade Life Stone - Level 67
(21276, 8750, 1, 1, 2, 23.189445), -- High-Grade Life Stone - Level 67
(21276, 8760, 1, 1, 2, 4.54695), -- Top-Grade Life Stone - Level 67
(21276, 1343, 10, 30, 2, 118276.627485), -- Silver Arrow
-- Antelope
(21278, 5478, 1, 1, -1, 26945), -- Sealed Dark Crystal Leather Armor Pattern
(21278, 729, 1, 1, -1, 356), -- Scroll: Enchant Weapon (A-Grade)
(21278, 4040, 1, 1, -1, 64087), -- Mold Lubricant
(21278, 57, 1268, 2577, 0, 700000), -- Adena
(21278, 11957, 1, 1, 1, 43.42806), -- Common Item - Tallum Blade
(21278, 5548, 1, 1, 1, 536.71891), -- Tallum Blade Edge
(21278, 11952, 1, 1, 1, 43.42806), -- Common Item - Elemental Sword
(21278, 5547, 1, 1, 1, 536.71891), -- Elemental Sword Edge
(21278, 11954, 1, 1, 1, 43.42806), -- Common Item - Inferno Master
(21278, 8331, 1, 1, 1, 538.278), -- Infernal Master Blade
(21278, 1865, 1, 1, 2, 94651.322115), -- Varnish
(21278, 1870, 1, 1, 2, 94651.322115), -- Coal
(21278, 1879, 1, 1, 2, 15775.18446), -- Cokes
(21278, 1875, 1, 1, 2, 6310.116855), -- Stone of Purity
(21278, 4040, 1, 1, 2, 1892.97045), -- Mold Lubricant
(21278, 6339, 1, 1, 2, 728.115255), -- Recipe: Sealed Majestic Ring(70%)
(21278, 8730, 1, 1, 2, 1051.578465), -- Life Stone - Level 67
(21278, 8740, 1, 1, 2, 262.948455), -- Mid-Grade Life Stone - Level 67
(21278, 8750, 1, 1, 2, 26.27331), -- High-Grade Life Stone - Level 67
(21278, 8760, 1, 1, 2, 5.16852), -- Top-Grade Life Stone - Level 67
-- Antelope
(21279, 5478, 1, 1, -1, 26790), -- Sealed Dark Crystal Leather Armor Pattern
(21279, 729, 1, 1, -1, 354), -- Scroll: Enchant Weapon (A-Grade)
(21279, 4040, 1, 1, -1, 63717), -- Mold Lubricant
(21279, 57, 1260, 2562, 0, 700000), -- Adena
(21279, 11957, 1, 1, 1, 43.17876), -- Common Item - Tallum Blade
(21279, 5548, 1, 1, 1, 533.63786), -- Tallum Blade Edge
(21279, 11952, 1, 1, 1, 43.17876), -- Common Item - Elemental Sword
(21279, 5547, 1, 1, 1, 533.63786), -- Elemental Sword Edge
(21279, 11954, 1, 1, 1, 43.17876), -- Common Item - Inferno Master
(21279, 8331, 1, 1, 1, 535.188), -- Infernal Master Blade
(21279, 1865, 1, 1, 2, 94105.886482), -- Varnish
(21279, 1870, 1, 1, 2, 94105.886482), -- Coal
(21279, 1879, 1, 1, 2, 15684.278728), -- Cokes
(21279, 1875, 1, 1, 2, 6273.754314), -- Stone of Purity
(21279, 4040, 1, 1, 2, 1882.06206), -- Mold Lubricant
(21279, 6339, 1, 1, 2, 723.919434), -- Recipe: Sealed Majestic Ring(70%)
(21279, 8730, 1, 1, 2, 1045.518662), -- Life Stone - Level 67
(21279, 8740, 1, 1, 2, 261.433194), -- Mid-Grade Life Stone - Level 67
(21279, 8750, 1, 1, 2, 26.121908), -- High-Grade Life Stone - Level 67
(21279, 8760, 1, 1, 2, 5.138736), -- Top-Grade Life Stone - Level 67
-- Antelope
(21280, 5478, 1, 1, -1, 27120), -- Sealed Dark Crystal Leather Armor Pattern
(21280, 729, 1, 1, -1, 358), -- Scroll: Enchant Weapon (A-Grade)
(21280, 4040, 1, 1, -1, 64502), -- Mold Lubricant
(21280, 57, 1276, 2593, 0, 700000), -- Adena
(21280, 11957, 1, 1, 1, 43.70229), -- Common Item - Tallum Blade
(21280, 5548, 1, 1, 1, 540.108065), -- Tallum Blade Edge
(21280, 11952, 1, 1, 1, 43.70229), -- Common Item - Elemental Sword
(21280, 5547, 1, 1, 1, 540.108065), -- Elemental Sword Edge
(21280, 11954, 1, 1, 1, 43.70229), -- Common Item - Inferno Master
(21280, 8331, 1, 1, 1, 541.677), -- Infernal Master Blade
(21280, 1865, 1, 1, 2, 95265.321776), -- Varnish
(21280, 1870, 1, 1, 2, 95265.321776), -- Coal
(21280, 1879, 1, 1, 2, 15877.517504), -- Cokes
(21280, 1875, 1, 1, 2, 6351.050352), -- Stone of Purity
(21280, 4040, 1, 1, 2, 1905.25008), -- Mold Lubricant
(21280, 6339, 1, 1, 2, 732.838512), -- Recipe: Sealed Majestic Ring(70%)
(21280, 8730, 1, 1, 2, 1058.400016), -- Life Stone - Level 67
(21280, 8740, 1, 1, 2, 264.654192), -- Mid-Grade Life Stone - Level 67
(21280, 8750, 1, 1, 2, 26.443744), -- High-Grade Life Stone - Level 67
(21280, 8760, 1, 1, 2, 5.202048), -- Top-Grade Life Stone - Level 67
-- Bandersnatch
(21282, 5536, 1, 1, -1, 11253), -- Bloody Orchid Head
(21282, 729, 1, 1, -1, 368), -- Scroll: Enchant Weapon (A-Grade)
(21282, 4040, 1, 1, -1, 66152), -- Mold Lubricant
(21282, 57, 1309, 2658, 0, 700000), -- Adena
(21282, 11957, 1, 1, 1, 44.82414), -- Common Item - Tallum Blade
(21282, 5548, 1, 1, 1, 553.97279), -- Tallum Blade Edge
(21282, 11952, 1, 1, 1, 44.82414), -- Common Item - Elemental Sword
(21282, 5547, 1, 1, 1, 553.97279), -- Elemental Sword Edge
(21282, 11954, 1, 1, 1, 44.82414), -- Common Item - Inferno Master
(21282, 8331, 1, 1, 1, 555.582), -- Infernal Master Blade
(21282, 1865, 1, 1, 2, 97701.271628), -- Varnish
(21282, 1870, 1, 1, 2, 97701.271628), -- Coal
(21282, 1879, 1, 1, 2, 16283.619131), -- Cokes
(21282, 1875, 1, 1, 2, 6513.314705), -- Stone of Purity
(21282, 4040, 1, 1, 2, 1954.105201), -- Mold Lubricant
(21282, 5456, 1, 1, 2, 36.117377), -- Recipe: Tallum Glaive(60%)
(21282, 8730, 1, 1, 2, 1085.515521), -- Life Stone - Level 67
(21282, 8740, 1, 1, 2, 271.434275), -- Mid-Grade Life Stone - Level 67
(21282, 8750, 1, 1, 2, 27.032638), -- High-Grade Life Stone - Level 67
(21282, 8760, 1, 1, 2, 5.317896), -- Top-Grade Life Stone - Level 67
-- Bandersnatch
(21283, 5536, 1, 1, -1, 11326), -- Bloody Orchid Head
(21283, 729, 1, 1, -1, 370), -- Scroll: Enchant Weapon (A-Grade)
(21283, 4040, 1, 1, -1, 66581), -- Mold Lubricant
(21283, 57, 1318, 2676, 0, 700000), -- Adena
(21283, 11957, 1, 1, 1, 45.1233), -- Common Item - Tallum Blade
(21283, 5548, 1, 1, 1, 557.67005), -- Tallum Blade Edge
(21283, 11952, 1, 1, 1, 45.1233), -- Common Item - Elemental Sword
(21283, 5547, 1, 1, 1, 557.67005), -- Elemental Sword Edge
(21283, 11954, 1, 1, 1, 45.1233), -- Common Item - Inferno Master
(21283, 8331, 1, 1, 1, 559.29), -- Infernal Master Blade
(21283, 1865, 1, 1, 2, 98334.890912), -- Varnish
(21283, 1870, 1, 1, 2, 98334.890912), -- Coal
(21283, 1879, 1, 1, 2, 16389.222824), -- Cokes
(21283, 1875, 1, 1, 2, 6555.55532), -- Stone of Purity
(21283, 4040, 1, 1, 2, 1966.778104), -- Mold Lubricant
(21283, 5456, 1, 1, 2, 36.351608), -- Recipe: Tallum Glaive(60%)
(21283, 8730, 1, 1, 2, 1092.555384), -- Life Stone - Level 67
(21283, 8740, 1, 1, 2, 273.1946), -- Mid-Grade Life Stone - Level 67
(21283, 8750, 1, 1, 2, 27.207952), -- High-Grade Life Stone - Level 67
(21283, 8760, 1, 1, 2, 5.352384), -- Top-Grade Life Stone - Level 67
-- Bandersnatch
(21284, 5536, 1, 1, -1, 11188), -- Bloody Orchid Head
(21284, 729, 1, 1, -1, 365), -- Scroll: Enchant Weapon (A-Grade)
(21284, 4040, 1, 1, -1, 65771), -- Mold Lubricant
(21284, 57, 1302, 2643, 0, 700000), -- Adena
(21284, 11957, 1, 1, 1, 44.57484), -- Common Item - Tallum Blade
(21284, 5548, 1, 1, 1, 550.89174), -- Tallum Blade Edge
(21284, 11952, 1, 1, 1, 44.57484), -- Common Item - Elemental Sword
(21284, 5547, 1, 1, 1, 550.89174), -- Elemental Sword Edge
(21284, 11954, 1, 1, 1, 44.57484), -- Common Item - Inferno Master
(21284, 8331, 1, 1, 1, 552.492), -- Infernal Master Blade
(21284, 1865, 1, 1, 2, 97138.201464), -- Varnish
(21284, 1870, 1, 1, 2, 97138.201464), -- Coal
(21284, 1879, 1, 1, 2, 16189.773678), -- Cokes
(21284, 1875, 1, 1, 2, 6475.77729), -- Stone of Purity
(21284, 4040, 1, 1, 2, 1942.843338), -- Mold Lubricant
(21284, 5456, 1, 1, 2, 35.909226), -- Recipe: Tallum Glaive(60%)
(21284, 8730, 1, 1, 2, 1079.259498), -- Life Stone - Level 67
(21284, 8740, 1, 1, 2, 269.86995), -- Mid-Grade Life Stone - Level 67
(21284, 8750, 1, 1, 2, 26.876844), -- High-Grade Life Stone - Level 67
(21284, 8760, 1, 1, 2, 5.287248), -- Top-Grade Life Stone - Level 67
-- Buffalo
(21286, 5549, 1, 1, -1, 341557), -- Metallic Thread
(21286, 1889, 1, 1, -1, 227705), -- Compound Braid
(21286, 6343, 1, 1, -1, 73029), -- Sealed Phoenix Necklace Beads
(21286, 57, 1351, 2748, 0, 700000), -- Adena
(21286, 12224, 1, 1, 1, 549.524654), -- Common Item - Sealed Dark Crystal Boots
(21286, 5496, 1, 1, 1, 2956.975346), -- Sealed Dark Crystal Boots Lining
(21286, 12231, 1, 1, 1, 549.524654), -- Common Item - Sealed Tallum Boots
(21286, 5497, 1, 1, 1, 2956.975346), -- Sealed Tallum Boots Lining
(21286, 12221, 1, 1, 1, 549.524654), -- Common Item - Sealed Dark Crystal Gloves
(21286, 5508, 1, 1, 1, 2956.975346), -- Sealed Dark Crystal Gloves Design
(21286, 12229, 1, 1, 1, 549.524654), -- Common Item - Sealed Tallum Gloves
(21286, 5509, 1, 1, 1, 2956.975346), -- Sealed Tallum Gloves Design
(21286, 1868, 1, 1, 2, 201781.465144), -- Thread
(21286, 1873, 1, 1, 2, 40356.398544), -- Silver Nugget
(21286, 5549, 1, 1, 2, 10089.099636), -- Metallic Thread
(21286, 1889, 1, 1, 2, 6726.066424), -- Compound Braid
(21286, 4044, 1, 1, 2, 3363.033212), -- Thons
(21286, 5440, 1, 1, 2, 37.457896), -- Recipe: Elysian(60%)
(21286, 8730, 1, 1, 2, 1121.099), -- Life Stone - Level 67
(21286, 8740, 1, 1, 2, 280.142856), -- Mid-Grade Life Stone - Level 67
(21286, 8750, 1, 1, 2, 27.961528), -- High-Grade Life Stone - Level 67
(21286, 8760, 1, 1, 2, 5.27576), -- Top-Grade Life Stone - Level 67
-- Buffalo
(21287, 5549, 1, 1, -1, 339589), -- Metallic Thread
(21287, 1889, 1, 1, -1, 226392), -- Compound Braid
(21287, 6343, 1, 1, -1, 72608), -- Sealed Phoenix Necklace Beads
(21287, 57, 1343, 2732, 0, 700000), -- Adena
(21287, 12224, 1, 1, 1, 546.351155), -- Common Item - Sealed Dark Crystal Boots
(21287, 5496, 1, 1, 1, 2939.898845), -- Sealed Dark Crystal Boots Lining
(21287, 12231, 1, 1, 1, 546.351155), -- Common Item - Sealed Tallum Boots
(21287, 5497, 1, 1, 1, 2939.898845), -- Sealed Tallum Boots Lining
(21287, 12221, 1, 1, 1, 546.351155), -- Common Item - Sealed Dark Crystal Gloves
(21287, 5508, 1, 1, 1, 2939.898845), -- Sealed Dark Crystal Gloves Design
(21287, 12229, 1, 1, 1, 546.351155), -- Common Item - Sealed Tallum Gloves
(21287, 5509, 1, 1, 1, 2939.898845), -- Sealed Tallum Gloves Design
(21287, 1868, 1, 1, 2, 200618.759384), -- Thread
(21287, 1873, 1, 1, 2, 40123.856784), -- Silver Nugget
(21287, 5549, 1, 1, 2, 10030.964196), -- Metallic Thread
(21287, 1889, 1, 1, 2, 6687.309464), -- Compound Braid
(21287, 4044, 1, 1, 2, 3343.654732), -- Thons
(21287, 5440, 1, 1, 2, 37.242056), -- Recipe: Elysian(60%)
(21287, 8730, 1, 1, 2, 1114.639), -- Life Stone - Level 67
(21287, 8740, 1, 1, 2, 278.528616), -- Mid-Grade Life Stone - Level 67
(21287, 8750, 1, 1, 2, 27.800408), -- High-Grade Life Stone - Level 67
(21287, 8760, 1, 1, 2, 5.24536), -- Top-Grade Life Stone - Level 67
-- Buffalo
(21288, 5549, 1, 1, -1, 343772), -- Metallic Thread
(21288, 1889, 1, 1, -1, 229181), -- Compound Braid
(21288, 6343, 1, 1, -1, 73503), -- Sealed Phoenix Necklace Beads
(21288, 57, 1360, 2766, 0, 700000), -- Adena
(21288, 12224, 1, 1, 1, 553.089943), -- Common Item - Sealed Dark Crystal Boots
(21288, 5496, 1, 1, 1, 2976.160057), -- Sealed Dark Crystal Boots Lining
(21288, 12231, 1, 1, 1, 553.089943), -- Common Item - Sealed Tallum Boots
(21288, 5497, 1, 1, 1, 2976.160057), -- Sealed Tallum Boots Lining
(21288, 12221, 1, 1, 1, 553.089943), -- Common Item - Sealed Dark Crystal Gloves
(21288, 5508, 1, 1, 1, 2976.160057), -- Sealed Dark Crystal Gloves Design
(21288, 12229, 1, 1, 1, 553.089943), -- Common Item - Sealed Tallum Gloves
(21288, 5509, 1, 1, 1, 2976.160057), -- Sealed Tallum Gloves Design
(21288, 1868, 1, 1, 2, 203089.509124), -- Thread
(21288, 1873, 1, 1, 2, 40618.008024), -- Silver Nugget
(21288, 5549, 1, 1, 2, 10154.502006), -- Metallic Thread
(21288, 1889, 1, 1, 2, 6769.668004), -- Compound Braid
(21288, 4044, 1, 1, 2, 3384.834002), -- Thons
(21288, 5440, 1, 1, 2, 37.700716), -- Recipe: Elysian(60%)
(21288, 8730, 1, 1, 2, 1128.3665), -- Life Stone - Level 67
(21288, 8740, 1, 1, 2, 281.958876), -- Mid-Grade Life Stone - Level 67
(21288, 8750, 1, 1, 2, 28.142788), -- High-Grade Life Stone - Level 67
(21288, 8760, 1, 1, 2, 5.30996), -- Top-Grade Life Stone - Level 67
-- Grendel
(21290, 730, 1, 1, -1, 2349), -- Scroll: Enchant Armor (A-Grade)
(21290, 4041, 1, 1, -1, 24508), -- Mold Hardener
(21290, 1875, 1, 1, -1, 187895), -- Stone of Purity
(21290, 57, 1391, 2835, 0, 700000), -- Adena
(21290, 11957, 1, 1, 1, 47.74095), -- Common Item - Tallum Blade
(21290, 5548, 1, 1, 1, 590.021075), -- Tallum Blade Edge
(21290, 11952, 1, 1, 1, 47.74095), -- Common Item - Elemental Sword
(21290, 5547, 1, 1, 1, 590.021075), -- Elemental Sword Edge
(21290, 11954, 1, 1, 1, 47.74095), -- Common Item - Inferno Master
(21290, 8331, 1, 1, 1, 591.735), -- Infernal Master Blade
(21290, 1872, 1, 1, 2, 138752.735056), -- Animal Bone
(21290, 1867, 1, 1, 2, 138752.735056), -- Animal Skin
(21290, 1881, 1, 1, 2, 13875.333654), -- Coarse Bone Powder
(21290, 1875, 1, 1, 2, 6937.516456), -- Stone of Purity
(21290, 4041, 1, 1, 2, 904.932678), -- Mold Hardener
(21290, 5456, 1, 1, 2, 38.494976), -- Recipe: Tallum Glaive(60%)
(21290, 8730, 1, 1, 2, 1156.35299), -- Life Stone - Level 67
(21290, 8740, 1, 1, 2, 289.013062), -- Mid-Grade Life Stone - Level 67
(21290, 8750, 1, 1, 2, 28.871232), -- High-Grade Life Stone - Level 67
(21290, 8760, 1, 1, 2, 6.01484), -- Top-Grade Life Stone - Level 67
-- Grendel
(21291, 730, 1, 1, -1, 2335), -- Scroll: Enchant Armor (A-Grade)
(21291, 4041, 1, 1, -1, 24367), -- Mold Hardener
(21291, 1875, 1, 1, -1, 186812), -- Stone of Purity
(21291, 57, 1383, 2819, 0, 700000), -- Adena
(21291, 11957, 1, 1, 1, 47.46672), -- Common Item - Tallum Blade
(21291, 5548, 1, 1, 1, 586.63192), -- Tallum Blade Edge
(21291, 11952, 1, 1, 1, 47.46672), -- Common Item - Elemental Sword
(21291, 5547, 1, 1, 1, 586.63192), -- Elemental Sword Edge
(21291, 11954, 1, 1, 1, 47.46672), -- Common Item - Inferno Master
(21291, 8331, 1, 1, 1, 588.336), -- Infernal Master Blade
(21291, 1872, 1, 1, 2, 137953.184312), -- Animal Bone
(21291, 1867, 1, 1, 2, 137953.184312), -- Animal Skin
(21291, 1881, 1, 1, 2, 13795.378233), -- Coarse Bone Powder
(21291, 1875, 1, 1, 2, 6897.539612), -- Stone of Purity
(21291, 4041, 1, 1, 2, 899.718081), -- Mold Hardener
(21291, 5456, 1, 1, 2, 38.273152), -- Recipe: Tallum Glaive(60%)
(21291, 8730, 1, 1, 2, 1149.689605), -- Life Stone - Level 67
(21291, 8740, 1, 1, 2, 287.347649), -- Mid-Grade Life Stone - Level 67
(21291, 8750, 1, 1, 2, 28.704864), -- High-Grade Life Stone - Level 67
(21291, 8760, 1, 1, 2, 5.98018), -- Top-Grade Life Stone - Level 67
-- Grendel
(21292, 730, 1, 1, -1, 2364), -- Scroll: Enchant Armor (A-Grade)
(21292, 4041, 1, 1, -1, 24667), -- Mold Hardener
(21292, 1875, 1, 1, -1, 189113), -- Stone of Purity
(21292, 57, 1400, 2853, 0, 700000), -- Adena
(21292, 11957, 1, 1, 1, 48.06504), -- Common Item - Tallum Blade
(21292, 5548, 1, 1, 1, 594.02644), -- Tallum Blade Edge
(21292, 11952, 1, 1, 1, 48.06504), -- Common Item - Elemental Sword
(21292, 5547, 1, 1, 1, 594.02644), -- Elemental Sword Edge
(21292, 11954, 1, 1, 1, 48.06504), -- Common Item - Inferno Master
(21292, 8331, 1, 1, 1, 595.752), -- Infernal Master Blade
(21292, 1872, 1, 1, 2, 139652.402656), -- Animal Bone
(21292, 1867, 1, 1, 2, 139652.402656), -- Animal Skin
(21292, 1881, 1, 1, 2, 13965.300804), -- Coarse Bone Powder
(21292, 1875, 1, 1, 2, 6982.499056), -- Stone of Purity
(21292, 4041, 1, 1, 2, 910.800228), -- Mold Hardener
(21292, 5456, 1, 1, 2, 38.744576), -- Recipe: Tallum Glaive(60%)
(21292, 8730, 1, 1, 2, 1163.85074), -- Life Stone - Level 67
(21292, 8740, 1, 1, 2, 290.887012), -- Mid-Grade Life Stone - Level 67
(21292, 8750, 1, 1, 2, 29.058432), -- High-Grade Life Stone - Level 67
(21292, 8760, 1, 1, 2, 6.05384), -- Top-Grade Life Stone - Level 67
-- Canyon Antelope
(21294, 5486, 1, 1, -1, 33941), -- Sealed Dark Crystal Robe Fabric
(21294, 5442, 1, 1, -1, 2124), -- Recipe: Soul Bow(60%)
(21294, 5489, 1, 1, -1, 75707), -- Sealed Tallum Stockings Fabric
(21294, 57, 2269, 4612, 0, 700000), -- Adena
(21294, 11957, 1, 1, 1, 77.73174), -- Common Item - Tallum Blade
(21294, 5548, 1, 1, 1, 960.67139), -- Tallum Blade Edge
(21294, 11952, 1, 1, 1, 77.73174), -- Common Item - Elemental Sword
(21294, 5547, 1, 1, 1, 960.67139), -- Elemental Sword Edge
(21294, 11954, 1, 1, 1, 77.73174), -- Common Item - Inferno Master
(21294, 8331, 1, 1, 1, 963.462), -- Infernal Master Blade
(21294, 1869, 1, 1, 2, 169431.236205), -- Iron Ore
(21294, 1864, 1, 3, 2, 169431.236205), -- Stem
(21294, 1880, 1, 1, 2, 16943.013765), -- Steel
(21294, 5550, 1, 1, 2, 2258.995265), -- Durable Metal Plate
(21294, 4043, 1, 1, 2, 5647.671255), -- Asofe
(21294, 5440, 1, 1, 2, 62.617635), -- Recipe: Elysian(60%)
(21294, 8730, 1, 1, 2, 1882.557085), -- Life Stone - Level 67
(21294, 8740, 1, 1, 2, 470.547725), -- Mid-Grade Life Stone - Level 67
(21294, 8750, 1, 1, 2, 47.237865), -- High-Grade Life Stone - Level 67
(21294, 8760, 1, 1, 2, 9.886995), -- Top-Grade Life Stone - Level 67
-- Canyon Antelope Slave
(21295, 5547, 1, 1, -1, 20750), -- Elemental Sword Edge
(21295, 5442, 1, 1, -1, 2259), -- Recipe: Soul Bow(60%)
(21295, 5548, 1, 1, -1, 20750), -- Tallum Blade Edge
(21295, 57, 2414, 4902, 0, 700000), -- Adena
(21295, 11957, 1, 1, 1, 82.66788), -- Common Item - Tallum Blade
(21295, 5548, 1, 1, 1, 1021.67618), -- Tallum Blade Edge
(21295, 11952, 1, 1, 1, 82.66788), -- Common Item - Elemental Sword
(21295, 5547, 1, 1, 1, 1021.67618), -- Elemental Sword Edge
(21295, 11954, 1, 1, 1, 82.66788), -- Common Item - Inferno Master
(21295, 8331, 1, 1, 1, 1024.644), -- Infernal Master Blade
(21295, 1869, 1, 3, 2, 100086.186912), -- Iron Ore
(21295, 1864, 1, 3, 2, 300258.560736), -- Stem
(21295, 1880, 1, 1, 2, 30025.67784), -- Steel
(21295, 5550, 1, 1, 2, 4003.57224), -- Durable Metal Plate
(21295, 4043, 1, 1, 2, 10008.707808), -- Asofe
(21295, 10304, 1, 1, 2, 1201.294464), -- Transformation Sealbook: Saber Tooth Tiger
-- Canyon Bandersnatch 
(21296, 5482, 1, 1, -1, 120055), -- Sealed Dark Crystal Leggings Design
(21296, 5440, 1, 1, -1, 3369), -- Recipe: Elysian(60%)
(21296, 5485, 1, 1, -1, 76488), -- Sealed Tallum Tunic Texture
(21296, 57, 3597, 7319, 0, 700000), -- Adena
(21296, 11955, 1, 1, 1, 369.855732), -- Common Item - Carnage Bow
(21296, 5535, 1, 1, 1, 4584.144268), -- Carnage Bow Stave
(21296, 1872, 4, 12, 2, 74633.468013), -- Animal Bone
(21296, 1867, 1, 3, 2, 199022.458401), -- Animal Skin
(21296, 1881, 1, 1, 2, 59706.62685), -- Coarse Bone Powder
(21296, 1875, 1, 1, 2, 29853.313425), -- Stone of Purity
(21296, 4041, 1, 1, 2, 3893.750055), -- Mold Hardener
(21296, 10304, 1, 1, 2, 1791.383256), -- Transformation Sealbook: Saber Tooth Tiger
-- Canyon Bandersnatch Slave
(21297, 5450, 1, 1, -1, 2714), -- Recipe: Dragon Grinder(60%)
(21297, 6345, 1, 1, -1, 280279), -- Sealed Phoenix Ring Gemstone
(21297, 5456, 1, 1, -1, 2714), -- Recipe: Tallum Glaive(60%)
(21297, 57, 3615, 7369, 0, 700000), -- Adena
(21297, 11951, 1, 1, 1, 372.343692), -- Common Item - Bloody Orchid
(21297, 5536, 1, 1, 1, 4601.656308), -- Bloody Orchid Head
(21297, 1873, 2, 6, 2, 45086.013615), -- Silver Nugget
(21297, 1868, 3, 9, 2, 150287.276958), -- Thread
(21297, 1876, 1, 1, 2, 90172.450911), -- Mithril Ore
(21297, 1895, 1, 1, 2, 128817.665964), -- Metallic Fiber
(21297, 4042, 1, 1, 2, 7514.406216), -- Enria
(21297, 10304, 1, 1, 2, 1803.186336), -- Transformation Sealbook: Saber Tooth Tiger
-- Eye of Restrainer 
(21298, 5478, 1, 1, -1, 39651), -- Sealed Dark Crystal Leather Armor Pattern
(21298, 730, 1, 1, -1, 3929), -- Scroll: Enchant Armor (A-Grade)
(21298, 1895, 1, 3, -1, 673616), -- Metallic Fiber
(21298, 57, 2327, 4743, 0, 700000), -- Adena
(21298, 12224, 1, 1, 1, 948.288516), -- Common Item - Sealed Dark Crystal Boots
(21298, 5496, 1, 1, 1, 5102.711484), -- Sealed Dark Crystal Boots Lining
(21298, 12231, 1, 1, 1, 948.288516), -- Common Item - Sealed Tallum Boots
(21298, 5497, 1, 1, 1, 5102.711484), -- Sealed Tallum Boots Lining
(21298, 12221, 1, 1, 1, 948.288516), -- Common Item - Sealed Dark Crystal Gloves
(21298, 5508, 1, 1, 1, 5102.711484), -- Sealed Dark Crystal Gloves Design
(21298, 12229, 1, 1, 1, 948.288516), -- Common Item - Sealed Tallum Gloves
(21298, 5509, 1, 1, 1, 5102.711484), -- Sealed Tallum Gloves Design
(21298, 1873, 1, 1, 2, 58034.635828), -- Silver Nugget
(21298, 1868, 1, 3, 2, 145087.049892), -- Thread
(21298, 1876, 1, 1, 2, 29017.317914), -- Mithril Ore
(21298, 1895, 1, 1, 2, 41453.377066), -- Metallic Fiber
(21298, 4042, 1, 1, 2, 2418.071466), -- Enria
(21298, 5167, 1, 1, 2, 64.44508), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21298, 5380, 1, 1, 2, 824.436702), -- Recipe: Sealed Boots of Nightmare(60%)
(21298, 8730, 1, 1, 2, 1612.047644), -- Life Stone - Level 67
(21298, 8740, 1, 1, 2, 403.242072), -- Mid-Grade Life Stone - Level 67
(21298, 8750, 1, 1, 2, 40.508336), -- High-Grade Life Stone - Level 67
(21298, 8760, 1, 1, 2, 8.285796), -- Top-Grade Life Stone - Level 67
(21298, 1344, 10, 30, 2, 181358.582204), -- Mithril Arrow
-- Buffalo Slave
(21299, 5508, 1, 1, -1, 177046), -- Sealed Dark Crystal Gloves Design
(21299, 729, 1, 1, -1, 839), -- Scroll: Enchant Weapon (A-Grade)
(21299, 4041, 1, 1, -1, 65661), -- Mold Hardener
(21299, 57, 3724, 7603, 0, 700000), -- Adena
(21299, 11957, 1, 1, 1, 127.91583), -- Common Item - Tallum Blade
(21299, 5548, 1, 1, 1, 1580.886755), -- Tallum Blade Edge
(21299, 11952, 1, 1, 1, 127.91583), -- Common Item - Elemental Sword
(21299, 5547, 1, 1, 1, 1580.886755), -- Elemental Sword Edge
(21299, 11954, 1, 1, 1, 127.91583), -- Common Item - Inferno Master
(21299, 8331, 1, 1, 1, 1585.479), -- Infernal Master Blade
(21299, 1872, 1, 3, 2, 154892.866007), -- Animal Bone
(21299, 1867, 1, 3, 2, 103262.166656), -- Animal Skin
(21299, 1881, 1, 1, 2, 30978.496406), -- Coarse Bone Powder
(21299, 1875, 1, 1, 2, 15489.248203), -- Stone of Purity
(21299, 4041, 1, 1, 2, 2020.486974), -- Mold Hardener
(21299, 5157, 1, 1, 2, 103.289813), -- Recipe: Soulshot (S) Compressed Package (100%)
(21299, 5382, 1, 1, 2, 1320.112926), -- Recipe: Sealed Majestic Boots(60%)
(21299, 8730, 1, 1, 2, 2581.477371), -- Life Stone - Level 67
(21299, 8740, 1, 1, 2, 645.465337), -- Mid-Grade Life Stone - Level 67
(21299, 8750, 1, 1, 2, 64.508136), -- High-Grade Life Stone - Level 67
(21299, 8760, 1, 1, 2, 13.055218), -- Top-Grade Life Stone - Level 67
(21299, 1344, 40, 120, 2, 72605.826953), -- Mithril Arrow
-- Eye of Guide
(21300, 1895, 1, 5, -1, 707483), -- Metallic Fiber
(21300, 5509, 1, 1, -1, 174175), -- Sealed Tallum Gloves Design
(21300, 5434, 1, 1, -1, 2751), -- Recipe: Dragon Slayer(60%)
(21300, 57, 3663, 7480, 0, 700000), -- Adena
(21300, 11946, 1, 1, 1, 94.390996), -- Common Item - Dasparion's Staff
(21300, 5543, 1, 1, 1, 1167.154464), -- Dasparion's Staff Head
(21300, 11949, 1, 1, 1, 94.390996), -- Common Item - Meteor Shower
(21300, 5532, 1, 1, 1, 1156.253364), -- Meteor Shower Head
(21300, 11953, 1, 1, 1, 94.390996), -- Common Item - Spiritual Eye
(21300, 8341, 1, 1, 1, 1154.774824), -- Spiritual Eye Piece
(21300, 11958, 1, 1, 1, 94.390996), -- Common Item - Destroyer Hammer
(21300, 8346, 1, 1, 1, 1156.253364), -- Hammer Piece of Destroyer
(21300, 1895, 1, 1, 2, 87074.879346), -- Metallic Fiber
(21300, 4040, 1, 1, 2, 6095.186244), -- Mold Lubricant
(21300, 4042, 1, 1, 2, 5079.397122), -- Enria
(21300, 4043, 1, 1, 2, 10158.681366), -- Asofe
(21300, 5162, 1, 1, 2, 135.4536), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21300, 8730, 1, 1, 2, 3386.227122), -- Life Stone - Level 67
(21300, 8740, 1, 1, 2, 846.585), -- Mid-Grade Life Stone - Level 67
(21300, 8750, 1, 1, 2, 84.6585), -- High-Grade Life Stone - Level 67
(21300, 8760, 1, 1, 2, 16.9317), -- Top-Grade Life Stone - Level 67
-- Gaze of Nightmare
(21301, 5520, 1, 1, -1, 57484), -- Sealed Dark Crystal Breastplate Pattern
(21301, 5440, 1, 1, -1, 3302), -- Recipe: Elysian(60%)
(21301, 5521, 1, 1, -1, 40563), -- Sealed Tallum Plate Armor Pattern
(21301, 57, 4396, 8976, 0, 700000), -- Adena
(21301, 11950, 1, 1, 1, 453.070422), -- Common Item - Blood Tornado
(21301, 5539, 1, 1, 1, 5549.929578), -- Blood Tornado Edge
(21301, 1868, 4, 12, 2, 68571.48648), -- Thread
(21301, 1873, 1, 1, 2, 109714.44897), -- Silver Nugget
(21301, 5549, 1, 1, 2, 27428.52399), -- Metallic Thread
(21301, 1889, 1, 1, 2, 18285.56499), -- Compound Braid
(21301, 4044, 1, 1, 2, 9142.959), -- Thons
(21301, 5167, 1, 1, 2, 121.78845), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21301, 5404, 1, 1, 2, 1558.53915), -- Recipe: Sealed Gauntlets of Nightmare(60%)
(21301, 8730, 1, 1, 2, 3047.53533), -- Life Stone - Level 67
(21301, 8740, 1, 1, 2, 761.79558), -- Mid-Grade Life Stone - Level 67
(21301, 8750, 1, 1, 2, 76.25016), -- High-Grade Life Stone - Level 67
(21301, 8760, 1, 1, 2, 15.17943), -- Top-Grade Life Stone - Level 67
(21301, 1344, 30, 90, 2, 114285.92847), -- Mithril Arrow
-- Eye of Watchman
(21302, 729, 1, 1, -1, 799), -- Scroll: Enchant Weapon (A-Grade)
(21302, 1875, 1, 1, -1, 479548), -- Stone of Purity
(21302, 4041, 1, 1, -1, 62550), -- Mold Hardener
(21302, 57, 3552, 7232, 0, 700000), -- Adena
(21302, 11957, 1, 1, 1, 121.85784), -- Common Item - Tallum Blade
(21302, 5548, 1, 1, 1, 1506.01724), -- Tallum Blade Edge
(21302, 11952, 1, 1, 1, 121.85784), -- Common Item - Elemental Sword
(21302, 5547, 1, 1, 1, 1506.01724), -- Elemental Sword Edge
(21302, 11954, 1, 1, 1, 121.85784), -- Common Item - Inferno Master
(21302, 8331, 1, 1, 1, 1510.392), -- Infernal Master Blade
(21302, 1872, 1, 3, 2, 160967.013024), -- Animal Bone
(21302, 1867, 1, 3, 2, 107311.342016), -- Animal Skin
(21302, 1881, 1, 1, 2, 32193.338003), -- Coarse Bone Powder
(21302, 1875, 1, 1, 2, 16096.830506), -- Stone of Purity
(21302, 4041, 1, 1, 2, 2099.5585), -- Mold Hardener
(21302, 5162, 1, 1, 2, 107.238988), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21302, 5382, 1, 1, 2, 1371.819223), -- Recipe: Sealed Majestic Boots(60%)
(21302, 8731, 1, 1, 2, 2235.545289), -- Life Stone - Level 70
(21302, 8741, 1, 1, 2, 558.80557), -- Mid-Grade Life Stone - Level 70
(21302, 8751, 1, 1, 2, 55.880557), -- High-Grade Life Stone - Level 70
(21302, 8761, 1, 1, 2, 11.628324), -- Top-Grade Life Stone - Level 70
-- Homunculus
(21303, 5547, 1, 1, -1, 24748), -- Elemental Sword Edge
(21303, 5466, 1, 1, -1, 2694), -- Recipe: Sword of Miracles(60%)
(21303, 5548, 1, 1, -1, 24748), -- Tallum Blade Edge
(21303, 57, 3592, 7313, 0, 700000), -- Adena
(21303, 11946, 1, 1, 1, 92.413531), -- Common Item - Dasparion's Staff
(21303, 5543, 1, 1, 1, 1142.702904), -- Dasparion's Staff Head
(21303, 11949, 1, 1, 1, 92.413531), -- Common Item - Meteor Shower
(21303, 5532, 1, 1, 1, 1132.030179), -- Meteor Shower Head
(21303, 11953, 1, 1, 1, 92.413531), -- Common Item - Spiritual Eye
(21303, 8341, 1, 1, 1, 1130.582614), -- Spiritual Eye Piece
(21303, 11958, 1, 1, 1, 92.413531), -- Common Item - Destroyer Hammer
(21303, 8346, 1, 1, 1, 1132.030179), -- Hammer Piece of Destroyer
(21303, 1872, 1, 3, 2, 149211.132531), -- Animal Bone
(21303, 1867, 1, 3, 2, 99474.088354), -- Animal Skin
(21303, 1881, 1, 1, 2, 29842.152634), -- Coarse Bone Powder
(21303, 1875, 1, 1, 2, 14921.076317), -- Stone of Purity
(21303, 4041, 1, 1, 2, 1946.163109), -- Mold Hardener
(21303, 5167, 1, 1, 2, 99.358109), -- Recipe: Blessed Spiritshot (S) Compressed Package (100%)
(21303, 5406, 1, 1, 2, 1271.709923), -- Recipe: Sealed Majestic Gauntlets(60%)
(21303, 8731, 1, 1, 2, 2072.484571), -- Life Stone - Level 70
(21303, 8741, 1, 1, 2, 518.213483), -- Mid-Grade Life Stone - Level 70
(21303, 8751, 1, 1, 2, 51.71054), -- High-Grade Life Stone - Level 70
(21303, 8761, 1, 1, 2, 10.342108), -- Top-Grade Life Stone - Level 70
(21303, 1344, 40, 120, 2, 69942.568321), -- Mithril Arrow
-- Grendel Slave
(21304, 5542, 1, 1, -1, 36128), -- Halberd Edge
(21304, 5440, 1, 1, -1, 3968), -- Recipe: Elysian(60%)
(21304, 5543, 1, 1, -1, 36469), -- Dasparion's Staff Head
(21304, 57, 5287, 10776, 0, 700000), -- Adena
(21304, 11946, 1, 1, 1, 136.124924), -- Common Item - Dasparion's Staff
(21304, 5543, 1, 1, 1, 1683.198816), -- Dasparion's Staff Head
(21304, 11949, 1, 1, 1, 136.124924), -- Common Item - Meteor Shower
(21304, 5532, 1, 1, 1, 1667.477916), -- Meteor Shower Head
(21304, 11953, 1, 1, 1, 136.124924), -- Common Item - Spiritual Eye
(21304, 8341, 1, 1, 1, 1665.345656), -- Spiritual Eye Piece
(21304, 11958, 1, 1, 1, 136.124924), -- Common Item - Destroyer Hammer
(21304, 8346, 1, 1, 1, 1667.477916), -- Hammer Piece of Destroyer
(21304, 1894, 1, 1, 2, 13879.8519), -- Crafted Leather
(21304, 4039, 1, 1, 2, 13185.637464), -- Mold Glue
(21304, 4041, 1, 1, 2, 3439.718652), -- Mold Hardener
(21304, 4044, 1, 1, 2, 13185.637464), -- Thons
(21304, 5277, 1, 1, 2, 175.698072), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21304, 8731, 1, 1, 2, 3662.742804), -- Life Stone - Level 70
(21304, 8741, 1, 1, 2, 915.759648), -- Mid-Grade Life Stone - Level 70
(21304, 8751, 1, 1, 2, 91.69428), -- High-Grade Life Stone - Level 70
(21304, 8761, 1, 1, 2, 18.338856), -- Top-Grade Life Stone - Level 70
(21304, 1344, 20, 60, 2, 247232.92086), -- Mithril Arrow
-- Eye of Pilgrim
(21305, 730, 1, 1, -1, 6574), -- Scroll: Enchant Armor (A-Grade)
(21305, 4040, 1, 1, -1, 157783), -- Mold Lubricant
(21305, 1877, 1, 1, -1, 315566), -- Adamantite Nugget
(21305, 57, 3893, 7935, 0, 700000), -- Adena
(21305, 11946, 1, 1, 1, 100.229226), -- Common Item - Dasparion's Staff
(21305, 5543, 1, 1, 1, 1239.344784), -- Dasparion's Staff Head
(21305, 11949, 1, 1, 1, 100.229226), -- Common Item - Meteor Shower
(21305, 5532, 1, 1, 1, 1227.769434), -- Meteor Shower Head
(21305, 11953, 1, 1, 1, 100.229226), -- Common Item - Spiritual Eye
(21305, 8341, 1, 1, 1, 1226.199444), -- Spiritual Eye Piece
(21305, 11958, 1, 1, 1, 100.229226), -- Common Item - Destroyer Hammer
(21305, 8346, 1, 1, 1, 1227.769434), -- Hammer Piece of Destroyer
(21305, 1871, 1, 3, 2, 145645.737432), -- Charcoal
(21305, 1866, 1, 1, 2, 194194.074288), -- Suede
(21305, 1877, 1, 1, 2, 11651.62992), -- Adamantite Nugget
(21305, 4041, 1, 1, 2, 2533.12104), -- Mold Hardener
(21305, 4040, 1, 1, 2, 5825.81496), -- Mold Lubricant
(21305, 5282, 1, 1, 2, 129.381792), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21305, 8731, 1, 1, 2, 2697.028872), -- Life Stone - Level 70
(21305, 8741, 1, 1, 2, 674.16636), -- Mid-Grade Life Stone - Level 70
(21305, 8751, 1, 1, 2, 67.598352), -- High-Grade Life Stone - Level 70
(21305, 8761, 1, 1, 2, 13.446984), -- Top-Grade Life Stone - Level 70
-- Disciples of Protection
(21306, 5547, 1, 1, -1, 48569), -- Elemental Sword Edge
(21306, 5442, 1, 1, -1, 5287), -- Recipe: Soul Bow(60%)
(21306, 5548, 1, 1, -1, 48569), -- Tallum Blade Edge
(21306, 57, 7045, 14360, 0, 700000), -- Adena
(21306, 11950, 1, 1, 1, 725.531562), -- Common Item - Blood Tornado
(21306, 5539, 1, 1, 1, 8887.468438), -- Blood Tornado Edge
(21306, 1865, 1, 3, 2, 159728.673824), -- Varnish
(21306, 1870, 2, 6, 2, 119796.622112), -- Coal
(21306, 1879, 1, 1, 2, 79864.5704), -- Cokes
(21306, 1875, 1, 1, 2, 31945.82816), -- Stone of Purity
(21306, 4040, 1, 1, 2, 9583.748448), -- Mold Lubricant
(21306, 6901, 1, 1, 2, 479.117376), -- Recipe: Shining Arrow (100%)
(21306, 8731, 1, 1, 2, 4436.738976), -- Life Stone - Level 70
(21306, 8741, 1, 1, 2, 1109.068), -- Mid-Grade Life Stone - Level 70
(21306, 8751, 1, 1, 2, 111.140288), -- High-Grade Life Stone - Level 70
(21306, 8761, 1, 1, 2, 22.414848), -- Top-Grade Life Stone - Level 70
(21306, 1344, 100, 300, 2, 59898.077568), -- Mithril Arrow
-- Elder Homunculus
(21307, 5480, 1, 1, -1, 45013), -- Sealed Leather Armor of Nightmare Fabric
(21307, 1808, 1, 1, -1, 4458), -- Recipe: Soulshot (S-Grade)
(21307, 5481, 1, 1, -1, 45013), -- Sealed Majestic Leather Armor Fabric
(21307, 57, 4948, 10097, 0, 700000), -- Adena
(21307, 11957, 1, 1, 1, 169.94781), -- Common Item - Tallum Blade
(21307, 5548, 1, 1, 1, 2100.351785), -- Tallum Blade Edge
(21307, 11952, 1, 1, 1, 169.94781), -- Common Item - Elemental Sword
(21307, 5547, 1, 1, 1, 2100.351785), -- Elemental Sword Edge
(21307, 11954, 1, 1, 1, 169.94781), -- Common Item - Inferno Master
(21307, 8331, 1, 1, 1, 2106.453), -- Infernal Master Blade
(21307, 1868, 3, 9, 2, 123464.184746), -- Thread
(21307, 1873, 1, 1, 2, 148157.091746), -- Silver Nugget
(21307, 5549, 1, 1, 2, 37039.3605), -- Metallic Thread
(21307, 1889, 1, 1, 2, 24692.907), -- Compound Braid
(21307, 4044, 1, 1, 2, 12346.4535), -- Thons
(21307, 5277, 1, 1, 2, 164.61938), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21307, 8731, 1, 1, 2, 3429.687168), -- Life Stone - Level 70
(21307, 8741, 1, 1, 2, 857.421792), -- Mid-Grade Life Stone - Level 70
(21307, 8751, 1, 1, 2, 85.81223), -- High-Grade Life Stone - Level 70
(21307, 8761, 1, 1, 2, 16.461938), -- Top-Grade Life Stone - Level 70
-- Disciples of Punishment
(21308, 3036, 1, 1, -1, 5924), -- Recipe: Spiritshot S
(21308, 5487, 1, 1, -1, 60021), -- Sealed Robe of Nightmare Fabric
(21308, 1875, 1, 1, -1, 888584), -- Stone of Purity
(21308, 57, 6575, 13415, 0, 700000), -- Adena
(21308, 11946, 1, 1, 1, 169.346336), -- Common Item - Dasparion's Staff
(21308, 5543, 1, 1, 1, 2093.985024), -- Dasparion's Staff Head
(21308, 11949, 1, 1, 1, 169.346336), -- Common Item - Meteor Shower
(21308, 5532, 1, 1, 1, 2074.427424), -- Meteor Shower Head
(21308, 11953, 1, 1, 1, 169.346336), -- Common Item - Spiritual Eye
(21308, 8341, 1, 1, 1, 2071.774784), -- Spiritual Eye Piece
(21308, 11958, 1, 1, 1, 169.346336), -- Common Item - Destroyer Hammer
(21308, 8346, 1, 1, 1, 2074.427424), -- Hammer Piece of Destroyer
(21308, 1872, 5, 15, 2, 59653.14794), -- Animal Bone
(21308, 1867, 1, 3, 2, 198843.66074), -- Animal Skin
(21308, 1881, 1, 1, 2, 59653.14794), -- Coarse Bone Powder
(21308, 1875, 1, 1, 2, 29826.32538), -- Stone of Purity
(21308, 4041, 1, 1, 2, 3890.4335), -- Mold Hardener
(21308, 5282, 1, 1, 2, 198.872), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21308, 8731, 1, 1, 2, 4142.50376), -- Life Stone - Level 70
(21308, 8741, 1, 1, 2, 1035.62594), -- Mid-Grade Life Stone - Level 70
(21308, 8751, 1, 1, 2, 103.41344), -- High-Grade Life Stone - Level 70
(21308, 8761, 1, 1, 2, 20.88156), -- Top-Grade Life Stone - Level 70
(21308, 1344, 40, 120, 2, 139811.9878), -- Mithril Arrow
-- Disciples of Punishment
(21309, 3036, 1, 1, -1, 6174), -- Recipe: Spiritshot S
(21309, 5487, 1, 1, -1, 62556), -- Sealed Robe of Nightmare Fabric
(21309, 1875, 1, 1, -1, 926118), -- Stone of Purity
(21309, 57, 6853, 13982, 0, 700000), -- Adena
(21309, 11946, 1, 1, 1, 176.502876), -- Common Item - Dasparion's Staff
(21309, 5543, 1, 1, 1, 2182.476384), -- Dasparion's Staff Head
(21309, 11949, 1, 1, 1, 176.502876), -- Common Item - Meteor Shower
(21309, 5532, 1, 1, 1, 2162.092284), -- Meteor Shower Head
(21309, 11953, 1, 1, 1, 176.502876), -- Common Item - Spiritual Eye
(21309, 8341, 1, 1, 1, 2159.327544), -- Spiritual Eye Piece
(21309, 11958, 1, 1, 1, 176.502876), -- Common Item - Destroyer Hammer
(21309, 8346, 1, 1, 1, 2162.092284), -- Hammer Piece of Destroyer
(21309, 1872, 5, 15, 2, 62172.92628), -- Animal Bone
(21309, 1867, 9, 27, 2, 34540.74492), -- Animal Skin
(21309, 1881, 1, 1, 2, 62172.92628), -- Coarse Bone Powder
(21309, 1875, 1, 1, 2, 31086.63588), -- Stone of Purity
(21309, 4041, 1, 1, 2, 4054.89876), -- Mold Hardener
(21309, 5282, 1, 1, 2, 207.288), -- Recipe: Greater Blessed Spiritshot (S) Compressed Package(100%)
(21309, 8731, 1, 1, 2, 4317.46356), -- Life Stone - Level 70
(21309, 8741, 1, 1, 2, 1079.27952), -- Mid-Grade Life Stone - Level 70
(21309, 8751, 1, 1, 2, 107.78976), -- High-Grade Life Stone - Level 70
(21309, 8761, 1, 1, 2, 21.41976), -- Top-Grade Life Stone - Level 70
(21309, 1344, 40, 120, 2, 145718.62728), -- Mithril Arrow
-- Disciples of Authority
(21310, 5549, 1, 3, -1, 571636), -- Metallic Thread
(21310, 5546, 1, 1, -1, 34452), -- Sword of Miracles Edge
(21310, 5162, 1, 1, -1, 5081), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21310, 57, 5625, 11517, 0, 700000), -- Adena
(21310, 11957, 1, 1, 1, 193.68117), -- Common Item - Tallum Blade
(21310, 5548, 1, 1, 1, 2393.667745), -- Tallum Blade Edge
(21310, 11952, 1, 1, 1, 193.68117), -- Common Item - Elemental Sword
(21310, 5547, 1, 1, 1, 2393.667745), -- Elemental Sword Edge
(21310, 11954, 1, 1, 1, 193.68117), -- Common Item - Inferno Master
(21310, 8331, 1, 1, 1, 2400.621), -- Infernal Master Blade
(21310, 1868, 3, 9, 2, 156344.773849), -- Thread
(21310, 1873, 1, 1, 2, 187613.551436), -- Silver Nugget
(21310, 5549, 1, 1, 2, 46903.387859), -- Metallic Thread
(21310, 1889, 1, 1, 2, 31268.777587), -- Compound Braid
(21310, 4044, 1, 1, 2, 15634.610272), -- Thons
(21310, 5157, 1, 1, 2, 208.632747), -- Recipe: Soulshot (S) Compressed Package (100%)
(21310, 8732, 1, 1, 2, 3908.652568), -- Life Stone - Level 76
(21310, 8742, 1, 1, 2, 977.163142), -- Mid-Grade Life Stone - Level 76
(21310, 8752, 1, 1, 2, 97.45054), -- High-Grade Life Stone - Level 76
-- Disciples of Authority
(21311, 5549, 1, 3, -1, 527054), -- Metallic Thread
(21311, 5546, 1, 1, -1, 31765), -- Sword of Miracles Edge
(21311, 5162, 1, 1, -1, 4685), -- Recipe: Spiritshot (S) Compressed Package (100%)
(21311, 57, 5186, 10619, 0, 700000), -- Adena
(21311, 11957, 1, 1, 1, 178.57359), -- Common Item - Tallum Blade
(21311, 5548, 1, 1, 1, 2206.956115), -- Tallum Blade Edge
(21311, 11952, 1, 1, 1, 178.57359), -- Common Item - Elemental Sword
(21311, 5547, 1, 1, 1, 2206.956115), -- Elemental Sword Edge
(21311, 11954, 1, 1, 1, 178.57359), -- Common Item - Inferno Master
(21311, 8331, 1, 1, 1, 2213.367), -- Infernal Master Blade
(21311, 1868, 3, 9, 2, 144151.521327), -- Thread
(21311, 1873, 1, 1, 2, 172981.662228), -- Silver Nugget
(21311, 5549, 1, 1, 2, 43245.415557), -- Metallic Thread
(21311, 1889, 1, 1, 2, 28830.140901), -- Compound Braid
(21311, 4044, 1, 1, 2, 14415.274656), -- Thons
(21311, 5157, 1, 1, 2, 192.361581), -- Recipe: Soulshot (S) Compressed Package (100%)
(21311, 8732, 1, 1, 2, 3603.818664), -- Life Stone - Level 76
(21311, 8742, 1, 1, 2, 900.954666), -- Mid-Grade Life Stone - Level 76
(21311, 8752, 1, 1, 2, 89.85042), -- High-Grade Life Stone - Level 76
-- Eye of Ruler
(21312, 5448, 1, 1, -1, 4041), -- Recipe: Soul Separator(60%)
(21312, 6341, 1, 1, -1, 301763), -- Sealed Phoenix Earring Gemstone
(21312, 729, 1, 1, -1, 1212), -- Scroll: Enchant Weapon (A-Grade)
(21312, 57, 5384, 10974, 0, 700000), -- Adena
(21312, 11955, 1, 1, 1, 554.484966), -- Common Item - Carnage Bow
(21312, 5535, 1, 1, 1, 6872.515034), -- Carnage Bow Stave
(21312, 1866, 1, 3, 2, 89519.913234), -- Suede
(21312, 1871, 1, 3, 2, 201419.281158), -- Charcoal
(21312, 5220, 1, 1, 2, 16113.48664), -- Metal Hardener
(21312, 1885, 1, 1, 2, 33569.880193), -- High-Grade Suede
(21312, 4041, 1, 1, 2, 3503.007765), -- Mold Hardener
(21312, 1808, 1, 1, 2, 179.077527), -- Recipe: Soulshot (S-Grade)
(21312, 8731, 1, 1, 2, 3729.909115), -- Life Stone - Level 70
(21312, 8741, 1, 1, 2, 932.390009), -- Mid-Grade Life Stone - Level 70
(21312, 8751, 1, 1, 2, 93.204093), -- High-Grade Life Stone - Level 70
(21312, 8761, 1, 1, 2, 18.850266), -- Top-Grade Life Stone - Level 70
-- Sly Hound Dog
(21313, 730, 1, 1, -1, 8658), -- Scroll: Enchant Armor (A-Grade)
(21313, 1895, 1, 7, -1, 742151), -- Metallic Fiber
(21313, 4042, 1, 1, -1, 173169), -- Enria
(21313, 57, 5124, 10462, 0, 700000), -- Adena
(21313, 11955, 1, 1, 1, 528.056034), -- Common Item - Carnage Bow
(21313, 5535, 1, 1, 1, 6544.943966), -- Carnage Bow Stave
(21313, 1873, 1, 1, 2, 139503.67112), -- Silver Nugget
(21313, 1868, 3, 9, 2, 116253.42432), -- Thread
(21313, 1876, 1, 1, 2, 69752.054592), -- Mithril Ore
(21313, 1895, 1, 1, 2, 99645.541952), -- Metallic Fiber
(21313, 4042, 1, 1, 2, 5812.671216), -- Enria
(21313, 5272, 1, 1, 2, 155.074656), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21313, 5380, 1, 1, 2, 1981.801536), -- Recipe: Sealed Boots of Nightmare(60%)
(21313, 8730, 1, 1, 2, 3875.114144), -- Life Stone - Level 67
(21313, 8740, 1, 1, 2, 968.559504), -- Mid-Grade Life Stone - Level 67
(21313, 8750, 1, 1, 2, 96.812144), -- High-Grade Life Stone - Level 67
(21313, 8760, 1, 1, 2, 19.274816), -- Top-Grade Life Stone - Level 67
-- Hot Springs Bandersnatchling
(21314, 6335, 1, 1, -1, 22347), -- Recipe: Sealed Majestic Necklace(70%)
(21314, 6341, 1, 1, -1, 160703), -- Sealed Phoenix Earring Gemstone
(21314, 730, 1, 1, -1, 4842), -- Scroll: Enchant Armor (A-Grade)
(21314, 57, 2869, 5842, 0, 700000), -- Adena
(21314, 11950, 1, 1, 1, 295.329762), -- Common Item - Blood Tornado
(21314, 5539, 1, 1, 1, 3617.670238), -- Blood Tornado Edge
(21314, 1895, 1, 1, 2, 68105.16775), -- Metallic Fiber
(21314, 4040, 1, 1, 2, 4767.339812), -- Mold Lubricant
(21314, 4042, 1, 1, 2, 3972.841658), -- Enria
(21314, 4043, 1, 1, 2, 7945.595594), -- Asofe
(21314, 5272, 1, 1, 2, 105.968176), -- Recipe: Greater Soulshot (S) Compressed Package(100%)
(21314, 8731, 1, 1, 2, 2207.08552), -- Life Stone - Level 70
(21314, 8741, 1, 1, 2, 551.77138), -- Mid-Grade Life Stone - Level 70
(21314, 8751, 1, 1, 2, 55.177138), -- High-Grade Life Stone - Level 70
(21314, 8761, 1, 1, 2, 11.052972), -- Top-Grade Life Stone - Level 70
-- Hot Springs Buffalo
(21315, 5549, 1, 1, -1, 605496), -- Metallic Thread
(21315, 1889, 1, 1, -1, 403664), -- Compound Braid
(21315, 6343, 1, 1, -1, 129462), -- Sealed Phoenix Necklace Beads
(21315, 57, 2990, 6088, 0, 700000), -- Adena
(21315, 11955, 1, 1, 1, 307.740276), -- Common Item - Carnage Bow
(21315, 5535, 1, 1, 1, 3814.259724), -- Carnage Bow Stave
(21315, 1868, 1, 3, 2, 203243.393899), -- Thread
(21315, 1873, 1, 1, 2, 81297.275085), -- Silver Nugget
(21315, 5549, 1, 1, 2, 20324.215678), -- Metallic Thread
(21315, 1889, 1, 1, 2, 13549.752034), -- Compound Braid
(21315, 4044, 1, 1, 2, 6774.876017), -- Thons
(21315, 5277, 1, 1, 2, 90.309687), -- Recipe: Greater Spiritshot (S) Compressed Package(100%)
(21315, 8731, 1, 1, 2, 1882.070372), -- Life Stone - Level 70
(21315, 8741, 1, 1, 2, 470.517593), -- Mid-Grade Life Stone - Level 70
(21315, 8751, 1, 1, 2, 47.010522), -- High-Grade Life Stone - Level 70
(21315, 8761, 1, 1, 2, 9.484579), -- Top-Grade Life Stone - Level 70
(21315, 1344, 30, 90, 2, 84684.094534), -- Mithril Arrow
-- Hot Springs Flava
(21316, 5550, 1, 1, -1, 84418), -- Durable Metal Plate
(21316, 4043, 1, 1, -1, 211044), -- Asofe
(21316, 6343, 1, 1, -1, 135372), -- Sealed Phoenix Necklace Beads
(21316, 57, 3124, 6369, 0, 700000), -- Adena
(21316, 11951, 1, 1, 1, 321.814542), -- Common Item -