/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.xml;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StdErrErrorHandler
implements ErrorHandler {
    public void warning(SAXParseException e) {
        System.err.println("[Warning]");
        this.showExceptionInformation(e);
        e.printStackTrace();
    }

    public void error(SAXParseException e) {
        System.err.println("[Error]");
        this.showExceptionInformation(e);
        e.printStackTrace();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("[Fatal Error]");
        this.showExceptionInformation(e);
        e.printStackTrace();
        throw e;
    }

    private void showExceptionInformation(SAXParseException e) {
        System.err.println("[\tLine Number: " + e.getLineNumber() + ']');
        System.err.println("[\tColumn Number: " + e.getColumnNumber() + ']');
        System.err.println("[\tPublic ID: " + e.getPublicId() + ']');
        System.err.println("[\tSystem ID: " + e.getSystemId() + ']');
    }
}

