﻿<?php
mb_language('ja');
mb_internal_encoding('UTF-8');
/**
 * POP before SMTP を使う方法
 *
 * プロパイダや無料メールのサーバを使います。
 * POP before SMTP とは、いちどメールを受信してからでないと送信が出来ない仕組みです。
 * アカウント・パスワードが暗号化されずにネットを流れてしまいます。
 * 過去との互換性のため、対応しているサーバは多いですが
 * あまり積極的には使用されません。
 *
 * 動作確認済メールサーバ：ポート
 *        smtp.mail.yahoo.co.jp:25/110
 *
 * 動作しないメールサーバ：ポート
 *        smtp.mail.yahoo.co.jp:587
 *  ssl://smtp.mail.yahoo.co.jp:465
 *               smtp.gmail.com:587
 *         ssl://smtp.gmail.com:465
 */

function sendmail($to, $subject, $body)
{
	$m = new PopBeforeSmtp();
	return  $m->send($to, $subject, $body);
}

class PopBeforeSmtp
{
	private $debug = FALSE;
	private $sock;

	function send($to, $subject, $body)
	{
		///// あなたの環境にあわせて書き換えてください /////
		// ここから
		$myname = 'L2J スタッフ';
		$from = '**********@*****.com';
		$smtp_server = 'smtp.mail.yahoo.co.jp';
		$pop_server = 'pop.mail.yahoo.co.jp';
		$smtp_port = 25;
		$pop_port = 110;
		$pop_user = '**********';
		$pop_passwd = '**********';
		// ここまで
		////////////////////////////////////////////////////

		if (stristr($body, '<html>') == TRUE) $ContentType = 'text/html';
		else                                  $ContentType = 'text/plain';

		if ($this->debug) {echo '<pre>';}

		// pop3 auth
		$this->sock = @fsockopen($pop_server,$pop_port)
			or die('<br><b>Error</b>: Unable pop server in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');
		$this->cmd(__LINE__, '^\+OK', null);
		$this->cmd(__LINE__, '^\+OK', "USER $pop_user\r\n");
		$this->cmd(__LINE__, '^\+OK', "PASS $pop_passwd\r\n");
		$this->cmd(__LINE__, '^\+OK', "QUIT\r\n");
		fclose($this->sock);

//		sleep(2);

		// smtp
		$this->sock = @fsockopen($smtp_server,$smtp_port)
			or die('<br><b>Error</b>: Unable smtp server in <b>'.basename(__FILE__).'</b> on line <b>'.__LINE__.'</b><br>');
		$this->cmd(__LINE__, '^220', null);
		$this->cmd(__LINE__, '^250', "HELO l2jserver\r\n");
		$this->cmd(__LINE__, '^250', "MAIL FROM:<$from>\r\n");
		$this->cmd(__LINE__, '^250', "RCPT TO:<$to>\r\n");
		$this->cmd(__LINE__, '^354', "DATA\r\n");

		$this->cmd(__LINE__, null, "From:".mb_encode_mimeheader($myname)." <$from>\r\n");
		$this->cmd(__LINE__, null, "To:<$to>\r\n");
		$this->cmd(__LINE__, null, "Subject:".mb_encode_mimeheader($subject)."\r\n");
		$this->cmd(__LINE__, null, "X-Mailer: L2J ACM/PHP\r\n");
		$this->cmd(__LINE__, null, "Content-Transfer-Encoding: 7bit\r\n");
		$this->cmd(__LINE__, null, "Content-Type: $ContentType; charset=iso-2022-jp\r\n");
		$this->cmd(__LINE__, null, "\r\n");

		$this->cmd(__LINE__, null, mb_convert_encoding($body, 'iso-2022-jp', mb_internal_encoding()));

		$this->cmd(__LINE__, '^250', "\r\n.\r\n");
		$this->cmd(__LINE__, '^221', "QUIT\r\n");
		fclose($this->sock);

		if ($this->debug) {echo '</pre>';exit;}
		return TRUE;
	}

	private function cmd($LINE, $check, $data)
	{
		if (! empty($data)) {
			if ($this->debug) echo '<span style="color:#0000FF">DEBUG: Send: ',str_replace('<','&lt;',$data).'</span>';
			fputs($this->sock,$data);
		}
		if (! empty($check)) {
			$result = fgets($this->sock,128);
			$st = stream_get_meta_data($this->sock);
			if ($st['unread_bytes'] > 0)
				$result .= fread($this->sock, $st['unread_bytes']);
			if ($this->debug) echo 'DEBUG: Recv: ',str_replace('<','&lt;',$result);
			if (! ereg($check, $result))
				die('<br><b>Error</b>: '.ereg_replace("[\r\n]","",$result).' in <b>'.basename(__FILE__).'</b> on line <b>'.$LINE.'</b><br>');
		}
	}
}
?>
