/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.ChristmasTree;

import static com.l2jserver.gameserver.util.EventNpcAligner.alignRight;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.event.LongTimeEvent;
import com.l2jserver.gameserver.model.holders.SkillHashCode;
import com.l2jserver.gameserver.model.skills.L2Skill;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;

/**
 * NX}XKT^ 2004 ̏
 * @author  2006/12/05 EvolutionIǗl@[GM] тɂ http://l2je.ath.cx
 * @author  2010/07/23 JOJO  5802_Christmas/__init__.py  java ɏ
 */
public class ChristmasTree extends LongTimeEvent
{
	private static final boolean USE_GETEFFECTS = true;
	
	private static final String qn = "ChristmasTree";

	// NPCs
	private static final int SANTA_TRAINEE_A	= 31863;	//KT^()
	private static final int SANTA_TRAINEE_B	= 31864;	//KT^

	// ITEMs
	private static final int ITEM_STAR_ORNAMENT		= 5556;	//c[FX^[ x4
	private static final int ITEM_BEAD_ORNAMENT		= 5557;	//c[F{[ x4
	private static final int ITEM_FIR_TREE_BRANCH	= 5558;	//c[F}   x10
	private static final int ITEM_FLOWER_POT		= 5559;	//c[F     x1

	private static final int ITEM_CHRISTMAS_TREE			= 5560;	//NX}X c[
	private static final int ITEM_SPECIAL_CHRISTMAS_TREE	= 5561;	//NX}X c[

	private static class Reword
	{
		int chance;	// %
		int itemId;
		long quantity;
		
		Reword(int chance, int item, long qty)
		{
			this.chance = chance;
			this.itemId = item;
			this.quantity = qty;
		}
	}
	// OMAKE
	private static final Reword[] REWARDS1 = {
	/*	new Reword(chance%,item,qty)	*/
		new Reword( 10,  728, 10 ),	//  2,000A }i |[V
		new Reword( 10, 1539, 20 ),	//    900A ̗͉񕜍
		new Reword( 10, 6035, 10 ),	//  2,400A @rx|[V
		new Reword( 10, 1374,  8 ),	//  3,000A ړx|[V
		new Reword( 10,  735, 10 ),	//  2,400A Ux|[V
		new Reword( 10, 1540, 10 ),	// 10,000A uԑ̗͉񕜍
		new Reword( 10, 1375,  4 ),	//  6,000A Ux|[V
		new Reword( 10, 6036,  4 ),	//  6,000A @rx|[V
		new Reword( 99, 5234, 10 ),	// 10,000A ~XeAX |[V
	};
	private static final Reword[] REWARDS2 = {
	/*	new Reword(chance%,item,qty)	*/
		new Reword(  1, 6660,  1 ),	//   616,000A NC[Ag O
		new Reword(  2, 6662,  1 ),	//   870,000A RA O
		new Reword(  3,  959,  1 ),	// 5,000,000A 틭XN[FSO[h
		new Reword(  4,  729,  1 ),	// 1,800,000A 틭XN[FAO[h
		new Reword(  5,  947,  1 ),	//   500,000A 틭XN[FBO[h
		new Reword(  6,  960,  1 ),	//   500,000A hXN[FSO[h
		new Reword(  7,  730,  1 ),	//   240,000A hXN[FAO[h
		new Reword(  8,  951,  1 ),	//   110,000A 틭XN[FCO[h
		new Reword(  9,  948,  1 ),	//    80,000A hXN[FBO[h
		new Reword( 10,  955,  1 ),	//    50,000A 틭XN[FDO[h
		new Reword( 11,  952,  1 ),	//    15,000A hXN[FCO[h
		new Reword( 14,  956,  1 ),	//     6,000A hXN[FDO[h
		new Reword( 99, 1458,100 ),	//       650A NX^FDO[h
	};
	
	private static final int[] BUFFS =
	{
		SkillHashCode.valueOf(4262, 2), // NX}X EBh EH[N - 莞ԁAړxサԁB2
		SkillHashCode.valueOf(4263, 1), // NX}X wCXg - ꎞIɍUxサ܂B1
		SkillHashCode.valueOf(4264, 1), // NX}X Gp[ - ꎞIɖ͂サԁB1
		SkillHashCode.valueOf(4265, 3), // NX}X }Cg - ꎞIɍU͂サԁB3
		SkillHashCode.valueOf(4266, 3), // NX}X V[h - ꎞIɖh͂サԁB3
	};
	
	private void giveRandamReward(L2PcInstance player, Reword[] rewardTable)
	{
		int rnd = getRandom(100);
		for (Reword e : rewardTable)
		{
			if ((rnd -= e.chance) < 0)
			{
				giveItems(player, e.itemId, e.quantity);
				break;
			}
		}
	}
	
	private void handleCast(L2Npc npc, L2Character target, int skillHashCode)
	{
if (USE_GETEFFECTS) {{
		L2Skill skill = SkillHashCode.getSkill(skillHashCode);
		skill.getEffects(npc, target);
		npc.broadcastPacket(new MagicSkillUse(npc, target, skill.getId(), skill.getLevel(), 0, 0));
}} else {{
		npc.doCast(SkillHashCode.getSkill(skillHashCode));
}}
	}
	
	private ChristmasTree(String name, String descr)
	{
		super(name, descr);
		
		addStartNpc(SANTA_TRAINEE_A);
		addStartNpc(SANTA_TRAINEE_B);
		addFirstTalkId(SANTA_TRAINEE_A);
		addFirstTalkId(SANTA_TRAINEE_B);
		addTalkId(SANTA_TRAINEE_A);
		addTalkId(SANTA_TRAINEE_B);
		addSpawnId(SANTA_TRAINEE_A);
		addSpawnId(SANTA_TRAINEE_B);
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		alignRight(npc);
		return super.onSpawn(npc);
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		switch (npc.getNpcId())
		{
		case SANTA_TRAINEE_A: return "31863.htm";
		case SANTA_TRAINEE_B: return "31864.htm";
		}
		throw new AssertionError();
	}

	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		return "main.htm";
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = event;

		switch (event)
		{
			case "1":
				// iiƌ
				if (getQuestItemsCount(player, ITEM_STAR_ORNAMENT) >= 4
				 && getQuestItemsCount(player, ITEM_BEAD_ORNAMENT) >= 4
				 && getQuestItemsCount(player, ITEM_FIR_TREE_BRANCH) >= 10
				 && getQuestItemsCount(player, ITEM_FLOWER_POT) >= 1)
				{
					takeItems(player, ITEM_STAR_ORNAMENT,4);	//c[FX^[
					takeItems(player, ITEM_BEAD_ORNAMENT,4);	//c[F{[
					takeItems(player, ITEM_FIR_TREE_BRANCH,10);	//c[F}
					takeItems(player, ITEM_FLOWER_POT,1);		//c[F
					
					giveItems(player, ITEM_CHRISTMAS_TREE,1);	//NX}X c[
					giveRandamReward(player, REWARDS1);			//܂
					
					return "1OK.htm";
				}
				else
				{
					return "1NG.htm";
				}
				
			case "2":
				// iiƌ
				if (getQuestItemsCount(player, ITEM_CHRISTMAS_TREE) >= 10)
				{
					takeItems(player, ITEM_CHRISTMAS_TREE,10);
					
					giveItems(player, ITEM_SPECIAL_CHRISTMAS_TREE,1);	//NX}X c[
					giveRandamReward(player, REWARDS2);					//܂
					
					return "2OK.htm";
				}
				else
				{
					return "2NG.htm";
				}
				
			case "3":
				// iiƌ
				if (getQuestItemsCount(player, ITEM_CHRISTMAS_TREE) >= 10)
				{
					takeItems(player, ITEM_CHRISTMAS_TREE,10);
				//	giveItems(player, 5555,1);		//2004̏
				//	giveItems(player, 7836,1);		//T^Xq
					giveItems(player, 8936,1);		//T^̂Ƃ񂪂Xq
					return "3OK.htm";
				}
				else
				{
					return "3NG.htm";
				}
				
			case "0":
				// LZ
				htmltext = "Trade has been canceled.";
				break;
				
			case "SupportMagic":
				// ⏕@
				for (int skill : BUFFS)
					handleCast(npc, player, skill);
				break;
				
			default:
				if (!event.contains(".htm")) throw new RuntimeException("onAdvEvent(" + event + "," + STR(npc) + "," + STR(player) + ")");
		}
		
		return htmltext;
	}
	
	public static void main(String[] args)
	{
		new ChristmasTree(qn, "events");
	}
}