/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class TemplateAntTask
extends MatchingTask {
    protected String python;
    private File srcDir;
    protected boolean verbose = false;
    protected boolean lazy = false;

    public void setPython(String string) {
        this.python = string;
    }

    public void setSrcdir(String string) {
        this.srcDir = new File(this.getProject().replaceProperties(string));
    }

    public void setVerbose(String string) {
        this.verbose = new Boolean(this.getProject().replaceProperties(string));
    }

    public void setLazy(String string) {
        this.lazy = new Boolean(this.getProject().replaceProperties(string));
    }

    public void execute() {
        if (null == this.srcDir) {
            throw new BuildException("no srcdir specified");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir '" + this.srcDir + "' doesn't exist");
        }
        File file = new File(this.srcDir.getAbsolutePath() + File.separator + "gexpose.py");
        File file2 = new File(this.srcDir.getAbsolutePath() + File.separator + "gderived.py");
        if (!file.exists()) {
            throw new BuildException("no gexpose.py script found at: " + file);
        }
        if (!file2.exists()) {
            throw new BuildException("no gderive.py script found at: " + file2);
        }
        this.runPythonScript(file.getAbsolutePath());
        this.runPythonScript(file2.getAbsolutePath());
    }

    private void runPythonScript(String string) throws BuildException {
        if (null == this.python) {
            this.python = "python";
        }
        Execute execute = new Execute();
        execute.setWorkingDirectory(this.srcDir);
        String[] stringArray = this.lazy ? new String[]{this.python, string, "--lazy"} : new String[]{this.python, string};
        execute.setCommandline(stringArray);
        if (this.verbose) {
            String string2 = "";
            for (int i = 0; i < execute.getCommandline().length; ++i) {
                string2 = string2 + execute.getCommandline()[i] + " ";
            }
            this.log("executing: " + string2);
        }
        try {
            execute.execute();
        }
        catch (IOException iOException) {
            throw new BuildException(iOException.toString(), (Throwable)iOException);
        }
    }
}

