﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

opendir DIR,'.'  or die $!;
my @files = readdir DIR;
closedir DIR;

foreach my $fileName (@files) {
	next if $fileName =~ m!^\.!;
	next unless $fileName =~ m!\.html?$!;

	open FILE, '<:utf8', $fileName  or die "'$fileName' $!";
	read FILE, my $htm, -s FILE;
	my $mtime = (stat FILE)[9];
	close FILE;

	my $original = $htm;
	$_           = $htm;

#----------------------------------------------------------------------------
s{>Use Life Crystals</a>}
 {>生命のクリスタルを使用する</a>};	#▼

s{<center>Use Life Crystals</center>}
 {<center>生命のクリスタルを使用</center>};	#▼

s{>Craft Life Crystal\.?</a>}
 {>生命のクリスタルを組み合わせる</a>};	#▼

## Listen to an explanation about the new Life Crystals.
s{(?<=<a action="bypass -h npc_%objectId%_Link adventurer_guildsman/AboutNewLifeCrystals.htm">).*?(?=</a>)}
 {新しい生命のクリスタルについての説明を聞く}s;	#▼

## Exchange previous Life Crystals for new Life Crystals.
s{(?<=<a action="bypass -h npc_%objectId%_multisell 317325003">).*?(?=</a>)}
 {今までの生命のクリスタルを新しい生命のクリスタルと交換する}s;	#▼

## Craft Adventurer's Box.
s{(?<=<a action="bypass -h npc_%objectId%_multisell 317325002">).*?(?=</a>)}
 {冒険家の箱で組み合わせる}s;	#▼

## Ask about higher level crafting
s{(?<=<a action="bypass -h npc_%objectId%_Link adventurer_guildsman/AboutHighLevelGuilds.htm">).*?(?=</a>)}
 {より高いグレードの組合せについて聞く}s;	#▼

## "I want a weapon made from the Life Crystals."
s{(?<=<a action="bypass -h npc_%objectId%_multisell 320825001">).*?(?=</a>)}
 {武器を組み合わせる}s;	#〓〓

## "I want armor made from the Life Crystals."
s{(?<=<a action="bypass -h npc_%objectId%_multisell 320825002">).*?(?=</a>)}
 {防具を組み合わせる}s;	#〓〓

s!(?<=<a action="bypass -h npc_%objectId%_questlist">).*?(?=</a>)!クエスト情報!;
s!(?<=<a action="bypass -h npc_%objectId%_Quest RaidbossInfo">).*?(?=</a>)!レイド モンスター情報!;
s!>Quest<!>クエスト<!;
s!>Quest\.<!>クエスト<!;
#----------------------------------------------------------------------------
	$htm = $_;

	if ($htm ne $original) {
		print $fileName,"\n";
		my $output = $fileName;
		   $output = "$fileName.text" if $DEBUG;
		open FILE, '>:utf8', $output  or die "'$output' $!";
		$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
		print FILE $htm;
		close FILE;
		utime $mtime,$mtime,$output;
	}
}
