﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
s!>Buy pet equipment\.?<!>ペット用品を取引する。<!;

s!(?<=<a action="bypass -h npc_%objectId%_Link petmanager/instructions.htm">).+?(?=</a>)!ペットの育成について説明を聞く。!;
s!(?<=<a action="bypass -h npc_%objectId%_exc_multisell 1000">).+?(?=</a>)!ペット用装備を上級装備に交換する。!;
s!(?<=<a action="bypass -h npc_%objectId%_multisell 999">).+?(?=</a>)!ハッチリン用の装備とストライダー用の装備を交換する。!;
s!(?<=<a action="bypass -h npc_%objectId%_Link petmanager/evolve.htm">).+?(?=</a>)!ペットを進化させる。!;
s!(?<=<a action="bypass -h npc_%objectId%_Link petmanager/exchange.htm">).+?(?=</a>)!ペット交換券をペットに交換する。!;
s!(?<=<a action="bypass -h npc_%objectId%_TerritoryStatus">).+?(?=</a>)!領主、税率情報を見る。!;

s/>Quest</>クエスト</;
s/>Quest\.</>クエスト</;
#----------------------------------------------------------------------------
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
