/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers;

import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.L2Skill;

/**
 * @author UnAfraid
 * 
 * NPC          143     ̗͂̃g[e
 * |ACe    21899   ̗͂̃g[e
 * |XL  22294-1 ̗͂̃g[e
 * |BUFXL   23308-1 g[ẽGiW[F̗ - _Iȃg[e̗͂HP񕜃{[iX30%サ܂Bn`󂯂_[W80%܂Bg[e͈̔͂Oƌʂ͏܂B
 * NPC          144     _̃g[e
 * |ACe    21900   _̃g[e
 * |XL  22295-1 _̃g[e
 * |BUFXL   23309-1 g[ẽGiW[F_ - _Iȃg[e̗͂MP񕜃{[iX30%サ܂Bg[e͈̔͂Oƌʂ͏܂B
 * NPC          145     EC̃g[e
 * |ACe    21901   EC̃g[e
 * |XL  22296-1 EC̃g[e
 * |BUFXL   23310-1 g[ẽGiW[FEC - _Iȃg[e̗͂Ŗh͂15%サ܂Bg[e͈̔͂Oƌʂ͏܂B
 * NPC          146     s̃g[e
 * |ACe    21902   s̃g[e
 * |XL  22297-1 s̃g[e
 * |BUFXL   23311-1 g[ẽGiW[Fs - _Iȃg[e̗͂Ŗ@R͂25%サ܂Bg[e͈̔͂Oƌʂ͏܂B
 */
public class Totems extends AbstractNpcAI
{
	private static final int TOTEM_OF_BODY = 143;
	private static final int TOTEM_OF_SPIRIT = 144;
	private static final int TOTEM_OF_BRAVERY = 145;
	private static final int TOTEM_OF_FORTITUDE = 146;
	
	protected Totems(String name, String descr)
	{
		super(name, descr);
		addFirstTalkId(TOTEM_OF_BODY, TOTEM_OF_SPIRIT, TOTEM_OF_BRAVERY, TOTEM_OF_FORTITUDE);
		addSpawnId(TOTEM_OF_BODY, TOTEM_OF_SPIRIT, TOTEM_OF_BRAVERY, TOTEM_OF_FORTITUDE);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		addTask(npc);
		return super.onSpawn(npc);
	}
	
	private void addTask(L2Npc npc)
	{
		final L2Skill skill;
		switch (npc.getNpcId())
		{
			case TOTEM_OF_BODY:
			{
				skill = SkillTable.getInstance().getInfo(23308, 1);
				break;
			}
			case TOTEM_OF_SPIRIT:
			{
				skill = SkillTable.getInstance().getInfo(23309, 1);
				break;
			}
			case TOTEM_OF_BRAVERY:
			{
				skill = SkillTable.getInstance().getInfo(23310, 1);
				break;
			}
			case TOTEM_OF_FORTITUDE:
			{
				skill = SkillTable.getInstance().getInfo(23311, 1);
				break;
			}
			default:
			{
				return;
			}
		}
		
		if (skill == null /*|| skill.getSkillType() == L2SkillType.NOTDONE*/) return;
		new TotemAI(npc, skill);
	}
	
	protected class TotemAI implements Runnable
	{
		private final L2Npc _npc;
		private final L2Skill _skill;				//+[JOJO]
		private final ScheduledFuture<?> _aiTask;	//+[JOJO]
		
		protected TotemAI(L2Npc npc, L2Skill skill)
		{
			_npc = npc;
			_skill = skill;
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 1000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			
			L2Skill skill = _skill;
			final int skillRadius = skill.getAffectRange();
			for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
			{
				if (!player.isInsideRadius(_npc, skillRadius, true, true))
					continue;
				if (player.getFirstEffect(skill.getId()) == null)
				{
					skill.getEffects(player, player);
				}
			}
		}
	}
	
	public static void main(String[] args)
	{
		new Totems(Totems.class.getSimpleName(), "ai/npc");
	}
}
