## Active Perl 5.16

## NpcBuffersData.xml 中のNPC名とスキル名を日本語コメントする

use utf8;
use strict;
use warnings;
use Encode;
use DBI;
#use Jcode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $vars_txt = 'tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^\@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('build/dist/game/data/scripts/ai/npc/NpcBuffers/NpcBuffersData.xml');

close LOG;
exit 0;

sub start {
	my ($filePath) = @_;

	my $outPath = $filePath;
	   $outPath .= '.text' if $DEBUG;

	print "  $filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $backup = $text;
	my @T = split m/(?<=[\n])/, $text;
	for (my $ii = 0; $ii <=$#T; ++$ii) {
		if ($T[$ii] =~ m/^[\t ]*<npc id="(\d+)"/) {
			my $id = $1;
			my $type = getNpcType($id);
			my $name = getNpcName($id);
			if ($name or $type) {
				   $T[$ii] =~ s/<!--.*-->$/<!-- $type $name -->/
				or $T[$ii] =~ s/$/ <!-- $type $name -->/;
			}
		}
		elsif ($T[$ii] =~ m/^[\t ]*<skill id="(\d+)" level="(\d+)"/) {
			my $id = $1;
			my $level = $2;
			my $name = getSkillName($id,$level);
			if ($name) {
				   $T[$ii] =~ s/<!--.*-->$/<!-- $name -->/
				or $T[$ii] =~ s/$/ <!-- $name -->/;
			}
		}
	}
	$text = join '',@T;

	if ($backup ne $text) {
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub getNpcName {
	my ($id) = @_;

	my $sql = "SELECT name,title FROM npcname_ja WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name,$N_title))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_name;
	if ($N_title) {
		# タイトルと名前をくっつける #
		if ($N_title =~ m/[\x{30A1}-\x{30ff}]$/
		 && $N_name =~ m/^[\x{30A1}-\x{30ff}]/) {
			#カタカナ+カタカナ連続するときは、空白入れる
		 	return $N_title.' '.$N_name;
		} elsif ($N_title =~ m/ /
		      || $N_name  =~ m/ /) {
			#タイトルか名前に空白ありのときは、空白入れる
		 	return $N_title.' '.$N_name;
		} else {
		 	return $N_title.$N_name;
		}
	}
	return $N_name;
}

sub getNpcType {
	my ($id) = @_;

	my $sql = "SELECT `type` FROM npc WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_type))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_type;
	return $N_type;
}

sub getSkillName {
	my ($id,$level) = @_;

	my $sth;
	if ($level) {
		my $sql = "SELECT name FROM skillname_ja WHERE id=? AND level=?";
		$sth = $db->prepare($sql);
		$sth->execute($id,$level) or die DBI::errstr;
	} else {
		my $sql = "SELECT name FROM skillname_ja WHERE id=? LIMIT 0,1";
		$sth = $db->prepare($sql);
		$sth->execute($id) or die DBI::errstr;
	}

	$sth->bind_columns(undef, \(my($N_name))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return '' unless $N_name;
#	return Encode::decode_utf8(Jcode->new($N_name, 'utf8')->z2h->utf8)
	return $N_name;
}
