﻿## Active Perl 5.8.8

use utf8;
use warnings;
use strict;
use Encode;
binmode STDOUT, ':encoding(cp932)'; $|=1;

my $DEBUG = 0;

&start('./');
exit 0;

sub start {
	my ($subDir) = @_;

	opendir DIR,$subDir  or die $!;
	my @files = readdir DIR;
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;
		next unless $fileName =~ m!\.html?$!;

		my $filePath = $subDir.$fileName;
		open FILE, '<:utf8', $filePath  or die "'$filePath' $!";
		read FILE, my $htm, -s FILE;
		my $mtime = (stat FILE)[9];
		close FILE;

		my $original = $htm;
		$_           = $htm;
#----------------------------------------------------------------------------
s!(?<=<a action="bypass -h npc_%objectId%_SkillList">).+?(?=</a>)!スキルを習う!;	#Learn skills
s!(?<=<a action="bypass -h Quest HealerTrainer SkillTransfer">).+?(?=</a>)!スキル リンクのことを聞く!;			#Ask about Skill Transfer
s!(?<=<a action="bypass -h npc_%objectId%_Link common/skill_enchant_help.htm">).+?(?=</a>)!スキル エンチャントのことを聞く!;	#Ask about Skill Enchanting
s!(?<=<a action="bypass -h npc_%objectId%_Quest">).+?(?=</a>)!クエスト!;
#----------------------------------------------------------------------------
		$htm = $_;

		if ($htm ne $original) {
			print $filePath,"\n";
			my $output = $filePath;
			   $output = $filePath.'.text' if $DEBUG;
			open FILE, '>:utf8', $output  or die "'$output' $!";
			$htm = "\x{feff}".$htm unless $htm =~ m/^\x{feff}/;  #BOM
			print FILE $htm;
			close FILE;
			utime $mtime,$mtime,$output;
		}
	}
}
